/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.compiler.IProblem;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemReporter;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class CompilationUnitDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    public ImportReference currentPackage;
    public ImportReference[] imports;
    public TypeDeclaration[] types;
    public int[][] comments;
    public boolean ignoreFurtherInvestigation = false;
    public boolean ignoreMethodBodies = false;
    public CompilationUnitScope scope;
    public ProblemReporter problemReporter;
    public CompilationResult compilationResult;
    public LocalTypeBinding[] localTypes;
    public int localTypeCount = 0;
    public boolean isPropagatingInnerClassEmulation;
    public Javadoc javadoc;

    public CompilationUnitDeclaration(ProblemReporter problemReporter, CompilationResult compilationResult, int sourceLength) {
        this.problemReporter = problemReporter;
        this.compilationResult = compilationResult;
        this.sourceStart = 0;
        this.sourceEnd = sourceLength - 1;
    }

    public void abort(int abortLevel, IProblem problem) {
        switch (abortLevel) {
            case 8: {
                throw new AbortType(this.compilationResult, problem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, problem);
            }
        }
        throw new AbortCompilationUnit(this.compilationResult, problem);
    }

    public void analyseCode() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (this.types != null) {
                int i = 0;
                int count = this.types.length;
                while (i < count) {
                    this.types[i].analyseCode(this.scope);
                    ++i;
                }
            }
            this.propagateInnerEmulationForAllLocalTypes();
        }
        catch (AbortCompilationUnit e) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void cleanUp() {
        if (this.types != null) {
            int i = 0;
            int max = this.types.length;
            while (i < max) {
                this.cleanUp(this.types[i]);
                ++i;
            }
            i = 0;
            max = this.localTypeCount;
            while (i < max) {
                LocalTypeBinding localType = this.localTypes[i];
                localType.scope = null;
                localType.enclosingCase = null;
                ++i;
            }
        }
        ClassFile[] classFiles = this.compilationResult.getClassFiles();
        int i = 0;
        int max = classFiles.length;
        while (i < max) {
            ClassFile classFile = classFiles[i];
            classFile.referenceBinding = null;
            classFile.codeStream = null;
            classFile.innerClassesBindings = null;
            ++i;
        }
    }

    private void cleanUp(TypeDeclaration type) {
        if (type.memberTypes != null) {
            int i = 0;
            int max = type.memberTypes.length;
            while (i < max) {
                this.cleanUp(type.memberTypes[i]);
                ++i;
            }
        }
        if (type.binding != null) {
            type.binding.scope = null;
        }
    }

    public void checkUnusedImports() {
        if (this.scope.imports != null) {
            int i = 0;
            int max = this.scope.imports.length;
            while (i < max) {
                ImportBinding importBinding = this.scope.imports[i];
                ImportReference importReference = importBinding.reference;
                if (importReference != null && !importReference.used) {
                    this.scope.problemReporter().unusedImport(importReference);
                }
                ++i;
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public TypeDeclaration declarationOfType(char[][] typeName) {
        int i = 0;
        while (i < this.types.length) {
            TypeDeclaration typeDecl = this.types[i].declarationOfType(typeName);
            if (typeDecl != null) {
                return typeDecl;
            }
            ++i;
        }
        return null;
    }

    public void generateCode() {
        if (this.ignoreFurtherInvestigation) {
            if (this.types != null) {
                int i = 0;
                int count = this.types.length;
                while (i < count) {
                    this.types[i].ignoreFurtherInvestigation = true;
                    this.types[i].generateCode(this.scope);
                    ++i;
                }
            }
            return;
        }
        if (this.isPackageInfo() && this.types != null && this.currentPackage.annotations != null) {
            this.types[0].annotations = this.currentPackage.annotations;
        }
        try {
            if (this.types != null) {
                int i = 0;
                int count = this.types.length;
                while (i < count) {
                    this.types[i].generateCode(this.scope);
                    ++i;
                }
            }
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            // empty catch block
        }
    }

    public char[] getFileName() {
        return this.compilationResult.getFileName();
    }

    public char[] getMainTypeName() {
        if (this.compilationResult.compilationUnit == null) {
            int end;
            char[] fileName = this.compilationResult.getFileName();
            int start = CharOperation.lastIndexOf('/', fileName) + 1;
            if (start == 0 || start < CharOperation.lastIndexOf('\\', fileName)) {
                start = CharOperation.lastIndexOf('\\', fileName) + 1;
            }
            if ((end = CharOperation.lastIndexOf('.', fileName)) == -1) {
                end = fileName.length;
            }
            return CharOperation.subarray(fileName, start, end);
        }
        return this.compilationResult.compilationUnit.getMainTypeName();
    }

    public boolean isEmpty() {
        return this.currentPackage == null && this.imports == null && this.types == null;
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.getMainTypeName(), TypeConstants.PACKAGE_INFO_NAME) && this.currentPackage != null && (this.currentPackage.annotations != null || this.javadoc != null);
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        int i;
        if (this.currentPackage != null) {
            ASTNode.printIndent(indent, output).append("package ");
            this.currentPackage.print(0, output, false).append(";\n");
        }
        if (this.imports != null) {
            i = 0;
            while (i < this.imports.length) {
                ASTNode.printIndent(indent, output).append("import ");
                this.imports[i].print(0, output).append(";\n");
                ++i;
            }
        }
        if (this.types != null) {
            i = 0;
            while (i < this.types.length) {
                this.types[i].print(indent, output).append("\n");
                ++i;
            }
        }
        return output;
    }

    public void propagateInnerEmulationForAllLocalTypes() {
        this.isPropagatingInnerClassEmulation = true;
        int i = 0;
        int max = this.localTypeCount;
        while (i < max) {
            LocalTypeBinding localType = this.localTypes[i];
            if ((localType.scope.referenceType().bits & Integer.MIN_VALUE) != 0) {
                localType.updateInnerEmulationDependents();
            }
            ++i;
        }
    }

    public void record(LocalTypeBinding localType) {
        if (this.localTypeCount == 0) {
            this.localTypes = new LocalTypeBinding[5];
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new LocalTypeBinding[this.localTypeCount * 2];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        this.localTypes[this.localTypeCount++] = localType;
    }

    public void resolve() {
        int startingTypeIndex = 0;
        boolean isPackageInfo = this.isPackageInfo();
        if (this.types != null && isPackageInfo) {
            TypeDeclaration syntheticTypeDeclaration = this.types[0];
            syntheticTypeDeclaration.javadoc = new Javadoc(syntheticTypeDeclaration.declarationSourceStart, syntheticTypeDeclaration.declarationSourceStart);
            syntheticTypeDeclaration.resolve(this.scope);
            if (this.currentPackage.annotations != null) {
                ASTNode.resolveAnnotations(syntheticTypeDeclaration.staticInitializerScope, this.currentPackage.annotations, this.scope.fPackage);
            }
            if (this.javadoc != null) {
                this.javadoc.resolve(syntheticTypeDeclaration.staticInitializerScope);
            }
            startingTypeIndex = 1;
        }
        if (this.currentPackage != null && this.currentPackage.annotations != null && !isPackageInfo) {
            this.scope.problemReporter().invalidFileNameForPackageAnnotations(this.currentPackage.annotations[0]);
        }
        try {
            if (this.types != null) {
                int i = startingTypeIndex;
                int count = this.types.length;
                while (i < count) {
                    this.types[i].resolve(this.scope);
                    ++i;
                }
            }
            if (!this.compilationResult.hasErrors()) {
                this.checkUnusedImports();
            }
        }
        catch (AbortCompilationUnit e) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (visitor.visit(this, this.scope)) {
                int i;
                if (this.currentPackage != null) {
                    this.currentPackage.traverse(visitor, this.scope);
                }
                if (this.imports != null) {
                    int importLength = this.imports.length;
                    i = 0;
                    while (i < importLength) {
                        this.imports[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.types != null) {
                    int typesLength = this.types.length;
                    i = 0;
                    while (i < typesLength) {
                        this.types[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
            }
            visitor.endVisit(this, this.scope);
        }
        catch (AbortCompilationUnit abortCompilationUnit) {
            // empty catch block
        }
    }
}

