/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.AdviceSignature;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.FieldSignature;
import org.aspectj.lang.reflect.MethodSignature;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NewFieldTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.VersionedDataInputStream;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.patterns.AnnotationTypePattern;
import org.aspectj.weaver.patterns.AnyAnnotationTypePattern;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.ModifiersPattern;
import org.aspectj.weaver.patterns.NamePattern;
import org.aspectj.weaver.patterns.PatternNode;
import org.aspectj.weaver.patterns.ThrowsPattern;
import org.aspectj.weaver.patterns.TypePattern;
import org.aspectj.weaver.patterns.TypePatternList;

public class SignaturePattern
extends PatternNode {
    private Member.Kind kind;
    private ModifiersPattern modifiers;
    private TypePattern returnType;
    private TypePattern declaringType;
    private NamePattern name;
    private TypePatternList parameterTypes;
    private ThrowsPattern throwsPattern;
    private AnnotationTypePattern annotationPattern;

    public SignaturePattern(Member.Kind kind, ModifiersPattern modifiers, TypePattern returnType, TypePattern declaringType, NamePattern name, TypePatternList parameterTypes, ThrowsPattern throwsPattern, AnnotationTypePattern annotationPattern) {
        this.kind = kind;
        this.modifiers = modifiers;
        this.returnType = returnType;
        this.name = name;
        this.declaringType = declaringType;
        this.parameterTypes = parameterTypes;
        this.throwsPattern = throwsPattern;
        this.annotationPattern = annotationPattern;
    }

    public SignaturePattern resolveBindings(IScope scope, Bindings bindings) {
        if (this.returnType != null) {
            this.returnType = this.returnType.resolveBindings(scope, bindings, false, false);
        }
        if (this.declaringType != null) {
            this.declaringType = this.declaringType.resolveBindings(scope, bindings, false, false);
        }
        if (this.parameterTypes != null) {
            this.parameterTypes = this.parameterTypes.resolveBindings(scope, bindings, false, false);
        }
        if (this.throwsPattern != null) {
            this.throwsPattern = this.throwsPattern.resolveBindings(scope, bindings);
        }
        if (this.annotationPattern != null) {
            this.annotationPattern = this.annotationPattern.resolveBindings(scope, bindings, false);
        }
        return this;
    }

    public SignaturePattern resolveBindingsFromRTTI() {
        if (this.returnType != null) {
            this.returnType = this.returnType.resolveBindingsFromRTTI(false, false);
        }
        if (this.declaringType != null) {
            this.declaringType = this.declaringType.resolveBindingsFromRTTI(false, false);
        }
        if (this.parameterTypes != null) {
            this.parameterTypes = this.parameterTypes.resolveBindingsFromRTTI(false, false);
        }
        if (this.throwsPattern != null) {
            this.throwsPattern = this.throwsPattern.resolveBindingsFromRTTI();
        }
        return this;
    }

    public void postRead(ResolvedTypeX enclosingType) {
        if (this.returnType != null) {
            this.returnType.postRead(enclosingType);
        }
        if (this.declaringType != null) {
            this.declaringType.postRead(enclosingType);
        }
        if (this.parameterTypes != null) {
            this.parameterTypes.postRead(enclosingType);
        }
    }

    public boolean matches(Member member, World world) {
        return this.matchesIgnoringAnnotations(member, world) && this.matchesAnnotations(member, world);
    }

    public boolean matchesAnnotations(Member member, World world) {
        ResolvedMember rMember = member.resolve(world);
        if (rMember == null) {
            if (member.getName().startsWith("ajc$")) {
                return false;
            }
            world.getLint().unresolvableMember.signal(member.toString(), this.getSourceLocation());
            return false;
        }
        this.annotationPattern.resolve(world);
        if (this.annotationPattern instanceof AnyAnnotationTypePattern) {
            return true;
        }
        if (rMember.isAnnotatedElsewhere() && member.getKind() == Member.FIELD) {
            ResolvedMember[] mems = rMember.getDeclaringType().resolve(world).getDeclaredFields();
            List mungers = rMember.getDeclaringType().resolve(world).getInterTypeMungers();
            Iterator iter = mungers.iterator();
            while (iter.hasNext()) {
                BcelTypeMunger typeMunger = (BcelTypeMunger)iter.next();
                if (!(typeMunger.getMunger() instanceof NewFieldTypeMunger)) continue;
                ResolvedMember fakerm = typeMunger.getSignature();
                ResolvedMember ajcMethod = AjcMemberMaker.interFieldInitializer(fakerm, typeMunger.getAspectType());
                ResolvedMember rmm = this.findMethod(typeMunger.getAspectType(), ajcMethod);
                if (!fakerm.equals(member)) continue;
                rMember = rmm;
            }
        }
        return this.annotationPattern.matches(rMember).alwaysTrue();
    }

    private ResolvedMember findMethod(ResolvedTypeX aspectType, ResolvedMember ajcMethod) {
        ResolvedMember[] decMethods = aspectType.getDeclaredMethods();
        for (int i = 0; i < decMethods.length; ++i) {
            ResolvedMember member = decMethods[i];
            if (!member.equals(ajcMethod)) continue;
            return member;
        }
        return null;
    }

    public boolean matchesIgnoringAnnotations(Member member, World world) {
        if (member == null) {
            return false;
        }
        ResolvedMember sig = member.resolve(world);
        if (sig == null) {
            if (member.getName().startsWith("ajc$")) {
                return false;
            }
            world.getLint().unresolvableMember.signal(member.toString(), this.getSourceLocation());
            return false;
        }
        if (sig.isBridgeMethod()) {
            return false;
        }
        if (this.kind != member.getKind()) {
            return false;
        }
        if (this.kind == Member.ADVICE) {
            return true;
        }
        if (!this.modifiers.matches(sig.getModifiers())) {
            return false;
        }
        if (this.kind == Member.STATIC_INITIALIZATION) {
            return this.declaringType.matchesStatically(sig.getDeclaringType().resolve(world));
        }
        if (this.kind == Member.FIELD) {
            if (!this.returnType.matchesStatically(sig.getReturnType().resolve(world))) {
                return false;
            }
            if (!this.name.matches(sig.getName())) {
                return false;
            }
            boolean ret = this.declaringTypeMatch(member.getDeclaringType(), member, world);
            return ret;
        }
        if (this.kind == Member.METHOD) {
            if (!this.name.matches(sig.getName())) {
                return false;
            }
            if (!this.parameterTypes.matches(world.resolve(sig.getParameterTypes()), TypePattern.STATIC).alwaysTrue()) {
                return false;
            }
            if (this.isNotMatchBecauseOfVarargsIssue(this.parameterTypes, sig.getModifiers())) {
                world.getLint().cantMatchArrayTypeOnVarargs.signal(sig.toString(), this.getSourceLocation());
                return false;
            }
            if (this.parameterTypes.size() > 0 && sig.isVarargsMethod() ^ this.parameterTypes.get((int)(this.parameterTypes.size() - 1)).isVarArgs) {
                return false;
            }
            if (!this.throwsPattern.matches(sig.getExceptions(), world)) {
                return false;
            }
            return this.declaringTypeMatchAllowingForCovariance(member, world, this.returnType, sig.getReturnType().resolve(world));
        }
        if (this.kind == Member.CONSTRUCTOR) {
            if (!this.parameterTypes.matches(world.resolve(sig.getParameterTypes()), TypePattern.STATIC).alwaysTrue()) {
                return false;
            }
            if (this.isNotMatchBecauseOfVarargsIssue(this.parameterTypes, sig.getModifiers())) {
                world.getLint().cantMatchArrayTypeOnVarargs.signal(sig.toString(), this.getSourceLocation());
                return false;
            }
            if (!this.throwsPattern.matches(sig.getExceptions(), world)) {
                return false;
            }
            return this.declaringType.matchesStatically(member.getDeclaringType().resolve(world));
        }
        return false;
    }

    public boolean declaringTypeMatchAllowingForCovariance(Member member, World world, TypePattern returnTypePattern, ResolvedTypeX sigReturn) {
        TypeX onTypeUnresolved = member.getDeclaringType();
        ResolvedTypeX onType = onTypeUnresolved.resolve(world);
        if (this.declaringType.matchesStatically(onType) && returnTypePattern.matchesStatically(sigReturn)) {
            return true;
        }
        Collection declaringTypes = member.getDeclaringTypes(world);
        boolean checkReturnType = true;
        Iterator i = declaringTypes.iterator();
        while (i.hasNext()) {
            TypeX returnTypeX;
            ResolvedTypeX returnType;
            ResolvedTypeX type = (ResolvedTypeX)i.next();
            if (!this.declaringType.matchesStatically(type)) continue;
            if (!checkReturnType) {
                return true;
            }
            ResolvedMember rm = type.lookupMethod(member);
            if (rm == null) {
                rm = type.lookupMethodInITDs(member);
            }
            if (!returnTypePattern.matchesStatically(returnType = (returnTypeX = rm.getReturnType()).resolve(world))) continue;
            return true;
        }
        return false;
    }

    public boolean matches(JoinPoint.StaticPart jpsp) {
        Signature sig = jpsp.getSignature();
        if (this.kind == Member.ADVICE && !(sig instanceof AdviceSignature)) {
            return false;
        }
        if (this.kind == Member.CONSTRUCTOR && !(sig instanceof ConstructorSignature)) {
            return false;
        }
        if (this.kind == Member.FIELD && !(sig instanceof FieldSignature)) {
            return false;
        }
        if (this.kind == Member.METHOD && !(sig instanceof MethodSignature)) {
            return false;
        }
        if (this.kind == Member.STATIC_INITIALIZATION && !jpsp.getKind().equals("staticinitialization")) {
            return false;
        }
        if (this.kind == Member.POINTCUT) {
            return false;
        }
        if (this.kind == Member.ADVICE) {
            return true;
        }
        if (!this.modifiers.matches(sig.getModifiers())) {
            return false;
        }
        if (this.kind == Member.STATIC_INITIALIZATION) {
            return this.declaringType.matchesStatically(sig.getDeclaringType());
        }
        if (this.kind == Member.FIELD) {
            Class returnTypeClass = ((FieldSignature)sig).getFieldType();
            if (!this.returnType.matchesStatically(returnTypeClass)) {
                return false;
            }
            if (!this.name.matches(sig.getName())) {
                return false;
            }
            boolean ret = this.declaringTypeMatch(sig);
            return ret;
        }
        if (this.kind == Member.METHOD) {
            MethodSignature msig = (MethodSignature)sig;
            Class returnTypeClass = msig.getReturnType();
            Class[] params = msig.getParameterTypes();
            Class[] exceptionTypes = msig.getExceptionTypes();
            if (!this.returnType.matchesStatically(returnTypeClass)) {
                return false;
            }
            if (!this.name.matches(sig.getName())) {
                return false;
            }
            if (!this.parameterTypes.matches(params, TypePattern.STATIC).alwaysTrue()) {
                return false;
            }
            if (this.isNotMatchBecauseOfVarargsIssue(this.parameterTypes, msig.getModifiers())) {
                return false;
            }
            if (!this.throwsPattern.matches(exceptionTypes)) {
                return false;
            }
            return this.declaringTypeMatch(sig);
        }
        if (this.kind == Member.CONSTRUCTOR) {
            ConstructorSignature csig = (ConstructorSignature)sig;
            Class[] params = csig.getParameterTypes();
            Class[] exceptionTypes = csig.getExceptionTypes();
            if (!this.parameterTypes.matches(params, TypePattern.STATIC).alwaysTrue()) {
                return false;
            }
            if (this.isNotMatchBecauseOfVarargsIssue(this.parameterTypes, csig.getModifiers())) {
                return false;
            }
            if (!this.throwsPattern.matches(exceptionTypes)) {
                return false;
            }
            return this.declaringType.matchesStatically(sig.getDeclaringType());
        }
        return false;
    }

    public boolean matches(Class declaringClass, java.lang.reflect.Member member) {
        if (this.kind == Member.ADVICE) {
            return true;
        }
        if (this.kind == Member.POINTCUT) {
            return false;
        }
        if (member != null && !this.modifiers.matches(member.getModifiers())) {
            return false;
        }
        if (this.kind == Member.STATIC_INITIALIZATION) {
            return this.declaringType.matchesStatically(declaringClass);
        }
        if (this.kind == Member.FIELD) {
            if (!(member instanceof Field)) {
                return false;
            }
            Class<?> fieldTypeClass = ((Field)member).getType();
            if (!this.returnType.matchesStatically(fieldTypeClass)) {
                return false;
            }
            if (!this.name.matches(member.getName())) {
                return false;
            }
            return this.declaringTypeMatch(member.getDeclaringClass());
        }
        if (this.kind == Member.METHOD) {
            if (!(member instanceof Method)) {
                return false;
            }
            Class<?> returnTypeClass = ((Method)member).getReturnType();
            Class[] params = ((Method)member).getParameterTypes();
            Class[] exceptionTypes = ((Method)member).getExceptionTypes();
            if (!this.returnType.matchesStatically(returnTypeClass)) {
                return false;
            }
            if (!this.name.matches(member.getName())) {
                return false;
            }
            if (!this.parameterTypes.matches(params, TypePattern.STATIC).alwaysTrue()) {
                return false;
            }
            if (this.isNotMatchBecauseOfVarargsIssue(this.parameterTypes, member.getModifiers())) {
                return false;
            }
            if (!this.throwsPattern.matches(exceptionTypes)) {
                return false;
            }
            return this.declaringTypeMatch(member.getDeclaringClass());
        }
        if (this.kind == Member.CONSTRUCTOR) {
            if (!(member instanceof Constructor)) {
                return false;
            }
            Class[] params = ((Constructor)member).getParameterTypes();
            Class[] exceptionTypes = ((Constructor)member).getExceptionTypes();
            if (!this.parameterTypes.matches(params, TypePattern.STATIC).alwaysTrue()) {
                return false;
            }
            if (this.isNotMatchBecauseOfVarargsIssue(this.parameterTypes, member.getModifiers())) {
                return false;
            }
            if (!this.throwsPattern.matches(exceptionTypes)) {
                return false;
            }
            return this.declaringType.matchesStatically(declaringClass);
        }
        return false;
    }

    private boolean declaringTypeMatch(TypeX onTypeUnresolved, Member member, World world) {
        ResolvedTypeX onType = onTypeUnresolved.resolve(world);
        if (this.declaringType.matchesStatically(onType)) {
            return true;
        }
        Collection declaringTypes = member.getDeclaringTypes(world);
        Iterator i = declaringTypes.iterator();
        while (i.hasNext()) {
            ResolvedTypeX type = (ResolvedTypeX)i.next();
            if (!this.declaringType.matchesStatically(type)) continue;
            return true;
        }
        return false;
    }

    private boolean declaringTypeMatch(Signature sig) {
        Class onType = sig.getDeclaringType();
        if (this.declaringType.matchesStatically(onType)) {
            return true;
        }
        Collection declaringTypes = this.getDeclaringTypes(sig);
        Iterator it = declaringTypes.iterator();
        while (it.hasNext()) {
            Class pClass = (Class)it.next();
            if (!this.declaringType.matchesStatically(pClass)) continue;
            return true;
        }
        return false;
    }

    private boolean declaringTypeMatch(Class clazz) {
        if (clazz == null) {
            return false;
        }
        if (this.declaringType.matchesStatically(clazz)) {
            return true;
        }
        Class<?>[] ifs = clazz.getInterfaces();
        for (int i = 0; i < ifs.length; ++i) {
            if (!this.declaringType.matchesStatically(ifs[i])) continue;
            return true;
        }
        return this.declaringTypeMatch(clazz.getSuperclass());
    }

    private Collection getDeclaringTypes(Signature sig) {
        ArrayList l;
        block7: {
            String memberName;
            block6: {
                l = new ArrayList();
                Class onType = sig.getDeclaringType();
                memberName = sig.getName();
                if (!(sig instanceof FieldSignature)) break block6;
                Class fieldType = ((FieldSignature)sig).getFieldType();
                for (Class superType = onType; superType != null; superType = superType.getSuperclass()) {
                    try {
                        Field f = superType.getDeclaredField(memberName);
                        if (f.getType() != fieldType) continue;
                        l.add(superType);
                        continue;
                    }
                    catch (NoSuchFieldException nsf) {
                        // empty catch block
                    }
                }
                break block7;
            }
            if (!(sig instanceof MethodSignature)) break block7;
            Class[] paramTypes = ((MethodSignature)sig).getParameterTypes();
            for (Class superType = onType; superType != null; superType = superType.getSuperclass()) {
                try {
                    Method m = superType.getDeclaredMethod(memberName, paramTypes);
                    l.add(superType);
                    continue;
                }
                catch (NoSuchMethodException nsm) {
                    // empty catch block
                }
            }
        }
        return l;
    }

    public NamePattern getName() {
        return this.name;
    }

    public TypePattern getDeclaringType() {
        return this.declaringType;
    }

    public Member.Kind getKind() {
        return this.kind;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.annotationPattern != AnnotationTypePattern.ANY) {
            buf.append(this.annotationPattern.toString());
            buf.append(' ');
        }
        if (this.modifiers != ModifiersPattern.ANY) {
            buf.append(this.modifiers.toString());
            buf.append(' ');
        }
        if (this.kind == Member.STATIC_INITIALIZATION) {
            buf.append(this.declaringType.toString());
            buf.append(".<clinit>()");
        } else if (this.kind == Member.HANDLER) {
            buf.append("handler(");
            buf.append(this.parameterTypes.get(0));
            buf.append(")");
        } else {
            if (this.kind != Member.CONSTRUCTOR) {
                buf.append(this.returnType.toString());
                buf.append(' ');
            }
            if (this.declaringType != TypePattern.ANY) {
                buf.append(this.declaringType.toString());
                buf.append('.');
            }
            if (this.kind == Member.CONSTRUCTOR) {
                buf.append("new");
            } else {
                buf.append(this.name.toString());
            }
            if (this.kind == Member.METHOD || this.kind == Member.CONSTRUCTOR) {
                buf.append(this.parameterTypes.toString());
            }
        }
        return buf.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof SignaturePattern)) {
            return false;
        }
        SignaturePattern o = (SignaturePattern)other;
        return o.kind.equals(this.kind) && o.modifiers.equals(this.modifiers) && o.returnType.equals(this.returnType) && o.declaringType.equals(this.declaringType) && o.name.equals(this.name) && o.parameterTypes.equals(this.parameterTypes) && o.throwsPattern.equals(this.throwsPattern) && o.annotationPattern.equals(this.annotationPattern);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.kind.hashCode();
        result = 37 * result + this.modifiers.hashCode();
        result = 37 * result + this.returnType.hashCode();
        result = 37 * result + this.declaringType.hashCode();
        result = 37 * result + this.name.hashCode();
        result = 37 * result + this.parameterTypes.hashCode();
        result = 37 * result + this.throwsPattern.hashCode();
        result = 37 * result + this.annotationPattern.hashCode();
        return result;
    }

    public void write(DataOutputStream s) throws IOException {
        this.kind.write(s);
        this.modifiers.write(s);
        this.returnType.write(s);
        this.declaringType.write(s);
        this.name.write(s);
        this.parameterTypes.write(s);
        this.throwsPattern.write(s);
        this.annotationPattern.write(s);
        this.writeLocation(s);
    }

    public static SignaturePattern read(VersionedDataInputStream s, ISourceContext context) throws IOException {
        Member.Kind kind = Member.Kind.read(s);
        ModifiersPattern modifiers = ModifiersPattern.read(s);
        TypePattern returnType = TypePattern.read(s, context);
        TypePattern declaringType = TypePattern.read(s, context);
        NamePattern name = NamePattern.read(s);
        TypePatternList parameterTypes = TypePatternList.read(s, context);
        ThrowsPattern throwsPattern = ThrowsPattern.read(s, context);
        AnnotationTypePattern annotationPattern = AnnotationTypePattern.ANY;
        if (s.getMajorVersion() >= AjAttribute.WeaverVersionInfo.WEAVER_VERSION_MAJOR_AJ150) {
            annotationPattern = AnnotationTypePattern.read(s, context);
        }
        SignaturePattern ret = new SignaturePattern(kind, modifiers, returnType, declaringType, name, parameterTypes, throwsPattern, annotationPattern);
        ret.readLocation(context, s);
        return ret;
    }

    public ModifiersPattern getModifiers() {
        return this.modifiers;
    }

    public TypePatternList getParameterTypes() {
        return this.parameterTypes;
    }

    public TypePattern getReturnType() {
        return this.returnType;
    }

    public ThrowsPattern getThrowsPattern() {
        return this.throwsPattern;
    }

    private boolean isNotMatchBecauseOfVarargsIssue(TypePatternList params, int modifiers) {
        TypePattern lastPattern;
        return params.size() > 0 && (modifiers & 0x80) != 0 && (lastPattern = params.get(params.size() - 1)).isArray() && !lastPattern.isVarArgs;
    }

    public AnnotationTypePattern getAnnotationPattern() {
        return this.annotationPattern;
    }

    public boolean isStarAnnotation() {
        return this.annotationPattern == AnnotationTypePattern.ANY;
    }
}

