/*
 * Decompiled with CFR 0.152.
 */
package com.arbortext.catalog;

import com.arbortext.catalog.InvalidCatalogEntryException;
import com.arbortext.catalog.InvalidCatalogEntryTypeException;

public class CatalogEntry {
    public static final int BASE = 1;
    public static final int CATALOG = 2;
    public static final int DOCUMENT = 3;
    public static final int OVERRIDE = 4;
    public static final int SGMLDECL = 5;
    public static final int DELEGATE = 6;
    public static final int DOCTYPE = 7;
    public static final int DTDDECL = 8;
    public static final int ENTITY = 9;
    public static final int LINKTYPE = 10;
    public static final int NOTATION = 11;
    public static final int PUBLIC = 12;
    public static final int SYSTEM = 13;
    private int entryType = 0;
    private String spec1 = "";
    private String spec2 = "";

    public CatalogEntry(int type, String spec) throws InvalidCatalogEntryTypeException, InvalidCatalogEntryException {
        if (type < 1 || type > 13) {
            throw new InvalidCatalogEntryTypeException();
        }
        if (type > 5) {
            throw new InvalidCatalogEntryException();
        }
        if (type == 4 && !spec.equalsIgnoreCase("YES") && !spec.equalsIgnoreCase("NO")) {
            throw new InvalidCatalogEntryException();
        }
        this.entryType = type;
        this.spec1 = spec;
    }

    public CatalogEntry(int type, String spec, String fsispec) throws InvalidCatalogEntryTypeException, InvalidCatalogEntryException {
        if (type < 1 || type > 13) {
            throw new InvalidCatalogEntryTypeException();
        }
        if (type < 6) {
            throw new InvalidCatalogEntryException();
        }
        this.entryType = type;
        this.spec1 = spec;
        this.spec2 = fsispec;
    }

    public String entityName() {
        if (this.entryType == 7 || this.entryType == 9 || this.entryType == 10 || this.entryType == 11) {
            return this.spec1;
        }
        return null;
    }

    public int entryType() {
        return this.entryType;
    }

    public String formalSystemIdentifier() {
        if (this.entryType > 5) {
            return this.spec2;
        }
        if (this.entryType != 4) {
            return this.spec1;
        }
        return null;
    }

    public String partialPublicId() {
        if (this.entryType != 6) {
            return null;
        }
        return this.spec1;
    }

    public String publicId() {
        if (this.entryType == 8 || this.entryType == 12) {
            return this.spec1;
        }
        return null;
    }

    public String systemId() {
        if (this.entryType != 13) {
            return null;
        }
        return this.spec1;
    }

    public void updateFormalSystemIdentifier(String newspec) {
        if (this.entryType > 5) {
            this.spec2 = newspec;
        } else {
            this.spec1 = newspec;
        }
    }

    public String yes_or_no() {
        if (this.entryType != 4) {
            return null;
        }
        return this.spec1;
    }
}

