/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Research, CN=Research CA */
  9, X'3051310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e3111300f060355040b13085265736561726368311430120603550403130b5265736561726368204341'
);

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, OU=Research, CN=Research CA' */
  11, X'e775f0a0f2ad20cdcd6023ccc7c80f29f3dd5420');

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, OU=Research, CN=Research CA' */
  11, X'c71449851517718914a496532a1ee801b21c6aa5');

INSERT INTO identities (
  type, data
) VALUES ( /* carol@strongswan.org */
  3, X'6361726f6c407374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, OU=Research, CN=carol@strongswan.org' */
  11, X'c400ef96d95d5ebb4b2309071f7a6cf3f65491bd'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b8308202a0a003020102020100300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303130303131385a170d3139303930373130303131385a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381b23081af30120603551d130101ff040830060101ff020101300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b0500038201010023929aa101b412d1f5a577532088f209b34798a72ed7bd6945d74beaa2b3a1768764ad7f8b0df8d97a1a3ed1102e92a5f107e3059dc2250be49d02261ca83a342e0e5de7d43c37744e3fcea3197720ca1184d4ef94e6beeb0d241746b0b92b7fb1004c08e88bf9eb4ce60f3e149466f3e9fc3f98bce449f448f9d465e52b59f0101e6203cfad0d89e23509fa043d4c12021e8f32be7db8b2edbada641d64aa1a04af64a2ee5b814a753dd76b30e3de04f3c6b61166e632f8364d51cf3730a9564a4d93b9227c28b09b0f5595d92a632f72fe509a129ca9ee54df2b0edc6c3d38564f10256efcd8be82b2ec64977e3a6f5ef098eaa7f00662a6cded16cb80637c'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Research, CN=Research CA */
  1, 1, X'308203c1308202a9a003020102020120300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3130303430363039353335305a170d3139303430343039353335305a3051310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e3111300f060355040b13085265736561726368311430120603550403130b526573656172636820434130820122300d06092a864886f70d01010105000382010f003082010a0282010100b639b23aa6e0075b58a73f4fb25a856a72f71b5d3db1e780137a95b9e961a1dfaf19c6b2f9831421591c277b7a046a43f02e2471dc12fdc351d7c9596032a559d4bdd95ca79f21063a717d33d73fd203071cd0690c94cec13120658e5546367bbc49e412819d7564a24de1b58e07af519da8d87edcb1266de809067813452471e0f289e7814efdbefc2d4cc1fab331af3c70fe59c8f2312602d2a5ba043b73d6ae31e142cfe3669527e74a85a11cde6a9bed2234acb40bedb922e13c36afa2de3b41888f01c01a87637bb622e7e5521f4d73d77f47abc6b113cc1ecdf45f51dafe6d14838f78fb0c2ac1f1016518f3c4c98c17fd521b82351374c3389decae390203010001a381af3081ac300f0603551d130101ff040530030101ff300b0603551d0f040403020106301d0603551d0e04160414e775f0a0f2ad20cdcd6023ccc7c80f29f3dd5420306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b050003820101008d6da16d1b2dcc815c0a3215e2ca1b2e1289b70d059b3fae80a173051abf47e8c8b74260c60528478738bbc8b1322389fa58e0c3f2dd20604395e972ce6f385c16f7b8cce987c1caa8f1e3eeea4c1a8e68b31705b789dcb230432262ae9a8767396c3ac71c8710a370c00c3ce0469968e974ea942e82e5c17f44161040dab11907589a9a06d4279339791344b9b9bcc51e816b0ff4391cffb6dfadc42f63c5c8c7a099ce155d2cb3b5ecddddf63ea86f286801c6354b672ab7cc3feb306db15d5c8a3d4e3acde94c08fd5476c33adad2f5730022e2ca246b4d8642b3ffaf00611eddb66c930de2036ce4d4af8537638e0c156332eeeb7205601bd6f2c1668992'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Research, CN=carol@strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 5 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  3, 7 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  3, 8 
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, OU=Research, CN=carol@strongswan.org' */
  1, X'308204a50201000282010100e8a8f6d28e9044a366e993843bedd5a17274f0cf34084dac8a27f1a0af64cc454015ec6a6b352ce2f8ed429011e389703510d6cf743f4e6f0305fe4f0380da70438605417bc73e46c0517c4466c5cb332bb7608f9cab8f06c916b5093de9b4e0a10f9eb47b2e94f9b3bfb3d67fa9658afd1f2253bd825dddcf7af1fae8c105bdf26804246f71b362df6aa4d5dd1112d41f6f21e4065a1eb80d2ac5e97cbf1d8fa7dcc792306677509a174ba619231bc635dee1781ff6c71bf756fd133721a29263fc67989b80de639fb990914f5233d43341bd996359b70e7f7771b279c37017782961261a337ba52f855b387bf012b896fa6fd34b30be1e07404c0990fae98f0203010001028201010086869c20e739d7d63b7d3744b07a369a215a289b4654bec4d325817b0daf54c57de6af4a612ee00365379ad33ee4b7e55f699b2b5ce5f5ee0e6b7abe29226a2b9b7f74ae86699042cc94d12ba3d91e433a35cfe97a0760ade5bbf175a48ceb7f2ee19f3c7035610278c291b3a721458b760c7886beff10535ed291f4287ce359f4b860c5176456044775be950ebc8f753f885742b0c74006b2d50672a8cc050e5931de65cfbc09ad0c1560a1ae3f5bd830acd8cd004a0031e6cf42368d5d21bab02666fb38b9709b71be5f1d09ccdede38e65d88548f73236847013aacabebb361ad43d2ea59d92f544b858f222497dedc9e83a44488f96c0bcd0df8df8e678102818100ff6b7443e3a6b55b11e012f9a70b73fea85a51aaa36de73b7d48b945874f5d32c5fd04e45229c1a2c9721a93fa30f9b587a17d9d7e395b5889658a0492179d52be6b8adcfc6211597fc144732d59e7a7bfbc11ef6a6dd46471a7bc9366d8f501e261b977121e99ed028d241ba8070bff85bdbacd832b92627f6c8886be0b946102818100e930460397ee15d8cce4804db29972734574f10261a0438d757f45c83deba360e147315a5def25161fdc0e797a199cd89766092aade82aec47f4712ab963b027bb803fc618492d57b7e49e75c2e417f1de1517438ac04cbc7cc7095a7bec1cf8034c79a6351c1d0a3861861f6913e25e141428609dfa5937ebe97a5fdc1643ef0281810093ea65955f43cee8e38c3150f4a5145298aa5d7b055403421746c34c7994c37340e74b2af24e0e3e388ce4c9676d6f5eea21e27e0f7825e73b025b90540e6ae45d342861dba2eb4b3a49f15b061b77a554cb1453e2fda1af5d867715a1cce8ee636c969c5718f3a926fe17b81071ac4818ea8c40b1c2ccee4fbec9bdc6572c6102818100c2ba953d1afaaf33c4a66c9e75aebe6c946bfb77499f53ca257c8b0194f3da13650cd6a1e81f7490ed3a0ebc52c260c05e6dcee9dd202bf7f47ea4a250fe76743797f9a9ab4e309737f1aa821ca5ed790544079157a50e6fb8a35da43a280a68f21842de112bd0f45ff0d0d81a1f88c19772dde51107a6c9942ffd095ff917f102818004145ff4373203f45d993b33a9e6df3cf366c7b88768d6eb6775dbbf2bf73f92e4cd79452d3bc0843cff52a9d533b0707b53867896245df9a28d18e927e53c76d79bd98cd9ded9e5ccac227f3fb4e75fcb7236af5fd5f6e4fb8407663ae55d0e58898815594b9e9dcc4721386c89af7819625ab4d141456cc50b765880e04e1c'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 7 
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 8 
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_CAROL', 'PH_IP_MOON'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id
) VALUES (
  'home', 1, 7, 9 
);

INSERT INTO child_configs (
  name, updown
) VALUES (
  'home', 'ipsec _updown iptables'
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 2
);

