//
// RSAKey.cpp
//
// $Id: //poco/1.3/Crypto/src/RSAKey.cpp#4 $
//
// Library: Crypto
// Package: RSA
// Module:  RSAKey
//
// Copyright (c) 2008, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/Crypto/RSAKey.h"
#include <openssl/rsa.h>


namespace Poco {
namespace Crypto {


RSAKey::RSAKey(const X509Certificate& cert):
	_pImpl(new RSAKeyImpl(cert))
{
}


RSAKey::RSAKey(KeyLength keyLength, Exponent exp):
	_pImpl(0)
{
	int keyLen = keyLength;
	unsigned long expVal = RSA_3;
	if (exp == EXP_LARGE)
		expVal = RSA_F4;
	_pImpl = new RSAKeyImpl(keyLen, expVal);
}


RSAKey::RSAKey(const std::string& publicKeyFile, const std::string& privateKeyFile, const std::string& privateKeyPassphrase):
	_pImpl(new RSAKeyImpl(publicKeyFile, privateKeyFile, privateKeyPassphrase))
{
}


RSAKey::RSAKey(std::istream* pPublicKeyStream, std::istream* pPrivateKeyStream, const std::string& privateKeyPassphrase):
	_pImpl(new RSAKeyImpl(pPublicKeyStream, pPrivateKeyStream, privateKeyPassphrase))
{
}


RSAKey::~RSAKey()
{
}


int RSAKey::size() const
{
	return _pImpl->size();
}


void RSAKey::save(const std::string& publicKeyFile, const std::string& privateKeyFile, const std::string& privateKeyPassphrase)
{
	_pImpl->save(publicKeyFile, privateKeyFile, privateKeyPassphrase);
}


void RSAKey::save(std::ostream* pPublicKeyStream, std::ostream* pPrivateKeyStream, const std::string& privateKeyPassphrase)
{
	_pImpl->save(pPublicKeyStream, pPrivateKeyStream, privateKeyPassphrase);
}


const std::string& RSAKey::name() const
{
	static const std::string n("rsa");
	return n;
}


} } // namespace Poco::Crypto
