/* keybindingmanager.c generated by valac 0.40.8, the Vala compiler
 * generated from keybindingmanager.vala, do not modify */

/* vim:set et sts=4 sw=4:
valac --pkg gtk+-2.0 --pkg x11 --pkg gdk-x11-2.0 --pkg gee-1.0 keybinding-manager.vala
*/


#include <glib.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gdk/gdkx.h>
#include <float.h>
#include <math.h>
#include <ibus.h>
#include <gtk/gtk.h>
#include <X11/extensions/XInput2.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_KEYBINDING_MANAGER (keybinding_manager_get_type ())
#define KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManager))
#define KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))
#define IS_KEYBINDING_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KEYBINDING_MANAGER))
#define IS_KEYBINDING_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KEYBINDING_MANAGER))
#define KEYBINDING_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KEYBINDING_MANAGER, KeybindingManagerClass))

typedef struct _KeybindingManager KeybindingManager;
typedef struct _KeybindingManagerClass KeybindingManagerClass;
typedef struct _KeybindingManagerPrivate KeybindingManagerPrivate;

#define KEYBINDING_MANAGER_TYPE_KEYBINDING (keybinding_manager_keybinding_get_type ())
#define KEYBINDING_MANAGER_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KEYBINDING_MANAGER_TYPE_KEYBINDING, KeybindingManagerKeybinding))
#define KEYBINDING_MANAGER_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KEYBINDING_MANAGER_TYPE_KEYBINDING, KeybindingManagerKeybindingClass))
#define KEYBINDING_MANAGER_IS_KEYBINDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KEYBINDING_MANAGER_TYPE_KEYBINDING))
#define KEYBINDING_MANAGER_IS_KEYBINDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KEYBINDING_MANAGER_TYPE_KEYBINDING))
#define KEYBINDING_MANAGER_KEYBINDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KEYBINDING_MANAGER_TYPE_KEYBINDING, KeybindingManagerKeybindingClass))

typedef struct _KeybindingManagerKeybinding KeybindingManagerKeybinding;
typedef struct _KeybindingManagerKeybindingClass KeybindingManagerKeybindingClass;
enum  {
	KEYBINDING_MANAGER_0_PROPERTY,
	KEYBINDING_MANAGER_NUM_PROPERTIES
};
static GParamSpec* keybinding_manager_properties[KEYBINDING_MANAGER_NUM_PROPERTIES];
#define _keybinding_manager_keybinding_unref0(var) ((var == NULL) ? NULL : (var = (keybinding_manager_keybinding_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GdkEventKey_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkEventKey_free (var), NULL)))
typedef struct _KeybindingManagerKeybindingPrivate KeybindingManagerKeybindingPrivate;
typedef struct _KeybindingManagerParamSpecKeybinding KeybindingManagerParamSpecKeybinding;

struct _KeybindingManager {
	GObject parent_instance;
	KeybindingManagerPrivate * priv;
};

struct _KeybindingManagerClass {
	GObjectClass parent_class;
};

struct _KeybindingManagerPrivate {
	GList* m_bindings;
};

typedef void (*KeybindingManagerKeybindingHandlerFunc) (GdkEvent* event, gpointer user_data);
struct _KeybindingManagerKeybinding {
	GTypeInstance parent_instance;
	volatile int ref_count;
	KeybindingManagerKeybindingPrivate * priv;
};

struct _KeybindingManagerKeybindingClass {
	GTypeClass parent_class;
	void (*finalize) (KeybindingManagerKeybinding *self);
};

struct _KeybindingManagerKeybindingPrivate {
	guint _keysym;
	GdkModifierType _modifiers;
	KeybindingManagerKeybindingHandlerFunc _handler;
	gpointer _handler_target;
};

struct _KeybindingManagerParamSpecKeybinding {
	GParamSpec parent_instance;
};


static gpointer keybinding_manager_parent_class = NULL;
static KeybindingManager* keybinding_manager_m_instance;
static KeybindingManager* keybinding_manager_m_instance = NULL;
static gpointer keybinding_manager_keybinding_parent_class = NULL;

GType keybinding_manager_get_type (void) G_GNUC_CONST;
static gpointer keybinding_manager_keybinding_ref (gpointer instance);
static void keybinding_manager_keybinding_unref (gpointer instance);
static GParamSpec* keybinding_manager_param_spec_keybinding (const gchar* name,
                                                      const gchar* nick,
                                                      const gchar* blurb,
                                                      GType object_type,
                                                      GParamFlags flags) G_GNUC_UNUSED;
static void keybinding_manager_value_set_keybinding (GValue* value,
                                              gpointer v_object) G_GNUC_UNUSED;
static void keybinding_manager_value_take_keybinding (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static gpointer keybinding_manager_value_get_keybinding (const GValue* value) G_GNUC_UNUSED;
static GType keybinding_manager_keybinding_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define KEYBINDING_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_KEYBINDING_MANAGER, KeybindingManagerPrivate))
static void _keybinding_manager_keybinding_unref0_ (gpointer var);
static inline void _g_list_free__keybinding_manager_keybinding_unref0_ (GList* self);
#define KEYBINDING_MANAGER_MODIFIER_FILTER ((guint) (GDK_MODIFIER_MASK & (~(((((((((GDK_LOCK_MASK | GDK_MOD2_MASK) | GDK_BUTTON1_MASK) | GDK_BUTTON2_MASK) | GDK_BUTTON3_MASK) | GDK_BUTTON4_MASK) | GDK_BUTTON5_MASK) | GDK_SUPER_MASK) | GDK_HYPER_MASK) | GDK_META_MASK))))
static KeybindingManager* keybinding_manager_new (void);
static KeybindingManager* keybinding_manager_construct (GType object_type);
static void keybinding_manager_event_handler (KeybindingManager* self,
                                       GdkEvent* event);
static void _keybinding_manager_event_handler_gdk_event_func (GdkEvent* event,
                                                       gpointer self);
gboolean keybinding_manager_bind (KeybindingManager* self,
                                  guint keysym,
                                  GdkModifierType modifiers,
                                  KeybindingManagerKeybindingHandlerFunc handler,
                                  gpointer handler_target);
static gboolean keybinding_manager_grab_keycode (KeybindingManager* self,
                                          GdkDisplay* display,
                                          guint keyval,
                                          guint modifiers);
static KeybindingManagerKeybinding* keybinding_manager_keybinding_new (guint keysym,
                                                                GdkModifierType modifiers,
                                                                KeybindingManagerKeybindingHandlerFunc handler,
                                                                gpointer handler_target);
static KeybindingManagerKeybinding* keybinding_manager_keybinding_construct (GType object_type,
                                                                      guint keysym,
                                                                      GdkModifierType modifiers,
                                                                      KeybindingManagerKeybindingHandlerFunc handler,
                                                                      gpointer handler_target);
void keybinding_manager_unbind (KeybindingManager* self,
                                guint keysym,
                                GdkModifierType modifiers);
static guint keybinding_manager_keybinding_get_keysym (KeybindingManagerKeybinding* self);
static GdkModifierType keybinding_manager_keybinding_get_modifiers (KeybindingManagerKeybinding* self);
static gboolean keybinding_manager_ungrab_keycode (KeybindingManager* self,
                                            GdkDisplay* display,
                                            guint keyval,
                                            guint modifiers);
KeybindingManager* keybinding_manager_get_instance (void);
GdkModifierType keybinding_manager_get_primary_modifier (guint binding_mask);
gboolean keybinding_manager_primary_modifier_still_pressed (GdkEvent* event,
                                                            guint primary_modifier);
static GdkEventKey* _vala_GdkEventKey_copy (GdkEventKey* self);
static void _vala_GdkEventKey_free (GdkEventKey* self);
guint keybinding_manager_keyval_to_modifier (guint keyval);
static KeybindingManagerKeybindingHandlerFunc keybinding_manager_keybinding_get_handler (KeybindingManagerKeybinding* self,
                                                                                  gpointer* result_target);
static XIGrabModifiers* keybinding_manager_get_grab_modifiers (KeybindingManager* self,
                                                        guint modifiers,
                                                        int* result_length1);
static void _vala_array_add4 (gint* * array,
                       int* length,
                       int* size,
                       gint value);
static void _vala_array_add5 (gint* * array,
                       int* length,
                       int* size,
                       gint value);
static void _vala_array_add6 (gint* * array,
                       int* length,
                       int* size,
                       gint value);
static void _vala_array_add7 (XIGrabModifiers* * array,
                       int* length,
                       int* size,
                       const XIGrabModifiers* value);
static void _vala_XIGrabModifiers_array_free (XIGrabModifiers * array,
                                       gint array_length);
#define KEYBINDING_MANAGER_KEYBINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KEYBINDING_MANAGER_TYPE_KEYBINDING, KeybindingManagerKeybindingPrivate))
static void keybinding_manager_keybinding_set_keysym (KeybindingManagerKeybinding* self,
                                               guint value);
static void keybinding_manager_keybinding_set_modifiers (KeybindingManagerKeybinding* self,
                                                  GdkModifierType value);
static void keybinding_manager_keybinding_set_handler (KeybindingManagerKeybinding* self,
                                                KeybindingManagerKeybindingHandlerFunc value,
                                                gpointer value_target);
static void keybinding_manager_keybinding_finalize (KeybindingManagerKeybinding * obj);
static void keybinding_manager_finalize (GObject * obj);


static void
_keybinding_manager_keybinding_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (keybinding_manager_keybinding_unref (var), NULL));
}


static inline void
_g_list_free__keybinding_manager_keybinding_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _keybinding_manager_keybinding_unref0_);
}


static void
_keybinding_manager_event_handler_gdk_event_func (GdkEvent* event,
                                                  gpointer self)
{
	keybinding_manager_event_handler ((KeybindingManager*) self, event);
}


static KeybindingManager*
keybinding_manager_construct (GType object_type)
{
	KeybindingManager * self = NULL;
	self = (KeybindingManager*) g_object_new (object_type, NULL);
	gdk_event_handler_set (_keybinding_manager_event_handler_gdk_event_func, g_object_ref (self), g_object_unref);
	return self;
}


static KeybindingManager*
keybinding_manager_new (void)
{
	return keybinding_manager_construct (TYPE_KEYBINDING_MANAGER);
}


/**
     * Bind accelerator to given handler
     *
     * @param keysym
     * @param modifiers
     * @param handler handler called when given accelerator is pressed
     */
static gpointer
_keybinding_manager_keybinding_ref0 (gpointer self)
{
	return self ? keybinding_manager_keybinding_ref (self) : NULL;
}


gboolean
keybinding_manager_bind (KeybindingManager* self,
                         guint keysym,
                         GdkModifierType modifiers,
                         KeybindingManagerKeybindingHandlerFunc handler,
                         gpointer handler_target)
{
	gboolean result = FALSE;
	Display* display = NULL;
	Display* _tmp0_;
	gint keycode = 0;
	Display* _tmp1_;
	gint _tmp2_;
	GdkDisplay* _tmp3_;
	KeybindingManagerKeybinding* binding = NULL;
	KeybindingManagerKeybinding* _tmp4_;
	KeybindingManagerKeybinding* _tmp5_;
	KeybindingManagerKeybinding* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = gdk_x11_get_default_xdisplay ();
	display = _tmp0_;
	_tmp1_ = display;
	keycode = (gint) XKeysymToKeycode (_tmp1_, (gulong) keysym);
	_tmp2_ = keycode;
	if (_tmp2_ == 0) {
		result = FALSE;
		return result;
	}
	_tmp3_ = gdk_display_get_default ();
	keybinding_manager_grab_keycode (self, _tmp3_, keysym, (guint) modifiers);
	_tmp4_ = keybinding_manager_keybinding_new (keysym, modifiers, handler, handler_target);
	binding = _tmp4_;
	_tmp5_ = binding;
	_tmp6_ = _keybinding_manager_keybinding_ref0 (_tmp5_);
	self->priv->m_bindings = g_list_append (self->priv->m_bindings, _tmp6_);
	result = TRUE;
	_keybinding_manager_keybinding_unref0 (binding);
	return result;
}


/**
     * Unbind given accelerator.
     *
     * @param keysym
     * @param modifiers
     */
void
keybinding_manager_unbind (KeybindingManager* self,
                           guint keysym,
                           GdkModifierType modifiers)
{
	GList* remove_bindings = NULL;
	GList* _tmp0_;
	GList* _tmp18_;
	g_return_if_fail (self != NULL);
	remove_bindings = NULL;
	_tmp0_ = self->priv->m_bindings;
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
		binding_collection = _tmp0_;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			KeybindingManagerKeybinding* _tmp1_;
			KeybindingManagerKeybinding* binding = NULL;
			_tmp1_ = _keybinding_manager_keybinding_ref0 ((KeybindingManagerKeybinding*) binding_it->data);
			binding = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				KeybindingManagerKeybinding* _tmp3_;
				guint _tmp4_;
				guint _tmp5_;
				_tmp3_ = binding;
				_tmp4_ = keybinding_manager_keybinding_get_keysym (_tmp3_);
				_tmp5_ = _tmp4_;
				if (_tmp5_ == keysym) {
					KeybindingManagerKeybinding* _tmp6_;
					GdkModifierType _tmp7_;
					GdkModifierType _tmp8_;
					_tmp6_ = binding;
					_tmp7_ = keybinding_manager_keybinding_get_modifiers (_tmp6_);
					_tmp8_ = _tmp7_;
					_tmp2_ = _tmp8_ == modifiers;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					GdkDisplay* _tmp9_;
					KeybindingManagerKeybinding* _tmp10_;
					guint _tmp11_;
					guint _tmp12_;
					KeybindingManagerKeybinding* _tmp13_;
					GdkModifierType _tmp14_;
					GdkModifierType _tmp15_;
					KeybindingManagerKeybinding* _tmp16_;
					KeybindingManagerKeybinding* _tmp17_;
					_tmp9_ = gdk_display_get_default ();
					_tmp10_ = binding;
					_tmp11_ = keybinding_manager_keybinding_get_keysym (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = binding;
					_tmp14_ = keybinding_manager_keybinding_get_modifiers (_tmp13_);
					_tmp15_ = _tmp14_;
					keybinding_manager_ungrab_keycode (self, _tmp9_, _tmp12_, (guint) _tmp15_);
					_tmp16_ = binding;
					_tmp17_ = _keybinding_manager_keybinding_ref0 (_tmp16_);
					remove_bindings = g_list_append (remove_bindings, _tmp17_);
				}
				_keybinding_manager_keybinding_unref0 (binding);
			}
		}
	}
	_tmp18_ = remove_bindings;
	{
		GList* binding_collection = NULL;
		GList* binding_it = NULL;
		binding_collection = _tmp18_;
		for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
			KeybindingManagerKeybinding* _tmp19_;
			KeybindingManagerKeybinding* binding = NULL;
			_tmp19_ = _keybinding_manager_keybinding_ref0 ((KeybindingManagerKeybinding*) binding_it->data);
			binding = _tmp19_;
			{
				KeybindingManagerKeybinding* _tmp20_;
				_tmp20_ = binding;
				self->priv->m_bindings = g_list_remove (self->priv->m_bindings, _tmp20_);
				_keybinding_manager_keybinding_unref0 (binding);
			}
		}
	}
	(remove_bindings == NULL) ? NULL : (remove_bindings = (_g_list_free__keybinding_manager_keybinding_unref0_ (remove_bindings), NULL));
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


KeybindingManager*
keybinding_manager_get_instance (void)
{
	KeybindingManager* result = NULL;
	KeybindingManager* _tmp0_;
	KeybindingManager* _tmp2_;
	KeybindingManager* _tmp3_;
	_tmp0_ = keybinding_manager_m_instance;
	if (_tmp0_ == NULL) {
		KeybindingManager* _tmp1_;
		_tmp1_ = keybinding_manager_new ();
		_g_object_unref0 (keybinding_manager_m_instance);
		keybinding_manager_m_instance = _tmp1_;
	}
	_tmp2_ = keybinding_manager_m_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


GdkModifierType
keybinding_manager_get_primary_modifier (guint binding_mask)
{
	GdkModifierType result = 0;
	static const GdkModifierType masks[8] = {GDK_MOD5_MASK, GDK_MOD4_MASK, GDK_MOD3_MASK, GDK_MOD2_MASK, GDK_MOD1_MASK, GDK_CONTROL_MASK, GDK_SHIFT_MASK, GDK_LOCK_MASK};
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				GdkModifierType mask = 0;
				gint _tmp3_;
				GdkModifierType _tmp4_;
				GdkModifierType _tmp5_;
				GdkModifierType _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < G_N_ELEMENTS (masks))) {
					break;
				}
				_tmp3_ = i;
				_tmp4_ = masks[_tmp3_];
				mask = _tmp4_;
				_tmp5_ = mask;
				_tmp6_ = mask;
				if ((binding_mask & _tmp5_) == ((guint) _tmp6_)) {
					result = mask;
					return result;
				}
			}
		}
	}
	result = 0;
	return result;
}


static GdkEventKey*
_vala_GdkEventKey_copy (GdkEventKey* self)
{
	return g_boxed_copy (gdk_event_get_type (), self);
}


static gpointer
__vala_GdkEventKey_copy0 (gpointer self)
{
	return self ? _vala_GdkEventKey_copy (self) : NULL;
}


static void
_vala_GdkEventKey_free (GdkEventKey* self)
{
	g_boxed_free (gdk_event_get_type (), self);
}


gboolean
keybinding_manager_primary_modifier_still_pressed (GdkEvent* event,
                                                   guint primary_modifier)
{
	gboolean result = FALSE;
	GdkEventKey* keyevent = NULL;
	GdkEventKey* _tmp0_;
	GdkEventKey* _tmp1_;
	GdkEventKey* _tmp2_;
	GdkDevice* device = NULL;
	GdkDevice* _tmp3_;
	GdkDevice* _tmp4_;
	GdkDevice* pointer = NULL;
	GdkDevice* _tmp5_;
	gdouble* axes = NULL;
	gint axes_length1;
	gint _axes_size_;
	guint modifier = 0U;
	GdkDevice* _tmp11_;
	GdkEventKey* _tmp12_;
	GdkWindow* _tmp13_;
	gdouble* _tmp14_;
	gint _tmp14__length1;
	GdkModifierType _tmp15_ = 0;
	guint _tmp16_;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = (GdkEventKey *) (event);
	_tmp1_ = _tmp0_;
	_tmp2_ = __vala_GdkEventKey_copy0 (_tmp1_);
	keyevent = _tmp2_;
	if (primary_modifier == ((guint) 0)) {
		result = FALSE;
		__vala_GdkEventKey_free0 (keyevent);
		return result;
	}
	_tmp3_ = gdk_event_get_device (event);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	device = _tmp4_;
	_tmp5_ = device;
	if (gdk_device_get_source (_tmp5_) == GDK_SOURCE_KEYBOARD) {
		GdkDevice* _tmp6_;
		GdkDevice* _tmp7_;
		GdkDevice* _tmp8_;
		_tmp6_ = device;
		_tmp7_ = gdk_device_get_associated_device (_tmp6_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (pointer);
		pointer = _tmp8_;
	} else {
		GdkDevice* _tmp9_;
		GdkDevice* _tmp10_;
		_tmp9_ = device;
		_tmp10_ = _g_object_ref0 (_tmp9_);
		_g_object_unref0 (pointer);
		pointer = _tmp10_;
	}
	axes = NULL;
	axes_length1 = 0;
	_axes_size_ = axes_length1;
	modifier = (guint) 0;
	_tmp11_ = pointer;
	_tmp12_ = keyevent;
	_tmp13_ = _tmp12_->window;
	_tmp14_ = axes;
	_tmp14__length1 = axes_length1;
	gdk_device_get_state (_tmp11_, _tmp13_, _tmp14_, &_tmp15_);
	modifier = (guint) _tmp15_;
	_tmp16_ = modifier;
	if ((primary_modifier & _tmp16_) == primary_modifier) {
		result = TRUE;
		axes = (g_free (axes), NULL);
		_g_object_unref0 (pointer);
		_g_object_unref0 (device);
		__vala_GdkEventKey_free0 (keyevent);
		return result;
	}
	result = FALSE;
	axes = (g_free (axes), NULL);
	_g_object_unref0 (pointer);
	_g_object_unref0 (device);
	__vala_GdkEventKey_free0 (keyevent);
	return result;
}


guint
keybinding_manager_keyval_to_modifier (guint keyval)
{
	guint result = 0U;
	switch (keyval) {
		case 0xffe3:
		case 0xffe4:
		{
			result = (guint) GDK_CONTROL_MASK;
			return result;
		}
		case 0xffe1:
		case 0xffe2:
		{
			result = (guint) GDK_SHIFT_MASK;
			return result;
		}
		case 0xffe5:
		{
			result = (guint) GDK_LOCK_MASK;
			return result;
		}
		case 0xffe9:
		case 0xffea:
		{
			result = (guint) GDK_MOD1_MASK;
			return result;
		}
		case 0xffe7:
		case 0xffe8:
		{
			result = (guint) GDK_META_MASK;
			return result;
		}
		case 0xffeb:
		case 0xffec:
		{
			result = (guint) GDK_SUPER_MASK;
			return result;
		}
		case 0xffed:
		case 0xffee:
		{
			result = (guint) GDK_HYPER_MASK;
			return result;
		}
		default:
		{
			result = (guint) 0;
			return result;
		}
	}
}


static void
keybinding_manager_event_handler (KeybindingManager* self,
                                  GdkEvent* event)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			GdkEventAny* _tmp1_;
			GdkEventAny* _tmp2_;
			GdkWindow* _tmp3_;
			GdkWindow* _tmp4_;
			GdkEventType _tmp5_;
			if (!_tmp0_) {
				if (!FALSE) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp1_ = (GdkEventAny *) (event);
			_tmp2_ = _tmp1_;
			_tmp3_ = _tmp2_->window;
			_tmp4_ = gdk_get_default_root_window ();
			if (_tmp3_ != _tmp4_) {
				break;
			}
			_tmp5_ = event->type;
			if (_tmp5_ == GDK_KEY_PRESS) {
				guint modifiers = 0U;
				GdkEventKey* _tmp6_;
				GdkEventKey* _tmp7_;
				GdkModifierType _tmp8_;
				guint keyval = 0U;
				GdkEventKey* _tmp9_;
				GdkEventKey* _tmp10_;
				guint _tmp11_;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				guint _tmp14_;
				GList* _tmp18_;
				_tmp6_ = (GdkEventKey *) (event);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_->state;
				modifiers = (guint) (_tmp8_ & KEYBINDING_MANAGER_MODIFIER_FILTER);
				_tmp9_ = (GdkEventKey *) (event);
				_tmp10_ = _tmp9_;
				_tmp11_ = _tmp10_->keyval;
				keyval = _tmp11_;
				_tmp14_ = keyval;
				if (_tmp14_ >= ((guint) IBUS_KEY_A)) {
					guint _tmp15_;
					_tmp15_ = keyval;
					_tmp13_ = _tmp15_ <= ((guint) IBUS_KEY_Z);
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					guint _tmp16_;
					_tmp16_ = modifiers;
					_tmp12_ = (_tmp16_ & GDK_SHIFT_MASK) != ((guint) 0);
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					guint _tmp17_;
					_tmp17_ = keyval;
					keyval = (_tmp17_ - IBUS_KEY_A) + IBUS_KEY_a;
				}
				_tmp18_ = self->priv->m_bindings;
				{
					GList* binding_collection = NULL;
					GList* binding_it = NULL;
					binding_collection = _tmp18_;
					for (binding_it = binding_collection; binding_it != NULL; binding_it = binding_it->next) {
						KeybindingManagerKeybinding* _tmp19_;
						KeybindingManagerKeybinding* binding = NULL;
						_tmp19_ = _keybinding_manager_keybinding_ref0 ((KeybindingManagerKeybinding*) binding_it->data);
						binding = _tmp19_;
						{
							gboolean _tmp20_ = FALSE;
							guint _tmp21_;
							KeybindingManagerKeybinding* _tmp22_;
							guint _tmp23_;
							guint _tmp24_;
							KeybindingManagerKeybinding* _tmp29_;
							KeybindingManagerKeybindingHandlerFunc _tmp30_;
							void* _tmp30__target;
							KeybindingManagerKeybindingHandlerFunc _tmp31_;
							void* _tmp31__target;
							_tmp21_ = keyval;
							_tmp22_ = binding;
							_tmp23_ = keybinding_manager_keybinding_get_keysym (_tmp22_);
							_tmp24_ = _tmp23_;
							if (_tmp21_ != _tmp24_) {
								_tmp20_ = TRUE;
							} else {
								guint _tmp25_;
								KeybindingManagerKeybinding* _tmp26_;
								GdkModifierType _tmp27_;
								GdkModifierType _tmp28_;
								_tmp25_ = modifiers;
								_tmp26_ = binding;
								_tmp27_ = keybinding_manager_keybinding_get_modifiers (_tmp26_);
								_tmp28_ = _tmp27_;
								_tmp20_ = _tmp25_ != ((guint) _tmp28_);
							}
							if (_tmp20_) {
								_keybinding_manager_keybinding_unref0 (binding);
								continue;
							}
							_tmp29_ = binding;
							_tmp30_ = keybinding_manager_keybinding_get_handler (_tmp29_, &_tmp30__target);
							_tmp31_ = _tmp30_;
							_tmp31__target = _tmp30__target;
							_tmp31_ (event, _tmp31__target);
							_keybinding_manager_keybinding_unref0 (binding);
							return;
						}
					}
				}
			}
		}
	}
	gtk_main_do_event (event);
}


static void
_vala_array_add4 (gint* * array,
                  int* length,
                  int* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add5 (gint* * array,
                  int* length,
                  int* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add6 (gint* * array,
                  int* length,
                  int* size,
                  gint value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add7 (XIGrabModifiers* * array,
                  int* length,
                  int* size,
                  const XIGrabModifiers* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (XIGrabModifiers, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void
_vala_XIGrabModifiers_array_free (XIGrabModifiers * array,
                                  gint array_length)
{
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			 (&array[i]);
		}
	}
	g_free (array);
}


static XIGrabModifiers*
keybinding_manager_get_grab_modifiers (KeybindingManager* self,
                                       guint modifiers,
                                       int* result_length1)
{
	XIGrabModifiers* result = NULL;
	static const gint ignored_modifiers[3] = {(gint) LockMask, (gint) Mod2Mask, (gint) Mod5Mask};
	gint* masks = NULL;
	gint* _tmp0_;
	gint masks_length1;
	gint _masks_size_;
	gint* _tmp18_;
	gint _tmp18__length1;
	XIGrabModifiers* ximodifiers = NULL;
	XIGrabModifiers* _tmp19_;
	gint ximodifiers_length1;
	gint _ximodifiers_size_;
	gint* _tmp20_;
	gint _tmp20__length1;
	XIGrabModifiers* _tmp24_;
	gint _tmp24__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gint, 0);
	masks = _tmp0_;
	masks_length1 = 0;
	_masks_size_ = masks_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_;
				gint modifier = 0;
				gint _tmp4_;
				gint _tmp5_;
				gint* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				gint length = 0;
				gint* _tmp8_;
				gint _tmp8__length1;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < G_N_ELEMENTS (ignored_modifiers))) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = ignored_modifiers[_tmp4_];
				modifier = _tmp5_;
				_tmp6_ = masks;
				_tmp6__length1 = masks_length1;
				_tmp7_ = modifier;
				_vala_array_add4 (&masks, &masks_length1, &_masks_size_, _tmp7_);
				_tmp8_ = masks;
				_tmp8__length1 = masks_length1;
				length = _tmp8__length1;
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp9_ = FALSE;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp11_;
							gint _tmp12_;
							gint* _tmp13_;
							gint _tmp13__length1;
							gint* _tmp14_;
							gint _tmp14__length1;
							gint _tmp15_;
							gint _tmp16_;
							gint _tmp17_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = j;
								j = _tmp10_ + 1;
							}
							_tmp9_ = FALSE;
							_tmp11_ = j;
							_tmp12_ = length;
							if (!(_tmp11_ < (_tmp12_ - 1))) {
								break;
							}
							_tmp13_ = masks;
							_tmp13__length1 = masks_length1;
							_tmp14_ = masks;
							_tmp14__length1 = masks_length1;
							_tmp15_ = j;
							_tmp16_ = _tmp14_[_tmp15_];
							_tmp17_ = modifier;
							_vala_array_add5 (&masks, &masks_length1, &_masks_size_, _tmp16_ | _tmp17_);
						}
					}
				}
			}
		}
	}
	_tmp18_ = masks;
	_tmp18__length1 = masks_length1;
	_vala_array_add6 (&masks, &masks_length1, &_masks_size_, 0);
	_tmp19_ = g_new0 (XIGrabModifiers, 0);
	ximodifiers = _tmp19_;
	ximodifiers_length1 = 0;
	_ximodifiers_size_ = ximodifiers_length1;
	_tmp20_ = masks;
	_tmp20__length1 = masks_length1;
	{
		gint* mask_collection = NULL;
		gint mask_collection_length1 = 0;
		gint _mask_collection_size_ = 0;
		gint mask_it = 0;
		mask_collection = _tmp20_;
		mask_collection_length1 = _tmp20__length1;
		for (mask_it = 0; mask_it < _tmp20__length1; mask_it = mask_it + 1) {
			gint mask = 0;
			mask = mask_collection[mask_it];
			{
				XIGrabModifiers* _tmp21_;
				gint _tmp21__length1;
				gint _tmp22_;
				XIGrabModifiers _tmp23_ = {0};
				_tmp21_ = ximodifiers;
				_tmp21__length1 = ximodifiers_length1;
				_tmp22_ = mask;
				memset (&_tmp23_, 0, sizeof (XIGrabModifiers));
				_tmp23_.modifiers = _tmp22_ | modifiers;
				_tmp23_.status = 0;
				_vala_array_add7 (&ximodifiers, &ximodifiers_length1, &_ximodifiers_size_, &_tmp23_);
			}
		}
	}
	_tmp24_ = ximodifiers;
	_tmp24__length1 = ximodifiers_length1;
	if (result_length1) {
		*result_length1 = _tmp24__length1;
	}
	result = _tmp24_;
	masks = (g_free (masks), NULL);
	return result;
}


static gboolean
keybinding_manager_grab_keycode (KeybindingManager* self,
                                 GdkDisplay* display,
                                 guint keyval,
                                 guint modifiers)
{
	gboolean result = FALSE;
	Display* xdisplay = NULL;
	Display* _tmp0_;
	gint keycode = 0;
	Display* _tmp1_;
	gint _tmp2_;
	XIEventMask evmask = {0};
	guchar* _tmp3_;
	XIEventMask _tmp4_ = {0};
	XIEventMask _tmp5_;
	guchar* _tmp6_;
	gint _tmp6__length1;
	XIEventMask _tmp7_;
	guchar* _tmp8_;
	gint _tmp8__length1;
	gint retval = 0;
	Display* _tmp9_;
	gint _tmp10_;
	Display* _tmp11_;
	XIEventMask _tmp12_;
	gint _tmp13_;
	XIGrabModifiers* _tmp14_;
	XIGrabModifiers* _tmp15_;
	gint _tmp15__length1;
	gint _tmp16_;
	gint _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	_tmp0_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_TYPE (display, gdk_x11_display_get_type ()) ? ((GdkX11Display*) display) : NULL);
	xdisplay = _tmp0_;
	_tmp1_ = xdisplay;
	keycode = (gint) XKeysymToKeycode (_tmp1_, (gulong) keyval);
	_tmp2_ = keycode;
	if (_tmp2_ == 0) {
		g_warning ("keybindingmanager.vala:260: Can not convert keyval=%u to keycode!", keyval);
		result = FALSE;
		return result;
	}
	_tmp3_ = g_new0 (guchar, (XI_LASTEVENT + 7) / 8);
	memset (&_tmp4_, 0, sizeof (XIEventMask));
	_tmp4_.deviceid = XIAllMasterDevices;
	_tmp4_.mask = (g_free (_tmp4_.mask), NULL);
	_tmp4_.mask = _tmp3_;
	_tmp4_.mask_len = (XI_LASTEVENT + 7) / 8;
	evmask = _tmp4_;
	_tmp5_ = evmask;
	_tmp6_ = _tmp5_.mask;
	_tmp6__length1 = _tmp5_.mask_len;
	XISetMask (_tmp6_, XI_KeyPress);
	_tmp7_ = evmask;
	_tmp8_ = _tmp7_.mask;
	_tmp8__length1 = _tmp7_.mask_len;
	XISetMask (_tmp8_, XI_KeyRelease);
	_tmp9_ = xdisplay;
	_tmp10_ = keycode;
	_tmp11_ = xdisplay;
	_tmp12_ = evmask;
	_tmp14_ = keybinding_manager_get_grab_modifiers (self, modifiers, &_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp15__length1 = _tmp13_;
	_tmp16_ = XIGrabKeycode (_tmp9_, XIAllMasterDevices, _tmp10_, DefaultRootWindow (_tmp11_), (gint) GrabModeAsync, (gint) GrabModeAsync, TRUE, &_tmp12_, _tmp13_, _tmp15_);
	_tmp15_ = (_vala_XIGrabModifiers_array_free (_tmp15_, _tmp15__length1), NULL);
	retval = _tmp16_;
	_tmp17_ = retval;
	result = _tmp17_ == 0;
	 (&evmask);
	return result;
}


static gboolean
keybinding_manager_ungrab_keycode (KeybindingManager* self,
                                   GdkDisplay* display,
                                   guint keyval,
                                   guint modifiers)
{
	gboolean result = FALSE;
	Display* xdisplay = NULL;
	Display* _tmp0_;
	gint keycode = 0;
	Display* _tmp1_;
	gint _tmp2_;
	gint retval = 0;
	Display* _tmp3_;
	gint _tmp4_;
	Display* _tmp5_;
	gint _tmp6_;
	XIGrabModifiers* _tmp7_;
	XIGrabModifiers* _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_;
	gint _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (display != NULL, FALSE);
	_tmp0_ = gdk_x11_display_get_xdisplay (G_TYPE_CHECK_INSTANCE_TYPE (display, gdk_x11_display_get_type ()) ? ((GdkX11Display*) display) : NULL);
	xdisplay = _tmp0_;
	_tmp1_ = xdisplay;
	keycode = (gint) XKeysymToKeycode (_tmp1_, (gulong) keyval);
	_tmp2_ = keycode;
	if (_tmp2_ == 0) {
		g_warning ("keybindingmanager.vala:293: Can not convert keyval=%u to keycode!", keyval);
		result = FALSE;
		return result;
	}
	_tmp3_ = xdisplay;
	_tmp4_ = keycode;
	_tmp5_ = xdisplay;
	_tmp7_ = keybinding_manager_get_grab_modifiers (self, modifiers, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_tmp9_ = XIUngrabKeycode (_tmp3_, XIAllMasterDevices, _tmp4_, DefaultRootWindow (_tmp5_), _tmp6_, _tmp8_);
	_tmp8_ = (_vala_XIGrabModifiers_array_free (_tmp8_, _tmp8__length1), NULL);
	retval = _tmp9_;
	_tmp10_ = retval;
	result = _tmp10_ == 0;
	return result;
}


static KeybindingManagerKeybinding*
keybinding_manager_keybinding_construct (GType object_type,
                                         guint keysym,
                                         GdkModifierType modifiers,
                                         KeybindingManagerKeybindingHandlerFunc handler,
                                         gpointer handler_target)
{
	KeybindingManagerKeybinding* self = NULL;
	self = (KeybindingManagerKeybinding*) g_type_create_instance (object_type);
	keybinding_manager_keybinding_set_keysym (self, keysym);
	keybinding_manager_keybinding_set_modifiers (self, modifiers);
	keybinding_manager_keybinding_set_handler (self, handler, handler_target);
	return self;
}


static KeybindingManagerKeybinding*
keybinding_manager_keybinding_new (guint keysym,
                                   GdkModifierType modifiers,
                                   KeybindingManagerKeybindingHandlerFunc handler,
                                   gpointer handler_target)
{
	return keybinding_manager_keybinding_construct (KEYBINDING_MANAGER_TYPE_KEYBINDING, keysym, modifiers, handler, handler_target);
}


static guint
keybinding_manager_keybinding_get_keysym (KeybindingManagerKeybinding* self)
{
	guint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_keysym;
	result = _tmp0_;
	return result;
}


static void
keybinding_manager_keybinding_set_keysym (KeybindingManagerKeybinding* self,
                                          guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_keysym = value;
}


static GdkModifierType
keybinding_manager_keybinding_get_modifiers (KeybindingManagerKeybinding* self)
{
	GdkModifierType result;
	GdkModifierType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_modifiers;
	result = _tmp0_;
	return result;
}


static void
keybinding_manager_keybinding_set_modifiers (KeybindingManagerKeybinding* self,
                                             GdkModifierType value)
{
	g_return_if_fail (self != NULL);
	self->priv->_modifiers = value;
}


static KeybindingManagerKeybindingHandlerFunc
keybinding_manager_keybinding_get_handler (KeybindingManagerKeybinding* self,
                                           gpointer* result_target)
{
	KeybindingManagerKeybindingHandlerFunc result;
	KeybindingManagerKeybindingHandlerFunc _tmp0_;
	void* _tmp0__target;
	KeybindingManagerKeybindingHandlerFunc _tmp1_;
	void* _tmp1__target;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_handler;
	_tmp0__target = self->priv->_handler_target;
	_tmp1_ = _tmp0_;
	_tmp1__target = _tmp0__target;
	*result_target = _tmp1__target;
	result = _tmp1_;
	return result;
}


static void
keybinding_manager_keybinding_set_handler (KeybindingManagerKeybinding* self,
                                           KeybindingManagerKeybindingHandlerFunc value,
                                           gpointer value_target)
{
	g_return_if_fail (self != NULL);
	self->priv->_handler = value;
	self->priv->_handler_target = value_target;
}


static void
keybinding_manager_value_keybinding_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
keybinding_manager_value_keybinding_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		keybinding_manager_keybinding_unref (value->data[0].v_pointer);
	}
}


static void
keybinding_manager_value_keybinding_copy_value (const GValue* src_value,
                                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = keybinding_manager_keybinding_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
keybinding_manager_value_keybinding_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
keybinding_manager_value_keybinding_collect_value (GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		KeybindingManagerKeybinding * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = keybinding_manager_keybinding_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
keybinding_manager_value_keybinding_lcopy_value (const GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	KeybindingManagerKeybinding ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = keybinding_manager_keybinding_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
keybinding_manager_param_spec_keybinding (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags)
{
	KeybindingManagerParamSpecKeybinding* spec;
	g_return_val_if_fail (g_type_is_a (object_type, KEYBINDING_MANAGER_TYPE_KEYBINDING), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
keybinding_manager_value_get_keybinding (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KEYBINDING_MANAGER_TYPE_KEYBINDING), NULL);
	return value->data[0].v_pointer;
}


static void
keybinding_manager_value_set_keybinding (GValue* value,
                                         gpointer v_object)
{
	KeybindingManagerKeybinding * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KEYBINDING_MANAGER_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, KEYBINDING_MANAGER_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		keybinding_manager_keybinding_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		keybinding_manager_keybinding_unref (old);
	}
}


static void
keybinding_manager_value_take_keybinding (GValue* value,
                                          gpointer v_object)
{
	KeybindingManagerKeybinding * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, KEYBINDING_MANAGER_TYPE_KEYBINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, KEYBINDING_MANAGER_TYPE_KEYBINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		keybinding_manager_keybinding_unref (old);
	}
}


static void
keybinding_manager_keybinding_class_init (KeybindingManagerKeybindingClass * klass)
{
	keybinding_manager_keybinding_parent_class = g_type_class_peek_parent (klass);
	((KeybindingManagerKeybindingClass *) klass)->finalize = keybinding_manager_keybinding_finalize;
	g_type_class_add_private (klass, sizeof (KeybindingManagerKeybindingPrivate));
}


static void
keybinding_manager_keybinding_instance_init (KeybindingManagerKeybinding * self)
{
	self->priv = KEYBINDING_MANAGER_KEYBINDING_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
keybinding_manager_keybinding_finalize (KeybindingManagerKeybinding * obj)
{
	KeybindingManagerKeybinding * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KEYBINDING_MANAGER_TYPE_KEYBINDING, KeybindingManagerKeybinding);
	g_signal_handlers_destroy (self);
}


/**
     * Helper class to store keybinding
     */
static GType
keybinding_manager_keybinding_get_type (void)
{
	static volatile gsize keybinding_manager_keybinding_type_id__volatile = 0;
	if (g_once_init_enter (&keybinding_manager_keybinding_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { keybinding_manager_value_keybinding_init, keybinding_manager_value_keybinding_free_value, keybinding_manager_value_keybinding_copy_value, keybinding_manager_value_keybinding_peek_pointer, "p", keybinding_manager_value_keybinding_collect_value, "p", keybinding_manager_value_keybinding_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (KeybindingManagerKeybindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keybinding_manager_keybinding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeybindingManagerKeybinding), 0, (GInstanceInitFunc) keybinding_manager_keybinding_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType keybinding_manager_keybinding_type_id;
		keybinding_manager_keybinding_type_id = g_type_register_fundamental (g_type_fundamental_next (), "KeybindingManagerKeybinding", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&keybinding_manager_keybinding_type_id__volatile, keybinding_manager_keybinding_type_id);
	}
	return keybinding_manager_keybinding_type_id__volatile;
}


static gpointer
keybinding_manager_keybinding_ref (gpointer instance)
{
	KeybindingManagerKeybinding * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
keybinding_manager_keybinding_unref (gpointer instance)
{
	KeybindingManagerKeybinding * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		KEYBINDING_MANAGER_KEYBINDING_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
keybinding_manager_class_init (KeybindingManagerClass * klass)
{
	keybinding_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KeybindingManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = keybinding_manager_finalize;
}


static void
keybinding_manager_instance_init (KeybindingManager * self)
{
	self->priv = KEYBINDING_MANAGER_GET_PRIVATE (self);
	self->priv->m_bindings = NULL;
}


static void
keybinding_manager_finalize (GObject * obj)
{
	KeybindingManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KEYBINDING_MANAGER, KeybindingManager);
	(self->priv->m_bindings == NULL) ? NULL : (self->priv->m_bindings = (_g_list_free__keybinding_manager_keybinding_unref0_ (self->priv->m_bindings), NULL));
	G_OBJECT_CLASS (keybinding_manager_parent_class)->finalize (obj);
}


/**
 * This class is in charge to grab keybindings on the X11 display
 * and filter X11-events and passing on such events to the registed
 * handler methods.
 *
 * @author Oliver Sauder <os@esite.ch>
 */
GType
keybinding_manager_get_type (void)
{
	static volatile gsize keybinding_manager_type_id__volatile = 0;
	if (g_once_init_enter (&keybinding_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KeybindingManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) keybinding_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KeybindingManager), 0, (GInstanceInitFunc) keybinding_manager_instance_init, NULL };
		GType keybinding_manager_type_id;
		keybinding_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "KeybindingManager", &g_define_type_info, 0);
		g_once_init_leave (&keybinding_manager_type_id__volatile, keybinding_manager_type_id);
	}
	return keybinding_manager_type_id__volatile;
}



