/* Identities */

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  9, X'3045310B300906035504061302434831193017060355040A13104C696E7578207374726F6E675377616E311B3019060355040313127374726F6E675377616E20526F6F74204341'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'5da7dd700651327ee7b66db3b5e5e060ea2e4def'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, CN=strongSwan Root CA' */
  11, X'ae096b87b44886d3b820978623dabd0eae22ebbc'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Sales, CN=Sales CA */
  9, X'304b310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e310e300c060355040b130553616c65733111300f0603550403130853616c6573204341'
);

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, OU=Sales, CN=Sales CA' */
  11, X'5f9b1346f92072c800d588b5a74c2e97ea0b9328'
);

INSERT INTO identities (
  type, data
) VALUES ( /* keyid of 'C=CH, O=Linux strongSwan, OU=Sales, CN=Sales CA' */
  11, X'c9ca6b980be96d5f210d7fed1529eb6c567ec26c'
);

INSERT INTO identities (
  type, data
) VALUES ( /* dave@strongswan.org */
  3, X'64617665407374726f6e677377616e2e6f7267'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* subjkey of 'C=CH, O=Linux strongSwan, OU=Sales, CN=dave@strongswan.org' */
  11, X'81c0c1dfa134c6f60e0b9a42ff901977b6145fc7'
 );

INSERT INTO identities (
  type, data
) VALUES ( /* moon.strongswan.org */
  2, X'6d6f6f6e2e7374726f6e677377616e2e6f7267'
 );

/* Certificates */

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, CN=strongSwan Root CA */
  1, 1, X'308203b8308202a0a003020102020100300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3034303931303130303131385a170d3139303930373130303131385a3045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f7420434130820122300d06092a864886f70d01010105000382010f003082010a0282010100bff25f62ea3d566e58b3c87a49caf3ac61cfa96377734d842db3f8fd6ea023f7b0132e66265012317386729c6d7c427a8d9f167be138e8ebae2b12b95933baef36a315c3ddf224cee4bb9bd578135d0467382629621ff96b8d45f6e002e5083662dce181805c140b3f2ce93f83aee3c861cff610a39f0189cb3a3c7cb9bf7e2a09544e2170efaa18fdd4ff20fa94be176d7fecff821f68d17152041d9b46f0cfcfc1e4cf43de5d3f3a587763afe9267f53b11699b3264fc55c5189f5682871166cb98307950569641fa30ffb50de134fed2f973cef1a392827862bc4ddaa97bbb01442e293c41070d07224d4be47ae2753eb2bed4bc1da91c68ec780c4620f0f0203010001a381b23081af30120603551d130101ff040830060101ff020101300b0603551d0f040403020106301d0603551d0e041604145da7dd700651327ee7b66db3b5e5e060ea2e4def306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b0500038201010023929aa101b412d1f5a577532088f209b34798a72ed7bd6945d74beaa2b3a1768764ad7f8b0df8d97a1a3ed1102e92a5f107e3059dc2250be49d02261ca83a342e0e5de7d43c37744e3fcea3197720ca1184d4ef94e6beeb0d241746b0b92b7fb1004c08e88bf9eb4ce60f3e149466f3e9fc3f98bce449f448f9d465e52b59f0101e6203cfad0d89e23509fa043d4c12021e8f32be7db8b2edbada641d64aa1a04af64a2ee5b814a753dd76b30e3de04f3c6b61166e632f8364d51cf3730a9564a4d93b9227c28b09b0f5595d92a632f72fe509a129ca9ee54df2b0edc6c3d38564f10256efcd8be82b2ec64977e3a6f5ef098eaa7f00662a6cded16cb80637c'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Sales CN=Sales CA */
  1, 1, X'308203bb308202a3a003020102020121300d06092a864886f70d01010b05003045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341301e170d3130303430363039353433335a170d3139303430343039353433335a304b310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e310e300c060355040b130553616c65733111300f0603550403130853616c657320434130820122300d06092a864886f70d01010105000382010f003082010a0282010100c24e4d26998c37b9511fa125ba1d704e34581c569beaf41620fe14b736734847fd07169b55dfaa773da9a3cf1a8c4ed817f05e01441df39d4331c6bad861b2f74c3e49963f5677b83af0b1caab98bcaae0923cedec527a7d608260951226f9e53e1f371ad320625aa1ee899fdbfd6701b607e52bde7140ff075c91276a27173a5cbf4329c464dd3c59b6ff52b837ed13d1bbf3b3ba3c94b27f2518865773d4465ee4f4ec52801b049d030d7271df9eb6903b5f41dc1ecdab742c0c8eb1569b62aff41bf7c16702cb7abe2a185dbedc2b2f3fb8cd5e785161e4afdbee22da602381b0512350378aaa14dcdab5bcf02aceb7a4388fd157d1eb7bd2f5afc5f574810203010001a381af3081ac300f0603551d130101ff040530030101ff300b0603551d0f040403020106301d0603551d0e041604145f9b1346f92072c800d588b5a74c2e97ea0b9328306d0603551d230466306480145da7dd700651327ee7b66db3b5e5e060ea2e4defa149a4473045310b300906035504061302434831193017060355040a13104c696e7578207374726f6e675377616e311b3019060355040313127374726f6e675377616e20526f6f74204341820100300d06092a864886f70d01010b0500038201010024654ea5cc8c7cbbafbad69eaff4f721674dde9dfb2e8a9078fd92f612039abbc587663f7238f983f6aa93e762349ec9f302978648c8c5e77d46f3e4ebee5e9e12092d2021427a98aebee5fd5add449d07809ed0e7789a45084262f32850914aa7615a8573349ae5f814f56b977df9a2d600be52da9a94a103e01bae0c3e0872dd2c946f8a817a9964dc9751ffa3a00392d078db4b888ed8fdd6cc33646f9f6f38448231a764ea3761eea7a04d2c7bfa7cb8b1749a4cfa71bb6631987feedd9ee63a64386f22dd7ccebff69f510b0503e13394a3621190219566373343aca19500ab5ae4b1bc0700468b4b9773d7c15d645c7df237375fc8663fe86f9b775828'
);

INSERT INTO certificates (
   type, keytype, data
) VALUES ( /* C=CH, O=Linux strongSwan, OU=Sales, CN=dave@strongswan.org */
  1, 1, X'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'
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 1
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 2
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  1, 3
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 4 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 5 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  2, 6 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  3, 7 
);

INSERT INTO certificate_identity (
  certificate, identity
) VALUES (
  3, 8 
);

/* Private Keys */

INSERT INTO private_keys (
   type, data
) VALUES ( /* key of 'C=CH, O=Linux strongSwan, OU=Sales, CN=dave@strongswan.org' */
  1, X'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'
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 7 
);

INSERT INTO private_key_identity (
  private_key, identity
) VALUES (
  1, 8 
);

/* Configurations */

INSERT INTO ike_configs (
  local, remote
) VALUES (
  'PH_IP_DAVE', 'PH_IP_MOON'
);

INSERT INTO peer_configs (
  name, ike_cfg, local_id, remote_id
) VALUES (
  'home', 1, 7, 9 
);

INSERT INTO child_configs (
  name, updown
) VALUES (
  'home', '/usr/local/libexec/ipsec/_updown iptables'
);

INSERT INTO peer_config_child_config (
  peer_cfg, child_cfg
) VALUES (
  1, 1
);

INSERT INTO traffic_selectors (
  type, start_addr, end_addr
) VALUES ( /* 10.1.0.0/16 */
  7, X'0a010000', X'0a01ffff'
);

INSERT INTO traffic_selectors (
  type
) VALUES ( /* dynamic/32 */
  7
);

INSERT INTO child_config_traffic_selector (
  child_cfg, traffic_selector, kind
) VALUES (
  1, 1, 1
);

INSERT INTO child_config_traffic_selector (
	child_cfg, traffic_selector, kind
) VALUES (
  1, 2, 2
);

