/*
 *  This file is part of the WebKit open source project.
 *  This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "config.h"
#include "WebKitDOMreadonly.h"

#include "CSSImportRule.h"
#include "DOMObjectCache.h"
#include "Document.h"
#include "ExceptionCode.h"
#include "ExceptionCodeDescription.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMreadonlyPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_READONLY_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_DOM_TYPE_READONLY, WebKitDOMreadonlyPrivate)

typedef struct _WebKitDOMreadonlyPrivate {
    RefPtr<WebCore::readonly> coreObject;
} WebKitDOMreadonlyPrivate;

namespace WebKit {

WebKitDOMreadonly* kit(WebCore::readonly* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_READONLY(ret);

    return wrapreadonly(obj);
}

WebCore::readonly* core(WebKitDOMreadonly* request)
{
    return request ? static_cast<WebCore::readonly*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMreadonly* wrapreadonly(WebCore::readonly* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_READONLY(g_object_new(WEBKIT_DOM_TYPE_READONLY, "core-object", coreObject, nullptr));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMreadonly, webkit_dom_readonly, WEBKIT_DOM_TYPE_OBJECT)

static void webkit_dom_readonly_finalize(GObject* object)
{
    WebKitDOMreadonlyPrivate* priv = WEBKIT_DOM_READONLY_GET_PRIVATE(object);

    WebKit::DOMObjectCache::forget(priv->coreObject.get());

    priv->~WebKitDOMreadonlyPrivate();
    G_OBJECT_CLASS(webkit_dom_readonly_parent_class)->finalize(object);
}

static GObject* webkit_dom_readonly_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_readonly_parent_class)->constructor(type, constructPropertiesCount, constructProperties);

    WebKitDOMreadonlyPrivate* priv = WEBKIT_DOM_READONLY_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::readonly*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);

    return object;
}

static void webkit_dom_readonly_class_init(WebKitDOMreadonlyClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMreadonlyPrivate));
    gobjectClass->constructor = webkit_dom_readonly_constructor;
    gobjectClass->finalize = webkit_dom_readonly_finalize;
}

static void webkit_dom_readonly_init(WebKitDOMreadonly* request)
{
    WebKitDOMreadonlyPrivate* priv = WEBKIT_DOM_READONLY_GET_PRIVATE(request);
    new (priv) WebKitDOMreadonlyPrivate();
}

