/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import javax.swing.SwingUtilities;

public abstract class Worker<T>
implements Runnable {
    private T value;
    private Throwable error;

    @Override
    public final void run() {
        try {
            this.setValue(this.construct());
        }
        catch (Throwable throwable) {
            this.setError(throwable);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Worker.this.failed(Worker.this.getError());
                    Worker.this.finished();
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Worker.this.done(Worker.this.getValue());
                Worker.this.finished();
            }
        });
    }

    protected abstract T construct() throws Exception;

    protected void done(T t) {
    }

    protected void failed(Throwable throwable) {
        throwable.printStackTrace();
    }

    protected void finished() {
    }

    protected synchronized T getValue() {
        return this.value;
    }

    private synchronized void setValue(T t) {
        this.value = t;
    }

    protected synchronized Throwable getError() {
        return this.error;
    }

    private synchronized void setError(Throwable throwable) {
        this.error = throwable;
    }

    public void start() {
        new Thread(this).start();
    }
}

