// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/services/shared_criterion_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v0/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [SharedCriterionService.GetSharedCriterion][google.ads.googleads.v0.services.SharedCriterionService.GetSharedCriterion].
type GetSharedCriterionRequest struct {
	// The resource name of the shared criterion to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSharedCriterionRequest) Reset()         { *m = GetSharedCriterionRequest{} }
func (m *GetSharedCriterionRequest) String() string { return proto.CompactTextString(m) }
func (*GetSharedCriterionRequest) ProtoMessage()    {}
func (*GetSharedCriterionRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_shared_criterion_service_6b64ffbc632397a6, []int{0}
}
func (m *GetSharedCriterionRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSharedCriterionRequest.Unmarshal(m, b)
}
func (m *GetSharedCriterionRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSharedCriterionRequest.Marshal(b, m, deterministic)
}
func (dst *GetSharedCriterionRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSharedCriterionRequest.Merge(dst, src)
}
func (m *GetSharedCriterionRequest) XXX_Size() int {
	return xxx_messageInfo_GetSharedCriterionRequest.Size(m)
}
func (m *GetSharedCriterionRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSharedCriterionRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSharedCriterionRequest proto.InternalMessageInfo

func (m *GetSharedCriterionRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [SharedCriterionService.MutateSharedCriteria][google.ads.googleads.v0.services.SharedCriterionService.MutateSharedCriteria].
type MutateSharedCriteriaRequest struct {
	// The ID of the customer whose shared criteria are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The list of operations to perform on individual shared criteria.
	Operations           []*SharedCriterionOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *MutateSharedCriteriaRequest) Reset()         { *m = MutateSharedCriteriaRequest{} }
func (m *MutateSharedCriteriaRequest) String() string { return proto.CompactTextString(m) }
func (*MutateSharedCriteriaRequest) ProtoMessage()    {}
func (*MutateSharedCriteriaRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_shared_criterion_service_6b64ffbc632397a6, []int{1}
}
func (m *MutateSharedCriteriaRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateSharedCriteriaRequest.Unmarshal(m, b)
}
func (m *MutateSharedCriteriaRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateSharedCriteriaRequest.Marshal(b, m, deterministic)
}
func (dst *MutateSharedCriteriaRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateSharedCriteriaRequest.Merge(dst, src)
}
func (m *MutateSharedCriteriaRequest) XXX_Size() int {
	return xxx_messageInfo_MutateSharedCriteriaRequest.Size(m)
}
func (m *MutateSharedCriteriaRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateSharedCriteriaRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateSharedCriteriaRequest proto.InternalMessageInfo

func (m *MutateSharedCriteriaRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateSharedCriteriaRequest) GetOperations() []*SharedCriterionOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

// A single operation (create, remove) on an shared criterion.
type SharedCriterionOperation struct {
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*SharedCriterionOperation_Create
	//	*SharedCriterionOperation_Remove
	Operation            isSharedCriterionOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *SharedCriterionOperation) Reset()         { *m = SharedCriterionOperation{} }
func (m *SharedCriterionOperation) String() string { return proto.CompactTextString(m) }
func (*SharedCriterionOperation) ProtoMessage()    {}
func (*SharedCriterionOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_shared_criterion_service_6b64ffbc632397a6, []int{2}
}
func (m *SharedCriterionOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SharedCriterionOperation.Unmarshal(m, b)
}
func (m *SharedCriterionOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SharedCriterionOperation.Marshal(b, m, deterministic)
}
func (dst *SharedCriterionOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SharedCriterionOperation.Merge(dst, src)
}
func (m *SharedCriterionOperation) XXX_Size() int {
	return xxx_messageInfo_SharedCriterionOperation.Size(m)
}
func (m *SharedCriterionOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_SharedCriterionOperation.DiscardUnknown(m)
}

var xxx_messageInfo_SharedCriterionOperation proto.InternalMessageInfo

type isSharedCriterionOperation_Operation interface {
	isSharedCriterionOperation_Operation()
}

type SharedCriterionOperation_Create struct {
	Create *resources.SharedCriterion `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type SharedCriterionOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*SharedCriterionOperation_Create) isSharedCriterionOperation_Operation() {}

func (*SharedCriterionOperation_Remove) isSharedCriterionOperation_Operation() {}

func (m *SharedCriterionOperation) GetOperation() isSharedCriterionOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *SharedCriterionOperation) GetCreate() *resources.SharedCriterion {
	if x, ok := m.GetOperation().(*SharedCriterionOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *SharedCriterionOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*SharedCriterionOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*SharedCriterionOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _SharedCriterionOperation_OneofMarshaler, _SharedCriterionOperation_OneofUnmarshaler, _SharedCriterionOperation_OneofSizer, []interface{}{
		(*SharedCriterionOperation_Create)(nil),
		(*SharedCriterionOperation_Remove)(nil),
	}
}

func _SharedCriterionOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*SharedCriterionOperation)
	// operation
	switch x := m.Operation.(type) {
	case *SharedCriterionOperation_Create:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Create); err != nil {
			return err
		}
	case *SharedCriterionOperation_Remove:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("SharedCriterionOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _SharedCriterionOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*SharedCriterionOperation)
	switch tag {
	case 1: // operation.create
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.SharedCriterion)
		err := b.DecodeMessage(msg)
		m.Operation = &SharedCriterionOperation_Create{msg}
		return true, err
	case 3: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &SharedCriterionOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _SharedCriterionOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*SharedCriterionOperation)
	// operation
	switch x := m.Operation.(type) {
	case *SharedCriterionOperation_Create:
		s := proto.Size(x.Create)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *SharedCriterionOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for a shared criterion mutate.
type MutateSharedCriteriaResponse struct {
	// All results for the mutate.
	Results              []*MutateSharedCriterionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *MutateSharedCriteriaResponse) Reset()         { *m = MutateSharedCriteriaResponse{} }
func (m *MutateSharedCriteriaResponse) String() string { return proto.CompactTextString(m) }
func (*MutateSharedCriteriaResponse) ProtoMessage()    {}
func (*MutateSharedCriteriaResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_shared_criterion_service_6b64ffbc632397a6, []int{3}
}
func (m *MutateSharedCriteriaResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateSharedCriteriaResponse.Unmarshal(m, b)
}
func (m *MutateSharedCriteriaResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateSharedCriteriaResponse.Marshal(b, m, deterministic)
}
func (dst *MutateSharedCriteriaResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateSharedCriteriaResponse.Merge(dst, src)
}
func (m *MutateSharedCriteriaResponse) XXX_Size() int {
	return xxx_messageInfo_MutateSharedCriteriaResponse.Size(m)
}
func (m *MutateSharedCriteriaResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateSharedCriteriaResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateSharedCriteriaResponse proto.InternalMessageInfo

func (m *MutateSharedCriteriaResponse) GetResults() []*MutateSharedCriterionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the shared criterion mutate.
type MutateSharedCriterionResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateSharedCriterionResult) Reset()         { *m = MutateSharedCriterionResult{} }
func (m *MutateSharedCriterionResult) String() string { return proto.CompactTextString(m) }
func (*MutateSharedCriterionResult) ProtoMessage()    {}
func (*MutateSharedCriterionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_shared_criterion_service_6b64ffbc632397a6, []int{4}
}
func (m *MutateSharedCriterionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateSharedCriterionResult.Unmarshal(m, b)
}
func (m *MutateSharedCriterionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateSharedCriterionResult.Marshal(b, m, deterministic)
}
func (dst *MutateSharedCriterionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateSharedCriterionResult.Merge(dst, src)
}
func (m *MutateSharedCriterionResult) XXX_Size() int {
	return xxx_messageInfo_MutateSharedCriterionResult.Size(m)
}
func (m *MutateSharedCriterionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateSharedCriterionResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateSharedCriterionResult proto.InternalMessageInfo

func (m *MutateSharedCriterionResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetSharedCriterionRequest)(nil), "google.ads.googleads.v0.services.GetSharedCriterionRequest")
	proto.RegisterType((*MutateSharedCriteriaRequest)(nil), "google.ads.googleads.v0.services.MutateSharedCriteriaRequest")
	proto.RegisterType((*SharedCriterionOperation)(nil), "google.ads.googleads.v0.services.SharedCriterionOperation")
	proto.RegisterType((*MutateSharedCriteriaResponse)(nil), "google.ads.googleads.v0.services.MutateSharedCriteriaResponse")
	proto.RegisterType((*MutateSharedCriterionResult)(nil), "google.ads.googleads.v0.services.MutateSharedCriterionResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SharedCriterionServiceClient is the client API for SharedCriterionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SharedCriterionServiceClient interface {
	// Returns the requested shared criterion in full detail.
	GetSharedCriterion(ctx context.Context, in *GetSharedCriterionRequest, opts ...grpc.CallOption) (*resources.SharedCriterion, error)
	// Creates or removes shared criteria. Operation statuses are returned.
	MutateSharedCriteria(ctx context.Context, in *MutateSharedCriteriaRequest, opts ...grpc.CallOption) (*MutateSharedCriteriaResponse, error)
}

type sharedCriterionServiceClient struct {
	cc *grpc.ClientConn
}

func NewSharedCriterionServiceClient(cc *grpc.ClientConn) SharedCriterionServiceClient {
	return &sharedCriterionServiceClient{cc}
}

func (c *sharedCriterionServiceClient) GetSharedCriterion(ctx context.Context, in *GetSharedCriterionRequest, opts ...grpc.CallOption) (*resources.SharedCriterion, error) {
	out := new(resources.SharedCriterion)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.SharedCriterionService/GetSharedCriterion", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sharedCriterionServiceClient) MutateSharedCriteria(ctx context.Context, in *MutateSharedCriteriaRequest, opts ...grpc.CallOption) (*MutateSharedCriteriaResponse, error) {
	out := new(MutateSharedCriteriaResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v0.services.SharedCriterionService/MutateSharedCriteria", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SharedCriterionServiceServer is the server API for SharedCriterionService service.
type SharedCriterionServiceServer interface {
	// Returns the requested shared criterion in full detail.
	GetSharedCriterion(context.Context, *GetSharedCriterionRequest) (*resources.SharedCriterion, error)
	// Creates or removes shared criteria. Operation statuses are returned.
	MutateSharedCriteria(context.Context, *MutateSharedCriteriaRequest) (*MutateSharedCriteriaResponse, error)
}

func RegisterSharedCriterionServiceServer(s *grpc.Server, srv SharedCriterionServiceServer) {
	s.RegisterService(&_SharedCriterionService_serviceDesc, srv)
}

func _SharedCriterionService_GetSharedCriterion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSharedCriterionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SharedCriterionServiceServer).GetSharedCriterion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.SharedCriterionService/GetSharedCriterion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SharedCriterionServiceServer).GetSharedCriterion(ctx, req.(*GetSharedCriterionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SharedCriterionService_MutateSharedCriteria_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateSharedCriteriaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SharedCriterionServiceServer).MutateSharedCriteria(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v0.services.SharedCriterionService/MutateSharedCriteria",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SharedCriterionServiceServer).MutateSharedCriteria(ctx, req.(*MutateSharedCriteriaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SharedCriterionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v0.services.SharedCriterionService",
	HandlerType: (*SharedCriterionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetSharedCriterion",
			Handler:    _SharedCriterionService_GetSharedCriterion_Handler,
		},
		{
			MethodName: "MutateSharedCriteria",
			Handler:    _SharedCriterionService_MutateSharedCriteria_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v0/services/shared_criterion_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/services/shared_criterion_service.proto", fileDescriptor_shared_criterion_service_6b64ffbc632397a6)
}

var fileDescriptor_shared_criterion_service_6b64ffbc632397a6 = []byte{
	// 538 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0x3f, 0x6f, 0xd3, 0x40,
	0x14, 0xc0, 0x71, 0x22, 0x05, 0xf5, 0x02, 0xcb, 0x09, 0xa1, 0x90, 0x56, 0x22, 0x32, 0x0c, 0x55,
	0x86, 0xb3, 0xe5, 0x2e, 0x51, 0xaa, 0x14, 0x12, 0x86, 0x14, 0x89, 0x3f, 0x95, 0x2b, 0x15, 0xa9,
	0x8a, 0x14, 0x1d, 0xf6, 0x93, 0xb1, 0x14, 0xfb, 0xcc, 0xdd, 0x39, 0x0c, 0x55, 0x17, 0xbe, 0x00,
	0x03, 0x1b, 0x23, 0x23, 0x23, 0x5f, 0x80, 0x9d, 0x15, 0x31, 0xb1, 0xf2, 0x41, 0xd0, 0xf9, 0x7c,
	0xa1, 0x0d, 0xb6, 0x82, 0xb2, 0x3d, 0xfb, 0xde, 0xfb, 0xbd, 0xff, 0x0f, 0x3d, 0x8a, 0x18, 0x8b,
	0x16, 0xe0, 0xd0, 0x50, 0x38, 0x5a, 0x54, 0xd2, 0xd2, 0x75, 0x04, 0xf0, 0x65, 0x1c, 0x80, 0x70,
	0xc4, 0x1b, 0xca, 0x21, 0x9c, 0x07, 0x3c, 0x96, 0xc0, 0x63, 0x96, 0xce, 0xcb, 0x17, 0x92, 0x71,
	0x26, 0x19, 0xee, 0x69, 0x2b, 0x42, 0x43, 0x41, 0x56, 0x00, 0xb2, 0x74, 0x89, 0x01, 0x74, 0x07,
	0x75, 0x2e, 0x38, 0x08, 0x96, 0xf3, 0x2a, 0x1f, 0x9a, 0xdd, 0xdd, 0x33, 0x96, 0x59, 0xec, 0xd0,
	0x34, 0x65, 0x92, 0xca, 0x98, 0xa5, 0x42, 0xbf, 0xda, 0x8f, 0xd1, 0xbd, 0x29, 0xc8, 0xd3, 0xc2,
	0xf4, 0x89, 0xb1, 0xf4, 0xe1, 0x6d, 0x0e, 0x42, 0xe2, 0x07, 0xe8, 0xb6, 0xc1, 0xcf, 0x53, 0x9a,
	0x40, 0xc7, 0xea, 0x59, 0xfb, 0x3b, 0xfe, 0x2d, 0xf3, 0xf3, 0x05, 0x4d, 0xc0, 0xfe, 0x64, 0xa1,
	0xdd, 0xe7, 0xb9, 0xa4, 0x12, 0xae, 0x51, 0xa8, 0x81, 0xdc, 0x47, 0xed, 0x20, 0x17, 0x92, 0x25,
	0xc0, 0xe7, 0x71, 0x58, 0x22, 0x90, 0xf9, 0xf5, 0x34, 0xc4, 0xe7, 0x08, 0xb1, 0x0c, 0xb8, 0x0e,
	0xab, 0xd3, 0xe8, 0x35, 0xf7, 0xdb, 0xde, 0x90, 0x6c, 0xaa, 0x08, 0x59, 0x8b, 0xf9, 0xa5, 0x41,
	0xf8, 0x57, 0x68, 0xf6, 0x07, 0x0b, 0x75, 0xea, 0x14, 0xf1, 0x33, 0xd4, 0x0a, 0x38, 0x50, 0xa9,
	0xf3, 0x6a, 0x7b, 0x5e, 0xad, 0xd3, 0x55, 0x91, 0xd7, 0xbd, 0x1e, 0xdf, 0xf0, 0x4b, 0x06, 0xee,
	0xa0, 0x16, 0x87, 0x84, 0x2d, 0xa1, 0xd3, 0x54, 0x29, 0xaa, 0x17, 0xfd, 0x3d, 0x69, 0xa3, 0x9d,
	0x55, 0x48, 0xf6, 0x3b, 0xb4, 0x57, 0x5d, 0x2d, 0x91, 0xb1, 0x54, 0x00, 0x7e, 0x85, 0x6e, 0x72,
	0x10, 0xf9, 0x42, 0x9a, 0x52, 0x8c, 0x36, 0x97, 0xa2, 0x02, 0xa8, 0x9a, 0xa8, 0x28, 0xbe, 0xa1,
	0xd9, 0x93, 0xca, 0x36, 0x19, 0xbd, 0xff, 0xea, 0xb5, 0xf7, 0xb5, 0x89, 0xee, 0xae, 0x99, 0x9f,
	0xea, 0x20, 0xf0, 0x37, 0x0b, 0xe1, 0x7f, 0x27, 0x09, 0x1f, 0x6e, 0x8e, 0xbe, 0x76, 0xfe, 0xba,
	0x5b, 0x34, 0xc4, 0x1e, 0xbc, 0xff, 0xf1, 0xfb, 0x63, 0xc3, 0xc3, 0xae, 0x5a, 0x8e, 0x8b, 0x6b,
	0x29, 0x8d, 0xcc, 0xd0, 0x09, 0xa7, 0x5f, 0x6e, 0x8b, 0x29, 0xbf, 0xd3, 0xbf, 0xc4, 0x3f, 0x2d,
	0x74, 0xa7, 0xaa, 0x35, 0x78, 0xbb, 0x0e, 0x98, 0x05, 0xe8, 0x1e, 0x6d, 0x6b, 0xae, 0x27, 0xc2,
	0x3e, 0x2a, 0x32, 0x1a, 0xd8, 0x07, 0x2a, 0xa3, 0xbf, 0x29, 0x5c, 0x5c, 0xd9, 0xaa, 0x51, 0xff,
	0x72, 0x2d, 0xa1, 0x61, 0x52, 0x20, 0x87, 0x56, 0x7f, 0xf2, 0xcb, 0x42, 0x0f, 0x03, 0x96, 0x6c,
	0x8c, 0x62, 0xb2, 0x5b, 0xdd, 0xda, 0x13, 0x75, 0x28, 0x4e, 0xac, 0xf3, 0xe3, 0x12, 0x10, 0xb1,
	0x05, 0x4d, 0x23, 0xc2, 0x78, 0xe4, 0x44, 0x90, 0x16, 0x67, 0xc4, 0x9c, 0xa4, 0x2c, 0x16, 0xf5,
	0x47, 0xf0, 0xd0, 0x08, 0x9f, 0x1b, 0xcd, 0xe9, 0x78, 0xfc, 0xa5, 0xd1, 0x9b, 0x6a, 0xe0, 0x38,
	0x14, 0x44, 0x8b, 0x4a, 0x3a, 0x73, 0x49, 0xe9, 0x58, 0x7c, 0x37, 0x2a, 0xb3, 0x71, 0x28, 0x66,
	0x2b, 0x95, 0xd9, 0x99, 0x3b, 0x33, 0x2a, 0xaf, 0x5b, 0x45, 0x00, 0x07, 0x7f, 0x02, 0x00, 0x00,
	0xff, 0xff, 0x08, 0x0f, 0x51, 0xc4, 0x84, 0x05, 0x00, 0x00,
}
