/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.CPointer;
import com.opera.FindClassThread;
import com.opera.InvocationThread;
import com.opera.JSObject;
import com.opera.LC3Resolver;
import com.opera.LiveConnectPrivilegedActions;
import com.opera.MethodLookupThread;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import netscape.plugin.Plugin;

class MethodResolver {
    static Class jsobjectClass;
    static Class objectClass;
    static Class stringClass;
    static Class classClass;
    static Class doubleClass;
    static Class booleanClass;
    static final int JSTYPE_NOTFOUND = 0;
    static final int JSTYPE_NUMBER = 1;
    static final int JSTYPE_BOOLEAN = 2;
    static final int JSTYPE_OBJECT = 3;
    static final int JSTYPE_JAVAARRAY = 4;
    static final int JSTYPE_JAVAOBJECT = 5;
    static final int JSTYPE_STATIC = 8;
    static final int JSTYPE_FINAL = 16;
    static final int JM_NOTFOUND = 0;
    static final int JM_NONSTATIC = 1;
    static final int JM_STATIC = 2;

    MethodResolver() {
    }

    static boolean findClass(String name, JSObject resumer, String origin, CPointer docPtr) {
        try {
            FindClassThread findThread = new FindClassThread(name, resumer, origin, docPtr);
            findThread.start();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }

    static String findMethod(Class clazz, String name, String paramString, Object[] unwrappedParams, boolean bstatic) {
        if (name.equals("<init>")) {
            Constructor cons = LC3Resolver.resolveConstructor(clazz, paramString, unwrappedParams, bstatic);
            if (cons != null) {
                return MethodResolver.makeSignature(null, cons.getParameterTypes());
            }
        } else {
            Method meth = LC3Resolver.resolveMethod(clazz, name, paramString, unwrappedParams, bstatic);
            if (meth != null) {
                return MethodResolver.makeSignature(meth.getReturnType(), meth.getParameterTypes());
            }
        }
        return null;
    }

    static String makeSignature(Class retType, Class[] paramTypes) {
        String ret = new String("(");
        for (int i = 0; i < paramTypes.length; ++i) {
            if (paramTypes[i] == null) continue;
            ret = ret + MethodResolver.getTypeSignature(paramTypes[i]);
        }
        ret = ret + ")";
        ret = retType != null ? ret + MethodResolver.getTypeSignature(retType) : ret + "V";
        return ret;
    }

    static boolean hasMethod(Class clazz, String name, boolean isStatic, JSObject resumer) {
        try {
            MethodLookupThread lookup = new MethodLookupThread(clazz, name, isStatic, resumer);
            lookup.start();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }

    static int hasMethod(Class clazz, String name, boolean isStatic) {
        Method[] meths = clazz.getMethods();
        int ret = 0;
        for (int i = 0; i < meths.length; ++i) {
            if (!name.equals(meths[i].getName()) || isStatic && !Modifier.isStatic(meths[i].getModifiers())) continue;
            ret |= Modifier.isStatic(meths[i].getModifiers()) ? 2 : 1;
        }
        return ret;
    }

    static int hasField(Class clazz, String name, boolean isStatic) {
        try {
            Field field = clazz.getField(name);
            if (!isStatic || Modifier.isStatic(field.getModifiers())) {
                Class<?> fClass = field.getType();
                return MethodResolver.classToJSType(fClass) | (Modifier.isStatic(field.getModifiers()) ? 8 : 0) | (Modifier.isFinal(field.getModifiers()) ? 16 : 0);
            }
            return 0;
        }
        catch (NoSuchFieldException x) {
            return 0;
        }
    }

    static int classToJSType(Class cls) {
        if (cls.equals(Byte.TYPE) || cls.equals(Character.TYPE) || cls.equals(Short.TYPE) || cls.equals(Integer.TYPE) || cls.equals(Long.TYPE) || cls.equals(Float.TYPE) || cls.equals(Double.TYPE)) {
            return 1;
        }
        if (cls.equals(Boolean.TYPE)) {
            return 2;
        }
        if (cls.equals(jsobjectClass)) {
            return 3;
        }
        if (cls.isArray()) {
            return 4;
        }
        return 5;
    }

    static String getFieldTypeName(Class clazz, String name, boolean isStatic) {
        try {
            Field field = clazz.getField(name);
            if (!isStatic || Modifier.isStatic(field.getModifiers())) {
                return MethodResolver.getTypeSignature(field.getType());
            }
            return null;
        }
        catch (NoSuchFieldException x) {
            return null;
        }
    }

    static double getFieldDouble(Class clazz, String name, Object obj, String origin, CPointer docPtr) {
        try {
            Field field = clazz.getField(name);
            Object val = LiveConnectPrivilegedActions.getField(field, obj, origin, docPtr);
            if (val instanceof Character) {
                return ((Character)val).charValue();
            }
            return ((Number)val).doubleValue();
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            return 0.0;
        }
    }

    static boolean getFieldBoolean(Class clazz, String name, Object obj, String origin, CPointer docPtr) {
        try {
            Field field = clazz.getField(name);
            Object val = LiveConnectPrivilegedActions.getField(field, obj, origin, docPtr);
            return (Boolean)val;
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            return false;
        }
    }

    static Object getFieldObject(Class clazz, String name, Object obj, String origin, CPointer docPtr) {
        try {
            Field field = clazz.getField(name);
            return LiveConnectPrivilegedActions.getField(field, obj, origin, docPtr);
        }
        catch (Exception x) {
            x.printStackTrace(System.err);
            return null;
        }
    }

    static boolean isAssignableFrom(String varSignature, Object obj) {
        try {
            Class varClass = MethodResolver.getTypeFromSignature(varSignature);
            return varClass.isAssignableFrom(obj.getClass());
        }
        catch (Exception x) {
            return false;
        }
    }

    private static Class getTypeFromSignature(String sig) {
        try {
            switch (sig.charAt(0)) {
                case 'L': {
                    String tmpStr = sig.replace('/', '.');
                    return Class.forName(tmpStr.substring(1, tmpStr.indexOf(59)));
                }
                case '[': {
                    return Class.forName(sig);
                }
                case 'B': {
                    return Byte.TYPE;
                }
                case 'C': {
                    return Character.TYPE;
                }
                case 'D': {
                    return Double.TYPE;
                }
                case 'F': {
                    return Float.TYPE;
                }
                case 'I': {
                    return Integer.TYPE;
                }
                case 'J': {
                    return Long.TYPE;
                }
                case 'S': {
                    return Short.TYPE;
                }
                case 'V': {
                    return Void.TYPE;
                }
                case 'Z': {
                    return Boolean.TYPE;
                }
            }
            return null;
        }
        catch (ClassNotFoundException x) {
            return null;
        }
    }

    private static String getTypeSignature(Class type) {
        if (type.isPrimitive()) {
            if (type.equals(Boolean.TYPE)) {
                return new String("Z");
            }
            if (type.equals(Byte.TYPE)) {
                return new String("B");
            }
            if (type.equals(Character.TYPE)) {
                return new String("C");
            }
            if (type.equals(Double.TYPE)) {
                return new String("D");
            }
            if (type.equals(Float.TYPE)) {
                return new String("F");
            }
            if (type.equals(Integer.TYPE)) {
                return new String("I");
            }
            if (type.equals(Long.TYPE)) {
                return new String("J");
            }
            if (type.equals(Short.TYPE)) {
                return new String("S");
            }
            if (type.equals(Void.TYPE)) {
                return new String("V");
            }
            return null;
        }
        if (type.isArray()) {
            return type.getName().replace('.', '/');
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    private static String getJRIStubName(Class plugClass, Method meth) {
        return "native_" + plugClass.getName().replace('.', '_') + "_" + meth.getName();
    }

    private static int nativeMethodCount(Method[] methods) {
        int ret = 0;
        for (int i = 0; i < methods.length; ++i) {
            if (!Modifier.isNative(methods[i].getModifiers())) continue;
            ++ret;
        }
        return ret;
    }

    private static String[] getNativeMethods(Class pluginClass) {
        Method[] methods = pluginClass.getDeclaredMethods();
        int count = MethodResolver.nativeMethodCount(methods);
        if (count > 0) {
            String[] retArray = new String[count * 2];
            int idx = 0;
            for (int i = 0; i < methods.length; ++i) {
                if (!Modifier.isNative(methods[i].getModifiers())) continue;
                String nameAndSig = methods[i].getName() + "(";
                Class<?>[] parmTyps = methods[i].getParameterTypes();
                for (int j = 0; j < parmTyps.length; ++j) {
                    nameAndSig = nameAndSig + MethodResolver.getTypeSignature(parmTyps[j]);
                }
                nameAndSig = nameAndSig + ")";
                nameAndSig = nameAndSig + MethodResolver.getTypeSignature(methods[i].getReturnType());
                String stubName = MethodResolver.getJRIStubName(pluginClass, methods[i]);
                retArray[idx++] = nameAndSig;
                retArray[idx++] = stubName;
            }
            return retArray;
        }
        return null;
    }

    private static Object newObject(Constructor cons, Object[] params, String origin, CPointer docPtr) throws Throwable {
        try {
            return LiveConnectPrivilegedActions.newObject(cons, params, origin, docPtr);
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
            while (ex.getCause() != null) {
                ex = ex.getCause();
            }
            throw ex;
        }
    }

    private static boolean invoke(Object obj, Method meth, Object[] params, JSObject resumer, String origin, CPointer docPtr) {
        try {
            InvocationThread invocation = new InvocationThread(obj, meth, params, resumer, origin, docPtr);
            if (obj instanceof Plugin) {
                invocation.run();
            } else {
                invocation.start();
            }
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            return false;
        }
    }

    static {
        try {
            jsobjectClass = Class.forName("netscape.javascript.JSObject");
            objectClass = Class.forName("java.lang.Object");
            stringClass = Class.forName("java.lang.String");
            classClass = Class.forName("java.lang.Class");
            doubleClass = Class.forName("java.lang.Double");
            booleanClass = Class.forName("java.lang.Boolean");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

