/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppletPanel;
import com.opera.ConsoleOStream;
import java.awt.Button;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintStream;

class JavaConsole
extends Frame
implements WindowListener,
ActionListener,
KeyListener {
    private TextArea outputArea = new TextArea();
    private Button but;

    JavaConsole(String title) {
        super(title);
        this.add(this.outputArea);
        this.but = new Button("Clear");
        this.but.addActionListener(this);
        this.add("South", this.but);
        this.pack();
        this.outputArea.setVisible(true);
        this.outputArea.setEditable(false);
        this.setSize(300, 250);
        PrintStream ostr = new PrintStream(new ConsoleOStream(this.outputArea));
        System.setOut(ostr);
        System.setErr(ostr);
        this.addWindowListener(this);
        this.outputArea.addKeyListener(this);
        this.but.addKeyListener(this);
        this.printInfo();
    }

    public void keyTyped(KeyEvent ev) {
    }

    public void keyPressed(KeyEvent ev) {
        if (ev.getModifiers() != 0) {
            return;
        }
        switch (ev.getKeyCode()) {
            case 67: {
                this.outputArea.setText(null);
                this.printInfo();
                break;
            }
            case 70: {
                System.out.print("Running finalization ... ");
                System.runFinalization();
                System.out.println("Done.");
                break;
            }
            case 71: {
                System.out.print("Running garbage collection ... ");
                System.gc();
                System.out.println("Done.");
                break;
            }
            case 72: {
                this.printHelp();
                break;
            }
            case 76: {
                AppletPanel.printClassLoaders();
                break;
            }
            case 77: {
                long freeMemory = Runtime.getRuntime().freeMemory() / 1024L;
                long totalMemory = Runtime.getRuntime().totalMemory() / 1024L;
                System.out.println("Total memory: " + totalMemory + "K  Free memory: " + freeMemory + "K");
                break;
            }
            case 84: {
                StringBuffer buffer = new StringBuffer();
                buffer.append("Dump thread list ...\n");
                Thread t = Thread.currentThread();
                ThreadGroup tg = t.getThreadGroup();
                this.dumpThreadGroup(tg, buffer);
                buffer.append("Done.");
                System.out.println(buffer.toString());
                break;
            }
            case 88: {
                System.out.print("Clearing classloader cache ... ");
                AppletPanel.clearClassLoaderCache();
                System.out.println("Done.");
                break;
            }
        }
    }

    private void printInfo() {
        System.out.println("-- " + System.getProperty("browser.opera.consoleString") + " --\n");
        System.out.println("Java vendor: " + System.getProperty("java.vendor"));
        System.out.println("Java version: " + System.getProperty("java.version"));
        System.out.println("\ntype 'h' for help\n\n--");
    }

    private void printHelp() {
        System.out.println("\nCommands:\n----------------------------------------");
        System.out.println("c - clear console");
        System.out.println("f - run finalization");
        System.out.println("g - run garbage collection");
        System.out.println("h - help");
        System.out.println("l - list cached classloaders");
        System.out.println("m - memory usage");
        System.out.println("t - dump threads");
        System.out.println("x - clear classloader cache\n");
    }

    public void keyReleased(KeyEvent ev) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.but) {
            this.outputArea.setText(null);
            this.printInfo();
        }
    }

    private void dumpThreadGroup(ThreadGroup tg, StringBuffer sb) {
        if (tg != null) {
            try {
                if (tg.activeCount() == 0 && tg.activeGroupCount() == 0 && !tg.isDestroyed()) {
                    tg.destroy();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            sb.append("Group " + tg.getName());
            sb.append(",ac=" + tg.activeCount());
            sb.append(",agc=" + tg.activeGroupCount());
            sb.append(",pri=" + tg.getMaxPriority());
            if (tg.isDestroyed()) {
                sb.append(",destoyed");
            }
            if (tg.isDaemon()) {
                sb.append(",daemon");
            }
            sb.append("\n");
            Thread[] tt = new Thread[1000];
            tg.enumerate(tt, false);
            for (int i = 0; i < tt.length; ++i) {
                if (tt[i] == null) continue;
                sb.append("    ");
                sb.append(tt[i].getName());
                sb.append(",");
                sb.append(tt[i].getPriority());
                if (tt[i].isAlive()) {
                    sb.append(",alive");
                } else {
                    sb.append(",not alive");
                }
                if (tt[i].isDaemon()) {
                    sb.append(",daemon");
                }
                if (tt[i].isInterrupted()) {
                    sb.append(",interrupted");
                }
                sb.append("\n");
            }
            ThreadGroup[] tgArray = new ThreadGroup[1000];
            tg.enumerate(tgArray, false);
            for (int i = 0; i < tgArray.length; ++i) {
                if (tgArray[i] == null) continue;
                this.dumpThreadGroup(tgArray[i], sb);
            }
        }
    }
}

