/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.URLConnection;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Hashtable;

class InputStream
extends java.io.InputStream {
    private static final int BUFFER_SIZE = 32768;
    private int protocolResponse = -1;
    private byte[] buffer = new byte[32768];
    private int nextRead = 0;
    private int lastAvail = -1;
    private int available = 0;
    private int totalInput = 0;
    private int contentLen = -1;
    private int streamId = -1;
    private boolean headerLoaded = false;
    private boolean eofState = false;
    protected Hashtable headerFields = new Hashtable();
    private URLConnection connection;

    protected InputStream(URLConnection conn) {
        this.connection = conn;
    }

    public int getResponse() {
        return this.protocolResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        InputStream inputStream = this;
        synchronized (inputStream) {
            return this.available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        InputStream inputStream = this;
        synchronized (inputStream) {
            while (this.available == 0 && !this.eofState) {
                try {
                    this.starving();
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.eofState = true;
                    this.available = 0;
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
            }
            if (this.available == 0 && this.eofState) {
                this.buffer = null;
                return -1;
            }
            --this.available;
            if (this.nextRead == 32768) {
                this.nextRead = 0;
            }
            return 0xFF & this.buffer[this.nextRead++];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void headerLoaded(int size, int response) {
        InputStream inputStream = this;
        synchronized (inputStream) {
            if (size == 0) {
                size = -1;
            }
            this.contentLen = size;
            this.protocolResponse = response;
            this.headerLoaded = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getContentLength() {
        InputStream inputStream = this;
        synchronized (inputStream) {
            while (!this.headerLoaded) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.contentLen;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEOF() {
        InputStream inputStream = this;
        synchronized (inputStream) {
            this.eofState = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalStream() {
        InputStream inputStream = this;
        synchronized (inputStream) {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addInput(byte[] data) {
        int cpLen = 0;
        int cpLen2 = 0;
        InputStream inputStream = this;
        synchronized (inputStream) {
            try {
                if (this.eofState) {
                    this.notifyAll();
                    return -1;
                }
                if (data.length > 0 && this.available < 32768) {
                    int maxCopySize = 32768 - this.available;
                    if (this.lastAvail < Short.MAX_VALUE) {
                        cpLen = data.length < 32768 - this.lastAvail ? data.length : 32768 - this.lastAvail - 1;
                        if (cpLen > maxCopySize) {
                            cpLen = maxCopySize;
                        }
                        System.arraycopy(data, 0, this.buffer, this.lastAvail + 1, cpLen);
                    }
                    if ((maxCopySize -= cpLen) > 0) {
                        cpLen2 = data.length - cpLen > maxCopySize ? maxCopySize : data.length - cpLen;
                        System.arraycopy(data, cpLen, this.buffer, 0, cpLen2);
                    }
                    this.lastAvail = (this.lastAvail + cpLen + cpLen2) % 32768;
                }
                this.notifyAll();
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                ex.printStackTrace(System.err);
            }
            this.available += cpLen + cpLen2;
            this.totalInput += cpLen + cpLen2;
            return cpLen + cpLen2;
        }
    }

    private native void starving();

    private void addHeader(String name, String value) {
        this.headerFields.put(name.toLowerCase(), value);
    }

    protected boolean isHeaderLoaded() {
        return this.headerLoaded;
    }

    protected native void stopLoading();

    private int writeReady() {
        return 32768 - this.available;
    }

    private void redirect(String newUrlString) {
        this.connection.redirect(newUrlString);
    }
}

