/*
 * Decompiled with CFR 0.152.
 */
package com.opera;

import com.opera.AppletClassLoader;
import com.opera.AppletContext;
import com.opera.AppletContextManager;
import com.opera.AppletEvent;
import com.opera.AppletEventQueue;
import com.opera.CPointer;
import java.applet.Applet;
import java.applet.AppletStub;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Panel;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class AppletPanel
extends Panel
implements AppletStub,
Runnable {
    private Frame frame;
    private AppletEventQueue eventQueue = new AppletEventQueue();
    public static final int APPLET_DISPOSE = 0;
    public static final int APPLET_LOAD = 1;
    public static final int APPLET_INIT = 2;
    public static final int APPLET_START = 3;
    public static final int APPLET_STOP = 4;
    public static final int APPLET_DESTROY = 5;
    public static final int APPLET_RESIZE = 6;
    public static final int APPLET_QUIT = 7;
    private int appletState = 0;
    private static final int STATUS_LOADING = 0;
    private static final int STATUS_LOADED = 1;
    private static final int STATUS_NOTFOUND = 2;
    private static final int STATUS_CLASSFORMATERROR = 3;
    private static final int STATUS_COULDNOTINSTANTIATE = 4;
    private static final int STATUS_CRASHED = 5;
    private static final int STATUS_STOPPED = 6;
    private static final int STATUS_DESTROYED = 7;
    private static final int STATUS_DISPOSED = 8;
    private static final int STATUS_SUPPRESSED = 9;
    private static final int STATUS_RUNNING = 10;
    private static final String[] statusMessages = new String[]{"Loading Applet...", "Applet loaded.", "Applet not found.", "Invalid bytecode.", "Could not instantiate.", "Applet crashed.", "Applet stopped.", "Applet destroyed.", "Applet disposed.", "Applet suppressed.", null};
    private static Font statusFont = new Font("sans-serif", 0, 11);
    private int status = 0;
    private boolean dontLoad = false;
    private Thread handlerThread;
    private Thread loaderThread;
    private Thread destroyThread;
    private AppletClassLoader appletLoader;
    private AppletContext appletContext;
    private CPointer inlineElement = null;
    private boolean suppressExternal = false;
    private URL codeBase;
    private URL documentBase;
    private URL realDocBase;
    private String archive;
    private String archive_ex;
    private Hashtable appletParams;
    private Hashtable appletAttributes;
    private final int defaultWidth = 150;
    private final int defaultHeight = 150;
    private Dimension currentSize = new Dimension(150, 150);
    private Applet applet;
    private static Hashtable classLoaders = new Hashtable();
    private static int noRefMax = 10;
    private static Vector noRefLoaders = new Vector();

    public Applet getApplet() {
        return this.applet;
    }

    protected boolean usesLoader(AppletClassLoader loader) {
        return this.appletLoader == loader;
    }

    private String getClassName() {
        String className = null;
        String classFilename = this.getParameter("java_code");
        if (classFilename == null) {
            classFilename = this.getParameter("code");
        }
        if (classFilename != null) {
            int fnameLen = (classFilename = classFilename.replace('/', '.').trim()).length();
            className = fnameLen > 6 && classFilename.startsWith(".class", fnameLen - 6) ? classFilename.substring(0, fnameLen - 6) : classFilename;
        }
        return className;
    }

    void sendEvent(AppletEvent ev) {
        this.eventQueue.enqueue(ev);
        if (ev.getId() == 7) {
            if (this.handlerThread != null) {
                try {
                    this.handlerThread.join(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.appletLoader != null) {
                this.appletLoader.release();
                this.appletLoader = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AppletEvent getNextEvent() throws InterruptedException {
        while (this.eventQueue.isEmpty()) {
            AppletEventQueue appletEventQueue = this.eventQueue;
            synchronized (appletEventQueue) {
                this.eventQueue.wait();
            }
        }
        return this.eventQueue.dequeue();
    }

    private int getWidthParam() {
        String wstr;
        if (this.appletAttributes != null && (wstr = (String)this.appletAttributes.get("width")) != null) {
            return new Integer(wstr);
        }
        return 150;
    }

    private int getHeightParam() {
        String hstr;
        if (this.appletAttributes != null && (hstr = (String)this.appletAttributes.get("height")) != null) {
            return new Integer(hstr);
        }
        return 150;
    }

    AppletPanel(String[] attrKeys, String[] attrValues, String[] paramKeys, String[] paramValues, String docBase, CPointer docPtr, CPointer inlineElm, boolean suppress) {
        String file;
        int i;
        String keyLower;
        int i2;
        this.inlineElement = inlineElm;
        this.suppressExternal = suppress;
        this.appletContext = AppletContextManager.getContext(docPtr);
        this.appletContext.addPanel(this);
        if (docBase.startsWith("file://localhost/")) {
            docBase = "file://" + docBase.substring(16);
        }
        this.appletParams = new Hashtable();
        for (i2 = 0; i2 < paramKeys.length; ++i2) {
            keyLower = paramKeys[i2].toLowerCase();
            if (this.appletParams.containsKey(keyLower)) continue;
            this.appletParams.put(keyLower, paramValues[i2]);
        }
        this.appletAttributes = new Hashtable();
        for (i2 = 0; i2 < attrKeys.length; ++i2) {
            keyLower = attrKeys[i2].toLowerCase();
            if (this.appletAttributes.containsKey(keyLower)) continue;
            this.appletAttributes.put(keyLower, attrValues[i2]);
        }
        try {
            this.documentBase = new URL(docBase);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        String cbase = this.getParameter("java_codebase");
        if (cbase == null) {
            cbase = this.getParameter("codebase");
        }
        if (cbase != null) {
            if (cbase.startsWith("file://localhost/")) {
                cbase = "file://" + cbase.substring(16);
            }
            if (!cbase.endsWith("/")) {
                cbase = cbase + "/";
            }
            try {
                this.codeBase = new URL(this.documentBase, cbase);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if ((i = (file = this.documentBase.getFile()).lastIndexOf(47)) >= 0 && i < file.length() - 1) {
            try {
                this.realDocBase = new URL(this.documentBase, file.substring(0, i + 1));
            }
            catch (MalformedURLException e) {
                e.printStackTrace(System.err);
            }
        }
        if (this.realDocBase == null) {
            this.realDocBase = this.documentBase;
        }
        if (this.codeBase == null) {
            this.codeBase = this.realDocBase;
        }
        this.archive = this.getParameter("java_archive");
        if (this.archive == null) {
            this.archive = this.getParameter("archive");
        }
        if (this.getParameter("cache_archive") != null) {
            this.archive = this.archive != null ? this.archive + "," + this.getParameter("cache_archive") : this.getParameter("cache_archive");
        }
        if (this.getParameter("cache_archive_ex") != null) {
            this.archive_ex = this.getParameter("cache_archive_ex");
        }
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
    }

    void startHandler() {
        this.appletLoader = AppletPanel.getClassLoader(this.codeBase, this.realDocBase, this.archive, this.archive_ex);
        this.appletLoader.grab();
        ThreadGroup appletThreadGroup = this.appletLoader.getThreadGroup();
        this.handlerThread = new Thread(appletThreadGroup, this);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                AppletPanel.this.handlerThread.setContextClassLoader(AppletPanel.this.appletLoader);
                return null;
            }
        });
        this.handlerThread.start();
    }

    void setFrame(Frame frm) {
        this.frame = frm;
    }

    Frame getFrame() {
        return this.frame;
    }

    void destroy() {
        this.destroyThread = new Thread(this);
        this.destroyThread.start();
        try {
            this.destroyThread.join(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.appletContext != null) {
            this.appletContext.removePanel(this);
            if (this.inlineElement != null) {
                this.appletContext.setLoadingFinished(this.inlineElement);
                this.inlineElement = null;
            }
            this.appletContext = null;
        }
        this.frame.removeAll();
        this.frame.dispose();
        this.frame = null;
    }

    public void run() {
        Thread currentThread = Thread.currentThread();
        if (currentThread == this.loaderThread) {
            this.runLoaderThread();
        } else if (currentThread == this.handlerThread) {
            this.runHandlerThread();
        } else if (currentThread == this.destroyThread) {
            this.runDestroyThread();
        }
    }

    private void stopLoading() {
        this.dontLoad = true;
        if (this.loaderThread != null) {
            this.loaderThread.interrupt();
        }
    }

    private void runDestroyThread() {
        this.stopLoading();
        this.sendEvent(new AppletEvent(4));
        this.sendEvent(new AppletEvent(5));
        this.sendEvent(new AppletEvent(0));
        this.sendEvent(new AppletEvent(7));
    }

    private void runLoaderThread() {
        String className = this.getClassName();
        if (className != null) {
            try {
                Class<?> appletClass = this.appletLoader.loadClass(className);
                this.status = 1;
                this.applet = (Applet)appletClass.newInstance();
                this.applet.setStub(this);
                this.applet.setVisible(false);
                this.add("Center", this.applet);
                this.applet.validate();
                this.appletState = 1;
            }
            catch (ClassNotFoundException e1) {
                this.appletState = 0;
                this.status = 2;
                this.repaint();
                e1.printStackTrace(System.err);
            }
            catch (ClassFormatError e2) {
                this.appletState = 0;
                this.status = 3;
                this.repaint();
                e2.printStackTrace(System.err);
            }
            catch (Exception e3) {
                this.appletState = 0;
                this.status = 4;
                this.repaint();
                e3.printStackTrace(System.err);
            }
        }
    }

    private void runHandlerThread() {
        while (true) {
            try {
                while (true) {
                    AppletEvent ev = this.getNextEvent();
                    switch (ev.getId()) {
                        case 1: {
                            if (this.appletState != 0) break;
                            this.status = 0;
                            if (this.suppressExternal && !this.dontLoad && this.appletLoader != null) {
                                URL[] urls = this.appletLoader.getURLs();
                                for (int j = 0; j < urls.length; ++j) {
                                    if (urls[j] == null || urls[j].getProtocol() == "file") continue;
                                    this.appletState = 0;
                                    this.status = 9;
                                    this.dontLoad = true;
                                    this.repaint();
                                    break;
                                }
                            }
                            this.repaint();
                            if (this.dontLoad) break;
                            this.loaderThread = new Thread(this);
                            this.loaderThread.start();
                            this.loaderThread.join();
                            this.loaderThread = null;
                            this.repaint();
                            break;
                        }
                        case 2: {
                            try {
                                if (this.appletState != 1) break;
                                if (this.applet != null) {
                                    this.currentSize.setSize(this.getWidthParam(), this.getHeightParam());
                                    this.applet.resize(this.currentSize);
                                    this.applet.setSize(this.currentSize);
                                    this.applet.init();
                                    this.validate();
                                    this.applet.setVisible(true);
                                }
                                this.appletState = 2;
                            }
                            catch (Exception ex) {
                                this.appletState = 0;
                                this.status = 5;
                                this.repaint();
                                ex.printStackTrace(System.err);
                            }
                            break;
                        }
                        case 3: {
                            try {
                                if (this.appletState == 2) {
                                    if (this.applet != null) {
                                        this.applet.start();
                                        this.validate();
                                        this.applet.setVisible(true);
                                    }
                                    this.appletState = 3;
                                    this.status = 10;
                                    this.repaint();
                                }
                            }
                            catch (Exception ex) {
                                this.appletState = 4;
                                this.status = 5;
                                this.repaint();
                                ex.printStackTrace(System.err);
                            }
                            if (this.appletContext == null) break;
                            this.appletContext.setLoadingFinished(this.inlineElement);
                            this.inlineElement = null;
                            break;
                        }
                        case 4: {
                            try {
                                if (this.appletState != 3) break;
                                this.appletState = 4;
                                if (this.applet != null) {
                                    this.applet.stop();
                                }
                                this.status = 6;
                                this.repaint();
                            }
                            catch (Exception ex) {
                                this.status = 5;
                                this.repaint();
                                ex.printStackTrace(System.err);
                            }
                            break;
                        }
                        case 5: {
                            try {
                                if (this.appletState != 4) break;
                                this.appletState = 5;
                                if (this.applet != null) {
                                    this.applet.destroy();
                                }
                                this.status = 7;
                                this.repaint();
                            }
                            catch (Exception ex) {
                                this.status = 5;
                                this.repaint();
                                ex.printStackTrace(System.err);
                            }
                            break;
                        }
                        case 0: {
                            this.applet = null;
                            this.status = 8;
                            this.repaint();
                            break;
                        }
                        case 6: {
                            Dimension size = (Dimension)ev.getParameter();
                            if (size == null || size.equals(this.currentSize)) break;
                            this.currentSize.setSize(size);
                            this.appletAttributes.put("width", String.valueOf((int)size.getWidth()));
                            this.appletAttributes.put("height", String.valueOf((int)size.getHeight()));
                            Frame frame = (Frame)this.getParent();
                            if (frame != null) {
                                frame.setSize(this.currentSize);
                            }
                            this.setSize(this.currentSize);
                            if (this.applet != null) {
                                this.applet.setSize(this.currentSize);
                            }
                            this.validate();
                            break;
                        }
                        case 7: {
                            return;
                        }
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    public void paint(Graphics g) {
        try {
            String message = statusMessages[this.status];
            if (message != null) {
                Font old_font = g.getFont();
                g.setFont(statusFont);
                FontMetrics fm = g.getFontMetrics();
                int str_width = fm.stringWidth(message);
                int x = (this.getWidth() - str_width) / 2;
                if (x < 0) {
                    x = 0;
                }
                g.drawString(message, x, this.getHeight() / 2);
                g.setFont(old_font);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public void appletResize(int width, int height) {
    }

    public java.applet.AppletContext getAppletContext() {
        return this.appletContext;
    }

    public URL getCodeBase() {
        return this.codeBase;
    }

    public URL getDocumentBase() {
        return this.documentBase;
    }

    public String getParameter(String name) {
        String paramValue = (String)this.appletParams.get(name.toLowerCase());
        if (paramValue == null) {
            paramValue = (String)this.appletAttributes.get(name.toLowerCase());
        }
        return paramValue;
    }

    public boolean isActive() {
        return this.appletState == 3;
    }

    protected static void setClassLoaderCacheSize(int size) {
        if (size < 0) {
            size = 0;
        }
        noRefMax = size;
    }

    static AppletClassLoader getClassLoader(URL codeBase, URL docBase, String archive, String archive_ex) {
        AppletClassLoader ldr;
        String key = codeBase.toString();
        if (archive != null) {
            key = key + "," + archive.trim();
        }
        if (archive_ex != null) {
            key = key + "," + archive_ex.trim();
        }
        if ((ldr = (AppletClassLoader)classLoaders.get(key)) == null) {
            String tok;
            StringTokenizer st;
            ldr = new AppletClassLoader(codeBase, key);
            if (archive_ex != null) {
                st = new StringTokenizer(archive_ex, ",", false);
                while (st.hasMoreTokens()) {
                    tok = st.nextToken().trim();
                    StringTokenizer inner_st = new StringTokenizer(tok, ";");
                    String inner_tok = inner_st.nextToken().trim();
                    if (inner_tok == null || inner_tok.equals("")) continue;
                    try {
                        ldr.addJar(new URL(codeBase, inner_tok));
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace(System.err);
                    }
                    catch (MalformedURLException me) {
                        me.printStackTrace(System.err);
                    }
                }
            }
            if (archive != null) {
                st = new StringTokenizer(archive, ",", false);
                while (st.hasMoreTokens()) {
                    tok = st.nextToken().trim();
                    if (tok.startsWith("data:") && st.hasMoreTokens()) {
                        tok = tok + "," + st.nextToken().trim();
                    }
                    try {
                        ldr.addJar(new URL(codeBase, tok));
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace(System.err);
                    }
                    catch (MalformedURLException me) {
                        me.printStackTrace(System.err);
                    }
                }
            }
            classLoaders.put(key, ldr);
        } else {
            noRefLoaders.remove(ldr);
        }
        return ldr;
    }

    static void cacheClassLoader(AppletClassLoader loader) {
        if (noRefMax <= 0) {
            classLoaders.remove(loader.getKey());
        } else {
            if (noRefLoaders.size() >= noRefMax) {
                classLoaders.remove(((AppletClassLoader)noRefLoaders.get(0)).getKey());
                noRefLoaders.remove(0);
            }
            noRefLoaders.add(loader);
        }
    }

    static void clearClassLoaderCache() {
        Iterator i = classLoaders.values().iterator();
        while (i.hasNext()) {
            AppletClassLoader l = (AppletClassLoader)i.next();
            if (l.getUsageCount() != 0) continue;
            i.remove();
        }
    }

    static void printClassLoaders() {
        System.out.println("Classloaders:");
        Iterator i = classLoaders.values().iterator();
        while (i.hasNext()) {
            AppletClassLoader l = (AppletClassLoader)i.next();
            System.out.println(l.getKey());
        }
    }
}

