## Script for updating an RC file
## assume you get the old .rc from STDIN
use Carp;

local (%keyHash, %reverseHash, $dlgBase);



sub SyntaxErr{
	print STDERR "Syntax error at line $. of table.\n";
}


sub ReadTable{
	open(XPTAB, "<allxpstr_win32.txt") || 
		die "The file allxpstr_win32.txt needs to be in the current directory for this script to work";
	my($key,$v404,$v405,$winID404, $winID405, $comment, $ref, $aLine);
	my($verb, $fromKey,$toRslt); ## These are used to pair items in the RC
	
		
	while($aLine = <XPTAB>){
		## The format of a line is {verb},{xp_identifier},{404_Win32_Name},{405_Win32_Name}

		chomp $aLine; ## remove the final CR/LF
		($verb,$key,$winID404,$winID405) = split /\t/,$aLine;
		
		## Only two verbs in the table require processing:
		##    DELETE indicates that string needs to be commented out (effectively, removed)
		##       from the .RC file.
		##    MOVE indicates that the ID changed, and we spit out this lines modified
		##    Any other verb we don't process.


		if($verb eq "DELETE"){
			$winID404 || SyntaxErr();
			$winID404 =~ /STRINGTABLE(\d+)/;
			$1 || SyntaxErr();
			$keyHash{$1} = -1 ; ## Add to our keyhash with a -1 for 405
		}
		elsif($verb eq "MOVE"){
			$winID404  && $winID405 || SyntaxErr();
			$winID404 =~ /STRINGTABLE(\d+)/;
			$1 || SyntaxErr();
			$fromKey = $1;
			$winID405 =~ /STRINGTABLE(\d+)/;
			$1 || SyntaxErr();
			$keyHash{$fromKey} = $1 ; ## Add to our keyhash with the new 405 id
			$reverseHash{$1} = $fromKey; ## to check for double assignment
		}

	} ## End While

	close XPTAB;
}


sub DoStrTable{
	my ($idNo, $newKey, $oldKey, $clashKey);

	while(<STDIN>){

		if($_ =~ /^END\n/){
			print "END\n";
			return 1;
		}

		if($_ =~ /(\s+)(\d+)(\s+)(\".+)\n/){
			$newKey = 0;
			$oldKey = $2;
			if(defined ($newKey = $keyHash{$oldKey}) && $newKey != -1){
				print $1 . $newKey . $3 . $4 . " // Previously $2\n";
			}
			elsif ($newKey == -1){
				chomp;
				print "//$_ // Not found in new version\n";
				print QUERYFILE $2 . $3 . $4 . " // Deleted in new version\n";
			}
			else{ ## not in hash, so probably not a Security Advisor string

				## We need to check if Core has reused an ID that
				## previously belonged to the WinFE (slap! slap!).
				if(exists $reverseHash{$oldKey}){
					$clashKey = $reverseHash{$oldKey};
					print QUERYFILE $2 . $3 . $4 . " // CLASH: $clashKey is mapped to this also\n";
				}
				else{ ## Simple pass through without complications.
					chomp;
					print "$_\n";
				}
			}
				
		}
		else{
			chomp;
			print "$_\n";
		}
	}
	
	return 0;

}

%keyHash = ();
%reverseHash = ();

print STDERR "Reading in allxpstr_win32.txt...\n";
ReadTable(); ## Pull in key pairs
open (QUERYFILE, ">huh.txt") || die "Huh? couldn't dump?";  ## dump problem items here.


## Walk through your string table.
print STDERR "Reading .RC file from standard input...\n";
while(<STDIN>){
	if(/^STRINGTABLE/){ ## look for the start of a string table in the .RC
		print;
		if(not DoStrTable()){ ## Process to the end of this string table
			carp "WARNING: looks funny to me";
			last;
		}
	}
	else{
		print; ## just pass the line through unaltered
	}
}


close QUERYFILE;
print STDERR "Done processing file.\n";