/*
 * Decompiled with CFR 0.152.
 */
package netscape.palomar.util;

import java.util.Enumeration;
import java.util.Stack;
import netscape.palomar.util.CascadedException;
import netscape.palomar.util.Tree;

public class TreeEnumeration {
    private int _lastLevel;
    private Stack _eStack = new Stack();

    public TreeEnumeration(Tree nTop) throws CascadedException {
        if (nTop.numChildren() > 0) {
            this._eStack.push(nTop.getChildren());
        }
    }

    public synchronized boolean hasMoreElements() {
        while (!this._eStack.empty()) {
            Enumeration t = (Enumeration)this._eStack.peek();
            if (t.hasMoreElements()) {
                return true;
            }
            this._eStack.pop();
        }
        return false;
    }

    public synchronized Object nextElement() throws CascadedException {
        if (this.hasMoreElements()) {
            Enumeration t = (Enumeration)this._eStack.peek();
            Tree p = (Tree)t.nextElement();
            this._lastLevel = this._eStack.size();
            if (p.numChildren() > 0) {
                this._eStack.push(p.getChildren());
            }
            return p;
        }
        throw new CascadedException(42);
    }

    public int getLevelOfElement() {
        return this._lastLevel;
    }
}

