/*
 * Decompiled with CFR 0.152.
 */
package netscape.palomar.sgml;

import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.palomar.sgml.SGMLAttribute;
import netscape.palomar.sgml.SGMLAttributeImpl;
import netscape.palomar.sgml.SGMLElement;
import netscape.palomar.sgml.SGMLElementImpl;
import netscape.palomar.sgml.SGMLException;
import netscape.palomar.sgml.SGMLParseTableEntry;
import netscape.palomar.sgml.SGMLParser;
import netscape.palomar.sgml.SGMLStream;
import netscape.palomar.sgml.SGMLTag;
import netscape.palomar.sgml.SGMLText;
import netscape.palomar.util.CascadedException;
import netscape.palomar.util.Tree;

public class SGMLTagImpl
extends SGMLElementImpl
implements SGMLTag {
    protected String _tagType;
    protected Hashtable _attributes;
    protected Vector _attrOrder;
    protected SGMLParseTableEntry _pte;
    protected Vector _excludeList;
    protected Vector _includeList;

    public SGMLParser getParser() {
        return this._pte.parser;
    }

    public void setRawValue(String newValue) {
        this._rawValue = newValue;
        this._tagType = SGMLParser.getTagType(newValue);
    }

    public void preParseSetup(String newValue, SGMLParseTableEntry pte) {
        this._rawValue = newValue;
        this._tagType = SGMLParser.getTagType(newValue);
        this._pte = pte;
    }

    public String getTagType() {
        if (this._tagType == null) {
            return "UNKNOWN";
        }
        return this._tagType;
    }

    public String getRawValue() {
        if (this._rawValue == null) {
            this.reconstructLineImage();
        }
        return this._rawValue;
    }

    void reconstructLineImage() {
        try {
            StringBuffer newImg = new StringBuffer("<");
            newImg.append(this.getTagType());
            Enumeration e = this._attrOrder.elements();
            while (e.hasMoreElements()) {
                String pVal;
                String pName = (String)e.nextElement();
                SGMLAttribute tp = (SGMLAttribute)this._attributes.get(pName);
                if (tp == null || (pVal = tp.getRawValue()) == null) continue;
                newImg.append(" ");
                newImg.append(pName);
                if (pName.equals(pVal)) continue;
                newImg.append("=");
                newImg.append(SGMLTagImpl.quote(pVal));
            }
            newImg.append(">");
            this._rawValue = newImg.toString();
            return;
        }
        catch (Exception e) {
            SGMLException pe = new SGMLException(215, e);
            pe.addToken("tag", this.getTagType());
            CascadedException.printException(pe, "SGMLTagImpl");
            return;
        }
    }

    public SGMLAttribute getAttribute(String name) throws CascadedException {
        try {
            if (this._attributes == null) {
                this.setUpParamVals();
            }
            return (SGMLAttribute)this._attributes.get(name.toUpperCase());
        }
        catch (Exception e) {
            SGMLException pe = new SGMLException(216, e);
            pe.addToken("attr", name);
            pe.addToken("tag", this.getTagType());
            throw pe;
        }
    }

    public void setAttribute(SGMLAttribute attr) throws CascadedException {
        String upperName = attr.getName().toUpperCase();
        try {
            if (this._attributes == null) {
                this.setUpParamVals();
            }
            this._attributes.put(upperName, attr);
            if (!this._attrOrder.contains(upperName)) {
                this._attrOrder.addElement(upperName);
            }
            this._rawValue = null;
            return;
        }
        catch (Exception e) {
            SGMLException pe = new SGMLException(217, e);
            pe.addToken("attr", upperName);
            pe.addToken("tag", this.getTagType());
            throw pe;
        }
    }

    public void initializeAttributes() throws CascadedException {
        String[] presets = this.getParser().getStandardAttributeList(this.getTagType());
        if (presets != null) {
            int i = 0;
            while (i < presets.length) {
                String attName = presets[i].substring(1);
                presets[i].charAt(0);
                this._attrOrder.addElement(attName);
                SGMLAttribute tp = this.createAttribute(attName, null);
                this._attributes.put(attName.toUpperCase(), tp);
                ++i;
            }
        }
    }

    public void postProcessAttributes() throws CascadedException {
    }

    protected synchronized void setUpParamVals() throws CascadedException {
        try {
            if (this._attributes != null) {
                return;
            }
            this._attributes = new Hashtable();
            this._attrOrder = new Vector();
            this.initializeAttributes();
            String sb = this.getRawValue();
            sb = sb.substring(1, sb.length() - 1);
            int i = this.findWhiteWithQuotes(sb, 0);
            if (i >= 0) {
                i = SGMLParser.spanWhite(sb, i);
            }
            while (i > 0) {
                int aStart = i;
                int aEnd = this.findWhiteWithQuotes(sb, aStart);
                if (aEnd < 0) {
                    this.makeAttributeSetting(sb.substring(aStart));
                    break;
                }
                if (sb.charAt(aEnd - 1) == '=') {
                    aEnd = SGMLParser.spanWhite(sb, aEnd);
                    if ((aEnd = this.findWhiteWithQuotes(sb, aEnd)) < 0) {
                        this.makeAttributeSetting(sb.substring(aStart));
                        break;
                    }
                }
                if ((i = SGMLParser.spanWhite(sb, aEnd)) < 0) {
                    this.makeAttributeSetting(sb.substring(aStart, aEnd));
                    break;
                }
                if (sb.charAt(i) == '=') {
                    aEnd = this.findWhiteWithQuotes(sb, i = SGMLParser.spanWhite(sb, i + 1));
                    if (aEnd < 0) {
                        this.makeAttributeSetting(sb.substring(aStart));
                        break;
                    }
                    i = SGMLParser.spanWhite(sb, aEnd);
                }
                this.makeAttributeSetting(sb.substring(aStart, aEnd));
            }
            this.postProcessAttributes();
            return;
        }
        catch (Exception e) {
            SGMLException pe = new SGMLException(218, e);
            pe.addToken("tag", this.getTagType());
            throw pe;
        }
    }

    int findWhiteWithQuotes(String s, int start) {
        int i = start;
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch <= ' ') {
                return i;
            }
            if (ch == '\"') {
                i = s.indexOf(34, i + 1);
            } else if (ch == '\'') {
                i = s.indexOf(39, i + 1);
            } else if (ch == '`') {
                i = s.indexOf(96, i + 1);
            }
            if (i < 0) {
                return -1;
            }
            ++i;
        }
        return -1;
    }

    void makeAttributeSetting(String part) throws CascadedException {
        String key = null;
        try {
            String value;
            int equalspos = part.indexOf(61);
            if (equalspos < 0) {
                value = key = part.toUpperCase();
            } else {
                key = part.substring(0, equalspos).toUpperCase().trim();
                value = SGMLTagImpl.unQuote(part.substring(equalspos + 1).trim());
            }
            SGMLAttribute tp = (SGMLAttribute)this._attributes.get(key);
            if (tp == null) {
                tp = this.createAttribute(key, value);
                this._attributes.put(key, tp);
            } else {
                tp.setRawValue(value);
            }
            if (!this._attrOrder.contains(key)) {
                this._attrOrder.addElement(key);
                return;
            }
        }
        catch (Exception e) {
            SGMLException pe = new SGMLException(219, e);
            pe.addToken("attr", key);
            pe.addToken("tag", this.getTagType());
            throw pe;
        }
    }

    public static String unQuote(String input) throws CascadedException {
        try {
            if (input == null) {
                return null;
            }
            if (input.length() < 2) {
                return input;
            }
            if (input.charAt(0) == '`') {
                return input;
            }
            char quoteChar = input.charAt(0);
            if (quoteChar != '\"' && quoteChar != '\'') {
                return input;
            }
            int pos = input.indexOf(quoteChar, 1);
            if (pos < 0) {
                return input.substring(1);
            }
            return input.substring(1, pos);
        }
        catch (Exception e) {
            SGMLException pe = new SGMLException(220, e);
            throw pe;
        }
    }

    public static String quote(String input) throws CascadedException {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return "\"\"";
        }
        if (input.charAt(0) == '`') {
            return input;
        }
        return "\"" + input + "\"";
    }

    public SGMLAttribute createAttribute(String key, String rawValue) throws CascadedException {
        SGMLAttributeImpl sai = new SGMLAttributeImpl(key, rawValue, this._pte.parser);
        return sai;
    }

    public void finishProcessing() throws CascadedException {
    }

    public Tree findGrandChildParent(Tree grandChild) {
        Tree lower = grandChild;
        Tree upper = grandChild.getParent();
        while (upper != this) {
            lower = upper;
            if ((upper = lower.getParent()) != null) continue;
            return null;
        }
        return lower;
    }

    public SGMLTag parseChildren(SGMLStream inf, Vector parentExclusion, Vector parentInclusion) throws CascadedException {
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public SGMLTag parseChildrenStructure(SGMLStream inf, Vector parentExclusion, Vector parentInclusion) throws CascadedException {
        if (this._pte == null) {
            pe = new SGMLException(221);
            pe.addToken("item", "ParseTableEntry");
            throw pe;
        }
        try {
            this._excludeList = (Vector)parentExclusion.clone();
            this._includeList = (Vector)parentInclusion.clone();
            last = this._pte.exclude.size();
            i1 = 0;
            while (i1 < last) {
                this._excludeList.addElement(this._pte.exclude.elementAt(i1));
                ++i1;
            }
            last = this._pte.include.size();
            i2 = 0;
            while (i2 < last) {
                this._includeList.addElement(this._pte.include.elementAt(i2));
                ++i2;
            }
            stopToken = "/" + this.getTagType();
            sb = null;
            block6: while (true) {
                if ((sb = inf.readText()) == null) {
                    return null;
                }
                if (this._pte.textOK && sb.length() > 0) {
                    ht = inf.generateText(sb);
                    this.addChildQuiet(ht);
                }
                if ((sb = inf.readTag()) == null) {
                    return null;
                }
                if (sb.length() <= 0) continue;
                tx = inf.generateTag(sb);
                while (true) {
                    if (tx != null) ** break;
                    continue block6;
                    txtype = tx.getTagType();
                    if (txtype.equals(stopToken)) {
                        return null;
                    }
                    if (!this.allowedChildType(txtype) && this.allowedInParent(txtype)) {
                        return tx;
                    }
                    this.appendParsedChild(tx);
                    returnedtx = tx.parseChildren(inf, this._excludeList, this._includeList);
                    try {
                        tx.finishProcessing();
                    }
                    catch (Exception ex) {
                        se = new SGMLException(227, ex);
                        se.addToken("tag", this.getTagType());
                        se.addToken("line", Integer.toString(inf.getLineNumber()));
                        se.addToken("col", Integer.toString(inf.getColumnNumber()));
                        inf.registerWarning(se);
                    }
                    tx = returnedtx;
                }
                break;
            }
        }
        catch (Exception e) {
            pe = new SGMLException(222, e);
            pe.addToken("tag", this.getTagType());
            throw pe;
        }
    }

    /*
     * Unable to fully structure code
     */
    public SGMLTag parseChildrenTop(SGMLStream inf, Vector parentExclusion, Vector parentInclusion) throws CascadedException {
        try {
            sb = null;
            this._excludeList = parentExclusion;
            this._includeList = parentInclusion;
            block4: while (true) {
                if ((sb = inf.readText()) == null) {
                    return null;
                }
                if (sb.equals("\n")) {
                    sb = "";
                }
                if (sb.length() > 0) {
                    ht = inf.generateText(sb);
                    this.addChildQuiet(ht);
                }
                if ((sb = inf.readTag()) == null) {
                    return null;
                }
                if (sb.length() <= 0) continue;
                tx = inf.generateTag(sb);
                while (true) {
                    if (tx != null) ** break;
                    continue block4;
                    tx.getTagType();
                    this.addChildQuiet(tx);
                    returnedtx = tx.parseChildren(inf, parentExclusion, parentInclusion);
                    try {
                        tx.finishProcessing();
                    }
                    catch (Exception ex) {
                        se = new SGMLException(227, ex);
                        se.addToken("tag", this.getTagType());
                        se.addToken("line", Integer.toString(inf.getLineNumber()));
                        se.addToken("col", Integer.toString(inf.getColumnNumber()));
                        inf.registerWarning(se);
                    }
                    tx = returnedtx;
                }
                break;
            }
        }
        catch (Exception e) {
            pe = new SGMLException(222, e);
            pe.addToken("tag", "Top");
            throw pe;
        }
    }

    public SGMLTag parseChildrenScript(SGMLStream inf, Vector parentExclusion, Vector parentInclusion) throws CascadedException {
        if (this._pte == null) {
            SGMLException pe = new SGMLException(221);
            pe.addToken("item", "ParseTableEntry");
            throw pe;
        }
        this._excludeList = parentExclusion;
        this._includeList = parentInclusion;
        String stopToken = "/" + this.getTagType();
        String sb = null;
        while (inf.textNext()) {
            sb = inf.getTextTilToken(stopToken);
            if (sb == null) {
                return null;
            }
            SGMLText ht = inf.generateScript(sb);
            this.addChildQuiet(ht);
        }
        sb = inf.readTag();
        return null;
    }

    public void appendParsedChild(SGMLTag tx) throws CascadedException {
        this.addChildQuiet(tx);
    }

    public boolean allowedChildType(String testTag) {
        boolean allowed = this._pte.contentModel.contains(testTag);
        if (this._includeList == null) {
            return allowed;
        }
        if (!allowed && !(allowed = this._includeList.contains(testTag))) {
            String stopTag;
            if (testTag.length() < 1) {
                return false;
            }
            return testTag.charAt(0) == '/' && (stopTag = "/" + this.getTagType()).equals(testTag);
        }
        return !this._excludeList.contains(testTag);
    }

    public boolean allowedInParent(String testTag) throws CascadedException {
        Tree parent = this.getParent();
        while (parent != null) {
            if (!(parent instanceof SGMLTag)) continue;
            if (((SGMLTag)parent).allowedChildType(testTag)) {
                return !((SGMLTag)parent).isTopTag();
            }
            parent = parent.getParent();
        }
        return false;
    }

    public void allowableChild(SGMLElement newTree) throws CascadedException {
        if (newTree instanceof SGMLText) {
            if (this._pte.textOK) {
                return;
            }
            SGMLException pe = new SGMLException(223);
            try {
                pe.addToken("tag", "'text'");
                pe.addToken("parent", this.getTagType());
            }
            catch (Exception exception) {}
            throw pe;
        }
        if (!this.allowedChildType(newTree.getTagType())) {
            SGMLException pe = new SGMLException(223);
            try {
                pe.addToken("tag", newTree.getTagType());
                pe.addToken("parent", this.getTagType());
            }
            catch (Exception exception) {}
            throw pe;
        }
        if (newTree instanceof SGMLTag) {
            ((SGMLTag)newTree).checkContext(this._excludeList, this._includeList);
        }
    }

    public void checkContext(Vector parentExclusion, Vector parentInclusion) throws CascadedException {
        this._excludeList = (Vector)parentExclusion.clone();
        Enumeration e = this._pte.exclude.elements();
        while (e.hasMoreElements()) {
            this._excludeList.addElement(e.nextElement());
        }
        this._includeList = (Vector)parentInclusion.clone();
        Enumeration e2 = this._pte.exclude.elements();
        while (e2.hasMoreElements()) {
            this._excludeList.addElement(e2.nextElement());
        }
        Enumeration e3 = this.getChildren();
        while (e3.hasMoreElements()) {
            SGMLElement testChild = (SGMLElement)e3.nextElement();
            if (testChild instanceof SGMLTag && !this.allowedChildType(testChild.getTagType())) {
                SGMLException pe = new SGMLException(224);
                pe.addToken("parent", this.getTagType());
                pe.addToken("child", testChild.getTagType());
                throw pe;
            }
            if (!(testChild instanceof SGMLTag)) continue;
            ((SGMLTag)testChild).checkContext(this._excludeList, this._includeList);
        }
    }

    public void writeYourself(DataOutputStream dos) throws CascadedException {
        try {
            dos.writeBytes(this.getRawValue());
            if (this._pte.contentEmpty) {
                return;
            }
            boolean addReturns = !this._pte.textOK;
            int last = this.numChildren();
            int i = 0;
            while (i < last) {
                Tree child = this.childAt(i);
                if (child instanceof SGMLElement) {
                    ((SGMLElement)child).writeYourself(dos);
                }
                ++i;
            }
            this.writeVirtualContent(dos);
            if (addReturns) {
                dos.writeBytes("\n");
            }
            dos.writeBytes("</");
            dos.writeBytes(this.getTagType());
            dos.writeBytes(">");
            return;
        }
        catch (Exception e) {
            SGMLException ce = new SGMLException(225, e);
            throw ce;
        }
    }

    public void writeVirtualContent(DataOutputStream dos) throws CascadedException {
    }

    public boolean isTopTag() {
        return false;
    }

    public void beenCloned() throws CascadedException {
        this._excludeList = null;
        this._includeList = null;
        Hashtable oldAttrs = this._attributes;
        super.beenCloned();
        try {
            if (this._attributes == null) {
                return;
            }
            this._attrOrder = (Vector)this._attrOrder.clone();
            this._attributes = new Hashtable();
            Enumeration eKeys = oldAttrs.keys();
            while (eKeys.hasMoreElements()) {
                Object oKey = eKeys.nextElement();
                SGMLAttribute tp = (SGMLAttribute)oldAttrs.get(oKey);
                SGMLAttribute tpclone = this.createAttribute(tp.getName(), tp.getRawValue());
                this._attributes.put(oKey, tpclone);
            }
            return;
        }
        catch (Exception e) {
            SGMLException pe = new SGMLException(226, e);
            pe.addToken("class", this.getTagType());
            pe.addToken("name", this.getTagType());
            throw pe;
        }
    }

    public void flush() throws CascadedException {
        this._attributes = null;
        this._attrOrder = null;
        this._excludeList = null;
        this._includeList = null;
        super.flush();
    }
}

