<?php

/*
+--------------------------------------------------------------------------
|   Invision Power Board v1.1
|   ========================================
|   by Matthew Mecham
|   (c) 2001,2002 Invision Power Services
|   http://www.ibforums.com
|   ========================================
|   Web: http://www.ibforums.com
|   Email: phpboards@ibforums.com
|   Licence Info: phpib-licence@ibforums.com
+---------------------------------------------------------------------------
|
|   > Admin Setting functions
|   > Module written by Matt Mecham
|   > Date started: 20th March 2002
|
|	> Module Version Number: 1.0.0
+--------------------------------------------------------------------------
*/


$idx = new ad_settings();


class ad_settings {

	var $base_url;

	function ad_settings() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		//---------------------------------------
		// Kill globals - globals bad, Homer good.
		//---------------------------------------
		
		$tmp_in = array_merge( $_GET, $_POST, $_COOKIE );
		
		foreach ( $tmp_in as $k => $v )
		{
			unset($$k);
		}

		switch($IN['code'])
		{
			case 'phpinfo':
				phpinfo();
				exit;
				
			case 'cookie':
				$this->cookie();
				break;
			case 'docookie':
				$this->save_config( array( 'cookie_domain', 'cookie_id', 'cookie_path' ) );
				break;
			//-------------------------	
			case 'secure':
				$this->secure();
				break;
			case 'dosecure':
				$this->save_config( array ( 'reg_antispam', 'disable_admin_anon', 'disable_online_ip', 'disable_reportpost', 'allow_dynamic_img','session_expiration','match_browser','allow_dup_email','allow_images', 'force_login', 'no_reg',
											'allow_flash','new_reg_notify','use_mail_form','flood_control', 'allow_online_list', 'reg_auth_type' ) );
				break;
			//-------------------------
			case 'post':
				$this->post();
				break;
			case 'dopost':
				$this->save_config( array ( 'poll_tags', 'guest_name_pre', 'guest_name_suf', 'max_w_flash', 'max_h_flash', 'hot_topic', 'display_max_topics','display_max_posts','max_emos','max_images','emo_per_row', 'etfilter_punct', 'etfilter_shout',
											'strip_quotes', 'max_post_length','show_img_upload','pre_polls','pre_moved','pre_pinned','img_ext' ) );
				break;
			//-------------------------
			case 'avatars':
				$this->avatars();
				break;
			case 'doavatars':
				$this->save_config( array ( 'subs_autoprune', 'topicpage_contents', 'postpage_contents', 'allow_skins', 'max_sig_length', 'sig_allow_ibc', 'sig_allow_html','avatar_ext','avatar_url','avup_size_max','avatars_on','avatar_dims','avatar_def', 'max_location_length', 'max_interest_length', 'post_titlechange', 'guests_ava', 'guests_img', 'guests_sig' ) );
				break;
			//-------------------------
			case 'dates':
				$this->dates();
				break;
			case 'dodates':
				$this->save_config( array ( 'time_offset','clock_short','clock_joined','clock_long', 'time_adjust' ) );
				break;
			//-------------------------
			
			case 'calendar':
				$this->calendar();
				break;
			case 'docalendar':
				$this->save_config( array ( 'show_calendar','calendar_limit', 'year_limit', 'start_year' ) );
				break;
			//-------------------------
			
			case 'cpu':
				$this->cpu();
				break;
			case 'docpu':
				$this->save_config( array ( 'min_search_word', 'short_forum_jump', 'no_au_forum', 'no_au_topic', 'au_cutoff', 'load_limit','show_active','show_birthdays','show_totals','allow_search', 'search_post_cut', 'show_user_posted', 'nocache' ) );
				break;
			//-------------------------
			case 'email':
				$this->email();
				break;
			case 'doemail':
				$this->save_config( array ( 'email_in', 'email_out', 'mail_method', 'smtp_host', 'smtp_port', 'smtp_user', 'smtp_pass' ) );
				break;
			//-------------------------
			case 'url':
				$this->url();
				break;
			case 'dourl':
				$this->save_config( array ( 'number_format', 'html_dir','safe_mode_skins', 'board_name','board_url','home_name','home_url', 'disable_zip',
										    'html_url','upload_url', 'upload_dir', 'print_headers', 'header_redirect', 'debug_level', 'sql_debug' ) );
				break;
			//-------------------------
			case 'pm':
				$this->pm();
				break;
			case 'dopm':
				$this->save_config( array ( 'show_max_msg_list', 'msg_allow_code', 'msg_allow_html' ) );
				break;
			//-------------------------
			case 'news':
				$this->news();
				break;
			case 'donews':
				$this->save_config( array ( 'news_forum_id', 'index_news_link' ) );
				break;
			//-------------------------
			case 'coppa':
				$this->coppa();
				break;
			case 'docoppa':
				$this->save_config( array ( 'use_coppa', 'coppa_fax', 'coppa_address' ) );
				break;
			//-------------------------
			case 'board':
				$this->board();
				break;
			case 'doboard':
				$this->save_config( array ( 'board_offline', 'offline_msg' ) );
				break;
			//-------------------------
			case 'bw':
				$this->badword();
				break;
			case 'bw_add':
				$this->add_badword();
				break;
			case 'bw_remove':
				$this->remove_badword();
				break;
			case 'bw_edit':
				$this->edit_badword();
				break;
			case 'bw_doedit':
				$this->doedit_badword();
				break;
			//-------------------------
			case 'emo':
				$this->emoticons();
				break;
			case 'emo_add':
				$this->add_emoticons();
				break;
			case 'emo_remove':
				$this->remove_emoticons();
				break;
			case 'emo_edit':
				$this->edit_emoticons();
				break;
			case 'emo_doedit':
				$this->doedit_emoticons();
				break;
			case 'emo_upload':
				$this->upload_emoticon();			
			//-------------------------
			case 'count':
				$this->countstats();
				break;
			case 'docount':
				$this->docount();
				break;
			default:
				$this->cookie();
				break;
		}
		
	}
	
	//=====================================================
	
	//-------------------------------------------------------------
	// NEWS
	//--------------------------------------------------------------
	
	function coppa()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('docoppa', 'COPPA ]w', 'ziHbUܧtmC`NAbz׾±ҥ <a href="http://www.ftc.gov/opa/1999/9910/childfinal.htm" target="_blank">COPPA</a> ɡA|nD 13 HUൣHǯuζloPN.');
		
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϥ COPPA Ut?</b>" ,
										  $SKIN->form_yes_no( "use_coppa", $INFO['use_coppa']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> COPPA 檺ǯuX</b>" ,
										  $SKIN->form_input( "coppa_fax", $form_array, $INFO['coppa_fax']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> COPPA 檺la}</b>" ,
										  $SKIN->form_textarea( "coppa_address", $INFO['coppa_address']  )
								 )      );
		
		
		$this->common_footer();
	
	
	}
	
	//=====================================================
	
	function docount()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ( (! $IN['posts']) and (! $IN['members'] ) and (! $IN['lastreg'] ) )
		{
			$ADMIN->error("Snsp⪺!");
		}
		
		$stats = array();
		
		if ($IN['posts'])
		{
			$DB->query("SELECT COUNT(pid) as posts FROM ibf_posts WHERE queued <> 1");
			$r = $DB->fetch_row();
			$stats['TOTAL_REPLIES'] = $r['posts'];
			$stats['TOTAL_REPLIES'] < 1 ? 0 : $stats['TOTAL_REPLIES'];
			
			$DB->query("SELECT COUNT(tid) as topics FROM ibf_topics WHERE approved = 1");
			$r = $DB->fetch_row();
			$stats['TOTAL_TOPICS'] = $r['topics'];
			$stats['TOTAL_TOPICS'] < 1 ? 0 : $stats['TOTAL_TOPICS'];
			
			$stats['TOTAL_REPLIES'] -= $stats['TOTAL_TOPICS'];
		}
		
		if ($IN['members'])
		{
			$DB->query("SELECT COUNT(uid) as members from xbb_members WHERE mgroup <> '".$INFO['auth_group']."'");
			$r = $DB->fetch_row();
			$stats['MEM_COUNT'] = $r['members'];
			// Remove "guest" account...
			$stats['MEM_COUNT']--;
			$stats['MEM_COUNT'] < 1 ? 0 : $stats['MEM_COUNT'];
		}
		
		if ($IN['lastreg'])
		{
			$DB->query("SELECT uid, uname FROM xbb_members WHERE mgroup <> '".$INFO['auth_group']."' ORDER BY uid DESC LIMIT 0,1");
			$r = $DB->fetch_row();
			$stats['LAST_MEM_NAME'] = $r['uname'];
			$stats['LAST_MEM_ID']   = $r['uid'];
		}
		
		if ($IN['online'])
		{
			$stats['MOST_DATE'] = time();
			$stats['MOST_COUNT'] = 1;
		}
		
		if ( count($stats) > 0 )
		{
			$db_string = $DB->compile_db_update_string( $stats );
			$DB->query("UPDATE ibf_stats SET $db_string");
		}
		else
		{
			$ADMIN->error("Snsp⪺!");
		}
		
		$ADMIN->done_screen("wspέp", "޲zx", "act=index" );
		
	}
	
	
	
	function countstats()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$ADMIN->page_detail = "пܭnsp⪺έp.";
		$ADMIN->page_title  = "spέp";
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'docount' ),
												  2 => array( 'act'   , 'op'     ),
									     )      );
									     
		//+-------------------------------
		
		$SKIN->td_header[] = array( "έp"    , "70%" );
		$SKIN->td_header[] = array( "ﶵ"       , "30%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "spέp" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "spҦDDP峹",
												  $SKIN->form_dropdown( 'posts', array( 0 => array( 1, 'O'  ), 1 => array( 0, '_' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->add_td_row( array( "sp|",
												  $SKIN->form_dropdown( 'members', array( 0 => array( 1, 'O'  ), 1 => array( 0, '_' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->add_td_row( array( "]̷sU|",
												  $SKIN->form_dropdown( 'lastreg', array( 0 => array( 1, 'O'  ), 1 => array( 0, '_' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->add_td_row( array( "] 'uW̰O' έp?",
												  $SKIN->form_dropdown( 'online', array( 0 => array( 0, '_'  ), 1 => array( 1, 'O' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->end_form(']oǲέp');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	
	}
	
	//-------------------------------------------------------------
	// CALENDAR
	//--------------------------------------------------------------
	
	function calendar()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('docalendar', 'ƾ]w', 'ziHbUܧtm');
		
		$INFO['start_year'] = (isset($INFO['start_year'])) ? $INFO['start_year'] : 2001;
		$INFO['year_limit'] = (isset($INFO['year_limit'])) ? $INFO['year_limit'] : 5;
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ܧYN{ƥ?</b><br>o|Nƾƥܦb׾­έpϤ." ,
										  $SKIN->form_yes_no( "show_calendar", $INFO['show_calendar'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̪ܳ񥼨 [x] Ѫƥ</b><br>oAΩWﶵ." ,
										  $SKIN->form_input( "calendar_limit", $INFO['calendar_limit']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ƾ '~' UԿ檺}l~</b><br>oAΩ˵ƾ / oƥ." ,
										  $SKIN->form_input( "start_year", $INFO['start_year']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>'~' UԿ檺~</b><br>oAΩ˵ƾ / oƥC<br>dҡG{bO 2002 ~AzJ 5 - ̫i諸~ = 2007" ,
										  $SKIN->form_input( "year_limit", $INFO['year_limit']  )
								 )      );
								 
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// URLs and ADDRESSES
	//--------------------------------------------------------------
	
	function board()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('doboard', '׾/}', 'ziHbUܧtm');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>׾?</b><br>vH̵MiHiJ׾" ,
										  $SKIN->form_yes_no( "board_offline", $INFO['board_offline'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>nܪT</b>" ,
										  $SKIN->form_textarea( "offline_msg", $INFO['offline_msg']  )
								 )      );
								 
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// EMOTICON FUNCTIONS
	//-------------------------------------------------------------
	
	function doedit_emoticons()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['before'] == "")
		{
			$ADMIN->error("zJ@ӭnNrA³J!");
		}
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("zJ@ӦĪϥ idA³J!");
		}
		
		$IN['clickable'] = $IN['clickable'] ? 1 : 0;
		
		$db_string = $DB->compile_db_update_string( array( 'code'     => $IN['before'],
														   'smile_url'     => $IN['after'],
														   'clickable' => $IN['click'],
												  )      );
												  
		$DB->query("UPDATE xbb_emoticons SET $db_string WHERE id='".$IN['id']."'");
		
		$std->boink_it($SKIN->base_url."&act=op&code=emo");
		exit();
			
		
	}
	
	//=====================================================
	
	
	function edit_emoticons()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$ADMIN->page_detail = "ziHbUsϥܹLo";
		$ADMIN->page_title  = "sϥ";
		
		//+-------------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("zJ@ӦĪLo idA³J!");
		}
		
		//+-------------------------------
		
		$DB->query("SELECT * FROM xbb_emoticons WHERE id='".$IN['id']."'");
		
		if ( ! $r = $DB->fetch_row() )
		{
			$ADMIN->error("LkbƮwӪϥ");
		}
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'emo_doedit' ),
												  2 => array( 'act'   , 'op'     ),
												  3 => array( 'id'    , $IN['id'] ),
									     )      );
		
		
		
		$SKIN->td_header[] = array( "e"  , "40%" );
		$SKIN->td_header[] = array( ""   , "40%" );
		$SKIN->td_header[] = array( "+ iI"  , "20%" );
		
		//+-------------------------------
		
		$emos = array();
		
		if (! is_dir($INFO['html_dir'].'/../../../uploads') )
		{
			$ADMIN->error("Lkϥܥؿ - нTw 'html_dir' |]m");
		}
		
		//+-------------------------------
		
		
		$dh = opendir( $INFO['html_dir'].'/../../../uploads' ) or die("Lk}ҭnŪϥܥؿAˬd|v");
 		while ( $file = readdir( $dh ) )
 		{
 			if ( preg_match( "/^smil.*/i", $file ) )
 			{
 				$emos[] = array( $file, $file );
 			}
 		}
 		closedir( $dh );
 		
 		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "sϥ" );
		
		$ADMIN->html .= "<script language='javascript'>
						 <!--
						 	function show_emo() {
						 	
						 		var emo_url = '{$INFO['html_url']}/../../../uploads/' + document.theAdminForm.after.options[document.theAdminForm.after.selectedIndex].value;
						 		
						 		document.images.emopreview.src = emo_url;
							}
						//-->
						</script>
						";
		
		$ADMIN->html .= $SKIN->add_td_row( array( $SKIN->form_input('before', ($r['code']) ),
												  $SKIN->form_dropdown('after', $emos, $r['smile_url'], "onChange='show_emo()'") . "&nbsp;&nbsp;<img src='../../uploads/{$r['smile_url']}' name='emopreview' border='0'>",
												  $SKIN->form_dropdown( 'click', array( 0 => array( 1, 'O'  ), 1 => array( 0, '_' ) ), $r['clickable'] )
										 )      );
										 
		$ADMIN->html .= $SKIN->end_form('sϥ');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	
	}
	
	//=====================================================
	
	function remove_emoticons()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("zJ@ӦĪϥ idA³J!");
		}
		
		$DB->query("DELETE FROM xbb_emoticons WHERE id='".$IN['id']."'");
		
		$std->boink_it($SKIN->base_url."&act=op&code=emo");
		exit();
			
		
	}
	
	//=====================================================
	
	function add_emoticons()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['before'] == "")
		{
			$ADMIN->error("zJnmϥܤrA³J!");
		}
		
		$IN['click'] = $IN['click'] ? 1 : 0;
		
		$db_string = $DB->compile_db_insert_string( array( 'code'      => $IN['before'],
														   'smile_url'      => $IN['after'],
														   'clickable'  => $IN['click'],
												  )      );
												  
		$DB->query("INSERT INTO xbb_emoticons (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
		
		$std->boink_it($SKIN->base_url."&act=op&code=emo");
		exit();
			
		
	}
	
	
	function perly_length_sort($a, $b)
	{
		if ( strlen($a['code']) == strlen($b['code']) )
		{
			return 0;
		}
		return ( strlen($a['code']) > strlen($b['code']) ) ? -1 : 1;
	}
	
	function perly_word_sort($a, $b)
	{
		if ( strlen($a['code']) == strlen($b['code']) )
		{
			return 0;
		}
		return ( strlen($a['code']) > strlen($b['code']) ) ? -1 : 1;
	}
	
	//=====================================================
	
	function upload_emoticon()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_FILES;
		
		$FILE_NAME = $HTTP_POST_FILES['FILE_UPLOAD']['name'];
		$FILE_SIZE = $HTTP_POST_FILES['FILE_UPLOAD']['size'];
		$FILE_TYPE = $HTTP_POST_FILES['FILE_UPLOAD']['type'];
		
		// Naughty Opera adds the filename on the end of the
		// mime type - we don't want this.
		
		$FILE_TYPE = preg_replace( "/^(.+?);.*$/", "\\1", $FILE_TYPE );
		
		if (! is_dir($INFO['html_dir'].'/../../../uploads') )
		{
			$ADMIN->error("Lkϥܥؿ - нTw 'html_dir' |O_]wT");
		}
							
		// Naughty Mozilla likes to use "none" to indicate an empty upload field.
		// I love universal languages that aren't universal.
		
		if ($HTTP_POST_FILES['FILE_UPLOAD']['name'] == "" or !$HTTP_POST_FILES['FILE_UPLOAD']['name'] or ($HTTP_POST_FILES['FILE_UPLOAD']['name'] == "none") )
		{
			$ADMIN->error("SܭnWǪɮ!");
		}
		
		//-------------------------------------------------
		// Copy the upload to the uploads directory
		//-------------------------------------------------
		
		if (! @move_uploaded_file( $HTTP_POST_FILES['FILE_UPLOAD']['tmp_name'], $INFO['html_dir'].'/../../../uploads'."/"."smiles-".$FILE_NAME) )
		{
			$ADMIN->error("The upload failed");
		}
		else
		{
			@chmod( $INFO['html_dir'].'/../../../uploads'."/".$FILE_NAME, 0777 );
		}
		
		$std->boink_it($SKIN->base_url."&act=op&code=emo");
		exit();
		
		
	}
	
	function emoticons()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$ADMIN->page_detail = "ziHbo̼W[/sβϥܡC<br>zuܤwgWǨ 'html/emoticons' ؿϥ<br><br>iIPoe 'iIϥ' 椤ϥܦ.";
		$ADMIN->page_title  = "ϥܱ";
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "e"      , "30%" );
		$SKIN->td_header[] = array( ""       , "30%" );
		$SKIN->td_header[] = array( "+ iI" , "20%" );
		$SKIN->td_header[] = array( "s"        , "10%" );
		$SKIN->td_header[] = array( ""      , "10%" );
		
		//+-------------------------------
		
		
		
		$ADMIN->html .= $SKIN->start_table( "ثeϥ" );
		
		$DB->query("SELECT * from xbb_emoticons");
		
		$emo_url = $INFO['html_url'] . '/../../../uploads';
		
		$smilies = array();
			
		if ( $DB->get_num_rows() )
		{
			while ( $r = $DB->fetch_row() )
			{
				$smilies[] = $r;
			}
			
			usort($smilies, array( 'ad_settings', 'perly_length_sort' ) );
			
			foreach( $smilies as $array_idx => $r )
			{
			
				$click = $r['clickable'] ? 'O' : '_';
				
				$ADMIN->html .= $SKIN->add_td_row( array( ($r['code']),
														  "<center><img src='$emo_url/{$r['smile_url']}'></center>",
														  "<center>$click</center>",
														  "<center><a href='".$SKIN->base_url."&act=op&code=emo_edit&id={$r['id']}'>s</a></center>",
														  "<center><a href='".$SKIN->base_url."&act=op&code=emo_remove&id={$r['id']}'></a></center>",
												 )      );
												   
			
				
			}
		}
		
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$emos = array();
		
		if (! is_dir($INFO['html_dir'].'/../../../uploads') )
		{
			$ADMIN->error("Lkϥܥؿ - нTw 'html_dir' |O_]T");
		}
		
		//+-------------------------------
		
		$cnt   = 0;
		$start = "";
		
		$dh = opendir( $INFO['html_dir'].'/../../../uploads' ) or die("Lk}ҪϥܥؿHiŪAˬd|Pv");
 		while ( $file = readdir( $dh ) )
 		{
			if (preg_match("/^smil.*/i",$file)) 
 			{
 				$emos[] = array( $file, $file );
 				
 				if ($cnt == 0)
 				{
 					$cnt = 1;
 					$start = $file;
 				}
 			}
 
 		}
 		closedir( $dh );
 		
 		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'emo_add' ),
												  2 => array( 'act'   , 'op'     ),
									     )      );
		
		
		$SKIN->td_header[] = array( "e"       , "40%" );
		$SKIN->td_header[] = array( ""        , "40%" );
		$SKIN->td_header[] = array( "+ iI"  , "20%" );
		
		//+-------------------------------
		
		$ADMIN->html .= "<script language='javascript'>
						 <!--
						 	function show_emo() {
						 	
						 		var emo_url = '{$INFO['html_url']}/../../../uploads/' + document.theAdminForm.after.options[document.theAdminForm.after.selectedIndex].value;
						 		
						 		document.images.emopreview.src = emo_url;
							}
						//-->
						</script>
						";
		
		$ADMIN->html .= $SKIN->start_table( "sWϥ" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( $SKIN->form_input('before'),
												  $SKIN->form_dropdown('after', $emos, "", "onChange='show_emo()'") . "&nbsp;&nbsp;<img src='../../uploads/$start' name='emopreview' border='0'>",
												  $SKIN->form_dropdown( 'click', array( 0 => array( 1, 'O'  ), 1 => array( 0, '_' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->end_form('W[ϥ');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'emo_upload' ),
												  2 => array( 'act'   , 'op'     ),
												  3 => array( 'MAX_FILE_SIZE', '10000000000' ),
									     ) , "uploadform", " enctype='multipart/form-data'"     );
		
		
		$SKIN->td_header[] = array( "&nbsp;"       , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"       , "60%" );
		
		
		$ADMIN->html .= $SKIN->start_table( "WǤ@Ӫϥܨϥܥؿ" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>qzqܤ@ӭnWǪɮ</b><br>WǤAibWΪϥ.",
												  $SKIN->form_upload(),
										 )      );
										 
		$ADMIN->html .= $SKIN->end_form('WǪϥ');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	
	}
	
	//-------------------------------------------------------------
	// BADWORD FUNCTIONS
	//--------------------------------------------------------------
	
	
	function doedit_badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['before'] == "")
		{
			$ADMIN->error("zJ@ӭnNrJA³J!");
		}
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("zJ@ӦĪLo idA³J!");
		}
		
		$IN['match'] = $IN['match'] ? 1 : 0;
		
		strlen($IN['swop']) > 1 ?  $IN['swop'] : "";
		
		$db_string = $DB->compile_db_update_string( array( 'type'    => $IN['before'],
														   'swop'    => $IN['after'],
														   'm_exact' => $IN['match'],
												  )      );
												  
		$DB->query("UPDATE ibf_badwords SET $db_string WHERE wid='".$IN['id']."'");
		
		$std->boink_it($SKIN->base_url."&act=op&code=bw");
		exit();
			
		
	}
	
	//=====================================================
	
	function edit_badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$ADMIN->page_detail = "ziHbUsҿ諸Lo";
		$ADMIN->page_title  = "}rJLo";
		
		//+-------------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("zJ@ӦĪLo idA³J!");
		}
		
		//+-------------------------------
		
		$DB->query("SELECT * FROM ibf_badwords WHERE wid='".$IN['id']."'");
		
		if ( ! $r = $DB->fetch_row() )
		{
			$ADMIN->error("LkbƮwӹLo");
		}
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'bw_doedit' ),
												  2 => array( 'act'   , 'op'     ),
												  3 => array( 'id'    , $IN['id'] ),
									     )      );
		
		
		
		$SKIN->td_header[] = array( "e"  , "40%" );
		$SKIN->td_header[] = array( ""   , "40%" );
		$SKIN->td_header[] = array( "Ҧ"  , "20%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "sLo" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( $SKIN->form_input('before', ($r['type']) ),
												  $SKIN->form_input('after' , ($r['swop']) ),
												  $SKIN->form_dropdown( 'match', array( 0 => array( 1, 'T'  ), 1 => array( 0, 'eP' ) ), $r['m_exact'] )
										 )      );
										 
		$ADMIN->html .= $SKIN->end_form('sLo');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	
	}
	
	//=====================================================
	
	function remove_badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("zJ@ӦĪLo idA³J!");
		}
		
		$DB->query("DELETE FROM ibf_badwords WHERE wid='".$IN['id']."'");
		
		$std->boink_it($SKIN->base_url."&act=op&code=bw");
		exit();
			
		
	}
	
	//=====================================================
	
	function add_badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['before'] == "")
		{
			$ADMIN->error("zJ@ӭnNrJA³J!");
		}
		
		$IN['match'] = $IN['match'] ? 1 : 0;
		
		strlen($IN['swop']) > 1 ?  $IN['swop'] : "";
		
		$db_string = $DB->compile_db_insert_string( array( 'type'    => $IN['before'],
														   'swop'    => $IN['after'],
														   'm_exact' => $IN['match'],
												  )      );
												  
		$DB->query("INSERT INTO ibf_badwords (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
		
		$std->boink_it($SKIN->base_url."&act=op&code=bw");
		exit();
			
		
	}
	
	//=====================================================
	
	function badword()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$ADMIN->page_detail = "ziHbo̼W[/sP}rJLoC<br>}rJLo\zq|峹BñWɤΥDDDjd򪺨NC<br><br><b>ePŦX</b>GpGzJ 'hell' @@Ӥ}rJAh|N 'hell'  'hello' NzҿJNr 6 Ӥr (jpg)<br><br><b>TŦX</b>GpGzJ 'hell' @@Ӥ}rJAu|N 'hell' NzҿJNrΪ 6 Ӥr (jpg)";
		$ADMIN->page_title  = "}rJLo";
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'bw_add' ),
												  2 => array( 'act'   , 'op'     ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "e"  , "30%" );
		$SKIN->td_header[] = array( ""   , "30%" );
		$SKIN->td_header[] = array( "Ҧ"  , "20%" );
		$SKIN->td_header[] = array( "s"    , "10%" );
		$SKIN->td_header[] = array( ""  , "10%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "ثeLo" );
		
		$DB->query("SELECT * from ibf_badwords");
		
		if ( $DB->get_num_rows() )
		{
			while ( $r = $DB->fetch_row() )
			{
				$words[] = $r;
			}
			
			usort($words, array( 'ad_settings', 'perly_word_sort' ) );
			
			foreach($words as $idx => $r)
			{
			
				$replace = $r['swop']    ? ($r['swop']) : '######';
				
				$method  = $r['m_exact'] ? 'T' : 'eP';
				
				$ADMIN->html .= $SKIN->add_td_row( array( ($r['type']),
														  $replace,
														  $method,
														  "<center><a href='".$SKIN->base_url."&act=op&code=bw_edit&id={$r['wid']}'>s</a></center>",
														  "<center><a href='".$SKIN->base_url."&act=op&code=bw_remove&id={$r['wid']}'></a></center>",
												 )      );
			}
			
		}
		
		$ADMIN->html .= $SKIN->end_table();
		
		
		$SKIN->td_header[] = array( "e"  , "40%" );
		$SKIN->td_header[] = array( ""   , "40%" );
		$SKIN->td_header[] = array( "Ҧ"  , "20%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "sWLo" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( $SKIN->form_input('before'),
												  $SKIN->form_input('after'),
												  $SKIN->form_dropdown( 'match', array( 0 => array( 1, 'T'  ), 1 => array( 0, 'eP' ) ) )
										 )      );
										 
		$ADMIN->html .= $SKIN->end_form('W[Lo');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	
	}
	
	//-------------------------------------------------------------
	// NEWS
	//--------------------------------------------------------------
	
	function news()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('donews', 'sDץX]w', 'ziHbUܧtm');
		
		$DB->query("SELECT id, name FROM ibf_forums WHERE subwrap = 0");
		
		$form_array = array();
		
		while ( $r = $DB->fetch_row() )
		{
			$form_array[] = array( $r['id'], $r['name'] );
		}
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>qӰQװ϶פJsDDD?</b>" ,
										  $SKIN->form_dropdown( "news_forum_id", $form_array, $INFO['news_forum_id']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> '̷s' s׾­?</b>" ,
										  $SKIN->form_yes_no( "index_news_link", $INFO['index_news_link']  )
								 )      );
		
		
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// PM
	//--------------------------------------------------------------
	
	function pm()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('dopm', 'ǰT̳]w', 'ziHbUܧtm');
		
		
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\b PM ϥ IBF Code ?</b>" ,
										  $SKIN->form_yes_no( "msg_allow_code", $INFO['msg_allow_code']  )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\bTϥ HTML?</b>" ,
										  $SKIN->form_yes_no( "msg_allow_html", $INFO['msg_allow_html']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>˵TCɨCܪT</b><br>w] 50" ,
										  $SKIN->form_input( "show_max_msg_list", $INFO['show_max_msg_list']  )
								 )      );
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// EMAIL functions
	//--------------------------------------------------------------
	
	function email()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('doemail', 'qll]w', 'ziHbUܧ]w');
		
		$ADMIN->html .= $SKIN->add_td_basic( 'qll}', 'left', 'catrow2' );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>׾±qll}</b>" ,
										  $SKIN->form_input( "email_in", $INFO['email_in']  )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>׾¥~Hqll}</b>" ,
										  $SKIN->form_input( "email_out", $INFO['email_out']  )
								 )      );
								 
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_basic( 'l覡', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>l覡</b><br>pG PHP  mail() iϥΡAп SMTP" ,
										  $SKIN->form_dropdown( "mail_method", 
										  						 array(
										  						 		0 => array( 'mail', 'PHP mail()' ),
										  						 		1 => array( 'smtp', 'SMTP'  ),
										  						 	  ),
										  						 $INFO['mail_method']  )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_basic( 'SMTP ﶵ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>r SMTP D?</b><br>w]O 'localhost'" ,
										  $SKIN->form_input( "smtp_host", $INFO['smtp_host']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>r SMTP ?</b><br>w]O 25" ,
										  $SKIN->form_input( "smtp_port", $INFO['smtp_port']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϥΪ̦W</b><br>ϥ 'localhost' ɡAhbݭn" ,
										  $SKIN->form_input( "smtp_user", $INFO['smtp_user']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>SMTP KX</b><br>ϥ 'localhost' ɡAhbݭn" ,
										  $SKIN->form_input( "smtp_pass", $INFO['smtp_pass']  )
								 )      );
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// URLs and ADDRESSES
	//--------------------------------------------------------------
	
	function url()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('dourl', ']w', 'ziHbUܧ]w');
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_basic( '׾¦WٻP HTTP }', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>׾¦W</b>" ,
										  $SKIN->form_input( "board_name", $INFO['board_name']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>׾º}</b>" ,
										  $SKIN->form_input( "board_url", $INFO['board_url']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>W</b><br>(Dثe Invision Power Board bϥΪ)" ,
										  $SKIN->form_input( "home_name", $INFO['home_name']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>}</b><br>(Dثe Invision Power Board bϥΪ)" ,
										  $SKIN->form_input( "home_url", $INFO['home_url']  )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>HTML URL</b><br>Ϥ..." ,
										  $SKIN->form_input( "html_url", $INFO['html_url']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>W URL</b>" ,
										  $SKIN->form_input( "upload_url", $INFO['upload_url']  )
								 )      );
								 					 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( '׾¦A|', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>'html' ؿ|</b><br>`NGoO|AO URL" ,
										  $SKIN->form_input( "html_dir", $INFO['html_dir']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Wǥؿ</b>" ,
										  $SKIN->form_input( "upload_dir", $INFO['upload_dir']  )
								 )      );
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'HTTP ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>X HTTP Y?</b><br>(Y NT w˻ݭnN)" ,
										  $SKIN->form_yes_no( "print_headers", $INFO['print_headers'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b><i></I> GZIP sX?</b><br>(GZIP iH[֭ǰeέCWeϥ)" ,
										  $SKIN->form_yes_no( "disable_gzip", $INFO['disable_gzip'] )
								 )      );
								 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>۰ʭsɦV?</b><br>(oAΩֳtLsɦV)" ,
										  $SKIN->form_dropdown( 'header_redirect', 
										  						 array(
										  						 		0 => array( 'location', 'wκA (*nix savvy)' ),
										  						 		1 => array( 'refresh' , 'sz (Windows savvy)' ),
										  						 		2 => array( 'html'    , 'HTML META sɦV (pGѪ...)' ),
										  						 	  ),
										  						 $INFO['header_redirect']  )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'Debugging', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>h</b>" ,
										  $SKIN->form_dropdown( "debug_level", 
										  						 array(
										  						 		0 => array( 0, '0: None - nܥ󰣿T' ),
										  						 		1 => array( 1, '1: ܦAtBͮɶάd߭p' ),
										  						 		2 => array( 2, '2: ܼh 1 (W)  GETBPOST T'),
										  						 		3 => array( 3, '3: ܼh 1 + 2 θƮwd'),
										  						 	  ),
										  						 $INFO['debug_level']  )
								 )      );
								 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b><i>ҥ</I> SQL Ҧ?</b><br>(pGOAN '&debug=1' [󭶭HK˵ mySQL T)" ,
										  $SKIN->form_yes_no( "sql_debug", $INFO['sql_debug'] )
								 )      );
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( '魱O]w', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϥΦwҦO?</b><br>(`NGpGzgۭq/sLOAboӧܤziॲAPBƱzҪOեC)" ,
										  $SKIN->form_dropdown( 'safe_mode_skins', 
										  						 array(
										  						 		0 => array( '0', '_' ),
										  						 		1 => array( '1' , 'O' ),
										  						 	  ),
										  						 $INFO['safe_mode_skins']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Ʀr榡</b><br>ziHܥΩjdBʪr<br>(ҦpGέ^ϥγr)" ,
										  $SKIN->form_dropdown( 'number_format', 
										  						 array(
										  						 		0 => array( 'L', 'ϥ' ),
										  						 		1 => array( 'Ů' , 'Ů' ),
										  						 		2 => array( ',' , ',' ),
										  						 		3 => array( '.' , '.' ),
										  						 	  ),
										  						 $INFO['number_format']  )
								 )      );
								 
 
		$this->common_footer();
	
	
	}
	
	
	
	//-------------------------------------------------------------
	// CPU SAVING
	//--------------------------------------------------------------
	
	function cpu()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('docpu', 'CPU `', 'ziHYǥ\H`ٸ귽ӥ');
		
		
		if ($INFO['au_cutoff'] == "")
		{
			$INFO['au_cutoff'] = 15;
		}
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'SQL `', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ܬʨϥΪ?</b>" ,
										  $SKIN->form_yes_no( "show_active", $INFO['show_active'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ܭYzHʨϥΪ</b>" ,
										  $SKIN->form_input( "au_cutoff", $INFO['au_cutoff'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ܥͤ?</b>" ,
										  $SKIN->form_yes_no( "show_birthdays", $INFO['show_birthdays'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ܽ׾²έp?</b>" ,
										  $SKIN->form_yes_no( "show_totals", $INFO['show_totals'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ܰQװϮɼаOϥΪ̰ѻPoLDD?</b>" ,
										  $SKIN->form_yes_no( "show_user_posted", $INFO['show_user_posted'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> 'ϥΪ̥s <u>Qװ</u>' \?</b><br>(C˵QװϮɥiH` 1 Ӭd)" ,
										  $SKIN->form_yes_no( "no_au_forum", $INFO['no_au_forum'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> 'ϥΪ̥s <u>DD</u>' \?</b><br>(C˵DDɥiH` 1 Ӭd)" ,
										  $SKIN->form_yes_no( "no_au_topic", $INFO['no_au_topic'] )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'CPU `', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>At</b><br>F쭭ɱN 'L' T<br>iHdŤ" ,
										  $SKIN->form_input( "load_limit", $INFO['load_limit']  )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\ϥΪ (Q\a) ϥηjM?</b>" ,
										  $SKIN->form_yes_no( "allow_search", $INFO['allow_search'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>jM峹 [x] Ӧr</b><br>AΦbH峹ܷjMG" ,
										  $SKIN->form_input( "search_post_cut", $INFO['search_post_cut'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̤pjMr</b><br>\ujMriHǦ^hGAҦp 'if', 'at', " ,
										  $SKIN->form_input( "min_search_word", $INFO['min_search_word'] )
								 )      );
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'Bandwidth Savings', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>X HTTP L֨Y?</b><br>(o|s֨)" ,
										  $SKIN->form_yes_no( "nocache", $INFO['nocache'] )
								 )      );
								 
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>²uQװϸDC?</b><br>o|NlQװϱqUԦC - pGzܦhlQװϳoZΪ" ,
										  $SKIN->form_yes_no( "short_forum_jump", $INFO['short_forum_jump'] )
								 )      );
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// DATES
	//--------------------------------------------------------------
	
	function dates()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('dodates', '', 'wq榡');
		
		$time_array = array();
		
		require ROOT_PATH."lang/en/lang_ucp.php";
		
		foreach( $lang as $off => $words )
 		{
 			if (preg_match("/^time_(\S+)$/", $off, $match))
 			{
 				$time_select[] = array( $match[1], $words );
 			}
 		}
 		
 		$d_date = $std->get_date(time(), 'LONG');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ͦAɰ</b><br><span style='color:red'>pGzwgܤFTɰϨåB@pɪ~tAoO]`ɪtGAz|iHgѨϥΪ̱xsL̪ '׾³]w' Ӯե.</span>" ,
										  $SKIN->form_dropdown( "time_offset", $time_select, $INFO['time_offset']  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Aɶվ ()</b><br>LզAɶApGzݭnqAɶּƤAƦr}YХ[W '-' (޸)." ,
										  $SKIN->form_input( "time_adjust", $INFO['time_adjust'] ) . "<br>׾®ɶ (XWɰϤΥثeվ) {b: $d_date"
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>uɶ榡</b><br>tm覡P <a href='http://www.php.net/date' target='_blank'>PHP Date</a> ۦP" ,
										  $SKIN->form_input( "clock_short", $INFO['clock_short'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Uɶ榡</b><br>tm覡P <a href='http://www.php.net/date' target='_blank'>PHP Date</a> ۦP" ,
										  $SKIN->form_input( "clock_joined", $INFO['clock_joined'] )
								 )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ɶ榡</b><br>tm覡P <a href='http://www.php.net/date' target='_blank'>PHP Date</a> ۦP" ,
										  $SKIN->form_input( "clock_long", $INFO['clock_long'] )
								 )      );
 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// AVATARS
	//--------------------------------------------------------------
	
	function avatars()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('doavatars', 'ϥΪ̭ӤH', 'wqϥΪ̭ӤHv');
		
		$INFO['avatar_ext'] = preg_replace( "/\|/", ",", $INFO['avatar_ext'] );
		
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ϥΪ̭ӤH & ﶵ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\|ܭO?</b>" ,
										  $SKIN->form_yes_no( "allow_skins", $INFO['allow_skins'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>|ܧYΩһݪ峹?</b><br>dūh|T" ,
										  $SKIN->form_input( "post_titlechange", $INFO['post_titlechange'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>mפW (줸)</b>" ,
										  $SKIN->form_input( "max_location_length", $INFO['max_location_length'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>פW (줸)</b>" ,
										  $SKIN->form_input( "max_interest_length", $INFO['max_interest_length'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϥΪñWפW (줸)</b>" ,
										  $SKIN->form_input( "max_sig_length", $INFO['max_sig_length'] )
								 )      );						 
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\ñWɨϥ HTML?</b>" ,
										  $SKIN->form_yes_no( "sig_allow_html", $INFO['sig_allow_html'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\ñWɨϥ IBF Code?</b>" ,
										  $SKIN->form_yes_no( "sig_allow_ibc", $INFO['sig_allow_ibc'] )
								 )      );
								 
		if ($INFO['postpage_contents'] == "")
		{
			$INFO['postpage_contents'] = '5,10,15,20,25,30,35,40';
		}
		
		if ($INFO['topicpage_contents'] == "")
		{
			$INFO['topicpage_contents'] = '5,10,15,20,25,30,35,40';
		}
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϥΪ̥iܪC峹ƤUԿ椺e</b><br>Hrj}A|۰ʥ[J 'ϥν׾¹w]'<br>dҡG 5,15,20,25,30" ,
										  $SKIN->form_input( "postpage_contents", $INFO['postpage_contents'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϥΪ̥iܪQװϭDDƤUԿ椺e</b><br>Hrj}A|۰ʥ[J 'ϥν׾¹w]'<br>dҡG 5,15,20,25,30" ,
										  $SKIN->form_input( "topicpage_contents", $INFO['topicpage_contents'] )
								 )      );
								 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>pGDDWL [x] ѨS^Ц۰ʨq\</b><br>dūh|۰ʨ" ,
										  $SKIN->form_input( "subs_autoprune", $INFO['subs_autoprune'] )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'ӤHϤ', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\|ϥΤjY?</b>" ,
										  $SKIN->form_yes_no( "avatars_on", $INFO['avatars_on'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\ϤɦW</b><br>Hrj} (gif,png,jpeg) " ,
										  $SKIN->form_input( "avatar_ext", $INFO['avatar_ext'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\ϥλ URL ӤHϤ?</b>" ,
										  $SKIN->form_yes_no( "avatar_url", $INFO['avatar_url'] )
								 )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>WǪӤHϤɮפjpW? (K)</b>" ,
										  $SKIN->form_input( "avup_size_max", $INFO['avup_size_max'] )
								 )      );
 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ӤHϤ̤jؤo</b><br>(e<b>x</b>))" ,
										  $SKIN->form_input( "avatar_dims", $INFO['avatar_dims'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>w]ӤHϤؤo</b><br>(e<b>x</b>)" ,
										  $SKIN->form_input( "avatar_def", $INFO['avatar_def'] )
								 )      );
								 
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'Xv', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\XȬݨñW?</b>" ,
										  $SKIN->form_yes_no( "guests_sig", $INFO['guests_sig'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\XȬݨiKϤ?</b>" ,
										  $SKIN->form_yes_no( "guests_img", $INFO['guests_img'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\XȬݨϥΪ̭ӤHϤ?</b>" ,
										  $SKIN->form_yes_no( "guests_ava", $INFO['guests_ava'] )
								 )      );
								 
			     
								 					 
		$this->common_footer();
	
	
	}
	
	
	//-------------------------------------------------------------
	// TOPICS and POSTS
	//--------------------------------------------------------------
	
	function post()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$INFO['img_ext'] = preg_replace( "/\|/", ",", $INFO['img_ext'] );
	
		$this->common_header('dopost', 'DDB峹εo', ']wioM.');
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'DD', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------	
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>QװϨCDD</b>" ,
										  $SKIN->form_input( "display_max_topics", $INFO['display_max_topics'] )
								 )      );
									     
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Хܬ 'DD' һݪ峹?</b>" ,
										  $SKIN->form_input( "hot_topic", $INFO['hot_topic'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>TwDDemW</b>" ,
										  $SKIN->form_input( "pre_pinned", $INFO['pre_pinned'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>hDDemW</b>" ,
										  $SKIN->form_input( "pre_moved", $INFO['pre_moved'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>벼DDemW</b>" ,
										  $SKIN->form_input( "pre_polls", $INFO['pre_polls'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>bDDDWH?</b><br>(|N CLICK HERE ର Click Here)<br>ĶGҥγoӿﶵ|D" ,
										  $SKIN->form_yes_no( "etfilter_shout", $INFO['etfilter_shout'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>DDDWhl۸/ݸ?</b><br>(|N This!!!!! ର This!)" ,
										  $SKIN->form_yes_no( "etfilter_punct", $INFO['etfilter_punct'] )
								 )      );						 
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( '峹 & o', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------	
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>CӥDD峹</b>" ,
										  $SKIN->form_input( "display_max_posts", $INFO['display_max_posts'] )
								 )      );						 
								 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>C@ӪCiϥܼƶq</b>" ,
										  $SKIN->form_input( "emo_per_row", $INFO['emo_per_row'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Cg峹iΪϥܤW</b>" ,
										  $SKIN->form_input( "max_emos", $INFO['max_emos'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Cg峹iiKϤW</b>" ,
										  $SKIN->form_input( "max_images", $INFO['max_images'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Cg峹jpW (d줸 [k])</b>" ,
										  $SKIN->form_input( "max_post_length", $INFO['max_post_length'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>iK Flash veפW ( pixels)</b>" ,
										  $SKIN->form_input( "max_w_flash", $INFO['max_w_flash'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>iK Flash vפW ( pixels)</b>" ,
										  $SKIN->form_input( "max_h_flash", $INFO['max_h_flash'] )
								 )      );
								 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>iiKĹϤɦW</b><br>(Hrj (gif,jpeg,jpg) " ,
										  $SKIN->form_input( "img_ext", $INFO['img_ext'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>b峹ܤWǪϤ?</b>" ,
										  $SKIN->form_yes_no( "show_img_upload", $INFO['show_img_upload'] )
								 )      );					 
		
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>TOި?</b><br>o|NޥΪ峹tިr<br><a href='#' title='pGo󪺷NqAz IQ ٰC'>..</a>" ,
										  $SKIN->form_yes_no( "strip_quotes", $INFO['strip_quotes'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>XȦW <i>r</i></b><br>(XȥHP|ۦPWٵoɡAo˥iHIϧOHקKVc)" ,
										  $SKIN->form_input( "guest_name_pre", $INFO['guest_name_pre'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>XȦW <i>r</i></b><br>(XȥHP|ۦPWٵoɡAo˥iHIϧOHקKVc)" ,
										  $SKIN->form_input( "guest_name_suf", $INFO['guest_name_suf'] )
								 )      );
								 
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( '벼', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\벼ﶵϥ [IMG]  [URL] ?</b>" ,
										  $SKIN->form_yes_no( "poll_tags", $INFO['poll_tags'] )
								 )      );
								 						 						 					 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// SECURITY
	//--------------------------------------------------------------
	
	function secure()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('dosecure', 'w', 'ϥΤUtmwqz׾ªwʳBzh');
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'w ()', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\ʺAϤ?</b><br>pG 'O' ϥΪ̥iHiK{ƪϤ;" ,
										  $SKIN->form_yes_no( "allow_dynamic_img", $INFO['allow_dynamic_img'] )
								 )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Session O ()</b><br>wgWLzwm sessions" ,
										  $SKIN->form_input( "session_expiration", $INFO['session_expiration'] )
								 )      );
 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>{ҮɰtXϥΪ̪s?</b>" ,
										  $SKIN->form_yes_no( "match_browser", $INFO['match_browser'] )
								 )      );
								 
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'w ()', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ҰʾH (Bot) U?</b><br>jϥΪ̿JHNXHϥε{BݵU".$SKIN->js_help_link('s_reg_antispam') ,
										  $SKIN->form_yes_no( "reg_antispam", $INFO['reg_antispam'] )
								 )      );		  
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϥΦwl@|l󩹪?</b><br>èϥΪ̪qll}" ,
										  $SKIN->form_yes_no( "use_mail_form", $INFO['use_mail_form'] )
								 )      );
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'w (C)', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------						 
								 					 
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\iKϤ?</b><br>i{]pvjϤ@{AL IBF iѳoӤkMI." ,
										  $SKIN->form_yes_no( "allow_images", $INFO['allow_images'] )
								 )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\b峹έӤHϤϥ flash v?</b><br>Flash ت{yAiMΦw" ,
										  $SKIN->form_yes_no( "allow_flash", $INFO['allow_flash'] )
								 )      );	
								 
								 
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'w (QϥΪ)', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------						 					 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϥΪ̵Uɤ\ƪqll?</b><br>|ˬdO_sbۦPqll}" ,
										  $SKIN->form_yes_no( "allow_dup_email", $INFO['allow_dup_email'] )
								 )      );
		
						 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Hqll{ҷsHU?</b><br>޲zHuwҦsbAΪsϥΪ̥HL̪qll}{" ,
										  $SKIN->form_dropdown( "reg_auth_type", 
										  						array(
										  								0 => array( 'user' , 'ϥΪ̹qll{' ),
										  								1 => array( 'admin', '޲z{'      ),
										  								2 => array( '0'    , ''                  )
										  							 ),
										  					    $INFO['reg_auth_type']
										  					  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>sHUɡAHqllq޲z?</b>" ,
										  $SKIN->form_dropdown( "new_reg_notify", 
										  						array(
										  								0 => array( '1' , 'O' ),
										  								1 => array( '0' , '_'  )
										  							 ),
										  					    $INFO['new_reg_notify']
										  					  )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>jXȵnJ~is׾?</b>" ,
										  $SKIN->form_yes_no( "force_login", $INFO['force_login'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>TsHU?</b>" ,
										  $SKIN->form_yes_no( "no_reg", $INFO['no_reg'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> '|g峹' s?</b>" ,
										  $SKIN->form_yes_no( "disable_reportpost", $INFO['disable_reportpost'] )
								 )      ); // 
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b> ()</b><br>ϥΪ̻ݵݭYzɶ~Ao<br>iHdŤi" ,
										  $SKIN->form_input( "flood_control", $INFO['flood_control'] )
								 )      );
		
		//-----------------------------------------------------------------------------------------------------------						 
		
		$ADMIN->html .= $SKIN->add_td_basic( 'p', 'left', 'catrow2' );
		
		//-----------------------------------------------------------------------------------------------------------	
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\ϥΪsuWHC?</b>" ,
										  $SKIN->form_yes_no( "allow_online_list", $INFO['allow_online_list'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>T̰޲zs˵uWΦWϥΪ?</b><br>ΦWϥΪ̦bL̪W٫᭱|P" ,
										  $SKIN->form_yes_no( "disable_admin_anon", $INFO['disable_admin_anon'] )
								 )      );
								 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>T̰޲zs˵uWCϥΪ IP }?</b>" ,
										  $SKIN->form_yes_no( "disable_online_ip", $INFO['disable_online_ip'] )
								 )      );
								 
		
								 					 
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	// COOKIES: Yum Yum!
	//--------------------------------------------------------------
	
	function cookie()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
	
		$this->common_header('docookie', 'Cookies', 'oiHdšCйݬݧXzDT]w');
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Cookie </b><br>ܡGϥ <b>.your-domain.com</b> @ cookies" ,
										  $SKIN->form_input( "cookie_domain", $INFO['cookie_domain'] )
								 )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Cookie W٦r</b><br>\hӽ׾¦bP@D." ,
										  $SKIN->form_input( "cookie_id", $INFO['cookie_id'] )
								 )      );
 
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Cookie |</b><br>q IBF ڥؿ۹|" ,
										  $SKIN->form_input( "cookie_path", $INFO['cookie_path'] )
								 )      );
		
		$this->common_footer();
	
	
	}
	
	//-------------------------------------------------------------
	//
	// Save config. Does the hard work, so you don't have to.
	//
	//--------------------------------------------------------------
	
	function save_config( $new )
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		$master = array();
		
		if ( is_array($new) )
		{
			if ( count($new) > 0 )
			{
				foreach( $new as $field )
				{
				
					// Handle special..
					
					if ($field == 'img_ext' or $field == 'avatar_ext')
					{
						$HTTP_POST_VARS[ $field ] = preg_replace( "/[\.\s]/", "" , $HTTP_POST_VARS[ $field ] );
						$HTTP_POST_VARS[ $field ] = preg_replace( "/,/"     , '|', $HTTP_POST_VARS[ $field ] );
					}
					else if ($field == 'coppa_address')
					{
						$HTTP_POST_VARS[ $field ] = nl2br( $HTTP_POST_VARS[ $field ] );
					}
					
					$HTTP_POST_VARS[ $field ] = preg_replace( "/'/", "&#39;", ($HTTP_POST_VARS[ $field ]) );
				
					$master[ $field ] = ($HTTP_POST_VARS[ $field ]);
				}
				
				$ADMIN->rebuild_config($master);
			}
		}
		
		$ADMIN->save_log("Board Settings Updated, Back Up Written");
		
		$ADMIN->done_screen("׾³]wws", "޲zx", "act=index" );
		
		
		
	}
	//-------------------------------------------------------------
	//
	// Common header: Saves writing the same stuff out over and over
	//
	//--------------------------------------------------------------
	
	function common_header( $formcode = "", $section = "", $extra = "" )
	{
	
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$extra = $extra ? $extra."<br>" : $extra;
		
		$ADMIN->page_detail = $extra . "ЦbTwܧ󤧫eˬdzҿJ";
		$ADMIN->page_title  = "׾³]w ($section)";
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , $formcode ),
												  2 => array( 'act'   , 'op'      ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "]w" );
		
	}

	//-------------------------------------------------------------
	//
	// Common footer: Saves writing the same stuff out over and over
	//
	//--------------------------------------------------------------
	
	function common_footer( $button="Twܧ" )
	{
	
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;

		$ADMIN->html .= $SKIN->end_form($button);
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
	}				
}


?>