<?php

/*
+--------------------------------------------------------------------------
|   Invision Power Board v1.1
|   ========================================
|   by Matthew Mecham
|   (c) 2001,2002 Invision Power Services
|   http://www.ibforums.com
|   ========================================
|   Web: http://www.ibforums.com
|   Email: phpboards@ibforums.com
|   Licence Info: phpib-licence@ibforums.com
+---------------------------------------------------------------------------
|
|   > Admin Forum functions
|   > Module written by Matt Mecham
|   > Date started: 1st march 2002
|
|	> Module Version Number: 1.0.0
+--------------------------------------------------------------------------
*/

$idx = new ad_forums();

class ad_forums {

	var $base_url;

	function ad_forums() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $ibforums;
		
		//---------------------------------------
		// Kill globals - globals bad, Homer good.
		//---------------------------------------
		
		$tmp_in = array_merge( $_GET, $_POST, $_COOKIE );
		
		foreach ( $tmp_in as $k => $v )
		{
			unset($$k);
		}
		
		//---------------------------------------

		switch($IN['code'])
		{
			case 'stepone':
				$this->do_advanced_search(1);
				break;
			case 'doform':
				$this->do_edit_form();
				break;
			case 'doedit':
				$this->do_edit();
				break;
			case 'advancedsearch':
				$this->do_advanced_search();
				break;
			//---------------------
			case 'add':
				$this->add_form();
				break;
			case 'doadd':
				$this->do_add();
				break;
			//---------------------
			case 'del':
				$this->delete_form();
				break;
			case 'delete2':
				$this->delete_lookup_form();
				break;
			case 'dodelete':
				$this->dodelete();
				break;
			case 'prune':
				$this->prune_confirm();
				break;
			case 'doprune':
				$this->doprune();
				break;
			//---------------------
			case 'title':
				$this->titles();
				break;
			case 'rank_edit':
				$this->rank_setup('edit');
				break;
			case 'rank_add':
				$this->rank_setup('add');
				break;
			case 'do_add_rank':
				$this->add_rank();
				break;
			case 'do_rank_edit':
				$this->edit_rank();
				break;
			case 'rank_delete':
				$this->delete_rank();
				break;
			//---------------------
			case 'ban':
				$this->ban_control();
				break;
			case 'doban':
				$this->update_ban();
				break;
			//---------------------
			case 'mod':
				$this->view_mod();
				break;
			case 'domod':
				$this->domod();
				break;
			//---------------------
			case 'changename':
				$this->change_name_start();
				break;
			case 'dochangename':
				$this->change_name_complete();
				break;
			//---------------------	
			case 'mail':
				$this->bulk_mail_form();
				break;
			case 'domail':
				$this->do_bulk_mail();
				break;
			//---------------------
			default:
				$this->search_form();
				break;
		}
		
	}
	
	//+---------------------------------------------------------------------------------
	//
	// MASS EMAIL PEOPLE!
	//
	//+---------------------------------------------------------------------------------
	
	function do_bulk_mail() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		// Get the ID's of the groups we're emailing.
		
		$ids = array();
 		
 		foreach ($IN as $key => $value)
 		{
 			if ( preg_match( "/^sg_(\d+)$/", $key, $match ) )
 			{
 				if ($IN[$match[0]])
 				{
 					$ids[] = $match[1];
 				}
 			}
 		}
 		
 		if ( count($ids) < 1 )
 		{
 			$this->bulk_mail_form(1, '~', 'zܤ֥ܤ@ӸsեHHol');
 			exit();
 		}
 		
 		if ($IN['title'] == "")
 		{
 			$this->bulk_mail_form(1, '~', 'zlqw@ӼD');
 			exit();
 		}
 		
 		if ($IN['email_contents'] == "")
 		{
 			$this->bulk_mail_form(1, '~', 'qllD饲tre');
 			exit();
 		}
 		
 		$group_str = implode( ",", $ids);
 		
 		// Sort out the rest of the DB stuff
 		
 		$where = ""; // Where? who knows? who cares?
 		
 		if ($IN['posts'] > 0)
 		{
 			$where .= " AND posts < ".$IN['posts'];
 		}
 		
 		if ($IN['days'] > 0)
 		{
 			$time = time() - ($IN['days']*60*60*24);
 			$where .= " AND last_activity < '$time'";
 		}
 		
 		if ($IN["honour_user_setting"] == 1)
 		{
 			$where .= "AND allow_admin_mails=1";
 		}
 		
 		//+---------------------------------------
 		// Get a grip, er count
 		//+---------------------------------------
 		
 		$DB->query("SELECT COUNT(uid) as total FROM xbb_members WHERE mgroup IN($group_str)".$where);
 		
 		$rows = $DB->fetch_row();
 		
 		if ($rows['total'] < 1)
 		{
 			$this->bulk_mail_form(1, '~', 'ЩezзǡA]ҴѪTLknHoqll󪺷|');
 			exit();
 		}
 		
 		//+---------------------------------------
 		// Regex up stuff
		//+---------------------------------------
		
		$DB->query("SELECT * FROM ibf_stats");
		$stats = $DB->fetch_row();
		
		$contents = ($HTTP_POST_VARS['email_contents']);
		
		$contents = str_replace( "{board_name}" , str_replace( "&#39;", "'", $INFO['board_name'] ) , $contents );
		$contents = str_replace( "{board_url}"  , $INFO['board_url']."/index.".$INFO['php_ext'] , $contents );
		$contents = str_replace( "{reg_total}"  , $stats['MEM_COUNT'] , $contents );
		$contents = str_replace( "{total_posts}", $stats['TOTAL_TOPICS'] + $stats['TOTAL_REPLIES'] , $contents );
		$contents = str_replace( "{busy_count}" , $stats['MOST_COUNT'] , $contents );
		$contents = str_replace( "{busy_time}"  , $std->get_date( $stats['MOST_DATE'], 'SHORT' ), $contents );

 		
 		//+---------------------------------------
 		// Are we previewing? Why am I asking you?
		//+---------------------------------------
		
		if ($IN['preview'] != "")
		{
			$this->bulk_mail_form(1, 'w',
									 "<b>".($HTTP_POST_VARS['title'])."</b><br><br>"
									 .$contents."<br><br><b>nHo|:</b> ".$rows['total']
								 );
 			exit();
 		}
 		
 		//+---------------------------------------
 		// We're still here? GROOVY, send da mail
		//+---------------------------------------
		
		@set_time_limit(1200);
		
		require ROOT_PATH."sources/lib/emailer.php";
		
		$this->email = new emailer();
		
		$this->email->bcc = array();
		
		$DB->query("SELECT email FROM xbb_members WHERE mgroup IN($group_str)".$where);
		
		while ( $r = $DB->fetch_row() )
		{
			if ($r['email'] != "")
			{
				$this->email->bcc[] = $r['email'];
			}
		}
		
		$this->email->message = str_replace( "\r\n", "\n", $contents);
		$this->email->subject = ($HTTP_POST_VARS['title']);
		
		if ($IN['email_admin'] == 1)
		{
			$this->email->to = $INFO['email_in'];
		}
		else
		{
			$this->email->to = "";
		}
		
		$this->email->send_mail();
		
		$ADMIN->save_log("soqll| ($where)");
		
		$ADMIN->done_screen("soqllwHX", "|", "act=mem" );
		
	}
	
	
	
	
	function bulk_mail_form($preview=0, $title='Preview', $content="") {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		
		$ADMIN->page_title = "so|qll";
		
		$ADMIN->page_detail = "ziHtmUsoqll󵹱z|.  'ֳt' sohT";
		
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'domail'  ),
												  2 => array( 'act'   , 'mem'     ),
									     )      );
									     
		if ($HTTP_POST_VARS['email_contents'] == "")
		{
			$HTTP_POST_VARS['email_contents'] = "\n\n\n-------------------------------------\n{board_name} έp:\n"
								   ."-------------------------------------\nUϥΪ: {reg_total}\n峹`: {total_posts}\n"
								   ."cɶ: {busy_time}  {busy_count} ϥΪ̦PɦbuW\n\n"
								   ."-------------------------------------\nKQs\n"
								   ."-------------------------------------\n׾¦}: {board_url}\nnJ: {board_url}?act=Login&CODE=00\n"
								   ."򥢱KX^_: {board_url}?act=Reg&CODE=10\n\n"
								   ."-------------------------------------\npq\n"
								   ."-------------------------------------\npq ({board_url}?act=UserCP&CODE=02) åBTw"
								   ." 'ѽ׾º޲zHX' AMeX";
		}
		
		if ($preview == 1)
		{
			$SKIN->td_header[] = array( "&nbsp;"  , "100%" );
			
			$ADMIN->html .= $SKIN->start_table( $title );
			
			$ADMIN->html .= $SKIN->add_td_row( array( nl2br($content) ) );
			
			$ADMIN->html .= $SKIN->end_table();
		}
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "so|qll: e" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>LϥΪ '\޲zqll' ]w?</b><br>jP˱zu!" ,
												  $SKIN->form_yes_no( "honour_user_setting", isset($IN["honour_user_setting"]) ? $IN["honour_user_setting"] : 1 )
									     	)      );
		
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>qllD</b>" ,
												  $SKIN->form_input( "title", ($HTTP_POST_VARS['title']) )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>qll󤺮e</b><br>".$SKIN->js_help_link('m_bulkemail') ,
												  $SKIN->form_textarea( "email_contents", ($HTTP_POST_VARS['email_contents']), 60, 15 )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Nqllǰe޲zH}?</b><br>pGzbeXɵoͶl~бҥγoӿﶵ - ϥ SMTP ɥo˰." ,
												  $SKIN->form_yes_no( "email_admin", isset($IN['email_admin']) ? $IN['email_admin'] : 1 )
									     )      );
									     							     
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "so|qll: ]w" );
		
		$DB->query("SELECT g_id, g_title FROM ibf_groups WHERE g_id <> ".$INFO['guest_group']." ORDER BY g_title");
		
		while ( $r = $DB->fetch_row() )
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>Hs <span style='color:red'>{$r['g_title']}</span></b>" ,
												  $SKIN->form_yes_no( "sg_{$r['g_id']}", isset($IN['sg_'.$r['g_id']]) ? $IN['sg_'.$r['g_id']] : 1 )
									     	)      );
		}
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϥΪ̵oƤ֩ [x] g</b><br>dŮɱHoqll󤣦Ҽ{峹" ,
												  $SKIN->form_input( "post", $IN['post'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ϥΪ̶WL [x] ѥWu</b><br>dŮɱHoqll󤣦Ҽ{̫Xݮɶ" ,
												  $SKIN->form_input( "days", $IN['days'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_basic( '<input type="submit" name="preview" value="w">', 'center' );
		
		$ADMIN->html .= $SKIN->end_form("Bz");
		
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
	}
	
		
	//+---------------------------------------------------------------------------------
	//
	// CHANGE MEMBER NAME
	//
	//+---------------------------------------------------------------------------------
	
	function change_name_complete() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		if ($IN['mid'] == "")
		{
			$ADMIN->error("zw@ӦĪ| idAЪ^");
		}
		
		if ($IN['new_name'] == "")
		{
			$this->change_name_start("z|J@ӷsW");
			exit();
		}
		
		$DB->query("SELECT uname, email FROM xbb_members WHERE uid='".$IN['mid']."'");
		
		if ( ! $member = $DB->fetch_row() )
		{
			$ADMIN->error("|ƮwLŦX ID");
		}
		
		$mid = $IN['mid']; // Save me poor ol' carpels
		
		if ($IN['new_name'] == $member['uname'])
		{
			$this->change_name_start("s¦W٬ۦP,oOX޿誺");
			exit();
		}
		
		// Check to ensure that his member name hasn't already been taken.
		
		$new_name = trim($IN['new_name']);
		
		$DB->query("SELECT uid FROM xbb_members WHERE LOWER(uname)='".strtolower($new_name)."'");
		
		if ( $DB->get_num_rows() )
		{
			$this->change_name_start("oӦW '$new_name' wgsbAХtL");
			exit();
		}
		
		// If one gets here, one can assume that the new name is correct for one, er...one.
		// So, lets do the converteroo
		
		$DB->query("UPDATE xbb_members SET uname='$new_name' WHERE uid='$mid'");
		$DB->query("UPDATE ibf_contacts SET contact_name='$new_name' WHERE contact_id='$mid'");
		$DB->query("UPDATE ibf_forums SET last_poster_name='$new_name' WHERE last_poster_id='$mid'");
		$DB->query("UPDATE ibf_moderator_logs SET member_name='$new_name' WHERE member_id='$mid'");
		$DB->query("UPDATE ibf_moderators SET member_name='$new_name' WHERE member_id='$mid'");
		$DB->query("UPDATE ibf_posts SET author_name='$new_name' WHERE author_id='$mid'");
		$DB->query("UPDATE ibf_sessions SET member_name='$new_name' WHERE member_id='$mid'");
		$DB->query("UPDATE ibf_topics SET starter_name='$new_name' WHERE starter_id='$mid'");
		$DB->query("UPDATE ibf_topics SET last_poster_name='$new_name' WHERE last_poster_id='$mid'");
		
		// I say, did we choose to email 'dis member?
		
		if ($IN['send_email'] == 1)
		{
			// By golly, we did!
			
			require ROOT_PATH."sources/lib/emailer.php";
		
			$this->email = new emailer();
			
			$msg = trim($HTTP_POST_VARS['email_contents']);
			
			$msg = str_replace( "{old_name}", $member['uname'], $msg );
			$msg = str_replace( "{new_name}", $new_name      , $msg );
			
			$this->email->message = $this->email->clean_message($msg);
			$this->email->subject = "|Wܧq";
			$this->email->to      = $member['email'];
			$this->email->send_mail();
		}
		
		$ADMIN->save_log("ܧ|W '{$member['name']}'  '$new_name'");
		
		$ADMIN->done_screen("|W٤wܧ", "|", "act=mem" );
	}
	
	//===========================================================================
	
	function change_name_start($message="") {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "ܧ|W";
		
		$ADMIN->page_detail = "ziHJ|sW";
		
		if ($IN['mid'] == "")
		{
			$ADMIN->error("zw@ӦĪ| idAЪ^");
		}
		
		$DB->query("SELECT uname FROM xbb_members WHERE uid='".$IN['mid']."'");
		
		if ( ! $member = $DB->fetch_row() )
		{
			$ADMIN->error("|ƮwLŦX ID");
		}
		
		$contents = "{old_name}\n޲zwgܧFzb {$INFO['board_name']} |W.\n\nzsW٬O: {new_name}\n\nШcO,zUϥγoӷsWٵnJ.\n׾¦}: {$INFO['board_url']}/index.php";
		
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'dochangename'  ),
												  2 => array( 'act'   , 'mem'       ),
												  3 => array( 'mid'   , $IN['mid']  ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "ܧ|W" );
		
		if ($message != "")
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>~T:</b>" ,
												  	  "<b><span style='color:red'>$message</span></b>",
									     	 )      );
		}
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ثe|W</b>" ,
												  $member['uname'],
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>s|W</b>" ,
												  $SKIN->form_input( "new_name", $IN['new_name'] )
									     )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Hqllq|?</b><br>(pGnAziHsUqll)" ,
												  $SKIN->form_yes_no( "send_email", 1 )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>qll󤺮e</b><br>(ҡG {old_name} = ثeW١A{new_name} = sW)" ,
												  $SKIN->form_textarea( "email_contents", $contents )
									     )      );
									     									     
		$ADMIN->html .= $SKIN->end_form("ܧ󦹷|W");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	}
	
	//+---------------------------------------------------------------------------------
	
	
	
	//+---------------------------------------------------------------------------------
	//
	// Moderation control...
	//
	//+---------------------------------------------------------------------------------
	
	function domod() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ids = array();
		
		foreach ($IN as $k => $v)
		{
			if ( preg_match( "/^mid_(\d+)$/", $k, $match ) )
			{
				if ($IN[ $match[0] ])
				{
					$ids[] = $match[1];
				}
			}
		}
		
		//-------------------
		
		if ( count($ids) < 1 )
		{
			$ADMIN->error("zSܥn֭ΧR|");
		}
		
		
		
		//-------------------
		
		if ($IN['type'] == 'approve')
		{
		
			//-------------------------------------------
			
			require ROOT_PATH."sources/lib/emailer.php";
			
			$email = new emailer();
			
			$email->get_template("complete_reg");
			
			$email->build_message( "" );
			
			$email->subject = "".$INFO['board_name']."bͮ";
			
			//-------------------------------------------
			
			$main = $DB->query("SELECT uid, email, validate_key, mgroup, prev_group FROM xbb_members WHERE uid IN(".implode( ",",$ids ).")");
			
			while( $row = $DB->fetch_row( $main ) )
			{
				if ($row['mgroup'] != $INFO['auth_group'])
				{
					continue;
				}
				
				if ($row['prev_group'] == "")
				{
					$row['prev_group'] = $INFO['member_group'];
				}
				
				$update = $DB->query("UPDATE xbb_members SET prev_group='', validate_key='', level='1', mgroup='".$row['prev_group']."' WHERE uid='".$row['uid']."'");
				
				$email->to = $row['email'];
				
				$email->send_mail();
			}
			
			$DB->query("SELECT uid, uname FROM xbb_members WHERE mgroup <> '".$INFO['auth_group']."' ORDER BY uid DESC LIMIT 0,1");
			$r = $DB->fetch_row();

			$DB->query("UPDATE ibf_stats SET MEM_COUNT=MEM_COUNT+".count($ids).", LAST_MEM_NAME='{$r['uname']}', LAST_MEM_ID='{$r['uid']}'");
			
			$ADMIN->save_log("֭㵥ݵU");
			
			$ADMIN->done_screen( count($ids)."|w֭", "޲zU", "act=mem&code=mod" );	
			
		}
		else
		{
			$DB->query("DELETE FROM xbb_members WHERE uid IN(".implode( ",",$ids ).")");
			
			$DB->query("DELETE from ibf_pfields_content WHERE member_id IN(".implode( ",",$ids ).")");

			// Convert their posts and topics into guest postings..
		
			$DB->query("UPDATE ibf_posts SET author_id='0' WHERE author_id IN(".implode( ",",$ids ).")");
		
			$DB->query("UPDATE ibf_topics SET starter_id='0' WHERE starter_id IN(".implode( ",",$ids ).")");
			
			//$DB->query("UPDATE ibf_stats SET MEM_COUNT=MEM_COUNT-".count($ids));
			
			$ADMIN->save_log("^ݵU");
			
			$ADMIN->done_screen( count($ids)."|w", "޲zU", "act=mem&code=mod" );
		}
		
	}
	
	
	//---------------------------------------------
	
	function view_mod() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title  = "޲zϥΪ̵U/qllܧC";
		
		$ADMIN->page_detail = "znD޲zbR»P|椧ewsb,iHbo̤\λ^U,]iHzλ^sqll}ܧ.<br><br>oӪ]z墨ǨSqll󪺤HU.";
		
		$DB->query("SELECT COUNT(uid) as mcount FROM xbb_members WHERE mgroup='".$INFO['auth_group']."' and (new_pass = '' or new_pass is null)");
		
		$row = $DB->fetch_row();
		
		$cnt = $row['mcount'] < 1 ? 0 : $row['mcount'];
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'domod'  ),
												  2 => array( 'act'   , 'mem'    ),
									     )      );
									     
		$SKIN->td_header[] = array( "|W"       , "30%" );
		$SKIN->td_header[] = array( "qll}"     , "30%" );
		$SKIN->td_header[] = array( "峹"             , "10%" );
		$SKIN->td_header[] = array( "U"     , "20%" );
		$SKIN->td_header[] = array( ""            , "10%" );
		
		$ADMIN->html .= $SKIN->start_table( "ݧ㪺ϥΪ" );
		
		$ADMIN->html .= $SKIN->add_td_basic( "<b>$cnt ϥΪ̻ݭnUιqllܧ{, 0 - 75</b>", "center", "title");
		
		if ($cnt > 0)
		{
			$DB->query("SELECT uname, uid, email, posts, user_regdate, coppa_user FROM xbb_members WHERE mgroup='".$INFO['auth_group']."' and (new_pass = '' or new_pass is null) ORDER BY user_regdate DESC LIMIT 0,75");
			
			while ( $r = $DB->fetch_row() )
			{
			
				if ($r['coppa_user'] == 1)
				{
					$coppa = '( COPPA Request )';
				}
				else
				{
					$coppa = "";
				}
				
				$ADMIN->html .= $SKIN->add_td_row( array( "<b>".$r['uname']."</b>$coppa" ,
												  		  $r['email'],
												  		  "<center>{$r['posts']}</center>",
												  		  $std->get_date( $r['user_regdate'], 'JOINED' ),
												  		  "<input type='checkbox' name='mid_{$r['uid']}' value='1'>"
											 )      );
			}
			
			$ADMIN->html .= $SKIN->add_td_basic("<select name='type' id='dropdown'><option value='approve'>֭oǱb</option><option value='delete'>RoǱb</option></select>", "center", "row1" );
			
		}
		
		$ADMIN->html .= $SKIN->end_form("Go!");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
	}
	
	
	
	//+---------------------------------------------------------------------------------
	//
	// Ban control...
	//
	//+---------------------------------------------------------------------------------
	
	function ban_control() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "걱";
		
		$ADMIN->page_detail = "ziHbo̭קBRΥ[J IP }Bqll}ιwdW٨Lo";
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'doban'  ),
												  2 => array( 'act'   , 'mem'       ),
									     )      );
									     
		$ip_list    = "";
		$name_list  = "";
		$email_list = "";
		
		if ($INFO['ban_ip'] != "")
		{
			$ip_list = preg_replace( "/\|/", "\n", $INFO['ban_ip'] );
		}
		
		//+-------------------------------
		
		if ($INFO['ban_email'] != "")
		{
			$email_list = preg_replace( "/\|/", "\n", $INFO['ban_email'] );
		}
		
		//+-------------------------------
		
		if ($INFO['ban_names'] != "")
		{
			$name_list = preg_replace( "/\|/", "\n", $INFO['ban_names'] );
		}

		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"     , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"     , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "걱" );
		
		$ADMIN->html .= $SKIN->add_td_basic("ꪺ IP } (C@ - ϥ * @UΦr)", "center", "title");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ꪺ IP }</b><br>(dҡG 212.45.45.23)<br>(dҡG 212.45.45.*)" ,
												  $SKIN->form_textarea( 'ban_ip', $ip_list )
											 )      );
											 
		$ADMIN->html .= $SKIN->add_td_basic("ꪺqll} (C@ - ϥ * @UΦr)", "center", "title");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ꪺqll}</b><br>(dҡG name@domain.com)<br>(dҡG *@domain.com)" ,
												  $SKIN->form_textarea( 'ban_email', $email_list )
											 )      );
											 
		$ADMIN->html .= $SKIN->add_td_basic("/wdW (C@)", "center", "title");
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ꪺW</b>" ,
												  $SKIN->form_textarea( 'ban_names', $name_list )
											 )      );
											 
		$ADMIN->html .= $SKIN->end_form("sLo");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();

	}
	
	function update_ban() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $HTTP_POST_VARS;
		
		// Get the incoming..
		
		$new = array();
		
		$new['ban_ip']    = preg_replace( "/\n/", "|", trim($HTTP_POST_VARS['ban_ip'])     );
		$new['ban_email'] = preg_replace( "/\n/", "|", trim($HTTP_POST_VARS['ban_email'])  );
		$new['ban_names'] = preg_replace( "/\n/", "|", trim($HTTP_POST_VARS['ban_names'])  );
		
		$ADMIN->rebuild_config( $new );
		
		$ADMIN->save_log("sLo");
		
		$ADMIN->done_screen("wsLo", "걱", "act=mem&code=ban" );		
		
	}
		
		
		
	//+---------------------------------------------------------------------------------
	//
	// MEMBER RANKS...
	//
	//+---------------------------------------------------------------------------------
	
	function titles() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "|ų]w";
		
		$ADMIN->page_detail = "ziHbo̭קBRμW[B~.<br>pGznb|W٩UܮIAпJI;pGznϥΦۭqϤ,unbIJϤW٧Yi.`NAoǦۭqϤbzw˪ 'html/team_icons' ؿ.";
		
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "Y"      , "30%" );
		$SKIN->td_header[] = array( "峹"  , "10%" );
		$SKIN->td_header[] = array( "I"       , "20%" );
		$SKIN->td_header[] = array( "&nbsp;"     , "20%" );
		$SKIN->td_header[] = array( "&nbsp;"     , "20%" );
		
		//+-------------------------------
		
		$DB->query("SELECT macro_id, img_dir FROM ibf_skins WHERE default_set=1");
		
		$mid = $DB->fetch_row();
		
		$DB->query("SELECT macro_replace AS A_STAR FROM ibf_macro WHERE macro_set={$mid['macro_id']} AND macro_value='A_STAR'");
    	           
    	$row = $DB->fetch_row();
    	
    	$row['A_STAR'] = str_replace( "<#IMG_DIR#>", $mid['img_dir'], $row['A_STAR'] );
		
		$ADMIN->html .= $SKIN->start_table( "|Y/" );
		
		$DB->query("SELECT * FROM ibf_titles ORDER BY posts");
		
		while ( $r = $DB->fetch_row() )
		{
			$img = "";
			
			if ( preg_match( "/^\d+$/", $r['pips'] ) )
			{
				for ($i = 1; $i <= $r['pips']; $i++)
				{
					$img .= $row['A_STAR'];
					
				}
			}
			else
			{
				$img = "<img src='html/team_icons/{$r['pips']}' border='0'>";
			}
				
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>".$r['title']."</b>" ,
													  $r['posts'],
													  $img,
													  "<a href='{$SKIN->base_url}&act=mem&code=rank_edit&id={$r['id']}'>s</a>",
													  "<a href='{$SKIN->base_url}&act=mem&code=rank_delete&id={$r['id']}'>R</a>",
											 )      );
			
		}
									     
		
										 
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'do_add_rank'  ),
												  2 => array( 'act'   , 'mem'       ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "W[|" );
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Y</b>" ,
												  $SKIN->form_input( "title" )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̤֩һݵo</b>" ,
												  $SKIN->form_input( "posts" )
									     )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Iƶq</b><br>(Ϊ̮IϤ)" ,
												  $SKIN->form_input( "pips" )
									     )      );
									     									     
		$ADMIN->html .= $SKIN->end_form("W[oӵ");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	}
	
	//+---------------------------------------------------------------------------------
	
	function add_rank() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//+-------------------------------
		// check for input
		//+-------------------------------
		
		foreach( array( 'posts', 'title', 'pips' ) as $field )
		{
			if ($IN[ $field ] == "")
			{
				$ADMIN->error("zӪ");
			}
		}
		
		//+-------------------------------
		// Add it to the DB
		//+-------------------------------
		
		$db_string = $DB->compile_db_insert_string( array (
															 'posts'  => trim($IN['posts']),
															 'title'  => trim($IN['title']),
															 'pips'   => trim($IN['pips']),
												  )       );
												  
		$DB->query("INSERT INTO ibf_titles (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
		
		$ADMIN->done_screen("ŤwsW", "|ű", "act=mem&code=title" );					
		
		
	}
	
	//+---------------------------------------------------------------------------------
	
	function delete_rank() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//+-------------------------------
		// check for input
		//+-------------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("LŦXID");
		}
		
		$DB->query("DELETE FROM ibf_titles WHERE id='".$IN['id']."'");
		
		$ADMIN->save_log("ų]w");
		
		$ADMIN->done_screen("Ťw", "|ű", "act=mem&code=title" );
		
	}
	
	//+---------------------------------------------------------------------------------
	
	function edit_rank() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//+-------------------------------
		// check for input
		//+-------------------------------
		
		if ($IN['id'] == "")
		{
			$ADMIN->error("LŦXID");
		}
		
		//+-------------------------------
		
		foreach( array( 'posts', 'title', 'pips' ) as $field )
		{
			if ($IN[ $field ] == "")
			{
				$ADMIN->error("zӪ");
			}
		}
		
		//+-------------------------------
		// Add it to the DB
		//+-------------------------------
		
		$db_string = $DB->compile_db_update_string( array (
															 'posts'  => trim($IN['posts']),
															 'title'  => trim($IN['title']),
															 'pips'   => trim($IN['pips']),
												  )       );
												  
		$DB->query("UPDATE ibf_titles SET $db_string WHERE id='".$IN['id']."'");
		
		$ADMIN->save_log("s赥ų]w");
		
		$ADMIN->done_screen("Ťws", "|ű", "act=mem&code=title" );					
		
		
	}
	
	//+---------------------------------------------------------------------------------
	
	function rank_setup($mode='edit') {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "|ų]w";
		
		$ADMIN->page_detail = "pGznb|W٩UܮI,пJI;pGznϥΦۭqϤ,unbIJϤW٧Yi.`N,oǦۭqϤbzw˪ 'html/team_icons' ؿ.";
		
		if ($mode == 'edit')
		{
			$form_code = 'do_rank_edit';
			
			if ($IN['id'] == "")
			{
				$ADMIN->error("S]w ID");
			}
			
			$DB->query("SELECT * from ibf_titles WHERE id='".$IN['id']."'");
			$rank = $DB->fetch_row();
			
			$button = "s";
		}
		else
		{
			$form_code = 'do_add_rank';
			$rank = array( 'posts' => "", 'title' => "", 'pips' => "");
			$button = "W[oӵ";
		}
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , $form_code  ),
												  2 => array( 'act'   , 'mem'       ),
												  3 => array( 'id'    , $rank['id'] ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "|" );
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Y</b>" ,
												  $SKIN->form_input( "title", $rank['title'] )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̤֩һݵo</b>" ,
												  $SKIN->form_input( "posts", $rank['posts'] )
									     )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Iƥ</b><br>(Ϊ̮IϤ)" ,
												  $SKIN->form_input( "pips", $rank['pips'] )
									     )      );
									     									     
		$ADMIN->html .= $SKIN->end_form($button);
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
		
	}
	
	//+---------------------------------------------------------------------------------
	
	
	//+---------------------------------------------------------------------------------
	//
	// DELETE MEMBER SET UP
	//
	//+---------------------------------------------------------------------------------
	
	function delete_form() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "|bR";
		
		$ADMIN->page_detail = "JΧ㪺ϥΪ̦W٥HjMnR|,Ϊ̳]wR";
		
		
		$mem_group[0] = array( '0', '|s' );
		
		$DB->query("SELECT g_id, g_title FROM ibf_groups ORDER BY g_title");
		
		while ( $r = $DB->fetch_row() )
		{
			$mem_group[] = array( $r['g_id'] , $r['g_title'] );
		}
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'delete2' ),
												  2 => array( 'act'   , 'mem'     ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "|jM" );
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>JΧ㪺ϥΪ̦W</b>" ,
												  $SKIN->form_input( "USER_NAME" )
									     )      );
									     
		$ADMIN->html .= $SKIN->end_form("M|b");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'prune' ),
												  2 => array( 'act'   , 'mem'     ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "<u>Ϊ</u> |..." );
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>|WL [x] ѥHWo</b><br>([x] = JƦr)<br>(dťHLd)" ,
												  $SKIN->form_input( "last_post", '60')
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b><u>H</u> |֩ [x] g峹</b><br>([x] = JƦr)<br>(dťHLd)" ,
												  $SKIN->form_input( "posts", '100')
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b><u>H</u> |wgU [x] ѥHW</b><br>([x] = JƦr)<br>(dťHLd)" ,
												  $SKIN->form_input( "joined", '365')
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b><u>H</u> |sլ...</b>" ,
												  $SKIN->form_dropdown( "mgroup",
																		$mem_group,
												  						0
												  					  )
									     )      );
									     							     
		$ADMIN->html .= $SKIN->end_form("R|");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
		
	}
	
	//+---------------------------------------------------------------------------------
	
	function prune_confirm() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//-----------------------------
		// Make sure we have *something*
		//------------------------------
		
		$blanks = 0;
		
		foreach( array( 'posts', 'last_post', 'user_regdate' ) as $field )
		{
			if ($IN[ $field ] == "")
			{
				$blanks++;
			}
		}
		
		if ($blanks == 3)
		{
			$ADMIN->error("zܤ֥w@HΩRd");
		}
		
		$time_now = time();
		
		$query = "SELECT COUNT(uid) as mcount FROM xbb_members WHERE";
		
		$add_query = array();
		
		if ($IN['user_regdate'] > 0)
		{
			$j = $time_now - ($IN['user_regdate'] *60*60*24);
			$add_query[] = " user_regdate < $j ";
		}
		
		if ($IN['last_post'] > 0)
		{
			$l = $time_now - ($IN['last_post'] *60*60*24);
			$add_query[] = " last_post < $l ";
		}
		
		if ($IN['posts'] > 0)
		{
			$add_query[] = " posts < ".$IN['posts']." ";
		}
		
		if ($IN['mgroup'] > 0)
		{
			$add_query[] = " mgroup='".$IN['mgroup']."' ";
		}
		
		$add_query[] = ' uid > 0';
		
		$additional_query = implode( "AND", $add_query );
		
		$this_query = trim( $query.$additional_query );
		
		$pass_query = addslashes(urlencode($additional_query));
		
		//--------------------------------
		// Run the query
		//--------------------------------
		
		$DB->query($this_query);
		
		$count = $DB->fetch_row();
		
		if ($count['mcount'] < 1)
		{
			$ADMIN->error("LkŦXRзǪ|AЪ^");
		}
		
		$ADMIN->page_title = "|R";
		
		$ADMIN->page_detail = "нT{zʧ@";
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'doprune' ),
												  2 => array( 'act'   , 'mem'     ),
												  3 => array( 'query' , $pass_query ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "|RT{" );
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>nR|</b>" ,
												  $count['mcount']
									     )      );
									     
		$ADMIN->html .= $SKIN->end_form("|R");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
	}
	
	
	//+---------------------------------------------------------------------------------
	
	
	function doprune() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		//-----------------------------
		// Make sure we have *something*
		//------------------------------
		
		$query = trim(urldecode(($IN['query'])));
		
		$query = str_replace( "&lt;", "<", $query );
		$query = str_replace( "&gt;", ">", $query );
		
		if ($query == "")
		{
			$ADMIN->error("Rd߿~ASd߳Qϥ");
		}
		
		//-----------------------------
		// Get the member ids...
		//------------------------------
		
		$ids = array();
		
		$DB->query("SELECT uid FROM xbb_members WHERE ".$query);
		
		if ( $DB->get_num_rows() )
		{
			while ($i = $DB->fetch_row())
			{
				$ids[] = $i['uid'];
			}
		}
		else
		{
			$ADMIN->error("LkŦXRзǪ|");
		}
		
		$id_string = implode( "," , $ids );
		
		$id_count = count($ids);
		
		// Convert their posts and topics into guest postings..
		
		$DB->query("UPDATE ibf_posts SET author_id='0' WHERE author_id IN(".$id_string.")");
		
		$DB->query("UPDATE ibf_topics SET starter_id='0' WHERE starter_id IN(".$id_string.")");
		
		// Delete member...
		
		$DB->query("DELETE from xbb_members WHERE uid IN(".$id_string.")");
		
		$DB->query("DELETE from ibf_pfields_content WHERE member_id IN(".$id_string.")");
		
		// Delete member messages...
		
		$DB->query("DELETE from ibf_messages WHERE member_id IN (".$id_string.")");
		
		// Delete member subscriptions.
		
		$DB->query("DELETE from ibf_tracker WHERE member_id IN (".$id_string.")");
		
		// Set the stats DB straight.
		
		$DB->query("SELECT uid, uname FROM xbb_members WHERE mgroup <> '".$INFO['auth_group']."' ORDER BY user_regdate DESC LIMIT 0,1");
		
		$mem = $DB->fetch_row();
		
		$DB->query("UPDATE ibf_stats SET ".
			             "MEM_COUNT=MEM_COUNT-".$id_count.", ".
			             "LAST_MEM_NAME='" . $mem['uname'] . "', ".
			             "LAST_MEM_ID='"   . $mem['uid']   . "'");
		
		// Blow me melon farmer
		
		$ADMIN->save_log("ѧR沾 $id_count |");
		
		$ADMIN->done_screen("|bwR", "|", "act=mem&code=edit" );
		
	}
	
	//+---------------------------------------------------------------------------------
	
	function delete_lookup_form() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['USER_NAME'] == "")
		{
			$ADMIN->error("zSܭnM䪺|W!");
		}
		
		$DB->query("SELECT uid, uname FROM xbb_members WHERE uname LIKE '".$IN['USER_NAME']."%'");
		
		if (! $DB->get_num_rows() )
		{
			$ADMIN->error("p,ڭ̵Lk|ŦXzJjMr");
		}
		
		$form_array = array();
		
		while ( $r = $DB->fetch_row() )
		{
			$form_array[] = array( $r['uid'] , $r['uname'] );
		}
		
		
		
		$ADMIN->page_title = "R@|";
		
		$ADMIN->page_detail = "пܭnR|";
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'dodelete' ),
												  2 => array( 'act'   , 'mem'     ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "|jMG" );
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>qŦX...</b>" ,
												  $SKIN->form_dropdown( "MEMBER_ID", $form_array )
									     )      );
									     
		$ADMIN->html .= $SKIN->end_form("R|");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
	}
	
	//+---------------------------------------------------------------------------------
	
	//+---------------------------------------------------------------------------------
	//
	// DO DELETE
	//
	//+---------------------------------------------------------------------------------
	
	function dodelete() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		if ($IN['MEMBER_ID'] == "")
		{
			$ADMIN->error("LkѪR| id");
		}
		
		//+-------------------------------
		
		$DB->query("SELECT * FROM xbb_members WHERE uid='".$IN['MEMBER_ID']."'");
		$mem = $DB->fetch_row();
		
		//+-------------------------------
		
		if ($mem['uid'] == "")
		{
			$ADMIN->error("LkѪR| id");
		}
		
		// Convert their posts and topics into guest postings..
		
		$DB->query("UPDATE ibf_posts SET author_id='0' WHERE author_id='".$IN['MEMBER_ID']."'");
		
		$DB->query("UPDATE ibf_topics SET starter_id='0' WHERE starter_id='".$IN['MEMBER_ID']."'");
		
		// Delete member...
		
		$DB->query("DELETE from xbb_members WHERE uid='".$IN['MEMBER_ID']."'");
		$DB->query("DELETE from ibf_pfields_content WHERE member_id='".$IN['MEMBER_ID']."'");
		$DB->query("DELETE from ibf_member_extra WHERE id='".$IN['MEMBER_ID']."'");
		
		// Delete member messages...
		
		$DB->query("DELETE from ibf_messages WHERE member_id='".$IN['MEMBER_ID']."'");
		
		// Delete member subscriptions.
		
		$DB->query("DELETE from ibf_tracker WHERE member_id='".$IN['MEMBER_ID']."'");
		$DB->query("DELETE from ibf_forum_tracker WHERE member_id='".$IN['MEMBER_ID']."'");
		
		// Set the stats DB straight.
		
		$DB->query("SELECT uid, uname FROM xbb_members WHERE mgroup <> '".$INFO['auth_group']."' ORDER BY user_regdate DESC LIMIT 0,1");
		
		$memb = $DB->fetch_row();
		
		$DB->query("UPDATE ibf_stats SET ".
			             "MEM_COUNT=MEM_COUNT-1, ".
			             "LAST_MEM_NAME='" . $memb['uname'] . "', ".
			             "LAST_MEM_ID='"   . $memb['uid']   . "'");
		
		// Blow me melon farmer
		
		$ADMIN->save_log("R| '{$mem['name']}'");
		
		$ADMIN->done_screen("|bwR", "|", "act=mem&code=edit" );
		
	}
		
	//+-------------------------------
	//+---------------------------------------------------------------------------------
	//
	// ADD MEMBER FORM
	//
	//+---------------------------------------------------------------------------------
	
	function add_form() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "wU|";
		
		$ADMIN->page_detail = "ziHϥγoӪwU|";
		
		$DB->query("SELECT g_id, g_title FROM ibf_groups ORDER BY g_title");
		
		while ( $r = $DB->fetch_row() )
		{
			$mem_group[] = array( $r['g_id'] , $r['g_title'] );
		}
		
		//+-------------------------------
		
		$custom_output = "";
		$field_data     = array();
		
		$DB->query("SELECT * from ibf_pfields_content WHERE member_id='".$IN['MEMBER_ID']."'");
		
		while ( $content = $DB->fetch_row() )
		{
			foreach($content as $k => $v)
			{
				if ( preg_match( "/^field_(\d+)$/", $k, $match) )
				{
					$field_data[ $match[1] ] = $v;
				}
			}
		}
		
		$DB->query("SELECT * from ibf_pfields_data WHERE fshowreg=1 ORDER BY forder");
		
		while( $row = $DB->fetch_row() )
		{
			$form_element = "";
			
			if ( $row['ftype'] == 'drop' )
			{
				$carray = explode( '|', trim($row['fcontent']) );
				
				$d_content = array();
				
				foreach( $carray as $entry )
				{
					$value = explode( '=', $entry );
					
					$ov = trim($value[0]);
					$td = trim($value[1]);
					
					if ($ov and $td)
					{
						$d_content[] = array( $ov, $td );
					}
				}
				
				$form_element = $SKIN->form_dropdown( 'field_'.$row['fid'], $d_content, "" );
				
			}
			else if ( $row['ftype'] == 'area' )
			{
				$form_element = $SKIN->form_textarea( 'field_'.$row['fid'], "" );
			}
			else
			{
				$form_element = $SKIN->form_input( 'field_'.$row['fid'], "" );
			}
			
			$custom_out .= $SKIN->add_td_row( array( "<b>{$row['ftitle']}</b><br>{$row['desc']}" , $form_element ) );
			
		}
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'doadd' ),
												  2 => array( 'act'   , 'mem'     ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "|U" );
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>|W</b>" ,
												  $SKIN->form_input( "name" )
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>KX</b>" ,
												  $SKIN->form_input( "password", "", 'password' )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>qll}</b>" ,
												  $SKIN->form_input( "email" )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>|s</b>" ,
												  $SKIN->form_dropdown( "mgroup",
																		$mem_group,
												  						$mem['mgroup']
												  					  )
									     )      );
									     
		if ($custom_out != "")
		{
			$ADMIN->html .= $custom_out;
		}
									     						     
		$ADMIN->html .= $SKIN->end_form("U|");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
		
	}
	
	function do_add()
	{
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		foreach( array('name', 'password', 'email', 'mgroup') as $field )
		{
			if ($IN[ $field ] == "")
			{
				$ADMIN->error("zӪ!");
			}
		}
		
		//----------------------------------
		// Do we already have such a member?
		//----------------------------------
		
		$DB->query("SELECT uid FROM xbb_members WHERE LOWER(uname)='".$IN['name']."'");
		
		if ( $DB->get_num_rows() )
		{
			$ADMIN->error("ڭ̤wgoӦW٪|AХtL");
		}
		
		//----------------------------------
		// Custom profile field stuff
		//----------------------------------
		
		$custom_fields = array();
		
		$DB->query("SELECT * from ibf_pfields_data");
		
		$have_custom = $DB->get_num_rows();
		
		while ( $row = $DB->fetch_row() )
		{
			$custom_fields[ 'field_'.$row['fid'] ] = $IN[ 'field_'.$row['fid'] ];
		}
		
		//+--------------------------------------------
		//| Find the highest member id, and increment it
		//| auto_increment not used for guest id 0 val.
		//+--------------------------------------------
		
		$DB->query("SELECT MAX(uid) as new_id FROM xbb_members");
		$r = $DB->fetch_row();
		
		$member_id = $r['new_id'] + 1;
		
		$db_string = $DB->compile_db_insert_string( array (
															 'uid'          => $member_id,
															 'uname'        => trim($IN['name']),
															 'pass'    => md5(trim($IN['password'])),
															 'email'       => trim(strtolower($IN['email'])),
															 'mgroup'      => $IN['mgroup'],
															 'user_regdate'      => time(),
															 'posts'       => 0,
															 'ip_address'  => $IN['ip_address'],
															 'timezone_offset' => 0,
															 'attachsig'   => 1,
															 'view_avs'    => 1,
															 'allow_post'  => 1,
															 'view_pop'    => 1,
															 'view_img'    => 1,
															 'vdirs'       => "in:Inbox|sent:Sent Items",
												  )       );
												  
		$DB->query("INSERT INTO xbb_members (" .$db_string['FIELD_NAMES']. ") VALUES (". $db_string['FIELD_VALUES'] .")");
//XOOPS
		$DB->query("INSERT INTO xbb_groups_users_link (groupid,uid) VALUES ('2','".$member_id."')");
//   
		
		//$member_id = $DB->get_insert_id();
		
		//+--------------------------------------------
		//| Insert into the custom profile fields DB
		//+--------------------------------------------
		
		if ( count($custom_fields) > 0 )
		{
		
			$custom_fields['member_id'] = $member_id;
				
			$db_string = $DB->compile_db_insert_string($custom_fields);
				
			$DB->query("INSERT INTO ibf_pfields_content (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
		
		}
		
		unset($db_string);
		
		//+--------------------------------------------
		
		$DB->query("UPDATE ibf_stats SET ".
			             "MEM_COUNT=MEM_COUNT+1, ".
			             "LAST_MEM_NAME='" . trim($IN['name']) . "', ".
			             "LAST_MEM_ID='"   . $member_id   . "'");
			             
		$ADMIN->save_log("إ߷s|b '{$IN['name']}'");
		
		$ADMIN->done_screen("|bwإ", "|", "act=mem&code=edit" );												 
		
	}
	
	
	//+---------------------------------------------------------------------------------
	//
	// SEARCH FORM, SEARCH FOR MEMBER
	//
	//+---------------------------------------------------------------------------------
	
	function search_form() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$ADMIN->page_title = "s|";
		
		$ADMIN->page_detail = "jM|";
		
		$mem_group = array( 0 => array( 'all', 's') );
		
		$DB->query("SELECT g_id, g_title FROM ibf_groups ORDER BY g_title");
		
		while ( $r = $DB->fetch_row() )
		{
			$mem_group[] = array( $r['g_id'] , $r['g_title'] );
		}
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'stepone' ),
												  2 => array( 'act'   , 'mem'     ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "|ֳtjM" );
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>JΧ㪺ϥΪ̦W</b>" ,
												  $SKIN->form_input( "USER_NAME" )
									     )      );
									     
		$ADMIN->html .= $SKIN->end_form("M|");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'advancedsearch' ),
												  2 => array( 'act'   , 'mem'     ),
									     )      );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "|ijM", "Цܤ֧@Ad߮ɷ|Lťժ" );
		
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>|W٥]t...</b>" ,
												  $SKIN->form_input( "uname" )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>qll}]t...</b>" ,
												  $SKIN->form_input( "email" )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>IP }]t...</b>" ,
												  $SKIN->form_input( "ip_address" )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>AIM W٥]t...</b>" ,
												  $SKIN->form_input( "user_aim" )
									     )      );

		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ICQ X]t...</b>" ,
												  $SKIN->form_input( "user_icq" )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Yahoo! ]t...</b>" ,
												  $SKIN->form_input( "user_yim" )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ñWɥ]t...</b>" ,
												  $SKIN->form_input( "signature" )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̫oq...</b>" ,
												  $SKIN->form_simple_input( "last_post" ). '... ѫeܤ'
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>̫ᬡʱq...</b>" ,
												  $SKIN->form_simple_input( "last_activity" ). '... ѫeܤ'
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ݩs...</b>" ,
												  $SKIN->form_dropdown( "mgroup", $mem_group )
									     )      );
									     
		$ADMIN->html .= $SKIN->end_form("d߷|Ʈw");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
		
	}
	
	//+---------------------------------------------------------------------------------
	
	function do_advanced_search($basic=0) {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP;
		
		$page_query = "";
		
		if ($basic == 0)
		{
			$query = array();
			
			foreach( array('uname','email','ip_address','user_aim','user_icq','user_yim','signature','last_post','last_activity','mgroup') as $bit )
			{
				$IN[ $bit ] = urldecode(trim($IN[ $bit ]));
				
				$page_query .= '&'.$bit.'='.urlencode($IN[ $bit ]);
				
				if ($IN[ $bit ] != "")
				{
					if ($bit == 'last_post' or $bit == 'last_activity')
					{
						$dateline = time() - ($IN[ $bit ]*60*60*24);
						$query[] = 'm.'.$bit.' > '."'$dateline'";
					}
					else if ($bit == 'mgroup')
					{
						if ($IN['mgroup'] != 'all')
						{
							$query[] = "m.mgroup=".$IN['mgroup'];
						}
					}
					else
					{
						$query[] = 'm.'.$bit." LIKE '%".$IN[$bit]."%'";
					}
				}
			}
			
			if (count($query) < 1)
			{
				$ADMIN->error("beXjM椧eЦܤ֧@");
			}
			
			$rq = implode( " AND ", $query );
		}
		else
		{
			// Basic username search
			
			$IN['USER_NAME'] = trim(urldecode($IN['USER_NAME']));
			
			if ($IN['USER_NAME'] == "")
			{
				$ADMIN->error("zSܭnM䪺|W!");
			}
			
			$page_query = "&USER_NAME=".urlencode($IN['USER_NAME']);
		
			$rq = "uname LIKE '".$IN['USER_NAME']."%'";
		}
		
		$st = intval($IN['st']);
		
		if ($st < 1)
		{
			$st = 0;
		}
		
		$query = "SELECT m.uid, m.email, m.uname, m.mgroup, m.ip_address, m.posts, g.g_title
		          FROM xbb_members m
		           LEFT JOIN ibf_groups g ON (g.g_id=m.mgroup)
		          WHERE $rq ORDER BY m.uname LIMIT $st,50";
		
		//+-------------------------------
		// Get the number of results
		//+-------------------------------
		
		$DB->query("SELECT COUNT(m.uid) as count FROM xbb_members m WHERE $rq");
		
		$count = $DB->fetch_row();
		
		if ($count['count'] < 1)
		{
			$ADMIN->error("z|Ʈw˯dߨSǦ^۲ŪGAЪ^");
		}
		
		$ADMIN->page_title = "z|jMG";
		
		$ADMIN->page_detail = "zjMG";
		
		//+-------------------------------
		
		$pages = $std->build_pagelinks( array( 'TOTAL_POSS'  => $count['count'],
											   'PER_PAGE'    => 50,
											   'CUR_ST_VAL'  => $IN['st'],
											   'L_SINGLE'    => "歶",
											   'L_MULTI'     => "h",
											   'BASE_URL'    => $SKIN->base_url."&act=mem&code={$IN['code']}".$page_query,
											 )
									  );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "|W"  , "20%" );
		$SKIN->td_header[] = array( "s"        , "20%" );
		$SKIN->td_header[] = array( "峹"        , "10%" );
		$SKIN->td_header[] = array( "qll"        , "20%" );
		$SKIN->td_header[] = array( "s" , "15%" );
		$SKIN->td_header[] = array( "ܧW"  , "15%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "{$count['count']} ӷjMG" );
		
		//+-------------------------------
		// Run the query
		//+-------------------------------
		
		$DB->query($query);
		
		while ( $r = $DB->fetch_row() )
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b><a style='font-size:12px' title='˵|ӤH' href='{$INFO['board_url']}/index.{$INFO['php_ext']}?act=Profile&MID={$r['uid']}' target='blank'>{$r['uname']}</a></b><br>IP}:{$r['ip_address']}",
													  $r['g_title'],
													  "<center>".$r['posts']."</center>",
													  "<center>".$r['email']."</center>",
													  "<b><a href='{$SKIN->base_url}&act=mem&code=doform&MEMBER_ID={$r['uid']}' title='s覹|b'>s</a></b>",
													  "<b><a href='{$SKIN->base_url}&act=mem&code=changename&mid={$r['uid']}' title='ܧ󦹷|W'>ܧW</a></b>"
									     	 )      );
		}
		
		$ADMIN->html .= $SKIN->add_td_basic($pages, 'right', 'catrow');
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
		
		
	}
	
	//+---------------------------------------------------------------------------------
	//
	// DO EDIT FORM
	//
	//+---------------------------------------------------------------------------------
	
	function do_edit_form() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $ibforums;
		
		require ROOT_PATH."sources/lib/post_parser.php";
		
		$parser = new post_parser();
		
		if ($IN['MEMBER_ID'] == "")
		{
			$ADMIN->error("LkѪR| id");
		}
		
		//+-------------------------------
		
		$DB->query("SELECT * FROM xbb_members WHERE uid='".$IN['MEMBER_ID']."'");
		$mem = $DB->fetch_row();
		
		//+-------------------------------
		
		if ($mem['uid'] == "")
		{
			$ADMIN->error("LkѪR| id");
		}
		
		//+-------------------------------
		
		$mem_group = array();
		$show_fixed = FALSE;
		
		$DB->query("SELECT g_id, g_title FROM ibf_groups ORDER BY g_title");
		
		while ( $r = $DB->fetch_row() )
		{
			// Ensure only root admins can promote to root admin grou...
			// oh screw it, I can't be bothered explaining stuff tonight
			
			if ($INFO['admin_group'] == $r['g_id'])
			{
				if ($MEMBER['mgroup'] != $INFO['admin_group'])
				{
					continue;
				}
			}
			
			$mem_group[] = array( $r['g_id'] , $r['g_title'] );
		}
		
		// is this a non root editing a root?
		
		if ($MEMBER['mgroup'] != $INFO['admin_group'])
		{
			if ($mem['mgroup'] == $INFO['admin_group'])
			{
				$show_fixed = TRUE;
			}
		}
		
		//+-------------------------------
		
		$lang_array = array();
		
		$DB->query("SELECT ldir, lname FROM ibf_languages");
		
		while ( $l = $DB->fetch_row() )
		{
			$lang_array[] = array( $l['ldir'], $l['lname'] );
		}
 		
 		//+-------------------------------
 		
 		$DB->query("SELECT uid, sid, sname, default_set, hidden FROM ibf_skins");
 		
 		$skin_array = array();
 		
 		$def_skin = "";
 			
		if ( $DB->get_num_rows() )
		{
			while ( $s = $DB->fetch_row() )
			{
				if ($s['default_set'] == 1)
				{
					$def_skin = $s['sid'];
				}
				
				if ($s['hidden'] == 1)
				{
					$hidden = " *(Hidden)";
				}
				else
				{
					$hidden = "";
				}
				
				$skin_array[] = array( $s['sid'], $s['sname'].$hidden );
			   
			}
		}
			
		//+-------------------------------
		
		if ($INFO['default_language'] == "")
		{
			$INFO['default_language'] = 'cn';
		}
		
		//-----------------------------------------------
		// Custom profile fields stuff
		//-----------------------------------------------
		
		$custom_output = "";
		$field_data     = array();
		
		$DB->query("SELECT * from ibf_pfields_content WHERE member_id='".$IN['MEMBER_ID']."'");
		
		while ( $content = $DB->fetch_row() )
		{
			foreach($content as $k => $v)
			{
				if ( preg_match( "/^field_(\d+)$/", $k, $match) )
				{
					$field_data[ $match[1] ] = $v;
				}
			}
		}
		
		$DB->query("SELECT * from ibf_pfields_data ORDER BY forder");
		
		while( $row = $DB->fetch_row() )
		{
			$form_element = "";
			
			if ( $row['ftype'] == 'drop' )
			{
				$carray = explode( '|', trim($row['fcontent']) );
				
				$d_content = array();
				
				foreach( $carray as $entry )
				{
					$value = explode( '=', $entry );
					
					$ov = trim($value[0]);
					$td = trim($value[1]);
					
					if ($ov != "" and $td !="")
					{
						$d_content[] = array( $ov, $td );
					}
				}
				
				$form_element = $SKIN->form_dropdown( 'field_'.$row['fid'], $d_content, $field_data[$row['fid']] );
				
			}
			else if ( $row['ftype'] == 'area' )
			{
				$form_element = $SKIN->form_textarea( 'field_'.$row['fid'], $field_data[$row['fid']] );
			}
			else
			{
				$form_element = $SKIN->form_input( 'field_'.$row['fid'], $field_data[$row['fid']] );
			}
			
			$custom_out .= $SKIN->add_td_row( array( "<b>{$row['ftitle']}</b><br>{$row['desc']}" , $form_element ) );
			
		}
		
		
		//+-------------------------------
		
		
		$ADMIN->page_title = "s|: ".$mem['uname']." IDs: ".$mem['uid']."";
		
		$ADMIN->page_detail = "ziHqo̧ܷ|]w";
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_form( array( 1 => array( 'code'  , 'doedit'  ),
												  2 => array( 'act'   , 'mem'     ),
												  3 => array( 'mid'   , $mem['uid'] ),
												  4 => array( 'curpass', $mem['pass'] ),
											) );
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "|w]w" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Uɪ IP }</b>" ,$mem['ip_address'] )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>\ {$mem['name']} bQ\iao?</b>" ,
												  $SKIN->form_yes_no("allow_post", $mem['allow_post'] )
									     )      );
		
		if ($show_fixed != TRUE)
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>|s</b>" ,
													  $SKIN->form_dropdown( "mgroup",
																			$mem_group,
																			$mem['mgroup']
																		  )
											 )      );
		}
		else
		{
			$ADMIN->html .= $SKIN->add_td_row( array( "<b>|s</b>" ,
													  $SKIN->form_hidden( array( 1 => array( 'mgroup' , $mem['mgroup'] ) ) )."<b>Root Admin</b> (Can't Change)",
											 )      );
		}
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>|Y</b>" ,
												  $SKIN->form_input("title", $mem['title'])
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ݭnODw|Ҧ峹?</b><br>pGOAҦѦ|o峹N|QJިC" ,
												  $SKIN->form_yes_no("mod_posts", $mem['mod_posts'])
									     )      );
									     
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->start_table( "KX" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>sKX</b><br>(pGQ]KXЯd!)" ,
												  $SKIN->form_input("password")
									     )      );
									     
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------+
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------+
		
		$ADMIN->html .= $SKIN->start_table( "׾³]w" );							     
		
		//+-------------------------------
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>y</b>" ,
												  $SKIN->form_dropdown( "language",
																		$lang_array,
												  						$mem['language'] != "" ? $mem['language'] : $INFO['default_language']
												  					  )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>O</b>" ,
												  $SKIN->form_dropdown( "skin",
																		$skin_array,
												  						$mem['skin'] != "" ? $mem['skin'] : $def_skin
												  					  )
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>æ|qll}?</b>" ,
												  $SKIN->form_yes_no("hide_email", $mem['user_viewemail'] )
									     )      );
									     						     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>PM qllq?</b>" ,
												  $SKIN->form_yes_no("email_pm", $mem['email_pm'] )
									     )      );		
		
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------+
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------+
		
		$ADMIN->html .= $SKIN->start_table( "s" );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>qll}</b>" ,
												  $SKIN->form_input("email", $mem['email'])
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>AIM </b>" ,
												  $SKIN->form_input("aim_name", $mem['user_aim'])
									     )      );							     						     
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ICQ X</b>" ,
												  $SKIN->form_input("icq_number", $mem['user_icq'])
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>Yahoo </b>" ,
												  $SKIN->form_input("yahoo", $mem['user_yim'])
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>MSN </b>" ,
												  $SKIN->form_input("msnname", $mem['user_msnm'])
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>}</b>" ,
												  $SKIN->form_input("website", $mem['url'])
									     )      );
									     
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------+
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------+
		
		$ADMIN->html .= $SKIN->start_table( "LT" );
									     							     							     
		//+-------------------------------
		
		$mem['signature'] = $parser->unconvert( $mem['signature'] );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ӤHϤ</b>" ,
												  $SKIN->form_input("avatar", $mem['avatar'])
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ӤHϤjp</b>" ,
												  $SKIN->form_input("avatar_size", $mem['avatar_size'])
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>o</b>" ,
												  $SKIN->form_input("posts", $mem['posts'])
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>m</b>" ,
												  $SKIN->form_input("location", $mem['user_from'])
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b></b>" ,
												  $SKIN->form_textarea("interests", str_replace( '<br>', "\n",$mem['user_intrest']))
									     )      );
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>ñW</b>" ,
												  $SKIN->form_textarea("signature", $mem['signature'])
									     )      );
		
		$ADMIN->html .= $SKIN->end_table();
		
		//+-------------------------------+
		
		$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
		$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
		
		//+-------------------------------+
		
		$ADMIN->html .= $SKIN->start_table( "{ҥNX" );
		
		
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>{ҥNX</b><br>(DzTwAݭn_hn!)" ,
												  $SKIN->form_input("validate_key", $mem['validate_key'])
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>sKX (MD5)</b><br>(DzTwAݭn_hn!)" ,
												  $SKIN->form_input("new_pass", $mem['new_pass'])
									     )      );
									     
		$ADMIN->html .= $SKIN->add_td_row( array( "<b>e|s ID</b><br>(DzTwAݭn_hn!)" ,
												  $SKIN->form_input("prev_group", $mem['prev_group'])
									     )      );
									     							     							     							     
		//+-------------------------------
		
		if ($custom_out != "")
		{
		
			$ADMIN->html .= $SKIN->end_table();
			
			
			$SKIN->td_header[] = array( "&nbsp;"  , "40%" );
			$SKIN->td_header[] = array( "&nbsp;"  , "60%" );
			
			//+-------------------------------+
			
			$ADMIN->html .= $SKIN->start_table( "ۭqӤH" );
			
			
			$ADMIN->html .= $custom_out;
											 
		}
								     							     							     
		//+-------------------------------
									     							     							     							     
		$ADMIN->html .= $SKIN->end_form("s覹|");
										 
		$ADMIN->html .= $SKIN->end_table();
		
		$ADMIN->output();
			
			
	}


	//+---------------------------------------------------------------------------------
	
	function do_edit() {
		global $IN, $INFO, $DB, $SKIN, $ADMIN, $std, $MEMBER, $GROUP, $ibforums;
		
		$DB->query("SELECT uname FROM xbb_members WHERE uid='".$IN['mid']."'");
		
		$memb = $DB->fetch_row();
		
		$password = "";
		
		if ($IN['password'] != "")
		{
			$password = ", pass='".md5($IN['password'])."'";
		}
		
		require ROOT_PATH."sources/lib/post_parser.php";
		
		$parser = new post_parser();
		
		$IN['signature'] = $parser->convert( array ('TEXT'      => $IN['signature'],
													'SMILIES'   => 0,
													'CODE'      => $INFO['sig_allow_ibc'],
													'HTML'      => $INFO['sig_allow_html'],
													'SIGNATURE' => 1
										   )       );
		
		$db_string = $DB->compile_db_update_string( array (
															'allow_post'   => $IN['allow_post'],
															'mgroup'       => $IN['mgroup'],
															'title'        => $IN['title'],
															'validate_key' => $IN['validate_key'],
															'new_pass'     => $IN['new_pass'],
															'prev_group'   => $IN['prev_group'],
															'language'     => $IN['language'],
															'skin'         => $IN['skin'],
															'user_viewemail'   => $IN['hide_email'],
															'email_pm'     => $IN['email_pm'],
															'email'        => $IN['email'],
															'user_aim'     => $IN['aim_name'],
															'user_icq'   => $IN['icq_number'],
															'user_yim'        => $IN['yahoo'],
															'user_msnm'      => $IN['msnname'],
															'url'      => $IN['website'],
															'user_avatar'       => $IN['avatar'],
															'avatar_size'  => $IN['avatar_size'],
															'posts'        => $IN['posts'],
															'user_from'     => $IN['location'],
															'user_intrest'    => $IN['interests'],
															'signature'    => $IN['signature'],
															'mod_posts'    => $IN['mod_posts'],
												  )       );
												  
		$DB->query("UPDATE xbb_members SET $db_string".$password." WHERE uid='".$IN['mid']."'");
		
		//----------------------------------
		// Custom profile field stuff
		//----------------------------------
		
		$custom_fields = array();
		
		$DB->query("SELECT * from ibf_pfields_data");
		
		while ( $row = $DB->fetch_row() )
		{
			$custom_fields[ 'field_'.$row['fid'] ] = str_replace( '<br>', "\n", $IN[ 'field_'.$row['fid'] ] );
		}
		
		if ( count($custom_fields) > 0 )
		{
			// Do we already have an entry in the content table?
			
			$DB->query("SELECT member_id FROM ibf_pfields_content WHERE member_id='".$IN['mid']."'");
			$test = $DB->fetch_row();
			
			if ( $test['member_id'] )
			{
				// We have it, so simply update
				
				$db_string = $DB->compile_db_update_string($custom_fields);
				
				$DB->query("UPDATE ibf_pfields_content SET $db_string WHERE member_id='".$IN['mid']."'");
			}
			else
			{
				$custom_fields['member_id'] = $IN['mid'];
				
				$db_string = $DB->compile_db_insert_string($custom_fields);
				
				$DB->query("INSERT INTO ibf_pfields_content (".$db_string['FIELD_NAMES'].") VALUES(".$db_string['FIELD_VALUES'].")");
			}
		}
		
		$ADMIN->save_log("s| '{$memb['name']}' b");
		
		$ADMIN->done_screen("|ws", "|", "act=mem&code=edit" );
		
	}


	
	
		
}


?>