// WULOG.H
// =======
//
//   WU_FTP logfile format DLL for use with Serv-U v2.2 and higher.
//   Code can be found in WULOG.CPP.
//

#ifndef WULOGH                          // avoid multiple inclusion
#define WULOGH

using namespace std;                    // to use standard lib identifiers

// Serv-U event definitions
// a copy of the list found in the Serv-U manual
#define EVNT_None	    0		// none
#define EVNT_IPName	    1		// symbolic IP name available
#define EVNT_Connect	    2		// connection was made
#define EVNT_Close	    3		// closed connection
#define EVNT_BouncedIP	    4		// bounced client because of IP address
#define EVNT_TooMany	    5		// bounced user because there are too many
#define EVNT_WrongPass	    6		// too many times wrong password
#define EVNT_TimeOut	    7		// connection timed out
#define EVNT_Login	    8		// use logged in
#define EVNT_StartUp	    9		// start upload of file
#define EVNT_EndUp	   10		// successfull upload of file
#define EVNT_StartDown     11           // start of download of file
#define EVNT_EndDown	   12           // successfull download of file
#define EVNT_AbortUp	   13		// aborted upload
#define EVNT_AbortDown	   14		// aborted download
#define EVNT_Rename	   15		// renamed file/dir
#define EVNT_DelFile	   16		// deleted file
#define EVNT_DelDir 	   17		// deleted dir
#define EVNT_ChgDir	   18		// changed working directory
#define EVNT_MakeDir	   19		// created directory

// Serv-U event hook definitions
#define EVNT_HookDown	  100		// hook for file downloads
#define EVNT_HookUp	  101		// hook for file uploads
#define EVNT_HookAppend   102		// hook for append file upload
#define EVNT_HookUnique	  103		// hook for unique name upload
#define EVNT_HookRename	  104		// hook for rename file/dir
#define EVNT_HookDelFile  105		// hook for delete file
#define EVNT_HookDelDir	  106		// hook for delete dir
#define EVNT_HookMkd	  107		// hook for make directory
#define EVNT_HookRmd	  108		// hook for remove directory

// Serv-U sub-event codes
#define SEVNT_None	    0		// no sub-event
#define SEVNT_ErrWrite	    1		// problem writing to disk
#define SEVNT_ErrRead	    2		// problem reading from disk
#define SEVNT_ErrQuota	    3		// insufficient disk quota
#define SEVNT_ErrTOut	    4		// packet timed out
#define SEVNT_ErrAbort	    5		// user aborted transfer
#define SEVNT_ErrUnknown    6		// unknown error
#define SEVNT_ErrClose	    7		// data connection closed unexpectedly

// return codes for hooks
#define REVNT_None	    0		// nothing
#define REVNT_Proceed	    1		// let event pass
#define REVNT_Abort	    2		// stop event
#define REVNT_Suspend	    3		// suspend event until decision is made

// event information structure for communications with DLL's
struct RFTPEventStr {

  // event info
  DWORD Event;				// event type
  DWORD SubEvent;			// sub-event type

  // user info
  DWORD SessionID;			// unique ID of the FTP session
  char User[40];			// user name
  char ClientIP[16];			// IP number of client
  char LocalIP[16];			// IP number the client connected to

  // event attributes
  DWORD Duration;			// duration of events
  DWORD Size;				// size of object (ie. file)

  // hook info
  HWND hWindow;				// window handle to post decision to
  UINT Message;				// message to post
  char* pReplyText;			// pointer to text to send to user

  // scratch pad area
  char AuxOne[512];			// auxiliary area one
  char AuxTwo[512];			// auxiliary area two
};

// user info structure to keep track of sessions
struct RUserInfoStr {
  DWORD SessionID;                      // session ID
  string IPName;                        // IP name of user (if available)
  string AnonPass;                      // anonymous password used to log in (for anonymous users)
};

// some definitions to make life easier
typedef RSimpleList<RUserInfoStr> LSTUINFO;                     // simple linked list of user info structures
#define EXPORT  extern "C" __declspec (dllexport)               // exported functions declaration header
#define MAXPATH 300                                             // maximum path length, used for declaring long strings

// text constants
#define INIFILE         "wulog.ini"                             // .ini file name
#define INISECTION      "LOG"                                   // .ini file section header used
#define INILOGFILE      "FileName"                              // .ini file logfile line

// function definitions
EXPORT WORD CALLBACK HandleEventHook(RFTPEventStr* pEventStruc);

int operator==(const RUserInfoStr& ArgA,const RUserInfoStr& ArgB);  
void LoadIniFile(HINSTANCE hInst);                      // process .ini file
void LogLine(RFTPEventStr* pEventStruc);                // log line to logfile

#endif
