library ftpdll;
uses
  SysUtils,
  Classes,
  Unit1 in 'Unit1.pas' {DataModule1: TDataModule}; 

   {Create the Structure equivilant to what is being passed from the ftp Server}
   
   Type  
   RClientEventStr = Record
     Event: Integer;
     Flag : Integer;
     User : Array [0..39] of Char;
     Aux  : Array [0..511] of Char;
     Host : Array [0..15] of Char;
   End;

   
   {Notice the 'var' identifier in the function, this allows the function to 
    actually change the original data sent by the ftp server}
    
{The Entry Point DLL}
   Function HandleClientEvent ( Var EventStruc: RclientEventStr ): Integer cdecl;
   var
   MyAux: Pchar;
   Begin


       DataModule1 := TDataModule1.Create(nil);  {Make sure you can access the Data}

       MyAux:=EventStruc.Aux;  {Convert to Pchar so I can pass it to the functions 
                                and have the function modify it.}
                                
      

       HandleClientEvent:=FindClient(EventStruc.user);  
          {If a user is passed  (a user is always passed except on checking for IP 
            exclusions) and found in the database it returns True, else it returns 
            false. This also sets the database to the correct record so other
            data can be checked in the event functions.  }
     
     {
       The  Ftp server calls the Security Dll everytime the user tries do something.
       The EventStruc.Event variable is different depending on what the user is trying
       to do.  The case statement below breaks the request down to the 12 possible actions,
       each returning 0 if the user is not allowed and 1 if the user is allowed.  The
       EventStruc.Aux will be modified by the functions themselves if needed.
      }


      {All of these function are in Unit1.pas}

      case EventStruc.event of    
            1:  EventStruc.Flag:=GetLoginMessage(MyAux);  
            2:  EventStruc.Flag:=GetHomeDir(MyAux);   {Myaux is changed by this function to show the homedir}
            3:  EventStruc.Flag:=VerifyPassword(MyAux);  
            4:  EventStruc.Flag:=VerifyIpAddress(MyAux);  {Always Returns True in my Case}
            5:  EventStruc.Flag:=WriteOk(MyAux);  
            6:  EventStruc.Flag:=ReadOk(MyAux);  
            7:  EventStruc.Flag:=ModifyOk(MyAux);  
            8:  EventStruc.Flag:=ExecuteOk(MyAux);  {Always Returns false}
            9:  EventStruc.Flag:=ListDirOk(MyAux);  
           10:  EventStruc.Flag:=ChangeDirOk(MyAux);  
           11:  EventStruc.Flag:=DeleteDirOk(MyAux);  
           12:  EventStruc.Flag:=CreateDirOk(MyAux);  
       else 
         EventStruc.Flag:=1;
         HandleClientEvent:=1;
       end;  
       strplcopy(EventStruc.Aux,MyAux+#0,511);  {Change the AUX field of the pointer to the
                                                 value changed in the above functions}

   end;
   
   exports
     HandleClientEvent; {name '_HandleClientEvent';}
  
begin
end.


{
Please note that the function name is case sensitive!
The function should return TRUE (=1) if it handled the event and does not want it to be passed on to the next DLL. It should return FALSE (=0) in case it didn't handle the event.

The RClientEventStr structure is defined as follows:
}
{
}

{The 'Event' code determines the nature of the request and can have the following values:

	#define SRVU_LoginMesFile	1	// get login message file
	#define SRVU_HomeDir		   2	// get home dir
	#define SRVU_Password		3	// verify password
	#define SRVU_IPAccess		4	// verify IP access
	#define SRVU_WriteFile		5	// verify write access
	#define SRVU_ReadFile		6	// verify read access
	#define SRVU_ModifyFile		7	// verify mod./del. file access
	#define SRVU_ExecProg		8	// verify execute access
	#define SRVU_ListDir		   9	// verify dir listing access
	#define SRVU_ChangeDir		10	// verify dir change access
	#define SRVU_DeleteDir		11	// verify dir delete access
	#define SRVU_CreateDir		12	// verify dir create access


Event Details

SRVU_LoginMesFile
       On entry:	User = user name
       On return:	Flag = TRUE (=1) if file name was found, FALSE (=0) otherwise
Aux = file name of login message file, if one was found

SRVU_HomeDir
       On entry:	User = user name
       On return:	Flag = TRUE if home dir was found, FALSE otherwise
Aux = home dir (full path), if one was found

       Note:	In case a user account is disabled 'no home dir' should be returned.

SRVU_Password
       On entry:	User = user name
     	Aux = password the user entered
       On return:	Flag = TRUE if password was correct, FALSE otherwise

SRVU_IPAccess
       On entry:	User = user name if available
		Aux = IP address of client, in text format
       On return:	Flag = TRUE if access is allowed, FALSE otherwise
      Note:	If no user name is present it means the client just 	connected and a check should be made for server-wide IP access. If a user name is present access should be checked for that particular user only.

SRVU_WriteFile
       On entry:	User = user name
   	Aux = full path of file
       On return:	Flag = TRUE if access is allowed, FALSE otherwise

SRVU_ReadFile
       On entry:	User = user name
		Aux = full path of file
       On return:	Flag = TRUE if access is allowed, FALSE otherwise

SRVU_ModifyFile
       On entry:	User = user name
		Aux = full path of file
       On return:	Flag = TRUE if access is allowed, FALSE otherwise

SRVU_ExecProg
       On entry:	User = user name
		Aux = full path of program name to be executed
       On return:	Flag = TRUE if access is allowed, FALSE otherwise

SRVU_ListDir
       On entry:	User = user name
		Aux = full path of directory
       On return:	Flag = TRUE if access is allowed, FALSE otherwise

SRVU_ChangeDir
       On entry:	User = user name
		Aux = full path of directory
       On return:	Flag = TRUE if access is allowed, FALSE otherwise

SRVU_DeleteDir
       On entry:	User = user name
		Aux = full path of directory
       On return:	Flag = TRUE if access is allowed, FALSE otherwise

SRVU_CreateDir
       On entry:	User = user name
		Aux = full path of directory
      On return:	Flag = TRUE if access is allowed, FALSE otherwise

}



