// CHGUSER.H
// =========
//
//   Command line util for setting up a Serv-U user.
//

#ifndef CHGUSERH
#define CHGUSERH

#include <cstring.h>
#include "list.h"

// access rule access specifiers
#define FTP_READ	  'R'           // read access (files)
#define FTP_WRITE	  'W'           // write access (files)
#define FTP_MODIFY	  'M'           // modify/delete access (files)
#define FTP_CREATE	  'C'           // create access (dirs)
#define FTP_DELETE	  'D'           // delete access (dirs)
#define FTP_LIST	  'L'           // list access (dirs)
#define FTP_EXEC          'E'           // execute access (programs)
#define FTP_PROP	  'P'           // child dirs inherit rule

// command line options
#define FTP_NAMEOPT     "-name"         // user name
#define FTP_PASSWDOPT   "-passwd"       // password
#define FTP_HOMEDIROPT  "-homedir"      // home directory
#define FTP_HOMEIPOPT   "-homeip"       // IP home
#define FTP_ACCESSOPT   "-access"       // access rule
#define FTP_INIFILEOPT  "-inifile"      // .ini file name

// text used in .ini file sections
#define FTP_GLOBAL	  "GLOBAL"
#define FTP_SECURITY	  "Security"
#define FTP_PORTNR	  "PortNr"
#define FTP_MAXUSERS	  "MaxNrUsers"
#define FTP_MAXANON	  "MaxNrAnonymous"
#define FTP_INVISIBLE	  "Invisible"
#define FTP_LOGFILE	  "Logfile"
#define FTP_LOGGING	  "Logging"
#define FTP_SIGNONOFF	  "SIGNONOFF"
#define FTP_SIGNON	  "SignOn"
#define FTP_SIGNOFF	  "SignOff"
#define FTP_IPACCESS	  "IP-ACCESS"
#define FTP_BOUNCE	  "Bounce"
#define FTP_ALLOW	  "Allow"
#define FTP_USER	  "USER="
#define FTP_HOME	  "HomeDir"
#define FTP_ACCESS	  "Access"
#define FTP_PASS	  "Password"
#define FTP_GROUP	  "Group"
#define FTP_GROUP2	  "GROUP="
#define FTP_ALLUSER	  "USER=ALL"
#define FTP_READ	  'R'
#define FTP_WRITE	  'W'
#define FTP_MODIFY	  'M'
#define FTP_CREATE	  'C'
#define FTP_DELETE	  'D'
#define FTP_LIST	  'L'
#define FTP_EXEC          'E'
#define FTP_PROP	  'P'
#define FTP_AUTHORIZE	  "Authorization"
#define FTP_WINPOS	  "Window"
#define FTP_UINFOPOS	  "UserInfoWin"
#define FTP_USERTOUT	  "TimeoutUser"
#define FTP_ANONTOUT	  "TimeoutAnonymous"
#define FTP_TRYOUT	  "TryOut"
#define FTP_CRIPPLED	  "Crippled"
#define FTP_FULL	  "Full"
#define FTP_LOGGETS	  "LogGETs"
#define FTP_LOGPUTS	  "LogPUTs"
#define FTP_LOGSYSTEM	  "LogSystemMes"
#define FTP_LOGSECUR	  "LogSecurityMes"
#define FTP_LOGFTPCOM	  "LogFTPCommands"
#define FTP_LOGFTPREPLY   "LogFTPReplies"
#define FTP_LOGIPNAME	  "LogIPNames"
#define FTP_LOGDEBUG	  "LogDirtyDetails"
#define FTP_ANONRELPATH   "AnonRelPaths"
#define FTP_RELPATHS	  "RelPaths"
#define FTP_REGKEY	  "RegistrationKey"
#define FTP_KEYSECTION	  "KEY"
#define FTP_DIRCNGFILE1	  "DirChangeMesFile"
#define FTP_DIRCNGFILE2	  "DirChangeMesFile2"
#define FTP_PASSANON	  "CheckAnonPass"
#define FTP_VERSION	  "Version"
#define FTP_ENABLE	  "Enable"
#define FTP_LINKFILE1	  "LinkFile"
#define FTP_LINKFILE2	  "LinkFile2"
#define FTP_LOGINMES	  "LoginMesFile"
#define FTP_EXTERN	  "EXTERNAL"
#define FTP_CLIENTDLL	  "ClientCheckDLL"
#define FTP_IPHOMES	  "IP-HOMES"
#define FTP_IP		  "IP"
#define FTP_HIDEHIDDEN	  "HideHidden"
#define FTP_RATIOENABLE   "RatiosEnable"
#define FTP_RATIOS	  "Ratios"
#define FTP_RATIOUP	  "RatioUp"
#define FTP_RATIODOWN	  "RatioDown"
#define FTP_RATIOBPS	  "BytesPerSession"
#define FTP_RATIOFPS	  "FilesPerSession"
#define FTP_RATIOBALL	  "BytesOverall"
#define FTP_RATIOFALL	  "FilesOverall"
#define FTP_RATIOSECT	  "RATIOS"
#define FTP_RATIOFREE	  "Free"
#define FTP_RATIOCREDIT   "RatiosCredit"
#define FTP_QUOTAENABLE   "QuotaEnable"
#define FTP_QUOTAMAXCUR	  "QuotaMaxCurrent"
#define FTP_ALWAYSLOGIN   "AlwaysAllowLogin"
#define FTP_ICONIC	  "StartIconic"
#define FTP_DENYFIRST	  "DenyRulesFirst"
#define FTP_SERVICE       "AutoStart"
#define FTP_ONELOGINPERIP "OneLoginPerIP"
#define FTP_LOWERCASE	  "LowerCaseFileDir"
#define FTP_EVENTDLL	  "EventHookDLL"

// home-IP structure for multi-homed support
struct RHomeIPStr {
  int No;				// index number
  string HomeIP;			// IP number in string form
};

// some things to make life easier
#define FTP_DEFINIFILE  "SERV-U.INI"         // default .ini file
typedef RSimpleList<string> LSTSTRINGS;      // simple list of strings
typedef RSimpleList<RHomeIPStr> LSTHOMESTR;  // simple list of home-IPs

// function prototypes
int operator==(const RHomeIPStr& Str1,const RHomeIPStr& Str2);
void LoadIPHomes(LSTHOMESTR& HomeList,const string& IniFile);

#endif
