<?
/*****************************************************************************************
 *  WebChat - multiple private/open room chat system for PostNuke                        *
 *****************************************************************************************
 *   David "Cyklone" Thompson   david@thompsonville.net                                  *
 *   portions credited to Daniel Toma [dt@dnt.ro] [http://www.webdev.ro]                 *
 *****************************************************************************************
 *  Read CHANGELOG for updates and bug fixes                                             *
 *****************************************************************************************
 * POST-NUKE Content Management System                                                   *
 * Copyright (C) 2001 by the Post-Nuke Development Team.                                 *
 * http://www.postnuke.com/                                                              *
 * --------------------------------------------------------------------------------------*
 * Based on:                                                                             *
 * PHP-NUKE Web Portal System - http://phpnuke.org/                                      *
 * Thatware - http://thatware.org/                                                       *
 *****************************************************************************************/
?>
<html>
<head>
<style>
BODY {
  font-family: Verdana, sans-serif;
  color: #000055;
  font-size: 14px;
  font-weight: bold;
}
</style>
<script>
<!--
<?
  require("./inc/config.php");
  require("./inc/mysql.lib.php");
  require("./inc/smiley.php");

  set_magic_quotes_runtime(0);

  $DbLink = new DB($dbhost, $dbname, $dbuname, $dbpass);

  // let's make sure this user is indeed logged in on chat, drop otherwise
  $DbLink->query("select name from ".$prefix."_chatuser where uid = $uid");
  if(!$DbLink->num_rows()) {
    $DbLink->clean_results();
    $DbLink->close();
    ?>
    top.location="quit.php?rid=<?=$rid ?>&uid=<?=$uid ?>&reason=1&lang=<?=$lang ?>";
    </script>
    </head>
    </html>
    <?
    exit;
  }
  $DbLink->clean_results();

  $DbSmiles = new DB($dbhost, $dbname, $dbuname, $dbpass);  // we'll need this for the smiley function
  $RCPT_ID = 0;

  $txt = htmlspecialchars(rawurldecode(stripslashes($txt)));
  if (isset($txt) && trim($txt) != "") {
    if(preg_match("/^\/(\w+)\s+([^\s]+)\s+(.+)/i", $txt, $parts) || preg_match("/^\/(\w+)\s+([^\s]+)/i", $txt, $parts) || preg_match("/^\/(\w+)/i", $txt, $parts)) {
      if($parts[1] == 'msg') {
        if($parts[2] != '') {
          $txt = smiley(' '.$parts[3]);
                $DbLink->query("select uid from ".$prefix."_chatuser where name = '$parts[2]'");
          if($DbLink->num_rows() > 0) {
                  list($RCPT_ID) = $DbLink->next_record();
                  $cmd = 'MSG';
                } else {
                        $RCPT_ID = $uid;
                        $txt = '/'.$parts[1].' '.$parts[2].' - Recipient not found';
                        $cmd = 'USERERR';
                }
                $DbLink->clean_results();
              } else {
                $RCPT_ID = $uid;
                $txt = '/'.$parts[1].' - Recipient name missing';
                $cmd = 'USERERR';
              }
            } else {
              // test for sound commands
              $DbSounds = new DB($dbhost, $dbname, $dbuname, $dbpass);
              $DbSounds->query("select cmd, file, saytext from ".$prefix."_chatsound where cmd = '$parts[1]' LIMIT 1");
              if($DbSounds->num_rows() > 0) {
                list($cmd, $sndfile, $sndtext) = $DbSounds->next_record();
          if($sndtext != '')
            $txt = $sndtext.' to';
          else
            $txt = 'sending a '.$parts[1].' to';
          if($parts[2] != '' && $parts[2] != 'all') {
            $DbLink->query("select uid from ".$prefix."_chatuser where name = '$parts[2]'");
            if($DbLink->num_rows() > 0) {
                    list($RCPT_ID) = $DbLink->next_record();
                  } else {
                    $RCPT_ID = $uid;
                    $txt = $parts[1].' '.$parts[2].' - Recipient not found';
                          $cmd = 'USERERR';
                         }
                         $DbLink->clean_results();
                }
              } else {
          $txt = 'Unknown command: /'.$parts[1];
          $RCPT_ID = $uid;
          $cmd = 'USERERR';
              }
              $DbSounds->clean_results();
              $DbSounds->close();
            }
    }

    if($RCPT_ID != 0)
      $DbLink->query("select name from ".$prefix."_chatuser where uid = $RCPT_ID LIMIT 1");
    else
      $DbLink->query("select name from ".$prefix."_chatuser where uid = $uid LIMIT 1");
    if($DbLink->num_rows() > 0)
      list($name) = $DbLink->next_record();
    $DbLink->clean_results();

    $timestamp = '<span class="timestamp">'.date("h:i:sa", (time() + (doubleval($tz)) * 60 * 60)).'&nbsp;</span>';
    $message = rawurldecode(addslashes(smiley($txt)));  /* decode smiled msg for displaying */

    // check for system messages foist
    if(isset($cmd)) {
      switch($cmd) {
        case 'MSG':
          if($RCPT_ID == $uid)
            $toOut .= '<p class="message">'.$timestamp.'<font color="#BB6655"><b>(to you)</b></font> '.$message.'</p>';
          else
            $toOut .= '<p class="message">'.$timestamp.'<font color="#BB6655"><b>(to '.$name.')</b></font> '.$message.'</p>';
          break;
        case 'USERERR':
          $toOut .= '<p class="message">'.$timestamp.'<font color="red"><b>Error:</b></font> '.$message.'</p>';
          break;
        default:
          if($RCPT_ID != 0)
            $toOut .= '<p class="sysmessage">'.$timestamp.'<font color="#BB6655"><b>('.$message.' '.$name.')</b></font></p>';
          else
            $toOut .= '<p class="sysmessage">'.$timestamp.'<font color="#BB6655"><b>('.$message.' all users)</b></font></p>';
          break;
      }
    }

    // standard messages
    elseif($RCPT_ID == 0)
      $toOut .= '<p class="message">'.$timestamp.'<font color="blue"><b>'.$name.'&gt;</b></font>&nbsp;'.$message.'</p>';
    elseif($RCPT_ID != $uid)
      $toOut .= '<p class="message">'.$timestamp.'<font color="red"><b>'.$name.'&gt;</b></font> '.$message.'</p>';
    elseif($RCPT_ID == $uid)
        $toOut .= '<p class="message">'.$timestamp.'<font color="#BB6655"><b>(to you)</b></font> '.$message.'</p>';

    if($cmd != 'USERERR') {
      $txt = rawurlencode(addslashes($txt));  /* slash specialchars and encode for posting */
      $DbLink->query("insert into ".$prefix."_chatmessage values (".time().", $rid, $uid, $RCPT_ID, '$cmd', '$txt')");
    }
  }

  $DbLink->close();
  $DbSmiles->close();
  $chatroom = stripslashes($chatroom);
  if($toOut != '' ) {
?>
  toOut = '<?=$toOut ?>';
  if (document.all) {
    top.wOut.document.body.innerHTML+= toOut;
  } else {
    top.wOut.document.write("<html><style>BODY {font-family: Verdana, sans-serif; color: #000055; font-size: 12px;} </style><body bgcolor='#FFFFFF'>");
          top.wOut.document.write(toOut);
  }
<?
  }
?>
//-->
</script>
</head>
<body bgcolor="#C0C0C0" topmargin="0" rightmargin="4">
<table border="0" width="100%">
<tr><td align="center" valign="middle"><font size="+0"><b><?=$chatroom ?></b></font></td>
</tr>
</table>
<form name="form2" method="post" action="send.php?rid=<?=$rid ?>&uid=<?=$uid ?>&tz=<?=$tz ?>&chatroom=<?=$chatroom ?>&lang=<?=$lang ?>">
<input type="hidden" name="txt">
</form>
</body>
</html>
