<?
/*****************************************************************************************
 *  WebChat - multiple private/open room chat system for PostNuke                        *
 *****************************************************************************************
 *   David "Cyklone" Thompson   david@thompsonville.net                                  *
 *   portions credited to Daniel Toma [dt@dnt.ro] [http://www.webdev.ro]                 *
 *****************************************************************************************
 *  Read CHANGELOG for updates and bug fixes                                             *
 *****************************************************************************************
 * POST-NUKE Content Management System                                                   *
 * Copyright (C) 2001 by the Post-Nuke Development Team.                                 *
 * http://www.postnuke.com/                                                              *
 * --------------------------------------------------------------------------------------*
 * Based on:                                                                             *
 * PHP-NUKE Web Portal System - http://phpnuke.org/                                      *
 * Thatware - http://thatware.org/                                                       *
 *****************************************************************************************/
?>
<html>
<head>
<script>
<?
  require("./inc/config.php");
  require("./inc/mysql.lib.php");
  require("./inc/smiley.php");

  if(file_exists("language/lang-$lang.php"))
    include("language/lang-$lang.php");
  else
    include("language/lang-english.php");

  set_magic_quotes_runtime(0);

  $DbLink = new DB($dbhost, $dbname, $dbuname, $dbpass);
  $DbUsers = new DB($dbhost, $dbname, $dbuname, $dbpass);
  $DbSmiles = new DB($dbhost, $dbname, $dbuname, $dbpass);
  
  // clean old users and messages
  $tstamp = time();
  $tstamp -= $usertime;
  $DbLink->query("DELETE from ".$prefix."_chatuser WHERE last < '".$tstamp."'");
  $DbLink->query("DELETE from ".$prefix."_chatmessage WHERE time < '".$tstamp."'");
  
  $toOut = "";
  // if first time into chat get welcome message
  if(isset($first)) {
    $toOut = "<font class=\"sysmessage\">"._WCCHATWELCOME."</font>";
    $msgLastCheck = time();
  }
  $usersounds = array();
  $DbLink->query("select m.send_id, m.rcpt_id, m.cmd, m.message, m.time from ".$prefix."_chatmessage as m, ".$prefix."_chatuser as u where m.time > '$msgLastCheck' and u.uid = $uid and m.rid = $rid and ((m.rcpt_id <= 0 ) or (m.rcpt_id = $uid )) order by m.time");
  if($DbLink->num_rows() > 0) {
	  while(list($send_id, $rcpt_id, $cmd, $message, $time) = $DbLink->next_record()) {  
      $message = smiley(rawurldecode($message));
      if ( $send_id != 0 ) {
        $DbUsers->query("select name from ".$prefix."_chatuser where uid = $send_id LIMIT 1");
        if($DbUsers->num_rows() > 0)
          list($name) = $DbUsers->next_record();
        else
          $name = "*empty*";
        $DbUsers->clean_results();
      }
      $timestamp = '<span class="timestamp">'.date("h:i:sa", ($time + (doubleval($tz)) * 60 * 60)).'&nbsp;</span>';
      // check message types
      if($cmd != "") {
        if ( $cmd == "USERENTER" ) {
          $toOut .= '<P class="sysmessage">'.$timestamp.'<img src="images/u3.gif" border="0" align="absmiddle">'.$message.' has entered the chat room</p>';
          $uenter = true;
          ?>
          window.parent.frames['wUsers'].refresh();
          <?
        } elseif ( $cmd == "USERLEFT" ) {
          $toOut .= '<P class="sysmessage">'.$timestamp.'<img src="images/u4.gif" border="0" align="absmiddle">'.$message.' has left the chat room</p>';
          $uleft = true;
          ?>
          window.parent.frames['wUsers'].refresh();
          <?
        } elseif ($cmd == "MSG") {
          if( $send_id != $uid )
            $toOut .= '<P class="message">'.$timestamp.'<font color="#5566BB"><b>(from '.$name.')</b> '.$message.'</font></p>';
        } else {
          if ( $rcpt_id == 0 ) {
            $usersounds[] = $cmd;
            $toOut .= '<P class="sysmessage">'.$timestamp.'<img src="images/beep.gif" border="0" align="absmiddle">&nbsp;'.$name.' is '.$message.' the room</p>';
          } elseif ( $rcpt_id == $uid ) {
            $usersounds[] = $cmd;
            $toOut .= '<P class="sysmessage">'.$timestamp.'<img src="images/beep.gif" border="0" align="absmiddle">&nbsp;'.$name.' is '.$message.' you</p>';
          }
        }
      } else {
        if ( $rcpt_id == 0 ) {
          if ( $send_id != $uid ) 
          $toOut .= '<P class="message">'.$timestamp.'<font color="red"><b>'.$name.'&gt;</b></font> '.$message.'</p>';
        } else if( $send_id != $uid )
          $toOut .= '<P class="message">'.$timestamp.'<font color="#5566BB"><b>(from '.$name.')</b> '.$message.'</font></p>';
      }
      if($time > $msgLastCheck)
        $msgLastCheck = $time;
    }
  }

  if($toOut != "") {
    ?>
    toOut = '<?=$toOut?>';
    if (document.all) {
      top.wOut.document.body.innerHTML += toOut;
    } else {
      top.wOut.document.write("<html><style>BODY {font-family: Verdana, sans-serif; color: #000055; font-size: 12px;} </style><body bgcolor='#FFFFFF'>");
      top.wOut.document.write(toOut);
    }
    <?
  }

  $DbLink->clean_results();
  // update our time in user table
  $DbUsers->query("UPDATE ".$prefix."_chatuser SET last = ".time()." WHERE name = '$username'");
  if(!$DbUsers->affected_rows()) {
    // hmmm, no entry in user table, we either lost our connection for a while or a security problem
    // drop user
    $DbUsers->close();
    $DbLink->close();
    $DbSmiles->close();
    ?>
    top.location="quit.php?rid=<?=$rid; ?>&uid=<?=$uid; ?>&reason=1&lang=<?=$lang ?>";
    </script>
    </head>
    </html>
    <?
    exit;
  }
?>
function refresh() {
  window.location='receive.php?rid=<?=$rid ?>&uid=<?=$uid ?>&username=<?=$username ?>&tz=<?=$tz ?>&msgLastCheck=<?=$msgLastCheck ?>&allowsounds=<?=$allowsounds ?>&lang=<?=$lang ?>';
}
</script>
<?
if($allowsounds) {
  $callowsounds = "checked";
  if($uenter) {
    ?>
    <!-- Sound for user entrance -->
    <BGSOUND SRC="<?=$soundsdir?>/hi.wav" LOOP="1">
    <?
  }
  if($uleft) {
    ?>
    <!-- Sound for user exit -->
    <BGSOUND SRC="<?=$soundsdir?>/byebye.wav" LOOP="1">
    <?
  }
  $n_usersounds = count($usersounds);
  for ($i = 0; $i < $n_usersounds; $i++) {
    $DbLink->query("SELECT file FROM ".$prefix."_chatsound WHERE cmd = '$usersounds[$i]' LIMIT 1");
    list($sndfile) = $DbLink->next_record();
    ?>
    <!-- User sound -->
    <BGSOUND SRC="<?=$soundsdir.'/'.$sndfile ?>" LOOP="1">
    <?
    $DbLink->clean_results();
  }
}
?>
</head>
<body bgcolor="#EEEEFF" marginwidth="0" marginheight="3" leftmargin="0" topmargin="0">
<form action="receive.php?rid=<?=$rid ?>&uid=<?=$uid ?>&username=<?=$username ?>&tz=<?=$tz ?>&msgLastCheck=<?=$msgLastCheck ?>&lang=<?=$lang ?>" method="post">
<font size="-2" face="MS Sans Serif"><input type="checkbox" name="allowsounds" onClick="submit()" <?=$callowsounds ?>>Allow Sounds</font>
</form>
<script>
<!--
setTimeout('refresh()',<?=$msg_refresh?>);
// -->
</script>
</body>
</html>
<?
// do the update here on user online db to keep online if flagged in config
if($keeponline) {
  $DbLink2 = new DB($dbhost, $dbname, $dbuname, $dbpass);
  $ip = getenv("REMOTE_ADDR");
  if($uid < 0) {
    $guest = 1;
    $uname = $ip;
  } else {
    $guest = 0;
    $uname = $username;
  }
  $past = time() - 900;
  $DbLink->query("DELETE FROM ".$prefix."_session WHERE time < ".$past);
  $ctime = time();
  $DbLink->query("SELECT username from ".$prefix."_session WHERE username = '$uname' LIMIT 1");
  if($DbLink->num_rows() == 0)
    $DbLink2->query("INSERT INTO ".$prefix."_session (username, time, host_addr, guest) VALUES ('$uname', '$ctime', '$ip', '$guest')");
  else
    $DbLink2->query("UPDATE ".$prefix."_session SET time='$ctime', host_addr='$ip' WHERE username = '$uname'");
  $DbLink->clean_results();
  
  // also, a hack for lastseen update as well
  if($uid > 0) {
    $DbLink->query("SELECT * FROM ".$prefix."_lastseen WHERE username = '$username' LIMIT 1");
    if($DbLink->num_rows() > 0) 
      $DbLink2->query("UPDATE ".$prefix."_lastseen SET date = ".$ctime." WHERE username = '$username'");
    else
      $DbLink2->query("INSERT INTO ".$prefix."_lastseen VALUES ('', '$username', ".time().", '$ip')");
  }
  $DbLink2->close();
  $DbLink->clean_results();
}    
$DbLink->close();
$DbUsers->close();
$DbSmiles->close();
?>