<?
/*****************************************************************************************
 *  WebChat - multiple private/open room chat system for PostNuke                        *
 *****************************************************************************************
 *   David "Cyklone" Thompson   david@thompsonville.net                                  *
 *   portions credited to Daniel Toma [dt@dnt.ro] [http://www.webdev.ro]                 *
 *****************************************************************************************
 *  Read CHANGELOG for updates and bug fixes                                             *
 *****************************************************************************************
 * POST-NUKE Content Management System                                                   *
 * Copyright (C) 2001 by the Post-Nuke Development Team.                                 *
 * http://www.postnuke.com/                                                              *
 * --------------------------------------------------------------------------------------*
 * Based on:                                                                             *
 * PHP-NUKE Web Portal System - http://phpnuke.org/                                      *
 * Thatware - http://thatware.org/                                                       *
 *****************************************************************************************/

  require("./inc/config.php");
  require("./inc/mysql.lib.php");

  if(file_exists("language/lang-$lang.php"))
   include("language/lang-$lang.php");
  else
   include("language/lang-english.php");

  $DbLink = new DB($dbhost, $dbname, $dbuname, $dbpass);
  
  $DbLink->query("select name from ".$prefix."_chatuser where uid = $uid");
  if($DbLink->num_rows() > 0) {
    list($username) = $DbLink->next_record();
    $DbLink->clean_results();
	  $DbLink->query("insert into ".$prefix."_chatmessage values (".time().", $rid, 0, 0,'USERLEFT', '$username')");
    $DbLink->query("delete from ".$prefix."_chatuser where uid = $uid and rid = $rid");
  } else
    $DbLink->clean_results();
    
  $DbLink->query("select name from ".$prefix."_chatroom where rid = $rid");
  list($chatroom) = $DbLink->next_record();
  $DbLink->clean_results();
  $DbLink->close();
  
  if(!isset($username))
    $username = "unknown";
  
  $quitreason = sprintf(_WCQUITREASON0, $username, $chatroom);
  if(isset($reason)) {
    switch($reason) { // overridden if other than 0 set above
      case 1: $quitreason = sprintf(_WCQUITREASON1, $username, $chatroom); break;
    }
  }
  
?>
<html>
<title>WebChat [<?=$chatroom ?>]</title>
<style>
BODY {
  font-family: Verdana, sans-serif;
  color: #000055;
  font-size: 14px;
  font-weight: normal;
}
</style>
<body bgcolor="#FFFFFF">
<table border="0" width="100%" cellpadding="5" cellspacing="5">
<tr>
  <td align="center"><img src="images/webchat_powered.gif" border="0"></td>
</tr>
  <td align="center">
  <font size="+1">
  <br><?=$quitreason ?></font><br><br>
  <font size="-1">
  <?=_WCQUIT ?>
  <br><br>
  <input type="button" name="close" onClick="javascript:window.close()" value="Close Window" style="font-size: 11px; font-family: Verdana; border-width: 1px; border-color: black;">
  </font></td>
</tr>
</table>
