<?
/*****************************************************************************************
 *  WebChat - multiple private/open room chat system for PostNuke                        *
 *****************************************************************************************
 *   David "Cyklone" Thompson   david@thompsonville.net                                  *
 *   portions credited to Daniel Toma [dt@dnt.ro] [http://www.webdev.ro]                 *
 *****************************************************************************************
 *  Read CHANGELOG for updates and bug fixes                                             *
 *****************************************************************************************
 * POST-NUKE Content Management System                                                   *
 * Copyright (C) 2001 by the Post-Nuke Development Team.                                 *
 * http://www.postnuke.com/                                                              *
 * --------------------------------------------------------------------------------------*
 * Based on:                                                                             *
 * PHP-NUKE Web Portal System - http://phpnuke.org/                                      *
 * Thatware - http://thatware.org/                                                       *
 *****************************************************************************************/

// Main
define('_WCAPPNAME',          'WebChat');
define('_WCTITLE',            '%s '._WCAPPNAME);
define('_WCNOTINSTALLED',     _WCAPPNAME.' is not installed or there is a problem with the installation.<br><br>Click <a href="modules.php?op=modload&name=WebChat&file=install">here</a> to start the installation process');
define('_WCADMINNEEDED',      'Please login as an admin so that the ability to install '._WCAPPNAME.' is enabled!');
define('_WCNOACTIVE',         'There are no rooms created');
define('_WCBACKLIST',         'Back to list of chat rooms');
define('_WCINVALIDROOM',      'You selected an invalid chat room. Please go back and select one');
define('_WCNONICK',           'You didn\'t enter your nickname');
define('_WCPWREQROOM',        'A password is required to access this chat room');
define('_WCINVUSERPW',        'Username and/or password are wrong');
define('_WCROOMNAME',         'Room Name');
define('_WCROOMTYPE',         'Type');
define('_WCROOMDESC',         'Description');
define('_WCROOMOCCUPANTS',    'Occupants');
define('_WCPASSWORD',         'Password');
define('_WCACTION',           'Action');
define('_WCNORMROOM',         'Normal');
define('_WCPRIVROOM',         'Private');
define('_WCENTERUNAME',       'Enter a username');
define('_WCINVROOMPW',        'Invalid password entered for %s');
define('_WCREGONLY',          '%s is for registered users only');
define('_WCALREADYINROOM',    'A user by the name %s was found in %s already with the same IP address as you.<br>The user tables are cleared after %s seconds when you will be able to re-enter.');
define('_WCUSERENTER',        '%s has entered the chat');
define('_WCPWREQ',            'Password required');
define('_WCENTERPW',          'Enter password');
define('_WCUSERS',            'users');
define('_WCJOINROOM',         'Join Room');
define('_WCCHATTIPS',         'Tips: put text within asterisks <b>*</b> to <b>bold</b>, and within underscores <b>_</b> for <i>italics</i>');
define('_WCFILLFIELDS',       'Please fill in the required fields');
define('_WCREQFIELDS',        '* = Required field');
define('_WCPASSOPT',          '** = Only valid for Private rooms');
define('_WCCHATWELCOME',      'Welcome to the chat<br>Please keep your conversation intelligible and respectful');
define('_WCQUIT',             'Thank for using '._WCAPPNAME.', come again sometime.');
define('_WCQUITREASON0',      '%s, you have left the %s.');
define('_WCQUITREASON1',      '%s, you have been dropped from %s because you were no longer logged into the chat!');

// Admin 
define('_WCADMINMENU',        _WCAPPNAME.' Administration');
define('_WCADMINGEN',         'General Chat Settings');
define('_WCADMINROOMS',       'Chat Rooms Management');
define('_WCADMINSMILES',      'Smiley Management');
define('_WCADMINSOUNDS',      'Sounds Management');
define('_WCADMINSPECIAL',     'Special Room Functions');
define('_WCADMINDBHOST',      'DB Host (readonly)');
define('_WCADMINDBUNAME',     'DB Username (readonly)');
define('_WCADMINDBPW',        'DB Password (readonly)');
define('_WCADMINDBNAME',      'DB Name (readonly)');
define('_WCADMINDBPREFIX',    'DB Prefix (readonly)');
define('_WCADMINSMILE',       'Smilies');
define('_WCADD',              'Add');
define('_WCMODIFY',           'Modify');
define('_WCDELETE',           'Delete');
define('_WCNOTEMPTY',         'Cannot delete room. Please evacuate users first');
define('_WCADMINROOMSDESC',   'Create, modify and delete chat rooms');
define('_WCADMINGENDESC',     'Configure general settings for WebChat behaviour');
define('_WCADMINSPECIALDESC', 'Globally message rooms or kick users (not implemented yet)');
define('_WCADMINSMILEDESC',   'Add, edit and delete smilies');
define('_WCADMINSOUNDDESC',   'Add, edit and delete sounds');
define('_WCADMINMSGREFRESH',  'Message refresh time (millisecs)');
define('_WCADMINUSRTIME',     'User/messages age (secs)');
define('_WCADMINSHOWSMILES',  'Show smiley shortcuts');
define('_WCADMINSMILESDIR',   'Smilies directory');
define('_WCADMINUSESOUNDS',   'Use sounds');
define('_WCADMINSHOWSOUNDS',  'Show sound shortcuts (not implemented yet)');
define('_WCADMINSNDSDIR',     'Sounds directory');
define('_WCADMINSHOWUSRS',    'Show list of user names');
define('_WCADMINKEEPONLINE',  'Keep session alive on site');
define('_WCADMINGENMSG1',     'WebChat window runs standalone and requires the db settings (these are pulled from your PN config)');
define('_WCADMINGENMSG2',     'General WebChat window behavior');
define('_WCADMINCURSMILEDIR', 'Current Smiley Directory');
define('_WCADMINCURSOUNDDIR', 'Current Sounds Directory');
define('_WCSMILEID',          'SID');
define('_WCSMILEIMAGE',       'Image');
define('_WCSMILECODE',        'Code');
define('_WCSMILEFILE',        'Filename');
define('_WCSMILEEMOTION',     'Emotion');
define('_WCSMILESHOW',        'Show shortcut');
define('_WCSOUNDCMD',         'Command');
define('_WCSOUNDFILE',        'Filename');
define('_WCSOUNDTEXT',        'Chat Say Text');
define('_WCSOUNDSHOW',        'Show shortcut');
define('_WCYES',              'Yes');
define('_WCNO',               'No');
define('_WCSAVESETTINGS',     'Save Settings');
define('_WCSETTINGSSAVED',    'Settings saved successfully');
define('_WCSETTINGSERR',      'Settings could not be saved!');
define('_WCONLINE',           'online');
define('_WCALLOWCREATE',      'Allow users to create rooms');
define('_WCONLYREGCANCREATE', 'Only registered users can create rooms');
define('_WCCREATEAROOM',      'Create your own chat room');
define('_WCORIGINAL',         'Original');

// help
define('_WCHELPTITLE',        _WCAPPNAME.' Help');
define('_WCHELPSMILETBL',     'Installed Smilies<br><br>The [code] column shows what is typed in your text to achieve the smiley displayed in the [Image] column.');
define('_WCHELPSOUNDTBL',     'Installed Sounds<br><br>The [command] column shows what command is typed to hear the sound.  The [Chat say text] column is the text that is displayed.');
define('_WCHELPSOUNDTBLOPTS', '<b>Options:</b><br><b><i><username></i></b>  if a username is specified the sound is directly to only them.<br>i.e. <b><i>/hey judy</i></b> will send the sound to Judy only.');
define('_WCHELPTEXT1',        'How to use smilies in your text');
define('_WCHELPTEXT2',        'How to invoke sounds in the chat');
define('_WCHELPTEXT3',        'What other commands are supported');
define('_WCHELPTOP',          'Back to top');
define('_WCHELPCLOSE',        'Close window');
define('_WCHELPNODATA',       'No %s installed at this time');
define('_WCHELPCMDTBL',       'Supported commands');
define('_WCHELPCMDDESC',      'Description');
define('_WCHELPCMDMSGHLP',    'Send a private message to <i>username</i>.  No one else will see this message.<br>A quick way to do this is by clicking on the username in the UserList');

// install
define('_WCINSGENSETTINGS',   'Installation: General Settings for WebChat behaviour');
define('_WCINSSAVESETTINGS',  'Save Settings and Continue');
define('_WCINSCONFIGSAVED',   'Settings saved and config.php created successfully.');
define('_WCINSTABLEERR',      'Error creating the table');
define('_WCINSTABLECREATED',  'table was created successfully.');
define('_WCINSCONT',          'Continue Installation');
define('_WCINSDONE',          'Done');
define('_WCINSTALLED',        _WCAPPNAME.' has been installed successfully!<br><br>I hope you like '._WCAPPNAME.' and find it useful.  Please report bugs or requests to <a href="http://naturald.sytes.net">Natural Disasters</a>');
define('_WCINSADDINGDEF',     'Installation: Adding some defaults to the tables...');
define('_WCINSDONETXT',       'Installation and Setup is now Done.  Clicking on [Done] will delete the install.php file and complete the install.');
define('_WCINSCREATETABLES',  'Installation: Creating the tables...');
define('_WCINSADDINGSMILES',  'Adding smiles...');
define('_WCINSADDINGROOMS',   'Adding rooms...');
define('_WCINSADDINGSOUNDS',  'Adding sounds...');
define('_WCINSADDINGERR',     'Error adding data into %s table');
define('_WCINSADDINGDONE',    'Done adding data to %s table');
?>