<?
/*****************************************************************************************
 *  WebChat - multiple private/open room chat system for PostNuke                        *
 *****************************************************************************************
 *   David "Cyklone" Thompson   david@thompsonville.net                                  *
 *   portions credited to Daniel Toma [dt@dnt.ro] [http://www.webdev.ro]                 *
 *****************************************************************************************
 *  Read CHANGELOG for updates and bug fixes                                             *
 *****************************************************************************************
 * POST-NUKE Content Management System                                                   *
 * Copyright (C) 2001 by the Post-Nuke Development Team.                                 *
 * http://www.postnuke.com/                                                              *
 * --------------------------------------------------------------------------------------*
 * Based on:                                                                             *
 * PHP-NUKE Web Portal System - http://phpnuke.org/                                      *
 * Thatware - http://thatware.org/                                                       *
 *****************************************************************************************/

function smiley($message) {
  global $DbSmiles, $prefix, $smilesdir, $dbhost, $dbname, $dbuname, $dbpass;
  
  $patterns = array();
  $replace = array();
  $DbSmiles->query("SELECT code, file, emotion, length(code) as length FROM ".$prefix."_chatsmile ORDER BY length DESC");
  if($DbSmiles->num_rows() > 0) {
    while(list($code, $filename, $emotion, $length) = $DbSmiles->next_record()) {
      $patterns[] = '/([\n\\ \\.])'.preg_quote("$code").'/si';
      $replace[]  = ' <img src="'.$smilesdir.'/'.$filename.'" border="0" alt="'.$code.'" align="absmiddle">';
    }
  }
  $DbSmiles->clean_results();
  // plus some xtra handy dandy ones
  $patterns[] = "/(http\:\/\/[^\s]+)/i";
	$patterns[] = "/(ftp\:\/\/[^\s]+)/i";	  
	$patterns[] = "/(mailto\:([^\s]+))/i";
	$patterns[] = "/\*(.+)\*/i";
	$patterns[] = "/\_(.+)\_/i";
	$patterns[] = "/\r/i";
  $replace[]  = "<a href=\"\\1\" target=\"_blank\">\\1</a>"; 
	$replace[]  = "<a href=\"\\1\" target=\"_blank\">\\1</a>"; 
	$replace[]  = "<a href=\"\\1\" target=\"_blank\">\\2</a>"; 
	$replace[]  = "<b>\\1</b>";
	$replace[]  = "<i>\\1</i>";
	$replace[]  = "<br>\n";
  
  // pad to allow for proper comparisms
  $message = ' '.$message;
  $message = preg_replace($patterns,$replace,$message);
  $message = substr($message,1);
  return($message);
}
?>
