<?php

/************************************************************************/
/* PHP-NUKE: Advanced Content Management System                         */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2002 by Francisco Burzi                                */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (eregi("install.php", $PHP_SELF)) {
    Header("Location: ../index.php");
    die();
}
global $prefix, $user_prefix;

sql_query("CREATE TABLE ".$prefix."_access (
  access_id int(10) NOT NULL auto_increment,
  access_title varchar(20) default NULL,
  PRIMARY KEY  (access_id),
  KEY access_id (access_id)
)", $dbi);

sql_query("INSERT INTO ".$prefix."_access VALUES (-1, 'Deleted')", $dbi);
sql_query("INSERT INTO ".$prefix."_access VALUES (1, 'User')", $dbi);
sql_query("INSERT INTO ".$prefix."_access VALUES (2, 'Moderator')", $dbi);
sql_query("INSERT INTO ".$prefix."_access VALUES (3, 'Super Moderator')", $dbi);
sql_query("INSERT INTO ".$prefix."_access VALUES (4, 'Administrator')", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_authors (
  aid varchar(25) NOT NULL default '',
  name varchar(50) default NULL,
  url varchar(255) NOT NULL default '',
  email varchar(255) NOT NULL default '',
  pwd varchar(40) default NULL,
  counter int(11) NOT NULL default '0',
  radminarticle tinyint(2) NOT NULL default '0',
  radmintopic tinyint(2) NOT NULL default '0',
  radminuser tinyint(2) NOT NULL default '0',
  radminsurvey tinyint(2) NOT NULL default '0',
  radminsection tinyint(2) NOT NULL default '0',
  radminlink tinyint(2) NOT NULL default '0',
  radminephem tinyint(2) NOT NULL default '0',
  radminfaq tinyint(2) NOT NULL default '0',
  radmindownload tinyint(2) NOT NULL default '0',
  radminreviews tinyint(2) NOT NULL default '0',
  radminnewsletter tinyint(2) NOT NULL default '0',
  radminforum tinyint(2) NOT NULL default '0',
  radmincontent tinyint(2) NOT NULL default '0',
  radminency tinyint(2) NOT NULL default '0',
  radminsuper tinyint(2) NOT NULL default '1',
  admlanguage varchar(30) NOT NULL default '',
  PRIMARY KEY  (aid),
  KEY aid (aid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_autonews (
  anid int(11) NOT NULL auto_increment,
  catid int(11) NOT NULL default '0',
  aid varchar(30) NOT NULL default '',
  title varchar(80) NOT NULL default '',
  time varchar(19) NOT NULL default '',
  hometext text NOT NULL,
  bodytext text NOT NULL,
  topic int(3) NOT NULL default '1',
  informant varchar(20) NOT NULL default '',
  notes text NOT NULL,
  ihome int(1) NOT NULL default '0',
  alanguage varchar(30) NOT NULL default '',
  acomm int(1) NOT NULL default '0',
  PRIMARY KEY  (anid),
  KEY anid (anid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_banlist (
  ban_id int(10) NOT NULL auto_increment,
  ban_userid int(10) default NULL,
  ban_ip varchar(16) default NULL,
  ban_start int(32) default NULL,
  ban_end int(50) default NULL,
  ban_time_type int(10) default NULL,
  PRIMARY KEY  (ban_id),
  KEY ban_id (ban_id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_banner (
  bid int(11) NOT NULL auto_increment,
  cid int(11) NOT NULL default '0',
  imptotal int(11) NOT NULL default '0',
  impmade int(11) NOT NULL default '0',
  clicks int(11) NOT NULL default '0',
  imageurl varchar(100) NOT NULL default '',
  clickurl varchar(200) NOT NULL default '',
  alttext varchar(255) NOT NULL default '',
  date datetime default NULL,
  dateend datetime default NULL,
  type tinyint(1) NOT NULL default '0',
  active tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (bid),
  KEY bid (bid),
  KEY cid (cid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_bannerclient (
  cid int(11) NOT NULL auto_increment,
  name varchar(60) NOT NULL default '',
  contact varchar(60) NOT NULL default '',
  email varchar(60) NOT NULL default '',
  login varchar(10) NOT NULL default '',
  passwd varchar(10) NOT NULL default '',
  extrainfo text NOT NULL,
  PRIMARY KEY  (cid),
  KEY cid (cid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_bbtopics (
  topic_id int(10) NOT NULL auto_increment,
  topic_title varchar(100) default NULL,
  topic_poster int(10) default NULL,
  topic_time varchar(20) default NULL,
  topic_views int(10) NOT NULL default '0',
  topic_replies int(10) NOT NULL default '0',
  topic_last_post_id int(10) NOT NULL default '0',
  forum_id int(10) NOT NULL default '0',
  topic_status int(10) NOT NULL default '0',
  topic_notify int(2) default '0',
  PRIMARY KEY  (topic_id),
  KEY topic_id (topic_id),
  KEY forum_id (forum_id),
  KEY topic_last_post_id (topic_last_post_id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_blocks (
  bid int(10) NOT NULL auto_increment,
  bkey varchar(15) NOT NULL default '',
  title varchar(60) NOT NULL default '',
  content text NOT NULL,
  url varchar(200) NOT NULL default '',
  position char(1) NOT NULL default '',
  weight int(10) NOT NULL default '1',
  active int(1) NOT NULL default '1',
  refresh int(10) NOT NULL default '0',
  time varchar(14) NOT NULL default '0',
  blanguage varchar(30) NOT NULL default '',
  blockfile varchar(255) NOT NULL default '',
  view int(1) NOT NULL default '0',
  PRIMARY KEY  (bid),
  KEY bid (bid),
  KEY title (title)
)", $dbi);

sql_query("INSERT INTO ".$prefix."_blocks VALUES (1, '', 'Modules', '', '', 'l', 1, 1, 0, '', '', 'block-Modules.php', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (2, 'admin', 'Administration', '<strong><big>&middot;</big></strong> <a href=\"admin.php\">Administration</a><br>\r\n<strong><big>&middot;</big></strong> <a href=\"admin.php?op=adminStory\">NEW Story</a><br>\r\n<strong><big>&middot;</big></strong> <a href=\"admin.php?op=create\">Change Survey</a><br>\r\n<strong><big>&middot;</big></strong> <a href=\"admin.php?op=content\">Content</a><br>\r\n<strong><big>&middot;</big></strong> <a href=\"admin.php?op=logout\">Logout</a>', '', 'l', 2, 1, 0, '985591188', '', '', 2)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (3, '', 'Who\'s Online', '', '', 'l', 3, 1, 0, '', '', 'block-Who_is_Online.php', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (4, '', 'Search', '', '', 'l', 4, 0, 3600, '', '', 'block-Search.php', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (5, '', 'Languages', '', '', 'l', 5, 1, 3600, '', '', 'block-Languages.php', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (6, '', 'Random Headlines', '', '', 'l', 6, 0, 3600, '', '', 'block-Random_Headlines.php', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (7, '', 'Amazon', '', '', 'l', 7, 1, 3600, '', '', 'block-Amazon.php', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (8, 'userbox', 'User\'s Custom Box', '', '', 'r', 1, 1, 0, '', '', '', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (9, '', 'Categories Menu', '', '', 'r', 2, 0, 0, '', '', 'block-Categories.php', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (10, '', 'Survey', '', '', 'r', 3, 1, 3600, '', '', 'block-Survey.php', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (11, '', 'Login', '', '', 'r', 4, 1, 3600, '', '', 'block-Login.php', 3)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (12, '', 'Big Story of Today', '', '', 'r', 5, 1, 3600, '', '', 'block-Big_Story_of_Today.php', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (13, '', 'Old Articles', '', '', 'r', 6, 1, 3600, '', '', 'block-Old_Articles.php', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_blocks VALUES (14, '', 'Information', '<br><center><font class=\"content\">\r\n<a href=\"http://phpnuke.org\"><img src=\"images/powered/phpnuke.gif\" border=\"0\" alt=\"Powered by PHP-Nuke\" title=\"Powered by PHP-Nuke\" width=\"88\" height=\"31\"></a>\r\n<br><br>\r\n<a href=\"http://validator.w3.org/check/referer\"><img src=\"images/html401.gif\" width=\"88\" height=\"31\" alt=\"Valid HTML 4.01!\" title=\"Valid HTML 4.01!\" border=\"0\"></a>\r\n<br><br>\r\n<a href=\"http://jigsaw.w3.org/css-validator\"><img src=\"images/css.gif\" width=\"88\" height=\"31\" alt=\"Valid CSS!\" title=\"Valid CSS!\" border=\"0\"></a></font></center><br>', '', 'r', 7, 1, 0, '', '', '', 0)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_catagories (
  cat_id int(10) NOT NULL auto_increment,
  cat_title varchar(100) default NULL,
  cat_order varchar(10) default NULL,
  PRIMARY KEY  (cat_id),
  KEY cat_id (cat_id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_comments (
  tid int(11) NOT NULL auto_increment,
  pid int(11) default '0',
  sid int(11) default '0',
  date datetime default NULL,
  name varchar(60) NOT NULL default '',
  email varchar(60) default NULL,
  url varchar(60) default NULL,
  host_name varchar(60) default NULL,
  subject varchar(85) NOT NULL default '',
  comment text NOT NULL,
  score tinyint(4) NOT NULL default '0',
  reason tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (tid),
  KEY tid (tid),
  KEY pid (pid),
  KEY sid (sid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_config (
  sitename varchar(255) NOT NULL default '',
  nukeurl varchar(255) NOT NULL default '',
  site_logo varchar(255) NOT NULL default '',
  slogan varchar(255) NOT NULL default '',
  startdate varchar(50) NOT NULL default '',
  adminmail varchar(255) NOT NULL default '',
  anonpost tinyint(1) NOT NULL default '0',
  Default_Theme varchar(255) NOT NULL default '',
  foot1 text NOT NULL,
  foot2 text NOT NULL,
  foot3 text NOT NULL,
  commentlimit int(9) NOT NULL default '4096',
  anonymous varchar(255) NOT NULL default '',
  minpass tinyint(1) NOT NULL default '5',
  pollcomm tinyint(1) NOT NULL default '1',
  articlecomm tinyint(1) NOT NULL default '1',
  broadcast_msg tinyint(1) NOT NULL default '1',
  my_headlines tinyint(1) NOT NULL default '1',
  top int(3) NOT NULL default '10',
  storyhome int(2) NOT NULL default '10',
  user_news tinyint(1) NOT NULL default '1',
  oldnum int(2) NOT NULL default '30',
  ultramode tinyint(1) NOT NULL default '0',
  banners tinyint(1) NOT NULL default '1',
  backend_title varchar(255) NOT NULL default '',
  backend_language varchar(10) NOT NULL default '',
  language varchar(100) NOT NULL default '',
  locale varchar(10) NOT NULL default '',
  multilingual tinyint(1) NOT NULL default '0',
  useflags tinyint(1) NOT NULL default '0',
  notify tinyint(1) NOT NULL default '0',
  notify_email varchar(255) NOT NULL default '',
  notify_subject varchar(255) NOT NULL default '',
  notify_message varchar(255) NOT NULL default '',
  notify_from varchar(255) NOT NULL default '',
  footermsgtxt text NOT NULL,
  email_send tinyint(1) NOT NULL default '1',
  attachmentdir varchar(255) NOT NULL default '',
  attachments tinyint(1) NOT NULL default '0',
  attachments_view tinyint(1) NOT NULL default '0',
  download_dir varchar(255) NOT NULL default '',
  defaultpopserver varchar(255) NOT NULL default '',
  singleaccount tinyint(1) NOT NULL default '',
  singleaccountname varchar(255) NOT NULL default '',
  numaccounts tinyint(2) NOT NULL default '-1',
  imgpath varchar(255) NOT NULL default '',
  filter_forward tinyint(1) NOT NULL default '1',
  moderate tinyint(1) NOT NULL default '0',
  admingraphic tinyint(1) NOT NULL default '1',
  httpref tinyint(1) NOT NULL default '1',
  httprefmax int(5) NOT NULL default '1000',
  CensorMode tinyint(1) NOT NULL default '3',
  CensorReplace varchar(10) NOT NULL default '',
  copyright text NOT NULL,
  Version_Num varchar(10) NOT NULL default ''
)", $dbi);
// DO NOT REMOVE NOR CHANGE/EDIT THE FOLLOWING LINE BECAUSE IT CONTAINS COPYRIGHT INFORMATION. TO EDIT THESE VALUES GO TO THE ADMINISTRATION SYSTEM.
mysql_query("INSERT INTO ".$prefix."_config VALUES ('PHP-Nuke Powered Site','http://yoursite.com','logo.gif','Your slogan here','September 2002','webmaster@yoursite.com',0,'DeepBlue','<a href=\'http://phpnuke.org\' target=\'blank\'><img src=\'images/powered/nuke.gif\' border=\'0\' Alt=\'Web site powered by PHP-Nuke\' hspace=\'10\'></a><br>','All logos and trademarks in this site are property of their respective owner. The comments are property of their posters, all the rest  2002 by me','You can syndicate our news using the file <a href=\'backend.php\'><font class=\'footmsg_l\'>backend.php</font></a> or <a href=\'ultramode.txt\'><font class=\'footmsg_l\'>ultramode.txt</font></a>',4096,'Anonymous',5,1,1,1,1,10,10,1,30,0,1,'PHP-Nuke Powered Site','zh_TW','chinese','zh_TW',0,0,0,'me@yoursite.com','NEWS for my site','Hey! You got a new submission for your site.','webmaster','Mail sent from WebMail service at PHP-Nuke Powered Site\r\n- http://yoursite.com',1,'/var/www/html/modules/WebMail/tmp/',0,0,'modules/WebMail/attachments/','','0','Your account',-1,'modules/WebMail/images',1,0,1,1,1000,3,'*****','Web site engine\'s code is Copyright &copy; 2002 by <a href=\"http://phpnuke.org\"><font class=\'footmsg_l\'>PHP-Nuke</font></a>. All Rights Reserved. PHP-Nuke is Free Software released under the <a href=\"http://www.gnu.org\"><font class=\'footmsg_l\'>GNU/GPL license</font></a>.','6.0')", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_contactbook (
  uid int(11) default NULL,
  contactid int(11) NOT NULL auto_increment,
  firstname varchar(50) default NULL,
  lastname varchar(50) default NULL,
  email varchar(255) default NULL,
  company varchar(255) default NULL,
  homeaddress varchar(255) default NULL,
  city varchar(80) default NULL,
  homephone varchar(255) default NULL,
  workphone varchar(255) default NULL,
  homepage varchar(255) default NULL,
  IM varchar(255) default NULL,
  events text,
  reminders int(11) default NULL,
  notes text,
  PRIMARY KEY  (contactid),
  KEY uid (uid),
  KEY contactid (contactid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_counter (
  type varchar(80) NOT NULL default '',
  var varchar(80) NOT NULL default '',
  count int(10) unsigned NOT NULL default '0'
)", $dbi);

sql_query("INSERT INTO ".$prefix."_counter VALUES ('total', 'hits', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('browser', 'WebTV', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('browser', 'Lynx', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('browser', 'MSIE', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('browser', 'Opera', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('browser', 'Konqueror', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('browser', 'Netscape', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('browser', 'Bot', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('browser', 'Other', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('os', 'Windows', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('os', 'Linux', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('os', 'Mac', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('os', 'FreeBSD', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('os', 'SunOS', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('os', 'IRIX', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('os', 'BeOS', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('os', 'OS/2', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('os', 'AIX', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_counter VALUES ('os', 'Other', 0)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_disallow (
  disallow_id int(10) NOT NULL auto_increment,
  disallow_username varchar(50) default NULL,
  PRIMARY KEY  (disallow_id),
  KEY disallow_id (disallow_id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_downloads_categories (
  cid int(11) NOT NULL auto_increment,
  title varchar(50) NOT NULL default '',
  cdescription text NOT NULL,
  parentid int(11) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY cid (cid),
  KEY title (title)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_downloads_downloads (
  lid int(11) NOT NULL auto_increment,
  cid int(11) NOT NULL default '0',
  sid int(11) NOT NULL default '0',
  title varchar(100) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  description text NOT NULL,
  date datetime default NULL,
  name varchar(100) NOT NULL default '',
  email varchar(100) NOT NULL default '',
  hits int(11) NOT NULL default '0',
  submitter varchar(60) NOT NULL default '',
  downloadratingsummary double(6,4) NOT NULL default '0.0000',
  totalvotes int(11) NOT NULL default '0',
  totalcomments int(11) NOT NULL default '0',
  filesize int(11) NOT NULL default '0',
  version varchar(10) NOT NULL default '',
  homepage varchar(200) NOT NULL default '',
  PRIMARY KEY  (lid),
  KEY lid (lid),
  KEY cid (cid),
  KEY sid (sid),
  KEY title (title)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_downloads_editorials (
  downloadid int(11) NOT NULL default '0',
  adminid varchar(60) NOT NULL default '',
  editorialtimestamp datetime NOT NULL default '0000-00-00 00:00:00',
  editorialtext text NOT NULL,
  editorialtitle varchar(100) NOT NULL default '',
  PRIMARY KEY  (downloadid),
  KEY downloadid (downloadid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_downloads_modrequest (
  requestid int(11) NOT NULL auto_increment,
  lid int(11) NOT NULL default '0',
  cid int(11) NOT NULL default '0',
  sid int(11) NOT NULL default '0',
  title varchar(100) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  description text NOT NULL,
  modifysubmitter varchar(60) NOT NULL default '',
  brokendownload int(3) NOT NULL default '0',
  name varchar(100) NOT NULL default '',
  email varchar(100) NOT NULL default '',
  filesize int(11) NOT NULL default '0',
  version varchar(10) NOT NULL default '',
  homepage varchar(200) NOT NULL default '',
  PRIMARY KEY  (requestid),
  UNIQUE KEY requestid (requestid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_downloads_newdownload (
  lid int(11) NOT NULL auto_increment,
  cid int(11) NOT NULL default '0',
  sid int(11) NOT NULL default '0',
  title varchar(100) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  description text NOT NULL,
  name varchar(100) NOT NULL default '',
  email varchar(100) NOT NULL default '',
  submitter varchar(60) NOT NULL default '',
  filesize int(11) NOT NULL default '0',
  version varchar(10) NOT NULL default '',
  homepage varchar(200) NOT NULL default '',
  PRIMARY KEY  (lid),
  KEY lid (lid),
  KEY cid (cid),
  KEY sid (sid),
  KEY title (title)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_downloads_votedata (
  ratingdbid int(11) NOT NULL auto_increment,
  ratinglid int(11) NOT NULL default '0',
  ratinguser varchar(60) NOT NULL default '',
  rating int(11) NOT NULL default '0',
  ratinghostname varchar(60) NOT NULL default '',
  ratingcomments text NOT NULL,
  ratingtimestamp datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (ratingdbid),
  KEY ratingdbid (ratingdbid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_encyclopedia (
  eid int(10) NOT NULL auto_increment,
  title varchar(255) NOT NULL default '',
  description text NOT NULL,
  elanguage varchar(30) NOT NULL default '',
  active int(1) NOT NULL default '0',
  PRIMARY KEY  (eid),
  KEY eid (eid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_encyclopedia_text (
  tid int(10) NOT NULL auto_increment,
  eid int(10) NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  text text NOT NULL,
  counter int(10) NOT NULL default '0',
  PRIMARY KEY  (tid),
  KEY tid (tid),
  KEY eid (eid),
  KEY title (title)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_ephem (
  eid int(11) NOT NULL auto_increment,
  did int(2) NOT NULL default '0',
  mid int(2) NOT NULL default '0',
  yid int(4) NOT NULL default '0',
  content text NOT NULL,
  elanguage varchar(30) NOT NULL default '',
  PRIMARY KEY  (eid),
  KEY eid (eid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_faqAnswer (
  id tinyint(4) NOT NULL auto_increment,
  id_cat tinyint(4) default NULL,
  question varchar(255) default NULL,
  answer text,
  PRIMARY KEY  (id),
  KEY id (id),
  KEY id_cat (id_cat)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_faqCategories (
  id_cat tinyint(3) NOT NULL auto_increment,
  categories varchar(255) default NULL,
  flanguage varchar(30) NOT NULL default '',
  PRIMARY KEY  (id_cat),
  KEY id_cat (id_cat)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_forum_access (
  forum_id int(10) NOT NULL default '0',
  user_id int(10) NOT NULL default '0',
  can_post tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (forum_id,user_id),
  KEY forum_id (forum_id),
  KEY user_id (user_id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_forum_config (
  allow_html int(2) default NULL,
  allow_bbcode int(2) default NULL,
  allow_sig int(2) default NULL,
  posts_per_page int(10) default NULL,
  hot_threshold int(10) default NULL,
  topics_per_page int(10) default NULL,
  index_head text,
  index_foot text,
  max_upfile int(6) NOT NULL default '300'
)", $dbi);

sql_query("INSERT INTO ".$prefix."_forum_config VALUES (1, 1, 1, 10, 10, 20, NULL, NULL, 300)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_forum_mods (
  forum_id int(10) NOT NULL default '0',
  user_id int(10) NOT NULL default '0',
  KEY forum_id (forum_id),
  KEY user_id (user_id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_forums (
  forum_id int(10) NOT NULL auto_increment,
  forum_name varchar(150) default NULL,
  forum_desc text,
  forum_access int(10) default '1',
  forum_moderator int(10) default NULL,
  cat_id int(10) default NULL,
  forum_type int(10) default '0',
  forum_pass varchar(60) default NULL,
  forum_notify_email varchar(30) default NULL,
  forum_atch int(2) NOT NULL default '0',
  PRIMARY KEY  (forum_id),
  KEY forum_id (forum_id),
  KEY forum_name (forum_name)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_forumtopics (
  topic_id int(10) NOT NULL auto_increment,
  topic_title varchar(100) default NULL,
  topic_poster int(10) default NULL,
  topic_time varchar(20) default NULL,
  topic_views int(10) NOT NULL default '0',
  forum_id int(10) default NULL,
  topic_status int(10) NOT NULL default '0',
  topic_notify int(2) default '0',
  PRIMARY KEY  (topic_id),
  KEY topic_id (topic_id),
  KEY forum_id (forum_id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_headlines (
  hid int(11) NOT NULL auto_increment,
  sitename varchar(30) NOT NULL default '',
  headlinesurl varchar(200) NOT NULL default '',
  PRIMARY KEY  (hid),
  KEY hid (hid)
)", $dbi);

sql_query("INSERT INTO ".$prefix."_headlines VALUES (1, 'PHP-Nuke', 'http://phpnuke.org/backend.php')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (2, 'ODISEA', 'http://odisea.org/backend.php')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (3, 'LinuxCentral', 'http://linuxcentral.com/backend/lcnew.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (4, 'NewsForge', 'http://www.newsforge.com/newsforge.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (5, 'PHPBuilder', 'http://phpbuilder.com/rss_feed.php')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (6, 'PHP-Nuke Espaol', 'http://phpnuke-espanol.org/backend.php')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (7, 'Freshmeat', 'http://freshmeat.net/backend/fm.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (8, 'AppWatch', 'http://static.appwatch.com/appwatch.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (9, 'LinuxWeelyNews', 'http://lwn.net/headlines/rss')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (10, 'HappyPenguin', 'http://happypenguin.org/html/news.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (11, 'Segfault', 'http://segfault.org/stories.xml')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (13, 'KDE', 'http://www.kde.org/news/kdenews.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (14, 'Perl.com', 'http://www.perl.com/pace/perlnews.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (15, 'Themes.org', 'http://www.themes.org/news.rdf.phtml')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (16, 'BrunchingShuttlecocks', 'http://www.brunching.com/brunching.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (17, 'MozillaNewsBot', 'http://www.mozilla.org/newsbot/newsbot.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (18, 'NewsTrolls', 'http://newstrolls.com/newstrolls.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (19, 'FreakTech', 'http://sunsite.auc.dk/FreakTech/FreakTech.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (20, 'AbsoluteGames', 'http://files.gameaholic.com/agfa.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (21, 'SciFi-News', 'http://www.technopagan.org/sf-news/rdf.php')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (22, 'SisterMachineGun', 'http://www.smg.org/index/mynetscape.html')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (23, 'LinuxM68k', 'http://www.linux-m68k.org/linux-m68k.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (24, 'Protest.net', 'http://www.protest.net/netcenter_rdf.cgi')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (25, 'HollywoodBitchslap', 'http://hollywoodbitchslap.com/hbs.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (26, 'DrDobbsTechNetCast', 'http://www.technetcast.com/tnc_headlines.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (27, 'RivaExtreme', 'http://rivaextreme.com/ssi/rivaextreme.rdf.cdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (28, 'Linuxpower', 'http://linuxpower.org/linuxpower.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (29, 'PBSOnline', 'http://cgi.pbs.org/cgi-registry/featuresrdf.pl')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (30, 'Listology', 'http://listology.com/recent.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (31, 'Linuxdev.net', 'http://linuxdev.net/archive/news.cdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (32, 'LinuxNewbie', 'http://www.linuxnewbie.org/news.cdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (33, 'exoScience', 'http://www.exosci.com/exosci.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (34, 'Technocrat', 'http://technocrat.net/rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (35, 'PDABuzz', 'http://www.pdabuzz.com/netscape.txt')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (36, 'MicroUnices', 'http://mu.current.nu/mu.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (37, 'TheNextLevel', 'http://www.the-nextlevel.com/rdf/tnl.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (38, 'Gnotices', 'http://news.gnome.org/gnome-news/rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (39, 'DailyDaemonNews', 'http://daily.daemonnews.org/ddn.rdf.php3')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (40, 'PerlMonks', 'http://www.perlmonks.org/headlines.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (41, 'PerlNews', 'http://news.perl.org/perl-news-short.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (42, 'BSDToday', 'http://www.bsdtoday.com/backend/bt.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (43, 'DotKDE', 'http://dot.kde.org/rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (44, 'GeekNik', 'http://www.geeknik.net/backend/weblog.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (45, 'HotWired', 'http://www.hotwired.com/webmonkey/meta/headlines.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (46, 'JustLinux', 'http://www.justlinux.com/backend/features.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (47, 'LAN-Systems', 'http://www.lansystems.com/backend/gazette_news_backend.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (48, 'DigitalTheatre', 'http://www.dtheatre.com/backend.php3?xml=yes')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (49, 'Linux.nu', 'http://www.linux.nu/backend/lnu.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (50, 'Lin-x-pert', 'http://www.lin-x-pert.com/linxpert_apps.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (51, 'MaximumBSD1', 'http://www.maximumbsd.com/backend/weblog.rdf1')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (52, 'SolarisCentral', 'http://www.SolarisCentral.org/news/SolarisCentral.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (53, 'Slashdot', 'http://slashdot.org/slashdot.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (54, 'Linux.com', 'http://linux.com/linuxcom.rss')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (55, 'WebReference','http://webreference.com/webreference.rdf')", $dbi);
sql_query("INSERT INTO ".$prefix."_headlines VALUES (56, 'FreeDOS','http://www.freedos.org/channels/rss.cgi')", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_journal (
  jid int(11) NOT NULL auto_increment,
  aid varchar(30) NOT NULL default '',
  title varchar(80) default NULL,
  bodytext text NOT NULL,
  mood varchar(48) NOT NULL default '',
  pdate varchar(48) NOT NULL default '',
  ptime varchar(48) NOT NULL default '',
  status varchar(48) NOT NULL default '',
  mtime varchar(48) NOT NULL default '',
  mdate varchar(48) NOT NULL default '',
  PRIMARY KEY  (jid),
  KEY jid (jid),
  KEY aid (aid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_journal_comments (
  cid int(11) NOT NULL auto_increment,
  rid varchar(48) NOT NULL default '',
  aid varchar(30) NOT NULL default '',
  comment text NOT NULL,
  pdate varchar(48) NOT NULL default '',
  ptime varchar(48) NOT NULL default '',
  PRIMARY KEY  (cid),
  KEY cid (cid),
  KEY rid (rid),
  KEY aid (aid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_journal_stats (
  id int(11) NOT NULL auto_increment,
  joid varchar(48) NOT NULL default '',
  nop varchar(48) NOT NULL default '',
  ldp varchar(24) NOT NULL default '',
  ltp varchar(24) NOT NULL default '',
  micro varchar(128) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY id (id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_links_categories (
  cid int(11) NOT NULL auto_increment,
  title varchar(50) NOT NULL default '',
  cdescription text NOT NULL,
  parentid int(11) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY cid (cid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_links_editorials (
  linkid int(11) NOT NULL default '0',
  adminid varchar(60) NOT NULL default '',
  editorialtimestamp datetime NOT NULL default '0000-00-00 00:00:00',
  editorialtext text NOT NULL,
  editorialtitle varchar(100) NOT NULL default '',
  PRIMARY KEY  (linkid),
  KEY linkid (linkid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_links_links (
  lid int(11) NOT NULL auto_increment,
  cid int(11) NOT NULL default '0',
  sid int(11) NOT NULL default '0',
  title varchar(100) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  description text NOT NULL,
  date datetime default NULL,
  name varchar(100) NOT NULL default '',
  email varchar(100) NOT NULL default '',
  hits int(11) NOT NULL default '0',
  submitter varchar(60) NOT NULL default '',
  linkratingsummary double(6,4) NOT NULL default '0.0000',
  totalvotes int(11) NOT NULL default '0',
  totalcomments int(11) NOT NULL default '0',
  PRIMARY KEY  (lid),
  KEY lid (lid),
  KEY cid (cid),
  KEY sid (sid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_links_modrequest (
  requestid int(11) NOT NULL auto_increment,
  lid int(11) NOT NULL default '0',
  cid int(11) NOT NULL default '0',
  sid int(11) NOT NULL default '0',
  title varchar(100) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  description text NOT NULL,
  modifysubmitter varchar(60) NOT NULL default '',
  brokenlink int(3) NOT NULL default '0',
  PRIMARY KEY  (requestid),
  UNIQUE KEY requestid (requestid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_links_newlink (
  lid int(11) NOT NULL auto_increment,
  cid int(11) NOT NULL default '0',
  sid int(11) NOT NULL default '0',
  title varchar(100) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  description text NOT NULL,
  name varchar(100) NOT NULL default '',
  email varchar(100) NOT NULL default '',
  submitter varchar(60) NOT NULL default '',
  PRIMARY KEY  (lid),
  KEY lid (lid),
  KEY cid (cid),
  KEY sid (sid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_links_votedata (
  ratingdbid int(11) NOT NULL auto_increment,
  ratinglid int(11) NOT NULL default '0',
  ratinguser varchar(60) NOT NULL default '',
  rating int(11) NOT NULL default '0',
  ratinghostname varchar(60) NOT NULL default '',
  ratingcomments text NOT NULL,
  ratingtimestamp datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (ratingdbid),
  KEY ratingdbid (ratingdbid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_main (
  main_module varchar(255) NOT NULL default ''
)", $dbi);

sql_query("INSERT INTO ".$prefix."_main VALUES ('News')", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_message (
  mid int(11) NOT NULL auto_increment,
  title varchar(100) NOT NULL default '',
  content text NOT NULL,
  date varchar(14) NOT NULL default '',
  expire int(7) NOT NULL default '0',
  active int(1) NOT NULL default '1',
  view int(1) NOT NULL default '1',
  mlanguage varchar(30) NOT NULL default '',
  PRIMARY KEY  (mid),
  UNIQUE KEY mid (mid)
)", $dbi);

sql_query("INSERT INTO ".$prefix."_message VALUES (1,'Welcome to PHP-Nuke!','<br>Congratulations! You have now a web portal installed!. You can edit or change this message from the <a href=\"admin.php\">Administration</a> page.\r\n<br><br>\r\n<center><b>For security reasons the best idea is to create the Super User right NOW by clicking <a href=\"admin.php\">HERE</a></b></center>\r\n<br><br>\r\nYou can also create a user for you from the same page. Please read carefully the README file, CREDITS file to see from where comes the things and remember that this is free software released under the GPL License (read COPYING file for details). Hope you enjoy this software. Please report any bug you find when one of this annoying things happens and I\'ll try to fix it for the next release.\r\n<br><br>\r\nIf you like this software and want to make a contribution you can purchase me something from my <a href=\"http://www.amazon.com/exec/obidos/wishlist/1N51JTF344VHI\">Wish List</a>, you can also donate some money to PHP-Nuke project by clicking <a href=\"https://secure.reg.net/product.asp?ID=11155\">here</a> or if you prefer you can become a PHP-Nuke\'s Club Member by clicking <a href=\"http://phpnuke.org/modules.php?name=Club\">here</a> and obtain extra goodies for your system.\r\n<br><br>\r\nPHP-Nuke is an advanced and <i>intelligent</i> content management system designed and programmed with very hard work. PHP-Nuke has the biggest user\'s community in the world for this kind of application, thousands of friendly people (users and programmers) are waiting for you to join the revolution at <a href=\"http://phpnuke.org\">http://phpnuke.org</a> where you can find thousands of modules/addons, themes, blocks, graphics, utilities and much more...\r\n<br><br>\r\nThanks for your support and for select PHP-Nuke as you web site\'s code! Hope you can can enjoy this application as much as we enjoy developing it!','993373194',0,1,1,'')", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_modules (
  mid int(10) NOT NULL auto_increment,
  title varchar(255) NOT NULL default '',
  custom_title varchar(255) NOT NULL default '',
  active int(1) NOT NULL default '0',
  view int(1) NOT NULL default '0',
  inmenu tinyint(1) NOT NULL default '1',
  PRIMARY KEY  (mid),
  KEY mid (mid),
  KEY title (title),
  KEY custom_title (custom_title)
)", $dbi);

sql_query("INSERT INTO ".$prefix."_modules VALUES (1, 'AvantGo', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (2, 'Downloads', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (3, 'Feedback', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (4, 'Journal', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (5, 'News', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (6, 'Private_Messages', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (7, 'Recommend_Us', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (8, 'Search', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (9, 'Statistics', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (10, 'Stories_Archive', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (11, 'Submit_News', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (12, 'Surveys', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (13, 'Top', 'Top 10', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (14, 'Topics', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (15, 'Web_Links', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (16, 'WebMail', '', 1, 1, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (17, 'Your_Account', '', 1, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (18, 'Addon_Sample', '', 0, 2, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (19, 'Content', '', 0, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (20, 'Encyclopedia', '', 0, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (21, 'FAQ', '', 0, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (22, 'Forums', '', 0, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (23, 'Members_List', '', 0, 1, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (24, 'Reviews', '', 0, 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_modules VALUES (25, 'Sections', '', 0, 0, 1)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_pages (
  pid int(10) NOT NULL auto_increment,
  cid int(10) NOT NULL default '0',
  title varchar(255) NOT NULL default '',
  subtitle varchar(255) NOT NULL default '',
  active int(1) NOT NULL default '0',
  page_header text NOT NULL,
  text text NOT NULL,
  page_footer text NOT NULL,
  signature text NOT NULL,
  date datetime NOT NULL default '0000-00-00 00:00:00',
  counter int(10) NOT NULL default '0',
  clanguage varchar(30) NOT NULL default '',
  PRIMARY KEY  (pid),
  KEY pid (pid),
  KEY cid (cid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_pages_categories (
  cid int(10) NOT NULL auto_increment,
  title varchar(255) NOT NULL default '',
  description text NOT NULL,
  PRIMARY KEY  (cid),
  KEY cid (cid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_poll_check (
  ip varchar(20) NOT NULL default '',
  time varchar(14) NOT NULL default '',
  pollID int(10) NOT NULL default '0'
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_poll_data (
  pollID int(11) NOT NULL default '0',
  optionText char(50) NOT NULL default '',
  optionCount int(11) NOT NULL default '0',
  voteID int(11) NOT NULL default '0'
)", $dbi);

sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, 'Ummmm, not bad', 0, 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, 'Cool', 0, 2)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, 'Terrific', 0, 3)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, 'The best one!', 0, 4)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, 'what the hell is this?', 0, 5)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, '', 0, 6)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, '', 0, 7)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, '', 0, 8)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, '', 0, 9)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, '', 0, 10)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, '', 0, 11)", $dbi);
sql_query("INSERT INTO ".$prefix."_poll_data VALUES (1, '', 0, 12)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_poll_desc (
  pollID int(11) NOT NULL auto_increment,
  pollTitle varchar(100) NOT NULL default '',
  timeStamp int(11) NOT NULL default '0',
  voters mediumint(9) NOT NULL default '0',
  planguage varchar(30) NOT NULL default '',
  artid int(10) NOT NULL default '0',
  PRIMARY KEY  (pollID),
  KEY pollID (pollID)
)", $dbi);

sql_query("INSERT INTO ".$prefix."_poll_desc VALUES (1, 'What do you think about this site?', 961405160, 0, 'english', 0)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_pollcomments (
  tid int(11) NOT NULL auto_increment,
  pid int(11) default '0',
  pollID int(11) default '0',
  date datetime default NULL,
  name varchar(60) NOT NULL default '',
  email varchar(60) default NULL,
  url varchar(60) default NULL,
  host_name varchar(60) default NULL,
  subject varchar(60) NOT NULL default '',
  comment text NOT NULL,
  score tinyint(4) NOT NULL default '0',
  reason tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (tid),
  KEY tid (tid),
  KEY pid (pid),
  KEY pollID (pollID)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_popsettings (
  id int(11) NOT NULL auto_increment,
  uid int(11) default NULL,
  account varchar(50) default NULL,
  popserver varchar(255) default NULL,
  port int(5) default NULL,
  uname varchar(100) default NULL,
  passwd varchar(20) default NULL,
  numshow int(11) default NULL,
  deletefromserver char(1) default NULL,
  refresh int(11) default NULL,
  timeout int(11) default NULL,
  PRIMARY KEY  (id),
  KEY id (id),
  KEY uid (uid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_posts (
  post_id int(10) NOT NULL auto_increment,
  image varchar(100) default NULL,
  topic_id int(10) NOT NULL default '0',
  forum_id int(10) NOT NULL default '0',
  poster_id int(10) default NULL,
  post_text text,
  post_time varchar(20) default NULL,
  poster_ip varchar(16) default NULL,
  PRIMARY KEY  (post_id),
  KEY post_id (post_id),
  KEY topic_id (topic_id),
  KEY forum_id (forum_id),
  KEY poster_id (poster_id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_posts_text (
  post_id int(10) NOT NULL default '0',
  post_text text,
  PRIMARY KEY  (post_id),
  KEY post_id (post_id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_priv_msgs (
  msg_id int(10) NOT NULL auto_increment,
  msg_image varchar(100) default NULL,
  subject varchar(100) default NULL,
  from_userid int(10) NOT NULL default '0',
  to_userid int(10) NOT NULL default '0',
  msg_time varchar(20) default NULL,
  msg_text text,
  read_msg tinyint(10) NOT NULL default '0',
  PRIMARY KEY  (msg_id),
  KEY msg_id (msg_id),
  KEY to_userid (to_userid),
  KEY from_userid (from_userid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_public_messages (
  mid int(10) NOT NULL auto_increment,
  content varchar(255) NOT NULL default '',
  date varchar(14) default NULL,
  who varchar(25) NOT NULL default '',
  PRIMARY KEY  (mid),
  KEY mid (mid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_queue (
  qid smallint(5) unsigned NOT NULL auto_increment,
  uid mediumint(9) NOT NULL default '0',
  uname varchar(40) NOT NULL default '',
  subject varchar(100) NOT NULL default '',
  story text,
  storyext text NOT NULL,
  timestamp datetime NOT NULL default '0000-00-00 00:00:00',
  topic varchar(20) NOT NULL default '',
  alanguage varchar(30) NOT NULL default '',
  PRIMARY KEY  (qid),
  KEY qid (qid),
  KEY uid (uid),
  KEY uname (uname)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_quotes (
  qid int(10) unsigned NOT NULL auto_increment,
  quote text,
  PRIMARY KEY  (qid),
  KEY qid (qid)
)", $dbi);

sql_query("INSERT INTO ".$prefix."_quotes VALUES (1, 'Nos morituri te salutamus - CBHS')", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_ranks (
  rank_id int(10) NOT NULL auto_increment,
  rank_title varchar(50) NOT NULL default '',
  rank_min int(10) NOT NULL default '0',
  rank_max int(10) NOT NULL default '0',
  rank_special int(2) default '0',
  rank_image varchar(255) default NULL,
  PRIMARY KEY  (rank_id),
  KEY rank_min (rank_min),
  KEY rank_max (rank_max)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_referer (
  rid int(11) NOT NULL auto_increment,
  url varchar(100) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY rid (rid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_related (
  rid int(11) NOT NULL auto_increment,
  tid int(11) NOT NULL default '0',
  name varchar(30) NOT NULL default '',
  url varchar(200) NOT NULL default '',
  PRIMARY KEY  (rid),
  KEY rid (rid),
  KEY tid (tid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_reviews (
  id int(10) NOT NULL auto_increment,
  date date NOT NULL default '0000-00-00',
  title varchar(150) NOT NULL default '',
  text text NOT NULL,
  reviewer varchar(20) default NULL,
  email varchar(60) default NULL,
  score int(10) NOT NULL default '0',
  cover varchar(100) NOT NULL default '',
  url varchar(100) NOT NULL default '',
  url_title varchar(50) NOT NULL default '',
  hits int(10) NOT NULL default '0',
  rlanguage varchar(30) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY id (id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_reviews_add (
  id int(10) NOT NULL auto_increment,
  date date default NULL,
  title varchar(150) NOT NULL default '',
  text text NOT NULL,
  reviewer varchar(20) NOT NULL default '',
  email varchar(60) default NULL,
  score int(10) NOT NULL default '0',
  url varchar(100) NOT NULL default '',
  url_title varchar(50) NOT NULL default '',
  rlanguage varchar(30) NOT NULL default '',
  PRIMARY KEY  (id),
  KEY id (id)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_reviews_comments (
  cid int(10) NOT NULL auto_increment,
  rid int(10) NOT NULL default '0',
  userid varchar(25) NOT NULL default '',
  date datetime default NULL,
  comments text,
  score int(10) NOT NULL default '0',
  PRIMARY KEY  (cid),
  KEY cid (cid),
  KEY rid (rid),
  KEY userid (userid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_reviews_main (
  title varchar(100) default NULL,
  description text
)", $dbi);

sql_query("INSERT INTO ".$prefix."_reviews_main VALUES ('Reviews Section Title', 'Reviews Section Long Description')", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_seccont (
  artid int(11) NOT NULL auto_increment,
  secid int(11) NOT NULL default '0',
  title text NOT NULL,
  content text NOT NULL,
  counter int(11) NOT NULL default '0',
  slanguage varchar(30) NOT NULL default '',
  PRIMARY KEY  (artid),
  KEY artid (artid),
  KEY secid (secid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_sections (
  secid int(11) NOT NULL auto_increment,
  secname varchar(40) NOT NULL default '',
  image varchar(50) NOT NULL default '',
  PRIMARY KEY  (secid),
  KEY secid (secid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_session (
  username varchar(25) NOT NULL default '',
  time varchar(14) NOT NULL default '',
  host_addr varchar(48) NOT NULL default '',
  guest int(1) NOT NULL default '0',
  KEY time (time),
  KEY guest (guest)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_smiles (
  id int(10) NOT NULL auto_increment,
  code varchar(50) default NULL,
  smile_url varchar(100) default NULL,
  emotion varchar(75) default NULL,
  active tinyint(2) default '0',
  PRIMARY KEY  (id),
  KEY id (id)
)", $dbi);

sql_query("INSERT INTO ".$prefix."_smiles VALUES (1, ':D', 'icon_biggrin.gif', 'Very Happy', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (2, ':-D', 'icon_biggrin.gif', 'Very Happy', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (3, ':grin:', 'icon_biggrin.gif', 'Very Happy', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (4, ':)', 'icon_smile.gif', 'Smile', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (5, ':-)', 'icon_smile.gif', 'Smile', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (6, ':smile:', 'icon_smile.gif', 'Smile', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (7, ':(', 'icon_frown.gif', 'Sad', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (8, ':-(', 'icon_frown.gif', 'Sad', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (9, ':sad:', 'icon_frown.gif', 'Sad', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (10, ':o', 'icon_eek.gif', 'Surprised', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (11, ':-o', 'icon_eek.gif', 'Surprised', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (12, ':eek:', 'icon_eek.gif', 'Suprised', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (13, ':-?', 'icon_confused.gif', 'Confused', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (14, ':???:', 'icon_confused.gif', 'Confused', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (15, '8)', 'icon_cool.gif', 'Cool', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (16, '8-)', 'icon_cool.gif', 'Cool', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (17, ':cool:', 'icon_cool.gif', 'Cool', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (18, ':lol:', 'icon_lol.gif', 'Laughing', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (19, ':x', 'icon_mad.gif', 'Mad', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (20, ':-x', 'icon_mad.gif', 'Mad', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (21, ':mad:', 'icon_mad.gif', 'Mad', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (22, ':P', 'icon_razz.gif', 'Razz', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (23, ':-P', 'icon_razz.gif', 'Razz', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (24, ':razz:', 'icon_razz.gif', 'Razz', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (25, ':oops:', 'icon_redface.gif', 'Embaressed', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (26, ':cry:', 'icon_cry.gif', 'Crying (very sad)', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (27, ':evil:', 'icon_evil.gif', 'Evil or Very Mad', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (28, ':roll:', 'icon_rolleyes.gif', 'Rolling Eyes', 1)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (29, ':wink:', 'icon_wink.gif', 'Wink', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (30, ';)', 'icon_wink.gif', 'Wink', 0)", $dbi);
sql_query("INSERT INTO ".$prefix."_smiles VALUES (31, ';-)', 'icon_wink.gif', 'Wink', 1)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_stats_date (
  year smallint(6) NOT NULL default '0',
  month tinyint(4) NOT NULL default '0',
  date tinyint(4) NOT NULL default '0',
  hits bigint(20) NOT NULL default '0'
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_stats_hour (
  year smallint(6) NOT NULL default '0',
  month tinyint(4) NOT NULL default '0',
  date tinyint(4) NOT NULL default '0',
  hour tinyint(4) NOT NULL default '0',
  hits int(11) NOT NULL default '0'
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_stats_month (
  year smallint(6) NOT NULL default '0',
  month tinyint(4) NOT NULL default '0',
  hits bigint(20) NOT NULL default '0'
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_stats_year (
  year smallint(6) NOT NULL default '0',
  hits bigint(20) NOT NULL default '0'
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_stories (
  sid int(11) NOT NULL auto_increment,
  catid int(11) NOT NULL default '0',
  aid varchar(30) NOT NULL default '',
  title varchar(80) default NULL,
  time datetime default NULL,
  hometext text,
  bodytext text NOT NULL,
  comments int(11) default '0',
  counter mediumint(8) unsigned default NULL,
  topic int(3) NOT NULL default '1',
  informant varchar(20) NOT NULL default '',
  notes text NOT NULL,
  ihome int(1) NOT NULL default '0',
  alanguage varchar(30) NOT NULL default '',
  acomm int(1) NOT NULL default '0',
  haspoll int(1) NOT NULL default '0',
  pollID int(10) NOT NULL default '0',
  score int(10) NOT NULL default '0',
  ratings int(10) NOT NULL default '0',
  PRIMARY KEY  (sid),
  KEY sid (sid),
  KEY catid (catid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_stories_cat (
  catid int(11) NOT NULL auto_increment,
  title varchar(20) NOT NULL default '',
  counter int(11) NOT NULL default '0',
  PRIMARY KEY  (catid),
  KEY catid (catid)
)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_topics (
  topicid int(3) NOT NULL auto_increment,
  topicname varchar(20) default NULL,
  topicimage varchar(20) default NULL,
  topictext varchar(40) default NULL,
  counter int(11) NOT NULL default '0',
  PRIMARY KEY  (topicid),
  KEY topicid (topicid)
)", $dbi);

sql_query("INSERT INTO ".$prefix."_topics VALUES (1, 'phpnuke', 'phpnuke.gif', 'PHP-Nuke', 0)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$user_prefix."_users (
  uid int(11) NOT NULL auto_increment,
  name varchar(60) NOT NULL default '',
  uname varchar(25) NOT NULL default '',
  email varchar(255) NOT NULL default '',
  femail varchar(255) NOT NULL default '',
  url varchar(255) NOT NULL default '',
  user_avatar varchar(30) default NULL,
  user_regdate varchar(20) NOT NULL default '',
  user_icq varchar(15) default NULL,
  user_occ varchar(100) default NULL,
  user_from varchar(100) default NULL,
  user_intrest varchar(150) default NULL,
  user_sig varchar(255) default NULL,
  user_viewemail tinyint(2) default NULL,
  user_theme int(3) default NULL,
  user_aim varchar(18) default NULL,
  user_yim varchar(25) default NULL,
  user_msnm varchar(25) default NULL,
  pass varchar(40) NOT NULL default '',
  storynum tinyint(4) NOT NULL default '10',
  umode varchar(10) NOT NULL default '',
  uorder tinyint(1) NOT NULL default '0',
  thold tinyint(1) NOT NULL default '0',
  noscore tinyint(1) NOT NULL default '0',
  bio tinytext NOT NULL,
  ublockon tinyint(1) NOT NULL default '0',
  ublock tinytext NOT NULL,
  theme varchar(255) NOT NULL default '',
  commentmax int(11) NOT NULL default '4096',
  counter int(11) NOT NULL default '0',
  newsletter int(1) NOT NULL default '0',
  user_posts int(10) NOT NULL default '0',
  user_attachsig int(2) NOT NULL default '0',
  user_rank int(10) NOT NULL default '0',
  user_level int(10) NOT NULL default '1',
  broadcast tinyint(1) NOT NULL default '1',
  popmeson tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (uid),
  KEY uid (uid),
  KEY uname (uname)
)", $dbi);

sql_query("INSERT INTO ".$user_prefix."_users VALUES (1, '', 'Anonymous', '', '', '', 'blank.gif', 'Nov 10, 2000', '', '', '', '', '', 0, 0, '', '', '', '', 10, '', 0, 0, 0, '', 0, '', '', 4096, 0, 0, 0, 0, 0, 1, 0, 0)", $dbi);

/////////////////////////////////////////////

sql_query("CREATE TABLE ".$prefix."_words (
  word_id int(10) NOT NULL auto_increment,
  word varchar(100) default NULL,
  replacement varchar(100) default NULL,
  PRIMARY KEY  (word_id),
  KEY word_id (word_id)
)", $dbi);

sql_query("CREATE TABLE c_cat (
  catid int(3) NOT NULL auto_increment,
  catname varchar(14) NOT NULL default '',
  PRIMARY KEY  (catid)
)", $dbi);

sql_query("INSERT INTO c_cat VALUES (1, 'Ю')",$dbi);
sql_query("INSERT INTO c_cat VALUES (2, 'Dw')",$dbi);

sql_query("CREATE TABLE culog (
  cuid int(3) NOT NULL auto_increment,
  fname varchar(40) default NULL,
  fdesc varchar(80) default NULL,
  ufrom varchar(10) default NULL,
  udate date NOT NULL default '0000-00-00',
  cid int(3) NOT NULL default '0',
  uid int(3) NOT NULL default '0',
  allow int(1) NOT NULL default '0',
  PRIMARY KEY  (cuid)
)",$dbi);

sql_query("CREATE TABLE ks_analys_abbr_agent (
  abbr char(2) NOT NULL default '',
  original text NOT NULL
)",$dbi);


sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('AB', 'AbachoBOT')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('AG', 'AvantGo')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('AH', 'ah-ha.com crawler')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('AJ', 'Ask Jeeves')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('DA', 'Download Accelarator')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('DB', 'DBrowse')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('DT', 'DTS Agent')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('ES', 'ExactSeek Crawler')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('FF', 'FreeFind')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('FG', 'FlashGet')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('FS', 'Fluffy the spider')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('GB', 'Googlebot')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('GL', 'Galeon')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('GR', 'GetRight')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('HT', 'HTTrack')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('IA', 'ia_archiver')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('IE', 'Internet Explorer')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('IS', 'InternetSeer.com')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('JV', 'Java')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('KQ', 'Konqueror')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('LS', 'Lycos_Spider')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('LY', 'Lynx')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('MO', 'Mozilla')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('MR', 'Mercator')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('NS', 'Netscape')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('OB', 'Openbot')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('OP', 'Opera')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('SC', 'Scooter')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('SE', 'Spider')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('SL', 'Slurp')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('SS', 'SlySearch')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('UK', 'UnKnown')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('WC', 'WebCrawler')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('WD', 'Web Downloader')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('WG', 'Wget')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('WR', 'WebReaper')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('WS', 'WebStripper')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_agent VALUES ('ZB', 'ZyBorg')",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `ks_analys_abbr_os`
#

sql_query("CREATE TABLE ks_analys_abbr_os (
  abbr char(3) NOT NULL default '',
  original text NOT NULL,
  UNIQUE KEY abbr (abbr)
)",$dbi);

#
# CXHUƮwƾڡG `ks_analys_abbr_os`
#

sql_query("INSERT INTO ks_analys_abbr_os VALUES ('Lin', 'Linux ')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_os VALUES ('MPC', 'Mac PowerPC ')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_os VALUES ('SE', 'Spider')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_os VALUES ('UNX', 'Unix ')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_os VALUES ('W20', 'Windows 2000 ')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_os VALUES ('W52', 'Windows NT5.2')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_os VALUES ('W95', 'Windows 95 ')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_os VALUES ('W98', 'Windows 98 ')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_os VALUES ('WME', 'Windows ME ')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_os VALUES ('WNT', 'Windows NT ')",$dbi);
sql_query("INSERT INTO ks_analys_abbr_os VALUES ('WXP', 'Windows XP ')",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `ks_analys_block_config`
#

sql_query("CREATE TABLE ks_analys_block_config (
  bid tinyint(4) NOT NULL auto_increment,
  name tinytext NOT NULL,
  daily int(2) unsigned NOT NULL default '10',
  monthly int(2) unsigned NOT NULL default '10',
  annual int(2) unsigned NOT NULL default '10',
  full int(2) unsigned NOT NULL default '10',
  weight int(2) unsigned NOT NULL default '0',
  type tinyint(2) NOT NULL default '0',
  KEY bid (bid)
)",$dbi);

#
# CXHUƮwƾڡG `ks_analys_block_config`
#

sql_query("INSERT INTO ks_analys_block_config VALUES (1, 'os', 10, 10, 10, 10, 1, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (2, 'browser', 10, 10, 10, 10, 2, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (3, 'colordepth', 10, 10, 10, 10, 3, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (4, 'hostcountry', 10, 10, 10, 10, 4, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (5, 'module', 10, 10, 10, 10, 5, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (6, 'nonhuman', 10, 10, 10, 10, 6, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (7, 'referer', 10, 10, 10, 10, 7, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (8, 'referercountry', 10, 10, 10, 10, 8, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (9, 'resolution', 10, 10, 10, 10, 9, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (10, 'searchquery', 10, 10, 10, 10, 10, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (11, 'username', 10, 10, 10, 10, 11, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (12, 'visitorhost', 10, 10, 10, 10, 12, 0)",$dbi);
sql_query("INSERT INTO ks_analys_block_config VALUES (13, 'hour', 10, 10, 10, 10, 13, 1)",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `ks_analys_domain_code`
#

sql_query("CREATE TABLE ks_analys_domain_code (
  code varchar(4) NOT NULL default '',
  country text NOT NULL
)",$dbi);

#
# CXHUƮwƾڡG `ks_analys_domain_code`
#

sql_query("INSERT INTO ks_analys_domain_code VALUES ('ac', 'Ascension Island')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ad', 'Andorra')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ae', 'United Arab Emirates')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('af', 'Afghanistan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ag', 'Antigua and Barbuda')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ai', 'Anguilla')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('al', 'Albania')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('am', 'Armenia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('an', 'Netherlands Antilles')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ao', 'Angola')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('aq', 'Antarctica')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ar', 'Argentina')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('as', 'American Samoa')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('at', 'Austria')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('au', 'Australia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('aw', 'Aruba')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('az', 'Azerbaijan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ba', 'Bosnia and Herzegovina')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bb', 'Barbados')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bd', 'Bangladesh')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('be', 'Belgium')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bf', 'Burkina Faso')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bg', 'Bulgaria')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bh', 'Bahrain')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bi', 'Burundi')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bj', 'Benin')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bm', 'Bermuda')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bn', 'Brunei Darussalam')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bo', 'Bolivia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('br', 'Brasil')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bs', 'Bahamas')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bt', 'Bhutan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bv', 'Bouvet Island')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bw', 'Botswana')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('by', 'Belarus')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('bz', 'Belize')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ca', 'Canada')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cc', 'Cocos (Keeling) Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cd', 'The Democratic Republic of the Congo')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cf', 'Central African Republic')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cg', 'Congo')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ch', 'Switzerland')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ci', 'Cote d\'Ivoire')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ck', 'Cook Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cl', 'Chile')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cm', 'Cameroon')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cn', 'The People\'s Republic of China')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('co', 'Colombia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cr', 'Costa Rica')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cu', 'Cuba')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cv', 'Cape Verde')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cx', 'Christmas Island')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cy', 'Cyprus')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('cz', 'Czech Republic')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('de', 'Germany')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('dj', 'Djibouti')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('dk', 'Denmark')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('dm', 'Dominica')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('do', 'Dominican Republic')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('dz', 'Algeria')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ec', 'Ecuador')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ee', 'Estonia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('eg', 'Egypt')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('eh', 'Western Sahara')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('er', 'Eritrea')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('es', 'Spain')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('et', 'Ethiopia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('fi', 'Finland')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('fj', 'Fiji')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('fk', 'Falkland Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('fm', 'Federated States of Micronesia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('fo', 'Faroe Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('fr', 'France')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('fx', 'France, Metropolitan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ga', 'Gabon')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gb', 'Great Britain')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gd', 'Grenada')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ge', 'Georgia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gf', 'French Guiana')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gg', 'Guernsey')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gh', 'Ghana')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gi', 'Gibraltar')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gl', 'Greenland')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gm', 'Gambia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gn', 'Guinea')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gp', 'Guadeloupe ')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gq', 'Equatorial Guinea')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gr', 'Greece')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gs', 'South Georgia and the South Sandwich Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gt', 'Guatemala')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gu', 'Guam')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gw', 'Guinea-Bissau')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('gy', 'Guyana')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('hk', 'Hong Kong')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('hm', 'Heard and Mc Donald Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('hn', 'Honduras')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('hr', 'Croatia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ht', 'Haiti')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('hu', 'Hungary')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('id', 'Indonesia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ie', 'Ireland')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('il', 'Israel')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('im', 'Isle of Man')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('in', 'India')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('io', 'British Indian Ocean Territory')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('iq', 'Iraq')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ir', 'Iran')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('is', 'Iceland')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('it', 'Italy')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('je', 'Jersey ')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('jm', 'Jamaica  ')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('jo', 'Jordan ')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('jp', 'Japan  ')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ke', 'Kenya  ')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('kg', 'Kyrgyzstan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('kh', 'Cambodia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ki', 'Kiribati')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('km', 'Comoros')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('kn', 'Saint Kitts and Nevis')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('kp', 'The Democratic People\'s Republic of Korea')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('kr', 'The Republic of Korea')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('kw', 'Kuwait')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ky', 'Cayman Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('kz', 'Kazakhstan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('la', 'Lao People\'s Democratic Republic')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('lb', 'Lebanon')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('lc', 'Saint Lucia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('li', 'Liechtenstein')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('lk', 'Sri Lanka')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('lr', 'Liberia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ls', 'Lesotho')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('lt', 'Lithuania')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('lu', 'Luxembourg')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('lv', 'Latvia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ly', 'Libya')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ma', 'Morocco')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mc', 'Monaco')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('md', 'The Republic of Moldova')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mg', 'Madagascar')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mh', 'Marshall Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mk', 'The Former Yugoslav Republic of Macedonia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ml', 'Mali')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mm', 'Myanmar')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mn', 'Mongolia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mo', 'Macau')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mp', 'Northern Mariana Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mq', 'Martinique')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mr', 'Mauritania')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ms', 'Montserrat')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mt', 'Malta')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mu', 'Mauritius')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mv', 'Maldives')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mw', 'Malawi')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mx', 'Mexico')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('my', 'Malaysia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('mz', 'Mozambique')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('na', 'Namibia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('nc', 'New Caledonia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ne', 'Niger')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('nf', 'Norfolk Island')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ng', 'Nigeria')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ni', 'Nicaragua')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('nl', 'Netherlands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('no', 'Norway')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('np', 'Nepal')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('nr', 'Nauru')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('nt', 'Neutral Zone')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('nu', 'Niue')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('nz', 'New Zealand')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('om', 'Oman')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pa', 'Panama')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pe', 'Peru')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pf', 'French Polynesia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pg', 'Papua New Guinea')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ph', 'Philippines')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pk', 'Pakistan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pl', 'Poland')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pm', 'St. Pierre and Miquelon')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pn', 'Pitcairn Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pr', 'Puerto Rico')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pt', 'Portugal')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('pw', 'Palau')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('py', 'Paraguay')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('qa', 'Qatar')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('re', 'Reunion')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ro', 'Romania')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ru', 'Russian Federation')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('rw', 'Rwanda')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sa', 'Saudi Arabia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sb', 'Solomon Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sc', 'Seychelles')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sd', 'Sudan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('se', 'Sweden')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sg', 'Singapore')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sh', 'St. Helena')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('si', 'Slowenia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sj', 'Svalbard and Jan Mayen Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sk', 'Slovakia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sl', 'Sierra Leone')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sm', 'San Marino')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sn', 'Senegal')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('so', 'Somalia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sr', 'Suriname')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('st', 'Sao Tome and Principe')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('su', 'Soviet Union, Former')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sv', 'El Salvador')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sy', 'Syria')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('sz', 'Swaziland')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tc', 'Turks and Caicos Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('td', 'Chad')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tf', 'French Southern Territories')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tg', 'Togo')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('th', 'Thailand')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tj', 'Tajikistan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tk', 'Tokelau')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tm', 'Turkmenistan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tn', 'Tunisia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('to', 'Tonga')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tp', 'Former Portuguese Colony of East Timor')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tr', 'Turkey')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tt', 'Trinidad and Tobago')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tv', 'Tuvalu')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tw', 'Taiwan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('tz', 'United Republic of Tanzania')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ua', 'Ukraine')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ug', 'Uganda')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('uk', 'United Kingdom')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('um', 'U.S. Minor Outlying Island')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('us', 'United States of America')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('uy', 'Uruguay')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('uz', 'Uzbekistan')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('va', 'The Holy See')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('vc', 'Saint Vincent and the Grenadines')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ve', 'Venezuela')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('vg', 'British Virgin Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('vi', 'U.S. Virgin Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('vn', 'Viet Nam')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('vu', 'Vanuatu')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('wf', 'Wallis and Futuna Islands')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ws', 'Samoa')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('ye', 'Yemen')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('yt', 'Mayotte')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('yu', 'Yugoslavia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('za', 'South Africa')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('zm', 'Zambia')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('zr', 'Zaire, Former')",$dbi);
sql_query("INSERT INTO ks_analys_domain_code VALUES ('zw', 'Zimbabwe')",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `ks_analys_module`
#

sql_query("CREATE TABLE ks_analys_module (
  id int(8) unsigned NOT NULL auto_increment,
  ip varchar(15) NOT NULL default '',
  date datetime NOT NULL default '0000-00-00 00:00:00',
  name tinytext NOT NULL,
  KEY id (id)
)",$dbi);

#
# CXHUƮwƾڡG `ks_analys_module`
#

# --------------------------------------------------------

#
# ƪ榡G `ks_analys_user`
#

sql_query("CREATE TABLE ks_analys_user (
  id smallint(5) unsigned NOT NULL auto_increment,
  date datetime NOT NULL default '0000-00-00 00:00:00',
  name text NOT NULL,
  KEY id (id)
)",$dbi);

#
# CXHUƮwƾڡG `ks_analys_user`
#

# --------------------------------------------------------

#
# ƪ榡G `ks_analys_visitor`
#

sql_query("CREATE TABLE ks_analys_visitor (
  id int(10) unsigned NOT NULL auto_increment,
  date datetime NOT NULL default '0000-00-00 00:00:00',
  ip varchar(15) NOT NULL default '',
  host tinytext,
  agent char(2) default NULL,
  version tinytext,
  os char(3) default NULL,
  referer tinytext,
  query tinytext,
  resolution tinytext,
  color_depth tinyint(1) unsigned default NULL,
  KEY id (id)
)",$dbi);

#
# CXHUƮwƾڡG `ks_analys_visitor`
#

# --------------------------------------------------------

#
# ƪ榡G `mod3_config`
#

sql_query("CREATE TABLE mod3_config (
  mid int(10) NOT NULL auto_increment,
  adminid int(11) default NULL,
  KEY mid (mid)
)",$dbi);

#
# CXHUƮwƾڡG `mod3_config`
#

# --------------------------------------------------------

#
# ƪ榡G `mod3_member`
#

sql_query("CREATE TABLE mod3_member (
  memid int(5) NOT NULL auto_increment,
  memname varchar(60) default NULL,
  catid int(5) default NULL,
  jobtitle varchar(60) default NULL,
  email varchar(255) default NULL,
  telphone varchar(120) default NULL,
  description varchar(255) default NULL,
  photo varchar(60) default NULL,
  KEY memid (memid)
)",$dbi);

#
# CXHUƮwƾڡG `mod3_member`
#

# --------------------------------------------------------

#
# ƪ榡G `mod3_membercategories`
#

sql_query("CREATE TABLE mod3_membercategories (
  catid int(5) NOT NULL auto_increment,
  catname varchar(60) default NULL,
  KEY catid (catid)
)",$dbi);

#
# CXHUƮwƾڡG `mod3_membercategories`
#

sql_query("INSERT INTO mod3_membercategories VALUES (1, 'ժ')",$dbi);
sql_query("INSERT INTO mod3_membercategories VALUES (2, 'аȳB')",$dbi);
sql_query("INSERT INTO mod3_membercategories VALUES (3, 'VɳB')",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `mod3_software`
#

sql_query("CREATE TABLE mod3_software (
  swid int(10) NOT NULL auto_increment,
  swname varchar(60) default NULL,
  version varchar(10) default NULL,
  disk int(6) default NULL,
  cd int(10) default NULL,
  os varchar(60) default NULL,
  manual int(6) default NULL,
  set_count varchar(5) default NULL,
  get_date datetime default NULL,
  serial_no varchar(255) default NULL,
  place varchar(50) default NULL,
  memo varchar(100) default NULL,
  KEY swid (swid)
)",$dbi);

sql_query("CREATE TABLE ".$prefix."_boombox (
  songID int(11) NOT NULL auto_increment,
  artist varchar(255) NOT NULL default '',
  title varchar(255) NOT NULL default '',
  notes text NOT NULL,
  songUrl varchar(255) NOT NULL default '',
  timeStamp datetime NOT NULL default '0000-00-00 00:00:00',
  hits int(11) NOT NULL default '0',
  downloadedBy text NOT NULL,
  PRIMARY KEY  (songID)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_boombox`
#

sql_query("INSERT INTO ".$prefix."_boombox VALUES (1, 'Faze', 'Mad Flava', 'This is just a demo entry. Go to the Boombox administration and edit or delete this entry.', 'http://www.knology.net/~sminer15/faze/Faze_-_Mad_Flava.mp3', '2002-05-14 12:00:00', 0, '')",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `nuke_catagories`
#

sql_query("CREATE TABLE ".$prefix."_catagories (
  cat_id int(10) NOT NULL auto_increment,
  cat_title varchar(100) default NULL,
  cat_order varchar(10) default NULL,
  PRIMARY KEY  (cat_id),
  KEY cat_id (cat_id)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_catagories`
#

# --------------------------------------------------------

#
# ƪ榡G `nuke_chatmessage`
#

sql_query("CREATE TABLE ".$prefix."_chatmessage (
  time int(11) default NULL,
  rid int(11) default NULL,
  send_id int(11) default NULL,
  rcpt_id int(11) default NULL,
  cmd varchar(50) default NULL,
  message text
)",$dbi);

#
# CXHUƮwƾڡG `nuke_chatmessage`
#

# --------------------------------------------------------

#
# ƪ榡G `nuke_chatroom`
#

sql_query("CREATE TABLE ".$prefix."_chatroom (
  rid int(11) NOT NULL auto_increment,
  name varchar(20) default NULL,
  descript varchar(255) default NULL,
  typ char(1) default NULL,
  pass varchar(64) default NULL,
  orig tinyint(1) default NULL,
  PRIMARY KEY  (rid)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_chatroom`
#

sql_query("INSERT INTO ".$prefix."_chatroom VALUES (1, 'General', 'General chat room', 'N', '', 1)",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `nuke_chatsmile`
#

sql_query("CREATE TABLE ".$prefix."_chatsmile (
  sid int(11) NOT NULL auto_increment,
  code varchar(12) default NULL,
  file varchar(50) default NULL,
  emotion varchar(50) default NULL,
  showit tinyint(1) default '0',
  PRIMARY KEY  (sid)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_chatsmile`
#

sql_query("INSERT INTO ".$prefix."_chatsmile VALUES (1, ':)', 'smile.gif', 'Smile', 1)",$dbi);
sql_query("INSERT INTO ".$prefix."_chatsmile VALUES (2, ':(', 'sad.gif', 'Sad', 1)",$dbi);
sql_query("INSERT INTO ".$prefix."_chatsmile VALUES (3, ';)', 'wink.gif', 'Wink', 1)",$dbi);
sql_query("INSERT INTO ".$prefix."_chatsmile VALUES (4, ':D', 'biggrin.gif', 'Big grin', 1)",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `nuke_chatsound`
#

sql_query("CREATE TABLE ".$prefix."_chatsound (
  sid int(11) NOT NULL auto_increment,
  cmd varchar(50) default NULL,
  file varchar(50) default NULL,
  saytext varchar(50) default NULL,
  PRIMARY KEY  (sid)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_chatsound`
#

sql_query("INSERT INTO ".$prefix."_chatsound VALUES (1, 'hey', 'hey.wav', 'saying hey')",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `nuke_chatuser`
#

sql_query("CREATE TABLE ".$prefix."_chatuser (
  uid int(11) NOT NULL default '0',
  name varchar(20) default NULL,
  last int(11) default NULL,
  rid int(11) default NULL,
  ip varchar(16) default NULL,
  PRIMARY KEY  (uid)
)",$dbi);


sql_query("CREATE TABLE ".$prefix."_docs (
  mid int(10) NOT NULL auto_increment,
  title varchar(255) NOT NULL default '',
  custom_title varchar(255) NOT NULL default '',
  active int(1) NOT NULL default '0',
  view int(1) NOT NULL default '0',
  description text,
  KEY mid (mid)
)",$dbi);


sql_query("CREATE TABLE ".$prefix."_ecal (
  id int(11) NOT NULL auto_increment,
  username varchar(255) default NULL,
  stamp datetime default NULL,
  subject varchar(255) default NULL,
  description blob,
  PRIMARY KEY  (id)
)",$dbi);

#

# --------------------------------------------------------

#
# ƪ榡G `nuke_events`
#

sql_query("CREATE TABLE ".$prefix."_events (
  eid bigint(20) NOT NULL auto_increment,
  aid varchar(30) NOT NULL default '',
  title varchar(150) default NULL,
  time datetime default NULL,
  hometext blob,
  comments int(11) default '0',
  counter mediumint(8) unsigned default NULL,
  topic int(3) NOT NULL default '1',
  informant varchar(20) NOT NULL default '',
  eventDate date NOT NULL default '0000-00-00',
  endDate date NOT NULL default '0000-00-00',
  startTime time default NULL,
  endTime time default NULL,
  alldayevent int(1) NOT NULL default '0',
  barcolor char(1) default NULL,
  PRIMARY KEY  (eid)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_events`
#

# --------------------------------------------------------

#
# ƪ榡G `nuke_events_queue`
#

sql_query("CREATE TABLE ".$prefix."_events_queue (
  qid bigint(20) NOT NULL auto_increment,
  uid mediumint(9) NOT NULL default '0',
  uname varchar(40) NOT NULL default '',
  title varchar(150) NOT NULL default '',
  story blob,
  timestamp datetime NOT NULL default '0000-00-00 00:00:00',
  topic varchar(20) NOT NULL default '',
  eventDate date NOT NULL default '0000-00-00',
  endDate date NOT NULL default '0000-00-00',
  startTime time default NULL,
  endTime time default NULL,
  alldayevent int(1) NOT NULL default '0',
  barcolor char(1) default NULL,
  PRIMARY KEY  (qid)
)",$dbi);

sql_query("CREATE TABLE ".$prefix."_maillist (
  mlid int(3) NOT NULL auto_increment,
  mlsubject varchar(128) NOT NULL default '',
  mldate varchar(10) NOT NULL default '',
  mlnums int(5) NOT NULL default '0',
  PRIMARY KEY  (mlid)
)",$dbi);

#
# ƪ榡G `nuke_memo`
#

sql_query("CREATE TABLE ".$prefix."_memo (
  mid int(11) NOT NULL auto_increment,
  username varchar(60) NOT NULL default '',
  date datetime NOT NULL default '0000-00-00 00:00:00',
  content text NOT NULL,
  PRIMARY KEY  (mid)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_memo`
#

# --------------------------------------------------------

#
# ƪ榡G `nuke_memoauthors`
#

sql_query("CREATE TABLE ".$prefix."_memoauthors (
  id int(4) NOT NULL auto_increment,
  username varchar(60) NOT NULL default '',
  PRIMARY KEY  (id)
)",$dbi);

#
# ƪ榡G `nuke_mod3`
#

sql_query("CREATE TABLE ".$prefix."_mod3 (
  mid int(10) NOT NULL auto_increment,
  title varchar(255) NOT NULL default '',
  custom_title varchar(255) NOT NULL default '',
  active int(1) NOT NULL default '0',
  view int(1) NOT NULL default '0',
  KEY mid (mid)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_mod3`
#

sql_query("INSERT INTO ".$prefix."_mod3 VALUES (1, 'Banner', '', 0, 0)",$dbi);
sql_query("INSERT INTO ".$prefix."_mod3 VALUES (2, 'Members', '', 0, 0)",$dbi);
sql_query("INSERT INTO ".$prefix."_mod3 VALUES (3, 'Online_Mailer', '', 0, 0)",$dbi);
sql_query("INSERT INTO ".$prefix."_mod3 VALUES (4, 'Software', '', 0, 0)",$dbi);
sql_query("INSERT INTO ".$prefix."_mod3 VALUES (5, 'eCal', '', 0, 0)",$dbi);
# --------------------------------------------------------


sql_query("CREATE TABLE ".$prefix."_quiz_admin (
  quizID int(11) NOT NULL auto_increment,
  quizTitle varchar(150) NOT NULL default '',
  timeStamp int(11) NOT NULL default '0',
  voters mediumint(9) NOT NULL default '0',
  nbscore tinyint(9) NOT NULL default '10',
  displayscore tinyint(1) NOT NULL default '0',
  displayresults tinyint(1) NOT NULL default '0',
  emailadmin tinyint(1) NOT NULL default '1',
  comment text,
  active tinyint(1) NOT NULL default '1',
  restrict_user tinyint(1) NOT NULL default '1',
  log_user tinyint(1) NOT NULL default '1',
  image varchar(50) default NULL,
  cid int(11) NOT NULL default '1',
  contrib tinyint(1) NOT NULL default '1',
  expire varchar(16) NOT NULL default 'xx-xx-xxxx xx:xx',
  admemail varchar(50) default NULL,
  administrator varchar(50) default NULL,
  conditions text,
  PRIMARY KEY  (quizID),
  KEY quizzID (quizID)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_quiz_admin`
#

sql_query("INSERT INTO ".$prefix."_quiz_admin VALUES (1, 'Nuke Quiz', 1015720245, 0, 0, 1, 1, 0, '', 1, 0, 0, '', 1, 0, 'xxxx-xx-xx xx:xx', '', '', '')",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `nuke_quiz_categories`
#

sql_query("CREATE TABLE ".$prefix."_quiz_categories (
  cid int(9) NOT NULL auto_increment,
  name varchar(50) NOT NULL default '',
  comment varchar(255) default NULL,
  image varchar(50) default NULL,
  PRIMARY KEY  (cid)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_quiz_categories`
#

sql_query("INSERT INTO ".$prefix."_quiz_categories VALUES (1, 'Nuke Quiz', 'Nuke Quiz by NyQuist', '')",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `nuke_quiz_check`
#

sql_query("CREATE TABLE ".$prefix."_quiz_check (
  ip varchar(20) default NULL,
  time varchar(14) NOT NULL default '',
  username varchar(50) default NULL,
  email varchar(50) default NULL,
  qid int(11) NOT NULL default '0',
  score tinyint(2) NOT NULL default '0',
  answers varchar(255) NOT NULL default '',
  KEY qid (qid)
)",$dbi);

#
# CXHUƮwƾڡG `nuke_quiz_check`
#

sql_query("INSERT INTO ".$prefix."_quiz_check VALUES (NULL, '1015720390', 'NyQuist', 'NyQuist@ntlworld.com', 1, 100, '1|')",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `nuke_quiz_data`
#

sql_query("CREATE TABLE ".$prefix."_quiz_data (
  pollID int(11) NOT NULL default '0',
  optionText char(150) NOT NULL default '',
  optionCount int(11) NOT NULL default '0',
  voteID int(11) NOT NULL default '0'
)",$dbi);

#
# CXHUƮwƾڡG `nuke_quiz_data`
#

sql_query("INSERT INTO ".$prefix."_quiz_data VALUES (1, 'The best php nuke module ever!', 1, 1)",$dbi);
sql_query("INSERT INTO ".$prefix."_quiz_data VALUES (1, 'Brilliant', 0, 2)",$dbi);
sql_query("INSERT INTO ".$prefix."_quiz_data VALUES (1, 'Good', 0, 3)",$dbi);
sql_query("INSERT INTO ".$prefix."_quiz_data VALUES (1, 'Ok', 0, 4)",$dbi);
sql_query("INSERT INTO ".$prefix."_quiz_data VALUES (1, 'Not too bad', 0, 5)",$dbi);
sql_query("INSERT INTO ".$prefix."_quiz_data VALUES (1, 'Buggy, to say the least', 0, 6)",$dbi);
sql_query("INSERT INTO ".$prefix."_quiz_data VALUES (1, 'A piece of crap', 0, 7)",$dbi);
sql_query("INSERT INTO ".$prefix."_quiz_data VALUES (1, '', 0, 8)",$dbi);
sql_query("INSERT INTO ".$prefix."_quiz_data VALUES (1, '', 0, 9)",$dbi);
sql_query("INSERT INTO ".$prefix."_quiz_data VALUES (1, '', 0, 10)",$dbi);
# --------------------------------------------------------

#
# ƪ榡G `nuke_quiz_desc`
#

sql_query("CREATE TABLE ".$prefix."_quiz_desc (
  pollID int(11) NOT NULL auto_increment,
  pollTitle blob NOT NULL,
  timeStamp int(11) NOT NULL default '0',
  voters mediumint(9) NOT NULL default '0',
  qid tinyint(9) NOT NULL default '0',
  answer varchar(30) NOT NULL default '0',
  coef tinyint(3) NOT NULL default '1',
  good text,
  bad text,
  comment text,
  image varchar(255) default NULL,
  PRIMARY KEY  (pollID)
)",$dbi);

sql_query("INSERT INTO ".$prefix."_quiz_desc VALUES (1, 'Nuke Quiz is:', 1015720361, 1, 1, '1,,,,,,,,,,', 1, 'Wow, you do know me well :)', 'No, no, wrong answer.', 'Do ya feel lucky, well do ya, punk?', '')",$dbi);
sql_query("CREATE TABLE ".$prefix."_quotes (
  qid int(10) unsigned NOT NULL auto_increment,
  quote text,
  PRIMARY KEY  (qid),
  KEY qid (qid)
)",$dbi);

sql_query("INSERT INTO ".$prefix."_quotes VALUES (10, 'ZLdU')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (11, 'ӴNxbAp󵽥β{b')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (12, '`hP,]Nાּ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (13, 'OqӦ۩ߴB')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (14, 'ߴӦ۩Ѫֿn')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (15, 'nܤ@yTVxAcyˤHH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (16, 'ѬOBsڬp')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (17, 'WơAۤצ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (18, 'nܤ@yTVxAcyˤHH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (19, '}иUAp@ަb')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (20, 'HL{A~')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (21, 'Ūn,nH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (22, 'b,WxH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (23, 'RH]QRNOsb̤jּ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (24, 'd[ϤHnzA[aӤOqI')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (26, 'ּ,OɨIXL{PG')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (28, 'eiAᨮ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (29, 'ĳLALlӭ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (30, 'CӤHOû|ܪ;FU@ӤHV,ڭ̥묹ۤv.')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (31, 'Xj欰H,o|QҦHw')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (32, 'pGڭ̪Ʊuoӥ@,hڭ̱NOҦ𪫪̤RB̴dG.')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (33, 'g禳p_ۤ@')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (34, ',èSڭ̰eӤѨ,ӬOڭ̰eӤH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (35, 'bҦiतn̦ܳn!')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (36, 'H@ۤpۤlAۤvEX@DӡFӨƹW]ObULHA@_гyӥ@')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (37, 'pGQnOHFѧAAMLHbP@aW')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (38, 'c]̫몺NO')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (39, 'IqۤvHA]|Iqۤv߲zHۤϪIӬݤ]O@˪')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (40, 'ڭӭnǲ߯F[AFѤHäOMڭ̷Q@')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (41, 'pGb@ӰaAnHMaH֦ۦPvQAoӰaN|`')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (42, '@ibڭ̭eAMڭ̬ۦyJA䤤쩳õۤ򯵱KOH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (43, 'HHasʡA@ӤHlaFAiHѥLHӥ[H״_')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (44, 'AӨ@WOFtAӬOF@ӯuH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (45, '߱nϦۤvݰ_ӹˤlQkAӱMߤ@Nouꪺۤv')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (46, 'H@wn̿ū׭pA~P_Ѯ𪺧N')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (47, '@ӦnHAO񭼧|jv٭nij_I')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (48, 'AqӤ|Dj')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (49, 'bHQn汼ۤvaA@w|QnRLH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (50, 'BۦK@͡A񰵥XìVHߧ@~AojNa@ͧuq')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (51, 'H|ǿApGCǿӻ{~HA~OjH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (52, 'yHtOOͬ覡AӬOݧAphBήɶ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (53, '@ӤHȧP_AbLkʯhִLq[')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (54, 'nۤvZv')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (55, 'q@ɪݨ@ɪY......BOH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (56, 'ڭ̷|YFLHAO]ڭ̧ۤvͬAݧ@OzQͬAӿ{LHڥͬA]NOӤHzQ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (57, 'ʻD@p@')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (58, 'HpGHlҬɷUAhUনuH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (59, 'ڤ|@˪')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (60, 'HȻPLQ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (61, 'H@ɬOo۩󤺳')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (62, 'SvQHOԴHu@~FSqȪHhOr~')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (63, 'HäO]YoUF~ଡUhAӬO]Ƥ~ଡUh')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (64, '@ǥصLkHQF_ӡAo@ӷ|yLHAHۤvL̦nı')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (65, 'jHOİʪA]NOL̬OH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (66, 'bڭ̳Q٧@HeAǤwgڭܦ@˪F')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (67, 'HûOuꪺAiOɭԳoӯu|')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (68, 'MHAڭ̨SnFiHL')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (69, 'HpGS}@lꪺAͩRN@ť')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (70, 'HiHߺDkCA]iHߺDVO')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (71, 'GQHeHAQ⤣n@N|QH᪺HAhQӮ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (72, 'QnsHApGOgѲzʦӱo쪺HANOgLF@qܪĳסA]OLΪ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (73, 'zʰIhxԤ@ANO\\ŪZy')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (74, 'b@WKQ~_sAڦܤ־Ƿ|F@˪FANOۤvL')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (75, 'LpߴNLAݤpFɷ|NjAoݨjF')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (76, 'SOdʡANnSee@')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (77, '۲z[񴼼z󭫭n')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (78, 'Hͳ̤j֥ЧYOͬAͬYOı')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (79, 'MتUNdjDAتUNO')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (80, 'zNOGBıBġBWV')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (81, 'So˪ƱAahܡBܫhqAƭnwdhPŶ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (82, 'StHAuηR߹')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (83, 'nQkNn߱FHL]e߹ҡAɨuͬ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (84, '}Bz߬O̦nOA@ɦAáAA]|oܤj֮')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (85, 'oӥ@ɰgbAq߶BiHo쵪')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (86, 'ѤwߡAƨƦN')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (87, 'ɮɨгy|ۤvA}oAּ֪H')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (88, 'u@AOFʪŶFͬAOצ檺I')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (89, 'O̦n')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (90, 'Hn@ˡAHHR')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (91, 'Hu~YAߤ]న')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (92, 'ۤvӮɱ`kצۤvAl[FAN|hH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (93, 'ǲߩUAVmۤvn@I۳¤pƦӷдo')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (94, 'ҵڭ̪wwOuȪAqFXww~̪[')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (95, 'ͬѲNOBBU')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (96, 'uRߡvnuzv¦')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (97, ']e@ӤHAдoN֤@')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (98, '֦wA]Nsiߪ|BߤjNOnֿnw{')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (99, 'UOH}ݺ֮A]O}ݦۤv֮')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (100, 'ñH͡ANqƱOּ֪')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (101, '߶qsjA߱Nn')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (102, 'zϧڭ̪߲MbѲ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (107, 'p~RHߦ֭pB֦kQ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (104, 'bͬVmۤvqjAbu@Vmۤv')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (105, 'ε߯ѯдctAרs|nG')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (106, 'bOH߳QA~kKOH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (108, 'ҬݲšAΤߥh򥦥šAҬݦӤ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (109, 'OdOֳuAIXPhҬOֳ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (110, '浽OFۤvAOFOHA]򰵡BN򦬦')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (111, 'ͬ@֥СAC@ӽtOڭ̯ѯЪa')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (112, 'LOHANoOHLA]|Q')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (113, 'u@OWoAӬOǲ߭Yıoּ֡AN|ּ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (114, '@ӤHۡAKOHq')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (115, 'n߱NnRBAnRBӦ۷OdߡAҥHnhRߡBhߡARN|n')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (116, 'ͯfTMnvA󭫭nOO@F')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (117, 'UnoߡALұoߤ~Os')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (118, 'ǲߧԭ@AӨӪƱNӡA]۵MahAndBê')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (119, 'ڭ̱`QbƪҤzZAӳobFoabܤ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (120, 'ڭ̦pG_߰ʩbQqLHALHN|QqA')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (121, 'CƥΥ`ߡB߬ݫ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (122, 'bƤHߡAnqۤv_AvΤH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (123, 'tzuOּ̧֪')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (124, 'ηOd@֥СAHzbƥͩR')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (125, 'qͬCӱĲhıʪsb')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (126, 'ߨʴNO@غֳ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (127, 'iOD`j]١AԻOD`j֥')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (128, 'oPuOڭ̤ߤpiAߦݬ復̤~VeڶiA_huåûdbLh')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (129, 'n``ײzۤvAԭ@OHAөʴN|ĤF')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (130, '׵oͥơAoBpAۤ߹F쥭I')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (131, 'ҿץ`Ynnaaҫܥ`')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (132, 'ֵnIBLLOּ֪')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (133, 'gNOڭ̪ѮvFѮvNO믫̾aAQwɦV')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (134, 'eԫסB]eߦhjAֳNhj')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (135, 'hIXAhOHQAh')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (136, '@IXN|ıLڡA@UN|FѸѲ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (137, 'Hͮȳ~HƦA_ӰANLoBWQ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (138, 'HƬSѡHɤߺɤOӤw')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (139, 'ıZɡA~iNj')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (140, '@ؤlAiHX@jꪺJɡAҥHn]pӤ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (141, '񶶦ۤߧYn[AͻPɬҫܲM')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (142, 'N|ּ֡AıN|W')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (143, '̤jqNOSдo')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (144, 'qLҨDIXA|ͩRLqAyֵLqͩR')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (145, 'ͷPNu^@ˡAɭnPɭn')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (146, '@ưAiHUNqUAӰɭԦnnAӭתɭԦnnסAndMp')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (147, '߬.ݤ򳣶 ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (148, '.Ӧۤ@oI ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (149, 'ܭnũMX.A׭nۿˤ ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (150, 'nή.浽]nή ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (151, 'bb.񨫨ؼ.󨯭W ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (152, 'ḩOH.ho.qj.֮j ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (153, 'ߤR.~|HHR ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (154, '֤boh.Ӧbp')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (155, 'ⴤU.NOΤ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (156, 'ݤHh@B.RHe@B.bH͹DN|oܧּ ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (157, 'noOHg.NogħOH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (158, '̦Oq.NOڭ̪⸣')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (159, '_oͩR\\.~O۪H ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (160, 'ťn.npJ.ccl')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (161, 'n`OnDOHڤ.nQگରOH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (162, 'UOH.NObUۤv')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (163, 'nuݨOH~bI.oݤۤvߪU')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (164, 'ͬ®.oZZ֧.u@DĲv.o')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (165, 'HR߫ݤH.HU߯ݱ.hHͨBRFu')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (166, '_JoV.VU.@ӤHVN.VR')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (167, 'b.nKˤ.nX.i@P')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (168, 'HͯQHݭn.\\.HIX.~O̩֪H')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (169, 'YLH.NOYۤv')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (170, '\\buIo.ѬOIֿn')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (171, '\"\"hF.\"W\"h~i')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (172, 'ڭӬOHNӥwߤ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (173, 'qN.֤ߴNF.O\"֦ܤF\"')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (174, '`Ϭ٦ۤvLL.YoѲSۦb')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (175, 'ǦNOn[Ƹѷдo.MDFww')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (176, 'ߴNpw.AjxPê]į}')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (177, 'nQaxNX.n``_wߤ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (178, '@nƭnⴤɾ.]nⴤ]t')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (179, '˥hQ骺nPa.ⴤ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (180, '`.@.wߨ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (181, 'ͮOOHLg@ۤv')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (182, 'Hͦh@P.Nh@')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (183, 'Ypۧ.Xj߯.u@nw.HPHnP ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (184, 'RPP.߲bߤдo')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (185, 'nƭn˥Xɶ.oOHͪت.]OHͪq')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (186, 'ͩRuƤQ~.zROû')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (187, '@nj.ӭn.nX.߭n')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (188, 'HBƭnp.Ӥ.np߲')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (189, 'IXRߴNO.дoNOz')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (190, 'ɮɦsn.On')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (191, 'fn.ߨɦn.n')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (192, 'H.ݤO.iT̨.hѤUS')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (193, 'fnܦpR.faܦpRrD')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (194, 'Ӷj.j.glqj.pHj')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (195, 'znM.oznǤH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (196, 'Hn..Ay')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (197, 'gର.⺡Od')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (198, '믫p`.NO̩֪H')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (199, 'ܦۤvO۱.vTOHOϤH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (200, 'L.LDhOq')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (201, 'anۤv.֭nۤvy.hy.NiWLqֳ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (202, 'ROLɪ]I.I󦳺')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (203, 'QLhO.QӬOkQ.̦nⴤUɨ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (204, 'wO.ּ֬Oz')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (205, 'HߩN.pO}ԲM.hҨ.Oӵ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (206, 'ɶêߥ.}Xzᦷ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (207, '̦nyOi~.NOLP')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (208, 'nNߤ.]BaOHQ@Q')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (209, 'e.iHN.٥iHYuHڶZ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (210, ',OӦۤ@oI')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (211, 'ɷдoOӦۤXz')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (212, 'R@䪫.ֱ`')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (213, 'wߩMPOдoOq')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (214, 'nƤ֧ڤ@.aƤhڤ@')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (215, '֤boh.Ӧbp')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (216, 'yWe.ߤRH̥iR.NO')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (4, 'LߥhaBQ.ťܳOn')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (218, 'vd.uOо..ǥͥۤvh')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (219, 'ߤR.~|HHR')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (220, 'Ԥ@ɤ.Kʤ餧~')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (221, 'ܧOH.pܦۤv')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (222, '`vL.פHD.ɮw.ɮɦN')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (223, 'ťHpӤ.ťHcpӬ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (224, 'C@ѳOH}l.C@ɨ賣Oۤvĵ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (225, 'Kܦn.ܤ۵M')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (226, 'hgN².iϤFoL񪺹RPѲ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (227, 'DֹحˤpDw.wNOKֹ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (228, '̥`H̴I')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (229, 'ݤߵL\\̦߳w.IX.UH.ϤH.̬Oּ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (230, 'ݤHh@B.RHe@o.bH͹DWN|oܧּ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (231, '̩֪HNOeePd@ͪH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (232, 'ߨLۤvH.~iYpۤv')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (233, 'h@B.@B.ӦOH.YO׾i.YOצ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (234, 'eʧ@.|.O`ͬ׾i԰doӪ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (235, '.ର.~@ئۧڪH')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (236, 'Hͭnv.')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (237, 'npݦۤv.]HLi')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (238, 'ƳOq@ӨM.@Ӻؤl}l')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (239, 'An|.ֳ.pⴤ]t.@˷|Ȩ')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (240, 'ߴN.@NO')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (241, 'bOFi.]iHO믫ìVj')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (242, '@ӥëOPߪH.N|Jx')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (243, '߭n@.N.߭nѪŤ@.}C')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (103, 'ߵLc.NL.Y`iۦb.ߥhI')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (3, 'IOHMQ.ӬO@@۪R')",$dbi);
sql_query("INSERT INTO ".$prefix."_quotes VALUES (1, 'o@`ڭ̴dGH.ରOHAȤQAȪH')",$dbi);

sql_query("CREATE TABLE u_cat (
  catid int(3) NOT NULL auto_increment,
  catname varchar(20) NOT NULL default '',
  PRIMARY KEY  (catid)
)",$dbi);

sql_query("INSERT INTO u_cat VALUES (1, '')",$dbi);
sql_query("INSERT INTO u_cat VALUES (2, '^')",$dbi);
sql_query("INSERT INTO u_cat VALUES (3, 'ƾ')",$dbi);
sql_query("INSERT INTO u_cat VALUES (4, 'z')",$dbi);
sql_query("INSERT INTO u_cat VALUES (5, 'dШ|')",$dbi);

sql_query("CREATE TABLE ".$prefix."_lastseen (
  id int(15) NOT NULL auto_increment,
  username text NOT NULL,
  date int(15) NOT NULL default '0',
  ip varchar(50) default NULL,
  PRIMARY KEY  (id),
  UNIQUE KEY id (id)
)",$dbi);

sql_query("CREATE TABLE button (
  bid int(11) NOT NULL auto_increment,
  hits int(11) default '0',
  member varchar(20) default NULL,
  email varchar(50) default NULL,
  url varchar(100) default NULL,
  img varchar(100) default NULL,
  title varchar(30) NOT NULL default '',
  cont varchar(120) NOT NULL default '',
  PRIMARY KEY  (bid)
)",$dbi);

sql_query("CREATE TABLE nuke_optimize_gain (
  gain decimal(10,3) default NULL
) ",$dbi);

Header("Location: index.php");

?>
