<?php

/************************************************************************/
/* PHP-NUKE: Web Portal System                                          */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2001 by Francisco Burzi (fburzi@ncc.org.ve)            */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/*                                                                      */
/* Php-Quiz Module							*/
/* ===============							*/
/* NyQuist								*/
/* NyQuist@ntlworld.com							*/
/* NyQuist.port5.com							*/
/*									*/
/* Hacked under the rights of the GPL, improved and re-released.        */
/* Please send any comments, bugs and ideas to NyQuist@ntlworld.com     */
/* 			 						*/
/************************************************************************/

$module_name = "Quiz"; // If you change the directory of the module, change it

require_once("mainfile.php");

if (!isset($prefix)) { $prefix= "nuke";}

if (isset($newlang)) {
        include("modules/$module_name/language/lang-$newlang.php");
        $language = $newlang;
} elseif (isset($lang)) {
    include("modules/$module_name/language/lang-$lang.php");
    $language = $lang;
} else {
    include("modules/$module_name/language/lang-$language.php");
}

if (!eregi("admin.php", $PHP_SELF)) { die ("Access Denied"); }
$hlpfile = "manual/faqs.html";
$result = sql_query("select radminsection, radminsuper from $prefix"._authors." where aid='$aid'", $dbi);
list($radminsection, $radminsuper) = sql_fetch_row($result, $dbi);
if (($radminsection==1) OR ($radminsuper==1)) {


/*********************************************************/
/* Quiz Admin Function                                   */
/*********************************************************/

function QuizAdmin()
{
    global $dbi, $language, $hlpfile, $admin, $module_name, $prefix;
    include ('header.php');
    GraphicAdmin($hlpfile);
    title("Quiz Administration");

    echo "<br>";
    OpenTable();
        print "<table width='100%'><tr><td colspan=3><center><font class=catdesc>\n";
        print "<a href=\"admin.php?op=QuizAdmin&act=QuizAdd\"><b> "._QUIZNEW." </b></a>";
        print "</font></center></td></tr>\n";

      $result = sql_query("SELECT
        $prefix"._quiz_admin.".quizID,
        $prefix"._quiz_admin.".quizTitle,
        $prefix"._quiz_admin.".active,
        $prefix"._quiz_categories.".name
        FROM $prefix"._quiz_admin.", $prefix"._quiz_categories."
        WHERE $prefix"._quiz_admin.".cid = $prefix"._quiz_categories.".cid
        ORDER BY quizID", $dbi);
           while(list($qid, $quizTitle,$active,$category) = sql_fetch_row($result, $dbi))
        {
        print "<tr>";
        if ($active == 1) { print "<td> <font class=catdesc>"._QUIZACTIVE." </font></td>"; } else {print "<td><font class=catdesc>"._QUIZINACTIVE."</font></td>";}
        print "<td>";
        print "<font class=catdesc>Quiz $qid : ";
        print "\"$quizTitle\" ";
        print "($category) | ";
        print "<a href=\"admin.php?op=QuizAdmin&act=QuizModify&qid=$qid\"> "._QUIZMODIFY." </a> | ";
        print "<a href=\"admin.php?op=QuizAdmin&act=QuizRemove&qid=$qid\"> "._QUIZDELETE." </a> | ";
        print "<a href=\"admin.php?op=QuizAdmin&act=QuizAddQuestion&qid=$qid\">"._QUIZADDQUESTION."";
        }
        print "</font>\n";
        print "</td></tr></table>\n";
        CloseTable();
        echo "<br><br>";
     
      $result = sql_query("select quizID, quizTitle from $prefix"._quiz_admin."", $dbi);
      $result2 = sql_query("select quizID, quizTitle from $prefix"._quiz_admin."", $dbi);
 
    if (sql_num_rows($result, $dbi) > 1) {

	OpenTable();
	echo "<center><b>"._MOVEQUESTIONS."</b><br><br>"
	    ."<form action=\"admin.php?op=QuizAdmin&act=MoveQuestions&qid=$qid&new_qid=$new_qid\" method=\"post\">"
	    .""._MOVEALLQUESTIONSFROM.": <select name=\"qid\">";
	while(list($qid, $title) = sql_fetch_row($result, $dbi)) {
	    echo "<option name=\"qid\" value=\"$qid\">$title";
	}
	echo "</select> "._TO.": <select name=\"new_qid\">";
	while(list($qid, $title) = sql_fetch_row($result2, $dbi)) {
	    echo "<option name=\"new_qid\" value=\"$qid\">$title";
	}    
	echo "</select>&nbsp;&nbsp;"
	    //."<input type=\"hidden\" name=\"op\" value=\"QuizAdmin\">"
	    ."<input type=\"submit\" value=\""._SAVECHANGES."\">"
	    ."</form></center>";
	CloseTable();
}
	echo "<br><br>";
        
    OpenTable();
    echo "<center><font class=catdesc size=\"3\"><b>"._QUIZADDCAT."</b></font></center>";
    print "\n<form method='post'action='admin.php?op=QuizAdmin'>";
    print "<INPUT type='hidden' name='act' value='createPostedQuizCategory'>";
    print "<font class=catdesc>";
    print "<table width='100%'>";
    print "<tr><td><font class=catdesc>"._QUIZCAT."</font></td><td><input type='text' class=textbox name='CatName' size=30></td>";
    print "<tr><td><font class=catdesc>"._QUIZCOMMENT."</font></td><td><input type='text' class=textbox name='CatComment' size=30><font class=catdesc> ("._QUIZHELPOPTION.")</font></td>";
    print "<tr><td><font class=catdesc>"._QUIZCATIMAGE."</font></td><td><input type='text' class=textbox name='CatImage' size=30><font class=catdesc> ("._QUIZHELPOPTION.")</font></td>";
    print "<td><font class=catdesc><input type='submit' class=button value='"._QUIZADD."'></font></td></tr></table>";
    print "</form>";
    CloseTable();

      echo "<br><br>";

    OpenTable();
    echo "<center><font class=catdesc size=\"3\"><b>"._QUIZDELCAT."</b></font></center>";
    print "\n<form method='post'action='admin.php?op=QuizAdmin'>";
    print "<INPUT type='hidden' name='act' value='QuizDelCategory'>";
    print "<font class=catdesc>";
    print "<table width='100%'>";
    print "<tr><td><font class=catdesc>"._QUIZCAT
        ." <SELECT class=textbox name=\"cid\">";
    $result = sql_query("select cid, name from $prefix"._quiz_categories."", $dbi);
    while(list($cid, $name) = sql_fetch_row($result, $dbi))
        {
            echo "<option value=\"$cid\">$name</option>\n";
        }
    print "</font></select></td><td><font class=catdesc><input type='submit' class=button value='"._QUIZDELETE."'></font></td></tr></table>";
    print "</form>";
    CloseTable();

	echo "<br><br>";

    OpenTable();
    echo "<center><font class=catdesc size=\"3\"><b>"._QUIZMODIFYCAT."</b></font></center>";
    print "\n<form method='post'action='admin.php?op=QuizAdmin'>";
    print "<INPUT type='hidden' name='act' value='QuizModifyCategory'>";
    print "<font class=catdesc>";
    print "<table width='100%'>";
    print "<tr><td><font class=catdesc>"._QUIZCAT
        ." <SELECT class=textbox name=\"cid\">";
    $result = sql_query("select cid, name from $prefix"._quiz_categories."", $dbi);
    while(list($cid, $name) = sql_fetch_row($result, $dbi))
        {
            echo "<option value=\"$cid\">$name</option>\n";
        }
    print "</font></select></td><td><font class=catdesc><input type='submit' class=button value='"._QUIZMODIFY."'></font></td></tr></table>";
    print "</form>";
    CloseTable();
    include ('footer.php');
}

/*********************************************************/
/* Quiz Add Functions                                    */
/*********************************************************/

function QuizAddQuestion()
{
    global $dbi, $language, $hlpfile, $admin, $qid, $prefix;
    include ('header.php');
        GraphicAdmin($hlpfile);
    OpenTable();
    echo "<center><font size=\"3\"><b>"._QUIZADDQUESTION."</b></font></center>";
    CloseTable();
    echo "<br>";
    OpenTable();

    print "\n<form method='post'action='admin.php?op=QuizAdmin'>";
    print "<INPUT type='hidden' name='act' value='createPostedQuizQuestion'>";
    print "<INPUT type='hidden' name='qid' value=\"$qid\">";
    print "<table width='100%' border=0><tr><td><font class=catdesc>"._QUIZQUESTIONTITLE."</font>: <input type=\"text\" class=textbox name=\"question\" size=\"50\" maxlength=\"300\" value=\"\"><br><br><br></td></tr></table><table width='100%' border=0><tr><td>";
    print "<tr><td><font class=catdesc>"._QUIZCOEF."</td><td colspan=3><input type='text' class=textbox name='coef' value='1' size=3></font></td></tr>";
    print "<tr><td><font class=catdesc>"._QUIZIMAGE." (*)</td><td colspan=3><input type='text' class=textbox name='image' size=50></font></td></tr>";
        print "<tr><td colspan=2><font class=catdesc>"._QUIZQUESTION."</font></td><td><font class=catdesc>"._QUIZANSWER."</font></td></tr>";
    for($i = 1; $i <= 10; $i++)
    {
        print "<tr><td><font class=catdesc>"._OPTION." $i:</font></td>";
		echo "<td><input type=\"text\" class=textbox name=\"optionText[$i]\" size=\"50\" maxlength=\"250\"></td>";
        //echo "<td><font class=catdesc><input type=\"radio\" class=textbox name=\"answer\" value=\"$i\" $checked> $optionText<br></font></td>\n";
	echo "<td><font class=catdesc><input type=\"checkbox\" class=textbox name=\"optionSort[$i]\" value=\"$i\" $sel> $optionText<br></font></td>\n";
    }
    echo "</table><br><br>"
    ."<table width='100%' border=0>"
	."<tr><td><font class=catdesc>"._QUIZCOMMENT." </font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"6\" name=\"comment\"></textarea></td></tr>"
	."<tr><td><font class=catdesc>"._QUIZIFBADANSWER." </font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"6\" name=\"bad\"></textarea></td></tr>"
    ."<tr><td><font class=catdesc>"._QUIZIFGOODANSWER." </font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"6\" name=\"good\"></textarea></td></tr>"
    ."</table><br><br><input type=\"submit\" class=button value=\""._QUIZADDQUESTION."\">"
    ."</form>";
    CloseTable();
   include ('footer.php');
}

function QuizAdd()
{
    global $dbi, $language, $hlpfile, $admin,$prefix;
    include ('header.php');
     GraphicAdmin($hlpfile);
    OpenTable();
    echo "<center><font size=\"3\"><b>"._QUIZNEW."</b></font></center>";
    CloseTable();
    echo "<br>";
    OpenTable();

    print "\n<form method='post'action='admin.php?op=QuizAdmin'>";
    print "<INPUT type='hidden' name='act' value='createPostedQuiz'>";
    print "<font class=catdesc>";
    print "<table width='100%'>";

    print "<tr><td><font class=catdesc>"._QUIZTITLE."</font></td><td><input type='text' class=textbox name='quizTitle' size=30><font class=catdesc></font></td></tr>";
    print "<tr><td><font class=catdesc>"._QUIZVIEWANSWER."</font></td><td><input type='checkbox' class=textbox name='displayresults' checked><font class=catdesc> "._QUIZHELPANSWER."</font></td></tr>";
    print "<tr><td><font class=catdesc>"._QUIZVIEWSCORE."</font></td><td><input type='checkbox' class=textbox name='displayscore' checked><font class=catdesc> "._QUIZHELPVIEWSCORE."</font></td></tr>";
    print "<tr><td><font class=catdesc>"._QUIZIMAGE."</font></td><td><input type='text' class=textbox name='image' size=30><font class=catdesc> (*) "._QUIZHELPIMAGE."</font></td></tr>";
        print "<tr><td><font class=catdesc>"._QUIZCAT."</font></td><td><font class=catdesc><SELECT class=textbox name=\"cid\">";
    $result = sql_query("select cid, name from $prefix"._quiz_categories."", $dbi);
    while(list($catid, $name) = sql_fetch_row($result, $dbi))
    {
        if ($catid==$cid) { $sel = "selected "; }
            echo "<option $sel value=\"$catid\">$name</option>\n";
                $sel = "";
    }
    print "</font></select></td></tr>";

	print "<tr><td><font class=catdesc>"._QUIZEXPIRATION." (*)</font></td><td><font class=catdesc>";
    $xday = 1;
    echo " "._DAY.": <SELECT class=textbox name=\"day\">";
	echo "<option name=\"day\" selected>xx</option>"; # by default print the "no expiration date" tag
    while ($xday <= 31) 
	{
	echo "<option name=\"day\">$xday</option>";
	$xday++;
    }
    echo "</select>";
    $xmonth = 1;
    echo " "._UMONTH.": <SELECT class=textbox name=\"month\">";
	echo "<option name=\"month\" selected>xx</option>"; # by default print the "no expiration date" tag
    while ($xmonth <= 12) 
	{
	echo "<option name=\"month\">$xmonth</option>";
	$xmonth++;
    }
    echo "</select>";
    echo " "._YEAR.": <input class=textbox type=\"text\" name=\"year\" value=\"xxxx\" size=\"5\" maxlength=\"4\">";
    echo " "._HOUR.": <SELECT class=textbox name=\"hour\">";
    $xhour = 0;
    $cero = "0";
	echo "<option name=\"hour\" selected>xx</option>"; # by default print the "no expiration date" tag
    while ($xhour <= 23) 
	{
	$dummy = $xhour;
	if ($xhour < 10) { $xhour = "$cero$xhour"; }
	echo "<option name=\"hour\">$xhour</option>";
	$xhour = $dummy;
	$xhour++;
    }
    echo "</select>";
    echo ": <SELECT class=textbox name=\"min\">";
    $xmin = 0;
	echo "<option name=\"min\" selected>xx</option>"; # by default print the "no expiration date" tag
    while ($xmin <= 59) 
	{
	if (($xmin == 0) OR ($xmin == 5)) { $xmin = "0$xmin"; }
	echo "<option name=\"min\">$xmin</option>";
	$xmin = $xmin + 5;
    }
    echo "</select>";


	$now = getnow();
    print "</font></select><br> <font class=catdesc>("._NOWIS." : $now)</td></tr>";

#_______________________________________

	
    print "<tr><td colspan=2><font class=catdesc>"._QUIZCOMMENT." (*)<br></font><TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"4\" name=\"comment\">$comment</textarea><font class=catdesc></font></td></tr>";
    print "<tr><td colspan=2><font class=catdesc>"._QUIZCONDITIONS." (*)<br></font><TEXTAREA class=textbox cols=\"50\" rows=\"4\" name=\"conditions\">$conditions</textarea><font class=catdesc></font></td></tr>";


    print "</table>";
    print "<br><center><input type='submit' class=button value='"._QUIZCREATE."'></center>";
    print "</form>";

    print "<font class=catdesc>* : "._QUIZHELPOPTION."</font>\n";
    CloseTable();
    include ('footer.php');
}


/*********************************************************/
/* Quiz Modify Functions                                 */
/*********************************************************/

function QuizModify()
{
    global $dbi, $language, $hlpfile, $admin, $qid,$prefix;

    $result = sql_query("select quizTitle, nbscore, displayscore, displayresults, emailadmin, comment, image, restrict_user, log_user, active, cid, contrib, expire, admemail, administrator, conditions from $prefix"._quiz_admin." where quizID='$qid'", $dbi);
    list($quizTitle, $nbscore, $displayscore, $displayresults, $emailadmin, $comment, $image,$restrict_user,$log_user,$active,$cid,$contrib,$expire,$admemail, $administrator,$conditions) = sql_fetch_row($result, $dbi);

    include ('header.php');
        GraphicAdmin($hlpfile);
    OpenTable();
    echo "<center><font class=catdesc size=\"3\"><b>"._QUIZMODIFY."</b></font></center>";
    CloseTable();
    echo "<br>";
    OpenTable();

    if ($active==1) { $act = "checked"; }
    if ($emailadmin==1) { $eadm = "checked"; }
    if ($displayscore==1) { $dis = "checked"; }
    if ($displayresults==1) { $res = "checked"; }
    if ($contrib==1) { $con = "checked"; }
    if ($log_user==1) { $log = "checked"; }
    if ($restrict_user==1) { $restrict = "checked"; }

    print "\n<form method='post'action='admin.php?op=QuizAdmin'>";
    print "<INPUT type='hidden' name='act' value='modifyPostedQuiz'>";
    print "<INPUT type='hidden' name='qid' value='$qid'>";
    print "<table width='100%'>";
    print "<tr><td><font class=catdesc>"._QUIZGENINFOS."</font></td></tr>";
    print "<tr><td><font class=catdesc>"._QUIZTITLE."</font></td><td><input type='text' class=textbox name='quizTitle' value=\"$quizTitle\" size=30><font class=catdesc></font></td></tr>";
    print "<tr><td><font class=catdesc>"._QUIZACTIVE."</font></td><td><input type='checkbox' class=textbox name='active' $act><font class=catdesc> "._QUIZHELPACTIVE."</font></td></tr>";
    print "<tr><td><font class=catdesc>"._QUIZVIEWSCORE."</font></td><td><input type='checkbox' class=textbox name='displayscore' $dis><font class=catdesc> "._QUIZHELPVIEWSCORE."</font></td></tr>";
    print "<tr><td><font class=catdesc>"._QUIZVIEWANSWER."</font></td><td><input type='checkbox' class=textbox name='displayresults' $res><font class=catdesc> "._QUIZHELPANSWER."</font></td></tr>";
    print "<tr><td><font class=catdesc>"._QUIZIMAGE."</font></td><td><input type='text' class=textbox name='image' value=\"$image\" size=30><font class=catdesc> (*) "._QUIZHELPIMAGE."</font></td></tr>";
    print "<tr><td><font class=catdesc>"._QUIZCAT."</font></td><td><font class=catdesc><SELECT class=textbox name=\"cid\">";
    $result = sql_query("select cid, name from $prefix"._quiz_categories."", $dbi);
    while(list($catid, $name) = sql_fetch_row($result, $dbi))
        {
        if ($catid==$cid) { $sel = "selected "; }
            echo "<option $sel value=\"$catid\">$name</option>\n";
                $sel = "";
        }
    print "</font></select></td></tr>";

	# expiration date (a lot of code for so few things)
	ereg ("([0-9x]{4})-([0-9x]{1,2})-([0-9x]{1,2}) ([0-9x]{1,2}):([0-9x]{1,2})", $expire, $datetime);

	print "<tr><td><font class=catdesc>"._QUIZEXPIRATION." (*)</font></td><td><font class=catdesc>";
    $xday = 1;
    echo " "._DAY.": <SELECT class=textbox name=\"day\">";
	if ($datetime[3] == "xx") { $sel="selected"; } else { $sel=""; }
	echo "<option name=\"day\" $sel>xx</option>";
    while ($xday <= 31) {
	if ($xday == $datetime[3]) {
	    $sel = "selected";
	} else {
	    $sel = "";
	}
	echo "<option name=\"day\" $sel>$xday</option>";
	$xday++;
    }
    echo "</select>";
    $xmonth = 1;
    echo " "._UMONTH.": <SELECT class=textbox name=\"month\">";
	if ($datetime[2] == "xx") { $sel="selected"; } else { $sel=""; }
	echo "<option name=\"month\" $sel>xx</option>";
    while ($xmonth <= 12) {
	if ($xmonth == $datetime[2]) {
	    $sel = "selected";
	} else {
	    $sel = "";
	}
	echo "<option name=\"month\" $sel>$xmonth</option>";
	$xmonth++;
    }
    echo "</select>";
    echo " "._YEAR.": <input class=textbox type=\"text\" name=\"year\" value=\"$datetime[1]\" size=\"5\" maxlength=\"4\">";
    echo " "._HOUR.": <SELECT class=textbox name=\"hour\">";
    $xhour = 0;
    $cero = "0";
	if ($datetime[4] == "xx") { $sel="selected"; } else { $sel=""; }
	echo "<option name=\"hour\" $sel>xx</option>";
    while ($xhour <= 23) {
	$dummy = $xhour;
	if ($xhour < 10) {
	    $xhour = "$cero$xhour";
	}
	if ($xhour == $datetime[4]) {
	    $sel = "selected";
	} else {
	    $sel = "";
	}
	echo "<option name=\"hour\" $sel>$xhour</option>";
	$xhour = $dummy;
	$xhour++;
    }
    echo "</select>";
    echo ": <SELECT class=textbox name=\"min\">";
    $xmin = 0;
	if ($datetime[5] == "xx") { $sel="selected"; } else { $sel=""; }
	echo "<option name=\"min\" $sel>xx</option>";
    while ($xmin <= 59) {
	if (($xmin == 0) OR ($xmin == 5)) {
	    $xmin = "0$xmin";
	}
	if ($xmin == $datetime[5]) {
	    $sel = "selected";
	} else {
	    $sel = "";
	}
	echo "<option name=\"min\" $sel>$xmin</option>";
	$xmin = $xmin + 5;
    }
    echo "</select>";


	$now = getnow();
    print "</font></select><br> <font class=catdesc>("._NOWIS." : $now)</td></tr>";


    print "<tr><td colspan=2><font class=catdesc>"._QUIZCOMMENT." (*)<br></font><TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"4\" name=\"comment\">$comment</textarea><font class=catdesc></font></td></tr>";
    print "</table>";
    print "<br><font class=catdesc><center><input type='submit' class=button value='"._QUIZMODIFY."'></font></center>";
    print "</form>";
    print "<font class=catdesc>* : "._QUIZHELPOPTION."</font>\n";
    CloseTable();
    echo "<br>";
    OpenTable();
    print "<center><font class=catdesc><a href=\"admin.php?op=QuizAdmin&act=QuizAddQuestion&qid=$qid\"><b>  "._QUIZADDQUESTION." </b></a></font></center>";
 
   print "<tr><td><font class=catdesc>"._QUIZQUESTIONS."</font></td></tr>";
    $result = sql_query("SELECT pollID, pollTitle FROM $prefix"._quiz_desc." WHERE qid=$qid", $dbi);
    while(list($pollID, $question) = sql_fetch_row($result, $dbi))
    {
        print "<tr><td>";
        print "<font class=catdesc>"._QUIZQUESTION." $pollID : ";
        print "\"$question\" <a href=\"admin.php?op=QuizAdmin&act=QuizModifyQuestion&pid=$pollID&qid=$qid\"> [ "._QUIZMODIFY." ]</a> | ";
        print "<a href=\"admin.php?op=QuizAdmin&act=QuizDelQuestion&pid=$pollID&qid=$qid\"> [ "._QUIZDELETE." ]</a> |";
        print "<a href=\"admin.php?op=QuizAdmin&act=QuizMoveQuestion&pid=$pollID&qid=$qid\"> [ "._QUIZMOVEQUESTION." ] </a> |";
        print "<a href=\"admin.php?op=QuizAdmin&act=QuizCopyQuestion&pid=$pollID\"> [ "._QUIZCOPYQUESTION." ]</a></td></tr>";
        }
    

    CloseTable();
    include ('footer.php');
}

function QuizModifyCategory()
{
    global $dbi, $language, $hlpfile, $admin, $cid,$prefix;
    include ('header.php');
        GraphicAdmin($hlpfile);
    OpenTable();
    echo "<center><font class=catdesc size=\"3\"><b>"._QUIZMODIFYCAT."</b></font></center>";
    CloseTable();
    echo "<br>";
    OpenTable();

    $result = sql_query("SELECT name, comment, image from $prefix"._quiz_categories." where cid='$cid'", $dbi);
    list ($name, $comment, $image) = sql_fetch_row($result, $dbi);

    print "\n<form method='post'action='admin.php?op=QuizAdmin'>";
    print "<INPUT type='hidden' name='act' value='modifyPostedQuizCategory'>";
    print "<INPUT type='hidden' name='cid' value='$cid'>";
    print "<font class=catdesc>";
    print "<table width='100%'>";
    print "<tr><td><font class=catdesc>"._QUIZCAT."</font></td><td><input type='text' class=textbox name='CatName' value='$name'size=30></td>";
    print "<tr><td><font class=catdesc>"._QUIZCOMMENT."</font></td><td><input type='text' class=textbox name='CatComment' value='$comment'size=30><font class=catdesc> (*)</font></td>";
    print "<tr><td><font class=catdesc>"._QUIZCATIMAGE."</font></td><td><input type='text' class=textbox name='CatImage' value='$image'size=30><font class=catdesc> (*)</font></td>";
    print "<td><font class=catdesc><input type='submit' class=button value='"._QUIZMODIFY."'></font></td></tr></table>";
    print "</form>";
    print "<font class=catdesc>* : "._QUIZHELPOPTION."</font>\n";

    CloseTable();
    include ('footer.php');
}

function QuizModifyQuestion()
{
    global $dbi, $language, $hlpfile, $admin,$qid, $pid,$prefix;
    include ('header.php');
        GraphicAdmin($hlpfile);
    OpenTable();
    echo "<center><font class=catdesc size=\"3\"><b>"._QUIZMODIFYQUESTION."</b></font></center>";
    CloseTable();
    echo "<br>";
    OpenTable();

    $result = sql_query("select pollTitle, answer, coef, good, bad, comment, image from $prefix"._quiz_desc." where pollID='$pid'", $dbi);
    list ($pollTitle,$answer,$coef,$good,$bad,$comment,$image) = sql_fetch_row($result, $dbi);
	$pollTitle = preg_replace("/\"/","&quot;",$pollTitle);

	# check if the answer was ordered
	if (ereg(",",$answer))
	{
		$array_answer = split(',',$answer);
	}

    print "\n<form method='post'action='admin.php?op=QuizAdmin'>";
    print "<INPUT type='hidden' name='act' value='modifyPostedQuizQuestion'>";
    print "<INPUT type='hidden' name='qid' value=\"$qid\">";
    print "<INPUT type='hidden' name='pid' value=\"$pid\">";
    print "<table width='100%' border=0><tr><td><font class=catdesc>"._QUIZQUESTIONTITLE.": <input type=\"text\" class=textbox name=\"question\" size=\"50\" maxlength=\"300\" value=\"$pollTitle\"></font><br><br><br></td></tr></table>";
    print "<table width='100%' border=0><tr><td>";
    print "<tr><td><font class=catdesc>"._QUIZCOEF."</td><td colspan=3><input type='text' class=textbox name='coef' value='$coef' size=3></font></td></tr>";
    $i=1;
    $j=0;
        print "<tr><td colspan=2><font class=catdesc>"._QUIZQUESTION."</font></td><td><font class=catdesc>"._QUIZANSWER."</font></td></tr>";
    $result = sql_query("select optionText, voteID from $prefix"._quiz_data." WHERE pollID='$pid' ORDER BY voteID", $dbi);


      while(list($Text,$voteID) = sql_fetch_row($result, $dbi))
    {
		$Text = big5_stripslashes(check_html($Text, "nohtml"));
        echo "<tr><td><font class=catdesc>"._OPTION." $i :</font></td><td><input type=\"text\" class=textbox name=\"optionText[$i]\" size=\"50\" maxlength=\"150\" value=\"$Text\"></font></td>\n";
        //if ((strlen($answer) == 1) and ($i == $answer)) { $sel = "checked"; } else { $sel = "";  } 
        //echo "<td><font class=catdesc><input type=\"radio\" class=textbox name=\"answer\" class=textbox value=\"$i\" $sel> $optionText<br></font></td>";
        if ($array_answer[$j] == $i) { $sel = "checked"; } else { $sel = "";  } 
        echo "<td><font class=catdesc><input type=\"checkbox\" class=textbox name=\"optionSort[$i]\" value=\"$i\" $sel> $optionText<br></font></td>";
     $i++;
     $j++;
      }     	
    
    echo "</tr></table><br><br>"
    ."<table width='100%' border=0>"
	."<tr><td><font class=catdesc>"._QUIZCOMMENT."</font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"4\" name=\"comment\">$comment</textarea></td></tr>"
	."<tr><td><font class=catdesc>"._QUIZIFBADANSWER."</font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"4\" name=\"bad\">$bad</textarea></td></tr>"
    ."<tr><td><font class=catdesc>"._QUIZIFGOODANSWER."</font><br>"
    ."<TEXTAREA class=textbox wrap=\"virtual\" cols=\"50\" rows=\"4\" name=\"good\">$good</textarea></td></tr></table><br><br>"
    ."<input type=\"submit\" class=button value=\""._QUIZMODIFYQUESTION."\">"
    ."</form>";
    CloseTable();
    include ('footer.php');
}

function modifyPostedQuizQuestion()
{
    global $hlpfile,$dbi, $question, $optionText,$qid,$pid,$answer,$coef,$good,$bad,$comment,$prefix,$optionSort,$image;

      $question = nl2br(check_html($question, "nohtml"));
      $good = nl2br(check_html($good, ""));
      $bad = nl2br(check_html($bad, ""));
      $comment = nl2br(check_html($comment, ""));
      
        if (strlen($optionSort) >= 2) {
                for($i = 1; $i <= sizeof($optionText); $i++) {
        if (isset($optionSort[$i])) { $optionSort[$i] = "$i,"; } else { $optionSort[$i] = ","; }
        }
        $answer = "$optionSort[1]$optionSort[2]$optionSort[3]$optionSort[4]$optionSort[5]$optionSort[6]$optionSort[7]$optionSort[8]$optionSort[9]$optionSort[10]";
        }

  	# update general information about current question ...
    if(!sql_query("UPDATE $prefix"._quiz_desc." SET pollTitle='$question', answer='$answer', coef='$coef', good='$good', bad='$bad', comment='$comment', image='$image' WHERE pollID='$pid'", $dbi))
        {
        echo sql_errno(). ": ".sql_error(). "<br>";
        return;
    }

    for($i = 1; $i <= sizeof($optionText); $i++)
        {
        if($optionText[$i] != "")
        {
            $optionText[$i] = FixQuotes($optionText[$i]);
        }

        if(!sql_query("UPDATE $prefix"._quiz_data." SET optionText='$optionText[$i]' WHERE voteID='$i' AND pollID='$pid'", $dbi))
        {
            echo sql_errno(). ": ".sql_error(). "<br>";
            return;
        }
    }
   Header("Location: admin.php?op=QuizAdmin&act=QuizModify&qid=$qid");
}

function modifyPostedQuiz()
{
        global $hlpfile,$dbi, $qid,$quizTitle, $displayresults,$displayscore,$emailadmin,$nbscore,$comment,$image,$log,$restrict,$active,$cid,$contrib,$year,$month,$day,$hour,$min,$prefix,$admemail,$administrator,$conditions;

    $quizTitle = FixQuotes($quizTitle);
    $comment = FixQuotes($comment);
    $conditions = FixQuotes($conditions);
    $expire = "$year-$month-$day $hour:$min";	



        if(isset($emailadmin)) $emailadmin=1; else $emailadmin=0;
        if(isset($displayresults)) $displayresults=1; else $displayresults=0;
        if(isset($displayscore)) $displayscore=1; else $displayscore=0;
        if(isset($restrict)) $restrict=1; else $restrict=0;
        if(isset($log)) $log=1; else $log=0;
        if(isset($active)) $active=1; else $active=0;
        if(isset($contrib)) $contrib=1; else $contrib=0;

    if(!sql_query("UPDATE $prefix"._quiz_admin." SET quizTitle='$quizTitle', nbscore='$nbscore', displayscore='$displayscore', displayresults='$displayresults', emailadmin='$emailadmin', comment='$comment', image='$image', restrict_user='$restrict', log_user='$log', active='$active', cid='$cid', contrib='$contrib', expire='$expire', admemail='$admemail', administrator='$administrator', conditions='$conditions' WHERE quizID='$qid'", $dbi)) {
        echo sql_errno(). ": ".sql_error(). "<br>";
        return;
    }
    Header("Location: admin.php?op=QuizAdmin&act=QuizAdmin");
}

function modifyPostedQuizCategory()
{
        global $hlpfile,$dbi, $CatName,$CatComment,$CatImage,$cid,$prefix;

    if(!sql_query("UPDATE $prefix"._quiz_categories." SET name='$CatName',comment='$CatComment',image='$CatImage' WHERE cid='$cid'", $dbi))
        {
                echo sql_errno(). ": ".sql_error(). "<br>";
                return;
    }
    Header("Location: admin.php?op=QuizAdmin&act=QuizAdmin");
}

/*********************************************************/
/* Quiz Move Functions                                   */
/*********************************************************/

function MoveQuestions($qid, $new_qid) {
    global $hlpfile,$prefix, $dbi;
    $result = sql_query("select qid from $prefix"._quiz_desc." WHERE qid='$qid'", $dbi);
    while(list($qid) = sql_fetch_row($result, $dbi)) {
	sql_query("update $prefix"._quiz_desc." set qid='$new_qid' WHERE qid='$qid'", $dbi);
    }
    Header("Location: admin.php?op=QuizAdmin&act=QuizAdmin");
}

function QuizMoveQuestion($pid, $qid)
{
    global $dbi, $language, $hlpfile, $admin, $module_name, $prefix;
    include ('header.php');
    GraphicAdmin($hlpfile);
    title("Move Question");

    $result = sql_query("SELECT pollID, pollTitle, qid FROM $prefix"._quiz_desc." WHERE pollID=$pid", $dbi);
    list($pollID, $question, $quizid) = sql_fetch_row($result, $dbi);
    
    $result1 = sql_query("SELECT quizID, quizTitle FROM $prefix"._quiz_admin." WHERE quizID=$qid", $dbi);
    list($quizID, $quizTitle) = sql_fetch_array($result1, $dbi);
    
    $result2 = sql_query("SELECT quizID, quizTitle FROM $prefix"._quiz_admin." order by quizID", $dbi);
    
    OpenTable();
	echo "<center><b>"._MOVEQUESTION." $pollID:<i> $question</b></i><br><br>
	    <form action=\"admin.php?op=QuizAdmin&act=QuizMoveQuestionConfirm&pid=$pid&qid=$qid&newqid=$newqid\" method=\"post\">
	    "._FROMQUIZ." $quizID : $quizTitle";

        echo "<br><br><center> "._TO.": <select name=\"newqid\">";
	while(list($quizID, $quizTitle) = sql_fetch_row($result2, $dbi)) {
	    echo "<option name=\"newqid\" value=\"$quizID\">"._QUIZ." $quizID: $quizTitle\n";
	}    
	echo "</select>&nbsp;&nbsp;"
	    ."<input type=\"submit\" value=\""._SAVECHANGES."\">"
	    ."</form></center>";
	CloseTable();
    
    include ('footer.php');

}

function QuizMoveQuestionConfirm($pid, $qid, $newqid) {
    global $hlpfile, $prefix, $dbi;
    $result = sql_query("select pollID, qid from $prefix"._quiz_desc." WHERE pollID='$pid'", $dbi);
    while(list($pollID, $qid) = sql_fetch_row($result, $dbi)) {
	sql_query("update $prefix"._quiz_desc." set qid='$newqid' WHERE pollID='$pid'", $dbi);
    }
    Header("Location: admin.php?op=QuizAdmin&act=QuizAdmin");
}

/*********************************************************/
/* Quiz Copy Functions                                   */
/*********************************************************/

function QuizCopyQuestion($pid)
{
    global $dbi, $language, $hlpfile, $admin, $module_name, $prefix;
    include ('header.php');
    GraphicAdmin($hlpfile);
    title("Copy Question");

    $result = sql_query("SELECT pollID, pollTitle, qid FROM $prefix"._quiz_desc." WHERE pollID=$pid", $dbi);
    list($pollID, $question, $quizid) = sql_fetch_row($result, $dbi);
    
    $result2 = sql_query("SELECT quizID, quizTitle FROM $prefix"._quiz_admin." order by quizID", $dbi);
    
    OpenTable();
	echo "<center><b>"._COPYQUESTION." $pollID:<i> $question</b></i><br><br>
	    <form action=\"admin.php?op=QuizAdmin&act=QuizCopyQuestionConfirm&pid=$pid&newqid=$newqid\" method=\"post\">";
	   
        echo "<br><br><center> "._TO.": <select name=\"newqid\">";
	while(list($quizID, $quizTitle) = sql_fetch_row($result2, $dbi)) {
	    echo "<option name=\"newqid\" value=\"$quizID\">"._QUIZ." $quizID: $quizTitle\n";
	}    
	echo "</select>&nbsp;&nbsp;"
	    ."<input type=\"submit\" value=\""._COPYQUESTION."\">"
	    ."</form></center>";
	CloseTable();
    
    include ('footer.php');

}

function QuizCopyQuestionConfirm($pid, $newqid) {
    global $hlpfile,$prefix, $dbi;
    $result = sql_query("select pollID, pollTitle, timeStamp, voters, qid, answer, coef, good, bad, comment, image from $prefix"._quiz_desc." WHERE pollID='$pid'", $dbi);
    list($pollID, $pollTitle, $timeStamp, $voters, $qid, $answer, $coef, $good, $bad, $comment, $image) = sql_fetch_row($result, $dbi);
    sql_query("insert $prefix"._quiz_desc." VALUES ('NULL', '$pollTitle', '$timeStamp', '$voters', '$newqid', '$answer', '$coef', '$good', '$bad', '$comment', '$image')", $dbi);
    Header("Location: admin.php?op=QuizAdmin&act=QuizAdmin");
}

/*********************************************************/
/* Quiz Misc Functions                                   */
/*********************************************************/

function getnow ()
{
    $today = getdate();
    $tday = $today[mday];
    if ($tday < 10){ $tday = "0$tday"; }
    $tmonth = $today[month];
    $ttmon = $today[mon];
    if ($ttmon < 10) { $ttmon = "0$ttmon"; }
    $tyear = $today[year];
    $thour = $today[hours];
    if ($thour < 10) { $thour = "0$thour"; }
    $tmin = $today[minutes];
    if ($tmin < 10) { $tmin = "0$tmin"; }
    $tsec = $today[seconds];
    if ($tsec < 10) { $tsec = "0$tsec"; }
    return "$tmonth $tday, $tyear @ $thour:$tmin:$tsec";
}

/*********************************************************/
/* Quiz Create Functions                                 */
/*********************************************************/

function createPostedQuiz()
{
    global $hlpfile,$dbi, $quizTitle, $displayresults, $displayscore,$emailadmin,$nbscore,$comment,$image,$restrict,$log,$cid,$contrib,$year,$month,$day,$hour,$min,$prefix,$admemail,$administrator,$conditions;

    if(isset($emailadmin)) $emailadmin=1; else $emailadmin=0;
    if(isset($displayresults)) $displayresults=1; else $displayresults=0;
    if(isset($displayscore)) $displayscore=1; else $displayscore=0;
    if(isset($restrict)) $restrict=1; else $restrict=0;
    if(isset($log)) $log=1; else $log=0;
    if(isset($contrib)) $contrib=1; else $contrib=0;
    $expire = "$year-$month-$day $hour:$min";

    $timeStamp = time();
//    $quizTitle = FixQuotes($quizTitle);
//    $comment = FixQuotes($comment);
//    $conditions = FixQuotes($conditions);
    if(!sql_query("INSERT INTO $prefix"._quiz_admin." VALUES (NULL, '$quizTitle', '$timeStamp', 0, '$nbscore','$displayscore','$displayresults','$emailadmin','$comment',1,'$restrict','$log','$image','$cid','$contrib','$expire','$admemail','$administrator','$conditions')", $dbi)) {
        echo sql_errno(). ": ".sql_error(). "<br>";
        return;
    }
    Header("Location: admin.php?op=QuizAdmin&act=QuizAdmin");
}

function createPostedQuizQuestion()
{
    global $hlpfile,$dbi, $question, $optionText,$qid,$answer,$coef,$good,$bad,$mode,$pid,$comment,$prefix,$optionSort,$image;

/* 	$good = nl2br(check_html($good, ""));
    $bad = nl2br(check_html($bad, ""));
    $comment = nl2br(check_html($comment, ""));
    $question = nl2br(check_html($question, ""));*/

    $timeStamp = time();

	if (strlen($optionSort) >= 2) {
                for($i = 1; $i <= sizeof($optionText); $i++) {
        if (isset($optionSort[$i])) { $optionSort[$i] = "$i,"; } else { $optionSort[$i] = ","; }
        }
        $answer = "$optionSort[1]$optionSort[2]$optionSort[3]$optionSort[4]$optionSort[5]$optionSort[6]$optionSort[7]$optionSort[8]$optionSort[9]$optionSort[10]";
        }
	if (!empty($answer))
	{		$answer = $answer; }

if(!sql_query("INSERT INTO $prefix"._quiz_desc." VALUES (NULL, '$question', '$timeStamp', 0, '$qid','$answer','$coef','$good','$bad','$comment','$image')", $dbi))
        {
        echo mysql_errno(). ": ".mysql_error(). "<br>";
        return;
    }
    $object = sql_fetch_object(sql_query("SELECT pollID FROM $prefix"._quiz_desc." WHERE pollTitle='$question'", $dbi), $dbi);
    $id = $object->pollID;
    for($i = 1; $i <= sizeof($optionText); $i++)
        {
        if($optionText[$i] != "")
        {
            $optionText[$i] = FixQuotes($optionText[$i]);
        }
        if(!sql_query("INSERT INTO $prefix"._quiz_data." (pollID, optionText, optionCount, voteID) VALUES ($id, '$optionText[$i]', 0, $i)", $dbi))
        {
            echo mysql_errno(). ": ".mysql_error(). "<br>";
            return;
        }
    }

    # delete contributor question if needed
    if ($mode == "contrib")
    {
         sql_query("DELETE FROM $prefix"._quiz_datacontrib." WHERE pollID='$pid'", $dbi);
         sql_query("DELETE FROM $prefix"._quiz_descontrib." WHERE pollID='$pid'", $dbi);
    }
    Header("Location: admin.php?op=QuizAdmin&act=QuizModify&qid=$qid");
}


function createPostedQuizCategory()
{
        global $hlpfile,$dbi, $CatName,$CatComment,$CatImage,$prefix;

    if(!sql_query("INSERT INTO $prefix"._quiz_categories." VALUES (NULL, '$CatName','$CatComment','$CatImage')", $dbi))
        {
                echo sql_errno(). ": ".sql_error(). "<br>";
                return;
    }
    Header("Location: admin.php?op=QuizAdmin&act=QuizAdmin");
}

/*********************************************************/
/* Quiz Delete Functions                                 */
/*********************************************************/

function QuizDelCategory()
{
        global $hlpfile,$dbi, $cid,$prefix;

    include ('header.php');
        GraphicAdmin($hlpfile);
    OpenTable();
    echo "<center><font class=catdesc size=\"4\"><b>"._QUIZADMIN."</b></font></center>";
    CloseTable();
    echo "<br>";
    OpenTable();
    echo "<center><font class=catdesc size=\"3\"><b>"._QUIZDELCAT."</b></font><br><br>"
        ."<font class=catdesc>"._QUIZSURE2DELETECAT."<br><br>"
        ."[ <a href=\"admin.php?op=QuizAdmin&act=removePostedQuizCategory&cid=$cid\">"._YES."</a> | <a href=\"admin.php?op=QuizAdmin&act=QuizAdmin\">"._NO."</a> ]</center>";
    CloseTable();
    include("footer.php");


}

function QuizDelQuestion() {
    global $hlpfile,$dbi, $hlpfile, $admin,$qid,$pid,$prefix;

    include ('header.php');
        GraphicAdmin($hlpfile);
    OpenTable();
    echo "<center><font size=\"4\"><b>"._QUIZADMIN."</b></font></center>";
    CloseTable();
    echo "<br>";
    OpenTable();
    echo "<center><font size=\"3\"><b>"._QUIZDELQUESTION."</b></font><br><br>"
        .""._QUIZSURE2DELQUESTION." $pid?<br><br>"
        ."[ <a href=\"admin.php?op=QuizAdmin&act=removePostedQuizQuestion&qid=$qid&pid=$pid\">"._YES."</a> | <a href=\"admin.php?op=QuizAdmin&act=QuizModify&qid=$qid\">"._NO."</a> ]</center>";
    CloseTable();
    include("footer.php");

}

function QuizRemove() {
    global $hlpfile,$dbi, $hlpfile, $admin,$qid,$prefix;

    include ('header.php');
        GraphicAdmin($hlpfile);
    OpenTable();
    echo "<center><font size=\"4\"><b>"._QUIZADMIN."</b></font></center>";
    CloseTable();
    echo "<br>";
    OpenTable();
    echo "<center><font size=\"3\"><b>"._QUIZDELETE."</b></font><br><br>"
        .""._QUIZSURE2DELETE." $qid?<br><br>"
        ."[ <a href=\"admin.php?op=QuizAdmin&act=removePostedQuiz&qid=$qid\">"._YES."</a> | <a href=\"admin.php?op=QuizAdmin&act=QuizAdmin\">"._NO."</a> ]</center>";
    CloseTable();
    include("footer.php");

}

function removePostedQuizCategory() {
    global $hlpfile,$dbi, $cid,$prefix;

    sql_query("DELETE FROM $prefix"._quiz_categories." WHERE cid='$cid'", $dbi);
    Header("Location: admin.php?op=QuizAdmin&act=QuizAdmin");
}

function removePostedQuiz() {
    global $hlpfile,$dbi, $qid,$prefix;

    $result = sql_query("SELECT pollID FROM $prefix"._quiz_desc." WHERE qid='$qid'", $dbi);
    while(list($pollID) = sql_fetch_row($result, $dbi))
    {
        sql_query("DELETE FROM $prefix"._quiz_desc." WHERE pollID='$pollID'", $dbi);
        sql_query("DELETE FROM $prefix"._quiz_data." WHERE pollID='$pollID'", $dbi);
	}

    sql_query("DELETE FROM $prefix"._quiz_admin." WHERE quizID='$qid'", $dbi);
    Header("Location: admin.php?op=QuizAdmin&act=QuizAdmin");
}

function removePostedQuizQuestion() {
    global $hlpfile,$dbi, $qid,$pid,$prefix;
    sql_query("DELETE FROM $prefix"._quiz_desc." WHERE pollID='$pid'", $dbi);
    sql_query("DELETE FROM $prefix"._quiz_data." WHERE pollID='$pid'", $dbi);
    Header("Refresh:0;url: admin.php?op=QuizAdmin&act=QuizModify&qid=$qid", $dbi);
}


/*********************************************************/
/* Quiz Act Functions                                    */
/*********************************************************/

if (!isset($act))
{
    QuizAdmin();
}
else
{
switch($act) {

    case "createPostedQuizQuestion":
    createPostedQuizQuestion();
    break;

    case "modifyPostedQuiz":
    modifyPostedQuiz();
    break;

    case "modifyPostedQuizCategory":
    modifyPostedQuizCategory();
    break;

    case "modifyPostedQuizQuestion":
    modifyPostedQuizQuestion();
    break;

    case "deletePostedScoreQuiz":
    deletePostedScoreQuiz();
    break;

    case "removePostedQuizCategory":
    removePostedQuizCategory();
    break;

    case "removePostedQuiz":
    removePostedQuiz();
    break;

    case "removePostedQuizQuestion":
    removePostedQuizQuestion();
    break;

    case "QuizAddQuestion":
    QuizAddQuestion();
    break;

    case "QuizDelQuestion":
    QuizDelQuestion();
    break;

    case "QuizViewStats":
    QuizViewStats();
    break;

    case "QuizRemoveScore":
    QuizRemoveScore();
    break;

    case "QuizViewScore":
    QuizViewScore();
    break;

    case "QuizRemove":
    QuizRemove();
    break;

    case "createPostedQuiz":
    createPostedQuiz();
    break;

    case "QuizModifyCategory":
    QuizModifyCategory();
    break;

    case "QuizModifyQuestion":
    QuizModifyQuestion();
    break;

    case "QuizModify":
    QuizModify();
    break;

    case "QuizDelCategory":
    QuizDelCategory();
    break;

    case "createPostedQuizCategory":
    createPostedQuizCategory();
    break;

    case "QuizAdd":
    QuizAdd();
    break;

    case "QuizMoveQuestion":
    QuizMoveQuestion($pid, $qid);
    break;
    
    case "MoveQuestions":
    MoveQuestions($qid, $new_qid);
    break;

    case "QuizMoveQuestionConfirm":
    QuizMoveQuestionConfirm($pid, $qid, $newqid);
    break;

    case "QuizCopyQuestion":
    QuizCopyQuestion($pid);
    break;

    case "QuizCopyQuestionConfirm":
    QuizCopyQuestionConfirm($pid, $newqid);
    break;

    case "QuizAdmin":
    QuizAdmin();
    break;

}
}
}


else
{
    echo "Access Denied";
}

/*********************************************************/
?>
