/*
 * Decompiled with CFR 0.152.
 */
package hhapplet;

import java.applet.Applet;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class ImageCache {
    private Hashtable m_Imagehash = null;
    private Applet m_applet = null;

    public ImageCache(Applet applet) {
        this.m_applet = applet;
        this.m_Imagehash = new Hashtable();
    }

    public String GetImagePrefixName(int n) {
        switch (n) {
            case 0: {
                return "topimage";
            }
            case 1: {
                return "topimageopen";
            }
        }
        return "";
    }

    public synchronized Image GetImage(String string) {
        URL uRL = null;
        boolean bl = true;
        if (string == null) {
            return null;
        }
        try {
            if (string.toLowerCase().startsWith("zip:")) {
                return (Image)this.m_Imagehash.get(string.substring(4, string.length()));
            }
            string = string.replace('|', ':');
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            bl = false;
        }
        if (!bl && this.m_applet != null) {
            try {
                uRL = new URL(this.m_applet.getDocumentBase(), string);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        if (uRL == null) {
            return null;
        }
        Object object = this.m_Imagehash.get(uRL);
        if (object != null && object instanceof Image) {
            return (Image)object;
        }
        if (this.m_applet != null) {
            try {
                object = this.m_applet.getImage(uRL);
            }
            catch (Exception exception) {
                return null;
            }
            if (object != null) {
                this.m_Imagehash.put(uRL, object);
            }
            return (Image)object;
        }
        return null;
    }

    public Image GetGif(String string) {
        return this.GetImage(string + ".gif");
    }

    public Image GetGif(int n) {
        return this.GetGif(n, 0);
    }

    public Image GetGif(int n, int n2) {
        return this.GetGif(this.GetImagePrefixName(n2) + String.valueOf(n));
    }

    public void putImage(String string, long l, Object object) {
        if (object instanceof InputStream) {
            InputStream inputStream = (InputStream)object;
            if (this.m_Imagehash.get(string) == null) {
                try {
                    if (l < 65535L) {
                        int n = (int)l;
                        byte[] byArray = new byte[n];
                        int n2 = inputStream.read(byArray);
                        while (n2 < n) {
                            byte[] byArray2 = new byte[n - n2];
                            int n3 = inputStream.read(byArray2);
                            if (n3 == 0) break;
                            int n4 = 0;
                            while (n4 < n3 && n4 < n - n2) {
                                byArray[n2 + n4] = byArray2[n4];
                                ++n4;
                            }
                            n2 += n3;
                        }
                        if (n == n2) {
                            this.m_Imagehash.put(string, Toolkit.getDefaultToolkit().createImage(byArray));
                            return;
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }
}

