// LocalizeRCDlg.h : header file
//

#pragma once
#include <tchar.h>
#include "afxcmn.h"
#include "afxwin.h"

// CLocalizeRCDlg dialog
class CLocalizeRCDlg : public CDialog
{
// Construction
public:
	CLocalizeRCDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	enum { IDD = IDD_LOCALIZERC_DIALOG };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support


// Implementation
protected:
	HICON hLargeIcon, hSmallIcon;

	// Generated message map functions
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	DECLARE_MESSAGE_MAP()
public:
	// content of rich edit control (input RC)
	CString m_strEdit;

	// filename of resource-file with source language
	CString strInputRC;
	// file of the INI File with IDC and text-strings
	CString strLangINI;
	// filename of the generated RC
	CString strOutputRC;
	
	BOOL m_bCopy;
	LANGID LangID;
	int m_nObsoleteItems;
	CString m_strWorkspace;
	CComboBox m_CtrlLanguage;

	// checks if line contents strings that have to be translated
	bool MustBeTranslated(CString strLine, CString strKeyword);
	// search for '"' that is not a quotation mark inside the text ("")
	int FindQuote(CString strLine, int nStartPos=0);
	int WriteReadIni(bool bWrite);
	
	CString ExtractCaption(CString& strText, int* pnPosition, CString strKeyword, CString &strIDC);
	static CString GetFolder(CString strPath);

	afx_msg void OnBnClickedNewWorkspace();
	afx_msg void OnBnClickedChngWorkspace();
	afx_msg void OnBnClickedModifyworkspace();
	
	afx_msg void OnBnClickedReverseini();

	afx_msg void OnCbnSelchangeLanguage();
	afx_msg void OnDestroy();
	afx_msg void OnBnClickedCreateini();
	afx_msg void OnBnClickedOpenini();
	afx_msg void OnBnClickedCreateoutput();

	BOOL OpenCreateWorkspaceDlg(BOOL bOpen);
	void OpenInputRC(void);
	BOOL LoadWorkspace(void);
	BOOL SaveWorkspace(void);
	CString GetAbsolutePathFromIni(CIniEx* pIniEx, CString strKey, CString strPath);
	CString m_strDetails;
	
	static int AddLanguage(CComboBox* pComboBox, LPCTSTR strLangCode, LANGID SelectedID);
	static CString StringTokenize(CString strSource, LPCTSTR strDelimiters, int* pnStart);
	static int FindSeperateWord(CString strText, LPCTSTR strWord, int nStartPos);

	static int StringSpanIncluding( LPCTSTR pszBlock, LPCTSTR pszSet ) throw()
	{
		return (int)_tcsspn( ( pszBlock ), ( pszSet ) );

	}

	static int StringSpanExcluding( LPCTSTR pszBlock, LPCTSTR pszSet ) throw()
	{
		return (int)_tcscspn( ( pszBlock ), ( pszSet ) );
	}
	CString m_strTextmode;
	afx_msg void OnCbnSelchangeObsItems();
	afx_msg void OnBnKillfocusCopy();
	afx_msg void OnBnKillfocusNosort();

	BOOL m_bNoSort;	
};
