// CreateWorkspace.cpp : implementation file
//

#include "stdafx.h"
#include "LocalizeRC.h"
#include "CreateWorkspace.h"


// CCreateWorkspace dialog

IMPLEMENT_DYNAMIC(CCreateWorkspace, CDialog)
CCreateWorkspace::CCreateWorkspace(CWnd* pParent /*=NULL*/)
	: CDialog(CCreateWorkspace::IDD, pParent)
	, m_strInputRC(_T(""))
	, m_strLangINI(_T(""))
	, m_strOutputRC(_T(""))
{
}

CCreateWorkspace::~CCreateWorkspace()
{
}

void CCreateWorkspace::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_INPUTRC, m_strInputRC);
	DDX_Text(pDX, IDC_LANGINI, m_strLangINI);
	DDX_Text(pDX, IDC_OUTPUTRC, m_strOutputRC);
}


BEGIN_MESSAGE_MAP(CCreateWorkspace, CDialog)
	ON_BN_CLICKED(IDC_CHNG_INPUTRC, OnBnClickedChngInputrc)
	ON_BN_CLICKED(IDC_CHNG_LANGINI, OnBnClickedChngLangini)
	ON_BN_CLICKED(IDC_CHNG_OUTPUTRC, OnBnClickedChngOutputrc)
	ON_BN_CLICKED(IDOK, OnBnClickedOk)
END_MESSAGE_MAP()


// CCreateWorkspace message handlers

void CCreateWorkspace::OnBnClickedChngInputrc()
{
	// Change Input RC
	UpdateData( true );
	OpenSaveDialog( true, IDS_EXTRC, IDS_EXTRCDESCRIPTION, m_strInputRC );
	UpdateData( false );
}

void CCreateWorkspace::OnBnClickedChngLangini()
{
	// Change Lang INI
	UpdateData( true );
	OpenSaveDialog( false, IDS_EXTINI, IDS_EXTINIDESCRIPTION, m_strLangINI );
	UpdateData( false );
}

void CCreateWorkspace::OnBnClickedChngOutputrc()
{
	// Change Output RC
	UpdateData( true );
	OpenSaveDialog( false, IDS_EXTRC, IDS_EXTRCDESCRIPTION, m_strOutputRC );
	UpdateData( false );
}

BOOL CCreateWorkspace::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Load Workspace
	CIniEx IniEx;
	if( !IniEx.Open( strWorkspace ) )
		return false;

	m_strInputRC = IniEx.GetValue( ENT_INPUTRC );
	m_strLangINI = IniEx.GetValue( ENT_LANGINI );
	m_strOutputRC = IniEx.GetValue( ENT_OUTPUTRC );

	UpdateData( false );

	return TRUE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

BOOL CCreateWorkspace::OpenSaveDialog(bool bOpen, UINT nExtID, UINT nExtDescriptionID, CString& strEdit)
{
	CString strExtension, strExtensionInfo;
	strExtension.LoadString( nExtID );
	strExtensionInfo.LoadString( nExtDescriptionID ); 

	// Change Output RC
#if _MFC_VER >= 0x0700
	CFileDialog FileDialog( bOpen, strExtension, NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT|OFN_EXPLORER|OFN_ENABLESIZING,
							strExtensionInfo, this, 0 );
#else
	CFileDialog FileDialog( bOpen, strExtension, NULL, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT|OFN_EXPLORER|OFN_ENABLESIZING,
							strExtensionInfo, this );
#endif

	_tcscpy( FileDialog.m_ofn.lpstrFile, strEdit );

	if( FileDialog.DoModal() == IDOK )
	{
		// change to relative path
		TCHAR szOut[MAX_PATH] = _T("");
		if( !PathRelativePathTo( szOut, strWorkspace, FILE_ATTRIBUTE_NORMAL, FileDialog.GetPathName(), FILE_ATTRIBUTE_NORMAL ) )
			_tcscpy( szOut, FileDialog.GetFileName() );
		
		strEdit = szOut;
		return true;
	}
	
	return false;
}

void CCreateWorkspace::OnBnClickedOk()
{
	UpdateData( true );

	// Load Workspace
	CIniEx IniEx;
	if( !IniEx.Open( strWorkspace ) )
		return;

	IniEx.SetValue( ENT_INPUTRC, m_strInputRC);
	IniEx.SetValue( ENT_LANGINI, m_strLangINI);
	IniEx.SetValue( ENT_OUTPUTRC, m_strOutputRC);
	
	// save changes
	IniEx.WriteFile();

	OnOK();
}
