%include "util.mac"
%include "vxdn.inc"
%include "icedump.inc"


extern sdata


		BITS 32


;
; global Definitions
;
;---- Functions ----
global CheckChar
global CharUpper
global CharLower
global ExtractNamePos
global AlignOffset
global ZeroPad
global Dword2Hex
global Byte2Hex
global Hex2Dec
global strcmp
global strlen
global strcat
global strcopy
global ScanForIt


;
; data Definition.
;
SEGMENT _LDATA
HTable	DB '0123456789ABCDEF',0


;
; Code Definition.
;

SEGMENT _LTEXT

;
; Check Char
;

;
;
;
CheckChar:
	push	ebp
	mov	ebp, esp
	push	edi
	push	esi
	push	ecx

	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: CheckChar: failed to install exception handler"
	debug_end

@@
	mov	eax, [ebp+08h]
	test	eax, eax
	jz	.free_eh

	xor	ecx, ecx
	mov	edi, [ebp+0Ch]

.LoopChar:
.protect_start:
	cmp	[edi+ecx], al
.protect_end:

	jz	short .ReturnECX

	inc	ecx
	cmp	ecx, [ebp+10h]
	jnz	short .LoopChar

.ReturnECX:
	inc	ecx
	mov	eax, ecx
	jmp	short .free_eh

.EH:
	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: CheckChar: exception, EDI:ECX: #edi:#ecx"
	debug_end

	xor	eax,eax

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: CheckChar: failed to uninstall exception handler"
	debug_end

@@
	pop	ecx
	pop	esi
	pop	edi
	pop	ebp
	retn	0Ch


segment _LDATA
	align 4
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd CheckChar.protect_start
	at EHS_End_EIP,		dd CheckChar.protect_end
	at EHS_Handler,		dd CheckChar.EH
iend


segment _LTEXT

;
; CharLower.
; CharUpper.
;

;
;ebp+8 : String.
;
;eax= pos of filename
;
CharLower:
	push	ebp
	mov	ebp, esp
	pushad

	mov	bl, 'a'-'A'
	mov	cl, 'A'
	mov	dl, 'Z'
	jmp	short CharCase

CharUpper:
	push	ebp
	mov	ebp, esp
	pushad

	mov	bl, 'A'-'a'
	mov	cl, 'a'
	mov	dl, 'z'

CharCase:
	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: CharCase: failed to install exception handler"
	debug_end

@@
	mov	esi, [ebp+08h]
	mov	edi, esi

.protect_start:
.LoopUp:
	lodsb
	test	al, al
	jz	.free_eh

	cmp	al, cl
	jl	.StosbIt

	cmp	al, dl
	jg	.StosbIt

	add	al, bl

.StosbIt:
	stosb
	jmp	short .LoopUp
.protect_end:

.EH:
	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: CharCase: exception, ESI: #esi, EDI: #edi"
	debug_end

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: CharCase: failed to uninstall exception handler"
	debug_end

@@
	popad
	pop	ebp
	retn	04h


segment _LDATA
	align 4
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd CharCase.protect_start
	at EHS_End_EIP,		dd CharCase.protect_end
	at EHS_Handler,		dd CharCase.EH
iend


;
; Find position of FileName from a full path.
;

;
;ebp+8 : Full path.
;
;eax= pos of filename
;
ExtractNamePos:
	push	ebp
	mov	ebp, esp
	push	esi

	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: ExtractNamePos: failed to install exception handler"
	debug_end

@@
	mov	esi, [ebp+08h]
	push	esi
	Call	strlen

.LoopFindTrail:
	dec	eax
	jl	.free_eh

.protect_start:
	cmp	byte [esi+eax], '\'
.protect_end:

	jnz	.LoopFindTrail
	jmp	short .free_eh

.EH:
	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: ExtractNamePos: exception, ESI:EAX: #esi#eax"
	debug_end

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: ExtractNamePos: failed to uninstall exception handler"
	debug_end

@@
	inc	eax

	pop	esi
	pop	ebp
	retn	04h


segment _LDATA
	align 4
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd ExtractNamePos.protect_start
	at EHS_End_EIP,		dd ExtractNamePos.protect_end
	at EHS_Handler,		dd ExtractNamePos.EH
iend


segment _LTEXT

;
; Align the Dword to the Alignment Value.
;

;
;ebp+8 : Value to Convert.
;ebp+c : Desired Alignment
;
AlignOffset:
	push	ebp
	mov	ebp, esp
	push	ecx

	mov	eax, [ebp+08h]
	mov	ecx, [ebp+0Ch]
	dec	ecx
	add	eax, ecx
	not	ecx
	and	eax, ecx

	pop	ecx
	pop	ebp
	retn	08h
;
; Set Zero in a range.
;
;
;ebp+8: Start
;ebp+C: End
;
ZeroPad:
	push	ebp
	mov	ebp, esp
	push	edi
	push	esi
	push	ecx
	push	eax

	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: ZeroPad: failed to install exception handler"
	debug_end

@@
	mov	edi, [ebp+08h]
	mov	ecx, [ebp+0Ch]
	sub	ecx, edi
	xor	eax, eax

.protect_start:
	rep	stosb
.protect_end:

	jmp	short .free_eh

.EH:
	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: ZeroPad: exception, EDI: #edi"
	debug_end

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: ZeroPad: failed to uninstall exception handler"
	debug_end

@@
	pop	eax
	pop	ecx
	pop	esi
	pop	edi
	pop	ebp
	retn	08h


segment _LDATA
	align 4
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd ZeroPad.protect_start
	at EHS_End_EIP,		dd ZeroPad.protect_end
	at EHS_Handler,		dd ZeroPad.EH
iend


segment _LTEXT

;
; Convert a Dword to its Hex String.
;

;
;ebp+8 : Value to Convert.
;ebp+C : Buffer where to Store.
;
Dword2Hex:
	push	ebp
	mov	ebp, esp
	push	edi
	push	esi
	push	ecx
	push	ebx

	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: Dword2Hex: failed to install exception handler"
	debug_end

@@
	mov	ebx, [ebp+08h]
	mov	edi, [ebp+0Ch]

;	mov	ecx,4
	push	byte 4
	pop	ecx

.Convert_it:
	rol	ebx,8      ; rotate 8 bits
	movzx	eax,bl
	shr	al,4
	mov	al,[eax+HTable]

	movzx	esi,bl
	and	esi,byte 0Fh
	mov	ah,[esi+HTable]

.protect_start:
	stosw
.protect_end:

	dec	ecx
	jnz	.Convert_it
	jmp	short .free_eh

.EH:
	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: Dword2Hex: exception, EDI: #edi"
	debug_end

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: Dword2Hex: failed to uninstall exception handler"
	debug_end

@@
	pop	ebx
	pop	ecx
	pop	esi
	pop	edi
	pop	ebp
	retn	08h


segment _LDATA
	align 4
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd Dword2Hex.protect_start
	at EHS_End_EIP,		dd Dword2Hex.protect_end
	at EHS_Handler,		dd Dword2Hex.EH
iend


segment _LTEXT

Byte2Hex:
	push	ebp
	mov	ebp, esp
	pushad

	mov	[.ESP],esp

	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: Byte2Hex: failed to install exception handler"
	debug_end

@@
	movzx	eax, byte [ebp+08h]
	mov	edi, [ebp+0Ch]

	push	eax
	shr	eax, 4
	push	eax
	mov	al, [HTable+eax]
	cmp	al, 30h
	jz	.NoWriteStore

.protect_start:
	stosb

.NoWriteStore:
	pop	eax
	pop	ebx
	shl	eax, 4
	sub	ebx, eax
	mov	al, [HTable+ebx]
	stosw
.protect_end:

	jmp	short .free_eh

.EH:
	mov	esp,[.ESP]

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: Byte2Hex: exception, EDI: #edi"
	debug_end

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: Byte2Hex: failed to uninstall exception handler"
	debug_end

@@
	popad
	pop	ebp
	retn	08h


segment _LDATA
	align 4
.ESP:	dd 0
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd Byte2Hex.protect_start
	at EHS_End_EIP,		dd Byte2Hex.protect_end
	at EHS_Handler,		dd Byte2Hex.EH
iend


segment _LTEXT

;
; Convert an hexstring to dword value.
;

;
;ebp+8 : String hex To convert
;
;eax=HEX value
;
Hex2Dec:
	push	ebp
	mov	ebp, esp
	push	esi
	push	edx

	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: Hex2Dec: failed to install exception handler"
	debug_end

@@
	mov	esi, [ebp+08h]
	xor	edx, edx

.HexConvert:
	xor	eax, eax

.protect_start:
	lodsb
.protect_end:

	test	eax, eax
	jz	.free_eh

	sub	al, '0'
	cmp	al, 9h
	jle	.WasDigit

	sub	al, 'A'-('0'+0Ah)

.WasDigit:
	shl	edx, 4
	add	edx, eax
	jmp	short .HexConvert

.EH:
	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: Hex2Dec: exception, ESI: #esi"
	debug_end

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: Hex2Dec: failed to uninstall exception handler"
	debug_end

@@
	mov	eax, edx

	pop	edx
	pop	esi
	pop	ebp
	retn	04h


segment _LDATA
	align 4
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd Hex2Dec.protect_start
	at EHS_End_EIP,		dd Hex2Dec.protect_end
	at EHS_Handler,		dd Hex2Dec.EH
iend


segment _LTEXT

;
; Compare Two String.
;

;
;ebp+8 : String 1
;ebp+C : String 2
;
;eax=0 on success, 1 otherwise.
;
strcmp:
	push	ebp
	mov	ebp, esp
	push	esi
	push	edi

	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: strcmp: failed to install exception handler"
	debug_end

@@
	mov	esi, [ebp+08h]
	mov	edi, [ebp+0Ch]
	xor	eax, eax

.CmpStr:
.protect_start:
	lodsb
	scasb
.protect_end:

	jnz	.notequal

	test	eax, eax
	jnz	.CmpStr

	jmp	short .free_eh

.notequal:
	xor	eax, eax
	inc	eax
	jmp	short .free_eh

.EH:
	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: strcmp: exception, ESI: #esi, EDI: #edi"
	debug_end

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: strcmp: failed to uninstall exception handler"
	debug_end

@@
	pop	edi
	pop	esi
	pop	ebp
	retn	08h


segment _LDATA
	align 4
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd strcmp.protect_start
	at EHS_End_EIP,		dd strcmp.protect_end
	at EHS_Handler,		dd strcmp.EH
iend


segment _LTEXT

;
; Compute string length.
;

;
;ebp+8 : String
;
;eax=size on success, 0 otherwise.
;
strlen:
	push	ebp
	mov	ebp, esp
	push	esi
	push	edi
	push	ecx

	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: strlen: failed to install exception handler"
	debug_end

@@
	mov	edi,[ebp+08h]
	xor	ecx, ecx
	dec	ecx
	mov	al,0
	cld

.protect_start:
	repnz	scasb
.protect_end:

	not	ecx
	mov	eax, ecx
	jmp	short .free_eh

.EH:
	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: strlen: exception, EDI: #edi"
	debug_end

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: strlen: failed to uninstall exception handler"
	debug_end

@@
	pop	ecx
	pop	edi
	pop	esi
	pop	ebp
	retn	04h


segment _LDATA
	align 4
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd strlen.protect_start
	at EHS_End_EIP,		dd strlen.protect_end
	at EHS_Handler,		dd strlen.EH
iend


segment _LTEXT

strcopy:
	push	ebp
	mov	ebp, esp
	push	edi
	push	esi
	push	eax

	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: strcopy: failed to install exception handler"
	debug_end

@@
	mov	esi, [ebp+08h]
	mov	edi, [ebp+0Ch]
	xor	eax, eax

.LoopCopy:
.protect_start:
	lodsb
	stosb
.protect_end:
 	test	eax, eax
	jnz	.LoopCopy

	jmp	short .free_eh

.EH:
	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: strcopy: exception, ESI: #esi, EDI: #edi"
	debug_end

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: strcopy: failed to uninstall exception handler"
	debug_end

@@
	pop	eax
	pop	esi
	pop	edi
	pop	ebp
	retn	08


segment _LDATA
	align 4
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd strcopy.protect_start
	at EHS_End_EIP,		dd strcopy.protect_end
	at EHS_Handler,		dd strcopy.EH
iend


segment _LTEXT

strcat:
	push	ebp
	mov	ebp, esp
	pushad

	mov	esi, dword [ebp+08h]
	push	esi
	Call	strlen
	lea	esi, [esi+eax-1]

	push	esi
	push	dword [ebp+0Ch]
	Call	strcopy

	popad
	pop	ebp
	retn	08h

;
; Scan for a given string.
;

;
;ebp+8 : String
;ebp+c : Length
;ebp+10: Pattern AZT
;
;eax=Position on success, 0 otherwise.
;
ScanForIt:
	push	ebp
	mov	ebp, esp
	sub	esp, 4
	push	esi
	push	edi
	push	ecx

	mov	[.ESP],esp

	mov	esi,.EHS
	VMMCall	Install_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: ScanForIt: failed to install exception handler"
	debug_end

@@
	mov	esi, [ebp+10h]
	xor	eax, eax
	mov	[ebp-4], eax

.LoopCount:
.protect_start:
	lodsb
	inc	dword [ebp-4]
	test	eax, eax
	jnz	.LoopCount

	mov	ecx, [ebp+0Ch]
	mov	esi, [ebp+08h]
	mov	edi, [ebp+10h]
	push	esi
	push	ecx

.LoopCmp:
	lodsb
	scasb
	jnz	.IncBuff

	cmp	byte [edi], 0
.protect_end:

	jnz	.LoopCmp

	pop	ecx
	pop	esi
	mov	eax, esi
	jmp	short .free_eh

.IncBuff:
	pop	ecx
	pop	esi
	inc	esi
	dec	ecx
	xor	eax, eax
	cmp	ecx, [ebp-4]	; jecxz EndScanForIt
	jl	.free_eh

	mov	edi, [ebp+10h]
	push	esi
	push	ecx
	jmp	short .LoopCmp

.EH:
	mov	esp,[.ESP]

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: ScanForIt: exception, ESI: #esi, EDI: #edi"
	debug_end

.free_eh:
	mov	esi,.EHS
	cmp	dword [esi+EHS_Reserved],byte 0
	jz	@F

	VMMCall	Remove_Exception_Handler
	jnc	@F

	debug_start debugflags, ICEDUMP_DEBUG_COMMON
	Trace_Out "ICEDUMP: ScanForIt: failed to uninstall exception handler"
	debug_end

@@
	pop	ecx
	pop	edi
	pop	esi
	leave
	retn	0ch


segment _LDATA
	align 4
.ESP:	dd 0
.EHS:
istruc Exception_Handler_Struc
	at EHS_Reserved,	dd 0
	at EHS_Start_EIP,	dd ScanForIt.protect_start
	at EHS_End_EIP,		dd ScanForIt.protect_end
	at EHS_Handler,		dd ScanForIt.EH
iend
