DestDir="."
mode=""
defbar off
;BLACK,WHITE,WHITE,BLACK,14,7,52
clrscr

; AV validation
if AVPresent == -1
      Title="Warning"
      Message="Invalid authenticity information"
      call ErrMsg
endif

if AVPresent == 0
      Title="Warning"
      Message="Missing authenticity information"
      call ErrMsg
endif

Again:

; Main background
setcolor GREEN,WHITE
window 1,1,80,25
clrscr 219
; Main window
window 1,1,80,25

; AV info
box 3,3,77,8,YELLOW,BLUE,SINGLE
setcolor YELLOW,BLUE
gotoxy 31,3
text " Patch information "
setcolor DARKGRAY,BLACK
window 5,9,78,9
clrscr 177
window 78,4,78,9
clrscr 177
window 4,4,76,7
setcolor WHITE,BLUE
clrscr
; Fields
gotoxy 1,1
text "  Valid  patch name:   "
gotoxy 1,2
text "  Actual patch name:   "
gotoxy 1,3
text "  Patch date:          "
gotoxy 1,4
text "  Created by:          "
; Values
setcolor WHITE,BLUE
gotoxy 26,1
if AVArcName!="AVArcName"
    text AVArcName
endif
gotoxy 26,2
text ArcName
gotoxy 26,3
if AVDate!="AVDate"
    text "released ",AVDate
endif
gotoxy 26,4
if AVUserName!="AVUserName"
    text AVUserName
endif

window 1,1,80,25
; Bottom line
setcolor LIGHTCYAN,DARKGRAY
gotoxy 1,25
text "                         Press F1 for help, Alt-X to exit                       "

; Shadow on the meadow
setcolor DARKGRAY,BLACK
window 25,18,56,19
clrscr 177
window 54,11,56,19
clrscr 177
window 1,1,80,25

; Sound on the same meadow
sound 90,1

; Installation Menu:

Menu:

Choice = menu 25,10,BLACK,WHITE,1,"Patch application menu"," Help with this menu","Scan for patch targets","  List patch actions","   Apply the patch", "         Exit"

if Choice==0
   goto Quit
endif

if Choice==1
   call OutHelp
   goto Menu
endif


if Choice==2
   mode="-t"
   install     
endif

if Choice==3
   mode="-l"
   install
   goto Again
endif

if Choice==4
   mode=""
   install
   goto Again
endif

if Choice==5
Quit:
     setcolor WHITE,BLACK
     clrscr
     gotoxy 2,3
     text "The patch has NOT been applied."
     sound 380,25
     delay 210
     sound 190,25
     exit 1
     goto Menu
endif

proc OnKey
     window 1,1,80,25
     if Par1 == 3
          savescr 15
          Par1=-1
          sound 2300,25
          delay 100
          sound 1450,100
          Choice=Menu 22,11,WHITE,LIGHTRED,1,"Ctrl-Break","             Abort           ","   Continue operation  "
          if Choice == 1
               exit 1
          endif
          restscr 15
     endif

     if Par1 == 301
           goto Quit
     endif

     if Par1 == 315
          savescr 15
          call OutHelp
          Par1=-1
          restscr 15
     endif
endp

proc Error
     window 7,12,75,23
     setcolor LIGHTCYAN,BLUE
     gotoxy 1,inswrow

     Title="Error"

     ; Par1 is assigned with error code:

     if Par1 == 1
           Message="Fatal error"
           call ErrMsg
     endif

     if Par1 == 2
           Message="CRC error, broken archive"
           call ErrMsg
     endif

     if Par1 == 3
           Message="Write error"
           call ErrMsg
     endif

     if Par1 == 4
           Message="File create error"
           call ErrMsg
     endif

     if Par1 == 5
           Message="Read error"
           call ErrMsg
     endif

     if Par1 == 6
           Message="File close error"
           call ErrMsg
     endif

     if Par1 == 7
           Message="File open error"
           call ErrMsg
     endif

     if Par1 == 8
           Message="Not enough memory"
           call ErrMsg
     endif

     if inswrow = 12
           text "\n"
     endif

     if inswrow < 12
           inswrow=inswrow+1
     endif
     window 1,1,80,25
endp

proc ErrMsg
     window 17,14,62,21
     setcolor WHITE,RED
     clrscr
     window 1,1,80,25
     box 20,15,59,20,WHITE,RED,DOUBLE
     gotoxy 1,15
     ctext " ",Title," "
     gotoxy 1,17
     ctext Message
     setcolor WHITE,BLACK
     gotoxy 1,19
     ctext " Ok "
     sound 20,5
     sound 80,50
     delay 15000
     window 1,1,80,25
endp

proc OutHelp
     savescr 1
FirstPage:
     window 1,1,80,25
     setcolor LIGHTCYAN,BLUE
     clrscr
     box 1,1,80,25,LIGHTCYAN,BLUE,DOUBLE
     gotoxy 8,25
     ctext " Press PgDn for the second page or Esc for menu... "
     gotoxy 1,1
     ctext " Help for patching "
     gotoxy 1,2

     window 2,2,79,24
     outtext on

Welcome!

This program is actually a patch generated using BinPatch. It will guide you
through applying itself automatically to your software.

Select "Scan for patch targets" in main menu (the one you chose to get this
help) you will see it a scan procedure of your harddisks. When finding
possible targets it will tell you so and if not it will also.

Select "List patch actions" you will find the some stats about the patch and
listed what this patch actually does. It is recommended that you do this
before really applying the patch on your system.

Select "Apply the patch" and it will scan for targets and prompt you with
each it finds, wether to apply the patch or not. Only choosing 'y' there
actually changes the files, you can still skip with 'n' at that time.

Hope you find this comfortable and note that this patching system is also
the most efficient as known today and free for non-commercial application,
so you may generate your patches too.
     outtext off

     window 2,2,80,25
     setcolor YELLOW,BLUE
     sound 140,5
     outtext on
     outtext off
GetKey1:
     Key=getkey
     if Key==27
           restscr 1
           goto Ende
     endif
     if Key==337
SecondPage:
          window 1,1,80,25
          setcolor LIGHTCYAN,BLUE
          clrscr
          box 1,1,80,25,LIGHTCYAN,BLUE,DOUBLE
          gotoxy 8,25
          ctext " Press PgUp for first page or Esc for menu ..."
          window 2,2,80,25
          setcolor YELLOW,BLUE
          gotoxy 1,1
          sound 145,5
          outtext on
          outtext off
GetKey2:
          Key=getkey
          if Key==27
                restscr 1
                goto Ende
          endif
          if Key == 329
               goto FirstPage
          endif
          goto GetKey2
     endif
     goto GetKey1

Ende:
endp

proc ArcDone
   call DoPatch

   window 1,1,80,25
   gotoxy 1,24

   text 

   if mode==""
      if value!="0" then
         setcolor RED,BLACK
         outtext on
An error occured, seems that patch was not applicable. Check the reason
given above.
         outtext off
      endif
      if value=="0" then
         setcolor GREEN,BLACK
         text "Patch has been successfully applied. Have fun with your enhanced software."
      endif

   endif
   if mode!=""
      setcolor GREEN,BLACK
      text "Please restart patch to continue."
   endif
endp

proc DoPatch
   setcolor WHITE,BLACK
   window 1,1,80,25
   clrscr

   value=exec "ThePatch.EXE ", mode
;   system "del ",DoPatchSFX.EXE
;   system "del ",ThePatch.UTP
endp

