// WindowDlg.cpp : implementation file
//

#include "stdafx.h"
#include "vcsample.h"
#include "WindowDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWindowDlg dialog


CWindowDlg::CWindowDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWindowDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWindowDlg)
	m_strWindowType = _T("");
	m_strReturnValue = _T("");
	//}}AFX_DATA_INIT
}


void CWindowDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWindowDlg)
	DDX_Text(pDX, IDC_WindowType, m_strWindowType);
	DDX_Text(pDX, IDC_ReturnValue, m_strReturnValue);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CWindowDlg, CDialog)
	//{{AFX_MSG_MAP(CWindowDlg)
	ON_BN_CLICKED(IDC_GetWindowType, OnGetWindowType)
	ON_BN_CLICKED(IDC_SetWindowType, OnSetWindowType)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWindowDlg message handlers

void CWindowDlg::OnGetWindowType() 
{
	// Get the specified window type
	UpdateData(TRUE);
	HH_WINTYPE *phhwt = NULL;
	HWND hWndHelp = HtmlHelp(NULL,m_strWindowType,HH_GET_WIN_TYPE,(DWORD)&phhwt);

	if (phhwt) {
		// Dump its contents to the debugger
		TRACE("cbStruct %d\r\n",phhwt->cbStruct);
		TRACE("fUniCodeStrings %d\r\n",phhwt->fUniCodeStrings);
		TRACE("pszType '%s'\r\n",phhwt->pszType);
		TRACE("fsValidMembers 0x%x\r\n",phhwt->fsValidMembers);
		TRACE("fsWinProperties 0x%x\r\n",phhwt->fsWinProperties);
		TRACE("pszCaption '%s'\r\n",phhwt->pszCaption);
		TRACE("dwStyles 0x%x\r\n",phhwt->dwStyles);
		TRACE("dwExStyles 0x%x\r\n",phhwt->dwExStyles);
		TRACE("rcWindowPos %d,%d,%d,%d\r\n",phhwt->rcWindowPos.top,
		  phhwt->rcWindowPos.left,phhwt->rcWindowPos.right,phhwt->rcWindowPos.bottom);
		TRACE("nShowState %d\r\n",phhwt->nShowState);
		TRACE("hwndHelp 0x%x\r\n",phhwt->hwndHelp);
		TRACE("hwndCaller 0x%x\r\n",phhwt->hwndCaller);
		TRACE("paInfoTypes 0x%x\r\n",phhwt->paInfoTypes);
		TRACE("hwndToolBar 0x%x\r\n",phhwt->hwndToolBar);
		TRACE("hwndNavigation 0x%x\r\n",phhwt->hwndNavigation);
		TRACE("hwndHTML 0x%x\r\n",phhwt->hwndHTML);
		TRACE("iNavWidth %d\r\n",phhwt->iNavWidth);
		TRACE("rcHTML %d,%d,%d,%d\r\n",phhwt->rcHTML.top,
		  phhwt->rcHTML.left,phhwt->rcHTML.right,phhwt->rcHTML.bottom);
		TRACE("pszToc '%s'\r\n",phhwt->pszToc);
		TRACE("pszIndex '%s'\r\n",phhwt->pszIndex);
		TRACE("pszFile '%s'\r\n",phhwt->pszFile);
		TRACE("pszHome '%s'\r\n",phhwt->pszHome);
		TRACE("fsToolBarFlags 0x%x\r\n",phhwt->fsToolBarFlags);
		TRACE("fNotExpanded %d\r\n",phhwt->fNotExpanded);
		TRACE("curNavType %d\r\n",phhwt->curNavType);
		TRACE("tabpos %d\r\n",phhwt->tabpos);
		TRACE("idNotify %d\r\n",phhwt->idNotify);
		//    tabOrder(HH_MAX_TABS) As Byte);
		TRACE("cHistory %d\r\n",phhwt->cHistory);
		TRACE("pszJump1 '%s'\r\n",phhwt->pszJump1);
		TRACE("pszJump2 '%s'\r\n",phhwt->pszJump2);
		TRACE("pszUrlJump1 '%s'\r\n",phhwt->pszUrlJump1);
		TRACE("pszUrlJump2 '%s'\r\n",phhwt->pszUrlJump2);
		TRACE("rcMinSize %d,%d,%d,%d\r\n",phhwt->rcMinSize.top,
		  phhwt->rcMinSize.left,phhwt->rcMinSize.right,phhwt->rcMinSize.bottom);
		TRACE("cbInfoTypes %d\r\n",phhwt->cbInfoTypes);
	}

	// Display the return value
	m_strReturnValue.Format("Return Value: 0x%xlx\r\n",hWndHelp);
	UpdateData(FALSE);
}

void CWindowDlg::OnSetWindowType() 
{
	// Get the specified window type
	UpdateData(TRUE);
	HH_WINTYPE *phhwt = NULL;
	HWND hWndHelp = HtmlHelp(NULL,m_strWindowType,HH_GET_WIN_TYPE,(DWORD)&phhwt);

	if (phhwt) {
		HH_WINTYPE hhwt;

		// Copy the returned structure
		// NOTE: DO NOT MODIFY THE RETURNED STRUCTURE!!
		memcpy(&hhwt,phhwt,min(sizeof(hhwt),phhwt->cbStruct));

		// Reset members to enable notification messages
		hhwt.cbStruct = sizeof(hhwt);
		hhwt.fsValidMembers = HHWIN_PARAM_PROPERTIES;
		hhwt.fsWinProperties |= HHWIN_PROP_TRACKING;
		hhwt.idNotify = ID_HtmlHelpWindow;
		hhwt.hwndCaller = AfxGetMainWnd()->GetSafeHwnd();

		// Set it
		hWndHelp = HtmlHelp(NULL,NULL,HH_SET_WIN_TYPE,(DWORD)&hhwt);
	}

	// Display the return value
	m_strReturnValue.Format("Return Value: 0x%xlx\r\n",hWndHelp);
	UpdateData(FALSE);
}
