// SearchDlg.cpp : implementation file
//

#include "stdafx.h"
#include "vcSample.h"
#include "SearchDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSearchDlg dialog


CSearchDlg::CSearchDlg(LPCSTR pszFile, CWnd* pParent /*=NULL*/)
	: CDialog(CSearchDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSearchDlg)
	m_bIndexOnFail = FALSE;
	m_strKeywords = _T("");
	m_strMsgText = _T("");
	m_strMsgTitle = _T("");
	m_strUrl = _T("");
	m_strWindow = _T("");
	m_iCommand = 0;
	//}}AFX_DATA_INIT
	m_pszFile = pszFile;
}


void CSearchDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSearchDlg)
	DDX_Control(pDX, IDC_ReturnValue, m_ctlReturnValue);
	DDX_Check(pDX, IDC_IndexOnFail, m_bIndexOnFail);
	DDX_Text(pDX, IDC_Keywords, m_strKeywords);
	DDX_Text(pDX, IDC_MsgText, m_strMsgText);
	DDX_Text(pDX, IDC_MsgTitle, m_strMsgTitle);
	DDX_Text(pDX, IDC_Url, m_strUrl);
	DDX_Text(pDX, IDC_Window, m_strWindow);
	DDX_Radio(pDX, IDC_HH_KEYWORD_LOOKUP, m_iCommand);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSearchDlg, CDialog)
	//{{AFX_MSG_MAP(CSearchDlg)
	ON_BN_CLICKED(IDC_SearchNow, OnSearchNow)
	ON_WM_CONTEXTMENU()
	ON_WM_HELPINFO()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSearchDlg message handlers

void CSearchDlg::OnSearchNow() 
{
    UpdateData();

	UINT uCommand;
	if (m_iCommand == 0) {
		uCommand = HH_KEYWORD_LOOKUP;
	} else {
		uCommand = HH_ALINK_LOOKUP;
	}

	HH_AKLINK hhak;
	memset(&hhak,0,sizeof(hhak));
    hhak.cbStruct = sizeof(hhak);
    if (!m_strKeywords.IsEmpty()) {
        hhak.pszKeywords = m_strKeywords;
	}
    if (!m_strUrl.IsEmpty()) {
        hhak.pszUrl = m_strUrl;
	}
    if (!m_strMsgText.IsEmpty()) {
        hhak.pszMsgText = m_strMsgText;
	}
    if (!m_strMsgTitle.IsEmpty()) {
        hhak.pszMsgTitle = m_strMsgTitle;
	}
    if (!m_strWindow.IsEmpty()) {
        hhak.pszWindow = m_strWindow;
	}
    hhak.fIndexOnFail = m_bIndexOnFail;
    
    HWND hWndHelp = HtmlHelp(theApp.GetHwndCaller(),
	  theApp.GetPszFile(m_pszFile,m_strWindow),uCommand,(DWORD)&hhak);
    
    // Display the return value
	CString strReturnValue;
	strReturnValue.Format("Return Value: 0x%lx",hWndHelp);
    m_ctlReturnValue.SetWindowText(strReturnValue);
}

static void ShowTextPopup(CWnd *pWnd, CPoint point)
{
	// Try to load a string corresponding to the control ID
	CString strTextPopup;
	if (strTextPopup.LoadString(pWnd->GetDlgCtrlID())) {
		// String loaded, display it as a popup help topic
		HH_POPUP hhp;
		memset(&hhp,0,sizeof(hhp));
		hhp.cbStruct = sizeof(hhp);
		hhp.clrBackground = -1;
		hhp.clrForeground = -1;
		hhp.rcMargins.left = -1;
		hhp.rcMargins.top = -1;
		hhp.rcMargins.bottom = -1;
		hhp.rcMargins.right = -1;
		hhp.pt = point;
		hhp.pszText = strTextPopup;
		hhp.pszFont = NULL;
		HtmlHelp(NULL,NULL,HH_DISPLAY_TEXT_POPUP,(DWORD)&hhp);
	}
}

void CSearchDlg::OnContextMenu(CWnd* pWnd, CPoint point) 
{
	ShowTextPopup(pWnd,point);
}

BOOL CSearchDlg::OnHelpInfo(HELPINFO* pHelpInfo) 
{
	CPoint pt;
	GetCursorPos(&pt);
	ShowTextPopup(CWnd::FromHandle((HWND)pHelpInfo->hItemHandle),pt);
	return(TRUE);
}
