#
#	becky.rb
#
#	Copyright (c) 2000,2001 T.Shimomura/netlife.gr.jp
#	$Id: becky.rb,v 1.10 2002/01/15 18:01:49 redbug Exp $
#

require "kconv"

module Becky
	def version
		BeckyAPI.GetVersion
	end

	def command( cmd )
		BeckyAPI.Command( cmd )
	end

	def handles
		BeckyAPI.GetWindowHandles
	end

	def datafolder
		BeckyAPI.GetDataFolder
	end

	def tempfolder
		BeckyAPI.GetTempFolder
	end

	def message=( msg )
		BeckyAPI.SetMessageText( msg )
	end

	def connect
		BeckyAPI.Connect( true )
	end

	def disconnect
		BeckyAPI.Connect( false )
	end

	def mailboxid
		BeckyAPI.GetCurrentMailBox
	end

	def mailboxid=( mbx )
		BeckyAPI.SetCurrentMailBox( mbx )
	end

	def mailbox
		BkMailBox.new
	end

	def mailbox=( mbx )
		BeckyAPI.SetCurrentMailBox( mbx.mbxid )
	end

	def folderid
		BeckyAPI.GetCurrentFolder
	end

	def folderid=( folder )
		BeckyAPI.SetCurrentFolder( folder )
	end

	def folder
		BkFolder.new
	end

	def folder=( newfolder )
		BeckyAPI.SetCurrentFolder( newfolder.folderid )
	end

	def mailid
		BeckyAPI.GetCurrentMail
	end

	def mailid=( mail )
		BeckyAPI.SetCurrentMail( mail )
	end

	def mail
		BkMail.new
	end

	def mail=( newmail )
		BeckyAPI.SetCurrentMail( newmail.mailid )
	end

	def encode( src, code )
		case code
			when "ISO-2022-JP"
				BeckyAPI.ISO_2022_JP( src, true )
			when "ISO-2022-KR"
				BeckyAPI.ISO_2022_KR( src, true )
			when "HZ-GB-2312"
				BeckyAPI.HZ_GB2312( src, true )
			when "ISO-8859-2"
				BeckyAPI.ISO_8859_2( src, true )
			when "EUC-JP"
				BeckyAPI.EUC_JP( src, true )
			when "UTF-7"
				BeckyAPI.UTF_7( src, true )
			when "UTF-8"
				BeckyAPI.UTF_8( src, true )
		end
	end

	def decode( src, code )
		case code
			when "ISO-2022-JP"
				BeckyAPI.ISO_2022_JP( src, false )
			when "ISO-2022-KR"
				BeckyAPI.ISO_2022_KR( src, false )
			when "HZ-GB-2312"
				BeckyAPI.HZ_GB2312( src, false )
			when "ISO-8859-2"
				BeckyAPI.ISO_8859_2( src, false )
			when "EUC-JP"
				BeckyAPI.EUC_JP( src, false )
			when "UTF-7"
				BeckyAPI.UTF_7( src, false )
			when "UTF-8"
				BeckyAPI.UTF_8( src, false )
		end
	end

	def receive
		BeckyAPI.Command("ReceiveNew")
	end

	def deliver
		BeckyAPI.Command("Deliver")
	end

	def send
		BeckyAPI.Command("Deliver")
	end

	def sendreceive
		BeckyAPI.Command("SendReceive")
	end

	def register( obj , singleton=true, overwrite=true )
		if BeckyAPI.CheckObject( obj ) && singleton then
			if overwrite then
				BeckyAPI.RemoveObject( obj )
			else
				return
			end
		end
		BeckyAPI.RegisterObject( obj )
	end

	def registered_obj
		BeckyAPI.GetObject
	end

end


class BkMailBox
	def initialize( mbxid=BeckyAPI.GetCurrentMailBox )
		@mbxid = mbxid
	end

	def mbxid
		@mbxid
	end

	def folderid
		if @mbxid == BeckyAPI.GetCurrentMailBox then
			BeckyAPI.GetCurrentFolder
		else
			nil
		end
	end

	def folderid=( newfolder )
		BeckyAPI.SetCurrentFolder( newfolder )
	end

	def folder
		if @mbxid == BeckyAPI.GetCurrentMailBox then
			BkFolder.new( BeckyAPI.GetCurrentFolder )
		else
			nil
		end
	end

	def folder=( newfolder )
		BeckyAPI.SetCurrentFolder( newfolder.folderid )
	end

	def mailid
		if @mbxid == BeckyAPI.GetCurrentMailBox then
			BeckyAPI.GetCurrentMail
		else
			nil
		end
	end

	def mailid=( newmail )
		BeckyAPI.SetCurrentMail( newmail )
	end

	def mail
		if @mbxid == BeckyAPI.GetCurrentMailBox then
			BkMail.new( BeckyAPI.GetCurrentMail )
		else
			nil
		end
	end

	def mail=( newmail )
		BeckyAPI.SetCurrentMail( newmail.mailid )
	end

	def current?
		return BeckyAPI.GetCurrentMailBox == @mbxid
	end

	def current
		BeckyAPI.SetCurrentMailBox( @mbxid )
	end

	def inbox
		BkFolder.new( @mbxid+"!!!!Inbox\\" )
	end

	def outbox
		BkFolder.new( @mbxid+"!!!!Outbox\\" )
	end

	def draft
		BkFolder.new( @mbxid+"!!!!Outbox\\!!!Draft\\" )
	end

	def sent
		BkFolder.new( @mbxid+"!!!!Outbox\\!!!Sent\\" )
	end

	def reminder
		BkFolder.new( @mbxid+"!!!!Outbox\\!!!XReminder\\" )
	end

	def trash
		BkFolder.new( @mbxid+"!Trash\\" )
	end
end


class BkFolder

include Enumerable

	def initialize( folderid=BeckyAPI.GetCurrentFolder )
		@folderid = folderid
	end

	def folderid
		@folderid
	end

	def mailid
		if @folderid == BeckyAPI.GetCurrentFolder then
			BeckyAPI.GetCurrentMail
		else
			nil
		end
	end

	def mailid=( newmail )
		BeckyAPI.SetCurrentMail( newmail )
	end

	def mail
		if @folderid == BeckyAPI.GetCurrentFolder then
			BkMail.new( BeckyAPI.GetCurrentMail )
		else
			nil
		end
	end

	def mail=( newmail )
		BeckyAPI.SetCurrentMail( newmail.mailid )
	end

	def name
		BeckyAPI.GetFolderDisplayName( @folderid )
	end

	def append( source )
		BeckyAPI.AppendMessage( @folderid , source )
	end

	def current?
		return BeckyAPI.GetCurrentFolder == @folderid
	end

	def current
		BeckyAPI.SetCurrentFolder( @folderid )
	end

	def each
		( mailid , pos ) = BeckyAPI.GetNextMail( -1 , false )
		while pos != -1
			yield BkMail.new( mailid )
			( mailid , pos ) = BeckyAPI.GetNextMail( pos , false )
		end
	end

	def each_id
		( mailid , pos ) = BeckyAPI.GetNextMail( -1 , false )
		while pos != -1
			yield mailid
			( mailid , pos ) = BeckyAPI.GetNextMail( pos , false )
		end
	end
end

class BkMail
	def initialize( mailid=BeckyAPI.GetCurrentMail )
		@mailid = mailid
	end

	def mailid
		@mailid
	end

	def select
		BeckyAPI.SetSel( @mailid , true )
	end

	def unselect
		BeckyAPI.SetSel( @mailid , false )
	end

	def current?
		return BeckyAPI.GetCurrentMail == @mailid
	end

	def current
		if block_given?
			nowmailid = Becky.mail.mailid
			nowfolderid = Becky.folder.folderid
		end
		if nowmailid != @mailid then
			BeckyAPI.SetCurrentMail( @mailid )
		end
		if block_given?
			yield self
			if nowmailid == "" then
				BeckyAPI.SetCurrentFolder( nowfolderid )
			elsif nowmailid != @mailid then
				BeckyAPI.SetCurrentMail( nowmailid )
			end
		end
	end

	def index
		( mailid , pos ) = BeckyAPI.GetNextMail( -1 , false )
		while pos != -1
			if mailid == @mailid then
				return pos
			end
			( mailid , pos ) = BeckyAPI.GetNextMail( pos , false )
		end
	end

	def succ
		( mailid , pos ) = BeckyAPI.GetNextMail( self.index , false )
		if pos == -1 then
			( mailid , pos ) = BeckyAPI.GetNextMail( -1 , false )
		end
		BkMail.new( mailid )
	end

	def succ!
		( mailid , pos ) = BeckyAPI.GetNextMail( self.index , false )
		if pos == -1 then
			( mailid , pos ) = BeckyAPI.GetNextMail( -1 , false )
		end
		@mailid = mailid
	end

	def next
		( mailid , pos ) = BeckyAPI.GetNextMail( self.index , false )
		if pos == -1 then
			nil
		else
			BkMail.new( mailid )
		end
	end

	def next!
		( mailid , pos ) = BeckyAPI.GetNextMail( self.index , false )
		if pos == -1 then
			self
		else
			@mailid = mailid
		end
	end

	def prev
		nowpos = self.index
		if nowpos >= 2 then
			( mailid , pos ) = BeckyAPI.GetNextMail( nowpos-2 , false )
			BkMail.new( mailid )
		elsif nowpos == 1 then
			( mailid , pos ) = BeckyAPI.GetNextMail( -1 , false )
			BkMail.new( mailid )
		else
			nil
		end
	end

	def prev!
		nowpos = self.index
		if nowpos >= 2 then
			( mailid , pos ) = BeckyAPI.GetNextMail( nowpos-2 , false )
			@mailid = mailid
		elsif nowpos == 1 then
			( mailid , pos ) = BeckyAPI.GetNextMail( -1 , false )
			@mailid = mailid
		else
			self
		end
	end

	def read?
		return BeckyAPI.GetStatus( @mailid ) & 1 == 1
	end

	def forward?
		return BeckyAPI.GetStatus( @mailid ) & 2 == 2
	end

	def reply?
		return BeckyAPI.GetStatus( @mailid ) & 4 == 4
	end

	def attach?
		return BeckyAPI.GetStatus( @mailid ) & 8 == 8
	end

	def partial?
		return BeckyAPI.GetStatus( @mailid ) & 0x100 == 0x100
	end

	def redirect?
		return BeckyAPI.GetStatus( @mailid ) & 0x200 == 0x200
	end

	def header
		BeckyAPI.GetHeader( @mailid )
	end

	def charset
		BeckyAPI.GetCharSet( @mailid )[1]
	end

	def codepage
		BeckyAPI.GetCharSet( @mailid )[0]
	end

	def source
		BeckyAPI.GetSource( @mailid )
	end

	def source=( src )
		BeckyAPI.SetSource( @mailid , src )
	end

	def specifiedheader( field )
		self.current do
			return BeckyAPI.GetSpecifiedHeader( field )
		end
	end

	def specifiedheader=( val )
		self.current do
			BeckyAPI.SetSpecifiedHeader( val[0], val[1] )
		end
	end

	[
		'Bcc',
		'Cc',
		'Content-Length',
		'Content-Transfer-Encoding',
		'Content-Type',
		'Date',
		'From',
		'In-Reply-To',
		'Message-Id',
		'Received',
		'References',
		'Reply-To',
		'Return-Path',
		'Sender',
		'Subject',
		'To',
		'X-Mailer',
		'X-ML-Name',
		'User-Agent'
	].each do |field|
		meth = field.tr('A-Z-','a-z_')
		eval <<-END
			def #{meth}; self.specifiedheader( "#{field}" ); end
			def #{meth}=(val); self.specifiedheader= [ "#{field}", val ]; end
		END
	end

	def body
		self.current do
			return BeckyAPI.GetText()[0]
		end
	end

	def mimetype
		self.current do
			return BeckyAPI.GetText()[1]
		end
	end

	def body=( txt )
		self.current do
			BeckyAPI.SetText( 0, txt )
		end
	end

	def insert( txt )
		self.current do
			BeckyAPI.SetText( -2, txt )
		end
	end

	def insert!( txt )
		self.current do
			BeckyAPI.SetText( -1, txt )
		end
	end

	def append( txt )
		self.current do
			BeckyAPI.SetText( 2, txt )
		end
	end

	def append!( txt )
		self.current do
			BeckyAPI.SetText( 1, txt )
		end
	end
end

class BkComposeMail
	def initialize( mailto="" )
		if mailto.class == BkComposeAPI then
			@mail = mailto
		else 
			@mail = BkComposeAPI.new
			@mail.ComposeMail( mailto )
		end
	end

	def message=( msg )
		@mail.SetMessageText( msg )
	end

	def command( cmd )
		@mail.Command( cmd )
	end

	def header
		@mail.GetHeader
	end

	def source
		@mail.GetSource
	end

	def source=( txt )
		@mail.SetSource( txt )
	end

	def charset
		@mail.GetCharSet()[0]
	end

	def codepage
		@mail.GetCharSet()[1]
	end

	def body
		@mail.GetText()[0]
	end

	def mimetype
		@mail.GetText()[1]
	end

	def body=( txt )
		@mail.SetText( 0 , txt )
	end

	def insert( txt )
		@mail.SetText( -2 , txt )
	end

	def insert!( txt )
		@mail.SetText( -1 , txt )
	end

	def append( txt )
		@mail.SetText( 2 , txt )
	end

	def append!( txt )
		@mail.SetText( 1 , txt )
	end

	def attach( file , mime=nil )
		@mail.AttachFile( file , mime )
	end

	def specifiedheader( field )
		@mail.GetSpecifiedHeader( field )
	end

	def specifiedheader=( val )
		@mail.SetSpecifiedHeader( val[0] , val[1] )
	end

	[
		'Bcc',
		'Cc',
		'Content-Length',
		'Content-Transfer-Encoding',
		'Content-Type',
		'Date',
		'From',
		'In-Reply-To',
		'Message-Id',
		'Received',
		'References',
		'Reply-To',
		'Return-Path',
		'Sender',
		'Subject',
		'To',
		'X-Mailer',
		'X-ML-Name',
		'User-Agent'
	].each do |field|
		meth = field.tr('A-Z-','a-z_')
		eval <<-END
			def #{meth}; self.specifiedheader( "#{field}" ); end
			def #{meth}=(val); self.specifiedheader= [ "#{field}", val ]; end
		END
	end
end


include Becky

