// BkSMIME.cpp : DLL p̏̒`s܂B
//

#include "stdafx.h"
#include <wincrypt.h>
#include "BkSMIME.h"
#include "SMIMESetting.h"
#include "../BeckyAPI.h"
#include "../BkCommon.h"

CBeckyAPI bka; // You can have only one instance in a project.

char szIni[_MAX_PATH+2]; // Ini file to save your plugin settings.
char szMan[_MAX_PATH+2];
char g_szVer[] = "Ver. 1.07";
char g_szVendor[] = "RimArts, Inc.";

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define WM_SET_TRANSFER_SAFE	WM_USER+300 // Makes compose window to encode text in transfer safe form.
#define WM_SET_READONLY			WM_USER+301 // Makes compose window to readonly

#define MY_ENCODING_TYPE  (PKCS_7_ASN_ENCODING | X509_ASN_ENCODING)

#define	ENCRYPT_3DES		0
#define ENCRYPT_RC2_40	1
#define	ENCRYPT_RC2_64	2
#define	ENCRYPT_RC2_128	3
#define ENCRYPT_DES		4

#define	HASH_SHA1		0
#define	HASH_MD5		1

#define BKA_CERT_FROM		0
#define BKA_CERT_ADDRESS	1

// Options
int g_nAlgorithm = ENCRYPT_3DES;
int g_nHash = HASH_SHA1;
int g_bClearTextSign = TRUE;
int g_nEncryptCert = BKA_CERT_FROM;
int g_nSignCert    = BKA_CERT_FROM;
CString g_strEncryptCert;
CString g_strSignCert;

// Globals
char szTempPath[_MAX_PATH+2];
char szAsc[_MAX_PATH+10];
char szTxt[_MAX_PATH+10];
char szOut[_MAX_PATH+10];

/////////////////////////////////////////////////////////////////////////////
// CBkSMIMEApp

BEGIN_MESSAGE_MAP(CBkSMIMEApp, CWinApp)
	//{{AFX_MSG_MAP(CBkSMIMEApp)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
		//        ̈ʒuɐR[hҏWȂłB
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
//
void WritePrivateProfileInt(LPCTSTR lpSection, LPCTSTR lpEntry, int nVal, LPCTSTR lpIni)
{
	CString strVal;
	strVal.Format("%d", nVal);
	::WritePrivateProfileString(lpSection, lpEntry, strVal, lpIni);
}

/////////////////////////////////////////////////////////////////////////////
// CBkSMIMEApp ̍\z

CBkSMIMEApp::CBkSMIMEApp()
{
}

/////////////////////////////////////////////////////////////////////////////
// B CBkSMIMEApp IuWFNg

CBkSMIMEApp theApp;


/////////////////////////////////////////////////////////////////////////////
// DLL entry point

BOOL CBkSMIMEApp::InitInstance() 
{
	BOOL bRet = CWinApp::InitInstance();
	if (!bka.InitAPI()) {
		return FALSE;
	}
	GetModuleFileName(AfxGetInstanceHandle(), szIni, _MAX_PATH);
	strcpy(szMan, szIni);
	LPSTR lpExt = strrchr(szIni, '.');
	if (lpExt) {
		strcpy(lpExt, ".ini");
	} else {
		// just in case
		strcat(szIni, ".ini");
	}
	lpExt = strrchr(szMan, '.');
	if (lpExt) {
		if (GetACP() == 932) strcpy(lpExt, "-j");
		else strcpy(lpExt, "-j");
		lpExt += 2;
		strcpy(lpExt, ".txt");
	}

	int nLen = GetTempPath(_MAX_PATH, szTempPath);
	if (nLen) {
		if (szTempPath[nLen-1] != '\\') {
			strcat(szTempPath, "\\");
		}
	}
	strcpy(szAsc, szTempPath); strcat(szAsc, "smime.asc");
	strcpy(szTxt, szTempPath); strcat(szTxt, "smime");
	strcpy(szOut, szTempPath); strcat(szOut, "smime.out");

	g_nAlgorithm = GetPrivateProfileInt("Settings", "Encryption", ENCRYPT_3DES, szIni);
	g_nHash      = GetPrivateProfileInt("Settings", "Hash", HASH_SHA1, szIni);
	g_bClearTextSign = GetPrivateProfileInt("Settings", "ClearTextSign", TRUE, szIni);

	DWORD dw;
	g_nEncryptCert  = GetPrivateProfileInt("Settings", "EncryptCert", BKA_CERT_FROM, szIni);
	g_nSignCert     = GetPrivateProfileInt("Settings", "SignCert", BKA_CERT_FROM, szIni);
	dw = GetPrivateProfileString("Settings", "EncryptCertAddress", "", g_strEncryptCert.GetBuffer(1024), 1024, szIni);
	g_strEncryptCert.ReleaseBuffer(dw);
	dw = GetPrivateProfileString("Settings", "SignCertAddress", "", g_strSignCert.GetBuffer(1024), 1024, szIni);
	g_strSignCert.ReleaseBuffer(dw);

	return bRet;
}


/////////////////////////////////////////////////////////////////////////////
void HandleError(char *s, HWND hWnd)
{
	CString str1;
	if (s && *s != '\0') {
		str1.Format("%s\n\n", s);
	}
	LPVOID lpMsgBuf = NULL;
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);
	CString str2; str2.Format("%s (Code: %x)\n", (LPSTR)lpMsgBuf, GetLastError());

	MessageBox(hWnd, str1 + str2, "S/MIME error", MB_OK);
	if (lpMsgBuf) LocalFree( lpMsgBuf );
}

void HandleError(UINT nID, HWND hWnd)
{
	CString str;
	int n = GetLastError();
	str.LoadString(nID);
	SetLastError(n);
	HandleError((LPSTR)(LPCTSTR)str, hWnd);
}

//---------------------------------------------------------------------
// Get printable name from CERT_CONTEXT
CString GetCertString(PCCERT_CONTEXT pCertContext)
{
	char szNameString[130];
	CString strRet;

	if(CertGetNameString(
	   pCertContext,
	   CERT_NAME_SIMPLE_DISPLAY_TYPE,
	   0,
	   NULL,
	   szNameString,
	   128)) {
		strRet += szNameString;
	}

	if(CertGetNameString(
	   pCertContext,
	   CERT_NAME_EMAIL_TYPE,
	   0,
	   NULL,
	   szNameString,
	   128)) {
		strRet += " <";
		strRet += szNameString;
		strRet += "> ";
	}

	return strRet;
}


//-------------------------------------------------------------
// Get algorithm name from CRYPT_ALGORITHM_IDENTIFIER struct.
CString ConvertAlgorithmName(CRYPT_ALGORITHM_IDENTIFIER* pAlg)
{
	CString strAlg = pAlg->pszObjId;

	if (strAlg.IsEmpty()) {
		strAlg = "UNKNOWN";
	} else
		// Standard for S/MIME
	if (strAlg.Compare(szOID_RSA_MD5) == 0) {
		strAlg = "MD5";
	} else
	if (strAlg.Compare(szOID_OIWSEC_sha1) == 0) {
		strAlg = "SHA-1";
	} else
	if (strAlg.Compare(szOID_OIWSEC_desCBC) == 0) {
		strAlg = "DES";
	} else
	if (strAlg.Compare(szOID_RSA_RC2CBC) == 0) {
		strAlg = "RC2";
		if (pAlg->Parameters.cbData) {
			DWORD cbSize = sizeof(CRYPT_RC2_CBC_PARAMETERS);
			CRYPT_RC2_CBC_PARAMETERS rc2Param;
			if (CryptDecodeObject(
					MY_ENCODING_TYPE,
					PKCS_RC2_CBC_PARAMETERS,
					pAlg->Parameters.pbData,
					pAlg->Parameters.cbData,
					0,
					&rc2Param,
					&cbSize)) {
				if (rc2Param.dwVersion == CRYPT_RC2_40BIT_VERSION) {
					strAlg += " (40bit)";
				} else 
				if (rc2Param.dwVersion == CRYPT_RC2_64BIT_VERSION) {
					strAlg += " (64bit)";
				} else 
				if (rc2Param.dwVersion == CRYPT_RC2_128BIT_VERSION) {
					strAlg += " (128bit)";
				}
			}
		}
	} else
	if (strAlg.Compare(szOID_RSA_DES_EDE3_CBC) == 0) {
		strAlg = "TripleDES";
	} else
		// Miscellaneous encryption and digest algorithms.
	if (strAlg.Compare(szOID_RSA_RSA) == 0) {
		strAlg = "RSA";
	} else
	if (strAlg.Compare(szOID_RSA_MD2RSA) == 0) {
		strAlg = "MD2RSA";
	} else
	if (strAlg.Compare(szOID_RSA_MD4RSA) == 0) {
		strAlg = "MD4RSA";
	} else
	if (strAlg.Compare(szOID_RSA_MD5RSA) == 0) {
		strAlg = "MD5RSA";
	} else
	if (strAlg.Compare(szOID_RSA_MD4) == 0) {
		strAlg = "MD4";
	} else
	if (strAlg.Compare(szOID_RSA_MD2) == 0) {
		strAlg = "MD2";
	} else
	if (strAlg.Compare(szOID_OIWSEC_md4RSA) == 0) {
		strAlg = "md4RSA";
	} else
	if (strAlg.Compare(szOID_OIWSEC_md5RSA) == 0) {
		strAlg = "md5RSA";
	} else
	if (strAlg.Compare(szOID_OIWSEC_md4RSA2) == 0) {
		strAlg = "md4RSA2";
	} else
	if (strAlg.Compare(szOID_OIWSEC_desECB) == 0) {
		strAlg = "desECB";
	} else
	if (strAlg.Compare(szOID_OIWSEC_desOFB) == 0) {
		strAlg = "desOFB";
	} else
	if (strAlg.Compare(szOID_OIWSEC_desCFB) == 0) {
		strAlg = "desCFB";
	} else
	if (strAlg.Compare(szOID_OIWSEC_desMAC) == 0) {
		strAlg = "desMAC";
	} else
	if (strAlg.Compare(szOID_OIWSEC_rsaSign) == 0) {
		strAlg = "rsaSign";
	} else
	if (strAlg.Compare(szOID_OIWSEC_dsa) == 0) {
		strAlg = "DSA";
	} else
	if (strAlg.Compare(szOID_OIWSEC_shaDSA) == 0) {
		strAlg = "shaDSA";
	} else
	if (strAlg.Compare(szOID_OIWSEC_mdc2RSA) == 0) {
		strAlg = "mdc2RSA";
	} else
	if (strAlg.Compare(szOID_OIWSEC_dhCommMod) == 0) {
		strAlg = "dhCommMod";
	} else
	if (strAlg.Compare(szOID_OIWSEC_desEDE) == 0) {
		strAlg = "desEDE";
	} else
	if (strAlg.Compare(szOID_OIWSEC_sha) == 0) {
		strAlg = "SHA";
	} else
	if (strAlg.Compare(szOID_OIWSEC_mdc2) == 0) {
		strAlg = "MDC2";
	} else
	if (strAlg.Compare(szOID_OIWSEC_dsaComm) == 0) {
		strAlg = "dsaComm";
	} else
	if (strAlg.Compare(szOID_OIWSEC_dsaCommSHA) == 0) {
		strAlg = "desCommSHA";
	} else
	if (strAlg.Compare(szOID_OIWSEC_rsaXchg) == 0) {
		strAlg = "rsaXchg";
	} else
	if (strAlg.Compare(szOID_OIWSEC_keyHashSeal) == 0) {
		strAlg = "keyHashSeal";
	} else
	if (strAlg.Compare(szOID_OIWSEC_md2RSASign) == 0) {
		strAlg = "md2RSASign";
	} else
	if (strAlg.Compare(szOID_OIWSEC_md5RSASign) == 0) {
		strAlg = "md5RSASign";
	} else
	if (strAlg.Compare(szOID_OIWSEC_dsaSHA1) == 0) {
		strAlg = "dsaSHA1";
	} else
	if (strAlg.Compare(szOID_OIWSEC_dsaCommSHA1) == 0) {
		strAlg = "dsaCommSHA1";
	} else
	if (strAlg.Compare(szOID_OIWSEC_sha1RSASign) == 0) {
		strAlg = "sha1RSASign";
	} else
	if (strAlg.Compare(szOID_RSA_RC4) == 0) {
		strAlg = "RC4";
	} else
	if (strAlg.Compare(szOID_RSA_RC5_CBCPad) == 0) {
		strAlg = "CBCPad";
	} else
	if (strAlg.Compare(szOID_RSA_SHA1RSA) == 0) {
		strAlg = "SHA1RSA";
	} else {
		strAlg = "OID." + strAlg;
	}
	return strAlg;
}

//-----------------------------------------------------------------------------------
// Verify a certificate
BOOL VerifyCert(PCCERT_CONTEXT pSignerCert, HCERTSTORE hAdditionalStore)
{
	CERT_CHAIN_PARA				ChainPara;
	ZeroMemory(&ChainPara, sizeof(ChainPara));
	ChainPara.cbSize = sizeof(ChainPara);
	PCCERT_CHAIN_CONTEXT pChainContext = NULL;

	if (!CertGetCertificateChain(
							NULL,
							pSignerCert,
							NULL,
							hAdditionalStore,
							&ChainPara,
							0,
							NULL,
							&pChainContext)) {
		return FALSE;
	}
	/*
	if (pChainContext->TrustStatus.dwErrorStatus & (CERT_TRUST_IS_NOT_TIME_VALID|CERT_TRUST_IS_REVOKED)) {
		CertFreeCertificateChain(pChainContext);
		return FALSE;
	}
	*/
	if (pChainContext->TrustStatus.dwErrorStatus != CERT_TRUST_NO_ERROR) {
		CString str; str.Format("Error code: %u", pChainContext->TrustStatus.dwErrorStatus);
		//AfxMessageBox(str);
		CertFreeCertificateChain(pChainContext);
		return FALSE;
	}
	CertFreeCertificateChain(pChainContext);
	return TRUE;
}

//-----------------------------------------------------------------------------------
// Retrieve information from encoded message blob.
DWORD GetEncodedMessageParam(LPBYTE pbEncodedBlob, DWORD cbEncodedBlob, CString& strAlg)
{
	HCRYPTMSG hMsg = NULL;
	DWORD dwType = CMSG_DATA;
	do {
		if (hMsg = CryptMsgOpenToDecode(
						   MY_ENCODING_TYPE,      // Encoding type.
						   0,                     // Flags.
						   0,                     // Use the default message type.
												  // The message type is 
												  // listed in the message header.
						   NULL,                  // Cryptographic provider. Use NULL
												  // for the default provider.
						   NULL,                  // Recipient information.
						   NULL))                 // Stream information.
		{
		} else {
			TRACE ("Error opening message.");
			break;
		}
		//--------------------------------------------------------------------
		//  Update the message with an encoded BLOB.
		//  Both pbEncodedBlob, the encoded data, 
		//  and cbEnclodeBlob, the length of the encoded data,
		//  must be available. 

		if (CryptMsgUpdate(
			hMsg,                 // Handle to the message
			pbEncodedBlob,        // Pointer to the encoded BLOB
			cbEncodedBlob,        // Size of the encoded BLOB
			TRUE))                // Last call
		{
		} else {
			TRACE ("Error updating message.");
			break;
		}

		DWORD cbDecoded = 0;

		if(CryptMsgGetParam(
			hMsg,                  // Handle to the message
			CMSG_TYPE_PARAM,    // Parameter type
			0,                     // Index
			NULL,                 
			&cbDecoded))           // Size of the returned 
								   // information.
		{
			DWORD* pBuf = (DWORD*)malloc(cbDecoded);
			if(CryptMsgGetParam(
				hMsg,                  // Handle to the message
				CMSG_TYPE_PARAM,      // Parameter type
				0,                     // Index
				pBuf,                 
				&cbDecoded))           // Size of the returned 
									   // information.
			{
				dwType = *pBuf;
			}
			if (pBuf) free(pBuf);
		}

		if (dwType == CMSG_SIGNED || dwType == CMSG_SIGNED_AND_ENVELOPED) {
			if(CryptMsgGetParam(
				hMsg,                  // Handle to the message
				CMSG_SIGNER_HASH_ALGORITHM_PARAM,    // Parameter type
				0,                     // Index
				NULL,                 
				&cbDecoded))           // Size of the returned 
									   // information.
			{
				CRYPT_ALGORITHM_IDENTIFIER* pBuf = (CRYPT_ALGORITHM_IDENTIFIER*)malloc(cbDecoded);
				if(CryptMsgGetParam(
					hMsg,                  // Handle to the message
					CMSG_SIGNER_HASH_ALGORITHM_PARAM,    // Parameter type
					0,                     // Index
					pBuf,                 
					&cbDecoded))           // Size of the returned 
										   // information.
				{
					strAlg = ConvertAlgorithmName(pBuf);
				}
				if (pBuf) free(pBuf);
			}
		}

		if (dwType == CMSG_ENVELOPED || dwType == CMSG_SIGNED_AND_ENVELOPED) {
			if(CryptMsgGetParam(
				hMsg,                  // Handle to the message
				CMSG_ENVELOPE_ALGORITHM_PARAM,    // Parameter type
				0,                     // Index
				NULL,                 
				&cbDecoded))           // Size of the returned 
									   // information.
			{
				CRYPT_ALGORITHM_IDENTIFIER* pBuf = (CRYPT_ALGORITHM_IDENTIFIER*)malloc(cbDecoded);
				if(CryptMsgGetParam(
					hMsg,                  // Handle to the message
					CMSG_ENVELOPE_ALGORITHM_PARAM,    // Parameter type
					0,                     // Index
					pBuf,                 
					&cbDecoded))           // Size of the returned 
										   // information.
				{
					strAlg = ConvertAlgorithmName(pBuf);
				}
				if (pBuf) free(pBuf);
			}
		}
	} while (0);
	if(hMsg) CryptMsgClose(hMsg);

	return dwType;
}


//--------------------------------------------------------------------
// GetRecipientCert enumerates the certificates in a store and finds
// the first certificate that has an AT_EXCHANGE key. If a certificate 
// is found, a pointer to that certificate is returned.  
int GetRecipientCert(HWND hWnd, HCERTSTORE hCertStore, HCERTSTORE hMyCertStore, CArray<PCCERT_CONTEXT, PCCERT_CONTEXT>& arrRecipientCert) 
{ 
	//-------------------------------------------------------------------- 
	// Declare and initialize local variables. 

	PCCERT_CONTEXT pCertContext = NULL; 
	DWORD dwSize = NULL; 

	//-------------------------------------------------------------------- 
	// Find certificates in the store until the end of the store 
	// is reached or a certificate with an AT_KEYEXCHANGE key is found. 
	CString strTo, strCc, strBcc, strFromBuf;
	LPSTR szTo = strTo.GetBuffer(32770);
	LPSTR szCc = strCc.GetBuffer(32770);
	LPSTR szBcc = strBcc.GetBuffer(32770);
	LPSTR szFrom = strFromBuf.GetBuffer(1024);
	bka.CompGetSpecifiedHeader(hWnd, "From", szFrom, 1024);
	bka.CompGetSpecifiedHeader(hWnd, "To", szTo, 32768);
	bka.CompGetSpecifiedHeader(hWnd, "Cc", szCc, 32768);
	bka.CompGetSpecifiedHeader(hWnd, "Bcc", szBcc, 32768);

	char szName[260], szEMail[260];
	char szUserID[260];
	CStringList lstAddr;
	LPSTR lpTok;

	LPSTR lpTo = bka.SerializeRcpts(szTo);
	if (szTo[0] == '\0') {
		char szError[258];
		LoadString(AfxGetInstanceHandle(), IDS_SMIME_NORECIPIENT, szError, 255);
		MessageBox(hWnd, szError, "S/MIME error", MB_OK);
		return 0;
	}

	lpTok = TokenAddr(lpTo);
	while (lpTok) {
		GetNameAndAddr(szName, 256, szEMail, 256, lpTok);
		sprintf(szUserID, "%s", szEMail);
		if (!lstAddr.Find(szUserID)) lstAddr.AddTail(szUserID);
		lpTok = TokenAddr(NULL);
	}
	bka.Free(lpTo);

	LPSTR lpCc = bka.SerializeRcpts(szCc);
	lpTok = TokenAddr(lpCc);
	while (lpTok) {
		GetNameAndAddr(szName, 256, szEMail, 256, lpTok);
		sprintf(szUserID, "%s", szEMail);
		if (!lstAddr.Find(szUserID)) lstAddr.AddTail(szUserID);
		lpTok = TokenAddr(NULL);
	}
	bka.Free(lpCc);

	LPSTR lpBcc = bka.SerializeRcpts(szBcc);
	lpTok = TokenAddr(lpBcc);
	if (lpTok) {
		CString strMsg;
		strMsg.LoadString(IDS_BCCENCRYPT);
		if (MessageBox(hWnd, strMsg, "S/MIME warning", MB_YESNO) == IDNO) {
			while (lpTok) {
				GetNameAndAddr(szName, 256, szEMail, 256, lpTok);
				sprintf(szUserID, "%s", szEMail);
				if (!lstAddr.Find(szUserID)) lstAddr.AddTail(szUserID);
				lpTok = TokenAddr(NULL);
			}
			bka.Free(lpBcc);
		}
	}

	if (!lstAddr.GetCount()) {
		char szError[258];
		LoadString(AfxGetInstanceHandle(), IDS_SMIME_NORECIPIENT, szError, 255);
		MessageBox(hWnd, szError, "S/MIME error", MB_OK);
		return 0;
	}

	CString strFrom;
	if (g_nEncryptCert == BKA_CERT_ADDRESS) {
		strFrom = g_strEncryptCert;
		strFrom.TrimLeft();
		strFrom.TrimRight();
		if (!lstAddr.Find(strFrom)) lstAddr.AddTail(strFrom);
	}
	if (strFrom.IsEmpty()) {
		LPSTR lpFrom = bka.SerializeRcpts(szFrom);
		lpTok = TokenAddr(lpFrom);
		while (lpTok) {
			GetNameAndAddr(szName, 256, szEMail, 256, lpTok);
			sprintf(szUserID, "%s", szEMail);
			if (!lstAddr.Find(szUserID)) lstAddr.AddTail(szUserID);
			lpTok = TokenAddr(NULL);
		}
		strFrom = lpFrom;
		bka.Free(lpFrom);
	}
	POSITION pos = lstAddr.GetHeadPosition();
	CStringList lstErr;
	pCertContext = NULL;
	CRYPT_KEY_PROV_INFO* pKeyInfo = NULL; 
	while (pos) {
		CString str = lstAddr.GetNext(pos);
		BOOL fMore = TRUE;
		char szMailBuf[1026];

		while (pCertContext = CertFindCertificateInStore( 
				   hCertStore,				// Handle of the store to be searched. 
				   MY_ENCODING_TYPE,        // Encoding type.
				   0,						// dwFindFlags. Special find criteria. 
				   CERT_FIND_ANY,			// Matches everything.
				   NULL,					// pvFindPara. Gives the specific 
				   pCertContext)) {
			if (CertGetNameString(pCertContext, CERT_NAME_EMAIL_TYPE, 0, NULL, szMailBuf, 1024) > 1) {
				if (str.CompareNoCase(szMailBuf) == 0) {
					if (VerifyCert(pCertContext, NULL)) {
						if (pCertContext->pCertInfo) {
							if (pCertContext->pCertInfo->SubjectPublicKeyInfo.PublicKey.cbData) break;
						}
					}
				}
			}
		}
		if (!pCertContext) {
			while (pCertContext = CertFindCertificateInStore( 
					   hMyCertStore,				// Handle of the store to be searched. 
					   MY_ENCODING_TYPE,        // Encoding type.
					   0,						// dwFindFlags. Special find criteria. 
					   CERT_FIND_ANY,			// Matches everything.
					   NULL,					// pvFindPara. Gives the specific 
					   pCertContext)) {
				if (CertGetNameString(pCertContext, CERT_NAME_EMAIL_TYPE, 0, NULL, szMailBuf, 1024) > 1) {
					if (str.CompareNoCase(szMailBuf) == 0) {
						if (VerifyCert(pCertContext, NULL)) {
							if (pCertContext->pCertInfo) {
								if (pCertContext->pCertInfo->SubjectPublicKeyInfo.PublicKey.cbData) break;
							}
						}
					}
				}
			}
			if (!pCertContext) {
				lstErr.AddTail(str);
				break;
			}
		}
		arrRecipientCert.Add(pCertContext);
		pCertContext = NULL;
	}
	if(pKeyInfo) free(pKeyInfo); 
	if (pCertContext) {
		 CertFreeCertificateContext(pCertContext);
	}

	int nErrLevel = 0;
	pos = lstErr.GetHeadPosition();
	while (pos) {
		CString str = lstErr.GetNext(pos);
		if (strFrom.Find(str) != -1) {
			nErrLevel = 1;
		} else {
			nErrLevel = -1;
			break;
		}
	}
	if (nErrLevel == -1) {
		CString strMsg;
		CString strErr;
		POSITION pos = lstErr.GetHeadPosition();
		while (pos) {
			strErr += lstErr.GetNext(pos);
			strErr += "\r\n";
		}
		strMsg.Format(IDS_ERRORRECIPIENTS, strErr);
		MessageBox(hWnd, strMsg, "S/MIME error", MB_ICONEXCLAMATION|MB_OK);
		return 0;
	} else if (arrRecipientCert.GetSize() == 0) { // Certificate was found but no keys.
		CString strMsg;
		strMsg.LoadString(IDS_ERRORCERT);
		MessageBox(hWnd, strMsg, "S/MIME error", MB_ICONEXCLAMATION|MB_OK);
		return 0;
	} else if (nErrLevel == 1) {
		CString strMsg;
		strMsg.LoadString(IDS_ERRORFROM);
		int rc = MessageBox(hWnd, strMsg, "S/MIME warning", MB_ICONQUESTION|MB_OKCANCEL);
		if (rc == IDCANCEL) {
			return 0;
		}
	}

	return arrRecipientCert.GetSize();
}


//--------------------------------------------------------------------
// Get Signers certificates
PCCERT_CONTEXT GetSignerCert(HWND hWnd, HCERTSTORE hStoreHandle, CArray<PCCERT_CONTEXT, PCCERT_CONTEXT>&arrCertContexts, PCCERT_CHAIN_CONTEXT& pChainContext)
{
	PCCERT_CONTEXT pSignerCert = NULL;
	CString strFromBuf;
	LPSTR szFrom = strFromBuf.GetBuffer(32770);
	bka.CompGetSpecifiedHeader(hWnd, "From", szFrom, 32768);

	char szName[260], szEMail[260];
	char szUserID[260];
	CStringList lstAddr;
	LPSTR lpTok;

	CString strFrom;
	if (g_nSignCert == BKA_CERT_ADDRESS) {
		strFrom = g_strSignCert;
		strFrom.TrimLeft();
		strFrom.TrimRight();
		lstAddr.AddTail(strFrom);
	}
	if (strFrom.IsEmpty()) {
		LPSTR lpFrom = bka.SerializeRcpts(szFrom);
		lpTok = TokenAddr(lpFrom);
		while (lpTok) {
			GetNameAndAddr(szName, 256, szEMail, 256, lpTok);
			sprintf(szUserID, "%s", szEMail);
			if (!lstAddr.Find(szUserID)) lstAddr.AddTail(szUserID);
			lpTok = TokenAddr(NULL);
		}
		strFrom = lpFrom;
		bka.Free(lpFrom);
	}
	//--------------------------------------------------------------------
	// Get a pointer to the signer's certificate.
	// This certificate must have access to the signer's private key.
	do {

		POSITION pos = lstAddr.GetHeadPosition();
		if (pos) {
			char szMailBuf[1026];
			CString strAddr = lstAddr.GetNext(pos);
			while (pSignerCert = CertFindCertificateInStore( 
					   hStoreHandle,		// Handle of the store to be searched. 
					   MY_ENCODING_TYPE,    // Encoding type.
					   0,					// dwFindFlags. Special find criteria. 
					   CERT_FIND_ANY,		// Matches everything.
					   NULL,				// pvFindPara. Gives the specific 
					   pSignerCert)) {
				if (CertGetNameString(pSignerCert, CERT_NAME_EMAIL_TYPE, 0, NULL, szMailBuf, 1024) > 1) {
					if (strAddr.CompareNoCase(szMailBuf) == 0) {
						if (VerifyCert(pSignerCert, NULL)) {
							break;
						}
					}
				}
			}
			if(!pSignerCert) {
				HandleError(IDS_ERRORSIGNER, hWnd);
				break;
			}

			CERT_CHAIN_PARA				ChainPara;
			ZeroMemory(&ChainPara, sizeof(ChainPara));
			ChainPara.cbSize = sizeof(ChainPara);

			if (!CertGetCertificateChain(
									NULL,
									pSignerCert,
									NULL,
									NULL,
									&ChainPara,
									0,
									NULL,
									&pChainContext)) {
				HandleError(IDS_ERRORSIGNER, hWnd);
				CertFreeCertificateContext(pSignerCert);
				pSignerCert = NULL;
				break;
			}
			UINT i, j;
			for (i=0; i<pChainContext->cChain; i++) {
				CERT_SIMPLE_CHAIN* pChain = pChainContext->rgpChain[i];
				for (j=0; j<pChain->cElement; j++) {
					CERT_CHAIN_ELEMENT* pCert = pChain->rgpElement[j];
					arrCertContexts.Add(pCert->pCertContext);
				}
			}
		}
	} while (0);
	return pSignerCert;
}

//----------------------------------------------------------------------
// S/MIME encryption
BOOL SMIMEEncryptData(HWND hWnd, CString& strSource, CString& strMessage)
{
	CString strReturn;

	DeleteFile(szAsc);
	DeleteFile(szOut);

	CMIMEItem item;

	// Canonicalization
	CString strTxt;
	LPSTR lpStr = strSource.GetBuffer(strSource.GetLength());
	LPSTR lpSrc = lpStr;
	item.FromString(lpStr);

	CPointerItem* pItem = item.m_lstHeaders.GetTop();
	while (pItem) {
		if (strnicmp("Content-", pItem->GetData(), 8) == 0) {
			strTxt += pItem->GetData();
		}
		pItem = pItem->GetNext();
	}
	LPSTR lpContent = strstr(lpSrc, "\r\n\r\n");
	if (lpContent) {
		lpContent += 2;
		strTxt += lpContent;
	}
	DWORD cbContent = strTxt.GetLength();
	LPBYTE pbContent = (LPBYTE)strTxt.GetBuffer(cbContent);


	HCERTSTORE hStoreHandle = NULL;
	HCERTSTORE hMyStoreHandle = NULL;
	int nRecipients = 0;
	CArray<PCCERT_CONTEXT, PCCERT_CONTEXT> arrRecipientCert;
	DWORD EncryptAlgSize;
	CRYPT_ALGORITHM_IDENTIFIER EncryptAlgorithm;
	CRYPT_ENCRYPT_MESSAGE_PARA EncryptParams;
	DWORD EncryptParamsSize;
	LPBYTE pbEncryptedBlob = NULL;
	DWORD  cbEncryptedBlob;
	PCCERT_CONTEXT* RecipientCertArray = NULL;

	BOOL bRet = FALSE;
	do {

		if(!(hStoreHandle = CertOpenSystemStore(NULL, "AddressBook"))) {
			HandleError(IDS_ERRORSTORE, hWnd);
			break;
		}
		if(!(hMyStoreHandle = CertOpenSystemStore(NULL, "MY"))) {
			HandleError(IDS_ERRORSTORE, hWnd);
			break;
		}

		if(nRecipients = GetRecipientCert(hWnd, hStoreHandle, hMyStoreHandle, arrRecipientCert))
		{
			RecipientCertArray = new PCCERT_CONTEXT[nRecipients];
			for (int i=0; i<nRecipients; i++) {
				RecipientCertArray[i] = arrRecipientCert[i];
			}
		} else {
			break;
		}

		EncryptAlgSize = sizeof(EncryptAlgorithm);
		memset(&EncryptAlgorithm, 0, EncryptAlgSize);
		EncryptParamsSize = sizeof(EncryptParams);
		memset(&EncryptParams, 0, EncryptParamsSize);

		CMSG_RC2_AUX_INFO auxInfo;
		auxInfo.cbSize = sizeof(CMSG_RC2_AUX_INFO);

		switch(g_nAlgorithm) {
		case ENCRYPT_DES:
			EncryptAlgorithm.pszObjId = szOID_OIWSEC_desCBC;
			break;
		case ENCRYPT_RC2_128:
			EncryptAlgorithm.pszObjId = szOID_RSA_RC2CBC;
			auxInfo.dwBitLen = 128;
			EncryptParams.pvEncryptionAuxInfo = &auxInfo;
			break;
		case ENCRYPT_RC2_64:
			EncryptAlgorithm.pszObjId = szOID_RSA_RC2CBC;
			auxInfo.dwBitLen = 64;
			EncryptParams.pvEncryptionAuxInfo = &auxInfo;
			break;
		case ENCRYPT_RC2_40:
			EncryptAlgorithm.pszObjId = szOID_RSA_RC2CBC;
			auxInfo.dwBitLen = 40;
			EncryptParams.pvEncryptionAuxInfo = &auxInfo;
			break;
		case ENCRYPT_3DES:
		default:
			EncryptAlgorithm.pszObjId = szOID_RSA_DES_EDE3_CBC;
			break;
		}
		EncryptAlgorithm.Parameters.cbData = 0;

		EncryptParams.cbSize =  EncryptParamsSize;
		EncryptParams.dwMsgEncodingType = MY_ENCODING_TYPE;
		EncryptParams.hCryptProv = 0;
		EncryptParams.ContentEncryptionAlgorithm = EncryptAlgorithm;

		if(!CryptEncryptMessage(
				  &EncryptParams,
				  nRecipients,
				  RecipientCertArray,
				  pbContent,
				  cbContent,
				  NULL,
				  &cbEncryptedBlob)) {
			HandleError(IDS_ERRORENCRYPT, hWnd);
			break;
		}

		CString strEncrypted;
		pbEncryptedBlob = (LPBYTE)strEncrypted.GetBuffer(cbEncryptedBlob);

		if(!CryptEncryptMessage(
				  &EncryptParams,
				  nRecipients,
				  RecipientCertArray,
				  pbContent,
				  cbContent,
				  pbEncryptedBlob,
				  &cbEncryptedBlob)) {
			HandleError(IDS_ERRORENCRYPT, hWnd);
			break;
		}

		FILE* fp;
		if (!(fp = fopen(szOut, "wb"))) break;
		fwrite(pbEncryptedBlob, cbEncryptedBlob, 1, fp);
		fclose(fp);

		CString strBuf;
		LPSTR szBuf = strBuf.GetBuffer(32768);

		if (!bka.B64Convert(szAsc, szOut, TRUE)) break;
		LPSTR lpAsc = FileToString(szAsc);
		LPSTR lpAscData = lpAsc;
		if (!lpAsc) break;

		sprintf(szBuf, "application/x-pkcs7-mime; name=\"smime.p7m\"; smime-type=enveloped-data\r\n");
		item.SetHeader("Content-Type", szBuf);
		item.SetHeader("Content-Transfer-Encoding", "base64\r\n");
		item.m_lstBody.Empty();
		item.SetChild(NULL); // Remove all the child items or the body of "multipart" will not be used.

		int n;
		while (n = sGets(lpAsc, szBuf, 32760)) {
			if (szBuf[n-1] == '\n') {
				szBuf[n-1] = '\r';
				szBuf[n] = '\n';
				szBuf[n+1] = '\0';
			} else {
				szBuf[n] = '\r';
				szBuf[n+1] = '\n';
				szBuf[n+2] = '\0';
			}
			item.m_lstBody.AddTail(szBuf);
		}

		LPSTR lpSource = item.ToString();
		strReturn = lpSource;

		free(lpSource);
		free(lpAscData);

		// Build an output message.
		CString strAlg;
		DWORD dwType = GetEncodedMessageParam(pbEncryptedBlob, cbEncryptedBlob, strAlg);
		CString strUsers;
		for (int i=0; i<arrRecipientCert.GetSize(); i++) {
			strUsers += GetCertString(arrRecipientCert[i]);
			strUsers += "\n";
		}
		strUsers.TrimRight();
		CString strMsg; strMsg.Format(IDS_ENCRYPTMESSAGE, strAlg, strUsers);
		strMessage += strMsg;

		bRet = TRUE;
	} while (0);
	//--------------------------------------------------------------------
	// Clean up.
	for (int i=0; i<arrRecipientCert.GetSize(); i++) {
		CertFreeCertificateContext(arrRecipientCert[i]);
	}
	if (RecipientCertArray) delete RecipientCertArray;

	if (hStoreHandle) {
		if(!CertCloseStore(hStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG)) {
			TRACE("Store close\n"
				  "But not all certificates, CRLs or CTLs were freed");
		}
	}
	if (hMyStoreHandle) {
		if(!CertCloseStore(hMyStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG)) {
			TRACE("Store close\n"
				  "But not all certificates, CRLs or CTLs were freed");
		}
	}
	DeleteFile(szAsc);
	DeleteFile(szOut);

	strSource.ReleaseBuffer();
	if (bRet) {
		strSource = strReturn;
	}
	return bRet;
}

//----------------------------------------------------------------------------------
// S/MIME sign
BOOL SMIMESignData(HWND hWnd, CString& strSource, CString& strMessage, BOOL bClearTextSign)
{
	CString strReturn;

	DeleteFile(szAsc);
	DeleteFile(szOut);

	CMIMEItem item;

	// Canonicalization
	CString strTxt;
	LPSTR lpStr = strSource.GetBuffer(strSource.GetLength());
	LPSTR lpSrc = lpStr;
	item.FromString(lpStr);

	CPointerItem* pItem = item.m_lstHeaders.GetTop();
	while (pItem) {
		if (strnicmp("Content-", pItem->GetData(), 8) == 0) {
			if (__stristr(pItem->GetData(), "pkcs7-mime")) { // Nested S/MIME
				bClearTextSign = FALSE;
			}
			strTxt += pItem->GetData();
		}
		pItem = pItem->GetNext();
	}
	LPSTR lpContent = strstr(lpSrc, "\r\n\r\n");
	if (lpContent) {
		lpContent += 2;
		strTxt += lpContent;
	}
#ifdef _DEBUG
	FILE* fp = fopen(szTxt, "wb");
	fwrite((LPCTSTR)strTxt,strTxt.GetLength(), 1, fp);
	fclose(fp);
#endif

	DWORD cbMessage = strTxt.GetLength();
	LPBYTE pbMessage = (LPBYTE)strTxt.GetBuffer(cbMessage);


	DWORD cbSignedMessageBlob = 0;
	BYTE  *pbSignedMessageBlob = NULL;

	HCERTSTORE hStoreHandle = NULL;   
	const BYTE* MessageArray[] = {pbMessage};
	DWORD MessageSizeArray[1];
	MessageSizeArray[0] = cbMessage;

	PCCERT_CONTEXT pSignerCert = NULL; 
	CArray<PCCERT_CONTEXT, PCCERT_CONTEXT> arrCertContexts;
	CArray<PCCRL_CONTEXT, PCCRL_CONTEXT> arrCrlContexts;
	PCCERT_CHAIN_CONTEXT		pChainContext = NULL;
	PCCRL_CONTEXT pCRLContext = NULL;
	PCCERT_CONTEXT* CertArray = NULL;
	PCCRL_CONTEXT* CrlArray = NULL;
	BOOL bRet = FALSE;

	do {
		if ( !( hStoreHandle = CertOpenStore(
		   CERT_STORE_PROV_SYSTEM,
		   0,
		   NULL,
		   CERT_SYSTEM_STORE_CURRENT_USER,
		   L"MY")))	{
			 HandleError(IDS_ERRORSTORE, hWnd);
			 break;
		}

		//--------------------------------------------------------------------
		// Get a pointer to the signer's certificate.
		// This certificate must have access to the signer's private key.
		if (pSignerCert = GetSignerCert(hWnd, hStoreHandle, arrCertContexts, pChainContext)) {
			CertArray = new PCCERT_CONTEXT[arrCertContexts.GetSize()];
			for (int i=0; i<arrCertContexts.GetSize(); i++) {
				CertArray[i] = arrCertContexts[i];
			}
		} else {
			break;
		}

		DWORD dw = 0;
		while (pCRLContext = CertGetCRLFromStore(hStoreHandle, pSignerCert, pCRLContext, &dw))
		{
			arrCrlContexts.Add(pCRLContext);
		}
		if (arrCrlContexts.GetSize()) {
			CrlArray = new PCCRL_CONTEXT[arrCrlContexts.GetSize()];
			for (int i=0; i<arrCrlContexts.GetSize(); i++) {
				CrlArray[i] = arrCrlContexts[i];
			}
		}

		CRYPT_SIGN_MESSAGE_PARA  SigParams;
		memset(&SigParams, 0, sizeof(SigParams));
		SigParams.cbSize = sizeof(CRYPT_SIGN_MESSAGE_PARA);
		SigParams.dwMsgEncodingType = MY_ENCODING_TYPE;
		SigParams.pSigningCert = CertArray[0];
		if (g_nHash == HASH_MD5) {
			SigParams.HashAlgorithm.pszObjId = szOID_RSA_MD5;
		} else {
			SigParams.HashAlgorithm.pszObjId = szOID_OIWSEC_sha1;
		}
		SigParams.HashAlgorithm.Parameters.cbData = NULL;
		SigParams.cMsgCert = arrCertContexts.GetSize();
		SigParams.rgpMsgCert = CertArray;
		SigParams.cAuthAttr = 0;
		SigParams.dwInnerContentType = 0;
		SigParams.cMsgCrl = arrCrlContexts.GetSize();
		SigParams.rgpMsgCrl = CrlArray;
		SigParams.cUnauthAttr = 0;
		SigParams.dwFlags = 0;
		SigParams.pvHashAuxInfo = NULL;
		SigParams.rgAuthAttr = NULL;
		//SigParams.HashEncryptionAlgorithm.pszObjId = NULL;
		//SigParams.HashEncryptionAlgorithm.Parameters.cbData = NULL;

		//--------------------------------------------------------------------
		// With two calls to CryptSignMessage, sign the message.
		// First, get the size of the output signed BLOB.

		if(!CryptSignMessage(
			&SigParams,             // Signature parameters
			bClearTextSign,			// Detached or not
			1,                      // Number of messages
			MessageArray,           // Messages to be signed
			MessageSizeArray,       // Size of messages
			NULL,                   // Buffer for signed message
			&cbSignedMessageBlob))  // Size of buffer
		{
			HandleError(IDS_ERRORSIGN, hWnd);
			break;
		}

		//--------------------------------------------------------------------
		// Allocate memory for the signed BLOB.

		CString strBlob;
		pbSignedMessageBlob = (BYTE*)strBlob.GetBuffer(cbSignedMessageBlob);

		//--------------------------------------------------------------------
		// Get the SignedMessageBlob.

		if(!CryptSignMessage(
			&SigParams,				// Signature parameters
			bClearTextSign,			// Detached or not
			1,						// Number of messages
			MessageArray,			// Messages to be signed
			MessageSizeArray,		// Size of messages
			pbSignedMessageBlob,	// Buffer for signed message
			&cbSignedMessageBlob))	// Size of buffer
		{
			HandleError(IDS_ERRORSIGN, hWnd);
			break;
		}

		FILE* fp;
		if (!(fp = fopen(szOut, "wb"))) break;
		fwrite(pbSignedMessageBlob, cbSignedMessageBlob, 1, fp);
		fclose(fp);

		if (bClearTextSign) { // Encapsulate with "multipart/signed"
			if (!bka.B64Convert(szAsc, szOut, TRUE)) break;
			LPSTR lpAsc = FileToString(szAsc);
			LPSTR lpAscData = lpAsc;
			if (!lpAsc) break;

			char szBoundary[1024];
			char szData[8192];
			time_t t;
			time(&t);
			sprintf(szBoundary, "===[S/MIME_RFC2633]===%08X.%04X===", (DWORD)t, &t);
			int n;
			CString strBuf;
			LPSTR szBuf = strBuf.GetBuffer(32768);
			char szHash[20];
			if (g_nHash == HASH_MD5) {
				strcpy(szHash, "md5");
			} else {
				strcpy(szHash, "sha1");
			}
			sprintf(szData, "multipart/signed;\r\n boundary=\"%s\";\r\n protocol=\"application/x-pkcs7-signature\"; micalg=%s\r\n",
				szBoundary, szHash);
			item.SetHeader("Content-Type", szData);
			item.SetHeader("Content-Transfer-Encoding", "7bit\r\n");
			item.m_lstBody.Empty();
			item.SetChild(NULL); // Remove all the child items or the body of "multipart" will not be used.
			sprintf(szBuf, "--%s\r\n", szBoundary);
			item.m_lstBody.AddTail(szBuf);
			item.m_lstBody.AddTail((LPSTR)pbMessage);
			sprintf(szBuf, "\r\n--%s\r\n", szBoundary);
			item.m_lstBody.AddTail(szBuf);
			item.m_lstBody.AddTail("Content-Type: application/x-pkcs7-signature; name=\"smime.p7s\"\r\n");
			item.m_lstBody.AddTail("Content-Disposition: attachment; filename=\"smime.p7s\"\r\n");
			item.m_lstBody.AddTail("Content-Transfer-Encoding: base64\r\n\r\n");

			while (n = sGets(lpAsc, szBuf, 32760)) {
				if (szBuf[n-1] == '\n') {
					szBuf[n-1] = '\r';
					szBuf[n] = '\n';
					szBuf[n+1] = '\0';
				}
				item.m_lstBody.AddTail(szBuf);
			}

			sprintf(szBuf, "\r\n--%s--\r\n", szBoundary);
			item.m_lstBody.AddTail(szBuf);
			LPSTR lpSource = item.ToString();
			strReturn = lpSource;
			free(lpSource);
			free(lpAscData);
		} else {
			CString strBuf;
			LPSTR szBuf = strBuf.GetBuffer(32768);

			if (!bka.B64Convert(szAsc, szOut, TRUE)) break;
			LPSTR lpAsc = FileToString(szAsc);
			LPSTR lpAscData = lpAsc;
			if (!lpAsc) break;

			sprintf(szBuf, "application/x-pkcs7-mime; name=\"smime.p7m\"; smime-type=signed-data\r\n");
			item.SetHeader("Content-Type", szBuf);
			item.SetHeader("Content-Transfer-Encoding", "base64\r\n");
			item.m_lstBody.Empty();
			item.SetChild(NULL); // Remove all the child items or the body of "multipart" will not be used.

			int n;
			while (n = sGets(lpAsc, szBuf, 32760)) {
				if (szBuf[n-1] == '\n') {
					szBuf[n-1] = '\r';
					szBuf[n] = '\n';
					szBuf[n+1] = '\0';
				} else {
					szBuf[n] = '\r';
					szBuf[n+1] = '\n';
					szBuf[n+2] = '\0';
				}
				item.m_lstBody.AddTail(szBuf);
			}

			LPSTR lpSource = item.ToString();
			strReturn = lpSource;
			free(lpSource);
			free(lpAscData);
		}
		CString strAlg;
		DWORD dwType = GetEncodedMessageParam(pbSignedMessageBlob, cbSignedMessageBlob, strAlg);
		CString strUsers = GetCertString(pSignerCert);
		CString strMsg; strMsg.Format(IDS_SIGNMESSAGE, strAlg, strUsers);
		strMessage += strMsg;

		bRet = TRUE;
	} while (0);

	//--------------------------------------------------------------------
	// Clean up.
	for (int i=0; i<arrCrlContexts.GetSize(); i++) {
		CertFreeCRLContext(arrCrlContexts[i]);
	}
	if (CertArray) delete CertArray;
	if (CrlArray) delete CrlArray;

	if (pSignerCert)
		CertFreeCertificateContext(pSignerCert);
    if (pChainContext) 
		CertFreeCertificateChain(pChainContext);


	if (hStoreHandle) {
		if(!CertCloseStore( hStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG)) {
			TRACE("Store close\n"
				  "But not all certificates, CRLs or CTLs were freed");
		}
	}
	DeleteFile(szAsc);
	DeleteFile(szOut);

	strSource.ReleaseBuffer();
	if (bRet) {
		strSource = strReturn;
	}
	return bRet;
}

BOOL StoreCACert(HCERTSTORE hAdditionalStore)
{
	BOOL bRet = TRUE;
	if (hAdditionalStore) {
		PCCERT_CONTEXT pContext = NULL;
		HCERTSTORE hCAStore = CertOpenSystemStore(NULL, "CA");
		if (hCAStore) {
			while (pContext = CertFindCertificateInStore(hAdditionalStore, MY_ENCODING_TYPE, 0, CERT_FIND_ANY, NULL, pContext))
			{
				if (pContext->pCertInfo && pContext->pCertInfo->cExtension) {
					PCERT_EXTENSION pExtension = CertFindExtension(szOID_BASIC_CONSTRAINTS2, pContext->pCertInfo->cExtension, pContext->pCertInfo->rgExtension);
					if (pExtension) {
						CERT_BASIC_CONSTRAINTS2_INFO CertBasic;
						DWORD cbCertBasic = sizeof(CERT_BASIC_CONSTRAINTS2_INFO);
						if (CryptDecodeObject(MY_ENCODING_TYPE, szOID_BASIC_CONSTRAINTS2, pExtension->Value.pbData, pExtension->Value.cbData, 0, &CertBasic, &cbCertBasic)) {
							if (CertBasic.fCA) {
								if (hCAStore) {
									if (!CertAddCertificateContextToStore(hCAStore, pContext, CERT_STORE_ADD_USE_EXISTING, NULL)) {
										// Failed to Add
									}
								}
							}
						}
					}
				}
			}
			if(!CertCloseStore(hCAStore, CERT_CLOSE_STORE_CHECK_FLAG)) {
				TRACE("Store close\n"
					  "But not all certificates, CRLs or CTLs were freed");
			}
		} else bRet = FALSE;
	} else bRet = FALSE;
	return bRet;
}

#define BKA_SMIME_PROCESS_NONE	0
#define BKA_SMIME_PROCESS_SIGN	1
#define BKA_SMIME_PROCESS_ENCR	2
//-----------------------------------------------------------------------------
// S/MIME decryption and verification.
BOOL SMIMEDecryptAndVerify(HWND hWnd)
{
	DeleteFile(szAsc);
	DeleteFile(szTxt);
	DeleteFile(szOut);

	CMIMEItem item;
	LPSTR lpSource = bka.GetSource(NULL);
	CString strFinalSource = lpSource;
	CString strFinalMessage;
	int nFinalNotice = MB_OK|MB_ICONINFORMATION;
	if (lpSource) {
		LPSTR lpStr = lpSource;
		item.FromString(lpStr);
		bka.Free(lpSource);
	}

	char szName[258];
	char szEMail[258];
	CString strSender;
	CStringList lstSigners;
	char szBuf[258];
	item.GetHeader("From", szBuf, 256);
	LPSTR lpTok = TokenAddr(szBuf);
	while (lpTok) {
		GetNameAndAddr(szName, 256, szEMail, 256, lpTok);
		strSender += szEMail;
		strSender += ",";
		lpTok = TokenAddr(NULL);
	}
	item.GetHeader("Sender", szBuf, 256);
	lpTok = TokenAddr(szBuf);
	while (lpTok) {
		GetNameAndAddr(szName, 256, szEMail, 256, lpTok);
		strSender += szEMail;
		strSender += ",";
		lpTok = TokenAddr(NULL);
	}
	strSender.TrimRight(",");

	CMIMEItem* pItem = &item;
	CString strHeader;
	LPSTR szHeader = strHeader.GetBuffer(32770);
	CArray <PCCERT_CONTEXT, PCCERT_CONTEXT> arrSignerCert;

	int nSignatureCount = 0;
	int nEncryptedCount = 0;
	int nLastProcess = BKA_SMIME_PROCESS_NONE;

	CString strCertBlob;
	LPBYTE pbCertBlob = NULL;
	DWORD cbCertBlob = 0;

	BOOL bRet = FALSE;
	BOOL bError = FALSE;
	do {

		CMIMEItem* pTop = pItem->FindMIMEItem("multipart", "signed");
		CMIMEItem* pEnc = pItem->FindMIMEItem("application", "pkcs7-mime");
		if (!pEnc) {
			pEnc = pItem->FindMIMEItem("application", "x-pkcs7-mime"); // early implementation.
		}
		if (!pEnc) {
			pEnc = pItem->FindMIMEItem("application", "octet-stream"); // early implementation.
			if (pEnc) {
				pEnc->GetHeader("Content-Type", szHeader, 32768);
				if (__stristr(szHeader, ".p7s") ||
					__stristr(szHeader, ".p7m") ) {
				} else pEnc = NULL;
			}
		}
		if (pTop) { // signed
			pTop->GetHeader("Content-Type", szHeader, 32768);
			if (!__stristr(szHeader, "pkcs7-signature")) {
				// No S/MIME message.
				break;
			}

			CMIMEItem* pSign, pContent;
			pSign = pTop->FindMIMEItem("application", "pkcs7-signature");
			if (!pSign) {
				pSign = pTop->FindMIMEItem("application", "x-pkcs7-signature"); // early implementation.
			}
			if (pSign) {
				LPSTR lpHash = __stristr(szHeader, "micalg=");
				if (lpHash) {
					lpHash += 7;
					lpHash = strtok(lpHash, "\r\n\t\" ");
				}
				CMIMEItem* pContent = pTop->GetChild();
				while (__stristr(pContent->m_szSubType, "pkcs7-signature") && pContent) { // Content should come first, but just in case.
					pContent = pContent->GetNext();
				}
				LPSTR lpSign = pSign->ToString();
				LPSTR lpBegin = strstr(lpSign, "\r\n\r\n");
				if (lpBegin) {
					lpBegin += 4;
				}
				CString strSign = lpBegin;
				free(lpSign);
				if (strSign.IsEmpty()) {
					SetLastError(CRYPT_E_ASN1_INTERNAL); // Not an exact error.
					HandleError(IDS_FILEERROR, hWnd);
					bError = TRUE;
					break;
				}

				LPSTR lpBody = NULL;
				int nBodyLen = 0;
				LPBYTE pbSignBlob = NULL;
				int nSignBlob = 0;
				if (pContent) {
					lpBody = pContent->ToString();
					nBodyLen = strlen(lpBody);
					// Remove trailing CRLF (it actually belongs to the boundary)
					if (nBodyLen > 2) {
						if (lpBody[nBodyLen-1] == '\n' &&
							lpBody[nBodyLen-2] == '\r') {
							nBodyLen -= 2;
							lpBody[nBodyLen] = '\0';
						}
					}
				}
				CString strBody = lpBody;
				strBody.Replace("\r\n..", "\r\n.");
				FILE* fp;
				if (fp = fopen(szAsc, "wb")) {
					fwrite(strSign, strSign.GetLength(), 1, fp);
					fclose(fp);
				}
				CString strSignBuf;
				pbSignBlob = (LPBYTE)strSignBuf.GetBuffer(strSign.GetLength()*2 + 2); // should be smaller than B64 encoded, but just in case.
				if (bka.B64Convert(szOut, szAsc, FALSE)) {
					if (fp = fopen(szOut, "rb")) {
						fread(pbSignBlob, strSign.GetLength()*2, 1, fp);
						nSignBlob = ftell(fp);
						fclose(fp);
					}
				}
				CString strAlg;
				DWORD dwType = GetEncodedMessageParam(pbSignBlob, nSignBlob, strAlg);

				PCCERT_CONTEXT pSignerCert = NULL;
				CRYPT_VERIFY_MESSAGE_PARA VerifyParams;
				memset(&VerifyParams, 0, sizeof(CRYPT_VERIFY_MESSAGE_PARA));
				VerifyParams.cbSize = sizeof(CRYPT_VERIFY_MESSAGE_PARA);
				VerifyParams.dwMsgAndCertEncodingType = MY_ENCODING_TYPE;
				VerifyParams.hCryptProv = 0;
				VerifyParams.pfnGetSignerCertificate = NULL;
				VerifyParams.pvGetArg = NULL;
				const BYTE* MessageArray[] = {(LPBYTE)(LPCTSTR)strBody};
				DWORD MessageSizeArray[1];
				MessageSizeArray[0] = strBody.GetLength();

				HCERTSTORE hAdditionalStore = CryptGetMessageCertificates(MY_ENCODING_TYPE, NULL, 0, pbSignBlob, nSignBlob);
				pbCertBlob = (LPBYTE)strCertBlob.GetBuffer(nSignBlob);
				memcpy(pbCertBlob, pbSignBlob, nSignBlob);
				cbCertBlob = nSignBlob;

				DWORD dwIndex = 0;
				do {

					if(CryptVerifyDetachedMessageSignature(
						&VerifyParams,		// Verify parameters.
						dwIndex,			// Signer index.
						pbSignBlob,			// Pointer to signed BLOB.
						nSignBlob,			// Size of signed BLOB.
						1,                  // Number of messages
						MessageArray,       // Messages to be signed
						MessageSizeArray,   // Size of messages
						&pSignerCert))      // Pointer to signer certificate.
					{
						CString strSigner = GetCertString(pSignerCert);
						if (dwIndex == 0) {
							CString strMsg;
							strMsg.Format(IDS_VERIFICATIONMESSAGE, strAlg, strSigner);
							strFinalMessage += strMsg;
						} else {
							strFinalMessage += strSigner + "\n";
						}

						if (!VerifyCert(pSignerCert, hAdditionalStore)) {
							CString str; str.LoadString(IDS_UNTRUSTEDCERT);
							strFinalMessage += str;
							nFinalNotice = MB_OK|MB_ICONEXCLAMATION;
						}

						GetNameAndAddr(szName, 256, szEMail, 256, strSigner.GetBuffer(strSigner.GetLength()));
						lstSigners.AddTail(szEMail);

					} else {
						if (GetLastError() == NTE_BAD_SIGNATURE) {
							CString strErr; strErr.LoadString(IDS_BADSIGNATURE);
							strFinalMessage += strErr;
							nFinalNotice = MB_OK|MB_ICONSTOP;
						} else {
							if (dwIndex && GetLastError() == CRYPT_E_NO_SIGNER) {
								nLastProcess = BKA_SMIME_PROCESS_SIGN;
								nSignatureCount++;
								break;
							}
							HandleError(IDS_ERRORVERIFY, hWnd);
							bError = TRUE;
							break;
						}
					}
					dwIndex++;
					if (pSignerCert) {
						arrSignerCert.Add(pSignerCert);
						pSignerCert = NULL;
					}
				} while (TRUE);

				if (hAdditionalStore) CertCloseStore(hAdditionalStore, CERT_CLOSE_STORE_CHECK_FLAG);

				if (pSignerCert) arrSignerCert.Add(pSignerCert);
				strFinalSource = lpBody;
				free(lpBody);
				if (bError) break;

				BOOL bMatched = FALSE;
				do {
					POSITION pos = lstSigners.GetHeadPosition();
					while (pos) {
						CString strSignerAddr = lstSigners.GetNext(pos);
						if (__stristr((LPSTR)(LPCTSTR)strSender, (LPSTR)(LPCTSTR)strSignerAddr)) {
							bMatched = TRUE;
							break;
						}
					}
				} while (0);
				if (!bMatched) {
					CString str; str.LoadString(IDS_UNTRUSTEDFROM);
					strFinalMessage += str;
				}
			}
		} else if (pEnc) { // encoded
			pEnc->GetHeader("Content-Type", szHeader, 32768);
			BOOL bVerifySkip = FALSE;
			int cbEncryptedBlob = 0;
			LPBYTE pbEncryptedBlob = NULL;
			LPSTR lpSign = pEnc->ToString();
			LPSTR lpBegin = strstr(lpSign, "\r\n\r\n");
			if (lpBegin) {
				lpBegin += 4;
			} else break;
			CString strSign = lpBegin;
			free(lpSign);
			FILE* fp;
			if (fp = fopen(szAsc, "wb")) {
				fwrite(strSign, strSign.GetLength(), 1, fp);
				fclose(fp);
			}
			CString strEncrypted;
			pbEncryptedBlob = (LPBYTE)strEncrypted.GetBuffer(strSign.GetLength()*2 + 2);
			if (bka.B64Convert(szOut, szAsc, FALSE)) {
				if (fp = fopen(szOut, "rb")) {
					fread(pbEncryptedBlob, strSign.GetLength()*2, 1, fp);
					cbEncryptedBlob = ftell(fp);
					fclose(fp);
				}
			}
			CString strAlg;
			DWORD dwType = GetEncodedMessageParam(pbEncryptedBlob, cbEncryptedBlob, strAlg);
			if (dwType == CMSG_ENVELOPED) {
				bVerifySkip = TRUE;
			}

			if (dwType != CMSG_SIGNED) { // skip decrypting if its a signature.

				HCERTSTORE hStoreHandle = NULL;
				HCERTSTORE hMyStoreHandle = NULL;
				DWORD cbDecryptedMessage;
				CRYPT_DECRYPT_MESSAGE_PARA  DecryptParams;
				DWORD  DecryptParamsSize = sizeof(DecryptParams);
				BYTE*  pbDecryptedMessage = NULL;
				PCCERT_CONTEXT pDecryptContext = NULL;
				do {
					if(!(hMyStoreHandle = CertOpenSystemStore(NULL, "MY"))) {
						HandleError(IDS_ERRORSTORE, hWnd);
						break;
					}
					if(!(hStoreHandle = CertOpenSystemStore(NULL, "AddressBook"))) {
						HandleError(IDS_ERRORSTORE, hWnd);
						break;
					}

					HCERTSTORE CertStoreArray[] = {hMyStoreHandle, hStoreHandle};

					memset(&DecryptParams, 0, DecryptParamsSize);
					DecryptParams.cbSize = DecryptParamsSize;
					DecryptParams.dwMsgAndCertEncodingType = MY_ENCODING_TYPE;
					DecryptParams.cCertStore = 2;
					DecryptParams.rghCertStore = CertStoreArray;

					//--------------------------------------------------------------------
					//  Decrypt the message data.
					//  Call CryptDecryptMessage to get the returned data size.
					if( !CryptDecryptMessage(
							  &DecryptParams,
							  pbEncryptedBlob,
							  cbEncryptedBlob,
							  NULL,
							  &cbDecryptedMessage,
							  NULL)) {
						if (GetLastError() == CRYPT_E_UNEXPECTED_MSG_TYPE) {
							break;
						}
						HandleError(IDS_ERRORDECRYPT, hWnd);
						bError = TRUE;
						break;
					}

					CString strDecrypt;
					pbDecryptedMessage = (BYTE*)strDecrypt.GetBuffer(cbDecryptedMessage);

					if(CryptDecryptMessage(
							  &DecryptParams,
							  pbEncryptedBlob,
							  cbEncryptedBlob,
							  pbDecryptedMessage,
							  &cbDecryptedMessage,
							  &pDecryptContext)) {

						LPSTR lpSource = strFinalSource.GetBuffer(cbDecryptedMessage+1);
						memcpy(lpSource, pbDecryptedMessage, cbDecryptedMessage+1);
						strFinalSource.ReleaseBuffer(cbDecryptedMessage);
						CString strMsg;
						strMsg.Format(IDS_DECRYPTMESSAGE, strAlg, GetCertString(pDecryptContext));
						strFinalMessage += strMsg;
						nLastProcess = BKA_SMIME_PROCESS_ENCR;
						nEncryptedCount++;
						bVerifySkip = TRUE;
					} else {
						if (GetLastError() == CRYPT_E_UNEXPECTED_MSG_TYPE) {
							break;
						}
						HandleError(IDS_ERRORDECRYPT, hWnd);
						bError = TRUE;
						break;
					}
				} while (0);
				if (pDecryptContext) CertFreeCertificateContext(pDecryptContext);
				if (hStoreHandle) {
					if (!CertCloseStore(hStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG)) {
						TRACE("Store close\n"
							  "But not all certificates, CRLs or CTLs were freed");
					}
				}
				if (hMyStoreHandle) {
					if (!CertCloseStore(hMyStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG)) {
						TRACE("Store close\n"
							  "But not all certificates, CRLs or CTLs were freed");
					}
				}
			}

			if (!bVerifySkip && !bError) {

				CRYPT_VERIFY_MESSAGE_PARA VerifyParams;
				BYTE  *pbDecodedMessageBlob = NULL;
				DWORD cbDecodedMessageBlob;
				PCCERT_CONTEXT pSignerCert = NULL;

				HCERTSTORE hAdditionalStore = CryptGetMessageCertificates(MY_ENCODING_TYPE, NULL, 0, pbEncryptedBlob, cbEncryptedBlob);
				pbCertBlob = (LPBYTE)strCertBlob.GetBuffer(cbEncryptedBlob);
				memcpy(pbCertBlob, pbEncryptedBlob, cbEncryptedBlob);
				cbCertBlob = cbEncryptedBlob;

				do {
					//  Initialize the VerifyParams data structure.
					VerifyParams.cbSize = sizeof(CRYPT_VERIFY_MESSAGE_PARA);
					VerifyParams.dwMsgAndCertEncodingType = MY_ENCODING_TYPE;
					VerifyParams.hCryptProv = 0;
					VerifyParams.pfnGetSignerCertificate = NULL;
					VerifyParams.pvGetArg = NULL;

					DWORD dwIndex = 0;
					DWORD dwSize = 0;
					do {
						if(CryptVerifyMessageSignature(
							&VerifyParams,           // Verify parameters.
							dwIndex,                       // Signer index.
							pbEncryptedBlob,     // Pointer to signed BLOB.
							cbEncryptedBlob,     // Size of signed BLOB.
							NULL,                    // Buffer for decoded message.
							&dwSize,                    // Size of buffer.
							&pSignerCert)) {
							CString strSigner = GetCertString(pSignerCert);
							if (dwIndex == 0) {
								CString strMsg;
								strMsg.Format(IDS_VERIFICATIONMESSAGE, strAlg, strSigner);
								strFinalMessage += strMsg;
								cbDecodedMessageBlob = dwSize;
							} else {
								strFinalMessage += strSigner + "\n";
							}
							if (!VerifyCert(pSignerCert, hAdditionalStore)) {
								CString str; str.LoadString(IDS_UNTRUSTEDCERT);
								strFinalMessage += str;
								nFinalNotice = MB_OK|MB_ICONEXCLAMATION;
							}
							GetNameAndAddr(szName, 256, szEMail, 256, strSigner.GetBuffer(strSigner.GetLength()));
							lstSigners.AddTail(szEMail);
						} else {
							if (GetLastError() == CRYPT_E_UNEXPECTED_MSG_TYPE) {
								break;
							} else
							if (GetLastError() == NTE_BAD_SIGNATURE) {
								CString strErr; strErr.LoadString(IDS_BADSIGNATURE);
								strFinalMessage += strErr;
								nFinalNotice = MB_OK|MB_ICONSTOP;
								break;
							} else {
								if (dwIndex && GetLastError() == CRYPT_E_NO_SIGNER) {
									nLastProcess = BKA_SMIME_PROCESS_SIGN;
									nSignatureCount++;
									break;
								}
								HandleError(IDS_ERRORVERIFY, hWnd);
								bError = TRUE;
								break;
							}
						}
						dwIndex++;
						if (pSignerCert) {
							arrSignerCert.Add(pSignerCert);
							pSignerCert = NULL;
						}
					} while (TRUE);

					if (bError) break;
					BOOL bMatched = FALSE;
					do {
						POSITION pos = lstSigners.GetHeadPosition();
						while (pos) {
							CString strSignerAddr = lstSigners.GetNext(pos);
							if (__stristr((LPSTR)(LPCTSTR)strSender, (LPSTR)(LPCTSTR)strSignerAddr)) {
								bMatched = TRUE;
								break;
							}
						}
					} while (0);
					if (!bMatched) {
						CString str; str.LoadString(IDS_UNTRUSTEDFROM);
						strFinalMessage += str;
					}

					CString strDecoded;
					pbDecodedMessageBlob = (LPBYTE)strDecoded.GetBuffer(cbDecodedMessageBlob);

					if(CryptVerifyMessageSignature(
						&VerifyParams,           // Verify parameters.
						0,                       // Signer index.
						pbEncryptedBlob,     // Pointer to signed BLOB.
						cbEncryptedBlob,     // Size of signed BLOB.
						pbDecodedMessageBlob,    // Buffer for decoded message.
						&cbDecodedMessageBlob,   // Size of buffer.
						NULL))                   // Pointer to signer certificate.
					{
						LPSTR lpSource = strFinalSource.GetBuffer(cbDecodedMessageBlob+1);
						memcpy(lpSource, pbDecodedMessageBlob, cbDecodedMessageBlob+1);
						strFinalSource.ReleaseBuffer(cbDecodedMessageBlob);
					} else {
						if (GetLastError() == CRYPT_E_UNEXPECTED_MSG_TYPE) {
							break;
						}
						HandleError(IDS_ERRORVERIFY, hWnd);
						bError = TRUE;
						break;
					}
				} while (0);
				
				if (hAdditionalStore) CertCloseStore(hAdditionalStore, CERT_CLOSE_STORE_CHECK_FLAG);

				if (pSignerCert) arrSignerCert.Add(pSignerCert);
			}
			if (bError) break;
		} else { // final
			break;
		}
		if (pItem && pItem != &item) {
			delete pItem;
		}
		pItem = new CMIMEItem;
		CString strSource = strFinalSource;
		LPSTR lpSource = strSource.GetBuffer(strSource.GetLength());
		pItem->FromString(lpSource);
	} while (TRUE);
	if (pItem && pItem != &item) {
		delete pItem;
		if (strFinalSource.GetLength()) {
			LPSTR lpArea = strFinalSource.GetBuffer(strFinalSource.GetLength());
			CMIMEItem itemDecrypt;
			LPSTR lpStr = lpArea;
			itemDecrypt.FromString(lpStr);
			strcpy(item.m_szType, itemDecrypt.m_szType);
			strcpy(item.m_szSubType, itemDecrypt.m_szSubType);
			char szHeader[32768];
			itemDecrypt.GetHeader("Content-Type", szHeader, 32768);
			if (szHeader[0]) {
				item.SetHeader("Content-Type", szHeader);
			} else {
				item.SetHeader("Content-Type", "text/plain\r\n");
			}
			itemDecrypt.GetHeader("Content-Transfer-Encoding", szHeader, 32768);
			if (szHeader[0]) {
				item.SetHeader("Content-Transfer-Encoding", szHeader);
			} else {
				item.SetHeader("Content-Transfer-Encoding", "7bit\r\n");
			}
			itemDecrypt.GetHeader("Content-Disposition", szHeader, 32768);
			if (szHeader[0]) {
				item.SetHeader("Content-Disposition", szHeader);
			} else {
				item.SetHeader("Content-Disposition", "");
			}
			if (item.m_lpBoundary) {
				free(item.m_lpBoundary);
				item.m_lpBoundary = NULL;
			}
			if (itemDecrypt.m_lpBoundary) {
				item.m_lpBoundary = strdup(itemDecrypt.m_lpBoundary);
			}
			item.m_lstBody.Empty();
			item.SetChild(NULL);
			LPSTR lpBody = strstr(lpArea, "\r\n\r\n");
			if (lpBody) {
				lpBody += 4;
			} else {
				lpBody = "\r\n";
			}
			{
				CPointerItem* pItem = itemDecrypt.m_lstHeaders.GetTop();
				while (pItem) {
					CPointerItem* pRemoveItem = NULL;
					if (strnicmp("Content-", pItem->GetData(), 8) &&
						strnicmp("MIME-Version", pItem->GetData(), 12) &&
						*pItem->GetData() != '\r') {
						item.m_lstHeaders.InsertBefore(item.m_lstHeaders.GetTail(), pItem->GetData());
						pRemoveItem = pItem;
					}
					pItem = pItem->GetNext();
					if (pRemoveItem) {
						itemDecrypt.m_lstHeaders.Remove(pRemoveItem);
					}
				}
			}
			item.m_lstBody.AddTail(lpBody);
			lpArea = item.ToString();
			bka.SetSource("TEMP", lpArea);
			free(lpArea);
		}
	} else if (!bError) {
		if (strFinalMessage.IsEmpty()) {
			strFinalMessage.LoadString(IDS_SMIME_ERROR);
		}
	}
	DeleteFile(szAsc);
	DeleteFile(szTxt);
	DeleteFile(szOut);

	if (nLastProcess == BKA_SMIME_PROCESS_ENCR &&
		nSignatureCount) {
		CString strMsg;
		strMsg.LoadString(IDS_SIGNATURE_WARNING);
		strFinalMessage += strMsg;
	}
	CArray<PCCERT_CONTEXT, PCCERT_CONTEXT> arrCertToAdd;
	HCERTSTORE hStoreHandle = NULL;
	if (arrSignerCert.GetSize()) {
		if((hStoreHandle = CertOpenSystemStore(NULL, "AddressBook"))) {
			for (int i=0; i<arrSignerCert.GetSize(); i++) {
				PCCERT_CONTEXT pCertContext = CertFindCertificateInStore( 
											   hStoreHandle,				// Handle of the store to be searched. 
											   MY_ENCODING_TYPE,        // Encoding type.
											   0,						// dwFindFlags. Special find criteria. 
											   CERT_FIND_EXISTING,		// Existing check.
											   arrSignerCert[i],		// Data to find	
											   NULL);
				if (!pCertContext) {
					arrCertToAdd.Add(arrSignerCert[i]);
				} else CertFreeCertificateContext(pCertContext);
			}
		} else {
			HandleError(IDS_ERRORSTORE, hWnd);
		}
		
		if (arrCertToAdd.GetSize() && (nFinalNotice & MB_ICONINFORMATION)) {
			nFinalNotice = MB_ICONQUESTION|MB_YESNO;
			CString strMsg;
			strMsg.LoadString(IDS_ADDSIGNERCERT);
			strFinalMessage += strMsg;
		}
	}
	strFinalMessage.TrimLeft();
	strFinalMessage.TrimRight();
	if (!strFinalMessage.IsEmpty()) {
		int nRC = MessageBox(hWnd, strFinalMessage, "S/MIME message", nFinalNotice);
		if (nRC == IDYES && arrCertToAdd.GetSize() && hStoreHandle) {
			for (int i=0; i<arrCertToAdd.GetSize(); i++) {
				if (!CertAddCertificateContextToStore(hStoreHandle, arrCertToAdd[i], CERT_STORE_ADD_USE_EXISTING, NULL)) {
					// Failed to Add
					HandleError(IDS_ERROR_GENERAL, hWnd);
				}
			}
		}
		if (nRC == IDYES && pbCertBlob)
		{
			HCERTSTORE hAdditionalStore = CryptGetMessageCertificates(MY_ENCODING_TYPE, NULL, 0, pbCertBlob, cbCertBlob);
			if (hAdditionalStore) {
				StoreCACert(hAdditionalStore);
				CertCloseStore(hAdditionalStore, CERT_CLOSE_STORE_CHECK_FLAG);
			}
		}
	}
	for (int i=0; i<arrSignerCert.GetSize(); i++) {
		BOOL bBreak = FALSE;
		for (int j=0; j<arrCertToAdd.GetSize(); j++) {
			if (arrSignerCert[i] == arrCertToAdd[j]) {
				bBreak = TRUE; // Added, so no need to free.
				break;
			}
		}
		if (!bBreak) CertFreeCertificateContext(arrSignerCert[i]);
	}
	if (hStoreHandle) {
		if(!CertCloseStore(hStoreHandle, CERT_CLOSE_STORE_CHECK_FLAG)) {
			TRACE("Store close\n"
				  "But not all certificates, CRLs or CTLs were freed");
		}
	}

	return bRet;
}


//--------------------------------------------------------------------------------------
// Menu callbacks.
void WINAPI CmdSMIME(HWND hWnd, LPARAM lParam)
{
	SMIMEDecryptAndVerify(hWnd);
}

void WINAPI CmdSMIMEEnc(HWND hWnd, LPARAM lParam)
{
	SendMessage(hWnd, WM_SET_TRANSFER_SAFE, (WPARAM)TRUE, 0);

	CString strSource;
	CString strMessage;

	LPSTR lpSrc = bka.CompGetSource(hWnd);
	if (lpSrc) {
		strSource = lpSrc;
		bka.Free(lpSrc);
		if (SMIMEEncryptData(hWnd, strSource, strMessage)) {
			bka.CompSetSource(hWnd, strSource);
			::SendMessage(hWnd, WM_SET_READONLY, TRUE, 0);
			strMessage.TrimLeft(); strMessage.TrimRight();
			if (!strMessage.IsEmpty()) {
				MessageBox(hWnd, strMessage, "S/MIME message", MB_OK|MB_ICONINFORMATION);
			}
		}

	}

}

void WINAPI CmdSMIMESig(HWND hWnd, LPARAM lParam)
{
	SendMessage(hWnd, WM_SET_TRANSFER_SAFE, (WPARAM)TRUE, 0);

	CString strSource;
	CString strMessage;

	LPSTR lpSrc = bka.CompGetSource(hWnd);
	if (lpSrc) {
		strSource = lpSrc;
		bka.Free(lpSrc);
		if (SMIMESignData(hWnd, strSource, strMessage, g_bClearTextSign)) {
			bka.CompSetSource(hWnd, strSource);
			::SendMessage(hWnd, WM_SET_READONLY, TRUE, 0);
			strMessage.TrimLeft(); strMessage.TrimRight();
			if (!strMessage.IsEmpty()) {
				MessageBox(hWnd, strMessage, "S/MIME message", MB_OK|MB_ICONINFORMATION);
			}
		}
	}
}

void WINAPI CmdSMIMESigEnc(HWND hWnd, LPARAM lParam)
{
	SendMessage(hWnd, WM_SET_TRANSFER_SAFE, (WPARAM)TRUE, 0);

	CString strSource;
	CString strMessage;

	LPSTR lpSrc = bka.CompGetSource(hWnd);

	if (lpSrc) {
		strSource = lpSrc;
		bka.Free(lpSrc);
		if (SMIMESignData(hWnd, strSource, strMessage, FALSE)) {
			if (SMIMEEncryptData(hWnd, strSource, strMessage)) {
				bka.CompSetSource(hWnd, strSource);
				::SendMessage(hWnd, WM_SET_READONLY, TRUE, 0);
				strMessage.TrimLeft(); strMessage.TrimRight();
				if (!strMessage.IsEmpty()) {
					MessageBox(hWnd, strMessage, "S/MIME message", MB_OK|MB_ICONINFORMATION);
				}
			}
		}
	}
}

void WINAPI SetupSMIME(HWND hWnd, LPARAM lParam)
{
	CSMIMESetting dlg;
	char sz[256];
	LoadString(AfxGetInstanceHandle(), IDS_PIN_NAME, sz, 255);
    dlg.m_strAbout = sz;
	dlg.m_strAbout += " (";
    dlg.m_strAbout += g_szVendor;
	dlg.m_strAbout += ")\n";
	dlg.m_strAbout += g_szVer;
	dlg.m_nAlgorithm = g_nAlgorithm;
	dlg.m_nHash = g_nHash;
	dlg.m_bClearTextSign = g_bClearTextSign;
	dlg.m_nEncryptCert = g_nEncryptCert;
	dlg.m_nSignCert = g_nSignCert;
	dlg.m_strEncryptCert = g_strEncryptCert;
	dlg.m_strSignCert = g_strSignCert;
	if (dlg.DoModal() == IDOK) {
		if (g_nAlgorithm != dlg.m_nAlgorithm) {
			g_nAlgorithm = dlg.m_nAlgorithm;
			WritePrivateProfileInt("Settings", "Encryption", g_nAlgorithm, szIni);
		}
		if (g_nHash != dlg.m_nHash) {
			g_nHash = dlg.m_nHash;
			WritePrivateProfileInt("Settings", "Hash", g_nHash, szIni);
		}
		if (g_nEncryptCert != dlg.m_nEncryptCert) {
			g_nEncryptCert = dlg.m_nEncryptCert;
			WritePrivateProfileInt("Settings", "EncryptCert", g_nEncryptCert, szIni);
		}
		if (g_nSignCert != dlg.m_nSignCert) {
			g_nSignCert = dlg.m_nSignCert;
			WritePrivateProfileInt("Settings", "SignCert", g_nSignCert, szIni);
		}
		if (g_strEncryptCert != dlg.m_strEncryptCert) {
			g_strEncryptCert = dlg.m_strEncryptCert;
			WritePrivateProfileString("Settings", "EncryptCertAddress", g_strEncryptCert, szIni);
		}
		if (g_strSignCert != dlg.m_strSignCert) {
			g_strSignCert = dlg.m_strSignCert;
			WritePrivateProfileString("Settings", "SignCertAddress", g_strSignCert, szIni);
		}
		if (g_bClearTextSign != dlg.m_bClearTextSign) {
			g_bClearTextSign = dlg.m_bClearTextSign;
			WritePrivateProfileInt("Settings", "ClearTextSign", g_bClearTextSign, szIni);
		}

	}
}

UINT CALLBACK CmdUIProc(HWND hWnd, LPARAM lParam)
{
    UINT nRetVal = 0;
	char szBuf[1024];
	bka.GetSpecifiedHeader("Content-Type", szBuf, 1024);
    if (__stristr(szBuf, "pkcs7-")) {
		// OK
	} else
	if (__stristr(szBuf, ".p7s") || __stristr(szBuf, ".p7m")) {
		// OK
    } else {
        nRetVal |= BKMENU_CMDUI_DISABLED;
	}
    return nRetVal;
}

/////////////////////////////////////////////////////////////////////////////////////////////
// Callbacks from Becky!

////////////////////////////////////////////////////////////////////////
// Called when the program is started and the main window is created.
int WINAPI BKC_OnStart()
{
	/*
	Since BKC_OnStart is called after Becky!'s main window is
	created, at least BKC_OnMenuInit with BKC_MENU_MAIN is called
	before BKC_OnStart. So, do not assume BKC_OnStart is called
	prior to any other callback.
	*/
	// Always return 0.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when the main window is closing.
int WINAPI BKC_OnExit()
{
	// Return -1 if you don't want to quit.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when menu is intialized.
int WINAPI BKC_OnMenuInit(HWND hWnd, HMENU hMenu, int nType)
{
	switch (nType) {
	case BKC_MENU_MAIN:
		{
            HMENU hSubMenu = GetSubMenu(hMenu, 4);
            AppendMenu(hSubMenu, MF_SEPARATOR, 0, NULL);

			char szMsg[82];
			UINT nID;
			LoadString(AfxGetInstanceHandle(), IDS_SMIME_DECRYPT, szMsg, 80);
			nID = bka.RegisterCommand(szMsg, nType, CmdSMIME);
			LoadString(AfxGetInstanceHandle(), IDS_SMIMEMENU_DECRYPT, szMsg, 80);
            AppendMenu(hSubMenu, MF_STRING, nID, szMsg);
            bka.RegisterUICallback(nID, CmdUIProc);

			LoadString(AfxGetInstanceHandle(), IDS_SMIME_SETUP, szMsg, 80);
			nID = bka.RegisterCommand(szMsg, nType, SetupSMIME);
			LoadString(AfxGetInstanceHandle(), IDS_SMIMEMENU_SETUP, szMsg, 80);
            AppendMenu(hSubMenu, MF_STRING, nID, szMsg);
		}
		break;
	case BKC_MENU_LISTVIEW:
		break;
	case BKC_MENU_TREEVIEW:
		break;
	case BKC_MENU_MSGVIEW:
		break;
	case BKC_MENU_MSGEDIT:
		break;
	case BKC_MENU_TASKTRAY:
		break;
	case BKC_MENU_COMPOSE:
		{
            HMENU hSubMenu = GetSubMenu(hMenu, 3);
            AppendMenu(hSubMenu, MF_SEPARATOR, 0, NULL);
			char szMsg[82];
			UINT nID;
			LoadString(AfxGetInstanceHandle(), IDS_SMIME_ENCRYPT, szMsg, 80);
			nID = bka.RegisterCommand(szMsg, nType, CmdSMIMEEnc);
			LoadString(AfxGetInstanceHandle(), IDS_SMIMEMENU_ENCRYPT, szMsg, 80);
            AppendMenu(hSubMenu, MF_STRING, nID, szMsg);

			LoadString(AfxGetInstanceHandle(), IDS_SMIME_SIGN, szMsg, 80);
			nID = bka.RegisterCommand(szMsg, nType, CmdSMIMESig);
			LoadString(AfxGetInstanceHandle(), IDS_SMIMEMENU_SIGN, szMsg, 80);
            AppendMenu(hSubMenu, MF_STRING, nID, szMsg);

			LoadString(AfxGetInstanceHandle(), IDS_SMIME_SIGNENCRYPT, szMsg, 80);
			nID = bka.RegisterCommand(szMsg, nType, CmdSMIMESigEnc);
			LoadString(AfxGetInstanceHandle(), IDS_SMIMEMENU_SIGNENCRYPT, szMsg, 80);
            AppendMenu(hSubMenu, MF_STRING, nID, szMsg);

		}
		break;
	case BKC_MENU_COMPEDIT:
		break;
	case BKC_MENU_COMPREF:
		break;
	default:
		break;
	}
	// Always return 0.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when a folder is opened.
int WINAPI BKC_OnOpenFolder(LPCTSTR lpFolderID)
{
	// Always return 0.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when a mail is selected.
int WINAPI BKC_OnOpenMail(LPCTSTR lpMailID)
{
	CString strHeader;
	LPSTR szHeader = strHeader.GetBuffer(32770);
	bka.GetSpecifiedHeader("Content-Type", szHeader, 32768);
	if (__stristr(szHeader, "pkcs7-mime") ||
		__stristr(szHeader, ".p7s") ||
		__stristr(szHeader, ".p7m") ) {
		CString strMsg;
		strMsg.LoadString(IDS_SMIMEMSG);
		bka.SetText(-2, strMsg);
	}
	// Always return 0.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called every minute.
int WINAPI BKC_OnEveryMinute()
{
	// Always return 0.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when a compose windows is opened.
int WINAPI BKC_OnOpenCompose(HWND hWnd, int nMode/* See COMPOSE_MODE_* in BeckyApi.h */)
{
	char szContent[1026];
	bka.CompGetSpecifiedHeader(hWnd, "Content-Type", szContent, 1024);
	if (strstr(szContent, "multipart/signed") &&
		strstr(szContent, "pkcs7-signature")) {
		SendMessage(hWnd, WM_SET_TRANSFER_SAFE, (WPARAM)TRUE, 0);
		SendMessage(hWnd, WM_SET_READONLY, (WPARAM)TRUE, 0);
	} else
	if (strstr(szContent, "pkcs7-mime")) {
		SendMessage(hWnd, WM_SET_READONLY, (WPARAM)TRUE, 0);
	}
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when the composing message is saved.
int WINAPI BKC_OnOutgoing(HWND hWnd, int nMode/* 0:SaveToOutbox, 1:SaveToDraft, 2:SaveToReminder*/) 
{
	// Return -1 if you do not want to send it yet.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when a key is pressed.
int WINAPI BKC_OnKeyDispatch(HWND hWnd, int nKey/* virtual key code */, int nShift/* Shift state. 0x40=Shift, 0x20=Ctrl, 0x60=Shift+Ctrl, 0xfe=Alt*/)
{
	// Return TRUE if you want to suppress subsequent command associated to this key.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when a message is retrieved and saved to a folder
int WINAPI BKC_OnRetrieve(LPCTSTR lpMessage/* Message source*/, LPCTSTR lpMailID/* Mail ID*/)
{
	// Always return 0.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when a message is spooled
int WINAPI BKC_OnSend(LPCTSTR lpMessage/* Message source */)
{
	// Return BKC_ONSEND_PROCESSED, if you have processed this message
	// and don't need Becky! to send it.
	// Becky! will move this message to Sent box when the sending
	// operation is done.
	// CAUTION: You are responsible for the destination of this
	// message if you return BKC_ONSEND_PROCESSED.

	// Return BKC_ONSEND_ERROR, if you want to cancel the sending operation.
	// You are responsible for displaying an error message.

	// Return 0 to proceed the sending operation.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when all messages are retrieved
int WINAPI BKC_OnFinishRetrieve(int nNumber/* Number of messages*/)
{
	// Always return 0.
	return 0;
}


////////////////////////////////////////////////////////////////////////
// Called when plug-in setup is needed.
int WINAPI BKC_OnPlugInSetup(HWND hWnd)
{
	SetupSMIME(hWnd, 0);
	return TRUE;
}


////////////////////////////////////////////////////////////////////////
// Called when plug-in information is being retrieved.
typedef struct tagBKPLUGININFO
{
	char szPlugInName[80]; // Name of the plug-in
	char szVendor[80]; // Name of the vendor
	char szVersion[80]; // Version string
	char szDescription[256]; // Short description about this plugin
} BKPLUGININFO, *LPBKPLUGININFO;

int WINAPI BKC_OnPlugInInfo(LPBKPLUGININFO lpPlugInInfo)
{
	char sz[256];
	LoadString(AfxGetInstanceHandle(), IDS_PIN_NAME, sz, 255);
    strcpy(lpPlugInInfo->szPlugInName, sz);
    strcpy(lpPlugInInfo->szVendor, g_szVendor);
    strcpy(lpPlugInInfo->szVersion, g_szVer);
	LoadString(AfxGetInstanceHandle(), IDS_PIN_DESCRIPTION, sz, 255);
    strcpy(lpPlugInInfo->szDescription, sz);
    // Always return 0.
	return 0;
}

////////////////////////////////////////////////////////////////////////
// Called when drag and drop operation occurs.
int WINAPI BKC_OnDragDrop(LPCSTR lpTgt, LPCSTR lpSrc, int nCount, int dropEffect)
{
	/*
	lpTgt:	A folder ID of the target folder.
			You can assume it is a root mailbox, if the string
			contains only one '\' character.
	lpSrc:	Either a folder ID or mail IDs. Multiple mail IDs are
			separated by '\n' (0x0a).
			You can assume it is a folder ID, if the string
			doesn't contain '?' character.
	nCount:	Number of items to be dropped.
			It can be more than one, if you drop mail items.
	dropEffect: Type of drag and drop operation
			1: Copy
			2: Move
			4: Link (Used for filtering setup in Becky!)
	*/
	// If you want to cancel the default drag and drop action,
	// return -1;
	// Do not assume the default action (copy, move, etc.) is always
	// processed, because other plug-ins might cancel the operation.
	return 0;
}


////////////////////////////////////////////////////////////////////////
// Called when a message was retrieved and about to be filtered.
int WINAPI BKC_OnBeforeFilter(LPCSTR lpMessage, int* lpnAction, char** lppParam)
{
	/*
    lpMessage: A complete message source, which ends with
    "<CRLF>.<CRLF>".
    lpnAction:	[out] Returns the filtering action to be applied.
    	#define ACTION_NOTHING		-1	// Do nothing
		#define ACTION_MOVEFOLDER	0	// Move to a folder
		#define ACTION_COLORLABEL	1	// Set the color label
		#define ACTION_SETFLAG		2	// Set the flag
		#define ACTION_SOUND		3	// Make a sound
		#define ACTION_RUNEXE		4	// Run executable file
		#define ACTION_REPLY		5	// Reply to the message
		#define ACTION_FORWARD		6	// Forward the message
		#define ACTION_LEAVESERVER	7	// Leave/delete on the server.
		#define ACTION_ADDHEADER	8	// Add "X-" header to the top of the message. (Plug-in only feature)
	lppParam:	[out] Returns the pointer to the filtering parameter string.
		ACTION_MOVEFOLDER:	Folder name.
							e.g. XXXXXXXX.mb\FolderName\
							or \FolderName\ (begin with '\') to use
							the mailbox the message belongs.
		ACTION_COLORLABEL:	Color code(BGR) in hexadecimal. e.g. 0088FF
		ACTION_SETFLAG:		"F" to set flag. "R" to set read.
		ACTION_SOUND:		Name of the sound file.
		ACTION_RUNEXE:		Command line to execute. %1 will be replaced with the path to the file that contains the entire message.
		ACTION_REPLY:		Path to the template file without extension.
								e.g. #Reply\MyReply
		ACTION_FORWARD:		Path to the template file without extension. + "*" + Address to forward.
								e.g. #Forward\MyForward*mail@address
									 *mail@address (no template)
		ACTION_LEAVESERVER:	The string consists of one or two decimals. The second decimal is optional.
							Two decimals must be separated with a space.
							First decimal	1: Delete the message from the server.
											0: Leave the message on the server.
							Second decimal	1: Do not store the message to the folder.
											0: Store the message to the folder. (default action)
							e.g. 0 (Leave the message on the server.)
								 1 1 (Delete the message on the server and do not save. (Means KILL))
		ACTION_ADDHEADER	"X-Header:data" that will be added at the top of the incoming message.
							You can specify multiple headers by separating CRLF, but each header must
							begin with "X-". e.g. "X-Plugindata1: test\r\nX-Plugindata2: test2";
	*/
	
	/* Return values
	BKC_FILTER_DEFAULT	Do nothing and apply default filtering rules.
	BKC_FILTER_PASS		Apply default filtering rules after applying the rule it returns.
	BKC_FILTER_DONE		Do not apply default rules.
	BKC_FILTER_NEXT		Request Becky! to call this callback again so that another rules can be added.
	*/
    return BKC_FILTER_DEFAULT;
}


