#TITLE=SAS Formats
#INFO
EditPlus Cliptext Library v1.0 written by ES-Computing.
This file is provided as a sample Cliptext library of EditPlus.
#SORT=n

#T=w.           standard numeric
w.
#T=w.d          standard numeric
w.d
#T=BINARYw.d    converts positive values to integers
BINARYw.d
#T=BITSw.d      extracts bits
BITSw.d
#T=BZw.d        blanks are zeros
BZw.d
#T=CBw.d        reads standard numeric values from column-binary files
CBw.d
#T=COMMAw.d     commas in numbers
COMMAw.d
#T=COMMAXw.d    removes embedded characters
COMMAXw.d
#T=Ew.d         scientific notation
Ew.d
#T=FLOATw.d     reads a native single-precision floating-point value and divides it by 10 raised to the dth power.
FLOATw.d
#T=HEXw.        numeric hexadecimal
HEXw.
#T=IBw.d        integer binary
IBw.d
#T=IEEEw.d      reads an IEEE floating-point value and divides it by 10 raised to the dth power
IEEEw.d
#T=MINGUOw.     converts an input value in yymmdd format into a SAS data value
MINGUOw.
#T=MRBw.d       Microsoft real binary (floating point) number
MRBw.d
#T=OCTALw.d     converts positive octal values to integers
OCTALw.d
#T=PDw.d        packed decimal
PDw.d
#T=PKw.d        unsigned packed data
PKw.d
#T=PERCENTw.    converts percentages into numeric values
PERCENTw.
#T=PIBw.d       positive integer binary
PIBw.d
#T=PUNCH.d      reads whether a row of column binary data is punched
PUNCH.d
#T=RBw.d        real binary (floating point)
RBw.d
#T=ROWw.d       reads a column binary field down a card column
ROWw.d
#T=S370FIBw.d   IBM 370 integer binary
S370FIBw.d
#T=S370FPDw.d   IBM 370 packed decimal
S370FPDw.d
#T=S370FRBw.d   IBM 370 real binary
S370FRBw.d
#T=S370FPIBw.d  IBM 370 positive integer binary
S370FPIBw.d
#T=S370FZDw.d   IBM zoned decimal
S370FZDw.d
#T=TUw.         reads timer units
TUw.
#T=YENw.d       removes embedded yen signs, commas, and decimal points
YENw.d
#T=ZDw.d        reads zoned decimal data
ZDw.d
#T=ZDBw.d       reads zoned decimal data with blanks
ZDBw.d
#T=ZDVw.d       reads zoned decimal data
ZDVw.d
#T=$w.          standard character
$w.
#T=$ASCIIw.     converts character data from EBCDIC to ASCII
$ASCIIw.
#T=$BINARYw.    converts character values to binary
$BINARYw.
#T=$CHARw.      characters with blanks
$CHARw.
#T=$EBCDICw.    EBCDIC to ASCII
$EBCDICw.
#T=$HEXw.       character hexa-decimal
$HEXw.
#T=$MSGCASEw.   writes data values  in uppercase, based on the value of the MSGCASE system option
$MSGCASEw.
#T=$OCTALw.     converts to octal representation
$OCTALw.
#T=$QUOTEw.     writes data values enclosed in quotes
$QUOTEw.
#T=$UPCASEw.    writes all characters in uppercase
$UPCASEw.
#T=$VARYINGw.   varying-length characters values
$VARYINGw.
#T=DATEw.       dates of form ddMMMyy
DATEw.
#T=DATETIMEw.d  date-time values
DATETIMEw.d
#T=DAYw.        writes day of month
DAYw.
#T=DDMMYYw.     date values
DDMMYYw.
#T=HHMMw.d      hour and minutes
HHMMw.d
#T=HOURw.d      hour
HOURw.d
#T=JULDAYw.     writes Julian day of the year
JULDAYw.
#T=JULIANw      Julian dates
JULIANw
#T=MMDDYYw.     date values
MMDDYYw.
#T=MMSSw.d      minutes and seconds
MMSSw.d
#T=MMYYxw.      formats that write month and year, separated by a character
MMYYxw.
#T=MONNAMEw.    writes name of month
MONNAMEw.
#T=MONTHw.      writes month of year
MONTHw.
#T=MONYYw.      month and year
MONYYw.
#T=NENGOw.      Japanese date (R.YYMMDD)
NENGOw.
#T=QTRw.        writes quarter of year
QTRw.
#T=QTRRw.       writes quarter of year in Roman numerals
QTRRw.
#T=TIMEw.d      time values
TIMEw.d
#T=TODw.        time-of-day
TODw.
#T=WEEKDATEw.   date values
WEEKDATEw.
#T=WEEKDATXw.   date values
WEEKDATXw.
#T=WEEKDAYw.    writes day of week
WEEKDAYw.
#T=WORDDATEw.   date values
WORDDATEw.
#T=WORDDATXw.   date values
WORDDATXw.
#T=WORDFw.      converts numeric values to words
WORDFw.
#T=WORDSw.      converts numeric values to words
WORDSw.
#T=YEARw.       writes year part of date value
YEARw.
#T=YYMMxw.      formats that write year and month, separated by a character
YYMMxw.
#T=YYMMDDw.     date values
YYMMDDw.
#T=YYMONw.      writes year and month abbreviation
YYMONw.
#T=YYQw.        year and quarter
YYQw.
#T=YYQxw.       formats that write year and quarter, separated by a character
YYQxw.
#T=YYQRxw.      formats that write year and quarter in Roman numerals, separated by character
YYQRxw.
