#TITLE=Perl Functions by Category
#SORT=n

#T=Scalar Manipulation

#T=- chomp
chomp ^! ;
#T=- chop
chop ^! ;
#T=- chr
chr ^! ;
#T=- crypt
crypt ^!, $salt ;
#T=- hex
hex ^! ;
#T=- index
index ^!, , ;
#T=- lc
lc ^! ;
#T=- lcfirst
lcfirst ^! ;
#T=- length
length ^! ;
#T=- oct
oct ^! ;
#T=- ord
ord ^! ;
#T=- pack
pack ^!, ;
#T=- q//
q/^!/;
#T=- qq//
qq/^!/;
#T=- reverse
reverse ^! ;
#T=- rindex
rindex ^!, , ;
#T=- sprintf
sprintf ^!, ;
#T=- substr
substr ^!, , ;
#T=- tr///
tr/^!//;
#T=- uc
uc ^! ;
#T=- ucfirst
ucfirst ^! ;
#T=- y///
y/^!//;

#T=
#T=Regular Expressions
#T=And Pattern Matching
#T=- m//
m/^!/m;
#T=- pos
pos ^! ;
#T=- quotemeta
quotemeta ^! ;
#T=- s///
s/^!//;
#T=- split
split /^!/, , ;
#T=- study
study ^!;

#T=
#T=Numeric Functions
#T=- abs
abs ^!;
#T=- atan2
atan2( ^!Y, X );
#T=- cos
cos ^!;
#T=- exp
exp ^!;
#T=- hex
hex ^!;
#T=- int
int ^!;
#T=- log
log ^!;
#T=- oct
oct ^!;
#T=- rand
rand ^!;
#T=- sin
sin ^!;
#T=- sqrt
sqrt ^!;
#T=- srand
srand ^!;

#T=
#T=Array Processing
#T=- pop
pop ^!;
#T=- push
push ^!, ;
#T=- shift
shift ^!;
#T=- splice
splice ^!, , , ;
#T=- unshift
unshift ^!, ;

#T=
#T=List processing
#T=- grep
grep ^!, ;
#T=- join
join "^!", ;
#T=- map
map ^!;
#T=- qw//
qw/^!/;
#T=- reverse
reverse ^!;
#T=- sort
sort ^!;
#T=- unpack
unpack ^!, ;

#T=
#T=Hash Processing
#T=- delete
delete ^!;
#T=- each
each ^!;
#T=- exists
exists ^!;
#T=- keys
keys ^!;
#T=- values
values ^!;

#T=
#T=Input and Output
#T=- binmode
binmode ^!;
#T=- close
close ^!;
#T=- closedir
closedir ^!;
#T=- dbmclose
dbmclose ^!;
#T=- dbmopen
dbmopen ^!;
#T=- die
die ^!;
#T=- eof
eof ^!;
#T=- fileno
fileno ^!;
#T=- flock
flock ^!, ;
#T=- format
format ^!;
#T=- getc
getc ^!;
#T=- print
print "^!";
#T=- printf
printf "^!";
#T=- read
read ^!, , , ;
#T=- readdir
readdir ^!;
#T=- rewinddir
rewinddir ^!;
#T=- seek
seek ^!, , ;
#T=- seekdir
seekdir ^!, ;
#T=- select
select ^!, , , ;
#T=- syscall
syscall ^!;
#T=- sysread
sysread ^!, , , ;
#T=- syswrite
syswrite ^!, , , ;
#T=- tell
tell ^!;
#T=- telldir
telldir ^!;
#T=- truncate
truncate ^!, ;
#T=- warn
warn "^!";
#T=- write
write ^!;

#T=
#T=Fixed-length data
#T=and Records
#T=- pack
pack ^!, ;
#T=- read
read ^!, , , ;
#T=- syscall
syscall ^!;
#T=- sysread
sysread ^!, , , ;
#T=- syswrite
syswrite ^!, , , ;
#T=- unpack
unpack ^!, ;
#T=- vec
vec ^!, , ;
#T=
#T=Filehandles, Files
#T=and Directories
#T=- chdir
chdir ^!;
#T=- chmod
chmod ^!, ;
#T=- chown
chown $uid, $gid,^! ;
#T=- chroot
chroot ^!;
#T=- fcntl
$sysReturn = fcntl ^!, , ;
#T=- glob
glob ^!;
#T=- ioctl
ioctl ^!, , ;
#T=- link
link ^!, ;
#T=- lstat
lstat ^!;
#T=- mkdir
mkdir ^!, ;
#T=- open
open ^!, ;
#T=- opendir
opendir ^!, ;
#T=- readlink
readlink ^!;
#T=- rename
rename ^!, ;
#T=- rmdir
rmdir ^!;
#T=- stat
stat ^!;
#T=- symlink
symlink ^!, ;
#T=- sysopen
sysopen ^!, , , ;
#T=- umask
umask ^!;
#T=- unlink
unlink ^!;
#T=- utime
utime ^!;

#T= 
#T=Flow Control of Program
#T=- caller
( $package, $filename, $line, $subname, $hasargs, $wantarray ) = caller ^!;
#T=- continue
continue ^!, ;
#T=- die
die ^!;
#T=- do
do ^!;
#T=- dump
dump ^!;
#T=- eval
eval {
	^!;
};
if ($@) {
}
#T=- exit
exit ^!;
#T=- goto
goto ^!;
#T=- last
last ^!;
#T=- next
next ^!;
#T=- redo
redo ^!;
#T=- return
return ^!;
#T=- sub
sub ^! {
}
#T=- wantarray
wantarray ^!;

#T= 
#T=Scoping
#T=- caller
( $package, $filename, $line, $subname, $hasargs, $wantarray ) = caller ^!;
#T=- import
import ^!;
#T=- local
local ( ^! );
#T=- my
my ( ^! );
#T=- package
package ^!;
#T=- use
use ^!;

#T=
#T=Miscellaneous
#T=- defined
defined ^!;
#T=- dump
dump ^!;
#T=- eval
eval {
	^!;
};
if ($@) {
}
#T=- formline
formline ^!, ;
#T=- local
local ( ^! );
#T=- my
my ( ^! );
#T=- reset
reset ^!;
#T=- scalar
scalar ^!;
#T=- undef
undef ^!;
#T=- wantarray
wantarray ^!;

#T=
#T=Processes and Process Groups
#T=- alarm
alarm ^!;
#T=- exec
exec ^!;
#T=- fork
fork ^!;
#T=- getpgrp
getpgrp;
#T=- getppid
getppid;
#T=- getpriority
getpriority ^!, ;
#T=- kill
kill ^!;
#T=- pipe
pipe ^!, ;
#T=- qx//
qx/^!/;
#T=- setpgrp
setpgrp ^!, ;
#T=- setpriority
setpriority ^!, , ;
#T=- sleep
sleep ^!;
#T=- system
system( ^! ) == 0 ;
#T=- times
($user, $system, $cuser, $csystem) = times;
#T=- wait
wait;
#T=- waitpid
waitpid ^!, ;

#T=
#T=Library Modules
#T=- do
do ^!;
#T=- import
import ^!;
#T=- no
no ^!;
#T=- package
package ^!;
#T=- require
require ^!;
#T=- use
use ^!;

#T=
#T=Classes and Objects
#T=- bless
bless ^!, ;
#T=- dbmclose
dbmclose ^!;
#T=- package
package ^!;
#T=- ref
ref ^!;
#T=- tie
tie ^!, , ;
#T=- tied
tied ^!;
#T=- untie
untie ^!;
#T=- use
use ^!;

#T=
#T=Low-Level Socket Access
#T=- accept
accept ^! , ;
#T=- bind
bind ^!, ;
#T=- connect
connect ^!, ;
#T=- getpeername
getpeername ^!;
#T=- getsockname
getsockname ^!;
#T=- getsockopt
getsockopt ^!, , ;
#T=- listen
listen ^!, ;
#T=- recv
recv ^!, , , ;
#T=- send
send ^!, , , ;
#T=- setsockopt
setsockopt ^!, , , ;
#T=- shutdown
shutdown ^!, ;
#T=- socket
socket ^!, , , ;
#T=- socketpair
socketpair ^!, , , , ;

#T=
#T=System V interprocess
#T=Communication
#T=- msgctl
msgctl ^!, , ;
#T=- msgget
msgget ^!, ;
#T=- msgrcv
msgrcv ^!, , , , ;
#T=- msgsnd
msgsnd ^!, , ;
#T=- semctl
semctl ^!, , , ;
#T=- semget
semget ^!, , , ;
#T=- semop
semop ^!, ;
#T=- shmctl
shmctl ^!, , ;
#T=- shmget
shmget ^!, , ;
#T=- shmread
shmread ^!, , , ;
#T=- shmwrite
shmwrite ^!, , , ;

#T=
#T=Fetching User and
#T=Group Information
#T=- endgrent
endgrent();
#T=- endhostent
endhostent();
#T=- endnetent
endnetent();
#T=- endpwent
endpwent();
#T=- getgrent
( $name, $passwd, $gid, $members ) = getgrent();
#T=- getgrgid
( $name, $passwd, $gid, $members ) = getgrgid();
#T=- getgrnam
( $name, $passwd, $gid, $members ) = getgrnam();
#T=- getlogin
getlogin();
#T=- getpwent
( $name, $passwd, $uid, $gid, $quota, $comment, $gcos, $dir, $shell ) = getpwent();
#T=- gwetpwnam
( $name, $passwd, $uid, $gid, $quota, $comment, $gcos, $dir, $shell ) = gwetpwnam();
#T=- getpwuid
( $name, $passwd, $uid, $gid, $quota, $comment, $gcos, $dir, $shell ) = getpwuid();
#T=- setgrent
setgrent( $name, $passwd, $gid, $members );
#T=- setpwent
setpwent( $name, $passwd, $uid, $gid, $quota, $comment, $gcos, $dir, $shell );

#T=
#T=Fetching Network Information
#T=- endprotoent
endprotoent();
#T=- endservent
endservent();
#T=- gethostbyaddr
( $name, $aliases, $addrtype, $length, @addrs ) = gethostbyaddr() ^!, ;
#T=- gethostbyname
( $name, $aliases, $addrtype, $length, @addrs ) = gethostbyname ^!;
#T=- gethostent
( $name, $aliases, $addrtype, $length, @addrs ) = gethostent ^!;
#T=- getnetbyaddr
( $name, $aliases, $addrtype, $net ) = getnetbyaddr ^!;
#T=- getnetbyname
( $name, $aliases, $addrtype, $net ) = getnetbyname ^!;
#T=- getnetent
( $name, $aliases, $addrtype, $net ) = getnetent ^!;
#T=- getprotobyname
( $name, $alias, $protocolNumber ) = getprotobyname ^!;
#T=- getprotobynumber
( $name, $alias, $protocolNumber ) = getprotobynumber ^!;
#T=- getprotoent
( $name, $alias, $protocolNumber ) = getprotoent ^!;
#T=- getservbyname
( $name, $aliases, $portNumber, $protocolName ) = getservbyname ^!, ;
#T=- getservbyport
( $name, $aliases, $portNumber, $protocolName ) = getservbyport ^!, ;
#T=- getservent
( $name, $aliases, $portNumber, $protocolName ) = getservent;
#T=- sethostent
sethostent ^!;
#T=- setnetent
setnetent ^!;
#T=- setprotoent
setprotoent ^!;
#T=- setservent
setservent ^!;

#T=
#T=Time
#T=- gmtime
( $second, $minute, $hour, $monthDay, $month, $year, $weekDay, $yearDay, $isDaylightSavingsTime ) = gmtime();
#T=- localtime
( $second, $minute, $hour, $monthDay, $month, $year, $weekDay, $yearDay, $isDaylightSavingsTime ) = localtime();
#T=- time
$seconds = time();
#T=- times
( $user, $system, $cuser, $csystem ) = times();