#TITLE=Official PHP Functions
#INFO
EditPlus Official PHP File
This file created by: randomblink
http://ninjasquirrels.com
#SORT=n
;;*******************************************************************************	
;;* NINJA SQUIRRELS SOFTWARE DESIGN						*
;;* Copyright (C) 2002 by the Ninja Squirrels Development Team.			*
;;* http://www.ninjasquirrels.com;						*
;;*******************************************************************************	
;;* LICENSE									*
;;*										*
;;* This program is free software; you can redistribute it and;or		*
;;* modify it under the terms of the GNU General Public License (GPL)		*
;;* as published by the Free Software Foundation; either version 2		*
;;* of the License, or (at your option) any later version.			*
;;*										*
;;* This program is distributed in the hope that it will be useful,		*
;;* but WITHOUT ANY WARRANTY; without even the implied warranty of		*
;;* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		*
;;* GNU General Public License for more details.				*
;;*										*
;;* To read the license please visit http:;;www.gnu.org;copyleft;gpl.html	*
;;*******************************************************************************	
;;* Original Author of file:	randomblink					*
;;* Authors Website:		http://randomblink.ninjasquirrels.com		*
;;* Purpose of file:		PHP Clip Text Library for Edit Plus		*
;;*******************************************************************************
;;* This file was created using the following steps:				*
;;* 1) I downloaded the php CHM file from http://www.php.net/download-docs.php  *
;;* 2) I downloaded eTextWizard v.1.95 from http://www.etextwizard.com		*
;;* 3) Using eTextWizard I exported the individual HTML files from the php CHM	*
;;* 4) I put all of the function.*.html files into a single folder.		*
;;* 5) I created a file and named it: combine.bat				*
;;* 6) I edited the combine.bat and put the following lines inside of it.	*
;;* *************************************************************************** *
;;* * combine.bat ************************************************************* *
;;* *************************************************************************** *
;;* *									      * *
;;* * dir *.html /b > filelist.txt					      * *
;;* * FOR %%1 in (*.html) do type %%1 >> combined.html			      * *
;;* *									      * *
;;* * ************************************************************************* *
;;* 7) I then saved the combine.bat file in the same folder as the html files.	*
;;* 8) I double-clicked on the combine.bat file					*
;;* 9) This combined ALL of the function.*.html files into combined.html.	*
;;* 10) I opened combined.html file in Windows Explorer.			*
;;* 11) I saved combined.html file as a TEXT file.				*
;;* 12) Now I had a HUGE combined.txt file which I opened in Edit Plus.		*
;;* 13) I SELECT'ed ALL and SHIFT+TAB to align everything against the left side.*
;;* 14) Then I put my cursor in front of the first entry(abs)			*
;;* 15) I created a macro that parsed the entries and created what you see here.*
;;*******************************************************************************

#T=abs - number abs ( mixed number)
(PHP 3, PHP 4 )
abs -- Absolute value
Description
number abs ( mixed number)
Returns the absolute value of number. If the argument number is of type 
float, the return type is also float, otherwise it is integer (as float 
usually has a bigger value range than integer). 
Example 1. abs() example
  <?php
  $abs = abs(-4.2); // $abs = 4.2; (double/float)
  $abs2 = abs(5);   // $abs2 = 5; (integer)
  $abs3 = abs(-5);  // $abs3 = 5; (integer)
  ?> 
#

#T=number abs ( mixed number)
abs ( ^!mixed number);
#

#T=acos - float acos ( float arg)
(PHP 3, PHP 4 )
acos -- Arc cosine
Description
float acos ( float arg)
Returns the arc cosine of arg in radians. acos() is the complementary 
function of cos(), which means that a==cos(acos(a)) for every value of a 
that is within acos()' range. 
See also acosh(), asin() and atan().   absUpacosh
#

#T=float acos ( float arg)
acos ( ^!float arg);
#

#T=acosh - float acosh ( float arg)
(PHP 4 >= 4.1.0)
acosh -- Inverse hyperbolic cosine
Description
float acosh ( float arg)
Returns the inverse hyperbolic cosine of arg, i.e. the value whose 
hyperbolic cosine is arg. 
Note: This function is not implemented on Windows platforms.
See also acos(), asinh() and atanh().   acosUpasin
#

#T=float acosh ( float arg)
acosh ( ^!float arg);
#

#T=addcslashes - string addcslashes ( string str, string charlist)
(PHP 4 )
addcslashes -- Quote string with slashes in a C style
Description
string addcslashes ( string str, string charlist)
Returns a string with backslashes before characters that are listed in 
charlist parameter. It escapes \n, \r etc. in C-like style, characters 
with ASCII code lower than 32 and higher than 126 are converted to octal 
representation. 
Be careful if you choose to escape characters 0, a, b, f, n, r, t and v. 
They will be converted to \0, \a, \b, \f, \n, \r, \t and \v. In PHP \0 
(NULL), \r (carriage return), \n (newline) and \t (tab) are predefined 
escape sequences, while in C all of these are predefined escape sequences. 

charlist like "\0..\37", which would escape all characters with ASCII code 
between 0 and 37. Example 1. addcslashes() example
  <?php
  $escaped = addcslashes($not_escaped, "\0..\37!@\177..\377");
  ?> 
When you define a sequence of characters in the charlist argument make 
sure that you know what characters come between the characters that you 
set as the start and end of the range. 
<?php
echo addcslashes('foo[ ]', 'A..z');
// output:  \f\o\o\[ \]
// All upper and lower-case letters will be escaped
// ... but so will the [\]^_` and any tabs, line
// feeds, carriage returns, etc.
?> 

Also, if the first character in a range has a higher ASCII value than the 
second character in the range, no range will be constructed. Only the 
start, end and period characters will be escaped. Use the ord() function 
to find the ASCII value for a character. 
<?php
echo addcslashes("zoo['.']", 'z..A');
// output:  \zoo['\.']
?> 

See also stripcslashes(), stripslashes(), htmlspecialchars(), and 
quotemeta().   String functionsUpaddslashes
#

#T=string addcslashes ( string str, string charlist)
addcslashes ( ^!string str, string charlist);
#

#T=addslashes - string addslashes ( string str)
(PHP 3, PHP 4 )
addslashes -- Quote string with slashes
Description
string addslashes ( string str)
Returns a string with backslashes before characters that need to be quoted 
in database queries etc. These characters are single quote ('), double 
quote ("), backslash (\) and NUL (the NULL byte). 
An example use of addslashes() is when you're entering data into a 
database. For example, to insert the name O'reilly into a database, you 
will need to escape it. Most databases do this with a \ which would mean 
O\'reilly. This would only be to get the data into the database, the extra 
\ will not be inserted. Having the PHP directive magic_quotes_sybase set 
to on will mean ' is instead escaped with another '. 
The PHP directive magic_quotes_gpc is on by default, and it essentially 
runs addslashes() on all GET, POST, and COOKIE data. Do not use 
addslashes() on strings that have already been escaped with 
magic_quotes_gpc as you'll then do double escaping. The function 
get_magic_quotes_gpc() may come in handy for checking this. 
Example 1. An addslashes() example
  <?php
  $str = "Is your name O'reilly?";

  // Outputs: Is your name O\'reilly?
  echo addslashes($str);
  ?> 
See also stripslashes(), htmlspecialchars(), quotemeta(), and 
get_magic_quotes_gpc().   addcslashesUpbin2hex
#

#T=string addslashes ( string str)
addslashes ( ^!string str);
#

#T=aggregate_info - array aggregate_info ( object object)
(PHP 5 CVS only)
aggregate_info --  returns an associative array of the methods and 
properties from each class that has been aggregated to the object. 
Description
array aggregate_info ( object object)
Will return the aggregation information for a particular object as an 
associative array of arrays of methods and properties. The key for the 
main array is the name of the aggregated class. 
For example the code below Example 1. Using aggregate_info()
  <?php

  class Slicer {
      var $vegetable;

      function Slicer($vegetable) {
	  $this->vegetable = $vegetable;
      }

      function slice_it($num_cuts) {
	  echo "Doing some simple slicing\n";
	  for ($i=0; $i < $num_cuts; $i++) {
	      // do some slicing
	  }
      }
  }

  class Dicer {
      var $vegetable;
      var $rotation_angle = 90;   // degrees

      function Dicer($vegetable) {
	  $this->vegetable = $vegetable;
      }

      function dice_it($num_cuts) {
	  echo "Cutting in one direction\n";
	  for ($i=0; $i < $num_cuts; $i++) {
	      // do some cutting
	  }
	  $this->rotate($this->rotation_angle);
	  echo "Cutting in a second direction\n";
	  for ($i=0; $i < $num_cuts; $i++) {
	      // do some more cutting
	  }
      }

      function rotate($deg) {
	  echo "Now rotating {$this->vegetable} {$deg} 
  degrees\n";
      }

      function _secret_super_dicing($num_cuts) {
	  // so secret we cannot show you ;-)
      }
  }

  $obj = new Slicer('onion');
  aggregate($obj, 'Dicer');
  print_r(aggregate_info($obj));
  ?> 

Will produce the output 
Array
(
[dicer] => Array
(
[methods] => Array
(
    [0] => dice_it
    [1] => rotate
)

[properties] => Array
(
    [0] => rotation_angle
)

)

)

As you can see, all properties and methods of the Dicer class have been 
aggregated into our new object, with the exception of the class 
constructor and the method _secret_super_dicing 
See also aggregate(), aggregate_methods(), aggregate_methods_by_list(), 
aggregate_methods_by_regexp(), aggregate_properties(), 
aggregate_properties_by_list(), aggregate_properties_by_regexp(), 
deaggregate()   Object Aggregation/Composition 
  FunctionsUpaggregate_methods_by_list
#

#T=array aggregate_info ( object object)
aggregate_info ( ^!object object);
#

#T=aggregate_methods_by_list - void aggregate_methods_by_list ( object object, string class_name, array 
(PHP 4 >= 4.2.0)
aggregate_methods_by_list --  selective dynamic class methods aggregation 
to an object 
Description
void aggregate_methods_by_list ( object object, string class_name, array 
methods_list [, bool exclude])
Aggregates methods from a class to an existing object using a list of 
method names. The optional paramater exclude is used to decide whether the 
list contains the names of methods to include in the aggregation (i.e. 
exclude is FALSE, which is the default value), or to exclude from the 
aggregation (exclude is TRUE). 
The class constructor or methods whose names start with an underscore 
character (_), which are considered private to the aggregated class, are 
always excluded. 
See also aggregate(), aggregate_info(), aggregate_methods(), 
aggregate_methods_by_regexp(), aggregate_properties(), 
aggregate_properties_by_list(), aggregate_properties_by_regexp(), 
deaggregate()   aggregate_infoUpaggregate_methods_by_regexp
#

#T=void aggregate_methods_by_list ( object object, string class_name, array 
aggregate_methods_by_list ( ^!object object, string class_name, array ;
#

#T=aggregate_methods_by_regexp - void aggregate_methods_by_regexp ( object object, string class_name, 
(PHP 4 >= 4.2.0)
aggregate_methods_by_regexp --  selective class methods aggregation to an 
object using a regular expression 
Description
void aggregate_methods_by_regexp ( object object, string class_name, 
string regexp [, bool exclude])
Aggregates methods from a class to an existing object using a regular 
expresion to match method names. The optional paramater exclude is used to 
decide whether the regular expression will select the names of methods to 
include in the aggregation (i.e. exclude is FALSE, which is the default 
value), or to exclude from the aggregation (exclude is TRUE). 
The class constructor or methods whose names start with an underscore 
character (_), which are considered private to the aggregated class, are 
always excluded. 
See also aggregate(), aggregate_info(), aggregate_methods(), 
aggregate_methods_by_list(), aggregate_properties(), 
aggregate_properties_by_list(), aggregate_properties_by_regexp(), 
deaggregate()   aggregate_methods_by_listUpaggregate_methods
#

#T=void aggregate_methods_by_regexp ( object object, string class_name, 
aggregate_methods_by_regexp ( ^!object object, string class_name, ;
#

#T=aggregate_methods - void aggregate_methods ( object object, string class_name)
(PHP 4 >= 4.2.0)
aggregate_methods --  dynamic class and object aggregation of methods 
Description
void aggregate_methods ( object object, string class_name)
Aggregates all methods defined in a class to an existing object, except 
for the class constructor, or methods whose names start with an underscore 
character (_) which are considered private to the aggregated class. 
See also aggregate(), aggregate_info(), aggregate_methods_by_list(), 
aggregate_methods_by_regexp(), aggregate_properties(), 
aggregate_properties_by_list(), aggregate_properties_by_regexp(), 
deaggregate()   aggregate_methods_by_regexpUpaggregate_properties_by_list
#

#T=void aggregate_methods ( object object, string class_name)
aggregate_methods ( ^!object object, string class_name);
#

#T=aggregate_properties_by_list - void aggregate_properties_by_list ( object object, string class_name, 
(PHP 4 >= 4.2.0)
aggregate_properties_by_list --  selective dynamic class properties 
aggregation to an object 
Description
void aggregate_properties_by_list ( object object, string class_name, 
array properties_list [, bool exclude])
Aggregates properties from a class to an existing object using a list of 
property names. The optional paramater exclude is used to decide whether 
the list contains the names of class properties to include in the 
aggregation (i.e. exclude is FALSE, which is the default value), or to 
exclude from the aggregation (exclude is TRUE). 
The properties whose names start with an underscore character (_), which 
are considered private to the aggregated class, are always excluded. 
See also aggregate(), aggregate_methods(), aggregate_methods_by_list(), 
aggregate_methods_by_regexp(), aggregate_properties(), 
aggregate_properties_by_regexp(), aggregate_info(), deaggregate()   aggregate_methodsUpaggregate_properties_by_regexp
#

#T=void aggregate_properties_by_list ( object object, string class_name, 
aggregate_properties_by_list ( ^!object object, string class_name, ;
#

#T=aggregate_properties_by_regexp - void aggregate_properties_by_regexp ( object object, string class_name, 
(PHP 4 >= 4.2.0)
aggregate_properties_by_regexp --  selective class properties aggregation 
to an object using a regular expression 
Description
void aggregate_properties_by_regexp ( object object, string class_name, 
string regexp [, bool exclude])
Aggregates properties from a class to an existing object using a regular 
expresion to match their names. The optional paramater exclude is used to 
decide whether the regular expression will select the names of class 
properties to include in the aggregation (i.e. exclude is FALSE, which is 
the default value), or to exclude from the aggregation (exclude is TRUE). 
The properties whose names start with an underscore character (_), which 
are considered private to the aggregated class, are always excluded. 
See also aggregate(), aggregate_methods(), aggregate_methods_by_list(), 
aggregate_methods_by_regexp(), aggregate_properties(), 
aggregate_properties_by_list(), aggregate_info(), deaggregate()   aggregate_properties_by_listUpaggregate_properties
#

#T=void aggregate_properties_by_regexp ( object object, string class_name, 
aggregate_properties_by_regexp ( ^!object object, string class_name, ;
#

#T=aggregate_properties - void aggregate_properties ( object object, string class_name)
(PHP 4 >= 4.2.0)
aggregate_properties --  dynamic aggregation of class properties to an 
object 
Description
void aggregate_properties ( object object, string class_name)
Aggregates all properties defined in a class to an existing object, except 
for properties whose names start with an underscore character (_) which 
are considered private to the aggregated class. 
See also aggregate(), aggregate_methods(), aggregate_methods_by_list(), 
aggregate_methods_by_regexp(), aggregate_properties_by_list(), 
aggregate_properties_by_regexp(), aggregate_info(), deaggregate()   aggregate_properties_by_regexpUpaggregate
#

#T=void aggregate_properties ( object object, string class_name)
aggregate_properties ( ^!object object, string class_name);
#

#T=aggregate - void aggregate ( object object, string class_name)
(PHP 4 >= 4.2.0)
aggregate --  dynamic class and object aggregation of methods and 
properties 
Description
void aggregate ( object object, string class_name)
Aggregates methods and properties defined in a class to an existing 
object. Methods and properties with names starting with an underscore 
character (_) are considered private to the aggregated class and are not 
used, constructors are also excluded from the aggregation procedure. 
See also aggregate_info(), aggregate_methods(), 
aggregate_methods_by_list(), aggregate_methods_by_regexp(), 
aggregate_properties(), aggregate_properties_by_list(), 
aggregate_properties_by_regexp(), deaggregate()   aggregate_propertiesUpaggregation_info
aggregation_info
aggregation_info -- Alias for aggregate_info()
Description
This function is an alias of aggregate_info().   aggregateUpdeaggregate
#

#T=void aggregate ( object object, string class_name)
aggregate ( ^!object object, string class_name);
#

#T=apache_child_terminate - bool apache_child_terminate ( void )
(PHP 4 >= 4.0.5)
apache_child_terminate -- Terminate apache process after this request
Description
bool apache_child_terminate ( void )
apache_child_terminate() will register the Apache process executing the 
current PHP request for termination once execution of PHP code it is 
completed. It may be used to terminate a process after a script with high 
memory consumption has been run as memory will usually only be freed 
internally but not given back to the operating system. 
Note: The availability of this feature is controlled by the php.ini 
directive child_terminate, which is set to off by default. 
This feature is also not available on multithreaded versions of apache 
like the win32 version. 
See also exit().   Apache-specific FunctionsUpapache_get_version
#

#T=bool apache_child_terminate ( void )
apache_child_terminate ( ^!void );
#

#T=apache_get_version - string apache_get_version ( void )
(PHP 4 >= 4.3.2)
apache_get_version --  Fetch Apache version 
Description
string apache_get_version ( void )
apache_get_version() returns the version of Apache as string, or FALSE on 
failure. 
Example 1. apache_get_version() example
  <?php
  $version = apache_get_version();
  echo "$version \n <br \>";
  ?> 

The printout of the above program will look similar to: 
Apache/1.3.29 (Unix) PHP/4.3.4
See also phpinfo().   apache_child_terminateUpapache_lookup_uri
#

#T=string apache_get_version ( void )
apache_get_version ( ^!void );
#

#T=apache_lookup_uri - object apache_lookup_uri ( string filename)
(PHP 3>= 3.0.4, PHP 4 )
apache_lookup_uri --  Perform a partial request for the specified URI and 
return all info about it 
Description
object apache_lookup_uri ( string filename)
This performs a partial request for a URI. It goes just far enough to 
obtain all the important information about the given resource and returns 
this information in a class. The properties of the returned class are: 
status
the_request
status_line
method
content_type
handler
uri
filename
path_info
args
boundary
no_cache
no_local_copy
allowed
send_bodyct
bytes_sent
byterange
clength
unparsed_uri
mtime
request_time

Note: apache_lookup_uri() only works when PHP is installed as an Apache 
module.   apache_get_versionUpapache_note
#

#T=object apache_lookup_uri ( string filename)
apache_lookup_uri ( ^!string filename);
#

#T=apache_note - string apache_note ( string note_name [, string note_value])
(PHP 3>= 3.0.2, PHP 4 )
apache_note -- Get and set apache request notes
Description
string apache_note ( string note_name [, string note_value])
apache_note() is an Apache-specific function which gets and sets values in 
a request's notes table. If called with one argument, it returns the 
current value of note note_name. If called with two arguments, it sets the 
value of note note_name to note_value and returns the previous value of 
note note_name.   apache_lookup_uriUpapache_request_headers
#

#T=string apache_note ( string note_name [, string note_value])
apache_note ( ^!string note_name [, string note_value]);
#

#T=apache_request_headers - array apache_request_headers ( void )
(PHP 4 >= 4.3.0)
apache_request_headers -- Fetch all HTTP request headers
Description
array apache_request_headers ( void )
apache_request_headers() returns an associative array of all the HTTP 
headers in the current request. This is only supported when PHP runs as an 
Apache module. 
Example 1. apache_request_headers() example
  <?php
  $headers = apache_request_headers();

  foreach ($headers as $header => $value) {
      echo "$header: $value <br />\n";
  }
  ?> 
Note: Prior to PHP 4.3.0, apache_request_headers() was called 
getallheaders(). After PHP 4.3.0, getallheaders() is an alias for 
apache_request_headers(). 
Note: You can also get at the value of the common CGI variables by 
reading them from the environment, which works whether or not you are 
using PHP as an Apache module. Use phpinfo() to see a list of all of the 
available environment variables. 
Note: From PHP 4.3.3 on you can use this function with the NSAPI server 
module in Netscape/iPlanet/SunONE webservers, too. 
See also apache_response_headers().   apache_noteUpapache_response_headers
#

#T=array apache_request_headers ( void )
apache_request_headers ( ^!void );
#

#T=apache_response_headers - array apache_response_headers ( void )
(PHP 4 >= 4.3.0)
apache_response_headers --  Fetch all HTTP response headers 
Description
array apache_response_headers ( void )
Returns an array of all Apache response headers. This functionality is 
only available in PHP version 4.3.0 and greater. 
Note: From PHP 4.3.3 on you can use this function with the NSAPI server 
module in Netscape/iPlanet/SunONE webservers, too. 
See also apache_request_headers(), and headers_sent().   apache_request_headersUpapache_setenv
#

#T=array apache_response_headers ( void )
apache_response_headers ( ^!void );
#

#T=apache_setenv - int apache_setenv ( string variable, string value [, bool walk_to_top])
(PHP 4 >= 4.2.0)
apache_setenv -- Set an Apache subprocess_env variable
Description
int apache_setenv ( string variable, string value [, bool walk_to_top])
Warning
This function is currently not documented; only the argument list is 
available.
  apache_response_headersUpascii2ebcdic
#

#T=int apache_setenv ( string variable, string value [, bool walk_to_top])
apache_setenv ( ^!string variable, string value [, bool walk_to_top]);
#

#T=array_change_key_case - array array_change_key_case ( array input [, int case])
(PHP 4 >= 4.2.0)
array_change_key_case -- Returns an array with all string keys lowercased 
or uppercased
Description
array array_change_key_case ( array input [, int case])
array_change_key_case() changes the keys in the input array to be all 
lowercase or uppercase. The change depends on the last optional case 
parameter. You can pass two constants there, CASE_UPPER and CASE_LOWER. 
The default is CASE_LOWER. The function will leave number indices as is. 
Example 1. array_change_key_case() example
  <?php
  $input_array = array("FirSt" => 1, "SecOnd" => 4);
  print_r(array_change_key_case($input_array, CASE_UPPER));
  ?> 

The printout of the above program will be: 
Array
(
[FIRST] => 1
[SECOND] => 4
)
If an array has indices that will be the same once run through this 
function (e.g. "keY" and "kEY"), the value that is later in the array will 
override other indices.   Array FunctionsUparray_chunk
#

#T=array array_change_key_case ( array input [, int case])
array_change_key_case ( ^!array input [, int case]);
#

#T=array_chunk - array array_chunk ( array input, int size [, bool preserve_keys])
(PHP 4 >= 4.2.0)
array_chunk -- Split an array into chunks
Description
array array_chunk ( array input, int size [, bool preserve_keys])
array_chunk() splits the array into several arrays with size values in 
them. You may also have an array with less values at the end. You get the 
arrays as members of a multidimensional array indexed with numbers 
starting from zero. 
By setting the optional preserve_keys parameter to TRUE, you can force PHP 
to preserve the original keys from the input array. If you specify FALSE 
new number indices will be used in each resulting array with indices 
starting from zero. The default is FALSE. 
Example 1. array_chunk() example
  <?php
  $input_array = array('a', 'b', 'c', 'd', 'e');
  print_r(array_chunk($input_array, 2));
  print_r(array_chunk($input_array, 2, true));
  ?> 

The printout of the above program will be: 
Array
(
[0] => Array
(
[0] => a
[1] => b
)

[1] => Array
(
[0] => c
[1] => d
)

[2] => Array
(
[0] => e
)

)
Array
(
[0] => Array
(
[0] => a
[1] => b
)

[1] => Array
(
[2] => c
[3] => d
)

[2] => Array
(
[4] => e
)

)

  array_change_key_caseUparray_combine
#

#T=array array_chunk ( array input, int size [, bool preserve_keys])
array_chunk ( ^!array input, int size [, bool preserve_keys]);
#

#T=array_combine - array array_combine ( array keys, array values)
(PHP 5 CVS only)
array_combine --  Creates an array by using one array for keys and another 
for its values 
Description
array array_combine ( array keys, array values)
Returns an array by using the values from the keys array as keys and the 
values from the values array as the corresponding values. 
Returns FALSE if the number of elements for each array isn't equal or if 
the arrays are empty. 
Example 1. A simple array_combine() example
  <?php
  $a = array('green', 'red', 'yellow');
  $b = array('avocado', 'apple', 'banana');
  $c = array_combine($a, $b);

  print_r($c);
  ?> 

Outputs: 
Array
(
[green]  => avocado
[red]    => apple
[yellow] => banana
)
See also array_merge(), array_walk(), and array_values().   array_chunkUparray_count_values
#

#T=array array_combine ( array keys, array values)
array_combine ( ^!array keys, array values);
#

#T=array_count_values - array array_count_values ( array input)
(PHP 4 )
array_count_values -- Counts all the values of an array
Description
array array_count_values ( array input)
array_count_values() returns an array using the values of the input array 
as keys and their frequency in input as values. 
Example 1. array_count_values() example
  <?php
  $array = array(1, "hello", 1, "world", "hello");
  print_r(array_count_values($array));
  ?> 

The printout of the above program will be: 
Array
(
[1] => 2
[hello] => 2
[world] => 1
)
See also count(), array_unique(), array_values(), and count_chars().   array_combineUparray_diff_assoc
#

#T=array array_count_values ( array input)
array_count_values ( ^!array input);
#

#T=array_diff_assoc - array array_diff_assoc ( array array1, array array2 [, array ...])
(PHP 4 >= 4.3.0)
array_diff_assoc -- Computes the difference of arrays with additional 
index check
Description
array array_diff_assoc ( array array1, array array2 [, array ...])
array_diff_assoc() returns an array containing all the values from array1 
that are not present in any of the other arguments. Note that the keys are 
used in the comparison unlike array_diff(). 
Example 1. array_diff_assoc() example
  <?php
  $array1 = array("a" => "green", "b" => "brown", "c" => "blue", 
  "red");
  $array2 = array("a" => "green", "yellow", "red");
  $result = array_diff_assoc($array1, $array2);
  print_r($result);
  ?> 

The result is: 
Array
(
[b] => brown
[c] => blue
[0] => red
)
In our example above you see the "a" => "green" pair is present in both 
arrays and thus it is not in the ouput from the function. Unlike this, the 
pair 0 => "red" is in the ouput because in the second argument "red" has 
key which is 1. 
Two values from key => value pairs are considered equal only if (string) 
$elem1 === (string) $elem2 . In other words a strict check takes place so 
the string representations must be the same. 
Note: Please note that this function only checks one dimension of a 
n-dimensional array. Of course you can check deeper dimensions by using, 
for example, array_diff_assoc($array1[0], $array2[0]);. 
See also array_diff(), array_intersect(), and array_intersect_assoc().   array_count_valuesUparray_diff_uassoc
array_diff_uassoc
(no version information, might be only in CVS)
array_diff_uassoc -- Computes the difference of arrays with additional 
index check which is performed by a user supplied callback function.
Description
array array_diff_assoc ( array array1, array array2 [, array ..., callback 
key_compare_func])
array_diff_uassoc() returns an array containing all the values from array1 
that are not present in any of the other arguments. Note that the keys are 
used in the comparison unlike array_diff(). This comparison is done by a 
user supplied callback function. It must return an integer less than, 
equal to, or greater than zero if the first argument is considered to be 
respectively less than, equal to, or greater than the second. This is 
unlike array_diff_assoc() where an internal function for comparing the 
indices is used. 
Example 1. array_diff_uassoc() example
  <?php
  function key_compare_func($a, $b) {
      if ($a === $b) return 0;
      return ($a > $b)? 1:-1;
  }

  $array1 = array("a" => "green", "b" => "brown", "c" => "blue", 
  "red");
  $array2 = array("a" => "green", "yellow", "red");
  $result = array_diff_uassoc($array1, $array2, 
  "key_compare_func");
  ?> 

The result is: 
Array
(
[b] => brown
[c] => blue
[0] => red
)
In our example above you see the "a" => "green" pair is present in both 
arrays and thus it is not in the ouput from the function. Unlike this, the 
pair 0 => "red" is in the ouput because in the second argument "red" has 
key which is 1. 
The equality of 2 indices is checked by the user supplied callback 
function. 
Note: Please note that this function only checks one dimension of a 
n-dimensional array. Of course you can check deeper dimensions by using, 
for example, array_diff_uassoc($array1[0], $array2[0], 
"key_compare_func");. 
See also array_diff(), array_diff_assoc(), array_udiff(), 
array_udiff_assoc(), array_udiff_uassoc(), array_intersect(), 
array_intersect_assoc(), array_uintersect(), array_uintersect_assoc() and 
array_uintersect_uassoc().   array_diff_assocUparray_diff
#

#T=array array_diff_assoc ( array array1, array array2 [, array ...])
array_diff_assoc ( ^!array array1, array array2 [, array ...]);
#

#T=array_diff - array array_diff ( array array1, array array2 [, array ...])
(PHP 4 >= 4.0.1)
array_diff -- Computes the difference of arrays
Description
array array_diff ( array array1, array array2 [, array ...])
array_diff() returns an array containing all the values of array1 that are 
not present in any of the other arguments. Note that keys are preserved. 
Example 1. array_diff() example
  <?php
  $array1 = array("a" => "green", "red", "blue", "red");
  $array2 = array("b" => "green", "yellow", "red");
  $result = array_diff($array1, $array2);

  print_r($result);
  ?> 

Multiple occurrences in $array1 are all treated the same way. This 
will output : 
Array
(
[1] => blue
)
Note: Two elements are considered equal if and only if (string) $elem1 
=== (string) $elem2. In words: when the string representation is the 
same. 
Note: Please note that this function only checks one dimension of a 
n-dimensional array. Of course you can check deeper dimensions by using 
array_diff($array1[0], $array2[0]);. 
Warning
This was broken in PHP 4.0.4! 

See also array_diff_assoc(), array_intersect(), and 
array_intersect_assoc().   array_diff_uassocUparray_fill
#

#T=array array_diff ( array array1, array array2 [, array ...])
array_diff ( ^!array array1, array array2 [, array ...]);
#

#T=array_fill - array array_fill ( int start_index, int num, mixed value)
(PHP 4 >= 4.2.0)
array_fill -- Fill an array with values
Description
array array_fill ( int start_index, int num, mixed value)
array_fill() fills an array with num entries of the value of the value 
parameter, keys starting at the start_index parameter. Note that num must 
be a number greater than zero, or PHP will throw a warning. 
Example 1. array_fill() example
  <?php
  $a = array_fill(5, 6, 'banana');
  print_r($a);
  ?> 

$a now is: 
Array
(
[5]  => banana
[6]  => banana
[7]  => banana
[8]  => banana
[9]  => banana
[10] => banana
)
See also str_repeat() and range().   array_diffUparray_filter
#

#T=array array_fill ( int start_index, int num, mixed value)
array_fill ( ^!int start_index, int num, mixed value);
#

#T=array_filter - array array_filter ( array input [, callback callback])
(PHP 4 >= 4.0.6)
array_filter --  Filters elements of an array using a callback function 
Description
array array_filter ( array input [, callback callback])
array_filter() iterates over each value in the input array passing them to 
the callback function. If the callback function returns true, the current 
value from input is returned into the result array. Array keys are 
preserved. 
Example 1. array_filter() example
  <?php
  function odd($var) {
      return($var % 2 == 1);
  }

  function even($var) {
      return($var % 2 == 0);
  }

  $array1 = array("a"=>1, "b"=>2, "c"=>3, "d"=>4, "e"=>5);
  $array2 = array(6, 7, 8, 9, 10, 11, 12);

  echo "Odd :\n";
  print_r(array_filter($array1, "odd"));
  echo "Even:\n";
  print_r(array_filter($array2, "even"));
  ?> 

The printout of the program above will be: 
  Odd :
  Array
  (
      [a] => 1
      [c] => 3
      [e] => 5
  )
  Even:
  Array
  (
      [0] => 6
      [2] => 8
      [4] => 10
      [6] => 12
  ) 
Users may not change the array itself from the callback function. e.g. 
Add/delete an element, unset the array that array_filter() is applied to. 
If the array is changed, the behavior of this function is undefined. 
If the callback function is not supplied, array_filter() will remove all 
the entries of input that are equal to FALSE. See converting to boolean 
for more information. 
Example 2. array_filter() without callback
  <?php

  $entry = array(
	       0 => 'foo',
	       1 => false,
	       2 => -1,
	       3 => null,
	       4 => ''
	    );

  print_r(array_filter($entry));
  ?> 

This will output : 
Array
(
[0] => foo
[2] => -1
)
See also array_map(), array_reduce(), and array_walk().   array_fillUparray_flip
#

#T=array array_filter ( array input [, callback callback])
array_filter ( ^!array input [, callback callback]);
#

#T=array_flip - array array_flip ( array trans)
(PHP 4 )
array_flip -- Exchanges all keys with their associated values in an array
Description
array array_flip ( array trans)
array_flip() returns an array in flip order, i.e. keys from trans become 
values and values from trans become keys. 
Note that the values of trans need to be valid keys, i.e. they need to be 
either integer or string. A warning will be emitted if a value has the 
wrong type, and the key/value pair in question will not be flipped. 
If a value has several occurrences, the latest key will be used as its 
values, and all others will be lost. 
array_flip() returns FALSE if it fails. 
Example 1. array_flip() example
  <?php
  $trans = array_flip($trans);
  $original = strtr($str, $trans);
  ?> 
Example 2. array_flip() example : collision
  <?php
  $trans = array("a" => 1, "b" => 1, "c" => 2);
  $trans = array_flip($trans);
  print_r($trans);
  ?> 

now $trans is: 
Array
(
[1] => b
[2] => c
)
See also array_values(), array_keys(), and array_reverse().   array_filterUparray_intersect_assoc
#

#T=array array_flip ( array trans)
array_flip ( ^!array trans);
#

#T=array_intersect_assoc - array array_intersect_assoc ( array array1, array array2 [, array ...])
(PHP 4 >= 4.3.0)
array_intersect_assoc -- Computes the intersection of arrays with 
additional index check
Description
array array_intersect_assoc ( array array1, array array2 [, array ...])
array_intersect_assoc() returns an array containing all the values of 
array1 that are present in all the arguments. Note that the keys are used 
in the comparison unlike in array_intersect(). 
Example 1. array_intersect_assoc() example
  <?php
  $array1 = array("a" => "green", "b" => "brown", "c" => "blue", 
  "red");
  $array2 = array("a" => "green", "yellow", "red");
  $result_array = array_intersect_assoc($array1, $array2);
  ?> 

$result_array will look like: 
Array
(
[a] => green
)
In our example you see that only the pair "a" => "green" is present in 
both arrays and thus is returned. The value "red" is not returned because 
in $array1 it's key is 0 while the key of "red" in $array2 is 1. 
The two values from the key => value pairs are considered equal only if 
(string) $elem1 === (string) $elem2 . In otherwords a strict type check is 
executed so the string representation must be the same. 
See also array_intersect(), array_diff() and array_diff_assoc().   array_flipUparray_intersect
#

#T=array array_intersect_assoc ( array array1, array array2 [, array ...])
array_intersect_assoc ( ^!array array1, array array2 [, array ...]);
#

#T=array_intersect - array array_intersect ( array array1, array array2 [, array ...])
(PHP 4 >= 4.0.1)
array_intersect -- Computes the intersection of arrays
Description
array array_intersect ( array array1, array array2 [, array ...])
array_intersect() returns an array containing all the values of array1 
that are present in all the arguments. Note that keys are preserved. 
Example 1. array_intersect() example
  <?php
  $array1 = array("a" => "green", "red", "blue");
  $array2 = array("b" => "green", "yellow", "red");
  $result = array_intersect($array1, $array2);
  ?> 

This makes $result have 
  Array
  (
      [a] => green
      [0] => red
  ) 
Note: Two elements are considered equal if and only if (string) $elem1 
=== (string) $elem2. In words: when the string representation is the 
same. 
See also array_intersect_assoc(), array_diff(), and array_diff_assoc().   array_intersect_assocUparray_key_exists
#

#T=array array_intersect ( array array1, array array2 [, array ...])
array_intersect ( ^!array array1, array array2 [, array ...]);
#

#T=array_key_exists - bool array_key_exists ( mixed key, array search)
(PHP 4 >= 4.1.0)
array_key_exists -- Checks if the given key or index exists in the array
Description
bool array_key_exists ( mixed key, array search)
array_key_exists() returns TRUE if the given key is set in the array. key 
can be any value possible for an array index. 
Example 1. array_key_exists() example
  <?php
  $search_array = array("first" => 1, "second" => 4);
  if (array_key_exists("first", $search_array)) {
      echo "The 'first' element is in the array";
  }
  ?> 
Note: The name of this function is key_exists() in PHP version 4.0.6. 
See also isset(), array_keys(), and in_array().   array_intersectUparray_keys
#

#T=bool array_key_exists ( mixed key, array search)
array_key_exists ( ^!mixed key, array search);
#

#T=array_keys - array array_keys ( array input [, mixed search_value])
(PHP 4 )
array_keys -- Return all the keys of an array
Description
array array_keys ( array input [, mixed search_value])
array_keys() returns the keys, numeric and string, from the input array. 
If the optional search_value is specified, then only the keys for that 
value are returned. Otherwise, all the keys from the input are returned. 
Example 1. array_keys() example
  <?php
  $array = array(0 => 100, "color" => "red");
  print_r(array_keys($array));

  $array = array("blue", "red", "green", "blue", "blue");
  print_r(array_keys($array, "blue"));

  $array = array("color" => array("blue", "red", "green"),
		 "size"  => array("small", "medium", "large"));
  print_r(array_keys($array));
  ?> 

The printout of the program above will be: 
Array
(
[0] => 0
[1] => color
)
Array
(
[0] => 0
[1] => 3
[2] => 4
)
Array
(
[0] => color
[1] => size
)
See also array_values() and array_key_exists().   array_key_existsUparray_map
#

#T=array array_keys ( array input [, mixed search_value])
array_keys ( ^!array input [, mixed search_value]);
#

#T=array_map - array array_map ( mixed callback, array arr1 [, array ...])
(PHP 4 >= 4.0.6)
array_map --  Applies the callback to the elements of the given arrays 
Description
array array_map ( mixed callback, array arr1 [, array ...])
array_map() returns an array containing all the elements of arr1 after 
applying the callback function to each one. The number of parameters that 
the callback function accepts should match the number of arrays passed to 
the array_map() 
Example 1. array_map() example
  <?php
  function cube($n) {
      return($n * $n * $n);
  }

  $a = array(1, 2, 3, 4, 5);
  $b = array_map("cube", $a);
  print_r($b);
  ?> 

This makes $b have: 
Array
(
[0] => 1
[1] => 8
[2] => 27
[3] => 64
[4] => 125
)
Example 2. array_map() - using more arrays
  <?php
  function show_Spanish($n, $m) {
      return("The number $n is called $m in Spanish");
  }

  function map_Spanish($n, $m) {
      return(array($n => $m));
  }

  $a = array(1, 2, 3, 4, 5);
  $b = array("uno", "dos", "tres", "cuatro", "cinco");

  $c = array_map("show_Spanish", $a, $b);
  print_r($c);

  $d = array_map("map_Spanish", $a , $b);
  print_r($d);
  ?> 

This results: 
// printout of $c
Array
(
[0] => The number 1 is called uno in Spanish
[1] => The number 2 is called dos in Spanish
[2] => The number 3 is called tres in Spanish
[3] => The number 4 is called cuatro in Spanish
[4] => The number 5 is called cinco in Spanish
)

// printout of $d
Array
(
[0] => Array
(
[1] => uno
)

[1] => Array
(
[2] => dos
)

[2] => Array
(
[3] => tres
)

[3] => Array
(
[4] => cuatro
)

[4] => Array
(
[5] => cinco
)

)
Usually when using two or more arrays, they should be of equal length 
because the callback function is applied in parallel to the corresponding 
elements. If the arrays are of unequal length, the shortest one will be 
extended with empty elements. 
An interesting use of this function is to construct an array of arrays, 
which can be easily performed by using NULL as the name of the callback 
function 
Example 3. Creating an array of arrays
  <?php
  $a = array(1, 2, 3, 4, 5);
  $b = array("one", "two", "three", "four", "five");
  $c = array("uno", "dos", "tres", "cuatro", "cinco");

  $d = array_map(null, $a, $b, $c);
  print_r($d);
  ?> 
The printout of the program above will be: 
Array
(
[0] => Array
(
[0] => 1
[1] => one
[2] => uno
)

[1] => Array
(
[0] => 2
[1] => two
[2] => dos
)

[2] => Array
(
[0] => 3
[1] => three
[2] => tres
)

[3] => Array
(
[0] => 4
[1] => four
[2] => cuatro
)

[4] => Array
(
[0] => 5
[1] => five
[2] => cinco
)

)

See also array_filter(), array_reduce(), and array_walk().   array_keysUparray_merge_recursive
#

#T=array array_map ( mixed callback, array arr1 [, array ...])
array_map ( ^!mixed callback, array arr1 [, array ...]);
#

#T=array_merge_recursive - array array_merge_recursive ( array array1, array array2 [, array ...])
(PHP 4 >= 4.0.1)
array_merge_recursive -- Merge two or more arrays recursively
Description
array array_merge_recursive ( array array1, array array2 [, array ...])
array_merge_recursive() merges the elements of two or more arrays together 
so that the values of one are appended to the end of the previous one. It 
returns the resulting array. 
If the input arrays have the same string keys, then the values for these 
keys are merged together into an array, and this is done recursively, so 
that if one of the values is an array itself, the function will merge it 
with a corresponding entry in another array too. If, however, the arrays 
have the same numeric key, the later value will not overwrite the original 
value, but will be appended. 
Example 1. array_merge_recursive() example
  <?php
  $ar1 = array("color" => array("favorite" => "red"), 5);
  $ar2 = array(10, "color" => array("favorite" => "green", 
  "blue"));
  $result = array_merge_recursive($ar1, $ar2);
  ?> 

The $result will be: 
  Array
  (
      [color] => Array
	  (
	      [favorite] => Array
		  (
		      [0] => red
		      [1] => green
		  )

	      [0] => blue
	  )

      [0] => 5
      [1] => 10
  ) 
See also array_merge().   array_mapUparray_merge
#

#T=array array_merge_recursive ( array array1, array array2 [, array ...])
array_merge_recursive ( ^!array array1, array array2 [, array ...]);
#

#T=array_merge - array array_merge ( array array1, array array2 [, array ...])
(PHP 4 )
array_merge -- Merge two or more arrays
Description
array array_merge ( array array1, array array2 [, array ...])
array_merge() merges the elements of two or more arrays together so that 
the values of one are appended to the end of the previous one. It returns 
the resulting array. 
If the input arrays have the same string keys, then the later value for 
that key will overwrite the previous one. If, however, the arrays contain 
numeric keys, the later value will not overwrite the original value, but 
will be appended. 
Example 1. array_merge() example
  <?php
  $array1 = array("color" => "red", 2, 4);
  $array2 = array("a", "b", "color" => "green", "shape" => 
  "trapezoid", 4);
  $result = array_merge($array1, $array2);
  print_r($result);
  ?> 

The $result is: 
  Array
  (
      [color] => green
      [0] => 2
      [1] => 4
      [2] => a
      [3] => b
      [shape] => trapezoid
      [4] => 4
  ) 
Example 2. Simple array_merge() example
  <?php
  $array1 = array();
  $array2 = array(1 => "data");
  $result = array_merge($array1, $array2);
  ?> 

Don't forget that numeric keys will be renumbered! 
  Array
  (
      [0] => data
  ) 

If you want to completely preserve the arrays and just want to 
append them to each other, use the + operator: 
  <?php
  $array1 = array();
  $array2 = array(1 => "data");
  $result = $array1 + $array2;
  ?> 

The numeric key will be preserved and thus the association remains. 
  Array
  (
      [1] => data
  ) 
Note: Shared keys will be overwritten on a first-come first-served 
basis. 
See also array_merge_recursive() and array_combine().   array_merge_recursiveUparray_multisort
#

#T=array array_merge ( array array1, array array2 [, array ...])
array_merge ( ^!array array1, array array2 [, array ...]);
#

#T=array_multisort - bool array_multisort ( array ar1 [, mixed arg [, mixed ... [, array 
(PHP 4 )
array_multisort -- Sort multiple or multi-dimensional arrays
Description
bool array_multisort ( array ar1 [, mixed arg [, mixed ... [, array 
...]]])
array_multisort() can be used to sort several arrays at once or a 
multi-dimensional array according by one of more dimensions. It maintains 
key association when sorting. 
The input arrays are treated as columns of a table to be sorted by rows - 
this resembles the functionality of SQL ORDER BY clause. The first array 
is the primary one to sort by. The rows (values) in that array that 
compare the same are sorted by the next input array, and so on. 
The argument structure of this function is a bit unusual, but flexible. 
The very first argument has to be an array. Subsequently, each argument 
can be either an array or a sorting flag from the following lists. 
Sorting order flags: 
SORT_ASC - sort in ascending order
SORT_DESC - sort in descending order
Sorting type flags: 
SORT_REGULAR - compare items normally
SORT_NUMERIC - compare items numerically
SORT_STRING - compare items as strings
No two sorting flags of the same type can be specified after each array. 
The sorting flags specified after an array argument apply only to that 
array - they are reset to default SORT_ASC and SORT_REGULAR before each 
new array argument. 
Returns TRUE on success or FALSE on failure. 
Example 1. Sorting multiple arrays
  <?php
  $ar1 = array("10", 100, 100, "a");
  $ar2 = array(1, 3, "2", 1);
  array_multisort($ar1, $ar2);
  ?> 
In this example, after sorting, the first array will contain 10, "a", 100, 
100. The second array will contain 1, 1, "2", 3. The entries in the second 
array corresponding to the identical entries in the first array (100 and 
100) were sorted as well. 
Example 2. Sorting multi-dimensional array
  <?php
  $ar = array(array("10", 100, 100, "a"), array(1, 3, "2", 1));
  array_multisort($ar[0], SORT_ASC, SORT_STRING,
		  $ar[1], SORT_NUMERIC, SORT_DESC);
  ?> 
In this example, after sorting, the first array will contain 10, 100, 100, 
"a" (it was sorted as strings in ascending order), and the second one will 
contain 1, 3, "2", 1 (sorted as numbers, in descending order).   array_mergeUparray_pad
#

#T=bool array_multisort ( array ar1 [, mixed arg [, mixed ... [, array 
array_multisort ( ^!array ar1 [, mixed arg [, mixed ... [, array ;
#

#T=array_pad - array array_pad ( array input, int pad_size, mixed pad_value)
(PHP 4 )
array_pad --  Pad array to the specified length with a value 
Description
array array_pad ( array input, int pad_size, mixed pad_value)
array_pad() returns a copy of the input padded to size specified by 
pad_size with value pad_value. If pad_size is positive then the array is 
padded on the right, if it's negative then on the left. If the absolute 
value of pad_size is less than or equal to the length of the input then no 
padding takes place. 
Example 1. array_pad() example
  <?php
  $input = array(12, 10, 9);

  $result = array_pad($input, 5, 0);
  // result is array(12, 10, 9, 0, 0)

  $result = array_pad($input, -7, -1);
  // result is array(-1, -1, -1, -1, 12, 10, 9)

  $result = array_pad($input, 2, "noop");
  // not padded
  ?> 
See also array_fill() and range().   array_multisortUparray_pop
#

#T=array array_pad ( array input, int pad_size, mixed pad_value)
array_pad ( ^!array input, int pad_size, mixed pad_value);
#

#T=array_pop - mixed array_pop ( array array)
(PHP 4 )
array_pop -- Pop the element off the end of array
Description
mixed array_pop ( array array)
array_pop() pops and returns the last value of the array, shortening the 
array by one element. If array is empty (or is not an array), NULL will be 
returned. 
Note: This function will reset() the array pointer after use.
Example 1. array_pop() example
  <?php
  $stack = array("orange", "banana", "apple", "raspberry");
  $fruit = array_pop($stack);
  print_r($stack);
  ?> 

After this, $stack will have only 3 elements: 
  Array
  (
      [0] => orange
      [1] => banana
      [2] => apple
  ) 

and raspberry will be assigned to $fruit. 

Warning
This function may return Boolean FALSE, but may also return a 
non-Boolean value which evaluates to FALSE, such as 0 or "". Please 
read the section on Booleans for more information. Use the === 
operator for testing the return value of this function.

See also array_push(), array_shift(), and array_unshift().   array_padUparray_push
#

#T=mixed array_pop ( array array)
array_pop ( ^!array array);
#

#T=array_push - int array_push ( array array, mixed var [, mixed ...])
(PHP 4 )
array_push --  Push one or more elements onto the end of array 
Description
int array_push ( array array, mixed var [, mixed ...])
array_push() treats array as a stack, and pushes the passed variables onto 
the end of array. The length of array increases by the number of variables 
pushed. Has the same effect as: <?php
$array[] = $var;
?> 
repeated for each var. 
Returns the new number of elements in the array. 
Example 1. array_push() example
  <?php
  $stack = array("orange", "banana");
  array_push($stack, "apple", "raspberry");
  print_r($stack);
  ?> 

This example would result in $stack having the following elements: 
  Array
  (
      [0] => orange
      [1] => banana
      [2] => apple
      [3] => raspberry
  ) 
See also array_pop(), array_shift(), and array_unshift().   array_popUparray_rand
#

#T=int array_push ( array array, mixed var [, mixed ...])
array_push ( ^!array array, mixed var [, mixed ...]);
#

#T=array_rand - mixed array_rand ( array input [, int num_req])
(PHP 4 )
array_rand --  Pick one or more random entries out of an array 
Description
mixed array_rand ( array input [, int num_req])
array_rand() is rather useful when you want to pick one or more random 
entries out of an array. It takes an input array and an optional argument 
num_req which specifies how many entries you want to pick - if not 
specified, it defaults to 1. 
If you are picking only one entry, array_rand() returns the key for a 
random entry. Otherwise, it returns an array of keys for the random 
entries. This is done so that you can pick random keys as well as values 
out of the array. 
Note: As of PHP 4.2.0, there is no need to seed the random number 
generator with srand() or mt_srand() as this is now done automatically. 
Example 1. array_rand() example
  <?php
  srand((float) microtime() * 10000000);
  $input = array("Neo", "Morpheus", "Trinity", "Cypher", 
"Tank");
  $rand_keys = array_rand($input, 2);
  echo $input[$rand_keys[0]] . "\n";
  echo $input[$rand_keys[1]] . "\n";
  ?> 
See also shuffle().   array_pushUparray_reduce
#

#T=mixed array_rand ( array input [, int num_req])
array_rand ( ^!array input [, int num_req]);
#

#T=array_reduce - mixed array_reduce ( array input, callback function [, int initial])
(PHP 4 >= 4.0.5)
array_reduce --  Iteratively reduce the array to a single value using a 
callback function 
Description
mixed array_reduce ( array input, callback function [, int initial])
array_reduce() applies iteratively the function function to the elements 
of the array input, so as to reduce the array to a single value. If the 
optional initial is available, it will be used at the beginning of the 
process, or as a final result in case the array is empty. 
Example 1. array_reduce() example
  <?php
  function rsum($v, $w) {
      $v += $w;
      return $v;
  }

  function rmul($v, $w) {
      $v *= $w;
      return $v;
  }

  $a = array(1, 2, 3, 4, 5);
  $x = array();
  $b = array_reduce($a, "rsum");
  $c = array_reduce($a, "rmul", 10);
  $d = array_reduce($x, "rsum", 1);
  ?> 
This will result in $b containing 15, $c containing 1200 (= 1*2*3*4*5*10), 
and $d containing 1. 
See also array_filter(), array_map(), array_unique(), and 
array_count_values().   array_randUparray_reverse
#

#T=mixed array_reduce ( array input, callback function [, int initial])
array_reduce ( ^!array input, callback function [, int initial]);
#

#T=array_reverse - array array_reverse ( array array [, bool preserve_keys])
(PHP 4 )
array_reverse --  Return an array with elements in reverse order 
Description
array array_reverse ( array array [, bool preserve_keys])
array_reverse() takes input array and returns a new array with the order 
of the elements reversed, preserving the keys if preserve_keys is TRUE. 
Example 1. array_reverse() example
  <?php
  $input  = array("php", 4.0, array("green", "red"));
  $result = array_reverse($input);
  $result_keyed = array_reverse($input, true);
  ?> 

This makes both $result and $result_keyed have the same elements, 
but note the difference between the keys. The printout of $result 
and $result_keyed will be: 
  Array
  (
      [0] => Array
	  (
	      [0] => green
	      [1] => red
	  )

      [1] => 4
      [2] => php
  )
  Array
  (
      [2] => Array
	  (
	      [0] => green
	      [1] => red
	  )

      [1] => 4
      [0] => php
  ) 
Note: The second parameter was added in PHP 4.0.3. 
See also array_flip().   array_reduceUparray_search
#

#T=array array_reverse ( array array [, bool preserve_keys])
array_reverse ( ^!array array [, bool preserve_keys]);
#

#T=array_search - mixed array_search ( mixed needle, array haystack [, bool strict])
(PHP 4 >= 4.0.5)
array_search --  Searches the array for a given value and returns the 
corresponding key if successful 
Description
mixed array_search ( mixed needle, array haystack [, bool strict])
Searches haystack for needle and returns the key if it is found in the 
array, FALSE otherwise. 
Note: If needle is a string, the comparison is done in a case-sensitive 
manner. 
Note: Prior to PHP 4.2.0, array_search() returns NULL on failure instead 
of FALSE. 
If the optional third parameter strict is set to TRUE then the 
array_search() will also check the types of the needle in the haystack. 
If needle is found in haystack more than once, the first matching key is 
returned. To return the keys for all matching values, use array_keys() 
with the optional search_value parameter instead. 
Example 1. array_search() example
  <?php
  $array = array(0 => 'blue', 1 => 'red', 2 => 'green', 3 => 
  'red');

  $key = array_search('green', $array); // $key = 2;
  $key = array_search('red', $array);   // $key = 1;
  ?> 
Warning
This function may return Boolean FALSE, but may also return a 
non-Boolean value which evaluates to FALSE, such as 0 or "". Please 
read the section on Booleans for more information. Use the === 
operator for testing the return value of this function.

See also array_keys(), array_values(), array_key_exists(), and in_array(). 
  array_reverseUparray_shift
#

#T=mixed array_search ( mixed needle, array haystack [, bool strict])
array_search ( ^!mixed needle, array haystack [, bool strict]);
#

#T=array_shift - mixed array_shift ( array array)
(PHP 4 )
array_shift --  Shift an element off the beginning of array 
Description
mixed array_shift ( array array)
array_shift() shifts the first value of the array off and returns it, 
shortening the array by one element and moving everything down. All 
numerical array keys will be modified to start counting from zero while 
literal keys won't be touched. If array is empty (or is not an array), 
NULL will be returned. 
Note: This function will reset() the array pointer after use.
Example 1. array_shift() example
  <?php
  $stack = array("orange", "banana", "apple", "raspberry");
  $fruit = array_shift($stack);
  print_r($stack);
  ?> 

This would result in $stack having 3 elements left: 
  Array
  (
      [0] => banana
      [1] => apple
      [2] => raspberry
  ) 

and orange will be assigned to $fruit. 

See also array_unshift(), array_push(), and array_pop().   array_searchUparray_slice
#

#T=mixed array_shift ( array array)
array_shift ( ^!array array);
#

#T=array_slice - array array_slice ( array array, int offset [, int length])
(PHP 4 )
array_slice -- Extract a slice of the array
Description
array array_slice ( array array, int offset [, int length])
array_slice() returns the sequence of elements from the array array as 
specified by the offset and length parameters. 
If offset is positive, the sequence will start at that offset in the 
array. If offset is negative, the sequence will start that far from the 
end of the array. 
If length is given and is positive, then the sequence will have that many 
elements in it. If length is given and is negative then the sequence will 
stop that many elements from the end of the array. If it is omitted, then 
the sequence will have everything from offset up until the end of the 
array. 
Note that array_slice() will ignore array keys, and will calculate offsets 
and lengths based on the actual positions of elements within the array. 
Example 1. array_slice() examples
  <?php
  $input = array("a", "b", "c", "d", "e");

  $output = array_slice($input, 2);      // returns "c", "d", 
  and "e"
  $output = array_slice($input, 2, -1);  // returns "c", "d"
  $output = array_slice($input, -2, 1);  // returns "d"
  $output = array_slice($input, 0, 3);   // returns "a", "b", 
  and "c"
  ?> 
See also array_splice() and unset().   array_shiftUparray_splice
#

#T=array array_slice ( array array, int offset [, int length])
array_slice ( ^!array array, int offset [, int length]);
#

#T=array_splice - array array_splice ( array input, int offset [, int length [, array 
(PHP 4 )
array_splice --  Remove a portion of the array and replace it with 
something else 
Description
array array_splice ( array input, int offset [, int length [, array 
replacement]])
array_splice() removes the elements designated by offset and length from 
the input array, and replaces them with the elements of the replacement 
array, if supplied. It returns an array containing the extracted elements. 

If offset is positive then the start of removed portion is at that offset 
from the beginning of the input array. If offset is negative then it 
starts that far from the end of the input array. 
If length is omitted, removes everything from offset to the end of the 
array. If length is specified and is positive, then that many elements 
will be removed. If length is specified and is negative then the end of 
the removed portion will be that many elements from the end of the array. 
Tip: to remove everything from offset to the end of the array when 
replacement is also specified, use count($input) for length. 
If replacement array is specified, then the removed elements are replaced 
with elements from this array. If offset and length are such that nothing 
is removed, then the elements from the replacement array are inserted in 
the place specified by the offset. Tip: if the replacement is just one 
element it is not necessary to put array() around it, unless the element 
is an array itself. 
The following equivalences hold: 
Table 1. array_splice() equivalents
array_push($input, $x, $y) array_splice($input, count($input), 0, 
array($x, $y)) 
array_pop($input) array_splice($input, -1) 
array_shift($input) array_splice($input, -1) 
array_unshift($input, $x, $y) array_splice($input, 0, 0, array($x, 
$y)) 
$a[$x] = $y array_splice($input, $x, 1, $y) 

Returns the array consisting of removed elements. 
Example 1. array_splice() examples
  <?php
  $input = array("red", "green", "blue", "yellow");
  array_splice($input, 2);
  // $input is now array("red", "green")

  $input = array("red", "green", "blue", "yellow");
  array_splice($input, 1, -1);
  // $input is now array("red", "yellow")

  $input = array("red", "green", "blue", "yellow");
  array_splice($input, 1, count($input), "orange");
  // $input is now array("red", "orange")

  $input = array("red", "green", "blue", "yellow");
  array_splice($input, -1, 1, array("black", "maroon"));
  // $input is now array("red", "green",
  //          "blue", "black", "maroon")

  $input = array("red", "green", "blue", "yellow");
  array_splice($input, 3, 0, "purple");
  // $input is now array("red", "green",
  //          "blue", "purple", "yellow");
  ?> 
See also array_slice(), unset(), and array_merge().   array_sliceUparray_sum
#

#T=array array_splice ( array input, int offset [, int length [, array 
array_splice ( ^!array input, int offset [, int length [, array ;
#

#T=array_sum - mixed array_sum ( array array)
(PHP 4 >= 4.0.4)
array_sum --  Calculate the sum of values in an array. 
Description
mixed array_sum ( array array)
array_sum() returns the sum of values in an array as an integer or float. 
Example 1. array_sum() examples
  <?php
  $a = array(2, 4, 6, 8);
  echo "sum(a) = " . array_sum($a) . "\n";

  $b = array("a" => 1.2, "b" => 2.3, "c" => 3.4);
  echo "sum(b) = " . array_sum($b) . "\n";
  ?> 

The printout of the program above will be: 
sum(a) = 20
sum(b) = 6.9
Note: PHP versions prior to 4.2.1 modified the passed array itself and 
converted strings to numbers (which most of the time converted them to 
zero, depending on their value).   array_spliceUparray_udiff_assoc
array_udiff_assoc
(no version information, might be only in CVS)
array_udiff_assoc -- Computes the difference of arrays with additional 
index check. The data is compared by using a callback function.
Description
array array_udiff_assoc ( array array1, array array2 [, array ..., 
callback data_compare_func])
array_udiff_assoc() returns an array containing all the values from array1 
that are not present in any of the other arguments. Note that the keys are 
used in the comparison unlike array_diff() and array_udiff(). The 
comparison of arrays' data is performed by using an user-supplied 
callback. In this aspect the behaviour is opposite to the behaviour of 
array_diff_assoc() which uses internal function for comparison. 
Example 1. array_udiff_assoc() example
  <?php
  class cr {
      var $priv_member;
      function cr($val) {
	  $this->priv_member = $val;
      }
      function comp_func_cr($a, $b) {
	  if ($a->priv_member === $b->priv_member) return 0;
	  return ($a->priv_member > $b->priv_member)? 1:-1;
      }
  }
  $a = array("0.1" => new cr(9), "0.5" => new cr(12), 0 => new 
  cr(23), 1=> new cr(4), 2 => new cr(-15),);
  $b = array("0.2" => new cr(9), "0.5" => new cr(22), 0 => new 
  cr(3), 1=> new cr(4), 2 => new cr(-15),);

  $result = array_udiff_assoc($a, $b, array("cr", 
  "comp_func_cr"));
  print_r($result);
  ?> 

The result is: 
Array
(
[0.1] => cr Object
(
[priv_member:private] => 9
)

[0.5] => cr Object
(
[priv_member:private] => 12
)

[0] => cr Object
(
[priv_member:private] => 23
)
)
In our example above you see the "1" => new cr(4) pair is present in both 
arrays and thus it is not in the ouput from the function. 
For comparison is used the user supplied callback function. It must return 
an integer less than, equal to, or greater than zero if the first argument 
is considered to be respectively less than, equal to, or greater than the 
second. 
Note: Please note that this function only checks one dimension of a 
n-dimensional array. Of course you can check deeper dimensions by using, 
for example, array_udiff_assoc($array1[0], $array2[0], 
"some_comparison_func");. 
See also array_diff(), array_diff_assoc(), array_diff_uassoc(), 
array_udiff(), array_udiff_uassoc(), array_intersect(), 
array_intersect_assoc(), array_uintersect(), array_uintersect_assoc() and 
array_uintersect_uassoc().   array_sumUparray_udiff_uassoc
array_udiff_uassoc
(no version information, might be only in CVS)
array_udiff_uassoc -- Computes the difference of arrays with additional 
index check. The data is compared by using a callback function. The index 
check is done by a callback function also
Description
array array_udiff_uassoc ( array array1, array array2 [, array ..., 
callback data_compare_func, callback key_compare_func])
array_udiff_uassoc() returns an array containing all the values from 
array1 that are not present in any of the other arguments. Note that the 
keys are used in the comparison unlike array_diff() and array_udiff(). The 
comparison of arrays' data is performed by using an user-supplied callback 
: data_compare_func. In this aspect the behaviour is opposite to the 
behaviour of array_diff_assoc() which uses internal function for 
comparison. The comparison of keys (indices) is done also by the callback 
function key_compare_func. This behaviour is unlike what 
array_udiff_assoc() does, since the latter compares the indices by using 
an internal function. 
Example 1. array_udiff_uassoc() example
  <?php
  class cr {
      var $priv_member;
      function cr($val) {
	  $this->priv_member = $val;
      }
      function comp_func_cr($a, $b) {
	  if ($a->priv_member === $b->priv_member) return 0;
	  return ($a->priv_member > $b->priv_member)? 1:-1;
      }
      function comp_func_key($a, $b) {
	  if ($a === $b) return 0;
	  return ($a > $b)? 1:-1;
      }
  }
  $a = array("0.1" => new cr(9), "0.5" => new cr(12), 0 => new 
  cr(23), 1=> new cr(4), 2 => new cr(-15),);
  $b = array("0.2" => new cr(9), "0.5" => new cr(22), 0 => new 
  cr(3), 1=> new cr(4), 2 => new cr(-15),);

  $result = array_udiff_uassoc($a, $b, array("cr", 
  "comp_func_cr"), array("cr", "comp_func_key"));
  print_r($result);
  ?> 

The result is: 
Array
(
[0.1] => cr Object
(
[priv_member:private] => 9
)

[0.5] => cr Object
(
[priv_member:private] => 12
)

[0] => cr Object
(
[priv_member:private] => 23
)
)
In our example above you see the "1" => new cr(4) pair is present in both 
arrays and thus it is not in the ouput from the function. Keep in mind 
that you have to supply 2 callback functions. 
For comparison is used the user supplied callback function. It must return 
an integer less than, equal to, or greater than zero if the first argument 
is considered to be respectively less than, equal to, or greater than the 
second. 
Note: Please note that this function only checks one dimension of a 
n-dimensional array. Of course you can check deeper dimensions by using, 
for example, array_udiff_uassoc($array1[0], $array2[0], 
"data_compare_func", "key_compare_func");. 
See also array_diff(), array_diff_assoc(), array_diff_uassoc(), 
array_udiff(), array_udiff_assoc(), array_intersect(), 
array_intersect_assoc(), array_uintersect(), array_uintersect_assoc() and 
array_uintersect_uassoc().   array_udiff_assocUparray_udiff
array_udiff
(no version information, might be only in CVS)
array_udiff -- Computes the difference of arrays by using a callback 
function for data comparison.
Description
array array_udiff ( array array1, array array2 [, array ..., callback 
data_compare_func])
array_udiff() returns an array containing all the values of array1 that 
are not present in any of the other arguments. Note that keys are 
preserved. For the comparison of the data data_compare_func is used. It 
must return an integer less than, equal to, or greater than zero if the 
first argument is considered to be respectively less than, equal to, or 
greater than the second. This is unlike array_diff() which uses an 
internal function for comparing the data. 
Example 1. array_udiff() example
  <?php
  class cr {
      var $priv_member;
      function cr($val) {
	  $this->priv_member = $val;
      }
      function comp_func_cr($a, $b) {
	  if ($a->priv_member === $b->priv_member) return 0;
	  return ($a->priv_member > $b->priv_member)? 1:-1;
      }
  }
  $a = array("0.1" => new cr(9), "0.5" => new cr(12), 0 => new 
  cr(23), 1=> new cr(4), 2 => new cr(-15),);
  $b = array("0.2" => new cr(9), "0.5" => new cr(22), 0 => new 
  cr(3), 1=> new cr(4), 2 => new cr(-15),);

  $result = array_udiff($a, $b, array("cr", "comp_func_cr"));
  print_r($result);
  ?> 

The result is: 
Array
(
[0.5] => cr Object
(
[priv_member:private] => 12
)

[0] => cr Object
(
[priv_member:private] => 23
)

)
Note: Two elements are considered equal if and only if (string) $elem1 
=== (string) $elem2. In words: when the string representation is the 
same. 
Note: Please note that this function only checks one dimension of a 
n-dimensional array. Of course you can check deeper dimensions by using 
array_udiff($array1[0], $array2[0], "data_compare_func");. 
See also array_diff(), array_diff_assoc(), array_diff_uassoc(), 
array_udiff_assoc(), array_udiff_uassoc(), array_intersect(), 
array_intersect_assoc(), array_uintersect(), array_uintersect_assoc() and 
array_uintersect_uassoc().   array_udiff_uassocUparray_unique
#

#T=mixed array_sum ( array array)
array_sum ( ^!array array);
#

#T=array_unique - array array_unique ( array array)
(PHP 4 >= 4.0.1)
array_unique -- Removes duplicate values from an array
Description
array array_unique ( array array)
array_unique() takes input array and returns a new array without duplicate 
values. 
Note that keys are preserved. array_unique() sorts the values treated as 
string at first, then will keep the first key encountered for every value, 
and ignore all following keys. It does not mean that the key of the first 
related value from the unsorted array will be kept. 
Note: Two elements are considered equal if and only if (string) $elem1 
=== (string) $elem2. In words: when the string representation is the 
same. 
The first element will be used. 
Example 1. array_unique() example
  <?php
  $input = array("a" => "green", "red", "b" => "green", "blue", 
  "red");
  $result = array_unique($input);
  print_r($result);
  ?> 

This will output: 
  Array
  (
      [a] => green
      [0] => red
      [1] => blue
  ) 
Example 2. array_unique() and types
  <?php
  $input = array(4, "4", "3", 4, 3, "3");
  $result = array_unique($input);
  var_dump($result);
  ?> 

This script will output: 
  array(2) {
    [0] => int(4)
    [2] => string(1) "3"
  } 

  array_udiffUparray_unshift
#

#T=array array_unique ( array array)
array_unique ( ^!array array);
#

#T=array_unshift - int array_unshift ( array array, mixed var [, mixed ...])
(PHP 4 )
array_unshift --  Prepend one or more elements to the beginning of an 
array 
Description
int array_unshift ( array array, mixed var [, mixed ...])
array_unshift() prepends passed elements to the front of the array. Note 
that the list of elements is prepended as a whole, so that the prepended 
elements stay in the same order. All numerical array keys will be modified 
to start counting from zero while literal keys won't be touched. 
Returns the new number of elements in the array. 
Example 1. array_unshift() example
  <?php
  $queue = array("orange", "banana");
  array_unshift($queue, "apple", "raspberry");
  ?> 

This would result in $queue having the following elements: 
  Array
  (
      [0] => apple
      [1] => raspberry
      [2] => orange
      [3] => banana
  ) 
See also array_shift(), array_push(), and array_pop().   array_uniqueUparray_values
#

#T=int array_unshift ( array array, mixed var [, mixed ...])
array_unshift ( ^!array array, mixed var [, mixed ...]);
#

#T=array_values - array array_values ( array input)
(PHP 4 )
array_values -- Return all the values of an array
Description
array array_values ( array input)
array_values() returns all the values from the input array and indexes 
numerically the array. 
Example 1. array_values() example
  <?php
  $array = array("size" => "XL", "color" => "gold");
  print_r(array_values($array));
  ?> 

This will output: 
  Array
  (
      [0] => XL
      [1] => gold
  ) 
See also array_keys().   array_unshiftUparray_walk
#

#T=array array_values ( array input)
array_values ( ^!array input);
#

#T=array_walk - bool array_walk ( array array, callback function [, mixed userdata])
(PHP 3>= 3.0.3, PHP 4 )
array_walk --  Apply a user function to every member of an array 
Description
bool array_walk ( array array, callback function [, mixed userdata])
Returns TRUE on success or FALSE on failure. 
Applies the user-defined function function to each element of the array 
array. Typically, function takes on two parameters. The array parameter's 
value being the first, and the key/index second. If the optional userdata 
parameter is supplied, it will be passed as the third parameter to the 
callback function. 
If function function requires more parameters than given to it, an error 
of level E_WARNING will be generated each time array_walk() calls 
function. These warnings may be suppressed by prepending the PHP error 
operator @ to the array_walk() call, or by using error_reporting(). 
Note: If function needs to be working with the actual values of the 
array, specify the first parameter of function as a reference. Then, any 
changes made to those elements will be made in the original array 
itself. 
Note: Passing the key and userdata to function was added in 4.0.0 
array_walk() is not affected by the internal array pointer of array. 
array_walk() will walk through the entire array regardless of pointer 
position. To reset the pointer, use reset(). In PHP 3, array_walk() resets 
the pointer. 
Users may not change the array itself from the callback function. e.g. 
Add/delete elements, unset elements, etc. If the array that array_walk() 
is applied to is changed, the behavior of this function is undefined, and 
unpredictable. 
Example 1. array_walk() example
  <?php
  $fruits = array("d" => "lemon", "a" => "orange", "b" => 
  "banana", "c" => "apple");

  function test_alter(&$item1, $key, $prefix) {
      $item1 = "$prefix: $item1";
  }

  function test_print($item2, $key) {
      echo "$key. $item2<br />\n";
  }

  echo "Before ...:\n";
  array_walk($fruits, 'test_print');

  array_walk($fruits, 'test_alter', 'fruit');
  echo "... and after:\n";

  array_walk($fruits, 'test_print');
  ?> 

The printout of the program above will be: 
  Before ...:
  d. lemon
  a. orange
  b. banana
  c. apple
  ... and after:
  d. fruit: lemon
  a. fruit: orange
  b. fruit: banana
  c. fruit: apple 
See also list(), foreach, each(), and call_user_func_array().   array_valuesUparray
#

#T=bool array_walk ( array array, callback function [, mixed userdata])
array_walk ( ^!array array, callback function [, mixed userdata]);
#

#T=array - array array ( [mixed ...])
(PHP 3, PHP 4 )
array --  Create an array 
Description
array array ( [mixed ...])
Returns an array of the parameters. The parameters can be given an index 
with the => operator. Read the section on the array type for more 
information on what an array is. 
Note: array() is a language construct used to represent literal arrays, 
and not a regular function. 
Syntax "index => values", separated by commas, define index and values. 
index may be of type string or numeric. When index is omitted, an integer 
index is automatically generated, starting at 0. If index is an integer, 
next generated index will be the biggest integer index + 1. Note that when 
two identical index are defined, the last overwrite the first. 
The following example demonstrates how to create a two-dimensional array, 
how to specify keys for associative arrays, and how to skip-and-continue 
numeric indices in normal arrays. Example 1. array() example
  <?php
  $fruits = array (
      "fruits"  => array("a" => "orange", "b" => "banana", "c" 
  => "apple"),
      "numbers" => array(1, 2, 3, 4, 5, 6),
      "holes"   => array("first", 5 => "second", "third")
  )
  ?> 
Example 2. Automatic index with array()
  <?php
  $array = array(1, 1, 1, 1,  1, 8 => 1,  4 => 1, 19, 3 => 13);
  print_r($array);
  ?> 

will display: 
  Array
  (
      [0] => 1
      [1] => 1
      [2] => 1
      [3] => 13
      [4] => 1
      [8] => 1
      [9] => 19
  ) 
Note that index '3' is defined twice, and keep its final value of 13. 
Index 4 is defined after index 8, and next generated index (value 19) is 
9, since biggest index was 8. 
This example creates a 1-based array. Example 3. 1-based index with 
array()
  <?php
  $firstquarter = array(1 => 'January', 'February', 'March');
  print_r($firstquarter);
  ?> 

will display: 
Array
(
[1] => January
[2] => February
[3] => March
)
See also array_pad(), list(), foreach, and range().   array_walkUparsort
#

#T=array array ( [mixed ...])
array ( ^![mixed ...]);
#

#T=arsort - bool arsort ( array array [, int sort_flags])
(PHP 3, PHP 4 )
arsort --  Sort an array in reverse order and maintain index association 
Description
bool arsort ( array array [, int sort_flags])
This function sorts an array such that array indices maintain their 
correlation with the array elements they are associated with. This is used 
mainly when sorting associative arrays where the actual element order is 
significant. 
Returns TRUE on success or FALSE on failure. 
Example 1. arsort() example
  <?php
  $fruits = array("d" => "lemon", "a" => "orange", "b" => 
  "banana", "c" => "apple");
  arsort($fruits);
  reset($fruits);
  while (list($key, $val) = each($fruits)) {
      echo "$key = $val\n";
  }
  ?> 

This example would display: 
a = orange
d = lemon
b = banana
c = apple
The fruits have been sorted in reverse alphabetical order, and the index 
associated with each element has been maintained. 
You may modify the behavior of the sort using the optional parameter 
sort_flags, for details see sort(). 
See also asort(), rsort(), ksort(), and sort().   arrayUpasort
#

#T=bool arsort ( array array [, int sort_flags])
arsort ( ^!array array [, int sort_flags]);
#

#T=ascii2ebcdic - int ascii2ebcdic ( string ascii_str)
(PHP 3>= 3.0.17)
ascii2ebcdic -- Translate string from ASCII to EBCDIC
Description
int ascii2ebcdic ( string ascii_str)
ascii2ebcdic() is an Apache-specific function which is available only on 
EBCDIC based operating systems (OS/390, BS2000). It translates the ASCII 
encoded string ascii_str to its equivalent EBCDIC representation (binary 
safe), and returns the result. 
See also the reverse function ebcdic2ascii()   apache_setenvUpebcdic2ascii
#

#T=int ascii2ebcdic ( string ascii_str)
ascii2ebcdic ( ^!string ascii_str);
#

#T=asin - float asin ( float arg)
(PHP 3, PHP 4 )
asin -- Arc sine
Description
float asin ( float arg)
Returns the arc sine of arg in radians. asin() is the complementary 
function of sin(), which means that a==sin(asin(a)) for every value of a 
that is within asin()'s range. 
See also asinh(), acos() and atan().   acoshUpasinh
#

#T=float asin ( float arg)
asin ( ^!float arg);
#

#T=asinh - float asinh ( float arg)
(PHP 4 >= 4.1.0)
asinh -- Inverse hyperbolic sine
Description
float asinh ( float arg)
Returns the inverse hyperbolic sine of arg, i.e. the value whose 
hyperbolic sine is arg. 
Note: This function is not implemented on Windows platforms.
See also asin(), acosh() and atanh().   asinUpatan2
#

#T=float asinh ( float arg)
asinh ( ^!float arg);
#

#T=asort - bool asort ( array array [, int sort_flags])
(PHP 3, PHP 4 )
asort -- Sort an array and maintain index association
Description
bool asort ( array array [, int sort_flags])
This function sorts an array such that array indices maintain their 
correlation with the array elements they are associated with. This is used 
mainly when sorting associative arrays where the actual element order is 
significant. 
Returns TRUE on success or FALSE on failure. 
Example 1. asort() example
  <?php
  $fruits = array("d" => "lemon", "a" => "orange", "b" => 
  "banana", "c" => "apple");
  asort($fruits);
  reset($fruits);
  while (list($key, $val) = each($fruits)) {
      echo "$key = $val\n";
  }
  ?> 

This example would display: 
c = apple
b = banana
d = lemon
a = orange
The fruits have been sorted in alphabetical order, and the index 
associated with each element has been maintained. 
You may modify the behavior of the sort using the optional parameter 
sort_flags, for details see sort(). 
See also arsort(), rsort(), ksort(), and sort().   arsortUpcompact
#

#T=bool asort ( array array [, int sort_flags])
asort ( ^!array array [, int sort_flags]);
#

#T=aspell_check_raw - bool aspell_check_raw ( int dictionary_link, string word)
(PHP 3>= 3.0.7, PHP 4 <= 4.2.3)
aspell_check_raw --  Check a word without changing its case or trying to 
trim it [deprecated] 
Description
bool aspell_check_raw ( int dictionary_link, string word)
aspell_check_raw() checks the spelling of a word, without changing its 
case or trying to trim it in any way and returns TRUE if the spelling is 
correct, FALSE if not. 
Example 1. aspell_check_raw()
  <?php

  $aspell_link = aspell_new("english");

  if (aspell_check_raw($aspell_link, "test")) {
      echo "This is a valid spelling";
  } else {
      echo "Sorry, wrong spelling";
  }

  ?> 

  Aspell functions [deprecated]Upaspell_check
#

#T=bool aspell_check_raw ( int dictionary_link, string word)
aspell_check_raw ( ^!int dictionary_link, string word);
#

#T=aspell_check - bool aspell_check ( int dictionary_link, string word)
(PHP 3>= 3.0.7, PHP 4 <= 4.2.3)
aspell_check -- Check a word [deprecated]
Description
bool aspell_check ( int dictionary_link, string word)
aspell_check() checks the spelling of a word and returns TRUE if the 
spelling is correct, FALSE if not. 
Example 1. aspell_check()
  <?php

  $aspell_link = aspell_new("english");

  if (aspell_check($aspell_link, "testt")) {
      echo "This is a valid spelling";
  } else {
      echo "Sorry, wrong spelling";
  }

  ?> 

  aspell_check_rawUpaspell_new
#

#T=bool aspell_check ( int dictionary_link, string word)
aspell_check ( ^!int dictionary_link, string word);
#

#T=aspell_new - int aspell_new ( string master [, string personal])
(PHP 3>= 3.0.7, PHP 4 <= 4.2.3)
aspell_new -- Load a new dictionary [deprecated]
Description
int aspell_new ( string master [, string personal])
aspell_new() opens up a new dictionary and returns the dictionary link 
identifier for use in other aspell functions. Returns FALSE on error. 
Example 1. aspell_new()
  <?php
  $aspell_link = aspell_new("english");
  ?> 

  aspell_checkUpaspell_suggest
#

#T=int aspell_new ( string master [, string personal])
aspell_new ( ^!string master [, string personal]);
#

#T=aspell_suggest - array aspell_suggest ( int dictionary_link, string word)
(PHP 3>= 3.0.7, PHP 4 <= 4.2.3)
aspell_suggest -- Suggest spellings of a word [deprecated]
Description
array aspell_suggest ( int dictionary_link, string word)
aspell_suggest() returns an array of possible spellings for the given 
word. 
Example 1. aspell_suggest()
  <?php

  $aspell_link = aspell_new("english");

  if (!aspell_check($aspell_link, "test")) {
      $suggestions = aspell_suggest($aspell_link, "test");

      foreach ($suggestions as $suggestion) {
	  echo "Possible spelling: $suggestion<br />\n"; 
      }
  }

  ?> 

  aspell_newUpBCMath Arbitrary Precision Mathematics Functions
#

#T=array aspell_suggest ( int dictionary_link, string word)
aspell_suggest ( ^!int dictionary_link, string word);
#

#T=assert_options - mixed assert_options ( int what [, mixed value])
(PHP 4 )
assert_options -- Set/get the various assert flags
Description
mixed assert_options ( int what [, mixed value])
Using assert_options() you may set the various assert() control options or 
just query their current settings. 
Table 1. Assert Options
optionini-parameterdefaultdescription
ASSERT_ACTIVEassert.active1enable assert() evaluation
ASSERT_WARNINGassert.warning1issue a PHP warning for each failed 
assertion
ASSERT_BAILassert.bail0terminate execution on failed assertions
ASSERT_QUIET_EVALassert.quiet_eval0disable error_reporting during 
assertion expression evaluation 
ASSERT_CALLBACKassert.callback(NULL)user function to call on failed 
assertions

assert_options() will return the original setting of any option or FALSE 
on errors.   PHP Options&InformationUpassert
#

#T=mixed assert_options ( int what [, mixed value])
assert_options ( ^!int what [, mixed value]);
#

#T=assert - int assert ( mixed assertion)
(PHP 4 )
assert -- Checks if assertion is FALSE
Description
int assert ( mixed assertion)
assert() will check the given assertion and take appropriate action if its 
result is FALSE. 
If the assertion is given as a string it will be evaluated as PHP code by 
assert(). The advantages of a string assertion are less overhead when 
assertion checking is off and messages containing the assertion expression 
when an assertion fails. This means that if you pass a boolean condition 
as assertion this condition will not show up as parameter to the assertion 
function which you may have defined with the assert_options() function, 
the condition is converted to a string before calling that handler 
function, and the boolean FALSE is converted as the empty string. 
Assertions should be used as a debugging feature only. You may use them 
for sanity-checks that test for conditions that should always be TRUE and 
that indicate some programming errors if not or to check for the presence 
of certain features like extension functions or certain system limits and 
features. 
Assertions should not be used for normal runtime operations like input 
parameter checks. As a rule of thumb your code should always be able to 
work correctly if assertion checking is not activated. 
The behavior of assert() may be configured by assert_options() or by 
.ini-settings described in that functions manual page. 
The assert_options() function and/or ASSERT_CALLBACK configuration 
directive allow a callback function to be set to handle failed assertions. 

assert() callbacks are particularly useful for building automated test 
suites because they allow you to easily capture the code passed to the 
assertion, along with information on where the assertion was made. While 
this information can be captured via other methods, using assertions makes 
it much faster and easier! 
The callback function should accept three arguments. The first argument 
will contain the file the assertion failed in. The second argument will 
contain the line the assertion failed on and the third argument will 
contain the expression that failed (if any - literal values such as 1 or 
"two" will not be passed via this argument) 
Example 1. Handle a failed assertion with a custom handler
  <?php
  // Active assert and make it quiet
  assert_options(ASSERT_ACTIVE, 1);
  assert_options(ASSERT_WARNING, 0);
  assert_options(ASSERT_QUIET_EVAL, 1);

  // Create a handler function
  function my_assert_handler($file, $line, $code) {
      echo "<hr>Assertion Failed:
	  File '$file'<br />
	  Line '$line'<br />
	  Code '$code'<br /><hr />";
  }

  // Set up the callback
  assert_options(ASSERT_CALLBACK, 'my_assert_handler');

  // Make an assertion that should fail
  assert('mysql_query("")');
  ?> 

  assert_optionsUpdl
#

#T=int assert ( mixed assertion)
assert ( ^!mixed assertion);
#

#T=atan - float atan ( float arg)
(PHP 3, PHP 4 )
atan -- Arc tangent
Description
float atan ( float arg)
Returns the arc tangent of arg in radians. atan() is the complementary 
function of tan(), which means that a==tan(atan(a)) for every value of a 
that is within atan()'s range. 
See also atanh(), asin() and acos().   atan2Upatanh
#

#T=float atan ( float arg)
atan ( ^!float arg);
#

#T=atan2 - float atan2 ( float y, float x)
(PHP 3>= 3.0.5, PHP 4 )
atan2 -- Arc tangent of two variables
Description
float atan2 ( float y, float x)
This function calculates the arc tangent of the two variables x and y. It 
is similar to calculating the arc tangent of y / x, except that the signs 
of both arguments are used to determine the quadrant of the result. 
The function returns the result in radians, which is between -PI and PI 
(inclusive). 
See also acos() and atan().   asinhUpatan
#

#T=float atan2 ( float y, float x)
atan2 ( ^!float y, float x);
#

#T=atanh - float atanh ( float arg)
(PHP 4 >= 4.1.0)
atanh -- Inverse hyperbolic tangent
Description
float atanh ( float arg)
Returns the inverse hyperbolic tangent of arg, i.e. the value whose 
hyperbolic tangent is arg. 
Note: This function is not implemented on Windows platforms.
See also atan(), asinh() and acosh().   atanUpbase_convert
#

#T=float atanh ( float arg)
atanh ( ^!float arg);
#

#T=base_convert - string base_convert ( string number, int frombase, int tobase)
(PHP 3>= 3.0.6, PHP 4 )
base_convert -- Convert a number between arbitrary bases
Description
string base_convert ( string number, int frombase, int tobase)
Returns a string containing number represented in base tobase. The base in 
which number is given is specified in frombase. Both frombase and tobase 
have to be between 2 and 36, inclusive. Digits in numbers with a base 
higher than 10 will be represented with the letters a-z, with a meaning 
10, b meaning 11 and z meaning 35. Example 1. base_convert()
  <?php
  $hexadecimal = 'A37334';
  echo base_convert($hexadecimal, 16, 2);
  ?> 

Outputs: 
101000110111001100110100

  atanhUpbindec
#

#T=string base_convert ( string number, int frombase, int tobase)
base_convert ( ^!string number, int frombase, int tobase);
#

#T=base64_decode - string base64_decode ( string encoded_data)
(PHP 3, PHP 4 )
base64_decode -- Decodes data encoded with MIME base64
Description
string base64_decode ( string encoded_data)
base64_decode() decodes encoded_data and returns the original data or 
FALSE on failure. The returned data may be binary. 
Example 1. base64_decode() example
  <?php
  $str = 'VGhpcyBpcyBhbiBlbmNvZGVkIHN0cmluZw==';
  echo base64_decode($str);
  ?> 

This example will produce : 
This is an encoded string
See also base64_encode() and RFC 2045 section 6.8.   URL FunctionsUpbase64_encode
#

#T=string base64_decode ( string encoded_data)
base64_decode ( ^!string encoded_data);
#

#T=base64_encode - string base64_encode ( string data)
(PHP 3, PHP 4 )
base64_encode -- Encodes data with MIME base64
Description
string base64_encode ( string data)
base64_encode() returns data encoded with base64. This encoding is 
designed to make binary data survive transport through transport layers 
that are not 8-bit clean, such as mail bodies. 
Base64-encoded data takes about 33% more space than the original data. 
Example 1. base64_encode() example
  <?php
    $str = 'This is an encoded string';
    echo base64_encode($str);
  ?> 

This example will produce : 
VGhpcyBpcyBhbiBlbmNvZGVkIHN0cmluZw==
See also base64_decode(), chunk_split() and RFC 2045 section 6.8.   base64_decodeUpget_meta_tags
#

#T=string base64_encode ( string data)
base64_encode ( ^!string data);
#

#T=basename - string basename ( string path [, string suffix])
(PHP 3, PHP 4 )
basename -- Returns filename component of path
Description
string basename ( string path [, string suffix])
Given a string containing a path to a file, this function will return the 
base name of the file. If the filename ends in suffix this will also be 
cut off. 
On Windows, both slash (/) and backslash (\) are used as path separator 
character. In other environments, it is the forward slash (/). 
Example 1. basename() example
  <?php
  $path = "/home/httpd/html/index.php";
  $file = basename($path);        // $file is set to "index.php"
  $file = basename($path, ".php"); // $file is set to "index"
  ?> 
Note: The suffix parameter was added in PHP 4.1.0. 
See also: dirname()   Filesystem functionsUpchgrp
#

#T=string basename ( string path [, string suffix])
basename ( ^!string path [, string suffix]);
#

#T=bcadd - string bcadd ( string left_operand, string right_operand [, int scale])
(PHP 3, PHP 4 )
bcadd -- Add two arbitrary precision numbers
Description
string bcadd ( string left_operand, string right_operand [, int scale])
Adds the left_operand to the right_operand and returns the sum in a 
string. The optional scale parameter is used to set the number of digits 
after the decimal place in the result. 
Example 1. bcadd() example
  <?php

  $a = 1.234;
  $b = 5;

  echo bcadd($a, $b);     // 6
  echo bcadd($a, $b, 4);  // 6.2340

  ?> 
See also bcsub().   BCMath Arbitrary Precision Mathematics FunctionsUpbccomp
#

#T=string bcadd ( string left_operand, string right_operand [, int scale])
bcadd ( ^!string left_operand, string right_operand [, int scale]);
#

#T=bccomp - int bccomp ( string left_operand, string right_operand [, int scale])
(PHP 3, PHP 4 )
bccomp -- Compare two arbitrary precision numbers
Description
int bccomp ( string left_operand, string right_operand [, int scale])
Compares the left_operand to the right_operand and returns the result as 
an integer. The optional scale parameter is used to set the number of 
digits after the decimal place which will be used in the comparison. The 
return value is 0 if the two operands are equal. If the left_operand is 
larger than the right_operand the return value is +1 and if the 
left_operand is less than the right_operand the return value is -1. 
Example 1. bccomp() example
  <?php
  echo bccomp('1', '2') . "\n";

  echo bccomp('1.00001', '1', 3) . "\n";
  echo bccomp('1.00001', '1', 5);
  ?> 

The above example will output: 
-1
0
1

  bcaddUpbcdiv
#

#T=int bccomp ( string left_operand, string right_operand [, int scale])
bccomp ( ^!string left_operand, string right_operand [, int scale]);
#

#T=bcdiv - string bcdiv ( string left_operand, string right_operand [, int scale])
(PHP 3, PHP 4 )
bcdiv -- Divide two arbitrary precision numbers
Description
string bcdiv ( string left_operand, string right_operand [, int scale])
Divides the left_operand by the right_operand and returns the result. The 
optional scale sets the number of digits after the decimal place in the 
result. 
Example 1. bcdiv() example
  <?php

  echo bcdiv(105, 6.55957, 3);  // 16.007

  ?> 
See also bcmul().   bccompUpbcmod
#

#T=string bcdiv ( string left_operand, string right_operand [, int scale])
bcdiv ( ^!string left_operand, string right_operand [, int scale]);
#

#T=bcmod - string bcmod ( string left_operand, string modulus)
(PHP 3, PHP 4 )
bcmod --  Get modulus of an arbitrary precision number 
Description
string bcmod ( string left_operand, string modulus)
Get the modulus of the left_operand using modulus. 
Example 1. bcmod() example
  <?php
  echo bcmod(4, 2) . "\n";
  echo bcmod(2, 4);
  ?> 

The above example will output: 
0
2
See also bcdiv().   bcdivUpbcmul
#

#T=string bcmod ( string left_operand, string modulus)
bcmod ( ^!string left_operand, string modulus);
#

#T=bcmul - string bcmul ( string left_operand, string right_operand [, int scale])
(PHP 3, PHP 4 )
bcmul -- Multiply two arbitrary precision number
Description
string bcmul ( string left_operand, string right_operand [, int scale])
Multiply the left_operand by the right_operand and returns the result. The 
optional scale sets the number of digits after the decimal place in the 
result. 
Example 1. bcmul() example
  <?php
  echo bcmul(1.34747474747, 35, 3) . "\n";
  echo bcmul(2, 4);
  ?> 

The above example will output: 
47.162
8
See also bcdiv().   bcmodUpbcpow
#

#T=string bcmul ( string left_operand, string right_operand [, int scale])
bcmul ( ^!string left_operand, string right_operand [, int scale]);
#

#T=bcpow - string bcpow ( number x, int y [, int scale])
(PHP 3, PHP 4 )
bcpow --  Raise an arbitrary precision number to another 
Description
string bcpow ( number x, int y [, int scale])
Raise x to the power y. The optional scale can be used to set the number 
of digits after the decimal place in the result. 
Example 1. bcpow() example
  <?php

  echo bcpow(4.2, 3, 2); // 74.08

  ?> 
See also bcpowmod(), and bcsqrt().   bcmulUpbcpowmod
#

#T=string bcpow ( number x, int y [, int scale])
bcpow ( ^!number x, int y [, int scale]);
#

#T=bcpowmod - string bcpowmod ( string x, string y, string modulus [, int scale])
(PHP 5 CVS only)
bcpowmod --  Raise an arbitrary precision number to another, reduced by a 
specified modulus. 
Description
string bcpowmod ( string x, string y, string modulus [, int scale])
Use the fast-exponentiation method to raise x to the power y with respect 
to the modulus modulus. The optional scale can be used to set the number 
of digits after the decimal place in the result. 
The following two statements are functionally identical. The bcpowmod() 
version however, executes in less time and can accept larger parameters. 
<?php
$a = bcpowmod($x, $y, $mod);

$b = bcmod(bcpow($x, $y), $mod);

// $a and $b are equal to each other. 

?> 

Note: Because this method uses the modulus operation, non-natural 
numbers may give unexpected results. A natural number is any positive 
non-zero integer. 
See also bcpow(), and bcmod().   bcpowUpbcscale
#

#T=string bcpowmod ( string x, string y, string modulus [, int scale])
bcpowmod ( ^!string x, string y, string modulus [, int scale]);
#

#T=bcscale - string bcscale ( int scale)
(PHP 3, PHP 4 )
bcscale --  Set default scale parameter for all bc math functions 
Description
string bcscale ( int scale)
This function sets the default scale parameter for all subsequent bc math 
functions that do not explicitly specify a scale parameter. 
Example 1. bcscale() example
  <?php

  // default scale : 3
  bcscale(3);
  echo bcdiv(105, 6.55957); // 16.007

  // this is the same without bcscale()
  echo bcdiv(105, 6.55957, 3); // 16.007

  ?> 

  bcpowmodUpbcsqrt
#

#T=string bcscale ( int scale)
bcscale ( ^!int scale);
#

#T=bcsqrt - string bcsqrt ( string operand [, int scale])
(PHP 3, PHP 4 )
bcsqrt --  Get the square root of an arbitrary precision number 
Description
string bcsqrt ( string operand [, int scale])
Return the square root of the operand. The optional scale parameter sets 
the number of digits after the decimal place in the result. 
Example 1. bcsqrt() example
  <?php

  echo bcsqrt(2, 3); // 1.414

  ?> 
See also bcpow().   bcscaleUpbcsub
#

#T=string bcsqrt ( string operand [, int scale])
bcsqrt ( ^!string operand [, int scale]);
#

#T=bcsub - string bcsub ( string left_operand, string right_operand [, int scale])
(PHP 3, PHP 4 )
bcsub --  Subtract one arbitrary precision number from another 
Description
string bcsub ( string left_operand, string right_operand [, int scale])
Subtracts the right_operand from the left_operand and returns the result 
in a string. The optional scale parameter is used to set the number of 
digits after the decimal place in the result. 
Example 1. bcsub() example
  <?php

  $a = 1.234;
  $b = 5;

  echo bcsub($a, $b);     // -3
  echo bcsub($a, $b, 4);  // -3.7660

  ?> 
See also bcadd().   bcsqrtUpBzip2 Compression Functions
#

#T=string bcsub ( string left_operand, string right_operand [, int scale])
bcsub ( ^!string left_operand, string right_operand [, int scale]);
#

#T=bin2hex - string bin2hex ( string str)
(PHP 3>= 3.0.9, PHP 4 )
bin2hex --  Convert binary data into hexadecimal representation 
Description
string bin2hex ( string str)
Returns an ASCII string containing the hexadecimal representation of str. 
The conversion is done byte-wise with the high-nibble first. 
See also pack() and unpack().   addslashesUpchop
#

#T=string bin2hex ( string str)
bin2hex ( ^!string str);
#

#T=bind_textdomain_codeset - string bind_textdomain_codeset ( string domain, string codeset)
(PHP 4 >= 4.2.0)
bind_textdomain_codeset --  Specify the character encoding in which the 
messages from the DOMAIN message catalog will be returned 
Description
string bind_textdomain_codeset ( string domain, string codeset)
Warning
This function is currently not documented; only the argument list is 
available.
  GettextUpbindtextdomain
#

#T=string bind_textdomain_codeset ( string domain, string codeset)
bind_textdomain_codeset ( ^!string domain, string codeset);
#

#T=bindec - int bindec ( string binary_string)
(PHP 3, PHP 4 )
bindec -- Binary to decimal
Description
int bindec ( string binary_string)
Returns the decimal equivalent of the binary number represented by the 
binary_string argument. 
bindec() converts a binary number to an integer. The largest number that 
can be converted is 31 bits of 1's or 2147483647 in decimal. 
Example 1. bindec() example
  <?php
  echo bindec('110011') . "\n";
  echo bindec('000110011') . "\n";

  echo bindec('111');
  ?> 

The above example will output: 
51
51
7
See also decbin(), octdec(), hexdec() and base_convert().   base_convertUpceil
#

#T=int bindec ( string binary_string)
bindec ( ^!string binary_string);
#

#T=bindtextdomain - string bindtextdomain ( string domain, string directory)
(PHP 3>= 3.0.7, PHP 4 )
bindtextdomain -- Sets the path for a domain
Description
string bindtextdomain ( string domain, string directory)
The bindtextdomain() function sets the path for a domain. It returns the 
full pathname for the domain currently being set. 
Example 1. bindtextdomain() example
  <?php

  $domain = 'myapp';
  echo bindtextdomain($domain, '/usr/share/myapp/locale'); 

  ?> 

This will output : 
/usr/share/myapp/locale

  bind_textdomain_codesetUpdcgettext
bzclose
(4.0.4 - 4.3.2 only)
bzclose -- Close a bzip2 file pointer
Description
int bzclose ( resource bz)
Closes the bzip2 file referenced by the pointer bz. 
Returns TRUE on success or FALSE on failure. 
The file pointer must be valid, and must point to a file successfully 
opened by bzopen(). 
See also bzopen().   Bzip2 Compression FunctionsUpbzcompress
bzcompress
(4.0.4 - 4.3.2 only)
bzcompress -- Compress a string into bzip2 encoded data
Description
string bzcompress ( string source [, int blocksize [, int workfactor]])
bzcompress() compresses the source string and returns it as bzip2 encoded 
data. 
The optional parameter blocksize specifies the blocksize used during 
compression and should be a number from 1 to 9 with 9 giving the best 
compression, but using more resources to do so. blocksize defaults to 4. 
The optional parameter workfactor controls how the compression phase 
behaves when presented with worst case, highly repetitive, input data. The 
value can be between 0 and 250 with 0 being a special case and 30 being 
the default value. Regardless of the workfactor, the generated output is 
the same. 
Example 1. bzcompress() Example
  <?php
  $str = "sample data";
  $bzstr = bzcompress($str, 9);
  echo $bzstr;
  ?> 
See also bzdecompress().   bzcloseUpbzdecompress
bzdecompress
(4.0.4 - 4.3.2 only)
bzdecompress -- Decompresses bzip2 encoded data
Description
string bzdecompress ( string source [, int small])
bzdecompress() decompresses the source string containing bzip2 encoded 
data and returns it. If the optional parameter small is TRUE, an 
alternative decompression algorithm will be used which uses less memory 
(the maximum memory requirement drops to around 2300K) but works at 
roughly half the speed. See the bzip2 documentation for more information 
about this feature. 
Example 1. bzdecompress()
  <?php
  $start_str = "This is not an honest face?";
  $bzstr = bzcompress($start_str);

  echo "Compressed String: ";
  echo $bzstr;
  echo "\n<br />\n";

  $str = bzdecompress($bzstr);
  echo "Decompressed String: ";
  echo $str;
  echo "\n<br />\n";
  ?> 
See also bzcompress().   bzcompressUpbzerrno
bzerrno
(4.0.4 - 4.3.2 only)
bzerrno -- Returns a bzip2 error number
Description
int bzerrno ( resource bz)
Returns the error number of any bzip2 error returned by the file pointer 
bz. 
See also bzerror() and bzerrstr().   bzdecompressUpbzerror
bzerror
(4.0.4 - 4.3.2 only)
bzerror -- Returns the bzip2 error number and error string in an array
Description
array bzerror ( resource bz)
Returns the error number and error string, in an associative array, of any 
bzip2 error returned by the file pointer bz. 
Example 1. bzerror() Example
  <?php
  $error = bzerror($bz);

  echo $error["errno"];
  echo $error["errstr"];
  ?> 
See also bzerrno() and bzerrstr().   bzerrnoUpbzerrstr
bzerrstr
(4.0.4 - 4.3.2 only)
bzerrstr -- Returns a bzip2 error string
Description
string bzerrstr ( resource bz)
Returns the error string of any bzip2 error returned by the file pointer 
bz. 
See also bzerrno() and bzerror().   bzerrorUpbzflush
bzflush
(4.0.4 - 4.3.2 only)
bzflush -- Force a write of all buffered data
Description
int bzflush ( resource bz)
Forces a write of all buffered bzip2 data for the file pointer bz. 
Returns TRUE on success or FALSE on failure. 
See also bzread() and bzwrite().   bzerrstrUpbzopen
bzopen
(4.0.4 - 4.3.2 only)
bzopen -- Opens a bzip2 compressed file
Description
resource bzopen ( string filename, string mode)
bzopen() opens a bzip2 (.bz2) file for reading or writing. filename is the 
name of the file to open. mode is similar to the fopen() function (`r' for 
read, `w' for write, etc.). 
If the open fails, bzopen() returns FALSE, otherwise it returns a pointer 
to the newly opened file. 
Example 1. bzopen() Example
  <?php

  $file = "/tmp/foo.bz2";
  $bz = bzopen($file, "r") or die("Couldn't open $file for 
  reading");

  bzclose($bz);

  ?> 
See also bzclose().   bzflushUpbzread
bzread
(4.0.4 - 4.3.2 only)
bzread -- Binary safe bzip2 file read
Description
string bzread ( resource bz [, int length])
bzread() reads up to length bytes from the bzip2 file pointer referenced 
by bz. Reading stops when length (uncompressed) bytes have been read or 
EOF is reached, whichever comes first. If the optional parameter length is 
not specified, bzread() will read 1024 (uncompressed) bytes at a time. 
Example 1. bzread() Example
  <?php

  $file = "/tmp/foo.bz2";
  $bz = bzopen($file", "r") or die("Couldn't open $file");

  $decompressed_file = '';
  while (!feof($bz)) {
      $decompressed_file .= bzread($bz, 4096);
  }
  bzclose($bz);

  echo "The contents of /tmp/foo.bz2 are: <br />\n";
  echo $decompressed_file;

  ?> 
See also bzwrite(), feof(), and bzopen().   bzopenUpbzwrite
bzwrite
(4.0.4 - 4.3.2 only)
bzwrite -- Binary safe bzip2 file write
Description
int bzwrite ( resource bz, string data [, int length])
bzwrite() writes the contents of the string data to the bzip2 file stream 
pointed to by bz. If the optional length argument is given, writing will 
stop after length (uncompressed) bytes have been written or the end of 
string is reached, whichever comes first. 
Example 1. bzwrite() Example
  <?php
  $str = "uncompressed data";
  $bz = bzopen("/tmp/foo.bz2", "w");
  bzwrite($bz, $str, strlen($str));
  bzclose($bz);
  ?> 
See also bzread() and bzopen().   bzreadUpCalendar functions
#

#T=string bindtextdomain ( string domain, string directory)
bindtextdomain ( ^!string domain, string directory);
#

#T=cal_days_in_month - int cal_days_in_month ( int calendar, int month, int year)
(PHP 4 >= 4.1.0)
cal_days_in_month -- Return the number of days in a month for a given year 
and calendar
Description
int cal_days_in_month ( int calendar, int month, int year)
This function will return the number of days in the month of year for the 
specified calendar. 
Example 1. cal_days_in_month() example
  <?php
  $num = cal_days_in_month(CAL_GREGORIAN, 8, 2003); // 31
  echo "There was $num days in August 2003";
  ?> 
See also jdtounix().   Calendar functionsUpcal_from_jd
#

#T=int cal_days_in_month ( int calendar, int month, int year)
cal_days_in_month ( ^!int calendar, int month, int year);
#

#T=cal_from_jd - array cal_from_jd ( int jd, int calendar)
(PHP 4 >= 4.1.0)
cal_from_jd -- Converts from Julian Day Count to a supported calendar
Description
array cal_from_jd ( int jd, int calendar)
cal_from_jd() converts the Julian day given in jd into a date of the 
specified calendar. Supported calendar values are CAL_GREGORIAN, 
CAL_JULIAN, CAL_JEWISH and CAL_FRENCH. 
Example 1. cal_from_jd() example
  <?php
  $today = unixtojd(mktime(0, 0, 0, 8, 16, 2003));
  print_r(cal_from_jd($today, CAL_GREGORIAN));
  ?> 

This will output : 
Array
(
[date] => 8/16/2003
[month] => 8
[day] => 16
[year] => 2003
[dow] => 6
[abbrevdayname] => Sat
[dayname] => Saturday
[abbrevmonth] => Aug
[monthname] => August
)
See also cal_to_jd().   cal_days_in_monthUpcal_info
#

#T=array cal_from_jd ( int jd, int calendar)
cal_from_jd ( ^!int jd, int calendar);
#

#T=cal_info - array cal_info ( [int calendar])
(PHP 4 >= 4.1.0)
cal_info -- Returns information about a particular calendar
Description
array cal_info ( [int calendar])
cal_info() returns information on the specified calendar or on all 
supported calendars if no calendar is specified. 
Calendar information is returned as an array containing the elements 
calname, calsymbol, month, abbrevmonth and maxdaysinmonth. 
If no calendar is specified information on all supported calendars is 
returned as an array. This functionality will be available beginning with 
PHP 5.   cal_from_jdUpcal_to_jd
#

#T=array cal_info ( [int calendar])
cal_info ( ^![int calendar]);
#

#T=cal_to_jd - int cal_to_jd ( int calendar, int month, int day, int year)
(PHP 4 >= 4.1.0)
cal_to_jd -- Converts from a supported calendar to Julian Day Count
Description
int cal_to_jd ( int calendar, int month, int day, int year)
cal_to_jd() calculates the Julian day count for a date in the specified 
calendar. Supported calendars are CAL_GREGORIAN, CAL_JULIAN, CAL_JEWISH 
and CAL_FRENCH. 
See also cal_to_jd().   cal_infoUpeaster_date
#

#T=int cal_to_jd ( int calendar, int month, int day, int year)
cal_to_jd ( ^!int calendar, int month, int day, int year);
#

#T=call_user_func_array - mixed call_user_func_array ( callback function [, array param_arr])
(PHP 4 >= 4.0.4)
call_user_func_array --  Call a user function given with an array of 
parameters 
Description
mixed call_user_func_array ( callback function [, array param_arr])
Call a user defined function given by function, with the parameters in 
param_arr. For example: 
<?php
function debug($var, $val) {
echo "***DEBUGGING\nVARIABLE: $var\nVALUE:";
if (is_array($val) || is_object($val) || is_resource($val)) {
    print_r($val);
} else {
    echo "\n$val\n";
}
echo "***\n";
}

$c = mysql_connect();
$host = $_SERVER["SERVER_NAME"];

call_user_func_array('debug', array("host", $host));
call_user_func_array('debug', array("c", $c));
call_user_func_array('debug', array("_POST", $_POST));
?> 

See also: call_user_func().   Function Handling functionsUpcall_user_func
#

#T=mixed call_user_func_array ( callback function [, array param_arr])
call_user_func_array ( ^!callback function [, array param_arr]);
#

#T=call_user_func - mixed call_user_func ( callback function [, mixed parameter [, mixed 
(PHP 3>= 3.0.3, PHP 4 )
call_user_func --  Call a user function given by the first parameter 
Description
mixed call_user_func ( callback function [, mixed parameter [, mixed 
...]])
Call a user defined function given by the function parameter. Take the 
following: 
<?php
function barber($type) {
echo "You wanted a $type haircut, no problem";
}
call_user_func('barber', "mushroom");
call_user_func('barber', "shave");
?> 

Object methods may also be invoked statically using this function by 
passing array($objectname, $methodname) to the function parameter. 
<?php
class myclass {
function say_hello() {
echo "Hello!\n";
}
}

$classname = "myclass";

call_user_func(array($classname, 'say_hello'));
?> 

See also: is_callable(), and call_user_func_array()   call_user_func_arrayUpcreate_function
#

#T=mixed call_user_func ( callback function [, mixed parameter [, mixed 
call_user_func ( ^!callback function [, mixed parameter [, mixed ;
#

#T=call_user_method_array - mixed call_user_method_array ( string method_name, object obj [, array 
(PHP 4 >= 4.0.5)
call_user_method_array --  Call a user method given with an array of 
parameters [deprecated] 
Description
mixed call_user_method_array ( string method_name, object obj [, array 
paramarr])
Warning
The call_user_method_array() function is deprecated as of PHP 4.1.0, 
use the call_user_func_array() variety with the array(&$obj, 
"method_name") syntax instead. 

Calls the method referred by method_name from the user defined obj object, 
using the parameters in paramarr. 
See also: call_user_func_array(), and call_user_func().   Class/Object FunctionsUpcall_user_method
#

#T=mixed call_user_method_array ( string method_name, object obj [, array 
call_user_method_array ( ^!string method_name, object obj [, array ;
#

#T=call_user_method - mixed call_user_method ( string method_name, object obj [, mixed parameter 
(PHP 3>= 3.0.3, PHP 4 )
call_user_method --  Call a user method on an specific object [deprecated] 

Description
mixed call_user_method ( string method_name, object obj [, mixed parameter 
[, mixed ...]])
Warning
The call_user_method() function is deprecated as of PHP 4.1.0, use 
the call_user_func() variety with the array(&$obj, "method_name") 
syntax instead. 

Calls the method referred by method_name from the user defined obj object. 
An example of usage is below, where we define a class, instantiate an 
object and use call_user_method() to call indirectly its print_info 
method. 
<?php
class Country {
var $NAME;
var $TLD;

function Country($name, $tld) {
    $this->NAME = $name;
    $this->TLD = $tld;
}

function print_info($prestr = "") {
    echo $prestr . "Country: " . $this->NAME . "\n";
    echo $prestr . "Top Level Domain: " . $this->TLD . "\n";
}
}

$cntry = new Country("Peru", "pe");

echo "* Calling the object method directly\n";
$cntry->print_info();

echo "\n* Calling the same method indirectly\n";
call_user_method("print_info", $cntry, "\t");
?> 

See also call_user_func_array(), and call_user_func().   call_user_method_arrayUpclass_exists
ccvs_add
(4.0.2 - 4.2.3 only)
ccvs_add -- Add data to a transaction 
Description
string ccvs_add ( string session, string invoice, string argtype, string 
argval)
Warning
This function is currently not documented; only the argument list is 
available.
  CCVS API FunctionsUpccvs_auth
ccvs_auth
(4.0.2 - 4.2.3 only)
ccvs_auth --  Perform credit authorization test on a transaction 
Description
string ccvs_auth ( string session, string invoice)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_addUpccvs_command
ccvs_command
(4.0.2 - 4.2.3 only)
ccvs_command --  Performs a command which is peculiar to a single 
protocol, and thus is not available in the general CCVS API 
Description
string ccvs_command ( string session, string type, string argval)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_authUpccvs_count
ccvs_count
(4.0.2 - 4.2.3 only)
ccvs_count --  Find out how many transactions of a given type are stored 
in the system 
Description
int ccvs_count ( string session, string type)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_commandUpccvs_delete
ccvs_delete
(4.0.2 - 4.2.3 only)
ccvs_delete -- Delete a transaction
Description
string ccvs_delete ( string session, string invoice)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_countUpccvs_done
ccvs_done
(4.0.2 - 4.2.3 only)
ccvs_done -- Terminate CCVS engine and do cleanup work
Description
string ccvs_done ( string sess)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_deleteUpccvs_init
ccvs_init
(4.0.2 - 4.2.3 only)
ccvs_init -- Initialize CCVS for use
Description
string ccvs_init ( string name)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_doneUpccvs_lookup
ccvs_lookup
(4.0.2 - 4.2.3 only)
ccvs_lookup --  Look up an item of a particular type in the database # 
Description
string ccvs_lookup ( string session, string invoice, int inum)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_initUpccvs_new
ccvs_new
(4.0.2 - 4.2.3 only)
ccvs_new -- Create a new, blank transaction 
Description
string ccvs_new ( string session, string invoice)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_lookupUpccvs_report
ccvs_report
(4.0.2 - 4.2.3 only)
ccvs_report -- Return the status of the background communication process 
Description
string ccvs_report ( string session, string type)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_newUpccvs_return
ccvs_return
(4.0.2 - 4.2.3 only)
ccvs_return --  Transfer funds from the merchant to the credit card holder 

Description
string ccvs_return ( string session, string invoice)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_reportUpccvs_reverse
ccvs_reverse
(4.0.2 - 4.2.3 only)
ccvs_reverse --  Perform a full reversal on an already-processed 
authorization 
Description
string ccvs_reverse ( string session, string invoice)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_returnUpccvs_sale
ccvs_sale
(4.0.2 - 4.2.3 only)
ccvs_sale --  Transfer funds from the credit card holder to the merchant 
Description
string ccvs_sale ( string session, string invoice)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_reverseUpccvs_status
ccvs_status
(4.0.2 - 4.2.3 only)
ccvs_status -- Check the status of an invoice
Description
string ccvs_status ( string session, string invoice)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_saleUpccvs_textvalue
ccvs_textvalue
(4.0.2 - 4.2.3 only)
ccvs_textvalue -- Get text return value for previous function call
Description
string ccvs_textvalue ( string session)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_statusUpccvs_void
ccvs_void
(4.0.2 - 4.2.3 only)
ccvs_void --  Perform a full reversal on a completed transaction 
Description
string ccvs_void ( string session, string invoice)
Warning
This function is currently not documented; only the argument list is 
available.
  ccvs_textvalueUpCOM support functions for Windows
#

#T=mixed call_user_method ( string method_name, object obj [, mixed parameter 
call_user_method ( ^!string method_name, object obj [, mixed parameter ;
#

#T=ceil - float ceil ( float value)
(PHP 3, PHP 4 )
ceil -- Round fractions up
Description
float ceil ( float value)
Returns the next highest integer value by rounding up value if necessary. 
The return value of ceil() is still of type float as the value range of 
float is usually bigger than that of integer. 
Example 1. ceil() example
  <?php
  echo ceil(4.3);    // 5
  echo ceil(9.999);  // 10
  ?> 
See also floor() and round().   bindecUpcos
#

#T=float ceil ( float value)
ceil ( ^!float value);
#

#T=chdir - bool chdir ( string directory)
(PHP 3, PHP 4 )
chdir -- Change directory
Description
bool chdir ( string directory)
Changes PHP's current directory to directory. Returns TRUE on success or 
FALSE on failure. 
Example 1. chdir() example
  <?php
      
  // current directory
  echo getcwd() . "\n";
      
  chdir('public_html');
      
  // current directory
  echo getcwd() . "\n";
      
  ?> 

This example will output: 
/home/vincent
/home/vincent/public_html
Note: When safe mode is enabled, PHP checks whether the directory in 
which you are about to operate has the same UID (owner) as the script 
that is being executed.
See also getcwd().   Directory functionsUpchroot
#

#T=bool chdir ( string directory)
chdir ( ^!string directory);
#

#T=checkdate - bool checkdate ( int month, int day, int year)
(PHP 3, PHP 4 )
checkdate -- Validate a Gregorian date
Description
bool checkdate ( int month, int day, int year)
Returns TRUE if the date given is valid; otherwise returns FALSE. Checks 
the validity of the date formed by the arguments. A date is considered 
valid if: 
year is between 1 and 32767 inclusive 
month is between 1 and 12 inclusive 
Day is within the allowed number of days for the given month. Leap years 
are taken into consideration. 
See also mktime() and strtotime().   Date and Time functionsUpdate
#

#T=bool checkdate ( int month, int day, int year)
checkdate ( ^!int month, int day, int year);
#

#T=checkdnsrr - int checkdnsrr ( string host [, string type])
(PHP 3, PHP 4 )
checkdnsrr --  Check DNS records corresponding to a given Internet host 
name or IP address 
Description
int checkdnsrr ( string host [, string type])
Searches DNS for records of type type corresponding to host. Returns TRUE 
if any records are found; returns FALSE if no records were found or if an 
error occurred. 
type may be any one of: A, MX, NS, SOA, PTR, CNAME, AAAA, or ANY. The 
default is MX. 
Host may either be the IP address in dotted-quad notation or the host 
name. 
Note: AAAA type added with PHP 5.0.0 
Note: This function is not implemented on Windows platforms. Try the 
PEAR class Net_DNS. 
See also getmxrr(), gethostbyaddr(), gethostbyname(), gethostbynamel(), 
and the named(8) manual page.   Network FunctionsUpcloselog
#

#T=int checkdnsrr ( string host [, string type])
checkdnsrr ( ^!string host [, string type]);
#

#T=chgrp - bool chgrp ( string filename, mixed group)
(PHP 3, PHP 4 )
chgrp -- Changes file group
Description
bool chgrp ( string filename, mixed group)
Attempts to change the group of the file filename to group (specified by 
name or number). Only the superuser may change the group of a file 
arbitrarily; other users may change the group of a file to any group of 
which that user is a member. 
Returns TRUE on success or FALSE on failure. 
Note: This function will not work on remote files as the file to be 
examined must be accessible via the servers filesystem.
Note: When safe mode is enabled, PHP checks whether the files or 
directories you are about to operate on have the same UID (owner) as the 
script that is being executed.
See also chown() and chmod().   basenameUpchmod
#

#T=bool chgrp ( string filename, mixed group)
chgrp ( ^!string filename, mixed group);
#

#T=chmod - bool chmod ( string filename, int mode)
(PHP 3, PHP 4 )
chmod -- Changes file mode
Description
bool chmod ( string filename, int mode)
Attempts to change the mode of the file specified by filename to that 
given in mode. 
Note that mode is not automatically assumed to be an octal value, so 
strings (such as "g+w") will not work properly. To ensure the expected 
operation, you need to prefix mode with a zero (0): 
<?php
chmod("/somedir/somefile", 755);   // decimal; probably incorrect   
chmod("/somedir/somefile", "u+rwx,go+rx"); // string; incorrect      

chmod("/somedir/somefile", 0755);  // octal; correct value of mode
?> 

The mode parameter consists of three octal number components specifying 
access restrictions for the owner, the user group in which the owner is 
in, and to everybody else in this order. One component can be computed by 
adding up the needed permissions for that target user base. Number 1 means 
that you grant execute rights, number 2 means that you make the file 
writeable, number 4 means that you make the file readable. Add up these 
numbers to specify needed rights. You can also read more about modes on 
Unix systems with 'man 1 chmod' and 'man 2 chmod'. 
<?php
// Read and write for owner, nothing for everybody else
chmod("/somedir/somefile", 0600);

// Read and write for owner, read for everybody else
chmod("/somedir/somefile", 0644);

// Everything for owner, read and execute for others
chmod("/somedir/somefile", 0755);

// Everything for owner, read and execute for owner's group
chmod("/somedir/somefile", 0750);
?> 

Returns TRUE on success or FALSE on failure. 
Note: The current user is the user under which PHP runs. It is probably 
not the same user you use for normal shell or FTP access. 
Note: This function will not work on remote files as the file to be 
examined must be accessible via the servers filesystem.
Note: When safe mode is enabled, PHP checks whether the files or 
directories you are about to operate on have the same UID (owner) as the 
script that is being executed. In addition, you cannot set the SUID, 
SGID and sticky bits 
See also chown() and chgrp().   chgrpUpchown
chop
chop -- Alias of rtrim()
Description
This function is an alias of rtrim(). 
Note: chop() is different than the Perl chop() function, which removes 
the last character in the string.   bin2hexUpchr
#

#T=bool chmod ( string filename, int mode)
chmod ( ^!string filename, int mode);
#

#T=chown - bool chown ( string filename, mixed user)
(PHP 3, PHP 4 )
chown -- Changes file owner
Description
bool chown ( string filename, mixed user)
Attempts to change the owner of the file filename to user user (specified 
by name or number). Only the superuser may change the owner of a file. 
Returns TRUE on success or FALSE on failure. 
Note: This function will not work on remote files as the file to be 
examined must be accessible via the servers filesystem.
Note: When safe mode is enabled, PHP checks whether the files or 
directories you are about to operate on have the same UID (owner) as the 
script that is being executed.
See also chmod().   chmodUpclearstatcache
#

#T=bool chown ( string filename, mixed user)
chown ( ^!string filename, mixed user);
#

#T=chr - string chr ( int ascii)
(PHP 3, PHP 4 )
chr -- Return a specific character
Description
string chr ( int ascii)
Returns a one-character string containing the character specified by 
ascii. Example 1. chr() example
  <?php
  $str = "The string ends in escape: ";
  $str .= chr(27); /* add an escape character at the end of $str 
  */

  /* Often this is more useful */

  $str = sprintf("The string ends in escape: %c", 27);
  ?> 
You can find an ASCII-table over here: http://www.asciitable.com. 
This function complements ord(). See also sprintf() with a format string 
of %c.   chopUpchunk_split
#

#T=string chr ( int ascii)
chr ( ^!int ascii);
#

#T=chroot - bool chroot ( string directory)
(PHP 4 >= 4.0.5)
chroot -- Change the root directory
Description
bool chroot ( string directory)
Changes the root directory of the current process to directory. Returns 
TRUE on success or FALSE on failure. 
This function is only available if your system supports it and you're 
using the CLI, CGI or Embed SAPI. 
Note: chroot() requires root privileges.
Note: This function is not implemented on Windows platforms.  chdirUpdir
#

#T=bool chroot ( string directory)
chroot ( ^!string directory);
#

#T=chunk_split - string chunk_split ( string body [, int chunklen [, string end]])
(PHP 3>= 3.0.6, PHP 4 )
chunk_split -- Split a string into smaller chunks
Description
string chunk_split ( string body [, int chunklen [, string end]])
Can be used to split a string into smaller chunks which is useful for e.g. 
converting base64_encode output to match RFC 2045 semantics. It inserts 
end (defaults to "\r\n") every chunklen characters (defaults to 76). It 
returns the new string leaving the original string untouched. 
Example 1. chunk_split() example
  <?php
  // format $data using RFC 2045 semantics
  $new_string = chunk_split(base64_encode($data));
  ?> 
See also explode(), split(), wordwrap() and RFC 2045.   chrUpconvert_cyr_string
#

#T=string chunk_split ( string body [, int chunklen [, string end]])
chunk_split ( ^!string body [, int chunklen [, string end]]);
#

#T=class_exists - bool class_exists ( string class_name)
(PHP 4 )
class_exists -- Checks if the class has been defined
Description
bool class_exists ( string class_name)
This function returns TRUE if the class given by class_name has been 
defined, FALSE otherwise. 
See also get_declared_classes().   call_user_methodUpget_class_methods
#

#T=bool class_exists ( string class_name)
class_exists ( ^!string class_name);
#

#T=clearstatcache - void clearstatcache ( void )
(PHP 3, PHP 4 )
clearstatcache -- Clears file status cache
Description
void clearstatcache ( void )
When you use stat(), lstat(), or any of the other functions listed in the 
affected functions list (below), PHP caches the information those 
functions return in order to provide faster performance. However, in 
certain cases, you may want to clear the cached information. For instance, 
if the same file is being checked multiple times within a single script, 
and that file is in danger of being removed or changed during that 
script's operation, you may elect to clear the status cache. In these 
cases, you can use the clearstatcache() function to clear the information 
that PHP caches about a file. 
Note: This function caches information about specific filenames, so you 
only need to call clearstatcache() if you are performing multiple 
operations on the same filename and require the information about that 
particular file to not be cached. 
Affected functions include stat(), lstat(), file_exists(), is_writable(), 
is_readable(), is_executable(), is_file(), is_dir(), is_link(), 
filectime(), fileatime(), filemtime(), fileinode(), filegroup(), 
fileowner(), filesize(), filetype(), and fileperms().   chownUpcopy
#

#T=void clearstatcache ( void )
clearstatcache ( ^!void );
#

#T=closedir - void closedir ( resource dir_handle)
(PHP 3, PHP 4 )
closedir -- close directory handle
Description
void closedir ( resource dir_handle)
Closes the directory stream indicated by dir_handle. The stream must have 
previously been opened by opendir().   dirUpgetcwd
#

#T=void closedir ( resource dir_handle)
closedir ( ^!resource dir_handle);
#

#T=closelog - int closelog ( void )
(PHP 3, PHP 4 )
closelog -- Close connection to system logger
Description
int closelog ( void )
closelog() closes the descriptor being used to write to the system logger. 
The use of closelog() is optional. 
See also define_syslog_variables(), syslog() and openlog().   checkdnsrrUpdebugger_off
com_addref
(4.1.0 - 4.3.2 only)
com_addref --  Increases the components reference counter. 
Description
void com_addref ( void )
Increases the components reference counter.   VARIANTUpcom_get
#

#T=int closelog ( void )
closelog ( ^!void );
#

#T=com_get - mixed com_get ( resource com_object, string property)
(PHP 3>= 3.0.3, 4.0.5 - 4.3.2 only)
com_get --  Gets the value of a COM Component's property 
Description
mixed com_get ( resource com_object, string property)
Returns the value of the property of the COM component referenced by 
com_object. Returns FALSE on error.   com_addrefUpcom_invoke
#

#T=mixed com_get ( resource com_object, string property)
com_get ( ^!resource com_object, string property);
#

#T=com_invoke - mixed com_invoke ( resource com_object, string function_name [, mixed 
(PHP 3>= 3.0.3)
com_invoke --  Calls a COM component's method. 
Description
mixed com_invoke ( resource com_object, string function_name [, mixed 
function parameters, ...])
com_invoke() invokes a method of the COM component referenced by 
com_object. Returns FALSE on error, returns the function_name's return 
value on success.   com_getUpcom_isenum
com_isenum
(4.1.0 - 4.3.2 only)
com_isenum -- Grabs an IEnumVariant
Description
void com_isenum ( object com_module)
Warning
This function is currently not documented; only the argument list is 
available.
  com_invokeUpcom_load_typelib
com_load_typelib
(4.1.0 - 4.3.2 only)
com_load_typelib -- Loads a Typelib
Description
void com_load_typelib ( string typelib_name [, int case_insensitive])
Warning
This function is currently not documented; only the argument list is 
available.
  com_isenumUpcom_load
#

#T=mixed com_invoke ( resource com_object, string function_name [, mixed 
com_invoke ( ^!resource com_object, string function_name [, mixed ;
#

#T=com_load - string com_load ( string module_name [, string server_name [, int 
(PHP 3>= 3.0.3)
com_load --  Creates a new reference to a COM component 
Description
string com_load ( string module_name [, string server_name [, int 
codepage]])
com_load() creates a new COM component and returns a reference to it. 
Returns FALSE on failure. Possible values for codepage are: CP_ACP, 
CP_MACCP, CP_OEMCP, CP_SYMBOL, CP_THREAD_ACP, CP_UTF7, and CP_UTF8.   com_load_typelibUpcom_propget
com_propget
com_propget -- Alias of com_get()
Description
This function is an alias for com_get().   com_loadUpcom_propput
com_propput
com_propput -- Alias of com_set()
Description
This function is an alias for com_set().   com_propgetUpcom_propset
com_propset
com_propset -- Alias of com_set()
Description
This function is an alias for com_set().   com_propputUpcom_release
com_release
(4.1.0 - 4.3.2 only)
com_release --  Decreases the components reference counter. 
Description
void com_release ( void )
Decreases the components reference counter.   com_propsetUpcom_set
#

#T=string com_load ( string module_name [, string server_name [, int 
com_load ( ^!string module_name [, string server_name [, int ;
#

#T=com_set - void com_set ( resource com_object, string property, mixed value)
(PHP 3>= 3.0.3, 4.0.5 - 4.3.2 only)
com_set --  Assigns a value to a COM component's property 
Description
void com_set ( resource com_object, string property, mixed value)
Sets the value of the property of the COM component referenced by 
com_object. Returns the newly set value if succeeded, FALSE on error.   com_releaseUpClass/Object Functions
#

#T=void com_set ( resource com_object, string property, mixed value)
com_set ( ^!resource com_object, string property, mixed value);
#

#T=compact - array compact ( mixed varname [, mixed ...])
(PHP 4 )
compact --  Create array containing variables and their values 
Description
array compact ( mixed varname [, mixed ...])
compact() takes a variable number of parameters. Each parameter can be 
either a string containing the name of the variable, or an array of 
variable names. The array can contain other arrays of variable names 
inside it; compact() handles it recursively. 
For each of these, compact() looks for a variable with that name in the 
current symbol table and adds it to the output array such that the 
variable name becomes the key and the contents of the variable become the 
value for that key. In short, it does the opposite of extract(). It 
returns the output array with all the variables added to it. 
Any strings that are not set will simply be skipped. 
Example 1. compact() example
  <?php
  $city  = "San Francisco";
  $state = "CA";
  $event = "SIGGRAPH";

  $location_vars = array("city", "state");

  $result = compact("event", "nothing_here", $location_vars);
  ?> 

After this, $result will be: 
  Array
  (
      [event] => SIGGRAPH
      [city] => San Francisco
      [state] => CA
  ) 
See also extract().   asortUpcount
#

#T=array compact ( mixed varname [, mixed ...])
compact ( ^!mixed varname [, mixed ...]);
#

#T=connection_aborted - int connection_aborted ( void )
(PHP 3>= 3.0.7, PHP 4 )
connection_aborted -- Returns TRUE if client disconnected
Description
int connection_aborted ( void )
Returns TRUE if client disconnected. See the Connection Handling 
description in the Features chapter for a complete explanation. 
See also connection_status(), and ignore_user_abort().   Miscellaneous functionsUpconnection_status
#

#T=int connection_aborted ( void )
connection_aborted ( ^!void );
#

#T=connection_status - int connection_status ( void )
(PHP 3>= 3.0.7, PHP 4 )
connection_status -- Returns connection status bitfield
Description
int connection_status ( void )
Returns the connection status bitfield. See the Connection Handling 
description in the Features chapter for a complete explanation. 
See also connection_aborted(), and ignore_user_abort().   connection_abortedUpconnection_timeout
#

#T=int connection_status ( void )
connection_status ( ^!void );
#

#T=connection_timeout - bool connection_timeout ( void )
(PHP 3>= 3.0.7, PHP 4 <= 4.0.4)
connection_timeout -- Return TRUE if script timed out
Description
bool connection_timeout ( void )
Returns TRUE if script timed out. 
Deprecated
This function is deprecated, and doesn't even exist anymore as of 
4.0.5. 

See the Connection Handling description in the Features chapter for a 
complete explanation.   connection_statusUpconstant
#

#T=bool connection_timeout ( void )
connection_timeout ( ^!void );
#

#T=constant - mixed constant ( string name)
(PHP 4 >= 4.0.4)
constant -- Returns the value of a constant
Description
mixed constant ( string name)
constant() will return the value of the constant indicated by name. 
constant() is useful if you need to retrieve the value of a constant, but 
do not know it's name. i.e. It is stored in a variable or returned by a 
function. 
Example 1. constant() example
  <?php

  define("MAXSIZE", 100);

  echo MAXSIZE;
  echo constant("MAXSIZE"); // same thing as the previous line

  ?> 
See also define(), defined() and the section on Constants.   connection_timeoutUpdefine
#

#T=mixed constant ( string name)
constant ( ^!string name);
#

#T=convert_cyr_string - string convert_cyr_string ( string str, string from, string to)
(PHP 3>= 3.0.6, PHP 4 )
convert_cyr_string --  Convert from one Cyrillic character set to another 
Description
string convert_cyr_string ( string str, string from, string to)
This function returns the given string converted from one Cyrillic 
character set to another. The from and to arguments are single characters 
that represent the source and target Cyrillic character sets. The 
supported types are: 
k - koi8-r 
w - windows-1251 
i - iso8859-5 
a - x-cp866 
d - x-cp866 
m - x-mac-cyrillic   chunk_splitUpcount_chars
#

#T=string convert_cyr_string ( string str, string from, string to)
convert_cyr_string ( ^!string str, string from, string to);
#

#T=copy - bool copy ( string source, string dest)
(PHP 3, PHP 4 )
copy -- Copies file
Description
bool copy ( string source, string dest)
Makes a copy of the file source to dest. Returns TRUE on success or FALSE 
on failure. Example 1. copy() example
  <?php
  if (!copy($file, $file.'.bak')) {
      echo "failed to copy $file...<br />\n";
  }
  ?> 
Note: As of PHP 4.3.0, both source and dest may be URLs if the "fopen 
wrappers" have been enabled. See fopen() for more details. If dest is an 
URL, the copy operation may fail if the wrapper does not support 
overwriting of existing files. 
Warning
If the destination file already exists, it will be overwritten. 

See also move_uploaded_file(), rename(), and the section of the manual 
about handling file uploads.   clearstatcacheUpdelete
#

#T=bool copy ( string source, string dest)
copy ( ^!string source, string dest);
#

#T=cos - float cos ( float arg)
(PHP 3, PHP 4 )
cos -- Cosine
Description
float cos ( float arg)
cos() returns the cosine of the arg parameter. The arg parameter is in 
radians. 
Example 1. cos() example
  <?php

  echo cos(M_PI); // -1

  ?> 
See also acos(), sin(), tan() and deg2rad().   ceilUpcosh
#

#T=float cos ( float arg)
cos ( ^!float arg);
#

#T=cosh - float cosh ( float arg)
(PHP 4 >= 4.1.0)
cosh -- Hyperbolic cosine
Description
float cosh ( float arg)
Returns the hyperbolic cosine of arg, defined as (exp(arg) + exp(-arg))/2. 

See also cos(), acosh(), sin() and tan().   cosUpdecbin
#

#T=float cosh ( float arg)
cosh ( ^!float arg);
#

#T=count_chars - mixed count_chars ( string string [, int mode])
(PHP 4 )
count_chars --  Return information about characters used in a string 
Description
mixed count_chars ( string string [, int mode])
Counts the number of occurrences of every byte-value (0..255) in string 
and returns it in various ways. The optional parameter mode default to 0. 
Depending on mode count_chars() returns one of the following: 
0 - an array with the byte-value as key and the frequency of every byte 
as value. 
1 - same as 0 but only byte-values with a frequency greater than zero 
are listed. 
2 - same as 0 but only byte-values with a frequency equal to zero are 
listed. 
3 - a string containing all used byte-values is returned. 
4 - a string containing all not used byte-values is returned. 
Example 1. count_chars() example
  <?php

  $data = "Two Ts and one F.";

  $result = count_chars($data, 0);

  for ($i=0; $i < count($result); $i++) {
     if ($result[$i] != 0)
	 echo "There were $result[$i] instance(s) of \"" , 
  chr($i) , "\" in the string.\n";
  }

  ?> 

This will output : 
There were 4 instance(s) of " " in the string. 
There were 1 instance(s) of "." in the string. 
There were 1 instance(s) of "F" in the string. 
There were 2 instance(s) of "T" in the string. 
There were 1 instance(s) of "a" in the string. 
There were 1 instance(s) of "d" in the string. 
There were 1 instance(s) of "e" in the string. 
There were 2 instance(s) of "n" in the string. 
There were 2 instance(s) of "o" in the string. 
There were 1 instance(s) of "s" in the string. 
There were 1 instance(s) of "w" in the string.
See also strpos() and substr_count().   convert_cyr_stringUpcrc32
#

#T=mixed count_chars ( string string [, int mode])
count_chars ( ^!string string [, int mode]);
#

#T=count - int count ( mixed var [, int mode])
(PHP 3, PHP 4 )
count -- Count elements in a variable
Description
int count ( mixed var [, int mode])
Returns the number of elements in var, which is typically an array (since 
anything else will have one element). 
If var is not an array, 1 will be returned (exception: count(NULL) equals 
0). 
Note: The optional mode parameter is available as of PHP 4.2.0. 
If the optional mode parameter is set to COUNT_RECURSIVE (or 1), count() 
will recursively count the array. This is particularly useful for counting 
all the elements of a multidimensional array. The default value for mode 
is 0. 
Caution
count() may return 0 for a variable that isn't set, but it may also 
return 0 for a variable that has been initialized with an empty 
array. Use isset() to test if a variable is set. 

Please see the Arrays section of the manual for a detailed explanation of 
how arrays are implemented and used in PHP. 
Example 1. count() example
  <?php
  $a[0] = 1;
  $a[1] = 3;
  $a[2] = 5;
  $result = count($a);
  // $result == 3

  $b[0]  = 7;
  $b[5]  = 9;
  $b[10] = 11;
  $result = count($b);
  // $result == 3;
  ?> 

#

#T=int count ( mixed var [, int mode])
count ( ^!mixed var [, int mode]);
#

#T= - bool cpdf_add_annotation ( int pdf_document, float llx, float lly, float 
Example 2. recursive count() example (PHP >= 4.2.0) 
  <?php
  $food = array('fruits' => array('orange', 'banana', 'apple'),
		'veggie' => array('carrot', 'collard', 'pea'));

  // recursive count
  echo count($food, COUNT_RECURSIVE);  // output 8

  // normal count
  echo count($food);                  // output 2

  ?> 
Note: The sizeof() function is an alias for count(). 
See also is_array(), isset(), and strlen().   compactUpcurrent
#

#T=cpdf_add_annotation - bool cpdf_add_annotation ( int pdf_document, float llx, float lly, float 
(PHP 3>= 3.0.12, PHP 4 )
cpdf_add_annotation -- Adds annotation
Description
bool cpdf_add_annotation ( int pdf_document, float llx, float lly, float 
urx, float ury, string title, string content [, int mode])
The cpdf_add_annotation() adds a note with the lower left corner at (llx, 
lly) and the upper right corner at (urx, ury). Returns TRUE on success or 
FALSE on failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.  ClibPDF functionsUpcpdf_add_outline
#

#T=bool cpdf_add_annotation ( int pdf_document, float llx, float lly, float 
cpdf_add_annotation ( ^!int pdf_document, float llx, float lly, float ;
#

#T=cpdf_add_outline - int cpdf_add_outline ( int pdf_document, int lastoutline, int sublevel, 
(PHP 3>= 3.0.9, PHP 4 )
cpdf_add_outline -- Adds bookmark for current page
Description
int cpdf_add_outline ( int pdf_document, int lastoutline, int sublevel, 
int open, int pagenr, string text)
The cpdf_add_outline() function adds a bookmark with text text that points 
to the current page. 
Example 1. Adding a page outline
  <?php
  $cpdf = cpdf_open(0);
  cpdf_page_init($cpdf, 1, 0, 595, 842);
  cpdf_add_outline($cpdf, 0, 0, 0, 1, "Page 1");
  // ...
  // some drawing
  // ...
  cpdf_finalize($cpdf);
  Header("Content-type: application/pdf");
  cpdf_output_buffer($cpdf);
  cpdf_close($cpdf);
  ?> 

  cpdf_add_annotationUpcpdf_arc
#

#T=int cpdf_add_outline ( int pdf_document, int lastoutline, int sublevel, 
cpdf_add_outline ( ^!int pdf_document, int lastoutline, int sublevel, ;
#

#T=cpdf_arc - bool cpdf_arc ( int pdf_document, float x-coor, float y-coor, float 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_arc -- Draws an arc
Description
bool cpdf_arc ( int pdf_document, float x-coor, float y-coor, float 
radius, float start, float end [, int mode])
The cpdf_arc() function draws an arc with center at point (x-coor, y-coor) 
and radius radius, starting at angle start and ending at angle end. 
Returns TRUE on success or FALSE on failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
See also cpdf_circle().   cpdf_add_outlineUpcpdf_begin_text
#

#T=bool cpdf_arc ( int pdf_document, float x-coor, float y-coor, float 
cpdf_arc ( ^!int pdf_document, float x-coor, float y-coor, float ;
#

#T=cpdf_begin_text - bool cpdf_begin_text ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_begin_text -- Starts text section
Description
bool cpdf_begin_text ( int pdf_document)
The cpdf_begin_text() function starts a text section. Returns TRUE on 
success or FALSE on failure. The created text section must be ended with 
cpdf_end_text(). 
Example 1. Text output
  <?php
  cpdf_begin_text($pdf);
  cpdf_set_font($pdf, 16, "Helvetica", "WinAnsiEncoding");
  cpdf_text($pdf, 100, 100, "Some text");
  cpdf_end_text($pdf)
  ?> 
See also cpdf_end_text().   cpdf_arcUpcpdf_circle
#

#T=bool cpdf_begin_text ( int pdf_document)
cpdf_begin_text ( ^!int pdf_document);
#

#T=cpdf_circle - bool cpdf_circle ( int pdf_document, float x-coor, float y-coor, float 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_circle -- Draw a circle
Description
bool cpdf_circle ( int pdf_document, float x-coor, float y-coor, float 
radius [, int mode])
The cpdf_circle() function draws a circle with center at point (x-coor, 
y-coor) and radius radius. Returns TRUE on success or FALSE on failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
See also cpdf_arc().   cpdf_begin_textUpcpdf_clip
#

#T=bool cpdf_circle ( int pdf_document, float x-coor, float y-coor, float 
cpdf_circle ( ^!int pdf_document, float x-coor, float y-coor, float ;
#

#T=cpdf_clip - bool cpdf_clip ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_clip -- Clips to current path
Description
bool cpdf_clip ( int pdf_document)
The cpdf_clip() function clips all drawing to the current path. Returns 
TRUE on success or FALSE on failure.   cpdf_circleUpcpdf_close
#

#T=bool cpdf_clip ( int pdf_document)
cpdf_clip ( ^!int pdf_document);
#

#T=cpdf_close - bool cpdf_close ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_close -- Closes the pdf document
Description
bool cpdf_close ( int pdf_document)
The cpdf_close() function closes the pdf document. Returns TRUE on success 
or FALSE on failure. This should be the last function even after 
cpdf_finalize(), cpdf_output_buffer() and cpdf_save_to_file(). 
See also cpdf_open().   cpdf_clipUpcpdf_closepath_fill_stroke
#

#T=bool cpdf_close ( int pdf_document)
cpdf_close ( ^!int pdf_document);
#

#T=cpdf_closepath_fill_stroke - bool cpdf_closepath_fill_stroke ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_closepath_fill_stroke -- Close, fill and stroke current path
Description
bool cpdf_closepath_fill_stroke ( int pdf_document)
The cpdf_closepath_fill_stroke() function closes, fills the interior of 
the current path with the current fill color and draws current path. 
Returns TRUE on success or FALSE on failure. 
See also cpdf_closepath(), cpdf_stroke(), cpdf_fill(), 
cpdf_setgray_fill(), cpdf_setgray(), cpdf_setrgbcolor_fill() and 
cpdf_setrgbcolor().   cpdf_closeUpcpdf_closepath_stroke
#

#T=bool cpdf_closepath_fill_stroke ( int pdf_document)
cpdf_closepath_fill_stroke ( ^!int pdf_document);
#

#T=cpdf_closepath_stroke - bool cpdf_closepath_stroke ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_closepath_stroke -- Close path and draw line along path
Description
bool cpdf_closepath_stroke ( int pdf_document)
The cpdf_closepath_stroke() function is a combination of cpdf_closepath() 
and cpdf_stroke(). Then clears the path. Returns TRUE on success or FALSE 
on failure. 
See also cpdf_closepath() and cpdf_stroke().   cpdf_closepath_fill_strokeUpcpdf_closepath
#

#T=bool cpdf_closepath_stroke ( int pdf_document)
cpdf_closepath_stroke ( ^!int pdf_document);
#

#T=cpdf_closepath - bool cpdf_closepath ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_closepath -- Close path
Description
bool cpdf_closepath ( int pdf_document)
The cpdf_closepath() function closes the current path. Returns TRUE on 
success or FALSE on failure.   cpdf_closepath_strokeUpcpdf_continue_text
#

#T=bool cpdf_closepath ( int pdf_document)
cpdf_closepath ( ^!int pdf_document);
#

#T=cpdf_continue_text - bool cpdf_continue_text ( int pdf_document, string text)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_continue_text -- Output text in next line
Description
bool cpdf_continue_text ( int pdf_document, string text)
The cpdf_continue_text() function outputs the string in text in the next 
line. Returns TRUE on success or FALSE on failure. 
See also cpdf_show_xy(), cpdf_text(), cpdf_set_leading() and 
cpdf_set_text_pos().   cpdf_closepathUpcpdf_curveto
#

#T=bool cpdf_continue_text ( int pdf_document, string text)
cpdf_continue_text ( ^!int pdf_document, string text);
#

#T=cpdf_curveto - bool cpdf_curveto ( int pdf_document, float x1, float y1, float x2, float 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_curveto -- Draws a curve
Description
bool cpdf_curveto ( int pdf_document, float x1, float y1, float x2, float 
y2, float x3, float y3 [, int mode])
The cpdf_curveto() function draws a Bezier curve from the current point to 
the point (x3, y3) using (x1, y1) and (x2, y2) as control points. Returns 
TRUE on success or FALSE on failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
See also cpdf_moveto(), cpdf_rmoveto(), cpdf_rlineto() and cpdf_lineto().   cpdf_continue_textUpcpdf_end_text
#

#T=bool cpdf_curveto ( int pdf_document, float x1, float y1, float x2, float 
cpdf_curveto ( ^!int pdf_document, float x1, float y1, float x2, float ;
#

#T=cpdf_end_text - bool cpdf_end_text ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_end_text -- Ends text section
Description
bool cpdf_end_text ( int pdf_document)
The cpdf_end_text() function ends a text section which was started with 
cpdf_begin_text(). Returns TRUE on success or FALSE on failure. 
Example 1. Text output
  <?php
  cpdf_begin_text($pdf);
  cpdf_set_font($pdf, 16, "Helvetica", "WinAnsiEncoding");
  cpdf_text($pdf, 100, 100, "Some text");
  cpdf_end_text($pdf)
  ?> 
See also cpdf_begin_text().   cpdf_curvetoUpcpdf_fill_stroke
#

#T=bool cpdf_end_text ( int pdf_document)
cpdf_end_text ( ^!int pdf_document);
#

#T=cpdf_fill_stroke - bool cpdf_fill_stroke ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_fill_stroke -- Fill and stroke current path
Description
bool cpdf_fill_stroke ( int pdf_document)
The cpdf_fill_stroke() function fills the interior of the current path 
with the current fill color and draws current path. Returns TRUE on 
success or FALSE on failure. 
See also cpdf_closepath(), cpdf_stroke(), cpdf_fill(), 
cpdf_setgray_fill(), cpdf_setgray(), cpdf_setrgbcolor_fill() and 
cpdf_setrgbcolor().   cpdf_end_textUpcpdf_fill
#

#T=bool cpdf_fill_stroke ( int pdf_document)
cpdf_fill_stroke ( ^!int pdf_document);
#

#T=cpdf_fill - bool cpdf_fill ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_fill -- Fill current path
Description
bool cpdf_fill ( int pdf_document)
The cpdf_fill() function fills the interior of the current path with the 
current fill color. Returns TRUE on success or FALSE on failure. 
See also cpdf_closepath(), cpdf_stroke(), cpdf_setgray_fill(), 
cpdf_setgray(), cpdf_setrgbcolor_fill() and cpdf_setrgbcolor().   cpdf_fill_strokeUpcpdf_finalize_page
#

#T=bool cpdf_fill ( int pdf_document)
cpdf_fill ( ^!int pdf_document);
#

#T=cpdf_finalize_page - bool cpdf_finalize_page ( int pdf_document, int page_number)
(PHP 3>= 3.0.10, PHP 4 )
cpdf_finalize_page -- Ends page
Description
bool cpdf_finalize_page ( int pdf_document, int page_number)
The cpdf_finalize_page() function ends the page with page number 
page_number. Returns TRUE on success or FALSE on failure. 
This function is only for saving memory. A finalized page takes less 
memory but cannot be modified anymore. 
See also cpdf_page_init().   cpdf_fillUpcpdf_finalize
#

#T=bool cpdf_finalize_page ( int pdf_document, int page_number)
cpdf_finalize_page ( ^!int pdf_document, int page_number);
#

#T=cpdf_finalize - bool cpdf_finalize ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_finalize -- Ends document
Description
bool cpdf_finalize ( int pdf_document)
The cpdf_finalize() function ends the document. You still have to call 
cpdf_close(). Returns TRUE on success or FALSE on failure. 
See also cpdf_close().   cpdf_finalize_pageUpcpdf_global_set_document_limits
#

#T=bool cpdf_finalize ( int pdf_document)
cpdf_finalize ( ^!int pdf_document);
#

#T=cpdf_global_set_document_limits - bool cpdf_global_set_document_limits ( int maxpages, int maxfonts, int 
(PHP 4 )
cpdf_global_set_document_limits -- Sets document limits for any pdf 
document
Description
bool cpdf_global_set_document_limits ( int maxpages, int maxfonts, int 
maximages, int maxannotations, int maxobjects)
The cpdf_global_set_document_limits() function sets several document 
limits. This function has to be called before cpdf_open() to take effect. 
It sets the limits for any document open afterwards. Returns TRUE on 
success or FALSE on failure. 
See also cpdf_open().   cpdf_finalizeUpcpdf_import_jpeg
#

#T=bool cpdf_global_set_document_limits ( int maxpages, int maxfonts, int 
cpdf_global_set_document_limits ( ^!int maxpages, int maxfonts, int ;
#

#T=cpdf_import_jpeg - int cpdf_import_jpeg ( int pdf_document, string file_name, float x-coor, 
(PHP 3>= 3.0.9, PHP 4 )
cpdf_import_jpeg -- Opens a JPEG image
Description
int cpdf_import_jpeg ( int pdf_document, string file_name, float x-coor, 
float y-coor, float angle, float width, float height, float x-scale, float 
y-scale, int gsave [, int mode])
The cpdf_import_jpeg() function opens an image stored in the file with the 
name file name. The format of the image has to be jpeg. The image is 
placed on the current page at position (x-coor, y-coor). The image is 
rotated by angle degrees. gsave should be non-zero to allow this function 
to operate correctly. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
See also cpdf_place_inline_image().   cpdf_global_set_document_limitsUpcpdf_lineto
#

#T=int cpdf_import_jpeg ( int pdf_document, string file_name, float x-coor, 
cpdf_import_jpeg ( ^!int pdf_document, string file_name, float x-coor, ;
#

#T=cpdf_lineto - bool cpdf_lineto ( int pdf_document, float x-coor, float y-coor [, int 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_lineto -- Draws a line
Description
bool cpdf_lineto ( int pdf_document, float x-coor, float y-coor [, int 
mode])
The cpdf_lineto() function draws a line from the current point to the 
point with coordinates (x-coor, y-coor). Returns TRUE on success or FALSE 
on failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
See also cpdf_moveto(), cpdf_rmoveto() and cpdf_curveto().   cpdf_import_jpegUpcpdf_moveto
#

#T=bool cpdf_lineto ( int pdf_document, float x-coor, float y-coor [, int 
cpdf_lineto ( ^!int pdf_document, float x-coor, float y-coor [, int ;
#

#T=cpdf_moveto - bool cpdf_moveto ( int pdf_document, float x-coor, float y-coor [, int 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_moveto -- Sets current point
Description
bool cpdf_moveto ( int pdf_document, float x-coor, float y-coor [, int 
mode])
The cpdf_moveto() function set the current point to the coordinates x-coor 
and y-coor. Returns TRUE on success or FALSE on failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.  cpdf_linetoUpcpdf_newpath
#

#T=bool cpdf_moveto ( int pdf_document, float x-coor, float y-coor [, int 
cpdf_moveto ( ^!int pdf_document, float x-coor, float y-coor [, int ;
#

#T=cpdf_newpath - bool cpdf_newpath ( int pdf_document)
(PHP 3>= 3.0.9, PHP 4 )
cpdf_newpath -- Starts a new path
Description
bool cpdf_newpath ( int pdf_document)
The cpdf_newpath() starts a new path on the document given by the 
pdf_document parameter. Returns TRUE on success or FALSE on failure.   cpdf_movetoUpcpdf_open
#

#T=bool cpdf_newpath ( int pdf_document)
cpdf_newpath ( ^!int pdf_document);
#

#T=cpdf_open - int cpdf_open ( int compression [, string filename])
(PHP 3>= 3.0.8, PHP 4 )
cpdf_open -- Opens a new pdf document
Description
int cpdf_open ( int compression [, string filename])
The cpdf_open() function opens a new pdf document. The first parameter 
turns document compression on if it is unequal to 0. The second optional 
parameter sets the file in which the document is written. If it is omitted 
the document is created in memory and can either be written into a file 
with the cpdf_save_to_file() or written to standard output with 
cpdf_output_buffer(). 
Note: The return value will be needed in further versions of ClibPDF as 
the first parameter in all other functions which are writing to the pdf 
document. 
The ClibPDF library takes the filename "-" as a synonym for stdout. If 
PHP is compiled as an apache module this will not work because the way 
ClibPDF outputs to stdout does not work with apache. You can solve this 
problem by skipping the filename and using cpdf_output_buffer() to 
output the pdf document. 
See also cpdf_close() and cpdf_output_buffer().   cpdf_newpathUpcpdf_output_buffer
#

#T=int cpdf_open ( int compression [, string filename])
cpdf_open ( ^!int compression [, string filename]);
#

#T=cpdf_output_buffer - bool cpdf_output_buffer ( int pdf_document)
(PHP 3>= 3.0.9, PHP 4 )
cpdf_output_buffer -- Outputs the pdf document in memory buffer
Description
bool cpdf_output_buffer ( int pdf_document)
The cpdf_output_buffer() function outputs the pdf document to stdout. The 
document has to be created in memory which is the case if cpdf_open() has 
been called with no filename parameter. Returns TRUE on success or FALSE 
on failure. 
See also cpdf_open().   cpdf_openUpcpdf_page_init
#

#T=bool cpdf_output_buffer ( int pdf_document)
cpdf_output_buffer ( ^!int pdf_document);
#

#T=cpdf_page_init - bool cpdf_page_init ( int pdf_document, int page_number, int orientation, 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_page_init -- Starts new page
Description
bool cpdf_page_init ( int pdf_document, int page_number, int orientation, 
float height, float width [, float unit])
The cpdf_page_init() function starts a new page with height height and 
width width. Returns TRUE on success or FALSE on failure. The page has 
number page_number and orientation orientation. orientation can be 0 for 
portrait and 1 for landscape. The last optional parameter unit sets the 
unit for the coordinate system. The value should be the number of 
postscript points per unit. Since one inch is equal to 72 points, a value 
of 72 would set the unit to one inch. The default is also 72. 
See also cpdf_set_current_page().   cpdf_output_bufferUpcpdf_place_inline_image
#

#T=bool cpdf_page_init ( int pdf_document, int page_number, int orientation, 
cpdf_page_init ( ^!int pdf_document, int page_number, int orientation, ;
#

#T=cpdf_place_inline_image - bool cpdf_place_inline_image ( int pdf_document, int image, float x-coor, 
(PHP 3>= 3.0.9, PHP 4 )
cpdf_place_inline_image -- Places an image on the page
Description
bool cpdf_place_inline_image ( int pdf_document, int image, float x-coor, 
float y-coor, float angle, float width, float height [, int mode])
The cpdf_place_inline_image() function places an image created with the 
PHP image functions on the page at position (x-coor, y-coor). The image 
can be scaled at the same time. Returns TRUE on success or FALSE on 
failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
See also cpdf_import_jpeg().   cpdf_page_initUpcpdf_rect
#

#T=bool cpdf_place_inline_image ( int pdf_document, int image, float x-coor, 
cpdf_place_inline_image ( ^!int pdf_document, int image, float x-coor, ;
#

#T=cpdf_rect - bool cpdf_rect ( int pdf_document, float x-coor, float y-coor, float 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_rect -- Draw a rectangle
Description
bool cpdf_rect ( int pdf_document, float x-coor, float y-coor, float 
width, float height [, int mode])
The cpdf_rect() function draws a rectangle with its lower left corner at 
point (x-coor, y-coor). This width is set to width. This height is set to 
height. Returns TRUE on success or FALSE on failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
Example 1. Drawing a rectangle
  <?php

  $cpdf = cpdf_open(0);
  cpdf_page_init($cpdf, 1, 0, 595, 842, 1.0);

  // set the fill color to red
  cpdf_setrgbcolor($cpdf, 1, 0, 0);

  // draw a (180 * 100) rectangle
  cpdf_rect($cpdf, 645, 400, 180, 100);

  // fill the rectangle
  cpdf_fill($cpdf);

  cpdf_finalize($cpdf);
  Header("Content-type: application/pdf");
  cpdf_output_buffer($cpdf);
  cpdf_close($cpdf);

  ?> 

  cpdf_place_inline_imageUpcpdf_restore
#

#T=bool cpdf_rect ( int pdf_document, float x-coor, float y-coor, float 
cpdf_rect ( ^!int pdf_document, float x-coor, float y-coor, float ;
#

#T=cpdf_restore - bool cpdf_restore ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_restore -- Restores formerly saved environment
Description
bool cpdf_restore ( int pdf_document)
The cpdf_restore() function restores the environment saved with 
cpdf_save(). It works like the postscript command grestore. Very useful if 
you want to translate or rotate an object without effecting other objects. 
Returns TRUE on success or FALSE on failure. 
Example 1. Save/Restore
  <?php
  cpdf_save($pdf);
  // do all kinds of rotations, transformations, ...
  cpdf_restore($pdf)
  ?> 
See also cpdf_save().   cpdf_rectUpcpdf_rlineto
#

#T=bool cpdf_restore ( int pdf_document)
cpdf_restore ( ^!int pdf_document);
#

#T=cpdf_rlineto - bool cpdf_rlineto ( int pdf_document, float x-coor, float y-coor [, int 
(PHP 3>= 3.0.9, PHP 4 )
cpdf_rlineto -- Draws a line
Description
bool cpdf_rlineto ( int pdf_document, float x-coor, float y-coor [, int 
mode])
The cpdf_rlineto() function draws a line from the current point to the 
relative point with coordinates (x-coor, y-coor). Returns TRUE on success 
or FALSE on failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
See also cpdf_moveto(), cpdf_rmoveto() and cpdf_curveto().   cpdf_restoreUpcpdf_rmoveto
#

#T=bool cpdf_rlineto ( int pdf_document, float x-coor, float y-coor [, int 
cpdf_rlineto ( ^!int pdf_document, float x-coor, float y-coor [, int ;
#

#T=cpdf_rmoveto - bool cpdf_rmoveto ( int pdf_document, float x-coor, float y-coor [, int 
(PHP 3>= 3.0.9, PHP 4 )
cpdf_rmoveto -- Sets current point
Description
bool cpdf_rmoveto ( int pdf_document, float x-coor, float y-coor [, int 
mode])
The cpdf_rmoveto() function set the current point relative to the 
coordinates x-coor and y-coor. Returns TRUE on success or FALSE on 
failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
See also cpdf_moveto().   cpdf_rlinetoUpcpdf_rotate_text
#

#T=bool cpdf_rmoveto ( int pdf_document, float x-coor, float y-coor [, int 
cpdf_rmoveto ( ^!int pdf_document, float x-coor, float y-coor [, int ;
#

#T=cpdf_rotate_text - bool cpdf_rotate_text ( int pdfdoc, float angle)
(PHP 3>= 3.0.9, PHP 4 )
cpdf_rotate_text --  Sets text rotation angle 
Description
bool cpdf_rotate_text ( int pdfdoc, float angle)
Warning
This function is currently not documented; only the argument list is 
available.
  cpdf_rmovetoUpcpdf_rotate
#

#T=bool cpdf_rotate_text ( int pdfdoc, float angle)
cpdf_rotate_text ( ^!int pdfdoc, float angle);
#

#T=cpdf_rotate - bool cpdf_rotate ( int pdf_document, float angle)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_rotate -- Sets rotation
Description
bool cpdf_rotate ( int pdf_document, float angle)
The cpdf_rotate() function set the rotation in degrees to angle. Returns 
TRUE on success or FALSE on failure.   cpdf_rotate_textUpcpdf_save_to_file
#

#T=bool cpdf_rotate ( int pdf_document, float angle)
cpdf_rotate ( ^!int pdf_document, float angle);
#

#T=cpdf_save_to_file - bool cpdf_save_to_file ( int pdf_document, string filename)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_save_to_file -- Writes the pdf document into a file
Description
bool cpdf_save_to_file ( int pdf_document, string filename)
The cpdf_save_to_file() function outputs the pdf document into a file if 
it has been created in memory. Returns TRUE on success or FALSE on 
failure. 
This function is not needed if the pdf document has been open by 
specifying a filename as a parameter of cpdf_open(). 
See also cpdf_output_buffer() and cpdf_open().   cpdf_rotateUpcpdf_save
#

#T=bool cpdf_save_to_file ( int pdf_document, string filename)
cpdf_save_to_file ( ^!int pdf_document, string filename);
#

#T=cpdf_save - bool cpdf_save ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_save -- Saves current environment
Description
bool cpdf_save ( int pdf_document)
The cpdf_save() function saves the current environment. It works like the 
postscript command gsave. Very useful if you want to translate or rotate 
an object without effecting other objects. Returns TRUE on success or 
FALSE on failure. 
See also cpdf_restore().   cpdf_save_to_fileUpcpdf_scale
#

#T=bool cpdf_save ( int pdf_document)
cpdf_save ( ^!int pdf_document);
#

#T=cpdf_scale - bool cpdf_scale ( int pdf_document, float x-scale, float y-scale)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_scale -- Sets scaling
Description
bool cpdf_scale ( int pdf_document, float x-scale, float y-scale)
The cpdf_scale() function set the scaling factor in both directions. 
Returns TRUE on success or FALSE on failure.   cpdf_saveUpcpdf_set_action_url
#

#T=bool cpdf_scale ( int pdf_document, float x-scale, float y-scale)
cpdf_scale ( ^!int pdf_document, float x-scale, float y-scale);
#

#T=cpdf_set_action_url - bool cpdf_set_action_url ( int pdfdoc, float xll, float yll, float xur, 
(PHP 3>= 3.0.9, PHP 4 )
cpdf_set_action_url --  Sets hyperlink 
Description
bool cpdf_set_action_url ( int pdfdoc, float xll, float yll, float xur, 
float xur, string url [, int mode])
Warning
This function is currently not documented; only the argument list is 
available.
  cpdf_scaleUpcpdf_set_char_spacing
#

#T=bool cpdf_set_action_url ( int pdfdoc, float xll, float yll, float xur, 
cpdf_set_action_url ( ^!int pdfdoc, float xll, float yll, float xur, ;
#

#T=cpdf_set_char_spacing - bool cpdf_set_char_spacing ( int pdf_document, float space)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_char_spacing -- Sets character spacing
Description
bool cpdf_set_char_spacing ( int pdf_document, float space)
The cpdf_set_char_spacing() function sets the spacing between characters. 
Returns TRUE on success or FALSE on failure. 
See also cpdf_set_word_spacing() and cpdf_set_leading().   cpdf_set_action_urlUpcpdf_set_creator
#

#T=bool cpdf_set_char_spacing ( int pdf_document, float space)
cpdf_set_char_spacing ( ^!int pdf_document, float space);
#

#T=cpdf_set_creator - bool cpdf_set_creator ( string creator)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_creator -- Sets the creator field in the pdf document
Description
bool cpdf_set_creator ( string creator)
The cpdf_set_creator() function sets the creator of a pdf document. 
Returns TRUE on success or FALSE on failure. 
See also cpdf_set_subject(), cpdf_set_title() and cpdf_set_keywords().   cpdf_set_char_spacingUpcpdf_set_current_page
#

#T=bool cpdf_set_creator ( string creator)
cpdf_set_creator ( ^!string creator);
#

#T=cpdf_set_current_page - bool cpdf_set_current_page ( int pdf_document, int page_number)
(PHP 3>= 3.0.9, PHP 4 )
cpdf_set_current_page -- Sets current page
Description
bool cpdf_set_current_page ( int pdf_document, int page_number)
The cpdf_set_current_page() function set the page on which all operations 
are performed. One can switch between pages until a page is finished with 
cpdf_finalize_page(). Returns TRUE on success or FALSE on failure. 
See also cpdf_finalize_page().   cpdf_set_creatorUpcpdf_set_font_directories
#

#T=bool cpdf_set_current_page ( int pdf_document, int page_number)
cpdf_set_current_page ( ^!int pdf_document, int page_number);
#

#T=cpdf_set_font_directories - bool cpdf_set_font_directories ( int pdfdoc, string pfmdir, string pfbdir)
(PHP 4 >= 4.0.6)
cpdf_set_font_directories --  Sets directories to search when using 
external fonts 
Description
bool cpdf_set_font_directories ( int pdfdoc, string pfmdir, string pfbdir)
Warning
This function is currently not documented; only the argument list is 
available.
  cpdf_set_current_pageUpcpdf_set_font_map_file
#

#T=bool cpdf_set_font_directories ( int pdfdoc, string pfmdir, string pfbdir)
cpdf_set_font_directories ( ^!int pdfdoc, string pfmdir, string pfbdir);
#

#T=cpdf_set_font_map_file - bool cpdf_set_font_map_file ( int pdfdoc, string filename)
(PHP 4 >= 4.0.6)
cpdf_set_font_map_file --  Sets fontname to filename translation map when 
using external fonts 
Description
bool cpdf_set_font_map_file ( int pdfdoc, string filename)
Warning
This function is currently not documented; only the argument list is 
available.
  cpdf_set_font_directoriesUpcpdf_set_font
#

#T=bool cpdf_set_font_map_file ( int pdfdoc, string filename)
cpdf_set_font_map_file ( ^!int pdfdoc, string filename);
#

#T=cpdf_set_font - bool cpdf_set_font ( int pdf_document, string font_name, float size, 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_font -- Select the current font face and size
Description
bool cpdf_set_font ( int pdf_document, string font_name, float size, 
string encoding)
The cpdf_set_font() function sets the current font face, font size and 
encoding. Currently only the standard postscript fonts are supported. 
Returns TRUE on success or FALSE on failure. 
The last parameter encoding can take the following values: 
"MacRomanEncoding", "MacExpertEncoding", "WinAnsiEncoding", and "NULL". 
"NULL" stands for the font's built-in encoding. 
See the ClibPDF Manual for more information, especially how to support 
Asian fonts.   cpdf_set_font_map_fileUpcpdf_set_horiz_scaling
#

#T=bool cpdf_set_font ( int pdf_document, string font_name, float size, 
cpdf_set_font ( ^!int pdf_document, string font_name, float size, ;
#

#T=cpdf_set_horiz_scaling - bool cpdf_set_horiz_scaling ( int pdf_document, float scale)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_horiz_scaling -- Sets horizontal scaling of text
Description
bool cpdf_set_horiz_scaling ( int pdf_document, float scale)
The cpdf_set_horiz_scaling() function sets the horizontal scaling to scale 
percent. Returns TRUE on success or FALSE on failure.   cpdf_set_fontUpcpdf_set_keywords
#

#T=bool cpdf_set_horiz_scaling ( int pdf_document, float scale)
cpdf_set_horiz_scaling ( ^!int pdf_document, float scale);
#

#T=cpdf_set_keywords - bool cpdf_set_keywords ( string keywords)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_keywords -- Sets the keywords field of the pdf document
Description
bool cpdf_set_keywords ( string keywords)
The cpdf_set_keywords() function sets the keywords of a pdf document. 
Returns TRUE on success or FALSE on failure. 
See also cpdf_set_title(), cpdf_set_creator() and cpdf_set_subject().   cpdf_set_horiz_scalingUpcpdf_set_leading
#

#T=bool cpdf_set_keywords ( string keywords)
cpdf_set_keywords ( ^!string keywords);
#

#T=cpdf_set_leading - bool cpdf_set_leading ( int pdf_document, float distance)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_leading -- Sets distance between text lines
Description
bool cpdf_set_leading ( int pdf_document, float distance)
The cpdf_set_leading() function sets the distance between text lines. This 
will be used if text is output by cpdf_continue_text(). Returns TRUE on 
success or FALSE on failure. 
See also cpdf_continue_text().   cpdf_set_keywordsUpcpdf_set_page_animation
#

#T=bool cpdf_set_leading ( int pdf_document, float distance)
cpdf_set_leading ( ^!int pdf_document, float distance);
#

#T=cpdf_set_page_animation - bool cpdf_set_page_animation ( int pdf_document, int transition, float 
(PHP 3>= 3.0.9, PHP 4 )
cpdf_set_page_animation -- Sets duration between pages
Description
bool cpdf_set_page_animation ( int pdf_document, int transition, float 
duration)
The cpdf_set_page_animation() function set the transition between 
following pages. Returns TRUE on success or FALSE on failure. 
The value of transition can be 
0 for none,
1 for two lines sweeping across the screen reveal the page, 
2 for multiple lines sweeping across the screen reveal the page, 
3 for a box reveals the page,
4 for a single line sweeping across the screen reveals the page, 
5 for the old page dissolves to reveal the page,
6 for the dissolve effect moves from one screen edge to another, 
7 for the old page is simply replaced by the new page (default) 

The value of duration is the number of seconds between page flipping.   cpdf_set_leadingUpcpdf_set_subject
#

#T=bool cpdf_set_page_animation ( int pdf_document, int transition, float 
cpdf_set_page_animation ( ^!int pdf_document, int transition, float ;
#

#T=cpdf_set_subject - bool cpdf_set_subject ( int pdf_document, string subject)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_subject -- Sets the subject field of the pdf document
Description
bool cpdf_set_subject ( int pdf_document, string subject)
The cpdf_set_subject() function sets the subject of a pdf document. 
Returns TRUE on success or FALSE on failure. 
See also cpdf_set_title(), cpdf_set_creator() and cpdf_set_keywords().   cpdf_set_page_animationUpcpdf_set_text_matrix
#

#T=bool cpdf_set_subject ( int pdf_document, string subject)
cpdf_set_subject ( ^!int pdf_document, string subject);
#

#T=cpdf_set_text_matrix - bool cpdf_set_text_matrix ( int pdf_document, array matrix)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_text_matrix -- Sets the text matrix
Description
bool cpdf_set_text_matrix ( int pdf_document, array matrix)
The cpdf_set_text_matrix() function sets a matrix which describes a 
transformation applied on the current text font. Returns TRUE on success 
or FALSE on failure.   cpdf_set_subjectUpcpdf_set_text_pos
#

#T=bool cpdf_set_text_matrix ( int pdf_document, array matrix)
cpdf_set_text_matrix ( ^!int pdf_document, array matrix);
#

#T=cpdf_set_text_pos - bool cpdf_set_text_pos ( int pdf_document, float x-coor, float y-coor [, 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_text_pos -- Sets text position
Description
bool cpdf_set_text_pos ( int pdf_document, float x-coor, float y-coor [, 
int mode])
The cpdf_set_text_pos() function sets the position of text for the next 
cpdf_show() function call. Returns TRUE on success or FALSE on failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
See also cpdf_show() and cpdf_text().   cpdf_set_text_matrixUpcpdf_set_text_rendering
#

#T=bool cpdf_set_text_pos ( int pdf_document, float x-coor, float y-coor [, 
cpdf_set_text_pos ( ^!int pdf_document, float x-coor, float y-coor [, ;
#

#T=cpdf_set_text_rendering - bool cpdf_set_text_rendering ( int pdf_document, int rendermode)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_text_rendering -- Determines how text is rendered
Description
bool cpdf_set_text_rendering ( int pdf_document, int rendermode)
The cpdf_set_text_rendering() function determines how text is rendered. 
Returns TRUE on success or FALSE on failure. 
The possible values for rendermode are 0=fill text, 1=stroke text, 2=fill 
and stroke text, 3=invisible, 4=fill text and add it to clipping path, 
5=stroke text and add it to clipping path, 6=fill and stroke text and add 
it to clipping path, 7=add it to clipping path.   cpdf_set_text_posUpcpdf_set_text_rise
#

#T=bool cpdf_set_text_rendering ( int pdf_document, int rendermode)
cpdf_set_text_rendering ( ^!int pdf_document, int rendermode);
#

#T=cpdf_set_text_rise - bool cpdf_set_text_rise ( int pdf_document, float value)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_text_rise -- Sets the text rise
Description
bool cpdf_set_text_rise ( int pdf_document, float value)
The cpdf_set_text_rise() function sets the text rising to value units. 
Returns TRUE on success or FALSE on failure.   cpdf_set_text_renderingUpcpdf_set_title
#

#T=bool cpdf_set_text_rise ( int pdf_document, float value)
cpdf_set_text_rise ( ^!int pdf_document, float value);
#

#T=cpdf_set_title - bool cpdf_set_title ( string title)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_title -- Sets the title field of the pdf document
Description
bool cpdf_set_title ( string title)
The cpdf_set_title() function sets the title of a pdf document. Returns 
TRUE on success or FALSE on failure. 
See also cpdf_set_subject(), cpdf_set_creator() and cpdf_set_keywords().   cpdf_set_text_riseUpcpdf_set_viewer_preferences
#

#T=bool cpdf_set_title ( string title)
cpdf_set_title ( ^!string title);
#

#T=cpdf_set_viewer_preferences - bool cpdf_set_viewer_preferences ( int pdfdoc, array preferences)
(PHP 3>= 3.0.9, PHP 4 )
cpdf_set_viewer_preferences --  How to show the document in the viewer 
Description
bool cpdf_set_viewer_preferences ( int pdfdoc, array preferences)
Warning
This function is currently not documented; only the argument list is 
available.
  cpdf_set_titleUpcpdf_set_word_spacing
#

#T=bool cpdf_set_viewer_preferences ( int pdfdoc, array preferences)
cpdf_set_viewer_preferences ( ^!int pdfdoc, array preferences);
#

#T=cpdf_set_word_spacing - bool cpdf_set_word_spacing ( int pdf_document, float space)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_set_word_spacing -- Sets spacing between words
Description
bool cpdf_set_word_spacing ( int pdf_document, float space)
The cpdf_set_word_spacing() function sets the spacing between words. 
Returns TRUE on success or FALSE on failure. 
See also cpdf_set_char_spacing() and cpdf_set_leading().   cpdf_set_viewer_preferencesUpcpdf_setdash
#

#T=bool cpdf_set_word_spacing ( int pdf_document, float space)
cpdf_set_word_spacing ( ^!int pdf_document, float space);
#

#T=cpdf_setdash - bool cpdf_setdash ( int pdf_document, float white, float black)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setdash -- Sets dash pattern
Description
bool cpdf_setdash ( int pdf_document, float white, float black)
The cpdf_setdash() function set the dash pattern white white units and 
black black units. If both are 0 a solid line is set. Returns TRUE on 
success or FALSE on failure.   cpdf_set_word_spacingUpcpdf_setflat
#

#T=bool cpdf_setdash ( int pdf_document, float white, float black)
cpdf_setdash ( ^!int pdf_document, float white, float black);
#

#T=cpdf_setflat - bool cpdf_setflat ( int pdf_document, float value)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setflat -- Sets flatness
Description
bool cpdf_setflat ( int pdf_document, float value)
The cpdf_setflat() function set the flatness to a value between 0 and 100. 
Returns TRUE on success or FALSE on failure.   cpdf_setdashUpcpdf_setgray_fill
#

#T=bool cpdf_setflat ( int pdf_document, float value)
cpdf_setflat ( ^!int pdf_document, float value);
#

#T=cpdf_setgray_fill - bool cpdf_setgray_fill ( int pdf_document, float value)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setgray_fill -- Sets filling color to gray value
Description
bool cpdf_setgray_fill ( int pdf_document, float value)
The cpdf_setgray_fill() function sets the current gray value to fill a 
path. Returns TRUE on success or FALSE on failure. 
See also cpdf_setrgbcolor_fill().   cpdf_setflatUpcpdf_setgray_stroke
#

#T=bool cpdf_setgray_fill ( int pdf_document, float value)
cpdf_setgray_fill ( ^!int pdf_document, float value);
#

#T=cpdf_setgray_stroke - bool cpdf_setgray_stroke ( int pdf_document, float gray_value)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setgray_stroke -- Sets drawing color to gray value
Description
bool cpdf_setgray_stroke ( int pdf_document, float gray_value)
The cpdf_setgray_stroke() function sets the current drawing color to the 
given gray value. Returns TRUE on success or FALSE on failure. 
See also cpdf_setrgbcolor_stroke().   cpdf_setgray_fillUpcpdf_setgray
#

#T=bool cpdf_setgray_stroke ( int pdf_document, float gray_value)
cpdf_setgray_stroke ( ^!int pdf_document, float gray_value);
#

#T=cpdf_setgray - bool cpdf_setgray ( int pdf_document, float gray_value)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setgray -- Sets drawing and filling color to gray value
Description
bool cpdf_setgray ( int pdf_document, float gray_value)
The cpdf_setgray() function sets the current drawing and filling color to 
the given gray value. Returns TRUE on success or FALSE on failure. 
See also cpdf_setrgbcolor_stroke() and cpdf_setrgbcolor_fill().   cpdf_setgray_strokeUpcpdf_setlinecap
#

#T=bool cpdf_setgray ( int pdf_document, float gray_value)
cpdf_setgray ( ^!int pdf_document, float gray_value);
#

#T=cpdf_setlinecap - bool cpdf_setlinecap ( int pdf_document, int value)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setlinecap -- Sets linecap parameter
Description
bool cpdf_setlinecap ( int pdf_document, int value)
The cpdf_setlinecap() function set the linecap parameter between a value 
of 0 and 2. 0 = butt end, 1 = round, 2 = projecting square. Returns TRUE 
on success or FALSE on failure.   cpdf_setgrayUpcpdf_setlinejoin
#

#T=bool cpdf_setlinecap ( int pdf_document, int value)
cpdf_setlinecap ( ^!int pdf_document, int value);
#

#T=cpdf_setlinejoin - bool cpdf_setlinejoin ( int pdf_document, int value)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setlinejoin -- Sets linejoin parameter
Description
bool cpdf_setlinejoin ( int pdf_document, int value)
The cpdf_setlinejoin() function set the linejoin parameter between a value 
of 0 and 2. 0 = miter, 1 = round, 2 = bevel. Returns TRUE on success or 
FALSE on failure.   cpdf_setlinecapUpcpdf_setlinewidth
#

#T=bool cpdf_setlinejoin ( int pdf_document, int value)
cpdf_setlinejoin ( ^!int pdf_document, int value);
#

#T=cpdf_setlinewidth - bool cpdf_setlinewidth ( int pdf_document, float width)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setlinewidth -- Sets line width
Description
bool cpdf_setlinewidth ( int pdf_document, float width)
The cpdf_setlinewidth() function set the line width to width. Returns TRUE 
on success or FALSE on failure.   cpdf_setlinejoinUpcpdf_setmiterlimit
#

#T=bool cpdf_setlinewidth ( int pdf_document, float width)
cpdf_setlinewidth ( ^!int pdf_document, float width);
#

#T=cpdf_setmiterlimit - bool cpdf_setmiterlimit ( int pdf_document, float value)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setmiterlimit -- Sets miter limit
Description
bool cpdf_setmiterlimit ( int pdf_document, float value)
The cpdf_setmiterlimit() function set the miter limit to a value greater 
or equal than 1. Returns TRUE on success or FALSE on failure.   cpdf_setlinewidthUpcpdf_setrgbcolor_fill
#

#T=bool cpdf_setmiterlimit ( int pdf_document, float value)
cpdf_setmiterlimit ( ^!int pdf_document, float value);
#

#T=cpdf_setrgbcolor_fill - bool cpdf_setrgbcolor_fill ( int pdf_document, float red_value, float 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setrgbcolor_fill -- Sets filling color to rgb color value
Description
bool cpdf_setrgbcolor_fill ( int pdf_document, float red_value, float 
green_value, float blue_value)
The cpdf_setrgbcolor_fill() function sets the current rgb color value to 
fill a path. Returns TRUE on success or FALSE on failure. 
Note: The values are expected to be floating point values between 0.0 
and 1.0. (i.e black is (0.0, 0.0, 0.0) and white is (1.0, 1.0, 1.0)). 
See also cpdf_setrgbcolor_stroke() and cpdf_setrgbcolor().   cpdf_setmiterlimitUpcpdf_setrgbcolor_stroke
#

#T=bool cpdf_setrgbcolor_fill ( int pdf_document, float red_value, float 
cpdf_setrgbcolor_fill ( ^!int pdf_document, float red_value, float ;
#

#T=cpdf_setrgbcolor_stroke - bool cpdf_setrgbcolor_stroke ( int pdf_document, float red_value, float 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setrgbcolor_stroke -- Sets drawing color to rgb color value
Description
bool cpdf_setrgbcolor_stroke ( int pdf_document, float red_value, float 
green_value, float blue_value)
The cpdf_setrgbcolor_stroke() function sets the current drawing color to 
the given rgb color value. Returns TRUE on success or FALSE on failure. 
Note: The values are expected to be floating point values between 0.0 
and 1.0. (i.e black is (0.0, 0.0, 0.0) and white is (1.0, 1.0, 1.0)). 
See also cpdf_setrgbcolor_fill() and cpdf_setrgbcolor().   cpdf_setrgbcolor_fillUpcpdf_setrgbcolor
#

#T=bool cpdf_setrgbcolor_stroke ( int pdf_document, float red_value, float 
cpdf_setrgbcolor_stroke ( ^!int pdf_document, float red_value, float ;
#

#T=cpdf_setrgbcolor - bool cpdf_setrgbcolor ( int pdf_document, float red_value, float 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_setrgbcolor -- Sets drawing and filling color to rgb color value
Description
bool cpdf_setrgbcolor ( int pdf_document, float red_value, float 
green_value, float blue_value)
The cpdf_setrgbcolor() function sets the current drawing and filling color 
to the given rgb color value. Returns TRUE on success or FALSE on failure. 

Note: The values are expected to be floating point values between 0.0 
and 1.0. (i.e black is (0.0, 0.0, 0.0) and white is (1.0, 1.0, 1.0)). 
See also cpdf_setrgbcolor_stroke() and cpdf_setrgbcolor_fill().   cpdf_setrgbcolor_strokeUpcpdf_show_xy
#

#T=bool cpdf_setrgbcolor ( int pdf_document, float red_value, float 
cpdf_setrgbcolor ( ^!int pdf_document, float red_value, float ;
#

#T=cpdf_show_xy - bool cpdf_show_xy ( int pdf_document, string text, float x-coor, float 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_show_xy -- Output text at position
Description
bool cpdf_show_xy ( int pdf_document, string text, float x-coor, float 
y-coor [, int mode])
The cpdf_show_xy() function outputs the string text at position with 
coordinates (x-coor, y-coor). Returns TRUE on success or FALSE on failure. 

The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
Note: The function cpdf_show_xy() is identical to cpdf_text() without 
the optional parameters. 
See also cpdf_text().   cpdf_setrgbcolorUpcpdf_show
#

#T=bool cpdf_show_xy ( int pdf_document, string text, float x-coor, float 
cpdf_show_xy ( ^!int pdf_document, string text, float x-coor, float ;
#

#T=cpdf_show - bool cpdf_show ( int pdf_document, string text)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_show -- Output text at current position
Description
bool cpdf_show ( int pdf_document, string text)
The cpdf_show() function outputs the string in text at the current 
position. Returns TRUE on success or FALSE on failure. 
See also cpdf_text(), cpdf_begin_text() and cpdf_end_text().   cpdf_show_xyUpcpdf_stringwidth
#

#T=bool cpdf_show ( int pdf_document, string text)
cpdf_show ( ^!int pdf_document, string text);
#

#T=cpdf_stringwidth - float cpdf_stringwidth ( int pdf_document, string text)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_stringwidth -- Returns width of text in current font
Description
float cpdf_stringwidth ( int pdf_document, string text)
The cpdf_stringwidth() function returns the width of the string in text. 
It requires a font to be set before. 
See also cpdf_set_font().   cpdf_showUpcpdf_stroke
#

#T=float cpdf_stringwidth ( int pdf_document, string text)
cpdf_stringwidth ( ^!int pdf_document, string text);
#

#T=cpdf_stroke - bool cpdf_stroke ( int pdf_document)
(PHP 3>= 3.0.8, PHP 4 )
cpdf_stroke -- Draw line along path
Description
bool cpdf_stroke ( int pdf_document)
The cpdf_stroke() function draws a line along current path. Returns TRUE 
on success or FALSE on failure. 
See also cpdf_closepath() and cpdf_closepath_stroke().   cpdf_stringwidthUpcpdf_text
#

#T=bool cpdf_stroke ( int pdf_document)
cpdf_stroke ( ^!int pdf_document);
#

#T=cpdf_text - bool cpdf_text ( int pdf_document, string text, float x-coor, float y-coor 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_text -- Output text with parameters
Description
bool cpdf_text ( int pdf_document, string text, float x-coor, float y-coor 
[, int mode [, float orientation [, int alignmode]]])
The cpdf_text() function outputs the string text at position with 
coordinates (x-coor, y-coor). Returns TRUE on success or FALSE on failure. 

The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.
The optional parameter orientation is the rotation of the text in degree. 
The optional parameter alignmode determines how the text is aligned. 
See the ClibPDF documentation for possible values. 
See also cpdf_show_xy().   cpdf_strokeUpcpdf_translate
#

#T=bool cpdf_text ( int pdf_document, string text, float x-coor, float y-coor 
cpdf_text ( ^!int pdf_document, string text, float x-coor, float y-coor ;
#

#T=cpdf_translate - bool cpdf_translate ( int pdf_document, float x-coor, float y-coor [, int 
(PHP 3>= 3.0.8, PHP 4 )
cpdf_translate -- Sets origin of coordinate system
Description
bool cpdf_translate ( int pdf_document, float x-coor, float y-coor [, int 
mode])
The cpdf_translate() function set the origin of coordinate system to the 
point (x-coor, y-coor). Returns TRUE on success or FALSE on failure. 
The optional parameter mode determines the unit length. If it is 0 or 
omitted the default unit as specified for the page is used. Otherwise the 
coordinates are measured in postscript points disregarding the current 
unit.  cpdf_textUpCrack functions
#

#T=bool cpdf_translate ( int pdf_document, float x-coor, float y-coor [, int 
cpdf_translate ( ^!int pdf_document, float x-coor, float y-coor [, int ;
#

#T=crack_check - bool crack_check ( [resource dictionary, string password])
(PHP 4 >= 4.0.5)
crack_check -- Performs an obscure check with the given password
Description
bool crack_check ( [resource dictionary, string password])
Returns TRUE if password is strong, or FALSE otherwise. 
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

crack_check() performs an obscure check with the given password on the 
specified dictionary . If dictionary is not specified, the last opened 
dictionary is used.   Crack functionsUpcrack_closedict
#

#T=bool crack_check ( [resource dictionary, string password])
crack_check ( ^![resource dictionary, string password]);
#

#T=crack_closedict - bool crack_closedict ( [resource dictionary])
(PHP 4 >= 4.0.5)
crack_closedict -- Closes an open CrackLib dictionary 
Description
bool crack_closedict ( [resource dictionary])
Returns TRUE on success or FALSE on failure. 
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

crack_closedict() closes the specified dictionary identifier. If 
dictionary is not specified, the current dictionary is closed.   crack_checkUpcrack_getlastmessage
#

#T=bool crack_closedict ( [resource dictionary])
crack_closedict ( ^![resource dictionary]);
#

#T=crack_getlastmessage - string crack_getlastmessage ( void )
(PHP 4 >= 4.0.5)
crack_getlastmessage -- Returns the message from the last obscure check
Description
string crack_getlastmessage ( void )
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

crack_getlastmessage() returns the message from the last obscure check.   crack_closedictUpcrack_opendict
#

#T=string crack_getlastmessage ( void )
crack_getlastmessage ( ^!void );
#

#T=crack_opendict - resource crack_opendict ( string dictionary)
(PHP 4 >= 4.0.5)
crack_opendict -- Opens a new CrackLib dictionary
Description
resource crack_opendict ( string dictionary)
Returns a dictionary resource identifier on success, or FALSE on failure. 
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

crack_opendict() opens the specified CrackLib dictionary for use with 
crack_check(). 
Note: Only one dictionary may be open at a time. 
See also: crack_check(), and crack_closedict().   crack_getlastmessageUpCURL, Client URL Library Functions
#

#T=resource crack_opendict ( string dictionary)
crack_opendict ( ^!string dictionary);
#

#T=crc32 - int crc32 ( string str)
(PHP 4 >= 4.0.1)
crc32 -- Calculates the crc32 polynomial of a string
Description
int crc32 ( string str)
Generates the cyclic redundancy checksum polynomial of 32-bit lengths of 
the str. This is usually used to validate the integrity of data being 
transmitted. 
Because PHP's integer type is signed, and many crc32 checksums will result 
in negative integers, you need to use the "%u" formatter of sprintf() or 
printf() to get the string representation of the unsigned crc32 checksum. 
This second example shows how to print a converted checksum with the 
printf() function: Example 1. Displaying a crc32 checksum
  <?php
  $checksum = crc32("The quick brown fox jumped over the lazy 
  dog.");
  printf("%u\n", $checksum);
  ?> 
See also md5() and sha1().   count_charsUpcrypt
#

#T=int crc32 ( string str)
crc32 ( ^!string str);
#

#T=create_function - string create_function ( string args, string code)
(PHP 4 >= 4.0.1)
create_function -- Create an anonymous (lambda-style) function
Description
string create_function ( string args, string code)
Creates an anonymous function from the parameters passed, and returns a 
unique name for it. Usually the args will be passed as a single quote 
delimited string, and this is also recommended for the code. The reason 
for using single quoted strings, is to protect the variable names from 
parsing, otherwise, if you use double quotes there will be a need to 
escape the variable names, e.g. \$avar. 
You can use this function, to (for example) create a function from 
information gathered at run time: 
Example 1. Creating an anonymous function with create_function() 
  <?php
  $newfunc = create_function('$a,$b', 'return "ln($a) + ln($b) = 
  " . log($a * $b);');
  echo "New anonymous function: $newfunc\n";
  echo $newfunc(2, M_E) . "\n";
  // outputs
  // New anonymous function: lambda_1
  // ln(2) + ln(2.718281828459) = 1.6931471805599
  ?> 
Or, perhaps to have general handler function that can apply a set of 
operations to a list of parameters: 
Example 2. Making a general processing function with 
create_function() 
  <?php
  function process($var1, $var2, $farr) {
      for ($f=0; $f < count($farr); $f++)
	  echo $farr[$f]($var1, $var2) . "\n";
  }

  // create a bunch of math functions
  $f1 = 'if ($a >=0) {return "b*a^2 = ".$b*sqrt($a);} else 
  {return false;}';
  $f2 = "return \"min(b^2+a, a^2,b) = 
  \".min(\$a*\$a+\$b,\$b*\$b+\$a);";
  $f3 = 'if ($a > 0 && $b != 0) {return "ln(a)/b = ".log($a)/$b; 
  } else { return false; }';
  $farr = array(
      create_function('$x,$y', 'return "some trig: ".(sin($x) + 
  $x*cos($y));'),
      create_function('$x,$y', 'return "a hypotenuse: 
  ".sqrt($x*$x + $y*$y);'),
      create_function('$a,$b', $f1),
      create_function('$a,$b', $f2),
      create_function('$a,$b', $f3)
      );

  echo "\nUsing the first array of anonymous functions\n";
  echo "parameters: 2.3445, M_PI\n";
  process(2.3445, M_PI, $farr);

  // now make a bunch of string processing functions
  $garr = array(
      create_function('$b,$a', 'if (strncmp($a, $b, 3) == 0) 
  return "** \"$a\" '.
      'and \"$b\"\n** Look the same to me! (looking at the first 
  3 chars)";'),
      create_function('$a,$b', '; return "CRCs: " . crc32($a) . 
  " , ".crc32(b);'),
      create_function('$a,$b', '; return "similar(a,b) = " . 
  similar_text($a, $b, &$p) . "($p%)";')
      );
  echo "\nUsing the second array of anonymous functions\n";
  process("Twas brilling and the slithy toves", "Twas the 
  night", $garr);
  ?> 

and when you run the code above, the output will be: 
Using the first array of anonymous functions
parameters: 2.3445, M_PI
some trig: -1.6291725057799
a hypotenuse: 3.9199852871011
b*a^2 = 4.8103313314525
min(b^2+a, a^2,b) = 8.6382729035898
ln(a/b) = 0.27122299212594

Using the second array of anonymous functions
** "Twas the night" and "Twas brilling and the slithy toves"
** Look the same to me! (looking at the first 3 chars)
CRCs: -725381282 , 1908338681
similar(a,b) = 11(45.833333333333%)
But perhaps the most common use for of lambda-style (anonymous) functions 
is to create callback functions, for example when using array_walk() or 
usort() 
Example 3. Using anonymous functions as callback functions
  <?php
  $av = array("the ", "a ", "that ", "this ");
  array_walk($av, create_function('&$v,$k', '$v = $v . 
  "mango";'));
  print_r($av); 
  ?> 

outputs: 
Array
(
[0] => the mango
[1] => a mango
[2] => that mango
[3] => this mango
)

an array of strings ordered from shorter to longer 
  <?php

  $sv = array("small", "larger", "a big string", "it is a string 
  thing");
  print_r($sv);

  ?> 

outputs: 
Array
(
[0] => small
[1] => larger
[2] => a big string
[3] => it is a string thing
)

sort it from longer to shorter 
  <?php

  usort($sv, create_function('$a,$b','return strlen($b) - 
  strlen($a);'));
  print_r($sv);

  ?> 

outputs: 
Array
(
[0] => it is a string thing
[1] => a big string
[2] => larger
[3] => small
)

  call_user_funcUpfunc_get_arg
#

#T=string create_function ( string args, string code)
create_function ( ^!string args, string code);
#

#T=crypt - string crypt ( string str [, string salt])
(PHP 3, PHP 4 )
crypt -- One-way string encryption (hashing)
Description
string crypt ( string str [, string salt])
crypt() will return an encrypted string using the standard Unix DES-based 
encryption algorithm or alternative algorithms that may be available on 
the system. Arguments are a string to be encrypted and an optional salt 
string to base the encryption on. See the Unix man page for your crypt 
function for more information. 
If the salt argument is not provided, one will be randomly generated by 
PHP. 
Some operating systems support more than one type of encryption. In fact, 
sometimes the standard DES-based encryption is replaced by an MD5-based 
encryption algorithm. The encryption type is triggered by the salt 
argument. At install time, PHP determines the capabilities of the crypt 
function and will accept salts for other encryption types. If no salt is 
provided, PHP will auto-generate a standard two character salt by default, 
unless the default encryption type on the system is MD5, in which case a 
random MD5-compatible salt is generated. PHP sets a constant named 
CRYPT_SALT_LENGTH which tells you whether a regular two character salt 
applies to your system or the longer twelve character salt is applicable. 
If you are using the supplied salt, you should be aware that the salt is 
generated once. If you are calling this function recursively, this may 
impact both appearance and security. 
The standard DES-based encryption crypt() returns the salt as the first 
two characters of the output. It also only uses the first eight characters 
of str, so longer strings that start with the same eight characters will 
generate the same result (when the same salt is used). 
On systems where the crypt() function supports multiple encryption types, 
the following constants are set to 0 or 1 depending on whether the given 
type is available: 
CRYPT_STD_DES - Standard DES-based encryption with a two character salt 
CRYPT_EXT_DES - Extended DES-based encryption with a nine character salt 

CRYPT_MD5 - MD5 encryption with a twelve character salt starting with 
$1$ 
CRYPT_BLOWFISH - Blowfish encryption with a sixteen character salt 
starting with $2$ 
Note: There is no decrypt function, since crypt() uses a one-way 
algorithm. 
Example 1. crypt() examples
  <?php
  $password = crypt("My1sTpassword"); // let salt be generated

  # You should pass the entire results of crypt() as the salt 
  for comparing a
  # password, to avoid problems when different hashing 
  algorithms are used. (As
  # it says above, standard DES-based password hashing uses a 
  2-character salt,
  # but MD5-based hashing uses 12.)
  if (crypt($user_input, $password) == $password) {
     echo "Password verified!";
  }
  ?> 
See also md5() and the Mcrypt extension.   crc32Upecho
#

#T=string crypt ( string str [, string salt])
crypt ( ^!string str [, string salt]);
#

#T=ctype_alnum - bool ctype_alnum ( string text)
(PHP 4 >= 4.0.4)
ctype_alnum -- Check for alphanumeric character(s)
Description
bool ctype_alnum ( string text)
Returns TRUE if every character in text is either a letter or a digit, 
FALSE otherwise. In the standard C locale letters are just [A-Za-z] and 
the function is equivalent to preg_match('/^[a-z0-9]*$/i', $text). 
See also ctype_alpha(), ctype_digit(), and setlocale().   Character type functionsUpctype_alpha
#

#T=bool ctype_alnum ( string text)
ctype_alnum ( ^!string text);
#

#T=ctype_alpha - bool ctype_alpha ( string text)
(PHP 4 >= 4.0.4)
ctype_alpha -- Check for alphabetic character(s)
Description
bool ctype_alpha ( string text)
Returns TRUE if every character in text is a letter from the current 
locale, FALSE otherwise. In the standard C locale letters are just 
[A-Za-z] and ctype_alpha() is equivalent to (ctype_upper($text) || 
ctype_lower($text)) if $text is just a single character, but other 
languages have letters that are considered neither upper nor lower case. 
See also ctype_upper(), ctype_lower(), and setlocale().   ctype_alnumUpctype_cntrl
#

#T=bool ctype_alpha ( string text)
ctype_alpha ( ^!string text);
#

#T=ctype_cntrl - bool ctype_cntrl ( string text)
(PHP 4 >= 4.0.4)
ctype_cntrl -- Check for control character(s)
Description
bool ctype_cntrl ( string text)
Returns TRUE if every character in text has a special control function, 
FALSE otherwise. Control characters are e.g. line feed, tab, esc.   ctype_alphaUpctype_digit
#

#T=bool ctype_cntrl ( string text)
ctype_cntrl ( ^!string text);
#

#T=ctype_digit - bool ctype_digit ( string text)
(PHP 4 >= 4.0.4)
ctype_digit -- Check for numeric character(s)
Description
bool ctype_digit ( string text)
Returns TRUE if every character in text is a decimal digit, FALSE 
otherwise. 
See also ctype_alnum() and ctype_xdigit().   ctype_cntrlUpctype_graph
#

#T=bool ctype_digit ( string text)
ctype_digit ( ^!string text);
#

#T=ctype_graph - bool ctype_graph ( string text)
(PHP 4 >= 4.0.4)
ctype_graph -- Check for any printable character(s) except space
Description
bool ctype_graph ( string text)
Returns TRUE if every character in text is printable and actually creates 
visible output (no white space), FALSE otherwise. 
See also ctype_alnum(), ctype_print(), and ctype_punct().   ctype_digitUpctype_lower
#

#T=bool ctype_graph ( string text)
ctype_graph ( ^!string text);
#

#T=ctype_lower - bool ctype_lower ( string text)
(PHP 4 >= 4.0.4)
ctype_lower -- Check for lowercase character(s)
Description
bool ctype_lower ( string text)
Returns TRUE if every character in text is a lowercase letter in the 
current locale. 
See also ctype_alpha() and ctype_upper().   ctype_graphUpctype_print
#

#T=bool ctype_lower ( string text)
ctype_lower ( ^!string text);
#

#T=ctype_print - bool ctype_print ( string text)
(PHP 4 >= 4.0.4)
ctype_print -- Check for printable character(s)
Description
bool ctype_print ( string text)
Returns TRUE if every character in text will actually create output 
(including blanks). Returns FALSE if text contains control characters or 
characters that do not have any output or control function at all. 
See also ctype_cntrl(), ctype_graph(), and ctype_punct().   ctype_lowerUpctype_punct
#

#T=bool ctype_print ( string text)
ctype_print ( ^!string text);
#

#T=ctype_punct - bool ctype_punct ( string text)
(PHP 4 >= 4.0.4)
ctype_punct --  Check for any printable character which is not whitespace 
or an alphanumeric character 
Description
bool ctype_punct ( string text)
Returns TRUE if every character in text is printable, but neither letter, 
digit or blank, FALSE otherwise. 
See also ctype_cntrl(), ctype_graph(), and ctype_punct().   ctype_printUpctype_space
#

#T=bool ctype_punct ( string text)
ctype_punct ( ^!string text);
#

#T=ctype_space - bool ctype_space ( string text)
(PHP 4 >= 4.0.4)
ctype_space -- Check for whitespace character(s)
Description
bool ctype_space ( string text)
Returns TRUE if every character in text creates some sort of white space, 
FALSE otherwise. Besides the blank character this also includes tab, 
vertical tab, line feed, carriage return and form feed characters.   ctype_punctUpctype_upper
#

#T=bool ctype_space ( string text)
ctype_space ( ^!string text);
#

#T=ctype_upper - bool ctype_upper ( string text)
(PHP 4 >= 4.0.4)
ctype_upper -- Check for uppercase character(s)
Description
bool ctype_upper ( string text)
Returns TRUE if every character in text is an uppercase letter in the 
current locale. 
See also ctype_alpha() and ctype_lower().   ctype_spaceUpctype_xdigit
#

#T=bool ctype_upper ( string text)
ctype_upper ( ^!string text);
#

#T=ctype_xdigit - bool ctype_xdigit ( string text)
(PHP 4 >= 4.0.4)
ctype_xdigit --  Check for character(s) representing a hexadecimal digit 
Description
bool ctype_xdigit ( string text)
Returns TRUE if every character in text is a hexadecimal 'digit', that is 
a decimal digit or a character from [A-Fa-f] , FALSE otherwise. 
See also ctype_digit().   ctype_upperUpDatabase (dbm-style) abstraction layer functions
#

#T=bool ctype_xdigit ( string text)
ctype_xdigit ( ^!string text);
#

#T=curl_close - void curl_close ( resource ch)
(PHP 4 >= 4.0.2)
curl_close -- Close a CURL session
Description
void curl_close ( resource ch)
This function closes a CURL session and frees all resources. The CURL 
handle, ch, is also deleted.   CURL, Client URL Library FunctionsUpcurl_errno
#

#T=void curl_close ( resource ch)
curl_close ( ^!resource ch);
#

#T=curl_errno - int curl_errno ( resource ch)
(PHP 4 >= 4.0.3)
curl_errno -- Return the last error number
Description
int curl_errno ( resource ch)
Returns the error number for the last cURL operation on the resource ch, 
or 0 (zero) if no error occurred. 
See also curl_error().  curl_closeUpcurl_error
#

#T=int curl_errno ( resource ch)
curl_errno ( ^!resource ch);
#

#T=curl_error - string curl_error ( resource ch)
(PHP 4 >= 4.0.3)
curl_error --  Return a string containing the last error for the current 
session 
Description
string curl_error ( resource ch)
Returns a clear text error message for the last cURL operation on the 
resource ch, or '' (the empty string) if no error occurred. 
See also curl_errno().  curl_errnoUpcurl_exec
#

#T=string curl_error ( resource ch)
curl_error ( ^!resource ch);
#

#T=curl_exec - mixed curl_exec ( resource ch)
(PHP 4 >= 4.0.2)
curl_exec -- Perform a CURL session
Description
mixed curl_exec ( resource ch)
This function should be called after you initialize a CURL session and all 
the options for the session are set. Its purpose is simply to execute the 
predefined CURL session (given by the ch). 
Note: If you want to have the result returned instead of it being 
printed to the browser directly, use the CURLOPT_RETURNTRANSFER option 
of curl_setopt().   curl_errorUpcurl_getinfo
#

#T=mixed curl_exec ( resource ch)
curl_exec ( ^!resource ch);
#

#T=curl_getinfo - string curl_getinfo ( resource ch [, int opt])
(PHP 4 >= 4.0.4)
curl_getinfo --  Get information regarding a specific transfer 
Description
string curl_getinfo ( resource ch [, int opt])
Returns information about the last transfer, opt may be one of the 
following: 
"CURLINFO_EFFECTIVE_URL" - Last effective URL 
"CURLINFO_HTTP_CODE" - Last received HTTP code 
"CURLINFO_FILETIME" - Remote time of the retrieved document, if -1 is 
returned the time of the document is unknown 
"CURLINFO_TOTAL_TIME" - Total transaction time in seconds for last 
transfer 
"CURLINFO_NAMELOOKUP_TIME" - Time in seconds until name resolving was 
complete 
"CURLINFO_CONNECT_TIME" - Time in seconds it took to establish the 
connection 
"CURLINFO_PRETRANSFER_TIME" - Time in seconds from start until just 
before file transfer begins 
"CURLINFO_STARTTRANSFER_TIME" - Time in seconds until the first byte is 
about to be transferred 
"CURLINFO_REDIRECT_TIME" - Time in seconds of all redirection steps 
before final transaction was started 
"CURLINFO_SIZE_UPLOAD" - Total number of bytes uploaded 
"CURLINFO_SIZE_DOWNLOAD" - Total number of bytes downloaded 
"CURLINFO_SPEED_DOWNLOAD" - Average download speed 
"CURLINFO_SPEED_UPLOAD" - Average upload speed 
"CURLINFO_HEADER_SIZE" - Total size of all headers received 
"CURLINFO_REQUEST_SIZE" - Total size of issued requests, currently only 
for HTTP requests 
"CURLINFO_SSL_VERIFYRESULT" - Result of SSL certification verification 
requested by setting CURLOPT_SSL_VERIFYPEER 
"CURLINFO_CONTENT_LENGTH_DOWNLOAD" - content-length of download, read 
from Content-Length: field 
"CURLINFO_CONTENT_LENGTH_UPLOAD" - Specified size of upload 
"CURLINFO_CONTENT_TYPE" - Content-type of downloaded object, NULL 
indicates server did not send valid Content-Type: header 
If called without the optional parameter opt an associative array is 
returned with the following array elements which correspond to opt 
options: 
"url" 
"content_type" 
"http_encode" 
"header_size" 
"request_size" 
"filetime" 
"ssl_verify_result" 
"redirect_count" 
"total_time" 
"namelookup_time" 
"connect_time" 
"pretransfer_time" 
"size_upload" 
"size_download" 
"speed_download" 
"speed_upload" 
"download_content_length" 
"upload_content_length" 
"starttransfer_time" 
"redirect_time"   curl_execUpcurl_init
#

#T=string curl_getinfo ( resource ch [, int opt])
curl_getinfo ( ^!resource ch [, int opt]);
#

#T=curl_init - resource curl_init ( [string url])
(PHP 4 >= 4.0.2)
curl_init -- Initialize a CURL session
Description
resource curl_init ( [string url])
The curl_init() will initialize a new session and return a CURL handle for 
use with the curl_setopt(), curl_exec(), and curl_close() functions. If 
the optional url parameter is supplied then the CURLOPT_URL option will be 
set to the value of the parameter. You can manually set this using the 
curl_setopt() function. Example 1. Initializing a new CURL session 
and fetching a webpage 
  <?php
  $ch = curl_init();

  curl_setopt($ch, CURLOPT_URL, "http://www.example.com/");
  curl_setopt($ch, CURLOPT_HEADER, 0);

  curl_exec($ch);

  curl_close($ch);
  ?> 
See also: curl_close(), curl_setopt()   curl_getinfoUpcurl_multi_add_handle
#

#T=resource curl_init ( [string url])
curl_init ( ^![string url]);
#

#T=curl_multi_add_handle - int curl_multi_add_handle ( resource mh, resource ch)
(PHP 5 CVS only)
curl_multi_add_handle --  Add a normal cURL handle to a cURL multi handle 
Description
int curl_multi_add_handle ( resource mh, resource ch)
Warning
This function is currently not documented; only the argument list is 
available.

See also curl_multi_init(), curl_init(), and curl_multi_remove_handle().   curl_initUpcurl_multi_close
#

#T=int curl_multi_add_handle ( resource mh, resource ch)
curl_multi_add_handle ( ^!resource mh, resource ch);
#

#T=curl_multi_close - void curl_multi_close ( resource mh)
(PHP 5 CVS only)
curl_multi_close --  Close a set of cURL handles 
Description
void curl_multi_close ( resource mh)
Warning
This function is currently not documented; only the argument list is 
available.

See also curl_multi_init() and curl_close().   curl_multi_add_handleUpcurl_multi_exec
#

#T=void curl_multi_close ( resource mh)
curl_multi_close ( ^!resource mh);
#

#T=curl_multi_exec - int curl_multi_exec ( resource mh)
(PHP 5 CVS only)
curl_multi_exec --  Run the sub-connections of the current cURL handle 
Description
int curl_multi_exec ( resource mh)
Warning
This function is currently not documented; only the argument list is 
available.

See also curl_multi_init() and curl_exec().   curl_multi_closeUpcurl_multi_getcontent
#

#T=int curl_multi_exec ( resource mh)
curl_multi_exec ( ^!resource mh);
#

#T=curl_multi_getcontent - string curl_multi_getcontent ( resource ch)
(PHP 5 CVS only)
curl_multi_getcontent --  Return the content of a cURL handle if 
CURLOPT_RETURNTRANSFER is set 
Description
string curl_multi_getcontent ( resource ch)
Warning
This function is currently not documented; only the argument list is 
available.

See also curl_multi_init().   curl_multi_execUpcurl_multi_info_read
#

#T=string curl_multi_getcontent ( resource ch)
curl_multi_getcontent ( ^!resource ch);
#

#T=curl_multi_info_read - array curl_multi_info_read ( resource mh)
(PHP 5 CVS only)
curl_multi_info_read --  Get information about the current transfers 
Description
array curl_multi_info_read ( resource mh)
Warning
This function is currently not documented; only the argument list is 
available.

See also curl_multi_init().   curl_multi_getcontentUpcurl_multi_init
#

#T=array curl_multi_info_read ( resource mh)
curl_multi_info_read ( ^!resource mh);
#

#T=curl_multi_init - resource curl_multi_init ( void )
(PHP 5 CVS only)
curl_multi_init --  Returns a new cURL multi handle 
Description
resource curl_multi_init ( void )
Warning
This function is currently not documented; only the argument list is 
available.

See also curl_init() and curl_multi_close().   curl_multi_info_readUpcurl_multi_remove_handle
#

#T=resource curl_multi_init ( void )
curl_multi_init ( ^!void );
#

#T=curl_multi_remove_handle - int curl_multi_remove_handle ( resource mh, resource ch)
(PHP 5 CVS only)
curl_multi_remove_handle --  Remove a multi handle from a set of cURL 
handles 
Description
int curl_multi_remove_handle ( resource mh, resource ch)
Warning
This function is currently not documented; only the argument list is 
available.

See also curl_multi_init(), curl_init(), and curl_multi_add_handle().   curl_multi_initUpcurl_multi_select
#

#T=int curl_multi_remove_handle ( resource mh, resource ch)
curl_multi_remove_handle ( ^!resource mh, resource ch);
#

#T=curl_multi_select - int curl_multi_select ( resource mh [, float timeout])
(PHP 5 CVS only)
curl_multi_select --  Get all the sockets associated with the cURL 
extension, which can then be "selected" 
Description
int curl_multi_select ( resource mh [, float timeout])
Warning
This function is currently not documented; only the argument list is 
available.

See also curl_multi_init().   curl_multi_remove_handleUpcurl_setopt
#

#T=int curl_multi_select ( resource mh [, float timeout])
curl_multi_select ( ^!resource mh [, float timeout]);
#

#T=curl_setopt - bool curl_setopt ( resource ch, string option, mixed value)
(PHP 4 >= 4.0.2)
curl_setopt -- Set an option for a CURL transfer
Description
bool curl_setopt ( resource ch, string option, mixed value)
The curl_setopt() function will set options for a CURL session identified 
by the ch parameter. The option parameter is the option you want to set, 
and the value is the value of the option given by the option. 
The value should be a long for the following options (specified in the 
option parameter): 
CURLOPT_INFILESIZE: When you are uploading a file to a remote site, this 
option should be used to tell PHP what the expected size of the infile 
will be. 
CURLOPT_VERBOSE: Set this option to a non-zero value if you want CURL to 
report everything that is happening. 
CURLOPT_HEADER: Set this option to a non-zero value if you want the 
header to be included in the output. 
CURLOPT_NOPROGRESS: Set this option to a non-zero value if you don't 
want PHP to display a progress meter for CURL transfers. 
Note: PHP automatically sets this option to a non-zero parameter, this 
should only be changed for debugging purposes. 
CURLOPT_NOBODY: Set this option to a non-zero value if you don't want 
the body included with the output. 
CURLOPT_FAILONERROR: Set this option to a non-zero value if you want PHP 
to fail silently if the HTTP code returned is greater than 300. The 
default behavior is to return the page normally, ignoring the code. 
CURLOPT_UPLOAD: Set this option to a non-zero value if you want PHP to 
prepare for an upload. 
CURLOPT_POST: Set this option to a non-zero value if you want PHP to do 
a regular HTTP POST. This POST is a normal 
application/x-www-form-urlencoded kind, most commonly used by HTML 
forms. 
CURLOPT_FTPLISTONLY: Set this option to a non-zero value and PHP will 
just list the names of an FTP directory. 
CURLOPT_FTPAPPEND: Set this option to a non-zero value and PHP will 
append to the remote file instead of overwriting it. 
CURLOPT_NETRC: Set this option to a non-zero value and PHP will scan 
your ~./netrc file to find your username and password for the remote 
site that you're establishing a connection with. 
CURLOPT_FOLLOWLOCATION: Set this option to a non-zero value to follow 
any "Location: " header that the server sends as a part of the HTTP 
header (note this is recursive, PHP will follow as many "Location: " 
headers that it is sent.) 
CURLOPT_PUT: Set this option to a non-zero value to HTTP PUT a file. The 
file to PUT must be set with the CURLOPT_INFILE and CURLOPT_INFILESIZE. 
CURLOPT_MUTE: Set this option to a non-zero value and PHP will be 
completely silent with regards to the CURL functions. 
CURLOPT_TIMEOUT: Pass a long as a parameter that contains the maximum 
time, in seconds, that you'll allow the CURL functions to take. 
CURLOPT_LOW_SPEED_LIMIT: Pass a long as a parameter that contains the 
transfer speed in bytes per second that the transfer should be below 
during CURLOPT_LOW_SPEED_TIME seconds for PHP to consider too slow and 
abort. 
CURLOPT_LOW_SPEED_TIME: Pass a long as a parameter that contains the 
time in seconds that the transfer should be below the 
CURLOPT_LOW_SPEED_LIMIT for PHP to consider it too slow and abort. 
CURLOPT_RESUME_FROM: Pass a long as a parameter that contains the 
offset, in bytes, that you want the transfer to start from. 
CURLOPT_CAINFO: Pass a filename of a file holding one or more 
certificates to verify the peer with. This only makes sense when used in 
combination with the CURLOPT_SSL_VERIFYPEER option. 
CURLOPT_SSL_VERIFYPEER: Pass a long that is set to a zero value to stop 
curl from verifying the peer's certificate (curl 7.10 starting setting 
this option to TRUE by default). Alternate certificates to verify 
against can be specified with the CURLOPT_CAINFO option (added in curl 
7.9.8) or a certificate directory can be specified with the 
CURLOPT_CAPATH option. As of curl 7.10, curl installs a default bundle. 
CURLOPT_SSL_VERIFYHOST may also need to be set to 1 or 0 if 
CURLOPT_SSL_VERIFYPEER is disabled (it defaults to 2). 
CURLOPT_SSLVERSION: Pass a long as a parameter that contains the SSL 
version (2 or 3) to use. By default PHP will try and determine this by 
itself, although, in some cases you must set this manually. 
CURLOPT_SSL_VERIFYHOST: Pass a long if CURL should verify the Common 
name of the peer certificate in the SSL handshake. A value of 1 denotes 
that we should check for the existence of the common name, a value of 2 
denotes that we should make sure it matches the provided hostname. 
CURLOPT_TIMECONDITION: Pass a long as a parameter that defines how the 
CURLOPT_TIMEVALUE is treated. You can set this parameter to 
TIMECOND_IFMODSINCE or TIMECOND_ISUNMODSINCE. This is a HTTP-only 
feature. 
CURLOPT_TIMEVALUE: Pass a long as a parameter that is the time in 
seconds since January 1st, 1970. The time will be used as specified by 
the CURLOPT_TIMECONDITION option, or by default the TIMECOND_IFMODSINCE 
will be used. 
CURLOPT_RETURNTRANSFER: Pass a non-zero value if you want CURL to 
directly return the transfer instead of printing it out directly. 
The value parameter should be a string for the following values of the 
option parameter: 
CURLOPT_URL: This is the URL that you want PHP to fetch. You can also 
set this option when initializing a session with the curl_init() 
function. 
CURLOPT_USERPWD: Pass a string formatted in the [username]:[password] 
manner, for PHP to use for the connection. 
CURLOPT_PROXYUSERPWD: Pass a string formatted in the 
[username]:[password] format for connection to the HTTP proxy. 
CURLOPT_RANGE: Pass the specified range you want. It should be in the 
"X-Y" format, where X or Y may be left out. The HTTP transfers also 
support several intervals, separated with commas as in X-Y,N-M. 
CURLOPT_POSTFIELDS: Pass a string containing the full data to post in an 
HTTP "POST" operation. 
CURLOPT_REFERER: Pass a string containing the "referer" header to be 
used in an HTTP request. 
CURLOPT_USERAGENT: Pass a string containing the "user-agent" header to 
be used in an HTTP request. 
CURLOPT_FTPPORT: Pass a string containing the value which will be used 
to get the IP address to use for the ftp "POST" instruction. The POST 
instruction tells the remote server to connect to our specified IP 
address. The string may be a plain IP address, a hostname, a network 
interface name (under Unix), or just a plain '-' to use the systems 
default IP address. 
CURLOPT_COOKIE: Pass a string containing the content of the cookie to be 
set in the HTTP header. 
CURLOPT_SSLCERT: Pass a string containing the filename of PEM formatted 
certificate. 
CURLOPT_SSLCERTPASSWD: Pass a string containing the password required to 
use the CURLOPT_SSLCERT certificate. 
CURLOPT_COOKIEFILE: Pass a string containing the name of the file 
containing the cookie data. The cookie file can be in Netscape format, 
or just plain HTTP-style headers dumped into a file. 
CURLOPT_CUSTOMREQUEST: Pass a string to be used instead of GET or HEAD 
when doing an HTTP request. This is useful for doing DELETE or other, 
more obscure, HTTP requests. Valid values are things like GET, POST, and 
so on; i.e. do not enter a whole HTTP request line here. For instance, 
entering 'GET /index.html HTTP/1.0\r\n\r\n' would be incorrect. 
Note: Don't do this without making sure your server supports the 
command first. 
CURLOPT_PROXY: Give the name of the HTTP proxy to tunnel requests 
through. 
CURLOPT_INTERFACE: Pass the name of the outgoing network interface to 
use. This can be an interface name, an IP address or a host name. 
CURLOPT_KRB4LEVEL: Pass the KRB4 (Kerberos 4) security level. Any of the 
following values (in order from least to most powerful) are valid: 
'clear', 'safe', 'confidential', 'private'. If the string does not match 
one of these, then 'private' is used. Setting this Option to NULL, will 
disable KRB4 security. Currently KRB4 security only works with FTP 
transactions. 
CURLOPT_HTTPHEADER: Pass an array of HTTP header fields to set. 
CURLOPT_QUOTE: Pass an array of FTP commands to perform on the server 
prior to the FTP request. 
CURLOPT_POSTQUOTE: Pass an array of FTP commands to execute on the 
server, after the FTP request has been performed. 
The following options expect a file descriptor that is obtained by using 
the fopen() function: 
CURLOPT_FILE: The file where the output of your transfer should be 
placed, the default is STDOUT. 
CURLOPT_INFILE: The file where the input of your transfer comes from. 
CURLOPT_WRITEHEADER: The file to write the header part of the output 
into. 
CURLOPT_STDERR: The file to write errors to instead of stderr.   curl_multi_selectUpcurl_version
#

#T=bool curl_setopt ( resource ch, string option, mixed value)
curl_setopt ( ^!resource ch, string option, mixed value);
#

#T=curl_version - string curl_version ( void )
(PHP 4 >= 4.0.2)
curl_version -- Return the current CURL version
Description
string curl_version ( void )
The curl_version() function returns a string containing the current CURL 
version.   curl_setoptUpCybercash payment functions
#

#T=string curl_version ( void )
curl_version ( ^!void );
#

#T=current - mixed current ( array array)
(PHP 3, PHP 4 )
current -- Return the current element in an array
Description
mixed current ( array array)
Every array has an internal pointer to its "current" element, which is 
initialized to the first element inserted into the array. 
The current() function simply returns the value of the array element 
that's currently being pointed to by the internal pointer. It does not 
move the pointer in any way. If the internal pointer points beyond the end 
of the elements list, current() returns FALSE. 
Warning
If the array contains empty elements (0 or "", the empty string) 
then this function will return FALSE for these elements as well. 
This makes it impossible to determine if you are really at the end 
of the list in such an array using current(). To properly traverse 
an array that may contain empty elements, use the each() function. 

Example 1. Example use of current() and friends
  <?php
  $transport = array('foot', 'bike', 'car', 'plane');
  $mode = current($transport); // $mode = 'foot';
  $mode = next($transport);    // $mode = 'bike';
  $mode = current($transport); // $mode = 'bike';
  $mode = prev($transport);    // $mode = 'foot';
  $mode = end($transport);     // $mode = 'plane';
  $mode = current($transport); // $mode = 'plane';
  ?> 
See also end(), key(), next(), prev(), and reset().   countUpeach
#

#T=mixed current ( array array)
current ( ^!array array);
#

#T=cybercash_base64_decode - string cybercash_base64_decode ( string inbuff)
(PHP 4 <= 4.2.3)
cybercash_base64_decode -- base64 decode data for Cybercash
Description
string cybercash_base64_decode ( string inbuff)

  Cybercash payment functionsUpcybercash_base64_encode
#

#T=string cybercash_base64_decode ( string inbuff)
cybercash_base64_decode ( ^!string inbuff);
#

#T=cybercash_base64_encode - string cybercash_base64_encode ( string inbuff)
(PHP 4 <= 4.2.3)
cybercash_base64_encode -- base64 encode data for Cybercash
Description
string cybercash_base64_encode ( string inbuff)

  cybercash_base64_decodeUpcybercash_decr
#

#T=string cybercash_base64_encode ( string inbuff)
cybercash_base64_encode ( ^!string inbuff);
#

#T=cybercash_decr - array cybercash_decr ( string wmk, string sk, string inbuff)
(PHP 4 <= 4.2.3)
cybercash_decr -- Cybercash decrypt
Description
array cybercash_decr ( string wmk, string sk, string inbuff)
The function returns an associative array with the elements "errcode" and, 
if "errcode" is FALSE, "outbuff" (string), "outLth" (long) and "macbuff" 
(string).   cybercash_base64_encodeUpcybercash_encr
#

#T=array cybercash_decr ( string wmk, string sk, string inbuff)
cybercash_decr ( ^!string wmk, string sk, string inbuff);
#

#T=cybercash_encr - array cybercash_encr ( string wmk, string sk, string inbuff)
(PHP 4 <= 4.2.3)
cybercash_encr -- Cybercash encrypt
Description
array cybercash_encr ( string wmk, string sk, string inbuff)
The function returns an associative array with the elements "errcode" and, 
if "errcode" is FALSE, "outbuff" (string), "outLth" (long) and "macbuff" 
(string).   cybercash_decrUpCyrus IMAP administration functions
cyrus_authenticate
(4.1.0 - 4.3.2 only)
cyrus_authenticate -- Authenticate against a Cyrus IMAP server 
Description
bool cyrus_authenticate ( resource connection [, string mechlist [, string 
service [, string user [, int minssf [, int maxssf]]]]])
Warning
This function is currently not documented; only the argument list is 
available.
  Cyrus IMAP administration functionsUpcyrus_bind
cyrus_bind
(4.1.0 - 4.3.2 only)
cyrus_bind -- Bind callbacks to a Cyrus IMAP connection 
Description
bool cyrus_bind ( resource connection, array callbacks)
Warning
This function is currently not documented; only the argument list is 
available.
  cyrus_authenticateUpcyrus_close
cyrus_close
(4.1.0 - 4.3.2 only)
cyrus_close -- Close connection to a Cyrus IMAP server 
Description
bool cyrus_close ( resource connection)
Warning
This function is currently not documented; only the argument list is 
available.
  cyrus_bindUpcyrus_connect
cyrus_connect
(4.1.0 - 4.3.2 only)
cyrus_connect -- Connect to a Cyrus IMAP server 
Description
resource cyrus_connect ( [string host [, string port [, int flags]]])
Warning
This function is currently not documented; only the argument list is 
available.
  cyrus_closeUpcyrus_query
cyrus_query
(4.1.0 - 4.3.2 only)
cyrus_query -- Send a query to a Cyrus IMAP server 
Description
bool cyrus_query ( resource connection, string query)
Warning
This function is currently not documented; only the argument list is 
available.
  cyrus_connectUpcyrus_unbind
cyrus_unbind
(4.1.0 - 4.3.2 only)
cyrus_unbind -- Unbind ... 
Description
bool cyrus_unbind ( resource connection, string trigger_name)
Warning
This function is currently not documented; only the argument list is 
available.
  cyrus_queryUpCharacter type functions
#

#T=array cybercash_encr ( string wmk, string sk, string inbuff)
cybercash_encr ( ^!string wmk, string sk, string inbuff);
#

#T=date - string date ( string format [, int timestamp])
(PHP 3, PHP 4 )
date -- Format a local time/date
Description
string date ( string format [, int timestamp])
Returns a string formatted according to the given format string using the 
given integer timestamp or the current local time if no timestamp is 
given. In otherwords, timestamp is optional and defaults to the value of 
time(). 
Note: The valid range of a timestamp is typically from Fri, 13 Dec 1901 
20:45:54 GMT to Tue, 19 Jan 2038 03:14:07 GMT. (These are the dates that 
correspond to the minimum and maximum values for a 32-bit signed 
integer). On Windows this range is limited from 01-01-1970 to 
19-01-2038. 
Note: To generate a timestamp from a string representation of the date, 
you may be able to use strtotime(). Additionally, some databases have 
functions to convert their date formats into timestamps (such as MySQL's 
UNIX_TIMESTAMP function). 
Table 1. The following characters are recognized in the format parameter 
string
format characterDescriptionExample returned values
aLowercase Ante meridiem and Post meridiemam or pm
AUppercase Ante meridiem and Post meridiemAM or PM
BSwatch Internet time000 through 999
dDay of the month, 2 digits with leading zeros01 to 31
DA textual representation of a day, three lettersMon through Sun
FA full textual representation of a month, such as January or 
MarchJanuary through December
g12-hour format of an hour without leading zeros1 through 12
G24-hour format of an hour without leading zeros0 through 23
h12-hour format of an hour with leading zeros01 through 12
H24-hour format of an hour with leading zeros00 through 23
iMinutes with leading zeros00 to 59
I (capital i)Whether or not the date is in daylights savings time1 
if Daylight Savings Time, 0 otherwise.
jDay of the month without leading zeros1 to 31
l (lowercase 'L')A full textual representation of the day of the 
weekSunday through Saturday
LWhether it's a leap year1 if it is a leap year, 0 otherwise.
mNumeric representation of a month, with leading zeros01 through 12
MA short textual representation of a month, three lettersJan through 
Dec
nNumeric representation of a month, without leading zeros1 through 
12
ODifference to Greenwich time (GMT) in hoursExample: +0200
rRFC 822 formatted dateExample: Thu, 21 Dec 2000 16:01:07 +0200
sSeconds, with leading zeros00 through 59
SEnglish ordinal suffix for the day of the month, 2 charactersst, 
nd, rd or th. Works well with j 
tNumber of days in the given month28 through 31
TTimezone setting of this machineExamples: EST, MDT ...
USeconds since the Unix Epoch (January 1 1970 00:00:00 GMT)See also 
time()
wNumeric representation of the day of the week0 (for Sunday) through 
6 (for Saturday)
WISO-8601 week number of year, weeks starting on Monday (added in 
PHP 4.1.0)Example: 42 (the 42nd week in the year)
YA full numeric representation of a year, 4 digitsExamples: 1999 or 
2003
yA two digit representation of a yearExamples: 99 or 03
zThe day of the year (starting from 0)0 through 365
ZTimezone offset in seconds. The offset for timezones west of UTC is 
always negative, and for those east of UTC is always positive.-43200 
through 43200

Unrecognized characters in the format string will be printed as-is. The Z 
format will always return 0 when using gmdate(). 
Example 1. date() examples
  <?php
  // Prints something like: Wednesday
  echo date("l");

  // Prints something like: Wednesday 15th of January 2003 
  05:51:38 AM
  echo date ("l dS of F Y h:i:s A");

  // Prints: July 1, 2000 is on a Saturday
  echo "July 1, 2000 is on a " . date ("l", mktime(0, 0, 0, 7, 
  1, 2000));
  ?> 
You can prevent a recognized character in the format string from being 
expanded by escaping it with a preceding backslash. If the character with 
a backslash is already a special sequence, you may need to also escape the 
backslash. Example 2. Escaping characters in date()
  <?php
  // prints something like: Wednesday the 15th
  echo date("l \\t\h\e jS");
  ?> 
It is possible to use date() and mktime() together to find dates in the 
future or the past. Example 3. date() and mktime() example 
  <?php
  $tomorrow  = mktime(0, 0, 0, date("m")  , date("d")+1, 
  date("Y"));
  $lastmonth = mktime(0, 0, 0, date("m")-1, date("d"),   
  date("Y"));
  $nextyear  = mktime(0, 0, 0, date("m"),   date("d"),   
  date("Y")+1);
  ?> 
Note: This can be more reliable than simply adding or subtracting the 
number of seconds in a day or month to a timestamp because of daylight 
savings time. 
Some examples of date() formatting. Note that you should escape any other 
characters, as any which currently have a special meaning will produce 
undesirable results, and other characters may be assigned meaning in 
future PHP versions. When escaping, be sure to use single quotes to 
prevent characters like \n from becoming newlines. Example 4. date() 
Formatting 
  <?php
  // Assuming today is: March 10th, 2001, 5:16:18 pm

  $today = date("F j, Y, g:i a");                 // March 10, 
  2001, 5:16 pm
  $today = date("m.d.y");                         // 03.10.01
  $today = date("j, n, Y");                       // 10, 3, 2001
  $today = date("Ymd");                           // 20010310
  $today = date('h-i-s, j-m-y, it is w Day z ');  // 05-16-17, 
  10-03-01, 1631 1618 6 Fripm01
  $today = date('\i\t \i\s \t\h\e jS \d\a\y.');   // It is the 
  10th day.
  $today = date("D M j G:i:s T Y");               // Sat Mar 10 
  15:16:08 MST 2001
  $today = date('H:m:s \m \i\s\ \m\o\n\t\h');     // 17:03:17 m 
  is month
  $today = date("H:i:s");                         // 17:16:17
  ?> 
To format dates in other languages, you should use the setlocale() and 
strftime() functions. 
See also getlastmod(), gmdate(), mktime(), strftime() and time().   checkdateUpgetdate
#

#T=string date ( string format [, int timestamp])
date ( ^!string format [, int timestamp]);
#

#T=dba_close - void dba_close ( resource handle)
(PHP 3>= 3.0.8, PHP 4 )
dba_close -- Close database
Description
void dba_close ( resource handle)
dba_close() closes the established database and frees all resources 
specified by handle. 
handle is a database handle returned by dba_open(). 
dba_close() does not return any value. 
See also: dba_open() and dba_popen()   Database (dbm-style) abstraction layer functionsUpdba_delete
#

#T=void dba_close ( resource handle)
dba_close ( ^!resource handle);
#

#T=dba_delete - bool dba_delete ( string key, resource handle)
(PHP 3>= 3.0.8, PHP 4 )
dba_delete -- Delete entry specified by key
Description
bool dba_delete ( string key, resource handle)
dba_delete() deletes the entry specified by key from the database 
specified with handle. 
key is the key of the entry which is deleted. 
handle is a database handle returned by dba_open(). 
dba_delete() returns TRUE or FALSE, if the entry is deleted or not 
deleted, respectively. 
See also: dba_exists(), dba_fetch(), dba_insert(), and dba_replace().   dba_closeUpdba_exists
#

#T=bool dba_delete ( string key, resource handle)
dba_delete ( ^!string key, resource handle);
#

#T=dba_exists - bool dba_exists ( string key, resource handle)
(PHP 3>= 3.0.8, PHP 4 )
dba_exists -- Check whether key exists
Description
bool dba_exists ( string key, resource handle)
dba_exists() checks whether the specified key exists in the database 
specified by handle. 
Key is the key the check is performed for. 
Handle is a database handle returned by dba_open(). 
dba_exists() returns TRUE or FALSE, if the key is found or not found, 
respectively. 
See also: dba_fetch(), dba_delete(), dba_insert(), and dba_replace().   dba_deleteUpdba_fetch
#

#T=bool dba_exists ( string key, resource handle)
dba_exists ( ^!string key, resource handle);
#

#T=dba_fetch - string dba_fetch ( string key, resource handle)
(PHP 3>= 3.0.8, PHP 4 )
dba_fetch -- Fetch data specified by key
Description
string dba_fetch ( string key, resource handle)

string dba_fetch ( string key, int skip, resource handle)
dba_fetch() fetches the data specified by key from the database specified 
with handle. 
Key is the key the data is specified by. 
Skip is the number of key-value pairs to ignore when using cdb databases. 
This value is ignored for all other databases which do not support 
multiple keys with the same name. 
Handle is a database handle returned by dba_open(). 
dba_fetch() returns the associated string or FALSE, if the key/data pair 
is found or not found, respectively. 
See also: dba_exists(), dba_delete(), dba_insert(), dba_replace() and 
dba_key_split(). 
Note: The skip parameter is available since PHP 4.3 to support cdb's 
capability of multiple keys having the same name. 
Note: When working with inifiles this function accepts arrays as keys 
where index 0 is the group and index 1 is the value name. See: 
dba_key_split().   dba_existsUpdba_firstkey
#

#T=string dba_fetch ( string key, resource handle)
dba_fetch ( ^!string key, resource handle);
#

#T=dba_firstkey - string dba_firstkey ( resource handle)
(PHP 3>= 3.0.8, PHP 4 )
dba_firstkey -- Fetch first key
Description
string dba_firstkey ( resource handle)
dba_firstkey() returns the first key of the database specified by handle 
and resets the internal key pointer. This permits a linear search through 
the whole database. 
Handle is a database handle returned by dba_open(). 
dba_firstkey() returns the key or FALSE depending on whether it succeeds 
or fails, respectively. 
See also: dba_firstkey(), dba_key_split() and example 2 in the DBA 
examples   dba_fetchUpdba_handlers
#

#T=string dba_firstkey ( resource handle)
dba_firstkey ( ^!resource handle);
#

#T=dba_handlers - array dba_handlers ( void )
(PHP 4 >= 4.3.0)
dba_handlers -- List handlers available
Description
array dba_handlers ( void )
dba_handlers() returns an array with all handlers supported by this 
extension. 
When the internal cdb library is used you will see 'cdb' and 'cdb_make'.   dba_firstkeyUpdba_insert
#

#T=array dba_handlers ( void )
dba_handlers ( ^!void );
#

#T=dba_insert - bool dba_insert ( string key, string value, resource handle)
(PHP 3>= 3.0.8, PHP 4 )
dba_insert -- Insert entry
Description
bool dba_insert ( string key, string value, resource handle)
dba_insert() inserts the entry described with key and value into the 
database specified by handle. It fails, if an entry with the same key 
already exists. 
key is the key of the entry to be inserted. 
value is the value to be inserted. 
handle is a database handle returned by dba_open(). 
dba_insert() returns TRUE or FALSE, depending on whether it succeeds of 
fails, respectively. 
See also: dba_exists() dba_delete() dba_fetch() dba_replace()   dba_handlersUpdba_key_split
dba_key_split
(no version information, might be only in CVS)
dba_key_split -- Splits a key in string representation into array 
representation
Description
mixed dba_key_split ( mixed key)
dba_key_split() returns an array of the form 
array(0=>group,1=>value_name). This function will return FALSE if key is 
NULL or FALSE. 
key is the key in string representation. 
See also dba_firstkey(), dba_nextkey() and dba_fetch().   dba_insertUpdba_list
#

#T=bool dba_insert ( string key, string value, resource handle)
dba_insert ( ^!string key, string value, resource handle);
#

#T=dba_list - array dba_list ( void )
(PHP 4 >= 4.3.0)
dba_list -- List all open database files
Description
array dba_list ( void )
dba_list() returns an associative array with all open database files. This 
array is in the form: resourceid=>filename.   dba_key_splitUpdba_nextkey
#

#T=array dba_list ( void )
dba_list ( ^!void );
#

#T=dba_nextkey - string dba_nextkey ( resource handle)
(PHP 3>= 3.0.8, PHP 4 )
dba_nextkey -- Fetch next key
Description
string dba_nextkey ( resource handle)
dba_nextkey() returns the next key of the database specified by handle and 
advances the internal key pointer. 
handle is a database handle returned by dba_open(). 
dba_nextkey() returns the key or FALSE depending on whether it succeeds or 
fails, respectively. 
See also: dba_firstkey(), dba_key_split() and example 2 in the DBA 
examples   dba_listUpdba_open
#

#T=string dba_nextkey ( resource handle)
dba_nextkey ( ^!resource handle);
#

#T=dba_open - resource dba_open ( string path, string mode, string handler [, ...])
(PHP 3>= 3.0.8, PHP 4 )
dba_open -- Open database
Description
resource dba_open ( string path, string mode, string handler [, ...])
dba_open() establishes a database instance for path with mode using 
handler. 
path is commonly a regular path in your filesystem. 
mode is "r" for read access, "w" for read/write access to an already 
existing database, "c" for read/write access and database creation if it 
doesn't currently exist, and "n" for create, truncate and read/write 
access. Additional you can set the database lock method with the next 
char. Use "l" to lock the database with an .lck file or "d" to lock the 
databasefile itself. It is important that all of your applications do this 
consistently. If you want to test the access and do not want to wait for 
the lock you can add "t" as third character. When you are absolutely sure 
that you do not require database locking you can do so by using "-" 
instead of "l" or "d". When none of "d", "l" or "-" is used dba will lock 
on the database file as it would with "d". 
handler is the name of the handler which shall be used for accessing path. 
It is passed all optional parameters given to dba_open() and can act on 
behalf of them. 
dba_open() returns a positive handle or FALSE, in the case the database 
was opened successfull or fails, respectively. 
Note: There can only be one writer for one database file. When you use 
dba on a webserver and more than one request requires write operations 
they can only be done one after another. Also read during write is not 
allowed. The dba extension uses locks to prevent this. See the following 
table: 
Table 1. DBA locking
already openmode = "rl"mode = "rlt"mode = "wl"mode = "wlt"mode = 
"rd"mode = "rdt"mode = "wd"mode = "wdt"
not openokokokokokokokok
mode = "rl"okokwaitfalseillegalillegalillegalillegal
mode = "wl"waitfalsewaitfalseillegalillegalillegalillegal
mode = "rd"illegalillegalillegalillegalokokwaitfalse
mode = "wd"illegalillegalillegalillegalwaitfalsewaitfalse

ok: the second call will be successfull.
wait: the second call waits until dba_close() is called for the 
first.
false: the second call returns false.
illegal: you must not mix "l" and "d" modifiers for mode 
parameter.

Note: Since PHP 4.3.0 it is possible to open database files over network 
connection. However in cases a socket connection will be used (as with 
http or ftp) the connection will be locked instead of the resource 
itself. This is important to know since in such cases locking is simply 
ignored on the resource and other solutions have to be found. 
Note: Locking and the mode modifiers "l", "d", "-" and "t" were added in 
PHP 4.3.0. In PHP versions before PHP 4.3.0 you must use semaphores to 
guard against simultaneous database access for any database handler with 
the exception of GDBM. See System V semaphore support. 
Note: Up to PHP 4.3.5 open mode 'c' is broken for several internal 
handlers and truncates the database instead of appending data to an 
existant database. Also dbm and ndbm fail on mode 'c' in typical 
configurations (this cannot be fixed). 
See also: dba_popen() dba_close()   dba_nextkeyUpdba_optimize
#

#T=resource dba_open ( string path, string mode, string handler [, ...])
dba_open ( ^!string path, string mode, string handler [, ...]);
#

#T=dba_optimize - bool dba_optimize ( resource handle)
(PHP 3>= 3.0.8, PHP 4 )
dba_optimize -- Optimize database
Description
bool dba_optimize ( resource handle)
dba_optimize() optimizes the underlying database specified by handle. 
handle is a database handle returned by dba_open(). 
dba_optimize() returns TRUE or FALSE, if the optimization succeeds or 
fails, respectively. 
See also: dba_sync()   dba_openUpdba_popen
#

#T=bool dba_optimize ( resource handle)
dba_optimize ( ^!resource handle);
#

#T=dba_popen - resource dba_popen ( string path, string mode, string handler [, ...])
(PHP 3>= 3.0.8, PHP 4 )
dba_popen -- Open database persistently
Description
resource dba_popen ( string path, string mode, string handler [, ...])
dba_popen() establishes a persistent database instance for path with mode 
using handler. 
path is commonly a regular path in your filesystem. 
mode is "r" for read access, "w" for read/write access to an already 
existing database, "c" for read/write access and database creation if it 
doesn't currently exist, and "n" for create, truncate and read/write 
access. 
handler is the name of the handler which shall be used for accessing path. 
It is passed all optional parameters given to dba_popen() and can act on 
behalf of them. 
dba_popen() returns a positive handle or FALSE, in the case the open is 
successful or fails, respectively. 
See also: dba_open() dba_close()   dba_optimizeUpdba_replace
#

#T=resource dba_popen ( string path, string mode, string handler [, ...])
dba_popen ( ^!string path, string mode, string handler [, ...]);
#

#T=dba_replace - bool dba_replace ( string key, string value, resource handle)
(PHP 3>= 3.0.8, PHP 4 )
dba_replace -- Replace or insert entry
Description
bool dba_replace ( string key, string value, resource handle)
dba_replace() replaces or inserts the entry described with key and value 
into the database specified by handle. 
key is the key of the entry to be inserted. 
value is the value to be inserted. 
handle is a database handle returned by dba_open(). 
dba_replace() returns TRUE or FALSE, depending on whether it succeeds of 
fails, respectively. 
See also: dba_exists(), dba_delete(), dba_fetch(), and dba_insert().   dba_popenUpdba_sync
#

#T=bool dba_replace ( string key, string value, resource handle)
dba_replace ( ^!string key, string value, resource handle);
#

#T=dba_sync - bool dba_sync ( resource handle)
(PHP 3>= 3.0.8, PHP 4 )
dba_sync -- Synchronize database
Description
bool dba_sync ( resource handle)
dba_sync() synchronizes the database specified by handle. This will 
probably trigger a physical write to disk, if supported. 
handle is a database handle returned by dba_open(). 
dba_sync() returns TRUE or FALSE, if the synchronization succeeds or 
fails, respectively. 
See also: dba_optimize()   dba_replaceUpDate and Time functions
#

#T=bool dba_sync ( resource handle)
dba_sync ( ^!resource handle);
#

#T=dbase_add_record - bool dbase_add_record ( int dbase_identifier, array record)
(PHP 3, PHP 4 )
dbase_add_record -- Add a record to a dBase database
Description
bool dbase_add_record ( int dbase_identifier, array record)
Adds the data in the record to the database. If the number of items in the 
supplied record isn't equal to the number of fields in the database, the 
operation will fail and FALSE will be returned.   dBase functionsUpdbase_close
#

#T=bool dbase_add_record ( int dbase_identifier, array record)
dbase_add_record ( ^!int dbase_identifier, array record);
#

#T=dbase_close - bool dbase_close ( int dbase_identifier)
(PHP 3, PHP 4 )
dbase_close -- Close a dBase database
Description
bool dbase_close ( int dbase_identifier)
Closes the database associated with dbase_identifier.   dbase_add_recordUpdbase_create
#

#T=bool dbase_close ( int dbase_identifier)
dbase_close ( ^!int dbase_identifier);
#

#T=dbase_create - int dbase_create ( string filename, array fields)
(PHP 3, PHP 4 )
dbase_create -- Creates a dBase database
Description
int dbase_create ( string filename, array fields)
dbase_create() creates a dBase database in the file filename, with the 
fields fields. 
The fields parameter is an array of arrays, each array describing the 
format of one field in the database. Each field consists of a name, a 
character indicating the field type, a length, and a precision. 
The types of fields available are: 
L
Boolean. These do not have a length or precision. 
M
Memo. (Note that these aren't supported by PHP.) These do not have a 
length or precision. 
D
Date (stored as YYYYMMDD). These do not have a length or precision. 
N
Number. These have both a length and a precision (the number of digits 
after the decimal point). 
C
String. 
If the database is successfully created, a dbase_identifier is returned, 
otherwise FALSE is returned. Example 1. Creating a dBase database 
file
  <?php

  // "database" name
  $dbname = "/tmp/test.dbf";

  // database "definition"
  $def =
      array(
	  array("date",     "D"),
	  array("name",     "C",  50),
	  array("age",      "N",   3, 0),
	  array("email",    "C", 128),
	  array("ismember", "L")
      );

  // creation
  if (!dbase_create($dbname, $def))
      echo "<strong>Error!</strong>";

  ?> 

  dbase_closeUpdbase_delete_record
#

#T=int dbase_create ( string filename, array fields)
dbase_create ( ^!string filename, array fields);
#

#T=dbase_delete_record - bool dbase_delete_record ( int dbase_identifier, int record)
(PHP 3, PHP 4 )
dbase_delete_record -- Deletes a record from a dBase database
Description
bool dbase_delete_record ( int dbase_identifier, int record)
Marks record to be deleted from the database. To actually remove the 
record from the database, you must also call dbase_pack().   dbase_createUpdbase_get_header_info
dbase_get_header_info
(no version information, might be only in CVS)
dbase_get_header_info -- Get the header info of a dBase database
Description
array dbase_get_header_info ( int dbase_identifier)
Returns information on the column structure of the database referenced by 
dbase_identifier. For each column in the database, there is an entry in a 
numerically-indexed array. The array index starts at 0. Each array element 
contains an associative array of column information. If the database 
header information cannot be read, FALSE is returned. 
The array elements are: 
name
The name of the column 
type
The human-readable name for the dbase type of the column (i.e. date, 
boolean, etc) 
length
The number of bytes this column can hold 
precision
The number of digits of decimal precision for the column 
format
A suggested printf() format specifier for the column 
offset
The byte offset of the column from the start of the row 
Example 1. Showing header information for a dBase database file
  <?php
  // Path to dbase file
  $db_path = "/tmp/test.dbf";

  // Open dbase file
  $dbh = dbase_open($db_path)
      or die("Error! Could not open dbase database file 
  '$db_path'.");

  // Get column information
  $column_info = dbase_get_header_info($dbh);

  // Display information
  print_r($column_info);
  ?> 

  dbase_delete_recordUpdbase_get_record_with_names
#

#T=bool dbase_delete_record ( int dbase_identifier, int record)
dbase_delete_record ( ^!int dbase_identifier, int record);
#

#T=dbase_get_record_with_names - array dbase_get_record_with_names ( int dbase_identifier, int record)
(PHP 3>= 3.0.4, PHP 4 )
dbase_get_record_with_names --  Gets a record from a dBase database as an 
associative array 
Description
array dbase_get_record_with_names ( int dbase_identifier, int record)
Returns the data from record in an associative array. The array also 
includes an associative member named 'deleted' which is set to 1 if the 
record has been marked for deletion (see dbase_delete_record()). 
Each field is converted to the appropriate PHP type, except: 
Dates are left as strings 
Integers that would have caused an overflow (> 32 bits) are returned as 
strings   dbase_get_header_infoUpdbase_get_record
#

#T=array dbase_get_record_with_names ( int dbase_identifier, int record)
dbase_get_record_with_names ( ^!int dbase_identifier, int record);
#

#T=dbase_get_record - array dbase_get_record ( int dbase_identifier, int record)
(PHP 3, PHP 4 )
dbase_get_record -- Gets a record from a dBase database
Description
array dbase_get_record ( int dbase_identifier, int record)
Returns the data from record in an array. The array is indexed starting at 
0, and includes an associative member named 'deleted' which is set to 1 if 
the record has been marked for deletion (see dbase_delete_record(). 
Each field is converted to the appropriate PHP type, except: 
Dates are left as strings 
Integers that would have caused an overflow (> 32 bits) are returned as 
strings   dbase_get_record_with_namesUpdbase_numfields
#

#T=array dbase_get_record ( int dbase_identifier, int record)
dbase_get_record ( ^!int dbase_identifier, int record);
#

#T=dbase_numfields - int dbase_numfields ( int dbase_identifier)
(PHP 3, PHP 4 )
dbase_numfields --  Find out how many fields are in a dBase database 
Description
int dbase_numfields ( int dbase_identifier)
Returns the number of fields (columns) in the specified database. Field 
numbers are between 0 and dbase_numfields($db)-1, while record numbers are 
between 1 and dbase_numrecords($db). Example 1. Using 
dbase_numfields()
  <?php

  $rec = dbase_get_record($db, $recno);
  $nf  = dbase_numfields($db);
  for ($i=0; $i < $nf; $i++) {
      echo $rec[$i]."<br />\n";
  }

  ?> 

  dbase_get_recordUpdbase_numrecords
#

#T=int dbase_numfields ( int dbase_identifier)
dbase_numfields ( ^!int dbase_identifier);
#

#T=dbase_numrecords - int dbase_numrecords ( int dbase_identifier)
(PHP 3, PHP 4 )
dbase_numrecords --  Find out how many records are in a dBase database 
Description
int dbase_numrecords ( int dbase_identifier)
Returns the number of records (rows) in the specified database. Record 
numbers are between 1 and dbase_numrecords($db), while field numbers are 
between 0 and dbase_numfields($db)-1.   dbase_numfieldsUpdbase_open
#

#T=int dbase_numrecords ( int dbase_identifier)
dbase_numrecords ( ^!int dbase_identifier);
#

#T=dbase_open - int dbase_open ( string filename, int flags)
(PHP 3, PHP 4 )
dbase_open -- Opens a dBase database
Description
int dbase_open ( string filename, int flags)
Returns a dbase_identifier for the opened database, or FALSE if the 
database couldn't be opened. 
Parameter flags correspond to those for the open() system call (Typically 
0 means read-only, 1 means write-only, and 2 means read and write). 
Note: When safe mode is enabled, PHP checks whether the files or 
directories you are about to operate on have the same UID (owner) as the 
script that is being executed.  dbase_numrecordsUpdbase_pack
#

#T=int dbase_open ( string filename, int flags)
dbase_open ( ^!string filename, int flags);
#

#T=dbase_pack - bool dbase_pack ( int dbase_identifier)
(PHP 3, PHP 4 )
dbase_pack -- Packs a dBase database
Description
bool dbase_pack ( int dbase_identifier)
Packs the specified database (permanently deleting all records marked for 
deletion using dbase_delete_record()).   dbase_openUpdbase_replace_record
#

#T=bool dbase_pack ( int dbase_identifier)
dbase_pack ( ^!int dbase_identifier);
#

#T=dbase_replace_record - bool dbase_replace_record ( int dbase_identifier, array record, int 
(PHP 3>= 3.0.11, PHP 4 )
dbase_replace_record -- Replace a record in a dBase database
Description
bool dbase_replace_record ( int dbase_identifier, array record, int 
dbase_record_number)
Replaces the data associated with the record record_number with the data 
in the record in the database. If the number of items in the supplied 
record is not equal to the number of fields in the database, the operation 
will fail and FALSE will be returned. 
dbase_record_number is an integer which spans from 1 to the number of 
records in the database (as returned by dbase_numrecords()).   dbase_packUpDBM Functions [deprecated]
#

#T=bool dbase_replace_record ( int dbase_identifier, array record, int 
dbase_replace_record ( ^!int dbase_identifier, array record, int ;
#

#T=dblist - string dblist ( void )
(PHP 3, PHP 4 )
dblist --  Describes the DBM-compatible library being used 
Description
string dblist ( void )
Example 1. Getting the information on the command line
[marcus@zaphod marcus]$ php -r 'echo dblist();'
This is GDBM version 1.8.0, as of May 19, 1999.

  DBM Functions [deprecated]Updbmclose
#

#T=string dblist ( void )
dblist ( ^!void );
#

#T=dbmclose - bool dbmclose ( resource dbm_identifier)
(PHP 3, PHP 4 )
dbmclose -- Closes a dbm database
Description
bool dbmclose ( resource dbm_identifier)
Unlocks and closes the specified database.   dblistUpdbmdelete
#

#T=bool dbmclose ( resource dbm_identifier)
dbmclose ( ^!resource dbm_identifier);
#

#T=dbmdelete - bool dbmdelete ( resource dbm_identifier, string key)
(PHP 3, PHP 4 )
dbmdelete --  Deletes the value for a key from a DBM database 
Description
bool dbmdelete ( resource dbm_identifier, string key)
Deletes the value for key in the database. 
Returns FALSE if the key didn't exist in the database.   dbmcloseUpdbmexists
#

#T=bool dbmdelete ( resource dbm_identifier, string key)
dbmdelete ( ^!resource dbm_identifier, string key);
#

#T=dbmexists - bool dbmexists ( resource dbm_identifier, string key)
(PHP 3, PHP 4 )
dbmexists --  Tells if a value exists for a key in a DBM database 
Description
bool dbmexists ( resource dbm_identifier, string key)
Returns TRUE if there is a value associated with the key.   dbmdeleteUpdbmfetch
#

#T=bool dbmexists ( resource dbm_identifier, string key)
dbmexists ( ^!resource dbm_identifier, string key);
#

#T=dbmfetch - string dbmfetch ( resource dbm_identifier, string key)
(PHP 3, PHP 4 )
dbmfetch --  Fetches a value for a key from a DBM database 
Description
string dbmfetch ( resource dbm_identifier, string key)
Returns the value associated with key.   dbmexistsUpdbmfirstkey
#

#T=string dbmfetch ( resource dbm_identifier, string key)
dbmfetch ( ^!resource dbm_identifier, string key);
#

#T=dbmfirstkey - string dbmfirstkey ( resource dbm_identifier)
(PHP 3, PHP 4 )
dbmfirstkey --  Retrieves the first key from a DBM database 
Description
string dbmfirstkey ( resource dbm_identifier)
Returns the first key in the database. Note that no particular order is 
guaranteed since the database may be built using a hash-table, which 
doesn't guarantee any ordering.   dbmfetchUpdbminsert
#

#T=string dbmfirstkey ( resource dbm_identifier)
dbmfirstkey ( ^!resource dbm_identifier);
#

#T=dbminsert - int dbminsert ( resource dbm_identifier, string key, string value)
(PHP 3, PHP 4 )
dbminsert --  Inserts a value for a key in a DBM database 
Description
int dbminsert ( resource dbm_identifier, string key, string value)
Adds the value to the database with the specified key. 
Returns -1 if the database was opened read-only, 0 if the insert was 
successful, and 1 if the specified key already exists. (To replace the 
value, use dbmreplace().)   dbmfirstkeyUpdbmnextkey
#

#T=int dbminsert ( resource dbm_identifier, string key, string value)
dbminsert ( ^!resource dbm_identifier, string key, string value);
#

#T=dbmnextkey - string dbmnextkey ( resource dbm_identifier, string key)
(PHP 3, PHP 4 )
dbmnextkey --  Retrieves the next key from a DBM database
Description
string dbmnextkey ( resource dbm_identifier, string key)
Returns the next key after key. By calling dbmfirstkey() followed by 
successive calls to dbmnextkey() it is possible to visit every key/value 
pair in the dbm database. For example: Example 1. Visiting every 
key/value pair in a DBM database
  <?php

  $key = dbmfirstkey($dbm_id);
  while ($key) {
      echo "$key = " . dbmfetch($dbm_id, $key) . "\n";
      $key = dbmnextkey($dbm_id, $key);
  }

  ?> 

  dbminsertUpdbmopen
#

#T=string dbmnextkey ( resource dbm_identifier, string key)
dbmnextkey ( ^!resource dbm_identifier, string key);
#

#T=dbmopen - resource dbmopen ( string filename, string flags)
(PHP 3, PHP 4 )
dbmopen -- Opens a DBM database
Description
resource dbmopen ( string filename, string flags)
The first argument is the full-path filename of the DBM file to be opened 
and the second is the file open mode which is one of "r", "n", "c" or "w" 
for read-only, new (implies read-write, and most likely will truncate an 
already-existing database of the same name), create (implies read-write, 
and will not truncate an already-existing database of the same name) and 
read-write respectively. 
Returns an identifier to be passed to the other DBM functions on success, 
or FALSE on failure. 
If NDBM support is used, NDBM will actually create filename.dir and 
filename.pag files. GDBM only uses one file, as does the internal 
flat-file support, and Berkeley DB creates a filename.db file. Note that 
PHP does its own file locking in addition to any file locking that may be 
done by the DBM library itself. PHP does not delete the .lck files it 
creates. It uses these files simply as fixed inodes on which to do the 
file locking. For more information on DBM files, see your Unix man pages, 
or obtain GNU's GDBM. 
Note: When safe mode is enabled, PHP checks whether the files or 
directories you are about to operate on have the same UID (owner) as the 
script that is being executed.  dbmnextkeyUpdbmreplace
#

#T=resource dbmopen ( string filename, string flags)
dbmopen ( ^!string filename, string flags);
#

#T=dbmreplace - int dbmreplace ( resource dbm_identifier, string key, string value)
(PHP 3, PHP 4 )
dbmreplace --  Replaces the value for a key in a DBM database 
Description
int dbmreplace ( resource dbm_identifier, string key, string value)
Replaces the value for the specified key in the database. 
This will also add the key to the database if it didn't already exist.   dbmopenUpdbx functions
dbplus_add
(4.1.0 - 4.2.3 only)
dbplus_add -- Add a tuple to a relation
Description
int dbplus_add ( resource relation, array tuple)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

This function will add a tuple to a relation. The tuple data is an array 
of attribute/value pairs to be inserted into the given relation. After 
successful execution the tuple array will contain the complete data of the 
newly created tuple, including all implicitly set domain fields like 
sequences. 
The function will return zero (aka. DBPLUS_ERR_NOERR) on success or a db++ 
error code on failure. See dbplus_errcode() or the introduction to this 
chapter for more information on db++ error codes.   DB++ FunctionsUpdbplus_aql
dbplus_aql
(4.1.0 - 4.2.3 only)
dbplus_aql -- Perform AQL query
Description
resource dbplus_aql ( string query [, string server [, string dbpath]])
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_aql() will execute an AQL query on the given server and dbpath. 
On success it will return a relation handle. The result data may be 
fetched from this relation by calling dbplus_next() and dbplus_current(). 
Other relation access functions will not work on a result relation. 
Further information on the AQL A... Query Language is provided in the 
original db++ manual.   dbplus_addUpdbplus_chdir
dbplus_chdir
(4.1.0 - 4.2.3 only)
dbplus_chdir -- Get/Set database virtual current directory
Description
string dbplus_chdir ( [string newdir])
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_chdir() will change the virtual current directory where relation 
files will be looked for by dbplus_open(). dbplus_chdir() will return the 
absolute path of the current directory. Calling dbplus_chdir() without 
giving any newdir may be used to query the current working directory.   dbplus_aqlUpdbplus_close
dbplus_close
(4.1.0 - 4.2.3 only)
dbplus_close -- Close a relation
Description
int dbplus_close ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Calling dbplus_close() will close a relation previously opened by 
dbplus_open().   dbplus_chdirUpdbplus_curr
dbplus_curr
(4.1.0 - 4.2.3 only)
dbplus_curr -- Get current tuple from relation
Description
int dbplus_curr ( resource relation, array tuple)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_curr() will read the data for the current tuple for the given 
relation and will pass it back as an associative array in tuple. 
The function will return zero (aka. DBPLUS_ERR_NOERR) on success or a db++ 
error code on failure. See dbplus_errcode() or the introduction to this 
chapter for more information on db++ error codes. 
See also dbplus_first(), dbplus_prev(), dbplus_next(), and dbplus_last().   dbplus_closeUpdbplus_errcode
dbplus_errcode
(4.1.0 - 4.2.3 only)
dbplus_errcode --  Get error string for given errorcode or last error 
Description
string dbplus_errcode ( int errno)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_errcode() returns a cleartext error string for the error code 
passed as errno of for the result code of the last db++ operation if no 
parameter is given.   dbplus_currUpdbplus_errno
dbplus_errno
(4.1.0 - 4.2.3 only)
dbplus_errno -- Get error code for last operation
Description
int dbplus_errno ( void )
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_errno() will return the error code returned by the last db++ 
operation. 
See also dbplus_errcode().   dbplus_errcodeUpdbplus_find
dbplus_find
(4.1.0 - 4.2.3 only)
dbplus_find -- Set a constraint on a relation
Description
int dbplus_find ( resource relation, array constraints, mixed tuple)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_find() will place a constraint on the given relation. Further calls 
to functions like dbplus_curr() or dbplus_next() will only return tuples 
matching the given constraints. 
Constraints are triplets of strings containing of a domain name, a 
comparison operator and a comparison value. The constraints parameter 
array may consist of a collection of string arrays, each of which contains 
a domain, an operator and a value, or of a single string array containing 
a multiple of three elements. 
The comparison operator may be one of the following strings: '==', '>', 
'>=', '<', '<=', '!=', '~' for a regular expression match and 'BAND' or 
'BOR' for bitwise operations. 
See also dbplus_unselect().   dbplus_errnoUpdbplus_first
dbplus_first
(4.1.0 - 4.2.3 only)
dbplus_first -- Get first tuple from relation
Description
int dbplus_first ( resource relation, array tuple)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_curr() will read the data for the first tuple for the given 
relation, make it the current tuple and pass it back as an associative 
array in tuple. 
The function will return zero (aka. DBPLUS_ERR_NOERR) on success or a db++ 
error code on failure. See dbplus_errcode() or the introduction to this 
chapter for more information on db++ error codes. 
See also dbplus_curr(), dbplus_prev(), dbplus_next(), and dbplus_last().   dbplus_findUpdbplus_flush
dbplus_flush
(4.1.0 - 4.2.3 only)
dbplus_flush -- Flush all changes made on a relation
Description
int dbplus_flush ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_flush() will write all changes applied to relation since the last 
flush to disk. 
The function will return zero (aka. DBPLUS_ERR_NOERR) on success or a db++ 
error code on failure. See dbplus_errcode() or the introduction to this 
chapter for more information on db++ error codes.   dbplus_firstUpdbplus_freealllocks
dbplus_freealllocks
(4.1.0 - 4.2.3 only)
dbplus_freealllocks -- Free all locks held by this client
Description
int dbplus_freealllocks ( void )
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_freealllocks() will free all tuple locks held by this client. 
See also dbplus_getlock(), dbplus_freelock(), and dbplus_freerlocks().   dbplus_flushUpdbplus_freelock
dbplus_freelock
(4.1.0 - 4.2.3 only)
dbplus_freelock -- Release write lock on tuple
Description
int dbplus_freelock ( resource relation, string tname)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_freelock() will release a write lock on the given tuple previously 
obtained by dbplus_getlock(). 
See also dbplus_getlock(), dbplus_freerlocks(), and dbplus_freealllocks(). 
  dbplus_freealllocksUpdbplus_freerlocks
dbplus_freerlocks
(4.1.0 - 4.2.3 only)
dbplus_freerlocks -- Free all tuple locks on given relation
Description
int dbplus_freerlocks ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_freerlocks() will free all tuple locks held on the given relation. 
See also dbplus_getlock(), dbplus_freelock(), and dbplus_freealllocks().   dbplus_freelockUpdbplus_getlock
dbplus_getlock
(4.1.0 - 4.2.3 only)
dbplus_getlock -- Get a write lock on a tuple
Description
int dbplus_getlock ( resource relation, string tname)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_getlock() will request a write lock on the specified tuple. It will 
return zero on success or a non-zero error code, especially 
DBPLUS_ERR_WLOCKED, on failure. 
See also dbplus_freelock(), dbplus_freerlocks(), and 
dbplus_freealllocks().   dbplus_freerlocksUpdbplus_getunique
dbplus_getunique
(4.1.0 - 4.2.3 only)
dbplus_getunique -- Get an id number unique to a relation
Description
int dbplus_getunique ( resource relation, int uniqueid)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_getunique() will obtain a number guaranteed to be unique for the 
given relation and will pass it back in the variable given as uniqueid. 
The function will return zero (aka. DBPLUS_ERR_NOERR) on success or a db++ 
error code on failure. See dbplus_errcode() or the introduction to this 
chapter for more information on db++ error codes.   dbplus_getlockUpdbplus_info
dbplus_info
(4.1.0 - 4.2.3 only)
dbplus_info -- ???
Description
int dbplus_info ( resource relation, string key, array )
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Not implemented yet.   dbplus_getuniqueUpdbplus_last
dbplus_last
(4.1.0 - 4.2.3 only)
dbplus_last -- Get last tuple from relation
Description
int dbplus_last ( resource relation, array tuple)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_curr() will read the data for the last tuple for the given 
relation, make it the current tuple and pass it back as an associative 
array in tuple. 
The function will return zero (aka. DBPLUS_ERR_NOERR) on success or a db++ 
error code on failure. See dbplus_errcode() or the introduction to this 
chapter for more information on db++ error codes. 
See also dbplus_first(), dbplus_curr(), dbplus_prev(), and dbplus_next().   dbplus_infoUpdbplus_lockrel
dbplus_lockrel
(no version information, might be only in CVS)
dbplus_lockrel -- Request write lock on relation
Description
int dbplus_lockrel ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_lockrel() will request a write lock on the given relation. Other 
clients may still query the relation, but can't alter it while it is 
locked.   dbplus_lastUpdbplus_next
dbplus_next
(4.1.0 - 4.2.3 only)
dbplus_next -- Get next tuple from relation
Description
int dbplus_next ( resource relation, array )
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_curr() will read the data for the next tuple for the given 
relation, will make it the current tuple and will pass it back as an 
associative array in tuple. 
The function will return zero (aka. DBPLUS_ERR_NOERR) on success or a db++ 
error code on failure. See dbplus_errcode() or the introduction to this 
chapter for more information on db++ error codes. 
See also dbplus_first(), dbplus_curr(), dbplus_prev(), and dbplus_last().   dbplus_lockrelUpdbplus_open
dbplus_open
(4.1.0 - 4.2.3 only)
dbplus_open -- Open relation file
Description
resource dbplus_open ( string name)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

The relation file name will be opened. name can be either a file name or a 
relative or absolute path name. This will be mapped in any case to an 
absolute relation file path on a specific host machine and server. 
On success a relation file resource (cursor) is returned which must be 
used in any subsequent commands referencing the relation. Failure leads to 
a zero return value, the actual error code may be asked for by calling 
dbplus_errno().   dbplus_nextUpdbplus_prev
dbplus_prev
(4.1.0 - 4.2.3 only)
dbplus_prev -- Get previous tuple from relation
Description
int dbplus_prev ( resource relation, array tuple)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_curr() will read the data for the next tuple for the given 
relation, will make it the current tuple and will pass it back as an 
associative array in tuple. 
The function will return zero (aka. DBPLUS_ERR_NOERR) on success or a db++ 
error code on failure. See dbplus_errcode() or the introduction to this 
chapter for more information on db++ error codes. 
See also dbplus_first(), dbplus_curr(), dbplus_next(), and dbplus_last().   dbplus_openUpdbplus_rchperm
dbplus_rchperm
(4.1.0 - 4.2.3 only)
dbplus_rchperm -- Change relation permissions
Description
int dbplus_rchperm ( resource relation, int mask, string user, string 
group)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_rchperm() will change access permissions as specified by mask, user 
and group. The values for these are operating system specific.   dbplus_prevUpdbplus_rcreate
dbplus_rcreate
(4.1.0 - 4.2.3 only)
dbplus_rcreate -- Creates a new DB++ relation
Description
resource dbplus_rcreate ( string name, mixed domlist [, bool overwrite])
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_rcreate() will create a new relation named name. An existing 
relation by the same name will only be overwritten if the relation is 
currently not in use and overwrite is set to TRUE. 
domlist should contain the domain specification for the new relation 
within an array of domain description strings. ( dbplus_rcreate() will 
also accept a string with space delimited domain description strings, but 
it is recommended to use an array). A domain description string consists 
of a domain name unique to this relation, a slash and a type specification 
character. See the db++ documentation, especially the dbcreate(1) manpage, 
for a description of available type specifiers and their meanings.   dbplus_rchpermUpdbplus_rcrtexact
dbplus_rcrtexact
(4.1.0 - 4.2.3 only)
dbplus_rcrtexact -- Creates an exact but empty copy of a relation 
including indices
Description
resource dbplus_rcrtexact ( string name, resource relation, bool 
overwrite)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_rcrtexact() will create an exact but empty copy of the given 
relation under a new name. An existing relation by the same name will only 
be overwritten if overwrite is TRUE and no other process is currently 
using the relation.   dbplus_rcreateUpdbplus_rcrtlike
dbplus_rcrtlike
(4.1.0 - 4.2.3 only)
dbplus_rcrtlike -- Creates an empty copy of a relation with default 
indices
Description
resource dbplus_rcrtlike ( string name, resource relation, int flag)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_rcrtexact() will create an empty copy of the given relation under a 
new name, but with default indices. An existing relation by the same name 
will only be overwritten if overwrite is TRUE and no other process is 
currently using the relation.   dbplus_rcrtexactUpdbplus_resolve
dbplus_resolve
(4.1.0 - 4.2.3 only)
dbplus_resolve -- Resolve host information for relation
Description
int dbplus_resolve ( string relation_name)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_resolve() will try to resolve the given relation_name and find out 
internal server id, real hostname and the database path on this host. The 
function will return an array containing these values under the keys 
'sid', 'host' and 'host_path' or FALSE on error. 
See also dbplus_tcl().   dbplus_rcrtlikeUpdbplus_restorepos
dbplus_restorepos
(4.1.0 - 4.2.3 only)
dbplus_restorepos -- ???
Description
int dbplus_restorepos ( resource relation, array tuple)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Not implemented yet.   dbplus_resolveUpdbplus_rkeys
dbplus_rkeys
(4.1.0 - 4.2.3 only)
dbplus_rkeys -- Specify new primary key for a relation
Description
resource dbplus_rkeys ( resource relation, mixed domlist)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_rkeys() will replace the current primary key for relation with the 
combination of domains specified by domlist. 
domlist may be passed as a single domain name string or as an array of 
domain names.   dbplus_restoreposUpdbplus_ropen
dbplus_ropen
(4.1.0 - 4.2.3 only)
dbplus_ropen -- Open relation file local
Description
resource dbplus_ropen ( string name)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_ropen() will open the relation file locally for quick access 
without any client/server overhead. Access is read only and only 
dbplus_current() and dbplus_next() may be applied to the returned 
relation.   dbplus_rkeysUpdbplus_rquery
dbplus_rquery
(4.1.0 - 4.2.3 only)
dbplus_rquery -- Perform local (raw) AQL query
Description
int dbplus_rquery ( string query, string dbpath)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_rquery() performs a local (raw) AQL query using an AQL interpreter 
embedded into the db++ client library. dbplus_rquery() is faster than 
dbplus_aql() but will work on local data only.   dbplus_ropenUpdbplus_rrename
dbplus_rrename
(4.1.0 - 4.2.3 only)
dbplus_rrename -- Rename a relation
Description
int dbplus_rrename ( resource relation, string name)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_rrename() will change the name of relation to name.   dbplus_rqueryUpdbplus_rsecindex
dbplus_rsecindex
(4.1.0 - 4.2.3 only)
dbplus_rsecindex --  Create a new secondary index for a relation 
Description
resource dbplus_rsecindex ( resource relation, mixed domlist, int type)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_rsecindex() will create a new secondary index for relation with 
consists of the domains specified by domlist and is of type type 
domlist may be passed as a single domain name string or as an array of 
domain names.   dbplus_rrenameUpdbplus_runlink
dbplus_runlink
(4.1.0 - 4.2.3 only)
dbplus_runlink -- Remove relation from filesystem
Description
int dbplus_runlink ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_unlink() will close and remove the relation.   dbplus_rsecindexUpdbplus_rzap
dbplus_rzap
(4.1.0 - 4.2.3 only)
dbplus_rzap -- Remove all tuples from relation
Description
int dbplus_rzap ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_rzap() will remove all tuples from relation.   dbplus_runlinkUpdbplus_savepos
dbplus_savepos
(4.1.0 - 4.2.3 only)
dbplus_savepos -- ???
Description
int dbplus_savepos ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Not implemented yet.   dbplus_rzapUpdbplus_setindex
dbplus_setindex
(4.1.0 - 4.2.3 only)
dbplus_setindex -- ???
Description
int dbplus_setindex ( resource relation, string idx_name)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Not implemented yet.   dbplus_saveposUpdbplus_setindexbynumber
dbplus_setindexbynumber
(4.1.0 - 4.2.3 only)
dbplus_setindexbynumber -- ???
Description
int dbplus_setindexbynumber ( resource relation, int idx_number)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Not implemented yet.   dbplus_setindexUpdbplus_sql
dbplus_sql
(4.1.0 - 4.2.3 only)
dbplus_sql -- Perform SQL query
Description
resource dbplus_sql ( string query, string server, string dbpath)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Not implemented yet.   dbplus_setindexbynumberUpdbplus_tcl
dbplus_tcl
(4.1.0 - 4.2.3 only)
dbplus_tcl -- Execute TCL code on server side
Description
int dbplus_tcl ( int sid, string script)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

A db++ server will prepare a TCL interpreter for each client connection. 
This interpreter will enable the server to execute TCL code provided by 
the client as a sort of stored procedures to improve the performance of 
database operations by avoiding client/server data transfers and context 
switches. 
dbplus_tcl() needs to pass the client connection id the TCL script code 
should be executed by. dbplus_resolve() will provide this connection id. 
The function will return whatever the TCL code returns or a TCL error 
message if the TCL code fails. 
See also dbplus_resolve().   dbplus_sqlUpdbplus_tremove
dbplus_tremove
(4.1.0 - 4.2.3 only)
dbplus_tremove -- Remove tuple and return new current tuple
Description
int dbplus_tremove ( resource relation, array tuple [, array current])
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_tremove() removes tuple from relation if it perfectly matches a 
tuple within the relation. current, if given, will contain the data of the 
new current tuple after calling dbplus_tremove().   dbplus_tclUpdbplus_undo
dbplus_undo
(4.1.0 - 4.2.3 only)
dbplus_undo -- ???
Description
int dbplus_undo ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Not implemented yet.   dbplus_tremoveUpdbplus_undoprepare
dbplus_undoprepare
(4.1.0 - 4.2.3 only)
dbplus_undoprepare -- ???
Description
int dbplus_undoprepare ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Not implemented yet.   dbplus_undoUpdbplus_unlockrel
dbplus_unlockrel
(4.1.0 - 4.2.3 only)
dbplus_unlockrel -- Give up write lock on relation
Description
int dbplus_unlockrel ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_unlockrel() will release a write lock previously obtained by 
dbplus_lockrel().   dbplus_undoprepareUpdbplus_unselect
dbplus_unselect
(4.1.0 - 4.2.3 only)
dbplus_unselect -- Remove a constraint from relation
Description
int dbplus_unselect ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Calling dbplus_unselect() will remove a constraint previously set by 
dbplus_find() on relation.   dbplus_unlockrelUpdbplus_update
dbplus_update
(4.1.0 - 4.2.3 only)
dbplus_update -- Update specified tuple in relation
Description
int dbplus_update ( resource relation, array old, array new)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_update() replaces the tuple given by old with the data from new if 
and only if old completely matches a tuple within relation.   dbplus_unselectUpdbplus_xlockrel
dbplus_xlockrel
(4.1.0 - 4.2.3 only)
dbplus_xlockrel -- Request exclusive lock on relation
Description
int dbplus_xlockrel ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_xlockrel() will request an exclusive lock on relation preventing 
even read access from other clients. 
See also dbplus_xunlockrel().   dbplus_updateUpdbplus_xunlockrel
dbplus_xunlockrel
(4.1.0 - 4.2.3 only)
dbplus_xunlockrel -- Free exclusive lock on relation
Description
int dbplus_xunlockrel ( resource relation)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

dbplus_xunlockrel() will release an exclusive lock on relation previously 
obtained by dbplus_xlockrel().   dbplus_xlockrelUpDirect IO functions
#

#T=int dbmreplace ( resource dbm_identifier, string key, string value)
dbmreplace ( ^!resource dbm_identifier, string key, string value);
#

#T=dbx_close - bool dbx_close ( object link_identifier)
(PHP 4 >= 4.0.6)
dbx_close -- Close an open connection/database
Description
bool dbx_close ( object link_identifier)
Returns TRUE on success or FALSE on failure. 
Example 1. dbx_close() example
  <?php
  $link = dbx_connect(DBX_MYSQL, "localhost", "db", "username", 
  "password")
      or die("Could not connect");

  echo "Connected successfully";
  dbx_close($link);
  ?> 
Note: Always refer to the module-specific documentation as well. 
See also dbx_connect().   dbx functionsUpdbx_compare
#

#T=bool dbx_close ( object link_identifier)
dbx_close ( ^!object link_identifier);
#

#T=dbx_compare - int dbx_compare ( array row_a, array row_b, string column_key [, int 
(PHP 4 >= 4.1.0)
dbx_compare -- Compare two rows for sorting purposes
Description
int dbx_compare ( array row_a, array row_b, string column_key [, int 
flags])
dbx_compare() returns 0 if the row_a[$column_key] is equal to 
row_b[$column_key], and 1 or -1 if the former is greater or is smaller 
than the latter one, respectively, or vice versa if the flag is set to 
DBX_CMP_DESC. dbx_compare() is a helper function for dbx_sort() to ease 
the make and use of the custom sorting function. 
The flags can be set to specify comparison direction: 
DBX_CMP_ASC - ascending order 
DBX_CMP_DESC - descending order 
and the preferred comparison type: 
DBX_CMP_NATIVE - no type conversion 
DBX_CMP_TEXT - compare items as strings 
DBX_CMP_NUMBER - compare items numerically 
One of the direction and one of the type constant can be combined with 
bitwise OR operator (|). The default value for the flags parameter is 
DBX_CMP_ASC | DBX_CMP_NATIVE. 
Example 1. dbx_compare() example
  <?php
  function user_re_order($a, $b) {
      $rv = dbx_compare($a, $b, "parentid", DBX_CMP_DESC);
      if (!$rv) {
	  $rv = dbx_compare($a, $b, "id", DBX_CMP_NUMBER);
      }
      return $rv;
  }

  $link   = dbx_connect(DBX_ODBC, "", "db", "username", 
  "password")
      or die("Could not connect");

  $result = dbx_query($link, "SELECT id, parentid, description 
  FROM table ORDER BY id");
      // data in $result is now ordered by id

  dbx_sort($result, "user_re_order");
      // date in $result is now ordered by parentid 
  (descending), then by id

  dbx_close($link);
  ?> 
See also dbx_sort().   dbx_closeUpdbx_connect
#

#T=int dbx_compare ( array row_a, array row_b, string column_key [, int 
dbx_compare ( ^!array row_a, array row_b, string column_key [, int ;
#

#T=dbx_connect - object dbx_connect ( mixed module, string host, string database, string 
(PHP 4 >= 4.0.6)
dbx_connect -- Open a connection/database
Description
object dbx_connect ( mixed module, string host, string database, string 
username, string password [, int persistent])
dbx_connect() returns an object on success, FALSE on error. If a 
connection has been made but the database could not be selected, the 
connection is closed and FALSE is returned. The persistent parameter can 
be set to DBX_PERSISTENT, if so, a persistent connection will be created. 
The module parameter can be either a string or a constant, though the 
latter form is preferred. The possible values are given below, but keep in 
mind that they only work if the module is actually loaded. 
DBX_MYSQL or "mysql" 
DBX_ODBC or "odbc" 
DBX_PGSQL or "pgsql" 
DBX_MSSQL or "mssql" 
DBX_FBSQL or "fbsql" (available from PHP 4.1.0) 
DBX_SYBASECT or "sybase_ct" (available from PHP 4.2.0) 
DBX_OCI8 or "oci8" (available from PHP 4.3.0) 
DBX_SQLITE or "sqlite" (CVS only) 
The host, database, username and password parameters are expected, but not 
always used depending on the connect functions for the abstracted module. 
The returned object has three properties: 
database
It is the name of the currently selected database. 
handle
It is a valid handle for the connected database, and as such it can be 
used in module-specific functions (if required). 
<?php
$link = dbx_connect(DBX_MYSQL, "localhost", "db", "username", 
"password");
mysql_close($link->handle); // dbx_close($link) would be better 
here
?> 

module
It is used internally by dbx only, and is actually the module number 
mentioned above. 
Example 1. dbx_connect() example
  <?php
  $link = dbx_connect(DBX_ODBC, "", "db", "username", 
  "password", DBX_PERSISTENT)
      or die("Could not connect");

  echo "Connected successfully";
  dbx_close($link);
  ?> 
Note: Always refer to the module-specific documentation as well. 
See also dbx_close().   dbx_compareUpdbx_error
#

#T=object dbx_connect ( mixed module, string host, string database, string 
dbx_connect ( ^!mixed module, string host, string database, string ;
#

#T=dbx_error - string dbx_error ( object link_identifier)
(PHP 4 >= 4.0.6)
dbx_error --  Report the error message of the latest function call in the 
module (not just in the connection) 
Description
string dbx_error ( object link_identifier)
dbx_error() returns a string containing the error message from the last 
function call of the abstracted module (e.g. mysql module). If there are 
multiple connections in the same module, just the last error is given. If 
there are connections on different modules, the latest error is returned 
for the module specified by the link_identifier parameter. 
Example 1. dbx_error() example
  <?php
  $link   = dbx_connect(DBX_MYSQL, "localhost", "db", 
  "username", "password")
      or die("Could not connect");

  $result = dbx_query($link, "select id from 
  non_existing_table");
  if ($result == 0) {
      echo dbx_error($link);
  }
  dbx_close($link);
  ?> 
Note: Always refer to the module-specific documentation as well. 
The error message for Microsoft SQL Server is actually the result of the 
mssql_get_last_message() function. 
The error message for Oracle (oci8) is not implemented (yet).   dbx_connectUpdbx_escape_string
#

#T=string dbx_error ( object link_identifier)
dbx_error ( ^!object link_identifier);
#

#T=dbx_escape_string - string dbx_escape_string ( object link_identifier, string text)
(PHP 4 >= 4.3.0)
dbx_escape_string --  Escape a string so it can safely be used in an 
sql-statement. 
Description
string dbx_escape_string ( object link_identifier, string text)
dbx_escape_string() returns the text, escaped where necessary (such as 
quotes, backslashes etc). It returns NULL on error. 
Example 1. dbx_escape_string() example
  <?php
  $link   = dbx_connect(DBX_MYSQL, "localhost", "db", 
  "username", "password")
      or die("Could not connect");

  $text = dbx_escape_string($link, "It\'s quoted and backslashed 
  (\\).");
  $result = dbx_query($link, "insert into tbl (txt) values ('" . 
  $text . "')");
  if ($result == 0) {
      echo dbx_error($link);
  }
  dbx_close($link);
  ?> 
See also dbx_query().   dbx_errorUpdbx_fetch_row
dbx_fetch_row
(no version information, might be only in CVS)
dbx_fetch_row -- Fetches rows from a query-result that had the 
DBX_RESULT_UNBUFFERED flag set
Description
object dbx_fetch_row ( object result_identifier)
dbx_fetch_row() returns a row on success, and 0 on failure (e.g. when no 
more rows are available). When the DBX_RESULT_UNBUFFERED is not set in the 
query, dbx_fetch_row() will fail as all rows have already been fetched 
into the results data property. 
As a side effect, the rows property of the query-result object is 
incremented for each successful call to dbx_fetch_row(). 
Example 1. How to handle the returned value
  <?php
  $result = dbx_query($link, 'SELECT id, parentid, description 
  FROM table', DBX_RESULT_UNBUFFERED);

  echo "<table>\n";
  while ($row = dbx_fetch_row($result)) {
      echo "<tr>\n";
      foreach ($row as $field) {
	  echo "<td>$field</td>";
      }
      echo "</tr>\n";
  }
  echo "</table>\n";
  ?> 
The result_identifier parameter is the result object returned by a call to 
dbx_query(). 
The returned array contains the same information as any row would have in 
the dbx_query result data property, including columns accessible by index 
or fieldname when the flags for dbx_guery were set that way. 
See also dbx_query().   dbx_escape_stringUpdbx_query
#

#T=string dbx_escape_string ( object link_identifier, string text)
dbx_escape_string ( ^!object link_identifier, string text);
#

#T=dbx_query - object dbx_query ( object link_identifier, string sql_statement [, int 
(PHP 4 >= 4.0.6)
dbx_query -- Send a query and fetch all results (if any)
Description
object dbx_query ( object link_identifier, string sql_statement [, int 
flags])
dbx_query() returns an object or 1 on success, and 0 on failure. The 
result object is returned only if the query given in sql_statement 
produces a result set (i.e. a SELECT query, even if the result set is 
empty). 
Example 1. How to handle the returned value
  <?php
  $link   = dbx_connect(DBX_ODBC, "", "db", "username", 
  "password")
      or die("Could not connect");

  $result = dbx_query($link, 'SELECT id, parentid, description 
  FROM table');

  if (is_object($result) ) {
      // ... do some stuff here, see detailed examples below ...
      // first, print out field names and types 
      // then, draw a table filled with the returned field 
values
  } else {
      exit("Query failed");
  }

  dbx_close($link);
  ?> 
The flags parameter is used to control the amount of information that is 
returned. It may be any combination of the following constants with the 
bitwise OR operator (|). The DBX_COLNAMES_* flags override the 
dbx.colnames_case setting from php.ini. 
DBX_RESULT_INDEX
It is always set, that is, the returned object has a data property which 
is a 2 dimensional array indexed numerically. For example, in the 
expression data[2][3] 2 stands for the row (or record) number and 3 
stands for the column (or field) number. The first row and column are 
indexed at 0. 
If DBX_RESULT_ASSOC is also specified, the returning object contains the 
information related to DBX_RESULT_INFO too, even if it was not 
specified. 
DBX_RESULT_INFO
It provides info about columns, such as field names and field types. 
DBX_RESULT_ASSOC
It effects that the field values can be accessed with the respective 
column names used as keys to the returned object's data property. 
Associated results are actually references to the numerically indexed 
data, so modifying data[0][0] causes that 
data[0]['field_name_for_first_column'] is modified as well. 
DBX_RESULT_UNBUFFERED (CVS only)
This flag will not create the data property, and the rows property will 
initially be 0. Use this flag for large datasets, and use 
dbx_fetch_row() to retrieve the results row by row. 
The dbx_fetch_row() function will return rows that are conformant to the 
flags set with this query. Incidentally, it will also update the rows 
each time it is called. 
DBX_COLNAMES_UNCHANGED (available from PHP 4.3.0)
The case of the returned column names will not be changed. 
DBX_COLNAMES_UPPERCASE (available from PHP 4.3.0)
The case of the returned column names will be changed to uppercase. 
DBX_COLNAMES_LOWERCASE (available from PHP 4.3.0)
The case of the returned column names will be changed to lowercase. 
Note that DBX_RESULT_INDEX is always used, regardless of the actual value 
of flags parameter. This means that only the following combinations are 
effective: 
DBX_RESULT_INDEX 
DBX_RESULT_INDEX | DBX_RESULT_INFO 
DBX_RESULT_INDEX | DBX_RESULT_INFO | DBX_RESULT_ASSOC - this is the 
default, if flags is not specified. 
The returned object has four or five properties depending on flags: 
handle
It is a valid handle for the connected database, and as such it can be 
used in module specific functions (if required). 
<?php
$result = dbx_query($link, "SELECT id FROM table");
mysql_field_len($result->handle, 0);
?> 

cols and rows
These contain the number of columns (or fields) and rows (or records) 
respectively. 
<?php
$result = dbx_query($link, 'SELECT id FROM table');
echo $result->rows; // number of records
echo $result->cols; // number of fields 
?> 

info (optional)
It is returned only if either DBX_RESULT_INFO or DBX_RESULT_ASSOC is 
specified in the flags parameter. It is a 2 dimensional array, that has 
two named rows (name and type) to retrieve column information. 
Example 2. lists each field's name and type
    <?php
    $result = dbx_query($link, 'SELECT id FROM table',
			 DBX_RESULT_INDEX | DBX_RESULT_INFO);

    for ($i = 0; $i < $result->cols; $i++ ) {
	echo $result->info['name'][$i] . "\n";
	echo $result->info['type'][$i] . "\n";  
    }
    ?> 
data
This property contains the actual resulting data, possibly associated 
with column names as well depending on flags. If DBX_RESULT_ASSOC is 
set, it is possible to use $result->data[2]["field_name"]. 
Example 3. outputs the content of data property into HTML table
    <?php
    $result = dbx_query($link, 'SELECT id, parentid, description 
    FROM table');

    echo "<table>\n";
    foreach ($result->data as $row) {
	echo "<tr>\n";
	foreach ($row as $field) {
	    echo "<td>$field</td>";
	}
	echo "</tr>\n";
    }
    echo "</table>\n";
    ?> 

Example 4. How to handle UNBUFFERED queries
    $result = dbx_query ($link, 'SELECT id, parentid, 
    description FROM table', DBX_RESULT_UNBUFFERED);

    echo "<table>\n";
    while ($row = dbx_fetch_row($result)) {
	echo "<tr>\n";
	foreach ($row as $field) {
	    echo "<td>$field</td>";
	}
	echo "</tr>\n";
    }
    echo "</table>\n"; 
Note: Always refer to the module-specific documentation as well. 
Column names for queries on an Oracle database are returned in 
lowercase. 
See also dbx_escape_string(), dbx_fetch_row() and dbx_connect().   dbx_fetch_rowUpdbx_sort
#

#T=object dbx_query ( object link_identifier, string sql_statement [, int 
dbx_query ( ^!object link_identifier, string sql_statement [, int ;
#

#T=dbx_sort - bool dbx_sort ( object result, string user_compare_function)
(PHP 4 >= 4.0.6)
dbx_sort --  Sort a result from a dbx_query by a custom sort function 
Description
bool dbx_sort ( object result, string user_compare_function)
Returns TRUE on success or FALSE on failure. 
Note: It is always better to use ORDER BY SQL clause instead of 
dbx_sort(), if possible. 
Example 1. dbx_sort() example
  <?php
  function user_re_order($a, $b) {
      $rv = dbx_compare($a, $b, "parentid", DBX_CMP_DESC);
      if (!$rv) {
	  $rv = dbx_compare($a, $b, "id", DBX_CMP_NUMBER);
      }
      return $rv;
  }

  $link   = dbx_connect(DBX_ODBC, "", "db", "username", 
  "password")
      or die("Could not connect");

  $result = dbx_query($link, "SELECT id, parentid, description 
  FROM tbl ORDER BY id");
      // data in $result is now ordered by id

  dbx_sort($result, "user_re_order");
      // data in $result is now ordered by parentid 
  (descending), then by id

  dbx_close($link);
  ?> 
See also dbx_compare().   dbx_queryUpDB++ Functions
#

#T=bool dbx_sort ( object result, string user_compare_function)
dbx_sort ( ^!object result, string user_compare_function);
#

#T=dcgettext - string dcgettext ( string domain, string message, int category)
(PHP 3>= 3.0.7, PHP 4 )
dcgettext -- Overrides the domain for a single lookup
Description
string dcgettext ( string domain, string message, int category)
This function allows you to override the current domain for a single 
message lookup. It also allows you to specify a category.   bindtextdomainUpdcngettext
#

#T=string dcgettext ( string domain, string message, int category)
dcgettext ( ^!string domain, string message, int category);
#

#T=dcngettext - string dcngettext ( string domain, string msgid1, string msgid2, int n, 
(PHP 4 >= 4.2.0)
dcngettext -- Plural version of dcgettext
Description
string dcngettext ( string domain, string msgid1, string msgid2, int n, 
int category)
Warning
This function is currently not documented; only the argument list is 
available.
  dcgettextUpdgettext
#

#T=string dcngettext ( string domain, string msgid1, string msgid2, int n, 
dcngettext ( ^!string domain, string msgid1, string msgid2, int n, ;
#

#T=deaggregate - void deaggregate ( object object [, string class_name])
(PHP 4 >= 4.2.0)
deaggregate --  Removes the aggregated methods and properties from an 
object 
Description
void deaggregate ( object object [, string class_name])
Removes the methods and properties from classes that were aggregated to an 
object. If the optional class_name parameters is passed, only those 
methods and properties defined in that class are removed, otherwise all 
aggregated methods and properties are eliminated. 
See also aggregate(), aggregate_methods(), aggregate_methods_by_list(), 
aggregate_methods_by_regexp(), aggregate_properties(), 
aggregate_properties_by_list(), aggregate_properties_by_regexp(), 
aggregate_info()   aggregation_infoUpOracle 8 functions
#

#T=void deaggregate ( object object [, string class_name])
deaggregate ( ^!object object [, string class_name]);
#

#T=debug_backtrace - array debug_backtrace ( void )
(PHP 4 >= 4.3.0)
debug_backtrace --  Generates a backtrace 
Description
array debug_backtrace ( void )
debug_backtrace() generates a PHP backtrace and returns this information 
as an associative array. The possible returned elements are listed in the 
following table: 
Table 1. Possible returned elements from debug_backtrace()
NameTypeDescription
functionstringThe current function name. See also __FUNCTION__. 
lineintegerThe current line number. See also __LINE__. 
filestringThe current file name. See also __FILE__. 
classstringThe current class name. See also __CLASS__ 
typestringThe current class type. 
argsarrayIf inside a function, this lists the functions arguments. 
If inside an included file, this lists the included file name(s). 

The following is a simple example. 
Example 1. debug_backtrace() example 
  // filename: a.php
  <?php

  function a_test($str) {

      echo "\nHi: $str";

      var_dump(debug_backtrace());
  }

  a_test('friend');
  ?>

  // filename: b.php
  <?php
  include_once '/tmp/a.php';
  ?> 

Results when executing /tmp/b.php: 
Hi: friend
array(2) {
[0]=>
array(4) {
["file"] => string(10) "/tmp/a.php"
["line"] => int(10)
["function"] => string(6) "a_test"
["args"]=>
array(1) {
[0] => &string(6) "friend"
}
}
[1]=>
array(4) {
["file"] => string(10) "/tmp/b.php"
["line"] => int(2)
["args"] => 
array(1) {
[0] => string(10) "/tmp/a.php"
}
["function"] => string(12) "include_once"
}
}
See also trigger_error() and debug_print_backtrace().   Error Handling and Logging FunctionsUpdebug_print_backtrace
#

#T=array debug_backtrace ( void )
debug_backtrace ( ^!void );
#

#T=debug_print_backtrace - void debug_print_backtrace ( void )
(PHP 5 CVS only)
debug_print_backtrace --  Prints a backtrace 
Description
void debug_print_backtrace ( void )
debug_print_backtrace() prints a PHP backtrace. 
Warning
This function is currently not documented; only the argument list is 
available.

See also debug_backtrace().   debug_backtraceUperror_log
#

#T=void debug_print_backtrace ( void )
debug_print_backtrace ( ^!void );
#

#T=debugger_off - int debugger_off ( void )
#
(PHP 3)
#T= - int debugger_off ( void )
debugger_off -- Disable internal PHP debugger (PHP 3)
Description
int debugger_off ( void )
Disables the internal PHP debugger. This function is only available in PHP 
3. 
For more information see the appendix on Debugging PHP.   closelogUpdebugger_on
#

#T=int debugger_off ( void )
debugger_off ( ^!void );
#

#T=debugger_on - int debugger_on ( string address)
#
(PHP 3)
#T= - int debugger_on ( string address)
debugger_on -- Enable internal PHP debugger (PHP 3)
Description
int debugger_on ( string address)
Enables the internal PHP debugger, connecting it to address. This function 
is only available in PHP 3. 
For more information see the appendix on Debugging PHP.   debugger_offUpdefine_syslog_variables
#

#T=int debugger_on ( string address)
debugger_on ( ^!string address);
#

#T=decbin - string decbin ( int number)
(PHP 3, PHP 4 )
decbin -- Decimal to binary
Description
string decbin ( int number)
Returns a string containing a binary representation of the given number 
argument. The largest number that can be converted is 4294967295 in 
decimal resulting to a string of 32 1's. 
Example 1. decbin() example
  <?php
  echo decbin(12) . "\n";
  echo decbin(26);
  ?> 

The above example will output: 
1100
11010
See also bindec(), decoct(), dechex() and base_convert().   coshUpdechex
#

#T=string decbin ( int number)
decbin ( ^!int number);
#

#T=dechex - string dechex ( int number)
(PHP 3, PHP 4 )
dechex -- Decimal to hexadecimal
Description
string dechex ( int number)
Returns a string containing a hexadecimal representation of the given 
number argument. The largest number that can be converted is 2147483647 in 
decimal resulting to "7fffffff". 
Example 1. dechex() example
  <?php
  echo dechex(10) . "\n";
  echo dechex(47);
  ?> 

The above example will output: 
a
2f
See also hexdec(), decbin(), decoct() and base_convert().   decbinUpdecoct
#

#T=string dechex ( int number)
dechex ( ^!int number);
#

#T=decoct - string decoct ( int number)
(PHP 3, PHP 4 )
decoct -- Decimal to octal
Description
string decoct ( int number)
Returns a string containing an octal representation of the given number 
argument. The largest number that can be converted is 2147483647 in 
decimal resulting to "17777777777". 
Example 1. decoct() example
  <?php
  echo decoct(15) . "\n";
  echo decoct(264);
  ?> 

The above example will output: 
17
410
See also octdec(), decbin(), dechex() and base_convert().   dechexUpdeg2rad
#

#T=string decoct ( int number)
decoct ( ^!int number);
#

#T=define_syslog_variables - void define_syslog_variables ( void )
(PHP 3, PHP 4 )
define_syslog_variables -- Initializes all syslog related constants
Description
void define_syslog_variables ( void )
Initializes all constants used in the syslog functions. 
See also openlog(), syslog() and closelog().   debugger_onUpdns_check_record
#

#T=void define_syslog_variables ( void )
define_syslog_variables ( ^!void );
#

#T=define - bool define ( string name, mixed value [, bool case_insensitive])
(PHP 3, PHP 4 )
define -- Defines a named constant.
Description
bool define ( string name, mixed value [, bool case_insensitive])
Defines a named constant. See the section on constants for more details. 
The name of the constant is given by name; the value is given by value. 
The optional third parameter case_insensitive is also available. If the 
value TRUE is given, then the constant will be defined case-insensitive. 
The default behaviour is case-sensitive; i.e. CONSTANT and Constant 
represent different values. 
Example 1. Defining Constants
  <?php
  define("CONSTANT", "Hello world.");
  echo CONSTANT; // outputs "Hello world."
  echo Constant; // outputs "Constant" and issues a notice.

  define("GREETING", "Hello you.", true);
  echo GREETING; // outputs "Hello you."
  echo Greeting; // outputs "Hello you."

  ?> 
Returns TRUE on success or FALSE on failure. 
See also defined(), constant() and the section on Constants.   constantUpdefined
#

#T=bool define ( string name, mixed value [, bool case_insensitive])
define ( ^!string name, mixed value [, bool case_insensitive]);
#

#T=defined - bool defined ( string name)
(PHP 3, PHP 4 )
defined --  Checks whether a given named constant exists 
Description
bool defined ( string name)
Returns TRUE if the named constant given by name has been defined, FALSE 
otherwise. 
Example 1. Checking Constants
  <?php
  /* Note the use of quotes, this is important.  This example is 
  checking 
  * if the string 'CONSTANT' is the name of a constant named 
  CONSTANT */
  if (defined('CONSTANT')) {
      echo CONSTANT;
  }
  ?> 
Note: If you want to see if a variable exists, use isset() as defined() 
only applies to constants. If you want to see if a function exists, use 
function_exists(). 
See also define(), constant(), get_defined_constants(), function_exists(), 
and the section on Constants.   defineUpdie
#

#T=bool defined ( string name)
defined ( ^!string name);
#

#T=deg2rad - float deg2rad ( float number)
(PHP 3>= 3.0.4, PHP 4 )
deg2rad --  Converts the number in degrees to the radian equivalent 
Description
float deg2rad ( float number)
This function converts number from degrees to the radian equivalent. 
Example 1. deg2rad() example
  <?php

  echo deg2rad(45); // 0.785398163397
  var_dump(deg2rad(45) === M_PI_4); // bool(true)

  ?> 
See also rad2deg().   decoctUpexp
delete
(no version information, might be only in CVS)
delete -- See unlink() or unset()
Description
void delete ( string file)
This is a dummy manual entry to satisfy those people who are looking for 
unlink() or unset() in the wrong place. 
See also: unlink() to delete files, unset() to delete variables.   copyUpdirname
#

#T=float deg2rad ( float number)
deg2rad ( ^!float number);
#

#T=dgettext - string dgettext ( string domain, string message)
(PHP 3>= 3.0.7, PHP 4 )
dgettext -- Override the current domain
Description
string dgettext ( string domain, string message)
The dgettext() function allows you to override the current domain for a 
single message lookup.   dcngettextUpdngettext
die
die -- Alias of exit()
Description
This function is an alias of exit().   definedUpeval
#

#T=string dgettext ( string domain, string message)
dgettext ( ^!string domain, string message);
#

#T=dio_close - void dio_close ( resource fd)
(PHP 4 >= 4.2.0)
dio_close -- Closes the file descriptor given by fd
Description
void dio_close ( resource fd)
The function dio_close() closes the file descriptor fd.   Direct IO functionsUpdio_fcntl
#

#T=void dio_close ( resource fd)
dio_close ( ^!resource fd);
#

#T=dio_fcntl - mixed dio_fcntl ( resource fd, int cmd [, mixed arg])
(PHP 4 >= 4.2.0)
dio_fcntl -- Performs a c library fcntl on fd
Description
mixed dio_fcntl ( resource fd, int cmd [, mixed arg])
The dio_fcntl() function performs the operation specified by cmd on the 
file descriptor fd. Some commands require additional arguments args to be 
supplied. 
arg is an associative array, when cmd is F_SETLK or F_SETLLW, with the 
following keys: 
"start" - offset where lock begins 
"length" - size of locked area. zero means to end of file 
"wenth" - Where l_start is relative to: can be SEEK_SET, SEEK_END and 
SEEK_CUR 
"type" - type of lock: can be F_RDLCK (read lock), F_WRLCK (write lock) 
or F_UNLCK (unlock) 
cmd can be one of the following operations: 
F_SETLK - Lock is set or cleared. If the lock is held by someone else 
dio_fcntl() returns -1. 
F_SETLKW - like F_SETLK, but in case the lock is held by someone else, 
dio_fcntl() waits until the lock is released. 
F_GETLK - dio_fcntl() returns an associative array (as described above) 
if someone else prevents lock. If there is no obstruction key "type" 
will set to F_UNLCK. 
F_DUPFD - finds the lowest numbered available file descriptor greater or 
equal than arg and returns them. 
F_SETFL - Sets the file descriptors flags to the value specified by arg, 
which can be O_APPEND,O_NONBLOCK or O_ASYNC. To use O_ASYNC you will 
need to use the PCNTL extension.   dio_closeUpdio_open
#

#T=mixed dio_fcntl ( resource fd, int cmd [, mixed arg])
dio_fcntl ( ^!resource fd, int cmd [, mixed arg]);
#

#T=dio_open - resource dio_open ( string filename, int flags [, int mode])
(PHP 4 >= 4.2.0)
dio_open --  Opens a new filename with specified permissions of flags and 
creation permissions of mode 
Description
resource dio_open ( string filename, int flags [, int mode])
dio_open() opens a file and returns a new file descriptor for it, or FALSE 
if any error occurred. If flags is O_CREAT, the optional third parameter 
mode will set the mode of the file (creation permissions). The flags 
parameter can be one of the following options: 
O_RDONLY - opens the file for read access.
O_WRONLY - opens the file for write access.
O_RDWR - opens the file for both reading and writing. 
The flags parameter can also include any combination of the following 
flags: 
O_CREAT - creates the file, if it doesn't already exist. 
O_EXCL - if both, O_CREAT and O_EXCL are set, dio_open() fails, if the 
file already exists. 
O_TRUNC - if the file exists, and its opened for write access, the file 
will be truncated to zero length. 
O_APPEND - write operations write data at the end of the file. 
O_NONBLOCK - sets non blocking mode.   dio_fcntlUpdio_read
#

#T=resource dio_open ( string filename, int flags [, int mode])
dio_open ( ^!string filename, int flags [, int mode]);
#

#T=dio_read - string dio_read ( resource fd [, int n])
(PHP 4 >= 4.2.0)
dio_read --  Reads n bytes from fd and returns them, if n is not 
specified, reads 1k block 
Description
string dio_read ( resource fd [, int n])
The function dio_read() reads and returns n bytes from file with 
descriptor fd. If n is not specified, dio_read() reads 1K sized block and 
returns them.   dio_openUpdio_seek
#

#T=string dio_read ( resource fd [, int n])
dio_read ( ^!resource fd [, int n]);
#

#T=dio_seek - int dio_seek ( resource fd, int pos, int whence)
(PHP 4 >= 4.2.0)
dio_seek -- Seeks to pos on fd from whence
Description
int dio_seek ( resource fd, int pos, int whence)
The function dio_seek() is used to change the file position of the file 
with descriptor fd. The parameter whence specifies how the position pos 
should be interpreted: 
SEEK_SET - specifies that pos is specified from the beginning of the 
file. 
SEEK_CUR - Specifies that pos is a count of characters from the current 
file position. This count may be positive or negative. 
SEEK_END - Specifies that pos is a count of characters from the end of 
the file. A negative count specifies a position within the current 
extent of the file; a positive count specifies a position past the 
current end. If you set the position past the current end, and actually 
write data, you will extend the file with zeros up to that position.   dio_readUpdio_stat
#

#T=int dio_seek ( resource fd, int pos, int whence)
dio_seek ( ^!resource fd, int pos, int whence);
#

#T=dio_stat - array dio_stat ( resource fd)
(PHP 4 >= 4.2.0)
dio_stat --  Gets stat information about the file descriptor fd 
Description
array dio_stat ( resource fd)
Function dio_stat() returns information about the file with file 
descriptor fd. dio_stat() returns an associative array with the following 
keys: 
"device" - device
"inode" - inode
"mode" - mode
"nlink" - number of hard links
"uid" - user id
"gid" - group id
"device_type" - device type (if inode device) 
"size" - total size in bytes
"blocksize" - blocksize
"blocks" - number of blocks allocated
"atime" - time of last access
"mtime" - time of last modification
"ctime" - time of last change
On error dio_stat() returns NULL.   dio_seekUpdio_tcsetattr
#

#T=array dio_stat ( resource fd)
dio_stat ( ^!resource fd);
#

#T=dio_tcsetattr - dio_tcsetattr ( resource fd, array options)
(PHP 4 >= 4.3.0)
dio_tcsetattr --  Sets terminal attributes and baud rate for a serial port 

Description
dio_tcsetattr ( resource fd, array options)
The function dio_tcsetattr() sets the terminal attributes and baud rate of 
the open resource. The currently available options are 
'baud' - baud rate of the port - can be 38400,19200,9600,4800,2400,1800, 
1200,600,300,200,150,134,110,75 or 50, default value is 9600. 
'bits' - data bits - can be 8,7,6 or 5. Default value is 8. 
'stop' - stop bits - can be 1 or 2. Default value is 1. 
'parity' - can be 0,1 or 2. Default value is 0. 
Example 1. Setting the baud rate on a serial port 
  <?php

  $fd = dio_open('/dev/ttyS0', O_RDWR | O_NOCTTY | O_NONBLOCK);

  dio_fcntl($fd, F_SETFL, O_SYNC);

  dio_tcsetattr($fd, array(
    'baud' => 9600,
    'bits' => 8,
    'stop'  => 1,
    'parity' => 0
  )); 

  while (1) {

    $data = dio_read($fd, 256);

    if ($data) {
	echo $data;
    }
  } 

  ?> 

  dio_statUpdio_truncate
#

#T=dio_tcsetattr ( resource fd, array options)
( resource ^!fd, array options);
#

#T=dio_truncate - bool dio_truncate ( resource fd, int offset)
(PHP 4 >= 4.2.0)
dio_truncate --  Truncates file descriptor fd to offset bytes 
Description
bool dio_truncate ( resource fd, int offset)
Function dio_truncate() causes the file referenced by fd to be truncated 
to at most offset bytes in size. If the file previously was larger than 
this size, the extra data is lost. If the file previously was shorter, it 
is unspecified whether the file is left unchanged or is extended. In the 
latter case the extended part reads as zero bytes. Returns TRUE on success 
or FALSE on failure..   dio_tcsetattrUpdio_write
#

#T=bool dio_truncate ( resource fd, int offset)
dio_truncate ( ^!resource fd, int offset);
#

#T=dio_write - int dio_write ( resource fd, string data [, int len])
(PHP 4 >= 4.2.0)
dio_write --  Writes data to fd with optional truncation at length 
Description
int dio_write ( resource fd, string data [, int len])
The function dio_write() writes up to len bytes from data to file fd. If 
len is not specified, dio_write() writes all data to the specified file. 
dio_write() returns the number of bytes written to fd.   dio_truncateUpDirectory functions
#

#T=int dio_write ( resource fd, string data [, int len])
dio_write ( ^!resource fd, string data [, int len]);
#

#T=dirname - string dirname ( string path)
(PHP 3, PHP 4 )
dirname -- Returns directory name component of path
Description
string dirname ( string path)
Given a string containing a path to a file, this function will return the 
name of the directory. 
On Windows, both slash (/) and backslash (\) are used as path separator 
character. In other environments, it is the forward slash (/).
Example 1. dirname() example
  <?php
  $path = "/etc/passwd";
  $file = dirname($path); // $file is set to "/etc"
  ?> 
Note: In PHP 4.0.3, dirname() was fixed to be POSIX-compliant. 
Essentially, this means that if there are no slashes in path , a dot 
('.') is returned, indicating the current directory. Otherwise, the 
returned string is path with any trailing /component removed. Note that 
this means that you will often get a slash or a dot back from dirname() 
in situations where the older functionality would have given you the 
empty string. 
See also basename(), pathinfo(), and realpath().   deleteUpdisk_free_space
#

#T=string dirname ( string path)
dirname ( ^!string path);
#

#T=disk_free_space - float disk_free_space ( string directory)
(PHP 4 >= 4.1.0)
disk_free_space -- Returns available space in directory
Description
float disk_free_space ( string directory)
Given a string containing a directory, this function will return the 
number of bytes available on the corresponding filesystem or disk 
partition. 
Example 1. disk_free_space() example
  <?php
  // $df contains the number of bytes available on "/"
  $df = disk_free_space("/");

  // On Windows:
  disk_free_space("C:");
  disk_free_space("D:");
  ?> 
Note: This function will not work on remote files as the file to be 
examined must be accessible via the servers filesystem.
See also disk_total_space()   dirnameUpdisk_total_space
#

#T=float disk_free_space ( string directory)
disk_free_space ( ^!string directory);
#

#T=disk_total_space - float disk_total_space ( string directory)
(PHP 4 >= 4.1.0)
disk_total_space -- Returns the total size of a directory
Description
float disk_total_space ( string directory)
Given a string containing a directory, this function will return the total 
number of bytes on the corresponding filesystem or disk partition. 
Example 1. disk_total_space() example
  <?php
  // $df contains the total number of bytes available on "/"
  $df = disk_total_space("/");

  // On Windows:
  disk_total_space("C:");
  disk_total_space("D:");
  ?> 
Note: This function will not work on remote files as the file to be 
examined must be accessible via the servers filesystem.
See also disk_free_space()   disk_free_spaceUpdiskfreespace
diskfreespace
diskfreespace -- Alias of disk_free_space()
Description
This function is an alias of disk_free_space().   disk_total_spaceUpfclose
#

#T=float disk_total_space ( string directory)
disk_total_space ( ^!string directory);
#

#T=dl - int dl ( string library)
(PHP 3, PHP 4 )
dl -- Loads a PHP extension at runtime
Description
int dl ( string library)
Loads the PHP extension given by the parameter library. The library 
parameter is only the filename of the extension to load which also depends 
on your platform. For example, the sockets extension (if compiled as a 
shared module, not the default!) would be called sockets.so on Unix 
platforms whereas it is called php_sockets.dll on the Windows platform. 
Returns TRUE on success or FALSE on failure. If the functionality of 
loading modules is not available (see Note) or has been disabled (either 
by turning it off enable_dl or by enabling safe mode in php.ini) an 
E_ERROR is emitted and execution is stopped. If dl() fails because the 
specified library couldn't be loaded, in addition to FALSE an E_WARNING 
message is emitted. 
Use extension_loaded() to test whether a given extension is already 
available or not. This works on both built-in extensions and dynamically 
loaded ones (either through php.ini or dl()). 
Example 1. dl() examples
  <?php
  // Example loading an extension based on OS
  if (!extension_loaded('sqlite')) {
      if (strtoupper(substr(PHP_OS, 0, 3) == 'WIN')) {
	  dl('php_sqlite.dll');
      } else {
	  dl('sqlite.so');
      }
  }

  // Or, the PHP_SHLIB_SUFFIX constant is available as of PHP 
  4.3.0
  if (!extension_loaded('sqlite')) {
      $prefix = (PHP_SHLIB_SUFFIX == 'dll') ? 'php_' : '';
      dl($prefix . 'sqlite.' . PHP_SHLIB_SUFFIX);
  }
  ?> 
The directory where the extension is loaded from depends on your platform: 

Windows - If not explicitly set in the php.ini, the extension is loaded 
from c:\php4\extensions\ by default. 
Unix - If not explicitly set in the php.ini, the default extension 
directory depends on 
whether PHP has been built with --enable-debug or not 
whether PHP has been built with (experimental) ZTS (Zend Thread Safety) 
support or not 
the current internal ZEND_MODULE_API_NO (Zend internal module API 
number, which is basically the date on which a major module API change 
happened, e.g. 20010901) 
Taking into account the above, the directory then defaults to 
<install-dir>/lib/php/extensions/ 
<debug-or-not>-<zts-or-not>-ZEND_MODULE_API_NO, e.g. 
/usr/local/php/lib/php/extensions/debug-non-zts-20010901 or 
/usr/local/php/lib/php/extensions/no-debug-zts-20010901. 
Note: dl() is not supported in multithreaded Web servers. Use the 
extensions statement in your php.ini when operating under such an 
environment. However, the CGI and CLI build are not affected ! 
Note: dl() is case sensitive on Unix platforms. 
Note: This function is disabled in safe mode.
See also Extension Loading Directives and extension_loaded().   assertUpextension_loaded
#

#T=int dl ( string library)
dl ( ^!string library);
#

#T=dngettext - string dngettext ( string domain, string msgid1, string msgid2, int n)
(PHP 4 >= 4.2.0)
dngettext -- Plural version of dgettext
Description
string dngettext ( string domain, string msgid1, string msgid2, int n)
Warning
This function is currently not documented; only the argument list is 
available.
  dgettextUpgettext
#

#T=string dngettext ( string domain, string msgid1, string msgid2, int n)
dngettext ( ^!string domain, string msgid1, string msgid2, int n);
#

#T=dns_check_record - int dns_check_record ( string host [, string type])
(PHP 5 CVS only)
dns_check_record -- Synonym for checkdnsrr()
Description
int dns_check_record ( string host [, string type])
Check DNS records corresponding to a given Internet host name or IP 
address   define_syslog_variablesUpdns_get_mx
#

#T=int dns_check_record ( string host [, string type])
dns_check_record ( ^!string host [, string type]);
#

#T=dns_get_mx - int dns_get_mx ( string hostname, array mxhosts [, array &weight])
(PHP 5 CVS only)
dns_get_mx -- Synonym for getmxrr()
Description
int dns_get_mx ( string hostname, array mxhosts [, array &weight])
Get MX records corresponding to a given Internet host name.   dns_check_recordUpdns_get_record
#

#T=int dns_get_mx ( string hostname, array mxhosts [, array &weight])
dns_get_mx ( ^!string hostname, array mxhosts [, array &weight]);
#

#T=dns_get_record - array dns_get_record ( string hostname [, int type [, array &authns, array 
(PHP 5 CVS only)
dns_get_record --  Fetch DNS Resource Records associated with a hostname 
Description
array dns_get_record ( string hostname [, int type [, array &authns, array 
&addtl]])
Note: This function is not implemented on Windows platforms. Try the 
PEAR class Net_DNS. 
This function returns an array of associative arrays. Each associative 
array contains at minimum the following keys: 
Table 1. Basic DNS attributes
AttributeMeaning
hostThe record in the DNS namespace to which the rest of the 
associated data refers. 
classdns_get_record() only returns Internet class records and as 
such this parameter will always return IN. 
typeString containing the record type. Additional attributes will 
also be contained in the resulting array dependant on the value of 
type. See table below. 
ttlTime To Live remaining for this record. This will not equal the 
record's original ttl, but will rather equal the original ttl minus 
whatever length of time has passed since the authoritative name 
server was queried. 

hostname should be a valid DNS hostname such as "www.example.com". Reverse 
lookups can be generated using in-addr.arpa notation, but gethostbyaddr() 
is more suitable for the majority of reverse lookups. 
By default, dns_get_record() will search for any resource records 
associated with hostname. To limit the query, specify the optional type 
parameter. type may be any one of the following: DNS_A, DNS_CNAME, 
DNS_HINFO, DNS_MX, DNS_NS, DNS_PTR, DNS_SOA, DNS_TXT, DNS_AAAA, DNS_SRV, 
DNS_NAPTR, DNS_ALL or DNS_ANY. The default is DNS_ANY. 
Note: Because of eccentricities in the performance of libresolv between 
platforms, DNS_ANY will not always return every record, the slower 
DNS_ALL will collect all records more reliably. 
The optional third and fourth arguments to this function, authns and addtl 
are passed by reference and, if given, will be populated with Resource 
Records for the Authoritative Name Servers, and any Additional Records 
respectively. See the example below. 
Table 2. Other keys in associative arrays dependant on 'type'
TypeExtra Columns
Aip: An IPv4 addresses in dotted decimal notation. 
MXpri: Priority of mail exchanger. Lower numbers indicate greater 
priority. target: FQDN of the mail exchanger. See also dns_get_mx(). 

CNAMEtarget: FQDN of location in DNS namespace to which the record 
is aliased. 
NStarget: FQDN of the name server which is authoritative for this 
hostname. 
PTRtarget: Location within the DNS namespace to which this record 
points. 
TXTtxt: Arbitrary string data associated with this record. 
HINFOcpu: IANA number designating the CPU of the machine referenced 
by this record. os: IANA number designating the Operating System on 
the machine referenced by this record. See IANA's Operating System 
Names for the meaning of these values. 
SOAmname: FQDN of the machine from which the resource records 
originated. rname: Email address of the administrative contain for 
this domain. serial: Serial # of this revision of the requested 
domain. refresh: Refresh interval (seconds) secondary name servers 
should use when updating remote copies of this domain. retry: Length 
of time (seconds) to wait after a failed refresh before making a 
second attempt. expire: Maximum length of time (seconds) a secondary 
DNS server should retain remote copies of the zone data without a 
successful refresh before discarding. minimum-ttl: Minimum length of 
time (seconds) a client can continue to use a DNS resolution before 
it should request a new resolution from the server. Can be 
overridden by individual resource records. 
AAAAipv6: IPv6 address 
SRVpri: (Priority) lowest priorities should be used first. weight: 
Ranking to weight which of commonly prioritized targets should be 
chosen at random. target and port: hostname and port where the 
requested service can be found. For additional information see: RFC 
2782 
NAPTRorder and pref: Equivalent to pri and weight above. flags, 
services, regex, and replacement: Parameters as defined by RFC 2915. 
Note: Per DNS standards, email addresses are given in user.host format 
(for example: hostmaster.example.com as opposed to 
hostmaster@example.com), be sure to check this value and modify if 
necessary before using it with a functions such as mail(). 
Example 1. Using dns_get_record()
  <?php
  $result = dns_get_record("php.net");
  print_r($result);
  ?> 

Produces output similar to the following: 
Array
(
[0] => Array
(
[host] => php.net
[type] => MX
[pri] => 5
[target] => pair2.php.net
[class] => IN
[ttl] => 6765
)

[1] => Array
(
[host] => php.net
[type] => A
[ip] => 64.246.30.37
[class] => IN
[ttl] => 8125
)

)
Since it's very common to want the IP address of a mail server once the MX 
record has been resolved, dns_get_record() also returns an array in addtl 
which contains associate records. authns is returned as well containing a 
list of authoritative name servers. 
Example 2. Using dns_get_record() and DNS_ANY
  <?php
  /* Request "ANY" record for php.net, 
     and create $authns and $addtl arrays
     containing list of name servers and
     any additional records which go with
     them */
  $result = dns_get_record("php.net", DNS_ANY, $authns, $addtl);
  echo "Result = ";
  print_r($result);
  echo "Auth NS = ";
  print_r($authns);
  echo "Additional = ";
  print_r($addtl);
  ?> 

Produces output similar to the following: 
Result = Array
(
[0] => Array
(
[host] => php.net
[type] => MX
[pri] => 5
[target] => pair2.php.net
[class] => IN
[ttl] => 6765
)

[1] => Array
(
[host] => php.net
[type] => A
[ip] => 64.246.30.37
[class] => IN
[ttl] => 8125
)

)
Auth NS = Array
(
[0] => Array
(
[host] => php.net
[type] => NS
[target] => remote1.easydns.com
[class] => IN
[ttl] => 10722
)

[1] => Array
(
[host] => php.net
[type] => NS
[target] => remote2.easydns.com
[class] => IN
[ttl] => 10722
)

[2] => Array
(
[host] => php.net
[type] => NS
[target] => ns1.easydns.com
[class] => IN
[ttl] => 10722
)

[3] => Array
(
[host] => php.net
[type] => NS
[target] => ns2.easydns.com
[class] => IN
[ttl] => 10722
)

)
Additional = Array
(
[0] => Array
(
[host] => pair2.php.net
[type] => A
[ip] => 216.92.131.5
[class] => IN
[ttl] => 6766
)

[1] => Array
(
[host] => remote1.easydns.com
[type] => A
[ip] => 64.39.29.212
[class] => IN
[ttl] => 100384
)

[2] => Array
(
[host] => remote2.easydns.com
[type] => A
[ip] => 212.100.224.80
[class] => IN
[ttl] => 81241
)

[3] => Array
(
[host] => ns1.easydns.com
[type] => A
[ip] => 216.220.40.243
[class] => IN
[ttl] => 81241
)

[4] => Array
(
[host] => ns2.easydns.com
[type] => A
[ip] => 216.220.40.244
[class] => IN
[ttl] => 81241
)

)
See also dns_get_mx(), and dns_check_record()   dns_get_mxUpfsockopen
DomAttribute->name
(no version information, might be only in CVS)
DomAttribute->name --  Returns name of attribute 
Description
bool DomAttribute->name ( void )
This function returns the name of the attribute. 
See also domattribute_value().   DOM XML functionsUpDomAttribute->specified
DomAttribute->specified
(no version information, might be only in CVS)
DomAttribute->specified --  Checks if attribute is specified 
Description
bool DomAttribute->specified ( void )
Check DOM standard for a detailed explanation.   DomAttribute->nameUpDomAttribute->value
DomAttribute->value
(no version information, might be only in CVS)
DomAttribute->value --  Returns value of attribute 
Description
bool DomAttribute->value ( void )
This function returns the value of the attribute. 
See also domattribute_name().   DomAttribute->specifiedUpDomDocument->add_root [deprecated]
DomDocument->add_root [deprecated]
(no version information, might be only in CVS)
DomDocument->add_root [deprecated] --  Adds a root node 
Description
resource DomDocument->add_root ( string name)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Adds a root element node to a dom document and returns the new node. The 
element name is given in the passed parameter. 
Example 1. Creating a simple HTML document header
  <?php
  $doc = domxml_new_doc("1.0");
  $root = $doc->add_root("HTML");
  $head = $root->new_child("HEAD", "");
  $head->new_child("TITLE", "Hier der Titel");
  echo htmlentities($doc->dump_mem());
  ?> 

  DomAttribute->valueUpDomDocument->create_attribute
DomDocument->create_attribute
(no version information, might be only in CVS)
DomDocument->create_attribute -- Create new attribute
Description
object DomDocument->create_attribute ( string name, string value)
This function returns a new instance of class DomAttribute. The name of 
the attribute is the value of the first parameter. The value of the 
attribute is the value of the second parameter. This node will not show up 
in the document unless it is inserted with e.g. domnode_append_child(). 
The return value is FALSE if an error occurred. 
See also domnode_append_child(), domdocument_create_element(), 
domdocument_create_text(), domdocument_create_cdata_section(), 
domdocument_create_processing_instruction(), 
domdocument_create_entity_reference(), and domnode_insert_before().   DomDocument->add_root 
  [deprecated]UpDomDocument->create_cdata_section
DomDocument->create_cdata_section
(no version information, might be only in CVS)
DomDocument->create_cdata_section -- Create new cdata node
Description
string DomDocument->create_cdata_section ( string content)
This function returns a new instance of class DomCData. The content of the 
cdata is the value of the passed parameter. This node will not show up in 
the document unless it is inserted with e.g. domnode_append_child(). 
The return value is FALSE if an error occurred. 
See also domnode_append_child(), domdocument_create_element(), 
domdocument_create_text(), domdocument_create_attribute(), 
domdocument_create_processing_instruction(), 
domdocument_create_entity_reference(), and domnode_insert_before().   DomDocument->create_attributeUpDomDocument->create_comment
DomDocument->create_comment
(no version information, might be only in CVS)
DomDocument->create_comment -- Create new comment node
Description
object DomDocument->create_comment ( string content)
This function returns a new instance of class DomComment. The content of 
the comment is the value of the passed parameter. This node will not show 
up in the document unless it is inserted with e.g. domnode_append_child(). 

The return value is FALSE if an error occurred. 
See also domnode_append_child(), domdocument_create_element(), 
domdocument_create_text(), domdocument_create_attribute(), 
domdocument_create_processing_instruction(), 
domdocument_create_entity_reference() and domnode_insert_before().   DomDocument->create_cdata_sectionUpDomDocument->create_element_ns
DomDocument->create_element
(no version information, might be only in CVS)
DomDocument->create_element -- Create new element node
Description
object DomDocument->create_element ( string name)
This function returns a new instance of class DomElement. The tag name of 
the element is the value of the passed parameter. This node will not show 
up in the document unless it is inserted with e.g. domnode_append_child(). 

The return value is FALSE if an error occurred. 
See also domdocument_create_element_ns(), domnode_append_child(), 
domdocument_create_text(), domdocument_create_comment(), 
domdocument_create_attribute(), 
domdocument_create_processing_instruction(), 
domdocument_create_entity_reference(), and domnode_insert_before().   DomDocument->create_element_nsUpDomDocument->create_entity_reference
DomDocument->create_element_ns
(no version information, might be only in CVS)
DomDocument->create_element_ns --  Create new element node with an 
associated namespace 
Description
object DomDocument->create_element_ns ( string uri, string name [, string 
prefix])
This function returns a new instance of class DomElement. The tag name of 
the element is the value of the passed parameter name. The URI of the 
namespace is the value of the passed parameter uri. If there is already a 
namespace declaration with the same uri in the root-node of the document, 
the prefix of this is taken, otherwise it will take the one provided in 
the optional parameter prefix or generate a random one. This node will not 
show up in the document unless it is inserted with e.g. 
domnode_append_child(). 
The return value is FALSE if an error occurred. 
See also domdocument_create_element_ns(), domnode_add_namespace(), 
domnode_set_namespace(), domnode_append_child(), 
domdocument_create_text(), domdocument_create_comment(), 
domdocument_create_attribute(), 
domdocument_create_processing_instruction(), 
domdocument_create_entity_reference(), and domnode_insert_before().   DomDocument->create_commentUpDomDocument->create_element
DomDocument->create_entity_reference
(no version information, might be only in CVS)
DomDocument->create_entity_reference --  
Description
object DomDocument->create_entity_reference ( string content)
This function returns a new instance of class DomEntityReference. The 
content of the entity reference is the value of the passed parameter. This 
node will not show up in the document unless it is inserted with e.g. 
domnode_append_child(). 
The return value is FALSE if an error occurred. 
See also domnode_append_child(), domdocument_create_element(), 
domdocument_create_text(), domdocument_create_cdata_section(), 
domdocument_create_processing_instruction(), 
domdocument_create_attribute(), and domnode_insert_before().   DomDocument->create_elementUpDomDocument->create_processing_instruction
DomDocument->create_processing_instruction
(no version information, might be only in CVS)
DomDocument->create_processing_instruction -- Creates new PI node
Description
string DomDocument->create_processing_instruction ( string content)
This function returns a new instance of class DomCData. The content of the 
pi is the value of the passed parameter. This node will not show up in the 
document unless it is inserted with e.g. domnode_append_child(). 
The return value is FALSE if an error occurred. 
See also domnode_append_child(), domdocument_create_element(), 
domdocument_create_text(), domdocument_create_cdata_section(), 
domdocument_create_attribute(), domdocument_create_entity_reference(), and 
domnode_insert_before().   DomDocument->create_entity_referenceUpDomDocument->create_text_node
DomDocument->create_text_node
(no version information, might be only in CVS)
DomDocument->create_text_node -- Create new text node
Description
object DomDocument->create_text_node ( string content)
This function returns a new instance of class DomText. The content of the 
text is the value of the passed parameter. This node will not show up in 
the document unless it is inserted with e.g. domnode_append_child(). 
The return value is FALSE if an error occurred. 
See also domnode_append_child(), domdocument_create_element(), 
domdocument_create_comment(), domdocument_create_text(), 
domdocument_create_attribute(), 
domdocument_create_processing_instruction(), 
domdocument_create_entity_reference(), and domnode_insert_before().   DomDocument->create_processing_instructionUpDomDocument->doctype
DomDocument->doctype
(no version information, might be only in CVS)
DomDocument->doctype --  Returns the document type 
Description
object DomDocument->doctype ( void )
This function returns an object of class DomDocumentType. In versions of 
PHP before 4.3 this has been the class Dtd, but the DOM Standard does not 
know such a class. 
See also the methods of class DomDocumentType.   DomDocument->create_text_nodeUpDomDocument->document_element
DomDocument->document_element
(no version information, might be only in CVS)
DomDocument->document_element --  Returns root element node 
Description
object DomDocument->document_element ( void )
This function returns the root element node of a document. 
The following example returns just the element with name CHAPTER and 
prints it. The other node -- the comment -- is not returned. Example 
1. Retrieving root element
  <?php
  include("example.inc");

  if (!$dom = domxml_open_mem($xmlstr)) {
    echo "Error while parsing the document\n";
    exit;
  }

  $root = $dom->document_element();
  print_r($root);
  ?> 

  DomDocument->doctypeUpDomDocument->dump_file
DomDocument->dump_file
(no version information, might be only in CVS)
DomDocument->dump_file --  Dumps the internal XML tree back into a file 
Description
string DomDocument->dump_file ( string filename [, bool compressionmode [, 
bool format]])
Creates an XML document from the dom representation. This function usually 
is called after building a new dom document from scratch as in the example 
below. The format specifies whether the output should be neatly formatted, 
or not. The first parameter specifies the name of the filename and the 
second parameter, whether it should be compressed or not. 
Example 1. Creating a simple HTML document header
  <?php
  $doc = domxml_new_doc("1.0");
  $root = $doc->create_element("HTML");
  $root = $doc->append_child($root);
  $head = $doc->create_element("HEAD");
  $head = $root->append_child($head);
  $title = $doc->create_element("TITLE");
  $title = $head->append_child($title);
  $text = $doc->create_text_node("This is the title");
  $text = $title->append_child($text);
  $doc->dump_file("/tmp/test.xml", false, true);
  ?> 
See also domdocument_dump_mem() domdocument_html_dump_mem().   DomDocument->document_elementUpDomDocument->dump_mem
DomDocument->dump_mem
(no version information, might be only in CVS)
DomDocument->dump_mem --  Dumps the internal XML tree back into a string 
Description
string DomDocument->dump_mem ( [bool format [, string encoding]])
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Creates an XML document from the dom representation. This function usually 
is called after building a new dom document from scratch as in the example 
below. The format specifies whether the output should be neatly formatted, 
or not. 
Example 1. Creating a simple HTML document header
  <?php
  $doc = domxml_new_doc("1.0");
  $root = $doc->create_element("HTML");
  $root = $doc->append_child($root);
  $head = $doc->create_element("HEAD");
  $head = $root->append_child($head);
  $title = $doc->create_element("TITLE");
  $title = $head->append_child($title);
  $text = $doc->create_text_node("This is the title");
  $text = $title->append_child($text);
  echo "<PRE>";
  echo htmlentities($doc->dump_mem(true));
  echo "</PRE>";
  ?> 
Note: The first parameter was added in PHP 4.3.0. 
See also domdocument_dump_file(), domdocument_html_dump_mem().   DomDocument->dump_fileUpDomDocument->get_element_by_id
DomDocument->get_element_by_id
(no version information, might be only in CVS)
DomDocument->get_element_by_id --  Searches for an element with a certain 
id 
Description
object DomDocument->get_element_by_id ( string id)
This function is similar to domdocument_get_elements_by_tagname() but 
searches for an element with a given id. According to the DOM standard 
this requires a DTD which defines the attribute ID to be of type ID, 
though the current implementation simply does an xpath search for "//*[@ID 
= '%s']". This does not comply to the DOM standard which requires to 
return null if it is not known which attribute is of type id. This 
behaviour is likely to be fixed, so do not rely on the current behaviour. 
See also domdocument_get_elements_by_tagname()   DomDocument->dump_memUpDomDocument->get_elements_by_tagname
DomDocument->get_elements_by_tagname
(no version information, might be only in CVS)
DomDocument->get_elements_by_tagname --  
Description
array DomDocument->get_elements_by_tagname ( string name)
See also domdocument_add_root()   DomDocument->get_element_by_idUpDomDocument->html_dump_mem
DomDocument->html_dump_mem
(no version information, might be only in CVS)
DomDocument->html_dump_mem --  Dumps the internal XML tree back into a 
string as HTML 
Description
string DomDocument->html_dump_mem ( void )
Creates an HTML document from the dom representation. This function 
usually is called after building a new dom document from scratch as in the 
example below. 
Example 1. Creating a simple HTML document header
  <?php
  $doc = domxml_new_doc("1.0");
  $root = $doc->create_element("HTML");
  $root = $doc->append_child($root);
  $head = $doc->create_element("HEAD");
  $head = $root->append_child($head);
  $title = $doc->create_element("TITLE");
  $title = $head->append_child($title);
  $text = $doc->create_text_node("This is the title");
  $text = $title->append_child($text);
  echo "<PRE>";
  echo htmlentities($doc->html_dump_mem());
  echo "</PRE>";
  ?> 
See also domdocument_dump_file(), domdocument_html_dump_mem().   DomDocument->get_elements_by_tagnameUpDomDocument->xinclude
DomDocument->xinclude
(no version information, might be only in CVS)
DomDocument->xinclude --  Substitutes XIncludes in a DomDocument Object. 
Description
int DomDocument->xinclude ( void )
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Warning
This function is currently not documented; only the argument list is 
available.
  DomDocument->html_dump_memUpDomDocumentType->entities
DomDocumentType->entities
(no version information, might be only in CVS)
DomDocumentType->entities --  Returns list of entities 
Description
array DomDocumentType->entities ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  DomDocument->xincludeUpDomDocumentType->internal_subset
DomDocumentType->internal_subset
(no version information, might be only in CVS)
DomDocumentType->internal_subset --  Returns internal subset 
Description
bool DomDocumentType->internal_subset ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  DomDocumentType->entitiesUpDomDocumentType->name
DomDocumentType->name
(no version information, might be only in CVS)
DomDocumentType->name --  Returns name of document type 
Description
string DomDocumentType->name ( void )
This function returns the name of the document type.   DomDocumentType->internal_subsetUpDomDocumentType->notations
DomDocumentType->notations
(no version information, might be only in CVS)
DomDocumentType->notations --  Returns list of notations 
Description
array DomDocumentType->notations ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  DomDocumentType->nameUpDomDocumentType->public_id
DomDocumentType->public_id
(no version information, might be only in CVS)
DomDocumentType->public_id --  Returns public id of document type 
Description
string DomDocumentType->public_id ( void )
This function returns the public id of the document type. 
The following example echos nothing. Example 1. Retrieving the 
public id
  <?php
  include("example.inc");

  if (!$dom = domxml_open_mem($xmlstr)) {
    echo "Error while parsing the document\n";
    exit;
  }

  $doctype = $dom->doctype();
  echo $doctype->public_id();
  ?> 

  DomDocumentType->notationsUpDomDocumentType->system_id
DomDocumentType->system_id
(no version information, might be only in CVS)
DomDocumentType->system_id --  Returns system id of document type 
Description
string DomDocumentType->system_id ( void )
Returns the system id of the document type. 
The following example echos 
'/share/sgml/Norman_Walsh/db3xml10/db3xml10.dtd'. Example 1. 
Retrieving the system id
  <?php
  include("example.inc");

  if (!$dom = domxml_open_mem($xmlstr)) {
    echo "Error while parsing the document\n";
    exit;
  }

  $doctype = $dom->doctype();
  echo $doctype->system_id();
  ?> 

  DomDocumentType->public_idUpDomElement->get_attribute_node
DomElement->get_attribute_node
(no version information, might be only in CVS)
DomElement->get_attribute_node --  Returns value of attribute 
Description
object DomElement->get_attribute_node ( object attr)
Warning
This function is currently not documented; only the argument list is 
available.
  DomDocumentType->system_idUpDomElement->get_attribute
DomElement->get_attribute
(no version information, might be only in CVS)
DomElement->get_attribute --  Returns value of attribute 
Description
object DomElement->get_attribute ( string name)
#

#T=array dns_get_record ( string hostname [, int type [, array &authns, array 
dns_get_record ( ^!string hostname [, int type [, array &authns, array ;
#

#T=Returns the attribute with name name of the current node.  - bool DomElement->get_elements_by_tagname ( string name)
(PHP >= 4.3 only) If no attribute with given name is found, an empty 
string is returned. 
See also domelement_set_attribute()   DomElement->get_attribute_nodeUpDomElement->get_elements_by_tagname
DomElement->get_elements_by_tagname
(no version information, might be only in CVS)
DomElement->get_elements_by_tagname --  Gets elements by tagname 
Description
bool DomElement->get_elements_by_tagname ( string name)
This function returns an array with all the elements which has name as his 
tagname. Every element of the array is an DomElement. 
Example 1. Getting a content
  <?php
  if (!$dom = domxml_open_mem($xmlstr)) {
    echo "Error while parsing the document\n";
    exit;
  }

  $root = $dom->document_element();

  $node_array = $root->get_elements_by_tagname("element");

  for ($i = 0; $i<count($node_array); $i++) {
      $node = $node_array[$i];
      echo "The element[$i] is: " . $node->get_content();
  }

  ?> 

  DomElement->get_attributeUpDomElement->has_attribute
DomElement->has_attribute
(no version information, might be only in CVS)
DomElement->has_attribute --  Checks to see if attribute exists 
Description
bool DomElement->has_attribute ( string name)
Warning
This function is currently not documented; only the argument list is 
available.
  DomElement->get_elements_by_tagnameUpDomElement->remove_attribute
DomElement->remove_attribute
(no version information, might be only in CVS)
DomElement->remove_attribute --  Removes attribute 
Description
bool DomElement->remove_attribute ( string name)
Warning
This function is currently not documented; only the argument list is 
available.
  DomElement->has_attributeUpDomElement->set_attribute
DomElement->set_attribute
(no version information, might be only in CVS)
DomElement->set_attribute --  Adds new attribute 
Description
bool DomElement->set_attribute ( string name, string value)
Sets an attribute with name name to the given value. If the attribute does 
not exist, it will be created. 
Example 1. Setting an attribute
  <?php
  $doc = domxml_new_doc("1.0");
  $node = $doc->create_element("para");
  $newnode = $doc->append_child($node);
  $newnode->set_attribute("align", "left");
  ?> 
See also domelement_get_attribute()   DomElement->remove_attributeUpDomElement->tagname
DomElement->tagname
(no version information, might be only in CVS)
DomElement->tagname --  Returns name of element 
Description
string DomElement->tagname ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  DomElement->set_attributeUpDomNode->add_namespace
DomNode->add_namespace
(no version information, might be only in CVS)
DomNode->add_namespace --  Adds a namespace declaration to a node. 
Description
bool DomNode->add_namespace ( string uri, string prefix)
See also domdocument_create_element_ns(), domnode_set_namespace()   DomElement->tagnameUpDomNode->append_child
DomNode->append_child
(no version information, might be only in CVS)
DomNode->append_child --  Adds new child at the end of the children 
Description
object DomNode->append_child ( object newnode)
This functions appends a child to an existing list of children or creates 
a new list of children. The child can be created with e.g. 
domdocument_create_element(), domdocument_create_text() etc. or simply by 
#

#T=bool DomElement->get_elements_by_tagname ( string name)
DomElement->^!get_elements_by_tagname ( string name);
#

#T=using any other node.  - object DomNode->append_sibling ( object newnode)
(PHP < 4.3) Before a new child is appended it is first duplicated. 
Therefore the new child is a completely new copy which can be modified 
without changing the node which was passed to this function. If the node 
passed has children itself, they will be duplicated as well, which makes 
it quite easy to duplicate large parts of an XML document. The return 
value is the appended child. If you plan to do further modifications on 
#

#T=the appended child you must use the returned node.  - object DomNode->append_sibling ( object newnode)
(PHP 4.3.0/4.3.1) The new child newnode is first unlinked from its 
existing context, if it's already a child of DomNode. Therefore the node 
#

#T=is moved and not copies anymore.  - object DomNode->append_sibling ( object newnode)
(PHP >= 4.3.2) The new child newnode is first unlinked from its existing 
context, if it's already in the tree. Therefore the node is moved and not 
copied. This is the behaviour according to the W3C specifications. If you 
want to duplicate large parts of an XML document, use 
DomNode->clone_node() before appending. 
The following example will add a new element node to a fresh document and 
sets the attribute "align" to "left". Example 1. Adding a child
  <?php
  $doc = domxml_new_doc("1.0");
  $node = $doc->create_element("para");
  $newnode = $doc->append_child($node);
  $newnode->set_attribute("align", "left");
  ?> 

The above example could also be written as the following: Example 2. 
Adding a child
  <?php
  $doc = domxml_new_doc("1.0");
  $node = $doc->create_element("para");
  $node->set_attribute("align", "left");
  $newnode = $doc->append_child($node);
  ?> 

A more complex example is the one below. It first searches for a certain 
element, duplicates it including its children and adds it as a sibling. 
Finally a new attribute is added to one of the children of the new sibling 
and the whole document is dumped. Example 3. Adding a child
  <?php
  include("example.inc");

  if (!$dom = domxml_open_mem($xmlstr)) {
    echo "Error while parsing the document\n";
    exit;
  }

  $elements = $dom->get_elements_by_tagname("informaltable");
  print_r($elements);
  $element = $elements[0];

  $parent = $element->parent_node();
  $newnode = $parent->append_child($element);
  $children = $newnode->children();
  $attr = $children[1]->set_attribute("align", "left");

  echo "<pre>";
  $xmlfile = $dom->dump_mem();
  echo htmlentities($xmlfile);
  echo "</pre>";
  ?> 

The above example could also be done with domnode_insert_before() instead 
of domnode_append_child(). 
See also domnode_insert_before(), domnode_clone_node().   DomNode->add_namespaceUpDomNode->append_sibling
DomNode->append_sibling
(no version information, might be only in CVS)
DomNode->append_sibling --  Adds new sibling to a node 
Description
object DomNode->append_sibling ( object newnode)
This functions appends a sibling to an existing node. The child can be 
created with e.g. domdocument_create_element(), domdocument_create_text() 
etc. or simply by using any other node. 
Before a new sibling is added it is first duplicated. Therefore the new 
child is a completely new copy which can be modified without changing the 
node which was passed to this function. If the node passed has children 
itself, they will be duplicated as well, which makes it quite easy to 
duplicate large parts of an XML document. The return value is the added 
sibling. If you plan to do further modifications on the added sibling you 
must use the returned node. 
This function has been added to provide the behaviour of 
domnode_append_child() as it works till PHP 4.2. 
See also domnode_append_before().   DomNode->append_childUpDomNode->attributes
DomNode->attributes
(no version information, might be only in CVS)
DomNode->attributes --  Returns list of attributes 
Description
array DomNode->attributes ( void )
This function only returns an array of attributes if the node is of type 
#

#T=object DomNode->append_sibling ( object newnode)
DomNode->^!append_sibling ( object newnode);
#

#T=XML_ELEMENT_NODE.  - array DomNode->child_nodes ( void )
(PHP >= 4.3 only) If no attributes are found, NULL is returned.   DomNode->append_siblingUpDomNode->child_nodes
DomNode->child_nodes
(no version information, might be only in CVS)
DomNode->child_nodes --  Returns children of node 
Description
array DomNode->child_nodes ( void )
Returns all children of the node. 
See also domnode_next_sibling(), domnode_previous_sibling().   DomNode->attributesUpDomNode->clone_node
DomNode->clone_node
(no version information, might be only in CVS)
DomNode->clone_node --  Clones a node 
Description
object DomNode->clone_node ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  DomNode->child_nodesUpDomNode->dump_node
DomNode->dump_node
(no version information, might be only in CVS)
DomNode->dump_node --  Dumps a single node 
Description
string DomNode->dump_node ( void )
Warning
This function is currently not documented; only the argument list is 
available.

See also domdocument_dump_mem().   DomNode->clone_nodeUpDomNode->first_child
DomNode->first_child
(no version information, might be only in CVS)
DomNode->first_child --  Returns first child of node 
Description
object DomNode->first_child ( void )
#

#T=array DomNode->child_nodes ( void )
DomNode->^!child_nodes ( void );
#

#T=Returns the first child of the node.  - string DomNode->get_content ( void )
(PHP >= 4.3 only) If no first child is found, NULL is returned. 
See also domnode_last_child(), domnode_next_sibling(), 
domnode_previous_sibling().   DomNode->dump_nodeUpDomNode->get_content
DomNode->get_content
(no version information, might be only in CVS)
DomNode->get_content --  Gets content of node 
Description
string DomNode->get_content ( void )
This function returns the content of the actual node. 
Example 1. Getting a content
  <?php
  if (!$dom = domxml_open_mem($xmlstr)) {
    echo "Error while parsing the document\n";
    exit;
  }

  $root = $dom->document_element();

  $node_array = $root->get_elements_by_tagname("element");

  for ($i = 0; $i<count($node_array); $i++) {
      $node = $node_array[$i];
      echo "The element[$i] is: " . $node->get_content();
  }

  ?> 

  DomNode->first_childUpDomNode->has_attributes
DomNode->has_attributes
(no version information, might be only in CVS)
DomNode->has_attributes --  Checks if node has attributes 
Description
bool DomNode->has_attributes ( void )
This function checks if the node has attributes. 
See also domnode_has_child_nodes().   DomNode->get_contentUpDomNode->has_child_nodes
DomNode->has_child_nodes
(no version information, might be only in CVS)
DomNode->has_child_nodes --  Checks if node has children 
Description
bool DomNode->has_child_nodes ( void )
This function checks if the node has children. 
See also domnode_child_nodes().   DomNode->has_attributesUpDomNode->insert_before
DomNode->insert_before
(no version information, might be only in CVS)
DomNode->insert_before --  Inserts new node as child 
Description
object DomNode->insert_before ( object newnode, object refnode)
This function inserts the new node newnode right before the node refnode. 
The return value is the inserted node. If you plan to do further 
#

#T=string DomNode->get_content ( void )
DomNode->^!get_content ( void );
#

#T=modifications on the appended child you must use the returned node.  - bool DomNode->is_blank_node ( void )
(PHP >= 4.3 only) If newnode already is part of a document, it will be 
first unlinked from its existing context. If refnode is NULL, then newnode 
will be inserted at the end of the list of children. 
domnode_insert_before() is very similar to domnode_append_child() as the 
following example shows which does the same as the example at 
domnode_append_child(). 
Example 1. Adding a child
  <?php
  include("example.inc");

  if (!$dom = domxml_open_mem($xmlstr)) {
    echo "Error while parsing the document\n";
    exit;
  }

  $elements = $dom->get_elements_by_tagname("informaltable");
  print_r($elements);
  $element = $elements[0];

  $newnode = $element->insert_before($element, $element);
  $children = $newnode->children();
  $attr = $children[1]->set_attribute("align", "left");

  echo "<PRE>";
  $xmlfile = $dom->dump_mem();
  echo htmlentities($xmlfile);
  echo "</PRE>";
  ?> 
See also domnode_append_child().   DomNode->has_child_nodesUpDomNode->is_blank_node
DomNode->is_blank_node
(no version information, might be only in CVS)
DomNode->is_blank_node --  Checks if node is blank 
Description
bool DomNode->is_blank_node ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  DomNode->insert_beforeUpDomNode->last_child
DomNode->last_child
(no version information, might be only in CVS)
DomNode->last_child --  Returns last child of node 
Description
object DomNode->last_child ( void )
#

#T=bool DomNode->is_blank_node ( void )
DomNode->^!is_blank_node ( void );
#

#T=Returns the last child of the node.  - object DomNode->next_sibling ( void )
(PHP >= 4.3 only) If no last child is found, NULL is returned. 
See also domnode_first_child(), domnode_next_sibling(), 
domnode_previous_sibling().   DomNode->is_blank_nodeUpDomNode->next_sibling
DomNode->next_sibling
(no version information, might be only in CVS)
DomNode->next_sibling --  Returns the next sibling of node 
Description
object DomNode->next_sibling ( void )
This function returns the next sibling of the current node. If there is no 
next sibling it returns FALSE (< 4.3) or null (>= 4.3). You can use this 
function to iterate over all children of a node as shown in the example. 
Example 1. Iterate over children
  <?php
  include("example.inc");

  if (!$dom = domxml_open_mem($xmlstr)) {
    echo "Error while parsing the document\n";
    exit;
  }

  $elements = $dom->get_elements_by_tagname("tbody");
  $element = $elements[0];
  $child = $element->first_child();

  while ($child) {
     print_r($child);
     $child = $child->next_sibling();
  }
  ?> 
See also domnode_previous_sibling().   DomNode->last_childUpDomNode->node_name
DomNode->node_name
(no version information, might be only in CVS)
DomNode->node_name --  Returns name of node 
Description
string DomNode->node_name ( void )
Returns name of the node. The name has different meanings for the 
different types of nodes as illustrated in the following table. 
Table 1. Meaning of value
TypeMeaning
DomAttributevalue of attribute
DomAttribute 
DomCDataSection#cdata-section
DomComment#comment
DomDocument#document
DomDocumentTypedocument type name
DomElementtag name
DomEntityname of entity
DomEntityReferencename of entity reference
DomNotationnotation name
DomProcessingInstructiontarget
DomText#text
  DomNode->next_siblingUpDomNode->node_type
DomNode->node_type
(no version information, might be only in CVS)
DomNode->node_type --  Returns type of node 
Description
int DomNode->node_type ( void )
Returns the type of the node. All possible types are listed in the table 
in the introduction.   DomNode->node_nameUpDomNode->node_value
DomNode->node_value
(no version information, might be only in CVS)
DomNode->node_value --  Returns value of a node 
Description
string DomNode->node_value ( void )
Returns value of the node. The value has different meanings for the 
different types of nodes as illustrated in the following table. 
Table 1. Meaning of value
TypeMeaning
DomAttributevalue of attribute
DomAttribute 
DomCDataSectioncontent
DomCommentcontent of comment
DomDocumentnull
DomDocumentTypenull
DomElementnull
DomEntitynull
DomEntityReferencenull
DomNotationnull
DomProcessingInstructionentire content without target
DomTextcontent of text
  DomNode->node_typeUpDomNode->owner_document
DomNode->owner_document
(no version information, might be only in CVS)
DomNode->owner_document --  Returns the document this node belongs to 
Description
object DomNode->owner_document ( void )
This function returns the document the current node belongs to. 
The following example will create two identical lists of children. 
Example 1. Finding the document of a node
  <?php
  $doc = domxml_new_doc("1.0");
  $node = $doc->create_element("para");
  $node = $doc->append_child($node);
  $children = $doc->children();
  print_r($children);

  $doc2 = $node->owner_document();
  $children = $doc2->children();
  print_r($children);
  ?> 
See also domnode_insert_before().   DomNode->node_valueUpDomNode->parent_node
DomNode->parent_node
(no version information, might be only in CVS)
DomNode->parent_node --  Returns the parent of the node 
Description
object DomNode->parent_node ( void )
#

#T=object DomNode->next_sibling ( void )
DomNode->^!next_sibling ( void );
#

#T=This function returns the parent node.  - string DomNode->prefix ( void )
(PHP >= 4.3 only) If no parent is found, NULL is returned. 
The following example will show two identical lists of children. 
Example 1. Finding the document of a node
  <?php
  $doc = domxml_new_doc("1.0");
  $node = $doc->create_element("para");
  $node = $doc->append_child($node);
  $children = $doc->children();
  print_r($children);

  $doc2 = $node->parent_node();
  $children = $doc2->children();
  print_r($children);
  ?> 

  DomNode->owner_documentUpDomNode->prefix
DomNode->prefix
(no version information, might be only in CVS)
DomNode->prefix --  Returns name space prefix of node 
Description
string DomNode->prefix ( void )
Returns the name space prefix of the node.   DomNode->parent_nodeUpDomNode->previous_sibling
DomNode->previous_sibling
(no version information, might be only in CVS)
DomNode->previous_sibling --  Returns the previous sibling of node 
Description
object DomNode->previous_sibling ( void )
This function returns the previous sibling of the current node. If there 
is no previous sibling it returns FALSE (< 4.3) or NULL (>= 4.3). You can 
use this function to iterate over all children of a node as shown in the 
example. 
See also domnode_next_sibling().   DomNode->prefixUpDomNode->remove_child
DomNode->remove_child
(no version information, might be only in CVS)
DomNode->remove_child --  Removes child from list of children 
Description
object DomNode->remove_child ( object oldchild)
This functions removes a child from a list of children. If child cannot be 
removed or is not a child the function will return FALSE. If the child 
could be removed the functions returns the old child. 
Example 1. Removing a child
  <?php
  include("example.inc");

  if (!$dom = domxml_open_mem($xmlstr)) {
    echo "Error while parsing the document\n";
    exit;
  }

  $elements = $dom->get_elements_by_tagname("tbody");
  $element = $elements[0];
  $children = $element->child_nodes();
  $child = $element->remove_child($children[0]);

  echo "<PRE>";
  $xmlfile = $dom->dump_mem(true);
  echo htmlentities($xmlfile);
  echo "</PRE>";
  ?> 
See also domnode_append_child().   DomNode->previous_siblingUpDomNode->replace_child
DomNode->replace_child
(no version information, might be only in CVS)
DomNode->replace_child --  Replaces a child 
Description
object DomNode->replace_child ( object oldnode, object newnode)

#

#T=string DomNode->prefix ( void )
DomNode->^!prefix ( void );
#

#T= - object DomNode->replace_node ( object newnode)
(PHP 4.2) This function replaces the child oldnode with the passed new 
node. If the new node is already a child it will not be added a second 
time. If the old node cannot be found the function returns FALSE. If the 
#

#T=replacement succeeds the old node is returned.  - object DomNode->replace_node ( object newnode)
(PHP 4.3) This function replaces the child oldnode with the passed 
newnode, even if the new node already is a child of the DomNode. If 
newnode was already inserted in the document it is first unlinked from its 
existing context. If the old node cannot be found the function returns 
FALSE. If the replacement succeeds the old node is returned. (This 
behaviour is according to the W3C specs). 
See also domnode_append_child()   DomNode->remove_childUpDomNode->replace_node
DomNode->replace_node
(no version information, might be only in CVS)
DomNode->replace_node --  Replaces node 
Description
object DomNode->replace_node ( object newnode)

#

#T=object DomNode->replace_node ( object newnode)
DomNode->^!replace_node ( object newnode);
#

#T= - bool DomNode->set_content ( void )
(PHP 4.2) This function replaces an existing node with the passed new 
node. Before the replacement newnode is copied if it has a parent to make 
sure a node which is already in the document will not be inserted a second 
time. This behaviour enforces doing all modifications on the node before 
the replacement or to refetch the inserted node afterwards with functions 
#

#T=like domnode_first_child(), domnode_child_nodes() etc..  - bool DomNode->set_content ( void )
(PHP 4.3) This function replaces an existing node with the passed new 
node. It is not copied anymore. If newnode was already inserted in the 
document it is first unlinked from its existing context. If the 
replacement succeeds the old node is returned. 
See also domnode_append_child()   DomNode->replace_childUpDomNode->set_content
DomNode->set_content
(no version information, might be only in CVS)
DomNode->set_content --  Sets content of node 
Description
bool DomNode->set_content ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  DomNode->replace_nodeUpDomNode->set_name
DomNode->set_name
(no version information, might be only in CVS)
DomNode->set_name --  Sets name of node 
Description
bool DomNode->set_name ( void )
Sets name of node. 
See also domnode_node_name().   DomNode->set_contentUpDomNode->set_namespace
DomNode->set_namespace
(no version information, might be only in CVS)
DomNode->set_namespace --  Sets namespace of a node. 
Description
void DomNode->set_namespace ( string uri [, string prefix])
Sets the namespace of a node to uri. If there is already a namespace 
declaration with the same uri in one of the parent nodes of the node, the 
prefix of this is taken, otherwise it will take the one provided in the 
optional parameter prefix or generate a random one. 
See also domdocument_create_element_ns(), domnode_add_namespace()   DomNode->set_nameUpDomNode->unlink_node
DomNode->unlink_node
(no version information, might be only in CVS)
DomNode->unlink_node --  Deletes node 
Description
object DomNode->unlink_node ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  DomNode->set_namespaceUpDomProcessingInstruction->data
DomProcessingInstruction->data
(no version information, might be only in CVS)
DomProcessingInstruction->data --  Returns data of pi node 
Description
string DomProcessingInstruction->data ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  DomNode->unlink_nodeUpDomProcessingInstruction->target
DomProcessingInstruction->target
(no version information, might be only in CVS)
DomProcessingInstruction->target --  Returns target of pi node 
Description
string DomProcessingInstruction->target ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  DomProcessingInstruction->dataUpDomXsltStylesheet->process
#

#T=bool DomNode->set_content ( void )
DomNode->^!set_content ( void );
#

#T=domxml_new_doc - object domxml_new_doc ( string version)
(PHP 4 >= 4.2.1)
domxml_new_doc --  Creates new empty XML document 
Description
object domxml_new_doc ( string version)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Creates a new dom document from scratch and returns it. 
See also domdocument_add_root()   DomXsltStylesheet->result_dump_memUpdomxml_open_file
#

#T=object domxml_new_doc ( string version)
domxml_new_doc ( ^!string version);
#

#T=domxml_open_file - object domxml_open_file ( string filename)
(PHP 4 >= 4.2.1)
domxml_open_file -- Creates a DOM object from XML file
Description
object domxml_open_file ( string filename)
The function parses the XML document in the file named filename and 
returns an object of class "Dom document", having the properties as listed 
above. The file is accessed read-only. 
Example 1. Opening an XML document from a file
  <?php

  if (!$dom = domxml_open_file("example.xml")) {
    echo "Error while parsing the document\n";
    exit;
  }

  $root = $dom->document_element();
  ?> 
See also domxml_open_mem(), domxml_new_doc().   domxml_new_docUpdomxml_open_mem
#

#T=object domxml_open_file ( string filename)
domxml_open_file ( ^!string filename);
#

#T=domxml_open_mem - object domxml_open_mem ( string str)
(PHP 4 >= 4.2.1)
domxml_open_mem -- Creates a DOM object of an XML document
Description
object domxml_open_mem ( string str)
The function parses the XML document in str and returns an object of class 
"Dom document", having the properties as listed above. This function, 
domxml_open_file() or domxml_new_doc() must be called before any other 
function calls. 
Example 1. Opening an XML document in a string
  <?php
  include("example.inc");

  if (!$dom = domxml_open_mem($xmlstr)) {
    echo "Error while parsing the document\n";
    exit;
  }

  $root = $dom->document_element();
  ?> 
See also domxml_open_file(), domxml_new_doc().   domxml_open_fileUpdomxml_version
#

#T=object domxml_open_mem ( string str)
domxml_open_mem ( ^!string str);
#

#T=domxml_version - string domxml_version ( void )
(PHP 4 >= 4.1.0)
domxml_version --  Get XML library version 
Description
string domxml_version ( void )
This function returns the version of the XML library version currently 
used.   domxml_open_memUpdomxml_xmltree
#

#T=string domxml_version ( void )
domxml_version ( ^!void );
#

#T=domxml_xmltree - object domxml_xmltree ( string str)
(PHP 4 >= 4.2.1)
domxml_xmltree --  Creates a tree of PHP objects from an XML document 
Description
object domxml_xmltree ( string str)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

The function parses the XML document in str and returns a tree PHP objects 
as the parsed document. This function is isolated from the other 
functions, which means you cannot access the tree with any of the other 
functions. Modifying it, for example by adding nodes, makes no sense since 
there is currently no way to dump it as an XML file. However this function 
may be valuable if you want to read a file and investigate the content.   domxml_versionUpdomxml_xslt_stylesheet_doc
#

#T=object domxml_xmltree ( string str)
domxml_xmltree ( ^!string str);
#

#T=domxml_xslt_stylesheet_doc - object domxml_xslt_stylesheet_doc ( object DocDocument Object)
(PHP 4 >= 4.2.0)
domxml_xslt_stylesheet_doc --  Creates a DomXsltStylesheet Object from a 
DomDocument Object. 
Description
object domxml_xslt_stylesheet_doc ( object DocDocument Object)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Warning
This function is currently not documented; only the argument list is 
available.

See also domxsltstylesheet->process(), domxml_xslt_stylesheet(), 
domxml_xslt_stylesheet_file()   domxml_xmltreeUpdomxml_xslt_stylesheet_file
#

#T=object domxml_xslt_stylesheet_doc ( object DocDocument Object)
domxml_xslt_stylesheet_doc ( ^!object DocDocument Object);
#

#T=domxml_xslt_stylesheet_file - object domxml_xslt_stylesheet_file ( string xsl file)
(PHP 4 >= 4.2.0)
domxml_xslt_stylesheet_file --  Creates a DomXsltStylesheet Object from an 
XSL document in a file. 
Description
object domxml_xslt_stylesheet_file ( string xsl file)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Warning
This function is currently not documented; only the argument list is 
available.

See also domxsltstylesheet->process(), domxml_xslt_stylesheet(), 
domxml_xslt_stylesheet_doc()   domxml_xslt_stylesheet_docUpdomxml_xslt_stylesheet
#

#T=object domxml_xslt_stylesheet_file ( string xsl file)
domxml_xslt_stylesheet_file ( ^!string xsl file);
#

#T=domxml_xslt_stylesheet - object domxml_xslt_stylesheet ( string xsl document)
(PHP 4 >= 4.2.0)
domxml_xslt_stylesheet --  Creates a DomXsltStylesheet Object from an XML 
document in a string. 
Description
object domxml_xslt_stylesheet ( string xsl document)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Warning
This function is currently not documented; only the argument list is 
available.

See also domxsltstylesheet->process(), domxml_xslt_stylesheet_file(), 
domxml_xslt_stylesheet_doc()   domxml_xslt_stylesheet_fileUpxpath_eval_expression
DomXsltStylesheet->process
(no version information, might be only in CVS)
DomXsltStylesheet->process --  Applies the XSLT-Transformation on a 
DomDocument Object. 
Description
object DomXsltStylesheet->process ( object DomDocument [, array 
xslt_parameters [, bool param_is_xpath]])
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Warning
This function is currently not documented; only the argument list is 
available.

See also domxml_xslt_stylesheet(), domxml_xslt_stylesheet_file(), 
domxml_xslt_stylesheet_doc()   DomProcessingInstruction->targetUpDomXsltStylesheet->result_dump_file
DomXsltStylesheet->result_dump_file
(no version information, might be only in CVS)
DomXsltStylesheet->result_dump_file --  Dumps the result from a 
XSLT-Transformation into a file 
Description
string DomXsltStylesheet->result_dump_file ( object DomDocument, string 
filename)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

This function is only available since PHP 4.3 
Since DomXsltStylesheet->process() always returns a well-formed XML 
DomDocument, no matter what output method was declared in <xsl:output> and 
similar attributes/elements, it's of not much use, if you want to output 
HTML 4 or text data. This function on the contrary honors <xsl:output 
method="html|text"> and other output control directives. See the example 
for instruction of how to use it. 
Example 1. Saving the result of a XSLT transformation in a file
  <?php
  $filename = "stylesheet.xsl";
  $xmldoc = domxml_open_file("data.xml");
  $xsldoc = domxml_xslt_stylesheet_file($filename);
  $result =  $xsldoc->process($xmldoc);
  echo $xsldoc->result_dump_file($result, "filename");     
  ?> 
See also domxml_xslt_result_dump_mem(), domxml_xslt_process()   DomXsltStylesheet->processUpDomXsltStylesheet->result_dump_mem
DomXsltStylesheet->result_dump_mem
(no version information, might be only in CVS)
DomXsltStylesheet->result_dump_mem --  Dumps the result from a 
XSLT-Transformation back into a string 
Description
string DomXsltStylesheet->result_dump_mem ( object DomDocument)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

This function is only available since PHP 4.3 
Since DomXsltStylesheet->process() always returns a well-formed XML 
DomDocument, no matter what output method was declared in <xsl:output> and 
similar attributes/elements, it's of not much use, if you want to output 
HTML 4 or text data. This function on the contrary honors <xsl:output 
method="html|text"> and other output control directives. See the example 
for instruction of how to use it. 
Example 1. Outputting the result of a XSLT transformation
  <?php
  $filename = "stylesheet.xsl";
  $xmldoc = domxml_open_file("data.xml");
  $xsldoc = domxml_xslt_stylesheet_file($filename);
  $result =  $xsldoc->process($xmldoc);
  echo $xsldoc->result_dump_mem($result);     
  ?> 
See also domxml_xslt_result_dump_file(), domxml_xslt_process()   DomXsltStylesheet->result_dump_fileUpdomxml_new_doc
dotnet_load
(no version information, might be only in CVS)
dotnet_load -- Loads a DOTNET module
Description
int dotnet_load ( string assembly_name [, string datatype_name [, int 
codepage]])
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Warning
This function is currently not documented; only the argument list is 
available.
  .NET functionsUpError Handling and Logging Functions
doubleval
doubleval -- Alias of floatval()
Description
This function is an alias of floatval(). 
Note: This alias is a left-over from a function-renaming. In older 
versions of PHP you'll need to use this alias of the floatval() 
function, because floatval() wasn't yet available in that version.   Variable FunctionsUpempty
#

#T=object domxml_xslt_stylesheet ( string xsl document)
domxml_xslt_stylesheet ( ^!string xsl document);
#

#T=each - array each ( array array)
(PHP 3, PHP 4 )
each --  Return the current key and value pair from an array and advance 
the array cursor 
Description
array each ( array array)
Returns the current key and value pair from the array array and advances 
the array cursor. This pair is returned in a four-element array, with the 
keys 0, 1, key, and value. Elements 0 and key contain the key name of the 
array element, and 1 and value contain the data. 
If the internal pointer for the array points past the end of the array 
contents, each() returns FALSE. 
Example 1. each() examples
  <?php
  $foo = array("bob", "fred", "jussi", "jouni", "egon", 
  "marliese");
  $bar = each($foo);
  print_r($bar);
  ?> 

$bar now contains the following key/value pairs: 
Array
(
[1] => bob
[value] => bob
[0] => 0
[key] => 0
)
<?php
$foo = array("Robert" => "Bob", "Seppo" => "Sepi");
$bar = each($foo);
print_r($bar);
?> 

$bar now contains the following key/value pairs: 
Array
(
[1] => Bob
[value] => Bob
[0] => Robert
[key] => Robert
)

each() is typically used in conjunction with list() to traverse an array, 
here's an example: Example 2. Traversing an array with each()
  <?php
  $fruit = array('a' => 'apple', 'b' => 'banana', 'c' => 
  'cranberry');

  reset($fruit);
  while (list($key, $val) = each($fruit)) {
      echo "$key => $val\n";
  }
  ?> 

Outputs: 
a => apple
b => banana
c => cranberry
After each() has executed, the array cursor will be left on the next 
element of the array, or past the last element if it hits the end of the 
array. You have to use reset() if you want to traverse the array again 
using each. 
Caution
Because assigning an array to another variable resets the original 
arrays pointer, our example above would cause an endless loop had we 
assigned $fruit to another variable inside the loop. 

See also key(), list(), current(), reset(), next(), prev(), and foreach.   currentUpend
#

#T=array each ( array array)
each ( ^!array array);
#

#T=easter_date - int easter_date ( [int year])
(PHP 3>= 3.0.9, PHP 4 )
easter_date --  Get Unix timestamp for midnight on Easter of a given year 
Description
int easter_date ( [int year])
Returns the Unix timestamp corresponding to midnight on Easter of the 
given year. 
Since PHP 4.3.0, the year parameter is optional and defaults to the 
current year according to the localtime if omitted. 
Example 1. easter_date() example
  <?php

  echo date("M-d-Y", easter_date(1999));        // Apr-04-1999
  echo date("M-d-Y", easter_date(2000));        // Apr-23-2000
  echo date("M-d-Y", easter_date(2001));        // Apr-15-2001

  ?> 
Warning
This function will generate a warning if the year is outside of the 
range for Unix timestamps (i.e. before 1970 or after 2037). 

The date of Easter Day was defined by the Council of Nicaea in AD325 as 
the Sunday after the first full moon which falls on or after the Spring 
Equinox. The Equinox is assumed to always fall on 21st March, so the 
calculation reduces to determining the date of the full moon and the date 
of the following Sunday. The algorithm used here was introduced around the 
year 532 by Dionysius Exiguus. Under the Julian Calendar (for years before 
1753) a simple 19-year cycle is used to track the phases of the Moon. 
Under the Gregorian Calendar (for years after 1753 - devised by Clavius 
and Lilius, and introduced by Pope Gregory XIII in October 1582, and into 
Britain and its then colonies in September 1752) two correction factors 
are added to make the cycle more accurate. 
(The code is based on a C program by Simon Kershaw, <webmaster at 
ely.anglican dot org>) 
See easter_days() for calculating Easter before 1970 or after 2037.   cal_to_jdUpeaster_days
#

#T=int easter_date ( [int year])
easter_date ( ^![int year]);
#

#T=easter_days - int easter_days ( [int year [, int method]])
(PHP 3>= 3.0.9, PHP 4 )
easter_days --  Get number of days after March 21 on which Easter falls 
for a given year 
Description
int easter_days ( [int year [, int method]])
Returns the number of days after March 21 on which Easter falls for a 
given year. If no year is specified, the current year is assumed. 
Since PHP 4.3.0, the year parameter is optional and defaults to the 
current year according to the localtime if omitted. 
The method parameter was also introduced in PHP 4.3.0 and allows to 
calculate easter dates based on the Gregorian calendar during the years 
1582 - 1752 when set to CAL_EASTER_ROMAN. See the calendar constants for 
more valid constants. 
This function can be used instead of easter_date() to calculate Easter for 
years which fall outside the range of Unix timestamps (i.e. before 1970 or 
after 2037). Example 1. easter_days() example
  <?php

  echo easter_days(1999);        // 14, i.e. April 4
  echo easter_days(1492);        // 32, i.e. April 22
  echo easter_days(1913);        //  2, i.e. March 23

  ?> 
The date of Easter Day was defined by the Council of Nicaea in AD325 as 
the Sunday after the first full moon which falls on or after the Spring 
Equinox. The Equinox is assumed to always fall on 21st March, so the 
calculation reduces to determining the date of the full moon and the date 
of the following Sunday. The algorithm used here was introduced around the 
year 532 by Dionysius Exiguus. Under the Julian Calendar (for years before 
1753) a simple 19-year cycle is used to track the phases of the Moon. 
Under the Gregorian Calendar (for years after 1753 - devised by Clavius 
and Lilius, and introduced by Pope Gregory XIII in October 1582, and into 
Britain and its then colonies in September 1752) two correction factors 
are added to make the cycle more accurate. 
(The code is based on a C program by Simon Kershaw, <webmaster at 
ely.anglican dot org>) 
See also easter_date().   easter_dateUpFrenchToJD
#

#T=int easter_days ( [int year [, int method]])
easter_days ( ^![int year [, int method]]);
#

#T=ebcdic2ascii - int ebcdic2ascii ( string ebcdic_str)
(PHP 3>= 3.0.17)
ebcdic2ascii -- Translate string from EBCDIC to ASCII
Description
int ebcdic2ascii ( string ebcdic_str)
ebcdic2ascii() is an Apache-specific function which is available only on 
EBCDIC based operating systems (OS/390, BS2000). It translates the EBCDIC 
encoded string ebcdic_str to its equivalent ASCII representation (binary 
safe), and returns the result. 
See also the reverse function ascii2ebcdic()   ascii2ebcdicUpgetallheaders
#

#T=int ebcdic2ascii ( string ebcdic_str)
ebcdic2ascii ( ^!string ebcdic_str);
#

#T=echo - void echo ( string arg1 [, string argn...])
(PHP 3, PHP 4 )
echo -- Output one or more strings
Description
void echo ( string arg1 [, string argn...])
Outputs all parameters. 
echo() is not actually a function (it is a language construct) so you are 
not required to use parentheses with it. In fact, if you want to pass more 
than one parameter to echo, you must not enclose the parameters within 
parentheses. 
Example 1. echo() examples
  <?php
  echo "Hello World";

  echo "This spans
  multiple lines. The newlines will be 
  output as well";

  echo "This spans\nmultiple lines. The newlines will be\noutput 
  as well.";

  echo "Escaping characters is done \"Like this\".";

  // You can use variables inside of an echo statement
  $foo = "foobar";
  $bar = "barbaz";

  echo "foo is $foo"; // foo is foobar

  // You can also use arrays
  $bar = array("value" => "foo");

  echo "this is {$bar['value']} !"; // this is foo !

  // Using single quotes will print the variable name, not the 
  value
  echo 'foo is $foo'; // foo is $foo

  // If you are not using any other characters, you can just 
  echo variables
  echo $foo;          // foobar
  echo $foo,$bar;     // foobarbarbaz

  // Some people prefer passing multiple parameters to echo over 
  concatenation.
  echo 'This ', 'string ', 'was ', 'made ', 'with multiple 
  parameters.', chr(10);
  echo 'This ' . 'string ' . 'was ' . 'made ' . 'with 
  concatenation.' . "\n";

  echo <<<END
  This uses the "here document" syntax to output
  multiple lines with $variable interpolation. Note
  that the here document terminator must appear on a
  line with just a semicolon. no extra whitespace!
  END;

  // Because echo is not a function, following code is invalid. 
  ($some_var) ? echo 'true' : echo 'false';

  // However, the following examples will work:
  ($some_var) ? print('true'): print('false'); // print is a 
  function
  echo $some_var ? 'true': 'false'; // changing the statement 
  around
  ?> 
echo() also has a shortcut syntax, where you can immediately follow the 
opening tag with an equals sign. This short syntax only works with the 
short_open_tag configuration setting enabled. 
I have <?=$foo?> foo. 

For a short discussion about the differences between print() and echo(), 
see this FAQTs Knowledge Base Article: 
http://www.faqts.com/knowledge_base/view.phtml/aid/1/fid/40 
Note: Because this is a language construct and not a function, it cannot 
be called using variable functions
See also print(), printf(), and flush().   cryptUpexplode
#

#T=void echo ( string arg1 [, string argn...])
echo ( ^!string arg1 [, string argn...]);
#

#T=empty - bool empty ( mixed var)
(PHP 3, PHP 4 )
empty -- Determine whether a variable is empty
Description
bool empty ( mixed var)
empty() returns FALSE if var has a non-empty or non-zero value. In 
otherwords, "", 0, "0", NULL, FALSE, array(), var $var;, and objects with 
empty properties, are all considered empty. TRUE is returned if var is 
empty. 
empty() is the opposite of (boolean) var, except that no warning is 
generated when the variable is not set. See converting to boolean for more 
information. 
Example 1. A simple empty() / isset() comparison. 
  <?php
  $var = 0;

  // Evaluates to true because $var is empty
  if (empty($var)) {
      echo '$var is either 0, empty, or not set at all';
  }

  // Evaluates as true because $var is set
  if (isset($var)) {
      echo '$var is set even though it is empty';
  }
  ?> 
Note: Because this is a language construct and not a function, it cannot 
be called using variable functions
Note: empty() only checks variables as anything else will result in a 
parse error. In otherwords, the following will not work: 
empty(addslashes($name)). 
See also isset(), unset(), array_key_exists(), count(), strlen(), and the 
type comparison tables.   doublevalUpfloatval
#

#T=bool empty ( mixed var)
empty ( ^!mixed var);
#

#T=end - mixed end ( array array)
(PHP 3, PHP 4 )
end --  Set the internal pointer of an array to its last element 
Description
mixed end ( array array)
end() advances array's internal pointer to the last element, and returns 
the value from the last element. 
Example 1. A simple end() example
  <?php

    $fruits = array('apple', 'banana', 'cranberry');
      
    echo end($fruits); // cranberry
	
  ?> 
See also current(), each(), prev(), next() and reset().   eachUpextract
#

#T=mixed end ( array array)
end ( ^!array array);
#

#T=ereg_replace - string ereg_replace ( string pattern, string replacement, string string)
(PHP 3, PHP 4 )
ereg_replace -- Replace regular expression
Description
string ereg_replace ( string pattern, string replacement, string string)
This function scans string for matches to pattern, then replaces the 
matched text with replacement. 
The modified string is returned. (Which may mean that the original string 
is returned if there are no matches to be replaced.) 
If pattern contains parenthesized substrings, replacement may contain 
substrings of the form \\digit, which will be replaced by the text 
matching the digit'th parenthesized substring; \\0 will produce the entire 
contents of string. Up to nine substrings may be used. Parentheses may be 
nested, in which case they are counted by the opening parenthesis. 
If no matches are found in string, then string will be returned unchanged. 

For example, the following code snippet prints "This was a test" three 
times: 
Example 1. ereg_replace() example
  <?php

  $string = "This is a test";
  echo str_replace(" is", " was", $string);
  echo ereg_replace("( )is", "\\1was", $string);
  echo ereg_replace("(( )is)", "\\2was", $string);

  ?> 
One thing to take note of is that if you use an integer value as the 
replacement parameter, you may not get the results you expect. This is 
because ereg_replace() will interpret the number as the ordinal value of a 
character, and apply that. For instance: 
Example 2. ereg_replace() example
  <?php
  /* This will not work as expected. */
  $num = 4;
  $string = "This string has four words.";
  $string = ereg_replace('four', $num, $string);
  echo $string;   /* Output: 'This string has   words.' */

  /* This will work. */
  $num = '4';
  $string = "This string has four words.";
  $string = ereg_replace('four', $num, $string);
  echo $string;   /* Output: 'This string has 4 words.' */
  ?> 
Example 3. Replace URLs with links
  <?php
  $text = 
  ereg_replace("[[:alpha:]]+://[^<>[:space:]]+[[:alnum:]/]",
		       "<a href=\"\\0\">\\0</a>", $text);
  ?> 
Tip: preg_replace(), which uses a Perl-compatible regular expression 
syntax, is often a faster alternative to ereg_replace(). 
See also ereg(), eregi(), eregi_replace(), str_replace(), and 
preg_match().   Regular Expression Functions (POSIX Extended)Upereg
#

#T=string ereg_replace ( string pattern, string replacement, string string)
ereg_replace ( ^!string pattern, string replacement, string string);
#

#T=ereg - bool ereg ( string pattern, string string [, array regs])
(PHP 3, PHP 4 )
ereg -- Regular expression match
Description
bool ereg ( string pattern, string string [, array regs])
Note: preg_match(), which uses a Perl-compatible regular expression 
syntax, is often a faster alternative to ereg(). 
Searches a string for matches to the regular expression given in pattern 
in a case-sensitive way. 
If matches are found for parenthesized substrings of pattern and the 
function is called with the third argument regs, the matches will be 
stored in the elements of the array regs. $regs[1] will contain the 
substring which starts at the first left parenthesis; $regs[2] will 
contain the substring starting at the second, and so on. $regs[0] will 
contain a copy of the complete string matched. 
Note: Up to (and including) PHP 4.1.0 $regs will be filled with exactly 
ten elements, even though more or fewer than ten parenthesized 
substrings may actually have matched. This has no effect on ereg()'s 
ability to match more substrings. If no matches are found, $regs will 
not be altered by ereg(). 
Returns TRUE if a match for pattern was found in string, or FALSE if no 
matches were found or an error occurred. 
The following code snippet takes a date in ISO format (YYYY-MM-DD) and 
prints it in DD.MM.YYYY format: 
Example 1. ereg() example
  <?php
  if (ereg ("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})", $date, 
  $regs)) {
      echo "$regs[3].$regs[2].$regs[1]";
  } else {
      echo "Invalid date format: $date";
  }
  ?> 
See also eregi(), ereg_replace(), eregi_replace(), preg_match(), strpos(), 
and strstr().   ereg_replaceUperegi_replace
#

#T=bool ereg ( string pattern, string string [, array regs])
ereg ( ^!string pattern, string string [, array regs]);
#

#T=eregi_replace - string eregi_replace ( string pattern, string replacement, string string)
(PHP 3, PHP 4 )
eregi_replace -- replace regular expression case insensitive
Description
string eregi_replace ( string pattern, string replacement, string string)
This function is identical to ereg_replace() except that this ignores case 
distinction when matching alphabetic characters. 
See also ereg(), eregi(), and ereg_replace().   eregUperegi
#

#T=string eregi_replace ( string pattern, string replacement, string string)
eregi_replace ( ^!string pattern, string replacement, string string);
#

#T=eregi - bool eregi ( string pattern, string string [, array regs])
(PHP 3, PHP 4 )
eregi -- case insensitive regular expression match
Description
bool eregi ( string pattern, string string [, array regs])
This function is identical to ereg() except that this ignores case 
distinction when matching alphabetic characters. 
Example 1. eregi() example
  <?php
  if (eregi("z", $string)) {
      echo "'$string' contains a 'z' or 'Z'!";
  }
  ?> 
See also ereg(), ereg_replace(), eregi_replace(), stripos(), and 
stristr().   eregi_replaceUpsplit
#

#T=bool eregi ( string pattern, string string [, array regs])
eregi ( ^!string pattern, string string [, array regs]);
#

#T=error_log - int error_log ( string message [, int message_type [, string destination 
(PHP 3, PHP 4 )
error_log -- Send an error message somewhere
Description
int error_log ( string message [, int message_type [, string destination 
[, string extra_headers]]])
Sends an error message to the web server's error log, a TCP port or to a 
file. The first parameter, message, is the error message that should be 
logged. The second parameter, message_type says where the message should 
go: 
Table 1. error_log() log types
0message is sent to PHP's system logger, using the Operating 
System's system logging mechanism or a file, depending on what the 
error_log configuration directive is set to. 
1message is sent by email to the address in the destination 
parameter. This is the only message type where the fourth parameter, 
extra_headers is used. This message type uses the same internal 
function as mail() does. 
2message is sent through the PHP debugging connection. This option 
is only available if remote debugging has been enabled. In this 
case, the destination parameter specifies the host name or IP 
address and optionally, port number, of the socket receiving the 
debug information. 
3message is appended to the file destination. 

Warning
Remote debugging via TCP/IP is a PHP 3 feature that is not available 
in PHP 4. 

Example 1. error_log() examples
  <?php
  // Send notification through the server log if we can not
  // connect to the database.
  if (!Ora_Logon($username, $password)) {
      error_log("Oracle database not available!", 0);
  }

  // Notify administrator by email if we run out of FOO
  if (!($foo = allocate_new_foo())) {
      error_log("Big trouble, we're all out of FOOs!", 1,
		 "operator@example.com");
  }

  // other ways of calling error_log():
  error_log("You messed up!", 2, "127.0.0.1:7000");
  error_log("You messed up!", 2, "loghost");
  error_log("You messed up!", 3, "/var/tmp/my-errors.log");
  ?> 

  debug_print_backtraceUperror_reporting
#

#T=int error_log ( string message [, int message_type [, string destination 
error_log ( ^!string message [, int message_type [, string destination ;
#

#T=error_reporting - int error_reporting ( [int level])
(PHP 3, PHP 4 )
error_reporting -- Sets which PHP errors are reported
Description
int error_reporting ( [int level])
The error_reporting() function sets the error_reporting directive at 
runtime. PHP has many levels of errors, using this function sets that 
level for the duration (runtime) of your script. 
error_reporting() sets PHP's error reporting level, and returns the old 
level. The level parameter takes on either a bitmask, or named constants. 
Using named constants is strongly encouraged to ensure compatibility for 
future versions. As error levels are added, the range of integers 
increases, so older integer-based error levels will not always behave as 
expected. 
Some example uses: 
Example 1. error_reporting() examples
  <?php

  // Turn off all error reporting
  error_reporting(0);

  // Report simple running errors
  error_reporting(E_ERROR | E_WARNING | E_PARSE);

  // Reporting E_NOTICE can be good too (to report uninitialized 

  // variables or catch variable name misspellings ...)
  error_reporting(E_ERROR | E_WARNING | E_PARSE | E_NOTICE);

  // Report all errors except E_NOTICE
  // This is the default value set in php.ini
  error_reporting(E_ALL ^ E_NOTICE);

  // Report all PHP errors (bitwise 63 may be used in PHP 3)
  error_reporting(E_ALL);

  // Same as error_reporting(E_ALL);
  ini_set ('error_reporting', E_ALL);

  ?> 
The available error level constants are listed below. The actual meanings 
of these error levels are described in the predefined constants. 
Table 1. error_reporting() level constants and bit values
valueconstant
1E_ERROR 
2E_WARNING 
4E_PARSE 
8E_NOTICE 
16E_CORE_ERROR 
32E_CORE_WARNING 
64E_COMPILE_ERROR 
128E_COMPILE_WARNING 
256E_USER_ERROR 
512E_USER_WARNING 
1024E_USER_NOTICE 
2047E_ALL 
2048E_STRICT 

Warning
With PHP > 5.0.0 E_STRICT with value 2048 is available. E_ALL does 
NOT include error levelE_STRICT. 

See also the display_errors directive and ini_set().   error_logUprestore_error_handler
#

#T=int error_reporting ( [int level])
error_reporting ( ^![int level]);
#

#T=escapeshellarg - string escapeshellarg ( string arg)
(PHP 4 >= 4.0.3)
escapeshellarg -- escape a string to be used as a shell argument
Description
string escapeshellarg ( string arg)
escapeshellarg() adds single quotes around a string and quotes/escapes any 
existing single quotes allowing you to pass a string directly to a shell 
function and having it be treated as a single safe argument. This function 
should be used to escape individual arguments to shell functions coming 
from user input. The shell functions include exec(), system() and the 
backtick operator. A standard use would be:
<?php
system('ls '.escapeshellarg($dir));
?> 

See also escapeshellcmd(), exec(), popen(), system(), and the backtick 
operator.   Program Execution functionsUpescapeshellcmd
#

#T=string escapeshellarg ( string arg)
escapeshellarg ( ^!string arg);
#

#T=escapeshellcmd - string escapeshellcmd ( string command)
(PHP 3, PHP 4 )
escapeshellcmd -- escape shell metacharacters
Description
string escapeshellcmd ( string command)
escapeshellcmd() escapes any characters in a string that might be used to 
trick a shell command into executing arbitrary commands. This function 
should be used to make sure that any data coming from user input is 
escaped before this data is passed to the exec() or system() functions, or 
to the backtick operator. A standard use would be:
<?php
$e = escapeshellcmd($userinput);

// here we don't care if $e has spaces
system("echo $e");
$f = escapeshellcmd($filename);

// and here we do, so we use quotes
system("touch \"/tmp/$f\"; ls -l \"/tmp/$f\"");
?> 

See also escapeshellarg(), exec(), popen(), system(), and the backtick 
operator.   escapeshellargUpexec
#

#T=string escapeshellcmd ( string command)
escapeshellcmd ( ^!string command);
#

#T=eval - mixed eval ( string code_str)
(PHP 3, PHP 4 )
eval -- Evaluate a string as PHP code
Description
mixed eval ( string code_str)
eval() evaluates the string given in code_str as PHP code. Among other 
things, this can be useful for storing code in a database text field for 
later execution. 
There are some factors to keep in mind when using eval(). Remember that 
the string passed must be valid PHP code, including things like 
terminating statements with a semicolon so the parser doesn't die on the 
line after the eval(), and properly escaping things in code_str. 
Also remember that variables given values under eval() will retain these 
values in the main script afterwards. 
A return statement will terminate the evaluation of the string 
immediately. In PHP 4, eval() returns NULL unless return is called in the 
evaluated code, in which case the value passed to return is returned. In 
PHP 3, eval() does not return a value. 
Example 1. eval() example - simple text merge 
  <?php
  $string = 'cup';
  $name = 'coffee';
  $str = 'This is a $string with my $name in it.';
  echo $str. "\n";
  eval("\$str = \"$str\";");
  echo $str. "\n";
  ?> 

The above example will show: 
This is a $string with my $name in it.
This is a cup with my coffee in it.
Tip: As with anything that outputs its result directly to the browser, 
you can use the output-control functions to capture the output of this 
function, and save it in a string (for example).  dieUpexit
#

#T=mixed eval ( string code_str)
eval ( ^!string code_str);
#

#T=exec - string exec ( string command [, array output [, int return_var]])
(PHP 3, PHP 4 )
exec -- Execute an external program
Description
string exec ( string command [, array output [, int return_var]])
exec() executes the given command, however it does not output anything. It 
simply returns the last line from the result of the command. If you need 
to execute a command and have all the data from the command passed 
directly back without any interference, use the passthru() function. 
If the output argument is present, then the specified array will be filled 
with every line of output from the command. Line endings, such as \n, are 
not included in this array. Note that if the array already contains some 
elements, exec() will append to the end of the array. If you do not want 
the function to append elements, call unset() on the array before passing 
it to exec(). 
If the return_var argument is present along with the output argument, then 
the return status of the executed command will be written to this 
variable. 
Warning
If you are going to allow data coming from user input to be passed 
to this function, then you should be using escapeshellarg() or 
escapeshellcmd() to make sure that users cannot trick the system 
into executing arbitrary commands. 

Note: If you start a program using this function and want to leave it 
running in the background, you have to make sure that the output of that 
program is redirected to a file or some other output stream or else PHP 
will hang until the execution of the program ends. 
Note: When safe mode is enabled, you can only execute executables within 
the safe_mode_exec_dir. For practical reasons it's currently not allowed 
to have .. components in the path to the executable. 
See also system(), passthru(), popen(), escapeshellcmd(), and the backtick 
operator.   escapeshellcmdUppassthru
#

#T=string exec ( string command [, array output [, int return_var]])
exec ( ^!string command [, array output [, int return_var]]);
#

#T=exif_imagetype - int exif_imagetype ( string filename)
(PHP 4 >= 4.3.0)
exif_imagetype -- Determine the type of an image
Description
int exif_imagetype ( string filename)
exif_imagetype() reads the first bytes of an image and checks its 
signature. When a correct signature is found a constant will be returned 
otherwise the return value is FALSE. The return value is the same value 
that getimagesize() returns in index 2 but this function is much faster. 
The following constants are defined: 
Table 1. Imagetype Constants
ValueConstant
1IMAGETYPE_GIF
2IMAGETYPE_JPEG
3IMAGETYPE_PNG
4IMAGETYPE_SWF
5IMAGETYPE_PSD
6IMAGETYPE_BMP
7IMAGETYPE_TIFF_II (intel byte order)
8IMAGETYPE_TIFF_MM (motorola byte order) 
9IMAGETYPE_JPC
10IMAGETYPE_JP2
11IMAGETYPE_JPX
12IMAGETYPE_JB2
13IMAGETYPE_SWC
14IMAGETYPE_IFF
15IMAGETYPE_WBMP
16IMAGETYPE_XBM

Note: Support for JPC, JP2, JPX, JB2, XBM, and WBMP became available in 
PHP 4.3.2. Support for SWC as of PHP 4.3.0. 
This function can be used to avoid calls to other exif functions with 
unsupported file types or in conjunction with $_SERVER['HTTP_ACCEPT'] to 
check whether or not the viewer is able to see a specific image in the 
browser. 
Note: This function is only available if PHP is compiled using 
--enable-exif. 
Note: This function does not require the GD image library. 
Example 1. exif_imagetype() example
  <?php

  if (exif_imagetype("image.gif") != IMAGETYPE_GIF) {
      echo "The picture is not a gif";
  }

  ?> 
See also getimagesize().   Image functionsUpexif_read_data
#

#T=int exif_imagetype ( string filename)
exif_imagetype ( ^!string filename);
#

#T=exif_read_data - array exif_read_data ( string filename [, string sections [, bool arrays 
(PHP 4 >= 4.2.0)
exif_read_data -- Reads the EXIF headers from JPEG or TIFF. This way you 
can read meta data generated by digital cameras.
Description
array exif_read_data ( string filename [, string sections [, bool arrays 
[, bool thumbnail]]])
The exif_read_data() function reads the EXIF headers from a JPEG or TIFF 
image file. It returns an associative array where the indexes are the 
header names and the values are the values associated with those headers. 
If no data can be returned the result is FALSE. 
filename is the name of the file to read. This cannot be an url. 
sections is a comma separated list of sections that need to be present in 
file to produce a result array. If none of the requested sections could be 
found the return value is FALSE. 
FILEFileName, FileSize, FileDateTime, SectionsFound
COMPUTEDhtml, Width, Height, IsColor and some more if available. 
ANY_TAGAny information that has a Tag e.g. IFD0, EXIF, ...
IFD0All tagged data of IFD0. In normal imagefiles this contains 
image size and so forth.
THUMBNAILA file is supposed to contain a thumbnail if it has a 
second IFD. All tagged information about the embedded thumbnail is 
stored in this section.
COMMENTComment headers of JPEG images.
EXIFThe EXIF section is a sub section of IFD0. It contains more 
detailed information about an image. Most of these entries are 
digital camera related.

arrays specifies whether or not each section becomes an array. The 
sections COMPUTED, THUMBNAIL and COMMENT allways become arrays as they may 
contain values whose names are conflict with other sections. 
thumbnail whether or not to read the thumbnail itself and not only its 
tagged data. 
Note: Exif headers tend to be present in JPEG/TIFF images generated by 
digital cameras, but unfortunately each digital camera maker has a 
different idea of how to actually tag their images, so you can't always 
rely on a specific Exif header being present. 
Windows ME/XP both can wipe the Exif headers when connecting to a 
camera. More information available at 
http://ww2.canon-europe.com/products/cameras/notices_dig_cam_users.html. 

Example 1. exif_read_data() example
  <?php

  echo "test1.jpg:<br />\n";
  $exif = exif_read_data('tests/test1.jpg', 'IFD0');
  echo $exif===false ? "No header data found.<br />\n" : "Image 
  contains headers<br />";

  $exif = exif_read_data('tests/test2.jpg', 0, true);
  echo "test2.jpg:<br />\n";
  foreach ($exif as $key => $section) {
      foreach ($section as $name => $val) {
	  echo "$key.$name: $val<br />\n";
      }
  }
  ?> 

The first call fails because the image has no header information. 
  test1.jpg:
  No header data found.
  test2.jpg:
  FILE.FileName: test2.jpg
  FILE.FileDateTime: 1017666176
  FILE.FileSize: 1240
  FILE.FileType: 2
  FILE.SectionsFound: ANY_TAG, IFD0, THUMBNAIL, COMMENT
  COMPUTED.html: width="1" height="1"
  COMPUTED.Height: 1
  COMPUTED.Width: 1
  COMPUTED.IsColor: 1
  COMPUTED.ByteOrderMotorola: 1
  COMPUTED.UserComment: Exif test image.
  COMPUTED.UserCommentEncoding: ASCII
  COMPUTED.Copyright: Photo (c) M.Boerger, Edited by M.Boerger.
  COMPUTED.Copyright.Photographer: Photo (c) M.Boerger
  COMPUTED.Copyright.Editor: Edited by M.Boerger.
  IFD0.Copyright: Photo (c) M.Boerger
  IFD0.UserComment: ASCII
  THUMBNAIL.JPEGInterchangeFormat: 134
  THUMBNAIL.JPEGInterchangeFormatLength: 523
  COMMENT.0: Comment #1.
  COMMENT.1: Comment #2.
  COMMENT.2: Comment #3end
  THUMBNAIL.JPEGInterchangeFormat: 134
  THUMBNAIL.Thumbnail.Height: 1
  THUMBNAIL.Thumbnail.Height: 1 
Note: If the image contains any IFD0 data then COMPUTED contains the 
entry ByteOrderMotorola which is 0 for little-endian (intel) and 1 for 
big-endian (motorola) byte order. This was added in PHP 4.3. 
When an Exif header contains a Copyright note this itself can contain 
two values. As the solution is inconsistent in the Exif 2.10 standard 
the COMPUTED section will return both entries Copyright.Photographer and 
Copyright.Editor while the IFD0 sections contains the byte array with 
the NULL character that splits both entries. Or just the first entry if 
the datatype was wrong (normal behaviour of Exif). The COMPUTED will 
contain also an entry Copyright Which is either the original copyright 
string or it is a comma separated list of photo and editor copyright. 
Note: The tag UserComment has the same problem as the Copyright tag. It 
can store two values first the encoding used and second the value 
itself. If so the IFD section only contains the encoding or a byte 
array. The COMPUTED section will store both in the entries 
UserCommentEncoding and UserComment. The entry UserComment is available 
in both cases so it should be used in preference to the value in IFD0 
section. 
If the user comment uses Unicode or JIS encoding and the module mbstring 
is available this encoding will automatically changed according to the 
exif ini settings in the php.ini. This was added in PHP 4.3. 
Note: Height and Width are computed the same way getimagesize() does so 
their values must not be part of any header returned. Also html is a 
height/width text string to be used inside normal HTML. 
Note: Starting from PHP 4.3 the function can read all embedded IFD data 
including arrays (returned as such). Also the size of an embedded 
thumbnail is returned in THUMBNAIL subarray and the function 
exif_read_data() can return thumbnails in TIFF format. Last but not 
least there is no longer a maximum length for returned values (not until 
memory limit is reached). 
Note: This function is only available in PHP 4 compiled using 
--enable-exif. Its functionality and behaviour has changed in PHP 4.2. 
Earlier versions are very unstable. 
Since PHP 4.3 user comment can automatically change encoding if PHP 4 
was compiled using --enable-mbstring. 
This function does not require the GD image library. 
See also exif_thumbnail() and getimagesize().   exif_imagetypeUpexif_thumbnail
#

#T=array exif_read_data ( string filename [, string sections [, bool arrays 
exif_read_data ( ^!string filename [, string sections [, bool arrays ;
#

#T=exif_thumbnail - string exif_thumbnail ( string filename [, int &width [, int &height [, 
(PHP 4 >= 4.2.0)
exif_thumbnail -- Retrieve the embedded thumbnail of a TIFF or JPEG image
Description
string exif_thumbnail ( string filename [, int &width [, int &height [, 
int &imagetype]]])
exif_thumbnail() reads the embedded thumbnail of a TIFF or JPEG image. If 
the image contains no thumbnail FALSE will be returned. 
The parameters width, height and imagetype are available since PHP 4.3.0 
and return the size of the thumbnail as well as its type. It is possible 
that exif_thumbnail() cannot create an image but can determine its size. 
In this case, the return value is FALSE but width and height are set. 
If you want to deliver thumbnails through this function, you should send 
the mimetype information using the header() function. The following 
example demonstrates this: 
Example 1. exif_thumbnail() example
  <?php
  if (array_key_exists('file', $_REQUEST)) {
      $image = exif_thumbnail($_REQUEST['file'], $width, 
  $height, $type);
  } else {
      $image = false;
  }
  if ($image!==false) {
      header("Content-type: " .image_type_to_mime_type($type));
      echo $image;
      exit;
  } else {
      // no thumbnail available, handle the error here
      echo "No thumbnail available";
  }
  ?> 
Starting from version PHP 4.3.0, the function exif_thumbnail() can return 
thumbnails in TIFF format. 
Note: This function is only available in PHP 4 compiled using 
--enable-exif. Its functionality and behaviour has changed in PHP 4.2.0 
Note: This function does not require the GD image library. 
See also exif_read_data() and image_type_to_mime_type().   exif_read_dataUpgd_info
#

#T=string exif_thumbnail ( string filename [, int &width [, int &height [, 
exif_thumbnail ( ^!string filename [, int &width [, int &height [, ;
#

#T=exit - void exit ( [string status])
(PHP 3, PHP 4 )
exit -- Output a message and terminate the current script
Description
void exit ( [string status])

void exit ( int status)
Note: This is not a real function, but a language construct. 
Note: PHP version >= 4.2.0 does NOT print the status if it is an 
integer. 
The exit() function terminates execution of the script. It prints status 
just before exiting. 
If status is an integer, that value will also be used as the exit status. 
Exit statuses should be in the range 1 to 254, the exit status 255 is 
reserved by PHP and shall not be used. 
Example 1. exit() example
  <?php

  $filename = '/path/to/data-file';
  $file = fopen($filename, 'r')
      or exit("unable to open file ($filename)");

  ?> 
Note: The die() function is an alias for exit(). 
See also: register_shutdown_function().   evalUpget_browser
#

#T=void exit ( [string status])
exit ( ^![string status]);
#

#T=exp - float exp ( float arg)
(PHP 3, PHP 4 )
exp -- Calculates the exponent of e (the Neperian or Natural logarithm 
base)
Description
float exp ( float arg)
Returns e raised to the power of arg. 
Note: 'e' is the base of the natural system of logarithms, or 
approximately 2.718282. 
Example 1. exp() example
  <?php
  echo exp(12) . "\n";
  echo exp(5.7);
  ?> 

The above example will output: 
1.6275E+005
298.87
See also log() and pow().   deg2radUpexpm1
#

#T=float exp ( float arg)
exp ( ^!float arg);
#

#T=explode - array explode ( string separator, string string [, int limit])
(PHP 3, PHP 4 )
explode -- Split a string by string
Description
array explode ( string separator, string string [, int limit])
Returns an array of strings, each of which is a substring of string formed 
by splitting it on boundaries formed by the string separator. If limit is 
set, the returned array will contain a maximum of limit elements with the 
last element containing the rest of string. 
If separator is an empty string (""), explode() will return FALSE. If 
separator contains a value that is not contained in string, then explode() 
will return an array containing string. 
Although implode() can, for historical reasons, accept its parameters in 
either order, explode() cannot. You must ensure that the separator 
argument comes before the string argument. 
Note: The limit parameter was added in PHP 4.0.1 
Example 1. explode() examples
  <?php
  // Example 1
  $pizza  = "piece1 piece2 piece3 piece4 piece5 piece6";
  $pieces = explode(" ", $pizza);
  echo $pieces[0]; // piece1
  echo $pieces[1]; // piece2

  // Example 2
  $data = "foo:*:1023:1000::/home/foo:/bin/sh";
  list($user, $pass, $uid, $gid, $gecos, $home, $shell) = 
  explode(":", $data);
  echo $user; // foo
  echo $pass; // *

  ?> 
See also preg_split(), spliti(), split(), and implode().   echoUpfprintf
#

#T=array explode ( string separator, string string [, int limit])
explode ( ^!string separator, string string [, int limit]);
#

#T=expm1 - float expm1 ( float number)
(PHP 4 >= 4.1.0)
expm1 --  Returns exp(number) - 1, computed in a way that is accurate even 
when the value of number is close to zero 
Description
float expm1 ( float number)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Warning
This function is currently not documented; only the argument list is 
available.

Note: This function is not implemented on Windows platforms.  expUpfloor
#

#T=float expm1 ( float number)
expm1 ( ^!float number);
#

#T=extension_loaded - bool extension_loaded ( string name)
(PHP 3>= 3.0.10, PHP 4 )
extension_loaded -- Find out whether an extension is loaded
Description
bool extension_loaded ( string name)
Returns TRUE if the extension identified by name is loaded, FALSE 
otherwise. 
Example 1. extension_loaded() example
  <?php
  if (!extension_loaded('gd')) {
      if (!dl('gd.so')) {
	  exit;
      }
  }
  ?> 
You can see the names of various extensions by using phpinfo() or if 
you're using the CGI or CLI version of PHP you can use the -m switch to 
list all available extensions: $ php -m
[PHP Modules]
xml
tokenizer
standard
sockets
session
posix
pcre
overload
mysql
mbstring
ctype

[Zend Modules]

Note: extension_loaded() uses the internal extension name to test 
whether a certain extension is available or not. Most internal extension 
names are written in lower case but there may be extension available 
which also use uppercase letters. Be warned that this function compares 
case sensitive ! 
See also get_loaded_extensions(), get_extension_funcs(), phpinfo(), and 
dl().   dlUpget_cfg_var
#

#T=bool extension_loaded ( string name)
extension_loaded ( ^!string name);
#

#T=extract - int extract ( array var_array [, int extract_type [, string prefix]])
(PHP 3>= 3.0.7, PHP 4 )
extract --  Import variables into the current symbol table from an array 
Description
int extract ( array var_array [, int extract_type [, string prefix]])
This function is used to import variables from an array into the current 
symbol table. It takes an associative array var_array and treats keys as 
variable names and values as variable values. For each key/value pair it 
will create a variable in the current symbol table, subject to 
extract_type and prefix parameters. 
Note: Beginning with version 4.0.5, this function returns the number of 
variables extracted. 
Note: EXTR_IF_EXISTS and EXTR_PREFIX_IF_EXISTS was introduced in version 
4.2.0. 
Note: EXTR_REFS was introduced in version 4.3.0. 
extract() checks each key to see whether it has a valid variable name. It 
also checks for collisions with existing variables in the symbol table. 
The way invalid/numeric keys and collisions are treated is determined by 
the extract_type. It can be one of the following values: 
EXTR_OVERWRITE
If there is a collision, overwrite the existing variable. 
EXTR_SKIP
If there is a collision, don't overwrite the existing variable. 
EXTR_PREFIX_SAME
If there is a collision, prefix the variable name with prefix. 
EXTR_PREFIX_ALL
Prefix all variable names with prefix. Beginning with PHP 4.0.5, this 
includes numeric variables as well. 
EXTR_PREFIX_INVALID
Only prefix invalid/numeric variable names with prefix. This flag was 
added in PHP 4.0.5. 
EXTR_IF_EXISTS
Only overwrite the variable if it already exists in the current symbol 
table, otherwise do nothing. This is useful for defining a list of valid 
variables and then extracting only those variables you have defined out 
of $_REQUEST, for example. This flag was added in PHP 4.2.0. 
EXTR_PREFIX_IF_EXISTS
Only create prefixed variable names if the non-prefixed version of the 
same variable exists in the current symbol table. This flag was added in 
PHP 4.2.0. 
EXTR_REFS
Extracts variables as references. This effectively means that the values 
of the imported variables are still referencing the values of the 
var_array parameter. You can use this flag on its own or combine it with 
any other flag by OR'ing the extract_type. This flag was added in PHP 
4.3.0. 
If extract_type is not specified, it is assumed to be EXTR_OVERWRITE. 
Note that prefix is only required if extract_type is EXTR_PREFIX_SAME, 
EXTR_PREFIX_ALL, EXTR_PREFIX_INVALID or EXTR_PREFIX_IF_EXISTS. If the 
prefixed result is not a valid variable name, it is not imported into the 
symbol table. 
extract() returns the number of variables successfully imported into the 
symbol table. 
A possible use for extract() is to import into the symbol table variables 
contained in an associative array returned by wddx_deserialize(). 
Example 1. extract() example
  <?php

  /* Suppose that $var_array is an array returned from
     wddx_deserialize */

  $size = "large";
  $var_array = array("color" => "blue",
		     "size"  => "medium",
		     "shape" => "sphere");
  extract($var_array, EXTR_PREFIX_SAME, "wddx");

  echo "$color, $size, $shape, $wddx_size\n";

  ?> 

The above example will produce: 
blue, large, sphere, medium
The $size wasn't overwritten, because we specified EXTR_PREFIX_SAME, which 
resulted in $wddx_size being created. If EXTR_SKIP was specified, then 
$wddx_size wouldn't even have been created. EXTR_OVERWRITE would have 
caused $size to have value "medium", and EXTR_PREFIX_ALL would result in 
new variables being named $wddx_color, $wddx_size, and $wddx_shape. 
You must use an associative array, a numerically indexed array will not 
produce results unless you use EXTR_PREFIX_ALL or EXTR_PREFIX_INVALID. 
See also compact().   endUpin_array
#

#T=int extract ( array var_array [, int extract_type [, string prefix]])
extract ( ^!array var_array [, int extract_type [, string prefix]]);
#

#T=ezmlm_hash - int ezmlm_hash ( string addr)
(PHP 3>= 3.0.17, PHP 4 >= 4.0.2)
ezmlm_hash -- Calculate the hash value needed by EZMLM
Description
int ezmlm_hash ( string addr)
ezmlm_hash() calculates the hash value needed when keeping EZMLM mailing 
lists in a MySQL database. 
Example 1. Calculating the hash and subscribing a user
  <?php

  $user = "joecool@example.com";
  $hash = ezmlm_hash($user);
  $query = sprintf("INSERT INTO sample VALUES (%s, '%s')", 
  $hash, $user);
  $db->query($query); // using PHPLIB db interface

  ?> 

  Mail functionsUpmail
#

#T=int ezmlm_hash ( string addr)
ezmlm_hash ( ^!string addr);
#

#T=fam_cancel_monitor - bool fam_cancel_monitor ( resource fam, resource fam_monitor)
(PHP 5 CVS only)
fam_cancel_monitor -- Terminate monitoring
Description
bool fam_cancel_monitor ( resource fam, resource fam_monitor)
fam_cancel_monitor() terminates monitoring on a resource previously 
requested using one of the fam_monitor_...(). 
See also fam_monitor_file(), fam_monitor_directory(), 
fam_monitor_collection(), and fam_suspend_monitor()   File alteration monitor functionsUpfam_close
#

#T=bool fam_cancel_monitor ( resource fam, resource fam_monitor)
fam_cancel_monitor ( ^!resource fam, resource fam_monitor);
#

#T=fam_close - void fam_close ( resource fam)
(PHP 5 CVS only)
fam_close -- Close FAM connection
Description
void fam_close ( resource fam)
fam_close() closes a connection to the FAM service previously opened using 
fam_open().   fam_cancel_monitorUpfam_monitor_collection
#

#T=void fam_close ( resource fam)
fam_close ( ^!resource fam);
#

#T=fam_monitor_collection - resource fam_monitor_collection ( resource fam, string dirname, int depth, 
(PHP 5 CVS only)
fam_monitor_collection -- Monitor a collection of files in a directory for 
changes
Description
resource fam_monitor_collection ( resource fam, string dirname, int depth, 
string mask)
fam_monitor_file() requests monitoring for a collection of files within a 
directory. The actual files to be monitored are specified by a directory 
path in dirname, the maximum search depth starting from this directory and 
a shell pattern restricting the file names to look for. 
See also fam_monitor_file(), fam_monitor_directory(), 
fam_cancel_monitor(), fam_suspend_monitor(), and fam_resume_monitor().   fam_closeUpfam_monitor_directory
#

#T=resource fam_monitor_collection ( resource fam, string dirname, int depth, 
fam_monitor_collection ( ^!resource fam, string dirname, int depth, ;
#

#T=fam_monitor_directory - resource fam_monitor_directory ( resource fam, string dirname)
(PHP 5 CVS only)
fam_monitor_directory -- Monitor a directory for changes
Description
resource fam_monitor_directory ( resource fam, string dirname)
fam_monitor_file() requests monitoring for a directory and all contained 
files. A FAM event will be generated whenever the status of the directory 
(i.e. the result of function stat() on that directory) or its content 
(i.e. the results of readdir()) change. 
See also fam_monitor_file(), fam_monitor_collection(), 
fam_cancel_monitor(), fam_suspend_monitor(), and fam_resume_monitor().   fam_monitor_collectionUpfam_monitor_file
#

#T=resource fam_monitor_directory ( resource fam, string dirname)
fam_monitor_directory ( ^!resource fam, string dirname);
#

#T=fam_monitor_file - resource fam_monitor_file ( resource fam, string filename)
(PHP 5 CVS only)
fam_monitor_file -- Monitor a regular file for changes
Description
resource fam_monitor_file ( resource fam, string filename)
fam_monitor_file() requests monitoring for a single file. A FAM event will 
be generated whenever the file status (i.e. the result of function stat() 
on that file) changes. 
See also fam_monitor_directory(), fam_monitor_collection(), 
fam_cancel_monitor(), fam_suspend_monitor(), and fam_resume_monitor().   fam_monitor_directoryUpfam_next_event
#

#T=resource fam_monitor_file ( resource fam, string filename)
fam_monitor_file ( ^!resource fam, string filename);
#

#T=fam_next_event - array fam_next_event ( resource fam)
(PHP 5 CVS only)
fam_next_event -- ...
Description
array fam_next_event ( resource fam)
fam_next_event() returns the next pending FAM event. The function will 
block until an event is available which can be checked for using 
fam_pending(). 
fam_ext_event() will return an array that contains a FAM event code in 
element 'code', the path of the file this event applies to in element 
'filename' and optionally a hostname in element 'hostname'. 
The possible event codes are described in detail in the introduction part 
of this section. 
See also fam_pending().   fam_monitor_fileUpfam_open
#

#T=array fam_next_event ( resource fam)
fam_next_event ( ^!resource fam);
#

#T=fam_open - resource fam_open ( [string appname])
(PHP 5 CVS only)
fam_open -- Open connection to FAM daemon
Description
resource fam_open ( [string appname])
fam_open() opens a connection to the FAM service daemon. The optional 
parameter appname should be set to a string identifying the application 
for logging reasons. 
See also fam_close().   fam_next_eventUpfam_pending
#

#T=resource fam_open ( [string appname])
fam_open ( ^![string appname]);
#

#T=fam_pending - bool fam_pending ( resource fam)
(PHP 5 CVS only)
fam_pending -- Check for pending FAM events
Description
bool fam_pending ( resource fam)
fam_pending() returns TRUE if events are available to be fetched using 
fam_next_event(). 
See also fam_next_event().   fam_openUpfam_resume_monitor
#

#T=bool fam_pending ( resource fam)
fam_pending ( ^!resource fam);
#

#T=fam_resume_monitor - bool fam_resume_monitor ( resource fam, resource fam_monitor)
(PHP 5 CVS only)
fam_resume_monitor -- Resume suspended monitoring
Description
bool fam_resume_monitor ( resource fam, resource fam_monitor)
fam_resume_monitor() resumes monitoring of a resource previously suspend 
using fam_suspend_monitor(). 
See also fam_suspend_monitor().   fam_pendingUpfam_suspend_monitor
#

#T=bool fam_resume_monitor ( resource fam, resource fam_monitor)
fam_resume_monitor ( ^!resource fam, resource fam_monitor);
#

#T=fam_suspend_monitor - bool fam_suspend_monitor ( resource fam, resource fam_monitor)
(PHP 5 CVS only)
fam_suspend_monitor -- Temporarily suspend monitoring
Description
bool fam_suspend_monitor ( resource fam, resource fam_monitor)
fam_suspend_monitor() temporarily suspend monitoring of a resource 
previously requested using one of the fam_monitor_...() functions. 
Monitoring can later be continued using fam_resume_monitor() without the 
need of requesting a complete new monitor. 
See also fam_resume_monitor(), and fam_cancel_monitor().   fam_resume_monitorUpFrontBase Functions
#

#T=bool fam_suspend_monitor ( resource fam, resource fam_monitor)
fam_suspend_monitor ( ^!resource fam, resource fam_monitor);
#

#T=fbsql_affected_rows - int fbsql_affected_rows ( [resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_affected_rows --  Get number of affected rows in previous FrontBase 
operation 
Description
int fbsql_affected_rows ( [resource link_identifier])
fbsql_affected_rows() returns the number of rows affected by the last 
INSERT, UPDATE or DELETE query associated with link_identifier. If the 
link identifier isn't specified, the last link opened by fbsql_connect() 
is assumed. 
Note: If you are using transactions, you need to call 
fbsql_affected_rows() after your INSERT, UPDATE, or DELETE query, not 
after the commit. 
If the last query was a DELETE query with no WHERE clause, all of the 
records will have been deleted from the table but this function will 
return zero. 
Note: When using UPDATE, FrontBase will not update columns where the new 
value is the same as the old value. This creates the possibility that 
fbsql_affected_rows() may not actually equal the number of rows matched, 
only the number of rows that were literally affected by the query. 
If the last query failed, this function will return -1. 
See also: fbsql_num_rows().   FrontBase FunctionsUpfbsql_autocommit
#

#T=int fbsql_affected_rows ( [resource link_identifier])
fbsql_affected_rows ( ^![resource link_identifier]);
#

#T=fbsql_autocommit - bool fbsql_autocommit ( resource link_identifier [, bool OnOff])
(PHP 4 >= 4.0.6)
fbsql_autocommit -- Enable or disable autocommit
Description
bool fbsql_autocommit ( resource link_identifier [, bool OnOff])
fbsql_autocommit() returns the current autocommit status. If the optional 
OnOff parameter is given the auto commit status will be changed. With 
OnOff set to TRUE each statement will be committed automatically, if no 
errors was found. With OnOff set to FALSE the user must commit or rollback 
the transaction using either fbsql_commit() or fbsql_rollback(). 
See also: fbsql_commit() and fbsql_rollback()   fbsql_affected_rowsUpfbsql_change_user
fbsql_change_user
(no version information, might be only in CVS)
fbsql_change_user --  Change logged in user of the active connection 
Description
resource fbsql_change_user ( string user, string password [, string 
database [, resource link_identifier]])
fbsql_change_user() changes the logged in user of the current active 
connection, or the connection given by the optional parameter 
link_identifier. If a database is specified, this will default or current 
database after the user has been changed. If the new user and password 
authorization fails, the current connected user stays active.   fbsql_autocommitUpfbsql_close
#

#T=bool fbsql_autocommit ( resource link_identifier [, bool OnOff])
fbsql_autocommit ( ^!resource link_identifier [, bool OnOff]);
#

#T=fbsql_close - bool fbsql_close ( [resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_close -- Close FrontBase connection
Description
bool fbsql_close ( [resource link_identifier])
Returns: TRUE on success, FALSE on error. 
fbsql_close() closes the connection to the FrontBase server that's 
associated with the specified link identifier. If link_identifier isn't 
specified, the last opened link is used. 
Using fbsql_close() isn't usually necessary, as non-persistent open links 
are automatically closed at the end of the script's execution. 
Example 1. fbsql_close() example
  <?php
      $link = fbsql_connect("localhost", "_SYSTEM", "secret")
	  or die("Could not connect");
      echo "Connected successfully";
      fbsql_close($link);
  ?> 
See also: fbsql_connect() and fbsql_pconnect().   fbsql_change_userUpfbsql_commit
#

#T=bool fbsql_close ( [resource link_identifier])
fbsql_close ( ^![resource link_identifier]);
#

#T=fbsql_commit - bool fbsql_commit ( [resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_commit -- Commits a transaction to the database
Description
bool fbsql_commit ( [resource link_identifier])
Returns TRUE on success or FALSE on failure. 
fbsql_commit() ends the current transaction by writing all inserts, 
updates and deletes to the disk and unlocking all row and table locks held 
by the transaction. This command is only needed if autocommit is set to 
false. 
See also: fbsql_autocommit() and fbsql_rollback()   fbsql_closeUpfbsql_connect
#

#T=bool fbsql_commit ( [resource link_identifier])
fbsql_commit ( ^![resource link_identifier]);
#

#T=fbsql_connect - resource fbsql_connect ( [string hostname [, string username [, string 
(PHP 4 >= 4.0.6)
fbsql_connect -- Open a connection to a FrontBase Server
Description
resource fbsql_connect ( [string hostname [, string username [, string 
password]]])
Returns a positive FrontBase link identifier on success, or an error 
message on failure. 
fbsql_connect() establishes a connection to a FrontBase server. The 
following defaults are assumed for missing optional parameters: hostname = 
'NULL', username = '_SYSTEM' and password = empty password. 
If a second call is made to fbsql_connect() with the same arguments, no 
new link will be established, but instead, the link identifier of the 
already opened link will be returned. 
The link to the server will be closed as soon as the execution of the 
script ends, unless it's closed earlier by explicitly calling 
fbsql_close(). 
Example 1. fbsql_connect() example
  <?php

      $link = fbsql_connect("localhost", "_SYSTEM", "secret")
	  or die("Could not connect");
      echo "Connected successfully";
      fbsql_close($link);

  ?> 
See also fbsql_pconnect() and fbsql_close().   fbsql_commitUpfbsql_create_blob
#

#T=resource fbsql_connect ( [string hostname [, string username [, string 
fbsql_connect ( ^![string hostname [, string username [, string ;
#

#T=fbsql_create_blob - string fbsql_create_blob ( string blob_data [, resource link_identifier])
(PHP 4 >= 4.2.0)
fbsql_create_blob -- Create a BLOB
Description
string fbsql_create_blob ( string blob_data [, resource link_identifier])
Returns: A resource handle to the newly created blob. 
fbsql_create_blob() creates a blob from blob_data. The returned resource 
handle can be used with insert and update commands to store the blob in 
the database. 
Example 1. fbsql_create_blob() example
  <?php
      $link = fbsql_pconnect("localhost", "_SYSTEM", "secret")
	  or die("Could not connect");
      $filename = "blobfile.bin";
      $fp = fopen($filename, "rb");
      $blobdata = fread($fp, filesize($filename));
      fclose($fp);
      
      $blobHandle = fbsql_create_blob($blobdata, $link);
      
      $sql = "INSERT INTO BLOB_TABLE (BLOB_COLUMN) VALUES 
  ($blobHandle);";
      $rs = fbsql_query($sql, $link);
  ?> 
See also: fbsql_create_clob(), fbsql_read_blob(), fbsql_read_clob(), and 
fbsql_set_lob_mode().   fbsql_connectUpfbsql_create_clob
#

#T=string fbsql_create_blob ( string blob_data [, resource link_identifier])
fbsql_create_blob ( ^!string blob_data [, resource link_identifier]);
#

#T=fbsql_create_clob - string fbsql_create_clob ( string clob_data [, resource link_identifier])
(PHP 4 >= 4.2.0)
fbsql_create_clob -- Create a CLOB
Description
string fbsql_create_clob ( string clob_data [, resource link_identifier])
Returns: A resource handle to the newly created CLOB. 
fbsql_create_clob() creates a clob from clob_data. The returned resource 
handle can be used with insert and update commands to store the clob in 
the database. 
Example 1. fbsql_create_clob() example
  <?php
      $link = fbsql_pconnect("localhost", "_SYSTEM", "secret")
	  or die("Could not connect");
      $filename = "clob_file.txt";
      $fp = fopen($filename, "rb");
      $clobdata = fread($fp, filesize($filename));
      fclose($fp);
      
      $clobHandle = fbsql_create_clob($clobdata, $link);
      
      $sql = "INSERT INTO CLOB_TABLE (CLOB_COLUMN) VALUES 
  ($clobHandle);";
      $rs = fbsql_query($sql, $link);
  ?> 
See also: fbsql_create_blob(), fbsql_read_blob(), fbsql_read_clob(), and 
fbsql_set_lob_mode().   fbsql_create_blobUpfbsql_create_db
#

#T=string fbsql_create_clob ( string clob_data [, resource link_identifier])
fbsql_create_clob ( ^!string clob_data [, resource link_identifier]);
#

#T=fbsql_create_db - bool fbsql_create_db ( string database_name [, resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_create_db -- Create a FrontBase database
Description
bool fbsql_create_db ( string database_name [, resource link_identifier])
fbsql_create_db() attempts to create a new database named database_name on 
the server associated with the specified connection link_identifier. 
Example 1. fbsql_create_db() example
  <?php
      $link = fbsql_pconnect("localhost", "_SYSTEM", "secret")
	  or die("Could not connect");
      if (fbsql_create_db("my_db")) {
	  echo "Database created successfully\n";
      } else {
	  printf("Error creating database: %s\n", 
fbsql_error());
      }
  ?> 
See also: fbsql_drop_db().   fbsql_create_clobUpfbsql_data_seek
#

#T=bool fbsql_create_db ( string database_name [, resource link_identifier])
fbsql_create_db ( ^!string database_name [, resource link_identifier]);
#

#T=fbsql_data_seek - bool fbsql_data_seek ( resource result_identifier, int row_number)
(PHP 4 >= 4.0.6)
fbsql_data_seek -- Move internal result pointer
Description
bool fbsql_data_seek ( resource result_identifier, int row_number)
Returns TRUE on success or FALSE on failure. 
fbsql_data_seek() moves the internal row pointer of the FrontBase result 
associated with the specified result identifier to point to the specified 
row number. The next call to fbsql_fetch_row() would return that row. 
Row_number starts at 0. 
Example 1. fbsql_data_seek() example
  <?php
      $link = fbsql_pconnect("localhost", "_SYSTEM", "secret")
	  or die("Could not connect");

      fbsql_select_db("samp_db")
	  or die("Could not select database");

      $query = "SELECT last_name, first_name FROM friends;";
      $result = fbsql_query($query)
	  or die("Query failed");

      // fetch rows in reverse order

      for ($i = fbsql_num_rows($result) - 1; $i >=0; $i--) {
	  if (!fbsql_data_seek($result, $i)) {
	      printf("Cannot seek to row %d\n", $i);
	      continue;
	  }

	  if (!($row = fbsql_fetch_object($result)))
	      continue;

	  echo $row->last_name . $row->first_name . "<br />\n";
      }

      fbsql_free_result($result);
  ?> 

  fbsql_create_dbUpfbsql_database_password
#

#T=bool fbsql_data_seek ( resource result_identifier, int row_number)
fbsql_data_seek ( ^!resource result_identifier, int row_number);
#

#T=fbsql_database_password - string fbsql_database_password ( resource link_identifier [, string 
(PHP 4 >= 4.0.6)
fbsql_database_password --  Sets or retrieves the password for a FrontBase 
database 
Description
string fbsql_database_password ( resource link_identifier [, string 
database_password])
Returns: The database password associated with the link identifier. 
fbsql_database_password() sets and retrieves the database password used by 
the connection. if a database is protected by a database password, the 
user must call this function before calling fbsql_select_db(). if the 
second optional parameter is given the function sets the database password 
for the specified link identifier. If no link identifier is specified, the 
last opened link is assumed. If no link is open, the function will try to 
establish a link as if fbsql_connect() was called, and use it. 
This function does not change the database password in the database nor 
can it be used to retrieve the database password for a database. 
Example 1. fbsql_create_clob() example
  <?php
      $link = fbsql_pconnect("localhost", "_SYSTEM", "secret")
	  or die("Could not connect");
      fbsql_database_password($link, "secret db password");
      fbsql_select_db($database, $link);
  ?> 
See also: fbsql_connect(), fbsql_pconnect() and fbsql_select_db().   fbsql_data_seekUpfbsql_database
#

#T=string fbsql_database_password ( resource link_identifier [, string 
fbsql_database_password ( ^!resource link_identifier [, string ;
#

#T=fbsql_database - string fbsql_database ( resource link_identifier [, string database])
(PHP 4 >= 4.0.6)
fbsql_database -- Get or set the database name used with a connection
Description
string fbsql_database ( resource link_identifier [, string database])
Warning
This function is currently not documented; only the argument list is 
available.
  fbsql_database_passwordUpfbsql_db_query
#

#T=string fbsql_database ( resource link_identifier [, string database])
fbsql_database ( ^!resource link_identifier [, string database]);
#

#T=fbsql_db_query - resource fbsql_db_query ( string database, string query [, resource 
(PHP 4 >= 4.0.6)
fbsql_db_query -- Send a FrontBase query
Description
resource fbsql_db_query ( string database, string query [, resource 
link_identifier])
Returns: A positive FrontBase result identifier to the query result, or 
FALSE on error. 
fbsql_db_query() selects a database and executes a query on it. If the 
optional link identifier isn't specified, the function will try to find an 
open link to the FrontBase server and if no such link is found it'll try 
to create one as if fbsql_connect() was called with no arguments 
See also fbsql_connect().   fbsql_databaseUpfbsql_db_status
#

#T=resource fbsql_db_query ( string database, string query [, resource 
fbsql_db_query ( ^!string database, string query [, resource ;
#

#T=fbsql_db_status - int fbsql_db_status ( string database_name [, resource link_identifier])
(PHP 4 >= 4.1.0)
fbsql_db_status -- Get the status for a given database
Description
int fbsql_db_status ( string database_name [, resource link_identifier])
Returns: An integer value with the current status. 
fbsql_db_status() requests the current status of the database specified by 
database_name. If the link_identifier is omitted the default 
link_identifier will be used. 
The return value can be one of the following constants: 
FALSE - The exec handler for the host was invalid. This error will occur 
when the link_identifier connects directly to a database by using a port 
number. FBExec can be available on the server but no connection has been 
made for it. 
FBSQL_UNKNOWN - The Status is unknown. 
FBSQL_STOPPED - The database is not running. Use fbsql_start_db() to 
start the database. 
FBSQL_STARTING - The database is starting. 
FBSQL_RUNNING - The database is running and can be used to perform SQL 
operations. 
FBSQL_STOPPING - The database is stopping. 
FBSQL_NOEXEC - FBExec is not running on the server and it is not 
possible to get the status of the database. 
See also: fbsql_start_db() and fbsql_stop_db().   fbsql_db_queryUpfbsql_drop_db
#

#T=int fbsql_db_status ( string database_name [, resource link_identifier])
fbsql_db_status ( ^!string database_name [, resource link_identifier]);
#

#T=fbsql_drop_db - bool fbsql_drop_db ( string database_name [, resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_drop_db -- Drop (delete) a FrontBase database
Description
bool fbsql_drop_db ( string database_name [, resource link_identifier])
Returns TRUE on success or FALSE on failure. 
fbsql_drop_db() attempts to drop (remove) an entire database from the 
server associated with the specified link identifier.   fbsql_db_statusUpfbsql_errno
#

#T=bool fbsql_drop_db ( string database_name [, resource link_identifier])
fbsql_drop_db ( ^!string database_name [, resource link_identifier]);
#

#T=fbsql_errno - int fbsql_errno ( [resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_errno --  Returns the numerical value of the error message from 
previous FrontBase operation 
Description
int fbsql_errno ( [resource link_identifier])
Returns the error number from the last fbsql function, or 0 (zero) if no 
error occurred. 
Errors coming back from the fbsql database backend don't issue warnings. 
Instead, use fbsql_errno() to retrieve the error code. Note that this 
function only returns the error code from the most recently executed fbsql 
function (not including fbsql_error() and fbsql_errno()), so if you want 
to use it, make sure you check the value before calling another fbsql 
function. 
<?php
fbsql_connect("marliesle");
echo fbsql_errno() . ": " . fbsql_error() . "<br />";
fbsql_select_db("nonexistentdb");
echo fbsql_errno() . ": " . fbsql_error() . "<br />";
$conn = fbsql_query("SELECT * FROM nonexistenttable;");
echo fbsql_errno() . ": " . fbsql_error() . "<br />";
?> 

See also: fbsql_error() and fbsql_warnings().   fbsql_drop_dbUpfbsql_error
#

#T=int fbsql_errno ( [resource link_identifier])
fbsql_errno ( ^![resource link_identifier]);
#

#T=fbsql_error - string fbsql_error ( [resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_error --  Returns the text of the error message from previous 
FrontBase operation 
Description
string fbsql_error ( [resource link_identifier])
Returns the error text from the last fbsql function, or '' (the empty 
string) if no error occurred. 
Errors coming back from the fbsql database backend don't issue warnings. 
Instead, use fbsql_error() to retrieve the error text. Note that this 
function only returns the error text from the most recently executed fbsql 
function (not including fbsql_error() and fbsql_errno()), so if you want 
to use it, make sure you check the value before calling another fbsql 
function. 
<?php
fbsql_connect("marliesle");
echo fbsql_errno() . ": " . fbsql_error() . "<br />";
fbsql_select_db("nonexistentdb");
echo fbsql_errno() . ": " . fbsql_error() . "<br />";
$conn = fbsql_query("SELECT * FROM nonexistenttable;");
echo fbsql_errno() . ": " . fbsql_error() . "<br />";
?> 

See also: fbsql_errno() and fbsql_warnings().   fbsql_errnoUpfbsql_fetch_array
#

#T=string fbsql_error ( [resource link_identifier])
fbsql_error ( ^![resource link_identifier]);
#

#T=fbsql_fetch_array - array fbsql_fetch_array ( resource result [, int result_type])
(PHP 4 >= 4.0.6)
fbsql_fetch_array --  Fetch a result row as an associative array, a 
numeric array, or both 
Description
array fbsql_fetch_array ( resource result [, int result_type])
Returns an array that corresponds to the fetched row, or FALSE if there 
are no more rows. 
fbsql_fetch_array() is an extended version of fbsql_fetch_row(). In 
addition to storing the data in the numeric indices of the result array, 
it also stores the data in associative indices, using the field names as 
keys. 
If two or more columns of the result have the same field names, the last 
column will take precedence. To access the other column(s) of the same 
name, you must the numeric index of the column or make an alias for the 
column. 
select t1.f1 as foo t2.f1 as bar from t1, t2

An important thing to note is that using fbsql_fetch_array() is NOT 
significantly slower than using fbsql_fetch_row(), while it provides a 
significant added value. 
The optional second argument result_type in fbsql_fetch_array() is a 
constant and can take the following values: FBSQL_ASSOC, FBSQL_NUM, and 
FBSQL_BOTH. 
For further details, see also fbsql_fetch_row() and fbsql_fetch_assoc(). 
Example 1. fbsql_fetch_array() example
  <?php 
  fbsql_connect($host, $user, $password);
  $result = fbsql_db_query("database", "select user_id, fullname 
  from table");
  while ($row = fbsql_fetch_array($result)) {
      echo "user_id: " . $row["user_id"] . "<br />\n";
      echo "user_id: " . $row[0] . "<br />\n";
      echo "fullname: " . $row["fullname"] . "<br />\n";
      echo "fullname: " . $row[1] . "<br />\n";
  }
  fbsql_free_result($result);
  ?> 

  fbsql_errorUpfbsql_fetch_assoc
#

#T=array fbsql_fetch_array ( resource result [, int result_type])
fbsql_fetch_array ( ^!resource result [, int result_type]);
#

#T=fbsql_fetch_assoc - array fbsql_fetch_assoc ( resource result)
(PHP 4 >= 4.0.6)
fbsql_fetch_assoc --  Fetch a result row as an associative array 
Description
array fbsql_fetch_assoc ( resource result)
Returns an associative array that corresponds to the fetched row, or FALSE 
if there are no more rows.
fbsql_fetch_assoc() is equivalent to calling fbsql_fetch_array() with 
FBSQL_ASSOC for the optional second parameter. It only returns an 
associative array. This is the way fbsql_fetch_array() originally worked. 
If you need the numeric indices as well as the associative, use 
fbsql_fetch_array(). 
If two or more columns of the result have the same field names, the last 
column will take precedence. To access the other column(s) of the same 
name, you must use fbsql_fetch_array() and have it return the numeric 
indices as well. 
An important thing to note is that using fbsql_fetch_assoc() is NOT 
significantly slower than using fbsql_fetch_row(), while it provides a 
significant added value. 
For further details, see also fbsql_fetch_row() and fbsql_fetch_array(). 
Example 1. fbsql_fetch_assoc() example
  <?php 
  fbsql_connect($host, $user, $password);
  $result = fbsql_db_query("database", "select * from table");
  while ($row = fbsql_fetch_assoc($result)) {
      echo $row["user_id"];
      echo $row["fullname"];
  }
  fbsql_free_result($result);
  ?> 

  fbsql_fetch_arrayUpfbsql_fetch_field
#

#T=array fbsql_fetch_assoc ( resource result)
fbsql_fetch_assoc ( ^!resource result);
#

#T=fbsql_fetch_field - object fbsql_fetch_field ( resource result [, int field_offset])
(PHP 4 >= 4.0.6)
fbsql_fetch_field --  Get column information from a result and return as 
an object 
Description
object fbsql_fetch_field ( resource result [, int field_offset])
Returns an object containing field information. 
fbsql_fetch_field() can be used in order to obtain information about 
fields in a certain query result. If the field offset isn't specified, the 
next field that wasn't yet retrieved by fbsql_fetch_field() is retrieved. 
The properties of the object are: 
name - column name 
table - name of the table the column belongs to 
max_length - maximum length of the column 
not_null - 1 if the column cannot be NULL 
type - the type of the column 
Example 1. fbsql_fetch_field() example
  <?php 
  fbsql_connect($host, $user, $password)
      or die("Could not connect");
  $result = fbsql_db_query("database", "select * from table")
      or die("Query failed");
  # get column metadata
  $i = 0;
  while ($i < fbsql_num_fields($result)) {
      echo "Information for column $i:<br />\n";
      $meta = fbsql_fetch_field($result);
      if (!$meta) {
	  echo "No information available<br />\n";
      }
      echo "<pre>
  max_length:   $meta->max_length
  name:         $meta->name
  not_null:     $meta->not_null
  table:        $meta->table
  type:         $meta->type
  </pre>";
      $i++;
  }
  fbsql_free_result($result);
  ?> 
See also fbsql_field_seek().   fbsql_fetch_assocUpfbsql_fetch_lengths
#

#T=object fbsql_fetch_field ( resource result [, int field_offset])
fbsql_fetch_field ( ^!resource result [, int field_offset]);
#

#T=fbsql_fetch_lengths - array fbsql_fetch_lengths ( [resource result])
(PHP 4 >= 4.0.6)
fbsql_fetch_lengths --  Get the length of each output in a result 
Description
array fbsql_fetch_lengths ( [resource result])
Returns: An array that corresponds to the lengths of each field in the 
last row fetched by fbsql_fetch_row(), or FALSE on error. 
fbsql_fetch_lengths() stores the lengths of each result column in the last 
row returned by fbsql_fetch_row(), fbsql_fetch_array() and 
fbsql_fetch_object() in an array, starting at offset 0. 
See also: fbsql_fetch_row().   fbsql_fetch_fieldUpfbsql_fetch_object
#

#T=array fbsql_fetch_lengths ( [resource result])
fbsql_fetch_lengths ( ^![resource result]);
#

#T=fbsql_fetch_object - object fbsql_fetch_object ( resource result [, int result_type])
(PHP 4 >= 4.0.6)
fbsql_fetch_object -- Fetch a result row as an object
Description
object fbsql_fetch_object ( resource result [, int result_type])
Returns an object with properties that correspond to the fetched row, or 
FALSE if there are no more rows. 
fbsql_fetch_object() is similar to fbsql_fetch_array(), with one 
difference - an object is returned, instead of an array. Indirectly, that 
means that you can only access the data by the field names, and not by 
their offsets (numbers are illegal property names). 
The optional argument result_type is a constant and can take the following 
values: FBSQL_ASSOC, FBSQL_NUM, and FBSQL_BOTH. 
Speed-wise, the function is identical to fbsql_fetch_array(), and almost 
as quick as fbsql_fetch_row() (the difference is insignificant). 
Example 1. fbsql_fetch_object() example
  <?php 
  fbsql_connect($host, $user, $password);
  $result = fbsql_db_query("database", "select * from table");
  while ($row = fbsql_fetch_object($result)) {
      echo $row->user_id;
      echo $row->fullname;
  }
  fbsql_free_result($result);
  ?> 
See also: fbsql_fetch_array() and fbsql_fetch_row().   fbsql_fetch_lengthsUpfbsql_fetch_row
#

#T=object fbsql_fetch_object ( resource result [, int result_type])
fbsql_fetch_object ( ^!resource result [, int result_type]);
#

#T=fbsql_fetch_row - array fbsql_fetch_row ( resource result)
(PHP 4 >= 4.0.6)
fbsql_fetch_row -- Get a result row as an enumerated array
Description
array fbsql_fetch_row ( resource result)
Returns: An array that corresponds to the fetched row, or FALSE if there 
are no more rows. 
fbsql_fetch_row() fetches one row of data from the result associated with 
the specified result identifier. The row is returned as an array. Each 
result column is stored in an array offset, starting at offset 0. 
Subsequent call to fbsql_fetch_row() would return the next row in the 
result set, or FALSE if there are no more rows. 
See also: fbsql_fetch_array(), fbsql_fetch_object(), fbsql_data_seek(), 
fbsql_fetch_lengths(), and fbsql_result().   fbsql_fetch_objectUpfbsql_field_flags
#

#T=array fbsql_fetch_row ( resource result)
fbsql_fetch_row ( ^!resource result);
#

#T=fbsql_field_flags - string fbsql_field_flags ( resource result, int field_offset)
(PHP 4 >= 4.0.6)
fbsql_field_flags --  Get the flags associated with the specified field in 
a result 
Description
string fbsql_field_flags ( resource result, int field_offset)
fbsql_field_flags() returns the field flags of the specified field. The 
flags are reported as a single word per flag separated by a single space, 
so that you can split the returned value using explode().   fbsql_fetch_rowUpfbsql_field_len
#

#T=string fbsql_field_flags ( resource result, int field_offset)
fbsql_field_flags ( ^!resource result, int field_offset);
#

#T=fbsql_field_len - int fbsql_field_len ( resource result, int field_offset)
(PHP 4 >= 4.0.6)
fbsql_field_len --  Returns the length of the specified field 
Description
int fbsql_field_len ( resource result, int field_offset)
fbsql_field_len() returns the length of the specified field.   fbsql_field_flagsUpfbsql_field_name
#

#T=int fbsql_field_len ( resource result, int field_offset)
fbsql_field_len ( ^!resource result, int field_offset);
#

#T=fbsql_field_name - string fbsql_field_name ( resource result, int field_index)
(PHP 4 >= 4.0.6)
fbsql_field_name --  Get the name of the specified field in a result 
Description
string fbsql_field_name ( resource result, int field_index)
fbsql_field_name() returns the name of the specified field index. result 
must be a valid result identifier and field_index is the numerical offset 
of the field. 
Note: field_index starts at 0. 
e.g. The index of the third field would actually be 2, the index of the 
fourth field would be 3 and so on. 
Example 1. fbsql_field_name() example
  <?php
  // The users table consists of three fields: 
  //   user_id
  //   username
  //   password.

  $res = fbsql_db_query("users", "select * from users", $link);

  echo fbsql_field_name($res, 0) . "\n";
  echo fbsql_field_name($res, 2);
  ?> 

The above example would produce the following output: 
user_id
password

  fbsql_field_lenUpfbsql_field_seek
#

#T=string fbsql_field_name ( resource result, int field_index)
fbsql_field_name ( ^!resource result, int field_index);
#

#T=fbsql_field_seek - bool fbsql_field_seek ( resource result, int field_offset)
(PHP 4 >= 4.0.6)
fbsql_field_seek --  Set result pointer to a specified field offset 
Description
bool fbsql_field_seek ( resource result, int field_offset)
Seeks to the specified field offset. If the next call to 
fbsql_fetch_field() doesn't include a field offset, the field offset 
specified in fbsql_field_seek() will be returned. 
See also: fbsql_fetch_field().   fbsql_field_nameUpfbsql_field_table
#

#T=bool fbsql_field_seek ( resource result, int field_offset)
fbsql_field_seek ( ^!resource result, int field_offset);
#

#T=fbsql_field_table - string fbsql_field_table ( resource result, int field_offset)
(PHP 4 >= 4.0.6)
fbsql_field_table --  Get name of the table the specified field is in 
Description
string fbsql_field_table ( resource result, int field_offset)
Returns the name of the table that the specified field is in.   fbsql_field_seekUpfbsql_field_type
#

#T=string fbsql_field_table ( resource result, int field_offset)
fbsql_field_table ( ^!resource result, int field_offset);
#

#T=fbsql_field_type - string fbsql_field_type ( resource result, int field_offset)
(PHP 4 >= 4.0.6)
fbsql_field_type --  Get the type of the specified field in a result 
Description
string fbsql_field_type ( resource result, int field_offset)
fbsql_field_type() is similar to the fbsql_field_name() function. The 
arguments are identical, but the field type is returned instead. The field 
type will be one of "int", "real", "string", "blob", and others as 
detailed in the FrontBase documentation. Example 1. 
fbsql_field_type() example
  <?php 

  fbsql_connect("localhost", "_SYSTEM", "");
  fbsql_select_db("wisconsin");
  $result = fbsql_query("SELECT * FROM onek;");
  $fields = fbsql_num_fields($result);
  $rows   = fbsql_num_rows($result);
  $i = 0;
  $table = fbsql_field_table($result, $i);
  echo "Your '" . $table . "' table has " . $fields . " fields 
  and " . $rows . " records <br />";
  echo "The table has the following fields <br />"; 
  while ($i < $fields) {
      $type  = fbsql_field_type($result, $i);
      $name  = fbsql_field_name($result, $i);
      $len   = fbsql_field_len($result, $i);
      $flags = fbsql_field_flags($result, $i);
      echo $type . " " . $name . " " . $len . " " . $flags . 
  "<br />";
      $i++;
  }
  fbsql_close();

  ?> 

  fbsql_field_tableUpfbsql_free_result
#

#T=string fbsql_field_type ( resource result, int field_offset)
fbsql_field_type ( ^!resource result, int field_offset);
#

#T=fbsql_free_result - bool fbsql_free_result ( resource result)
(PHP 4 >= 4.0.6)
fbsql_free_result -- Free result memory
Description
bool fbsql_free_result ( resource result)
fbsql_free_result() will free all memory associated with the result 
identifier result. 
fbsql_free_result() only needs to be called if you are concerned about how 
much memory is being used for queries that return large result sets. All 
associated result memory is automatically freed at the end of the script's 
execution.   fbsql_field_typeUpfbsql_get_autostart_info
#

#T=bool fbsql_free_result ( resource result)
fbsql_free_result ( ^!resource result);
#

#T=fbsql_get_autostart_info - 
array fbsql_get_autostart_info
(PHP 4 >= 4.1.0)
fbsql_get_autostart_info -- No description given yet
Description
array fbsql_get_autostart_info ( [resource link_identifier])
Warning
This function is currently not documented; only the argument list is 
available.
  fbsql_free_resultUpfbsql_hostname
#

#T=
array fbsql_get_autostart_info

fbsql_get_autostart_info;^!
#

#T=fbsql_hostname - string fbsql_hostname ( resource link_identifier [, string host_name])
(PHP 4 >= 4.0.6)
fbsql_hostname -- Get or set the host name used with a connection
Description
string fbsql_hostname ( resource link_identifier [, string host_name])
Warning
This function is currently not documented; only the argument list is 
available.
  fbsql_get_autostart_infoUpfbsql_insert_id
#

#T=string fbsql_hostname ( resource link_identifier [, string host_name])
fbsql_hostname ( ^!resource link_identifier [, string host_name]);
#

#T=fbsql_insert_id - int fbsql_insert_id ( [resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_insert_id --  Get the id generated from the previous INSERT 
operation 
Description
int fbsql_insert_id ( [resource link_identifier])
fbsql_insert_id() returns the ID generated for an column defined as 
DEFAULT UNIQUE by the previous INSERT query using the given 
link_identifier. If link_identifier isn't specified, the last opened link 
is assumed. 
fbsql_insert_id() returns 0 if the previous query does not generate an 
DEFAULT UNIQUE value. If you need to save the value for later, be sure to 
call fbsql_insert_id() immediately after the query that generates the 
value. 
Note: The value of the FrontBase SQL function fbsql_insert_id() always 
contains the most recently generated DEFAULT UNIQUE value, and is not 
reset between queries.   fbsql_hostnameUpfbsql_list_dbs
#

#T=int fbsql_insert_id ( [resource link_identifier])
fbsql_insert_id ( ^![resource link_identifier]);
#

#T=fbsql_list_dbs - resource fbsql_list_dbs ( [resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_list_dbs --  List databases available on a FrontBase server 
Description
resource fbsql_list_dbs ( [resource link_identifier])
fbsql_list_dbs() will return a result pointer containing the databases 
available from the current fbsql daemon. Use the fbsql_tablename() 
function to traverse this result pointer. 
Example 1. fbsql_list_dbs() example
  $link = fbsql_connect('localhost', 'myname', 'secret');
  $db_list = fbsql_list_dbs($link);

  while ($row = fbsql_fetch_object($db_list)) {
      echo $row->Database . "\n";
  } 

The above example would produce the following output: 
database1
database2
database3
...
Note: The above code would just as easily work with fbsql_fetch_row() or 
other similar functions.   fbsql_insert_idUpfbsql_list_fields
#

#T=resource fbsql_list_dbs ( [resource link_identifier])
fbsql_list_dbs ( ^![resource link_identifier]);
#

#T=fbsql_list_fields - resource fbsql_list_fields ( string database_name, string table_name [, 
(PHP 4 >= 4.0.6)
fbsql_list_fields -- List FrontBase result fields
Description
resource fbsql_list_fields ( string database_name, string table_name [, 
resource link_identifier])
fbsql_list_fields() retrieves information about the given tablename. 
Arguments are the database name and the table name. A result pointer is 
returned which can be used with fbsql_field_flags(), fbsql_field_len(), 
fbsql_field_name(), and fbsql_field_type(). 
A result identifier is a positive integer. The function returns FALSE if 
an error occurs. A string describing the error will be placed in 
$phperrmsg, and unless the function was called as @fbsql() then this error 
string will also be printed out. 
Example 1. fbsql_list_fields() example
  <?php
  $link = fbsql_connect('localhost', 'myname', 'secret');

  $fields = fbsql_list_fields("database1", "table1", $link);
  $columns = fbsql_num_fields($fields);

  for ($i = 0; $i < $columns; $i++) {
      echo fbsql_field_name($fields, $i) . "\n";;
  }
  ?> 

The above example would produce the following output: 
field1
field2
field3
...

  fbsql_list_dbsUpfbsql_list_tables
#

#T=resource fbsql_list_fields ( string database_name, string table_name [, 
fbsql_list_fields ( ^!string database_name, string table_name [, ;
#

#T=fbsql_list_tables - resource fbsql_list_tables ( string database [, resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_list_tables -- List tables in a FrontBase database
Description
resource fbsql_list_tables ( string database [, resource link_identifier])
fbsql_list_tables() takes a database name and returns a result pointer 
much like the fbsql_db_query() function. The fbsql_tablename() function 
should be used to extract the actual table names from the result pointer.   fbsql_list_fieldsUpfbsql_next_result
#

#T=resource fbsql_list_tables ( string database [, resource link_identifier])
fbsql_list_tables ( ^!string database [, resource link_identifier]);
#

#T=fbsql_next_result - bool fbsql_next_result ( resource result_id)
(PHP 4 >= 4.0.6)
fbsql_next_result --  Move the internal result pointer to the next result 
Description
bool fbsql_next_result ( resource result_id)
When sending more than one SQL statement to the server or executing a 
stored procedure with multiple results will cause the server to return 
multiple result sets. This function will test for additional results 
available form the server. If an additional result set exists it will free 
the existing result set and prepare to fetch the words from the new result 
set. The function will return TRUE if an additional result set was 
available or FALSE otherwise. 
Example 1. fbsql_next_result() example
  <?php
      $link = fbsql_connect("localhost", "_SYSTEM", "secret");
      fbsql_select_db("MyDB", $link);
      $SQL = "Select * from table1; select * from table2;";
      $rs = fbsql_query($SQL, $link);
      do {
	  while ($row = fbsql_fetch_row($rs)) {
	  }
      } while (fbsql_next_result($rs));
      fbsql_free_result($rs);
      fbsql_close($link);
  ?> 

  fbsql_list_tablesUpfbsql_num_fields
#

#T=bool fbsql_next_result ( resource result_id)
fbsql_next_result ( ^!resource result_id);
#

#T=fbsql_num_fields - int fbsql_num_fields ( resource result)
(PHP 4 >= 4.0.6)
fbsql_num_fields -- Get number of fields in result
Description
int fbsql_num_fields ( resource result)
fbsql_num_fields() returns the number of fields in a result set. 
See also: fbsql_db_query(), fbsql_query(), fbsql_fetch_field(), and 
fbsql_num_rows().   fbsql_next_resultUpfbsql_num_rows
#

#T=int fbsql_num_fields ( resource result)
fbsql_num_fields ( ^!resource result);
#

#T=fbsql_num_rows - int fbsql_num_rows ( resource result)
(PHP 4 >= 4.0.6)
fbsql_num_rows -- Get number of rows in result
Description
int fbsql_num_rows ( resource result)
fbsql_num_rows() returns the number of rows in a result set. This command 
is only valid for SELECT statements. To retrieve the number of rows 
returned from a INSERT, UPDATE or DELETE query, use fbsql_affected_rows(). 
Example 1. fbsql_num_rows() example
  <?php

  $link = fbsql_connect("localhost", "username", "password"); 
  fbsql_select_db("database", $link);

  $result = fbsql_query("SELECT * FROM table1;", $link); 
  $num_rows = fbsql_num_rows($result); 

  echo "$num_rows Rows\n";

  ?> 
See also: fbsql_affected_rows(), fbsql_connect(), fbsql_select_db(), and 
fbsql_query().   fbsql_num_fieldsUpfbsql_password
#

#T=int fbsql_num_rows ( resource result)
fbsql_num_rows ( ^!resource result);
#

#T=fbsql_password - string fbsql_password ( resource link_identifier [, string password])
(PHP 4 >= 4.0.6)
fbsql_password -- Get or set the user password used with a connection
Description
string fbsql_password ( resource link_identifier [, string password])
Warning
This function is currently not documented; only the argument list is 
available.
  fbsql_num_rowsUpfbsql_pconnect
#

#T=string fbsql_password ( resource link_identifier [, string password])
fbsql_password ( ^!resource link_identifier [, string password]);
#

#T=fbsql_pconnect - resource fbsql_pconnect ( [string hostname [, string username [, string 
(PHP 4 >= 4.0.6)
fbsql_pconnect --  Open a persistent connection to a FrontBase Server 
Description
resource fbsql_pconnect ( [string hostname [, string username [, string 
password]]])
Returns: A positive FrontBase persistent link identifier on success, or 
FALSE on error. 
fbsql_pconnect() establishes a connection to a FrontBase server. The 
following defaults are assumed for missing optional parameters: host = 
'localhost', username = "_SYSTEM" and password = empty password. 
To set Frontbase server port number, use fbsql_select_db(). 
fbsql_pconnect() acts very much like fbsql_connect() with two major 
differences. 
First, when connecting, the function would first try to find a 
(persistent) link that's already open with the same host, username and 
password. If one is found, an identifier for it will be returned instead 
of opening a new connection. 
Second, the connection to the SQL server will not be closed when the 
execution of the script ends. Instead, the link will remain open for 
future use. 
This type of links is therefore called 'persistent'.   fbsql_passwordUpfbsql_query
#

#T=resource fbsql_pconnect ( [string hostname [, string username [, string 
fbsql_pconnect ( ^![string hostname [, string username [, string ;
#

#T=fbsql_query - resource fbsql_query ( string query [, resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_query -- Send a FrontBase query
Description
resource fbsql_query ( string query [, resource link_identifier])
fbsql_query() sends a query to the currently active database on the server 
that's associated with the specified link identifier. If link_identifier 
isn't specified, the last opened link is assumed. If no link is open, the 
function tries to establish a link as if fbsql_connect() was called with 
no arguments, and use it. 
Note: The query string shall always end with a semicolon. 
fbsql_query() returns TRUE (non-zero) or FALSE to indicate whether or not 
the query succeeded. A return value of TRUE means that the query was legal 
and could be executed by the server. It does not indicate anything about 
the number of rows affected or returned. It is perfectly possible for a 
query to succeed but affect no rows or return no rows. 
The following query is syntactically invalid, so fbsql_query() fails and 
returns FALSE: Example 1. fbsql_query() example
  <?php
  $result = fbsql_query("SELECT * WHERE 1=1")
      or die ("Invalid query");
  ?> 
The following query is semantically invalid if my_col is not a column in 
the table my_tbl, so fbsql_query() fails and returns FALSE: Example 
2. fbsql_query() example
  <?php
  $result = fbsql_query ("SELECT my_col FROM my_tbl")
      or die ("Invalid query");
  ?> 
fbsql_query() will also fail and return FALSE if you don't have permission 
to access the table(s) referenced by the query. 
Assuming the query succeeds, you can call fbsql_num_rows() to find out how 
many rows were returned for a SELECT statement or fbsql_affected_rows() to 
find out how many rows were affected by a DELETE, INSERT, REPLACE, or 
UPDATE statement. 
For SELECT statements, fbsql_query() returns a new result identifier that 
you can pass to fbsql_result(). When you are done with the result set, you 
can free the resources associated with it by calling fbsql_free_result(). 
Although, the memory will automatically be freed at the end of the 
script's execution. 
See also: fbsql_affected_rows(), fbsql_db_query(), fbsql_free_result(), 
fbsql_result(), fbsql_select_db(), and fbsql_connect().   fbsql_pconnectUpfbsql_read_blob
#

#T=resource fbsql_query ( string query [, resource link_identifier])
fbsql_query ( ^!string query [, resource link_identifier]);
#

#T=fbsql_read_blob - string fbsql_read_blob ( string blob_handle [, resource link_identifier])
(PHP 4 >= 4.2.0)
fbsql_read_blob -- Read a BLOB from the database
Description
string fbsql_read_blob ( string blob_handle [, resource link_identifier])
Returns: A string containing the BLOB specified by blob_handle. 
fbsql_read_blob() reads BLOB data from the database. If a select statement 
contains BLOB and/or CLOB columns FrontBase will return the data directly 
when data is fetched. This default behavior can be changed with 
fbsql_set_lob_mode() so the fetch functions will return handles to BLOB 
and CLOB data. If a handle is fetched a user must call fbsql_read_blob() 
to get the actual BLOB data from the database. 
Example 1. fbsql_read_blob() example
  <?php
      $link = fbsql_pconnect("localhost", "_SYSTEM", "secret")
	  or die("Could not connect");
      $sql = "SELECT BLOB_COLUMN FROM BLOB_TABLE;";
      $rs = fbsql_query($sql, $link);
      $row_data = fbsql_fetch_row($rs);
      // $row_data[0] will now contain the blob data for the 
  first row
      fbsql_free_result($rs);
      
      $rs = fbsql_query($sql, $link);
      fbsql_set_lob_mode($rs, FBSQL_LOB_HANDLE);
      $row_data = fbsql_fetch_row($rs);
      // $row_data[0] will now contain a handle to the BLOB data 
  in the first row
      $blob_data = fbsql_read_blob($row_data[0]);
      fbsql_free_result($rs);
      
  ?> 
See also: fbsql_create_blob(), fbsql_read_blob(), fbsql_read_clob(), and 
fbsql_set_lob_mode().   fbsql_queryUpfbsql_read_clob
#

#T=string fbsql_read_blob ( string blob_handle [, resource link_identifier])
fbsql_read_blob ( ^!string blob_handle [, resource link_identifier]);
#

#T=fbsql_read_clob - string fbsql_read_clob ( string clob_handle [, resource link_identifier])
(PHP 4 >= 4.2.0)
fbsql_read_clob -- Read a CLOB from the database
Description
string fbsql_read_clob ( string clob_handle [, resource link_identifier])
Returns: A string containing the CLOB specified by clob_handle. 
fbsql_read_clob() reads CLOB data from the database. If a select statement 
contains BLOB and/or CLOB columns FrontBase will return the data directly 
when data is fetched. This default behavior can be changed with 
fbsql_set_lob_mode() so the fetch functions will return handles to BLOB 
and CLOB data. If a handle is fetched a user must call fbsql_read_clob() 
to get the actual CLOB data from the database. 
Example 1. fbsql_read_clob() example
  <?php
      $link = fbsql_pconnect("localhost", "_SYSTEM", "secret")
	  or die("Could not connect");
      $sql = "SELECT CLOB_COLUMN FROM CLOB_TABLE;";
      $rs = fbsql_query($sql, $link);
      $row_data = fbsql_fetch_row($rs);
      // $row_data[0] will now contain the clob data for the 
  first row
      fbsql_free_result($rs);
      
      $rs = fbsql_query($sql, $link);
      fbsql_set_lob_mode($rs, FBSQL_LOB_HANDLE);
      $row_data = fbsql_fetch_row($rs);
      // $row_data[0] will now contain a handle to the CLOB data 
  in the first row
      $clob_data = fbsql_read_clob($row_data[0]);
      fbsql_free_result($rs);
      
  ?> 
See also: fbsql_create_blob(), fbsql_read_blob(), fbsql_read_clob(), and 
fbsql_set_lob_mode().   fbsql_read_blobUpfbsql_result
#

#T=string fbsql_read_clob ( string clob_handle [, resource link_identifier])
fbsql_read_clob ( ^!string clob_handle [, resource link_identifier]);
#

#T=fbsql_result - mixed fbsql_result ( resource result, int row [, mixed field])
(PHP 4 >= 4.0.6)
fbsql_result -- Get result data
Description
mixed fbsql_result ( resource result, int row [, mixed field])
fbsql_result() returns the contents of one cell from a FrontBase result 
set. The field argument can be the field's offset, or the field's name, or 
the field's table dot field's name (tabledname.fieldname). If the column 
name has been aliased ('select foo as bar from...'), use the alias instead 
of the column name. 
When working on large result sets, you should consider using one of the 
functions that fetch an entire row (specified below). As these functions 
return the contents of multiple cells in one function call, they're MUCH 
quicker than fbsql_result(). Also, note that specifying a numeric offset 
for the field argument is much quicker than specifying a fieldname or 
tablename.fieldname argument. 
Calls to fbsql_result() should not be mixed with calls to other functions 
that deal with the result set. 
Recommended high-performance alternatives: fbsql_fetch_row(), 
fbsql_fetch_array(), and fbsql_fetch_object().   fbsql_read_clobUpfbsql_rollback
#

#T=mixed fbsql_result ( resource result, int row [, mixed field])
fbsql_result ( ^!resource result, int row [, mixed field]);
#

#T=fbsql_rollback - bool fbsql_rollback ( [resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_rollback -- Rollback a transaction to the database
Description
bool fbsql_rollback ( [resource link_identifier])
Returns TRUE on success or FALSE on failure. 
fbsql_rollback() ends the current transaction by rolling back all 
statements issued since last commit. This command is only needed if 
autocommit is set to false. 
See also: fbsql_autocommit() and fbsql_commit()   fbsql_resultUpfbsql_select_db
#

#T=bool fbsql_rollback ( [resource link_identifier])
fbsql_rollback ( ^![resource link_identifier]);
#

#T=fbsql_select_db - bool fbsql_select_db ( string database_name [, resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_select_db -- Select a FrontBase database
Description
bool fbsql_select_db ( string database_name [, resource link_identifier])
fbsql_select_db() sets the current active database on the server that's 
associated with the specified link identifier. If no link identifier is 
specified, the last opened link is assumed. If no link is open, the 
function will try to establish a link as if fbsql_connect() was called, 
and use it. 
Returns TRUE on success or FALSE on failure. 
The client contacts FBExec to obtain the port number to use for the 
connection to the database. If the database name is a number the system 
will use that as a port number and it will not ask FBExec for the port 
number. The FrontBase server can be stared as FRontBase -FBExec=No 
-port=<port number> <database name>. 
Every subsequent call to fbsql_query() will be made on the active 
database. 
if the database is protected with a database password, the user must call 
fbsql_database_password() before selecting the database. 
See also fbsql_connect(), fbsql_pconnect(), fbsql_database_password(), and 
fbsql_query().   fbsql_rollbackUpfbsql_set_lob_mode
#

#T=bool fbsql_select_db ( string database_name [, resource link_identifier])
fbsql_select_db ( ^!string database_name [, resource link_identifier]);
#

#T=fbsql_set_lob_mode - bool fbsql_set_lob_mode ( resource result, string database_name)
(PHP 4 >= 4.2.0)
fbsql_set_lob_mode --  Set the LOB retrieve mode for a FrontBase result 
set 
Description
bool fbsql_set_lob_mode ( resource result, string database_name)
Returns: TRUE on success, FALSE on error. 
fbsql_set_lob_mode() sets the mode for retrieving LOB data from the 
database. When BLOB and CLOB data is stored in FrontBase it can be stored 
direct or indirect. Direct stored LOB data will always be fetched no 
matter the setting of the lob mode. If the LOB data is less than 512 bytes 
it will always be stored directly. 
FBSQL_LOB_DIRECT - LOB data is retrieved directly. When data is fetched 
from the database with fbsql_fetch_row(), and other fetch functions, all 
CLOB and BLOB columns will be returned as ordinary columns. This is the 
default value on a new FrontBase result. 
FBSQL_LOB_HANDLE - LOB data is retrieved as handles to the data. When 
data is fetched from the database with fbsql_fetch_row (), and other 
fetch functions, LOB data will be returned as a handle to the data if 
the data is stored indirect or the data if it is stored direct. If a 
handle is returned it will be a 27 byte string formatted as 
"@'000000000000000000000000'". 
See also: fbsql_create_blob(), fbsql_create_clob(), fbsql_read_blob(), and 
fbsql_read_clob().   fbsql_select_dbUpfbsql_set_transaction
#

#T=bool fbsql_set_lob_mode ( resource result, string database_name)
fbsql_set_lob_mode ( ^!resource result, string database_name);
#

#T=fbsql_set_transaction - void fbsql_set_transaction ( resource link_identifier, int Locking, int 
(PHP 4 >= 4.2.0)
fbsql_set_transaction --  Set the transaction locking and isolation 
Description
void fbsql_set_transaction ( resource link_identifier, int Locking, int 
Isolation)
Warning
This function is currently not documented; only the argument list is 
available.
  fbsql_set_lob_modeUpfbsql_start_db
#

#T=void fbsql_set_transaction ( resource link_identifier, int Locking, int 
fbsql_set_transaction ( ^!resource link_identifier, int Locking, int ;
#

#T=fbsql_start_db - bool fbsql_start_db ( string database_name [, resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_start_db -- Start a database on local or remote server
Description
bool fbsql_start_db ( string database_name [, resource link_identifier])
Returns TRUE on success or FALSE on failure. 
fbsql_start_db() 
See also: fbsql_db_status() and fbsql_stop_db().   fbsql_set_transactionUpfbsql_stop_db
#

#T=bool fbsql_start_db ( string database_name [, resource link_identifier])
fbsql_start_db ( ^!string database_name [, resource link_identifier]);
#

#T=fbsql_stop_db - bool fbsql_stop_db ( string database_name [, resource link_identifier])
(PHP 4 >= 4.0.6)
fbsql_stop_db -- Stop a database on local or remote server
Description
bool fbsql_stop_db ( string database_name [, resource link_identifier])
Returns TRUE on success or FALSE on failure. 
fbsql_stop_db() 
See also: fbsql_db_status() and fbsql_start_db().   fbsql_start_dbUpfbsql_tablename
#

#T=bool fbsql_stop_db ( string database_name [, resource link_identifier])
fbsql_stop_db ( ^!string database_name [, resource link_identifier]);
#

#T=fbsql_tablename - string fbsql_tablename ( resource result, int i)
(PHP 4 >= 4.2.0)
fbsql_tablename -- Get table name of field
Description
string fbsql_tablename ( resource result, int i)
fbsql_tablename() takes a result pointer returned by the 
fbsql_list_tables() function as well as an integer index and returns the 
name of a table. The fbsql_num_rows() function may be used to determine 
the number of tables in the result pointer. Example 1. 
fbsql_tablename() example
  <?php 
  fbsql_connect("localhost", "_SYSTEM", "");
  $result = fbsql_list_tables("wisconsin");
  $i = 0;
  while ($i < fbsql_num_rows($result)) {
      $tb_names[$i] = fbsql_tablename($result, $i);
      echo $tb_names[$i] . "<br />";
      $i++;
  }
  ?> 

  fbsql_stop_dbUpfbsql_username
#

#T=string fbsql_tablename ( resource result, int i)
fbsql_tablename ( ^!resource result, int i);
#

#T=fbsql_username - string fbsql_username ( resource link_identifier [, string username])
(PHP 4 >= 4.0.6)
fbsql_username -- Get or set the host user used with a connection
Description
string fbsql_username ( resource link_identifier [, string username])
Warning
This function is currently not documented; only the argument list is 
available.
  fbsql_tablenameUpfbsql_warnings
#

#T=string fbsql_username ( resource link_identifier [, string username])
fbsql_username ( ^!resource link_identifier [, string username]);
#

#T=fbsql_warnings - bool fbsql_warnings ( [bool OnOff])
(PHP 4 >= 4.0.6)
fbsql_warnings -- Enable or disable FrontBase warnings
Description
bool fbsql_warnings ( [bool OnOff])
Returns TRUE if warnings is turned on otherwise FALSE. 
fbsql_warnings() enables or disables FrontBase warnings.   fbsql_usernameUpfilePro functions
#

#T=bool fbsql_warnings ( [bool OnOff])
fbsql_warnings ( ^![bool OnOff]);
#

#T=fclose - bool fclose ( resource handle)
(PHP 3, PHP 4 )
fclose -- Closes an open file pointer
Description
bool fclose ( resource handle)
The file pointed to by handle is closed. 
Returns TRUE on success or FALSE on failure. 
The file pointer must be valid, and must point to a file successfully 
opened by fopen() or fsockopen(). 
Example 1. A simple fclose() example
  <?php

    $handle = fopen('somefile.txt', 'r');
    
    fclose($handle);
    
  ?> 

  diskfreespaceUpfeof
#

#T=bool fclose ( resource handle)
fclose ( ^!resource handle);
#

#T=fdf_add_doc_javascript - bool fdf_add_doc_javascript ( resource fdfdoc, string script_name, string 
(PHP 4 >= 4.3.0)
fdf_add_doc_javascript -- Adds javascript code to the FDF document
Description
bool fdf_add_doc_javascript ( resource fdfdoc, string script_name, string 
script_code)
Adds a script to the FDF, which Acrobat then adds to the doc-level scripts 
of a document, once the FDF is imported into it. It is strongly suggested 
to use '\r' for linebreaks within script_code. 
Example 1. Adding JavaScript code to a FDF
  <?php
  $fdf = fdf_create();
  fdf_add_doc_javascript($fdf, "PlusOne", "function 
  PlusOne(x)\r{\r  return x+1;\r}\r");
  fdf_save($fdf);
  ?> 

will create a FDF like this:
%FDF-1.2
%
1 0 obj
<< 
/FDF << /JavaScript << /Doc [ (PlusOne)(function PlusOne\(x\)\r{\r  return x+1;\r}\r)] >> >> 
>> 
endobj
trailer
<<
/Root 1 0 R 

>>
%%EOF

  Forms Data Format functionsUpfdf_add_template
#

#T=bool fdf_add_doc_javascript ( resource fdfdoc, string script_name, string 
fdf_add_doc_javascript ( ^!resource fdfdoc, string script_name, string ;
#

#T=fdf_add_template - bool fdf_add_template ( resource fdfdoc, int newpage, string filename, 
(PHP 3>= 3.0.13, PHP 4 )
fdf_add_template -- Adds a template into the FDF document
Description
bool fdf_add_template ( resource fdfdoc, int newpage, string filename, 
string template, int rename)
Warning
This function is currently not documented; only the argument list is 
available.
  fdf_add_doc_javascriptUpfdf_close
#

#T=bool fdf_add_template ( resource fdfdoc, int newpage, string filename, 
fdf_add_template ( ^!resource fdfdoc, int newpage, string filename, ;
#

#T=fdf_close - bool fdf_close ( resource fdf_document)
(PHP 3>= 3.0.6, PHP 4 )
fdf_close -- Close an FDF document
Description
bool fdf_close ( resource fdf_document)
The fdf_close() function closes the FDF document.
See also fdf_open().  fdf_add_templateUpfdf_create
#

#T=bool fdf_close ( resource fdf_document)
fdf_close ( ^!resource fdf_document);
#

#T=fdf_create - resource fdf_create ( void )
(PHP 3>= 3.0.6, PHP 4 )
fdf_create -- Create a new FDF document
Description
resource fdf_create ( void )
The fdf_create() creates a new FDF document. This function is needed if 
one would like to populate input fields in a PDF document with data.
Example 1. Populating a PDF document
  <?php
  $outfdf = fdf_create();
  fdf_set_value($outfdf, "volume", $volume, 0);

  fdf_set_file($outfdf, "http:/testfdf/resultlabel.pdf");
  fdf_save($outfdf, "outtest.fdf");
  fdf_close($outfdf);
  Header("Content-type: application/vnd.fdf");
  $fp = fopen("outtest.fdf", "r");
  fpassthru($fp);
  unlink("outtest.fdf");
  ?> 
See also fdf_close(), fdf_save(), fdf_open().  fdf_closeUpfdf_enum_values
#

#T=resource fdf_create ( void )
fdf_create ( ^!void );
#

#T=fdf_enum_values - bool fdf_enum_values ( resource fdfdoc, callback function [, mixed 
(PHP 4 >= 4.3.0)
fdf_enum_values -- Call a user defined function for each document value 
Description
bool fdf_enum_values ( resource fdfdoc, callback function [, mixed 
userdata])
Warning
This function is currently not documented; only the argument list is 
available.
  fdf_createUpfdf_errno
#

#T=bool fdf_enum_values ( resource fdfdoc, callback function [, mixed 
fdf_enum_values ( ^!resource fdfdoc, callback function [, mixed ;
#

#T=fdf_errno - int fdf_errno ( void )
(PHP 4 >= 4.3.0)
fdf_errno -- Return error code for last fdf operation
Description
int fdf_errno ( void )
fdf_errno() returns the error code set by the last fdf_...() function 
call. This is zero for a successfull operation or a non-zero error code on 
failure. A textual description may be obtained using the fdf_error() 
function. 
See also fdf_error().   fdf_enum_valuesUpfdf_error
#

#T=int fdf_errno ( void )
fdf_errno ( ^!void );
#

#T=fdf_error - 
string fdf_error ( [int e
(PHP 4 >= 4.3.0)
fdf_error -- Return error description for fdf error code
Description
string fdf_error ( [int error_code])
fdf_error() returns a textual description for the fdf error code given in 
error_code. The function uses the internal error code set by the last 
operation if no error_code is given, so fdf_error() is a convenient 
shortcut for fdf_error(fdf_errno()). 
See also fdf_errno().   fdf_errnoUpfdf_get_ap
#

#T=
string fdf_error ( [int e

fdf_error ( ^![int e;
#

#T=fdf_get_ap - bool fdf_get_ap ( resource fdf_document, string field, int face, string 
(PHP 4 >= 4.3.0)
fdf_get_ap -- Get the appearance of a field
Description
bool fdf_get_ap ( resource fdf_document, string field, int face, string 
filename)
The fdf_get_ap() function gets the appearance of a field (i.e. the value 
of the /AP key) and stores it in a file. The possible values of face are 
FDFNormalAP, FDFRolloverAP and FDFDownAP. The appearance is stored in 
filename.   fdf_errorUpfdf_get_attachment
#

#T=bool fdf_get_ap ( resource fdf_document, string field, int face, string 
fdf_get_ap ( ^!resource fdf_document, string field, int face, string ;
#

#T=fdf_get_attachment - array fdf_get_attachment ( resource fdf_document, string fieldname, string 
(PHP 4 >= 4.3.0)
fdf_get_attachment -- Extracts uploaded file embedded in the FDF
Description
array fdf_get_attachment ( resource fdf_document, string fieldname, string 
savepath)
Extracts a file uploaded by means of the "file selection" field fieldname 
and stores it under savepath. savepath may be the name of a plain file or 
an existing directory in which the file is to be created under its 
original name. Any existing file under the same name will be overwritten. 
Note: There seems to be no other way to find out the original filename 
but to store the file using a directory as savepath and check for the 
basename it was stored under. 
The returned array contains the following fields: 
path - path were the file got stored
size - size of the stored file in bytes
type - mimetype if given in the FDF
Example 1. Storing an uploaded file
  <?php 
    $fdf = fdf_open_string($HTTP_FDF_DATA);
    $data = fdf_get_attachment($fdf, "filename", "/tmpdir");
    echo "The uploaded file is stored in $data[path]";
  ?> 

  fdf_get_apUpfdf_get_encoding
#

#T=array fdf_get_attachment ( resource fdf_document, string fieldname, string 
fdf_get_attachment ( ^!resource fdf_document, string fieldname, string ;
#

#T=fdf_get_encoding - string fdf_get_encoding ( resource fdf_document)
(PHP 4 >= 4.3.0)
fdf_get_encoding -- Get the value of the /Encoding key
Description
string fdf_get_encoding ( resource fdf_document)
The fdf_get_encoding() returns the value of the /Encoding key. An empty 
string is returned if the default PDFDocEncoding/Unicode scheme is used. 
See also fdf_set_encoding().   fdf_get_attachmentUpfdf_get_file
#

#T=string fdf_get_encoding ( resource fdf_document)
fdf_get_encoding ( ^!resource fdf_document);
#

#T=fdf_get_file - string fdf_get_file ( resource fdf_document)
(PHP 3>= 3.0.6, PHP 4 )
fdf_get_file -- Get the value of the /F key
Description
string fdf_get_file ( resource fdf_document)
The fdf_set_file() returns the value of the /F key. 
See also fdf_set_file().  fdf_get_encodingUpfdf_get_flags
#

#T=string fdf_get_file ( resource fdf_document)
fdf_get_file ( ^!resource fdf_document);
#

#T=fdf_get_flags - fdf_get_flags ( void )
(PHP 4 >= 4.3.0)
fdf_get_flags -- Gets the flags of a field
Description
fdf_get_flags ( void )
Warning
This function is currently not documented; only the argument list is 
available.
  fdf_get_fileUpfdf_get_opt
#

#T=fdf_get_flags ( void )
( void ^!);
#

#T=fdf_get_opt - mixed fdf_get_opt ( resource fdfdof, string fieldname [, int element])
(PHP 4 >= 4.3.0)
fdf_get_opt -- Gets a value from the opt array of a field
Description
mixed fdf_get_opt ( resource fdfdof, string fieldname [, int element])
Warning
This function is currently not documented; only the argument list is 
available.
  fdf_get_flagsUpfdf_get_status
#

#T=mixed fdf_get_opt ( resource fdfdof, string fieldname [, int element])
fdf_get_opt ( ^!resource fdfdof, string fieldname [, int element]);
#

#T=fdf_get_status - string fdf_get_status ( resource fdf_document)
(PHP 3>= 3.0.6, PHP 4 )
fdf_get_status -- Get the value of the /STATUS key
Description
string fdf_get_status ( resource fdf_document)
The fdf_get_status() returns the value of the /STATUS key. 
See also fdf_set_status().   fdf_get_optUpfdf_get_value
#

#T=string fdf_get_status ( resource fdf_document)
fdf_get_status ( ^!resource fdf_document);
#

#T=fdf_get_value - string fdf_get_value ( resource fdf_document, string fieldname [, int 
(PHP 3>= 3.0.6, PHP 4 )
fdf_get_value -- Get the value of a field
Description
string fdf_get_value ( resource fdf_document, string fieldname [, int 
which])
The fdf_get_value() function returns the value for the requested 
fieldname. 
Elements of an array field can be retrieved by passing the optional which, 
starting at zero. For non-array fields the optional parameter which will 
be ignored. 
Note: Array support and optional which parameter were added in PHP 4.3. 
See also fdf_set_value().   fdf_get_statusUpfdf_get_version
#

#T=string fdf_get_value ( resource fdf_document, string fieldname [, int 
fdf_get_value ( ^!resource fdf_document, string fieldname [, int ;
#

#T=fdf_get_version - string fdf_get_version ( [resource fdf_document])
(PHP 4 >= 4.3.0)
fdf_get_version -- Gets version number for FDF API or file 
Description
string fdf_get_version ( [resource fdf_document])
This function will return the fdf version for the given fdf_document, or 
the toolkit API version number if no parameter is given. 
For the current FDF toolkit 5.0 the API version number is '5.0' and the 
document version number is either '1.2', '1.3' or '1.4'. 
See also fdf_set_version().   fdf_get_valueUpfdf_header
#

#T=string fdf_get_version ( [resource fdf_document])
fdf_get_version ( ^![resource fdf_document]);
#

#T=fdf_header - bool fdf_header ( void )
(PHP 4 >= 4.3.0)
fdf_header -- Sets FDF-specific output headers
Description
bool fdf_header ( void )
This is a convenience function to set appropriate HTTP headers for FDF 
output. It sets the Content-type: to application/vnd.fdf.   fdf_get_versionUpfdf_next_field_name
#

#T=bool fdf_header ( void )
fdf_header ( ^!void );
#

#T=fdf_next_field_name - string fdf_next_field_name ( resource fdf_document [, string fieldname])
(PHP 3>= 3.0.6, PHP 4 )
fdf_next_field_name -- Get the next field name
Description
string fdf_next_field_name ( resource fdf_document [, string fieldname])
The fdf_next_field_name() function returns the name of the field after the 
field in fieldname or the field name of the first field if the second 
parameter is NULL. 
Example 1. Detecting all fieldnames in a FDF
  <?php
    $fdf = fdf_open($HTTP_FDF_DATA);
    for ($field = fdf_next_field_name($fdf); 
       $field != ""; 
       $field = fdf_next_field_name($fdf, $field)) {
      echo "field: $field\n";
    } 
  ?> 
See also fdf_enum_fields() and fdf_get_value().   fdf_headerUpfdf_open_string
#

#T=string fdf_next_field_name ( resource fdf_document [, string fieldname])
fdf_next_field_name ( ^!resource fdf_document [, string fieldname]);
#

#T=fdf_open_string - resource fdf_open_string ( string fdf_data)
(PHP 4 >= 4.3.0)
fdf_open_string -- Read a FDF document from a string
Description
resource fdf_open_string ( string fdf_data)
The fdf_open_string() function reads form data from a string. fdf_data 
must contain the data as returned from a PDF form or created using 
fdf_create() and fdf_save_string(). 
You can fdf_open_string() together with $HTTP_FDF_DATA to process fdf form 
input from a remote client. 
Example 1. Accessing the form data
  <?php
  $fdf = fdf_open_string($HTTP_FDF_DATA);
  /* ... */
  fdf_close($fdf);
  ?> 
See also fdf_open(), fdf_close(), fdf_create() and fdf_save_string().   fdf_next_field_nameUpfdf_open
#

#T=resource fdf_open_string ( string fdf_data)
fdf_open_string ( ^!string fdf_data);
#

#T=fdf_open - resource fdf_open ( string filename)
(PHP 3>= 3.0.6, PHP 4 )
fdf_open -- Open a FDF document
Description
resource fdf_open ( string filename)
The fdf_open() function opens a file with form data. This file must 
contain the data as returned from a PDF form or created using fdf_create() 
and fdf_save(). 
You can process the results of a PDF form POST request by writing the data 
received in $HTTP_FDF_DATA to a file and open it using fdf_open(). 
Starting with PHP 4.3 you can also use fdf_open_string() which handles 
temporary file creation and cleanup for you. 
Example 1. Accessing the form data
  <?php
  // Save the FDF data into a temp file
  $fdffp = fopen("test.fdf", "w");
  fwrite($fdffp, $HTTP_FDF_DATA, strlen($HTTP_FDF_DATA));
  fclose($fdffp);

  // Open temp file and evaluate data
  $fdf = fdf_open("test.fdf");
  /* ... */
  fdf_close($fdf);
  ?> 
See also fdf_open_string(), fdf_close(), fdf_create() and fdf_save().   fdf_open_stringUpfdf_remove_item
#

#T=resource fdf_open ( string filename)
fdf_open ( ^!string filename);
#

#T=fdf_remove_item - bool fdf_remove_item ( resource fdfdoc, string fieldname, int item)
(PHP 4 >= 4.3.0)
fdf_remove_item -- Sets target frame for form
Description
bool fdf_remove_item ( resource fdfdoc, string fieldname, int item)
Warning
This function is currently not documented; only the argument list is 
available.
  fdf_openUpfdf_save_string
#

#T=bool fdf_remove_item ( resource fdfdoc, string fieldname, int item)
fdf_remove_item ( ^!resource fdfdoc, string fieldname, int item);
#

#T=fdf_save_string - string fdf_save_string ( resource fdf_document)
(PHP 4 >= 4.3.0)
fdf_save_string -- Returns the FDF document as a string
Description
string fdf_save_string ( resource fdf_document)
The fdf_save_string() function returns the FDF document as a string. 
Example 1. Retrieving FDF as a string
  <?php
  $fdf = fdf_create();
  fdf_set_value($fdf, "foo", "bar");
  $str = fdf_save_string($fdf);
  fdf_close($fdf);
  echo $str;
  ?> 

will output something like 
%FDF-1.2
%
1 0 obj
<< 
/FDF << /Fields 2 0 R >> 
>> 
endobj
2 0 obj
[ 
<< /T (foo)/V (bar)>> 
]
endobj
trailer
<<
/Root 1 0 R 

>>
%%EOF
See also fdf_save(), fdf_open_string(), fdf_create() and fdf_close().   fdf_remove_itemUpfdf_save
#

#T=string fdf_save_string ( resource fdf_document)
fdf_save_string ( ^!resource fdf_document);
#

#T=fdf_save - bool fdf_save ( resource fdf_document [, string filename])
(PHP 3>= 3.0.6, PHP 4 )
fdf_save -- Save a FDF document
Description
bool fdf_save ( resource fdf_document [, string filename])
The fdf_save() function saves a FDF document. The resulting FDF will be 
written to filename. Without a filename fdf_save() will write the FDF to 
the default PHP output stream. 
See also fdf_save_string(), fdf_create() and fdf_close().   fdf_save_stringUpfdf_set_ap
#

#T=bool fdf_save ( resource fdf_document [, string filename])
fdf_save ( ^!resource fdf_document [, string filename]);
#

#T=fdf_set_ap - bool fdf_set_ap ( resource fdf_document, string field_name, int face, 
(PHP 3>= 3.0.6, PHP 4 )
fdf_set_ap -- Set the appearance of a field
Description
bool fdf_set_ap ( resource fdf_document, string field_name, int face, 
string filename, int page_number)
The fdf_set_ap() function sets the appearance of a field (i.e. the value 
of the /AP key). The possible values of face are FDFNormalAP, 
FDFRolloverAP and FDFDownAP.   fdf_saveUpfdf_set_encoding
#

#T=bool fdf_set_ap ( resource fdf_document, string field_name, int face, 
fdf_set_ap ( ^!resource fdf_document, string field_name, int face, ;
#

#T=fdf_set_encoding - bool fdf_set_encoding ( resource fdf_document, string encoding)
(PHP 4 >= 4.1.0)
fdf_set_encoding -- Sets FDF character encoding
Description
bool fdf_set_encoding ( resource fdf_document, string encoding)
fdf_set_encoding() sets the character encoding in FDF document 
fdf_document. encoding should be the valid encoding name. Currently the 
following values are supported: "Shift-JIS", "UHC", "GBK","BigFive". An 
empty string resets the encoding to the default PDFDocEncoding/Unicode 
scheme.   fdf_set_apUpfdf_set_file
#

#T=bool fdf_set_encoding ( resource fdf_document, string encoding)
fdf_set_encoding ( ^!resource fdf_document, string encoding);
#

#T=fdf_set_file - bool fdf_set_file ( resource fdf_document, string url [, string 
(PHP 3>= 3.0.6, PHP 4 )
fdf_set_file -- Set PDF document to display FDF data in
Description
bool fdf_set_file ( resource fdf_document, string url [, string 
target_frame])
The fdf_set_file() selects a different PDF document to display the form 
results in then the form it originated from. The url needs to be given as 
an absolute URL. 
The frame to display the document in may be selected using the optional 
parameter target_frame or the function fdf_set_target_frame(). 
Example 1. Passing FDF data to a second form
  <?php
    /* set content type for Adobe FDF */
    fdf_header();

    /* start new fdf */
    $fdf = fdf_create();
      
    /* set field "foo" to value "bar" */
    $fdf_set_value($fdf, "foo", "bar");

    /* tell client to display FDF data using "fdf_form.pdf" */
    fdf_set_file($fdf, "http://www.example.com/fdf_form.pdf");

    /* output fdf */
    fdf_save();

    /* clean up */
    fdf_close();
  ?> 
See also fdf_get_file() and fdf_set_target_frame().   fdf_set_encodingUpfdf_set_flags
#

#T=bool fdf_set_file ( resource fdf_document, string url [, string 
fdf_set_file ( ^!resource fdf_document, string url [, string ;
#

#T=fdf_set_flags - bool fdf_set_flags ( resource fdf_document, string fieldname, int 
(PHP 4 >= 4.0.2)
fdf_set_flags -- Sets a flag of a field
Description
bool fdf_set_flags ( resource fdf_document, string fieldname, int 
whichFlags, int newFlags)
The fdf_set_flags() sets certain flags of the given field fieldname. 
See also fdf_set_opt().   fdf_set_fileUpfdf_set_javascript_action
#

#T=bool fdf_set_flags ( resource fdf_document, string fieldname, int 
fdf_set_flags ( ^!resource fdf_document, string fieldname, int ;
#

#T=fdf_set_javascript_action - bool fdf_set_javascript_action ( resource fdf_document, string fieldname, 
(PHP 4 >= 4.0.2)
fdf_set_javascript_action -- Sets an javascript action of a field
Description
bool fdf_set_javascript_action ( resource fdf_document, string fieldname, 
int trigger, string script)
fdf_set_javascript_action() sets a javascript action for the given field 
fieldname. 
See also fdf_set_submit_form_action().   fdf_set_flagsUpfdf_set_opt
#

#T=bool fdf_set_javascript_action ( resource fdf_document, string fieldname, 
fdf_set_javascript_action ( ^!resource fdf_document, string fieldname, ;
#

#T=fdf_set_opt - bool fdf_set_opt ( resource fdf_document, string fieldname, int element, 
(PHP 4 >= 4.0.2)
fdf_set_opt -- Sets an option of a field
Description
bool fdf_set_opt ( resource fdf_document, string fieldname, int element, 
string str1, string str2)
The fdf_set_opt() sets options of the given field fieldname. 
See also fdf_set_flags().   fdf_set_javascript_actionUpfdf_set_status
#

#T=bool fdf_set_opt ( resource fdf_document, string fieldname, int element, 
fdf_set_opt ( ^!resource fdf_document, string fieldname, int element, ;
#

#T=fdf_set_status - bool fdf_set_status ( resource fdf_document, string status)
(PHP 3>= 3.0.6, PHP 4 )
fdf_set_status -- Set the value of the /STATUS key
Description
bool fdf_set_status ( resource fdf_document, string status)
The fdf_set_status() sets the value of the /STATUS key. When a client 
receives a FDF with a status set it will present the value in an alert 
box. 
See also fdf_get_status().   fdf_set_optUpfdf_set_submit_form_action
#

#T=bool fdf_set_status ( resource fdf_document, string status)
fdf_set_status ( ^!resource fdf_document, string status);
#

#T=fdf_set_submit_form_action - bool fdf_set_submit_form_action ( resource fdf_document, string fieldname, 
(PHP 4 >= 4.0.2)
fdf_set_submit_form_action -- Sets a submit form action of a field
Description
bool fdf_set_submit_form_action ( resource fdf_document, string fieldname, 
int trigger, string script, int flags)
The fdf_set_submit_form_action() sets a submit form action for the given 
field fieldname. 
See also fdf_set_javascript_action().   fdf_set_statusUpfdf_set_target_frame
#

#T=bool fdf_set_submit_form_action ( resource fdf_document, string fieldname, 
fdf_set_submit_form_action ( ^!resource fdf_document, string fieldname, ;
#

#T=fdf_set_target_frame - bool fdf_set_target_frame ( resource fdf_document, string frame_name)
(PHP 4 >= 4.3.0)
fdf_set_target_frame -- Set target frame for form display
Description
bool fdf_set_target_frame ( resource fdf_document, string frame_name)
Sets the target frame to display a result PDF defined with fdf_save_file() 
in. 
See also fdf_save_file().   fdf_set_submit_form_actionUpfdf_set_value
#

#T=bool fdf_set_target_frame ( resource fdf_document, string frame_name)
fdf_set_target_frame ( ^!resource fdf_document, string frame_name);
#

#T=fdf_set_value - bool fdf_set_value ( resource fdf_document, string fieldname, mixed value 
(PHP 3>= 3.0.6, PHP 4 )
fdf_set_value -- Set the value of a field
Description
bool fdf_set_value ( resource fdf_document, string fieldname, mixed value 
[, int isName])
The fdf_set_value() function sets the value for a field named fieldname. 
The value will be stored as a string unless it is an array. In this case 
all array elements will be stored as a value array. 
Note: In older versions of the fdf toolkit last parameter determined if 
the field value was to be converted to a PDF Name (isName = 1) or set to 
a PDF String (isName = 0). The value is no longer used in the current 
toolkit version 5.0. For compatibility reasons it is still supported as 
an optional parameter beginning with PHP 4.3, but ignored internally. 
Support for value arrays was added in PHP 4.3. 
See also fdf_get_value() and fdf_remove_item().   fdf_set_target_frameUpfdf_set_version
#

#T=bool fdf_set_value ( resource fdf_document, string fieldname, mixed value 
fdf_set_value ( ^!resource fdf_document, string fieldname, mixed value ;
#

#T=fdf_set_version - string fdf_set_version ( resource fdf_document, string version)
(PHP 4 >= 4.3.0)
fdf_set_version -- Sets version number for a FDF file 
Description
string fdf_set_version ( resource fdf_document, string version)
This function will set the fdf version for the given fdf_document. Some 
features supported by this extension are only available in newer fdf 
versions. For the current FDF toolkit 5.0 version may be either '1.2', 
'1.3' or '1.4'. 
See also fdf_get_version().   fdf_set_valueUpFriBiDi functions
#

#T=string fdf_set_version ( resource fdf_document, string version)
fdf_set_version ( ^!resource fdf_document, string version);
#

#T=feof - bool feof ( resource handle)
(PHP 3, PHP 4 )
feof -- Tests for end-of-file on a file pointer
Description
bool feof ( resource handle)
Returns TRUE if the file pointer is at EOF or an error occurs (including 
socket timeout); otherwise returns FALSE. 
Warning
feof() will return TRUE only if the connection opened by fsockopen() 
is closed. This can cause a script to timeout. The workaround for 
this is to use stream_set_timeout(), so that feof() will return 
FALSE on timeout. 

The file pointer must be valid, and must point to a file successfully 
opened by fopen(), popen(), or fsockopen().   fcloseUpfflush
#

#T=bool feof ( resource handle)
feof ( ^!resource handle);
#

#T=fflush - bool fflush ( resource handle)
(PHP 4 >= 4.0.1)
fflush -- Flushes the output to a file
Description
bool fflush ( resource handle)
This function forces a write of all buffered output to the resource 
pointed to by the file handle handle. Returns TRUE if successful, FALSE 
otherwise. 
The file pointer must be valid, and must point to a file successfully 
opened by fopen(), popen(), or fsockopen().   feofUpfgetc
#

#T=bool fflush ( resource handle)
fflush ( ^!resource handle);
#

#T=fgetc - string fgetc ( resource handle)
(PHP 3, PHP 4 )
fgetc -- Gets character from file pointer
Description
string fgetc ( resource handle)
Returns a string containing a single character read from the file pointed 
to by handle. Returns FALSE on EOF. 
The file pointer must be valid, and must point to a file successfully 
opened by fopen(), popen(), or fsockopen(). 
Warning
This function may return Boolean FALSE, but may also return a 
non-Boolean value which evaluates to FALSE, such as 0 or "". Please 
read the section on Booleans for more information. Use the === 
operator for testing the return value of this function.

Example 1. A fgetc() example
  <?php
  $fp = fopen('somefile.txt', 'r');
  if (!$fp) {
      echo 'Could not open file somefile.txt';
  }
  while (false !== ($char = fgetc($fp))) {
      echo "$char\n";
  }
  ?> 
Note: This function is binary-safe.
See also fread(), fopen(), popen(), fsockopen(), and fgets().   fflushUpfgetcsv
#

#T=string fgetc ( resource handle)
fgetc ( ^!resource handle);
#

#T=fgetcsv - array fgetcsv ( resource handle, int length [, string delimiter [, string 
(PHP 3>= 3.0.8, PHP 4 )
fgetcsv -- Gets line from file pointer and parse for CSV fields
Description
array fgetcsv ( resource handle, int length [, string delimiter [, string 
enclosure]])
Similar to fgets() except that fgetcsv() parses the line it reads for 
fields in CSV format and returns an array containing the fields read. The 
optional third delimiter parameter defaults as a comma, and the optional 
enclosure defaults as a double quotation mark. Both delimiter and 
enclosure are limited to one character. If either is more than one 
character, only the first character is used. 
Note: The enclosure parameter was added in PHP 4.3.0. 
The handle parameter must be a valid file pointer to a file successfully 
opened by fopen(), popen(), or fsockopen(). 
The length parameter must be greater than the longest line to be found in 
the CSV file (allowing for trailing line-end characters). 
fgetcsv() returns FALSE on error, including end of file. 
Note: A blank line in a CSV file will be returned as an array comprising 
a single null field, and will not be treated as an error. 
Example 1. Read and print the entire contents of a CSV file
  <?php
  $row = 1;
  $handle = fopen("test.csv", "r");
  while ($data = fgetcsv($handle, 1000, ",")) {
      $num = count($data);
      echo "<p> $num fields in line $row: <br />\n";
      $row++;
      for ($c=0; $c < $num; $c++) {
	  echo $data[$c] . "<br />\n";
      }
  }
  fclose($handle);
  ?> 
See also explode(), file(), and pack()   fgetcUpfgets
#

#T=array fgetcsv ( resource handle, int length [, string delimiter [, string 
fgetcsv ( ^!resource handle, int length [, string delimiter [, string ;
#

#T=fgets - string fgets ( resource handle [, int length])
(PHP 3, PHP 4 )
fgets -- Gets line from file pointer
Description
string fgets ( resource handle [, int length])
Returns a string of up to length - 1 bytes read from the file pointed to 
by handle. Reading ends when length - 1 bytes have been read, on a newline 
(which is included in the return value), or on EOF (whichever comes 
first). If no length is specified, the length defaults to 1k, or 1024 
bytes. 
If an error occurs, returns FALSE. 
Common Pitfalls: 
People used to the 'C' semantics of fgets() should note the difference in 
how EOF is returned. 
The file pointer must be valid, and must point to a file successfully 
opened by fopen(), popen(), or fsockopen(). 
A simple example follows: Example 1. Reading a file line by line
  <?php
  $handle = fopen("/tmp/inputfile.txt", "r");
  while (!feof($handle)) {
      $buffer = fgets($handle, 4096);
      echo $buffer;
  }
  fclose($handle);
  ?> 
Note: The length parameter became optional in PHP 4.2.0, if omitted, it 
would assume 1024 as the line length. As of PHP 4.3, omitting length 
will keep reading from the stream until it reaches the end of the line. 
If the majority of the lines in the file are all larger than 8KB, it is 
more resource efficient for your script to specify the maximum line 
length. 
Note: This function is binary safe as of PHP 4.3. Earlier versions were 
not binary safe. 
Note: If you are having problems with PHP not recognizing the line 
endings when reading files either on or created by a Macintosh computer, 
you might want to enable the auto_detect_line_endings run-time 
configuration option.
See also fread(), fgetc(), stream_get_line(), fopen(), popen(), 
fsockopen(), and stream_set_timeout().   fgetcsvUpfgetss
#

#T=string fgets ( resource handle [, int length])
fgets ( ^!resource handle [, int length]);
#

#T=fgetss - string fgetss ( resource handle, int length [, string allowable_tags])
(PHP 3, PHP 4 )
fgetss -- Gets line from file pointer and strip HTML tags
Description
string fgetss ( resource handle, int length [, string allowable_tags])
Identical to fgets(), except that fgetss attempts to strip any HTML and 
PHP tags from the text it reads. 
You can use the optional third parameter to specify tags which should not 
be stripped. 
Note: allowable_tags was added in PHP 3.0.13, PHP 4.0.0. 
Note: If you are having problems with PHP not recognizing the line 
endings when reading files either on or created by a Macintosh computer, 
you might want to enable the auto_detect_line_endings run-time 
configuration option.
See also fgets(), fopen(), fsockopen(), popen(), and strip_tags().   fgetsUpfile_exists
#

#T=string fgetss ( resource handle, int length [, string allowable_tags])
fgetss ( ^!resource handle, int length [, string allowable_tags]);
#

#T=file_exists - bool file_exists ( string filename)
(PHP 3, PHP 4 )
file_exists -- Checks whether a file or directory exists
Description
bool file_exists ( string filename)
Returns TRUE if the file or directory specified by filename exists; FALSE 
otherwise. 
On windows, use //computername/share/filename or 
\\computername\share\filename to check files on network shares. 
Example 1. Testing whether a file exists
  <?php
  $filename = '/path/to/foo.txt';

  if (file_exists($filename)) {
      echo "The file $filename exists";
  } else {
      echo "The file $filename does not exist";
  }
  ?> 
Note: The results of this function are cached. See clearstatcache() for 
more details.
Tip: As of PHP 5.0.0 this function can also be used with some url 
wrappers. Refer to Appendix I for a listing of which wrappers support 
stat() family of functionality.
See also is_readable(), is_writable(), is_file() and file().   fgetssUpfile_get_contents
#

#T=bool file_exists ( string filename)
file_exists ( ^!string filename);
#

#T=file_get_contents - string file_get_contents ( string filename [, int use_include_path [, 
(PHP 4 >= 4.3.0)
file_get_contents -- Reads entire file into a string
Description
string file_get_contents ( string filename [, int use_include_path [, 
resource context]])
Identical to file(), except that file_get_contents() returns the file in a 
string. 
file_get_contents() is the preferred way to read the contents of a file 
into a string. It will use memory mapping techniques if supported by your 
OS to enhance performance. 
Note: This function is binary-safe.
Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Note: Context support was added with PHP 5.0.0. 
See also: fgets(), file(), fread(), include(), and readfile().   file_existsUpfile_put_contents
#

#T=string file_get_contents ( string filename [, int use_include_path [, 
file_get_contents ( ^!string filename [, int use_include_path [, ;
#

#T=file_put_contents - int file_put_contents ( string filename, string data [, int flags [, 
(PHP 5 CVS only)
file_put_contents -- Write a string to a file
Description
int file_put_contents ( string filename, string data [, int flags [, 
resource context]])
Identical to calling fopen(), fwrite(), and fclose() successively. The 
function returns the amount of bytes that were written to the file. 
flags can take FILE_USE_INCLUDE_PATH and/or FILE_APPEND, however the 
FILE_USE_INCLUDE_PATH option should be used with caution. 
Note: This function is binary-safe.
Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
See also: fopen(), fwrite(), fclose(), and file_get_contents().   file_get_contentsUpfile
#

#T=int file_put_contents ( string filename, string data [, int flags [, 
file_put_contents ( ^!string filename, string data [, int flags [, ;
#

#T=file - array file ( string filename [, int use_include_path [, resource 
(PHP 3, PHP 4 )
file -- Reads entire file into an array
Description
array file ( string filename [, int use_include_path [, resource 
context]])
Identical to readfile(), except that file() returns the file in an array. 
Each element of the array corresponds to a line in the file, with the 
newline still attached. Upon failure, file() returns FALSE. 
You can use the optional use_include_path parameter and set it to "1", if 
you want to search for the file in the include_path, too. 
<?php
// Get a file into an array.  In this example we'll go through HTTP 
to get 
// the HTML source of a URL.
$lines = file('http://www.example.com/');

// Loop through our array, show HTML source as HTML source; and line 
numbers too.
foreach ($lines as $line_num => $line) {
echo "Line #<b>{$line_num}</b> : " . htmlspecialchars($line) . 
"<br />\n";
}

// Another example, let's get a web page into a string.  See also 
file_get_contents().
$html = implode('', file('http://www.example.com/'));
?> 

Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Note: Each line in the resulting array will include the line ending, so 
you still need to use rtrim() if you do not want the line ending 
present. 
Note: If you are having problems with PHP not recognizing the line 
endings when reading files either on or created by a Macintosh computer, 
you might want to enable the auto_detect_line_endings run-time 
configuration option.
Note: As of PHP 4.3.0 you can use file_get_contents() to return the 
contents of a file as a string. 
In PHP 4.3.0 file() became binary safe. 
Note: Context support was added with PHP 5.0.0 
See also readfile(), fopen(), fsockopen(), popen(), file_get_contents(), 
and include().   file_put_contentsUpfileatime
#

#T=array file ( string filename [, int use_include_path [, resource 
file ( ^!string filename [, int use_include_path [, resource ;
#

#T=fileatime - int fileatime ( string filename)
(PHP 3, PHP 4 )
fileatime -- Gets last access time of file
Description
int fileatime ( string filename)
Returns the time the file was last accessed, or FALSE in case of an error. 
The time is returned as a Unix timestamp. 
Note: The atime of a file is supposed to change whenever the data blocks 
of a file are being read. This can be costly performancewise when an 
application regularly accesses a very large number of files or 
directories. Some Unix filesystems can be mounted with atime updates 
disabled to increase the performance of such applications; USENET news 
spools are a common example. On such filesystems this function will be 
useless. 
Note: The results of this function are cached. See clearstatcache() for 
more details.
Tip: As of PHP 5.0.0 this function can also be used with some url 
wrappers. Refer to Appendix I for a listing of which wrappers support 
stat() family of functionality.
Example 1. fileatime() example
  <?php

  // outputs e.g.  somefile.txt was last accessed: December 29 
  2002 22:16:23.

  $filename = 'somefile.txt';
  if (file_exists($filename)) {
      echo "$filename was last accessed: " . date("F d Y 
  H:i:s.", fileatime($filename));
  }

  ?> 
See also filemtime(), fileinode(), and date().   fileUpfilectime
#

#T=int fileatime ( string filename)
fileatime ( ^!string filename);
#

#T=filectime - int filectime ( string filename)
(PHP 3, PHP 4 )
filectime -- Gets inode change time of file
Description
int filectime ( string filename)
Returns the time the file was last changed, or FALSE in case of an error. 
The time is returned as a Unix timestamp. 
Note: In most Unix filesystems, a file is considered changed when its 
inode data is changed; that is, when the permissions, owner, group, or 
other metadata from the inode is updated. See also filemtime() (which is 
what you want to use when you want to create "Last Modified" footers on 
web pages) and fileatime(). 
Note also that in some Unix texts the ctime of a file is referred to as 
being the creation time of the file. This is wrong. There is no creation 
time for Unix files in most Unix filesystems. 
Note: The results of this function are cached. See clearstatcache() for 
more details.
Tip: As of PHP 5.0.0 this function can also be used with some url 
wrappers. Refer to Appendix I for a listing of which wrappers support 
stat() family of functionality.
Example 1. fileatime() example
  <?php

  // outputs e.g.  somefile.txt was last changed: December 29 
  2002 22:16:23.

  $filename = 'somefile.txt';
  if (file_exists($filename)) {
      echo "$filename was last changed: " . date("F d Y H:i:s.", 
  filectime($filename));
  }

  ?> 
See also filemtime()   fileatimeUpfilegroup
#

#T=int filectime ( string filename)
filectime ( ^!string filename);
#

#T=filegroup - int filegroup ( string filename)
(PHP 3, PHP 4 )
filegroup -- Gets file group
Description
int filegroup ( string filename)
Returns the group ID of the file, or FALSE in case of an error. The group 
ID is returned in numerical format, use posix_getgrgid() to resolve it to 
a group name. Upon failure, FALSE is returned along with an error of level 
E_WARNING. 
Note: The results of this function are cached. See clearstatcache() for 
more details.
Tip: As of PHP 5.0.0 this function can also be used with some url 
wrappers. Refer to Appendix I for a listing of which wrappers support 
stat() family of functionality.
See also fileowner(), and safe_mode_gid.   filectimeUpfileinode
#

#T=int filegroup ( string filename)
filegroup ( ^!string filename);
#

#T=fileinode - int fileinode ( string filename)
(PHP 3, PHP 4 )
fileinode -- Gets file inode
Description
int fileinode ( string filename)
Returns the inode number of the file, or FALSE in case of an error. 
Note: The results of this function are cached. See clearstatcache() for 
more details.
Tip: As of PHP 5.0.0 this function can also be used with some url 
wrappers. Refer to Appendix I for a listing of which wrappers support 
stat() family of functionality.
See also stat()   filegroupUpfilemtime
#

#T=int fileinode ( string filename)
fileinode ( ^!string filename);
#

#T=filemtime - int filemtime ( string filename)
(PHP 3, PHP 4 )
filemtime -- Gets file modification time
Description
int filemtime ( string filename)
Returns the time the file was last modified, or FALSE in case of an error. 
The time is returned as a Unix timestamp, which is suitable for the date() 
function. 
Note: The results of this function are cached. See clearstatcache() for 
more details.
Tip: As of PHP 5.0.0 this function can also be used with some url 
wrappers. Refer to Appendix I for a listing of which wrappers support 
stat() family of functionality.
This function returns the time when the data blocks of a file were being 
written to, that is, the time when the content of the file was changed. 
Example 1. filemtime() example
  <?php
  // outputs e.g.  somefile.txt was last modified: December 29 
  2002 22:16:23.

  $filename = 'somefile.txt';
  if (file_exists($filename)) {
      echo "$filename was last modified: " . date ("F d Y 
  H:i:s.", filemtime($filename));
  }
  ?> 
See also filectime(), stat(), touch(), and getlastmod().   fileinodeUpfileowner
#

#T=int filemtime ( string filename)
filemtime ( ^!string filename);
#

#T=fileowner - int fileowner ( string filename)
(PHP 3, PHP 4 )
fileowner -- Gets file owner
Description
int fileowner ( string filename)
Returns the user ID of the owner of the file, or FALSE in case of an 
error. The user ID is returned in numerical format, use posix_getpwuid() 
to resolve it to a username. 
Note: The results of this function are cached. See clearstatcache() for 
more details.
Tip: As of PHP 5.0.0 this function can also be used with some url 
wrappers. Refer to Appendix I for a listing of which wrappers support 
stat() family of functionality.
See also stat()   filemtimeUpfileperms
#

#T=int fileowner ( string filename)
fileowner ( ^!string filename);
#

#T=fileperms - int fileperms ( string filename)
(PHP 3, PHP 4 )
fileperms -- Gets file permissions
Description
int fileperms ( string filename)
Returns the permissions on the file, or FALSE in case of an error. 
Note: The results of this function are cached. See clearstatcache() for 
more details.
Tip: As of PHP 5.0.0 this function can also be used with some url 
wrappers. Refer to Appendix I for a listing of which wrappers support 
stat() family of functionality.
See also is_readable(), and stat()   fileownerUpfilesize
#

#T=int fileperms ( string filename)
fileperms ( ^!string filename);
#

#T=filepro_fieldcount - int filepro_fieldcount ( void )
(PHP 3, PHP 4 )
filepro_fieldcount -- Find out how many fields are in a filePro database
Description
int filepro_fieldcount ( void )
Returns the number of fields (columns) in the opened filePro database. 
See also filepro().   filePro functionsUpfilepro_fieldname
#

#T=int filepro_fieldcount ( void )
filepro_fieldcount ( ^!void );
#

#T=filepro_fieldname - string filepro_fieldname ( int field_number)
(PHP 3, PHP 4 )
filepro_fieldname -- Gets the name of a field
Description
string filepro_fieldname ( int field_number)
Returns the name of the field corresponding to field_number.   filepro_fieldcountUpfilepro_fieldtype
#

#T=string filepro_fieldname ( int field_number)
filepro_fieldname ( ^!int field_number);
#

#T=filepro_fieldtype - string filepro_fieldtype ( int field_number)
(PHP 3, PHP 4 )
filepro_fieldtype -- Gets the type of a field
Description
string filepro_fieldtype ( int field_number)
Returns the edit type of the field corresponding to field_number.   filepro_fieldnameUpfilepro_fieldwidth
#

#T=string filepro_fieldtype ( int field_number)
filepro_fieldtype ( ^!int field_number);
#

#T=filepro_fieldwidth - int filepro_fieldwidth ( int field_number)
(PHP 3, PHP 4 )
filepro_fieldwidth -- Gets the width of a field
Description
int filepro_fieldwidth ( int field_number)
Returns the width of the field corresponding to field_number.   filepro_fieldtypeUpfilepro_retrieve
#

#T=int filepro_fieldwidth ( int field_number)
filepro_fieldwidth ( ^!int field_number);
#

#T=filepro_retrieve - string filepro_retrieve ( int row_number, int field_number)
(PHP 3, PHP 4 )
filepro_retrieve -- Retrieves data from a filePro database
Description
string filepro_retrieve ( int row_number, int field_number)
Returns the data from the specified location in the database. The 
row_number parameter must be between zero and the total number of rows 
minus one (0..filepro_rowcount() - 1). Likewise, field_number accepts 
values between zero and the total number of fields minus one 
(0..filepro_fieldcount() - 1) 
Note: When safe mode is enabled, PHP checks whether the files or 
directories you are about to operate on have the same UID (owner) as the 
script that is being executed.  filepro_fieldwidthUpfilepro_rowcount
#

#T=string filepro_retrieve ( int row_number, int field_number)
filepro_retrieve ( ^!int row_number, int field_number);
#

#T=filepro_rowcount - int filepro_rowcount ( void )
(PHP 3, PHP 4 )
filepro_rowcount -- Find out how many rows are in a filePro database
Description
int filepro_rowcount ( void )
Returns the number of rows in the opened filePro database. 
Note: When safe mode is enabled, PHP checks whether the files or 
directories you are about to operate on have the same UID (owner) as the 
script that is being executed.
See also filepro().   filepro_retrieveUpfilepro
#

#T=int filepro_rowcount ( void )
filepro_rowcount ( ^!void );
#

#T=filepro - bool filepro ( string directory)
(PHP 3, PHP 4 )
filepro -- Read and verify the map file
Description
bool filepro ( string directory)
This reads and verifies the map file, storing the field count and info. 
No locking is done, so you should avoid modifying your filePro database 
while it may be opened in PHP. 
Note: When safe mode is enabled, PHP checks whether the files or 
directories you are about to operate on have the same UID (owner) as the 
script that is being executed.  filepro_rowcountUpFilesystem functions
#

#T=bool filepro ( string directory)
filepro ( ^!string directory);
#

#T=filesize - int filesize ( string filename)
(PHP 3, PHP 4 )
filesize -- Gets file size
Description
int filesize ( string filename)
Returns the size of the file in bytes, or FALSE in case of an error. 
Note: Because PHP's integer type is signed and many platforms use 32bit 
integers, filesize() may return unexpected results for files which are 
larger than 2GB. For files between 2GB and 4GB in size this can usually 
be overcome by using sprintf("%u", filesize($file)). 
Note: The results of this function are cached. See clearstatcache() for 
more details.
Tip: As of PHP 5.0.0 this function can also be used with some url 
wrappers. Refer to Appendix I for a listing of which wrappers support 
stat() family of functionality.
Example 1. filesize() example
  <?php

  // outputs e.g.  somefile.txt: 1024 bytes

  $filename = 'somefile.txt';
  echo $filename . ': ' . filesize($filename) . ' bytes';

  ?> 
See also file_exists()   filepermsUpfiletype
#

#T=int filesize ( string filename)
filesize ( ^!string filename);
#

#T=filetype - string filetype ( string filename)
(PHP 3, PHP 4 )
filetype -- Gets file type
Description
string filetype ( string filename)
Returns the type of the file. Possible values are fifo, char, dir, block, 
link, file, and unknown. 
Returns FALSE if an error occurs. filetype() will also produce an E_NOTICE 
message if the stat call fails or if the file type is unknown. 
Note: The results of this function are cached. See clearstatcache() for 
more details.
Tip: As of PHP 5.0.0 this function can also be used with some url 
wrappers. Refer to Appendix I for a listing of which wrappers support 
stat() family of functionality.
Example 1. filetype() example
  <?php

  echo filetype('/etc/passwd');  // file
  echo filetype('/etc/');        // dir

  ?> 
See also is_dir(), is_file(), is_link(), file_exists(), stat(), and 
mime_content_type().   filesizeUpflock
#

#T=string filetype ( string filename)
filetype ( ^!string filename);
#

#T=floatval - float floatval ( mixed var)
(PHP 4 >= 4.2.0)
floatval -- Get float value of a variable
Description
float floatval ( mixed var)
Returns the float value of var. 
Var may be any scalar type. You cannot use floatval() on arrays or 
objects. 
<?php
$var = '122.34343The';
$float_value_of_var = floatval($var);
echo $float_value_of_var; // prints 122.34343
?> 

See also intval(), strval(), settype() and Type juggling.   emptyUpget_defined_vars
#

#T=float floatval ( mixed var)
floatval ( ^!mixed var);
#

#T=flock - bool flock ( resource handle, int operation [, int &wouldblock])
(PHP 3>= 3.0.7, PHP 4 )
flock -- Portable advisory file locking
Description
bool flock ( resource handle, int operation [, int &wouldblock])
PHP supports a portable way of locking complete files in an advisory way 
(which means all accessing programs have to use the same way of locking or 
it will not work). 
flock() operates on handle which must be an open file pointer. operation 
is one of the following values: 
To acquire a shared lock (reader), set operation to LOCK_SH (set to 1 
prior to PHP 4.0.1). 
To acquire an exclusive lock (writer), set operation to LOCK_EX (set to 
2 prior to PHP 4.0.1). 
To release a lock (shared or exclusive), set operation to LOCK_UN (set 
to 3 prior to PHP 4.0.1). 
If you don't want flock() to block while locking, add LOCK_NB (4 prior 
to PHP 4.0.1) to operation. 
flock() allows you to perform a simple reader/writer model which can be 
used on virtually every platform (including most Unix derivatives and even 
Windows). The optional third argument is set to TRUE if the lock would 
block (EWOULDBLOCK errno condition) 
Returns TRUE on success or FALSE on failure. 
Example 1. flock() example
  <?php

  $fp = fopen("/tmp/lock.txt", "w+");

  if (flock($fp, LOCK_EX)) { // do an exclusive lock
      fwrite($fp, "Write something here\n");
      flock($fp, LOCK_UN); // release the lock
  } else {
      echo "Couldn't lock the file !";
  }

  fclose($fp);

  ?> 
Note: Because flock() requires a file pointer, you may have to use a 
special lock file to protect access to a file that you intend to 
truncate by opening it in write mode (with a "w" or "w+" argument to 
fopen()). 
Warning
flock() will not work on NFS and many other networked file systems. 
Check your operating system documentation for more details. 
On some operating systems flock() is implemented at the process 
level. When using a multithreaded server API like ISAPI you may not 
be able to rely on flock() to protect files against other PHP 
scripts running in parallel threads of the same server instance! 
flock() is not supported on antiquated filesystems like FAT and its 
derivates and will therefore always return FALSE under this 
environments (this is especially true for Windows 98 users). 
  filetypeUpfnmatch
#

#T=bool flock ( resource handle, int operation [, int &wouldblock])
flock ( ^!resource handle, int operation [, int &wouldblock]);
#

#T=floor - float floor ( float value)
(PHP 3, PHP 4 )
floor -- Round fractions down
Description
float floor ( float value)
Returns the next lowest integer value by rounding down value if necessary. 
The return value of floor() is still of type float because the value range 
of float is usually bigger than that of integer. 
Example 1. floor() example
  <?php
  echo floor(4.3);   // 4
  echo floor(9.999); // 9
  ?> 
See also ceil() and round().   expm1Upfmod
#

#T=float floor ( float value)
floor ( ^!float value);
#

#T=flush - void flush ( void )
(PHP 3, PHP 4 )
flush -- Flush the output buffer
Description
void flush ( void )
Flushes the output buffers of PHP and whatever backend PHP is using (CGI, 
a web server, etc). This effectively tries to push all the output so far 
to the user's browser. 
flush() has no effect on the buffering scheme of your webserver or the 
browser on the client side. 
Several servers, especially on Win32, will still buffer the output from 
your script until it terminates before transmitting the results to the 
browser. 
Server modules for Apache like mod_gzip may do buffering of their own that 
will cause flush() to not result in data being sent immediately to the 
client. 
Even the browser may buffer its input before displaying it. Netscape, for 
example, buffers text until it receives an end-of-line or the beginning of 
a tag, and it won't render tables until the </table> tag of the outermost 
table is seen. 
Some versions of Microsoft Internet Explorer will only start to display 
the page after they have received 256 bytes of output, so you may need to 
send extra whitespace before flushing to get those browsers to display the 
page.   Output Control FunctionsUpob_clean
#

#T=void flush ( void )
flush ( ^!void );
#

#T=fmod - float fmod ( float x, float y)
(PHP 4 >= 4.2.0)
fmod -- Returns the floating point remainder (modulo) of the division of 
the arguments
Description
float fmod ( float x, float y)
Returns the floating point remainder of dividing the dividend (x) by the 
divisor (y). The reminder (r) is defined as: x = i * y + r, for some 
integer i. If y is non-zero, r has the same sign as x and a magnitude less 
than the magnitude of y. 
Example 1. Using fmod()
  <?php
  $x = 5.7;
  $y = 1.3;
  $r = fmod($x, $y);
  // $r equals 0.5, because 4 * 1.3 + 0.5 = 5.7
  ?> 

  floorUpgetrandmax
#

#T=float fmod ( float x, float y)
fmod ( ^!float x, float y);
#

#T=fnmatch - array fnmatch ( string pattern, string string [, int flags])
(PHP 4 >= 4.3.0)
fnmatch -- Match filename against a pattern
Description
array fnmatch ( string pattern, string string [, int flags])
fnmatch() checks if the passed string would match the given shell wildcard 
pattern. 
This is especially useful for filenames, but may also be used on regular 
strings. The average user may be used to shell patterns or at least in 
their simplest form to '?' and '*' wildcards so using fnmatch() instead of 
ereg() or preg_match() for frontend search expression input may be way 
more convenient for non-programming users. 
Example 1. Checking a color name against a shell wildcard pattern. 
  <?php
  if (fnmatch("*gr[ae]y", $color)) {
    echo "some form of gray ...";
  }
  ?> 
See also glob(), ereg(), preg_match() and the Unix manpage on fnmatch(3) 
for flag names (as long as they are not documented here ).   flockUpfopen
#

#T=array fnmatch ( string pattern, string string [, int flags])
fnmatch ( ^!string pattern, string string [, int flags]);
#

#T=fopen - resource fopen ( string filename, string mode [, int use_include_path [, 
(PHP 3, PHP 4 )
fopen -- Opens file or URL
Description
resource fopen ( string filename, string mode [, int use_include_path [, 
resource zcontext]])
fopen() binds a named resource, specified by filename, to a stream. If 
filename is of the form "scheme://...", it is assumed to be a URL and PHP 
will search for a protocol handler (also known as a wrapper) for that 
scheme. If no wrappers for that protocol are registered, PHP will emit a 
notice to help you track potential problems in your script and then 
continue as though filename specifies a regular file. 
If PHP has decided that filename specifies a local file, then it will try 
to open a stream on that file. The file must be accessible to PHP, so you 
need to ensure that the file access permissions allow this access. If you 
have enabled safe mode, or open_basedir further restrictions may apply. 
If PHP has decided that filename specifies a registered protocol, and that 
protocol is registered as a network URL, PHP will check to make sure that 
allow_url_fopen is enabled. If it is switched off, PHP will emit a warning 
and the fopen call will fail. 
Note: The list of supported protocols can be found in Appendix I. Some 
protocols (also referred to as wrappers) support context and/or php.ini 
options. Refer to the specific page for the protocol in use for a list 
of options which can be set. ( i.e. php.ini value user_agent used by the 
http wrapper) For a description of contexts and the zcontext parameter , 
refer to Reference CI, Stream functions. 
The mode parameter specifies the type of access you require to the stream. 
It may be any of the following: 
Table 1. A list of possible modes for fopen() using mode 
modeDescription
'r'Open for reading only; place the file pointer at the beginning of 
the file. 
'r+'Open for reading and writing; place the file pointer at the 
beginning of the file. 
'w'Open for writing only; place the file pointer at the beginning of 
the file and truncate the file to zero length. If the file does not 
exist, attempt to create it. 
'w+'Open for reading and writing; place the file pointer at the 
beginning of the file and truncate the file to zero length. If the 
file does not exist, attempt to create it. 
'a'Open for writing only; place the file pointer at the end of the 
file. If the file does not exist, attempt to create it. 
'a+'Open for reading and writing; place the file pointer at the end 
of the file. If the file does not exist, attempt to create it. 
'x'Create and open for writing only; place the file pointer at the 
beginning of the file. If the file already exists, the fopen() call 
will fail by returning FALSE and generating an error of level 
E_WARNING. If the file does not exist, attempt to create it. This is 
equivalent to specifying O_EXCL|O_CREAT flags for the underlying 
open(2) system call. This option is supported in PHP 4.3.2 and 
later, and only works for local files. 
'x+'Create and open for reading and writing; place the file pointer 
at the beginning of the file. If the file already exists, the 
fopen() call will fail by returning FALSE and generating an error of 
level E_WARNING. If the file does not exist, attempt to create it. 
This is equivalent to specifying O_EXCL|O_CREAT flags for the 
underlying open(2) system call. This option is supported in PHP 
4.3.2 and later, and only works for local files. 

Note: Different operating system families have different line-ending 
conventions. When you write a text file and want to insert a line break, 
you need to use the correct line-ending character(s) for your operating 
system. Unix based systems use \n as the line ending character, Windows 
based systems use \r\n as the line ending characters and Macintosh based 
systems use \r as the the line ending character. 
If you use the wrong line ending characters when writing your files, you 
might find that other applications that open those files will "look 
funny". 
Windows offers a text-mode translation flag ('t') which will 
transparently translate \n to \r\n when working with the file. In 
contrast, you can also use 'b' to force binary mode, which will not 
translate your data. To use these flags, specify either 'b' or 't' as 
the last character of the mode parameter. 
The default translation mode depends on the SAPI and version of PHP that 
you are using, so you are encouraged to always specify the appropriate 
flag for portability reasons. You should use the 't' mode if you are 
working with plain-text files and you use \n to delimit your line 
endings in your script, but expect your files to be readable with 
applications such as notepad. You should use the 'b' in all other cases. 

If you do not specify the 'b' flag when working with binary files, you 
may experience strange problems with your data, including broken image 
files and strange problems with \r\n characters. 
For portability, it is strongly recommended that you always use the 'b' 
flag when opening files with fopen(). 
Again, for portability, it is also strongly recommended that you 
re-write code that uses or relies upon the 't' mode so that it uses the 
correct line endings and 'b' mode instead. 
As of PHP 4.3.2, the default mode is set to binary for all platforms 
that distinguish between binary and text mode. If you are having 
problems with your scripts after upgrading, try using the 't' flag as a 
workaround until you have made your script more portable as mentioned 
above. 
The optional third use_include_path parameter can be set to '1' or TRUE if 
you want to search for the file in the include_path, too. 
If the open fails, the function returns FALSE and an error of level 
E_WARNING is generated. You may use @ to suppress this warning. 
Example 1. fopen() examples
  <?php
  $handle = fopen("/home/rasmus/file.txt", "r");
  $handle = fopen("/home/rasmus/file.gif", "wb");
  $handle = fopen("http://www.example.com/", "r");
  $handle = 
  fopen("ftp://user:password@example.com/somefile.txt", "w");
  ?> 
If you are experiencing problems with reading and writing to files and 
you're using the server module version of PHP, remember to make sure that 
the files and directories you're using are accessible to the server 
process. 
On the Windows platform, be careful to escape any backslashes used in the 
path to the file, or use forward slashes. 
<?php
$handle = fopen("c:\\data\\info.txt", "r");
?> 

Note: When safe mode is enabled, PHP checks whether the directory in 
which you are about to operate has the same UID (owner) as the script 
that is being executed.
See also Appendix I, fclose(), fgets(), fread(), fwrite(), fsockopen(), 
file(), file_exists(), is_readable(), stream_set_timeout(), and popen().   fnmatchUpfpassthru
#

#T=resource fopen ( string filename, string mode [, int use_include_path [, 
fopen ( ^!string filename, string mode [, int use_include_path [, ;
#

#T=fpassthru - int fpassthru ( resource handle)
(PHP 3, PHP 4 )
fpassthru -- Output all remaining data on a file pointer
Description
int fpassthru ( resource handle)
Reads to EOF on the given file pointer from the current position and 
writes the results to the output buffer. 
If an error occurs, fpassthru() returns FALSE. Otherwise, fpassthru() 
returns the number of characters read from handle and passed through to 
the output. 
The file pointer must be valid, and must point to a file successfully 
opened by fopen(), popen(), or fsockopen(). You may need to call rewind() 
to reset the file pointer to the beginning of the file if you have already 
written data to the file. The file is closed when fpassthru() is done 
reading it (leaving handle useless). 
If you just want to dump the contents of a file to the output buffer, 
without first modifying it or seeking to a particular offset, you may want 
to use the readfile(), which saves you the fopen() call. 
Note: When using fpassthru() on a binary file on Windows systems, you 
should make sure to open the file in binary mode by appending a b to the 
mode used in the call to fopen(). 
You are encouraged to use the b flag when dealing with binary files, 
even if your system does not require it, so that your scripts will be 
more portable. 
Example 1. Using fpassthru() with binary files
  <?php

  // open the file in a binary mode
  $name = ".\public\dev\img\ok.png";
  $fp = fopen($name, 'rb');

  // send the right headers
  header("Content-Type: image/png");
  header("Content-Length: " . filesize($name));

  // dump the picture and stop the script
  fpassthru($fp);
  exit;

  ?> 
See also readfile(), fopen(), popen(), and fsockopen()   fopenUpfputs
#

#T=int fpassthru ( resource handle)
fpassthru ( ^!resource handle);
#

#T=fprintf - int fprintf ( resource handle, string format [, mixed args])
(PHP 5 CVS only)
fprintf -- Write a formatted string to a stream
Description
int fprintf ( resource handle, string format [, mixed args])
Write a string produced according to the formatting string format to the 
stream resource specified by handle.. 
The format string is composed of zero or more directives: ordinary 
characters (excluding %) that are copied directly to the result, and 
conversion specifications, each of which results in fetching its own 
parameter. This applies to fprintf(), sprintf(), and printf(). 
Each conversion specification consists of a percent sign (%), followed by 
one or more of these elements, in order: 
An optional padding specifier that says what character will be used for 
padding the results to the right string size. This may be a space 
character or a 0 (zero character). The default is to pad with spaces. An 
alternate padding character can be specified by prefixing it with a 
single quote ('). See the examples below. 
An optional alignment specifier that says if the result should be 
left-justified or right-justified. The default is right-justified; a - 
character here will make it left-justified. 
An optional number, a width specifier that says how many characters 
(minimum) this conversion should result in. 
An optional precision specifier that says how many decimal digits should 
be displayed for floating-point numbers. This option has no effect for 
other types than float. (Another function useful for formatting numbers 
is number_format().) 
A type specifier that says what type the argument data should be treated 
as. Possible types: 
% - a literal percent character. No argument is required. 
b - the argument is treated as an integer, and presented as a 
binary number. 
c - the argument is treated as an integer, and presented as the 
character with that ASCII value. 
d - the argument is treated as an integer, and presented as a 
(signed) decimal number. 
u - the argument is treated as an integer, and presented as an 
unsigned decimal number. 
f - the argument is treated as a float, and presented as a 
floating-point number. 
o - the argument is treated as an integer, and presented as an 
octal number. 
s - the argument is treated as and presented as a string. 
x - the argument is treated as an integer and presented as a 
hexadecimal number (with lowercase letters). 
X - the argument is treated as an integer and presented as a 
hexadecimal number (with uppercase letters). 

See also: printf(), sprintf(), sscanf(), fscanf(), vsprintf(), and 
number_format(). 
Examples
Example 1. sprintf(): zero-padded integers
  <?php
  $isodate = sprintf("%04d-%02d-%02d", $year, $month, $day);
  ?> 

Example 2. sprintf(): formatting currency
  <?php
  $money1 = 68.75;
  $money2 = 54.35;
  $money = $money1 + $money2;
  // echo $money will output "123.1";
  $formatted = sprintf("%01.2f", $money);
  // echo $formatted will output "123.10"
  ?> 

  explodeUpget_html_translation_table
fputs
fputs -- Alias of fwrite()
Description
This function is an alias of fwrite().   fpassthruUpfread
#

#T=int fprintf ( resource handle, string format [, mixed args])
fprintf ( ^!resource handle, string format [, mixed args]);
#

#T=fread - string fread ( resource handle, int length)
(PHP 3, PHP 4 )
fread -- Binary-safe file read
Description
string fread ( resource handle, int length)
fread() reads up to length bytes from the file pointer referenced by 
handle. Reading stops when length bytes have been read, EOF (end of file) 
is reached, or (for network streams) when a packet becomes available, 
whichever comes first. 
<?php
// get contents of a file into a string
$filename = "/usr/local/something.txt";
$handle = fopen($filename, "r");
$contents = fread($handle, filesize($filename));
fclose($handle);
?> 

Warning
On systems which differentiate between binary and text files (i.e. 
Windows) the file must be opened with 'b' included in fopen() mode 
parameter. 

<?php
$filename = "c:\\files\\somepic.gif";
$handle = fopen($filename, "rb");
$contents = fread($handle, filesize($filename));
fclose($handle);
?> 

Warning
When reading from network streams or pipes, such as those returned 
when reading remote files or from popen() and proc_open(), reading 
will stop after a packet is available. This means that you should 
collect the data together in chunks as shown in the example below. 

<?php
$handle = fopen("http://www.example.com/", "rb");
$contents = "";
do {
$data = fread($handle, 8192);
if (strlen($data) == 0) {
    break;
}
$contents .= $data;
} while (true);
fclose($handle);
?> 

Note: The example above has better performance than the traditional 
approach using while(!feof()), as we are saving the overhead of a 
function call per iteration. 
Note: If you just want to get the contents of a file into a string, use 
file_get_contents() as it has much better performance than the code 
above. 
See also fwrite(), fopen(), fsockopen(), popen(), fgets(), fgetss(), 
fscanf(), file(), and fpassthru().   fputsUpfscanf
#

#T=string fread ( resource handle, int length)
fread ( ^!resource handle, int length);
#

#T=FrenchToJD - int frenchtojd ( int month, int day, int year)
(PHP 3, PHP 4 )
FrenchToJD --  Converts a date from the French Republican Calendar to a 
Julian Day Count 
Description
int frenchtojd ( int month, int day, int year)
Converts a date from the French Republican Calendar to a Julian Day Count. 

These routines only convert dates in years 1 through 14 (Gregorian dates 
22 September 1792 through 22 September 1806). This more than covers the 
period when the calendar was in use.   easter_daysUpGregorianToJD
fribidi_log2vis
(4.0.4 - 4.3.2 only)
fribidi_log2vis -- Convert a logical string to a visual one
Description
string fribidi_log2vis ( string str, string direction, int charset)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Warning
This function is currently not documented; only the argument list is 
available.
  FriBiDi functionsUpFTP functions
#

#T=int frenchtojd ( int month, int day, int year)
frenchtojd ( ^!int month, int day, int year);
#

#T=fscanf - mixed fscanf ( resource handle, string format [, string var1])
(PHP 4 >= 4.0.1)
fscanf -- Parses input from a file according to a format
Description
mixed fscanf ( resource handle, string format [, string var1])
The function fscanf() is similar to sscanf(), but it takes its input from 
a file associated with handle and interprets the input according to the 
specified format, which is described in the documentation for sprintf(). 
If only two parameters were passed to this function, the values parsed 
will be returned as an array. Otherwise, if optional parameters are 
passed, the function will return the number of assigned values. The 
optional parameters must be passed by reference. 
Any whitespace in the format string matches any whitespace in the input 
stream. This means that even a tab \t in the format string can match a 
single space character in the input stream. 
Example 1. fscanf() Example
  <?php
  $handle = fopen("users.txt", "r");
  while ($userinfo = fscanf($handle, "%s\t%s\t%s\n")) {
      list ($name, $profession, $countrycode) = $userinfo;
      //... do something with the values
  }
  fclose($handle);
  ?> 

Example 2. users.txt
javier  argonaut        pe
hiroshi sculptor        jp
robert  slacker us
luigi   florist it
Note: Prior to PHP 4.3.0, the maximum number of characters read from the 
file was 512 (or up to the first \n, whichever came first). As of PHP 
4.3.0 arbitrarily long lines will be read and scanned. 
See also fread(), fgets(), fgetss(), sscanf(), printf(), and sprintf().   freadUpfseek
#

#T=mixed fscanf ( resource handle, string format [, string var1])
fscanf ( ^!resource handle, string format [, string var1]);
#

#T=fseek - int fseek ( resource handle, int offset [, int whence])
(PHP 3, PHP 4 )
fseek -- Seeks on a file pointer
Description
int fseek ( resource handle, int offset [, int whence])
Sets the file position indicator for the file referenced by handle.The new 
position, measured in bytes from the beginning of the file, is obtained by 
adding offset to the position specified by whence, whose values are 
defined as follows: 
SEEK_SET - Set position equal to offset bytes.
SEEK_CUR - Set position to current location plus offset.
SEEK_END - Set position to end-of-file plus offset. (To move to a 
position before the end-of-file, you need to pass a negative value 
in offset.)

If whence is not specified, it is assumed to be SEEK_SET. 
Upon success, returns 0; otherwise, returns -1. Note that seeking past EOF 
is not considered an error. 
Example 1. fseek() example
  <?php

  $fp = fopen('somefile.txt');

  // read some data
  $data = fgets($fp, 4096);

  // move back to the beginning of the file
  // same as rewind($fp);
  fseek($fp, 0);

  ?> 
May not be used on file pointers returned by fopen() if they use the 
"http://" or "ftp://" formats. 
Note: The whence argument was added after PHP 4.0.0. 
See also ftell() and rewind().   fscanfUpfstat
#

#T=int fseek ( resource handle, int offset [, int whence])
fseek ( ^!resource handle, int offset [, int whence]);
#

#T=fsockopen - resource fsockopen ( string target, int port [, int errno [, string errstr 
(PHP 3, PHP 4 )
fsockopen --  Open Internet or Unix domain socket connection 
Description
resource fsockopen ( string target, int port [, int errno [, string errstr 
[, float timeout]]])
Initiates a socket connection to the resource specified by target. PHP 
supports targets in the Internet and Unix domains as described in Appendix 
J. A list of supported transports can also be retrieved using 
stream_get_transports(). 
Note: If you need to set a timeout for reading/writing data over the 
socket, use stream_set_timeout(), as the timeout parameter to 
fsockopen() only applies while connecting the socket. 
As of PHP 4.3.0, if you have compiled in OpenSSL support, you may prefix 
the hostname with either 'ssl://' or 'tls://' to use an SSL or TLS client 
connection over TCP/IP to connect to the remote host. 
fsockopen() returns a file pointer which may be used together with the 
other file functions (such as fgets(), fgetss(), fputs(), fclose(), and 
feof()). 
If the call fails, it will return FALSE and if the optional errno and 
errstr arguments are present they will be set to indicate the actual 
system level error that occurred in the system-level connect() call. If 
the value returned in errno is 0 and the function returned FALSE, it is an 
indication that the error occurred before the connect() call. This is most 
likely due to a problem initializing the socket. Note that the errno and 
errstr arguments will always be passed by reference. 
Depending on the environment, the Unix domain or the optional connect 
timeout may not be available. 
The socket will by default be opened in blocking mode. You can switch it 
to non-blocking mode by using stream_set_blocking(). Example 1. 
fsockopen() Example
  <?php
  $fp = fsockopen("www.example.com", 80, $errno, $errstr, 30);
  if (!$fp) {
      echo "$errstr ($errno)<br />\n";
  } else {
      $out = "GET / HTTP/1.1\r\n";
      $out .= "Host: www.example.com\r\n";
      $out .= "Connection: Close\r\n\r\n";

      fputs($fp, $out);
      while (!feof($fp)) {
	  echo fgets($fp, 128);
      }
      fclose($fp);
  }
  ?> 

The example below shows how to retrieve the day and time from the UDP 
service "daytime" (port 13) in your own machine. Example 2. Using 
UDP connection
  <?php
  $fp = fsockopen("udp://127.0.0.1", 13, $errno, $errstr);
  if (!$fp) {
      echo "ERROR: $errno - $errstr<br />\n";
  } else {
      fwrite($fp, "\n");
      echo fread($fp, 26);
      fclose($fp);
  }
  ?> 
Warning
UDP sockets will sometimes appear to have opened without an error, 
even if the remote host is unreachable. The error will only become 
apparent when you read or write data to/from the socket. The reason 
for this is because UDP is a "connectionless" protocol, which means 
that the operating system does not try to establish a link for the 
socket until it actually needs to send or receive data. 

Note: When specifying a numerical IPv6 address (e.g. fe80::1) you must 
enclose the IP in square brackets. For example, tcp://[fe80::1]:80.
Note: The timeout parameter was introduced in PHP 3.0.9 and UDP support 
was added in PHP 4. 
See also pfsockopen(), stream_set_blocking(), stream_set_timeout(), 
fgets(), fgetss(), fputs(), fclose(), feof(), and the Curl extension.   dns_get_recordUpgethostbyaddr
#

#T=resource fsockopen ( string target, int port [, int errno [, string errstr 
fsockopen ( ^!string target, int port [, int errno [, string errstr ;
#

#T=fstat - array fstat ( resource handle)
(PHP 4 )
fstat -- Gets information about a file using an open file pointer
Description
array fstat ( resource handle)
Gathers the statistics of the file opened by the file pointer handle. This 
function is similar to the stat() function except that it operates on an 
open file pointer instead of a filename. 
Returns an array with the statistics of the file; the format of the array 
is described in detail on the stat() manual page. 
Example 1. fstat() example
  <?php

  // open a file
  $fp = fopen("/etc/passwd", "r");

  // gather statistics
  $fstat = fstat($fp);

  // close the file
  fclose($fp);

  // print only the associative part
  print_r(array_slice($fstat, 13));

  ?> 

this will output : 
Array
(
[dev] => 771
[ino] => 488704
[mode] => 33188
[nlink] => 1
[uid] => 0
[gid] => 0
[rdev] => 0
[size] => 1114
[atime] => 1061067181
[mtime] => 1056136526
[ctime] => 1056136526
[blksize] => 4096
[blocks] => 8
)
Note: The results of this function are cached. See clearstatcache() for 
more details.
Note: This function will not work on remote files as the file to be 
examined must be accessible via the servers filesystem.  fseekUpftell
#

#T=array fstat ( resource handle)
fstat ( ^!resource handle);
#

#T=ftell - int ftell ( resource handle)
(PHP 3, PHP 4 )
ftell -- Tells file pointer read/write position
Description
int ftell ( resource handle)
Returns the position of the file pointer referenced by handle; i.e., its 
offset into the file stream. 
If an error occurs, returns FALSE. 
The file pointer must be valid, and must point to a file successfully 
opened by fopen() or popen(). 
Example 1. ftell() example
  <?php

  // opens a file and read some data
  $fp = fopen("/etc/passwd", "r");
  $data = fgets($fp, 12);

  // where are we ?
  echo ftell($fp); // 11

  fclose($fp);

  ?> 
See also fopen(), popen(), fseek(), and rewind().   fstatUpftruncate
#

#T=int ftell ( resource handle)
ftell ( ^!resource handle);
#

#T=ftok - int ftok ( string pathname, string proj)
(PHP 4 >= 4.2.0)
ftok --  Convert a pathname and a project identifier to a System V IPC key 

Description
int ftok ( string pathname, string proj)
The function converts the pathname of an existing accessible file and a 
project identifier (proj) into a integer for use with for example 
shmop_open() and other System V IPC keys. The proj parameter should be a 
one character string. 
On success the return value will be the created key value, otherwise -1 is 
returned. 
See also shmop_open() and sem_get().   Semaphore, Shared Memory and IPC FunctionsUpmsg_get_queue
ftp_alloc
(no version information, might be only in CVS)
ftp_alloc -- Allocates space for a file to be uploaded.
Description
bool ftp_alloc ( resource ftp_stream, int filesize [, string &result])
Sends an ALLO command to the remote FTP server to allocate filesize bytes 
of space. Returns TRUE on success, or FALSE on failure. 
Note: Many FTP servers do not support this command. These servers may 
return a failure code (FALSE) indicating the command is not supported or 
a success code (TRUE) to indicate that pre-allocation is not necessary 
and the client should continue as though the operation were successful. 
Because of this, it may be best to reserve this function for servers 
which explicitly require preallocation. 
A textual representation of the servers response will be returned by 
reference in result is a variable is provided. 
Example 1. ftp_alloc() example
  <?php

  $file = "/home/user/myfile";

  /* connect to the server */
  $conn_id = ftp_connect('ftp.example.com');
  $login_result = ftp_login($conn_id, 'anonymous', 
  'user@example.com');

  if (ftp_alloc($conn_id, filesize($file), $result)) {
    echo "Space successfully allocated on server.  Sending 
  $file.\n";
    ftp_put($conn_id, '/incomming/myfile', $file, FTP_BINARY);
  } else {
    echo "Unable to allocate space on server.  Server said: 
  $result\n";
  }

  ftp_close($conn_id);

  ?> 
See also: ftp_put(), and ftp_fput().   FTP functionsUpftp_cdup
#

#T=int ftok ( string pathname, string proj)
ftok ( ^!string pathname, string proj);
#

#T=ftp_cdup - bool ftp_cdup ( resource ftp_stream)
(PHP 3>= 3.0.13, PHP 4 )
ftp_cdup -- Changes to the parent directory
Description
bool ftp_cdup ( resource ftp_stream)
Changes to the parent directory. 
Example 1. ftp_cdup() example
  <?php
  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // change the current directory to html
  ftp_chdir($conn_id, 'html');

  echo ftp_pwd($conn_id); // /html 

  // return to the parent directory
  if (ftp_cdup($conn_id)) { 
    echo "cdup successful\n";
  } else {
    echo "cdup not successful\n";
  }

  echo ftp_pwd($conn_id); // /

  ftp_close($conn_id);
  ?> 
Returns TRUE on success or FALSE on failure. 
See also ftp_chdir().   ftp_allocUpftp_chdir
#

#T=bool ftp_cdup ( resource ftp_stream)
ftp_cdup ( ^!resource ftp_stream);
#

#T=ftp_chdir - bool ftp_chdir ( resource ftp_stream, string directory)
(PHP 3>= 3.0.13, PHP 4 )
ftp_chdir -- Changes directories on a FTP server
Description
bool ftp_chdir ( resource ftp_stream, string directory)
Changes the current directory to the specified directory. 
Returns TRUE on success or FALSE on failure. 
Example 1. ftp_chdir() example
  <?php

  // set up basic connection
  $conn_id = ftp_connect($ftp_server); 

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass); 

  // check connection
  if ((!$conn_id) || (!$login_result)) {
      die("FTP connection has failed !");
  }

  echo "Current directory: " . ftp_pwd($conn_id) . "\n";

  // try to change the directory to somedir
  if (ftp_chdir($conn_id, "somedir")) {
      echo "Current directory is now: " . ftp_pwd($conn_id) . 
  "\n";
  } else { 
      echo "Couldn't change directory\n";
  }

  // close the connection
  ftp_close($conn_id);
  ?> 
See also ftp_cdup().   ftp_cdupUpftp_chmod
#

#T=bool ftp_chdir ( resource ftp_stream, string directory)
ftp_chdir ( ^!resource ftp_stream, string directory);
#

#T=ftp_chmod - string ftp_chmod ( resource ftp_stream, int mode, string filename)
(PHP 5 CVS only)
ftp_chmod -- Set permissions on a file via FTP
Description
string ftp_chmod ( resource ftp_stream, int mode, string filename)
Sets the permissions on the remote file specified by filename to mode 
given as an octal value. 
Example 1. ftp_chmod() example
  <?php
  $file = 'public_html/index.php';

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // try to chmod $file to 644
  if (ftp_chmod($conn_id, 0644, $file)) {
  echo "$file cdmoded successfully to 644\n";
  } else {
  echo "could not chmod $file\n";
  }

  // close the connection
  ftp_close($conn_id);
  ?> 
Returns the new file permissions on success or FALSE on error. 
See also chmod().   ftp_chdirUpftp_close
#

#T=string ftp_chmod ( resource ftp_stream, int mode, string filename)
ftp_chmod ( ^!resource ftp_stream, int mode, string filename);
#

#T=ftp_close - void ftp_close ( resource ftp_stream)
(PHP 4 >= 4.2.0)
ftp_close -- Closes an FTP connection
Description
void ftp_close ( resource ftp_stream)
ftp_close() closes ftp_stream and releases the resource. After calling 
this function, you can no longer use the FTP connection and must create a 
new one with ftp_connect(). 
Example 1. ftp_close() example
  <?php

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // print the current directory
  echo ftp_pwd($conn_id); // /

  // close this connection
  ftp_close($conn_id);
  ?> 
See also ftp_connect()   ftp_chmodUpftp_connect
#

#T=void ftp_close ( resource ftp_stream)
ftp_close ( ^!resource ftp_stream);
#

#T=ftp_connect - resource ftp_connect ( string host [, int port [, int timeout]])
(PHP 3>= 3.0.13, PHP 4 )
ftp_connect -- Opens an FTP connection
Description
resource ftp_connect ( string host [, int port [, int timeout]])
Returns a FTP stream on success or FALSE on error. 
ftp_connect() opens an FTP connection to the specified host. host 
shouldn't have any trailing slashes and shouldn't be prefixed with ftp://. 
The port parameter specifies an alternate port to connect to. If it is 
omitted or set to zero, then the default FTP port, 21, will be used. 
The timeout parameter specifies the timeout for all subsequent network 
operations. If omitted, the default value is 90 seconds. The timeout can 
be changed and queried at any time with ftp_set_option() and 
ftp_get_option(). 
Note: The timeout parameter became available in PHP 4.2.0. 
Example 1. ftp_connect() example
  <?php

  $ftp_server = "ftp.example.com";

  // set up a connection or die
  $conn_id = ftp_connect($ftp_server) or die("Couldn't connect 
  to $ftp_server"); 

  ?> 
See also ftp_close(), and ftp_ssl_connect().   ftp_closeUpftp_delete
#

#T=resource ftp_connect ( string host [, int port [, int timeout]])
ftp_connect ( ^!string host [, int port [, int timeout]]);
#

#T=ftp_delete - bool ftp_delete ( resource ftp_stream, string path)
(PHP 3>= 3.0.13, PHP 4 )
ftp_delete -- Deletes a file on the FTP server
Description
bool ftp_delete ( resource ftp_stream, string path)
ftp_delete() deletes the file specified by path from the FTP server. 
Example 1. ftp_delete() example
  <?php
  $file = 'public_html/old.txt';

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // try to delete $file
  if (ftp_delete($conn_id, $file)) {
  echo "$file deleted successful\n";
  } else {
  echo "could not delete $file\n";
  }

  // close the connection
  ftp_close($conn_id);
  ?> 
Returns TRUE on success or FALSE on failure.   ftp_connectUpftp_exec
#

#T=bool ftp_delete ( resource ftp_stream, string path)
ftp_delete ( ^!resource ftp_stream, string path);
#

#T=ftp_exec - bool ftp_exec ( resource ftp_stream, string command)
(PHP 4 >= 4.0.3)
ftp_exec -- Requests execution of a program on the FTP server
Description
bool ftp_exec ( resource ftp_stream, string command)
Sends a SITE EXEC command request to the FTP server. Returns TRUE if the 
command was successful (server sent response code: 200); otherwise returns 
FALSE. 
Example 1. ftp_exec() example
  <?php

  $command = 'ls -al';

  $conn_id = ftp_connect($ftp_server);

  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  if ($res = ftp_exec($conn_id, $command)) {
      echo "$command executed successfully<br />\n";
      echo nl2br($res);
  } else {
      echo 'could not execute ' . $command;
  }

  ?> 
See also ftp_raw().   ftp_deleteUpftp_fget
#

#T=bool ftp_exec ( resource ftp_stream, string command)
ftp_exec ( ^!resource ftp_stream, string command);
#

#T=ftp_fget - bool ftp_fget ( resource ftp_stream, resource handle, string remote_file, 
(PHP 3>= 3.0.13, PHP 4 )
ftp_fget -- Downloads a file from the FTP server and saves to an open file
Description
bool ftp_fget ( resource ftp_stream, resource handle, string remote_file, 
int mode [, int resumepos])
ftp_fget() retrieves remote_file from the FTP server, and writes it to the 
given file pointer, handle. The transfer mode specified must be either 
FTP_ASCII or FTP_BINARY. 
Example 1. ftp_fget() example
  <?php

  // open some file for reading
  $file = 'somefile.txt';
  $fp = fopen($file, 'w');

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // try to download $file
  if (ftp_fget($conn_id, $fp, $file, FTP_ASCII, 1)) {
  echo "successfully written to $file\n";
  } else {
  echo "There was a problem with $file\n";
  }

  // close the connection and the file handler
  ftp_close($conn_id);
  fclose($fp);
  ?> 
Note: The resumepos parameter was added in PHP 4.3.0. 
Returns TRUE on success or FALSE on failure. 
See also ftp_get(), ftp_nb_get() and ftp_nb_fget().   ftp_execUpftp_fput
#

#T=bool ftp_fget ( resource ftp_stream, resource handle, string remote_file, 
ftp_fget ( ^!resource ftp_stream, resource handle, string remote_file, ;
#

#T=ftp_fput - bool ftp_fput ( resource ftp_stream, string remote_file, resource handle, 
(PHP 3>= 3.0.13, PHP 4 )
ftp_fput -- Uploads from an open file to the FTP server
Description
bool ftp_fput ( resource ftp_stream, string remote_file, resource handle, 
int mode [, int startpos])
ftp_fput() uploads the data from the file pointer handle until the end of 
the file is reached. The results are stored in remote_file on the FTP 
server. The transfer mode specified must be either FTP_ASCII or 
FTP_BINARY. 
Example 1. ftp_fput() example
  <?php

  // open some file for reading
  $file = 'somefile.txt';
  $fp = fopen($file, 'r');

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // try to upload $file
  if (ftp_fput($conn_id, $file, $fp, FTP_ASCII)) {
      echo "Successfully uploaded $file\n";
  } else {
      echo "There was a problem while uploading $file\n";
  }

  // close the connection and the file handler
  ftp_close($conn_id);
  fclose($fp);

  ?> 
Note: The startpos parameter was added in PHP 4.3.0. 
Returns TRUE on success or FALSE on failure. 
See also ftp_put(), ftp_nb_fput(), and ftp_nb_put().   ftp_fgetUpftp_get_option
#

#T=bool ftp_fput ( resource ftp_stream, string remote_file, resource handle, 
ftp_fput ( ^!resource ftp_stream, string remote_file, resource handle, ;
#

#T=ftp_get_option - mixed ftp_get_option ( resource ftp_stream, int option)
(PHP 4 >= 4.2.0)
ftp_get_option -- Retrieves various runtime behaviours of the current FTP 
stream
Description
mixed ftp_get_option ( resource ftp_stream, int option)
Returns the value on success or FALSE if the given option is not 
supported. In the latter case, a warning message is also thrown. 
This function returns the value for the requested option from the 
specified ftp_stream . Currently, the following options are supported: 
Table 1. Supported runtime FTP options
FTP_TIMEOUT_SECReturns the current timeout used for network related 
operations. 

Example 1. ftp_get_option() example
  <?php
  // Get the timeout of the given FTP stream
  $timeout = ftp_get_option($conn_id, FTP_TIMEOUT_SEC);
  ?> 
See also ftp_set_option().   ftp_fputUpftp_get
#

#T=mixed ftp_get_option ( resource ftp_stream, int option)
ftp_get_option ( ^!resource ftp_stream, int option);
#

#T=ftp_get - bool ftp_get ( resource ftp_stream, string local_file, string remote_file, 
(PHP 3>= 3.0.13, PHP 4 )
ftp_get -- Downloads a file from the FTP server
Description
bool ftp_get ( resource ftp_stream, string local_file, string remote_file, 
int mode [, int resumepos])
ftp_get() retrieves remote_file from the FTP server, and saves it to 
local_file locally. The transfer mode specified must be either FTP_ASCII 
or FTP_BINARY. 
Note: The resumepos parameter was added in PHP 4.3.0. 
Returns TRUE on success or FALSE on failure. 
Example 1. ftp_get() example
  <?php

  // define some variables
  $local_file = 'local.zip';
  $server_file = 'server.zip';

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // try to download $server_file and save to $local_file
  if (ftp_get($conn_id, $local_file, $server_file, FTP_BINARY)) 
{
      echo "Successfully written to $local_file\n";
  } else {
      echo "There was a problem\n";
  }

  // close the connection
  ftp_close($conn_id);

  ?> 
See also ftp_fget(), ftp_nb_get() and ftp_nb_fget().   ftp_get_optionUpftp_login
#

#T=bool ftp_get ( resource ftp_stream, string local_file, string remote_file, 
ftp_get ( ^!resource ftp_stream, string local_file, string remote_file, ;
#

#T=ftp_login - bool ftp_login ( resource ftp_stream, string username, string password)
(PHP 3>= 3.0.13, PHP 4 )
ftp_login -- Logs in to an FTP connection
Description
bool ftp_login ( resource ftp_stream, string username, string password)
Logs in to the given FTP stream. 
Returns TRUE on success or FALSE on failure. 
Example 1. ftp_login() example
  <?php
		       
  $ftp_server = "ftp.example.com";
  $ftp_user = "foo";
  $ftp_pass = "bar";

  // set up a connection or die
  $conn_id = ftp_connect($ftp_server) or die("Couldn't connect 
  to $ftp_server"); 

  // try to login
  if (@ftp_login($conn_id, $ftp_user, $ftp_pass)) {
      echo "Connected as $ftp_user@$ftp_server\n";
  } else {
      echo "Couldn't connect as $ftp_user\n";
  }

  // close the connection
  ftp_close($conn_id);  
  ?> 

  ftp_getUpftp_mdtm
#

#T=bool ftp_login ( resource ftp_stream, string username, string password)
ftp_login ( ^!resource ftp_stream, string username, string password);
#

#T=ftp_mdtm - int ftp_mdtm ( resource ftp_stream, string remote_file)
(PHP 3>= 3.0.13, PHP 4 )
ftp_mdtm -- Returns the last modified time of the given file
Description
int ftp_mdtm ( resource ftp_stream, string remote_file)
ftp_mdtm() checks the last modified time for a file, and returns it as a 
Unix timestamp. If an error occurs, or the file does not exist, -1 is 
returned. 
Returns a Unix timestamp on success, or -1 on error. 
Example 1. ftp_mdtm() example
  <?php

  $file = 'somefile.txt';

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  //  get the last modified time
  $buff = ftp_mdtm($conn_id, $file);

  if ($buff != -1) {
      // somefile.txt was last modified on: March 26 2003 
  14:16:41.
      echo "$file was last modified on : " . date("F d Y 
  H:i:s.", $buff);
  } else {
      echo "Couldn't get mdtime";
  }

  // close the connection
  ftp_close($conn_id);

  ?> 
Note: Not all servers support this feature! 
Note: ftp_mdtm() does not work with directories.   ftp_loginUpftp_mkdir
#

#T=int ftp_mdtm ( resource ftp_stream, string remote_file)
ftp_mdtm ( ^!resource ftp_stream, string remote_file);
#

#T=ftp_mkdir - string ftp_mkdir ( resource ftp_stream, string directory)
(PHP 3>= 3.0.13, PHP 4 )
ftp_mkdir -- Creates a directory
Description
string ftp_mkdir ( resource ftp_stream, string directory)
Creates the specified directory on the FTP server. 
Returns the newly created directory name on success or FALSE on error. 
Example 1. ftp_mkdir() example
  <?php

  $dir = 'www';

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // try to create the directory $dir
  if (ftp_mkdir($conn_id, $dir)) {
  echo "successfully created $dir\n";
  } else {
  echo "There was a problem while creating $dir\n";
  }

  // close the connection
  ftp_close($conn_id);
  ?> 
See also ftp_rmdir().   ftp_mdtmUpftp_nb_continue
#

#T=string ftp_mkdir ( resource ftp_stream, string directory)
ftp_mkdir ( ^!resource ftp_stream, string directory);
#

#T=ftp_nb_continue - int ftp_nb_continue ( resource ftp_stream)
(PHP 4 >= 4.3.0)
ftp_nb_continue -- Continues retrieving/sending a file (non-blocking)
Description
int ftp_nb_continue ( resource ftp_stream)
Continues retrieving/sending a file non-blocking. 
Example 1. ftp_nb_continue() example
  <?php

  // Initate the download
  $ret = ftp_nb_get($my_connection, "test", "README", 
  FTP_BINARY);
  while ($ret == FTP_MOREDATA) {

     // Continue downloading...
     $ret = ftp_nb_continue($my_connection);
  }
  if ($ret != FTP_FINISHED) {
     echo "There was an error downloading the file...";
     exit(1);
  }
  ?> 
Returns FTP_FAILED or FTP_FINISHED or FTP_MOREDATA.   ftp_mkdirUpftp_nb_fget
#

#T=int ftp_nb_continue ( resource ftp_stream)
ftp_nb_continue ( ^!resource ftp_stream);
#

#T=ftp_nb_fget - int ftp_nb_fget ( resource ftp_stream, resource handle, string 
(PHP 4 >= 4.3.0)
ftp_nb_fget -- Retrieves a file from the FTP server and writes it to an 
open file (non-blocking)
Description
int ftp_nb_fget ( resource ftp_stream, resource handle, string 
remote_file, int mode [, int resumepos])
ftp_nb_fget() retrieves remote_file from the FTP server, and writes it to 
the given file pointer, handle. The transfer mode specified must be either 
FTP_ASCII or FTP_BINARY. The difference between this function and the 
ftp_fget() is that this function retrieves the file asynchronously, so 
your program can perform other operations while the file is being 
downloaded. 
Example 1. ftp_nb_fget() example
  <?php

  // open some file for reading
  $file = 'index.php';
  $fp = fopen($file, 'w');

  $conn_id = ftp_connect($ftp_server);

  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // Initate the download
  $ret = ftp_nb_fget($conn_id, $fp, $file, FTP_BINARY);
  while ($ret == FTP_MOREDATA) {

     // Do whatever you want
     echo ".";

     // Continue downloading...
     $ret = ftp_nb_continue($conn_id);
  }
  if ($ret != FTP_FINISHED) {
     echo "There was an error downloading the file...";
     exit(1);
  }

  // close filepointer
  fclose($fp);
  ?> 
Returns FTP_FAILED, FTP_FINISHED, or FTP_MOREDATA. 
See also ftp_nb_get(), ftp_nb_continue(), ftp_fget(), and ftp_get().   ftp_nb_continueUpftp_nb_fput
#

#T=int ftp_nb_fget ( resource ftp_stream, resource handle, string 
ftp_nb_fget ( ^!resource ftp_stream, resource handle, string ;
#

#T=ftp_nb_fput - int ftp_nb_fput ( resource ftp_stream, string remote_file, resource 
(PHP 4 >= 4.3.0)
ftp_nb_fput -- Stores a file from an open file to the FTP server 
(non-blocking)
Description
int ftp_nb_fput ( resource ftp_stream, string remote_file, resource 
handle, int mode [, int startpos])
ftp_nb_fput() uploads the data from the file pointer handle until it 
reaches the end of the file. The results are stored in remote_file on the 
FTP server. The transfer mode specified must be either FTP_ASCII or 
FTP_BINARY. The difference between this function and the ftp_fput() is 
that this function uploads the file asynchronously, so your program can 
perform other operations while the file is being uploaded. 
Example 1. ftp_nb_fput() example
  <?php

  $file = 'index.php';

  $fp = fopen($file, 'r');

  $conn_id = ftp_connect($ftp_server);

  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // Initate the upload
  $ret = ftp_nb_fput($conn_id, $file, $fp, FTP_BINARY);
  while ($ret == FTP_MOREDATA) {

     // Do whatever you want
     echo ".";

     // Continue upload...
     $ret = ftp_nb_continue($conn_id);
  }
  if ($ret != FTP_FINISHED) {
     echo "There was an error uploading the file...";
     exit(1);
  }

  fclose($fp);
  ?> 
Returns FTP_FAILED, FTP_FINISHED, or FTP_MOREDATA. 
See also ftp_nb_put(), ftp_nb_continue(), ftp_put() and ftp_fput().   ftp_nb_fgetUpftp_nb_get
#

#T=int ftp_nb_fput ( resource ftp_stream, string remote_file, resource 
ftp_nb_fput ( ^!resource ftp_stream, string remote_file, resource ;
#

#T=ftp_nb_get - int ftp_nb_get ( resource ftp_stream, string local_file, string 
(PHP 4 >= 4.3.0)
ftp_nb_get -- Retrieves a file from the FTP server and writes it to a 
local file (non-blocking)
Description
int ftp_nb_get ( resource ftp_stream, string local_file, string 
remote_file, int mode [, int resumepos])
ftp_nb_get() retrieves remote_file from the FTP server, and saves it to 
local_file locally. The transfer mode specified must be either FTP_ASCII 
or FTP_BINARY. The difference between this function and the ftp_get() is 
that this function retrieves the file asynchronously, so your program can 
perform other operations while the file is being downloaded. 
Returns FTP_FAILED, FTP_FINISHED, or FTP_MOREDATA. 
Example 1. ftp_nb_get() example
  <?php

  // Initate the download
  $ret = ftp_nb_get($my_connection, "test", "README", 
  FTP_BINARY);
  while ($ret == FTP_MOREDATA) {
     
     // Do whatever you want
     echo ".";

     // Continue downloading...
     $ret = ftp_nb_continue($my_connection);
  }
  if ($ret != FTP_FINISHED) {
     echo "There was an error downloading the file...";
     exit(1);
  }
  ?> 

Example 2. Resuming a download with ftp_nb_get()
  <?php

  // Initate 
  $ret = ftp_nb_get($my_connection, "test", "README", 
  FTP_BINARY, 
			filesize("test"));
  // OR: $ret = ftp_nb_get($my_connection, "test", "README", 
  //                           FTP_BINARY, FTP_AUTORESUME);
  while ($ret == FTP_MOREDATA) {
     
     // Do whatever you want
     echo ".";

     // Continue downloading...
     $ret = ftp_nb_continue($my_connection);
  }
  if ($ret != FTP_FINISHED) {
     echo "There was an error downloading the file...";
     exit(1);
  }
  ?> 

Example 3. Resuming a download at position 100 to a new file with 
ftp_nb_get() 
  <?php

  // Disable Autoseek
  ftp_set_option($my_connection, FTP_AUTOSEEK, false);

  // Initiate
  $ret = ftp_nb_get($my_connection, "newfile", "README", 
  FTP_BINARY, 100);
  while ($ret == FTP_MOREDATA) {

     /* ... */
     
     // Continue downloading...
     $ret = ftp_nb_continue($my_connection);
  }
  ?> 
In the example above, "newfile" is 100 bytes smaller than "README" on the 
FTP server because we started reading at offset 100. If we have not have 
disabled FTP_AUTOSEEK, the first 100 bytes of "newfile" will be '\0'. 
See also ftp_nb_fget(), ftp_nb_continue(), ftp_get(), and ftp_fget().   ftp_nb_fputUpftp_nb_put
#

#T=int ftp_nb_get ( resource ftp_stream, string local_file, string 
ftp_nb_get ( ^!resource ftp_stream, string local_file, string ;
#

#T=ftp_nb_put - int ftp_nb_put ( resource ftp_stream, string remote_file, string 
(PHP 4 >= 4.3.0)
ftp_nb_put -- Stores a file on the FTP server (non-blocking)
Description
int ftp_nb_put ( resource ftp_stream, string remote_file, string 
local_file, int mode [, int startpos])
ftp_nb_put() stores local_file on the FTP server, as remote_file. The 
transfer mode specified must be either FTP_ASCII or FTP_BINARY. The 
difference between this function and the ftp_put() is that this function 
uploads the file asynchronously, so your program can perform other 
operations while the file is being uploaded. 
Returns FTP_FAILED, FTP_FINISHED, or FTP_MOREDATA. 
Example 1. ftp_nb_put() example
  <?php

  // Initiate the Upload
  $ret = ftp_nb_put($my_connection, "test.remote", "test.local", 
  FTP_BINARY);
  while ($ret == FTP_MOREDATA) {
     
     // Do whatever you want
     echo ".";

     // Continue uploading...
     $ret = ftp_nb_continue($my_connection);
  }
  if ($ret != FTP_FINISHED) {
     echo "There was an error uploading the file...";
     exit(1);
  }
  ?> 

Example 2. Resuming an upload with ftp_nb_put()
  <?php

  // Initiate
  $ret = ftp_nb_put($my_connection, "test.remote", "test.local", 

			FTP_BINARY, ftp_size("test.remote"));
  // OR: $ret = ftp_nb_put($my_connection, "test.remote", 
  "test.local", 
  //                           FTP_BINARY, FTP_AUTORESUME);

  while ($ret == FTP_MOREDATA) {
     
     // Do whatever you want
     echo ".";

     // Continue uploading...
     $ret = ftp_nb_continue($my_connection);
  }
  if ($ret != FTP_FINISHED) {
     echo "There was an error uploading the file...";
     exit(1);
  }
  ?> 
See also ftp_nb_fput(), ftp_nb_continue(), ftp_put(), and ftp_fput().   ftp_nb_getUpftp_nlist
#

#T=int ftp_nb_put ( resource ftp_stream, string remote_file, string 
ftp_nb_put ( ^!resource ftp_stream, string remote_file, string ;
#

#T=ftp_nlist - array ftp_nlist ( resource ftp_stream, string directory)
(PHP 3>= 3.0.13, PHP 4 )
ftp_nlist -- Returns a list of files in the given directory
Description
array ftp_nlist ( resource ftp_stream, string directory)
Returns an array of filenames from the specified directory on success or 
FALSE on error. 
Example 1. ftp_nlist() example
  <?php

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // get contents of the current directory
  $contents = ftp_nlist($conn_id, ".");

  // output $contents
  var_dump($contents);

  ?> 

The above example will output something similar to: 
array(3) {
[0]=>
string(11) "public_html"
[1]=>
string(10) "public_ftp"
[2]=>
string(3) "www"
See also ftp_rawlist().   ftp_nb_putUpftp_pasv
#

#T=array ftp_nlist ( resource ftp_stream, string directory)
ftp_nlist ( ^!resource ftp_stream, string directory);
#

#T=ftp_pasv - bool ftp_pasv ( resource ftp_stream, bool pasv)
(PHP 3>= 3.0.13, PHP 4 )
ftp_pasv -- Turns passive mode on or off
Description
bool ftp_pasv ( resource ftp_stream, bool pasv)
ftp_pasv() turns on passive mode if the pasv parameter is TRUE. It turns 
off passive mode if pasv is FALSE. In passive mode, data connections are 
initiated by the client, rather than by the server. 
Example 1. ftp_pasv() example
  <?php
  $file = 'somefile.txt';
  $remote_file = 'readme.txt';

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // turn passive mode on
  ftp_pasv($conn_id, true);

  // upload a file
  if (ftp_put($conn_id, $remote_file, $file, FTP_ASCII)) {
  echo "successfully uploaded $file\n";
  } else {
  echo "There was a problem while uploading $file\n";
  }

  // close the connection
  ftp_close($conn_id);
  ?> 
Returns TRUE on success or FALSE on failure.   ftp_nlistUpftp_put
#

#T=bool ftp_pasv ( resource ftp_stream, bool pasv)
ftp_pasv ( ^!resource ftp_stream, bool pasv);
#

#T=ftp_put - bool ftp_put ( resource ftp_stream, string remote_file, string local_file, 
(PHP 3>= 3.0.13, PHP 4 )
ftp_put -- Uploads a file to the FTP server
Description
bool ftp_put ( resource ftp_stream, string remote_file, string local_file, 
int mode [, int startpos])
ftp_put() stores local_file on the FTP server, as remote_file. The 
transfer mode specified must be either FTP_ASCII or FTP_BINARY. 
Note: The startpos parameter was added in PHP 4.3.0. 
Returns TRUE on success or FALSE on failure. 
Example 1. ftp_put() example
  <?php
  $file = 'somefile.txt';
  $remote_file = 'readme.txt';

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // upload a file
  if (ftp_put($conn_id, $remote_file, $file, FTP_ASCII)) {
  echo "successfully uploaded $file\n";
  } else {
  echo "There was a problem while uploading $file\n";
  }

  // close the connection
  ftp_close($conn_id);
  ?> 
See also ftp_fput(), ftp_nb_fput(), and ftp_nb_put().   ftp_pasvUpftp_pwd
#

#T=bool ftp_put ( resource ftp_stream, string remote_file, string local_file, 
ftp_put ( ^!resource ftp_stream, string remote_file, string local_file, ;
#

#T=ftp_pwd - string ftp_pwd ( resource ftp_stream)
(PHP 3>= 3.0.13, PHP 4 )
ftp_pwd -- Returns the current directory name
Description
string ftp_pwd ( resource ftp_stream)
Returns the current directory or FALSE on error. 
Example 1. ftp_pwd() example
  <?php

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // change directory to public_html
  ftp_chdir($conn_id, 'public_html');

  // print current directory
  echo ftp_pwd($conn_id); // /public_html

  // close the connection
  ftp_close($conn_id);
  ?> 

  ftp_putUpftp_quit
ftp_quit
ftp_quit -- Alias of ftp_close()
Description
This function is an alias of ftp_close().   ftp_pwdUpftp_raw
#

#T=string ftp_pwd ( resource ftp_stream)
ftp_pwd ( ^!resource ftp_stream);
#

#T=ftp_raw - array ftp_raw ( resource ftp_stream, string command)
(PHP 5 CVS only)
ftp_raw -- Sends an arbitrary command to an FTP server
Description
array ftp_raw ( resource ftp_stream, string command)
Sends an arbitrary command to the FTP server. Returns the server's 
response as an array of strings. No parsing is performed on the response 
string, nor does ftp_raw() determine if the command succeeded. 
Example 1. Using ftp_raw() to login to an FTP server manually.
  <?php
  $fp = ftp_connect("ftp.example.com");

  /* This is the same as: 
     ftp_login($fp, "joeblow", "secret"); */
  ftp_raw($fp, "USER joeblow");
  ftp_raw($fp, "PASS secret");
  ?> 
See Also: ftp_exec()   ftp_quitUpftp_rawlist
#

#T=array ftp_raw ( resource ftp_stream, string command)
ftp_raw ( ^!resource ftp_stream, string command);
#

#T=ftp_rawlist - array ftp_rawlist ( resource ftp_stream, string directory)
(PHP 3>= 3.0.13, PHP 4 )
ftp_rawlist -- Returns a detailed list of files in the given directory
Description
array ftp_rawlist ( resource ftp_stream, string directory)
ftp_rawlist() executes the FTP LIST command, and returns the result as an 
array. Each array element corresponds to one line of text. The output is 
not parsed in any way. The system type identifier returned by 
ftp_systype() can be used to determine how the results should be 
interpreted. 
Example 1. ftp_rawlist() example
  <?php

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // get the file list for /
  $buff = ftp_rawlist($conn_id, '/');

  // close the connection
  ftp_close($conn_id);

  // output the buffer
  var_dump($buff);
  ?> 

The above example will output something similar to:     
array(3) {
[0]=>
string(65) "drwxr-x---   3 vincent  vincent      4096 Jul 12 12:16 public_ftp"
[1]=>
string(66) "drwxr-x---  15 vincent  vincent      4096 Nov  3 21:31 public_html"
[2]=>
string(73) "lrwxrwxrwx   1 vincent  vincent        11 Jul 12 12:16 www -> public_html"
}
See also ftp_nlist().   ftp_rawUpftp_rename
#

#T=array ftp_rawlist ( resource ftp_stream, string directory)
ftp_rawlist ( ^!resource ftp_stream, string directory);
#

#T=ftp_rename - bool ftp_rename ( resource ftp_stream, string from, string to)
(PHP 3>= 3.0.13, PHP 4 )
ftp_rename -- Renames a file on the FTP server
Description
bool ftp_rename ( resource ftp_stream, string from, string to)
ftp_rename() renames the file or directory that is currently named from to 
the new name to, using the FTP stream ftp_stream. 
Example 1. ftp_rename() example
  <?php
  $old_file = 'somefile.txt.bak';
  $new_file = 'somefile.txt';

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // try to rename $olf_file to $new_file
  if (ftp_rename($conn_id, $old_file, $new_file)) {
  echo "successfully renamed $old_file to $new_file\n";
  } else {
  echo "There was a problem while renaming $old_file to 
  $new_file\n";
  }

  // close the connection
  ftp_close($conn_id);
  ?> 
Returns TRUE on success or FALSE on failure.   ftp_rawlistUpftp_rmdir
#

#T=bool ftp_rename ( resource ftp_stream, string from, string to)
ftp_rename ( ^!resource ftp_stream, string from, string to);
#

#T=ftp_rmdir - bool ftp_rmdir ( resource ftp_stream, string directory)
(PHP 3>= 3.0.13, PHP 4 )
ftp_rmdir -- Removes a directory
Description
bool ftp_rmdir ( resource ftp_stream, string directory)
Removes the specified directory. directory must be either an absolute or 
relative path to an empty directory. 
Returns TRUE on success or FALSE on failure. 
Example 1. ftp_rmdir() example
  <?php

  $dir = 'www/';

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // try to delete the directory $dir
  if (ftp_rmdir($conn_id, $dir)) {
      echo "Successfully deleted $dir\n";
  } else {
      echo "There was a problem while deleting $dir\n";
  }

  ftp_close($conn_id);

  ?> 
See also ftp_mkdir().   ftp_renameUpftp_set_option
#

#T=bool ftp_rmdir ( resource ftp_stream, string directory)
ftp_rmdir ( ^!resource ftp_stream, string directory);
#

#T=ftp_set_option - bool ftp_set_option ( resource ftp_stream, int option, mixed value)
(PHP 4 >= 4.2.0)
ftp_set_option -- Set miscellaneous runtime FTP options
Description
bool ftp_set_option ( resource ftp_stream, int option, mixed value)
Returns TRUE if the option could be set; FALSE if not. A warning message 
will be thrown if the option is not supported or the passed value doesn't 
match the expected value for the given option. 
This function controls various runtime options for the specified FTP 
stream. The value parameter depends on which option parameter is chosen to 
be altered. Currently, the following options are supported: 
Table 1. Supported runtime FTP options
FTP_TIMEOUT_SECChanges the timeout in seconds used for all network 
related functions. value must be an integer that is greater than 0. 
The default timeout is 90 seconds.
FTP_AUTOSEEKWhen enabled, GET or PUT requests with a resumepos or 
startpos parameter will first seek to the requested position within 
the file. This is enabled by default. 

Example 1. ftp_set_option() example
  <?php
  // Set the network timeout to 10 seconds
  ftp_set_option($conn_id, FTP_TIMEOUT_SEC, 10);
  ?> 
See also ftp_get_option().   ftp_rmdirUpftp_site
#

#T=bool ftp_set_option ( resource ftp_stream, int option, mixed value)
ftp_set_option ( ^!resource ftp_stream, int option, mixed value);
#

#T=ftp_site - bool ftp_site ( resource ftp_stream, string cmd)
(PHP 3>= 3.0.15, PHP 4 )
ftp_site -- Sends a SITE command to the server
Description
bool ftp_site ( resource ftp_stream, string cmd)
ftp_site() sends the command specified by cmd to the FTP server. SITE 
commands are not standardized, and vary from server to server. They are 
useful for handling such things as file permissions and group membership. 
Example 1. Sending a SITE command to an ftp server
  <?php
  /* Connect to FTP server */
  $conn = ftp_connect('ftp.example.com');
  if (!$conn) die('Unable to connect to ftp.example.com');

  /* Login as "user" with password "pass" */
  if (!ftp_login($conn, 'user', 'pass')) die('Error logging into 
  ftp.example.com');

  /* Issue: "SITE CHMOD 0600 /home/user/privatefile" command to 
  ftp server */
  if (ftp_site($conn, 'CHMOD 0600 /home/user/privatefile')) {
     echo "Command executed successfully.\n";
  } else {
     die('Command failed.');
  }
  ?> 
Returns TRUE on success or FALSE on failure. 
See Also: ftp_raw()   ftp_set_optionUpftp_size
#

#T=bool ftp_site ( resource ftp_stream, string cmd)
ftp_site ( ^!resource ftp_stream, string cmd);
#

#T=ftp_size - int ftp_size ( resource ftp_stream, string remote_file)
(PHP 3>= 3.0.13, PHP 4 )
ftp_size -- Returns the size of the given file
Description
int ftp_size ( resource ftp_stream, string remote_file)
ftp_size() returns the size of a remote_file in bytes. If an error occurs, 
or if the given file does not exist, or is a directory, -1 is returned. 
Not all servers support this feature. 
Returns the file size on success, or -1 on error. 
Example 1. ftp_size() example
  <?php

  $file = 'somefile.txt';

  // set up basic connection
  $conn_id = ftp_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  // get the size of $file
  $res = ftp_size($conn_id, $file);

  if ($res != -1) {
      echo "size of $file is $res bytes";
  } else {
      echo "couldn't get the size";
  }

  // close the connection
  ftp_close($conn_id);

  ?> 
See also ftp_rawlist().   ftp_siteUpftp_ssl_connect
#

#T=int ftp_size ( resource ftp_stream, string remote_file)
ftp_size ( ^!resource ftp_stream, string remote_file);
#

#T=ftp_ssl_connect - resource ftp_ssl_connect ( string host [, int port [, int timeout]])
(PHP 4 >= 4.3.0)
ftp_ssl_connect -- Opens an Secure SSL-FTP connection
Description
resource ftp_ssl_connect ( string host [, int port [, int timeout]])
Returns a SSL-FTP stream on success or FALSE on error. 
ftp_ssl_connect() opens a SSL-FTP connection to the specified host. The 
port parameter specifies an alternate port to connect to. If it's omitted 
or set to zero then the default FTP port 21 will be used. 
The timeout parameter specifies the timeout for all subsequent network 
operations. If omitted, the default value is 90 seconds. The timeout can 
be changed and queried at any time with ftp_set_option() and 
ftp_get_option(). 
Example 1. ftp_ssl_connect() example
  <?php

  // set up basic ssl connection
  $conn_id = ftp_ssl_connect($ftp_server);

  // login with username and password
  $login_result = ftp_login($conn_id, $ftp_user_name, 
  $ftp_user_pass);

  echo ftp_pwd($conn_id); // /

  // close the ssl connection
  ftp_close($conn_id);
  ?> 
Why this function may not exist: ftp_ssl_connect() is only available if 
OpenSSL support is enabled into your version of PHP. If it's undefined 
and you've compiled FTP support then this is why. 
See also ftp_connect().   ftp_sizeUpftp_systype
#

#T=resource ftp_ssl_connect ( string host [, int port [, int timeout]])
ftp_ssl_connect ( ^!string host [, int port [, int timeout]]);
#

#T=ftp_systype - string ftp_systype ( resource ftp_stream)
(PHP 3>= 3.0.13, PHP 4 )
ftp_systype -- Returns the system type identifier of the remote FTP server
Description
string ftp_systype ( resource ftp_stream)
Returns the remote system type, or FALSE on error. 
Example 1. ftp_systype() example
  <?php

  // ftp connection
  $ftp = ftp_connect('ftp.example.com');
  ftp_login($ftp, 'user', 'password');

  // get the system type
  if ($type = ftp_systype($ftp)) {
      echo "Example.com is powered by $type\n";
  } else {
      echo "Couldn't get the systype";
  }

  ?> 

The above example will output something similar to: 
Example.com is powered by UNIX

  ftp_ssl_connectUpFunction Handling functions
#

#T=string ftp_systype ( resource ftp_stream)
ftp_systype ( ^!resource ftp_stream);
#

#T=ftruncate - bool ftruncate ( resource handle, int size)
(PHP 4 )
ftruncate -- Truncates a file to a given length
Description
bool ftruncate ( resource handle, int size)
Takes the filepointer, handle, and truncates the file to length, size. 
Returns TRUE on success or FALSE on failure. 
Note: Prior to PHP 4.3.3, ftruncate() returns an integer value of 1 on 
success, instead of boolean TRUE. 
See also fopen() and fseek().   ftellUpfwrite
#

#T=bool ftruncate ( resource handle, int size)
ftruncate ( ^!resource handle, int size);
#

#T=func_get_arg - mixed func_get_arg ( int arg_num)
(PHP 4 )
func_get_arg -- Return an item from the argument list
Description
mixed func_get_arg ( int arg_num)
Returns the argument which is at the arg_num'th offset into a user-defined 
function's argument list. Function arguments are counted starting from 
zero. func_get_arg() will generate a warning if called from outside of a 
function definition. 
If arg_num is greater than the number of arguments actually passed, a 
warning will be generated and func_get_arg() will return FALSE. 
<?php
function foo() {
 $numargs = func_num_args();
 echo "Number of arguments: $numargs<br />\n";
 if ($numargs >= 2) {
 echo "Second argument is: " . func_get_arg(1) . "<br />\n";
 }
} 

foo (1, 2, 3);
?> 

func_get_arg() may be used in conjunction with func_num_args() and 
func_get_args() to allow user-defined functions to accept variable-length 
argument lists. 
Note: This function was added in PHP 4.   create_functionUpfunc_get_args
#

#T=mixed func_get_arg ( int arg_num)
func_get_arg ( ^!int arg_num);
#

#T=func_get_args - array func_get_args ( void )
(PHP 4 )
func_get_args --  Returns an array comprising a function's argument list 
Description
array func_get_args ( void )
Returns an array in which each element is the corresponding member of the 
current user-defined function's argument list. func_get_args() will 
generate a warning if called from outside of a function definition. 
<?php
function foo() {
$numargs = func_num_args();
echo "Number of arguments: $numargs<br />\n";
if ($numargs >= 2) {
    echo "Second argument is: " . func_get_arg(1) . "<br />\n";
}
$arg_list = func_get_args();
for ($i = 0; $i < $numargs; $i++) {
    echo "Argument $i is: " . $arg_list[$i] . "<br />\n";
}
} 

foo(1, 2, 3);
?> 

func_get_args() may be used in conjunction with func_num_args() and 
func_get_arg() to allow user-defined functions to accept variable-length 
argument lists. 
Note: This function was added in PHP 4.   func_get_argUpfunc_num_args
#

#T=array func_get_args ( void )
func_get_args ( ^!void );
#

#T=func_num_args - int func_num_args ( void )
(PHP 4 )
func_num_args --  Returns the number of arguments passed to the function 
Description
int func_num_args ( void )
Returns the number of arguments passed into the current user-defined 
function. func_num_args() will generate a warning if called from outside 
of a user-defined function. 
<?php
function foo() {
$numargs = func_num_args();
echo "Number of arguments: $numargs\n";
} 

foo(1, 2, 3);    // Prints 'Number of arguments: 3'
?> 

func_num_args() may be used in conjunction with func_get_arg() and 
func_get_args() to allow user-defined functions to accept variable-length 
argument lists.   func_get_argsUpfunction_exists
#

#T=int func_num_args ( void )
func_num_args ( ^!void );
#

#T=function_exists - bool function_exists ( string function_name)
(PHP 3>= 3.0.7, PHP 4 )
function_exists --  Return TRUE if the given function has been defined 
Description
bool function_exists ( string function_name)
Checks the list of defined functions, both built-in (internal) and 
user-defined, for function_name. Returns TRUE on success or FALSE on 
failure. 
<?php
if (function_exists('imap_open')) {
echo "IMAP functions are available.<br />\n";
} else {
echo "IMAP functions are not available.<br />\n";
}
?> 

Note that a function name may exist even if the function itself is 
unusable due to configuration or compiling options (with the image 
functions being an example). Also note that function_exists() will return 
FALSE for constructs, such as include_once() and echo(). 
See also method_exists() and get_defined_functions().   func_num_argsUpget_defined_functions
#

#T=bool function_exists ( string function_name)
function_exists ( ^!string function_name);
#

#T=fwrite - int fwrite ( resource handle, string string [, int length])
(PHP 3, PHP 4 )
fwrite -- Binary-safe file write
Description
int fwrite ( resource handle, string string [, int length])
fwrite() writes the contents of string to the file stream pointed to by 
handle. If the length argument is given, writing will stop after length 
bytes have been written or the end of string is reached, whichever comes 
first. 
fwrite() returns the number of bytes written, or FALSE on error. 
Note that if the length argument is given, then the magic_quotes_runtime 
configuration option will be ignored and no slashes will be stripped from 
string. 
Note: On systems which differentiate between binary and text files (i.e. 
Windows) the file must be opened with 'b' included in fopen() mode 
parameter. 
Example 1. A simple fwrite example
  <?php
  $filename = 'test.txt';
  $somecontent = "Add this to the file\n";

  // Let's make sure the file exists and is writable first.
  if (is_writable($filename)) {

      // In our example we're opening $filename in append mode.
      // The file pointer is at the bottom of the file hence 
      // that's where $somecontent will go when we fwrite() it.
      if (!$handle = fopen($filename, 'a')) {
	   echo "Cannot open file ($filename)";
	   exit;
      }

      // Write $somecontent to our opened file.
      if (!fwrite($handle, $somecontent)) {
	  echo "Cannot write to file ($filename)";
	  exit;
      }
      
      echo "Success, wrote ($somecontent) to file ($filename)";
      
      fclose($handle);
		      
  } else {
      echo "The file $filename is not writable";
  }
  ?> 
See also fread(), fopen(), fsockopen(), popen(), and fputs().   ftruncateUpglob
#

#T=int fwrite ( resource handle, string string [, int length])
fwrite ( ^!resource handle, string string [, int length]);
#

#T=gd_info - array gd_info ( void )
(PHP 4 >= 4.3.0)
gd_info -- Retrieve information about the currently installed GD library
Description
array gd_info ( void )
Returns an associative array describing the version and capabilities of 
the installed GD library. 
Table 1. Elements of array returned by gd_info()
AttributeMeaning
GD Versionstring value describing the installed libgd version.
Freetype Supportboolean value. TRUE if Freetype Support is 
installed.
Freetype Linkagestring value describing the way in which Freetype 
was linked. Expected values are: 'with freetype', 'with TTF 
library', and 'with unknown library'. This element will only be 
defined if Freetype Support evaluated to TRUE.
T1Lib Supportboolean value. TRUE if T1Lib support is included.
GIF Read Supportboolean value. TRUE if support for reading GIF 
images is included.
GIF Create Supportboolean value. TRUE if support for creating GIF 
images is included.
JPG Supportboolean value. TRUE if JPG support is included.
PNG Supportboolean value. TRUE if PNG support is included.
WBMP Supportboolean value. TRUE if WBMP support is included.
XBM Supportboolean value. TRUE if XBM support is included.

Example 1. Using gd_info()
  <?php
  var_dump(gd_info());
  ?> 

The typical output is : 
array(9) {
["GD Version"]=>
string(24) "bundled (2.0 compatible)"
["FreeType Support"]=>
bool(false)
["T1Lib Support"]=>
bool(false)
["GIF Read Support"]=>
bool(true)
["GIF Create Support"]=>
bool(false)
["JPG Support"]=>
bool(false)
["PNG Support"]=>
bool(true)
["WBMP Support"]=>
bool(true)
["XBM Support"]=>
bool(false)
}
See also imagepng(), imagejpeg(), imagegif(), imagewbmp(), and 
imagetypes().   exif_thumbnailUpgetimagesize
#

#T=array gd_info ( void )
gd_info ( ^!void );
#

#T=get_browser - object get_browser ( [string user_agent])
(PHP 3, PHP 4 )
get_browser --  Tells what the user's browser is capable of 
Description
object get_browser ( [string user_agent])
get_browser() attempts to determine the capabilities of the user's 
browser. This is done by looking up the browser's information in the 
browscap.ini file. By default, the value of HTTP_USER_AGENT is used; 
however, you can alter this (i.e., look up another browser's info) by 
passing the optional user_agent parameter to get_browser(). 
The information is returned in an object, which will contain various data 
elements representing, for instance, the browser's major and minor version 
numbers and ID string; TRUE/FALSE values for features such as frames, 
JavaScript, and cookies; and so forth. 
While browscap.ini contains information on many browsers, it relies on 
user updates to keep the database current. The format of the file is 
fairly self-explanatory. 
The following example shows how one might list all available information 
retrieved about the user's browser. Example 1. get_browser() example
  <?php
  echo $_SERVER['HTTP_USER_AGENT'] . "<hr />\n";

  $browser = get_browser();

  foreach ($browser as $name => $value) {
      echo "<b>$name</b> $value <br />\n";
  }

  ?> 

The output of the above script would look something like this: 
Mozilla/4.5 [en] (X11; U; Linux 2.2.9 i586)<hr />
<b>browser_name_pattern:</b> Mozilla/4\.5.*<br />
<b>parent:</b> Netscape 4.0<br />
<b>platform:</b> Linux<br />
<b>majorver:</b> 4<br />
<b>minorver:</b> 5<br />
<b>browser:</b> Netscape<br />
<b>version:</b> 4<br />
<b>frames:</b> 1<br />
<b>tables:</b> 1<br />
<b>cookies:</b> 1<br />
<b>backgroundsounds:</b> <br />
<b>vbscript:</b> <br />
<b>javascript:</b> 1<br />
<b>javaapplets:</b> 1<br />
<b>activexcontrols:</b> <br />
<b>beta:</b> <br />
<b>crawler:</b> <br />
<b>authenticodeupdate:</b> <br />
<b>msn:</b> <br />
In order for this to work, your browscap configuration setting in php.ini 
must point to the correct location of the browscap.ini file on your 
system. browscap.ini is not bundled with PHP but you may find an 
up-to-date browscap.ini file here. By default, the browscap directive is 
commented out. 
The cookies value simply means that the browser itself is capable of 
accepting cookies and does not mean the user has enabled the browser to 
accept cookies or not. The only way to test if cookies are accepted is to 
set one with setcookie(), reload, and check for the value. 
Note: On versions older than PHP 4.0.6, you will have to pass the user 
agent in via the optional user_agent parameter if the PHP directive 
register_globals is off. In this case, you will pass in 
$HTTP_SERVER_VARS['HTTP_USER_AGENT'].   exitUphighlight_file
#

#T=object get_browser ( [string user_agent])
get_browser ( ^![string user_agent]);
#

#T=get_cfg_var - string get_cfg_var ( string varname)
(PHP 3, PHP 4 )
get_cfg_var --  Gets the value of a PHP configuration option 
Description
string get_cfg_var ( string varname)
Returns the current value of the PHP configuration variable specified by 
varname, or FALSE if an error occurs. 
It will not return configuration information set when the PHP was 
compiled, or read from an Apache configuration file (using the 
php3_configuration_option directives). 
To check whether the system is using a configuration file, try retrieving 
the value of the cfg_file_path configuration setting. If this is 
available, a configuration file is being used. 
See also ini_get().   extension_loadedUpget_current_user
#

#T=string get_cfg_var ( string varname)
get_cfg_var ( ^!string varname);
#

#T=get_class_methods - array get_class_methods ( mixed class_name)
(PHP 4 )
get_class_methods -- Returns an array of class methods' names
Description
array get_class_methods ( mixed class_name)
This function returns an array of method names defined for the class 
specified by class_name. 
Note: As of PHP 4.0.6, you can specify the object itself instead of 
class_name. For example: 
<?php
$class_methods = get_class_methods($my_class); // see below the 
full example
?> 

Example 1. get_class_methods() example
  <?php

  class myclass {
      // constructor
      function myclass() {
	  return(true);
      }
      
      // method 1
      function myfunc1() {
	  return(true);
      }

      // method 2
      function myfunc2() {
	  return(true);
      }
  }

  $my_object = new myclass();

  $class_methods = get_class_methods(get_class($my_object));

  foreach ($class_methods as $method_name) {
      echo "$method_name\n";
  }

  ?> 

Will produce: 
myclass
myfunc1
myfunc2
See also get_class_vars() and get_object_vars().   class_existsUpget_class_vars
#

#T=array get_class_methods ( mixed class_name)
get_class_methods ( ^!mixed class_name);
#

#T=get_class_vars - array get_class_vars ( string class_name)
(PHP 4 )
get_class_vars --  Returns an array of default properties of the class 
Description
array get_class_vars ( string class_name)
This function will return an associative array of default properties of 
the class. The resulting array elements are in the form of varname => 
value. 
Note: Prior to PHP 4.2.0, Uninitialized class variables will not be 
reported by get_class_vars(). 
Example 1. get_class_vars() example
  <?php

  class myclass {

      var $var1; // this has no default value...
      var $var2 = "xyz";
      var $var3 = 100;
      
      // constructor
      function myclass() {
	  return(true);
      }

  }

  $my_class = new myclass();

  $class_vars = get_class_vars(get_class($my_class));

  foreach ($class_vars as $name => $value) {
      echo "$name : $value\n";
  }

  ?> 

Will produce: 
// Before PHP 4.2.0
var2 : xyz
var3 : 100

// As of PHP 4.2.0
var1 :
var2 : xyz
var3 : 100
See also get_class_methods(), get_object_vars()   get_class_methodsUpget_class
#

#T=array get_class_vars ( string class_name)
get_class_vars ( ^!string class_name);
#

#T=get_class - string get_class ( object obj)
(PHP 4 )
get_class -- Returns the name of the class of an object
Description
string get_class ( object obj)
This function returns the name of the class of which the object obj is an 
instance. Returns FALSE if obj is not an object. 
Note: get_class() returns a user defined class name in lowercase. A 
class defined in a PHP extension is returned in its original notation. 
Example 1. Using get_class()
  <?php

  class foo {
      function foo() {
      // implements some logic
      }

      function name() {
	  echo "My name is " , get_class($this) , "\n";
      }
  }

  // create an object
  $bar = new foo();

  // external call
  echo "Its name is " , get_class($bar) , "\n";

  // internal call
  $bar->name();

  ?> 

The output is: 
Its name is foo
My name is foo
See also get_parent_class(), gettype(), and is_subclass_of().   get_class_varsUpget_declared_classes
#

#T=string get_class ( object obj)
get_class ( ^!object obj);
#

#T=get_current_user - string get_current_user ( void )
(PHP 3, PHP 4 )
get_current_user --  Gets the name of the owner of the current PHP script 
Description
string get_current_user ( void )
Returns the name of the owner of the current PHP script. 
See also getmyuid(), getmygid(), getmypid(), getmyinode(), and 
getlastmod().   get_cfg_varUpget_defined_constants
#

#T=string get_current_user ( void )
get_current_user ( ^!void );
#

#T=get_declared_classes - array get_declared_classes ( void )
(PHP 4 )
get_declared_classes -- Returns an array with the name of the defined 
classes
Description
array get_declared_classes ( void )
This function returns an array of the names of the declared classes in the 
current script. 
Note: In PHP 4.0.1pl2, three extra classes are returned at the beginning 
of the array: stdClass (defined in Zend/zend.c), OverloadedTestClass 
(defined in ext/standard/basic_functions.c) and Directory (defined in 
ext/standard/dir.c). 
Also note that depending on what libraries you have compiled into PHP, 
additional classes could be present. This means that you will not be 
able to define your own classes using these names. There is a list of 
predefined classes in the Predefined Classes section of the appendices. 
See also class_exists().   get_classUpget_object_vars
#

#T=array get_declared_classes ( void )
get_declared_classes ( ^!void );
#

#T=get_defined_constants - array get_defined_constants ( void )
(PHP 4 >= 4.1.0)
get_defined_constants --  Returns an associative array with the names of 
all the constants and their values 
Description
array get_defined_constants ( void )
This function returns the names and values of all the constants currently 
defined. This includes those created by extensions as well as those 
created with the define() function. 
For example the line below: 
<?php
print_r(get_defined_constants());
?> 

will print a list like: 
Array
(
[E_ERROR] => 1
[E_WARNING] => 2
[E_PARSE] => 4
[E_NOTICE] => 8
[E_CORE_ERROR] => 16
[E_CORE_WARNING] => 32
[E_COMPILE_ERROR] => 64
[E_COMPILE_WARNING] => 128
[E_USER_ERROR] => 256
[E_USER_WARNING] => 512
[E_USER_NOTICE] => 1024
[E_ALL] => 2047
[TRUE] => 1
)

See also get_loaded_extensions(), get_defined_functions(), and 
get_defined_vars().   get_current_userUpget_extension_funcs
#

#T=array get_defined_constants ( void )
get_defined_constants ( ^!void );
#

#T=get_defined_functions - array get_defined_functions ( void )
(PHP 4 >= 4.0.4)
get_defined_functions --  Returns an array of all defined functions 
Description
array get_defined_functions ( void )
This function returns an multidimensional array containing a list of all 
defined functions, both built-in (internal) and user-defined. The internal 
functions will be accessible via $arr["internal"], and the user defined 
ones using $arr["user"] (see example below). 
<?php
function myrow($id, $data) {
return "<tr><th>$id</th><td>$data</td></tr>\n";
}

$arr = get_defined_functions();

print_r($arr);
?> 

Will output something along the lines of: 
Array
(
[internal] => Array
(
[0] => zend_version
[1] => func_num_args
[2] => func_get_arg
[3] => func_get_args
[4] => strlen
[5] => strcmp
[6] => strncmp
...
[750] => bcscale
[751] => bccomp
)

[user] => Array
(
[0] => myrow
)

)

See also get_defined_vars() and get_defined_constants().   function_existsUpregister_shutdown_function
#

#T=array get_defined_functions ( void )
get_defined_functions ( ^!void );
#

#T=get_defined_vars - array get_defined_vars ( void )
(PHP 4 >= 4.0.4)
get_defined_vars --  Returns an array of all defined variables 
Description
array get_defined_vars ( void )
This function returns an multidimensional array containing a list of all 
defined variables, be them environment, server or user-defined variables. 
<?php
$b = array(1, 1, 2, 3, 5, 8);

$arr = get_defined_vars();

// print $b
print_r($arr["b"]);

/* print path to the PHP interpreter (if used as a CGI)
* e.g. /usr/local/bin/php */
echo $arr["_"];

// print the command-line paramaters if any
print_r($arr["argv"]);

// print all the server vars
print_r($arr["_SERVER"]);

// print all the available keys for the arrays of variables
print_r(array_keys(get_defined_vars()));
?> 

See also get_defined_functions() and get_defined_constants().   floatvalUpget_resource_type
#

#T=array get_defined_vars ( void )
get_defined_vars ( ^!void );
#

#T=get_extension_funcs - array get_extension_funcs ( string module_name)
(PHP 4 )
get_extension_funcs --  Returns an array with the names of the functions 
of a module 
Description
array get_extension_funcs ( string module_name)
This function returns the names of all the functions defined in the module 
indicated by module_name. 
For example the lines below 
<?php
print_r(get_extension_funcs("xml"));
print_r(get_extension_funcs("gd"));
?> 

will print a list of the functions in the modules xml and gd respectively. 

See also: get_loaded_extensions()   get_defined_constantsUpget_include_path
#

#T=array get_extension_funcs ( string module_name)
get_extension_funcs ( ^!string module_name);
#

#T=get_html_translation_table - array get_html_translation_table ( int table [, int quote_style])
(PHP 4 )
get_html_translation_table --  Returns the translation table used by 
htmlspecialchars() and htmlentities() 
Description
array get_html_translation_table ( int table [, int quote_style])
get_html_translation_table() will return the translation table that is 
used internally for htmlspecialchars() and htmlentities(). 
There are two new constants (HTML_ENTITIES, HTML_SPECIALCHARS) that allow 
you to specify the table you want. And as in the htmlspecialchars() and 
htmlentities() functions you can optionally specify the quote_style you 
are working with. The default is ENT_COMPAT mode. See the description of 
these modes in htmlspecialchars(). 
Example 1. Translation Table Example
  <?php
  $trans = get_html_translation_table(HTML_ENTITIES);
  $str = "Hallo & <Frau> & Krmer";
  $encoded = strtr($str, $trans);
  ?> 

The $encoded variable will now contain: "Hallo &amp; &lt;Frau&gt; &amp; 
Kr&auml;mer". 
Another interesting use of this function is to, with help of array_flip(), 
change the direction of the translation. 
<?php
$trans = array_flip($trans);
$original = strtr($encoded, $trans);
?> 

The content of $original would be: "Hallo & <Frau> & Krmer". 
See also htmlspecialchars(), htmlentities(), strtr(), and array_flip().   fprintfUphebrev
#

#T=array get_html_translation_table ( int table [, int quote_style])
get_html_translation_table ( ^!int table [, int quote_style]);
#

#T=get_include_path - string get_include_path ( void )
(PHP 4 >= 4.3.0)
get_include_path --  Gets the current include_path configuration option 
Description
string get_include_path ( void )
Gets the current include_path configuration option value. 
Example 1. get_include_path() example
  <?php
  // Works as of PHP 4.3.0
  echo get_include_path();

  // Works in all PHP versions
  echo ini_get('include_path');
  ?> 
See also ini_get(), restore_include_path(), set_include_path(), and 
include().   get_extension_funcsUpget_included_files
#

#T=string get_include_path ( void )
get_include_path ( ^!void );
#

#T=get_included_files - array get_included_files ( void )
(PHP 4 )
get_included_files --  Returns an array with the names of included or 
required files 
Description
array get_included_files ( void )
Returns an array of the names of all files that have been included using 
include(), include_once(), require() or require_once(). 
Files that are included or required multiple times only show up once in 
the returned array. 
Note: Files included using the auto_prepend_file configuration directive 
are not included in the returned array. 
Example 1. get_included_files() example
  <?php

  include("test1.php");
  include_once("test2.php");
  require("test3.php");
  require_once("test4.php");

  $included_files = get_included_files();

  foreach ($included_files as $filename) {
      echo "$filename\n";
  }

  ?> 

will generate the following output: 
test1.php
test2.php
test3.php
test4.php
Note: In PHP 4.0.1pl2 and previous versions get_included_files() assumed 
that the required files ended in the extension .php; other extensions 
would not be returned. The array returned by get_included_files() was an 
associative array and only listed files included by include() and 
include_once(). 
See also include(), include_once(), require(), require_once(), and 
get_required_files().   get_include_pathUpget_loaded_extensions
#

#T=array get_included_files ( void )
get_included_files ( ^!void );
#

#T=get_loaded_extensions - array get_loaded_extensions ( void )
(PHP 4 )
get_loaded_extensions --  Returns an array with the names of all modules 
compiled and loaded 
Description
array get_loaded_extensions ( void )
This function returns the names of all the modules compiled and loaded in 
the PHP interpreter. 
For example the line below 
<?php
print_r(get_loaded_extensions());
?> 

will print a list like: 
Array
(
[0] => xml
[1] => wddx
[2] => standard
[3] => session
[4] => posix
[5] => pgsql
[6] => pcre
[7] => gd
[8] => ftp
[9] => db
[10] => calendar
[11] => bcmath
)

See also get_extension_funcs(), extension_loaded(), dl(), and phpinfo().   get_included_filesUpget_magic_quotes_gpc
#

#T=array get_loaded_extensions ( void )
get_loaded_extensions ( ^!void );
#

#T=get_magic_quotes_gpc - int get_magic_quotes_gpc ( void )
(PHP 3>= 3.0.6, PHP 4 )
get_magic_quotes_gpc --  Gets the current active configuration setting of 
magic quotes gpc 
Description
int get_magic_quotes_gpc ( void )
Returns the current active configuration setting of magic_quotes_gpc (0 
for off, 1 for on). 
Note: If the directive magic_quotes_sybase is ON it will completely 
override magic_quotes_gpc. So even when get_magic_quotes() returns TRUE 
neither double quotes, backslashes or NUL's will be escaped. Only single 
quotes will be escaped. In this case they'll look like: '' 
Keep in mind that magic_quotes_gpc can not be set at runtime. 
Example 1. get_magic_quotes_gpc() example
  <?php
  echo get_magic_quotes_gpc();         // 1
  echo $_POST['lastname'];             // O\'reilly
  echo addslashes($_POST['lastname']); // O\\\'reilly

  if (!get_magic_quotes_gpc()) {
      $lastname = addslashes($_POST['lastname']);
  } else {
      $lastname = $_POST['lastname'];
  }

  echo $lastname; // O\'reilly
  $sql = "INSERT INTO lastnames (lastname) VALUES 
('$lastname')";
  ?> 
See also addslashes(), stripslashes(), get_magic_quotes_runtime(), and 
ini_get().   get_loaded_extensionsUpget_magic_quotes_runtime
#

#T=int get_magic_quotes_gpc ( void )
get_magic_quotes_gpc ( ^!void );
#

#T=get_magic_quotes_runtime - int get_magic_quotes_runtime ( void )
(PHP 3>= 3.0.6, PHP 4 )
get_magic_quotes_runtime --  Gets the current active configuration setting 
of magic_quotes_runtime 
Description
int get_magic_quotes_runtime ( void )
Returns the current active configuration setting of magic_quotes_runtime 
(0 for off, 1 for on). 
See also get_magic_quotes_gpc() and set_magic_quotes_runtime().   get_magic_quotes_gpcUpget_required_files
#

#T=int get_magic_quotes_runtime ( void )
get_magic_quotes_runtime ( ^!void );
#

#T=get_meta_tags - array get_meta_tags ( string filename [, int use_include_path])
(PHP 3>= 3.0.4, PHP 4 )
get_meta_tags --  Extracts all meta tag content attributes from a file and 
returns an array 
Description
array get_meta_tags ( string filename [, int use_include_path])
Opens filename and parses it line by line for <meta> tags in the file. 
This can be a local file or an URL. The parsing stops at </head>. 
Setting use_include_path to 1 will result in PHP trying to open the file 
along the standard include path as per the include_path directive. This is 
used for local files, not URLs. 
Example 1. What get_meta_tags() parses
<meta name="author" content="name">
<meta name="keywords" content="php documentation">
<meta name="DESCRIPTION" content="a php manual">
<meta name="geo.position" content="49.33;-86.59">
</head> <!-- parsing stops here -->

(pay attention to line endings - PHP uses a native function to parse the 
input, so a Mac file won't work on Unix). 
The value of the name property becomes the key, the value of the content 
property becomes the value of the returned array, so you can easily use 
standard array functions to traverse it or access single values. Special 
characters in the value of the name property are substituted with '_', the 
rest is converted to lower case. If two meta tags have the same name, only 
the last one is returned. 
Example 2. What get_meta_tags() returns
  <?php
  // Assuming the above tags are at www.example.com
  $tags = get_meta_tags('http://www.example.com/');

  // Notice how the keys are all lowercase now, and
  // how . was replaced by _ in the key.
  echo $tags['author'];       // name
  echo $tags['keywords'];     // php documentation
  echo $tags['description'];  // a php manual
  echo $tags['geo_position']; // 49.33;-86.59
  ?> 
Note: As of PHP 4.0.5, get_meta_tags() supports unquoted HTML 
attributes. 
See also htmlentities() and urlencode().   base64_encodeUphttp_build_query
#

#T=array get_meta_tags ( string filename [, int use_include_path])
get_meta_tags ( ^!string filename [, int use_include_path]);
#

#T=get_object_vars - array get_object_vars ( object obj)
(PHP 4 )
get_object_vars -- Returns an associative array of object properties
Description
array get_object_vars ( object obj)
This function returns an associative array of defined object properties 
for the specified object obj. 
Note: In versions prior to PHP 4.2.0, if the variables declared in the 
class of which the obj is an instance, have not been assigned a value, 
those will not be returned in the array. In versions after PHP 4.2.0, 
the key will be assigned with a NULL value. 
Example 1. Use of get_object_vars()
  <?php
  class Point2D {
      var $x, $y;
      var $label;

      function Point2D($x, $y) {
	  $this->x = $x;
	  $this->y = $y;
      }

      function setLabel($label) {
	  $this->label = $label;
      }

      function getPoint() {
	  return array("x" => $this->x,
		       "y" => $this->y,
		       "label" => $this->label);
      }
  }

  // "$label" is declared but not defined
  $p1 = new Point2D(1.233, 3.445);
  print_r(get_object_vars($p1));

  $p1->setLabel("point #1");
  print_r(get_object_vars($p1));

  ?> 

The printout of the above program will be: 
Array
(
[x] => 1.233
[y] => 3.445
[label] =>
)

Array
(
[x] => 1.233
[y] => 3.445
[label] => point #1
)
See also get_class_methods() and get_class_vars()!   get_declared_classesUpget_parent_class
#

#T=array get_object_vars ( object obj)
get_object_vars ( ^!object obj);
#

#T=get_parent_class - string get_parent_class ( mixed obj)
(PHP 4 )
get_parent_class -- Retrieves the parent class name for object or class
Description
string get_parent_class ( mixed obj)
If obj is an object, returns the name of the parent class of the class of 
which obj is an instance. 
If obj is a string, returns the name of the parent class of the class with 
that name. This functionality was added in PHP 4.0.5. 
Example 1. Using get_parent_class()
  <?php

  class dad {
      function dad() {
      // implements some logic
      }
  }

  class child extends dad {
      function child() {
	  echo "I'm " , get_parent_class($this) , "'s son\n";
      }
  }

  class child2 extends dad {
      function child2() {
	  echo "I'm " , get_parent_class('child2') , "'s son 
  too\n";
      }
  }

  $foo = new child();
  $bar = new child2();

  ?> 

The output is: 
I'm dad's son
I'm dad's son too
See also get_class() and is_subclass_of().   get_object_varsUpis_a
get_required_files
get_required_files -- Alias of get_included_files()
Description
This function is an alias of get_included_files().   get_magic_quotes_runtimeUpgetenv
#

#T=string get_parent_class ( mixed obj)
get_parent_class ( ^!mixed obj);
#

#T=get_resource_type - string get_resource_type ( resource handle)
(PHP 4 >= 4.0.2)
get_resource_type --  Returns the resource type 
Description
string get_resource_type ( resource handle)
This function returns a string representing the type of the resource 
passed to it. If the paramater is not a valid resource, it generates an 
error. 
<?php
// prints: mysql link
$c = mysql_connect();
echo get_resource_type($c) . "\n";

// prints: file
$fp = fopen("foo", "w");
echo get_resource_type($fp) . "\n";

// prints: domxml document
$doc = new_xmldoc("1.0");
echo get_resource_type($doc->doc) . "\n";
?> 
  get_defined_varsUpgettype
#

#T=string get_resource_type ( resource handle)
get_resource_type ( ^!resource handle);
#

#T=getallheaders - array getallheaders ( void )
(PHP 3, PHP 4 )
getallheaders -- Fetch all HTTP request headers
Description
array getallheaders ( void )
getallheaders() is an alias for apache_request_headers(). It will return 
an associative array of all the HTTP headers in the current request. 
Please read the apache_request_headers() documentation for more 
information on how this function works. 
Note: In PHP 4.3.0, getallheaders() became an alias for 
apache_request_headers(). Essentially, it was renamed. This is because 
this function only works when PHP is compiled as an Apache Module. 
Note: From PHP 4.3.3 on you can use this function with the NSAPI server 
module in Netscape/iPlanet/SunONE webservers, too. 
See also apache_request_headers().   ebcdic2asciiUpvirtual
#

#T=array getallheaders ( void )
getallheaders ( ^!void );
#

#T=getcwd - string getcwd ( void )
(PHP 4 )
getcwd -- gets the current working directory
Description
string getcwd ( void )
Returns the current working directory. 
Example 1. getcwd() example
  <?php

  // current directory
  echo getcwd() . "\n";

  chdir('cvs');

  // current directory
  echo getcwd() . "\n";

  ?> 

This example will output: 
/home/didou
/home/didou/cvs
See also chdir().   closedirUpopendir
#

#T=string getcwd ( void )
getcwd ( ^!void );
#

#T=getdate - array getdate ( [int timestamp])
(PHP 3, PHP 4 )
getdate -- Get date/time information
Description
array getdate ( [int timestamp])
Returns an associative array containing the date information of the 
timestamp, or the current local time if no timestamp is given, as the 
following associative array elements: 
Table 1. Key elements of the returned associative array
KeyDescriptionExample returned values
"seconds"Numeric representation of seconds0 to 59
"minutes"Numeric representation of minutes0 to 59
"hours"Numeric representation of hours0 to 23
"mday"Numeric representation of the day of the month1 to 31
"wday"Numeric representation of the day of the week0 (for Sunday) 
through 6 (for Saturday)
"mon"Numeric representation of a month1 through 12
"year"A full numeric representation of a year, 4 digitsExamples: 
1999 or 2003
"yday"Numeric representation of the day of the year0 through 366
"weekday"A full textual representation of the day of the weekSunday 
through Saturday
"month"A full textual representation of a month, such as January or 
MarchJanuary through December
0Seconds since the Unix Epoch, similar to the values returned by 
time() and used by date().System Dependent, typically -2147483648 
through 2147483647.

Example 1. getdate() example 
  <?php
  $today = getdate(); 
  print_r($today);
  ?> 

The output will look similar to: 
Array
(
[seconds] => 40
[minutes] => 58
[hours]   => 21
[mday]    => 17
[wday]    => 2
[mon]     => 6
[year]    => 2003
[yday]    => 167
[weekday] => Tuesday
[month]   => June
[0]       => 1055901520
)
See also date(), time(), and setlocale().   dateUpgettimeofday
#

#T=array getdate ( [int timestamp])
getdate ( ^![int timestamp]);
#

#T=getenv - string getenv ( string varname)
(PHP 3, PHP 4 )
getenv -- Gets the value of an environment variable
Description
string getenv ( string varname)
Returns the value of the environment variable varname, or FALSE on an 
error. 
<?php
$ip = getenv("REMOTE_ADDR"); // get the ip number of the user
?> 

You can see a list of all the environmental variables by using phpinfo(). 
You can find out what many of them mean by taking a look at the CGI 
specification, specifically the page on environmental variables. 
Note: This function does not work in ISAPI mode. 
See also putenv().   get_required_filesUpgetlastmod
#

#T=string getenv ( string varname)
getenv ( ^!string varname);
#

#T=gethostbyaddr - string gethostbyaddr ( string ip_address)
(PHP 3, PHP 4 )
gethostbyaddr --  Get the Internet host name corresponding to a given IP 
address 
Description
string gethostbyaddr ( string ip_address)
Returns the host name of the Internet host specified by ip_address or a 
string containing the unmodified ip_address on failure. 
Example 1. A simple gethostbyaddr() example
  <?php
  $hostname = gethostbyaddr($_SERVER['REMOTE_ADDR']);
    
  echo $hostname;
  ?> 
See also gethostbyname().   fsockopenUpgethostbyname
#

#T=string gethostbyaddr ( string ip_address)
gethostbyaddr ( ^!string ip_address);
#

#T=gethostbyname - string gethostbyname ( string hostname)
(PHP 3, PHP 4 )
gethostbyname --  Get the IP address corresponding to a given Internet 
host name 
Description
string gethostbyname ( string hostname)
Returns the IP address of the Internet host specified by hostname or a 
string containing the unmodified hostname on failure. 
Example 1. A simple gethostbyname() example
  <?php
  $ip = gethostbyname('www.example.com');

  echo $ip;
  ?> 
See also gethostbyaddr().   gethostbyaddrUpgethostbynamel
#

#T=string gethostbyname ( string hostname)
gethostbyname ( ^!string hostname);
#

#T=gethostbynamel - array gethostbynamel ( string hostname)
(PHP 3, PHP 4 )
gethostbynamel --  Get a list of IP addresses corresponding to a given 
Internet host name 
Description
array gethostbynamel ( string hostname)
Returns a list of IP addresses to which the Internet host specified by 
hostname resolves. 
Example 1. gethostbynamel() example
  <?php
    $hosts = gethostbynamel('www.example.com');
    print_r($hosts);
  ?> 

The printout of the above program will be: Array
(
[0] => 192.0.34.166
)
See also gethostbyname(), gethostbyaddr(), checkdnsrr(), getmxrr(), and 
the named(8) manual page.   gethostbynameUpgetmxrr
#

#T=array gethostbynamel ( string hostname)
gethostbynamel ( ^!string hostname);
#

#T=getimagesize - array getimagesize ( string filename [, array imageinfo])
(PHP 3, PHP 4 )
getimagesize -- Get the size of an image
Description
array getimagesize ( string filename [, array imageinfo])
The getimagesize() function will determine the size of any GIF, JPG, PNG, 
SWF, SWC, PSD, TIFF, BMP, IFF, JP2, JPX, JB2, JPC, XBM, or WBMP image file 
and return the dimensions along with the file type and a height/width text 
string to be used inside a normal HTML IMG tag. 
Note: Support for JPC, JP2, JPX, JB2, XBM, and WBMP became available in 
PHP 4.3.2. Support for SWC as of PHP 4.3.0. 
Returns an array with 4 elements. Index 0 contains the width of the image 
in pixels. Index 1 contains the height. Index 2 is a flag indicating the 
type of the image: 1 = GIF, 2 = JPG, 3 = PNG, 4 = SWF, 5 = PSD, 6 = BMP, 7 
= TIFF(intel byte order), 8 = TIFF(motorola byte order), 9 = JPC, 10 = 
JP2, 11 = JPX, 12 = JB2, 13 = SWC, 14 = IFF, 15 = WBMP, 16 = XBM. These 
values correspond to the IMAGETYPE constants that were added in PHP 4.3. 
Index 3 is a text string with the correct height="yyy" width="xxx" string 
that can be used directly in an IMG tag. Example 1. getimagesize 
(file)
  <?php
  list($width, $height, $type, $attr) = 
  getimagesize("img/flag.jpg");
  echo "<img src=\"img/flag.jpg\" $attr alt=\"getimagesize() 
  example\" />";
  ?> 
Example 2. getimagesize (URL)
  <?php 
  $size = getimagesize("http://www.example.com/gifs/logo.gif");

  // if the file name has space in it, encode it properly
  $size = 
  getimagesize("http://www.example.com/gifs/lo%20go.gif");

  ?> 
With JPG images, two extra indexes are returned: channels and bits. 
channels will be 3 for RGB pictures and 4 for CMYK pictures. bits is the 
number of bits for each color. 
Beginning with PHP 4.3, bits and channels are present for other image 
types, too. However, the presence of these values can be a bit confusing. 
As an example, GIF always uses 3 channels per pixel, but the number of 
bits per pixel cannot be calculated for an animated GIF with a global 
color table. 
Some formats may contain no image or may contain multiple images. In these 
cases, getimagesize() might not be able to properly determine the image 
size. getimagesize() will return zero for width and height in these cases. 

Beginning with PHP 4.3, getimagesize() also returns an additional 
parameter, mime, that corresponds with the MIME type of the image. This 
information can be used to deliver images with correct HTTP Content-type 
headers: Example 3. getimagesize() and MIME types
  <?php
  $size = getimagesize($filename);
  $fp=fopen($filename, "rb");
  if ($size && $fp) {
    header("Content-type: {$size['mime']}");
    fpassthru($fp);
    exit;
  } else {
    // error
  }
  ?> 
If accessing the filename image is impossible, or if it isn't a valid 
picture, getimagesize() will return FALSE and generate a warning. 
The optional imageinfo parameter allows you to extract some extended 
information from the image file. Currently, this will return the different 
JPG APP markers as an associative array. Some programs use these APP 
markers to embed text information in images. A very common one is to embed 
IPTC http://www.iptc.org/ information in the APP13 marker. You can use the 
iptcparse() function to parse the binary APP13 marker into something 
readable. Example 4. getimagesize() returning IPTC
  <?php
  $size = getimagesize("testimg.jpg", $info);
  if (isset($info["APP13"])) {
      $iptc = iptcparse($info["APP13"]);
      var_dump($iptc);
  }
  ?> 
Note: JPEG 2000 support was added in PHP 4.3.2. Note that JPC and JP2 
are capable of having components with different bit depths. In this 
case, the value for "bits" is the highest bit depth encountered. Also, 
JP2 files may contain multiple JPEG 2000 codestreams. In this case, 
getimagesize() returns the values for the first codestream it encounters 
in the root of the file. 
Note: TIFF support was added in PHP 4.2. 
This function does not require the GD image library. 
See also image_type_to_mime_type(), exif_imagetype(), exif_read_data() 
and exif_thumbnail(). 
URL support was added in PHP 4.0.5.   gd_infoUpimage_type_to_mime_type
#

#T=array getimagesize ( string filename [, array imageinfo])
getimagesize ( ^!string filename [, array imageinfo]);
#

#T=getlastmod - int getlastmod ( void )
(PHP 3, PHP 4 )
getlastmod -- Gets time of last page modification
Description
int getlastmod ( void )
Returns the time of the last modification of the current page. The value 
returned is a Unix timestamp, suitable for feeding to date(). Returns 
FALSE on error. 
Example 1. getlastmod() example
  <?php
  // outputs e.g. 'Last modified: March 04 1998 20:43:59.'
  echo "Last modified: " . date ("F d Y H:i:s.", getlastmod());
  ?> 
Note: If you're interested in getting the last modification time of a 
different file, consider using filemtime(). 
See also date(), getmyuid(), getmygid(), get_current_user(), getmyinode(), 
getmypid(), and filemtime().   getenvUpgetmygid
#

#T=int getlastmod ( void )
getlastmod ( ^!void );
#

#T=getmxrr - int getmxrr ( string hostname, array mxhosts [, array weight])
(PHP 3, PHP 4 )
getmxrr --  Get MX records corresponding to a given Internet host name 
Description
int getmxrr ( string hostname, array mxhosts [, array weight])
Searches DNS for MX records corresponding to hostname. Returns TRUE if any 
records are found; returns FALSE if no records were found or if an error 
occurred. 
A list of the MX records found is placed into the array mxhosts. If the 
weight array is given, it will be filled with the weight information 
gathered. 
Note: This function should not be used for the purposes of address 
verification. Only the mailexchangers found in DNS are returned, 
however, according to RFC 2821 when no mail exchangers are listed, 
hostname itself should be used as the only mail exchanger with a 
priority of 0. 
Note: This function is not implemented on Windows platforms. Try the 
PEAR class Net_DNS. 
See also checkdnsrr(), gethostbyname(), gethostbynamel(), gethostbyaddr(), 
and the named(8) manual page.   gethostbynamelUpgetprotobyname
#

#T=int getmxrr ( string hostname, array mxhosts [, array weight])
getmxrr ( ^!string hostname, array mxhosts [, array weight]);
#

#T=getmygid - int getmygid ( void )
(PHP 4 >= 4.1.0)
getmygid -- Get PHP script owner's GID
Description
int getmygid ( void )
Returns the group ID of the current script, or FALSE on error. 
See also getmyuid(), getmypid(), get_current_user(), getmyinode(), and 
getlastmod().   getlastmodUpgetmyinode
#

#T=int getmygid ( void )
getmygid ( ^!void );
#

#T=getmyinode - int getmyinode ( void )
(PHP 3, PHP 4 )
getmyinode -- Gets the inode of the current script
Description
int getmyinode ( void )
Returns the current script's inode, or FALSE on error. 
See also getmygid(), getmyuid(), get_current_user(), getmypid(), and 
getlastmod(). 
Note: This function is not implemented on Windows platforms.  getmygidUpgetmypid
#

#T=int getmyinode ( void )
getmyinode ( ^!void );
#

#T=getmypid - int getmypid ( void )
(PHP 3, PHP 4 )
getmypid -- Gets PHP's process ID
Description
int getmypid ( void )
Returns the current PHP process ID, or FALSE on error. 
Warning
Process IDs are not unique, thus they are a weak entropy source. We 
recommend against relying on pids in security-dependent contexts. 

See also getmygid(), getmyuid(), get_current_user(), getmyinode(), and 
getlastmod().   getmyinodeUpgetmyuid
#

#T=int getmypid ( void )
getmypid ( ^!void );
#

#T=getmyuid - int getmyuid ( void )
(PHP 3, PHP 4 )
getmyuid -- Gets PHP script owner's UID
Description
int getmyuid ( void )
Returns the user ID of the current script, or FALSE on error. 
See also getmygid(), getmypid(), get_current_user(), getmyinode(), and 
getlastmod().   getmypidUpgetopt
#

#T=int getmyuid ( void )
getmyuid ( ^!void );
#

#T=getopt - array getopt ( string options)
(PHP 4 >= 4.3.0)
getopt -- Gets options from the command line argument list
Description
array getopt ( string options)
Returns an associative array of option / argument pairs based on the 
options format specified in options, or FALSE on an error. 
<?php
// parse the command line ($GLOBALS['argv'])
$options = getopt("f:hp:");
?> 

The options parameter may contain the following elements: individual 
characters, and characters followed by a colon to indicate an option 
argument is to follow. For example, an option string x recognizes an 
option -x, and an option string x: recognizes an option and argument -x 
argument. It does not matter if an argument has leading white space. 
This function will return an array of option / argument pairs. If an 
option does not have an argument, the value will be set to FALSE. 
Note: This function is not implemented on Windows platforms.  getmyuidUpgetrusage
#

#T=array getopt ( string options)
getopt ( ^!string options);
#

#T=getprotobyname - int getprotobyname ( string name)
(PHP 4 )
getprotobyname --  Get protocol number associated with protocol name 
Description
int getprotobyname ( string name)
getprotobyname() returns the protocol number associated with the protocol 
name as per /etc/protocols. 
Example 1. getprotobyname() example
  <?php
  $protocol = 'tcp';
  $get_prot = getprotobyname($protocol);
  if ($get_prot == -1) {
      // if nothing found, returns -1
      echo 'Invalid Protocol';
  } else {
      echo 'Protocol #' . $get_prot;
  }
  ?> 
See also: getprotobynumber().   getmxrrUpgetprotobynumber
#

#T=int getprotobyname ( string name)
getprotobyname ( ^!string name);
#

#T=getprotobynumber - string getprotobynumber ( int number)
(PHP 4 )
getprotobynumber --  Get protocol name associated with protocol number 
Description
string getprotobynumber ( int number)
getprotobynumber() returns the protocol name associated with protocol 
number as per /etc/protocols. 
See also: getprotobyname().   getprotobynameUpgetservbyname
#

#T=string getprotobynumber ( int number)
getprotobynumber ( ^!int number);
#

#T=getrandmax - int getrandmax ( void )
(PHP 3, PHP 4 )
getrandmax -- Show largest possible random value
Description
int getrandmax ( void )
Returns the maximum value that can be returned by a call to rand(). 
See also rand(), srand() and mt_getrandmax().   fmodUphexdec
#

#T=int getrandmax ( void )
getrandmax ( ^!void );
#

#T=getrusage - array getrusage ( [int who])
(PHP 3>= 3.0.7, PHP 4 )
getrusage -- Gets the current resource usages
Description
array getrusage ( [int who])
This is an interface to getrusage(2). It returns an associative array 
containing the data returned from the system call. If who is 1, getrusage 
will be called with RUSAGE_CHILDREN. 
All entries are accessible by using their documented field names. 
Example 1. getrusage() example
  <?php
  $dat = getrusage();
  echo $dat["ru_nswap"];         // number of swaps
  echo $dat["ru_majflt"];        // number of page faults
  echo $dat["ru_utime.tv_sec"];  // user time used (seconds)
  echo $dat["ru_utime.tv_usec"]; // user time used 
(microseconds)
  ?> 

See your system's man page on getrusage(2) for more details. 
Note: This function is not implemented on Windows platforms.  getoptUpini_alter
#

#T=array getrusage ( [int who])
getrusage ( ^![int who]);
#

#T=getservbyname - int getservbyname ( string service, string protocol)
(PHP 4 )
getservbyname --  Get port number associated with an Internet service and 
protocol 
Description
int getservbyname ( string service, string protocol)
getservbyname() returns the Internet port which corresponds to service for 
the specified protocol as per /etc/services. protocol is either "tcp" or 
"udp" (in lowercase). 
Example 1. getservbyname() example
  <?php
  $services = array('http', 'ftp', 'ssh', 'telnet', 'imap', 
  'smtp', 'nicname', 'gopher', 'finger', 'pop3', 'www');

  foreach ($services as $service) {                    
      $port = getservbyname($service, 'tcp');
      echo $service . ": " . $port . "<br />\n";
  }
  ?> 
For complete list of port numbers see: 
http://www.iana.org/assignments/port-numbers. 
See also: getservbyport().   getprotobynumberUpgetservbyport
#

#T=int getservbyname ( string service, string protocol)
getservbyname ( ^!string service, string protocol);
#

#T=getservbyport - string getservbyport ( int port, string protocol)
(PHP 4 )
getservbyport --  Get Internet service which corresponds to port and 
protocol 
Description
string getservbyport ( int port, string protocol)
getservbyport() returns the Internet service associated with port for the 
specified protocol as per /etc/services. protocol is either "tcp" or "udp" 
(in lowercase). 
See also: getservbyname().   getservbynameUpip2long
#

#T=string getservbyport ( int port, string protocol)
getservbyport ( ^!int port, string protocol);
#

#T=gettext - string gettext ( string message)
(PHP 3>= 3.0.7, PHP 4 )
gettext -- Lookup a message in the current domain
Description
string gettext ( string message)
This function returns a translated string if one is found in the 
translation table, or the submitted message if not found. You may use the 
underscore character '_' as an alias to this function. 
Example 1. gettext()-check
  <?php
  // Set language to German
  setlocale(LC_ALL, 'de');

  // Specify location of translation tables
  bindtextdomain("myPHPApp", "./locale");

  // Choose domain
  textdomain("myPHPApp");

  // Print a test message
  echo gettext("Welcome to My PHP Application");

  // Or use the alias _() for gettext()
  echo _("Have a nice day");
  ?> 

  dngettextUpngettext
#

#T=string gettext ( string message)
gettext ( ^!string message);
#

#T=gettimeofday - array gettimeofday ( void )
(PHP 3>= 3.0.7, PHP 4 )
gettimeofday -- Get current time
Description
array gettimeofday ( void )
This is an interface to gettimeofday(2). It returns an associative array 
containing the data returned from the system call. 
"sec" - seconds 
"usec" - microseconds 
"minuteswest" - minutes west of Greenwich 
"dsttime" - type of dst correction   getdateUpgmdate
#

#T=array gettimeofday ( void )
gettimeofday ( ^!void );
#

#T=gettype - string gettype ( mixed var)
(PHP 3, PHP 4 )
gettype -- Get the type of a variable
Description
string gettype ( mixed var)
Returns the type of the PHP variable var. 
Warning
Never use gettype() to test for a certain type, since the returned 
string may be subject to change in a future version. In addition, it 
is slow too, as it involves string comparison. 
Instead, use the is_* functions. 

Possibles values for the returned string are: 
"boolean" (since PHP 4)
"integer"
"double" (for historical reasons "double" is returned in case of a 
float, and not simply "float")
"string"
"array"
"object"
"resource" (since PHP 4)
#

#T=string gettype ( mixed var)
gettype ( ^!mixed var);
#
"NULL" (since PH
#T=P 4) - array glob ( string pattern [, int flags])
"user function" (PHP 3 only, deprecated)
"unknown type"
For PHP 4, you should use function_exists() and method_exists() to replace 
the prior usage of gettype() on a function. 
See also settype(), is_array(), is_bool(), is_float(), is_integer(), 
is_null(), is_numeric(), is_object(), is_resource(), is_scalar(), and 
is_string().   get_resource_typeUpimport_request_variables
#

#T=glob - array glob ( string pattern [, int flags])
(PHP 4 >= 4.3.0)
glob -- Find pathnames matching a pattern
Description
array glob ( string pattern [, int flags])
The glob() function searches for all the pathnames matching pattern 
according to the rules used by the shell. No tilde expansion or parameter 
substitution is done. 
Returns an array containing the matched files/directories or FALSE on 
error. 
Valid flags: 
GLOB_MARK - Adds a slash to each item returned 
GLOB_NOSORT - Return files as they appear in the directory (no sorting) 
GLOB_NOCHECK - Return the search pattern if no files matching it were 
found 
GLOB_NOESCAPE - Backslashes do not quote metacharacters 
GLOB_BRACE - Expands {a,b,c} to match 'a', 'b', or 'c' 
GLOB_ONLYDIR - Return only directory entries which match the pattern 
Note: Before PHP 4.3.3 GLOB_ONLYDIR was not available on Windows and 
other systems not using the GNU C library. 
Example 1. Convenient way how glob() can replace opendir() and 
friends. 
  <?php
  foreach (glob("*.txt") as $filename) {
      echo "$filename size " . filesize($filename) . "\n";
  } 

Output will look something like: 
funclist.txt size 44686
funcsummary.txt size 267625
quickref.txt size 137820
Note: This function will not work on remote files as the file to be 
examined must be accessible via the servers filesystem.
See also opendir(), readdir(), closedir(), and fnmatch().   fwriteUpis_dir
#

#T=array glob ( string pattern [, int flags])
glob ( ^!string pattern [, int flags]);
#

#T=gmdate - string gmdate ( string format [, int timestamp])
(PHP 3, PHP 4 )
gmdate -- Format a GMT/UTC date/time
Description
string gmdate ( string format [, int timestamp])
Identical to the date() function except that the time returned is 
Greenwich Mean Time (GMT). For example, when run in Finland (GMT +0200), 
the first line below prints "Jan 01 1998 00:00:00", while the second 
prints "Dec 31 1997 22:00:00". Example 1. gmdate() example
  <?php
  echo date("M d Y H:i:s", mktime(0, 0, 0, 1, 1, 1998));
  echo gmdate("M d Y H:i:s", mktime(0, 0, 0, 1, 1, 1998));
  ?> 
Note: In the Microsoft Windows series of Operating Systems the system 
libraries implementing this function are broken, so gmdate() does not 
support negative values for the timestamp. For details see bug reports: 
#22620, #22457, and #14391. 
This problem does not occur in Unix/Linux Operating Systems, as the 
system libraries behave as expected. 
PHP cannot fix broken system libraries. Contact your OS vendor for a fix 
to this and similar problems. 
See also date(), mktime(), gmmktime() and strftime().   gettimeofdayUpgmmktime
#

#T=string gmdate ( string format [, int timestamp])
gmdate ( ^!string format [, int timestamp]);
#

#T=gmmktime - int gmmktime ( [int hour [, int minute [, int second [, int month [, int 
(PHP 3, PHP 4 )
gmmktime -- Get Unix timestamp for a GMT date
Description
int gmmktime ( [int hour [, int minute [, int second [, int month [, int 
day [, int year [, int is_dst]]]]]]])
Identical to mktime() except the passed parameters represents a GMT date. 
Like mktime(), arguments may be left out in order from right to left, with 
any omitted arguments being set to the current corresponding GMT value.   gmdateUpgmstrftime
#

#T=int gmmktime ( [int hour [, int minute [, int second [, int month [, int 
gmmktime ( ^![int hour [, int minute [, int second [, int month [, int ;
#

#T=gmp_abs - resource gmp_abs ( resource a)
(PHP 4 >= 4.0.4)
gmp_abs -- Absolute value
Description
resource gmp_abs ( resource a)
Returns absolute value of a.   GMP functionsUpgmp_add
#

#T=resource gmp_abs ( resource a)
gmp_abs ( ^!resource a);
#

#T=gmp_add - resource gmp_add ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_add -- Add numbers
Description
resource gmp_add ( resource a, resource b)
Add two GMP numbers. The result will be a GMP number representing the sum 
of the arguments.   gmp_absUpgmp_and
#

#T=resource gmp_add ( resource a, resource b)
gmp_add ( ^!resource a, resource b);
#

#T=gmp_and - resource gmp_and ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_and -- Logical AND
Description
resource gmp_and ( resource a, resource b)
Calculates logical AND of two GMP numbers.   gmp_addUpgmp_clrbit
#

#T=resource gmp_and ( resource a, resource b)
gmp_and ( ^!resource a, resource b);
#

#T=gmp_clrbit - resource gmp_clrbit ( resource &a, int index)
(PHP 4 >= 4.0.4)
gmp_clrbit -- Clear bit
Description
resource gmp_clrbit ( resource &a, int index)
Clears (sets to 0) bit index in a.   gmp_andUpgmp_cmp
#

#T=resource gmp_clrbit ( resource &a, int index)
gmp_clrbit ( ^!resource &a, int index);
#

#T=gmp_cmp - int gmp_cmp ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_cmp -- Compare numbers
Description
int gmp_cmp ( resource a, resource b)
Returns a positive value if a > b, zero if a = b and negative value if a < 
b.   gmp_clrbitUpgmp_com
#

#T=int gmp_cmp ( resource a, resource b)
gmp_cmp ( ^!resource a, resource b);
#

#T=gmp_com - resource gmp_com ( resource a)
(PHP 4 >= 4.0.4)
gmp_com -- Calculates one's complement of a
Description
resource gmp_com ( resource a)
Warning
This function is currently not documented; only the argument list is 
available.
  gmp_cmpUpgmp_div_q
#

#T=resource gmp_com ( resource a)
gmp_com ( ^!resource a);
#

#T=gmp_div_q - resource gmp_div_q ( resource a, resource b [, int round])
(PHP 4 >= 4.0.4)
gmp_div_q -- Divide numbers
Description
resource gmp_div_q ( resource a, resource b [, int round])
Divides a by b and returns the integer result. The result rounding is 
defined by the round, which can have the following values: 
GMP_ROUND_ZERO: The result is truncated towards 0. 
GMP_ROUND_PLUSINF: The result is rounded towards +infinity. 
GMP_ROUND_MINUSINF: The result is rounded towards -infinity. 
This function can also be called as gmp_div(). 
See also gmp_div_r(), gmp_div_qr()   gmp_comUpgmp_div_qr
#

#T=resource gmp_div_q ( resource a, resource b [, int round])
gmp_div_q ( ^!resource a, resource b [, int round]);
#

#T=gmp_div_qr - array gmp_div_qr ( resource n, resource d [, int round])
(PHP 4 >= 4.0.4)
gmp_div_qr -- Divide numbers and get quotient and remainder
Description
array gmp_div_qr ( resource n, resource d [, int round])
The function divides n by d and returns array, with the first element 
being [n/d] (the integer result of the division) and the second being (n - 
[n/d] * d) (the remainder of the division). 
See the gmp_div_q() function for description of the round argument. 
Example 1. Division of GMP numbers
  <?php
      $a = gmp_init("0x41682179fbf5");
      $res = gmp_div_qr($a, "0xDEFE75");
      printf("Result is: q - %s, r - %s", 
	      gmp_strval($res[0]), gmp_strval($res[1]));
  ?> 
See also gmp_div_q(), gmp_div_r().   gmp_div_qUpgmp_div_r
#

#T=array gmp_div_qr ( resource n, resource d [, int round])
gmp_div_qr ( ^!resource n, resource d [, int round]);
#

#T=gmp_div_r - resource gmp_div_r ( resource n, resource d [, int round])
(PHP 4 >= 4.0.4)
gmp_div_r -- Remainder of the division of numbers
Description
resource gmp_div_r ( resource n, resource d [, int round])
Calculates remainder of the integer division of n by d. The remainder has 
the sign of the n argument, if not zero. 
See the gmp_div_q() function for description of the round argument. 
See also gmp_div_q(), gmp_div_qr()   gmp_div_qrUpgmp_div
gmp_div
gmp_div -- Alias of gmp_div_q()
Description
This function is an alias of gmp_div_q().   gmp_div_rUpgmp_divexact
#

#T=resource gmp_div_r ( resource n, resource d [, int round])
gmp_div_r ( ^!resource n, resource d [, int round]);
#

#T=gmp_divexact - resource gmp_divexact ( resource n, resource d)
(PHP 4 >= 4.0.4)
gmp_divexact -- Exact division of numbers
Description
resource gmp_divexact ( resource n, resource d)
Divides n by d, using fast "exact division" algorithm. This function 
produces correct results only when it is known in advance that d divides 
n.   gmp_divUpgmp_fact
#

#T=resource gmp_divexact ( resource n, resource d)
gmp_divexact ( ^!resource n, resource d);
#

#T=gmp_fact - resource gmp_fact ( int a)
(PHP 4 >= 4.0.4)
gmp_fact -- Factorial
Description
resource gmp_fact ( int a)
Calculates factorial (a!) of a.   gmp_divexactUpgmp_gcd
#

#T=resource gmp_fact ( int a)
gmp_fact ( ^!int a);
#

#T=gmp_gcd - resource gmp_gcd ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_gcd -- Calculate GCD
Description
resource gmp_gcd ( resource a, resource b)
Calculate greatest common divisor of a and b. The result is always 
positive even if either of, or both, input operands are negative.   gmp_factUpgmp_gcdext
#

#T=resource gmp_gcd ( resource a, resource b)
gmp_gcd ( ^!resource a, resource b);
#

#T=gmp_gcdext - array gmp_gcdext ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_gcdext -- Calculate GCD and multipliers
Description
array gmp_gcdext ( resource a, resource b)
Calculates g, s, and t, such that a*s + b*t = g = gcd(a,b), where gcd is 
the greatest common divisor. Returns an array with respective elements g, 
s and t. 
This function can be used to solve linear Diophantine equations in two 
variables. These are equations that allow only integer solutions and have 
the form: a*x + b*y = c. For more information, go to the "Diophantine 
Equation" page at MathWorld 
Example 1. Solving a linear Diophantine equation
  <?php
  // Solve the equation a*s + b*t = g
  // where a = 12, b = 21, g = gcd(12, 21) = 3
  $a = gmp_init(12);
  $b = gmp_init(21);
  $g = gmp_gcd($a, $b);
  $r = gmp_gcdext($a, $b);

  $check_gcd = (gmp_strval($g) == gmp_strval($r['g']));
  $eq_res = gmp_add(gmp_mul($a, $r['s']), gmp_mul($b, $r['t']));
  $check_res = (gmp_strval($g) == gmp_strval($eq_res));

  if ($check_gcd && $check_res) {
      $fmt = "Solution: %d*%d + %d*%d = %d\n";
      printf($fmt, gmp_strval($a), gmp_strval($r['s']), 
  gmp_strval($b),
      gmp_strval($r['t']), gmp_strval($r['g']));
  } else {
      echo "Error while solving the equation\n";
  }
      
  // output: Solution: 12*2 + 21*-1 = 3
  ?> 

  gmp_gcdUpgmp_hamdist
#

#T=array gmp_gcdext ( resource a, resource b)
gmp_gcdext ( ^!resource a, resource b);
#

#T=gmp_hamdist - int gmp_hamdist ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_hamdist -- Hamming distance
Description
int gmp_hamdist ( resource a, resource b)
Returns the hamming distance between a and b. Both operands should be 
non-negative.   gmp_gcdextUpgmp_init
#

#T=int gmp_hamdist ( resource a, resource b)
gmp_hamdist ( ^!resource a, resource b);
#

#T=gmp_init - resource gmp_init ( mixed number)
(PHP 4 >= 4.0.4)
gmp_init -- Create GMP number
Description
resource gmp_init ( mixed number)
Creates a GMP number from an integer or string. String representation can 
be decimal or hexadecimal. In the latter case, the string should start 
with 0x. 
Example 1. Creating GMP number
  <?php
      $a = gmp_init(123456);
      $b = gmp_init("0xFFFFDEBACDFEDF7200");
  ?> 
Note: It is not necessary to call this function if you want to use 
integer or string in place of GMP number in GMP functions, like 
gmp_add(). Function arguments are automatically converted to GMP 
numbers, if such conversion is possible and needed, using the same rules 
as gmp_init().   gmp_hamdistUpgmp_intval
#

#T=resource gmp_init ( mixed number)
gmp_init ( ^!mixed number);
#

#T=gmp_intval - int gmp_intval ( resource gmpnumber)
(PHP 4 >= 4.0.4)
gmp_intval -- Convert GMP number to integer
Description
int gmp_intval ( resource gmpnumber)
This function allows to convert GMP number to integer. 
Warning
This function returns a useful result only if the number actually 
fits the PHP integer (i.e., signed long type). If you want just to 
print the GMP number, use gmp_strval(). 
  gmp_initUpgmp_invert
#

#T=int gmp_intval ( resource gmpnumber)
gmp_intval ( ^!resource gmpnumber);
#

#T=gmp_invert - resource gmp_invert ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_invert -- Inverse by modulo
Description
resource gmp_invert ( resource a, resource b)
Computes the inverse of a modulo b. Returns FALSE if an inverse does not 
exist.   gmp_intvalUpgmp_jacobi
#

#T=resource gmp_invert ( resource a, resource b)
gmp_invert ( ^!resource a, resource b);
#

#T=gmp_jacobi - int gmp_jacobi ( resource a, resource p)
(PHP 4 >= 4.0.4)
gmp_jacobi -- Jacobi symbol
Description
int gmp_jacobi ( resource a, resource p)
Computes Jacobi symbol of a and p. p should be odd and must be positive.   gmp_invertUpgmp_legendre
#

#T=int gmp_jacobi ( resource a, resource p)
gmp_jacobi ( ^!resource a, resource p);
#

#T=gmp_legendre - int gmp_legendre ( resource a, resource p)
(PHP 4 >= 4.0.4)
gmp_legendre -- Legendre symbol
Description
int gmp_legendre ( resource a, resource p)
Compute the Legendre symbol of a and p. p should be odd and must be 
positive.   gmp_jacobiUpgmp_mod
#

#T=int gmp_legendre ( resource a, resource p)
gmp_legendre ( ^!resource a, resource p);
#

#T=gmp_mod - resource gmp_mod ( resource n, resource d)
(PHP 4 >= 4.0.4)
gmp_mod -- Modulo operation
Description
resource gmp_mod ( resource n, resource d)
Calculates n modulo d. The result is always non-negative, the sign of d is 
ignored.   gmp_legendreUpgmp_mul
#

#T=resource gmp_mod ( resource n, resource d)
gmp_mod ( ^!resource n, resource d);
#

#T=gmp_mul - resource gmp_mul ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_mul -- Multiply numbers
Description
resource gmp_mul ( resource a, resource b)
Multiplies a by b and returns the result.   gmp_modUpgmp_neg
#

#T=resource gmp_mul ( resource a, resource b)
gmp_mul ( ^!resource a, resource b);
#

#T=gmp_neg - resource gmp_neg ( resource a)
(PHP 4 >= 4.0.4)
gmp_neg -- Negate number
Description
resource gmp_neg ( resource a)
Returns -a.   gmp_mulUpgmp_or
#

#T=resource gmp_neg ( resource a)
gmp_neg ( ^!resource a);
#

#T=gmp_or - resource gmp_or ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_or -- Logical OR
Description
resource gmp_or ( resource a, resource b)
Calculates logical inclusive OR of two GMP numbers.   gmp_negUpgmp_perfect_square
#

#T=resource gmp_or ( resource a, resource b)
gmp_or ( ^!resource a, resource b);
#

#T=gmp_perfect_square - bool gmp_perfect_square ( resource a)
(PHP 4 >= 4.0.4)
gmp_perfect_square -- Perfect square check
Description
bool gmp_perfect_square ( resource a)
Returns TRUE if a is a perfect square, FALSE otherwise. 
See also: gmp_sqrt(), gmp_sqrtrm().   gmp_orUpgmp_popcount
#

#T=bool gmp_perfect_square ( resource a)
gmp_perfect_square ( ^!resource a);
#

#T=gmp_popcount - int gmp_popcount ( resource a)
(PHP 4 >= 4.0.4)
gmp_popcount -- Population count
Description
int gmp_popcount ( resource a)
Return the population count of a.   gmp_perfect_squareUpgmp_pow
#

#T=int gmp_popcount ( resource a)
gmp_popcount ( ^!resource a);
#

#T=gmp_pow - resource gmp_pow ( resource base, int exp)
(PHP 4 >= 4.0.4)
gmp_pow -- Raise number into power
Description
resource gmp_pow ( resource base, int exp)
Raise base into power exp. The case of 0^0 yields 1. exp cannot be 
negative.   gmp_popcountUpgmp_powm
#

#T=resource gmp_pow ( resource base, int exp)
gmp_pow ( ^!resource base, int exp);
#

#T=gmp_powm - resource gmp_powm ( resource base, resource exp, resource mod)
(PHP 4 >= 4.0.4)
gmp_powm -- Raise number into power with modulo
Description
resource gmp_powm ( resource base, resource exp, resource mod)
Calculate (base raised into power exp) modulo mod. If exp is negative, 
result is undefined.   gmp_powUpgmp_prob_prime
#

#T=resource gmp_powm ( resource base, resource exp, resource mod)
gmp_powm ( ^!resource base, resource exp, resource mod);
#

#T=gmp_prob_prime - int gmp_prob_prime ( resource a [, int reps])
(PHP 4 >= 4.0.4)
gmp_prob_prime -- Check if number is "probably prime"
Description
int gmp_prob_prime ( resource a [, int reps])
If this function returns 0, a is definitely not prime. If it returns 1, 
then a is "probably" prime. If it returns 2, then a is surely prime. 
Reasonable values of reps vary from 5 to 10 (default being 10); a higher 
value lowers the probability for a non-prime to pass as a "probable" 
prime. 
The function uses Miller-Rabin's probabilistic test.   gmp_powmUpgmp_random
#

#T=int gmp_prob_prime ( resource a [, int reps])
gmp_prob_prime ( ^!resource a [, int reps]);
#

#T=gmp_random - resource gmp_random ( int limiter)
(PHP 4 >= 4.0.4)
gmp_random -- Random number
Description
resource gmp_random ( int limiter)
Generate a random number. The number will be between limiter and zero in 
value. If limiter is negative, negative numbers are generated.   gmp_prob_primeUpgmp_scan0
#

#T=resource gmp_random ( int limiter)
gmp_random ( ^!int limiter);
#

#T=gmp_scan0 - int gmp_scan0 ( resource a, int start)
(PHP 4 >= 4.0.4)
gmp_scan0 -- Scan for 0
Description
int gmp_scan0 ( resource a, int start)
Scans a, starting with bit start, towards more significant bits, until the 
first clear bit is found. Returns the index of the found bit.   gmp_randomUpgmp_scan1
#

#T=int gmp_scan0 ( resource a, int start)
gmp_scan0 ( ^!resource a, int start);
#

#T=gmp_scan1 - int gmp_scan1 ( resource a, int start)
(PHP 4 >= 4.0.4)
gmp_scan1 -- Scan for 1
Description
int gmp_scan1 ( resource a, int start)
Scans a, starting with bit start, towards more significant bits, until the 
first set bit is found. Returns the index of the found bit.   gmp_scan0Upgmp_setbit
#

#T=int gmp_scan1 ( resource a, int start)
gmp_scan1 ( ^!resource a, int start);
#

#T=gmp_setbit - resource gmp_setbit ( resource &a, int index [, bool set_clear])
(PHP 4 >= 4.0.4)
gmp_setbit -- Set bit
Description
resource gmp_setbit ( resource &a, int index [, bool set_clear])
Sets bit index in a. set_clear defines if the bit is set to 0 or 1. By 
default the bit is set to 1.   gmp_scan1Upgmp_sign
#

#T=resource gmp_setbit ( resource &a, int index [, bool set_clear])
gmp_setbit ( ^!resource &a, int index [, bool set_clear]);
#

#T=gmp_sign - int gmp_sign ( resource a)
(PHP 4 >= 4.0.4)
gmp_sign -- Sign of number
Description
int gmp_sign ( resource a)
Return sign of a - 1 if a is positive and -1 if it's negative.   gmp_setbitUpgmp_sqrt
#

#T=int gmp_sign ( resource a)
gmp_sign ( ^!resource a);
#

#T=gmp_sqrt - resource gmp_sqrt ( resource a)
(PHP 4 >= 4.0.4)
gmp_sqrt -- Square root
Description
resource gmp_sqrt ( resource a)
Calculates square root of a.   gmp_signUpgmp_sqrtrm
gmp_sqrtrm
(no version information, might be only in CVS)
gmp_sqrtrm -- Square root with remainder
Description
array gmp_sqrtrm ( resource a)
Returns array where first element is the integer square root of a (see 
also gmp_sqrt()), and the second is the remainder (i.e., the difference 
between a and the first element squared).   gmp_sqrtUpgmp_strval
#

#T=resource gmp_sqrt ( resource a)
gmp_sqrt ( ^!resource a);
#

#T=gmp_strval - string gmp_strval ( resource gmpnumber [, int base])
(PHP 4 >= 4.0.4)
gmp_strval -- Convert GMP number to string
Description
string gmp_strval ( resource gmpnumber [, int base])
Convert GMP number to string representation in base base. The default base 
is 10. Allowed values for the base are from 2 to 36. 
Example 1. Converting a GMP number to a string
  <?php
      $a = gmp_init("0x41682179fbf5");
      printf("Decimal: %s, 36-based: %s", gmp_strval($a), 
  gmp_strval($a,36));
  ?> 

  gmp_sqrtrmUpgmp_sub
#

#T=string gmp_strval ( resource gmpnumber [, int base])
gmp_strval ( ^!resource gmpnumber [, int base]);
#

#T=gmp_sub - resource gmp_sub ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_sub -- Subtract numbers
Description
resource gmp_sub ( resource a, resource b)
Subtracts b from a and returns the result.   gmp_strvalUpgmp_xor
#

#T=resource gmp_sub ( resource a, resource b)
gmp_sub ( ^!resource a, resource b);
#

#T=gmp_xor - resource gmp_xor ( resource a, resource b)
(PHP 4 >= 4.0.4)
gmp_xor -- Logical XOR
Description
resource gmp_xor ( resource a, resource b)
Calculates logical exclusive OR (XOR) of two GMP numbers.   gmp_subUpHTTP functions
#

#T=resource gmp_xor ( resource a, resource b)
gmp_xor ( ^!resource a, resource b);
#

#T=gmstrftime - string gmstrftime ( string format [, int timestamp])
(PHP 3>= 3.0.12, PHP 4 )
gmstrftime --  Format a GMT/UTC time/date according to locale settings 
Description
string gmstrftime ( string format [, int timestamp])
Behaves the same as strftime() except that the time returned is Greenwich 
Mean Time (GMT). For example, when run in Eastern Standard Time (GMT 
-0500), the first line below prints "Dec 31 1998 20:00:00", while the 
second prints "Jan 01 1999 01:00:00". Example 1. gmstrftime() 
example
  <?php
  setlocale(LC_TIME, 'en_US');
  echo strftime("%b %d %Y %H:%M:%S", mktime(20, 0, 0, 12, 31, 
  98)) . "\n";
  echo gmstrftime("%b %d %Y %H:%M:%S", mktime(20, 0, 0, 12, 31, 
  98)) . "\n";
  ?> 
See also strftime().   gmmktimeUplocaltime
#

#T=string gmstrftime ( string format [, int timestamp])
gmstrftime ( ^!string format [, int timestamp]);
#

#T=GregorianToJD - int gregoriantojd ( int month, int day, int year)
(PHP 3, PHP 4 )
GregorianToJD --  Converts a Gregorian date to Julian Day Count 
Description
int gregoriantojd ( int month, int day, int year)
Valid Range for Gregorian Calendar 4714 B.C. to 9999 A.D.
Although this function can handle dates all the way back to 4714 B.C., 
such use may not be meaningful. The Gregorian calendar was not instituted 
until October 15, 1582 (or October 5, 1582 in the Julian calendar). Some 
countries did not accept it until much later. For example, Britain 
converted in 1752, The USSR in 1918 and Greece in 1923. Most European 
countries used the Julian calendar prior to the Gregorian. Example 
1. Calendar functions
  <?php
  $jd = GregorianToJD(10, 11, 1970);
  echo "$jd\n";
  $gregorian = JDToGregorian($jd);
  echo "$gregorian\n";
  ?> 

  FrenchToJDUpJDDayOfWeek
#

#T=int gregoriantojd ( int month, int day, int year)
gregoriantojd ( ^!int month, int day, int year);
#

#T=gzclose - int gzclose ( resource zp)
(PHP 3, PHP 4 )
gzclose -- Close an open gz-file pointer
Description
int gzclose ( resource zp)
The gz-file pointed to by zp is closed. 
Returns TRUE on success or FALSE on failure. 
The gz-file pointer must be valid, and must point to a file successfully 
opened by gzopen().   Zlib Compression FunctionsUpgzcompress
#

#T=int gzclose ( resource zp)
gzclose ( ^!resource zp);
#

#T=gzcompress - string gzcompress ( string data [, int level])
(PHP 4 >= 4.0.1)
gzcompress -- Compress a string
Description
string gzcompress ( string data [, int level])
This function returns a compressed version of the input data using the 
ZLIB data format, or FALSE if an error is encountered. The optional 
parameter level can be given as 0 for no compression up to 9 for maximum 
compression. 
For details on the ZLIB compression algorithm see the document "ZLIB 
Compressed Data Format Specification version 3.3" (RFC 1950). 
Note: This is not the same as gzip compression, which includes some 
header data. See gzencode() for gzip compression. 
See also gzdeflate(), gzinflate(), gzuncompress(), gzencode().   gzcloseUpgzdeflate
#

#T=string gzcompress ( string data [, int level])
gzcompress ( ^!string data [, int level]);
#

#T=gzdeflate - string gzdeflate ( string data [, int level])
(PHP 4 >= 4.0.4)
gzdeflate -- Deflate a string
Description
string gzdeflate ( string data [, int level])
This function returns a compressed version of the input data using the 
DEFLATE data format, or FALSE if an error is encountered. The optional 
parameter level can be given as 0 for no compression up to 9 for maximum 
compression. 
For details on the DEFLATE compression algorithm see the document "DEFLATE 
Compressed Data Format Specification version 1.3" (RFC 1951). 
See also gzinflate(), gzcompress(), gzuncompress(), gzencode().   gzcompressUpgzencode
#

#T=string gzdeflate ( string data [, int level])
gzdeflate ( ^!string data [, int level]);
#

#T=gzencode - string gzencode ( string data [, int level [, int encoding_mode]])
(PHP 4 >= 4.0.4)
gzencode -- Create a gzip compressed string
Description
string gzencode ( string data [, int level [, int encoding_mode]])
This function returns a compressed version of the input data compatible 
with the output of the gzip program, or FALSE if an error is encountered. 
The optional parameter level can be given as 0 for no compression up to 9 
for maximum compression, if not given the default compression level will 
be the default compression level of the zlib library. 
You can also give FORCE_GZIP (the default) or FORCE_DEFLATE as optional 
third parameter encoding_mode. If you use FORCE_DEFLATE, you get a 
standard zlib deflated string (inclusive zlib headers) after the gzip file 
header but without the trailing crc32 checksum. 
Note: level was added in PHP 4.2, before PHP 4.2 gzencode() only had the 
data and (optional) encoding_mode parameters.. 
The resulting data contains the appropriate headers and data structure to 
make a standard .gz file, e.g.: Example 1. Creating a gzip file
  <?php
      $data = implode("", file("bigfile.txt"));
      $gzdata = gzencode($data, 9);
      $fp = fopen("bigfile.txt.gz", "w");
      fwrite($fp, $gzdata);
      fclose($fp);
  ?> 
For more information on the GZIP file format, see the document: GZIP file 
format specification version 4.3 (RFC 1952). 
See also gzcompress(). gzuncompress(), gzdeflate(), gzinflate().   gzdeflateUpgzeof
#

#T=string gzencode ( string data [, int level [, int encoding_mode]])
gzencode ( ^!string data [, int level [, int encoding_mode]]);
#

#T=gzeof - int gzeof ( resource zp)
(PHP 3, PHP 4 )
gzeof -- Test for end-of-file on a gz-file pointer
Description
int gzeof ( resource zp)
Returns TRUE if the gz-file pointer is at EOF or an error occurs; 
otherwise returns FALSE. 
The gz-file pointer must be valid, and must point to a file successfully 
opened by gzopen().   gzencodeUpgzfile
#

#T=int gzeof ( resource zp)
gzeof ( ^!resource zp);
#

#T=gzfile - array gzfile ( string filename [, int use_include_path])
(PHP 3, PHP 4 )
gzfile -- Read entire gz-file into an array
Description
array gzfile ( string filename [, int use_include_path])
Identical to readgzfile(), except that gzfile() returns the file in an 
array. 
You can use the optional second parameter and set it to "1", if you want 
to search for the file in the include_path, too. 
See also readgzfile(), and gzopen().   gzeofUpgzgetc
#

#T=array gzfile ( string filename [, int use_include_path])
gzfile ( ^!string filename [, int use_include_path]);
#

#T=gzgetc - string gzgetc ( resource zp)
(PHP 3, PHP 4 )
gzgetc -- Get character from gz-file pointer
Description
string gzgetc ( resource zp)
Returns a string containing a single (uncompressed) character read from 
the file pointed to by zp. Returns FALSE on EOF (unlike gzeof()). 
The gz-file pointer must be valid, and must point to a file successfully 
opened by gzopen(). 
See also gzopen(), and gzgets().   gzfileUpgzgets
#

#T=string gzgetc ( resource zp)
gzgetc ( ^!resource zp);
#

#T=gzgets - string gzgets ( resource zp, int length)
(PHP 3, PHP 4 )
gzgets -- Get line from file pointer
Description
string gzgets ( resource zp, int length)
Returns a (uncompressed) string of up to length - 1 bytes read from the 
file pointed to by fp. Reading ends when length - 1 bytes have been read, 
on a newline, or on EOF (whichever comes first). 
If an error occurs, returns FALSE. 
The file pointer must be valid, and must point to a file successfully 
opened by gzopen(). 
See also gzopen(), gzgetc(), and fgets().   gzgetcUpgzgetss
#

#T=string gzgets ( resource zp, int length)
gzgets ( ^!resource zp, int length);
#

#T=gzgetss - string gzgetss ( resource zp, int length [, string allowable_tags])
(PHP 3, PHP 4 )
gzgetss --  Get line from gz-file pointer and strip HTML tags 
Description
string gzgetss ( resource zp, int length [, string allowable_tags])
Identical to gzgets(), except that gzgetss() attempts to strip any HTML 
and PHP tags from the text it reads. 
You can use the optional third parameter to specify tags which should not 
be stripped. 
Note: Allowable_tags was added in PHP 3.0.13, PHP 4.0b3. 
See also gzgets(), gzopen(), and strip_tags().   gzgetsUpgzinflate
#

#T=string gzgetss ( resource zp, int length [, string allowable_tags])
gzgetss ( ^!resource zp, int length [, string allowable_tags]);
#

#T=gzinflate - string gzinflate ( string data [, int length])
(PHP 4 >= 4.0.4)
gzinflate -- Inflate a deflated string
Description
string gzinflate ( string data [, int length])
This function takes data compressed by gzdeflate() and returns the 
original uncompressed data or FALSE on error. The function will return an 
error if the uncompressed data is more than 32768 times the length of the 
compressed input data or more than the optional parameter length. 
See also gzcompress(). gzuncompress(), gzdeflate(), gzencode().   gzgetssUpgzopen
#

#T=string gzinflate ( string data [, int length])
gzinflate ( ^!string data [, int length]);
#

#T=gzopen - resource gzopen ( string filename, string mode [, int use_include_path])
(PHP 3, PHP 4 )
gzopen -- Open gz-file
Description
resource gzopen ( string filename, string mode [, int use_include_path])
Opens a gzip (.gz) file for reading or writing. The mode parameter is as 
in fopen() ("rb" or "wb") but can also include a compression level ("wb9") 
or a strategy: 'f' for filtered data as in "wb6f", 'h' for Huffman only 
compression as in "wb1h". (See the description of deflateInit2 in zlib.h 
for more information about the strategy parameter.) 
gzopen() can be used to read a file which is not in gzip format; in this 
case gzread() will directly read from the file without decompression. 
gzopen() returns a file pointer to the file opened, after that, everything 
you read from this file descriptor will be transparently decompressed and 
what you write gets compressed. 
If the open fails, the function returns FALSE. 
You can use the optional third parameter and set it to "1", if you want to 
search for the file in the include_path, too. 
Example 1. gzopen() Example
  <?php
  $fp = gzopen("/tmp/file.gz", "r");
  ?> 
See also gzclose().   gzinflateUpgzpassthru
#

#T=resource gzopen ( string filename, string mode [, int use_include_path])
gzopen ( ^!string filename, string mode [, int use_include_path]);
#

#T=gzpassthru - int gzpassthru ( resource zp)
(PHP 3, PHP 4 )
gzpassthru --  Output all remaining data on a gz-file pointer 
Description
int gzpassthru ( resource zp)
Reads to EOF on the given gz-file pointer and writes the (uncompressed) 
results to standard output. 
If an error occurs, returns FALSE. 
The file pointer must be valid, and must point to a file successfully 
opened by gzopen().   gzopenUpgzputs
gzputs
gzputs -- Alias for gzwrite()
Description
This function is an alias of gzwrite().   gzpassthruUpgzread
#

#T=int gzpassthru ( resource zp)
gzpassthru ( ^!resource zp);
#

#T=gzread - string gzread ( resource zp, int length)
(PHP 3, PHP 4 )
gzread -- Binary-safe gz-file read
Description
string gzread ( resource zp, int length)
gzread() reads up to length bytes from the gz-file pointer referenced by 
zp. Reading stops when length (uncompressed) bytes have been read or EOF 
is reached, whichever comes first. 
Example 1. gzread() example
  <?php
  // get contents of a gz-file into a string
  $filename = "/usr/local/something.txt.gz";
  $zd = gzopen($filename, "r");
  $contents = gzread($zd, 10000);
  gzclose($zd);
  ?> 
See also gzwrite(), gzopen(), gzgets(), gzgetss(), gzfile(), and 
gzpassthru().   gzputsUpgzrewind
#

#T=string gzread ( resource zp, int length)
gzread ( ^!resource zp, int length);
#

#T=gzrewind - int gzrewind ( resource zp)
(PHP 3, PHP 4 )
gzrewind -- Rewind the position of a gz-file pointer
Description
int gzrewind ( resource zp)
Sets the file position indicator for zp to the beginning of the file 
stream. 
If an error occurs, returns 0. 
The file pointer must be valid, and must point to a file successfully 
opened by gzopen(). 
See also gzseek() and gztell().   gzreadUpgzseek
#

#T=int gzrewind ( resource zp)
gzrewind ( ^!resource zp);
#

#T=gzseek - int gzseek ( resource zp, int offset)
(PHP 3, PHP 4 )
gzseek -- Seek on a gz-file pointer
Description
int gzseek ( resource zp, int offset)
Sets the file position indicator for the file referenced by zp to offset 
bytes into the file stream. Equivalent to calling (in C) gzseek(zp, 
offset, SEEK_SET). 
If the file is opened for reading, this function is emulated but can be 
extremely slow. If the file is opened for writing, only forward seeks are 
supported; gzseek then compresses a sequence of zeroes up to the new 
starting position. 
Upon success, returns 0; otherwise, returns -1. Note that seeking past EOF 
is not considered an error. 
See also gztell() and gzrewind().   gzrewindUpgztell
#

#T=int gzseek ( resource zp, int offset)
gzseek ( ^!resource zp, int offset);
#

#T=gztell - int gztell ( resource zp)
(PHP 3, PHP 4 )
gztell -- Tell gz-file pointer read/write position
Description
int gztell ( resource zp)
Returns the position of the file pointer referenced by zp; i.e., its 
offset into the file stream. 
If an error occurs, returns FALSE. 
The file pointer must be valid, and must point to a file successfully 
opened by gzopen(). 
See also gzopen(), gzseek() and gzrewind().   gzseekUpgzuncompress
#

#T=int gztell ( resource zp)
gztell ( ^!resource zp);
#

#T=gzuncompress - string gzuncompress ( string data [, int length])
(PHP 4 >= 4.0.1)
gzuncompress -- Uncompress a deflated string
Description
string gzuncompress ( string data [, int length])
This function takes data compressed by gzcompress() and returns the 
original uncompressed data or FALSE on error. The function will return an 
error if the uncompressed data is more than 32768 times the length of the 
compressed input data or more than the optional parameter length. 
See also gzdeflate(), gzinflate(), gzcompress(), gzencode().   gztellUpgzwrite
#

#T=string gzuncompress ( string data [, int length])
gzuncompress ( ^!string data [, int length]);
#

#T=gzwrite - int gzwrite ( resource zp, string string [, int length])
(PHP 3, PHP 4 )
gzwrite -- Binary-safe gz-file write
Description
int gzwrite ( resource zp, string string [, int length])
gzwrite() writes the contents of string to the gz-file stream pointed to 
by zp. If the length argument is given, writing will stop after length 
(uncompressed) bytes have been written or the end of string is reached, 
whichever comes first. 
gzwrite() returns the number of (uncompressed) bytes written to the 
gz-file stream pointed to by zp. 
Note that if the length argument is given, then the magic_quotes_runtime 
configuration option will be ignored and no slashes will be stripped from 
string. 
See also gzread(), gzopen(), and gzputs().   gzuncompressUpreadgzfile
#

#T=int gzwrite ( resource zp, string string [, int length])
gzwrite ( ^!resource zp, string string [, int length]);
#

#T=header - void header ( string string [, bool replace [, int http_response_code]])
(PHP 3, PHP 4 )
header -- Send a raw HTTP header
Description
void header ( string string [, bool replace [, int http_response_code]])
header() is used to send raw HTTP headers. See the HTTP/1.1 specification 
for more information on HTTP headers. 
The optional replace parameter indicates whether the header should replace 
a previous similar header, or add a second header of the same type. By 
default it will replace, but if you pass in FALSE as the second argument 
you can force multiple headers of the same type. For example: 
<?php
header('WWW-Authenticate: Negotiate');
header('WWW-Authenticate: NTLM', false);
?> 

The second optional http_response_code force the HTTP response code to the 
specified value. (This parameter is available in PHP 4.3.0 and higher.) 
There are two special-case header calls. The first is a header that starts 
with the string "HTTP/" (case is not significant), which will be used to 
figure out the HTTP status code to send. For example, if you have 
configured Apache to use a PHP script to handle requests for missing files 
(using the ErrorDocument directive), you may want to make sure that your 
script generates the proper status code. 
<?php
header("HTTP/1.0 404 Not Found");
?> 

Note: The HTTP status header line will always be the first sent to the 
client, regardless of the actual header() call being the first or not. 
The status may be overridden by calling header() with a new status line 
at any time unless the HTTP headers have already been sent. 
Note: In PHP 3, this only works when PHP is compiled as an Apache 
module. You can achieve the same effect using the Status header. 
<?php
header("Status: 404 Not Found");
?> 

The second special case is the "Location:" header. Not only does it send 
this header back to the browser, but it also returns a REDIRECT (302) 
status code to the browser unless some 3xx status code has already been 
set. 
<?php
header("Location: http://www.example.com/"); /* Redirect browser */

/* Make sure that code below does not get executed when we redirect. 
*/
exit;
?> 

Note: HTTP/1.1 requires an absolute URI as argument to Location: 
including the scheme, hostname and absolute path, but some clients 
accept relative URIs. You can usually use $_SERVER['HTTP_HOST'], 
$_SERVER['PHP_SELF'] and dirname() to make an absolute URI from a 
relative one yourself: 
<?php
header("Location: http://" . $_SERVER['HTTP_HOST']
		    . dirname($_SERVER['PHP_SELF'])
		    . "/" . $relative_url);
?> 

PHP scripts often generate dynamic content that must not be cached by the 
client browser or any proxy caches between the server and the client 
browser. Many proxies and clients can be forced to disable caching with: 
<?php
// Date in the past
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");

// always modified
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");

// HTTP/1.1
header("Cache-Control: no-store, no-cache, must-revalidate");
header("Cache-Control: post-check=0, pre-check=0", false);

// HTTP/1.0
header("Pragma: no-cache");
?> 

Note: You may find that your pages aren't cached even if you don't 
output all of the headers above. There are a number of options that 
users may be able to set for their browser that change its default 
caching behavior. By sending the headers above, you should override any 
settings that may otherwise cause the output of your script to be 
cached. 
Additionally, session_cache_limiter() and the session.cache_limiter 
configuration setting can be used to automatically generate the correct 
caching-related headers when sessions are being used. 
Remember that header() must be called before any actual output is sent, 
either by normal HTML tags, blank lines in a file, or from PHP. It is a 
very common error to read code with include(), or require(), functions, or 
another file access function, and have spaces or empty lines that are 
output before header() is called. The same problem exists when using a 
single PHP/HTML file. 
<html>
<?php
/* This will give an error. Note the output
* above, which is before the header() call */
header('Location: http://www.example.com/');
?> 

Note: In PHP 4, you can use output buffering to get around this problem, 
with the overhead of all of your output to the browser being buffered in 
the server until you send it. You can do this by calling ob_start() and 
ob_end_flush() in your script, or setting the output_buffering 
configuration directive on in your php.ini or server configuration 
files. 
If you want the user to be prompted to save the data you are sending, such 
as a generated PDF file, you can use the Content-Disposition header to 
supply a recommended filename and force the browser to display the save 
dialog. 
<?php
// We'll be outputting a PDF
header("Content-type: application/pdf");

// It will be called downloaded.pdf
header("Content-Disposition: attachment; filename=downloaded.pdf");

// The PDF source is in original.pdf
readfile('original.pdf');
?> 

Note: There is a bug in Microsoft Internet Explorer 4.01 that prevents 
this from working. There is no workaround. There is also a bug in 
Microsoft Internet Explorer 5.5 that interferes with this, which can be 
resolved by upgrading to Service Pack 2 or later. 
Note: If safe mode is enabled the uid of the script is added to the 
realm part of the WWW-Authenticate header if you set this header (used 
for HTTP Authentication). 
See also headers_sent(), setcookie(), and the section on HTTP 
authentication.   HTTP functionsUpheaders_list
headers_list
(no version information, might be only in CVS)
headers_list -- Returns a list of response headers sent (or ready to send)
Description
array headers_list ( void )
headers_list() will return a numerically indexed array of headers to be 
sent to the browser / client. To determine whether or not these headers 
have been sent yet, use headers_sent(). 
Example 1. Examples using headers_list()
  <?php

  /* setcookie() will add a response header on its own */
  setcookie('foo', 'bar');

  /* Define a custom response header
     This will be ignored by most clients */
  header("X-Sample-Test: foo");

  /* Specify plain text content in our response */
  header('Content-type: text/plain');

  /* What headers are going to be sent? */
  var_dump(headers_list());

  ?> 

this will output : 
array(4) {
[0]=>
string(29) "X-Powered-By: PHP/5.0.0"
[1]=>
string(19) "Set-Cookie: foo=bar"
[2]=>
string(18) "X-Sample-Test: foo"
[3]=>
string(24) "Content-type: text/plain"
}
See Also: headers_sent(), header(), and setcookie().   headerUpheaders_sent
#

#T=void header ( string string [, bool replace [, int http_response_code]])
header ( ^!string string [, bool replace [, int http_response_code]]);
#

#T=headers_sent - bool headers_sent ( [string &file [, int &line]])
(PHP 3>= 3.0.8, PHP 4 )
headers_sent -- Checks if or where headers have been sent
Description
bool headers_sent ( [string &file [, int &line]])
headers_sent() will return FALSE if no HTTP headers have already been sent 
or TRUE otherwise. If the optional file and line parameters are set, 
headers_sent() will put the PHP source file name and line number where 
output started in the file and line variables. 
You can't add any more header lines using the header() function once the 
header block has already been sent. Using this function you can at least 
prevent getting HTTP header related error messages. Another option is to 
use Output Buffering. 
Note: The optional file and line parameters where added in PHP 4.3.0. 
Example 1. Examples using headers_sent()
  <?php

  // If no headers are sent, send one
  if (!headers_sent()) {
      header('Location: http://www.example.com/');
      exit;
  }
    
  // An example using the optional file and line parameters, as 
  of PHP 4.3.0
  // Note that $filename and $linenum are passed in for later 
  use.
  // Do not assign them values beforehand.
  if (!headers_sent($filename, $linenum)) {
      header('Location: http://www.example.com/');
      exit;

  // You would most likely trigger an error here.
  } else {

      echo "Headers already sent in $filename on line 
  $linenum\n" .
	    "Cannot redirect, for now please click this <a " .
	    "href=\"http://www.example.com\">link</a> 
instead\n";
      exit;
  }

  ?> 
See also ob_start(), trigger_error(), and header() for a more detailed 
discussion of the matters involved.   headers_listUpsetcookie
#

#T=bool headers_sent ( [string &file [, int &line]])
headers_sent ( ^![string &file [, int &line]]);
#

#T=hebrev - string hebrev ( string hebrew_text [, int max_chars_per_line])
(PHP 3, PHP 4 )
hebrev --  Convert logical Hebrew text to visual text 
Description
string hebrev ( string hebrew_text [, int max_chars_per_line])
The optional parameter max_chars_per_line indicates maximum number of 
characters per line will be output. The function tries to avoid breaking 
words. 
See also hebrevc()   get_html_translation_tableUphebrevc
#

#T=string hebrev ( string hebrew_text [, int max_chars_per_line])
hebrev ( ^!string hebrew_text [, int max_chars_per_line]);
#

#T=hebrevc - string hebrevc ( string hebrew_text [, int max_chars_per_line])
(PHP 3, PHP 4 )
hebrevc --  Convert logical Hebrew text to visual text with newline 
conversion 
Description
string hebrevc ( string hebrew_text [, int max_chars_per_line])
This function is similar to hebrev() with the difference that it converts 
newlines (\n) to "<br>\n". The optional parameter max_chars_per_line 
indicates maximum number of characters per line will be output. The 
function tries to avoid breaking words. 
See also hebrev()   hebrevUphtml_entity_decode
#

#T=string hebrevc ( string hebrew_text [, int max_chars_per_line])
hebrevc ( ^!string hebrew_text [, int max_chars_per_line]);
#

#T=hexdec - int hexdec ( string hex_string)
(PHP 3, PHP 4 )
hexdec -- Hexadecimal to decimal
Description
int hexdec ( string hex_string)
Returns the decimal equivalent of the hexadecimal number represented by 
the hex_string argument. hexdec() converts a hexadecimal string to a 
decimal number. The largest number that can be converted is 7fffffff or 
2147483647 in decimal. 
hexdec() will replace of any non-hexadecimal characters it encounters by 
0. This way, all left zeros are ignored, but right zeros will be valued. 
Example 1. hexdec() example
  <?php
  var_dump(hexdec("See"));
  var_dump(hexdec("ee"));
  // both print "int(238)"

  var_dump(hexdec("that"));
  var_dump(hexdec("a0"));
  // both print "int(160)"
  ?> 
See also dechex(), bindec(), octdec() and base_convert().   getrandmaxUphypot
#

#T=int hexdec ( string hex_string)
hexdec ( ^!string hex_string);
#

#T=highlight_file - mixed highlight_file ( string filename [, bool return])
(PHP 4 )
highlight_file -- Syntax highlighting of a file
Description
mixed highlight_file ( string filename [, bool return])
The highlight_file() function prints out a syntax highlighted version of 
the code contained in filename using the colors defined in the built-in 
syntax highlighter for PHP. 
If the second parameter return is set to TRUE then highlight_file() will 
return the highlighted code as a string instead of printing it out. If the 
second parameter is not set to TRUE then highlight_file() will return TRUE 
on success, FALSE on failure. 
Note: The return parameter became available in PHP 4.2.0. Before this 
time it behaved like the default, which is FALSE 
Caution
Care should be taken when using the show_source() and 
highlight_file() functions to make sure that you do not 
inadvertently reveal sensitive information such as passwords or any 
other type of information that might create a potential security 
risk. 

Note: Since PHP 4.2.1 this function is also affected by safe_mode and 
open_basedir. 
To setup a URL that can code hightlight any script that you pass to it, we 
will make use of the "ForceType" directive in Apache to generate a nice 
URL pattern, and use the function highlight_file() to show a nice looking 
code list. 
In your httpd.conf you can add the following: 
Example 1. Creating a source highlighting URL
<Location /source>
ForceType application/x-httpd-php
</Location>

And then make a file named "source" and put it in your web root 
directory. 
  <html>
  <head>
  <title>Source Display</title>
  </head>
  <body bgcolor="white">
  <?php
      $script = getenv("PATH_TRANSLATED");
      if (!$script) {
	  echo "<br /><b>ERROR: Script Name needed</b><br />";
      } else {
	  if (ereg("(\\.php|\\.inc)$", $script)) {
	      echo "<h1>Source of: " . getenv("PATH_INFO") . 
  "</h1>\n<hr />\n";
	      highlight_file($script);
	  } else {
	      echo "<h1>ERROR: Only PHP or include script names 
  are allowed</h1>"; 
	  }
      }
      echo "<hr />Processed: " . date("Y/M/d H:i:s", time());
  ?>
  </BODY>
  </HTML> 

Then you can use an URL like the one below to display a colorized 
version of a script located in "/path/to/script.php" in your web 
site. 
http://www.example.com/source/path/to/script.php
See also highlight_string().   get_browserUphighlight_string
#

#T=mixed highlight_file ( string filename [, bool return])
highlight_file ( ^!string filename [, bool return]);
#

#T=highlight_string - mixed highlight_string ( string str [, bool return])
(PHP 4 )
highlight_string -- Syntax highlighting of a string
Description
mixed highlight_string ( string str [, bool return])
The highlight_string() function outputs a syntax highlighted version of 
str using the colors defined in the built-in syntax highlighter for PHP. 
If the second parameter return is set to TRUE then highlight_string() will 
return the highlighted code as a string instead of printing it out. If the 
second parameter is not set to TRUE then highlight_string() will return 
TRUE on success, FALSE on failure. 
Note: The return parameter became available in PHP 4.2.0. Before this 
time it behaved like the default, which is FALSE 
See also highlight_file().   highlight_fileUpignore_user_abort
#

#T=mixed highlight_string ( string str [, bool return])
highlight_string ( ^!string str [, bool return]);
#

#T=html_entity_decode - string html_entity_decode ( string string [, int quote_style [, string 
(PHP 4 >= 4.3.0)
html_entity_decode --  Convert all HTML entities to their applicable 
characters 
Description
string html_entity_decode ( string string [, int quote_style [, string 
charset]])
html_entity_decode() is the opposite of htmlentities() in that it converts 
all HTML entities to their applicable characters from string. 
The optional second quote_style parameter lets you define what will be 
done with 'single' and "double" quotes. It takes on one of three constants 
with the default being ENT_COMPAT: 
Table 1. Available quote_style constants
Constant NameDescription
ENT_COMPATWill convert double-quotes and leave single-quotes alone.
ENT_QUOTESWill convert both double and single quotes.
ENT_NOQUOTESWill leave both double and single quotes unconverted.

The ISO-8859-1 character set is used as default for the optional third 
charset. This defines the character set used in conversion. Support for 
this third argument was added in PHP 4.1.0. 
Following character sets are supported in PHP 4.3.0 and later. 
Table 2. Supported charsets
CharsetAliasesDescription
ISO-8859-1ISO8859-1Western European, Latin-1 
ISO-8859-15ISO8859-15Western European, Latin-9. Adds the Euro sign, 
French and Finnish letters missing in Latin-1(ISO-8859-1). 
UTF-8 ASCII compatible multi-byte 8-bit Unicode. 
cp866ibm866, 866DOS-specific Cyrillic charset. This charset is 
supported in 4.3.2. 
cp1251Windows-1251, win-1251, 1251Windows-specific Cyrillic charset. 
This charset is supported in 4.3.2. 
cp1252Windows-1252, 1252Windows specific charset for Western 
European. 
KOI8-Rkoi8-ru, koi8rRussian. This charset is supported in 4.3.2. 
BIG5950Traditional Chinese, mainly used in Taiwan. 
GB2312936Simplified Chinese, national standard character set. 
BIG5-HKSCS Big5 with Hong Kong extensions, Traditional Chinese. 
Shift_JISSJIS, 932Japanese 
EUC-JPEUCJPJapanese 

Note: Any other character sets are not recognized and ISO-8859-1 will be 
used instead. 
Example 1. Decoding HTML entities
  <?php
  $orig = "I'll \"walk\" the <b>dog</b> now";

  $a = htmlentities($orig);

  $b = html_entity_decode($a);

  echo $a; // I'll &quot;walk&quot; the &lt;b&gt;dog&lt;/b&gt; 
  now

  echo $b; // I'll "walk" the <b>dog</b> now
  // For users prior to PHP 4.3.0 you may do this:
  function unhtmlentities($string) {
      $trans_tbl = get_html_translation_table(HTML_ENTITIES);
      $trans_tbl = array_flip($trans_tbl);
      return strtr($string, $trans_tbl);
  }

  $c = unhtmlentities($a);

  echo $c; // I'll "walk" the <b>dog</b> now

  ?> 
Note: You might wonder why trim(html_entity_decode('&nbsp;')); doesn't 
reduce the string to an empty string, that's because the '&nbsp;' entity 
is not ASCII code 32 (which is stripped by trim()) but ASCII code 160 
(0xa0) in the default ISO 8859-1 characterset. 
See also htmlentities(), htmlspecialchars(), get_html_translation_table(), 
htmlspecialchars() and urldecode().   hebrevcUphtmlentities
#

#T=string html_entity_decode ( string string [, int quote_style [, string 
html_entity_decode ( ^!string string [, int quote_style [, string ;
#

#T=htmlentities - string htmlentities ( string string [, int quote_style [, string 
(PHP 3, PHP 4 )
htmlentities --  Convert all applicable characters to HTML entities 
Description
string htmlentities ( string string [, int quote_style [, string 
charset]])
This function is identical to htmlspecialchars() in all ways, except with 
htmlentities(), all characters which have HTML character entity 
equivalents are translated into these entities. 
Like htmlspecialchars(), the optional second quote_style parameter lets 
you define what will be done with 'single' and "double" quotes. It takes 
on one of three constants with the default being ENT_COMPAT: 
Table 1. Available quote_style constants
Constant NameDescription
ENT_COMPATWill convert double-quotes and leave single-quotes alone.
ENT_QUOTESWill convert both double and single quotes.
ENT_NOQUOTESWill leave both double and single quotes unconverted.

Support for the optional quote parameter was added in PHP 4.0.3. 
Like htmlspecialchars(), it takes an optional third argument charset which 
defines character set used in conversion. Support for this argument was 
added in PHP 4.1.0. Presently, the ISO-8859-1 character set is used as the 
default. 
Following character sets are supported in PHP 4.3.0 and later. 
Table 2. Supported charsets
CharsetAliasesDescription
ISO-8859-1ISO8859-1Western European, Latin-1 
ISO-8859-15ISO8859-15Western European, Latin-9. Adds the Euro sign, 
French and Finnish letters missing in Latin-1(ISO-8859-1). 
UTF-8 ASCII compatible multi-byte 8-bit Unicode. 
cp866ibm866, 866DOS-specific Cyrillic charset. This charset is 
supported in 4.3.2. 
cp1251Windows-1251, win-1251, 1251Windows-specific Cyrillic charset. 
This charset is supported in 4.3.2. 
cp1252Windows-1252, 1252Windows specific charset for Western 
European. 
KOI8-Rkoi8-ru, koi8rRussian. This charset is supported in 4.3.2. 
BIG5950Traditional Chinese, mainly used in Taiwan. 
GB2312936Simplified Chinese, national standard character set. 
BIG5-HKSCS Big5 with Hong Kong extensions, Traditional Chinese. 
Shift_JISSJIS, 932Japanese 
EUC-JPEUCJPJapanese 

Note: Any other character sets are not recognized and ISO-8859-1 will be 
used instead. 
If you're wanting to decode instead (the reverse) you can use 
html_entity_decode(). 
Example 1. A htmlentities() example
  <?php
  $str = "A 'quote' is <b>bold</b>";

  // Outputs: A 'quote' is &lt;b&gt;bold&lt;/b&gt;
  echo htmlentities($str);

  // Outputs: A &#039;quote&#039; is &lt;b&gt;bold&lt;/b&gt;
  echo htmlentities($str, ENT_QUOTES);
  ?> 
See also html_entity_decode(), get_html_translation_table(), 
htmlspecialchars(), nl2br(), and urlencode().   html_entity_decodeUphtmlspecialchars
#

#T=string htmlentities ( string string [, int quote_style [, string 
htmlentities ( ^!string string [, int quote_style [, string ;
#

#T=htmlspecialchars - string htmlspecialchars ( string string [, int quote_style [, string 
(PHP 3, PHP 4 )
htmlspecialchars --  Convert special characters to HTML entities 
Description
string htmlspecialchars ( string string [, int quote_style [, string 
charset]])
Certain characters have special significance in HTML, and should be 
represented by HTML entities if they are to preserve their meanings. This 
function returns a string with some of these conversions made; the 
translations made are those most useful for everyday web programming. If 
you require all HTML character entities to be translated, use 
htmlentities() instead. 
This function is useful in preventing user-supplied text from containing 
HTML markup, such as in a message board or guest book application. The 
optional second argument, quote_style, tells the function what to do with 
single and double quote characters. The default mode, ENT_COMPAT, is the 
backwards compatible mode which only translates the double-quote character 
and leaves the single-quote untranslated. If ENT_QUOTES is set, both 
single and double quotes are translated and if ENT_NOQUOTES is set neither 
single nor double quotes are translated. 
The translations performed are: 
'&' (ampersand) becomes '&amp;' 
'"' (double quote) becomes '&quot;' when ENT_NOQUOTES is not set. 
''' (single quote) becomes '&#039;' only when ENT_QUOTES is set. 
'<' (less than) becomes '&lt;' 
'>' (greater than) becomes '&gt;' 
Example 1. htmlspecialchars() example
  <?php
  $new = htmlspecialchars("<a href='test'>Test</a>", 
ENT_QUOTES);
  echo $new; // &lt;a href=&#039;test&#039;&gt;Test&lt;/a&gt;
  ?> 
Note that this function does not translate anything beyond what is listed 
above. For full entity translation, see htmlentities(). Support for the 
optional second argument was added in PHP 3.0.17 and PHP 4.0.3. 
The third argument charset defines character set used in conversion. The 
default character set is ISO-8859-1. Support for this third argument was 
added in PHP 4.1.0. 
Following character sets are supported in PHP 4.3.0 and later. 
Table 1. Supported charsets
CharsetAliasesDescription
ISO-8859-1ISO8859-1Western European, Latin-1 
ISO-8859-15ISO8859-15Western European, Latin-9. Adds the Euro sign, 
French and Finnish letters missing in Latin-1(ISO-8859-1). 
UTF-8 ASCII compatible multi-byte 8-bit Unicode. 
cp866ibm866, 866DOS-specific Cyrillic charset. This charset is 
supported in 4.3.2. 
cp1251Windows-1251, win-1251, 1251Windows-specific Cyrillic charset. 
This charset is supported in 4.3.2. 
cp1252Windows-1252, 1252Windows specific charset for Western 
European. 
KOI8-Rkoi8-ru, koi8rRussian. This charset is supported in 4.3.2. 
BIG5950Traditional Chinese, mainly used in Taiwan. 
GB2312936Simplified Chinese, national standard character set. 
BIG5-HKSCS Big5 with Hong Kong extensions, Traditional Chinese. 
Shift_JISSJIS, 932Japanese 
EUC-JPEUCJPJapanese 

Note: Any other character sets are not recognized and ISO-8859-1 will be 
used instead. 
See also get_html_translation_table(), strip_tags(), htmlentities(), and 
nl2br().   htmlentitiesUpimplode
http_build_query
(no version information, might be only in CVS)
http_build_query -- Generate url-encoded query string
Description
string http_build_query ( array formdata [, string numeric_prefix])
Generates a url-encoded query string from the associative (or indexed) 
array provided. formdata may be an array or object containing properties. 
A formdata array may be a simple one-dimensional structure, or an array of 
arrays (who in turn may contain other arrays). If numeric indices are used 
in the base array and a numeric_prefix is provided, it will be prepended 
to the numeric index for elements in the base array only. This is to allow 
for legal variable names when the data is decoded by PHP or another CGI 
application later on. 
Example 1. Simple usage of http_build_query()
  <?php
  $data = array('foo'=>'bar',
		'baz'=>'boom',
		'cow'=>'milk',
		'php'=>'hypertext processor');
		
  echo http_build_query($data);
  /* Outputs:
	foo=bar&baz=boom&cow=milk&php=hypertext+processor
  */
  ?> 

Example 2. http_build_query() with numerically index elements.
  <?php
  $data = array('foo', 'bar', 'baz', 'boom', 'cow' => 'milk', 
  'php' =>'hypertext processor');
		
  echo http_build_query($data);
  /* Outputs:
	
0=foo&1=bar&2=baz&3=boom&cow=milk&php=hypertext+processor
  */

  echo http_build_query($data, 'myvar_');
  /* Outputs:
	
  myvar_0=foo&myvar_1=bar&myvar_2=baz&myvar_3=boom&cow=milk&php=hypertext+processor
  */
  ?> 

Example 3. http_build_query() with complex arrays
  <?php
  $data = array('user'=>array('name'=>'Bob Smith',
			      'age'=>47,
			      'sex'=>'M',
			      'dob'=>'5/12/1956'),
		'pastimes'=>array('golf', 'opera', 'poker', 
  'rap'),
		'children'=>array('bobby'=>array('age'=>12,
						 'sex'=>'M'),
				  'sally'=>array('age'=>8,
						 'sex'=>'F')),
		'CEO');
						 
  echo http_build_query($data, 'flags_');
  ?> 

this will output : (word wrapped for readability) 
user[name]=Bob+Smith&user[age]=47&user[sex]=M&user[dob]=5%1F12%1F1956&
pastimes[0]=golf&pastimes[1]=opera&pastimes[2]=poker&pastimes[3]=rap&
children[bobby][age]=12&children[bobby][sex]=M&children[sally][age]=8&
children[sally][sex]=F&flags_0=CEO

Note: Only the numerically indexed element in the base array "CEO" 
received a prefix. The other numeric indices, found under 
pastimes, do not require a string prefix to be legal variable 
names. 
Example 4. Using http_build_query() with an object
  <?php
  class myClass {
    var $foo;
    var $baz;
    
    function myClass() {
      $this->foo = 'bar';
      $this->baz = 'boom';
    }
  }

  $data = new myClass();

  echo http_build_query($data);
  /* Outputs:
	foo=bar&baz=boom
  */
  ?> 
See also: parse_str(), parse_url(), urlencode(), and array_walk()   get_meta_tagsUpparse_url
#

#T=string htmlspecialchars ( string string [, int quote_style [, string 
htmlspecialchars ( ^!string string [, int quote_style [, string ;
#

#T=hw_Array2Objrec - string hw_array2objrec ( array object_array)
(PHP 3>= 3.0.4, PHP 4 )
hw_Array2Objrec -- convert attributes from object array to object record
Description
string hw_array2objrec ( array object_array)
Converts an object_array into an object record. Multiple attributes like 
'Title' in different languages are treated properly. 
See also hw_objrec2array().   Hyperwave functionsUphw_changeobject
#

#T=string hw_array2objrec ( array object_array)
hw_array2objrec ( ^!array object_array);
#

#T=hw_changeobject - void hw_changeobject ( int link, int objid, array attributes)
(PHP 3>= 3.0.3, PHP 4 )
hw_changeobject --  Changes attributes of an object (obsolete) 
Description
void hw_changeobject ( int link, int objid, array attributes)
Warning
This function is currently not documented; only the argument list is 
available.
  hw_Array2ObjrecUphw_Children
#

#T=void hw_changeobject ( int link, int objid, array attributes)
hw_changeobject ( ^!int link, int objid, array attributes);
#

#T=hw_Children - array hw_children ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_Children -- object ids of children
Description
array hw_children ( int connection, int objectID)
Returns an array of object ids. Each id belongs to a child of the 
collection with ID objectID. The array contains all children both 
documents and collections.  hw_changeobjectUphw_ChildrenObj
#

#T=array hw_children ( int connection, int objectID)
hw_children ( ^!int connection, int objectID);
#

#T=hw_ChildrenObj - array hw_childrenobj ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_ChildrenObj -- object records of children
Description
array hw_childrenobj ( int connection, int objectID)
Returns an array of object records. Each object record belongs to a child 
of the collection with ID objectID. The array contains all children both 
documents and collections.  hw_ChildrenUphw_Close
#

#T=array hw_childrenobj ( int connection, int objectID)
hw_childrenobj ( ^!int connection, int objectID);
#

#T=hw_Close - int hw_close ( int connection)
(PHP 3>= 3.0.3, PHP 4 )
hw_Close -- closes the Hyperwave connection
Description
int hw_close ( int connection)
Returns FALSE if connection is not a valid connection index, otherwise 
TRUE. Closes down the connection to a Hyperwave server with the given 
connection index.   hw_ChildrenObjUphw_Connect
#

#T=int hw_close ( int connection)
hw_close ( ^!int connection);
#

#T=hw_Connect - int hw_connect ( string host, int port, string username, string password)
(PHP 3>= 3.0.3, PHP 4 )
hw_Connect -- opens a connection
Description
int hw_connect ( string host, int port, string username, string password)
Opens a connection to a Hyperwave server and returns a connection index on 
success, or FALSE if the connection could not be made. Each of the 
arguments should be a quoted string, except for the port number. The 
username and password arguments are optional and can be left out. In such 
a case no identification with the server will be done. It is similar to 
identify as user anonymous. This function returns a connection index that 
is needed by other Hyperwave functions. You can have multiple connections 
open at once. Keep in mind, that the password is not encrypted. 
See also hw_pconnect().   hw_CloseUphw_connection_info
#

#T=int hw_connect ( string host, int port, string username, string password)
hw_connect ( ^!string host, int port, string username, string password);
#

#T=hw_connection_info - void hw_connection_info ( int link)
(PHP 3>= 3.0.3, PHP 4 )
hw_connection_info --  Prints information about the connection to 
Hyperwave server 
Description
void hw_connection_info ( int link)
Warning
This function is currently not documented; only the argument list is 
available.
  hw_ConnectUphw_cp
#

#T=void hw_connection_info ( int link)
hw_connection_info ( ^!int link);
#

#T=hw_cp - int hw_cp ( int connection, array object_id_array, int destination_id)
(PHP 3>= 3.0.3, PHP 4 )
hw_cp -- Copies objects
Description
int hw_cp ( int connection, array object_id_array, int destination_id)
Copies the objects with object ids as specified in the second parameter to 
the collection with the id destination id. 
The value return is the number of copied objects. 
See also hw_mv().   hw_connection_infoUphw_Deleteobject
#

#T=int hw_cp ( int connection, array object_id_array, int destination_id)
hw_cp ( ^!int connection, array object_id_array, int destination_id);
#

#T=hw_Deleteobject - int hw_deleteobject ( int connection, int object_to_delete)
(PHP 3>= 3.0.3, PHP 4 )
hw_Deleteobject -- deletes object
Description
int hw_deleteobject ( int connection, int object_to_delete)
Deletes the object with the given object id in the second parameter. It 
will delete all instances of the object. 
Returns TRUE if no error occurs otherwise FALSE. 
See also hw_mv().   hw_cpUphw_DocByAnchor
#

#T=int hw_deleteobject ( int connection, int object_to_delete)
hw_deleteobject ( ^!int connection, int object_to_delete);
#

#T=hw_DocByAnchor - int hw_docbyanchor ( int connection, int anchorID)
(PHP 3>= 3.0.3, PHP 4 )
hw_DocByAnchor -- object id object belonging to anchor
Description
int hw_docbyanchor ( int connection, int anchorID)
Returns an th object id of the document to which anchorID belongs.   hw_DeleteobjectUphw_DocByAnchorObj
#

#T=int hw_docbyanchor ( int connection, int anchorID)
hw_docbyanchor ( ^!int connection, int anchorID);
#

#T=hw_DocByAnchorObj - string hw_docbyanchorobj ( int connection, int anchorID)
(PHP 3>= 3.0.3, PHP 4 )
hw_DocByAnchorObj -- object record object belonging to anchor
Description
string hw_docbyanchorobj ( int connection, int anchorID)
Returns an th object record of the document to which anchorID belongs.   hw_DocByAnchorUphw_Document_Attributes
#

#T=string hw_docbyanchorobj ( int connection, int anchorID)
hw_docbyanchorobj ( ^!int connection, int anchorID);
#

#T=hw_Document_Attributes - string hw_document_attributes ( int hw_document)
(PHP 3>= 3.0.3, PHP 4 )
hw_Document_Attributes -- object record of hw_document
Description
string hw_document_attributes ( int hw_document)
Returns the object record of the document. 
For backward compatibility, hw_documentattributes() is also accepted. This 
is deprecated, however. 
See also hw_document_bodytag(), and hw_document_size().   hw_DocByAnchorObjUphw_Document_BodyTag
#

#T=string hw_document_attributes ( int hw_document)
hw_document_attributes ( ^!int hw_document);
#

#T=hw_Document_BodyTag - string hw_document_bodytag ( int hw_document)
(PHP 3>= 3.0.3, PHP 4 )
hw_Document_BodyTag -- body tag of hw_document
Description
string hw_document_bodytag ( int hw_document)
Returns the BODY tag of the document. If the document is an HTML document 
the BODY tag should be printed before the document. 
See also hw_document_attributes(), and hw_document_size(). 
For backward compatibility, hw_documentbodytag() is also accepted. This is 
deprecated, however.   hw_Document_AttributesUphw_Document_Content
#

#T=string hw_document_bodytag ( int hw_document)
hw_document_bodytag ( ^!int hw_document);
#

#T=hw_Document_Content - string hw_document_content ( int hw_document)
(PHP 3>= 3.0.3, PHP 4 )
hw_Document_Content -- returns content of hw_document
Description
string hw_document_content ( int hw_document)
Returns the content of the document. If the document is an HTML document 
the content is everything after the BODY tag. Information from the HEAD 
and BODY tag is in the stored in the object record. 
See also hw_document_attributes(), hw_document_size(), and 
hw_document_setcontent().   hw_Document_BodyTagUphw_Document_SetContent
#

#T=string hw_document_content ( int hw_document)
hw_document_content ( ^!int hw_document);
#

#T=hw_Document_SetContent - string hw_document_setcontent ( int hw_document, string content)
(PHP 4 )
hw_Document_SetContent -- sets/replaces content of hw_document
Description
string hw_document_setcontent ( int hw_document, string content)
Sets or replaces the content of the document. If the document is an HTML 
document the content is everything after the BODY tag. Information from 
the HEAD and BODY tag is in the stored in the object record. If you 
provide this information in the content of the document too, the Hyperwave 
server will change the object record accordingly when the document is 
inserted. Probably not a very good idea. If this functions fails the 
document will retain its old content. 
See also hw_document_attributes(), hw_document_size(), and 
hw_document_content().   hw_Document_ContentUphw_Document_Size
#

#T=string hw_document_setcontent ( int hw_document, string content)
hw_document_setcontent ( ^!int hw_document, string content);
#

#T=hw_Document_Size - int hw_document_size ( int hw_document)
(PHP 3>= 3.0.3, PHP 4 )
hw_Document_Size -- size of hw_document
Description
int hw_document_size ( int hw_document)
Returns the size in bytes of the document.
See also hw_document_bodytag(), and hw_document_attributes(). 
For backward compatibility, hw_documentsize() is also accepted. This is 
deprecated, however.   hw_Document_SetContentUphw_dummy
#

#T=int hw_document_size ( int hw_document)
hw_document_size ( ^!int hw_document);
#

#T=hw_dummy - string hw_dummy ( int link, int id, int msgid)
(PHP 3>= 3.0.3, PHP 4 )
hw_dummy --  Hyperwave dummy function 
Description
string hw_dummy ( int link, int id, int msgid)
Warning
This function is currently not documented; only the argument list is 
available.
  hw_Document_SizeUphw_EditText
#

#T=string hw_dummy ( int link, int id, int msgid)
hw_dummy ( ^!int link, int id, int msgid);
#

#T=hw_EditText - int hw_edittext ( int connection, int hw_document)
(PHP 3>= 3.0.3, PHP 4 )
hw_EditText -- retrieve text document
Description
int hw_edittext ( int connection, int hw_document)
Uploads the text document to the server. The object record of the document 
may not be modified while the document is edited. This function will only 
works for pure text documents. It will not open a special data connection 
and therefore blocks the control connection during the transfer. 
See also hw_pipedocument(), hw_free_document(), hw_document_bodytag(), 
hw_document_size(), hw_output_document(), and hw_gettext().   hw_dummyUphw_Error
#

#T=int hw_edittext ( int connection, int hw_document)
hw_edittext ( ^!int connection, int hw_document);
#

#T=hw_Error - int hw_error ( int connection)
(PHP 3>= 3.0.3, PHP 4 )
hw_Error -- error number
Description
int hw_error ( int connection)
Returns the last error number. If the return value is 0 no error has 
occurred. The error relates to the last command.   hw_EditTextUphw_ErrorMsg
#

#T=int hw_error ( int connection)
hw_error ( ^!int connection);
#

#T=hw_ErrorMsg - string hw_errormsg ( int connection)
(PHP 3>= 3.0.3, PHP 4 )
hw_ErrorMsg -- returns error message
Description
string hw_errormsg ( int connection)
Returns a string containing the last error message or 'No Error'. If FALSE 
is returned, this function failed. The message relates to the last 
command.   hw_ErrorUphw_Free_Document
#

#T=string hw_errormsg ( int connection)
hw_errormsg ( ^!int connection);
#

#T=hw_Free_Document - int hw_free_document ( int hw_document)
(PHP 3>= 3.0.3, PHP 4 )
hw_Free_Document -- frees hw_document
Description
int hw_free_document ( int hw_document)
Frees the memory occupied by the Hyperwave document.   hw_ErrorMsgUphw_GetAnchors
#

#T=int hw_free_document ( int hw_document)
hw_free_document ( ^!int hw_document);
#

#T=hw_GetAnchors - array hw_getanchors ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetAnchors -- object ids of anchors of document
Description
array hw_getanchors ( int connection, int objectID)
Returns an array of object ids with anchors of the document with object ID 
objectID.   hw_Free_DocumentUphw_GetAnchorsObj
#

#T=array hw_getanchors ( int connection, int objectID)
hw_getanchors ( ^!int connection, int objectID);
#

#T=hw_GetAnchorsObj - array hw_getanchorsobj ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetAnchorsObj -- object records of anchors of document
Description
array hw_getanchorsobj ( int connection, int objectID)
Returns an array of object records with anchors of the document with 
object ID objectID.   hw_GetAnchorsUphw_GetAndLock
#

#T=array hw_getanchorsobj ( int connection, int objectID)
hw_getanchorsobj ( ^!int connection, int objectID);
#

#T=hw_GetAndLock - string hw_getandlock ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetAndLock -- return object record and lock object
Description
string hw_getandlock ( int connection, int objectID)
Returns the object record for the object with ID objectID. It will also 
lock the object, so other users cannot access it until it is unlocked. 
See also hw_unlock(), and hw_getobject().   hw_GetAnchorsObjUphw_GetChildColl
#

#T=string hw_getandlock ( int connection, int objectID)
hw_getandlock ( ^!int connection, int objectID);
#

#T=hw_GetChildColl - array hw_getchildcoll ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetChildColl -- object ids of child collections
Description
array hw_getchildcoll ( int connection, int objectID)
Returns an array of object ids. Each object ID belongs to a child 
collection of the collection with ID objectID. The function will not 
return child documents.
See also hw_children(), and hw_getchilddoccoll().   hw_GetAndLockUphw_GetChildCollObj
#

#T=array hw_getchildcoll ( int connection, int objectID)
hw_getchildcoll ( ^!int connection, int objectID);
#

#T=hw_GetChildCollObj - array hw_getchildcollobj ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetChildCollObj -- object records of child collections
Description
array hw_getchildcollobj ( int connection, int objectID)
Returns an array of object records. Each object records belongs to a child 
collection of the collection with ID objectID. The function will not 
return child documents. 
See also hw_childrenobj(), and hw_getchilddoccollobj().   hw_GetChildCollUphw_GetChildDocColl
#

#T=array hw_getchildcollobj ( int connection, int objectID)
hw_getchildcollobj ( ^!int connection, int objectID);
#

#T=hw_GetChildDocColl - array hw_getchilddoccoll ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetChildDocColl -- object ids of child documents of collection
Description
array hw_getchilddoccoll ( int connection, int objectID)
Returns array of object ids for child documents of a collection. 
See also hw_children(), and hw_getchildcoll().   hw_GetChildCollObjUphw_GetChildDocCollObj
#

#T=array hw_getchilddoccoll ( int connection, int objectID)
hw_getchilddoccoll ( ^!int connection, int objectID);
#

#T=hw_GetChildDocCollObj - array hw_getchilddoccollobj ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetChildDocCollObj -- object records of child documents of collection
Description
array hw_getchilddoccollobj ( int connection, int objectID)
Returns an array of object records for child documents of a collection.
See also hw_childrenobj(), and hw_getchildcollobj().   hw_GetChildDocCollUphw_GetObject
#

#T=array hw_getchilddoccollobj ( int connection, int objectID)
hw_getchilddoccollobj ( ^!int connection, int objectID);
#

#T=hw_GetObject - array hw_getobject ( int connection, mixed objectID, string query)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetObject -- object record
Description
array hw_getobject ( int connection, mixed objectID, string query)
Returns the object record for the object with ID objectID if the second 
parameter is an integer. If the second parameter is an array of integer 
the function will return an array of object records. In such a case the 
last parameter is also evaluated which is a query string. 
The query string has the following syntax:
<expr> ::= "(" <expr> ")" |
"!" <expr> | /* NOT */
<expr> "||" <expr> | /* OR */
<expr> "&&" <expr> | /* AND */
<attribute> <operator> <value>
<attribute> ::= /* any attribute name (Title, Author, DocumentType ...) */
<operator> ::= "=" | /* equal */
"<" | /* less than (string compare) */
">" | /* greater than (string compare) */
"~" /* regular expression matching */
The query allows to further select certain objects from the list of given 
objects. Unlike the other query functions, this query may use not indexed 
attributes. How many object records are returned depends on the query and 
if access to the object is allowed. 
See also hw_getandlock(), and hw_getobjectbyquery().   hw_GetChildDocCollObjUphw_GetObjectByQuery
#

#T=array hw_getobject ( int connection, mixed objectID, string query)
hw_getobject ( ^!int connection, mixed objectID, string query);
#

#T=hw_GetObjectByQuery - array hw_getobjectbyquery ( int connection, string query, int max_hits)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetObjectByQuery -- search object
Description
array hw_getobjectbyquery ( int connection, string query, int max_hits)
Searches for objects on the whole server and returns an array of object 
ids. The maximum number of matches is limited to max_hits. If max_hits is 
set to -1 the maximum number of matches is unlimited. 
The query will only work with indexed attributes. 
See also hw_getobjectbyqueryobj().   hw_GetObjectUphw_GetObjectByQueryColl
#

#T=array hw_getobjectbyquery ( int connection, string query, int max_hits)
hw_getobjectbyquery ( ^!int connection, string query, int max_hits);
#

#T=hw_GetObjectByQueryColl - array hw_getobjectbyquerycoll ( int connection, int objectID, string 
(PHP 3>= 3.0.3, PHP 4 )
hw_GetObjectByQueryColl -- search object in collection
Description
array hw_getobjectbyquerycoll ( int connection, int objectID, string 
query, int max_hits)
Searches for objects in collection with ID objectID and returns an array 
of object ids. The maximum number of matches is limited to max_hits. If 
max_hits is set to -1 the maximum number of matches is unlimited. 
The query will only work with indexed attributes.
See also hw_getobjectbyquerycollobj().   hw_GetObjectByQueryUphw_GetObjectByQueryCollObj
#

#T=array hw_getobjectbyquerycoll ( int connection, int objectID, string 
hw_getobjectbyquerycoll ( ^!int connection, int objectID, string ;
#

#T=hw_GetObjectByQueryCollObj - array hw_getobjectbyquerycollobj ( int connection, int objectID, string 
(PHP 3>= 3.0.3, PHP 4 )
hw_GetObjectByQueryCollObj -- search object in collection
Description
array hw_getobjectbyquerycollobj ( int connection, int objectID, string 
query, int max_hits)
Searches for objects in collection with ID objectID and returns an array 
of object records. The maximum number of matches is limited to max_hits. 
If max_hits is set to -1 the maximum number of matches is unlimited. 
The query will only work with indexed attributes. 
See also hw_getobjectbyquerycoll().   hw_GetObjectByQueryCollUphw_GetObjectByQueryObj
#

#T=array hw_getobjectbyquerycollobj ( int connection, int objectID, string 
hw_getobjectbyquerycollobj ( ^!int connection, int objectID, string ;
#

#T=hw_GetObjectByQueryObj - array hw_getobjectbyqueryobj ( int connection, string query, int max_hits)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetObjectByQueryObj -- search object
Description
array hw_getobjectbyqueryobj ( int connection, string query, int max_hits)
Searches for objects on the whole server and returns an array of object 
records. The maximum number of matches is limited to max_hits. If max_hits 
is set to -1 the maximum number of matches is unlimited. 
The query will only work with indexed attributes. 
See also hw_getobjectbyquery().   hw_GetObjectByQueryCollObjUphw_GetParents
#

#T=array hw_getobjectbyqueryobj ( int connection, string query, int max_hits)
hw_getobjectbyqueryobj ( ^!int connection, string query, int max_hits);
#

#T=hw_GetParents - array hw_getparents ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetParents -- object ids of parents
Description
array hw_getparents ( int connection, int objectID)
Returns an indexed array of object ids. Each object id belongs to a parent 
of the object with ID objectID.   hw_GetObjectByQueryObjUphw_GetParentsObj
#

#T=array hw_getparents ( int connection, int objectID)
hw_getparents ( ^!int connection, int objectID);
#

#T=hw_GetParentsObj - array hw_getparentsobj ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetParentsObj -- object records of parents
Description
array hw_getparentsobj ( int connection, int objectID)
Returns an indexed array of object records plus an associated array with 
statistical information about the object records. The associated array is 
the last entry of the returned array. Each object record belongs to a 
parent of the object with ID objectID.   hw_GetParentsUphw_getrellink
#

#T=array hw_getparentsobj ( int connection, int objectID)
hw_getparentsobj ( ^!int connection, int objectID);
#

#T=hw_getrellink - string hw_getrellink ( int link, int rootid, int sourceid, int destid)
(PHP 3>= 3.0.3, PHP 4 )
hw_getrellink --  Get link from source to dest relative to rootid 
Description
string hw_getrellink ( int link, int rootid, int sourceid, int destid)
Warning
This function is currently not documented; only the argument list is 
available.
  hw_GetParentsObjUphw_GetRemote
#

#T=string hw_getrellink ( int link, int rootid, int sourceid, int destid)
hw_getrellink ( ^!int link, int rootid, int sourceid, int destid);
#

#T=hw_GetRemote - int hw_getremote ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetRemote -- Gets a remote document
Description
int hw_getremote ( int connection, int objectID)
Returns a remote document. Remote documents in Hyperwave notation are 
documents retrieved from an external source. Common remote documents are 
for example external web pages or queries in a database. In order to be 
able to access external sources through remote documents Hyperwave 
introduces the HGI (Hyperwave Gateway Interface) which is similar to the 
CGI. Currently, only ftp, http-servers and some databases can be accessed 
by the HGI. Calling hw_getremote() returns the document from the external 
source. If you want to use this function you should be very familiar with 
HGIs. You should also consider to use PHP instead of Hyperwave to access 
external sources. Adding database support by a Hyperwave gateway should be 
more difficult than doing it in PHP. 
See also hw_getremotechildren().   hw_getrellinkUphw_getremotechildren
#

#T=int hw_getremote ( int connection, int objectID)
hw_getremote ( ^!int connection, int objectID);
#

#T=hw_getremotechildren - int hw_getremotechildren ( int connection, string object_record)
(PHP 3>= 3.0.3, PHP 4 )
hw_getremotechildren -- Gets children of remote document
Description
int hw_getremotechildren ( int connection, string object_record)
Returns the children of a remote document. Children of a remote document 
are remote documents itself. This makes sense if a database query has to 
be narrowed and is explained in Hyperwave Programmers' Guide. If the 
number of children is 1 the function will return the document itself 
formated by the Hyperwave Gateway Interface (HGI). If the number of 
children is greater than 1 it will return an array of object record with 
each maybe the input value for another call to hw_getremotechildren(). 
Those object records are virtual and do not exist in the Hyperwave server, 
therefore they do not have a valid object ID. How exactly such an object 
record looks like is up to the HGI. If you want to use this function you 
should be very familiar with HGIs. You should also consider to use PHP 
instead of Hyperwave to access external sources. Adding database support 
by a Hyperwave gateway should be more difficult than doing it in PHP. 
See also hw_getremote().   hw_GetRemoteUphw_GetSrcByDestObj
#

#T=int hw_getremotechildren ( int connection, string object_record)
hw_getremotechildren ( ^!int connection, string object_record);
#

#T=hw_GetSrcByDestObj - array hw_getsrcbydestobj ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_GetSrcByDestObj -- Returns anchors pointing at object
Description
array hw_getsrcbydestobj ( int connection, int objectID)
Returns the object records of all anchors pointing to the object with ID 
objectID. The object can either be a document or an anchor of type 
destination.
See also hw_getanchors().   hw_getremotechildrenUphw_GetText
#

#T=array hw_getsrcbydestobj ( int connection, int objectID)
hw_getsrcbydestobj ( ^!int connection, int objectID);
#

#T=hw_GetText - int hw_gettext ( int connection, int objectID [, mixed rootID/prefix])
(PHP 3>= 3.0.3, PHP 4 )
hw_GetText -- retrieve text document
Description
int hw_gettext ( int connection, int objectID [, mixed rootID/prefix])
Returns the document with object ID objectID. If the document has anchors 
which can be inserted, they will be inserted already. The optional 
parameter rootID/prefix can be a string or an integer. If it is an integer 
it determines how links are inserted into the document. The default is 0 
and will result in links that are constructed from the name of the link's 
destination object. This is useful for web applications. If a link points 
to an object with name 'internet_movie' the HTML link will be <A 
HREF="/internet_movie">. The actual location of the source and destination 
object in the document hierarchy is disregarded. You will have to set up 
your web browser, to rewrite that URL to for example 
'/my_script.php3/internet_movie'. 'my_script.php3' will have to evaluate 
$PATH_INFO and retrieve the document. All links will have the prefix 
'/my_script.php3/'. If you do not want this you can set the optional 
parameter rootID/prefix to any prefix which is used instead. Is this case 
it has to be a string. 
If rootID/prefix is an integer and unequal to 0 the link is constructed 
from all the names starting at the object with the id rootID/prefix 
separated by a slash relative to the current object. If for example the 
above document 'internet_movie' is located at 'a-b-c-internet_movie' with 
'-' being the separator between hierarchy levels on the Hyperwave server 
and the source document is located at 'a-b-d-source' the resulting HTML 
link would be: <A HREF="../c/internet_movie">. This is useful if you want 
to download the whole server content onto disk and map the document 
hierarchy onto the file system. 
This function will only work for pure text documents. It will not open a 
special data connection and therefore blocks the control connection during 
the transfer. 
See also hw_pipedocument(), hw_free_document(), hw_document_bodytag(), 
hw_document_size(), and hw_output_document().   hw_GetSrcByDestObjUphw_getusername
#

#T=int hw_gettext ( int connection, int objectID [, mixed rootID/prefix])
hw_gettext ( ^!int connection, int objectID [, mixed rootID/prefix]);
#

#T=hw_getusername - string hw_getusername ( int connection)
(PHP 3>= 3.0.3, PHP 4 )
hw_getusername -- name of currently logged in user
Description
string hw_getusername ( int connection)
Returns the username of the connection.   hw_GetTextUphw_Identify
#

#T=string hw_getusername ( int connection)
hw_getusername ( ^!int connection);
#

#T=hw_Identify - int hw_identify ( string username, string password)
(PHP 3>= 3.0.3, PHP 4 )
hw_Identify -- identifies as user
Description
int hw_identify ( string username, string password)
Identifies as user with username and password. Identification is only 
valid for the current session. I do not thing this function will be needed 
very often. In most cases it will be easier to identify with the opening 
of the connection. 
See also hw_connect().   hw_getusernameUphw_InCollections
#

#T=int hw_identify ( string username, string password)
hw_identify ( ^!string username, string password);
#

#T=hw_InCollections - array hw_incollections ( int connection, array object_id_array, array 
(PHP 3>= 3.0.3, PHP 4 )
hw_InCollections -- check if object ids in collections
Description
array hw_incollections ( int connection, array object_id_array, array 
collection_id_array, int return_collections)
Checks whether a set of objects (documents or collections) specified by 
the object_id_array is part of the collections listed in 
collection_id_array. When the fourth parameter return_collections is 0, 
the subset of object ids that is part of the collections (i.e., the 
documents or collections that are children of one or more collections of 
collection ids or their subcollections, recursively) is returned as an 
array. When the fourth parameter is 1, however, the set of collections 
that have one or more objects of this subset as children are returned as 
an array. This option allows a client to, e.g., highlight the part of the 
collection hierarchy that contains the matches of a previous query, in a 
graphical overview.   hw_IdentifyUphw_Info
#

#T=array hw_incollections ( int connection, array object_id_array, array 
hw_incollections ( ^!int connection, array object_id_array, array ;
#

#T=hw_Info - string hw_info ( int connection)
(PHP 3>= 3.0.3, PHP 4 )
hw_Info -- info about connection
Description
string hw_info ( int connection)
Returns information about the current connection. The returned string has 
the following format: <Serverstring>, <Host>, <Port>, <Username>, <Port of 
Client>, <Byte swapping>   hw_InCollectionsUphw_InsColl
#

#T=string hw_info ( int connection)
hw_info ( ^!int connection);
#

#T=hw_InsColl - int hw_inscoll ( int connection, int objectID, array object_array)
(PHP 3>= 3.0.3, PHP 4 )
hw_InsColl -- insert collection
Description
int hw_inscoll ( int connection, int objectID, array object_array)
Inserts a new collection with attributes as in object_array into 
collection with object ID objectID.   hw_InfoUphw_InsDoc
#

#T=int hw_inscoll ( int connection, int objectID, array object_array)
hw_inscoll ( ^!int connection, int objectID, array object_array);
#

#T=hw_InsDoc - int hw_insdoc ( int connection, int parentID, string object_record, string 
(PHP 3>= 3.0.3, PHP 4 )
hw_InsDoc -- insert document
Description
int hw_insdoc ( int connection, int parentID, string object_record, string 
text)
Inserts a new document with attributes as in object_record into collection 
with object ID parentID. This function inserts either an object record 
only or an object record and a pure ascii text in text if text is given. 
If you want to insert a general document of any kind use 
hw_insertdocument() instead. 
See also hw_insertdocument(), and hw_inscoll().   hw_InsCollUphw_insertanchors
#

#T=int hw_insdoc ( int connection, int parentID, string object_record, string 
hw_insdoc ( ^!int connection, int parentID, string object_record, string ;
#

#T=hw_insertanchors - string hw_insertanchors ( int hwdoc, array anchorecs, array dest [, array 
(PHP 4 >= 4.0.4)
hw_insertanchors --  Inserts only anchors into text 
Description
string hw_insertanchors ( int hwdoc, array anchorecs, array dest [, array 
urlprefixes])
Warning
This function is currently not documented; only the argument list is 
available.
  hw_InsDocUphw_InsertDocument
#

#T=string hw_insertanchors ( int hwdoc, array anchorecs, array dest [, array 
hw_insertanchors ( ^!int hwdoc, array anchorecs, array dest [, array ;
#

#T=hw_InsertDocument - int hw_insertdocument ( int connection, int parent_id, int hw_document)
(PHP 3>= 3.0.3, PHP 4 )
hw_InsertDocument -- upload any document
Description
int hw_insertdocument ( int connection, int parent_id, int hw_document)
Uploads a document into the collection with parent_id. The document has to 
be created before with hw_new_document(). Make sure that the object record 
of the new document contains at least the attributes: Type, DocumentType, 
Title and Name. Possibly you also want to set the MimeType. The functions 
returns the object id of the new document or FALSE. 
See also hw_pipedocument().   hw_insertanchorsUphw_InsertObject
#

#T=int hw_insertdocument ( int connection, int parent_id, int hw_document)
hw_insertdocument ( ^!int connection, int parent_id, int hw_document);
#

#T=hw_InsertObject - int hw_insertobject ( int connection, string object_rec, string parameter)
(PHP 3>= 3.0.3, PHP 4 )
hw_InsertObject -- inserts an object record
Description
int hw_insertobject ( int connection, string object_rec, string parameter)
Inserts an object into the server. The object can be any valid hyperwave 
object. See the HG-CSP documentation for a detailed information on how the 
parameters have to be. 
Note: If you want to insert an Anchor, the attribute Position has always 
been set either to a start/end value or to 'invisible'. Invisible 
positions are needed if the annotation has no corresponding link in the 
annotation text. 
See also hw_pipedocument(), hw_insertdocument(), hw_insdoc(), and 
hw_inscoll().   hw_InsertDocumentUphw_mapid
#

#T=int hw_insertobject ( int connection, string object_rec, string parameter)
hw_insertobject ( ^!int connection, string object_rec, string parameter);
#

#T=hw_mapid - int hw_mapid ( int connection, int server_id, int object_id)
(PHP 3>= 3.0.13, PHP 4 )
hw_mapid -- Maps global id on virtual local id
Description
int hw_mapid ( int connection, int server_id, int object_id)
Maps a global object id on any hyperwave server, even those you did not 
connect to with hw_connect(), onto a virtual object id. This virtual 
object id can then be used as any other object id, e.g. to obtain the 
object record with hw_getobject(). The server id is the first part of the 
global object id (GOid) of the object which is actually the IP number as 
an integer. 
Note: In order to use this function you will have to set the F_DISTRIBUTED 
flag, which can currently only be set at compile time in hg_comm.c. It is 
not set by default. Read the comment at the beginning of hg_comm.c   hw_InsertObjectUphw_Modifyobject
#

#T=int hw_mapid ( int connection, int server_id, int object_id)
hw_mapid ( ^!int connection, int server_id, int object_id);
#

#T=hw_Modifyobject - int hw_modifyobject ( int connection, int object_to_change, array remove, 
(PHP 3>= 3.0.7, PHP 4 )
hw_Modifyobject -- modifies object record
Description
int hw_modifyobject ( int connection, int object_to_change, array remove, 
array add, int mode)
This command allows to remove, add, or modify individual attributes of an 
object record. The object is specified by the Object ID object_to_change. 
The first array remove is a list of attributes to remove. The second array 
add is a list of attributes to add. In order to modify an attribute one 
will have to remove the old one and add a new one. hw_modifyobject() will 
always remove the attributes before it adds attributes unless the value of 
the attribute to remove is not a string or array. 
The last parameter determines if the modification is performed 
recursively. 1 means recursive modification. If some of the objects cannot 
be modified they will be skipped without notice. hw_error() may not 
indicate an error though some of the objects could not be modified. 
The keys of both arrays are the attributes name. The value of each array 
element can either be an array, a string or anything else. If it is an 
array each attribute value is constructed by the key of each element plus 
a colon and the value of each element. If it is a string it is taken as 
the attribute value. An empty string will result in a complete removal of 
that attribute. If the value is neither a string nor an array but 
something else, e.g. an integer, no operation at all will be performed on 
the attribute. This is necessary if you want to to add a completely new 
attribute not just a new value for an existing attribute. If the remove 
array contained an empty string for that attribute, the attribute would be 
tried to be removed which would fail since it doesn't exist. The following 
addition of a new value for that attribute would also fail. Setting the 
value for that attribute to e.g. 0 would not even try to remove it and the 
addition will work. 
If you would like to change the attribute 'Name' with the current value 
'books' into 'articles' you will have to create two arrays and call 
hw_modifyobject(). Example 1. modifying an attribute
  <?php
	 // $connect is an existing connection to the Hyperwave 
  server
	 // $objid is the ID of the object to modify
	 $remarr = array("Name" => "books");
	 $addarr = array("Name" => "articles");
	 $hw_modifyobject($connect, $objid, $remarr, $addarr);
  ?> 

In order to delete/add a name=value pair from/to the object record just 
pass the remove/add array and set the last/third parameter to an empty 
array. If the attribute is the first one with that name to add, set 
attribute value in the remove array to an integer. Example 2. adding 
a completely new attribute
  <?php
	 // $connect is an existing connection to the Hyperwave 
  server
	 // $objid is the ID of the object to modify
	 $remarr = array("Name" => 0);
	 $addarr = array("Name" => "articles");
	 $hw_modifyobject($connect, $objid, $remarr, $addarr);
  ?> 
Note: Multilingual attributes, e.g. 'Title', can be modified in two 
ways. Either by providing the attributes value in its native form 
'language':'title' or by providing an array with elements for each 
language as described above. The above example would than be: 
Example 3. modifying Title attribute
  <?php
	 $remarr = array("Title" => "en:Books");
	 $addarr = array("Title" => "en:Articles");
	 $hw_modifyobject($connect, $objid, $remarr, $addarr);
  ?> 

or Example 4. modifying Title attribute
  <?php
	 $remarr = array("Title" => array("en" => "Books"));
	 $addarr = array("Title" => array("en" => "Articles", 
  "ge"=>"Artikel"));
	 $hw_modifyobject($connect, $objid, $remarr, $addarr);
  ?> 

This removes the English title 'Books' and adds the English title 
'Articles' and the German title 'Artikel'. Example 5. removing 
attribute
  <?php
	 $remarr = array("Title" => "");
	 $addarr = array("Title" => "en:Articles");
	 $hw_modifyobject($connect, $objid, $remarr, $addarr);
  ?> 
Note: This will remove all attributes with the name 'Title' and adds a 
new 'Title' attribute. This comes in handy if you want to remove 
attributes recursively. 
Note: If you need to delete all attributes with a certain name you will 
have to pass an empty string as the attribute value. 
Note: Only the attributes 'Title', 'Description' and 'Keyword' will 
properly handle the language prefix. If those attributes don't carry a 
language prefix, the prefix 'xx' will be assigned. 
Note: The 'Name' attribute is somewhat special. In some cases it cannot 
be complete removed. You will get an error message 'Change of base 
attribute' (not clear when this happens). Therefore you will always have 
to add a new Name first and than remove the old one. 
Note: You may not surround this function by calls to hw_getandlock() and 
hw_unlock(). hw_modifyobject() does this internally. 
Returns TRUE on success or FALSE on failure.   hw_mapidUphw_mv
#

#T=int hw_modifyobject ( int connection, int object_to_change, array remove, 
hw_modifyobject ( ^!int connection, int object_to_change, array remove, ;
#

#T=hw_mv - int hw_mv ( int connection, array object_id_array, int source_id, int 
(PHP 3>= 3.0.3, PHP 4 )
hw_mv -- Moves objects
Description
int hw_mv ( int connection, array object_id_array, int source_id, int 
destination_id)
Moves the objects with object ids as specified in the second parameter 
from the collection with id source_id to the collection with the id 
destination_id. If the destination id is 0 the objects will be unlinked 
from the source collection. If this is the last instance of that object it 
will be deleted. If you want to delete all instances at once, use 
hw_deleteobject(). 
The value returned is the number of moved objects. 
See also hw_cp(), and hw_deleteobject().   hw_ModifyobjectUphw_New_Document
#

#T=int hw_mv ( int connection, array object_id_array, int source_id, int 
hw_mv ( ^!int connection, array object_id_array, int source_id, int ;
#

#T=hw_New_Document - int hw_new_document ( string object_record, string document_data, int 
(PHP 3>= 3.0.3, PHP 4 )
hw_New_Document -- create new document
Description
int hw_new_document ( string object_record, string document_data, int 
document_size)
Returns a new Hyperwave document with document data set to document_data 
and object record set to object_record. The length of the document_data 
has to passed in document_sizeThis function does not insert the document 
into the Hyperwave server. 
See also hw_free_document(), hw_document_size(), hw_document_bodytag(), 
hw_output_document(), and hw_insertdocument().   hw_mvUphw_objrec2array
#

#T=int hw_new_document ( string object_record, string document_data, int 
hw_new_document ( ^!string object_record, string document_data, int ;
#

#T=hw_objrec2array - array hw_objrec2array ( string object_record [, array format])
(PHP 3>= 3.0.3, PHP 4 )
hw_objrec2array -- Convert attributes from object record to object array
Description
array hw_objrec2array ( string object_record [, array format])
Converts an object_record into an object array. The keys of the resulting 
array are the attributes names. Multi-value attributes like 'Title' in 
different languages form its own array. The keys of this array are the 
left part to the colon of the attribute value. This left part must be two 
characters long. Other multi-value attributes without a prefix form an 
indexed array. If the optional parameter is missing the attributes 
'Title', 'Description' and 'Keyword' are treated as language attributes 
and the attributes 'Group', 'Parent' and 'HtmlAttr' as non-prefixed 
multi-value attributes. By passing an array holding the type for each 
attribute you can alter this behaviour. The array is an associated array 
with the attribute name as its key and the value being one of HW_ATTR_LANG 
or HW_ATTR_NONE. 
See also hw_array2objrec().   hw_New_DocumentUphw_Output_Document
#

#T=array hw_objrec2array ( string object_record [, array format])
hw_objrec2array ( ^!string object_record [, array format]);
#

#T=hw_Output_Document - int hw_output_document ( int hw_document)
(PHP 3>= 3.0.3, PHP 4 )
hw_Output_Document -- prints hw_document
Description
int hw_output_document ( int hw_document)
Prints the document without the BODY tag. 
For backward compatibility, hw_outputdocument() is also accepted. This is 
deprecated, however.   hw_objrec2arrayUphw_pConnect
#

#T=int hw_output_document ( int hw_document)
hw_output_document ( ^!int hw_document);
#

#T=hw_pConnect - int hw_pconnect ( string host, int port, string username, string password)
(PHP 3>= 3.0.3, PHP 4 )
hw_pConnect -- make a persistent database connection
Description
int hw_pconnect ( string host, int port, string username, string password)
Returns a connection index on success, or FALSE if the connection could 
not be made. Opens a persistent connection to a Hyperwave server. Each of 
the arguments should be a quoted string, except for the port number. The 
username and password arguments are optional and can be left out. In such 
a case no identification with the server will be done. It is similar to 
identify as user anonymous. This function returns a connection index that 
is needed by other Hyperwave functions. You can have multiple persistent 
connections open at once.
See also hw_connect().   hw_Output_DocumentUphw_PipeDocument
#

#T=int hw_pconnect ( string host, int port, string username, string password)
hw_pconnect ( ^!string host, int port, string username, string password);
#

#T=hw_PipeDocument - int hw_pipedocument ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_PipeDocument -- retrieve any document
Description
int hw_pipedocument ( int connection, int objectID)
Returns the Hyperwave document with object ID objectID. If the document 
has anchors which can be inserted, they will have been inserted already. 
The document will be transferred via a special data connection which does 
not block the control connection.
See also hw_gettext() for more on link insertion, hw_free_document(), 
hw_document_size(), hw_document_bodytag(), and hw_output_document().   hw_pConnectUphw_Root
#

#T=int hw_pipedocument ( int connection, int objectID)
hw_pipedocument ( ^!int connection, int objectID);
#

#T=hw_Root - int hw_root ( )
(PHP 3>= 3.0.3, PHP 4 )
hw_Root -- root object id
Description
int hw_root ( )
Returns the object ID of the hyperroot collection. Currently this is 
always 0. The child collection of the hyperroot is the root collection of 
the connected server.   hw_PipeDocumentUphw_setlinkroot
#

#T=int hw_root ( )
hw_root ( ^!);
#

#T=hw_setlinkroot - void hw_setlinkroot ( int link, int rootid)
(PHP 3>= 3.0.3, PHP 4 )
hw_setlinkroot --  Set the id to which links are calculated 
Description
void hw_setlinkroot ( int link, int rootid)
Warning
This function is currently not documented; only the argument list is 
available.
  hw_RootUphw_stat
#

#T=void hw_setlinkroot ( int link, int rootid)
hw_setlinkroot ( ^!int link, int rootid);
#

#T=hw_stat - string hw_stat ( int link)
(PHP 3>= 3.0.3, PHP 4 )
hw_stat --  Returns status string 
Description
string hw_stat ( int link)
Warning
This function is currently not documented; only the argument list is 
available.
  hw_setlinkrootUphw_Unlock
#

#T=string hw_stat ( int link)
hw_stat ( ^!int link);
#

#T=hw_Unlock - int hw_unlock ( int connection, int objectID)
(PHP 3>= 3.0.3, PHP 4 )
hw_Unlock -- unlock object
Description
int hw_unlock ( int connection, int objectID)
Unlocks a document, so other users regain access. 
See also hw_getandlock().   hw_statUphw_Who
#

#T=int hw_unlock ( int connection, int objectID)
hw_unlock ( ^!int connection, int objectID);
#

#T=hw_Who - int hw_who ( int connection)
(PHP 3>= 3.0.3, PHP 4 )
hw_Who -- List of currently logged in users
Description
int hw_who ( int connection)
Returns an array of users currently logged into the Hyperwave server. Each 
entry in this array is an array itself containing the elements id, name, 
system, onSinceDate, onSinceTime, TotalTime and self. 'self' is 1 if this 
entry belongs to the user who initiated the request.   hw_UnlockUpHyperwave API functions
hw_api_attribute->key
(no version information, might be only in CVS)
hw_api_attribute->key -- Returns key of the attribute
Description
string key ( void )
Returns the name of the attribute. 
See also hwapi_attribute_value().   Hyperwave API functionsUphw_api_attribute->langdepvalue
hw_api_attribute->langdepvalue
(no version information, might be only in CVS)
hw_api_attribute->langdepvalue -- Returns value for a given language
Description
string langdepvalue ( string language)
Returns the value in the given language of the attribute. 
See also hwapi_attribute_value().   hw_api_attribute->keyUphw_api_attribute->value
hw_api_attribute->value
(no version information, might be only in CVS)
hw_api_attribute->value -- Returns value of the attribute
Description
string value ( void )
Returns the value of the attribute. 
See also hwapi_attribute_key(), hwapi_attribute_values().   hw_api_attribute->langdepvalueUphw_api_attribute->values
hw_api_attribute->values
(no version information, might be only in CVS)
hw_api_attribute->values -- Returns all values of the attribute
Description
array values ( void )
Returns all values of the attribute as an array of strings. 
See also hwapi_attribute_value().   hw_api_attribute->valueUphw_api_attribute
hw_api_attribute
(no version information, might be only in CVS)
hw_api_attribute -- Creates instance of class hw_api_attribute
Description
object attribute ( [string name [, string value]])
Creates a new instance of hw_api_attribute with the given name and value.   hw_api_attribute->valuesUphw_api->checkin
hw_api->checkin
(no version information, might be only in CVS)
hw_api->checkin -- Checks in an object
Description
object checkin ( array parameter)
This function checks in an object or a whole hiearchie of objects. The 
parameters array contains the required element 'objectIdentifier' and the 
optional element 'version', 'comment', 'mode' and 'objectQuery'. 'version' 
sets the version of the object. It consists of the major and minor version 
separated by a period. If the version is not set, the minor version is 
incremented. 'mode' can be one of the following values: 
HW_API_CHECKIN_NORMAL
Checks in and commits the object. The object must be a document. 
HW_API_CHECKIN_RECURSIVE
If the object to check in is a collection, all children will be checked 
in recursively if they are documents. Trying to check in a collection 
would result in an error. 
HW_API_CHECKIN_FORCE_VERSION_CONTROL
Checks in an object even if it is not under version control. 
HW_API_CHECKIN_REVERT_IF_NOT_CHANGED
Check if the new version is different from the last version. Unless this 
is the case the object will be checked in. 
HW_API_CHECKIN_KEEP_TIME_MODIFIED
Keeps the time modified from the most recent object. 
HW_API_CHECKIN_NO_AUTO_COMMIT
The object is not automatically committed on check-in. 
See also hwapi_checkout().   hw_api_attributeUphw_api->checkout
hw_api->checkout
(no version information, might be only in CVS)
hw_api->checkout -- Checks out an object
Description
object checkout ( array parameter)
This function checks out an object or a whole hiearchie of objects. The 
parameters array contains the required element 'objectIdentifier' and the 
optional element 'version', 'mode' and 'objectQuery'. 'mode' can be one of 
the following values: 
HW_API_CHECKIN_NORMAL
Checks out an object. The object must be a document. 
HW_API_CHECKIN_RECURSIVE
If the object to check out is a collection, all children will be checked 
out recursively if they are documents. Trying to check out a collection 
would result in an error. 
See also hwapi_checkin().   hw_api->checkinUphw_api->children
hw_api->children
(no version information, might be only in CVS)
hw_api->children -- Returns children of an object
Description
array children ( array parameter)
Retrieves the children of a collection or the attributes of a document. 
The children can be further filtered by specifying an object query. The 
parameter array contains the required elements 'objectIdentifier' and the 
optional elements 'attributeSelector' and 'objectQuery'. 
The return value is an array of objects of type HW_API_Object or 
HW_API_Error. 
See also hwapi_parents().   hw_api->checkoutUphw_api_content->mimetype
hw_api_content->mimetype
(no version information, might be only in CVS)
hw_api_content->mimetype -- Returns mimetype
Description
string mimetype ( void )
Returns the mimetype of the content.   hw_api->childrenUphw_api_content->read
hw_api_content->read
(no version information, might be only in CVS)
hw_api_content->read -- Read content
Description
string read ( string buffer, integer len)
Reads len bytes from the content into the given buffer.   hw_api_content->mimetypeUphw_api->content
hw_api->content
(no version information, might be only in CVS)
hw_api->content -- Returns content of an object
Description
object content ( array parameter)
This function returns the content of a document as an object of type 
hw_api_content. The parameter array contains the required elements 
'objectidentifier' and the optional element 'mode'. The mode can be one of 
the constants HW_API_CONTENT_ALLLINKS, HW_API_CONTENT_REACHABLELINKS or 
HW_API_CONTENT_PLAIN. HW_API_CONTENT_ALLLINKS means to insert all anchors 
even if the destination is not reachable. HW_API_CONTENT_REACHABLELINKS 
tells hw_api_content() to insert only reachable links and 
HW_API_CONTENT_PLAIN will lead to document without any links.   hw_api_content->readUphw_api->copy
hw_api->copy
(no version information, might be only in CVS)
hw_api->copy -- Copies physically
Description
object copy ( array parameter)
This function will make a physical copy including the content if it exists 
and returns the new object or an error object. The parameter array 
contains the required elements 'objectIdentifier' and 
'destinationParentIdentifier'. The optional parameter is 
'attributeSelector'` 
See also hwapi_move(), hwapi_link().   hw_api->contentUphw_api->dbstat
hw_api->dbstat
(no version information, might be only in CVS)
hw_api->dbstat -- Returns statistics about database server
Description
object dbstat ( array parameter)
See also hwapi_dcstat(), hwapi_hwstat(), hwapi_ftstat().   hw_api->copyUphw_api->dcstat
hw_api->dcstat
(no version information, might be only in CVS)
hw_api->dcstat -- Returns statistics about document cache server
Description
object dcstat ( array parameter)
See also hwapi_hwstat(), hwapi_dbstat(), hwapi_ftstat().   hw_api->dbstatUphw_api->dstanchors
hw_api->dstanchors
(no version information, might be only in CVS)
hw_api->dstanchors -- Returns a list of all destination anchors
Description
object dstanchors ( array parameter)
Retrieves all destination anchors of an object. The parameter array 
contains the required element 'objectIdentifier' and the optional elements 
'attributeSelector' and 'objectQuery'. 
See also hwapi_srcanchors().   hw_api->dcstatUphw_api->dstofsrcanchors
hw_api->dstofsrcanchors
(no version information, might be only in CVS)
hw_api->dstofsrcanchors -- Returns destination of a source anchor
Description
object dstofsrcanchors ( array parameter)
Retrieves the destination object pointed by the specified source anchors. 
The destination object can either be a destination anchor or a whole 
document. The parameters array contains the required element 
'objectIdentifier' and the optional element 'attributeSelector'. 
See also hwapi_srcanchors(), hwapi_dstanchors(), hwapi_objectbyanchor().   hw_api->dstanchorsUphw_api_error->count
hw_api_error->count
(no version information, might be only in CVS)
hw_api_error->count -- Returns number of reasons
Description
int count ( void )
Returns the number of error reasons. 
See also hwapi_error_reason().   hw_api->dstofsrcanchorsUphw_api_error->reason
hw_api_error->reason
(no version information, might be only in CVS)
hw_api_error->reason -- Returns reason of error
Description
object reason ( void )
Returns the first error reason. 
See also hwapi_error_count().   hw_api_error->countUphw_api->find
hw_api->find
(no version information, might be only in CVS)
hw_api->find -- Search for objects
Description
array find ( array parameter)
This functions searches for objects either by executing a key or/and full 
text query. The found objects can further be filtered by an optional 
object query. They are sorted by their importance. The second search 
operation is relatively slow and its result can be limited to a certain 
number of hits. This allows to perform an incremental search, each 
returning just a subset of all found documents, starting at a given index. 
The parameter array contains the 'keyquery' or/and 'fulltextquery' 
depending on who you would like to search. Optional parameters are 
'objectquery', 'scope', 'languages' and 'attributeselector'. In case of an 
incremental search the optional parameters 'startIndex', 
numberOfObjectsToGet' and 'exactMatchUnit' can be passed.   hw_api_error->reasonUphw_api->ftstat
hw_api->ftstat
(no version information, might be only in CVS)
hw_api->ftstat -- Returns statistics about fulltext server
Description
object ftstat ( array parameter)
See also hwapi_dcstat(), hwapi_dbstat(), hwapi_hwstat().   hw_api->findUphwapi_hgcsp
hwapi_hgcsp
(no version information, might be only in CVS)
hwapi_hgcsp -- Returns object of class hw_api
Description
object hwapi_hgcsp ( string hostname [, int port])
Opens a connection to the Hyperwave server on host hostname. The protocol 
used is HGCSP. If you do not pass a port number, 418 is used. 
See also hwapi_hwtp().   hw_api->ftstatUphw_api->hwstat
hw_api->hwstat
(no version information, might be only in CVS)
hw_api->hwstat -- Returns statistics about Hyperwave server
Description
object hwstat ( array parameter)
See also hwapi_dcstat(), hwapi_dbstat(), hwapi_ftstat().   hwapi_hgcspUphw_api->identify
hw_api->identify
(no version information, might be only in CVS)
hw_api->identify -- Log into Hyperwave Server
Description
object identify ( array parameter)
Logs into the Hyperwave Server. The parameter array must contain the 
elements 'username' and 'password'. 
The return value will be an object of type HW_API_Error if identification 
failed or TRUE if it was successful.   hw_api->hwstatUphw_api->info
hw_api->info
(no version information, might be only in CVS)
hw_api->info -- Returns information about server configuration
Description
object info ( array parameter)
See also hwapi_dcstat(), hwapi_dbstat(), hwapi_ftstat(), hwapi_hwstat().   hw_api->identifyUphw_api->insert
hw_api->insert
(no version information, might be only in CVS)
hw_api->insert -- Inserts a new object
Description
object insert ( array parameter)
Insert a new object. The object type can be user, group, document or 
anchor. Depending on the type other object attributes has to be set. The 
parameter array contains the required elements 'object' and 'content' (if 
the object is a document) and the optional parameters 'parameters', 'mode' 
and 'attributeSelector'. The 'object' must contain all attributes of the 
object. 'parameters' is an object as well holding further attributes like 
the destination (attribute key is 'Parent'). 'content' is the content of 
the document. 'mode' can be a combination of the following flags: 
HW_API_INSERT_NORMAL
The object in inserted into the server. 
HW_API_INSERT_FORCE_VERSION_CONTROL
HW_API_INSERT_AUTOMATIC_CHECKOUT
HW_API_INSERT_PLAIN
HW_API_INSERT_KEEP_TIME_MODIFIED
HW_API_INSERT_DELAY_INDEXING
See also hwapi_replace().   hw_api->infoUphw_api->insertanchor
hw_api->insertanchor
(no version information, might be only in CVS)
hw_api->insertanchor -- Inserts a new object of type anchor
Description
object insertanchor ( array parameter)
This function is a shortcut for hwapi_insert(). It inserts an object of 
type anchor and sets some of the attributes required for an anchor. The 
parameter array contains the required elements 'object' and 
'documentIdentifier' and the optional elements 'destinationIdentifier', 
'parameter', 'hint' and 'attributeSelector'. The 'documentIdentifier' 
specifies the document where the anchor shall be inserted. The target of 
the anchor is set in 'destinationIdentifier' if it already exists. If the 
target does not exists the element 'hint' has to be set to the name of 
object which is supposed to be inserted later. Once it is inserted the 
anchor target is resolved automatically. 
See also hwapi_insertdocument(), hwapi_insertcollection(), hwapi_insert(). 
  hw_api->insertUphw_api->insertcollection
hw_api->insertcollection
(no version information, might be only in CVS)
hw_api->insertcollection -- Inserts a new object of type collection
Description
object insertcollection ( array parameter)
This function is a shortcut for hwapi_insert(). It inserts an object of 
type collection and sets some of the attributes required for a collection. 
The parameter array contains the required elements 'object' and 
'parentIdentifier' and the optional elements 'parameter' and 
'attributeSelector'. See hwapi_insert() for the meaning of each element. 
See also hwapi_insertdocument(), hwapi_insertanchor(), hwapi_insert().   hw_api->insertanchorUphw_api->insertdocument
hw_api->insertdocument
(no version information, might be only in CVS)
hw_api->insertdocument -- Inserts a new object of type document
Description
object insertdocument ( array parameter)
This function is a shortcut for hwapi_insert(). It inserts an object with 
content and sets some of the attributes required for a document. The 
parameter array contains the required elements 'object', 
'parentIdentifier' and 'content' and the optional elements 'mode', 
'parameter' and 'attributeSelector'. See hwapi_insert() for the meaning of 
each element. 
See also hwapi_insert() hwapi_insertanchor(), hwapi_insertcollection().   hw_api->insertcollectionUphw_api->link
hw_api->link
(no version information, might be only in CVS)
hw_api->link -- Creates a link to an object
Description
object link ( array parameter)
Creates a link to an object. Accessing this link is like accessing the 
object to links points to. The parameter array contains the required 
elements 'objectIdentifier' and 'destinationParentIdentifier'. 
'destinationParentIdentifier' is the target collection. 
The function returns TRUE on success or an error object. 
See also hwapi_copy().   hw_api->insertdocumentUphw_api->lock
hw_api->lock
(no version information, might be only in CVS)
hw_api->lock -- Locks an object
Description
object lock ( array parameter)
Locks an object for exclusive editing by the user calling this function. 
The object can be only unlocked by this user or the system user. The 
parameter array contains the required element 'objectIdentifier' and the 
optional parameters 'mode' and 'objectquery'. 'mode' determines how an 
object is locked. HW_API_LOCK_NORMAL means, an object is locked until it 
is unlocked. HW_API_LOCK_RECURSIVE is only valid for collection and locks 
all objects within the collection and possible subcollections. 
HW_API_LOCK_SESSION means, an object is locked only as long as the session 
is valid. 
See also hwapi_unlock().   hw_api->linkUphw_api->move
hw_api->move
(no version information, might be only in CVS)
hw_api->move -- Moves object between collections
Description
object move ( array parameter)
See also hw_objrec2array().   hw_api->lockUphw_api_content
hw_api_content
(no version information, might be only in CVS)
hw_api_content -- Create new instance of class hw_api_content
Description
string content ( string content, string mimetype)
Creates a new content object from the string content. The mimetype is set 
to mimetype.   hw_api->moveUphw_api_object->assign
hw_api_object->assign
(no version information, might be only in CVS)
hw_api_object->assign -- Clones object
Description
object assign ( array parameter)
Clones the attributes of an object.   hw_api_contentUphw_api_object->attreditable
hw_api_object->attreditable
(no version information, might be only in CVS)
hw_api_object->attreditable -- Checks whether an attribute is editable
Description
bool attreditable ( array parameter)

  hw_api_object->assignUphw_api_object->count
hw_api_object->count
(no version information, might be only in CVS)
hw_api_object->count -- Returns number of attributes
Description
int count ( array parameter)

  hw_api_object->attreditableUphw_api_object->insert
hw_api_object->insert
(no version information, might be only in CVS)
hw_api_object->insert -- Inserts new attribute
Description
bool insert ( object attribute)
Adds an attribute to the object. Returns TRUE on success and otherwise 
FALSE. 
See also hwapi_object_remove().   hw_api_object->countUphw_api_object
hw_api_object
(no version information, might be only in CVS)
hw_api_object -- Creates a new instance of class hw_api_object
Description
object hw_api_object ( array parameter)
See also hwapi_lock().   hw_api_object->insertUphw_api_object->remove
hw_api_object->remove
(no version information, might be only in CVS)
hw_api_object->remove -- Removes attribute
Description
bool remove ( string name)
Removes the attribute with the given name. Returns TRUE on success and 
otherwise FALSE. 
See also hwapi_object_insert().   hw_api_objectUphw_api_object->title
hw_api_object->title
(no version information, might be only in CVS)
hw_api_object->title -- Returns the title attribute
Description
string title ( array parameter)

  hw_api_object->removeUphw_api_object->value
hw_api_object->value
(no version information, might be only in CVS)
hw_api_object->value -- Returns value of attribute
Description
string value ( string name)
Returns the value of the attribute with the given name or FALSE if an 
error occurred.   hw_api_object->titleUphw_api->object
hw_api->object
(no version information, might be only in CVS)
hw_api->object -- Retrieve attribute information
Description
object hw_api->object ( array parameter)
This function retrieves the attribute information of an object of any 
version. It will not return the document content. The parameter array 
contains the required elements 'objectIdentifier' and the optional 
elements 'attributeSelector' and 'version'. 
The returned object is an instance of class HW_API_Object on success or 
HW_API_Error if an error occurred. 
This simple example retrieves an object and checks for errors. 
Example 1. Retrieve an object
  <?php
  function handle_error($error) {
    $reason = $error->reason(0);
    echo "Type: <b>";
    switch ($reason->type()) {
      case 0:
	echo "Error";
	break;
      case 1:
	echo "Warning";
	break;
      case 2:
	echo "Message";
	break;
    }
    echo "</b><br />\n";
    echo "Description: " . $reason->description("en") . "<br 
  />\n";
  }

  function list_attr($obj) {
    echo "<table>\n";
    $count = $obj->count();
    for ($i=0; $i<$count; $i++) {
      $attr = $obj->attribute($i);
      printf("<tr><td align=\"right\" 
  bgcolor=\"#c0c0c0\"><b>%s</b></td><td 
  bgcolor\="#F0F0F0\">%s</td></tr>\n",
	       $attr->key(), $attr->value());
    }
    echo "</table>\n";
  }

  $hwapi = hwapi_hgcsp($g_config[HOSTNAME]);
  $parms = array("objectIdentifier"=>"rootcollection", 
  "attributeSelector"=>array("Title", "Name", "DocumentType"));
  $root = $hwapi->object($parms);
  if (get_class($root) == "HW_API_Error") {
    handle_error($root);
    exit;
  }
  list_attr($root);
  ?> 
See also hwapi_content().   hw_api_object->valueUphw_api->objectbyanchor
hw_api->objectbyanchor
(no version information, might be only in CVS)
hw_api->objectbyanchor -- Returns the object an anchor belongs to
Description
object objectbyanchor ( array parameter)
This function retrieves an object the specified anchor belongs to. The 
parameter array contains the required element 'objectIdentifier' and the 
optional element 'attributeSelector'. 
See also hwapi_dstofsrcanchor(), hwapi_srcanchors(), hwapi_dstanchors().   hw_api->objectUphw_api->parents
hw_api->parents
(no version information, might be only in CVS)
hw_api->parents -- Returns parents of an object
Description
array parents ( array parameter)
Retrieves the parents of an object. The parents can be further filtered by 
specifying an object query. The parameter array contains the required 
elements 'objectidentifier' and the optional elements 'attributeselector' 
and 'objectquery'. 
The return value is an array of objects of type HW_API_Object or 
HW_API_Error. 
See also hwapi_children().   hw_api->objectbyanchorUphw_api_reason->description
hw_api_reason->description
(no version information, might be only in CVS)
hw_api_reason->description -- Returns description of reason
Description
string description ( void )
Returns the description of a reason   hw_api->parentsUphw_api_reason->type
hw_api_reason->type
(no version information, might be only in CVS)
hw_api_reason->type -- Returns type of reason
Description
object type ( void )
Returns the type of a reason.   hw_api_reason->descriptionUphw_api->remove
hw_api->remove
(no version information, might be only in CVS)
hw_api->remove -- Delete an object
Description
object remove ( array parameter)
Removes an object from the specified parent. Collections will be removed 
recursively. You can pass an optional object query to remove only those 
objects which match the query. An object will be deleted physically if it 
is the last instance. The parameter array contains the required elements 
'objectidentifier' and 'parentidentifier'. If you want to remove a user or 
group 'parentidentifier' can be skipped. The optional parameter 'mode' 
determines how the deletion is performed. In normal mode the object will 
not be removed physically until all instances are removed. In physical 
mode all instances of the object will be deleted immediately. In 
removelinks mode all references to and from the objects will be deleted as 
well. In nonrecursive the deletion is not performed recursive. Removing a 
collection which is not empty will cause an error. 
See also hwapi_move().   hw_api_reason->typeUphw_api->replace
hw_api->replace
(no version information, might be only in CVS)
hw_api->replace -- Replaces an object
Description
object replace ( array parameter)
Replaces the attributes and the content of an object The parameter array 
contains the required elements 'objectIdentifier' and 'object' and the 
optional parameters 'content', 'parameters', 'mode' and 
'attributeSelector'. 'objectIdentifier' contains the object to be 
replaced. 'object' contains the new object. 'content' contains the new 
content. 'parameters' contain extra information for HTML documents. 
HTML_Language is the letter abbreviation of the language of the title. 
HTML_Base sets the base attribute of the HTML document. 'mode' can be a 
combination of the following flags: 
HW_API_REPLACE_NORMAL
The object on the server is replace with the object passed. 
HW_API_REPLACE_FORCE_VERSION_CONTROL
HW_API_REPLACE_AUTOMATIC_CHECKOUT
HW_API_REPLACE_AUTOMATIC_CHECKIN
HW_API_REPLACE_PLAIN
HW_API_REPLACE_REVERT_IF_NOT_CHANGED
HW_API_REPLACE_KEEP_TIME_MODIFIED
See also hwapi_insert().   hw_api->removeUphw_api->setcommitedversion
hw_api->setcommitedversion
(no version information, might be only in CVS)
hw_api->setcommitedversion -- Commits version other than last version
Description
object setcommitedversion ( array parameter)
Commits a version of a document. The committed version is the one which is 
visible to users with read access. By default the last version is the 
committed version. 
See also hwapi_checkin(), hwapi_checkout(), hwapi_revert().   hw_api->replaceUphw_api->srcanchors
hw_api->srcanchors
(no version information, might be only in CVS)
hw_api->srcanchors -- Returns a list of all source anchors
Description
object srcanchors ( array parameter)
Retrieves all source anchors of an object. The parameter array contains 
the required element 'objectIdentifier' and the optional elements 
'attributeSelector' and 'objectQuery'. 
See also hwapi_dstanchors().   hw_api->setcommitedversionUphw_api->srcsofdst
hw_api->srcsofdst
(no version information, might be only in CVS)
hw_api->srcsofdst -- Returns source of a destination object
Description
object srcsofdst ( array parameter)
Retrieves all the source anchors pointing to the specified destination. 
The destination object can either be a destination anchor or a whole 
document. The parameters array contains the required element 
'objectIdentifier' and the optional element 'attributeSelector' and 
'objectQuery'. The function returns an array of objects or an error. 
See also hwapi_dstofsrcanchor().   hw_api->srcanchorsUphw_api->unlock
hw_api->unlock
(no version information, might be only in CVS)
hw_api->unlock -- Unlocks a locked object
Description
object unlock ( array parameter)
Unlocks a locked object. Only the user who has locked the object and the 
system user may unlock an object. The parameter array contains the 
required element 'objectIdentifier' and the optional parameters 'mode' and 
'objectquery'. The meaning of 'mode' is the same as in function 
hwapi_lock(). 
Returns TRUE on success or an object of class HW_API_Error. 
See also hwapi_lock().   hw_api->srcsofdstUphw_api->user
hw_api->user
(no version information, might be only in CVS)
hw_api->user -- Returns the own user object
Description
object user ( array parameter)
See also hwapi_userlist().   hw_api->unlockUphw_api->userlist
hw_api->userlist
(no version information, might be only in CVS)
hw_api->userlist -- Returns a list of all logged in users
Description
object userlist ( array parameter)
See also hwapi_user().   hw_api->userUpiconv functions
#

#T=int hw_who ( int connection)
hw_who ( ^!int connection);
#

#T=hypot - float hypot ( float num1, float num2)
(PHP 4 >= 4.1.0)
hypot --  Returns sqrt(num1*num1 + num2*num2) 
Description
float hypot ( float num1, float num2)
Warning
This function is EXPERIMENTAL. The behaviour of this function, the 
name of this function, and anything else documented about this 
function may change without notice in a future release of PHP. Use 
this function at your own risk.

Warning
This function is currently not documented; only the argument list is 
available.
  hexdecUpis_finite
#

#T=float hypot ( float num1, float num2)
hypot ( ^!float num1, float num2);
#

#T=ibase_add_user - bool ibase_add_user ( string server, string dba_user_name, string 
(PHP 4 >= 4.2.0)
ibase_add_user --  Add a user to a security database (only for IB6 or 
later) 
Description
bool ibase_add_user ( string server, string dba_user_name, string 
dba_user_password, string user_name, string password [, string first_name 
[, string middle_name [, string last_name]]])
Warning
This function is currently not documented; only the argument list is 
available.

See also ibase_modify_user() and ibase_delete_user().   InterBase functionsUpibase_affected_rows
ibase_affected_rows
(no version information, might be only in CVS)
ibase_affected_rows --  Return the number of rows that were affected by 
the previous query 
Description
int ibase_affected_rows ( resource link_identifier)
This function returns the number of rows that were affected by the 
previous query that was executed from within the transaction context 
specified by link_identifier. If link_identifier is a connection resource, 
its default transaction is used. 
See also ibase_query() and ibase_execute().   ibase_add_userUpibase_blob_add
#

#T=bool ibase_add_user ( string server, string dba_user_name, string 
ibase_add_user ( ^!string server, string dba_user_name, string ;
#

#T=ibase_blob_add - bool ibase_blob_add ( resource blob_handle, string data)
(PHP 3>= 3.0.7, PHP 4 )
ibase_blob_add --  Add data into a newly created blob 
Description
bool ibase_blob_add ( resource blob_handle, string data)
ibase_blob_add() adds data into a blob created with ibase_blob_create(). 
Returns TRUE on success or FALSE on failure. 
See also ibase_blob_cancel(), ibase_blob_close(), ibase_blob_create() and 
ibase_blob_import().   ibase_affected_rowsUpibase_blob_cancel
#

#T=bool ibase_blob_add ( resource blob_handle, string data)
ibase_blob_add ( ^!resource blob_handle, string data);
#

#T=ibase_blob_cancel - bool ibase_blob_cancel ( resource blob_handle)
(PHP 3>= 3.0.7, PHP 4 )
ibase_blob_cancel --  Cancel creating blob 
Description
bool ibase_blob_cancel ( resource blob_handle)
This function will discard a BLOB created by ibase_create_blob() if it has 
not yet been closed by ibase_blob_close(). Returns TRUE on success or 
FALSE on failure. 
See also ibase_blob_close(), ibase_blob_create() and ibase_blob_import().   ibase_blob_addUpibase_blob_close
#

#T=bool ibase_blob_cancel ( resource blob_handle)
ibase_blob_cancel ( ^!resource blob_handle);
#

#T=ibase_blob_close - mixed ibase_blob_close ( resource blob_handle)
(PHP 3>= 3.0.7, PHP 4 )
ibase_blob_close --  Close blob 
Description
mixed ibase_blob_close ( resource blob_handle)
This function closes a BLOB that has either been opened for reading by 
ibase_open_blob() or has been opened for writing by ibase_create_blob(). 
If the BLOB was being read, this function returns TRUE on success, if the 
BLOB was being written to, this function returns a string containing the 
BLOB id that has been assigned to it by the database. On failure, this 
function returns FALSE. 
See also ibase_blob_cancel() and ibase_blob_open().   ibase_blob_cancelUpibase_blob_create
#

#T=mixed ibase_blob_close ( resource blob_handle)
ibase_blob_close ( ^!resource blob_handle);
#

#T=ibase_blob_create - resource ibase_blob_create ( [resource link_identifier])
(PHP 3>= 3.0.7, PHP 4 )
ibase_blob_create --  Create a new blob for adding data 
Description
resource ibase_blob_create ( [resource link_identifier])
ibase_blob_create() creates a new BLOB for filling with data. It returns a 
BLOB handle for later use with ibase_blob_add() or FALSE on failure. 
See also ibase_blob_add(), ibase_blob_cancel(), ibase_blob_close() and 
ibase_blob_import().   ibase_blob_closeUpibase_blob_echo
#

#T=resource ibase_blob_create ( [resource link_identifier])
ibase_blob_create ( ^![resource link_identifier]);
#

#T=ibase_blob_echo - bool ibase_blob_echo ( string blob_id)
(PHP 3>= 3.0.7, PHP 4 )
ibase_blob_echo --  Output blob contents to browser 
Description
bool ibase_blob_echo ( string blob_id)
This function opens a BLOB for reading and sends its contents directly to 
standard output (the browser, in most cases). Returns TRUE on success or 
FALSE on failure. 
See also ibase_blob_open(), ibase_blob_close() and ibase_blob_get().   ibase_blob_createUpibase_blob_get
#

#T=bool ibase_blob_echo ( string blob_id)
ibase_blob_echo ( ^!string blob_id);
#

#T=ibase_blob_get - string ibase_blob_get ( resource blob_handle, int len)
(PHP 3>= 3.0.7, PHP 4 )
ibase_blob_get --  Get len bytes data from open blob 
Description
string ibase_blob_get ( resource blob_handle, int len)
This function returns at most len bytes from a BLOB that has been opened 
for reading by ibase_blob_open(). Returns FALSE on failure. 
<?php
$sql       = "SELECT blob_value FROM table";
$result    = ibase_query($sql);
$data      = ibase_fetch_object($result);
$blob_data = ibase_blob_info($data->BLOB_VALUE);
$blob_hndl = ibase_blob_open($data->BLOB_VALUE);
echo         ibase_blob_get($blob_hndl, $blob_data[0]);
?> 

Whilst this example doesn't do much more than a 
'ibase_blob_echo($data->BLOB_VALUE)' would do, it does show you how to get 
information into a $variable to manipulate as you please. 
Note: It is not possible to read from a BLOB that has been opened for 
writing by ibase_blob_create(). 
See also ibase_blob_open(), ibase_blob_close() and ibase_blob_echo().   ibase_blob_echoUpibase_blob_import
#

#T=string ibase_blob_get ( resource blob_handle, int len)
ibase_blob_get ( ^!resource blob_handle, int len);
#

#T=ibase_blob_import - string ibase_blob_import ( [resource link_identifier, resource 
(PHP 3>= 3.0.7, PHP 4 )
ibase_blob_import --  Create blob, copy file in it, and close it 
Description
string ibase_blob_import ( [resource link_identifier, resource 
file_handle])
This function creates a BLOB, reads an entire file into it, closes it and 
returns the assigned BLOB id. The file handle is a handle returned by 
fopen(). Returns FALSE on failure. 
See also ibase_blob_add(), ibase_blob_cancel(), ibase_blob_close() and 
ibase_blob_create().   ibase_blob_getUpibase_blob_info
#

#T=string ibase_blob_import ( [resource link_identifier, resource 
ibase_blob_import ( ^![resource link_identifier, resource ;
#

#T=ibase_blob_info - array ibase_blob_info ( string blob_id)
(PHP 3>= 3.0.7, PHP 4 )
ibase_blob_info --  Return blob length and other useful info 
Description
array ibase_blob_info ( string blob_id)
Returns an array containing information about a BLOB. The information 
returned consists of the length of the BLOB, the number of segments it 
contains, the size of the largest segment, and whether it is a stream BLOB 
or a segmented BLOB.   ibase_blob_importUpibase_blob_open
#

#T=array ibase_blob_info ( string blob_id)
ibase_blob_info ( ^!string blob_id);
#

#T=ibase_blob_open - resource ibase_blob_open ( string blob_id)
(PHP 3>= 3.0.7, PHP 4 )
ibase_blob_open --  Open blob for retrieving data parts 
Description
resource ibase_blob_open ( string blob_id)
ibase_blob_open() opens an existing BLOB for reading. It returns a BLOB 
handle for later use with ibase_blob_get() or FALSE on failure. 
See also ibase_blob_close(), ibase_blob_echo() and ibase_blob_get().   ibase_blob_infoUpibase_close
#

#T=resource ibase_blob_open ( string blob_id)
ibase_blob_open ( ^!string blob_id);
#

#T=ibase_close - bool ibase_close ( [resource connection_id])
(PHP 3>= 3.0.6, PHP 4 )
ibase_close --  Close a connection to an InterBase database 
Description
bool ibase_close ( [resource connection_id])
Closes the link to an InterBase database that's associated with a 
connection id returned from ibase_connect(). If the connection id is 
omitted, the last opened link is assumed. Default transaction on link is 
committed, other transactions are rolled back. Returns TRUE on success or 
FALSE on failure. 
See also ibase_connect() and ibase_pconnect().   ibase_blob_openUpibase_commit_ret
ibase_commit_ret
(no version information, might be only in CVS)
ibase_commit_ret -- Commit a transaction without closing it
Description
bool ibase_commit_ret ( [resource link_identifier])
If called without an argument, this function commits the default 
transaction of the default link. If the argument is a connection 
identifier, the default transaction of the corresponding connection will 
be committed. If the argument is a transaction identifier, the 
corresponding transaction will be committed. The transaction context will 
be retained, so statements executed from within this transaction will not 
be invalidated. Returns TRUE on success or FALSE on failure.   ibase_closeUpibase_commit
#

#T=bool ibase_close ( [resource connection_id])
ibase_close ( ^![resource connection_id]);
#

#T=ibase_commit - bool ibase_commit ( [resource link_identifier])
(PHP 3>= 3.0.7, PHP 4 )
ibase_commit -- Commit a transaction
Description
bool ibase_commit ( [resource link_identifier])
If called without an argument, this function commits the default 
transaction of the default link. If the argument is a connection 
identifier, the default transaction of the corresponding connection will 
be committed. If the argument is a transaction identifier, the 
corresponding transaction will be committed. Returns TRUE on success or 
FALSE on failure.   ibase_commit_retUpibase_connect
#

#T=bool ibase_commit ( [resource link_identifier])
ibase_commit ( ^![resource link_identifier]);
#

#T=ibase_connect - resource ibase_connect ( string database [, string username [, string 
(PHP 3>= 3.0.6, PHP 4 )
ibase_connect --  Open a connection to an InterBase database 
Description
resource ibase_connect ( string database [, string username [, string 
password [, string charset [, int buffers [, int dialect [, string 
role]]]]]])
Establishes a connection to an InterBase server. The database argument has 
to be a valid path to database file on the server it resides on. If the 
server is not local, it must be prefixed with either 'hostname:' (TCP/IP), 
'//hostname/' (NetBEUI) or 'hostname@' (IPX/SPX), depending on the 
connection protocol used. username and password can also be specified with 
PHP configuration directives ibase.default_user and 
ibase.default_password. charset is the default character set for a 
database. buffers is the number of database buffers to allocate for the 
server-side cache. If 0 or omitted, server chooses its own default. 
dialect selects the default SQL dialect for any statement executed within 
a connection, and it defaults to the highest one supported by client 
libraries. 
In case a second call is made to ibase_connect() with the same arguments, 
no new link will be established, but instead, the link identifier of the 
already opened link will be returned. The link to the server will be 
closed as soon as the execution of the script ends, unless it's closed 
earlier by explicitly calling ibase_close(). Example 1. 
ibase_connect() example
  <?php
      $host = 'localhost:/path/to/your.gdb';

      $dbh = ibase_connect($host, $username, $password);
      $stmt = 'SELECT * FROM tblname';
      $sth = ibase_query($dbh, $stmt);
      while ($row = ibase_fetch_object($sth)) {
	  echo $row->email, "\n";
      }
      ibase_free_result($sth);
      ibase_close($dbh);
  ?> 
Note: The optional buffers parameter was added in PHP 4.0.0. 
Note: The optional dialect parameter was added in PHP 4.0.0 and is 
functional only with InterBase 6 and up. 
Note: The optional role parameter was added in PHP 4.0.0 and is 
functional only with InterBase 5 and up. 
Note: If you get some error like "arithmetic exception, numeric 
overflow, or string truncation. Cannot transliterate character between 
character sets" (this occurs when you try use some character with 
accents) when using this and after ibase_query() you must set the 
character set (i.e. ISO8859_1 or your current character set). 
See also ibase_pconnect() and ibase_close().   ibase_commitUpibase_delete_user
#

#T=resource ibase_connect ( string database [, string username [, string 
ibase_connect ( ^!string database [, string username [, string ;
#

#T=ibase_delete_user - bool ibase_delete_user ( string server, string dba_user_name, string 
(PHP 4 >= 4.2.0)
ibase_delete_user --  Delete a user from a security database (only for IB6 
or later) 
Description
bool ibase_delete_user ( string server, string dba_user_name, string 
dba_user_password, string user_name)
Warning
This function is currently not documented; only the argument list is 
available.

See also ibase_add_user() and ibase_modify_user().   ibase_connectUpibase_drop_db
ibase_drop_db
(no version information, might be only in CVS)
ibase_drop_db --  Drops a database 
Description
bool ibase_drop_db ( resource connection)
This functions drops a database that was opened by either ibase_connect() 
or ibase_pconnect(). The database is closed and deleted from the server. 
Returns TRUE on success or FALSE on failure. 
See also ibase_connect() and ibase_pconnect().   ibase_delete_userUpibase_errcode
ibase_errcode
(no version information, might be only in CVS)
ibase_errcode --  Return an error code 
Description
int ibase_errcode ( void )
Returns the error code that resulted from the most recent InterBase 
function call. Returns FALSE if no error occurred. 
See also ibase_errmsg().   ibase_drop_dbUpibase_errmsg
#

#T=bool ibase_delete_user ( string server, string dba_user_name, string 
ibase_delete_user ( ^!string server, string dba_user_name, string ;
#

#T=ibase_errmsg - string ibase_errmsg ( void )
(PHP 3>= 3.0.7, PHP 4 )
ibase_errmsg --  Return error messages 
Description
string ibase_errmsg ( void )
Returns the error message that resulted from the most recent InterBase 
function call. Returns FALSE if no error occurred. 
See also ibase_errcode().   ibase_errcodeUpibase_execute
#

#T=string ibase_errmsg ( void )
ibase_errmsg ( ^!void );
#

#T=ibase_execute - resource ibase_execute ( resource query [, int bind_args])
(PHP 3>= 3.0.6, PHP 4 )
ibase_execute -- Execute a previously prepared query
Description
resource ibase_execute ( resource query [, int bind_args])
Execute a query prepared by ibase_prepare(). If the query raises an error, 
returns FALSE. If it is successful and there is a (possibly empty) result 
set (such as with a SELECT query), returns a result identifier. If the 
query was successful and there were no results, returns TRUE. 
This is a lot more effective than using ibase_query() if you are repeating 
a same kind of query several times with only some parameters changing. 
Example 1. ibase_execute() example
  <?php
     
      $dbh = ibase_connect($host, $username, $password); 

      $updates = array(
	  1 => 'Eric',
	  5 => 'Filip',
	  7 => 'Larry'
      );

      $query = ibase_prepare($dbh, "UPDATE FOO SET BAR = ? WHERE 
  BAZ = ?");

      while (list($baz, $bar) = each($updates)) {
	  ibase_execute($query, $bar, $baz);
      }
  ?> 
Note: In PHP 5.0.0 and up, this function returns the number of rows 
affected by the query (if > 0 and applicable to the statement type). A 
query that succeeded, but did not affect any rows (e.g. an UPDATE of a 
non-existent record) will return TRUE. 
See also ibase_query().   ibase_errmsgUpibase_fetch_assoc
#

#T=resource ibase_execute ( resource query [, int bind_args])
ibase_execute ( ^!resource query [, int bind_args]);
#

#T=ibase_fetch_assoc - array ibase_fetch_assoc ( resource result [, int fetch_flag])
(PHP 4 >= 4.3.0)
ibase_fetch_assoc --  Fetch a result row from a query as an associative 
array 
Description
array ibase_fetch_assoc ( resource result [, int fetch_flag])
ibase_fetch_assoc() returns an associative array that corresponds to the 
fetched row. Subsequent calls will return the next row in the result set, 
or FALSE if there are no more rows. 
ibase_fetch_assoc() fetches one row of data from the result. If two or 
more columns of the result have the same field names, the last column will 
take precedence. To access the other column(s) of the same name, you 
either need to access the result with numeric indices by using 
ibase_fetch_row() or use alias names in your query. 
fetch_flag is a combination of the constants IBASE_TEXT and IBASE_UNIXTIME 
ORed together. Passing IBASE_TEXT will cause this function to return BLOB 
contents instead of BLOB ids. Passing IBASE_UNIXTIME will cause this 
function to return date/time values as Unix timestamps instead of as 
formatted strings. 
See also ibase_fetch_row() and ibase_fetch_object().   ibase_executeUpibase_fetch_object
#

#T=array ibase_fetch_assoc ( resource result [, int fetch_flag])
ibase_fetch_assoc ( ^!resource result [, int fetch_flag]);
#

#T=ibase_fetch_object - object ibase_fetch_object ( resource result_id [, int fetch_flag])
(PHP 3>= 3.0.7, PHP 4 )
ibase_fetch_object -- Get an object from a InterBase database
Description
object ibase_fetch_object ( resource result_id [, int fetch_flag])
Fetches a row as a pseudo-object from a result_id obtained either by 
ibase_query() or ibase_execute(). 
<?php
$dbh = ibase_connect($host, $username, $password);
$stmt = 'SELECT * FROM tblname';
$sth = ibase_query($dbh, $stmt);
while ($row = ibase_fetch_object($sth)) {
    echo $row->email . "\n";
}
ibase_close($dbh);
?> 

Subsequent calls to ibase_fetch_object() return the next row in the result 
set, or FALSE if there are no more rows. 
fetch_flag is a combination of the constants IBASE_TEXT and IBASE_UNIXTIME 
ORed together. Passing IBASE_TEXT will cause this function to return BLOB 
contents instead of BLOB ids. Passing IBASE_UNIXTIME will cause this 
function to return date/time values as Unix timestamps instead of as 
formatted strings. 
See also ibase_fetch_row() and ibase_fetch_assoc().   ibase_fetch_assocUpibase_fetch_row
#

#T=object ibase_fetch_object ( resource result_id [, int fetch_flag])
ibase_fetch_object ( ^!resource result_id [, int fetch_flag]);
#

#T=ibase_fetch_row - array ibase_fetch_row ( resource result_identifier [, int fetch_flag])
(PHP 3>= 3.0.6, PHP 4 )
ibase_fetch_row -- Fetch a row from an InterBase database
Description
array ibase_fetch_row ( resource result_identifier [, int fetch_flag])
Returns an array that corresponds to the fetched row, or FALSE if there 
are no more rows. 
ibase_fetch_row() fetches one row of data from the result associated with 
the specified result_identifier. The row is returned as an array. Each 
result column is stored in an array offset, starting at offset 0. 
Subsequent calls to ibase_fetch_row() return the next row in the result 
set, or FALSE if there are no more rows. 
fetch_flag is a combination of the constants IBASE_TEXT and IBASE_UNIXTIME 
ORed together. Passing IBASE_TEXT will cause this function to return BLOB 
contents instead of BLOB ids. Passing IBASE_UNIXTIME will cause this 
function to return date/time values as Unix timestamps instead of as 
formatted strings. 
See also ibase_fetch_assoc() and ibase_fetch_object().   ibase_fetch_objectUpibase_field_info
#

#T=array ibase_fetch_row ( resource result_identifier [, int fetch_flag])
ibase_fetch_row ( ^!resource result_identifier [, int fetch_flag]);
#

#T=ibase_field_info - array ibase_field_info ( resource result, int field_number)
(PHP 3>= 3.0.7, PHP 4 )
ibase_field_info --  Get information about a field 
Description
array ibase_field_info ( resource result, int field_number)
Returns an array with information about a field after a select query has 
been run. The array is in the form of name, alias, relation, length, type. 

<?php
$rs = ibase_query("SELECT * FROM tablename"); 
$coln = ibase_num_fields($rs);
for ($i = 0; $i < $coln; $i++) {
    $col_info = ibase_field_info($rs, $i); 
    echo "name: ". $col_info['name']. "\n"; 
    echo "alias: ". $col_info['alias']. "\n"; 
    echo "relation: ". $col_info['relation']. "\n"; 
    echo "length: ". $col_info['length']. "\n"; 
    echo "type: ". $col_info['type']. "\n"; 
}
?> 

See also: ibase_num_fields().   ibase_fetch_rowUpibase_free_event_handler
ibase_free_event_handler
(no version information, might be only in CVS)
ibase_free_event_handler --  Cancels a registered event handler 
Description
bool ibase_free_event_handler ( resource event)
This function causes the registered event handler specified by event to be 
cancelled. The callback function will no longer be called for the events 
it was registered to handle. Returns TRUE on success or FALSE on failure. 
See also ibase_set_event_handler().   ibase_field_infoUpibase_free_query
#

#T=array ibase_field_info ( resource result, int field_number)
ibase_field_info ( ^!resource result, int field_number);
#

#T=ibase_free_query - bool ibase_free_query ( resource query)
(PHP 3>= 3.0.6, PHP 4 )
ibase_free_query --  Free memory allocated by a prepared query 
Description
bool ibase_free_query ( resource query)
Free a query prepared by ibase_prepare(). Returns TRUE on success or FALSE 
on failure.   ibase_free_event_handlerUpibase_free_result
#

#T=bool ibase_free_query ( resource query)
ibase_free_query ( ^!resource query);
#

#T=ibase_free_result - bool ibase_free_result ( resource result_identifier)
(PHP 3>= 3.0.6, PHP 4 )
ibase_free_result -- Free a result set
Description
bool ibase_free_result ( resource result_identifier)
Frees a result set that has been created by ibase_query() or 
ibase_execute(). Returns TRUE on success or FALSE on failure.   ibase_free_queryUpibase_gen_id
ibase_gen_id
(no version information, might be only in CVS)
ibase_gen_id --  Increments the named generator and returns its new value 
Description
int ibase_gen_id ( [resource link_identifier [, string generator [, int 
increment]]])
Warning
This function is currently not documented; only the argument list is 
available.
  ibase_free_resultUpibase_modify_user
#

#T=bool ibase_free_result ( resource result_identifier)
ibase_free_result ( ^!resource result_identifier);
#

#T=ibase_modify_user - bool ibase_modify_user ( string server, string dba_user_name, string 
(PHP 4 >= 4.2.0)
ibase_modify_user --  Modify a user to a security database (only for IB6 
or later) 
Description
bool ibase_modify_user ( string server, string dba_user_name, string 
dba_user_password, string user_name, string password [, string first_name 
[, string middle_name [, string last_name]]])
Warning
This function is currently not documented; only the argument list is 
available.

See also ibase_add_user() and ibase_delete_user().   ibase_gen_idUpibase_name_result
ibase_name_result
(no version information, might be only in CVS)
ibase_name_result --  Assigns a name to a result set 
Description
bool ibase_name_result ( resource result, string name)
This function assigns a name to a result set. This name can be used later 
in UPDATE|DELETE ... WHERE CURRENT OF name statements. Returns TRUE on 
success or FALSE on failure. 
<?php
$result = ibase_query("SELECT field1,field2 FROM table FOR UPDATE");
ibase_name_result($result, "my_cursor");

$updateqry = ibase_prepare("UPDATE table SET field2 = ? WHERE 
CURRENT OF my_cursor");

for ($i = 0; ibase_fetch_row($result); ++$i) {
    ibase_execute($updateqry, $i);
}
?> 

See also ibase_prepare() and ibase_execute().   ibase_modify_userUpibase_num_fields
#

#T=bool ibase_modify_user ( string server, string dba_user_name, string 
ibase_modify_user ( ^!string server, string dba_user_name, string ;
#

#T=ibase_num_fields - int ibase_num_fields ( resource result_id)
(PHP 3>= 3.0.7, PHP 4 )
ibase_num_fields --  Get the number of fields in a result set 
Description
int ibase_num_fields ( resource result_id)
Returns an integer containing the number of fields in a result set. 
<?php
$rs = ibase_query("SELECT * FROM tablename"); 
$coln = ibase_num_fields($rs);
for ($i = 0; $i < $coln; $i++) {
    $col_info = ibase_field_info($rs, $i); 
    echo "name: " . $col_info['name'] . "\n"; 
    echo "alias: " . $col_info['alias'] . "\n"; 
    echo "relation: " . $col_info['relation'] . "\n"; 
    echo "length: " . $col_info['length'] . "\n"; 
    echo "type: " . $col_info['type'] . "\n"; 
}
?> 

See also: ibase_field_info().   ibase_name_resultUpibase_num_params
ibase_num_params
(no version information, might be only in CVS)
ibase_num_params --  Return the number of parameters in a prepared query 
Description
int ibase_num_params ( resource query)
This function returns the number of parameters in the prepared query 
specified by query. This is the number of binding arguments that must be 
present when calling ibase_execute(). 
See also ibase_prepare() and ibase_param_info().   ibase_num_fieldsUpibase_param_info
ibase_param_info
(no version information, might be only in CVS)
ibase_param_info --  Return information about a parameter in a prepared 
query 
Description
array ibase_param_info ( resource query, int param_number)
Returns an array with information about a parameter after a query has been 
prepared. The array is in the form of name, alias, relation, length, type. 

See also ibase_field_info() and ibase_num_params().   ibase_num_paramsUpibase_pconnect
#

#T=int ibase_num_fields ( resource result_id)
ibase_num_fields ( ^!resource result_id);
#

#T=ibase_pconnect - resource ibase_pconnect ( string database [, string username [, string 
(PHP 3>= 3.0.6, PHP 4 )
ibase_pconnect --  Open a persistent connection to an InterBase database 
Description
resource ibase_pconnect ( string database [, string username [, string 
password [, string charset [, int buffers [, int dialect [, string 
role]]]]]])
ibase_pconnect() acts very much like ibase_connect() with two major 
differences. First, when connecting, the function will first try to find a 
(persistent) link that's already opened with the same parameters. If one 
is found, an identifier for it will be returned instead of opening a new 
connection. Second, the connection to the InterBase server will not be 
closed when the execution of the script ends. Instead, the link will 
remain open for future use (ibase_close() will not close links established 
by ibase_pconnect()). This type of link is therefore called 'persistent'. 
Note: buffers was added in PHP4-RC2. 
Note: dialect was added in PHP4-RC2. It is functional only with 
InterBase 6 and versions higher than that. 
Note: role was added in PHP4-RC2. It is functional only with InterBase 5 
and versions higher than that. 
See also ibase_close() and ibase_connect() for the meaning of parameters 
passed to this function. They are exactly the same.   ibase_param_infoUpibase_prepare
#

#T=resource ibase_pconnect ( string database [, string username [, string 
ibase_pconnect ( ^!string database [, string username [, string ;
#

#T=ibase_prepare - resource ibase_prepare ( [resource link_identifier, string query])
(PHP 3>= 3.0.6, PHP 4 )
ibase_prepare --  Prepare a query for later binding of parameter 
placeholders and execution 
Description
resource ibase_prepare ( [resource link_identifier, string query])
Prepare a query for later binding of parameter placeholders and execution 
(via ibase_execute()).   ibase_pconnectUpibase_query
#

#T=resource ibase_prepare ( [resource link_identifier, string query])
ibase_prepare ( ^![resource link_identifier, string query]);
#

#T=ibase_query - resource ibase_query ( [resource link_identifier, string query [, int 
(PHP 3>= 3.0.6, PHP 4 )
ibase_query -- Execute a query on an InterBase database
Description
resource ibase_query ( [resource link_identifier, string query [, int 
bind_args]])
Performs a query on an InterBase database. If the query raises an error, 
returns FALSE. If it is successful and there is a (possibly empty) result 
set (such as with a SELECT query), returns a result identifier. If the 
query was successful and there were no results, returns TRUE. 
Example 1. ibase_query() example
  <?php

      $host = 'localhost:/path/to/your.gdb';

      $dbh = ibase_connect($host, $username, $password);
      $stmt = 'SELECT * FROM tblname';

      $sth = ibase_query($dbh, $stmt) or die(ibase_errmsg());

  ?> 
Note: In PHP 5.0.0 and up, this function returns the number of rows 
affected by the query (if > 0 and applicable to the statement type). A 
query that succeeded, but did not affect any rows (e.g. an UPDATE of a 
non-existent record) will return TRUE. 
Note: If you get some error like "arithmetic exception, numeric 
overflow, or string truncation. Cannot transliterate character between 
character sets" (this occurs when you try use some character with 
accents) when using this and after ibase_query() you must set the 
character set (i.e. ISO8859_1 or your current character set). 
See also ibase_errmsg(), ibase_fetch_row(), ibase_fetch_object(), and 
ibase_free_result().   ibase_prepareUpibase_rollback_ret
ibase_rollback_ret
(no version information, might be only in CVS)
ibase_rollback_ret -- Roll back a transaction without closing it
Description
bool ibase_rollback_ret ( [resource link_identifier])
If called without an argument, this function rolls back the default 
transaction of the default link. If the argument is a connection 
identifier, the default transaction of the corresponding connection will 
be rolled back. If the argument is a transaction identifier, the 
corresponding transaction will be rolled back. The transaction context 
will be retained, so statements executed from within this transaction will 
not be invalidated. Returns TRUE on success or FALSE on failure.   ibase_queryUpibase_rollback
#

#T=resource ibase_query ( [resource link_identifier, string query [, int 
ibase_query ( ^![resource link_identifier, string query [, int ;
#

#T=ibase_rollback - bool ibase_rollback ( [resource link_identifier])
(PHP 3>= 3.0.7, PHP 4 )
ibase_rollback -- Roll back a transaction
Description
bool ibase_rollback ( [resource link_identifier])
If called without an argument, this function rolls back the default 
transaction of the default link. If the argument is a connection 
identifier, the default transaction of the corresponding connection will 
be rolled back. If the argument is a transaction identifier, the 
corresponding transaction will be rolled back. Returns TRUE on success or 
FALSE on failure.   ibase_rollback_retUpibase_set_event_handler
ibase_set_event_handler
(no version information, might be only in CVS)
ibase_set_event_handler --  Register a callback function to be called when 
events are posted 
Description
resource ibase_set_event_handler ( [resource connection, callback 
event_handler, string event_name1 [, string event_name2 [, string ...]]])
This function registers a PHP user function as event handler for the 
specified events. The callback is called with the event name and the link 
resource as arguments whenever one of the specified events is posted by 
the database. The callback must return FALSE if the event handler should 
be canceled. Any other return value is ignored. 
<?php

function event_handler($event_name, $link) {
    if ($event_name=="NEW ORDER") {
	// process new order
	ibase_query($link, "UPDATE orders SET 
status='handled'");
    } else if ($event_name=="DB_SHUTDOWN") {
	// free event handler 
	return false;
    }
}

ibase_set_event_handler($link, "event_handler", "NEW_ORDER", 
"DB_SHUTDOWN");
?> 

The return value is an event resource. This resource can be used to free 
the event handler using ibase_free_event_handler(). 
See also ibase_free_event_handler() and ibase_wait_event().   ibase_rollbackUpibase_timefmt
#

#T=bool ibase_rollback ( [resource link_identifier])
ibase_rollback ( ^![resource link_identifier]);
#

#T=ibase_timefmt - int ibase_timefmt ( string format [, int columntype])
(PHP 3>= 3.0.6, PHP 4 )
ibase_timefmt --  Sets the format of timestamp, date and time type columns 
returned from queries 
Description
int ibase_timefmt ( string format [, int columntype])
Sets the format of timestamp, date or time type columns returned from 
queries. Internally, the columns are formatted by c-function strftime(), 
so refer to it's documentation regarding to the format of the string. 
columntype is one of the constants IBASE_TIMESTAMP, IBASE_DATE and 
IBASE_TIME. If omitted, defaults to IBASE_TIMESTAMP for backwards 
compatibility. 
<?php
/* InterBase 6 TIME-type columns will be returned in
 * the form '05 hours 37 minutes'. */
ibase_timefmt("%H hours %M minutes", IBASE_TIME);
?> 

You can also set defaults for these formats with PHP configuration 
directives ibase.timestampformat, ibase.dateformat and ibase.timeformat. 
Note: columntype was added in PHP 4.0. It has any meaning only with 
InterBase version 6 and higher. 
Note: A backwards incompatible change happened in PHP 4.0 when PHP 
configuration directive ibase.timeformat was renamed to 
ibase.timestampformat and directives ibase.dateformat and 
ibase.timeformat were added, so that the names would match better their 
functionality.   ibase_set_event_handlerUpibase_trans
#

#T=int ibase_timefmt ( string format [, int columntype])
ibase_timefmt ( ^!string format [, int columntype]);
#

#T=ibase_trans - resource ibase_trans ( [int trans_args [, resource link_identifier]])
(PHP 3>= 3.0.7, PHP 4 )
ibase_trans -- Begin a transaction
Description
resource ibase_trans ( [int trans_args [, resource link_identifier]])
Begins a transaction. 
trans_args can be a combination of IBASE_READ, IBASE_WRITE, 
IBASE_COMMITED, IBASE_CONSISTENCY, IBASE_CONCURRENCY, IBASE_REC_VERSION, 
IBASE_REC_NO_VERSION, IBASE_WAIT and IBASE_NOWAIT. 
Note: The behaviour of this function has been changed in PHP 5.0.0. The 
first call to ibase_trans() will not return the default transaction of a 
connection. All transactions started by ibase_trans() will be rolled 
back at the end of the script if they were not committed or rolled back 
by either ibase_commit() or ibase_rollback(). 
Note: In PHP 5.0.0. and up, this function will accept multiple 
trans_args and link_identifier arguments. This allows transactions over 
multiple database connections, which are committed using a 2-phase 
commit algorithm. This means you can rely on the updates to either 
succeed in every database, or fail in every database. It does NOT mean 
you can use tables from different databases in the same query! 
If you use transactions over multiple databases, you will have to 
specify both the link_id and transaction_id in calls to ibase_query() 
and ibase_prepare().   ibase_timefmtUpibase_wait_event
ibase_wait_event
(no version information, might be only in CVS)
ibase_wait_event --  Wait for an event to be posted by the database 
Description
string ibase_wait_event ( [resource connection, string event_name1 [, 
string event_name2 [, string ...]]])
This function suspends execution of the script until one of the specified 
events is posted by the database. The name of the event that was posted is 
returned. This function accepts up to 15 event arguments. 
See also ibase_set_event_handler() and ibase_free_event_handler().   ibase_transUpIngres II functions
#

#T=resource ibase_trans ( [int trans_args [, resource link_identifier]])
ibase_trans ( ^![int trans_args [, resource link_identifier]]);
#

#T=iconv_get_encoding - mixed iconv_get_encoding ( [string type])
(PHP 4 >= 4.0.5)
iconv_get_encoding -- Retrieve internal configuration variables of iconv 
extension
Description
mixed iconv_get_encoding ( [string type])
iconv_get_encoding() returns the current value of the internal 
configuration variable if successful, or FALSE on failure. 
The value of the optional type can be: 
all
input_encoding
output_encoding
internal_encoding

If type is omitted or set to "all", iconv_get_encoding() returns an array 
that stores all these variables. 
Example 1. iconv_get_encoding() example
  <pre>
  <?php
  iconv_set_encoding("internal_encoding", "UTF-8");
  iconv_set_encoding("output_encoding", "ISO-8859-1");
  var_dump(iconv_get_encoding('all'));
  ?>
  </pre> 

The printout of the above program will be: 
Array
(
[input_encoding] => ISO-8859-1
[output_encoding] => ISO-8859-1
[internal_encoding] => UTF-8
)
See also iconv_set_encoding() and ob_iconv_handler().   iconv functionsUpiconv_mime_decode_headers
iconv_mime_decode_headers
(no version information, might be only in CVS)
iconv_mime_decode_headers --  Decodes multiple MIME header fields at once 
Description
array iconv_mime_decode_headers ( string encoded_headers [, int mode [, 
string charset]])
Returns an associative array that holds a whole set of MIME header fields 
specified by encoded_headers on success, or FALSE if an error occurs 
during the decoding. 
Each key of the return value represents an individual field name and the 
corresponding element represents a field value. If more than one field of 
the same name are present, iconv_mime_decode_headers() automatically 
incorporates them into a numerically indexed array in the order of 
occurrence. 
mode determines the behaviour in the event iconv_mime_decode_headers() 
encounters a malformed MIME header field. You can specify any combination 
of the following bitmasks. 
Table 1. Bitmasks acceptable to iconv_mime_decode_headers()
ValueConstantDescription
1ICONV_MIME_DECODE_STRICTIf set, the given header is decoded in full 
conformance with the standards defined in RFC2047. This option is 
disabled by default because there are a lot of broken mail user 
agents that don't follow the specification and don't produce correct 
MIME headers. 
2ICONV_MIME_DECODE_CONTINUE_ON_ERRORIf set, 
iconv_mime_decode_headers() attempts to ignore any grammatical 
errors and continue to process a given header. 

The optional charset parameter specifies the character set to represent 
the result by. If omitted, iconv.internal_charset will be used. 
Example 1. iconv_mime_decode_function() example
  <?php
  $headers_string = <<<EOF
  Subject: =?UTF-8?B?UHLDvGZ1bmcgUHLDvGZ1bmc=?=
  To: example@example.com
  Date: Thu, 1 Jan 1970 00:00:00 +0000
  Message-Id: <example@example.com>
  Received: from localhost (localhost [127.0.0.1]) by localhost
      with SMTP id example for <example@example.com>
      Thu, 1 Jan 1970 00:00:00 +0000 (UTC)
      (envelope-from 
  example-return-0000-example=example.com@example.com)
  Received: (qmail 0 invoked by uid 65534); 1 Thu 2003 00:00:00 
  +0000

  EOF;

  $headers =  iconv_mime_decode_headers($headers_string, 0, 
  "ISO-8859-1");
  print_r($headers);
  ?> 

The output of this script should look like: 
Array
(
[Subject] => Prfung Prfung
[To] => example@example.com
[Date] => Thu, 1 Jan 1970 00:00:00 +0000
[Message-Id] => <example@example.com>
[Received] => Array
(
[0] => from localhost (localhost [127.0.0.1]) by localhost with SMTP id example for <example@example.com>; Thu, 1 Jan 1970 00:00:00 +0000 (UTC) (envelope-from example-return-0000-example=example.com@example.com)
[1] => (qmail 0 invoked by uid 65534); 1 Thu 2003 00:00:00 +0000
)

)
See also iconv_mime_decode(), mb_decode_mimeheader(), 
imap_mime_header_decode(), imap_base64() and imap_qprint().   iconv_get_encodingUpiconv_mime_decode
#

#T=mixed iconv_get_encoding ( [string type])
iconv_get_encoding ( ^![string type]);
#

#T=iconv_mime_decode - string iconv_mime_decode ( string encoded_header [, int mode [, string 
(PHP 5 CVS only)
iconv_mime_decode --  Decodes a MIME header field 
Description
string iconv_mime_decode ( string encoded_header [, int mode [, string 
charset]])
Returns a decoded MIME field on success, or FALSE if an error occurs 
during the decoding. 
mode determines the behaviour in the event iconv_mime_decode() encounters 
a malformed MIME header field. You can specify any combination of the 
following bitmasks. 
Table 1. Bitmasks acceptable to iconv_mime_decode()
ValueConstantDescription
1ICONV_MIME_DECODE_STRICTIf set, the given header is decoded in full 
conformance with the standards defined in RFC2047. This option is 
disabled by default because there are a lot of broken mail user 
agents that don't follow the specification and don't produce correct 
MIME headers. 
2ICONV_MIME_DECODE_CONTINUE_ON_ERRORIf set, iconv_mime_decode() 
attempts to continue to process the given header even though an 
error occurs. 

The optional charset parameter specifies the character set to represent 
the result by. If omitted, iconv.internal_charset will be used. 
Example 1. iconv_mime_decode() example
  <?php
  // This yields "Subject: Prfung Prfung"
  echo iconv_mime_decode("Subject: 
  =?UTF-8?B?UHLDvGZ1bmcgUHLDvGZ1bmc=?=",
			 0, "ISO-8859-1");
  ?> 
See also iconv_mime_decode_headers(), mb_decode_mimeheader(), 
imap_mime_header_decode(), imap_base64() and imap_qprint().   iconv_mime_decode_headersUpiconv_mime_encode
#

#T=string iconv_mime_decode ( string encoded_header [, int mode [, string 
iconv_mime_decode ( ^!string encoded_header [, int mode [, string ;
#

#T=iconv_mime_encode - string iconv_mime_encode ( string field_name, string field_value [, array 
(PHP 5 CVS only)
iconv_mime_encode --  Composes a MIME header field 
Description
string iconv_mime_encode ( string field_name, string field_value [, array 
preferences])
Composes and returns a string that represents a valid MIME header field, 
which looks like the following: Subject: =?ISO-8859-1?Q?Pr=FCfung_f=FCr?= Entwerfen von einer MIME kopfzeile
In the above example, "Subject" is the field name and the portion that 
begins with "=?ISO-8859-1?..." is the field value. 
You can control the behaviour of iconv_mime_encode() by specifying an 
associative array that contains configuration items to the optional third 
parameter preferences. The items supported by iconv_mime_encode() are 
listed below. Note that item names are treated case-sensitive. 
Table 1. Configuration items supported by iconv_mime_encode()
ItemTypeDescriptionDefault valueExample
schemebooleanSpecifies the method to encode a field value by. The 
value of this item may be either "B" or "Q", where "B" stands for 
base64 encoding scheme and "Q" stands for quoted-printable encoding 
scheme. BB
input-charsetstringSpecifies the character set in which the first 
parameter field_name and the second parameter field_value are 
presented. If not given, iconv_mime_encode() assumes those 
parameters are presented to it in the iconv.internal_charset ini 
setting. iconv.internal_charset ISO-8859-1
output-charsetstringSpecifies the character set to use to compose 
the MIME header. If not given, the same value as input-charset will 
be used. the same value as input-charset UTF-8
line-lengthintegerSpecifies the maximum length of the header lines. 
The resulting header is "folded" to a set of multiple lines in case 
the resulting header field would be longer than the value of this 
parameter, according to RFC2822 - Internet Message Format. If not 
given, the length will be limited to 76 characters. 76996
line-break-charsstringSpecifies the sequence of characters to append 
to each line as an end-of-line sign when "folding" is performed on a 
long header field. If not given, this defaults to "\r\n" (CR LF). 
Note that this parameter is always treated as an ASCII string 
regardless of the value of input-charset. \r\n\n

Example 1. iconv_mime_encode() example:
  <?php
  $preferences = array(
      "input-charset" => "ISO-8859-1",
      "output-charset" => "UTF-8",
      "line-length" => 76,
      "line-break-chars" => "\n"
  );
  $preferences["scheme"] = "Q";
  // This yields "Subject: 
=?UTF-8?Q?Pr=C3=BCfung_Pr=C3=BCfung?="
  echo iconv_mime_encode("Subject", "Prfung Prfung", 
  $preferences);

  $preferences["scheme"] = "B";
  // This yields "Subject: =?UTF-8?B?UHLDvGZ1bmcgUHLDvGZ1bmc=?="
  echo iconv_mime_encode("Subject", "Prfung Prfung", 
  $preferences);
  ?> 
See also imap_binary(), mb_encode_mimeheader() and imap_8bit().   iconv_mime_decodeUpiconv_set_encoding
#

#T=string iconv_mime_encode ( string field_name, string field_value [, array 
iconv_mime_encode ( ^!string field_name, string field_value [, array ;
#

#T=iconv_set_encoding - bool iconv_set_encoding ( string type, string charset)
(PHP 4 >= 4.0.5)
iconv_set_encoding -- Set current setting for character encoding 
conversion
Description
bool iconv_set_encoding ( string type, string charset)
iconv_set_encoding() changes the value of the internal configuration 
variable specified by type to charset. Returns TRUE on success or FALSE on 
failure. 
The value of type can be any one of those: 
input_encoding
output_encoding
internal_encoding

Example 1. iconv_set_encoding() example:
  <?php
  iconv_set_encoding("internal_encoding", "UTF-8");
  iconv_set_encoding("output_encoding", "ISO-8859-1");
  ?> 
See also iconv_get_encoding() and ob_iconv_handler().   iconv_mime_encodeUpiconv_strlen
#

#T=bool iconv_set_encoding ( string type, string charset)
iconv_set_encoding ( ^!string type, string charset);
#

#T=iconv_strlen - int iconv_strlen ( string str [, string charset])
(PHP 5 CVS only)
iconv_strlen --  Returns the character count of string 
Description
int iconv_strlen ( string str [, string charset])
Returns the character count of str. 
In contrast to strlen(), iconv_strlen() counts the occurrences of 
characters in the given byte sequence str on the basis of the specified 
character set, the result of which is not necessarily identical to the 
length of the string in byte. 
If charset parameter is omitted, str is assumed to be encoded in 
iconv.internal_charset. 
See also strlen() and mb_strlen().   iconv_set_encodingUpiconv_strpos
#

#T=int iconv_strlen ( string str [, string charset])
iconv_strlen ( ^!string str [, string charset]);
#

#T=iconv_strpos - int iconv_strpos ( string haystack, string needle, int offset [, string 
(PHP 5 CVS only)
iconv_strpos --  Finds position of first occurrence of a needle within a 
haystack. 
Description
int iconv_strpos ( string haystack, string needle, int offset [, string 
charset])
Returns the numeric position of the first occurrence of needle in 
haystack. 
The optional offset parameter specifies the position from which the search 
should be performed. 
If needle is not found, iconv_strpos() will return FALSE. 
Warning
This function may return Boolean FALSE, but may also return a 
non-Boolean value which evaluates to FALSE, such as 0 or "". Please 
read the section on Booleans for more information. Use the === 
operator for testing the return value of this function.

If haystack or needle is not a string, it is converted to a string and 
applied as the ordinal value of a character. 
In contrast to strpos(), the return value of iconv_strpos() is the number 
of characters that appear before the needle, rather than the offset in 
bytes to the position where the needle has been found. The characters are 
counted on the basis of the specified character set charset. 
If charset parameter is omitted, string are assumed to be encoded in 
iconv.internal_charset. 
See also strpos(), iconv_strrpos() and mb_strpos().   iconv_strlenUpiconv_strrpos
#

#T=int iconv_strpos ( string haystack, string needle, int offset [, string 
iconv_strpos ( ^!string haystack, string needle, int offset [, string ;
#

#T=iconv_strrpos - string iconv_strrpos ( string haystack, string needle [, string charset])
(PHP 5 CVS only)
iconv_strrpos --  Finds the last occurrence of a needle within the 
specified range of haystack. 
Description
string iconv_strrpos ( string haystack, string needle [, string charset])
Returns the numeric position of the last occurrence of needle in haystack. 

If needle is not found, iconv_strrpos() will return FALSE. 
Warning
This function may return Boolean FALSE, but may also return a 
non-Boolean value which evaluates to FALSE, such as 0 or "". Please 
read the section on Booleans for more information. Use the === 
operator for testing the return value of this function.

If haystack or needle is not a string, it is converted to a string and 
applied as the ordinal value of a character. 
In contrast to strpos(), the return value of iconv_strrpos() is the number 
of characters that appear before the needle, rather than the offset in 
bytes to the position where the needle has been found. The characters are 
counted on the basis of the specified character set charset. 
See also strrpos(), iconv_strpos() and mb_strrpos().   iconv_strposUpiconv_substr
#

#T=string iconv_strrpos ( string haystack, string needle [, string charset])
iconv_strrpos ( ^!string haystack, string needle [, string charset]);
#

#T=iconv_substr - string iconv_substr ( string str, int offset [, int length [, string 
(PHP 5 CVS only)
iconv_substr --  Cut out part of a string 
Description
string iconv_substr ( string str, int offset [, int length [, string 
charset]])
Returns the portion of str specified by the start and length parameters. 
If start is non-negative, iconv_substr() cuts the portion out of str 
beginning at start'th character, counting from zero. 
If start is negative, iconv_substr() cuts out the portion beginning at the 
position, start characters away from the end of str. 
If length is given and is positive, the return value will contain at most 
length characters of the portion that begins at start (depending on the 
length of string). If str is shorter than start characters long, FALSE 
will be returned. 
If negative length is passed, iconv_substr() cuts the portion out of str 
from the start'th character up to the character that is length characters 
away from the end of the string. In case start is also negative, the start 
position is calculated beforehand according to the rule explained above. 
Note that offset and length parameters are always deemed to represent 
offsets that are calculated on the basis of the character set determined 
by charset, whilst the counterpart substr() always takes these for byte 
offsets. If charset is not given, the character set is determined by the 
iconv.internal_charset ini setting. 
See also substr(), mb_substr() and mb_strcut().   iconv_strrposUpiconv
#

#T=string iconv_substr ( string str, int offset [, int length [, string 
iconv_substr ( ^!string str, int offset [, int length [, string ;
#

#T=iconv - string iconv ( string in_charset, string out_charset, string str)
(PHP 4 >= 4.0.5)
iconv -- Convert string to requested character encoding
Description
string iconv ( string in_charset, string out_charset, string str)
Performs a character set conversion on the string str from in_charset to 
out_charset. Returns the converted string or FALSE on failure. 
Example 1. iconv() example:
  <?php
  echo iconv("ISO-8859-1", "UTF-8", "This is a test.");
  ?> 

  iconv_substrUpob_iconv_handler
#

#T=string iconv ( string in_charset, string out_charset, string str)
iconv ( ^!string in_charset, string out_charset, string str);
#

#T=ifx_affected_rows - int ifx_affected_rows ( int result_id)
(PHP 3>= 3.0.3, PHP 4 )
ifx_affected_rows -- Get number of rows affected by a query
Description
int ifx_affected_rows ( int result_id)
result_id is a valid result id returned by ifx_query() or ifx_prepare(). 
Returns the number of rows affected by a query associated with result_id. 
For inserts, updates and deletes the number is the real number 
(sqlerrd[2]) of affected rows. For selects it is an estimate (sqlerrd[0]). 
Don't rely on it. The database server can never return the actual number 
of rows that will be returned by a SELECT because it has not even begun 
fetching them at this stage (just after the "PREPARE" when the optimizer 
has determined the query plan). 
Useful after ifx_prepare() to limit queries to reasonable result sets. 
Example 1. Informix affected rows
  <?php
  $rid = ifx_prepare("select * from emp 
		       where name like " . $name, $connid);
  if (! $rid) {
      /* ... error ... */
  }
  $rowcount = ifx_affected_rows($rid);
  if ($rowcount > 1000) {
      printf ("Too many rows in result set (%d)\n<br />", 
  $rowcount);
      die ("Please restrict your query<br />\n");
  }
  ?> 
See also ifx_num_rows().   Informix functionsUpifx_blobinfile_mode
#

#T=int ifx_affected_rows ( int result_id)
ifx_affected_rows ( ^!int result_id);
#

#T=ifx_blobinfile_mode - void ifx_blobinfile_mode ( int mode)
(PHP 3>= 3.0.4, PHP 4 )
ifx_blobinfile_mode -- Set the default blob mode for all select queries
Description
void ifx_blobinfile_mode ( int mode)
Set the default blob mode for all select queries. Mode "0" means save 
Byte-Blobs in memory, and mode "1" means save Byte-Blobs in a file.   ifx_affected_rowsUpifx_byteasvarchar
#

#T=void ifx_blobinfile_mode ( int mode)
ifx_blobinfile_mode ( ^!int mode);
#

#T=ifx_byteasvarchar - void ifx_byteasvarchar ( int mode)
(PHP 3>= 3.0.4, PHP 4 )
ifx_byteasvarchar -- Set the default byte mode
Description
void ifx_byteasvarchar ( int mode)
Sets the default byte mode for all select-queries. Mode "0" will return a 
blob id, and mode "1" will return a varchar with text content.   ifx_blobinfile_modeUpifx_close
#

#T=void ifx_byteasvarchar ( int mode)
ifx_byteasvarchar ( ^!int mode);
#

#T=ifx_close - int ifx_close ( [int link_identifier])
(PHP 3>= 3.0.3, PHP 4 )
ifx_close -- Close Informix connection
Description
int ifx_close ( [int link_identifier])
Returns: always TRUE. 
ifx_close() closes the link to an Informix database that's associated with 
the specified link identifier. If the link identifier isn't specified, the 
last opened link is assumed. 
Note that this isn't usually necessary, as non-persistent open links are 
automatically closed at the end of the script's execution. 
ifx_close() will not close persistent links generated by ifx_pconnect(). 
Example 1. Closing a Informix connection
  <?php
  $conn_id = ifx_connect ("mydb@ol_srv", "itsme", "mypassword");
  /* ... some queries and stuff ... */
  ifx_close($conn_id);
  ?> 
See also ifx_connect() and ifx_pconnect().   ifx_byteasvarcharUpifx_connect
#

#T=int ifx_close ( [int link_identifier])
ifx_close ( ^![int link_identifier]);
#

#T=ifx_connect - int ifx_connect ( [string database [, string userid [, string password]]])
(PHP 3>= 3.0.3, PHP 4 )
ifx_connect -- Open Informix server connection
Description
int ifx_connect ( [string database [, string userid [, string password]]])
Returns a connection identifier on success, or FALSE on error. 
ifx_connect() establishes a connection to an Informix server. All of the 
arguments are optional, and if they're missing, defaults are taken from 
values supplied in configuration file (ifx.default_host for the host 
(Informix libraries will use INFORMIXSERVER environment value if not 
defined), ifx.default_user for user, ifx.default_password for the password 
(none if not defined). 
In case a second call is made to ifx_connect() with the same arguments, no 
new link will be established, but instead, the link identifier of the 
already opened link will be returned. 
The link to the server will be closed as soon as the execution of the 
script ends, unless it's closed earlier by explicitly calling ifx_close(). 

Example 1. Connect to a Informix database
  <?php
  $conn_id = ifx_connect ("mydb@ol_srv1", "imyself", 
  "mypassword");
  ?> 
See also ifx_pconnect() and ifx_close().   ifx_closeUpifx_copy_blob
#

#T=int ifx_connect ( [string database [, string userid [, string password]]])
ifx_connect ( ^![string database [, string userid [, string password]]]);
#

#T=ifx_copy_blob - int ifx_copy_blob ( int bid)
(PHP 3>= 3.0.4, PHP 4 )
ifx_copy_blob -- Duplicates the given blob object
Description
int ifx_copy_blob ( int bid)
Duplicates the given blob object. bid is the ID of the blob object. 
Returns FALSE on error otherwise the new blob object-id.   ifx_connectUpifx_create_blob
#

#T=int ifx_copy_blob ( int bid)
ifx_copy_blob ( ^!int bid);
#

#T=ifx_create_blob - int ifx_create_blob ( int type, int mode, string param)
(PHP 3>= 3.0.4, PHP 4 )
ifx_create_blob -- Creates an blob object
Description
int ifx_create_blob ( int type, int mode, string param)
Creates an blob object. 
type: 1 = TEXT, 0 = BYTE 
mode: 0 = blob-object holds the content in memory, 1 = blob-object holds 
the content in file. 
param: if mode = 0: pointer to the content, if mode = 1: pointer to the 
filestring. 
Return FALSE on error, otherwise the new blob object-id.   ifx_copy_blobUpifx_create_char
#

#T=int ifx_create_blob ( int type, int mode, string param)
ifx_create_blob ( ^!int type, int mode, string param);
#

#T=ifx_create_char - int ifx_create_char ( string param)
(PHP 3>= 3.0.6, PHP 4 )
ifx_create_char -- Creates an char object
Description
int ifx_create_char ( string param)
Creates an char object. param should be the char content.   ifx_create_blobUpifx_do
#

#T=int ifx_create_char ( string param)
ifx_create_char ( ^!string param);
#

#T=ifx_do - int ifx_do ( int result_id)
(PHP 3>= 3.0.4, PHP 4 )
ifx_do --  Execute a previously prepared SQL-statement 
Description
int ifx_do ( int result_id)
Returns TRUE on success or FALSE on failure. 
Executes a previously prepared query or opens a cursor for it. 
Does NOT free result_id on error. 
Also sets the real number of ifx_affected_rows() for non-select statements 
for retrieval by ifx_affected_rows() 
See also: ifx_prepare().   ifx_create_charUpifx_error
#

#T=int ifx_do ( int result_id)
ifx_do ( ^!int result_id);
#

#T=ifx_error - string ifx_error ( void )
(PHP 3>= 3.0.3, PHP 4 )
ifx_error -- Returns error code of last Informix call
Description
string ifx_error ( void )
The Informix error codes (SQLSTATE & SQLCODE) formatted as follows : 
x [SQLSTATE = aa bbb SQLCODE=cccc] 
where x = space : no error 
E : error 
N : no more data 
W : warning 
? : undefined 
If the "x" character is anything other than space, SQLSTATE and SQLCODE 
describe the error in more detail. 
See the Informix manual for the description of SQLSTATE and SQLCODE 
Returns in a string one character describing the general results of a 
statement and both SQLSTATE and SQLCODE associated with the most recent 
SQL statement executed. The format of the string is "(char) [SQLSTATE=(two 
digits) (three digits) SQLCODE=(one digit)]". The first character can be ' 
' (space) (success), 'W' (the statement caused some warning), 'E' (an 
error happened when executing the statement) or 'N' (the statement didn't 
return any data). 
See also: ifx_errormsg()   ifx_doUpifx_errormsg
#

#T=string ifx_error ( void )
ifx_error ( ^!void );
#

#T=ifx_errormsg - string ifx_errormsg ( [int errorcode])
(PHP 3>= 3.0.4, PHP 4 )
ifx_errormsg -- Returns error message of last Informix call
Description
string ifx_errormsg ( [int errorcode])
Returns the Informix error message associated with the most recent 
Informix error, or, when the optional "errorcode" parameter is present, 
the error message corresponding to "errorcode". 
Example 1. ifx_errormsg() example
  printf("%s\n&lt;br>", ifx_errormsg(-201)); 
See also ifx_error().   ifx_errorUpifx_fetch_row
#

#T=string ifx_errormsg ( [int errorcode])
ifx_errormsg ( ^![int errorcode]);
#

#T=ifx_fetch_row - array ifx_fetch_row ( int result_id [, mixed position])
(PHP 3>= 3.0.3, PHP 4 )
ifx_fetch_row -- Get row as enumerated array
Description
array ifx_fetch_row ( int result_id [, mixed position])
Returns an associative array that corresponds to the fetched row, or FALSE 
if there are no more rows. 
Blob columns are returned as integer blob id values for use in 
ifx_get_blob() unless you have used ifx_textasvarchar(1) or 
ifx_byteasvarchar(1), in which case blobs are returned as string values. 
Returns FALSE on error 
result_id is a valid resultid returned by ifx_query() or ifx_prepare() 
(select type queries only!). 
position is an optional parameter for a "fetch" operation on "scroll" 
cursors: "NEXT", "PREVIOUS", "CURRENT", "FIRST", "LAST" or a number. If 
you specify a number, an "absolute" row fetch is executed. This parameter 
is optional, and only valid for SCROLL cursors. 
ifx_fetch_row() fetches one row of data from the result associated with 
the specified result identifier. The row is returned as an array. Each 
result column is stored in an array offset, starting at offset 0, with the 
column name as key. 
Subsequent calls to ifx_fetch_row() would return the next row in the 
result set, or FALSE if there are no more rows. 
Example 1. Informix fetch rows
  <?php
  $rid = ifx_prepare ("select * from emp where name like " . 
  $name,
		       $connid, IFX_SCROLL);
  if (! $rid) {
      /* ... error ... */
  }
  $rowcount = ifx_affected_rows($rid);
  if ($rowcount > 1000) {
      printf ("Too many rows in result set (%d)\n<br />", 
  $rowcount);
      die ("Please restrict your query<br />\n");
  }
  if (! ifx_do ($rid)) {
     /* ... error ... */
  }
  $row = ifx_fetch_row ($rid, "NEXT");
  while (is_array($row)) {
      for (reset($row); $fieldname=key($row); next($row)) {
	  $fieldvalue = $row[$fieldname];
	  printf ("%s = %s,", $fieldname, $fieldvalue);
      }
      printf("\n<br />");
      $row = ifx_fetch_row($rid, "NEXT");
  }
  ifx_free_result ($rid);
  ?> 

  ifx_errormsgUpifx_fieldproperties
#

#T=array ifx_fetch_row ( int result_id [, mixed position])
ifx_fetch_row ( ^!int result_id [, mixed position]);
#

#T=ifx_fieldproperties - array ifx_fieldproperties ( int result_id)
(PHP 3>= 3.0.3, PHP 4 )
ifx_fieldproperties -- List of SQL fieldproperties
Description
array ifx_fieldproperties ( int result_id)
Returns an associative array with fieldnames as key and the SQL 
fieldproperties as data for a query with result_id. Returns FALSE on 
error. 
Returns the Informix SQL fieldproperties of every field in the query as an 
associative array. Properties are encoded as: 
"SQLTYPE;length;precision;scale;ISNULLABLE" where SQLTYPE = the Informix 
type like "SQLVCHAR" etc. and ISNULLABLE = "Y" or "N". 
Example 1. Informix SQL fieldproperties
  <?php
  $properties = ifx_fieldproperties ($resultid);
  if (! isset($properties)) {
      /* ... error ... */
  }
  for ($i = 0; $i < count($properties); $i++) {
      $fname = key ($properties);
      printf ("%s:\t type =  %s\n", $fname, 
$properties[$fname]);
      next ($properties);
  }
  ?> 

  ifx_fetch_rowUpifx_fieldtypes
#

#T=array ifx_fieldproperties ( int result_id)
ifx_fieldproperties ( ^!int result_id);
#

#T=ifx_fieldtypes - array ifx_fieldtypes ( int result_id)
(PHP 3>= 3.0.3, PHP 4 )
ifx_fieldtypes -- List of Informix SQL fields
Description
array ifx_fieldtypes ( int result_id)
Returns an associative array with fieldnames as key and the SQL fieldtypes 
as data for query with result_id. Returns FALSE on error. 
Example 1. Fieldnames and SQL fieldtypes
  <?php
  $types = ifx_fieldtypes ($resultid);
  if (! isset ($types)) {
      /* ... error ... */
  }
  for ($i = 0; $i < count($types); $i++) {
      $fname = key($types);
      printf("%s :\t type =  %s\n", $fname, $types[$fname]);
      next($types);
  }
  ?> 

  ifx_fieldpropertiesUpifx_free_blob
#

#T=array ifx_fieldtypes ( int result_id)
ifx_fieldtypes ( ^!int result_id);
#

#T=ifx_free_blob - int ifx_free_blob ( int bid)
(PHP 3>= 3.0.4, PHP 4 )
ifx_free_blob -- Deletes the blob object
Description
int ifx_free_blob ( int bid)
Deletes the blobobject for the given blob object-id bid. Returns TRUE on 
success or FALSE on failure.   ifx_fieldtypesUpifx_free_char
#

#T=int ifx_free_blob ( int bid)
ifx_free_blob ( ^!int bid);
#

#T=ifx_free_char - int ifx_free_char ( int bid)
(PHP 3>= 3.0.6, PHP 4 )
ifx_free_char -- Deletes the char object
Description
int ifx_free_char ( int bid)
Deletes the charobject for the given char object-id bid. Returns TRUE on 
success or FALSE on failure.   ifx_free_blobUpifx_free_result
#

#T=int ifx_free_char ( int bid)
ifx_free_char ( ^!int bid);
#

#T=ifx_free_result - int ifx_free_result ( int result_id)
(PHP 3>= 3.0.3, PHP 4 )
ifx_free_result -- Releases resources for the query
Description
int ifx_free_result ( int result_id)
Releases resources for the query associated with result_id. Returns TRUE 
on success or FALSE on failure.   ifx_free_charUpifx_get_blob
#

#T=int ifx_free_result ( int result_id)
ifx_free_result ( ^!int result_id);
#

#T=ifx_get_blob - int ifx_get_blob ( int bid)
(PHP 3>= 3.0.4, PHP 4 )
ifx_get_blob -- Return the content of a blob object
Description
int ifx_get_blob ( int bid)
Returns the content of the blob object for the given blob object-id bid.   ifx_free_resultUpifx_get_char
#

#T=int ifx_get_blob ( int bid)
ifx_get_blob ( ^!int bid);
#

#T=ifx_get_char - int ifx_get_char ( int bid)
(PHP 3>= 3.0.6, PHP 4 )
ifx_get_char -- Return the content of the char object
Description
int ifx_get_char ( int bid)
Returns the content of the char object for the given char object-id bid.   ifx_get_blobUpifx_getsqlca
#

#T=int ifx_get_char ( int bid)
ifx_get_char ( ^!int bid);
#

#T=ifx_getsqlca - array ifx_getsqlca ( int result_id)
(PHP 3>= 3.0.8, PHP 4 )
ifx_getsqlca --  Get the contents of sqlca.sqlerrd[0..5] after a query 
Description
array ifx_getsqlca ( int result_id)
result_id is a valid result id returned by ifx_query() or ifx_prepare(). 
Returns a pseudo-row (associative array) with sqlca.sqlerrd[0] ... 
sqlca.sqlerrd[5] after the query associated with result_id. 
For inserts, updates and deletes the values returned are those as set by 
the server after executing the query. This gives access to the number of 
affected rows and the serial insert value. For SELECTs the values are 
those saved after the PREPARE statement. This gives access to the 
*estimated* number of affected rows. The use of this function saves the 
overhead of executing a "select dbinfo('sqlca.sqlerrdx')" query, as it 
retrieves the values that were saved by the ifx driver at the appropriate 
moment. 
Example 1. Retrieve Informix sqlca.sqlerrd[x] values
  <?php
  /* assume the first column of 'sometable' is a serial */
  $qid = ifx_query("insert into sometable 
		    values (0, '2nd column', 'another column') 
  ", $connid);
  if (!$qid) {
      /* ... error ... */
  }
  $sqlca = ifx_getsqlca($qid);
  $serial_value = $sqlca["sqlerrd1"];
  echo "The serial value of the inserted row is : 
  $serial_value<br />\n"; 
  ?> 

  ifx_get_charUpifx_htmltbl_result
#

#T=array ifx_getsqlca ( int result_id)
ifx_getsqlca ( ^!int result_id);
#

#T=ifx_htmltbl_result - int ifx_htmltbl_result ( int result_id [, string html_table_options])
(PHP 3>= 3.0.3, PHP 4 )
ifx_htmltbl_result --  Formats all rows of a query into a HTML table 
Description
int ifx_htmltbl_result ( int result_id [, string html_table_options])
Returns the number of rows fetched or FALSE on error. 
Formats all rows of the result_id query into a HTML table. The optional 
second argument is a string of <table> tag options 
Example 1. Informix results as HTML table
  <?php
  $rid = ifx_prepare ("select * from emp where name like " . 
  $name,
		       $connid, IFX_SCROLL);
  if (! $rid) {
      /* ... error ... */
  }
  $rowcount = ifx_affected_rows ($rid);
  if ($rowcount > 1000) {
      printf ("Too many rows in result set (%d)\n<br />", 
  $rowcount);
      die ("Please restrict your query<br />\n");
  }
  if (! ifx_do($rid)) {
      /* ... error ... */
  }

  ifx_htmltbl_result ($rid, "border=\"2\"");

  ifx_free_result($rid);
  ?> 

  ifx_getsqlcaUpifx_nullformat
#

#T=int ifx_htmltbl_result ( int result_id [, string html_table_options])
ifx_htmltbl_result ( ^!int result_id [, string html_table_options]);
#

#T=ifx_nullformat - void ifx_nullformat ( int mode)
(PHP 3>= 3.0.4, PHP 4 )
ifx_nullformat --  Sets the default return value on a fetch row 
Description
void ifx_nullformat ( int mode)
Sets the default return value of a NULL-value on a fetch row. Mode "0" 
returns "", and mode "1" returns "NULL".   ifx_htmltbl_resultUpifx_num_fields
#

#T=void ifx_nullformat ( int mode)
ifx_nullformat ( ^!int mode);
#

#T=ifx_num_fields - int ifx_num_fields ( int result_id)
(PHP 3>= 3.0.3, PHP 4 )
ifx_num_fields -- Returns the number of columns in the query
Description
int ifx_num_fields ( int result_id)
Returns the number of columns in query for result_id or FALSE on error 
After preparing or executing a query, this call gives you the number of 
columns in the query.   ifx_nullformatUpifx_num_rows
#

#T=int ifx_num_fields ( int result_id)
ifx_num_fields ( ^!int result_id);
#

#T=ifx_num_rows - int ifx_num_rows ( int result_id)
(PHP 3>= 3.0.3, PHP 4 )
ifx_num_rows -- Count the rows already fetched from a query
Description
int ifx_num_rows ( int result_id)
Gives the number of rows fetched so far for a query with result_id after a 
ifx_query() or ifx_do() query.   ifx_num_fieldsUpifx_pconnect
#

#T=int ifx_num_rows ( int result_id)
ifx_num_rows ( ^!int result_id);
#

#T=ifx_pconnect - int ifx_pconnect ( [string database [, string userid [, string 
(PHP 3>= 3.0.3, PHP 4 )
ifx_pconnect -- Open persistent Informix connection
Description
int ifx_pconnect ( [string database [, string userid [, string 
password]]])
Returns: A positive Informix persistent link identifier on success, or 
FALSE on error 
ifx_pconnect() acts very much like ifx_connect() with two major 
differences. 
This function behaves exactly like ifx_connect() when PHP is not running 
as an Apache module. First, when connecting, the function would first try 
to find a (persistent) link that's already open with the same host, 
username and password. If one is found, an identifier for it will be 
returned instead of opening a new connection. 
Second, the connection to the SQL server will not be closed when the 
execution of the script ends. Instead, the link will remain open for 
future use (ifx_close() will not close links established by 
ifx_pconnect()). 
This type of links is therefore called 'persistent'. 
See also: ifx_connect().   ifx_num_rowsUpifx_prepare
#

#T=int ifx_pconnect ( [string database [, string userid [, string 
ifx_pconnect ( ^![string database [, string userid [, string ;
#

#T=ifx_prepare - int ifx_prepare ( string query, int conn_id [, int cursor_def, mixed 
(PHP 3>= 3.0.4, PHP 4 )
ifx_prepare -- Prepare an SQL-statement for execution
Description
int ifx_prepare ( string query, int conn_id [, int cursor_def, mixed 
blobidarray])
Returns an integer result_id for use by ifx_do(). Sets affected_rows for 
retrieval by the ifx_affected_rows() function. 
Prepares query on connection conn_id. For "select-type" queries a cursor 
is declared and opened. The optional cursor_type parameter allows you to 
make this a "scroll" and/or "hold" cursor. It's a bitmask and can be 
either IFX_SCROLL, IFX_HOLD, or both or'ed together. 
For either query type the estimated number of affected rows is saved for 
retrieval by ifx_affected_rows(). 
If you have BLOB (BYTE or TEXT) columns in the query, you can add a 
blobidarray parameter containing the corresponding "blob ids", and you 
should replace those columns with a "?" in the query text. 
If the contents of the TEXT (or BYTE) column allow it, you can also use 
"ifx_textasvarchar(1)" and "ifx_byteasvarchar(1)". This allows you to 
treat TEXT (or BYTE) columns just as if they were ordinary (but long) 
VARCHAR columns for select queries, and you don't need to bother with blob 
id's. 
With ifx_textasvarchar(0) or ifx_byteasvarchar(0) (the default situation), 
select queries will return BLOB columns as blob id's (integer value). You 
can get the value of the blob as a string or file with the blob functions 
(see below). 
See also: ifx_do().   ifx_pconnectUpifx_query
#

#T=int ifx_prepare ( string query, int conn_id [, int cursor_def, mixed 
ifx_prepare ( ^!string query, int conn_id [, int cursor_def, mixed ;
#

#T=ifx_query - int ifx_query ( string query, int link_identifier [, int cursor_type [, 
(PHP 3>= 3.0.3, PHP 4 )
ifx_query -- Send Informix query
Description
int ifx_query ( string query, int link_identifier [, int cursor_type [, 
mixed blobidarray]])
Returns a positive Informix result identifier on success, or FALSE on 
error. 
A "result_id" resource used by other functions to retrieve the query 
results. Sets "affected_rows" for retrieval by the ifx_affected_rows() 
function. 
ifx_query() sends a query to the currently active database on the server 
that's associated with the specified link identifier. 
Executes query on connection conn_id. For "select-type" queries a cursor 
is declared and opened. The optional cursor_type parameter allows you to 
make this a "scroll" and/or "hold" cursor. It's a bitmask and can be 
either IFX_SCROLL, IFX_HOLD, or both or'ed together. Non-select queries 
are "execute immediate". IFX_SCROLL and IFX_HOLD are symbolic constants 
and as such shouldn't be between quotes. I you omit this parameter the 
cursor is a normal sequential cursor. 
For either query type the number of (estimated or real) affected rows is 
saved for retrieval by ifx_affected_rows(). 
If you have BLOB (BYTE or TEXT) columns in an update query, you can add a 
blobidarray parameter containing the corresponding "blob ids", and you 
should replace those columns with a "?" in the query text. 
If the contents of the TEXT (or BYTE) column allow it, you can also use 
"ifx_textasvarchar(1)" and "ifx_byteasvarchar(1)". This allows you to 
treat TEXT (or BYTE) columns just as if they were ordinary (but long) 
VARCHAR columns for select queries, and you don't need to bother with blob 
id's. 
With ifx_textasvarchar(0) or ifx_byteasvarchar(0) (the default situation), 
select queries will return BLOB columns as blob id's (integer value). You 
can get the value of the blob as a string or file with the blob functions 
(see below). 
Example 1. Show all rows of the "orders" table as a HTML table 
  <?php
  ifx_textasvarchar(1);      // use "text mode" for blobs
  $res_id = ifx_query("select * from orders", $conn_id);
  if (! $res_id) {
      printf("Can't select orders : %s\n<br />%s<br />\n", 
  ifx_error());
      ifx_errormsg();
      die;
  }
  ifx_htmltbl_result($res_id, "border=\"1\"");
  ifx_free_result($res_id);
  ?> 

Example 2. Insert some values into the "catalog" table
  <?php

  // create blob id's for a byte and text column
  $textid = ifx_create_blob(0, 0, "Text column in memory");
  $byteid = ifx_create_blob(1, 0, "Byte column in memory");

  // store blob id's in a blobid array
  $blobidarray[] = $textid;
  $blobidarray[] = $byteid;

  // launch query
  $query = "insert into catalog (stock_num, manu_code, " .
	   "cat_descr,cat_picture) values(1,'HRO',?,?)";
  $res_id = ifx_query($query, $conn_id, $blobidarray);
  if (! $res_id) {
      /* ... error ... */
  }

  // free result id
  ifx_free_result($res_id);
  ?> 
See also ifx_connect().   ifx_prepareUpifx_textasvarchar
#

#T=int ifx_query ( string query, int link_identifier [, int cursor_type [, 
ifx_query ( ^!string query, int link_identifier [, int cursor_type [, ;
#

#T=ifx_textasvarchar - void ifx_textasvarchar ( int mode)
(PHP 3>= 3.0.4, PHP 4 )
ifx_textasvarchar -- Set the default text mode
Description
void ifx_textasvarchar ( int mode)
Sets the default text mode for all select-queries. Mode "0" will return a 
blob id, and mode "1" will return a varchar with text content.   ifx_queryUpifx_update_blob
#

#T=void ifx_textasvarchar ( int mode)
ifx_textasvarchar ( ^!int mode);
#

#T=ifx_update_blob - bool ifx_update_blob ( int bid, string content)
(PHP 3>= 3.0.4, PHP 4 )
ifx_update_blob -- Updates the content of the blob object
Description
bool ifx_update_blob ( int bid, string content)
Updates the content of the blob object for the given blob object bid. 
content is a string with new data. Returns TRUE on success or FALSE on 
failure.   ifx_textasvarcharUpifx_update_char
#

#T=bool ifx_update_blob ( int bid, string content)
ifx_update_blob ( ^!int bid, string content);
#

#T=ifx_update_char - int ifx_update_char ( int bid, string content)
(PHP 3>= 3.0.6, PHP 4 )
ifx_update_char -- Updates the content of the char object
Description
int ifx_update_char ( int bid, string content)
Updates the content of the char object for the given char object bid. 
content is a string with new data. Returns TRUE on success or FALSE on 
failure.   ifx_update_blobUpifxus_close_slob
#

#T=int ifx_update_char ( int bid, string content)
ifx_update_char ( ^!int bid, string content);
#

#T=ifxus_close_slob - int ifxus_close_slob ( int bid)
(PHP 3>= 3.0.4, PHP 4 )
ifxus_close_slob -- Deletes the slob object
Description
int ifxus_close_slob ( int bid)
Deletes the slob object on the given slob object-id bid. Returns TRUE on 
success or FALSE on failure.   ifx_update_charUpifxus_create_slob
#

#T=int ifxus_close_slob ( int bid)
ifxus_close_slob ( ^!int bid);
#

#T=ifxus_create_slob - int ifxus_create_slob ( int mode)
(PHP 3>= 3.0.4, PHP 4 )
ifxus_create_slob -- Creates an slob object and opens it
Description
int ifxus_create_slob ( int mode)
Creates an slob object and opens it. Modes: 1 = LO_RDONLY, 2 = LO_WRONLY, 
4 = LO_APPEND, 8 = LO_RDWR, 16 = LO_BUFFER, 32 = LO_NOBUFFER -> or-mask. 
You can also use constants named IFX_LO_RDONLY, IFX_LO_WRONLY etc. Return 
FALSE on error otherwise the new slob object-id.   ifxus_close_slobUpifxus_free_slob
#

#T=int ifxus_create_slob ( int mode)
ifxus_create_slob ( ^!int mode);
#

#T=ifxus_free_slob - int ifxus_free_slob ( int bid)
(PHP 3>= 3.0.4, PHP 4 )
ifxus_free_slob -- Deletes the slob object
Description
int ifxus_free_slob ( int bid)
Deletes the slob object. bid is the Id of the slob object. Returns TRUE on 
success or FALSE on failure.   ifxus_create_slobUpifxus_open_slob
#

#T=int ifxus_free_slob ( int bid)
ifxus_free_slob ( ^!int bid);
#

#T=ifxus_open_slob - int ifxus_open_slob ( long bid, int mode)
(PHP 3>= 3.0.4, PHP 4 )
ifxus_open_slob -- Opens an slob object
Description
int ifxus_open_slob ( long bid, int mode)
Opens an slob object. bid should be an existing slob id. Modes: 1 = 
LO_RDONLY, 2 = LO_WRONLY, 4 = LO_APPEND, 8 = LO_RDWR, 16 = LO_BUFFER, 32 = 
LO_NOBUFFER -> or-mask. Returns FALSE on error otherwise the new slob 
object-id.   ifxus_free_slobUpifxus_read_slob
#

#T=int ifxus_open_slob ( long bid, int mode)
ifxus_open_slob ( ^!long bid, int mode);
#

#T=ifxus_read_slob - int ifxus_read_slob ( long bid, long nbytes)
(PHP 3>= 3.0.4, PHP 4 )
ifxus_read_slob -- Reads nbytes of the slob object
Description
int ifxus_read_slob ( long bid, long nbytes)
Reads nbytes of the slob object. bid is a existing slob id and nbytes is 
the number of bytes read. Return FALSE on error otherwise the string.   ifxus_open_slobUpifxus_seek_slob
#

#T=int ifxus_read_slob ( long bid, long nbytes)
ifxus_read_slob ( ^!long bid, long nbytes);
#

#T=ifxus_seek_slob - int ifxus_seek_slob ( long bid, int mode, long offset)
(PHP 3>= 3.0.4, PHP 4 )
ifxus_seek_slob -- Sets the current file or seek position
Description
int ifxus_seek_slob ( long bid, int mode, long offset)
Sets the current file or seek position of an open slob object. bid should 
be an existing slob id. Modes: 0 = LO_SEEK_SET, 1 = LO_SEEK_CUR, 2 = 
LO_SEEK_END and offset is an byte offset. Return FALSE on error otherwise 
the seek position.   ifxus_read_slobUpifxus_tell_slob
#

#T=int ifxus_seek_slob ( long bid, int mode, long offset)
ifxus_seek_slob ( ^!long bid, int mode, long offset);
#

#T=ifxus_tell_slob - int ifxus_tell_slob ( long bid)
(PHP 3>= 3.0.4, PHP 4 )
ifxus_tell_slob -- Returns the current file or seek position
Description
int ifxus_tell_slob ( long bid)
Returns the current file or seek position of an open slob object bid 
should be an existing slob id. Return FALSE on error otherwise the seek 
position.   ifxus_seek_slobUpifxus_write_slob
#

#T=int ifxus_tell_slob ( long bid)
ifxus_tell_slob ( ^!long bid);
#

#T=ifxus_write_slob - int ifxus_write_slob ( long bid, string content)
(PHP 3>= 3.0.4, PHP 4 )
ifxus_write_slob -- Writes a string into the slob object
Description
int ifxus_write_slob ( long bid, string content)
Writes a string into the slob object. bid is an existing slob id and 
content the content to write. Return FALSE on error otherwise bytes 
written.   ifxus_tell_slobUpInterBase functions
#

#T=int ifxus_write_slob ( long bid, string content)
ifxus_write_slob ( ^!long bid, string content);
#

#T=ignore_user_abort - int ignore_user_abort ( [bool setting])
(PHP 3>= 3.0.7, PHP 4 )
ignore_user_abort --  Set whether a client disconnect should abort script 
execution 
Description
int ignore_user_abort ( [bool setting])
This function sets whether a client disconnect should cause a script to be 
aborted. It will return the previous setting and can be called without an 
argument to not change the current setting and only return the current 
setting. See the Connection Handling section in the Features chapter for a 
complete description of connection handling in PHP. 
See also connection_aborted(), and connection_status().   highlight_stringUppack
#

#T=int ignore_user_abort ( [bool setting])
ignore_user_abort ( ^![bool setting]);
#

#T=image_type_to_mime_type - string image_type_to_mime_type ( int imagetype)
(PHP 4 >= 4.3.0)
image_type_to_mime_type -- Get Mime-Type for image-type returned by 
getimagesize, exif_read_data, exif_thumbnail, exif_imagetype
Description
string image_type_to_mime_type ( int imagetype)
The image_type_to_mime_type() function will determine the Mime-Type for an 
IMAGETYPE constant. Example 1. image_type_to_mime_type (file)
  <?php
  header("Content-type: " . 
  image_type_to_mime_type(IMAGETYPE_PNG));
  ?> 
The returned values are as follows 
Table 1. Returned values Constants
imagetypeReturned value
IMAGETYPE_GIFimage/gif
IMAGETYPE_JPEGimage/jpeg
IMAGETYPE_PNGimage/png
IMAGETYPE_SWFapplication/x-shockwave-flash
IMAGETYPE_PSDimage/psd
IMAGETYPE_BMPimage/bmp
IMAGETYPE_TIFF_II (intel byte order)image/tiff
IMAGETYPE_TIFF_MM (motorola byte order) image/tiff
IMAGETYPE_JPCapplication/octet-stream
IMAGETYPE_JP2image/jp2
IMAGETYPE_JPXapplication/octet-stream
IMAGETYPE_JB2application/octet-stream
IMAGETYPE_SWCapplication/x-shockwave-flash
IMAGETYPE_IFFimage/iff
IMAGETYPE_WBMPimage/vnd.wap.wbmp
IMAGETYPE_XBMimage/xbm

Note: This function does not require the GD image library. 
See also getimagesize(), exif_imagetype(), exif_read_data() and 
exif_thumbnail().   getimagesizeUpimage2wbmp
#

#T=string image_type_to_mime_type ( int imagetype)
image_type_to_mime_type ( ^!int imagetype);
#

#T=image2wbmp - int image2wbmp ( resource image [, string filename [, int threshold]])
(PHP 4 >= 4.0.5)
image2wbmp -- Output image to browser or file
Description
int image2wbmp ( resource image [, string filename [, int threshold]])
image2wbmp() creates the WBMP file in filename from the image image. The 
image argument is the return from imagecreate(). 
The filename argument is optional, and if left off, the raw image stream 
will be output directly. By sending an image/vnd.wap.wbmp content-type 
using header(), you can create a PHP script that outputs WBMP images 
directly. 
Example 1. image2wbmp() example
  <?php

  $file = 'php.jpg';

  header('Content-type: ' . 
  image_type_to_mime_type(IMAGETYPE_WBMP));
  image2wbmp($file); // output the stream directly

  ?> 
Note: WBMP support is only available if PHP was compiled against GD-1.8 
or later. 
See also imagewbmp().   image_type_to_mime_typeUpimagealphablending
#

#T=int image2wbmp ( resource image [, string filename [, int threshold]])
image2wbmp ( ^!resource image [, string filename [, int threshold]]);
#

#T=imagealphablending - bool imagealphablending ( resource image, bool blendmode)
(PHP 4 >= 4.0.6)
imagealphablending -- Set the blending mode for an image
Description
bool imagealphablending ( resource image, bool blendmode)
imagealphablending() allows for two different modes of drawing on 
truecolor images. In blending mode, the alpha channel component of the 
color supplied to all drawing function, such as imagesetpixel() determines 
how much of the underlying color should be allowed to shine through. As a 
result, gd automatically blends the existing color at that point with the 
drawing color, and stores the result in the image. The resulting pixel is 
opaque. In non-blending mode, the drawing color is copied literally with 
its alpha channel information, replacing the destination pixel. Blending 
mode is not available when drawing on palette images. If blendmode is 
TRUE, then blending mode is enabled, otherwise disabled. Returns TRUE on 
success or FALSE on failure. 
Note: This function was added in PHP 4.0.6 and requires GD 2.0.1   image2wbmpUpimageantialias
#

#T=bool imagealphablending ( resource image, bool blendmode)
imagealphablending ( ^!resource image, bool blendmode);
#

#T=imageantialias - bool imageantialias ( resource im, bool on)
(PHP 4 >= 4.3.2)
imageantialias --  Should antialias functions be used or not 
Description
bool imageantialias ( resource im, bool on)
Warning
This function is currently not documented; only the argument list is 
available.

See also imagecreatetruecolor().   imagealphablendingUpimagearc
#

#T=bool imageantialias ( resource im, bool on)
imageantialias ( ^!resource im, bool on);
#

#T=imagearc - int imagearc ( resource image, int cx, int cy, int w, int h, int s, int e, 
(PHP 3, PHP 4 )
imagearc -- Draw a partial ellipse
Description
int imagearc ( resource image, int cx, int cy, int w, int h, int s, int e, 
int color)
imagearc() draws a partial ellipse centered at cx, cy (top left is 0, 0) 
in the image represented by image. W and h specifies the ellipse's width 
and height respectively while the start and end points are specified in 
degrees indicated by the s and e arguments. 0 is located at the 
three-o'clock position, and the arc is drawn counter-clockwise. 
Example 1. Drawing a circle with imagearc()
  <?php

  // create a 200*200 image
  $img = imagecreate(200, 200);

  // allocate some colors
  $white = imagecolorallocate($img, 255, 255, 255);
     
  // draw a white circle 
  imagearc($img, 100, 100, 150, 150, 0, 360, $white);

  // output image in the browser
  header("Content-type: image/png");
  imagepng($img);
     
  // free memory
  imagedestroy($img);

  ?> 
See also imageellipse(), imagefilledellipse(), and imagefilledarc().   imageantialiasUpimagechar
#

#T=int imagearc ( resource image, int cx, int cy, int w, int h, int s, int e, 
imagearc ( ^!resource image, int cx, int cy, int w, int h, int s, int e, ;
#

#T=imagechar - int imagechar ( resource image, int font, int x, int y, string c, int 
(PHP 3, PHP 4 )
imagechar -- Draw a character horizontally
Description
int imagechar ( resource image, int font, int x, int y, string c, int 
color)
imagechar() draws the first character of c in the image identified by 
image with its upper-left at x,y (top left is 0, 0) with the color color. 
If font is 1, 2, 3, 4 or 5, a built-in font is used (with higher numbers 
corresponding to larger fonts). 
Example 1. imagechar() example
  <?php

  $im = imagecreate(100, 100);

  $string = 'PHP';

  $bg = imagecolorallocate($im, 255, 255, 255);
  $black = imagecolorallocate($im, 0, 0, 0);

  // prints a black "P" in the top left corner
  imagechar($im, 1, 0, 0, $string, $black);

  header('Content-type: image/png');
  imagepng($im);

  ?> 
See also imagecharup() and imageloadfont().   imagearcUpimagecharup
#

#T=int imagechar ( resource image, int font, int x, int y, string c, int 
imagechar ( ^!resource image, int font, int x, int y, string c, int ;
#

#T=imagecharup - int imagecharup ( resource image, int font, int x, int y, string c, int 
(PHP 3, PHP 4 )
imagecharup -- Draw a character vertically
Description
int imagecharup ( resource image, int font, int x, int y, string c, int 
color)
imagecharup() draws the character c vertically in the image identified by 
image at coordinates x, y (top left is 0, 0) with the color color. If font 
is 1, 2, 3, 4 or 5, a built-in font is used. 
Example 1. imagecharup() example
  <?php

  $im = imagecreate(100, 100);

  $string = 'Note that the first letter is a N';

  $bg = imagecolorallocate($im, 255, 255, 255);
  $black = imagecolorallocate($im, 0, 0, 0);

  // prints a black "Z" on a white background
  imagecharup($im, 3, 10, 10, $string, $black);

  header('Content-type: image/png');
  imagepng($im);

  ?> 
See also imagechar() and imageloadfont().   imagecharUpimagecolorallocate
#

#T=int imagecharup ( resource image, int font, int x, int y, string c, int 
imagecharup ( ^!resource image, int font, int x, int y, string c, int ;
#

#T=imagecolorallocate - int imagecolorallocate ( resource image, int red, int green, int blue)
(PHP 3, PHP 4 )
imagecolorallocate -- Allocate a color for an image
Description
int imagecolorallocate ( resource image, int red, int green, int blue)
imagecolorallocate() returns a color identifier representing the color 
composed of the given RGB components. The image argument is the return 
from the imagecreate() function. red, green and blue are the values of the 
red, green and blue component of the requested color respectively. These 
parameters are integers between 0 and 255 or hexadecimals between 0x00 and 
0xFF. imagecolorallocate() must be called to create each color that is to 
be used in the image represented by image. 
Note: The first call to imagecolorallocate() fills the background color. 

<?php

// sets background to red
$background = imagecolorallocate($im, 255, 0, 0);

// sets some colors
$white = imagecolorallocate($im, 255, 255, 255);
$black = imagecolorallocate($im, 0, 0, 0);

// hexadecimal way
$white = imagecolorallocate($im, 0xFF, 0xFF, 0xFF);
$black = imagecolorallocate($im, 0x00, 0x00, 0x00);

?> 

Returns -1 if the allocation failed. 
See also imagecolorallocatealpha() and imagecolordeallocate().   imagecharupUpimagecolorallocatealpha
#

#T=int imagecolorallocate ( resource image, int red, int green, int blue)
imagecolorallocate ( ^!resource image, int red, int green, int blue);
#

#T=imagecolorallocatealpha - int imagecolorallocatealpha ( resource image, int red, int green, int 
(PHP 4 >= 4.3.2)
imagecolorallocatealpha -- Allocate a color for an image
Description
int imagecolorallocatealpha ( resource image, int red, int green, int 
blue, int alpha)
imagecolorallocatealpha() behaves identically to imagecolorallocate() with 
the addition of the transparency parameter alpha which may have a value 
between 0 and 127. 0 indicates completely opaque while 127 indicates 
completely transparent. 
Returns FALSE if the allocation failed. 
Example 1. Example of using imagecolorallocatealpha()
  <?php
  $size = 300;
  $image=imagecreatetruecolor($size, $size);

  // something to get a white background with black border
  $back = imagecolorallocate($image, 255, 255, 255);
  $border = imagecolorallocate($image, 0, 0, 0);
  imagefilledrectangle($image, 0, 0, $size - 1, $size - 1, 
  $back);
  imagerectangle($image, 0, 0, $size - 1, $size - 1, $border);

  $yellow_x = 100;
  $yellow_y = 75;
  $red_x    = 120;
  $red_y    = 165; 
  $blue_x   = 187;
  $blue_y   = 125; 
  $radius   = 150;

  // allocate colors with alpha values
  $yellow = imagecolorallocatealpha($image, 255, 255, 0, 75);
  $red    = imagecolorallocatealpha($image, 255, 0, 0, 75);
  $blue   = imagecolorallocatealpha($image, 0, 0, 255, 75);

  // drawing 3 overlapped circle
  imagefilledellipse($image, $yellow_x, $yellow_y, $radius, 
  $radius, $yellow);
  imagefilledellipse($image, $red_x, $red_y, $radius, $radius, 
  $red);   
  imagefilledellipse($image, $blue_x, $blue_y, $radius, $radius, 
  $blue);

  // don't forget to output a correct header!
  header('Content-type: image/png');

  // and finally, output the result
  imagepng($image);
  imagedestroy($image);
  ?> 
See also imagecolorallocate() and imagecolordeallocate().   imagecolorallocateUpimagecolorat
#

#T=int imagecolorallocatealpha ( resource image, int red, int green, int 
imagecolorallocatealpha ( ^!resource image, int red, int green, int ;
#

#T=imagecolorat - int imagecolorat ( resource image, int x, int y)
(PHP 3, PHP 4 )
imagecolorat -- Get the index of the color of a pixel
Description
int imagecolorat ( resource image, int x, int y)
Returns the index of the color of the pixel at the specified location in 
the image specified by image. 
If PHP is compiled against GD library 2.0 or higher and the image is a 
truecolor image, this function returns the RGB value of that pixel as 
integer. Use bitshifting and masking to access the distinct red, green and 
blue component values: Example 1. Access distinct RGB values
  <?php
  $im = ImageCreateFromPng("rockym.png");
  $rgb = ImageColorAt($im, 100, 100);
  $r = ($rgb >> 16) & 0xFF;
  $g = ($rgb >> 8) & 0xFF;
  $b = $rgb & 0xFF;
  ?> 
See also imagecolorset() and imagecolorsforindex().   imagecolorallocatealphaUpimagecolorclosest
#

#T=int imagecolorat ( resource image, int x, int y)
imagecolorat ( ^!resource image, int x, int y);
#

#T=imagecolorclosest - int imagecolorclosest ( resource image, int red, int green, int blue)
(PHP 3, PHP 4 )
imagecolorclosest -- Get the index of the closest color to the specified 
color
Description
int imagecolorclosest ( resource image, int red, int green, int blue)
Returns the index of the color in the palette of the image which is 
"closest" to the specified RGB value. 
The "distance" between the desired color and each color in the palette is 
calculated as if the RGB values represented points in three-dimensional 
space. 
See also imagecolorexact().   imagecoloratUpimagecolorclosestalpha
#

#T=int imagecolorclosest ( resource image, int red, int green, int blue)
imagecolorclosest ( ^!resource image, int red, int green, int blue);
#

#T=imagecolorclosestalpha - int imagecolorclosestalpha ( resource image, int red, int green, int blue, 
(PHP 4 >= 4.0.6)
imagecolorclosestalpha -- Get the index of the closest color to the 
specified color + alpha
Description
int imagecolorclosestalpha ( resource image, int red, int green, int blue, 
int alpha)
Returns the index of the color in the palette of the image which is 
"closest" to the specified RGB value and alpha level. 
Note: This function was added in PHP 4.0.6 and requires GD 2.0.1 
See also imagecolorexactalpha().   imagecolorclosestUpimagecolorclosesthwb
#

#T=int imagecolorclosestalpha ( resource image, int red, int green, int blue, 
imagecolorclosestalpha ( ^!resource image, int red, int green, int blue, ;
#

#T=imagecolorclosesthwb - int imagecolorclosesthwb ( resource image, int red, int green, int blue)
(PHP 4 >= 4.0.1)
imagecolorclosesthwb --  Get the index of the color which has the hue, 
white and blackness nearest to the given color 
Description
int imagecolorclosesthwb ( resource image, int red, int green, int blue)
Warning
This function is currently not documented; only the argument list is 
available.
  imagecolorclosestalphaUpimagecolordeallocate
#

#T=int imagecolorclosesthwb ( resource image, int red, int green, int blue)
imagecolorclosesthwb ( ^!resource image, int red, int green, int blue);
#

#T=imagecolordeallocate - int imagecolordeallocate ( resource image, int color)
(PHP 3>= 3.0.6, PHP 4 )
imagecolordeallocate -- De-allocate a color for an image
Description
int imagecolordeallocate ( resource image, int color)
The imagecolordeallocate() function de-allocates a color previously 
allocated with imagecolorallocate() or imagecolorallocatealpha(). 
<?php
$white = imagecolorallocate($im, 255, 255, 255);
imagecolordeallocate($im, $white);
?> 

See also imagecolorallocate() and imagecolorallocatealpha().   imagecolorclosesthwbUpimagecolorexact
#

#T=int imagecolordeallocate ( resource image, int color)
imagecolordeallocate ( ^!resource image, int color);
#

#T=imagecolorexact - int imagecolorexact ( resource image, int red, int green, int blue)
(PHP 3, PHP 4 )
imagecolorexact -- Get the index of the specified color
Description
int imagecolorexact ( resource image, int red, int green, int blue)
Returns the index of the specified color in the palette of the image. 
If the color does not exist in the image's palette, -1 is returned. 
See also imagecolorclosest().   imagecolordeallocateUpimagecolorexactalpha
#

#T=int imagecolorexact ( resource image, int red, int green, int blue)
imagecolorexact ( ^!resource image, int red, int green, int blue);
#

#T=imagecolorexactalpha - int imagecolorexactalpha ( resource image, int red, int green, int blue, 
(PHP 4 >= 4.0.6)
imagecolorexactalpha -- Get the index of the specified color + alpha
Description
int imagecolorexactalpha ( resource image, int red, int green, int blue, 
int alpha)
Returns the index of the specified color+alpha in the palette of the 
image. 
If the color does not exist in the image's palette, -1 is returned. 
See also imagecolorclosestalpha(). 
Note: This function was added in PHP 4.0.6 and requires GD 2.0.1 or 
later  imagecolorexactUpimagecolormatch
#

#T=int imagecolorexactalpha ( resource image, int red, int green, int blue, 
imagecolorexactalpha ( ^!resource image, int red, int green, int blue, ;
#

#T=imagecolormatch - bool imagecolormatch ( resource image1, resource image2)
(PHP 4 >= 4.3.0)
imagecolormatch --  Makes the colors of the palette version of an image 
more closely match the true color version 
Description
bool imagecolormatch ( resource image1, resource image2)
Warning
This function is currently not documented; only the argument list is 
available.

image1 must be Truecolor, image2 must be Palette, and both image1 and 
image2 must be the same size. 
Returns TRUE on success or FALSE on failure. 
See also imagecreatetruecolor().   imagecolorexactalphaUpimagecolorresolve
#

#T=bool imagecolormatch ( resource image1, resource image2)
imagecolormatch ( ^!resource image1, resource image2);
#

#T=imagecolorresolve - int imagecolorresolve ( resource image, int red, int green, int blue)
(PHP 3>= 3.0.2, PHP 4 )
imagecolorresolve --  Get the index of the specified color or its closest 
possible alternative 
Description
int imagecolorresolve ( resource image, int red, int green, int blue)
This function is guaranteed to return a color index for a requested color, 
either the exact color or the closest possible alternative. 
See also imagecolorclosest().   imagecolormatchUpimagecolorresolvealpha
#

#T=int imagecolorresolve ( resource image, int red, int green, int blue)
imagecolorresolve ( ^!resource image, int red, int green, int blue);
#

#T=imagecolorresolvealpha - int imagecolorresolvealpha ( resource image, int red, int green, int blue, 
(PHP 4 >= 4.0.6)
imagecolorresolvealpha --  Get the index of the specified color + alpha or 
its closest possible alternative 
Description
int imagecolorresolvealpha ( resource image, int red, int green, int blue, 
int alpha)
This function is guaranteed to return a color index for a requested color, 
either the exact color or the closest possible alternative. 
See also imagecolorclosestalpha(). 
Note: This function was added in PHP 4.0.6 and requires GD 2.0.1  imagecolorresolveUpimagecolorset
#

#T=int imagecolorresolvealpha ( resource image, int red, int green, int blue, 
imagecolorresolvealpha ( ^!resource image, int red, int green, int blue, ;
#

#T=imagecolorset - bool imagecolorset ( resource image, int index, int red, int green, int 
(PHP 3, PHP 4 )
imagecolorset -- Set the color for the specified palette index
Description
bool imagecolorset ( resource image, int index, int red, int green, int 
blue)
This sets the specified index in the palette to the specified color. This 
is useful for creating flood-fill-like effects in palleted images without 
the overhead of performing the actual flood-fill. 
See also imagecolorat().   imagecolorresolvealphaUpimagecolorsforindex
#

#T=bool imagecolorset ( resource image, int index, int red, int green, int 
imagecolorset ( ^!resource image, int index, int red, int green, int ;
#

#T=imagecolorsforindex - array imagecolorsforindex ( resource image, int index)
(PHP 3, PHP 4 )
imagecolorsforindex -- Get the colors for an index
Description
array imagecolorsforindex ( resource image, int index)
This returns an associative array with red, green, blue and alpha keys 
that contain the appropriate values for the specified color index. 
Example 1. imagecolorsforindex() example
  <?php

  // open an image
  $im = imagecreatefrompng('nexen.png');

  // get a color
  $start_x = 40;
  $start_y = 50;
  $color_index = imagecolorat($im, $start_x, $start_y);

  // make it human readable
  $color_tran = imagecolorsforindex($im, $color_index);

  // what is it ?
  echo '<pre>';
  print_r($color_tran);
  echo '</pre>';

  ?> 

This example will output : 
Array
(
[red] => 226
[green] => 222
[blue] => 252
[alpha] => 0
)
See also imagecolorat() and imagecolorexact().   imagecolorsetUpimagecolorstotal
#

#T=array imagecolorsforindex ( resource image, int index)
imagecolorsforindex ( ^!resource image, int index);
#

#T=imagecolorstotal - int imagecolorstotal ( resource image)
(PHP 3, PHP 4 )
imagecolorstotal -- Find out the number of colors in an image's palette
Description
int imagecolorstotal ( resource image)
This returns the number of colors in the specified image's palette. 
See also imagecolorat() and imagecolorsforindex().   imagecolorsforindexUpimagecolortransparent
#

#T=int imagecolorstotal ( resource image)
imagecolorstotal ( ^!resource image);
#

#T=imagecolortransparent - int imagecolortransparent ( resource image [, int color])
(PHP 3, PHP 4 )
imagecolortransparent -- Define a color as transparent
Description
int imagecolortransparent ( resource image [, int color])
imagecolortransparent() sets the transparent color in the image image to 
color. image is the image identifier returned by imagecreate() and color 
is a color identifier returned by imagecolorallocate(). 
Note: The transparent color is a property of the image, transparency is 
not a property of the color. Once you have a set a color to be the 
transparent color, any regions of the image in that color that were 
drawn previously will be transparent. 
The identifier of the new (or current, if none is specified) transparent 
color is returned.   imagecolorstotalUpimagecopy
#

#T=int imagecolortransparent ( resource image [, int color])
imagecolortransparent ( ^!resource image [, int color]);
#

#T=imagecopy - int imagecopy ( resource dst_im, resource src_im, int dst_x, int dst_y, 
(PHP 3>= 3.0.6, PHP 4 )
imagecopy -- Copy part of an image
Description
int imagecopy ( resource dst_im, resource src_im, int dst_x, int dst_y, 
int src_x, int src_y, int src_w, int src_h)
Copy a part of src_im onto dst_im starting at the x,y coordinates src_x, 
src_y with a width of src_w and a height of src_h. The portion defined 
will be copied onto the x,y coordinates, dst_x and dst_y.   imagecolortransparentUpimagecopymerge
#

#T=int imagecopy ( resource dst_im, resource src_im, int dst_x, int dst_y, 
imagecopy ( ^!resource dst_im, resource src_im, int dst_x, int dst_y, ;
#

#T=imagecopymerge - int imagecopymerge ( resource dst_im, resource src_im, int dst_x, int 
(PHP 4 >= 4.0.1)
imagecopymerge -- Copy and merge part of an image
Description
int imagecopymerge ( resource dst_im, resource src_im, int dst_x, int 
dst_y, int src_x, int src_y, int src_w, int src_h, int pct)
Copy a part of src_im onto dst_im starting at the x,y coordinates src_x, 
src_y with a width of src_w and a height of src_h. The portion defined 
will be copied onto the x,y coordinates, dst_x and dst_y. The two images 
will be merged according to pct which can range from 0 to 100. When pct = 
0, no action is taken, when 100 this function behaves identically to 
imagecopy(). 
Note: This function was added in PHP 4.0.6  imagecopyUpimagecopymergegray
#

#T=int imagecopymerge ( resource dst_im, resource src_im, int dst_x, int 
imagecopymerge ( ^!resource dst_im, resource src_im, int dst_x, int ;
#

#T=imagecopymergegray - int imagecopymergegray ( resource dst_im, resource src_im, int dst_x, int 
(PHP 4 >= 4.0.6)
imagecopymergegray -- Copy and merge part of an image with gray scale
Description
int imagecopymergegray ( resource dst_im, resource src_im, int dst_x, int 
dst_y, int src_x, int src_y, int src_w, int src_h, int pct)
imagecopymergegray() copy a part of src_im onto dst_im starting at the x,y 
coordinates src_x, src_y with a width of src_w and a height of src_h. The 
portion defined will be copied onto the x,y coordinates, dst_x and dst_y. 
The two images will be merged according to pct which can range from 0 to 
100. When pct = 0, no action is taken, when 100 this function behaves 
identically to imagecopy(). 
This function is identical to imagecopymerge() except that when merging it 
preserves the hue of the source by converting the destination pixels to 
gray scale before the copy operation. 
Note: This function was added in PHP 4.0.6  imagecopymergeUpimagecopyresampled
#

#T=int imagecopymergegray ( resource dst_im, resource src_im, int dst_x, int 
imagecopymergegray ( ^!resource dst_im, resource src_im, int dst_x, int ;
#

#T=imagecopyresampled - bool imagecopyresampled ( resource dst_im, resource src_im, int dstX, int 
(PHP 4 >= 4.0.6)
imagecopyresampled -- Copy and resize part of an image with resampling
Description
bool imagecopyresampled ( resource dst_im, resource src_im, int dstX, int 
dstY, int srcX, int srcY, int dstW, int dstH, int srcW, int srcH)
imagecopyresampled() copies a rectangular portion of one image to another 
image, smoothly interpolating pixel values so that, in particular, 
reducing the size of an image still retains a great deal of clarity. 
Returns TRUE on success or FALSE on failure. dst_im is the destination 
image, src_im is the source image identifier. If the source and 
destination coordinates and width and heights differ, appropriate 
stretching or shrinking of the image fragment will be performed. The 
coordinates refer to the upper left corner. This function can be used to 
copy regions within the same image (if dst_im is the same as src_im) but 
if the regions overlap the results will be unpredictable. 
Note: There is a problem due to palette image limitations (255+1 
colors). Resampling or filtering an image commonly needs more colors 
than 255, a kind of approximation is used to calculate the new resampled 
pixel and its color. With a palette image we try to allocate a new 
color, if that failed, we choose the closest (in theory) computed color. 
This is not always the closest visual color. That may produce a weird 
result, like blank (or visually blank) images. To skip this problem, 
please use a truecolor image as a destination image, such as one created 
by imagecreatetruecolor(). 
Note: imagecopyresampled() requires GD 2.0.l or greater. 
See also imagecopyresized().   imagecopymergegrayUpimagecopyresized
#

#T=bool imagecopyresampled ( resource dst_im, resource src_im, int dstX, int 
imagecopyresampled ( ^!resource dst_im, resource src_im, int dstX, int ;
#

#T=imagecopyresized - int imagecopyresized ( resource dst_im, resource src_im, int dstX, int 
(PHP 3, PHP 4 )
imagecopyresized -- Copy and resize part of an image
Description
int imagecopyresized ( resource dst_im, resource src_im, int dstX, int 
dstY, int srcX, int srcY, int dstW, int dstH, int srcW, int srcH)
imagecopyresized() copies a rectangular portion of one image to another 
image. Dst_im is the destination image, src_im is the source image 
identifier. If the source and destination coordinates and width and 
heights differ, appropriate stretching or shrinking of the image fragment 
will be performed. The coordinates refer to the upper left corner. This 
function can be used to copy regions within the same image (if dst_im is 
the same as src_im) but if the regions overlap the results will be 
unpredictable. 
Note: There is a problem due to palette image limitations (255+1 
colors). Resampling or filtering an image commonly needs more colors 
than 255, a kind of approximation is used to calculate the new resampled 
pixel and its color. With a palette image we try to allocate a new 
color, if that failed, we choose the closest (in theory) computed color. 
This is not always the closest visual color. That may produce a weird 
result, like blank (or visually blank) images. To skip this problem, 
please use a truecolor image as a destination image, such as one created 
by imagecreatetruecolor(). 
See also imagecopyresampled().   imagecopyresampledUpimagecreate
#

#T=int imagecopyresized ( resource dst_im, resource src_im, int dstX, int 
imagecopyresized ( ^!resource dst_im, resource src_im, int dstX, int ;
#

#T=imagecreate - resource imagecreate ( int x_size, int y_size)
(PHP 3, PHP 4 )
imagecreate -- Create a new palette based image
Description
resource imagecreate ( int x_size, int y_size)
imagecreate() returns an image identifier representing a blank image of 
size x_size by y_size. 
We recommend the use of imagecreatetruecolor(). 
Example 1. Creating a new GD image stream and outputting an image. 
  <?php
  header("Content-type: image/png");
  $im = @imagecreate(50, 100)
      or die("Cannot Initialize new GD image stream");
  $background_color = imagecolorallocate($im, 255, 255, 255);
  $text_color = imagecolorallocate($im, 233, 14, 91);
  imagestring($im, 1, 5, 5,  "A Simple Text String", 
  $text_color);
  imagepng($im);
  imagedestroy($im);
  ?> 
See also imagedestroy() and imagecreatetruecolor().   imagecopyresizedUpimagecreatefromgd2
#

#T=resource imagecreate ( int x_size, int y_size)
imagecreate ( ^!int x_size, int y_size);
#

#T=imagecreatefromgd - resource imagecreatefromgd ( string filename)
(PHP 4 >= 4.1.0)
imagecreatefromgd -- Create a new image from GD file or URL
Description
resource imagecreatefromgd ( string filename)
Warning
This function is currently not documented; only the argument list is 
available.

Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Warning
Windows versions of PHP prior to PHP 4.3.0 do not support accessing 
remote files via this function, even if allow_url_fopen is enabled. 
  imagecreatefromgd2partUpimagecreatefromgif
#

#T=resource imagecreatefromgd ( string filename)
imagecreatefromgd ( ^!string filename);
#

#T=imagecreatefromgd2 - resource imagecreatefromgd2 ( string filename)
(PHP 4 >= 4.1.0)
imagecreatefromgd2 -- Create a new image from GD2 file or URL
Description
resource imagecreatefromgd2 ( string filename)
Warning
This function is currently not documented; only the argument list is 
available.

Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Warning
Windows versions of PHP prior to PHP 4.3.0 do not support accessing 
remote files via this function, even if allow_url_fopen is enabled. 
  imagecreateUpimagecreatefromgd2part
#

#T=resource imagecreatefromgd2 ( string filename)
imagecreatefromgd2 ( ^!string filename);
#

#T=imagecreatefromgd2part - resource imagecreatefromgd2part ( string filename, int srcX, int srcY, int 
(PHP 4 >= 4.1.0)
imagecreatefromgd2part -- Create a new image from a given part of GD2 file 
or URL
Description
resource imagecreatefromgd2part ( string filename, int srcX, int srcY, int 
width, int height)
Warning
This function is currently not documented; only the argument list is 
available.

Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Warning
Windows versions of PHP prior to PHP 4.3.0 do not support accessing 
remote files via this function, even if allow_url_fopen is enabled. 
  imagecreatefromgd2Upimagecreatefromgd
#

#T=resource imagecreatefromgd2part ( string filename, int srcX, int srcY, int 
imagecreatefromgd2part ( ^!string filename, int srcX, int srcY, int ;
#

#T=imagecreatefromgif - resource imagecreatefromgif ( string filename)
(PHP 3, PHP 4 )
imagecreatefromgif -- Create a new image from file or URL
Description
resource imagecreatefromgif ( string filename)
imagecreatefromgif() returns an image identifier representing the image 
obtained from the given filename. 
imagecreatefromgif() returns an empty string on failure. It also outputs 
an error message, which unfortunately displays as a broken link in a 
browser. To ease debugging the following example will produce an error 
GIF: Example 1. Example to handle an error during creation (courtesy 
vic at zymsys dot com) 
  <?php
  function LoadGif ($imgname) {
      $im = @imagecreatefromgif ($imgname); /* Attempt to open 
*/
      if (!$im) { /* See if it failed */
	  $im = imagecreate (150, 30); /* Create a blank image 
*/
	  $bgc = imagecolorallocate ($im, 255, 255, 255);
	  $tc = imagecolorallocate ($im, 0, 0, 0);
	  imagefilledrectangle ($im, 0, 0, 150, 30, $bgc);
	  /* Output an errmsg */
	  imagestring ($im, 1, 5, 5, "Error loading $imgname", 
  $tc);
      }
      return $im;
  }
  ?> 
Note: Since all GIF support was removed from the GD library in version 
1.6, this function is not available if you are using that version of the 
GD library. 
Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Warning
Windows versions of PHP prior to PHP 4.3.0 do not support accessing 
remote files via this function, even if allow_url_fopen is enabled. 
  imagecreatefromgdUpimagecreatefromjpeg
#

#T=resource imagecreatefromgif ( string filename)
imagecreatefromgif ( ^!string filename);
#

#T=imagecreatefromjpeg - resource imagecreatefromjpeg ( string filename)
(PHP 3>= 3.0.16, PHP 4 )
imagecreatefromjpeg -- Create a new image from file or URL
Description
resource imagecreatefromjpeg ( string filename)
imagecreatefromjpeg() returns an image identifier representing the image 
obtained from the given filename. 
imagecreatefromjpeg() returns an empty string on failure. It also outputs 
an error message, which unfortunately displays as a broken link in a 
browser. To ease debugging the following example will produce an error 
JPEG: Example 1. Example to handle an error during creation 
(courtesy vic at zymsys dot com ) 
  <?php
  function LoadJpeg($imgname) {
      $im = @imagecreatefromjpeg($imgname); /* Attempt to open 
*/
      if (!$im) { /* See if it failed */
	  $im  = imagecreate(150, 30); /* Create a blank image 
*/
	  $bgc = imagecolorallocate($im, 255, 255, 255);
	  $tc  = imagecolorallocate($im, 0, 0, 0);
	  imagefilledrectangle($im, 0, 0, 150, 30, $bgc);
	  /* Output an errmsg */
	  imagestring($im, 1, 5, 5, "Error loading $imgname", 
  $tc);
      }
      return $im;
  }
  ?> 
Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Warning
Windows versions of PHP prior to PHP 4.3.0 do not support accessing 
remote files via this function, even if allow_url_fopen is enabled. 
  imagecreatefromgifUpimagecreatefrompng
#

#T=resource imagecreatefromjpeg ( string filename)
imagecreatefromjpeg ( ^!string filename);
#

#T=imagecreatefrompng - resource imagecreatefrompng ( string filename)
(PHP 3>= 3.0.13, PHP 4 )
imagecreatefrompng -- Create a new image from file or URL
Description
resource imagecreatefrompng ( string filename)
imagecreatefrompng() returns an image identifier representing the image 
obtained from the given filename. 
imagecreatefrompng() returns an empty string on failure. It also outputs 
an error message, which unfortunately displays as a broken link in a 
browser. To ease debugging the following example will produce an error 
PNG: Example 1. Example to handle an error during creation (courtesy 
vic at zymsys dot com) 
  <?php
  function LoadPNG($imgname) {
      $im = @imagecreatefrompng($imgname); /* Attempt to open */
      if (!$im) { /* See if it failed */
	  $im  = imagecreate(150, 30); /* Create a blank image 
*/
	  $bgc = imagecolorallocate($im, 255, 255, 255);
	  $tc  = imagecolorallocate($im, 0, 0, 0);
	  imagefilledrectangle($im, 0, 0, 150, 30, $bgc);
	  /* Output an errmsg */
	  imagestring($im, 1, 5, 5, "Error loading $imgname", 
  $tc);
      }
      return $im;
  }
  ?> 
Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Warning
Windows versions of PHP prior to PHP 4.3.0 do not support accessing 
remote files via this function, even if allow_url_fopen is enabled. 
  imagecreatefromjpegUpimagecreatefromstring
#

#T=resource imagecreatefrompng ( string filename)
imagecreatefrompng ( ^!string filename);
#

#T=imagecreatefromstring - resource imagecreatefromstring ( string image)
(PHP 4 >= 4.0.4)
imagecreatefromstring -- Create a new image from the image stream in the 
string
Description
resource imagecreatefromstring ( string image)
imagecreatefromstring() returns an image identifier representing the image 
obtained from the given string.   imagecreatefrompngUpimagecreatefromwbmp
#

#T=resource imagecreatefromstring ( string image)
imagecreatefromstring ( ^!string image);
#

#T=imagecreatefromwbmp - resource imagecreatefromwbmp ( string filename)
(PHP 4 >= 4.0.1)
imagecreatefromwbmp -- Create a new image from file or URL
Description
resource imagecreatefromwbmp ( string filename)
imagecreatefromwbmp() returns an image identifier representing the image 
obtained from the given filename. 
imagecreatefromwbmp() returns an empty string on failure. It also outputs 
an error message, which unfortunately displays as a broken link in a 
browser. To ease debugging the following example will produce an error 
WBMP: Example 1. Example to handle an error during creation 
(courtesy vic at zymsys dot com) 
  <?php
  function LoadWBMP($imgname) {
      $im = @imagecreatefromwbmp($imgname); /* Attempt to open 
*/
      if (!$im) { /* See if it failed */
	  $im  = imagecreate (20, 20); /* Create a blank image 
*/
	  $bgc = imagecolorallocate($im, 255, 255, 255);
	  $tc  = imagecolorallocate($im, 0, 0, 0);
	  imagefilledrectangle($im, 0, 0, 10, 10, $bgc);
	  /* Output an errmsg */
	  imagestring($im, 1, 5, 5, "Error loading $imgname", 
  $tc);
      }
      return $im;
  }
  ?> 
Note: WBMP support is only available if PHP was compiled against GD-1.8 
or later. 
Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Warning
Windows versions of PHP prior to PHP 4.3.0 do not support accessing 
remote files via this function, even if allow_url_fopen is enabled. 
  imagecreatefromstringUpimagecreatefromxbm
#

#T=resource imagecreatefromwbmp ( string filename)
imagecreatefromwbmp ( ^!string filename);
#

#T=imagecreatefromxbm - resource imagecreatefromxbm ( string filename)
(PHP 4 >= 4.0.1)
imagecreatefromxbm -- Create a new image from file or URL
Description
resource imagecreatefromxbm ( string filename)
imagecreatefromxbm() returns an image identifier representing the image 
obtained from the given filename. 
Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Warning
Windows versions of PHP prior to PHP 4.3.0 do not support accessing 
remote files via this function, even if allow_url_fopen is enabled. 
  imagecreatefromwbmpUpimagecreatefromxpm
#

#T=resource imagecreatefromxbm ( string filename)
imagecreatefromxbm ( ^!string filename);
#

#T=imagecreatefromxpm - resource imagecreatefromxpm ( string filename)
(PHP 4 >= 4.0.1)
imagecreatefromxpm -- Create a new image from file or URL
Description
resource imagecreatefromxpm ( string filename)
imagecreatefromxpm() returns an image identifier representing the image 
obtained from the given filename. 
Tip: You can use a URL as a filename with this function if the fopen 
wrappers have been enabled. See fopen() for more details on how to 
specify the filename and Appendix I for a list of supported URL 
protocols.
Warning
Windows versions of PHP prior to PHP 4.3.0 do not support accessing 
remote files via this function, even if allow_url_fopen is enabled. 
  imagecreatefromxbmUpimagecreatetruecolor
#

#T=resource imagecreatefromxpm ( string filename)
imagecreatefromxpm ( ^!string filename);
#

#T=imagecreatetruecolor - resource imagecreatetruecolor ( int x_size, int y_size)
(PHP 4 >= 4.0.6)
imagecreatetruecolor -- Create a new true color image
Description
resource imagecreatetruecolor ( int x_size, int y_size)
imagecreatetruecolor() returns an image identifier representing a black 
image of size x_size by y_size. 
Example 1. Creating a new GD image stream and outputting an image. 
  <?php
  header ("Content-type: image/png");
  $im = @imagecreatetruecolor(50, 100)
	or die("Cannot Initialize new GD image stream");
  $text_color = imagecolorallocate($im, 233, 14, 91);
  imagestring($im, 1, 5, 5,  "A Simple Text String", 
  $text_color);
  imagepng($im);
  imagedestroy($im);
  ?> 
Note: This function was added in PHP 4.0.6 and requires GD 2.0.1 or 
later. 
Note: This function will not work with GIF file formats. 
See also imagedestroy() and imagecreate().   imagecreatefromxpmUpimagedashedline
#

#T=resource imagecreatetruecolor ( int x_size, int y_size)
imagecreatetruecolor ( ^!int x_size, int y_size);
#

#T=imagedashedline - int imagedashedline ( resource image, int x1, int y1, int x2, int y2, int 
(PHP 3, PHP 4 )
imagedashedline -- Draw a dashed line
Description
int imagedashedline ( resource image, int x1, int y1, int x2, int y2, int 
color)
This function is deprecated. Use combination of imagesetstyle() and 
imageline() instead.   imagecreatetruecolorUpimagedestroy
#

#T=int imagedashedline ( resource image, int x1, int y1, int x2, int y2, int 
imagedashedline ( ^!resource image, int x1, int y1, int x2, int y2, int ;
#

#T=imagedestroy - int imagedestroy ( resource image)
(PHP 3, PHP 4 )
imagedestroy -- Destroy an image
Description
int imagedestroy ( resource image)
imagedestroy() frees any memory associated with image image. image is the 
image identifier returned by the imagecreate() function.   imagedashedlineUpimageellipse
#

#T=int imagedestroy ( resource image)
imagedestroy ( ^!resource image);
#

#T=imageellipse - int imageellipse ( resource image, int cx, int cy, int w, int h, int 
(PHP 4 >= 4.0.6)
imageellipse -- Draw an ellipse
Description
int imageellipse ( resource image, int cx, int cy, int w, int h, int 
color)
imageellipse() draws an ellipse centered at cx, cy (top left is 0, 0) in 
the image represented by image. W and h specifies the ellipse's width and 
height respectively. The color of the ellipse is specified by color. 
Note: This function was added in PHP 4.0.6 and requires GD 2.0.2 or 
later which can be obtained at http://www.boutell.com/gd/ 
Example 1. imageellipse() example
  <?php

  // create a blank image
  $image = imagecreate(400, 300);

  // fill the background color
  $bg = imagecolorallocate($image, 0, 0, 0);

  // choose a color for the ellipse
  $col_ellipse = imagecolorallocate($image, 255, 255, 255);

  // draw the ellipse
  imageellipse($image, 200, 150, 300, 200, $col_ellipse);

  // output the picture
  header("Content-type: image/png");
  imagepng($image);

  ?> 
See also imagefilledellipse() and imagearc().   imagedestroyUpimagefill
#

#T=int imageellipse ( resource image, int cx, int cy, int w, int h, int 
imageellipse ( ^!resource image, int cx, int cy, int w, int h, int ;
#

#T=imagefill - int imagefill ( resource image, int x, int y, int color)
(PHP 3, PHP 4 )
imagefill -- Flood fill
Description
int imagefill ( resource image, int x, int y, int color)
imagefill() performs a flood fill starting at coordinate x, y (top left is 
0, 0) with color color in the image image.   imageellipseUpimagefilledarc
#

#T=int imagefill ( resource image, int x, int y, int color)
imagefill ( ^!resource image, int x, int y, int color);
#

#T=imagefilledarc - bool imagefilledarc ( resource image, int cx, int cy, int w, int h, int s, 
(PHP 4 >= 4.0.6)
imagefilledarc -- Draw a partial ellipse and fill it
Description
bool imagefilledarc ( resource image, int cx, int cy, int w, int h, int s, 
int e, int color, int style)
imagefilledarc() draws a partial ellipse centered at cx, cy (top left is 
0, 0) in the image represented by image. Returns TRUE on success or FALSE 
on failure. W and h specifies the ellipse's width and height respectively 
while the start and end points are specified in degrees indicated by the s 
and e arguments. style is a bitwise OR of the following possibilities: 
IMG_ARC_PIE
IMG_ARC_CHORD
IMG_ARC_NOFILL
IMG_ARC_EDGED
IMG_ARC_PIE and IMG_ARC_CHORD are mutually exclusive; IMG_ARC_CHORD just 
connects the starting and ending angles with a straight line, while 
IMG_ARC_PIE produces a rounded edge. IMG_ARC_NOFILL indicates that the arc 
or chord should be outlined, not filled. IMG_ARC_EDGED, used together with 
IMG_ARC_NOFILL, indicates that the beginning and ending angles should be 
connected to the center - this is a good way to outline (rather than fill) 
a 'pie slice'. 
Example 1. Creating a 3D looking pie
  <?php

  // this example is provided by poxy at klam dot is

  // create image
  $image = imagecreate(100, 100);

  // allocate some solors
  $white    = imagecolorallocate($image, 0xFF, 0xFF, 0xFF);
  $gray     = imagecolorallocate($image, 0xC0, 0xC0, 0xC0);
  $darkgray = imagecolorallocate($image, 0x90, 0x90, 0x90);
  $navy     = imagecolorallocate($image, 0x00, 0x00, 0x80);
  $darknavy = imagecolorallocate($image, 0x00, 0x00, 0x50);
  $red      = imagecolorallocate($image, 0xFF, 0x00, 0x00);
  $darkred  = imagecolorallocate($image, 0x90, 0x00, 0x00);

  // make the 3D effect
  for ($i = 60; $i > 50; $i--) {
     imagefilledarc($image, 50, $i, 100, 50, 0, 45, $darknavy, 
  IMG_ARC_PIE);
    imagefilledarc($image, 50, $i, 100, 50, 45, 75 , $darkgray, 
  IMG_ARC_PIE);
    imagefilledarc($image, 50, $i, 100, 50, 75, 360 , $darkred, 
  IMG_ARC_PIE);
  }

  imagefilledarc($image, 50, 50, 100, 50, 0, 45, $navy, 
  IMG_ARC_PIE);
  imagefilledarc($image, 50, 50, 100, 50, 45, 75 , $gray, 
  IMG_ARC_PIE);
  imagefilledarc($image, 50, 50, 100, 50, 75, 360 , $red, 
  IMG_ARC_PIE);
  // flush image
  header('Content-type: image/png');
  imagepng($image);
  imagedestroy($image);
  ?> 
Note: This function was added in PHP 4.0.6 and requires GD 2.0.1   imagefillUpimagefilledellipse
#

#T=bool imagefilledarc ( resource image, int cx, int cy, int w, int h, int s, 
imagefilledarc ( ^!resource image, int cx, int cy, int w, int h, int s, ;
#

#T=imagefilledellipse - bool imagefilledellipse ( resource image, int cx, int cy, int w, int h, 
(PHP 4 >= 4.0.6)
imagefilledellipse -- Draw a filled ellipse
Description
bool imagefilledellipse ( resource image, int cx, int cy, int w, int h, 
int color)
imagefilledellipse() draws an ellipse centered at cx, cy (top left is 0, 
0) in the image represented by image. W and h specifies the ellipse's 
width and height respectively. The ellipse is filled using color. Returns 
TRUE on success or FALSE on failure. 
Note: This function was added in PHP 4.0.6 and requires GD 2.0.1 or 
later 
Example 1. imagefilledellipse() example
  <?php

  // create a blank image
  $image = imagecreate(400, 300);

  // fill the background color
  $bg = imagecolorallocate($image, 0, 0, 0);

  // choose a color for the ellipse
  $col_ellipse = imagecolorallocate($image, 255, 255, 255);

  // draw the white ellipse
  imagefilledellipse($image, 200, 150, 300, 200, $col_ellipse);

  // output the picture
  header("Content-type: image/png");
  imagepng($image);

  ?> 
See also imageellipse() and imagefilledarc().   imagefilledarcUpimagefilledpolygon
#

#T=bool imagefilledellipse ( resource image, int cx, int cy, int w, int h, 
imagefilledellipse ( ^!resource image, int cx, int cy, int w, int h, ;
#

#T=imagefilledpolygon - int imagefilledpolygon ( resource image, array points, int num_points, int 
(PHP 3, PHP 4 )
imagefilledpolygon -- Draw a filled polygon
Description
int imagefilledpolygon ( resource image, array points, int num_points, int 
color)
imagefilledpolygon() creates a filled polygon in image image. points is a 
PHP array containing the polygon's vertices, i.e. points[0] = x0, 
points[1] = y0, points[2] = x1, points[3] = y1, etc. num_points is the 
total number of vertices. 
Example 1. imagefilledpolygon() example
  <?php

  // this example is provided by ecofarm at mullum dot com dot 
au

  // set up array of points for polygon
  $values = array(
    0  => 40,    // x1
    1  => 50,    // y1
    2  => 20,    // x2
    3  => 240,   // y2
    4  => 60,    // x3
    5  => 60,    // y3
    6  => 240,   // x4
    7  => 20,    // y4
    8  => 50,    // x5
    9  => 40,    // y5
    10 => 10,    // x6
    11 => 10,    // y6
  );

  // create image
  $im = imagecreate(250, 250);

  // some colors
  $bg   = imagecolorallocate($im, 255, 255, 255);
  $blue = imagecolorallocate($im, 0, 0, 255);

  // draw a polygon
  imagefilledpolygon($im, $values, 6, $blue );

  // flush image
  header('Content-type: image/png');
  imagepng($im);
  imagedestroy($im);

  ?> 

  imagefilledellipseUpimagefilledrectangle
#

#T=int imagefilledpolygon ( resource image, array points, int num_points, int 
imagefilledpolygon ( ^!resource image, array points, int num_points, int ;
#

#T=imagefilledrectangle - int imagefilledrectangle ( resource image, int x1, int y1, int x2, int y2, 
(PHP 3, PHP 4 )
imagefilledrectangle -- Draw a filled rectangle
Description
int imagefilledrectangle ( resource image, int x1, int y1, int x2, int y2, 
int color)
imagefilledrectangle() creates a filled rectangle of color color in image 
image starting at upper left coordinates x1, y1 and ending at bottom right 
coordinates x2, y2. 0, 0 is the top left corner of the image.   imagefilledpolygonUpimagefilltoborder
#

#T=int imagefilledrectangle ( resource image, int x1, int y1, int x2, int y2, 
imagefilledrectangle ( ^!resource image, int x1, int y1, int x2, int y2, ;
#

#T=imagefilltoborder - int imagefilltoborder ( resource image, int x, int y, int border, int 
(PHP 3, PHP 4 )
imagefilltoborder -- Flood fill to specific color
Description
int imagefilltoborder ( resource image, int x, int y, int border, int 
color)
imagefilltoborder() performs a flood fill whose border color is defined by 
border. The starting point for the fill is x, y (top left is 0, 0) and the 
region is filled with color color.   imagefilledrectangleUpimagefontheight
#

#T=int imagefilltoborder ( resource image, int x, int y, int border, int 
imagefilltoborder ( ^!resource image, int x, int y, int border, int ;
#

#T=imagefontheight - int imagefontheight ( int font)
(PHP 3, PHP 4 )
imagefontheight -- Get font height
Description
int imagefontheight ( int font)
Returns the pixel height of a character in the specified font. 
See also imagefontwidth() and imageloadfont().   imagefilltoborderUpimagefontwidth
#

#T=int imagefontheight ( int font)
imagefontheight ( ^!int font);
#

#T=imagefontwidth - int imagefontwidth ( int font)
(PHP 3, PHP 4 )
imagefontwidth -- Get font width
Description
int imagefontwidth ( int font)
Returns the pixel width of a character in font. 
See also imagefontheight() and imageloadfont().   imagefontheightUpimageftbbox
#

#T=int imagefontwidth ( int font)
imagefontwidth ( ^!int font);
#

#T=imageftbbox - array imageftbbox ( int size, int angle, string font_file, string text [, 
(PHP 4 >= 4.1.0)
imageftbbox -- Give the bounding box of a text using fonts via freetype2
Description
array imageftbbox ( int size, int angle, string font_file, string text [, 
array extrainfo])
Warning
This function is currently not documented; only the argument list is 
available.
  imagefontwidthUpimagefttext
#

#T=array imageftbbox ( int size, int angle, string font_file, string text [, 
imageftbbox ( ^!int size, int angle, string font_file, string text [, ;
#

#T=imagefttext - array imagefttext ( resource image, int size, int angle, int x, int y, int 
(PHP 4 >= 4.1.0)
imagefttext -- Write text to the image using fonts using FreeType 2
Description
array imagefttext ( resource image, int size, int angle, int x, int y, int 
col, string font_file, string text [, array extrainfo])
Warning
This function is currently not documented; only the argument list is 
available.
  imageftbboxUpimagegammacorrect
#

#T=array imagefttext ( resource image, int size, int angle, int x, int y, int 
imagefttext ( ^!resource image, int size, int angle, int x, int y, int ;
#

#T=imagegammacorrect - int imagegammacorrect ( resource image, float inputgamma, float 
(PHP 3>= 3.0.13, PHP 4 )
imagegammacorrect -- Apply a gamma correction to a GD image
Description
int imagegammacorrect ( resource image, float inputgamma, float 
outputgamma)
The imagegammacorrect() function applies gamma correction to a gd image 
stream (image) given an input gamma, the parameter inputgamma and an 
output gamma, the parameter outputgamma.   imagefttextUpimagegd2
#

#T=int imagegammacorrect ( resource image, float inputgamma, float 
imagegammacorrect ( ^!resource image, float inputgamma, float ;
#

#T=imagegd - int imagegd ( resource image [, string filename])
(PHP 4 >= 4.1.0)
imagegd -- Output GD image to browser or file
Description
int imagegd ( resource image [, string filename])
Warning
This function is currently not documented; only the argument list is 
available.
  imagegd2Upimagegif
#

#T=int imagegd ( resource image [, string filename])
imagegd ( ^!resource image [, string filename]);
#

#T=imagegd2 - int imagegd2 ( resource image [, string filename [, int chunk_size [, int 
(PHP 4 >= 4.1.0)
imagegd2 -- Output GD2 image
Description
int imagegd2 ( resource image [, string filename [, int chunk_size [, int 
type]]])
imagegd2() outputs GD2 image to browser or file. 
The optional type parameter is either IMG_GD2_RAW or IMG_GD2_COMPRESSED. 
Default is IMG_GD2_RAW. 
Note: The optional chunk_size and type parameters became available in 
PHP 4.3.2.   imagegammacorrectUpimagegd
#

#T=int imagegd2 ( resource image [, string filename [, int chunk_size [, int 
imagegd2 ( ^!resource image [, string filename [, int chunk_size [, int ;
#

#T=imagegif - int imagegif ( resource image [, string filename])
(PHP 3, PHP 4 )
imagegif -- Output image to browser or file
Description
int imagegif ( resource image [, string filename])
imagegif() creates the GIF file in filename from the image image. The 
image argument is the return from the imagecreate() function. 
The image format will be GIF87a unless the image has been made transparent 
with imagecolortransparent(), in which case the image format will be 
GIF89a. 
The filename argument is optional, and if left off, the raw image stream 
will be output directly. By sending an image/gif content-type using 
header(), you can create a PHP script that outputs GIF images directly. 
Note: Since all GIF support was removed from the GD library in version 
1.6, this function is not available if you are using that version of the 
GD library. Support is expected to return in a version subsequent to the 
rerelease of GIF support in the GD library in mid 2004. For more 
information, see the GD Project site. 
The following code snippet allows you to write more portable PHP 
applications by auto-detecting the type of GD support which is 
available. Replace the sequence header ("Content-type: image/gif"); 
imagegif ($im); by the more flexible sequence: 
<?php
if (function_exists("imagegif")) {
  header("Content-type: image/gif");
  imagegif($im);
} elseif (function_exists("imagejpeg")) {
  header("Content-type: image/jpeg");
  imagejpeg($im, "", 0.5);
} elseif (function_exists("imagepng")) {
  header("Content-type: image/png");
  imagepng($im);
} elseif (function_exists("imagewbmp")) {
  header("Content-type: image/vnd.wap.wbmp");
  imagewbmp($im);
} else {
  die("No image support in this PHP server");
}
?> 

Note: As of version 3.0.18 and 4.0.2 you can use the function 
imagetypes() in place of function_exists() for checking the presence of 
the various supported image formats: 
<?php
if (imagetypes() & IMG_GIF) {
  header ("Content-type: image/gif");
  imagegif ($im);
} elseif (imagetypes() & IMG_JPG) {
  /* ... etc. */
}
?> 

See also imagepng(), imagewbmp(), imagejpeg() and imagetypes().   imagegdUpimageinterlace
#

#T=int imagegif ( resource image [, string filename])
imagegif ( ^!resource image [, string filename]);
#

#T=imageinterlace - int imageinterlace ( resource image [, int interlace])
(PHP 3, PHP 4 )
imageinterlace -- Enable or disable interlace
Description
int imageinterlace ( resource image [, int interlace])
imageinterlace() turns the interlace bit on or off. If interlace is 1 the 
image will be interlaced, and if interlace is 0 the interlace bit is 
turned off. 
If the interlace bit is set and the image is used as a JPEG image, the 
image is created as a progressive JPEG. 
This function returns whether the interlace bit is set for the image.   imagegifUpimageistruecolor
#

#T=int imageinterlace ( resource image [, int interlace])
imageinterlace ( ^!resource image [, int interlace]);
#

#T=imageistruecolor - bool imageistruecolor ( resource image)
(PHP 4 >= 4.3.2)
imageistruecolor -- Finds whether an image is a truecolor image.
Description
bool imageistruecolor ( resource image)
imageistruecolor() finds whether the image image is a truecolor image. 
See also imagecreatetruecolor().   imageinterlaceUpimagejpeg
#

#T=bool imageistruecolor ( resource image)
imageistruecolor ( ^!resource image);
#

#T=imagejpeg - int imagejpeg ( resource image [, string filename [, int quality]])
(PHP 3>= 3.0.16, PHP 4 )
imagejpeg -- Output image to browser or file
Description
int imagejpeg ( resource image [, string filename [, int quality]])
imagejpeg() creates the JPEG file in filename from the image image. The 
image argument is the return from the imagecreate() function. 
The filename argument is optional, and if left off, the raw image stream 
will be output directly. To skip the filename argument in order to provide 
a quality argument just use an empty string (''). By sending an image/jpeg 
content-type using header(), you can create a PHP script that outputs JPEG 
images directly. 
Note: JPEG support is only available if PHP was compiled against GD-1.8 
or later. 
quality is optional, and ranges from 0 (worst quality, smaller file) to 
100 (best quality, biggest file). The default is the default IJG quality 
value (about 75). 
If you want to output Progressive JPEGs, you need to set interlacing on 
with imageinterlace(). 
See also imagepng(), imagegif(), imagewbmp(), imageinterlace() and 
imagetypes().   imageistruecolorUpimageline
#

#T=int imagejpeg ( resource image [, string filename [, int quality]])
imagejpeg ( ^!resource image [, string filename [, int quality]]);
#

#T=imageline - int imageline ( resource image, int x1, int y1, int x2, int y2, int color)
(PHP 3, PHP 4 )
imageline -- Draw a line
Description
int imageline ( resource image, int x1, int y1, int x2, int y2, int color)
imageline() draws a line from x1, y1 to x2, y2 (top left is 0, 0) in image 
image of color color. 
Example 1. Drawing a thick line
  <?php

  function imagelinethick($image, $x1, $y1, $x2, $y2, $color, 
  $thick = 1) {
      /* this way it works well only for orthogonal lines
      imagesetthickness($image, $thick);
      return imageline($image, $x1, $y1, $x2, $y2, $color);
      */
      if ($thick == 1) {
	  return imageline($image, $x1, $y1, $x2, $y2, $color);
      }
      $t = $thick / 2 - 0.5;
      if ($x1 == $x2 || $y1 == $y2) {
	  return imagefilledrectangle($image, round(min($x1, 
  $x2) - $t), round(min($y1, $y2) - $t), round(max($x1, $x2) + 
  $t), round(max($y1, $y2) + $t), $color);
      }
      $k = ($y2 - $y1) / ($x2 - $x1); //y = kx + q
      $a = $t / sqrt(1 + pow($k, 2));
      $points = array(
	  round($x1 - (1+$k)*$a), round($y1 + (1-$k)*$a),
	  round($x1 - (1-$k)*$a), round($y1 - (1+$k)*$a),
	  round($x2 + (1+$k)*$a), round($y2 - (1-$k)*$a),
	  round($x2 + (1-$k)*$a), round($y2 + (1+$k)*$a),
      );    
      imagefilledpolygon($image, $points, 4, $color);
      return imagepolygon($image, $points, 4, $color);
  }

  ?> 
See also imagecreate() and imagecolorallocate().   imagejpegUpimageloadfont
#

#T=int imageline ( resource image, int x1, int y1, int x2, int y2, int color)
imageline ( ^!resource image, int x1, int y1, int x2, int y2, int color);
#

#T=imageloadfont - int imageloadfont ( string file)
(PHP 3, PHP 4 )
imageloadfont -- Load a new font
Description
int imageloadfont ( string file)
imageloadfont() loads a user-defined bitmap font and returns an identifier 
for the font (that is always greater than 5, so it will not conflict with 
the built-in fonts). 
The font file format is currently binary and architecture dependent. This 
means you should generate the font files on the same type of CPU as the 
machine you are running PHP on. 
Table 1. Font file format
byte positionC data typedescription
byte 0-3intnumber of characters in the font
byte 4-7intvalue of first character in the font (often 32 for space) 

byte 8-11intpixel width of each character
byte 12-15intpixel height of each character
byte 16-chararray with character data, one byte per pixel in each 
character, for a total of (nchars*width*height) bytes. 

See also imagefontwidth() and imagefontheight().   imagelineUpimagepalettecopy
#

#T=int imageloadfont ( string file)
imageloadfont ( ^!string file);
#

#T=imagepalettecopy - int imagepalettecopy ( resource destination, resource source)
(PHP 4 >= 4.0.1)
imagepalettecopy -- Copy the palette from one image to another
Description
int imagepalettecopy ( resource destination, resource source)
imagepalettecopy() copies the palette from the source image to the 
destination image.   imageloadfontUpimagepng
#

#T=int imagepalettecopy ( resource destination, resource source)
imagepalettecopy ( ^!resource destination, resource source);
#

#T=imagepng - int imagepng ( resource image [, string filename])
(PHP 3>= 3.0.13, PHP 4 )
imagepng -- Output a PNG image to either the browser or a file
Description
int imagepng ( resource image [, string filename])
The imagepng() outputs a GD image stream (image) in PNG format to standard 
output (usually the browser) or, if a filename is given by the filename it 
outputs the image to the file. 
<?php
$im = imagecreatefrompng("test.png");
imagepng($im);
?> 

See also imagegif(), imagewbmp(), imagejpeg(), imagetypes().   imagepalettecopyUpimagepolygon
#

#T=int imagepng ( resource image [, string filename])
imagepng ( ^!resource image [, string filename]);
#

#T=imagepolygon - int imagepolygon ( resource image, array points, int num_points, int 
(PHP 3, PHP 4 )
imagepolygon -- Draw a polygon
Description
int imagepolygon ( resource image, array points, int num_points, int 
color)
imagepolygon() creates a polygon in image id. points is a PHP array 
containing the polygon's vertices, i.e. points[0] = x0, points[1] = y0, 
points[2] = x1, points[3] = y1, etc. num_points is the total number of 
points (vertices). 
Example 1. imagepolygon() example
  <?php
  // create a blank image
  $image = imagecreate(400, 300);

  // fill the background color
  $bg = imagecolorallocate($image, 0, 0, 0);

  // choose a color for the polygon
  $col_poly = imagecolorallocate($image, 255, 255, 255);

  // draw the polygon
  imagepolygon($image, 
	       array (
		      0, 0,
		      100, 200,
		      300, 200
	       ),
	       3,
	       $col_poly);

  // output the picture
  header("Content-type: image/png");
  imagepng($image);

  ?> 
See also imagecreate() and imagecreatetruecolor().   imagepngUpimagepsbbox
#

#T=int imagepolygon ( resource image, array points, int num_points, int 
imagepolygon ( ^!resource image, array points, int num_points, int ;
#

#T=imagepsbbox - array imagepsbbox ( string text, int font, int size [, int space [, int 
(PHP 3>= 3.0.9, PHP 4 )
imagepsbbox --  Give the bounding box of a text rectangle using PostScript 
Type1 fonts 
Description
array imagepsbbox ( string text, int font, int size [, int space [, int 
tightness [, float angle]]])
size is expressed in pixels. 
space allows you to change the default value of a space in a font. This 
amount is added to the normal value and can also be negative. 
tightness allows you to control the amount of white space between 
characters. This amount is added to the normal character width and can 
also be negative. 
angle is in degrees. 
Parameters space and tightness are expressed in character space units, 
where 1 unit is 1/1000th of an em-square. 
Parameters space, tightness, and angle are optional. 
The bounding box is calculated using information available from character 
metrics, and unfortunately tends to differ slightly from the results 
achieved by actually rasterizing the text. If the angle is 0 degrees, you 
can expect the text to need 1 pixel more to every direction. 
Note: This function is only available if PHP is compiled using 
--enable-t1lib. 
This function returns an array containing the following elements: 
0lower left x-coordinate
1lower left y-coordinate
2upper right x-coordinate
3upper right y-coordinate

See also imagepstext().   imagepolygonUpimagepscopyfont
#

#T=array imagepsbbox ( string text, int font, int size [, int space [, int 
imagepsbbox ( ^!string text, int font, int size [, int space [, int ;
#

#T=imagepscopyfont - int imagepscopyfont ( int fontindex)
(PHP 3>= 3.0.9, PHP 4 )
imagepscopyfont --  Make a copy of an already loaded font for further 
modification 
Description
int imagepscopyfont ( int fontindex)
Use this function if you need make further modifications to the font, for 
example extending/condensing, slanting it or changing it's character 
encoding vector, but need to keep the original along as well. Note that 
the font you want to copy must be one obtained using imagepsloadfont(), 
not a font that is itself a copied one. You can although make 
modifications to it before copying. 
If you use this function, you must free the fonts obtained this way 
yourself and in reverse order. Otherwise your script will hang. 
In the case everything went right, a valid font index will be returned and 
can be used for further purposes. Otherwise the function returns FALSE and 
prints a message describing what went wrong. 
Note: This function is only available if PHP is compiled using 
--enable-t1lib. 
See also imagepsloadfont().   imagepsbboxUpimagepsencodefont
#

#T=int imagepscopyfont ( int fontindex)
imagepscopyfont ( ^!int fontindex);
#

#T=imagepsencodefont - int imagepsencodefont ( int font_index, string encodingfile)
(PHP 3>= 3.0.9, PHP 4 )
imagepsencodefont -- Change the character encoding vector of a font
Description
int imagepsencodefont ( int font_index, string encodingfile)
Loads a character encoding vector from a file and changes the fonts 
encoding vector to it. As a PostScript fonts default vector lacks most of 
the character positions above 127, you'll definitely want to change this 
if you use an other language than English. The exact format of this file 
is described in T1libs documentation. T1lib comes with two ready-to-use 
files, IsoLatin1.enc and IsoLatin2.enc. 
If you find yourself using this function all the time, a much better way 
to define the encoding is to set ps.default_encoding in the configuration 
file to point to the right encoding file and all fonts you load will 
automatically have the right encoding. 
Note: This function is only available if PHP is compiled using 
--enable-t1lib.   imagepscopyfontUpimagepsextendfont
#

#T=int imagepsencodefont ( int font_index, string encodingfile)
imagepsencodefont ( ^!int font_index, string encodingfile);
#

#T=imagepsextendfont - bool imagepsextendfont ( int font_index, float extend)
(PHP 3>= 3.0.9, PHP 4 )
imagepsextendfont -- Extend or condense a font
Description
bool imagepsextendfont ( int font_index, float extend)
Extend or condense a font (font_index), if the value of the extend 
parameter is less than one you will be condensing the font. 
Note: This function is only available if PHP is compiled using 
--enable-t1lib.   imagepsencodefontUpimagepsfreefont
#

#T=bool imagepsextendfont ( int font_index, float extend)
imagepsextendfont ( ^!int font_index, float extend);
#

#T=imagepsfreefont - void imagepsfreefont ( int fontindex)
(PHP 3>= 3.0.9, PHP 4 )
imagepsfreefont -- Free memory used by a PostScript Type 1 font
Description
void imagepsfreefont ( int fontindex)
imagepsfreefont() frees memory used by a PostScript Type 1 font. 
Note: This function is only available if PHP is compiled using 
--enable-t1lib. 
See also imagepsloadfont().   imagepsextendfontUpimagepsloadfont
#

#T=void imagepsfreefont ( int fontindex)
imagepsfreefont ( ^!int fontindex);
#

#T=imagepsloadfont - int imagepsloadfont ( string filename)
(PHP 3>= 3.0.9, PHP 4 )
imagepsloadfont -- Load a PostScript Type 1 font from file
Description
int imagepsloadfont ( string filename)
In the case everything went right, a valid font index will be returned and 
can be used for further purposes. Otherwise the function returns FALSE and 
prints a message describing what went wrong, which you cannot read 
directly, while the output type is image. 
Example 1. imagepsloadfont() example
  <?php
  header("Content-type: image/jpeg");
  $im = imagecreate(350, 45);
  $black = imagecolorallocate($im, 0, 0, 0);
  $white = imagecolorallocate($im, 255, 255, 255);
  $font = imagepsloadfont("bchbi.pfb"); // or locate your .pfb 
  files on your machine
  imagepstext($im, "Testing... It worked!", $font, 32, $white, 
  $black, 32, 32);
  imagepsfreefont($font);
  imagejpeg($im, "", 100); //for best quality...your mileage may 
  vary
  imagedestroy($im);
  ?> 
Note: This function is only available if PHP is compiled using 
--enable-t1lib. 
See also imagepsfreefont().   imagepsfreefontUpimagepsslantfont
#

#T=int imagepsloadfont ( string filename)
imagepsloadfont ( ^!string filename);
#

#T=imagepsslantfont - bool imagepsslantfont ( int font_index, float slant)
(PHP 3>= 3.0.9, PHP 4 )
imagepsslantfont -- Slant a font
Description
bool imagepsslantfont ( int font_index, float slant)
Slant a font given by the font_index parameter with a slant of the value 
of the slant parameter. 
Note: This function is only available if PHP is compiled using 
--enable-t1lib.   imagepsloadfontUpimagepstext
#

#T=bool imagepsslantfont ( int font_index, float slant)
imagepsslantfont ( ^!int font_index, float slant);
#

#T=imagepstext - array imagepstext ( resource image, string text, int font, int size, int 
(PHP 3>= 3.0.9, PHP 4 )
imagepstext -- To draw a text string over an image using PostScript Type1 
fonts
Description
array imagepstext ( resource image, string text, int font, int size, int 
foreground, int background, int x, int y [, int space [, int tightness [, 
float angle [, int antialias_steps]]]])
foreground is the color in which the text will be painted. Background is 
the color to which the text will try to fade in with antialiasing. No 
pixels with the color background are actually painted, so the background 
image does not need to be of solid color. 
The coordinates given by x, y will define the origin (or reference point) 
of the first character (roughly the lower-left corner of the character). 
This is different from the imagestring(), where x, y define the 
upper-right corner of the first character. Refer to PostScript 
documentation about fonts and their measuring system if you have trouble 
understanding how this works. 
space allows you to change the default value of a space in a font. This 
amount is added to the normal value and can also be negative. 
tightness allows you to control the amount of white space between 
characters. This amount is added to the normal character width and can 
also be negative. 
angle is in degrees. 
size is expressed in pixels. 
antialias_steps allows you to control the number of colours used for 
antialiasing text. Allowed values are 4 and 16. The higher value is 
recommended for text sizes lower than 20, where the effect in text quality 
is quite visible. With bigger sizes, use 4. It's less computationally 
intensive. 
Parameters space and tightness are expressed in character space units, 
where 1 unit is 1/1000th of an em-square. 
Parameters space, tightness, angle and antialias_steps are optional. 
Note: This function is only available if PHP is compiled using 
--enable-t1lib. 
This function returns an array containing the following elements: 
0lower left x-coordinate
1lower left y-coordinate
2upper right x-coordinate
3upper right y-coordinate

See also imagepsbbox().   imagepsslantfontUpimagerectangle
#

#T=array imagepstext ( resource image, string text, int font, int size, int 
imagepstext ( ^!resource image, string text, int font, int size, int ;
#

#T=imagerectangle - int imagerectangle ( resource image, int x1, int y1, int x2, int y2, int 
(PHP 3, PHP 4 )
imagerectangle -- Draw a rectangle
Description
int imagerectangle ( resource image, int x1, int y1, int x2, int y2, int 
col)
imagerectangle() creates a rectangle of color col in image image starting 
at upper left coordinate x1, y1 and ending at bottom right coordinate x2, 
y2. 0, 0 is the top left corner of the image.   imagepstextUpimagerotate
#

#T=int imagerectangle ( resource image, int x1, int y1, int x2, int y2, int 
imagerectangle ( ^!resource image, int x1, int y1, int x2, int y2, int ;
#

#T=imagerotate - resource imagerotate ( resource src_im, float angle, int bgd_color)
(PHP 4 >= 4.3.0)
imagerotate -- Rotate an image with a given angle
Description
resource imagerotate ( resource src_im, float angle, int bgd_color)
Rotates the src_im image using a given angle in degree. bgd_color 
specifies the color of the uncovered zone after the rotation.   imagerectangleUpimagesavealpha
#

#T=resource imagerotate ( resource src_im, float angle, int bgd_color)
imagerotate ( ^!resource src_im, float angle, int bgd_color);
#

#T=imagesavealpha - bool imagesavealpha ( resource image, bool saveflag)
(PHP 4 >= 4.3.2)
imagesavealpha --  Set the flag to save full alpha channel information (as 
opposed to single-color transparency) when saving PNG images. 
Description
bool imagesavealpha ( resource image, bool saveflag)
imagesavealpha() sets the flag to attempt to save full alpha channel 
information (as opposed to single-color transparency) when saving PNG 
images. 
You have to unset alphablending (imagealphablending($im, FALSE)), to use 
it. 
Alpha channel is not supported by all browsers, if you have problem with 
your browser, try to load your script with an alpha channel compliant 
browser, e.g. latest Mozilla. 
See also imagealphablending().   imagerotateUpimagesetbrush
#

#T=bool imagesavealpha ( resource image, bool saveflag)
imagesavealpha ( ^!resource image, bool saveflag);
#

#T=imagesetbrush - int imagesetbrush ( resource image, resource brush)
(PHP 4 >= 4.0.6)
imagesetbrush -- Set the brush image for line drawing
Description
int imagesetbrush ( resource image, resource brush)
imagesetbrush() sets the brush image to be used by all line drawing 
functions (such as imageline() and imagepolygon()) when drawing with the 
special colors IMG_COLOR_BRUSHED or IMG_COLOR_STYLEDBRUSHED. 
Note: You need not take special action when you are finished with a 
brush, but if you destroy the brush image, you must not use the 
IMG_COLOR_BRUSHED or IMG_COLOR_STYLEDBRUSHED colors until you have set a 
new brush image! 
Note: This function was added in PHP 4.0.6  imagesavealphaUpimagesetpixel
#

#T=int imagesetbrush ( resource image, resource brush)
imagesetbrush ( ^!resource image, resource brush);
#

#T=imagesetpixel - int imagesetpixel ( resource image, int x, int y, int color)
(PHP 3, PHP 4 )
imagesetpixel -- Set a single pixel
Description
int imagesetpixel ( resource image, int x, int y, int color)
imagesetpixel() draws a pixel at x, y (top left is 0, 0) in image image of 
color color. 
See also imagecreate() and imagecolorallocate().   imagesetbrushUpimagesetstyle
#

#T=int imagesetpixel ( resource image, int x, int y, int color)
imagesetpixel ( ^!resource image, int x, int y, int color);
#

#T=imagesetstyle - bool imagesetstyle ( resource image, array style)
(PHP 4 >= 4.0.6)
imagesetstyle -- Set the style for line drawing
Description
bool imagesetstyle ( resource image, array style)
imagesetstyle() sets the style to be used by all line drawing functions 
(such as imageline() and imagepolygon()) when drawing with the special 
color IMG_COLOR_STYLED or lines of images with color 
IMG_COLOR_STYLEDBRUSHED. Returns TRUE on success or FALSE on failure. 
The style parameter is an array of pixels. Following example script draws 
a dashed line from upper left to lower right corner of the canvas: 
Example 1. imagesetstyle() example
  <?php
  header("Content-type: image/jpeg");
  $im  = imagecreate(100, 100);
  $w   = imagecolorallocate($im, 255, 255, 255);
  $red = imagecolorallocate($im, 255, 0, 0);

  /* Draw a dashed line, 5 red pixels, 5 white pixels */
  $style = array($red, $red, $red, $red, $red, $w, $w, $w, $w, 
  $w);
  imagesetstyle($im, $style);
  imageline($im, 0, 0, 100, 100, IMG_COLOR_STYLED);

  /* Draw a line of happy faces using imagesetbrush() with 
  imagesetstyle */
  $style = array($w, $w, $w, $w, $w, $w, $w, $w, $w, $w, $w, $w, 
  $red);
  imagesetstyle($im, $style);

  $brush = 
  imagecreatefrompng("http://www.libpng.org/pub/png/images/smile.happy.png");
  $w2 = imagecolorallocate($brush, 255, 255, 255);
  imagecolortransparent($brush, $w2);
  imagesetbrush($im, $brush);
  imageline($im, 100, 0, 0, 100, IMG_COLOR_STYLEDBRUSHED);

  imagejpeg($im);
  imagedestroy($im);
  ?> 
See also imagesetbrush(), imageline(). 
Note: This function was added in PHP 4.0.6  imagesetpixelUpimagesetthickness
#

#T=bool imagesetstyle ( resource image, array style)
imagesetstyle ( ^!resource image, array style);
#

#T=imagesetthickness - bool imagesetthickness ( resource image, int thickness)
(PHP 4 >= 4.0.6)
imagesetthickness -- Set the thickness for line drawing
Description
bool imagesetthickness ( resource image, int thickness)
imagesetthickness() sets the thickness of the lines drawn when drawing 
rectangles, polygons, ellipses etc. etc. to thickness pixels. Returns TRUE 
on success or FALSE on failure. 
Note: This function was added in PHP 4.0.6 and requires GD 2.0.1 or 
later  imagesetstyleUpimagesettile
#

#T=bool imagesetthickness ( resource image, int thickness)
imagesetthickness ( ^!resource image, int thickness);
#

#T=imagesettile - int imagesettile ( resource image, resource tile)
(PHP 4 >= 4.0.6)
imagesettile -- Set the tile image for filling
Description
int imagesettile ( resource image, resource tile)
imagesettile() sets the tile image to be used by all region filling 
functions (such as imagefill() and imagefilledpolygon()) when filling with 
the special color IMG_COLOR_TILED. 
A tile is an image used to fill an area with a repeated pattern. Any GD 
image can be used as a tile, and by setting the transparent color index of 
the tile image with imagecolortransparent(), a tile allows certain parts 
of the underlying area to shine through can be created. 
Note: You need not take special action when you are finished with a 
tile, but if you destroy the tile image, you must not use the 
IMG_COLOR_TILED color until you have set a new tile image!   imagesetthicknessUpimagestring
#

#T=int imagesettile ( resource image, resource tile)
imagesettile ( ^!resource image, resource tile);
#

#T=imagestring - int imagestring ( resource image, int font, int x, int y, string s, int 
(PHP 3, PHP 4 )
imagestring -- Draw a string horizontally
Description
int imagestring ( resource image, int font, int x, int y, string s, int 
col)
imagestring() draws the string s in the image identified by image at 
coordinates x, y (top left is 0, 0) in color col. If font is 1, 2, 3, 4 or 
5, a built-in font is used. 
Example 1. imagestring() example
  <?php

    // create a 100*30 image
    $im = imagecreate(100, 30);

    // white background and blue text
    $bg = imagecolorallocate($im, 255, 255, 255);
    $textcolor = imagecolorallocate($im, 0, 0, 255);
    
    // write the string at the top left
    imagestring($im, 5, 0, 0, "Hello world!", $textcolor);
    
    // output the image
    header("Content-type: image/jpg");
    imagejpeg($im);
  ?> 
See also imageloadfont().   imagesettileUpimagestringup
#

#T=int imagestring ( resource image, int font, int x, int y, string s, int 
imagestring ( ^!resource image, int font, int x, int y, string s, int ;
#

#T=imagestringup - int imagestringup ( resource image, int font, int x, int y, string s, int 
(PHP 3, PHP 4 )
imagestringup -- Draw a string vertically
Description
int imagestringup ( resource image, int font, int x, int y, string s, int 
col)
imagestringup() draws the string s vertically in the image identified by 
image at coordinates x, y (top left is 0, 0) in color col. If font is 1, 
2, 3, 4 or 5, a built-in font is used. 
See also imageloadfont().   imagestringUpimagesx
#

#T=int imagestringup ( resource image, int font, int x, int y, string s, int 
imagestringup ( ^!resource image, int font, int x, int y, string s, int ;
#

#T=imagesx - int imagesx ( resource image)
(PHP 3, PHP 4 )
imagesx -- Get image width
Description
int imagesx ( resource image)
imagesx() returns the width of the image identified by image. 
Example 1. Using imagesx()
  <?php

  // create a 300*200 image
  $img = imagecreate(300, 200);

  echo imagesx($img); // 300

  ?> 
See also imagecreate(), getimagesize() and imagesy().   imagestringupUpimagesy
#

#T=int imagesx ( resource image)
imagesx ( ^!resource image);
#

#T=imagesy - int imagesy ( resource image)
(PHP 3, PHP 4 )
imagesy -- Get image height
Description
int imagesy ( resource image)
imagesy() returns the height of the image identified by image. 
Example 1. Using imagesy()
  <?php

  // create a 300*200 image
  $img = imagecreate(300, 200);

  echo imagesy($img); // 200

  ?> 
See also imagecreate(), getimagesize() and imagesx().   imagesxUpimagetruecolortopalette
#

#T=int imagesy ( resource image)
imagesy ( ^!resource image);
#

#T=imagetruecolortopalette - void imagetruecolortopalette ( resource image, bool dither, int ncolors)
(PHP 4 >= 4.0.6)
imagetruecolortopalette -- Convert a true color image to a palette image
Description
void imagetruecolortopalette ( resource image, bool dither, int ncolors)
imagetruecolortopalette() converts a truecolor image to a palette image. 
The code for this function was originally drawn from the Independent JPEG 
Group library code, which is excellent. The code has been modified to 
preserve as much alpha channel information as possible in the resulting 
palette, in addition to preserving colors as well as possible. This does 
not work as well as might be hoped. It is usually best to simply produce a 
truecolor output image instead, which guarantees the highest output 
quality. 
dither indicates if the image should be dithered - if it is TRUE then 
dithering will be used which will result in a more speckled image but with 
better color approximation. 
ncolors sets the maximum number of colors that should be retained in the 
palette. 
Note: This function was added in PHP 4.0.6 and requires GD 2.0.1 or 
later   imagesyUpimagettfbbox
#

#T=void imagetruecolortopalette ( resource image, bool dither, int ncolors)
imagetruecolortopalette ( ^!resource image, bool dither, int ncolors);
#

#T=imagettfbbox - array imagettfbbox ( int size, int angle, string fontfile, string text)
(PHP 3>= 3.0.1, PHP 4 )
imagettfbbox -- Give the bounding box of a text using TrueType fonts
Description
array imagettfbbox ( int size, int angle, string fontfile, string text)
This function calculates and returns the bounding box in pixels for a 
TrueType text. 
text
The string to be measured.
size
The font size in pixels.
fontfile
The name of the TrueType font file. (Can also be an URL.) Depending on 
which version of the GD library that PHP is using, it may attempt to 
search for files that do not begin with a leading '/' by appending 
'.ttf' to the filename and searching along a library-defined font path. 
angle
Angle in degrees in which text will be measured. 
imagettfbbox() returns an array with 8 elements representing four points 
making the bounding box of the text: 
0lower left corner, X position
1lower left corner, Y position
2lower right corner, X position
3lower right corner, Y position
4upper right corner, X position
5upper right corner, Y position
6upper left corner, X position
7upper left corner, Y position

The points are relative to the text regardless of the angle, so "upper 
left" means in the top left-hand corner seeing the text horizontally. 
This function requires both the GD library and the FreeType library. 
See also imagettftext().   imagetruecolortopaletteUpimagettftext
#

#T=array imagettfbbox ( int size, int angle, string fontfile, string text)
imagettfbbox ( ^!int size, int angle, string fontfile, string text);
#

#T=imagettftext - array imagettftext ( resource image, int size, int angle, int x, int y, 
(PHP 3, PHP 4 )
imagettftext -- Write text to the image using TrueType fonts
Description
array imagettftext ( resource image, int size, int angle, int x, int y, 
int color, string fontfile, string text)
imagettftext() draws the string text in the image identified by image, 
starting at coordinates x, y (top left is 0, 0), at an angle of angle in 
color color, using the TrueType font file identified by fontfile. 
Depending on which version of the GD library that PHP is using, when 
fontfile does not begin with a leading '/', '.ttf' will be appended to the 
filename and the library will attempt to search for that filename along a 
library-defined font path. 
The coordinates given by x, y will define the basepoint of the first 
character (roughly the lower-left corner of the character). This is 
different from the imagestring(), where x, y define the upper-right corner 
of the first character. 
angle is in degrees, with 0 degrees being left-to-right reading text (3 
o'clock direction), and higher values representing a counter-clockwise 
rotation. (i.e., a value of 90 would result in bottom-to-top reading 
text). 
fontfile is the path to the TrueType font you wish to use. 
text is the text string which may include UTF-8 character sequences (of 
the form: &#123;) to access characters in a font beyond the first 255. 
color is the color index. Using the negative of a color index has the 
effect of turning off antialiasing. 
imagettftext() returns an array with 8 elements representing four points 
making the bounding box of the text. The order of the points is lower 
left, lower right, upper right, upper left. The points are relative to the 
text regardless of the angle, so "upper left" means in the top left-hand 
corner when you see the text horizontally. 
This example script will produce a black JPEG 400x30 pixels, with the 
words "Testing..." in white in the font Arial. Example 1. 
imagettftext() example
  <?php
    header("Content-type: image/jpeg");
    $im = imagecreate(400, 30);
    $white = imagecolorallocate($im, 255, 255, 255);
    $black = imagecolorallocate($im, 0, 0, 0);
    
    // Replace path by your own font path
    imagettftext($im, 20, 0, 10, 20, $black, "/path/arial.ttf",
    "Testing... Omega: &amp;#937;");
    imagejpeg($im);
    imagedestroy($im);
  ?> 
This function requires both the GD library and the FreeType library. 
See also imagettfbbox().   imagettfbboxUpimagetypes
#

#T=array imagettftext ( resource image, int size, int angle, int x, int y, 
imagettftext ( ^!resource image, int size, int angle, int x, int y, ;
#

#T=imagetypes - int imagetypes ( void )
(PHP 3 CVS only, PHP 4 >= 4.0.2)
imagetypes -- Return the image types supported by this PHP build
Description
int imagetypes ( void )
This function returns a bit-field corresponding to the image formats 
supported by the version of GD linked into PHP. The following bits are 
returned, IMG_GIF | IMG_JPG | IMG_PNG | IMG_WBMP. To check for PNG 
support, for example, do this: Example 1. imagetypes() example
  <?php
  if (imagetypes() & IMG_PNG) {
      echo "PNG Support is enabled";
  }
  ?> 

  imagettftextUpimagewbmp
#

#T=int imagetypes ( void )
imagetypes ( ^!void );
#

#T=imagewbmp - int imagewbmp ( resource image [, string filename [, int foreground]])
(PHP 3>= 3.0.15, PHP 4 >= 4.0.1)
imagewbmp -- Output image to browser or file
Description
int imagewbmp ( resource image [, string filename [, int foreground]])
imagewbmp() creates the WBMP file in filename from the image image. The 
image argument is the return from the imagecreate() function. 
The filename argument is optional, and if left off, the raw image stream 
will be output directly. By sending an image/vnd.wap.wbmp content-type 
using header(), you can create a PHP script that outputs WBMP images 
directly. 
Note: WBMP support is only available if PHP was compiled against GD-1.8 
or later. 
Using the optional foreground parameter, you can set the foreground color. 
Use an identifier obtained from imagecolorallocate(). The default 
foreground color is black. 
See also image2wbmp(), imagepng(), imagegif(), imagejpeg(), imagetypes().   imagetypesUpiptcembed
#

#T=int imagewbmp ( resource image [, string filename [, int foreground]])
imagewbmp ( ^!resource image [, string filename [, int foreground]]);
#

#T=imap_8bit - string imap_8bit ( string string)
(PHP 3, PHP 4 )
imap_8bit --  Convert an 8bit string to a quoted-printable string 
Description
string imap_8bit ( string string)
Convert an 8bit string to a quoted-printable string (according to RFC2045, 
section 6.7). 
Returns a quoted-printable string. 
See also imap_qprint().   IMAP, POP3 and NNTP functionsUpimap_alerts
#

#T=string imap_8bit ( string string)
imap_8bit ( ^!string string);
#

#T=imap_alerts - array imap_alerts ( void )
(PHP 3>= 3.0.12, PHP 4 )
imap_alerts --  This function returns all IMAP alert messages (if any) 
that have occurred during this page request or since the alert stack was 
reset 
Description
array imap_alerts ( void )
This function returns an array of all of the IMAP alert messages generated 
since the last imap_alerts() call, or the beginning of the page. When 
imap_alerts() is called, the alert stack is subsequently cleared. The IMAP 
specification requires that these messages be passed to the user.   imap_8bitUpimap_append
#

#T=array imap_alerts ( void )
imap_alerts ( ^!void );
#

#T=imap_append - bool imap_append ( resource imap_stream, string mbox, string message [, 
(PHP 3, PHP 4 )
imap_append --  Append a string message to a specified mailbox 
Description
bool imap_append ( resource imap_stream, string mbox, string message [, 
string options])
imap_append() appends a string message to the specified mailbox mbox. If 
the optional options is specified, writes the options to that mailbox 
also. 
Returns TRUE on success or FALSE on failure. 
When talking to the Cyrus IMAP server, you must use "\r\n" as your 
end-of-line terminator instead of "\n" or the operation will fail. 
Example 1. imap_append() example
  <?php
  $stream = imap_open("{your.imap.host}INBOX.Drafts", 
  "username", "password");

  $check = imap_check($stream);
  echo "Msg Count before append: ". $check->Nmsgs."\n";

  imap_append($stream, "{your.imap.host}INBOX.Drafts"
		     , "From: me@example.com\r\n"
		     . "To: you@example.com\r\n"
		     . "Subject: test\r\n"
		     . "\r\n"
		     . "this is a test message, please 
  ignore\r\n"
		     );

  $check = imap_check($stream);
  echo "Msg Count after append : ". $check->Nmsgs."\n";

  imap_close($stream);
  ?> 

  imap_alertsUpimap_base64
#

#T=bool imap_append ( resource imap_stream, string mbox, string message [, 
imap_append ( ^!resource imap_stream, string mbox, string message [, ;
#

#T=imap_base64 - string imap_base64 ( string text)
(PHP 3, PHP 4 )
imap_base64 -- Decode BASE64 encoded text
Description
string imap_base64 ( string text)
imap_base64() function decodes BASE-64 encoded text (see RFC2045, Section 
6.8). The decoded message is returned as a string. 
See also imap_binary(), base64_encode() and base64_decode().   imap_appendUpimap_binary
#

#T=string imap_base64 ( string text)
imap_base64 ( ^!string text);
#

#T=imap_binary - string imap_binary ( string string)
(PHP 3>= 3.0.2, PHP 4 )
imap_binary --  Convert an 8bit string to a base64 string 
Description
string imap_binary ( string string)
Convert an 8bit string to a base64 string (according to RFC2045, Section 
6.8). 
Returns a base64 string. 
See also imap_base64().   imap_base64Upimap_body
#

#T=string imap_binary ( string string)
imap_binary ( ^!string string);
#

#T=imap_body - string imap_body ( resource imap_stream, int msg_number [, int options])
(PHP 3, PHP 4 )
imap_body -- Read the message body
Description
string imap_body ( resource imap_stream, int msg_number [, int options])
imap_body() returns the body of the message, numbered msg_number in the 
current mailbox. The optional flags are a bit mask with one or more of the 
following: 
FT_UID - The msgno is a UID 
FT_PEEK - Do not set the \Seen flag if not already set 
FT_INTERNAL - The return string is in internal format, will not 
canonicalize to CRLF. 
imap_body() will only return a verbatim copy of the message body. To 
extract single parts of a multipart MIME-encoded message you have to use 
imap_fetchstructure() to analyze its structure and imap_fetchbody() to 
extract a copy of a single body component.   imap_binaryUpimap_bodystruct
#

#T=string imap_body ( resource imap_stream, int msg_number [, int options])
imap_body ( ^!resource imap_stream, int msg_number [, int options]);
#

#T=imap_bodystruct - object imap_bodystruct ( resource stream_id, int msg_no, int section)
(PHP 3>= 3.0.4, PHP 4 )
imap_bodystruct --  Read the structure of a specified body section of a 
specific message 
Description
object imap_bodystruct ( resource stream_id, int msg_no, int section)
Warning
This function is currently not documented; only the argument list is 
available.
  imap_bodyUpimap_check
#

#T=object imap_bodystruct ( resource stream_id, int msg_no, int section)
imap_bodystruct ( ^!resource stream_id, int msg_no, int section);
#

#T=imap_check - object imap_check ( resource imap_stream)
(PHP 3, PHP 4 )
imap_check -- Check current mailbox
Description
object imap_check ( resource imap_stream)
Returns information about the current mailbox. Returns FALSE on failure. 
The imap_check() function checks the current mailbox status on the server 
and returns the information in an object with following properties: 
Date - current system time formatted according to RFC822 
Driver - protocol used to access this mailbox: POP3, IMAP, NNTP 
Mailbox - the mailbox name 
Nmsgs - number of messages in the mailbox 
Recent - number of recent messages in the mailbox 
Example 1. imap_check() example
  <?php

  $imap_obj = imap_check($imap_stream);
  var_dump($imap_obj);

  ?> 

this will output : 
object(stdClass)(5) {
["Date"]=>
string(37) "Wed, 10 Dec 2003 17:56:54 +0100 (CET)"
["Driver"]=>
string(4) "imap"
["Mailbox"]=>
string(54)
"{www.example.com:143/imap/user="foo@example.com"}INBOX"
["Nmsgs"]=>
int(1)
["Recent"]=>
int(0)
}

  imap_bodystructUpimap_clearflag_full
#

#T=object imap_check ( resource imap_stream)
imap_check ( ^!resource imap_stream);
#

#T=imap_clearflag_full - bool imap_clearflag_full ( resource stream, string sequence, string flag, 
(PHP 3>= 3.0.3, PHP 4 )
imap_clearflag_full -- Clears flags on messages
Description
bool imap_clearflag_full ( resource stream, string sequence, string flag, 
string options)
This function causes a store to delete the specified flag to the flags set 
for the messages in the specified sequence. The flags which you can unset 
are "\\Seen", "\\Answered", "\\Flagged", "\\Deleted", and "\\Draft" (as 
defined by RFC2060). 
The options are a bit mask with one or more of the following: 

ST_UID          The sequence argument contains UIDs instead of
      sequence numbers
  imap_checkUpimap_close
#

#T=bool imap_clearflag_full ( resource stream, string sequence, string flag, 
imap_clearflag_full ( ^!resource stream, string sequence, string flag, ;
#

#T=imap_close - bool imap_close ( resource imap_stream [, int flag])
(PHP 3, PHP 4 )
imap_close -- Close an IMAP stream
Description
bool imap_close ( resource imap_stream [, int flag])
Closes the imap stream. Takes an optional flag CL_EXPUNGE, which will 
silently expunge the mailbox before closing, removing all messages marked 
for deletion.   imap_clearflag_fullUpimap_createmailbox
#

#T=bool imap_close ( resource imap_stream [, int flag])
imap_close ( ^!resource imap_stream [, int flag]);
#

#T=imap_createmailbox - bool imap_createmailbox ( resource imap_stream, string mbox)
(PHP 3, PHP 4 )
imap_createmailbox -- Create a new mailbox
Description
bool imap_createmailbox ( resource imap_stream, string mbox)
imap_createmailbox() creates a new mailbox specified by mbox. Names 
containing international characters should be encoded by 
imap_utf7_encode() 
Returns TRUE on success and FALSE on error. 
See also imap_renamemailbox(), imap_deletemailbox() and imap_open() for 
the format of mbox names. 
Example 1. imap_createmailbox() example
  <?php
  $mbox = imap_open("{your.imap.host}", "username", "password", 
  OP_HALFOPEN)
       or die("can't connect: " . imap_last_error());

  $name1 = "phpnewbox";
  $name2 = imap_utf7_encode("phpnewb&ouml;x");

  $newname = $name1;

  echo "Newname will be '$name1'<br />\n";

  # we will now create a new mailbox "phptestbox" in your inbox 
  folder,
  # check its status after creation and finaly remove it to 
  restore
  # your inbox to its initial state 
  if (@imap_createmailbox($mbox, 
  imap_utf7_encode("{your.imap.host}INBOX.$newname"))) {
    $status = @imap_status($mbox, 
  "{your.imap.host}INBOX.$newname", SA_ALL);
    if ($status) {
      echo "your new mailbox '$name1' has the following 
  status:<br />\n";
      echo "Messages:   " . $status->messages    . "<br />\n";
      echo "Recent:     " . $status->recent      . "<br />\n";
      echo "Unseen:     " . $status->unseen      . "<br />\n";
      echo "UIDnext:    " . $status->uidnext     . "<br />\n";
      echo "UIDvalidity:" . $status->uidvalidity . "<br />\n";
      
      if (imap_renamemailbox($mbox, 
  "{your.imap.host}INBOX.$newname", 
  "{your.imap.host}INBOX.$name2")) {
	echo "renamed new mailbox from '$name1' to '$name2'<br 
  />\n";
	$newname=$name2;
      } else {
	echo "imap_renamemailbox on new mailbox failed: " . 
  imap_last_error() . "<br />\n";
      }
    } else {
      echo "imap_status on new mailbox failed: " . 
  imap_last_error() . "<br />\n";
    }
    if (@imap_deletemailbox($mbox, 
  "{your.imap.host}INBOX.$newname")) {
      echo "new mailbox removed to restore initial state<br 
  />\n";
    } else {
      echo "imap_deletemailbox on new mailbox failed: " . 
  implode("<br />\n", imap_errors()) . "<br />\n";
    }
    
  } else {
    echo "could not create new mailbox: " . implode("<br />\n", 
  imap_errors()) . "<br />\n";
  }

  imap_close($mbox);
  ?> 

  imap_closeUpimap_delete
#

#T=bool imap_createmailbox ( resource imap_stream, string mbox)
imap_createmailbox ( ^!resource imap_stream, string mbox);
#

#T=imap_delete - bool imap_delete ( int imap_stream, int msg_number [, int options])
(PHP 3, PHP 4 )
imap_delete --  Mark a message for deletion from current mailbox 
Description
bool imap_delete ( int imap_stream, int msg_number [, int options])
Returns TRUE. 
imap_delete() marks messages listed in msg_number for deletion. The 
optional flags parameter only has a single option, FT_UID, which tells the 
function to treat the msg_number argument as a UID. Messages marked for 
deletion will stay in the mailbox until either imap_expunge() is called or 
imap_close() is called with the optional parameter CL_EXPUNGE. 
Note: POP3 mailboxes do not have their message flags saved between 
connections, so imap_expunge() must be called during the same connection 
in order for messages marked for deletion to actually be purged. 
Example 1. imap_delete() example
  <?php
  $mbox = imap_open("{your.imap.host}INBOX", "username", 
  "password")
      or die("Can't connect: " . imap_last_error());

  $check = imap_mailboxmsginfo($mbox);
  echo "Messages before delete: " . $check->Nmsgs . "<br />\n";
  imap_delete($mbox, 1);
  $check = imap_mailboxmsginfo($mbox);
  echo "Messages after  delete: " . $check->Nmsgs . "<br />\n";
  imap_expunge($mbox);
  $check = imap_mailboxmsginfo($mbox);
  echo "Messages after expunge: " . $check->Nmsgs . "<br />\n";
  imap_close($mbox);
  ?> 

  imap_createmailboxUpimap_deletemailbox
#

#T=bool imap_delete ( int imap_stream, int msg_number [, int options])
imap_delete ( ^!int imap_stream, int msg_number [, int options]);
#

#T=imap_deletemailbox - bool imap_deletemailbox ( resource imap_stream, string mbox)
(PHP 3, PHP 4 )
imap_deletemailbox -- Delete a mailbox
Description
bool imap_deletemailbox ( resource imap_stream, string mbox)
imap_deletemailbox() deletes the specified mailbox (see imap_open() for 
the format of mbox names). 
Returns TRUE on success and FALSE on error. 
See also imap_createmailbox(), imap_renamemailbox(), and imap_open() for 
the format of mbox.   imap_deleteUpimap_errors
#

#T=bool imap_deletemailbox ( resource imap_stream, string mbox)
imap_deletemailbox ( ^!resource imap_stream, string mbox);
#

#T=imap_errors - array imap_errors ( void )
(PHP 3>= 3.0.12, PHP 4 )
imap_errors --  This function returns all of the IMAP errors (if any) that 
have occurred during this page request or since the error stack was reset. 

Description
array imap_errors ( void )
This function returns an array of all of the IMAP error messages generated 
since the last imap_errors() call, or the beginning of the page. When 
imap_errors() is called, the error stack is subsequently cleared.   imap_deletemailboxUpimap_expunge
#

#T=array imap_errors ( void )
imap_errors ( ^!void );
#

#T=imap_expunge - bool imap_expunge ( resource imap_stream)
(PHP 3, PHP 4 )
imap_expunge -- Delete all messages marked for deletion
Description
bool imap_expunge ( resource imap_stream)
imap_expunge() deletes all the messages marked for deletion by 
imap_delete(), imap_mail_move(), or imap_setflag_full(). 
Returns TRUE.   imap_errorsUpimap_fetch_overview
#

#T=bool imap_expunge ( resource imap_stream)
imap_expunge ( ^!resource imap_stream);
#

#T=imap_fetch_overview - array imap_fetch_overview ( resource imap_stream, string sequence [, int 
(PHP 3>= 3.0.4, PHP 4 )
imap_fetch_overview --  Read an overview of the information in the headers 
of the given message 
Description
array imap_fetch_overview ( resource imap_stream, string sequence [, int 
options])
This function fetches mail headers for the given sequence and returns an 
overview of their contents. sequence will contain a sequence of message 
indices or UIDs, if flags contains FT_UID. The returned value is an array 
of objects describing one message header each: 
subject - the messages subject 
from - who sent it 
date - when was it sent 
message_id - Message-ID 
references - is a reference to this message id 
size - size in bytes 
uid - UID the message has in the mailbox 
msgno - message sequence number in the maibox 
recent - this message is flagged as recent 
flagged - this message is flagged 
answered - this message is flagged as answered 
deleted - this message is flagged for deletion 
seen - this message is flagged as already read 
draft - this message is flagged as being a draft 
Example 1. imap_fetch_overview() example
  <?php
  $mbox = imap_open("{your.imap.host:143}", "username", 
  "password")
       or die("can't connect: " . imap_last_error());

  $overview = imap_fetch_overview($mbox, "2,4:6", 0);

  if (is_array($overview)) {
	  reset($overview);
	  while (list($key, $val) = each($overview)) {
		  echo      $val->msgno
		  . " - " . $val->date
		  . " - " . $val->subject
		  . "\n";
	  }
  }

  imap_close($mbox);
  ?> 

  imap_expungeUpimap_fetchbody
#

#T=array imap_fetch_overview ( resource imap_stream, string sequence [, int 
imap_fetch_overview ( ^!resource imap_stream, string sequence [, int ;
#

#T=imap_fetchbody - string imap_fetchbody ( resource imap_stream, int msg_number, string 
(PHP 3, PHP 4 )
imap_fetchbody --  Fetch a particular section of the body of the message 
Description
string imap_fetchbody ( resource imap_stream, int msg_number, string 
part_number [, flags options])
This function causes a fetch of a particular section of the body of the 
specified messages as a text string and returns that text string. The 
section specification is a string of integers delimited by period which 
index into a body part list as per the IMAP4 specification. Body parts are 
not decoded by this function. 
The options for imap_fetchbody() is a bitmask with one or more of the 
following: 
FT_UID - The msg_number is a UID 
FT_PEEK - Do not set the \Seen flag if not already set 
FT_INTERNAL - The return string is in "internal" format, without any 
attempt to canonicalize CRLF. 
See also: imap_fetchstructure().   imap_fetch_overviewUpimap_fetchheader
#

#T=string imap_fetchbody ( resource imap_stream, int msg_number, string 
imap_fetchbody ( ^!resource imap_stream, int msg_number, string ;
#

#T=imap_fetchheader - string imap_fetchheader ( resource imap_stream, int msgno, int options)
(PHP 3>= 3.0.3, PHP 4 )
imap_fetchheader -- Returns header for a message
Description
string imap_fetchheader ( resource imap_stream, int msgno, int options)
This function causes a fetch of the complete, unfiltered RFC2822 format 
header of the specified message as a text string and returns that text 
string. 
The options are: 

FT_UID          The msgno argument is a UID 
FT_INTERNAL     The return string is in "internal" format,
      without any attempt to canonicalize to CRLF
      newlines
FT_PREFETCHTEXT The RFC822.TEXT should be pre-fetched at the
      same time.  This avoids an extra RTT on an
      IMAP connection if a full message text is
      desired (e.g. in a "save to local file"
      operation)
  imap_fetchbodyUpimap_fetchstructure
#

#T=string imap_fetchheader ( resource imap_stream, int msgno, int options)
imap_fetchheader ( ^!resource imap_stream, int msgno, int options);
#

#T=imap_fetchstructure - object imap_fetchstructure ( resource imap_stream, int msg_number [, int 
(PHP 3, PHP 4 )
imap_fetchstructure --  Read the structure of a particular message 
Description
object imap_fetchstructure ( resource imap_stream, int msg_number [, int 
options])
This function fetches all the structured information for a given message. 
The optional flags parameter only has a single option, FT_UID, which tells 
the function to treat the msg_number argument as a UID. The returned 
object includes the envelope, internal date, size, flags and body 
structure along with a similar object for each mime attachment. The 
structure of the returned objects is as follows: 
Table 1. Returned Objects for imap_fetchstructure() 
typePrimary body type
encodingBody transfer encoding
ifsubtypeTRUE if there is a subtype string
subtypeMIME subtype
ifdescriptionTRUE if there is a description string
descriptionContent description string
ifidTRUE if there is an identification string
idIdentification string
linesNumber of lines
bytesNumber of bytes
ifdispositionTRUE if there is a disposition string
dispositionDisposition string
ifdparametersTRUE if the dparameters array exists
dparametersAn array of objects where each object has an "attribute" 
and a "value" property corresponding to the parameters on the 
Content-disposition MIMEheader.
ifparametersTRUE if the parameters array exists
parametersAn array of objects where each object has an "attribute" 
and a "value" property.
partsAn array of objects identical in structure to the top-level 
object, each of which corresponds to a MIME body part.

Table 2. Primary body type
0text
1multipart
2message
3application
4audio
5image
6video
7other

Table 3. Transfer encodings
07BIT
18BIT
2BINARY
3BASE64
4QUOTED-PRINTABLE
5OTHER

See also: imap_fetchbody().   imap_fetchheaderUpimap_get_quota
#

#T=object imap_fetchstructure ( resource imap_stream, int msg_number [, int 
imap_fetchstructure ( ^!resource imap_stream, int msg_number [, int ;
#

#T=imap_get_quota - array imap_get_quota ( resource imap_stream, string quota_root)
(PHP 4 >= 4.0.5)
imap_get_quota --  Retrieve the quota level settings, and usage statics 
per mailbox 
Description
array imap_get_quota ( resource imap_stream, string quota_root)
Returns an array with integer values limit and usage for the given 
mailbox. The value of limit represents the total amount of space allowed 
for this mailbox. The usage value represents the mailboxes current level 
of capacity. Will return FALSE in the case of failure. 
This function is currently only available to users of the c-client2000 or 
greater library. 
NOTE: For this function to work, the mail stream is required to be opened 
as the mail-admin user. For a non-admin user version of this function, 
please see the imap_get_quotaroot() function of PHP. 
imap_stream should be the value returned from an imap_open() call. NOTE: 
This stream is required to be opened as the mail admin user for the 
get_quota function to work. quota_root should normally be in the form of 
user.name where name is the mailbox you wish to retrieve information 
about. 
Example 1. imap_get_quota() example
  <?php
  $mbox = imap_open("{your.imap.host}", "mailadmin", "password", 
  OP_HALFOPEN)
	or die("can't connect: " . imap_last_error());

  $quota_value = imap_get_quota($mbox, "user.kalowsky");
  if (is_array($quota_value)) {
      echo "Usage level is: " . $quota_value['usage'];
      echo "Limit level is: " . $quota_value['limit'];
  } 

  imap_close($mbox); 
  ?> 
As of PHP version 4.3, the function more properly reflects the 
functionality as dictated by the RFC 2087. The array return value has 
changed to support an unlimited number of returned resources (i.e. 
messages, or sub-folders) with each named resource receiving an individual 
array key. Each key value then contains an another array with the usage 
and limit values within it. The example below shows the updated returned 
output. 
For backwards compatibility reasons, the originial access methods are 
still available for use, although it is suggested to update. 
Example 2. imap_get_quota() 4.3 or greater example
  <?php
  $mbox = imap_open("{your.imap.host}", "mailadmin", "password", 
  OP_HALFOPEN)
	or die("can't connect: " . imap_last_error());
	 
  $quota_values = imap_get_quota($mbox, "user.kalowsky");
  if (is_array($quota_values)) {
     $storage = $quota_values['STORAGE'];
     echo "STORAGE usage level is: " .  $storage['usage'];
     echo "STORAGE limit level is: " .  $storage['limit'];

     $message = $quota_values['MESSAGE']; 
     echo "MESSAGE usage level is: " .  $message['usage'];
     echo "MESSAGE limit is: " .  $message['limit'];

     /* ...  */ 
  } 

  imap_close($mbox); 
  ?> 
See also imap_open(), imap_set_quota() and imap_get_quotaroot().   imap_fetchstructureUpimap_get_quotaroot
#

#T=array imap_get_quota ( resource imap_stream, string quota_root)
imap_get_quota ( ^!resource imap_stream, string quota_root);
#

#T=imap_get_quotaroot - array imap_get_quotaroot ( resource imap_stream, string quota_root)
(PHP 4 >= 4.3.0)
imap_get_quotaroot --  Retrieve the quota settings per user 
Description
array imap_get_quotaroot ( resource imap_stream, string quota_root)
Returns an array of integer values pertaining to the specified user 
mailbox. All values contain a key based upon the resource name, and a 
corresponding array with the usage and limit values within. 
The limit value represents the total amount of space allowed for this 
user's total mailbox usage. The usage value represents the user's current 
total mailbox capacity. This function will return FALSE in the case of 
call failure, and an array of information about the connection upon an 
un-parsable response from the server. 
This function is currently only available to users of the c-client2000 or 
greater library. 
imap_stream should be the value returned from an imap_open() call. This 
stream should be opened as the user whose mailbox you wish to check. 
quota_root should normally be in the form of which mailbox (i.e. INBOX). 
Example 1. imap_get_quotaroot() example
  <?php
  $mbox = imap_open("{your.imap.host}", "kalowsky", "password", 
  OP_HALFOPEN)
	or die("can't connect: " . imap_last_error());

  $quota = imap_get_quotaroot($mbox, "INBOX");
  if (is_array($quota)) {
     $storage = $quota_values['STORAGE'];
     echo "STORAGE usage level is: " .  $storage['usage'];
     echo "STORAGE limit level is: " .  $storage['limit'];

     $message = $quota_values['MESSAGE']; 
     echo "MESSAGE usage level is: " .  $message['usage'];
     echo "MESSAGE usage level is: " .  $message['limit'];

     /* ...  */ 

  } 

  imap_close($mbox); 
  ?> 
See also imap_open(), imap_set_quota() and imap_get_quota().   imap_get_quotaUpimap_getacl
#

#T=array imap_get_quotaroot ( resource imap_stream, string quota_root)
imap_get_quotaroot ( ^!resource imap_stream, string quota_root);
#

#T=imap_getacl - array imap_getacl ( resource stream_id, string mailbox)
(PHP 5 CVS only)
imap_getacl --  Gets the ACL for a given mailbox 
Description
array imap_getacl ( resource stream_id, string mailbox)
Warning
This function is currently not documented; only the argument list is 
available.
  imap_get_quotarootUpimap_getmailboxes
#

#T=array imap_getacl ( resource stream_id, string mailbox)
imap_getacl ( ^!resource stream_id, string mailbox);
#

#T=imap_getmailboxes - array imap_getmailboxes ( resource imap_stream, string ref, string 
(PHP 3>= 3.0.12, PHP 4 )
imap_getmailboxes --  Read the list of mailboxes, returning detailed 
information on each one 
Description
array imap_getmailboxes ( resource imap_stream, string ref, string 
pattern)
Returns an array of objects containing mailbox information. Each object 
has the attributes name, specifying the full name of the mailbox; 
delimiter, which is the hierarchy delimiter for the part of the hierarchy 
this mailbox is in; and attributes. Attributes is a bitmask that can be 
tested against: 
LATT_NOINFERIORS - This mailbox has no "children" (there are no 
mailboxes below this one). 
LATT_NOSELECT - This is only a container, not a mailbox - you cannot 
open it. 
LATT_MARKED - This mailbox is marked. Only used by UW-IMAPD. 
LATT_UNMARKED - This mailbox is not marked. Only used by UW-IMAPD. 
Mailbox names containing international Characters outside the printable 
ASCII range will be encoded and may be decoded by imap_utf7_decode(). 
ref should normally be just the server specification as described in 
imap_open(), and pattern specifies where in the mailbox hierarchy to start 
searching. If you want all mailboxes, pass '*' for pattern. 
There are two special characters you can pass as part of the pattern: '*' 
and '%'. '*' means to return all mailboxes. If you pass pattern as '*', 
you will get a list of the entire mailbox hierarchy. '%' means to return 
the current l