import java.util.*;
import java.util.jar.*;
import java.io.*;

class JarToCtl
{
	private String jarFile;
	private String prefix;

	private String[] classes;
	
	JarToCtl( String jarFile )
	{
		this( jarFile, null );
	}

	JarToCtl( String jarFile, String prefix )
	{
		this.jarFile = jarFile;
		this.prefix = prefix;
		System.out.println( "JarToCtl - EditPlus Tool created" +
			" by Luca Sepe & Stefano Bisi (Mar2002)" );
		System.out.println( "---------------------------------" +
			"---------------------------\r\n" );
		System.out.println( ">> Opening file ... " + jarFile );
		if ( prefix == null )
			System.out.println( ">> Analyzing all Classes !!!" );
		else
			System.out.println( ">> Analyzing only classes beginning with : " + prefix );

		classesToStringArray();
		
		System.out.println(">> Found : " + 
			classes.length + " files.." );
	}

	private Vector getClassesFromJar( )
		throws IOException, ClassNotFoundException
	{
		Vector tmp = new Vector();

		JarFile jar = new JarFile( jarFile );
		
		Enumeration e = jar.entries();
		
		while ( e.hasMoreElements() )
		{
			JarEntry entry = (JarEntry)e.nextElement();
			if ( !entry.isDirectory() )
			{
				String jf = entry.toString().replace('/', '.');

				if ( prefix !=null && jf.startsWith(prefix) && 
					 jf.endsWith(".class") && (jf.indexOf('$') < 0) )
				{
					jf = jf.substring( 0, jf.indexOf(".class") );
					System.out.println( ">> Class : " + jf );
					tmp.addElement( jf );
				}
			}
		}
		return tmp;
	}

	private void classesToStringArray( )
	{
		try
		{
			Vector v = getClassesFromJar( );
			classes = new String[v.size()];
		
			for ( int i = 0; i < classes.length; i++ )
				classes[i] = (String)v.elementAt(i);
		} catch ( IOException ioe ) { 
		} catch ( Exception ioe ) { }
	}
	
	public String[] getClasses() { return classes; }

	public static void main(String[] args) throws Exception
	{
		String sJar ="", sFile="", sPrefix = null;
		if ( args.length == 2  )
		{
			sJar = args[0];
			sFile = args[1];
		} else if ( args.length == 3 ) {
			sJar = args[0];
			sFile = args[1];
			sPrefix = args[2];
		} else {
			System.out.println( "Usage : java JarToCtl "+
				"<library.jar> <destDir> [<packagePrefix>]" );
			System.exit(1);
		}

		JarToCtl j2ctl = new JarToCtl( sJar, sPrefix );
		
		String[] classes = j2ctl.getClasses();
		for (int i = 0; i < classes.length; i++ )
			new CTL( classes[i] ).toFile( sFile );
	}
}