#TITLE=AutoIt Script Commands
#INFO
EditPlus cliptext library file for AutoIt 2.64
Cliptext by Robert Olsen <robert@geotrail.no>

#SORT=n

#T=-- AutoIt Special Variables --
 
#T=The type of Operating System being run.
; The type of Operating System being run.  Either "WIN32_WINDOWS" or "WIN32_NT".
A_OSTYPE
#T=Get Windows version
; "WIN_XP", "WIN_2000", "WIN_NT4", "WIN_95", "WIN_98", "WIN_ME".
A_OSVERSION
#T=The current script name.
; The current script name, e.g. "myscript.aut".
A_SCRIPTNAME
#T=Current Dir
; The directory that the current script resides in.
A_SCRIPTDIR
#T=Current path and filename
; The full pathname of the current script, e.g. "C:\Windows\Scripts\myscript.aut".
A_SCRIPTFULLPATH
#T=Working Directory
; The current working directory.
A_WORKINGDIR
#T=SetBatch line setting
; The current setting of the "SetBatchLines" command.
A_NUMBATCHLINES
#T=Time (Seconds)
; Seconds after the minute (00-59)
A_SEC
#T=Time (Minutes)
; Minutes after the hour (00-59)
A_MIN
#T=Time (Hours)
; Hours after midnight (00-23)
A_HOUR
#T=Time (Day 01-31)
; Day of the month (01-31)
A_MDAY
#T=Time (Month 01-12)
; Month of the year (01-12)
A_MON
#T=Time (Year 2003)
; The current year (4 digit format, e.g. 2000)
A_YEAR
#T=Time (Day of week 1-7)
; Day of the week (1-7)
A_WDAY
#T=Time (Day of year 1-365)
; Day of the year (1-365)
A_YDAY
#T= 
#T=Include file
; #include can be used anywhere in the main body of the script (not the ADLIB section) and will
; include the specified file at that position.  (If the include file contains an ADLIB section,
; it will be added to the overall ADLIB section!).
;
^#include <filename to include>^!
#T=AdlibOn
AdlibOn
#T=AdlibOff
AdlibOff
#T=BlockInput
; This command will disable both mouse and keyboard input.
; This only works on various operating system configurations as indicated below:
; Operating System "BlockInput" Results
;
; Windows 95 No effect.
; Windows 98 User input is blocked but AutoIt is also unable to simulate input.
; Windows NT 4 (Without ServicePack 6) No effect.
; Windows NT 4 (With ServicePack 6) User input is blocked and AutoIt can simulate input.
; Windows 2000 User input is blocked and AutoIt can simulate input.
;
; Input will be automatically enabled when the script closes.
BlockInput, <on | off>^!
#T=Break
; This command tells AutoIt whether or not the user can close AutoIt.
; Default is "on" (i.e. user can close AutoIt)
; e.g.
; Break, On
Break, <on | off>^!
#T=DetectHiddenText
; Some programs use hidden windows and hidden text on windows (e.g. Backup Exec)
; this can cause problems when trying to script them.
; This command allows you to tell AutoIt whether or not to detect this hidden text.
; Default is "off".
DetectHiddenText, <on | off>^!
#T=EndRepeat
; Ends an Repeat command
; eg:
; Repeat, 10
; MsgBox, 0, Example, This will be output ten times!
; EndRepeat
EndRepeat
#T=EnvAdd
; Allows you to add, subtract, multiply and divide with Env variables.
; If the variable or value is not numeric, it will be taken to be zero (0).
; Note this functions perform only integer (whole number) functions - any remainers are dropped.
;
; e.g.
; SetEnv, test, 20
; EnvAdd, test, 20
; MsgBox, 0, Example, %test%
;
; This will output "40" to the screen.
EnvAdd, <Variable>, <Value>^!
#T=EnvDiv
; Allows you to add, subtract, multiply and divide with Env variables.
; If the variable or value is not numeric, it will be taken to be zero (0).
; Note this functions perform only integer (whole number) functions - any remainers are dropped.
;
; e.g.
; SetEnv, test, 20
; EnvAdd, test, 20
; MsgBox, 0, Example, %test%
;
; This will output "40" to the screen.
EnvDiv, <Variable>, <Value>^!
#T=EnvMult
; Allows you to add, subtract, multiply and divide with Env variables.
; If the variable or value is not numeric, it will be taken to be zero (0).
; Note this functions perform only integer (whole number) functions - any remainers are dropped.
;
; e.g.
; SetEnv, test, 20
; EnvAdd, test, 20
; MsgBox, 0, Example, %test%
;
; This will output "40" to the screen.
EnvMult, <Variable>, <Value>^!
#T=EnvSub
; Allows you to add, subtract, multiply and divide with Env variables.
; If the variable or value is not numeric, it will be taken to be zero (0).
; Note this functions perform only integer (whole number) functions - any remainers are dropped.
;
; e.g.
; SetEnv, test, 20
; EnvAdd, test, 20
; MsgBox, 0, Example, %test%
;
; This will output "40" to the screen.
EnvSub, <Variable>, <Value>^!
#T=Exit
; This command will end the script.
; If the optional <exit code> is used, this will return the numeric
; exit code to the calling process.  This can be used in DOS batch files like so:
;
; @ECHO OFF
; AutoIt.exe myscript.aut
; ECHO Exit code of AutoIt was %ERRORLEVEL%
;
Exit^!
#T=FileAppend
; This command will append "Text" to the end of a file.
; If the file does not exist, it will be created.
; e.g.
; FileAppend, This is line 1\nThis is line 2\n, myfile.txt
; This will append two lines of text to "myfile.txt", note
; the use of "\n" to indicate a newline is required.
; If the command is successful %ERRORLEVEL% is set to 0, otherwise it is set to 1.
;
FileAppend, <Text>, <Filename>^!
#T=FileCopy
; This command will copy a file or files from <Source> to <Destination>.
; Simple wildcards (*) are supported.  If the optional last parameter is 1
; then existing files are overwritten.
;
; e.g.
; FileCopy, C:\\*.exe, C:\\TestDir\\*.exe
;
; If the command is successful %ERRORLEVEL% is set to 0, otherwise it is set to 1
FileCopy, <Source>, <Destination>^!
#T=FileCreateDir
; This command will create the directory <Directory>.
; e.g.
; FileCreateDir, C:\\TestDir
;
; If the command is successful %ERRORLEVEL% is set to 0, otherwise it is set to 1
FileCreateDir, <Directory>^!
#T=FileDelete
; This command will delete the specified  <File>.  Wildcards are supported.
; e.g.
; FileDelete, C:\\Test\\*.aut
;
; This will delete all files called *.aut in the C:\Test directory.
;
; If the command is successful %ERRORLEVEL% is set to 0, otherwise it is set to 1.
FileDelete, <File>^!
#T=FileInstall
; This command is a directive for the Aut2Exe compiler and allows you to
; add extra files to the resulting compiled script and to copy them to the
; disk during execution of the script.
;
; The file <Source> is added during script compilation.  When the compiled script
; is executed and the same "FileInstall" command has been reached, the file is then
; extracted to <Destination>.  The last optional parameter can be set to 1 to indicate
; that existing files should be overwritten.
;
; Files added to a script are compressed and also encrypted.
;
; If this command is used in an normal (uncompiled) script, a simple file copy will
; be performed instead -- this will help the testing of scripts that will eventually be compiled.
;
; Note: Wildcards are not supported.
;
; e.g.
; FileInstall, C:\\atool.exe,  %TEMP%\\atool.exe
; If the command is successful %ERRORLEVEL% is set to 0, otherwise it is set to 1.
FileInstall, <Source>, <Destination>, [1 | 0]^!
#T=FileReadLine
; This command will read a line from a file of text into a variable.
; Line 1 is taken to be the first line.
; e.g.
; FileReadLine, test, myfile.txt, 1
; Will read the first line of "myfile.txt" into the %test% variable.
; If the command is successful %ERRORLEVEL% is set to 0, otherwise it is set to 1.
;
FileReadLine, <Variable>, <Filename>, <Line>^!
#T=FileRemoveDir
; This command will delete the directory <Directory>.  Note: the directory must be empty.
; e.g.
; FileRemoveDir, C:\\TestDir
;
; If the command is successful %ERRORLEVEL% is set to 0, otherwise it is set to 1.
FileRemoveDir, <Directory>^!
#T=FileSelectFile
; This command will show the standard file selection dialog.
; If the second parameter is "1" then the filename must already exist.
; On completion, %ERRORLEVEL% is set to 0 if successful.
; If the user cancels to operation %ERRORLEVEL% is set to 1.
; e.g. To prompt the user for a filename that already exists
; FileSelectFile, filenamevar, 1
; MsgBox, 0, Example, Filename selected was %filenamevar%
;
; e.g. To prompt the user for a filename that already exists, and
; initially open in the "C:\My Files" directory
; FileSelectFile, filenamevar, 1, C:\\My Files
; MsgBox, 0, Example, Filename selected was %filenamevar%
;
FileSelectFile, <Filename Var>, <1 | 0> [,<Working Directory>]^!
#T=Gosub
; Just like the old BASIC commands. Gosub will branch to a specified label.
; Return will return to the line after the Gosub command.
; e.g.
; SetEnv, MyMessage, This is the first message!
; Gosub, mysubroutine
; SetEnv, MyMessage, This is the second message!
; Gosub, mysubroutine
; SetEnv, MyMessage, This is the third message!
; Gosub, mysubroutine
; Exit
;
; mysubroutine:
; MsgBox, 0, AutoIt, %MyMessage%
; Return
;
Gosub,<label>^!
Return
#T=Goto
; Script execution will continue at the specified label.
; e.g.
;; This script will loop forever
; myloop:
; Sleep, 10
; Goto, myloop
;
Goto, <label>^!
#T=HideAutoItWin
; This command can be used to completely hide the AutoIt
; window and tray icon from the user.
HideAutoItWin, on^!
#T=IfExist
; Will cause the script to execute <Command> if the specified file
; or directory exists/doesn't exists.
; e.g.
; IfExist, C:\\COMMAND.COM, Goto, fileexist
; Exit
; fileexist:
;; Script will get to here if C:\COMMAND.COM DOES exist.
; MsgBox, 0, AutoIt, File exists
IfExist, <file or directory>, <Command>^!
#T=IfNotExist
; Will cause the script to execute <Command> if the specified file
; or directory exists/doesn't exists.
; e.g.
; IfExist, C:\\COMMAND.COM, Goto, fileexist
; Exit
; fileexist:
;; Script will get to here if C:\COMMAND.COM DOES exist.
; MsgBox, 0, AutoIt, File exists
IfNotExist,<file or directory>,<Command>^!
#T=IfEqual
; Will compare the DOS variable <variable> with <text> and branch depending on the result.
; e.g.
; InputBox, MyVar, AutoIt, Please enter the word: WOMBLE
; IfEqual, MyVar, WOMBLE, Goto, match
; MsgBox, 0, AutoIt, You didnt type the correct word!
; Exit
; match:
; MsgBox, 0, AutoIt, Well done! You typed in the correct word!
IfEqual, <variable>, <text>, <Command>^!
#T=IfNotEqual
; Will compare the DOS variable <variable> with <text> and branch depending on the result.
; e.g.
; InputBox, MyVar, AutoIt, Please enter the word: WOMBLE
; IfEqual, MyVar, WOMBLE, Goto, match
; MsgBox, 0, AutoIt, You didnt type the correct word!
; Exit
; match:
; MsgBox, 0, AutoIt, Well done! You typed in the correct word!
IfNotEqual,<variable>, <text>, <Command>^!
#T=IfGreater
; Will compare the DOS variable <variable> with <number> and
; branch depending on the result.  If the parameters are not numeric
; they will be treated as being zero.
IfGreater, <variable>, <number>, <Command>^!
#T=IfGreaterOrEqual
; Will compare the DOS variable <variable> with <number> and
; branch depending on the result.  If the parameters are not numeric
; they will be treated as being zero.
IfGreaterOrEqual, <variable>, <number>, <Command>^!
#T=IfLess
; Will compare the DOS variable <variable> with <number> and
; branch depending on the result.  If the parameters are not numeric
; they will be treated as being zero.
IfLess, <variable>, <number>, <Command>^!
#T=IfLessOrEqual
; Will compare the DOS variable <variable> with <number> and
; branch depending on the result.  If the parameters are not numeric
; they will be treated as being zero.
IfLessOrEqual, <variable>, <number>, <Command>^!
#T=IfInString
; Checks to see if the contents of the <Search String Variable> is/is not present
; in the string <String>.  If the condition is met, <Command> will be executed.
; If a match was made, %ERRORLEVEL% will be set to 0.
; Otherwise, %ERRORLEVEL% will be set to 1.
; e.g. To check if the word "Hello" is in the string "Hello this is a string"
; SetEnv, search, Hello this is a string
; IfInString, search, Hello, MsgBox, 0, Matched, Yes, the search string was found
; (This will output "Yes, the search string was found)
;
IfInString, <String Variable>, <Search String>, <Command>^!
#T=IfNotInString
; Checks to see if the contents of the <Search String Variable> is/is not present
; in the string <String>.  If the condition is met, <Command> will be executed.
; If a match was made, %ERRORLEVEL% will be set to 0.
; Otherwise, %ERRORLEVEL% will be set to 1.
; e.g. To check if the word "Hello" is in the string "Hello this is a string"
; SetEnv, search, Hello this is a string
; IfInString, search, Hello, MsgBox, 0, Matched, Yes, the search string was found
; (This will output "Yes, the search string was found)
;
IfNotInString, <String Variable>, <Search String>, <Command>^!
#T=IfWinActive
; If the condition is met (i.e. the window title and text exists, is
; active, doesn't exist, is inactive) then the script will execute the <Command>.
; N.B. If no window text is to be given you MUST include the extra comma.
; e.g.
; IfWinExist, Win Title, Win Text, Goto, label1
; IfWinExist, Win Title,, Goto, label1
;
IfWinActive, <Window Title>, [<Window Text>], <Command>^!
#T=IfWinNotActive
; If the condition is met (i.e. the window title and text exists, is
; active, doesn't exist, is inactive) then the script will execute the <Command>.
; N.B. If no window text is to be given you MUST include the extra comma.
; e.g.
; IfWinExist, Win Title, Win Text, Goto, label1
; IfWinExist, Win Title,, Goto, label1
;
IfWinNotActive, <Window Title>, [<Window Text>], <Command>^!
#T=IfWinExist
; If the condition is met (i.e. the window title and text exists, is
; active, doesn't exist, is inactive) then the script will execute the <Command>.
; N.B. If no window text is to be given you MUST include the extra comma.
; e.g.
; IfWinExist, Win Title, Win Text, Goto, label1
; IfWinExist, Win Title,, Goto, label1
;
IfWinExist, <Window Title>, [<Window Text>], <Command>^!
#T=IfWinNotExist
; If the condition is met (i.e. the window title and text exists, is
; active, doesn't exist, is inactive) then the script will execute the <Command>.
; N.B. If no window text is to be given you MUST include the extra comma.
; e.g.
; IfWinExist, Win Title, Win Text, Goto, label1
; IfWinExist, Win Title,, Goto, label1
;
IfWinNotExist, <Window Title>, [<Window Text>], <Command>^!
#T=IfMsgBox
; Use this to execute a command  based on the button the user pressed in the MsgBox command.
; Valid return values from MsgBox are:
; ABORT, CANCEL, IGNORE, NO, OK, RETRY, YES
;
; e.g. To put up a dialog box, with OK and CANCEL buttons, then branch if the user selects CANCEL:
;
; Example Script
; MsgBox, 1, AutoIt, This is a test message
; IfMsgBox, CANCEL, Goto, cancellabel
; Exit
; cancellabel:
; If the script gets to here, user pressed cancel
; MsgBox, 0, AutoIt, The user pressed cancel
;
IfMsgBox, <return value>, <Command>^!
#T=IniRead
; Allows reading and writing of standard windows .ini files., i.e. the following format.
; [SectionName]
; KeyName=Value
;
; e.g. To read the value of "mykey" from the "mysection" part of an ini
; file, into the variable "%result%":
; IniRead, result, c:\\mypath\\myfile.ini, mysection, mykey
;
; e.g. To write the text "womble" into the same section and key:
; IniWrite, womble, c:\\mypath\\myfile.ini, mysection, mykey
;
; e.g. To write the DOS path information into the same section and key:
; IniWrite, %path%, c:\\mypath\\myfile.ini, mysection, mykey
;
; e.g. To delete the DOS path information into the same section and key:
; IniDelete, c:\\mypath\\myfile.ini, mysection, mykey
;
; NB. The full path and filename of the .ini file must be given.
;
IniRead,<variable>, <filename>, <section>, <key>^!
#T=IniWrite
; Allows reading and writing of standard windows .ini files., i.e. the following format.
; [SectionName]
; KeyName=Value
;
; e.g. To read the value of "mykey" from the "mysection" part of an ini
; file, into the variable "%result%":
; IniRead, result, c:\\mypath\\myfile.ini, mysection, mykey
;
; e.g. To write the text "womble" into the same section and key:
; IniWrite, womble, c:\\mypath\\myfile.ini, mysection, mykey
;
; e.g. To write the DOS path information into the same section and key:
; IniWrite, %path%, c:\\mypath\\myfile.ini, mysection, mykey
;
; e.g. To delete the DOS path information into the same section and key:
; IniDelete, c:\\mypath\\myfile.ini, mysection, mykey
;
; NB. The full path and filename of the .ini file must be given.
;
IniWrite,<value>, <filename>, <section>, <key>^!
#T=IniDelete
; Allows reading and writing of standard windows .ini files., i.e. the following format.
; [SectionName]
; KeyName=Value
;
; e.g. To read the value of "mykey" from the "mysection" part of an ini
; file, into the variable "%result%":
; IniRead, result, c:\\mypath\\myfile.ini, mysection, mykey
;
; e.g. To write the text "womble" into the same section and key:
; IniWrite, womble, c:\\mypath\\myfile.ini, mysection, mykey
;
; e.g. To write the DOS path information into the same section and key:
; IniWrite, %path%, c:\\mypath\\myfile.ini, mysection, mykey
;
; e.g. To delete the DOS path information into the same section and key:
; IniDelete, c:\\mypath\\myfile.ini, mysection, mykey
;
; NB. The full path and filename of the .ini file must be given.
;
IniDelete, <Filename>, <Section>, <Key>^!
#T=InputBox
; Will cause a dialog box with <message> to appear. The user can enter text, press OK,
; and the text will be stored in the DOS variable <variable>.  If the "hide" parameter
; is used, input will be masked (eg. for passwords).
;
; e.g.
; InputBox, MyMessage, AutoIt, Please - Enter some text to display!
; MsgBox, 0, AutoIt, %MyMessage%
;
; e.g.
; InputBox, password, AutoIt, Please enter your password (input is hidden), hide
InputBox, <variable>, <title>, <message> [,hide]^!
#T=LeftClick
; Simulates a left or right mouse button click. The X and Y co-ordinates are relative
; to the currently active window. Run AutoIt in reveal mode to determine the required
; co-ordinates of a window.
; To perform a double-click, simply run the command twice :)
;
LeftClick, <x>, <y>^!
#T=LeftClickDrag
; Drags the mouse pointer from x1,y1 to x2,y2 with the relevant mousebutton held down.
; The co-ordinates are relative to the current active window.
;
LeftClickDrag, <x1>, <y1>, <x2>, <y2>^!
#T=MouseGetPos
; This command will get the current position of the mouse cursor into the 'x' and 'y' variables.
; The co-ords are relative to the active window.
;
; e.g.
; MouseGetPos, xpos, ypos
; MsgBox, 0, Examples,  The mouse is at position %xpos% %ypos%
MouseGetPos, <x Variable>, <y Variable>^!
#T=MouseMove
; This command will move the mouse cursor to the position <xpos>, <ypos>.
; The co-ords are relative to the active window.
MouseMove, <x>, <y>^!
#T=MsgBox
; Displays a dialog box with the specified message. Different display modes will
; give different results (appearance, number of buttons). A list of modes is given
; below, add up the numbers of the display modes you want.
;
; e.g. To display "Hello" with just an "OK" button:
; MsgBox, 0, AutoIt, Hello
;
; e.g. To display "Hello" with an exclamation box and OK and Cancel:
; MsgBox, 49, AutoIt, Hello
; (1=OKCANCEL, 48=Exclamation, = 49)
;
; Function AutoIt Value
; MB_OK 0
; MB_OKCANCEL 1
; MB_ABORTRETRYIGNORE 2
; MB_YESNOCANCEL 3
; MB_YESNO 4
; MB_RETRYCANCEL 5
;
; MB_ICONHAND 16
; MB_ICONQUESTION  32
; MB_ICONEXCLAMATION 48
; MB_ICONASTERISK 64
;
; MB_APPLMODAL 0
; MB_SYSTEMMODAL 4096
; MB_TASKMODAL 8192
;
MsgBox, <display mode>, <title>, <message>^!
#T=Random
; This command produces a random number between <Min Value> and <Max Value>.
; (These values must be between 0 and 32767).
;
; e.g. To produce a random number between 1 and 200
; Random, output, 1, 200
; MsgBox, 0, Result, %output%
; (This would output the random number between 1 and 200)
;
Random, <Output Variable>, <Min Value>, <Max Value>^!
#T=RegRead
; This command allows you to read REG_SZ and REG_DWORD values from the regsitry.
; If the command is successful %ERRORLEVEL% is set to 0, otherwise it is set to 1.
;
; RegKey must be either "HKEY_LOCAL_MACHINE", "HKEY_CURRENT_USER", "HKEY_USERS", "HKEY_CURRENT_CONFIG" or "HKEY_CLASSES_ROOT".
; ValueType must be "REG_DWORD" or "REG_SZ".
;
; e.g. To read the location of the "Program Files" directory into the variable "TestKey":
; RegRead, TestKey, REG_SZ, HKEY_LOCAL_MACHINE, Software\\Microsoft\\Windows\\CurrentVersion, ProgramFilesDir
; MsgBox, 0, Example, Program Files are located in %TestKey%
;
RegRead, <Variable>, <ValueType>, <RegKey>, <RegSubKey>, <ValueName>^!
#T=RegWrite
; Similar to the RegRead command, this command will allow you to create or modify a registry key.
; If the command is successful %ERRORLEVEL% is set to 0, otherwise it is set to 1.
;
; e.g. To change the wallpaper of the current user:
; RegWrite, REG_SZ, HKEY_CURRENT_USER, Control Panel\\Desktop, Wallpaper, C:\\Mycrazybitmap.bmp
;
RegWrite, <ValueType>, <RegKey>, <RegSubKey>, <ValueName>, <Value>^!
#T=RegDelete
; This command will delete a regsitry value. If the command is successful %ERRORLEVEL% is set to 0,
; otherwise it is set to 1.
;
; e.g. To delete the wallpaper value of the current user (not particularly recommended :) ):
; RegDelete, HKEY_CURRENT_USER, Control Panel\\Desktop, Wallpaper
;
RegDelete, <RegKey>, <RegSubKey>, <ValueName>^!
#T=Repeat
; This will repeat a section of the script up to the following "EndRepeat" command
; a total of <Count> times.  If <Count> is zero, the loop will be infinite.
; Repeat statements can be nested.
;
; e.g.
; Repeat, 10
; MsgBox, 0, Example, This will be output ten times!
; EndRepeat
;
Repeat, <Count>^!
EndRepeat
#T=Return
; Just like the old BASIC commands. Gosub will branch to a specified label.
; Return will return to the line after the Gosub command.
;
; e.g.
; SetEnv, MyMessage, This is the first message!
; Gosub, mysubroutine
; SetEnv, MyMessage, This is the second message!
; Gosub, mysubroutine
; SetEnv, MyMessage, This is the third message!
; Gosub, mysubroutine
; Exit
;
; mysubroutine:
; MsgBox, 0, AutoIt, %MyMessage%
; Return
;
Return
#T=RightClick
; Simulates a left or right mouse button click. The X and Y co-ordinates are relative
; to the currently active window. Run AutoIt in reveal mode to determine the required
; co-ordinates of a window.
; To perform a double-click, simply run the command twice :)
;
RightClick, <x>, <y>^!
#T=RightClickDrag
; Drags the mouse pointer from x1,y1 to x2,y2 with the relevant mousebutton held down.
; The co-ordinates are relative to the current active window.
;
RightClickDrag, <x1>, <y1>, <x2>, <y2>^!
#T=Run
; Executes a given program and proceeds to the next line of the script. N.B.
; The program to run and the working directory are separated by
; a comma ','. The working directory is optional.
;
; >>>>> N.B. Because the '\' character is special you must use '\\' when specifying paths! <<<<<
;
; e.g.
; Run, notepad.exe, C:\\WINDOWS
; Run, C:\\Program Files\\Microsoft Office\\Office\\WinWord.exe
;
; The first command runs notepad and sets the working directory to "C:\WINDOWS".
; The second command runs MS Word in the current directory.
;
; You can also run command interpreter commands line Echo, Copy, etc.
; e.g.
; Run, COMMAND.COM /C Echo Hello > C:\\Hello.txt
; OR
; Run, %COMSPEC% /C Echo Hello > C:\\Hello.txt
;
; Creates a file called C:\Hello.txt containing the word "Hello".
;
Run, <Program path and name> [,<Working directory> [,<max | min | hide>]]^!
#T=RunWait
; Same as the Run command but waits for the program to finish before continuing
; (recommended when running DOS commands such as copy, md, del, etc.).
;
; This command will also set the variable %ERRORLEVEL% to the return code of the program.
;
RunWait, <Program path and name> [,<Working directory> [,<max | min | hide>]]^!
#T=Send
; Sends a set of keystrokes to the currently active window.
; Send Command Syntax
; The "Send" command syntax is similar to that of ScriptIt and the Visual Basic "SendKeys" command.
; Characters are sent as written with the exception of the following characters:
;
; '!'
; This tells AutoIt to send an ALT keystroke, therefore "Send,This is text!a" would send the keys
; "This is text" and then press "ALT+a".
;
; N.B. Some programs are very choosy about capital letters and ALT keys, i.e. "!A" is
; different to "!a". The first says ALT+SHIFT+A, the second is ALT+a. If in doubt, use lowercase!
;
; '+'
; This tells AutoIt to send a SHIFT keystroke, therefore "Send,Hell+o" would send the
; text "HellO". "Send,!+a" would send "ALT+SHIFT+a".
;
; '^'
; This tells AutoIt to send a CONTROL keystroke, therefore "Send,^!a" would send "CTRL+ALT+a".
;
; N.B. Some programs are very choosy about capital letters and CTRL keys, i.e. "^A" is
; different to "^a". The first says CTRL+SHIFT+A, the second is CTRL+a. If in doubt, use lowercase!
;
; '#'
; The hash is used as a key delimiter to make a line easier to read.  i.e. "Send, H#e#l#l#o" is
; the same as "Send,Hello".
;
; Certain special keys can be sent and should be enclosed in braces:
; N.B.  Windows does not allow the simulation of the "CTRL-ALT-DEL" combination!
;
; Send Command Resulting Keypress
;
;	{!}			!
;	{#}			#
;	{+}			+
;	{^}			^
;	{{}			{
;	{}}			}
;	{SPACE}			SPACE
;	{ENTER}			ENTER
;	{ALT}			ALT
;	{BACKSPACE} or {BS}	BACKSPACE
;	{DELETE} or {DEL}	DELETE
;	{UP}			Cursor up
;	{DOWN}			Cursor down
;	{LEFT}			Cursor left
;	{RIGHT}			Cursor right
;	{HOME}			HOME
;	{END}			END
;	{ESCAPE} or {ESC}	ESCAPE
;	{INSERT} or {INS}	INS
;	{PGUP}			PGUP
;	{PGDN}			PGDN
;	{F1} - {F12}		Function keys
;	{TAB}			TAB
;	{PRINTSCREEN}		PRINTSCR
;	{LWIN}			Left Windows key
;	{RWIN}			Right Windows key
;	{NUMLOCK}		NUMLOCK
;	{CTRLBREAK}		Ctrl+break
;	{PAUSE}			PAUSE
;	{CAPSLOCK}		CAPSLOCK
;	{NUMPAD0} - {NUMPAD 9}	Numpad digits
;	{NUMPADMULT}		Numpad Multiply
;	{NUMPADADD}		Numpad Add
;	{NUMPADSUB}		Numpad Subtract
;	{NUMPADDIV}		Numpad Divide
;	{NUMPADDOT}		Numpad period
;	{APPSKEY}		Windows App key
;	{ALTDOWN}		Holds the ALT key down until {ALTUP} is sent
;	{SHIFTDOWN}		Holds the SHIFT key down until {SHIFTUP} is sent
;	{CTRLDOWN}		Holds the CTRL key down until {CTRLUP} is sent
;	{LWINDOWN}		Holds the left Windows key down until {LWINUP} is sent
;	{RWINDOWN}		Holds the right Windows key down until {RWINUP} is sent
;	{ASC nnnn}		Send the ALT+nnnn key combination
;
; To send the ASCII value A (same as pressing ALT+65 on the numeric keypad)
;	Send, {ASC 65}
;
; Single keys can also be repeated, e.g.
;	Send, {DEL 4}		Presses the DEL key 4 times
;	Send, {S 30}		Sends 30 'S' characters
;	Send, +{TAB 4}		Presses SHIFT+TAB 4 times
;
Send, <Series of key presses>^!
#T=SetBatchLines
; Usually, AutoIt executes each line of a script during a 10ms timer cycle (under NT is it 10ms,
; under 9x it could be a much larger time).
; This can mean that in scripts which do a lot of String/Variable processing, the scripts
; can be quite slow.  The SetBatchLines command can be used to change the number of script lines
; that are processed in a timer cycle.  The default is 1.  The maximum value is 32767.
; Note: For very high values, AutoIt will start to impact the available CPU time.
; The current value of SetBatchLines can be obtained from the special variable "A_NUMBATCHLINES".
;
; Note: Most users will not need to uses this command at all!
;
; e.g. To execute 100 scripts lines per cycle
; SetBatchLines, 100
;
SetBatchLines, <lines>^!
#T=SetEnv
; This command will set an environment variable to the specified value.
; N.B. This variable only exists within AutoIt you will not be able to access it from DOS.
;
; e.g. To set the Env variable "ERROR" to "There has been an error":
; SetEnv, ERROR, There has been an error.
;
; To use this variable, use the percent symbol:
;
; e.g. After running the previous command, this will output "There has been an error":
; MsgBox, 1, AutoIt, %ERROR%
;
SetEnv, <variable>, <value>^!
#T=SetKeyDelay
; Changes the delay between keystrokes in milliseconds.
; Max is 32767.
; Default is 20ms.
; 1000 milliseconds = 1 second.
;
SetKeyDelay, <milliseconds>^!
#T=SetTitleMatchMode
; Changes the way that window titles are matched against the script.
; Valid modes are "1" and "2" - the default is "1". This mode affects most of the commands
; within AutoIt that have any sort of window title and text in the command, i.e. WinWait,
; WinWaitActive, IfWinActive, etc.
;
; e.g.
; Script using mode 1 (default)
; SetTitleMatchMode, 1
;
; Script using mode 2
; SetTitleMatchMode, 2
;
; mode 1
; In the script you specify the start of a window title to match. i.e. for the notepad.exe window
; (Untitled - Notepad), valid matches would be:
; "Untitled", "Untitled -", "Unt" and "Untitled - Notepad".
;
; mode 2
; In the script you can specify ANY substring of the window title you want to match.
; Again for the notepad.exe window valid matches would be:
; "Untitled", "Untitled - Notepad", "Notepad", "No".
;
SetTitleMatchMode, <mode>^!
#T=SetWinDelay
; This changes the time that AutoIt pauses after carrying out a window related
; function (waiting for, minimizing, restoring, etc.) before continuing.  This is
; useful on very slow machines, or when you have things like window animation enabled.
; The default is 500 milliseconds.
;
; e.g.
; SetWinDelay, 2000
; Run, Notepad.exe
; WinWaitActive, Untitled - Notepad
; Send, Hello
;
; In this example there would be a pause of 2000 milliseconds (2 seconds) after notepad has
; started until the words "Hello" appear.
;
SetWinDelay, <Milliseconds>^!
#T=Shutdown
; This command allows you to perform various forms of shutdown.
; The type is determined by <Flag>.  The flag can be a combination from the table below:
;
;	Flag	Function
;	0	Log off the current user
;	1	Shutdown the workstation
;	2	Reboot the workstation
;	4	Force closing of applications (may lose unsaved work)
;	8	Shutdown and power off (if supported)
;
; e.g. To shutdown and force applications to close without saving = Shutdown + Force = 1 + 4 = 5:
; Shutdown, 5
;
Shutdown, <Flag>^!
#T=Sleep
; Halts execution of the script for the given number of milliseconds. Max is 2147483647.
; 1000 milliseconds = 1 second.
;
Sleep, <milliseconds>^!
#T=SplashTextOn
; This command brings up a window the specified message and title.
; The window stays topmost without interfering with windows behind it.
; Useful for automation when you can bring up a "Don't Touch" message for the user
; without affecting other windows.
;
SplashTextOn, <Width>, <Height>, <Title>, <Message>^!
#T=SplashTextOff
; Removes the splash text screen from view.
;
SplashTextOff
#T=StringCaseSense
; This command will turn case sensitivity on or off for the commands: IfEqual, IfNotEqual,
; IfInString, IfNotInString, StringReplace and StringGetPos.
;
; Default is off (i.e. comparisons are NOT case sensitive)
;
StringCaseSense, <On | Off>^!
#T=StringGetPos
; This command takes the contents of <Input Variable>, searches for the string <Search Text> and
; returns the position of the string in <Output Variable>.  If the search string is not
; found, %ERRORLEVEL% is set to 1, otherwise it is set to 0.  Position "0" is the first character.
;
; e.g. To get the position character of a string
; SetEnv, test, Hello this is a test string
; StringGetPos, output, test, this
; MsgBox, 0, AutoIt, The search string is at position %output%
;
; (The output would be "The search string is at position 6")
;
StringGetPos, <Output Variable> , <Input Variable>, <Search Text>^!
#T=StringLeft
; This command takes the contents of <Input Variable>, extracts a number of characters and places
; the result in <Output Variable>.
;
; e.g. To extract the leftmost 5 characters of a string
; SetEnv, test, Hello this is a test string
; StringLeft, output, test, 5
; MsgBox, 0, AutoIt, The resulting string is %output%
;
; (The output would be "Hello")
;
; e.g. To extract the rightmost 6 characters of a string
; SetEnv, test, Hello this is a test string
; StringRight, output, test, 6
; MsgBox, 0, AutoIt, The resulting string is %output%
;
; (The output would be "string")
;
StringLeft, <Output Variable> , <Input Variable>, <Number of chars to extract>^!
#T=StringRight
; This command takes the contents of <Input Variable>, extracts a number of characters and places
; the result in <Output Variable>.
;
; e.g. To extract the leftmost 5 characters of a string
; SetEnv, test, Hello this is a test string
; StringLeft, output, test, 5
; MsgBox, 0, AutoIt, The resulting string is %output%
;
; (The output would be "Hello")
;
; e.g. To extract the rightmost 6 characters of a string
; SetEnv, test, Hello this is a test string
; StringRight, output, test, 6
; MsgBox, 0, AutoIt, The resulting string is %output%
;
; (The output would be "string")
;
StringRight, <Output Variable> , <Input Variable>, <Number of chars to extract>^!
#T=StringMid
; This command takes the contents of <Input Variable>, extracts a number of characters starting
; from <Start char>  and places the result in <Output Variable>.
;
; e.g. To extract 4 characters starting from character 7
; SetEnv, test, Hello this is a test string
; StringMid, output, test, 7, 4
; MsgBox, 0, AutoIt, The resulting string is %output%
;
; (The output would be "this")
;
StringMid, <Output Variable> , <Input Variable>, <Start char>, <Number of chars to extract>^!
#T=StringLen
; This command takes the contents of <Input Variable> and puts the number of characters in
; the string into <Output Variable>.
; e.g.
; SetEnv, test, Hello this is a test string
; StringLen, output, test
; MsgBox, 0, AutoIt, The string length is %output%
;
; (The output would be "The string length is 27")
;
StringLen, <Output Variable> , <Input Variable>^!
#T=StringReplace
; This command will search for the <Search String> in the contents of the variable <Input Variable>.
; The search string will be replace by <Replace String> and the result will be placed in
; the variable <Output Variable>.  If the search string cannot be found, the contents of
; <Output Variable> will be the same as <Input Variable>.
;
; If a match was made, %ERRORLEVEL% will be set to 0.  Otherwise, %ERRORLEVEL% will be set to 1.
;
; e.g.
; SetEnv, teststring, Hello this is a test string
; StringReplace, output, teststring, test, testing testing 1 2 3
; MsgBox, 0, AutoIt, %output%
;
; (The output would be "Hello this is a testing testing 1 2 3 string")
;
StringReplace, <Output Variable> , <Input Variable>, <Search String>, <Replace String>^!
#T=StringTrimLeft
; This command takes the contents of <Input Variable>, trims a number of characters and places the
; result in <Output Variable>.
;
; e.g. To trim the leftmost 6 characters of a string
; SetEnv, test, Hello this is a test string
; StringTrimLeft, output, test, 6
; MsgBox, 0, AutoIt, The resulting string is %output%
;
; (The output would be "this is a test string")
;
; e.g. To trim the rightmost 7 characters of a string
; SetEnv, test, Hello this is a test string
; StringTrimRight, output, test, 7
; MsgBox, 0, AutoIt, The resulting string is %output%
;
; (The output would be "Hello this is a test")
;
StringTrimLeft, <Output Variable> , <Input Variable>, <Number of chars to trim>^!
#T=StringTrimRight
; This command takes the contents of <Input Variable>, trims a number of characters and places the
; result in <Output Variable>.
;
; e.g. To trim the leftmost 6 characters of a string
; SetEnv, test, Hello this is a test string
; StringTrimLeft, output, test, 6
; MsgBox, 0, AutoIt, The resulting string is %output%
;
; (The output would be "this is a test string")
;
; e.g. To trim the rightmost 7 characters of a string
; SetEnv, test, Hello this is a test string
; StringTrimRight, output, test, 7
; MsgBox, 0, AutoIt, The resulting string is %output%
;
; (The output would be "Hello this is a test")
;
StringTrimRight, <Output Variable> , <Input Variable>, <Number of chars to trim>^!
#T=WinActivate
; If the window exists, the relevant command (i.e. minimizing, hiding,
; activating, etc.) will be performed.
;
WinActivate, <Window Title> [,<Window Text>]^!
#T=WinClose
; If the window exists, the relevant command (i.e. minimizing, hiding,
; activating, etc.) will be performed.
;
WinClose, <Window Title> [,<Window Text>]^!
#T=WinGetActiveStats
; This command allows you to receive much information from the active window, including:
; Windows title, window width, window height, window x-position and window y-position.
;
; e.g.
; Sleep, 2000
; WinGetActiveStats, titlevar, widthvar, heightvar, xposvar, yposvar
; MsgBox, 0, AutoIt, Title=%titlevar% Width=%widthvar% Height=%heightvar% Position=%xposvar%,%yposvar%
;
WinGetActiveStats, <Title Var>, <Width Var>, <Height Var>, <Xpos Var>, <Ypos Var>^!
#T=WinGetActiveTitle
; This command gets the title of the active window and puts it in the DOS variable <Variable>
;
; e.g.
; Sleep, 2000
; WinGetActiveTitle, myvar
; MsgBox, 0, AutoIt, The active window was %myvar%
;
WinGetActiveTitle, <Variable>^!
#T=WinKill
; Similar to WinClose, but if the window has not closed after a couple of seconds
; (Asking to save, crashed, etc.) the window will be forcibly terminated.
;
WinKill, <Window Title> [,<Window Text>]^!
#T=WinSetTitle
; Use this command to rename a window.
;
; e.g.
; Run, notepad.exe
; WinWaitActive, Untitled - Notepad
; WinSetTitle, Untitled - Notepad,, Renamed Notepad!
;
WinSetTitle, <Window Title>, [Window Text], <New Title>^!
#T=WinHide
; If the window exists, the relevant command (i.e. minimizing, hiding,
; activating, etc.) will be performed.
;
WinHide, <Window Title> [,<Window Text>]^!
#T=WinShow
; If the window exists, the relevant command (i.e. minimizing, hiding,
; activating, etc.) will be performed.
;
WinShow, <Window Title> [,<Window Text>]^!
#T=WinMove
; If the window in Title and Text exists, it is moved to <X>, <Y> and resized to <Width>, <Height>
;
; e.g.
; Run, notepad.exe
; WinWaitActive, Untitled - Notepad
; WinMove, Untitled - Notepad,, 0, 0, 100, 100
;
; This moves the notepad window to 0,0 and changes the size of the window to 100,100
;
; Remember to include the comma if you don't specify Window text.  "default" can be used in place of
; Width and Height if you don't want to change the size of the window
;
; e.g.
; WinMove, Untitled - Notepad,, 0, 0, default, default
;
WinMove, <Window Title>, [<Window Text>], <X>, <Y>, <Width>, <Height>^!
#T=WinMaximize
; If the window exists, the relevant command (i.e. minimizing, hiding,
; activating, etc.) will be performed.
;
WinMaximize, <Window Title> [,<Window Text>]^!
#T=WinMinimize
; If the window exists, the relevant command (i.e. minimizing, hiding,
; activating, etc.) will be performed.
;
WinMinimize, <Window Title> [,<Window Text>]^!
#T=WinMinimizeAll
; The "WinMinimizeAll" command minimizes all windows;
; "WinMinimizeAllUndo" will undo this action.
; If any windows are manipulated by AutoIt or the user, then "WinMinimizeAllUndo" will not have any
; effect on these "touched" windows.
;
WinMinimizeAll
#T=WinMinimizeAllUndo
; The "WinMinimizeAll" command minimizes all windows;
; "WinMinimizeAllUndo" will undo this action.
; If any windows are manipulated by AutoIt or the user, then "WinMinimizeAllUndo" will not have any
; effect on these "touched" windows.
;
WinMinimizeAllUndo
#T=WinRestore
; If the window exists, the relevant command (i.e. minimizing, hiding,
; activating, etc.) will be performed.
;
WinRestore, <Window Title> [,<Window Text>]^!
#T=WinWait
; Stops script execution until the specified window exists. The window does not need be active.
; If specified the "Timeout" is in seconds.  After the line has executed the Env
; variable %ERRORLEVEL% will be set to 0 if the function completed normally, or 1 if the wait timed out.
; The maximum value of Timeout is 32767 seconds.
;
; e.g.  Wait forever for the notepad window
; WinWait, Untitled - Notepad
;
; e.g.  Wait for five seconds for the notepad window
; WinWait, Untitled - Notepad,, 5
;
WinWait, <Window Title> [,<Window Text> [,<Timeout>]]^!
#T=WinWaitActive
; Stops script execution until the specified window to exists and is active.
; If specified the "Timeout" is in seconds.  After the line has executed the Env
; variable %ERRORLEVEL% will be set to 0 if the function completed normally,
; or 1 if the wait timed out.
;
WinWaitActive, <Window Title> [,<Window Text> [,<Timeout>]]^!
#T=WinWaitNotActive
; Stops script execution until the specified window ceases to be active.
; If specified the "Timeout" is in seconds.  After the line has executed the Env
; variable %ERRORLEVEL% will be set to 0 if the function completed normally, or 1 if the wait timed out.
;
WinWaitNotActive, <Window Title> [,<Window Text> [,<Timeout>]]^!
#T=WinWaitClose
; Stops script execution until the specified window ceases to exist.
; If specified the "Timeout" is in seconds.  After the line has executed the Env
; variable %ERRORLEVEL% will be set to 0 if the function completed normally, or 1 if the wait timed out.
;
; e.g.
; WinWaitClose, Untitled - Notepad
;
WinWaitClose, <Window Title> [,<Window Text> [,<Timeout>]]^!
#