/* 
 * Bhrama Client-Server Interface 0.3
 * (c)1999 CindyG
 *
 * bhrama.h : client side bhrama interface
 */

#ifndef _BHRAMA_H_
#define _BHRAMA_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Bhrama Options */
#define BHRAMA_PREDUMP_AUTODUMP		0x00000001	/* use internal predump */
#define	BHRAMA_TRACE_RANGECHECK		0x00000002	/* ignore faults */
#define	BHRAMA_TRACE_AUTOEIP		0x00000004	/* EIP confirmation */
#define	BHRAMA_TRACE_AUTOLAYER		0x00000008	/* multiple layer confirmation */
#define	BHRAMA_TRACE_TRACEAPI		0x00000010	/* trace API */
#define	BHRAMA_RESTORE_AUTOOBJ		0x00000020	/* rebuild object size */
#define	BHRAMA_RESTORE_SHRINKPE		0x00000040	/* optimize pe structure */
#define	BHRAMA_RESTORE_RELOC		0x00000080	/* rebuild relocations */
#define	BHRAMA_RESTORE_HEADER		0x00000100	/* rebuild header */
#define	BHRAMA_LOADER_RAWMODE		0x00000200	/* force raw mode */
#define	BHRAMA_LOADER_MERGECODE		0x00000400	/* merge code into an unique section */
#define	BHRAMA_LOADER_CHECKHEADER	0x00000800	/* check header sections */
#define	BHRAMA_MISC_SHOWDISASM		0x00001000	/* not implemented yet */

#define BHRAMA_OPT_DEFAULT	  \
	BHRAMA_PREDUMP_AUTODUMP | \
	BHRAMA_RESTORE_AUTOOBJ  | \
	BHRAMA_RESTORE_SHRINKPE 

/* Bhrama import rebuilder */
#define BHRAMA_IMPORT_SKIP			0			/* don't rebuild import */
#define BHRAMA_IMPORT_USE			1			/* use actual import info */
#define BHRAMA_IMPORT_REBUILD		2			/* rebuild import table */
#define BHRAMA_IMPORT_NEW			3			/* rebuild new import table */

/* Prototypes */
BOOL bhrama_query(DWORD pid);
BOOL bhrama_dump(DWORD pid, DWORD eip, DWORD delay, DWORD import, DWORD options);
BOOL bhrama_dumppart(DWORD pid, DWORD start, DWORD length);

#ifdef __cplusplus
};
#endif
#endif /* _BHRAMA_H_ */