/* Declarations of functions only visible to Xconq kernel.
   Copyright (C) 1996-1999 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

extern int move_unit(Unit *unit, int nx, int ny);
extern int maybe_react_to_move(Unit *unit, int ox, int oy);
extern void consume_move_supplies(Unit *unit);

#undef  DEF_ACTION
#define DEF_ACTION(name,code,args,PREPFN,netprepfn,dofn,checkfn,ARGDECL,doc)  \
  extern int PREPFN ARGDECL;

#include "action.def"

#undef  DEF_TASK
#define DEF_TASK(name,code,argtypes,dofn,CREATEFN,SETFN,netsetfn,PUSHFN,netpushfn,ARGDECL)  \
  extern void SETFN ARGDECL;  \
  extern void PUSHFN ARGDECL;

#include "task.def"

extern void finish_turn(Side *side);
extern void resign_game(Side *side, Side *side2);
extern void change_people_side_around(int x, int y, int u, Side *side);
extern void change_control_side_around(int x, int y, int u, Side *side);
extern void maybe_starve(Unit *unit, int partial);

extern void set_side_ai(Side *side, char *typename);

extern int change_cell(Unit *unit, int x, int y);
extern void rescue_occupants(Unit *unit);
extern void wreck_unit(Unit *unit);
extern void maybe_track(Unit *unit);
extern void maybe_lose_track(Unit *unit, int nx, int ny);

extern void notify_tech(Side *side, int u, int oldtech, int newtech);
extern void notify_tp(Side *side, Unit *unit, int u2, int oldtp, int newtp);
extern void reckon_damage_around(int x, int y, int r);
extern void damage_unit(Unit *unit, enum damage_reasons reason, Unit *agent);
extern void capture_unit(Unit *unit, Unit *pris, int captype);
extern int detonate_unit(Unit *unit, int x, int y, int z);
extern void damage_terrain(int u, int x, int y);
extern int damaged_terrain_type(int t);

extern void set_side_name(Side *side, Side *side2, char *newname);
extern void set_side_longname(Side *side, Side *side2, char *newname);
extern void set_side_shortname(Side *side, Side *side2, char *newname);
extern void set_side_noun(Side *side, Side *side2, char *newname);
extern void set_side_pluralnoun(Side *side, Side *side2, char *newname);
extern void set_side_adjective(Side *side, Side *side2, char *newname);
extern void set_side_emblemname(Side *side, Side *side2, char *newname);
extern void set_side_colorscheme(Side *side, Side *side2, char *newname);
extern void become_designer(Side *side);
extern void become_nondesigner(Side *side);
extern void set_trust(Side *side, Side *side2, int val);
extern void set_mutual_trust(Side *side, Side *side2, int val);
extern void set_autofinish(Side *side, int value);
extern void set_autoresearch(Side *side, int value);
extern void set_willing_to_save(Side *side, int flag);
extern void set_willing_to_draw(Side *side, int flag);
extern void send_message(Side *side, SideMask sidemask, char *str);
extern void set_side_self_unit(Side *side, struct a_unit *unit);
extern void set_doctrine(Side *side, char *spec);
extern void set_controlled_by(Side *side, Side *side2, int val);
extern void set_side_research(Side *side, int a);

#ifdef DESIGNERS
extern void paint_view(Side *side, int x, int y, int r, int tview, int uview);
#endif /* DESIGNERS */

extern void change_unit_side(Unit *unit, Side *newside, int reason,
			     Unit *agent);
extern int set_unit_side(Unit *unit, Side *side);
extern int set_unit_origside(Unit *unit, Side *side);
extern void set_unit_plan_type(Side *side, Unit *unit, int type);
extern void set_unit_asleep(Side *side, Unit *unit, int flag, int recurse);
extern void set_unit_reserve(Side *side, Unit *unit, int flag, int recurse);
extern void set_unit_ai_control(Side *side, Unit *unit, int flag, int recurse);
extern void set_unit_main_goal(Side *side, Unit *unit, Goal *goal);
extern void set_unit_curadvance(Side *side, Unit *unit, int a);
extern void set_unit_autoplan(Side *side, Unit *unit, int flag);
extern void set_unit_autoresearch(Side *side, Unit *unit, int flag);
extern void set_unit_autobuild(Side *side, Unit *unit, int flag);
extern void set_unit_waiting_for_transport(Side *side, Unit *unit, int flag);
extern void set_unit_name(Side *side, Unit *unit, char *newname);
extern int disband_unit(Side *side, Unit *unit);
extern void kill_unit(Unit *unit, int reason);
extern void kill_unit_aux(Unit *unit, int reason);
extern void set_unit_position(Unit *unit, int x, int y, int z);
extern void change_morale(Unit *unit, int sign, int morchange);

#ifdef DESIGNERS
extern Unit *designer_create_unit(Side *side, int u, int s, int x, int y);
extern int designer_teleport(Unit *unit, int x, int y, Unit *other);
extern int designer_change_side(Unit *unit, Side *side);
extern int designer_disband(Unit *unit);
#endif /* DESIGNERS */

extern void wake_unit(Side *side, Unit *unit, int wakeoccs);
extern void wake_area(Side *side, int x, int y, int n, int occs);
extern void set_formation(Unit *unit, Unit *leader, int x, int y,
			  int dist, int flex);
extern void delay_unit(Unit *unit, int flag);
extern int clear_task_agenda(Plan *plan);
extern void force_replan(Side *side, Unit *unit, int passive_only);

extern int execute_plan(Unit *unit);
extern int resupply_if_low(Unit *unit);
extern int rearm_if_low(Unit *unit);
extern int do_for_occupants(Unit *unit);
extern int go_after_victim(Unit *unit, int range);
extern int fire_at_opportunity(Unit *unit);
extern int explore_reachable_cell(Unit *unit, int range);
extern int capture_useful_if_nearby(Unit *unit);
extern int capture_indep_if_nearby(Unit *unit);
extern void random_walk(Unit *unit);
extern int go_after_captive(Unit *unit, int range);
extern TaskOutcome execute_task(Unit *unit);
extern void pop_task(Plan *plan);
extern void add_task(Unit *unit, int pos, Task *task);

extern Feature *create_feature(char *typename, char *name);
extern void set_feature_type_name(Feature *feature, char *typename);
extern void set_feature_name(Feature *feature, char *name);
extern void destroy_feature(Feature *feature);
extern void renumber_features(void);

#ifdef DESIGNERS
extern void paint_cell(Side *side, int x, int y, int r, int t);
extern void paint_border(Side *side, int x, int y, int dir, int t, int mode);
extern void paint_connection(Side *side, int x, int y, int dir, int t,
			     int mode);
extern void paint_coating(Side *side, int x, int y, int r, int t, int depth);
extern void paint_people(Side *side, int x, int y, int r, int s);
extern void paint_control(Side *side, int x, int y, int r, int s);
extern void paint_feature(Side *side, int x, int y, int r, int f);
extern void paint_elevation(Side *side, int x, int y, int r, int elev);
extern void paint_temperature(Side *side, int x, int y, int r, int temp);
extern void paint_material(Side *side, int x, int y, int r, int m, int amt);
extern void paint_clouds(Side *side, int x, int y, int r,
			 int cloudtype, int bot, int hgt);
extern void paint_winds(Side *side, int x, int y, int r,
			int dir, int force);
#endif /* DESIGNERS */

extern void request_additional_side(char *playerspec);
