/* The main program of the X11 interface to Xconq.
   Copyright (C) 1987-1989, 1991-1999 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

#include "conq.h"
#include "kpublic.h"
#include "cmdline.h"
extern char *args_used;
extern char *default_player_spec;

extern int launch_game(void);
extern void launch_game_2(void);

#include "tcltk/tkconq.h"
extern int use_clip_mask;
extern int use_stdio;

#include <unistd.h>

extern void host_the_game(char *option);
extern void try_join_game(char *hostport);
extern void init_all_displays(void);

/* Local function declarations. */

void init_x_signal_handlers(void);
static int handle_x_error(Display *dpy, XErrorEvent *evt);
static int handle_xio_error(Display *dpy);

/* The main program. */

int
main(int argc, char *argv[])
{
    extern uid_t games_uid;

    use_stdio = TRUE;
    /* Dummy reference to get libraries pulled in */
    if (argc == -1)
      cmd_error(NULL, NULL);
    /* Shift to being the user that started the game. */
    games_uid = geteuid();
    setuid(getuid());
    init_library_path(NULL);
    /* Fiddle with game module structures. */
    clear_game_modules();
#ifdef DEBUGGING
    init_debug_to_stdout();
#endif /* DEBUGGING */
    /* Set up empty data structures. */
    init_data_structures();

    if (argc > 1) {
	/* We're probably typing in a command line, use stdout. */
	printf("\n              Welcome to X11 Xconq version %s\n\n",
	       version_string());
	printf("%s", license_string());
	print_any_news();
    } else {
	/* Total GUI-ness this way. */
	option_popup_new_game_dialog = TRUE;
    }

    parse_command_line(argc, argv, general_options);

    initial_ui_init();

    /* If we're getting a startup dialog sequence, do it instead. */
    if (option_popup_new_game_dialog) {
	popup_game_dialog();
    } else {
	if (option_game_to_join != NULL) {
	    parse_command_line(argc, argv, variant_options);
	    set_variants_from_options();
	    parse_command_line(argc, argv, player_options);
	    set_players_from_options();
	    /* Go through once more and complain about anything not used. */
	    parse_command_line(argc, argv, leftover_options);
	    try_join_game(option_game_to_join);
	} else {
	    load_all_modules();
	    check_game_validity();
	    parse_command_line(argc, argv, variant_options);
	    set_variants_from_options();
	    parse_command_line(argc, argv, player_options);
	    set_players_from_options();
	    make_trial_assignments();
	    /* Complain about anything that's left. */
	    parse_command_line(argc, argv, leftover_options);
	    /* (still need to merge some databases derived from display) */
	    if (option_game_to_host != NULL) {
		host_the_game(option_game_to_host);
	    }
	    launch_game();
	}
	launch_game_2();
	print_instructions();
    }
    /* At this point we know we can use popups. */
    use_stdio = FALSE;
    /* Go into the main play loop. */
    ui_mainloop();

    /* Humor the compiler. */
    return 0;
}

/* The default (human) player is the current user on the current display. */

Player *
add_default_player(void)
{
    Player *player = add_player();
    
    player->name = getenv("USER");
    player->configname = getenv("XCONQCONFIG");
    player->displayname = getenv("DISPLAY");
    return player;
}

void
init_x_signal_handlers(void)
{
    XSetErrorHandler(handle_x_error);
    XSetIOErrorHandler(handle_xio_error);
}

/* Handlers for X catastrophes attempt to do a save first. */

static int
handle_x_error (Display *dpy, XErrorEvent *evt)
{
    static int num_errors = 0;
    char buf[BUFSIZE];

    XGetErrorText(dpy, evt->error_code, buf, BUFSIZE);
    fprintf(stderr, "\nX error on display %s: %s\n", DisplayString(dpy), buf);
    if (++num_errors >= 10) {
        printf("\nX error: trying emergency save!\n");
	/* Note that if the save fails too, we're totally hosed. */
	/* (should use configurable name here) */
        write_entire_game_state("ack!.xconq");
	abort();
    }
    return 0;
}

static int
handle_xio_error (Display *dpy)
{
    fprintf(stderr, "\nX IO error on display %s: trying emergency save!\n",
	   DisplayString(dpy));
    write_entire_game_state("ack!.xconq");
    abort();
    return 0;
}
