(game-module "ww2-div-eur"
  (title "WWII, Division-level, Europe")
  (blurb "base module for division-level WWII in Europe")
  (variants
   (world-seen true)
   (see-all true)
   ("Keep Score" keep-score (true (scorekeeper (do last-side-wins))))
   )
  )

(unit-type a-inf (name "infantry(a)") (image-name "inf-div")
  (help "Allied infantry division"))
(unit-type a-armor (name "armor(a)") (image-name "armor-div")
  (help "Allied armored division"))
(unit-type a-para (name "paratroops(a)") (image-name "para-div")
  (help "Allied paratroop division"))

(define a-ground-types (a-inf a-armor a-para))

(add a-ground-types possible-sides "allies")

(add a-ground-types acp-per-turn (3 6 3))

(unit-type g-inf (name "infantry(g)") (image-name "inf-div")
  (help "German infantry division"))
(unit-type g-armor (name "armor(g)") (image-name "armor-div")
  (help "German Panzer division"))
(unit-type g-para (name "paratroops(g)") (image-name "para-div")
  (help "German paratroop division"))
(unit-type pzgren (name "panzergrenadiers") (image-name "pzgren-div")
  (help "German panzergrenadier division"))
(unit-type metro (image-name "metro-div")
  (help "German metropolitan defense division"))
(unit-type cd (name "coastal defense") (image-name "inf-div")
  (help "German coastal defense division"))

(define g-ground-types (g-inf g-armor g-para pzgren metro cd))

(add g-ground-types possible-sides "axis")

(add g-ground-types acp-per-turn (3 5 3 3 3 2))

(unit-type hq (image-name "army-hq")
  (help "Army HQ, one needed for every 16 divisions"))

(add hq acp-per-turn 6)

(define ground-types (append a-ground-types g-ground-types hq))

(define non-mot-types (a-inf g-inf))

(define mot-types (a-armor g-armor))

(unit-type train
  (help "rail transport"))

;; should have assault craft distinct from transports.
(unit-type transport (image-name "ap")
  )
(unit-type battleship (image-name "bb")
  )

(define ship-types (transport battleship))

(unit-type bomber (image-name "4e")
  )

(unit-type airbase
  )
(unit-type v2-base (image-name "v2")
  (help "V-2 rocket base"))
(unit-type port (image-name "anchor")
  )
(unit-type coast-defense (image-name "walltown")
  )
(unit-type town (image-name "town20")
  )

(define place-types (airbase v2-base port coast-defense town))

(material-type org
  (help "organization - important to do things, acquired from HQs"))
(material-type missile
  (help "what the V-2 bases shoot with"))

; sea clr brkn/bocage rough/hills mtn urb estuary road rail river rhine

(terrain-type sea (char ".")
  (help "the high seas, and coastal waters"))
(terrain-type swamp (char "=")
  (help "soggy and overgrown terrain, difficult for vehicles"))
(terrain-type clear (image-name "plains") (char "+")
  )
(terrain-type broken (image-name "bocage") (char "%")
  )
(terrain-type hills (image-name "forest") (char "^")
  )
(terrain-type mountains (char "/")
  )
(terrain-type urban (char "#")
  )
(terrain-type estuary (image-name "shallows")
  )
(terrain-type river
  (subtype border) (subtype-x river-x)
  )
(terrain-type Rhine-river (image-name "river")
  (subtype border)
  )
(terrain-type beach
  (subtype border) (subtype-x river-x)
  )
(terrain-type road
  (subtype connection) (subtype-x road-x)
  )
(terrain-type railroad
  (subtype connection) (subtype-x road-x)
  (help "where trains can go"))

(define water-t* (sea estuary))

(define land-t* (swamp clear broken hills mountains urban))

(define cell-t* (sea swamp clear broken hills mountains urban estuary))

(add water-t* liquid true)

;;; Static relationships.

(table vanishes-on
  (ground-types water-t* true)
  (ship-types land-t* true)
  (place-types water-t* true)
  )

;; Unit-in-terrain capacities.

(add t* capacity 3)

;; Unit-in-unit capacities.

(table unit-size-as-occupant
  (u* u* 99)
  (ground-types (transport town) 1)
  ;; Trains can carry one unit each.
  (ground-types train 1)
  (train town 1)
  )

(add transport capacity 4)
(add train capacity 1)
(add town capacity 6)

(table unit-capacity-x
  (port ship-types (6 2))
  (airbase bomber 2)
  )

(table unit-storage-x
  (ground-types org 4)
  (hq org 20)
  (v2-base missile 50)
  )

;;; Vision.

;;; Static units can't do anything without the world's reporters finding
;;; out within the week - except for V-2 bases.

(add place-types see-always true)
(add v2-base see-always false)

;;; Actions.

;; (ground-types acp already defined)
(add ship-types acp-per-turn 14) ; 28 would be better
(add train acp-per-turn 28)
(add bomber acp-per-turn 7)
(add place-types acp-per-turn 0)
(add v2-base acp-per-turn 7) ; for missile attacks

(table material-to-act
  (ground-types org 1)
  )

;;; Movement.

(add ship-types speed 70.00)
(add place-types speed 0)
(add bomber speed 0)

(table mp-to-enter-terrain
  (mot-types hills 2)
  (ground-types mountains 2)
  (mot-types mountains 4)
  (hq mountains 1)
  (ground-types river 2)
  (ground-types Rhine-river 3)
  (ground-types water-t* 9999)
  ;; Trains can only move on railroads.
  (train t* 9999)
  (train railroad 0)
  (ship-types land-t* 9999)
  )

(table mp-to-leave-terrain
  ;; Trains can only move on railroads.
  (train t* 9999)
  (train railroad 0)
  )

(table mp-to-traverse
  (ground-types road 1)
  (train railroad 1)
  )

;; Zones of control.

(table zoc-range
  ;; Ground units can constrain the movement of adjacent ground units.
  (ground-types ground-types 1)
  ;; Except for HQs, which are wimpy combatwise.
  (hq u* 0)
  ;; Ground types can also control estuaries.
  (ground-types ship-types 1)
  )

(table zoc-into-terrain
  (ground-types t* false)
  (ground-types land-t* true)
  (ground-types estuary true)
  )

(table mp-to-enter-zoc
  (ground-types ground-types 7)
  (ship-types ground-types 980)
  )

(table mp-to-traverse-zoc
  (ship-types ground-types 980)
  )

(table mp-to-leave-zoc
  (ship-types ground-types 980)
  )

;;; Repair.

(add u* hp-recovery 0.50)

;;; (should have towns repair units also, but would need to be able to act then!)
;;; (could say nonzero acp-to-xxx with zero acp-max means auto-actions)

;;; Combat.

(add ground-types hp-max 12)
(add ship-types hp-max 24)
(add bomber hp-max 12)
(add place-types hp-max 48)

(table acp-to-attack
  (u* u* 1)
  ;; Metro divisions are purely defensive.
  (metro u* 0)
  ;; Similarly for HQ units.
  (hq u* 0)
  ;; Transportation types can't actually attack anything.
  (transport u* 0)
  (train u* 0)
  ;; V-2 bases can only fire missiles.
  (v2-base u* 0)
  )

(table hit-chance
  (u* u* 50)
  (a-inf u* 60)
  (a-armor u* 40)
  (a-para u* 50)
  (g-inf u* 40)
  (g-armor u* 40)
  (g-para u* 70)
  (pzgren u* 60)
  (cd u* 30)
  ;; HQs are not for combat.
  (hq u* 0)
  ;; Transport combat is non-existent at this scale.
  (u* transport 0)
  (transport u* 0)
  ;; Battleships are very good at shelling everything.
  (battleship u* 90)
  ;; ...but not so good with each other.
  (battleship battleship 50)
  ;; Might accidentally destroy what we're trying to capture.
  (u* train 10)
  ;; Bombers can't hit V-2 bases, they're too small and mobile.
  (bomber v2-base 0)
  ;; V-2 bases can only hit stationary targets.
  (v2-base u* 0)
  (v2-base place-types 50)
  )

(table damage
  (u* u* 2d4)
  (hq u* 0)
  (u* transport 0)
  (transport u* 0)
  (u* train 1)
  ;; V-2 bases can only hit stationary targets.
  (v2-base u* 0)
  (v2-base place-types 2d4)
  )

(table hp-min
  ;; Towns can never be totally destroyed.
  (u* town 1)
  ;; Bombers are not capable of destroying ground units.
  (bomber ground-types 6)
  ;; Neither are ships.
  (ship-types ground-types 6)
  )

(table withdraw-chance-per-attack
  ;; HQs are supposed to preserve themselves.
  (u* hq 90)
  )

;; Battleships can reach inland a little ways.

(add battleship acp-to-fire 1)
(add battleship range 2)

;; Aircraft give towns and bases a long reach.

(add bomber acp-to-fire 1)

(add v2-base acp-to-fire 1)

;; Bombers can reach pretty much everywhere.

(add bomber range 60)

;; Nominally, the V-2's range was 200 miles, but be generous.

(add v2-base range 24)

(table consumption-per-attack
  (v2-base missile 1)
  )

(table hit-by
  (u* missile 1)
  )

(table capture-chance
  ;; Trains are easily captured, but might be able to escape sometimes.
  (ground-types train 80)
  ;; Towns don't usually have much integral defense.
  (ground-types place-types 90)
  )

;; (units in towns and trains should be able to help defend)

;;; Backdrop.

(table base-production
  (hq org 16)
  (v2-base missile 2)
  )

(table base-consumption
  (ground-types org 1)
  ;; HQ is automatically organized.
  (hq org 0)
  )

(table out-length
  (hq org 10)
  )

(table in-length
  (ground-types org 10)
  )

;;; Definitions used for testing.

;;; Some defns for the fractal percentile generator.

(set alt-blob-density 10000)
(set alt-blob-size 20)
(set alt-smoothing 6)
(set wet-blob-density 2000)
(set wet-blob-size 100)

; sea low clr brkn rough mtn urb

(add cell-t* alt-percentile-min (  0  30  30  30  70  90  30   0))
(add cell-t* alt-percentile-max ( 30  35  70  70  90 100  70   0))
(add cell-t* wet-percentile-min (  0  50   0  50   0   0  45   0))
(add cell-t* wet-percentile-max (100 100  45 100 100 100  50   0))

;;; River generation.

(add (clear hills mountains) river-chance (2.00 2.00 4.00))

(set river-sink-terrain sea)

;;; Road generation.

(table road-chance
  (town town 100)
  (town (port airbase) 100)
  )

(table road-into-chance
  (land-t* land-t* 100)
  )

(set country-radius-min 6)

(add (sea clear) country-terrain-min (5 5))

(add u* start-with 1)  ; one of everything

(table favored-terrain
  (u* t* 100)
  (u* (sea swamp) 0)
  (ship-types sea 100)
  (ship-types land-t* 0)
  )

(table unit-initial-supply
  ;; Everybody starts out optimistic and efficient.
  (ground-types org 999)
  ;; V-2 bases first became operational 6 Sep 1944, so start them out
  ;; empty.
  (v2-base missile 0)
  )

;;; No political detailing needed at the divisional level.

(set side-library '(
  ((name "Allies") (adjective "Allied") (class "allies")
   (emblem-name "white-star"))
  ((name "Axis") (adjective "Axis") (class "axis")
   (emblem-name "german-cross"))
  ))

(world 2500 (year-length 52))

(set calendar '(usual week))

(game-module (design-notes (
  "The map scale is 10 miles/hex, game time is 1 week/turn."
  ""
  "This game design covers division-level operations in Europe during WWII."
  "Players take on the roles of army commanders but not political leaders;"
  "the game does not include political factors."
  )))

#|

Parachutists have restrictions on initial placement (why?), won't
drop further than 10 hexes from friendlies (even on invasion?)
(use control radius to impl)

Can build fortresses (very slowly), units can be inside or outside.

Admin movement should also use trucks.

All units have medium prob to surrender - use ZOC to calculate.

|#
