set showcolor 1
set shownames 1
set showmasks 1

wm title . imftk

frame .menubar
pack .menubar -fill x

menubutton .menubar.file -text File -menu .menubar.file.m
pack .menubar.file -side left
set filemenu [menu .menubar.file.m]
$filemenu add command -label New -command { new_images }
$filemenu add command -label "Open Imf Dir..."
$filemenu add command -label "Add Imf File..." -command { add_imf_file }
$filemenu add command -label "Save Imf Dir..."
$filemenu add command -label "Save Imf File..."
$filemenu add command -label Quit -command { exit }

menubutton .menubar.view -text View -menu .menubar.view.m
pack .menubar.view -side left
set viewmenu [menu .menubar.view.m]
$viewmenu add command -label 8x8 \
	-command { .images.content config -mag 8 }
$viewmenu add command -label 16x16 \
	-command { .images.content config -mag 16 }
$viewmenu add command -label 32x32 \
	-command { .images.content config -mag 32 }
$viewmenu add command -label 64x64 \
	-command { .images.content config -mag 64 }
$viewmenu add separator
$viewmenu add check -label Color -variable showcolor \
	-command toggle_show_color
$viewmenu add check -label Names -variable shownames \
	-command toggle_show_names
$viewmenu add check -label Masks -variable showmasks \
	-command toggle_show_masks

label .menubar.count -text [get_imf_status]
pack .menubar.count -side right

frame .closeup -borderwidth 2 -relief sunken
pack .closeup -side top -fill x

canvas .closeup.content -height 80
pack .closeup.content

.closeup.content create text 100 10 -text "(nothing_selected)" -tag selname

frame .images

imflist .images.content
.images.content config -showcolor $showcolor
.images.content config -showcolor $showcolor -showmasks $showmasks

scrollbar .images.scroll -command { .images.content yview }
# -side right -fill y
pack .images.scroll -side right -fill y
pack .images.content -side left -fill both -expand true
pack .images -side top -fill both -expand true

bind .images.content <ButtonRelease-1> { select_imf %x %y }

proc new_images {} {
}

proc open_imf_dir {} {
}

proc add_imf_file {} {
    set filename [get_string ".imf file to add"]
    if { $filename != {} } {
	load_imf_file $filename
	.menubar.count config -text [get_imf_status]
    }
}

proc save_imf_dir {} {
}

proc save_imf_file {} {
}

proc toggle_show_color {} {
    global showcolor

    .images.content config -showcolor $showcolor
}

proc toggle_show_names {} {
    global shownames

    .images.content config -shownames $shownames
}

proc toggle_show_masks {} {
    global showmasks

    .images.content config -showmasks $showmasks
}

proc select_imf { x y } {
    .images.content select $x $y
    set n [.images.content curselection]
    .closeup.content itemconfigure selname -text [get_imf_details $n]

}

proc get_string { hint } {
    global prompt

    set f [toplevel .getstring -bd 10]
    label $f.label -text $hint
    entry $f.entry -textvariable prompt(result)
    set b [frame $f.buttons -bd 10]
    pack $f.label $f.entry $f.buttons -side top -fill x
    button $b.ok -text "OK" -command { set prompt(ok) 1 }
    button $b.cancel -text "Cancel" -command { set prompt(ok) 0 }
    pack $b.ok -side left
    pack $b.cancel -side right

    focus $f.entry
    grab $f
    tkwait variable prompt(ok)
    grab release $f
    destroy $f
    if { $prompt(ok) } {
	return $prompt(result)
    } else {
	return {}
    }
}