/* Definitions for the tcl/tk interface to Xconq.
   Copyright (C) 1998 Stanley T. Shebs.

Xconq is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.  See the file COPYING.  */

#include <tcl.h>
#include <tk.h>

#include <math.h>

#include "imf.h"
#include "ui.h"

#include "tkimf.h"

#ifndef IMFLIB
#ifdef VMS
#define IMFLIB "[-.lib-x11]"
#else /* not VMS */
#define IMFLIB "../lib-x11"
#endif /* VMS */
#endif /* IMFLIB */

/* Every map has a mode that governs the interpretation of input (mainly
   mouse input) activity for that map. */

enum mapmode {
  survey_mode,
  move_mode,
  fire_mode,
  build_mode,
#ifdef DESIGNERS
  cell_paint_mode,
  bord_paint_mode,
  conn_paint_mode,
  coat_paint_mode,
  unit_paint_mode,
  people_paint_mode,
  control_paint_mode,
  feature_paint_mode,
  material_paint_mode,
  elevation_paint_mode,
  temperature_paint_mode,
  clouds_paint_mode,
  winds_paint_mode,
  view_paint_mode,
#endif /* DESIGNERS */
  nummodes
};

/* Drawing techniques that may be used. */

enum whattouse {
  dontdraw,
  useblocks,
  usepictures,
  usepolygons
};

enum grayshade {
  black,
  gray,
  darkgray,
  numgrays
};

enum movie_type {
  movie_null,
  movie_miss,
  movie_hit,
  movie_death,
  movie_nuke,
  movie_sound,
  movie_flash
};

struct a_movie {
  char *type;
  enum movie_type itype;
  int args[5];
};

/* The user interface substructure.  This is only allocated for sides with
   attached displays. */

typedef struct a_ui {
    int active;			/* True when the display is usable */

    Display *dpy;		/* The X display used by this side */
    int screen;			/* The X screen in use */

    short bonw;			/* true if display is black-on-white */
    int sxdown, sydown;
    int	cellx, celly;
    int cellxy_ok;		/* cellx & celly valid? */
    int beepcount;		/* number of times we've been beeped */
    /* Constructed during display init. */
    short monochrome;		/* obvious */
    short fw, fh;		/* dimensions of text font (in pixels) */
    /* Working variables for the display. */
    XColor *bgcolor;		/* background color */
    XColor *fgcolor;		/* foreground (text) color */
    XColor *whitecolor;		/* actual white for this display */
    XColor *blackcolor;		/* actual black for this display */
    XColor *graycolor;		/* color for graying out (usually gray) */
    XColor *diffcolor;		/* unusual/distinct color (usually maroon) */
    XColor *badcolor;		/* color for non-OKness (usually red) */
    XColor *grid_color;
    XColor *unseen_color;
    XColor *contour_color;
    XColor *country_border_color;
    XColor *feature_color;
    XColor *frontline_color;
    XColor *meridian_color;
    XColor *shoreline_color;
    XColor *unit_name_color;
    XColor *cellcolor[MAXTTYPES];	/* the color of each terrain type */
    XColor *cellfgcolor[MAXTTYPES]; /* the "fg" color of each terrain type */
    XColor *colors[MAXSIDES][3];
    int numcolors[MAXSIDES];
    XColor **unitcolors;
    XColor **numunitcolors;
    short dflt_color_unit_images;
    short dflt_color_terr_images;
    short dflt_color_embl_images;
    short pref_solid_color_terrain;
    short pref_color_unit_images;
    short default_latlong_interval;

    /* Map-related slots. */
    struct a_map *maps;		/* Chain of maps that are up */

    /* Help-related slots. */
    short helpw, helph;
    struct a_helpnode *curhelpnode;
    struct a_helpnode **nodestack;
    int nodenumber, nodestackpos;

    int i_metric;
#ifdef DESIGNERS
    /* Design-related slots. */
    short curdesigntool;
    short curbrushradius;
    short curttype;
    short curbgttype;
    short curutype;
    short curusidenumber;
    short curpeoplenumber;
    short curcontrolnumber;
    short curfid;
    short curmtype;
    short curmamount;
    short curelevation;
    short curtemperature;
    short curcloudtype;
    short curcloudbottom;
    short curcloudheight;
    short curwinddir;
    short curwindforce;
    short curtview;
    short curuview;
#endif /* DESIGNERS */
    /* Arrays of image families for units, terrain, and sides. */
    ImageFamily **uimages;
    ImageFamily **timages;
    ImageFamily **eimages;
    short *eimages_loaded;
    /* Terrain drawing machinery */
    /* (should use as cache of image in image family - calc as needed) */
    Pixmap terrpics[NUMPOWERS][MAXTTYPES];
    char terrchars[NUMPOWERS][MAXTTYPES];

    Pixmap hexpics[NUMPOWERS], bhexpics[NUMPOWERS];
    Pixmap hexchars[NUMPOWERS], bhexchars[NUMPOWERS];
    /* Unit drawing machinery */
    Pixmap unitpics[NUMPOWERS][MAXUTYPES];
    Pixmap unitmasks[NUMPOWERS][MAXUTYPES];
    char unitchars[NUMPOWERS][MAXUTYPES];

    /* Emblem drawing machinery */
    Pixmap emblempics[MAXSIDES];
    Pixmap emblemmasks[MAXSIDES];
    int embw[MAXSIDES], embh[MAXSIDES];
#if 0
    /* Map legend drawing machinery */
    XFontStruct *ulegendfonts[NUMPOWERS][MAXUTYPES];
    XFontStruct *flegendfonts[6];
    Font flegendfids[6];
#endif
    Legend *legends;
    int numfeatures;
    /* Side closeup list */
    struct a_side_closeup *sidecloseuplist;
    /* Unit list */
    struct a_unit_list *unitlistlist;
    /* Unit closeup list */
    struct a_unit_closeup *unitcloseuplist;
    /* Unit closeup summary */
    struct a_closeup_summary *closeupsummary;

    StandingOrder *sorder_edit;
    char *sorder_types_edit;
    Task *sorder_task_edit;

    int *grok_p1;
    int *grok_p2;
    int grok_size;
    /* Random stuff */
    Pixmap bombpics[4];
    Pixmap hitpics[3];
    Pixmap grays[numgrays];
    Pixmap dots;
    Tk_Cursor cursors[nummodes];

    int numscheduled;
    struct a_movie movies[10];
    short told_outcome;
    struct a_map *curmap;
} UI;

typedef struct a_map {
    enum mapmode mode;
    int autoselect;
    int move_on_click;
    int see_all;
    int terrain_style;
    int unit_style;
    int colorize_units;

    short follow_action;	/* scroll to where something has occured */

    struct a_unit *curunit;	/* Unit under cursor */
    struct a_unit *savedcurunit;/* Unit under cursor (saved) */
    void (*modalhandler) PARAMS ((Side *side, struct a_map *map, int cancelled));
    char inpch;			/* Keyboard char */
    short inpsx, inpsy;
    short inpx, inpy;
    short inptype;		/* Unit type clicked in unit type list */
    Unit *inpunit;
    short prefixarg;		/* numerical prefix argument */
    short argunitid;		/* is unit id, not ptr, for safety */
    short tmpt;
    struct a_side *argside;
    short uvec[MAXUTYPES];	/* vector of allowed unit types to input */
    char ustr[MAXUTYPES+1];	/* used in composing unit type hints */
    short tvec[MAXTTYPES];	/* vector of allowed terrain types to input */
    char tstr[MAXTTYPES+1];	/* used in composing terrain type hints */
    char prompt[BUFSIZE];	/* prompt for input */
    char answer[BUFSIZE];	/* string being typed in */
    int tmpint;

    short anim_state;

    char *widget;
    char *worldw;
    struct a_map *next;
} Map;

/* Iteration over all of a side's map windows. */

#define for_all_maps(m)  \
  for ((m) = dside->ui->maps; (m) != NULL; (m) = (m)->next)

extern Tcl_Interp *interp;

extern Side *dside;

extern void redraw_map(Map *map);
extern VP *widget_vp(Map *map);


