(game-module "beirut"
  (title "Beirut 1982")
  (blurb "The heroic fighters of Beirut")
  (variants
   (see-all false)
   )
  )

; death squads shouldn't retreat
; no capturing of leader if they are win/lose condition.

(unit-type militia (image-name "soldiers")
  (help "hide and fight from building to building"))
(unit-type |death squad| (image-name "45")
  (help "used for assassinating leaders"))
(unit-type leader (image-name "man") (char "L")
  (help "an individual, one for each side"))
(unit-type |car bomb| (image-name "auto") (char "C")
  (help "destroys buildings and all else in the vicinity"))
(unit-type tank (image-name "tank") (char "T")
  (help "also destroys buildings and other things"))
(unit-type wreckage (image-name "city20-wrecked") (char "W")
  (possible-sides "independent")
  (help "a disaster, but still OK for hiding out"))
(unit-type building (image-name "city20") (char "B")
  (help "good for hiding out"))

(terrain-type sea (char "."))
(terrain-type beach (image-name "desert") (char ","))
(terrain-type street (image-name "road") (char "+"))
(terrain-type junkheap (image-name "brown") (char "^"))
(terrain-type fields (image-name "green") (char "="))
(terrain-type trees (image-name "forest") (char "%"))

(add sea liquid true)

(define m militia)
(define d |death squad|)
(define L leader)
(define C |car bomb|)
(define T tank)
(define W wreckage)
(define B building)

(define movers ( m d L C T ))
(define walkers ( m d L ))
(define vehicles ( C T ))
(define water ( sea ))
(define land ( beach street junkheap fields trees ))

;;; Static relationships.

;;; Unit-unit capacities.

(add (W B) capacity (1 2))

(table unit-size-as-occupant
  (u* u* 99)
  (walkers (W B) 1)
  )

;;; Unit-terrain capacities.

(add t* capacity 4)

(table unit-size-in-terrain
  (u* t* 1)
  ((W B) t* 4)
  )

;;; Vision.

(add u* vision-range 4)
;; Tanks have optics to see further.
(add T vision-range 8)

(table visibility
  ;; Death squads are sneaky.
  (d t* 0)
  ;; Leaders are well-known, so can't hide in crowds on the street,
  ;; but can take cover in some kinds of terrain.
  (L (junkheap trees) 0)
  )

(add u* vision-bend 0)

(table eye-height
  ;; Everybody can at least stand up to look around.
  (u* t* 2)
  ;; One can stand on top of a tank to see further.
  (T t* 4)
  ;; Buildings are multi-story, offer good viewing.
  (B t* 15)
  )

(add junkheap thickness 10)
(add trees thickness 8)

(add (W B) see-always true)

(set terrain-seen true)

;;; Actions.

;                          m d L C T
(add movers acp-per-turn ( 2 4 4 6 6 ))

;;; Movement.

(add (W B) speed 0)

(table mp-to-enter-terrain
  (u* t* 99)
  (walkers land 1)
  (vehicles ( beach street ) 1)
  ;; Tanks can go cross-country.
  (T fields 1)
  )

(table can-enter-independent
  ;; Anybody on foot can duck into buildings or wreckage.
  (walkers (W B) true)
  ;; ...but militia will always want to take and keep it.
  (m B false)
  )

;;; Combat.

;                m d L C T W  B
(add u* hp-max ( 9 1 1 1 2 1 10))

(table hit-chance
  ;        m  d  L  C  T  W  B
  (m u* ( 50 50 50 50 30  0 50 ))
  (d u* (  5 50 70 20 10  0  0 ))
  (L u* (  0 20 50 10 10  0  0 ))
  (C u* ( 20 50 90 90 10  0 10 ))
  (T u* ( 90 90 90 90 90  0 90 ))
  (W u* 0)
  (B u* ( 10 10 10 10  0  0  0 ))
  )

(table damage
  (u* u* 1)
  (u* W 0)
  (T m 2d2+1)
  (W u* 0)
  )

(add T acp-to-fire 1)

(add T range 8)

(add T fire-angle-max 10)

(table weapon-height
  (u* t* 0)
  (T t* 2)
  )

(table body-height
  (u* t* 2)
  )

(table capture-chance
  (m ( C T B ) ( 80 50 90 ))
  )

(table withdraw-chance-per-attack
  (u* m 20)
  (u* d 80)
  (u* L 95)
  (u* C 50)
  (u* T 25)
  )

(table protection
  ((W B) ( m d ) 50)
  (m B 10)
  )

(add B wrecked-type W)

;; Car bombs do their work by detonation.

(add C acp-to-detonate 1)

(add C hp-per-detonation 1)

(table detonation-unit-range
  (C u* 2)
  )

(table detonation-damage-at
  (C u* 10)
  (C W 0)
  )

(table detonation-damage-adjacent
  (C u* 8)
  (C T 1)
  (C W 0)
  )

(table detonate-on-hit
  ;       m  d  L   C   T   W   B
  (C u* (50 50 50 100 100 100 100))
  )

(table detonate-on-capture
  ;; Car bombs often have booby traps in them.
  (C u* 30)
  )

(table detonation-accident-chance
  ;; Car bombs are dangerous to handle.
  (C t* 4)
  )

;;; Random events.

(add B revolt-chance 50)

;; Buildings may surrender to nearby units, including
;; other buildings.

(table surrender-chance
  ((m L T B) B (10.00 10.00 20.00 5.00))
  )

(table surrender-range
  (u* u* 1)
  )

;;; Scoring.

(scorekeeper (do last-side-wins))

(add L point-value 25)
(add B point-value 1)

;;; Setup.

;                   m d L C T W B
(add u* start-with (6 2 1 5 2 0 5))

(table independent-density (B junkheap 9000))

(table favored-terrain
  (u* t* 0)
  (movers street 100)
  (B junkheap 100)
  )

(set country-radius-min 4)
(set country-separation-min 6)
(set country-separation-max 12)

(add street country-terrain-min 15)
(add junkheap country-terrain-min 1)

;; Don't let this go on forever.

(set last-turn 200)

(side 1 (noun "Maronite")
  )
(side 2 (plural-noun "Amal")
  )
(side 3 (name "Hezbollah")
  )
(side 4 (noun "Druze") (plural-noun "Druze")
  )
(side 5 (noun "Syrian") (emblem-name "flag-syria")
  )
(side 6 (noun "Israeli") (emblem-name "flag-israel")
  )
(side 7 (adjective "PLO")
  )

(set sides-min 7)
(set sides-max 7)

(world 100000)

(area 72 42 (cell-width 50))

(area (terrain
  (by-name
    (sea 0) (beach 1) (street 2) (junkheap 3) (fields 4)
    (trees 5))
  "72a"
  "72a"
  "72a"
  "15ab3d6b4a2bc2dc2dbd4bc2dc2dc4bc17a"
  "9abc5bc4d2c2dc2d4c2dc2dc2dc2dc2dc2dc2dc2dc16a"
  "8a2b3c3dc2d3cd6c3d6c3d16c15a"
  "7ab2dc2dc2d4cdc3dc2dc3dedc2dcd3cdc2dc2dc2dc2dcdc14a"
  "7ab2dc2d2cdc2dc2dc2dc2dc3dedc2dcdc3dc2dc2dc2dcdfc2dc13a"
  "7ab3c2dcd2c2d14ce10c2d11cd2c12a"
  "7ab2dc2dc2dc2dc2dcdc3dcf2c2df2dc2dc2dc2dc2dc2dc2dcd2cde11a"
  "7ab3d10cdc2dc2dc2dc2de2dc2dc2dc2dc2dc3dcdc2dcdfe10a"
  "8ab3c3dc3dcd5c2d7cf7cd8cdc2d4cf2e9a"
  "8ab3dc2dc3dc2dc2dc2dc2dc2dcfdcdc3dc2dcdc3d2c4dcdcd2e8a"
  "9a4dcd5c2dc2d4c2dc2dcfdc2dc2dc2dc2dc2dc2dc2dcfd4e7a"
  "9ab2cd4c2d7c2d8cd2c2dcd6cd11cefefc6a"
  "10abd2c2dc2dc2dcd2c2dc2dc2dc2dedcdcdc5dc5dc2dcfdcde2ce5a"
  "10abdcd3c2dc2dc2dc2dc2dc2dc2de2d2cdc2dc2dc2df2dc2dc2dcefcfde4a"
  "11abcdcd14c2d6cedcd11cd3cd4c2ecf3e3a"
  "11abd2cdc2dc2dcdc3dcd4c3dcdec2dc2dc2dc2dcdc2d2c2dcdecd4e2a"
  "12abdc2dcdc2dc2dc2dc5dc2dcdfc2dc2dc3dcdc2dc2dc2dc2dcf2ef2ea"
  "13ab16c4d6cf8c2d14c3efefe"
  "13adcdc2dc2dc2dcdc2dc2d2cdc3df2dc2dc2dc2dc2dc2dcdcdfdcdf2ef2e"
  "14adcdcdc2dcd2c2dc2dcdc2dc3dc2dc3dcdc2dcd2c2dc2dc2dc7e"
  "15abcd4c2dcd16ce3cdc2d3cdc2d8cd2fef2e"
  "16adcdc2dcdc3dc2dcdc3dc2dc2de2dc2dc2dc2dc2dcdc3dcdf5e"
  "17ab2c2dc2dc3dcdc2dc2dc2dc3dedc2d2cfc2dcd2c2dc2dcd3ef2e"
  "18ab13c2d4c2d10cd7cdcdcd4c5e"
  "19a3dc2dc5dc2dcdc3dc2dcdec2dc5dc2dc2dc2dc2dcfd2e"
  "20a2dc3d2c3dcd2c2dc2dc2dcdfc2dc2dc2dcd2c2dc2dc2d3cfe"
  "22ad2b2cd2cd3c3d8cf10cdcdcd7cfece"
  "25a2b3d2c2d2cdcdc3dcd2c2dc2dc2dcdc2d2c2dc2dcd2ec"
  "27a2b2dc2dcd2c2dc3dcdcedc2dc2dcdc3dc2dc2dc2def"
  "30a3cdc2d8cd2cf4c2dc2d2cd10ce"
  "31abd2c2dc2dc5dc2df2dc3dc3d2c2dc2dc2dce"
  "32abdc3dcdc5dc2dc2dc2d3c3dc2dc2dc3dc"
  "34a7c2d2cd4cf5c2d14c"
  "35a2dc2dc2dcd2cd2cdfc2dc2dc5dc2dc3dc"
  "36adc2dc2dcdcdcdc2de2dc2dc5dc2dc3dc"
  "37ab8c2d4ce14cd4c"
  "37ab2dc2dc2dc2dc2dcedc2dc2dc2dc2dc3dc"
  "38a2dc2dc2dc2dc2dc2dc2dc2dc2dc2dc3dc"
  "38a34c"
))

;;; Documentation.

(game-module (instructions (
  "Take control of the city and eliminate your rival factions."
  ""
  "Try not to destroy too much of the city in the process."
  )))

(game-module (design-notes (
  "Actually, this includes only a subset of the actual participants.
  They all fight each other here; there should actually be some alliances."
  )))

(game-module (notes (
  "Relive the heroic struggles of the heroic factions fighting for"
  "the just and righteous cause of control of Beirut."
  )))
